//------- PipeWorks                     6/9/92 Miller


//***************
//------- Pipe Textures

#declare TEX1 = texture {
color CadetBlue
ambient 0.25
diffuse 0.7
phong 1
phong_size 100
0.02
}

#declare TEX2 = texture {
gold2
}


//********************
//------- Torus Shapes

//--------Torus - outer17 inner11
#declare T_17_11 =
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -410.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        374.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -410.000000 0.000000 34969.000000 >
   }

//----- Torus outer 7 inner 5
#declare T_7_5 =
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -74.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        70.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -74.000000 0.000000 1225.000000 >
   }

//-----Torus outer8.5 inner 3.5
#declare T_3_8 =
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -84.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        59.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -84.500000 0.000000 885.062500 >
   }



//******************************************
//--------- Pipe Parts

//----- 2.5 radius Flange
#declare F1 = intersection { X_Disk scale <.7 2.5 2.5> }

//----- Small Spoke
#declare S1 = intersection { Z_Disk scale <.7 .7 6> }

//----- 1.5 radius Pipe
#declare P1 = 
object {
	intersection {
		quadric { Cylinder_X scale <1 1.5 1.5> }
		plane { <1 0 0> 0 } 
	}
			texture { TEX1			}
}


//----- 6 radius X Pipe
#declare P2 =
object {
	intersection {
		quadric { Cylinder_X scale <1 6 6> }
		plane { <1 0 0> 0 }
	}
			texture { TEX1			}
}



//----- 1.5 radius Z Pipe
#declare P3 =
object {
        intersection {
        quadric { Cylinder_Z scale <1.5 1.5 1> }
        plane { <0 0 1> 0 inverse }
        }
		texture { TEX1
		}
}


//----- 1.5 Connector
#declare CONNECTOR_1 =
object {
        union {
        intersection { X_Disk scale <4 2.5 2.5> }
        intersection { Z_Disk scale <2.5 2.5 4> }
        }
                texture { TEX1
                }
                               bounded_by {
                               sphere { <0 0 0> 7 }
                                }
}


//------ Small Elbo
#declare ELBO_1 =
object {
        intersection {
        quartic { T_3_8 }
        plane { <0 0 1> 0 }
        plane { <1 0 0> 0 inverse }
        }
                texture { TEX1
                }
                        bounded_by {
                        sphere { <4 0 -4> 10 }
                        }
}


//------ 1.5 radius Y Pipe
#declare P4 =
object {
        intersection {
        quadric { Cylinder_Y scale <1.5 1 1.5> }
        plane { <0 1 0> 0 }
        }
                texture { TEX1 
                }
}

//------ Large Collar
#declare COLLAR_1 =
object {
        union {
	       intersection { Y_Disk scale <16 10 16> translate <0 0 0> }
	       intersection { X_Disk scale <5 8 8> translate <-15 0 0> }
	       intersection {Z_Disk scale <5 5 5> translate <0 0 -15> }
	       intersection { Z_Disk scale <3 3 5> translate <0 0 -18> }
       }
                        texture { TEX1
                        }
                                bounded_by {
                                sphere { <0 0 0> 25 }
                                }
}



#declare CUTTER =
difference {
        union {
	intersection { Y_Disk scale <15 2 15> translate <0 0 0> }
	intersection { Y_Disk scale <17 1 17> translate <0 0 0> }
        }
                quadric { Cylinder_Y scale <14 1 14> }
}
            





//------ Main Fat Vertical Stack
#declare MAIN_DRAIN = 
object {
difference {
	union {
//	intersection { Y_Disk scale <15 2 15> translate <0 38 0> }
//	intersection { Y_Disk scale <17 1 17> translate <0 38 0> }

        difference { CUTTER translate <0 38 0> }

	quartic { T_17_11 translate <0 33 0> }
	intersection { Y_Disk scale <14 15 14> translate <0 15 0> }
	intersection { Y_Disk scale <15 0.5 15> translate <0 20.5 0> }
	intersection { Y_Disk scale <15 0.5 15> translate <0 16.5 0> }
	intersection { Y_Disk scale <15 0.5 15> translate <0 12.5 0> }
	}
	       intersection { Y_Disk scale <13 15 13> translate <0 15 0> }
               }

		texture { TEX1 
		}
			bounded_by {
			box { <-20 -1 -20> <20 42 20> }
			}
}


//------ Small Shut-Off
#declare SHUT_OFF_1 = 
object {
	union {
	intersection { F1 translate <9 0 0> }
	intersection { F1 translate <6 0 0> }
	intersection { F1 translate <-9 0 0> }
	intersection { F1 translate <-6 0 0> }
	intersection { X_Disk scale <9 1.6 1.6> translate <0 0 0> }
	quadric { Sphere scale <5 3.5 3.5> }
	intersection { Y_Disk scale <1 2.5 1> translate <0 5 0> }
	intersection { S1 rotate <0 0 0> translate <0 7.5 0> }
	intersection { S1 rotate <0 60 0> translate <0 7.5 0> }
	intersection { S1 rotate <0 120 0> translate <0 7.5 0> }			
	quartic { T_7_5 translate <0 7.5 0> }
	}
		texture { TEX2 
		}
			bounded_by {
			sphere { <0 0 0> 14 }
			}
}





//***********************
//---------------- ASSEMBLE PIPES


#declare PIPES  =
composite {
	object { MAIN_DRAIN translate <0 -40 0> }
	object { SHUT_OFF_1 translate <-35 -15.5 0> }
	object { SHUT_OFF_1 rotate <-90 0 0> translate <-90 -31.5 0> }
	object { SHUT_OFF_1 translate <-75 -15.5 -36> }
	object { SHUT_OFF_1 rotate <0 90 0> rotate <-90 0 0>  translate <-75 -49 -21> }
	object { P1 translate <0 -15.5 0> }
	object { P1 translate <0 -31.5 0> }
        object { P2 translate <0 -50 0> }
        object { CONNECTOR_1 translate <-55 -15.5 0> }
        object { CONNECTOR_1 translate <-55 -31.5 0> }
        object { CONNECTOR_1 translate <-75 -31.5 0> }
        object { P3 translate <-55 -15.5 -30> }
        object { P3 translate <-55 -31.5 -35> }
        object { P3 translate <-75 -31.5 -15> }
        object { COLLAR_1 translate <0 -50 0> }
        object { ELBO_1 translate <-61 -15.5 -30> }
        object { P1 translate <-61 -15.5 -36> }
        object { ELBO_1 rotate <0 0 90> translate <-55 -37.5 -35> }
        object { ELBO_1 rotate <0 0 90> translate <-75 -37.5 -15> }
        object { P4 translate <-55 -37.5 -41> }
        object { P4 translate <-75 -37.5 -21> }
        object { P4 scale <9 9 9> translate <0 -50 0>  }
}



