// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//-------------- planet 30   

#declare world30 =
union {
  //----- sky
  sphere { 0, 1 hollow on
    scale <5000, 3000, 6000>
    inverse
    hollow on
    texture {
      pigment { image_map { gif "cloud3.gif" } scale <4000, 3000, 1> translate <200, -710, 0> }
      finish { ambient 1 diffuse 0 }
    }
    texture {
      pigment { 
        gradient y
        color_map {
          [0.0 0.2 color Black color Black filter 0.75]
          [0.2 0.6 color Black filter 0.75 color DimGray filter 0.6]
          [0.6 1.0 color DimGray filter 0.6 color Gray filter 0.3]
        }
        scale <4000, 3000, 1>
        translate y*-800
      }
    }
  }
  //----------water
  box { -1, 1
    scale <2000, 0.01, 400>
    translate y*-7
    texture {
      pigment { color rgb y*0.1 }
      finish { reflection { 0.25 } phong 1 }
      normal { ripples 0.2 scale <1000, 1, 10> }
    }
    interior { ior 1.3 }
  }
}