// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//---------- lower marble wall

#declare dent1 = box { -1, 1 scale <1, 1.5, 2> }

#declare s_wall = //-------support wall
//------ top molding
union {
  object {
    union {
      box { -1, 1 scale <15.5, 2, 3.5> translate y*57 }
      box { -1, 1 scale <16, 0.5, 4> translate y*59.5 }
    }
    texture { Stone8 scale <10, 17, 20> }
  }
  //------ chair molding
  object {
    difference {  // added a difference statement for the molding
      box { -1, 1 scale <15.5, 2.5, 3.5> translate y*21.5 }
      union {
        sphere { 0, 1.5 translate <-15.5, 21.5, -3.5> }
        sphere { 0, 1.5 translate <15.5, 21.5, -3.5> }
        object { Disk_X scale <31, 1.5, 1.5> translate <-15.5, 21.5, -3.5> }
        object { Disk_Z scale <1.5, 1.5, 7> translate <-15.5, 21.5, -3.5> }
        object { Disk_Z scale <1.5, 1.5, 7> translate <15.5, 21.5, -3.5> }
      }
    }
    texture { Stone8 scale <10, 12, 10> }
    bounded_by { sphere { 0, 20 translate y*21.5 } }
  }
  //----- base molding
  object {
    union {
      box { -1, 1 scale <16, 2.5, 4> translate y*2.5 }
      box { -1, 1 scale <15.5, 3, 3.5> translate y*3 }
      box { -1, 1 scale <16.5, 2.5, 4.5> translate y*-2.5 }
    }
    texture { Stone8 scale <10, 17, 20> }
  }
  //----- bottom wall
  box { -1, 1 
    scale <15, 10, 3>
    translate y*10
    texture { Stone21 scale <20, 37, 10> rotate x*30 }
  }
  //----- upper wall
  box { -1, 1
    scale <15, 18, 3>
    translate y*40
    texture { pigment { color Black } }
    texture { T_Grnt15a scale <20, 36, 20> rotate x*90 }
    texture { T_Grnt2a scale <30, 35, 20> rotate z*50 finish { ambient 0.2 crand 0.03 } }
    texture { Crack1 scale <15, 20, 10> rotate z*-30 finish { phong 1.0 phong_size 90 } }
  }
  bounded_by { box { -1, 1 scale <18, 35, 5> translate y*31 } }
}

#declare a_wall = //----arched wall & dentiles
union {
  //------ arched wall
  object {
    difference {
      box { -1, 1 scale <35, 20, 3> translate y*80 }
      object { Cylinder_Z scale <25, 25, 1> translate y*60 }
    }
    texture { Grnt0 scale <20, 35, 50> rotate z*50 finish { ambient 0.2 crand 0.03 } }
    texture { Grnt0a scale <20, 30, 10> rotate z*-30 finish { phong 1.0 phong_size 90 } }
  }
  //------ arched molding
  object {
    union {
      difference {
        object { Disk_Z scale <26, 26, 8> translate z*-4 }
        object { Cylinder_Z scale <24, 24, 1> }
        plane { y, 0 }
      }
      difference {
        object { Disk_Z scale <26, 26, 5> translate z*-2.5 }
        object { Cylinder_Z scale <20, 20, 1> }
        plane { y, 0 }
      }
    }
    texture { Stone8 scale <10, 17, 20> }
    bounded_by { object { Disk_Z scale <30, 30, 12> translate z*-6 } }
    translate y*60
  }
  //------ keystone
  object {
    union {
      intersection {
        plane { z, 4.2 }
        plane { z, -4.2 inverse }
        plane { y, 4 }
        plane { y, -4 inverse }
        plane { x, 5 rotate z*-25 }
        plane { x, -5 rotate z*25 inverse }
      }
      intersection {
        plane { z, 5 }
        plane { z, -5 inverse }
        plane { y, 6 }
        plane { y, -5 inverse }
        plane { x, 3 rotate z*-25 }
        plane { x, -3 rotate z*25 inverse }
      }
    }
    texture { Stone8 }
    translate y*82
    scale <0.8, 1, 1>
  }
  //----- dentiles & ceiling molding
  object {
    union {
      box { -1, 1 scale <35, 4, 5> translate y*96 }
      box { -1, 1 scale <35, 2.5, 7> translate y*97.5 }
      object { dent1 translate <-20, 98.5, -9> }
      object { dent1 translate <-15, 98.5, -9> }
      object { dent1 translate <-10, 98.5, -9> }
      object { dent1 translate <-5, 98.5, -9> }
      object { dent1 translate <0, 98.5, -9> }
      object { dent1 translate <5, 98.5, -9> }
      object { dent1 translate <10, 98.5, -9> }
      object { dent1 translate <15, 98.5, -9> }
      object { dent1 translate <20, 98.5, -9> }
    }
    texture { Stone8 scale <10, 17, 20> }
    bounded_by { box { -1, 1 scale <37, 10, 12> translate y*96 } }
  }
}