// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//---------- Tile Walk & Footers


//------- footer pads
#declare footer =
object {
  union {
    object { y_tri scale <24, 1, 260> translate <-12, 0, -160> }
    object { Disk_Z scale <4, 4, 260> translate <-12, -4, -160> }
    object { Disk_Z scale <4, 4, 260> translate <12, -4, -160> }
    object { Disk_Z scale <2, 2, 260> translate <-16, -6, -160> }
    object { Disk_Z scale <2, 2, 260> translate <16, -6, -160> }
  }
  texture { Stone9 scale <10, 10, 14> finish { reflection { 0.2 } } }
  //---- add cracks
  texture { 
    pigment {
      gradient z
      color_map {
        [0.0 0.95 color Clear color Clear]
        [0.95 1.0 color Black color Black]
      }
      scale <100, 100, 20>
      translate y*-40
    }
  }
  bounded_by { box { -1, 1 scale <20, 10, 150> translate <0, -2, -30> } }
}

//------- tile walk
#declare walk =
object {
  y_tri scale <38, 1, 260>
  texture { Stone1 scale <10, 7, 15> }
  texture {
    pigment {
      checker
        color Mica filter 0.4 
        color Clear 
        scale <19, 1, 19>
        translate <-19, -0.7723, 0> 
    }
    finish { phong 1.0 reflection { 0.2 } ambient 0.2 diffuse 0.6 }
  }
}

//-------- floor Section under Rail
#declare stoop =
object {
  union {
    box { -1, 1 scale <20, 2, 14> }
    object { Disk_X scale <200, 2, 2> translate <-100, 0, -14> }
  }
  texture { Stone9 scale <10, 10, 14> finish { reflection { 0.15 } } }
}

//-------- water
#declare water =
object {
  y_tri scale <200, 1, 135>
  texture { lq }
}