// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//---------- marble column

#declare column1 =
//------ build column
//------ create cap
union {
  union {
    object { cap_s }
    object { cap_s rotate y*18 }
    object { cap_s rotate y*36 }
    object { cap_s rotate y*54 }
    object { cap_s rotate y*72 }
    object { cap_s rotate y*90 }
    object { cap_s rotate y*108 }
    object { cap_s rotate y*126 }
    object { cap_s rotate y*144 }
    object { cap_s rotate y*162 }
    object { cap_s rotate y*180 }
    object { cap_s rotate y*198 }
    object { cap_s rotate y*216 }
    object { cap_s rotate y*234 }
    object { cap_s rotate y*252 }
    object { cap_s rotate y*270 }
    object { cap_s rotate y*288 }
    object { cap_s rotate y*306 }
    object { cap_s rotate y*324 }
    object { cap_s rotate y*342 }
    object { cap_s rotate y*360 }
    bounded_by { sphere { 0, 15 translate y*5 } }
    translate y*81.5
  }

  //----- cap molding
  object {
    union {
      box { -1, 1 scale <12, 2.5, 12> translate y*97.5 }
      box { -1, 1 scale <11, 1.5, 11> translate y*93.5 }
      object { Disk_Y scale <7.5, 3, 7.5> translate y*77 }
    }
    texture { Stone8 scale <10, 17, 20>  }
    bounded_by { sphere { 0, 20 translate y*90 } }
  }

  //------ main body
  object { Disk_Y
    scale <7, 43, 7>
    translate y*34
    texture { Stone1 scale <12, 15, 12> translate y*34 }
  }

  //------ column base molding
  object {
    union {
      sphere { 0, 1 scale <8, 3, 8> translate y*33 }
      sphere { 0, 1 scale <9, 3, 9> translate y*30 }
      sphere { 0, 1 scale <11, 7, 11> translate y*24 }
      object { Disk_Y scale <8, 9, 8> translate y*24 }
      //object { Disk_Y scale <9, 6, 9> translate y*44 } // Removed, looked strange!
    }
    texture { Stone2 scale <15, 18, 10>  }
    bounded_by { sphere { 0, 17 translate y*27 } }
  }

  //----- column pedistal
  object {
    difference {  // added a difference statement for the molding
      union {
        box { -1, 1 scale <12, 2.5, 12> translate y*21.5 }
        box { -1, 1 scale <12, 2.5, 12> translate y*2.5 }
        box { -1, 1 scale <12.5, 2.5, 12.5> translate y*-2.5 } //new
        box { -1, 1 scale <11.5, 3, 11.5> translate y*3 }
      }
      union {
        sphere { 0, 1.5 translate <-12, 21.5, -12> }
        sphere { 0, 1.5 translate <12, 21.5, -12> }
        object { Disk_X scale <24, 1.5, 1.5> translate <-12, 21.5, -12> }
        object { Disk_Z scale <1.5, 1.5, 26> translate <-12, 21.5, -12> }
        object { Disk_Z scale <1.5, 1.5, 26> translate <12, 21.5, -12> }
      }
    }
    texture { Stone8 scale <10, 17, 20>  }
    bounded_by { sphere { 0, 25 translate y*14 } }
  }

  //------ main pedistal body
  object {
    difference {
      box { -1, 1 scale <11, 10, 11> translate y*10 }
      box { -1, 1 scale <9, 4.5, 2> translate <0, 12.5, -11>  }
    }
    texture { Stone21 scale <27, 35, 19> rotate x*30 }
    bounded_by { sphere { 0, 25 translate y*14 } }
  }
  bounded_by { object { Disk_Y scale <20, 105, 20> translate y*-2 } }
}