// Persistence of Vision Raytracer
//---------- marble walls & columns to test stone textures
//----------------------------------     m. miller 5/13/91

#include "colors.inc"
#include "shapes.inc"
#include "mmshape.inc"
#include "stones.inc"
#include "declares.inc"
#include "tri.inc"
#include "ceil.inc"
#include "world30.inc"
#include "floor.inc"    
#include "rail.inc"     
#include "walls.inc" 
#include "column.inc"


camera {
 location <130 80 -300> direction <0 0 1.9>
 up <0 1 0> right <1.3 0 0>
 look_at <10 33 0>
 }

//-----#declare light
#declare light = object { light_source { <0 0 0> color White } }

object { light translate <-1000 20 -400>  }
object { light translate <300 80 -1500>  }


//--------- build scene
composite {

composite { column1 translate <-35 0 -16>  }
composite { column1 translate <35 0 -16>  }
composite { column1 translate <-105 0 -16>  }
composite { column1 translate <105 0 -16>  }
composite { column1 translate <-35 0 100>  }
composite { column1 translate <35 0 100>  }

composite { s_wall translate <-35 0 0>  }
composite { s_wall translate <35 0 0>  }
composite { s_wall translate <-105 0 0>  }
composite { s_wall translate <105 0 0>  }

composite { a_wall translate <0 0 0>  }
composite { a_wall translate <70 0 0>  }
composite { a_wall translate <-70 0 0>  }
composite { a_wall translate <-140 0 0>  }
composite { a_wall translate <140 0 0>  }

composite { rail translate <-70 0 0>  }
composite { rail translate <70 0 0>  }
object { footer translate <-35 0 0 >  }
object { footer translate <35 0 0 >  }

object { walk translate <-19 -4 -160>  }

object { stoop translate <-70 -6 -14>  }
object { stoop translate <70 -6 -14>  }
object { water translate <-252 -6 -160>  }
object { water translate <53 -6 -160>  }

object { ceiling translate <-117 100 -76>  }
object { ceiling translate <-47 100 -76>  }
object { ceiling translate <23 100 -76>  }
object { ceiling translate <93 100 -76>  }

object { ceiling translate <-117 100 -118>  }
object { ceiling translate <-47 100 -118>  }
object { ceiling translate <23 100 -118>  }
object { ceiling translate <93 100 -118>  }

object { ceiling translate <-117 100 -160>  }
object { ceiling translate <-47 100 -160>  }
object { ceiling translate <23 100 -160>  }
object { ceiling translate <93 100 -160>  }

object { c1 translate <-200 100 -30>  }

object { g_ball translate <0 8 -80>  }
object { g_ball scale <1.2 1.2 1.2> translate <75 10 -70>  }

composite { world30 rotate <0 0 0>  }


 }



