//----------------------- LARGE VASE FOR PLANT
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Connector_1 =       //used to connect points with equal radii
intersection { 
  quadric { <0, 1, 1>, 0, 0, -1 }
   plane { x, 0 inverse }
   plane { x, 1 }
}

#declare Connector_2 =       //used to connect points with unequal radii
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

#declare vase =
object {
  union {
    sphere { 0, 1 scale <12, 3, 12> translate y*5 }
    sphere { 0, 11 translate y*12 }
    intersection { 
      quadric { Connector_2 }
      plane { x, 11.180340 }
      plane { x, 8.198916 inverse }
      translate x*-8.198916
      scale <1.118034, 1, 1>
      translate x*7.333333
      rotate z*90
      translate y*12
    }
    sphere { 0, 15 translate y*18 }
    intersection { 
      quadric { Connector_2 }
      plane { x, 14.161764 }
      plane { x, 11.180340 inverse }
      translate x*-11.180340
      scale <1.118034, 1, 1>
      translate x*10
      rotate z*90
      translate y*18
    }
    sphere { 0, 19 translate y*24 }
    difference { 	
      union {
        intersection { 
          quadric { Connector_2 }
          plane { x, 15.798109 }
          plane { x, 11.640712 inverse }
          translate x*-15.798109
          scale <1.496663, 1, 1>
          translate x*-10.555556
          rotate y*180
          rotate z*90
          translate y*24
        }
        sphere { 0, 14 translate y*33 }
        intersection { 
          quadric { Connector_2 }
          plane { x, 13.804186 }
          plane { x, 12.818173 inverse }
          translate x*-13.804186
          scale <5.916080, 1, 1>
          translate x*-2.333333
          rotate y*180
          rotate z*90
          translate y*33
        }
        sphere { 0, 1 scale <13, 3, 13> translate y*39 }
        intersection { 
          Connector_1
          scale <4, 13, 13>
          rotate z*90
          translate y*39
        }
        sphere { 0, 1 scale <16, 4, 16> translate y*43 }
      }
      sphere { 0, 11 translate y*43 }
    }
  }
  texture {
    pigment { image_map { gif "marb2.gif" } }
    scale <32, 43, 1>
    translate <-16, 0, -1>
    finish { phong 1.0 phong_size 50 ambient 0.4 diffuse 0.9 }
  }
  bounded_by { sphere { 0, 47.239205 translate y*22.5 } }
}