//----------- DATA FILE THAT CREATES A LEAF, A STEM, A HOUSE PLANT
//------------------------------------------------M.MILLER 1/13/91
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------------------------------THE LEAF
#declare SPONGY =
texture {
  pigment {
    gradient x
    color_map {
      [0.000 0.308 colour rgbf <0.196, 0.275, 0.047, 0> colour rgbf <0.420, 0.439, 0.227, 0>]
      [0.308 0.402 colour rgbf <0.420, 0.439, 0.227, 0> colour rgbf <0.329, 0.392, 0.184, 0>]
      [0.402 0.547 colour rgbf <0.329, 0.392, 0.184, 0> colour rgbf <0.282, 0.353, 0.149, 0>]
      [0.547 0.761 colour rgbf <0.282, 0.353, 0.149, 0> colour rgbf <0.196, 0.275, 0.208, 0>]
      [0.761 0.983 colour rgbf <0.196, 0.275, 0.208, 0> colour rgbf <0.196, 0.275, 0.047, 0>]
      [0.983 1.001 colour rgbf <0.196, 0.275, 0.047, 0> colour rgbf <0.196, 0.275, 0.047, 0>]
    }
  }
  finish { ambient 0.2 }
}
texture { 
  pigment { color rgbf <1,1,0,0.9> }
  normal { bumps 0.5 scale 0.2 }
  finish { phong 1 phong_size 20 }
}

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1}
  texture { SPONGY }
  clipped_by {
    plane {  x, 1 }
    plane { -x , 0 }
  }
}

#declare Connector_2  =
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// ------------------------ START THE LEAF -----------------
#declare LEAF_L =
   union {
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.75
         translate x*-0.45
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.745767 }
            plane { x, 0.696049 inverse }
         }
         translate <-0.745767, 0, 0>
         scale <9.372300, 1, 1>
         translate <-0.079571, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 39.536614>
         rotate <0, 97.907163, 0>
         translate <-0.450000, 0, 0>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.7
         translate <-0.5, 0.3, -0.36>
      }
      object {
         Connector_1
         scale <0.412311, 0.7, 0.7>
         rotate <0, 0, 75.963757>
         rotate <0, 90, 0>
         translate <-0.5, 0.3, -0.360000>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.7
         translate <-0.5, 0.70, -0.46>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.694439 }
            plane { x, 0.659717 inverse }
         }
         translate <-0.694439, 0, 0>
         scale <7.885663, 1, 1>
         translate <-0.088063, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 76.047264>
         rotate <0, 63.434949, 0>
         translate <-0.5, 0.7, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.665
         translate <-0.47, 0.97, -0.520000>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.652713 }
            plane { x, 0.588914 inverse }
         }
         translate <-0.652713, 0, 0>
         scale <5.129679, 1, 1>
         translate <-0.127242, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 76.270955>
         rotate <0, 29.744881, 0>
         translate <-0.47, 0.97, -0.52>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.6
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.569210 }
            plane { x, 0.474342 inverse }
         }
         translate <-0.569210, 0, 0>
         scale <3, 1, 1>
         translate <-0.189737, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 71.565051>
         translate <-0.4, 1.3, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.5
         translate <-0.3, 1.6, -0.56>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.476731 }
            plane { x, 0.381385 inverse }
         }
         translate <-0.476731, 0, 0>
         scale <3.162278, 1, 1>
         translate <-0.150756, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 64.760598>
         rotate <0,-45, 0>
         translate <-0.3, 1.6, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.4
         translate <-0.200000  1.900000 -0.460000>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.384642 }
            plane { x, 0.269250 inverse }
         }
         translate <-0.384642, 0, 0>
         scale <3.503966, 1, 1>
         translate <-0.109773, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 60.347246>
         rotate <0,-56.309932, 0>
         translate <-0.2, 1.9, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.28
         translate <-0.08, 2.28, -0.28>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.275907 }
            plane { x, 0.197076 inverse }
         }
         translate <-0.275907, 0, 0>
         scale <5.783868, 1, 1>
         translate <-0.047703, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 42.958491>
         rotate <0,-81.634114, 0>
         translate <-0.08, 2.28, -0.28>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.2
         translate <-0.03, 2.6, 0.06>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.173770 }
            plane { x, 0.086885 inverse }
         }
         translate <-0.173770, 0, 0>
         scale <1.754993, 1, 1>
         translate <-0.099015, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 81.950533>
         rotate <0, 45, 0>
         translate <-0.03, 2.6, 0.06>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.1
         translate <-0.01, 2.8, 0.04>
      }
      bounded_by { sphere { 0, 2.417294 translate <-0.45, 1.075, -0.217500> } }
   }

// ------------------LEFT----------------------------
#declare LEAF_LEFT = 
object {
  object { LEAF_L }
  bounded_by { sphere { 0, 2.417294 translate <-0.45, 1.075, -0.217500> } }
}

// ------------------------ THE RIGHT HALF OF LEAF -----------------
#declare LEAF_R =
   union {
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.75
         translate x*0.45
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.745767 }
            plane { x, 0.696049 inverse }
         }
         translate <-0.745767, 0, 0>
         scale <9.372300, 1, 1>
         translate <-0.079571, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 39.536614>
         rotate <0, 82.092837, 0>
         translate y*0.45
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.7
         translate <0.5, 0.3, -0.36>
      }
      object {
         Connector_1
         scale <0.412311, 0.7, 0.7>
         rotate <0, 0, 75.963757>
         rotate <0, 90, 0>
         translate <0.5, 0.3, -0.36>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.7
         translate <0.5, 0.7, -0.46>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.694439 }
            plane { x, 0.659717 inverse }
         }
         translate <-0.694439, 0, 0>
         scale <7.885663, 1, 1>
         translate <-0.088063, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 76.047264>
         rotate <0, 116.565051, 0>
         translate <0.5, 0.7, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.665
         translate <0.47, 0.97, -0.52>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.652713 }
            plane { x, 0.588914 inverse }
         }
         translate <-0.652713, 0, 0>
         scale <5.129679, 1, 1>
         translate <-0.127242, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 76.270955>
         rotate <0, 150.255119, 0>
         translate <0.47, 0.97, -0.52>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.6
         translate <0.4, 1.3, -0.56>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.569210 }
            plane { x, 0.474342 inverse }
         }
         translate <-0.56921, 0, 0>
         scale <3, 1, 1>
         translate <-0.189737, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 71.565051>
         rotate <0, -180, 0>
         translate <0.4, 1.3, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.5
         translate <0.3, 1.6, -0.56>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.476731 }
            plane { x, 0.381385 inverse }
         }
         translate <-0.476731, 0, 0>
         scale <3.162278, 1, 1>
         translate <-0.150756, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 64.760598>
         rotate <0, -135, 0>
         translate <0.3, 1.6, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.4
         translate <0.2, 1.9, -0.46>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.384642 }
            plane { x, 0.269250 inverse }
         }
         translate <-0.384642, 0, 0>
         scale <3.503966, 1, 1>
         translate <-0.109773, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 60.347246>
         rotate <0, -123.690068, 0>
         translate <0.2, 1.9, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.28
         translate <0.08, 2.28, -0.28>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.275907 }
            plane { x, 0.197076 inverse }
         }
         translate <-0.275907, 0, 0>
         scale <5.783868, 1, 1>
         translate <-0.047703, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 42.958491>
         rotate <0, -98.365886, 0>
         translate <0.08, 2.28, -0.28>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.2
         translate <0.03, 2.6, 0.06>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY }
         clipped_by {
            plane { x, 0.173770 }
            plane { x, 0.086885 inverse }
         }
         translate <-0.173770, 0, 0>
         scale <1.754993, 1, 1>
         translate <-0.099015, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 0, 81.950533>
         rotate <0, 135, 0>
         translate <0.03, 2.6, 0.06>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.1
         translate <0.01, 2.8, 0.04>
      }
      bounded_by { sphere { 0, 2.417294 translate <0.45, 1.075, -0.2175> } }
   }

// ---------------------RIGHT---------------------------
#declare LEAF_RIGHT = 
object {
  object { LEAF_R }
  bounded_by { sphere { 0, 2.417294 translate <0.45, 1.075, -0.2175> } }
}

// ----------------- THE STEM -------------------------------
#declare STEM =
   union {
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 2.28, -0.28>
      }
      object {
         Connector_1
         scale <0.420476, 0.14, 0.14>
         rotate <0, 0,-64.653824>
         rotate <0, 90, 0>
         translate <0, 2.28, -0.28>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 1.9, -0.46>
      }
      object {
         Connector_1
         scale <0.316228, 0.14, 0.14>
         rotate <0, 0,-71.565051>
         rotate <0, 90, 0>
         translate <0, 1.9, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 1.6, -0.56>
      }
      object {
         Connector_1
         scale <0.3, 0.14, 0.14>
         rotate <0, 0,-90>
         translate <0, 1.6, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 1.3, -0.56>
      }
      object {
         Connector_1
         scale <0.332415, 0.14, 0.14>
         rotate <0, 0,-83.088773>
         rotate <0, -90, 0>
         translate <0, 1.3, -0.56>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 0.97, -0.52>
      }
      object {
         Connector_1
         scale <0.276586, 0.14, 0.14>
         rotate <0, 0, -77.471192>
         rotate <0, -90, 0>
         translate <0, 0.97, -0.52>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 0.7, -0.46>
      }
      object {
         Connector_1
         scale <0.412311, 0.14, 0.14>
         rotate <0, 0, -75.963757>
         rotate <0, -90, 0>
         translate <0, 0.7, -0.46>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, 0.3, -0.36>
      }
      object {
         Connector_1
         scale <0.468615, 0.14, 0.14>
         rotate <0, 0, -39.805571>
         rotate <0, -90, 0>
         translate <0, 0.3, -0.36>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
      }
      object {
         Connector_1
         scale <0.951315, 0.14, 0.14>
         rotate <0, 0, -39.882685>
         rotate <0, -90, 0>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.14
         translate <0, -0.61, 0.73>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.159913 }
            plane { x, 0.139924 inverse }
         }
         translate <-0.139924, 0, 0>
         scale <30.397368, 1, 1>
         translate <0.004603, 0, 0>
         rotate <0, 0, -27.407575>
         rotate <0, -90, 0>
         translate <0, -0.61, 0.73>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.16
         translate <0, -0.89, 1.27>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.164996 }
            plane { x, 0.159996 inverse }
         }
         translate <-0.159996, 0, 0>
         scale <148.926156, 1, 1>
         translate <0.001074, 0, 0>
         rotate <0, 0, -14.782726>
         rotate <0, -90, 0>
         translate <0, -0.89, 1.27>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.165
         translate <0, -1.08, 1.990000>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.184920 }
            plane { x, 0.164929 inverse }
         }
         translate <-0.164929, 0, 0>
         scale <34, 1, 1>
         translate <0.004851, 0, 0>
         rotate <0, 0, -1.684684>
         rotate <0, -90, 0>
         translate <0, -1.08, 1.99>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.185
         translate <0, -1.1, 2.67>
      }
      object {
         Connector_1
         scale <0.565155, 0.185, 0.185>
         rotate <0, 0, 13.298570>
         rotate <0, -90, 0>
         translate <0, -1.1, 2.67>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.185
         translate <0, -0.97, 3.22>
      }
      object {
         Connector_1
         scale <0.505668, 0.185, 0.185>
         rotate <0, 0, 24.537728>
         rotate <0, -90, 0>
         translate <0, -0.97, 3.22>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.185
         translate <0, -0.76, 3.68>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.199923 }
            plane { x, 0.184929 inverse }
         }
         translate <-0.184929, 0, 0>
         scale <36.121708, 1, 1>
         translate <0.005120, 0, 0>
         rotate <0, 0, 37.504142>
         rotate <0, -90, 0>
         translate <0, -0.76, 3.68>
      }
      object {
         sphere { 0, 1 }
         texture { SPONGY }
         scale 0.2
         translate <0, -0.43, 4.11>
      }
      object {
         quadric { Connector_2 }
         texture { SPONGY } 
         clipped_by {
            plane { x, 0.249004 }
            plane { x, 0.199204 inverse }
         }
         translate <-0.199204, 0, 0>
         scale <11.171392, 1, 1>
         translate <0.017832, 0, 0>
         rotate <0, 0, 50.063617>
         rotate <0, -90, 0>
         translate <0, -0.43, 4.11>
      }
      object {
         sphere { 0, 1 } 
         texture { SPONGY }
         scale 0.25
         translate z*4.47
      }
      bounded_by { sphere { 0, 3.621382 translate <0, 0.5675, 2.01> } }
   }

// ---------------------- PUT BOTH HALFS TOGETHER -----------------------
#declare THE_LEAF =
union {
  object { LEAF_RIGHT }
  object { LEAF_LEFT }
}


#declare LEAF_N_STEM =
union {
  object { THE_LEAF scale <1, 1, 0.5> translate y*0.5 }
  object { STEM scale <0.8, 1, 1> rotate 0 }
  translate z*-4.47
  rotate z*180
  rotate x*40
}

#declare PLANT1 =
union {
  union { LEAF_N_STEM rotate 0 translate 0 } 
  union { LEAF_N_STEM rotate y*90 translate 0 }
  union { LEAF_N_STEM rotate y*180 translate -y } 
  union { LEAF_N_STEM rotate y*270 translate 0 } 

  union { LEAF_N_STEM rotate y*60 translate y*2 }
  union { LEAF_N_STEM rotate y*150 translate y*1.5 } 
  union { LEAF_N_STEM rotate y*240 translate y*2 }
  union { LEAF_N_STEM rotate y*330 translate y*2 } 
 
  union { LEAF_N_STEM rotate y*20 translate y*4 }
  union { LEAF_N_STEM rotate y*110 translate y*3 }
  union { LEAF_N_STEM rotate y*200 translate y*4 }
  union { LEAF_N_STEM rotate y*290 translate y*3.5 } 

  union { LEAF_N_STEM rotate y*100 translate y*5 } 
  union { LEAF_N_STEM rotate y*200 translate y*6 } 
  union { LEAF_N_STEM rotate y*260 translate y*6 }
  union { LEAF_N_STEM rotate y*10 translate y*5.5 } 

  union { LEAF_N_STEM rotate y*40 translate y*8 }
  union { LEAF_N_STEM rotate y*130 translate y*7 }
  union { LEAF_N_STEM rotate y*230 translate y*8 } 
  union { LEAF_N_STEM rotate y*310 translate y*7.5 } 

  union { LEAF_N_STEM rotate y*110 translate y*9 }
  union { LEAF_N_STEM rotate y*190 translate y*10 }
  union { LEAF_N_STEM rotate y*280 translate y*10 } 
  union { LEAF_N_STEM rotate 0 translate y*-9.5 } 

  union { LEAF_N_STEM rotate y*82 translate y*12 }
  union { LEAF_N_STEM rotate y*170 translate y*11 }
  union { LEAF_N_STEM rotate y*250 translate y*12 } 
  union { LEAF_N_STEM rotate y*350 translate y*11.5 } 

  bounded_by { object { Disk_Y scale <10, 25, 10> translate y*-2 } }
}

//object { PLANT1 }