//--------------------  THE PARLOR ------------------------
//-------------------------------------------MILLER 1/25/91
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "Fly2.INC"
#include "Vase.INC"
#include "Plant.INC"
#include "World.INC"
   
global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

camera {
  location <-25, 40, -550>
  direction z*1.6
  up y
  right x*image_width/image_height
  look_at <-25, 40, 0> 
}

// --------- CONTROLS SHADOW THROUGH DOOR -----------
light_source { <-50, 300, 300> color White } 
light_source { <100, 215, -50> color White }
light_source { <-1500, 115, -1560> color White }
light_source { <400, 5, -650> color White }

// ------------- DECLARED COLORS --------------------------
#declare TRIM_PAINT = texture { pigment { color Gray } finish { ambient 0.3 diffuse 1 phong 1 } }
#declare WALL_PAINT = texture { pigment { color rgb <0.78, 0.71, 0.71> } finish { crand 0.03 ambient 0.2 phong 0.2 } }
#declare PAPER = texture { pigment { color LightBlue } finish { phong  0.2 } }
#declare DOOR_PAINT = texture { pigment { color Gray } finish { ambient 0.1 diffuse 0.6 phong 1 } }

// --------------- START FRENCH DOOR ------------------------------
#declare SPOKE = box { -1, 1 scale <18, 1, 2> }

#declare TOP_ARCH =
union {
  difference {
    object { Disk_Z scale <40, 40, 8> translate <0, 136, -4> }
    object { Cylinder_Z scale <34, 34, 1> translate y*136 }
    plane { y, 136 }
  }
  difference {
    object { Disk_Z scale <6, 6, 8> translate <0, 136, -4> }
    plane { y, 136 }
  }
  object { SPOKE translate x*18 rotate z*45 translate y*136 }
  object { SPOKE translate x*18 rotate z*90 translate y*136 }
  object { SPOKE translate x*18 rotate z*135 translate y*136 }
  bounded_by { box { -1, 1 scale <41, 21, 5> translate y*156 } }
  texture { DOOR_PAINT }
}

// ----------- DOOR PANELS-------------------------------
#declare F_DOOR =
object {
  union {
    difference {
      box { -1, 1 scale <40, 68, 4> translate y*68 }
      box { -1, 1 scale <34, 60, 5> translate y*70 }
    }
    box { -1, 1 scale <35, 1, 2> translate y*100 }
    box { -1, 1 scale <35, 1, 2> translate y*70 }
    box { -1, 1 scale <35, 1, 2> translate y*40 }
    box { -1, 1 scale <1, 61, 2> translate <-18.5, 70, 0> }
    box { -1, 1 scale <1, 61, 2> translate <18.5, 70, 0> }
    box { -1, 1 scale <3, 61, 2> translate y*70 }
  }
  bounded_by { box { -1, 1 scale <41, 70, 5> translate y*69 } }
  texture { DOOR_PAINT }
}

// ----------------- WALL PANEL FRAME -------------------
#declare FRAME =
union {
  difference {
    union {
      object { Cylinder_X translate y*12 }
      object { Cylinder_X translate y*-12 }
    }
    plane { x, 9 inverse }
    plane { x, -9 }
  }
  difference {
    union {
      object { Cylinder_Y translate x*9 }
      object { Cylinder_Y translate x*-9 }
    }
    plane { y, 12 inverse }
    plane { y, -12 }
  }
  sphere { 0, 1 translate <9, 12, 0> }
  sphere { 0, 1 translate <9, -12, 0> }
  sphere { 0, 1 translate <-9, 12, 0> }
  sphere { 0, 1 translate <-9, -12, 0> }
  // box { -1, 1 scale <6.5, 9.5, 1> }
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <11, 15, 2> } }
}

// ---------- BOTTOM POST MOLDING -----------------
#declare B_POST =
union {
  box { -1, 1 scale <8, 5, 8> translate y*5 }
  box { -1, 1 scale <7, 1, 7> translate y*11 }
  box { -1, 1 scale <6, 1, 6> translate y*13 }
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <9, 8, 9> translate y*7 } }
}

// ---------- TOP POST MOLDING -----------------
#declare T_POST =
union {
  box { -1, 1 scale <6.5, 1, 6.5> translate y }
  box { -1, 1 scale <5.5, 1, 5.5> translate y*3 }
  box { -1, 1 scale <5, 1, 5> translate y*5 }
  box { -1, 1 scale <6, 1, 6> translate y*7 }
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <7, 5, 7> translate y*4 } }
}

// -------------- LOWER POST ---------------------------
#declare L_POST =
box { -1, 1 scale <5.5, 18, 5.5> texture { TRIM_PAINT } }

// -------------- LOWER POST ---------------------------
#declare U_POST =
box { -1, 1 scale <4, 37, 4> texture { TRIM_PAINT } }

// -------------- ARCHED MOLDING ----------------------
#declare A_MOLD = 
difference {
  object { Disk_Z scale <48, 48, 8> }
  object { Cylinder_Z scale <40, 40, 1> }
  plane { y, 0 }
  translate z*-4
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <49, 25, 5> translate y*24 } }
}

// ----------  DISTANT CHAIR MOLDING--------------------------
#declare C_MOLD =
union {
  box { -1, 1 scale <50, 1, 6> translate y }
  box { -1, 1 scale <48.2, 1, 4.1> translate y*3 }
  box { -1, 1 scale <50, 1, 6> translate y*5 }
  texture { TRIM_PAINT } 
  bounded_by { box { -1, 1 scale <51, 4, 7> translate y*3 } }
}

// -------------------- CLOSE-UP CHAIR MOLDING--------------------
#declare C_M =
union {
  box { -1, 1 scale <55, 3, 0.25> translate z*-0.25 }
  box { -1, 1 scale <55, 2.5, 0.25> translate z*-0.75 }
  object { Cylinder_X scale <110, 1, 1> translate <-55, 1, -0.75> }
  object { Cylinder_X scale <110, 1, 1> translate <-55, -1, -0.5> }
}

#declare CHAIR_MOLD =
union {
  difference {
    object { C_M translate z*-4 }
    plane { x, 0 rotate y*-45 translate <50, 0, -4> inverse }
  }
  difference {
    object { C_M rotate y*-90 translate x*50 }
    plane { x, 0 rotate y*-45 translate <50, 0, -4> }
    plane { x, 0 rotate y*45 translate <50, 0, 4> }
  }
  difference {
    object { C_M rotate y*180 translate z*4 }
    plane { x, 0 rotate y*45 translate <50, 0, 4> inverse }
  }
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <65, 12, 14> translate y*6 } }
  scale <1, 1.1, 1>
}

// ---------- WALL BASE --------------------------------------------
#declare W_BASE = 
union {
  box { -1 ,1 scale <51, 5, 7> translate y*5 }
  box { -1, 1 scale <50, 1, 5> translate y*11 }
  box { -1, 1 scale <49, 1, 5> translate y*13 }
  texture { TRIM_PAINT }
  bounded_by { box { -1, 1 scale <52, 8, 8> translate y*7 } }
}

// ---------- LOWER WALL ---------------------------------------
#declare L_WALL = 
box { -1, 1 scale <48, 20, 4> translate y*5 texture { WALL_PAINT finish { ambient 0.2 diffuse 0.4 } } }

// ---------- MIDDLE WALLPAPERED WALL---------------------------
#declare P_WALL = 
box { -1, 1
  scale <48, 50, 4>
  texture {
    pigment { image_map { gif "wall3.gif" } }
    finish { ambient 0.2 diffuse 0.3 phong 0.2 phong_size 10 }
    scale <30, 63, 4>
    translate <-48, -50, -4>
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.5 color Clear color Clear]
        [0.5 1.01 color Clear color Black]
      }
      scale <100, 63, 5>
      translate y*-50
    }
  }
}

// ---------- FRONT WALLPAPERED WALL---------------------------
#declare F_WALL = 
box { -1, 1
  scale <48, 50, 4>
  texture {
    pigment { image_map { gif "wall3.gif" } }
    finish { ambient 0.4 diffuse 0.6 phong 0.2 phong_size 10 }
    scale <15, 30, 1>
    translate <-48, -50, -4>
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.5 color Clear color Clear]
        [0.5 1.01 color Clear color Black]
      }
    scale <100, 29, 5>
    translate y*-25
    }
    //finish { ambient 0.2 diffuse 0.5 }
  }
}

// ----------- BUILD THE ROOM-----------------------------
union {
  object { F_DOOR }
  object { TOP_ARCH }
  union {
    object { B_POST translate <44, 0, -7.9> }
    object { L_POST translate <44, 31, -7.9> }
    object { T_POST translate <44, 48, -7.9> }
    bounded_by { box { -1, 1 scale <9, 30, 9> translate <44, 28, -7.9> } }
  }
  union {
    object { B_POST translate <-44, 0, -7.9> }
    object { L_POST translate <-44, 31, -7.9> }
    object { T_POST translate <-44, 48, -7.9> }
    bounded_by { box { -1, 1 scale <9, 30, 9> translate <-44, 28, -7.9> } }
  }
  object { U_POST translate <44, 92, -7.9> }
  object { U_POST translate <-44, 92, -7.9> }
  object { T_POST rotate z*180 translate <44, 136, -7.9> }
  object { T_POST rotate z*180 translate <-44, 136, -7.9> }
  object { A_MOLD translate <0, 136, -7.9> }
  bounded_by { box { -1, 1 scale <53, 105, 20> translate <0, 104, -3> } }
}

// ------------------ UPPER WALL AROUND FRENCH DOOR --------------------
difference {
  box { -1, 1 scale <140, 85, 4> }
  box { -1, 1 scale <40, 50, 5> translate y*-39 }
  object { Cylinder_Z scale <40, 40, 1> }
  texture { WALL_PAINT finish { ambient 0.1 diffuse 0.6 phong 0 } }
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 1.0 color Clear color Black]
      }
      scale <300, 170, 5>
      translate y*-85
    }
  }
  bounded_by { box { -1, 1 scale <141, 86, 5> } }
  translate y*137
}

// --------------- LOWER RIGHT WALL SECTIONS ---------------------------
union {
  object { W_BASE translate x*94 }
  object { L_WALL texture { WALL_PAINT finish { ambient 0.1 diffuse 0.6 } } translate <94, 28, 0> }
  object { C_MOLD translate <94, 50, 0> }
  object { FRAME translate <64, 32, -4> }
  object { FRAME translate <94, 32, -4> }
  bounded_by { box { -1, 1 scale <60, 30, 10> translate <94, 29, 0> } }
}

// --------------- LOWER LEFT WALL SECTIONS ---------------------------
union {
  object { W_BASE translate x*-94 }
  object { L_WALL texture { WALL_PAINT finish { ambient 0.1 } } translate <-94, 28, 0> }
  object { C_MOLD translate <-94, 50, 0> }
  object { FRAME translate <-64, 32, -4> }
  object { FRAME translate <-94, 32, -4> }
  bounded_by { box { -1, 1 scale <60, 30, 10> translate <-94, 29, 0> } }
}

// --------------- MIDDLE WALL SECTIONS ---------------------------
union {
  object { W_BASE translate <70, 0, -300> }
  object { L_WALL translate <70, 28, -300> }
  object { CHAIR_MOLD rotate y*180 translate <71, 53, -300> }
  object { FRAME translate <40, 32, -304> }
  object { FRAME translate <70, 32, -304> }
  bounded_by { box { -1, 1 scale <40, 30, 10> translate <70, 29, -300> } }
}

// --------- PAPER WALL OF MIDDLE SECTION ------------------------
object { P_WALL translate <70, 105, -300> }

// ----------- PLACE VASE ----------------------
object { vase scale 0.8 translate <35, -4, -330> }

// --------------PLACE PLANT ------------------------------------
object { PLANT1 scale 4 translate <35, 28, -330> }

// --------------- FRONT WALL SECTIONS ---------------------------
union {
  object { L_WALL translate <-80, 8, -500> }
  object { CHAIR_MOLD translate <-82, 34, -500> }
  bounded_by { box { -1, 1 scale <60, 30, 10> translate <-80, 9, -500> } }
}

object { F_WALL rotate y*180 translate <-80, 87, -500> }

//----------------- GLUE FLY TO WALL -------------------
object { FLY rotate x*180 scale 0.035 rotate z*-60 translate <-37, 45, -504> }

object { TheWorld hollow rotate x*50}

// ----------------- CEILING ----------------------
object { 
  difference {
    plane { y, 220 inverse }
    plane { z, 0 inverse }
  }
  pigment { color Green }
}

// ------------  FLOOR -----------------------
plane { y, 0 inverse
  texture {
    pigment { color DimGray }
    finish { reflection 0.15 ambient 0.2 }
  }
}