//--------------- FLY BODY colorS
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare SILVER = pigment { colour rgb <0.90, 0.91, 0.98> }

#declare BUG_color1 =
texture {
  pigment {
    gradient x
    color_map {
      [0.000 0.370 colour rgbf <0.000, 0.000, 0.000, 0.000> colour rgbf <0.024, 0.004, 0.294, 0.000>]
      [0.370 0.773 colour rgbf <0.024, 0.004, 0.294, 0.000> colour rgbf <0.302, 0.004, 0.420, 0.000>]
      [0.773 0.992 colour rgbf <0.302, 0.004, 0.420, 0.000> colour rgbf <0.000, 0.000, 0.000, 0.000>]
      [0.992 1.001 colour rgbf <0.000, 0.000, 0.000, 0.000> colour rgbf <0.000, 0.000, 0.000, 0.000>]
    }
  }
  finish { ambient 0.3 }
}

#declare BUG_color2 =
texture {
  pigment {
    marble
    turbulence 0.2
    color_map {
      [0.000 0.017 colour rgbf <0.000, 0.000, 0.000, 1.000> colour rgbf <0.835, 0.992, 0.071, 0.325>]
      [0.017 0.136 colour rgbf <0.835, 0.992, 0.071, 0.325> colour rgbf <0.000, 0.722, 0.122, 0.667>]
      [0.136 0.356 colour rgbf <0.000, 0.722, 0.122, 0.667> colour rgbf <0.000, 0.000, 0.000, 1.000>]
      [0.356 0.924 colour rgbf <0.000, 0.000, 0.000, 1.000> colour rgbf <0.000, 0.000, 0.000, 0.996>]
      [0.924 1.001 colour rgbf <0.000, 0.000, 0.000, 0.996> colour rgbf <0.000, 0.000, 0.000, 1.000>]
    }
  }
  finish { phong 1.0 ambient 0.2 }
}

#declare BUG_color3 =
texture {
  pigment {
    gradient y
    color_map {
      [0.000 0.364 colour rgbf <0.106, 0.067, 0.157, 0.000> colour rgbf <0.384, 0.200, 0.200, 0.000>]
      [0.364 0.492 colour rgbf <0.384, 0.200, 0.200, 0.000> colour rgbf <0.333, 0.333, 0.000, 0.000>]
      [0.492 0.585 colour rgbf <0.333, 0.333, 0.000, 0.000> colour rgbf <0.384, 0.200, 0.200, 0.000>]
      [0.585 0.983 colour rgbf <0.384, 0.200, 0.200, 0.000> colour rgbf <0.157, 0.094, 0.227, 0.000>]
      [0.983 1.001 colour rgbf <0.157, 0.094, 0.227, 0.000> colour rgbf <0.106, 0.067, 0.157, 0.000>]
    }
  }
}

#declare BUG_color4 =
texture {
  pigment {
    gradient x
    color_map {
      [0.000 0.153 colour rgbf <0.000, 0.000, 0.000, 0.000> colour rgbf <0.333, 0.333, 0.000, 0.651>]
      [0.153 0.432 colour rgbf <0.333, 0.333, 0.000, 0.651> colour rgbf <0.667, 0.667, 0.000, 1.000>]
      [0.432 0.814 colour rgbf <0.667, 0.667, 0.000, 1.000> colour rgbf <0.333, 0.333, 0.000, 0.992>]
      [0.814 0.983 colour rgbf <0.333, 0.333, 0.000, 0.992> colour rgbf <0.000, 0.000, 0.000, 0.000>]
      [0.983 1.001 colour rgbf <0.000, 0.000, 0.000, 0.000> colour rgbf <0.000, 0.000, 0.000, 0.000>]
    }
  }
}

#declare YourTexture =
texture { BUG_color3 scale <30, 40, 30> }
texture { BUG_color4 scale <20, 30, 30> }
texture { 
  pigment { color Black filter 0.30 }
  finish { phong 1.0 phong_size 20 }
  normal { bumps 0.3 frequency 30 scale 0.3 }
}

#declare A_Texture =
texture { BUG_color3 scale <10, 20, 30>  }
texture { BUG_color4 scale <10, 20, 10> }
texture {
  pigment { color Black filter 0.65 }
  finish { phong 1.0 phong_size 20 }
}

// --------------------- FLY LEGS ---------------------------

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1}
  clipped_by {
    plane { x, 1 }
    plane { -x , 0 }
  }
}

#declare Connector_2  =
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

// -------------BACK SET OF LEGS--------------------
#declare leg1 =
   union {
      object {
         sphere { 0, 6 translate <21, -13, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999641 }
            plane { x, 5.499671 inverse }
         }
         translate <-5.999641, 0, 0>
         scale     <91.405689, 1, 1>
         translate <-0.065638, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -46.220888>
         rotate    <0, -18.434949,  0>
         translate <21, -13, 49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <51, -46,  59> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <72.979449, 5.5, 5.5,>
         rotate    <0, 0, -2.355948>
         rotate    <0, 42.220833, 0>
         translate <51, -46 ,59>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <105, -49,  10> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.496631 }
            plane { x, 3.997550 inverse }
         }
         translate <-5.496631, 0, 0>
         scale     <28.555988, 1, 1>
         translate <-0.192486, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -34.053001>
         rotate    <0, 9.727579, 0>
         translate <105, -49, 10>
         texture { YourTexture }
      }
      object {
         sphere { 0, 4 translate <140, -73,  4> }
         texture { YourTexture }
      }
      bounded_by { sphere { 0, 88.173852 translate <79.5, -42, 32.25> } }
   }

// --------------------------------------------------------------
#declare leg2 =
union {
      object {
         sphere { 0, 6 translate <12, -19, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999713 }
            plane { x, 5.499737 inverse }
         }
         translate <-5.999713, 0, 0>
         scale     <102.171425, 1, 1>
         translate <-0.058722, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -59.457937>
         rotate    <0, -105.642246, 0>
         translate <12, -19, 49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <5, -63, 74> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <79.429214, 5.5, 5.5>
         rotate    <0, 0, -5.780553>
         rotate    <0, 128.320114, 0>
         translate <5, -63, 74>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-44, -71, 12> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.497169 }
            plane { x, 3.997941 inverse }
         }
         translate <-5.497169, 0, 0>
         scale     <31.153741, 1, 1>
         translate <-0.176453, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -26.689348>
         rotate    <0, 168.95906, 0>
         translate <-44, -71, 12>
         texture { YourTexture }
      }
      object {
         sphere{ 0, 4 translate <-85, -92, 4> }
         texture { YourTexture }
      }
      bounded_by { sphere{ 0, 90.349533 translate <-35.5, -48, 39.75> } }
   }

// ----------------------------------------------------------
#declare leg3 =
union {
     object {
         sphere { 0, 6 translate <-12, -12, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999833 }
            plane { x, 5.499847 inverse }
         }
         translate <-5.999833, 0, 0>
         scale     <133.951484, 1, 1>
         translate <-0.044791, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -35.611359>
         rotate    <0, -134.255941, 0>
         translate <-12, -12,  49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-50, -51, 88> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <94.308006, 5.5, 5.5>
         rotate    <0, 0, -7.923234>
         rotate    <0, 127.605991, 0>
         translate <-50, -51, 88>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-107, -64, 14> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.498578 }
            plane { x, 3.998966 inverse }
         }
         translate <-5.498578, 0, 0>
         scale     <43.973477, 1, 1>
         translate <-0.125043, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, -35.166605>
         rotate    <0, 169.315088, 0>
         translate <-107, -64, 14>
         texture { YourTexture }
      }
      object {
         sphere { 0, 4 translate <-160, -102, 4> }
         texture { YourTexture }
      }
      bounded_by { sphere { 0, 119.077540 translate <-82, -53, 46.75> } }
}

#declare leg =
union {
  object { leg1 }
  object { leg2 }
  object { leg3 }
  bounded_by { sphere { 0, 186.386106 translate <-10, -53, 46.750000> } }
}

// --------------------------- FRONT LEGS----------------------------------
#declare leg21 =
   union {
      object {
         sphere { 0, 6 translate <21, 13, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999641 }
            plane { x, 5.499671 inverse }
         }
         translate <-5.999641, 0, 0>
         scale     <91.405689, 1,  1>
         translate <-0.065638, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 46.220888>
         rotate    <0, -18.434949, 0>
         translate <21, 13, 49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <51, 46, 59> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <72.979449, 5.5, 5.5>
         rotate    <0, 0, 2.355948>
         rotate    <0, 42.220833, 0>
         translate <51, 46, 59>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <105, 49, 10> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.496631 }
            plane { x, 3.997550 inverse }
         }
         translate <-5.496631, 0, 0>
         scale     <28.555988, 1, 1>
         translate <-0.192486, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 34.053001>
         rotate    <0, 9.727579, 0>
         translate <105, 49, 10>
         texture { YourTexture }
      }
      object {
         sphere { 0, 4 translate <140, 73, 4> }
         texture { YourTexture }
      }
      bounded_by { sphere { 0, 88.173852 translate <79.5, 42, 32.25> } }
   }

// --------------------------------------------------------------
#declare leg22 =
union {
      object {
         sphere { 0, 6 translate <12, 19, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999713 }
            plane { x, 5.499737 inverse }
         }
         translate <-5.999713, 0, 0>
         scale     <102.171425, 1, 1>
         translate <-0.058722, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 59.457937>
         rotate    <0, -105.642246, 0>
         translate <12, 19, 49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <5, 63, 74> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <79.429214, 5.5, 5.5>
         rotate    <0, 0, 5.780553>
         rotate    <0, 128.320114, 0>
         translate <5, 63, 74>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-44, 71, 12> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.497169 }
            plane { x, 3.997941 inverse }
         }
         translate <-5.497169, 0, 0>
         scale     <31.153741, 1, 1>
         translate <-0.176453, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 26.689348>
         rotate    <0, 168.959060, 0>
         translate <-44, 71, 12>
         texture { YourTexture }
      }
      object {
         sphere { 0, 4 translate <-85, 92, 4> }
         texture { YourTexture }
      }
      bounded_by {  sphere { 0, 90.349533 translate <-35.5, 48, 39.75> } }
   }

// ------------------------------------------------------------------
#declare leg23 =
   union {
      object {
         sphere { 0, 6 translate <-12, 12, 49> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.999833 }
            plane { x, 5.499847 inverse }
         }
         translate <-5.999833, 0, 0>
         scale     <133.951484, 1, 1>
         translate <-0.044791, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 35.611359>
         rotate    <0, -134.255941, 0>
         translate <-12, 12, 49>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-50, 51, 88> }
         texture { YourTexture }
      }
      object {
         Connector_1
         scale     <94.308006, 5.5, 5.5>
         rotate    <0, 0, 7.923234>
         rotate    <0, 127.605991, 0>
         translate <-50, 51, 88>
         texture { YourTexture }
      }
      object {
         sphere { 0, 5.5 translate <-107, 64, 14> }
         texture { YourTexture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 5.498578 }
            plane { x, 3.998966 inverse }
         }
         translate <-5.498578, 0, 0>
         scale     <43.973477, 1, 1>
         translate <-0.125043, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 35.166605>
         rotate    <0, 169.315088, 0>
         translate <-107, 64, 14>
         texture { YourTexture }
      }
      object {
         sphere { 0, 4 translate <-160, 102, 4> }
         texture { YourTexture }
      }
      bounded_by {  sphere { 0, 119.077540 translate <-82, 53, 46.75> } }
   }

#declare leg2 = 
union {
  object { leg21 }
  object { leg22 }
  object { leg23 }
  bounded_by { sphere { 0, 186.386106 translate <-10, 53, 46.75> } }
}

// --------------- FLY ANTLERS-------------------------
#declare antler1 =
   union {
      object {
         sphere { 0, 2.5 translate <108, -13, 68> }
         texture { A_Texture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 4.981734 }
            plane { x, 2.490867 inverse }
         }
         translate <-2.490867, 0, 0>
         scale     <11.667048, 1, 1>
         translate <0.213496, 0, 0>
         rotate    <0, 0, 15.859230>
         rotate    <0, 173.884496, 0>
         translate <108, -13, 68>
         texture { A_Texture }
      }
      object {
         sphere { 0, 5 translate <80, -5, 65> }
         texture { A_Texture }
      }
      object {
         quadric { Connector_2  }
         clipped_by {
            plane { x, 10.337952 }
            plane { x, 4.135181 inverse }
         }
         translate <-4.135181, 0, 0>
         scale     <1.471205, 1, 1>
         translate <2.810744, 0, 0>
         rotate    <0, 0, 22.009841>
         rotate    <0, -165.963757, 0>
         translate <80, -5,  65>
         texture { A_Texture }
      }
      object {
         sphere { 0, 12.5 translate <68, 0, 68> }
         texture { A_Texture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 10.337952 }
            plane { x, 4.135181 inverse }
         }
         translate <-10.337952, 0, 0>
         scale     <1.471205, 1, 1>
         translate <-7.02686, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 22.009841>
         rotate    <0, 14.036243, 0>
         translate <68, 0, 68>
         texture { A_Texture }
      }
      object {
         sphere { 0, 5 translate <80, 5, 65> }
         texture { A_Texture }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 4.981734 }
            plane { x, 2.490867 inverse }
         }
         translate <-4.981734, 0, 0>
         scale     <11.667048, 1, 1>
         translate <-0.426992, 0, 0>
         rotate    <0, 180, 0>
         rotate    <0, 0, 15.859230>
         rotate    <0  -6.115504, 0>
         translate <80, 5, 65>
         texture { A_Texture }
      }
      object {
         sphere { 0, 2.5 translate <108, 13, 68> }
         texture { A_Texture }
      }
      bounded_by {  sphere { 0, 37.347389 translate <83, 0, 68> } }
   }

#declare antler = 
union {
  object { antler1 }
  bounded_by { sphere { 0, 37.347389 translate <83, 0, 68> } }
}

// -------------------FLY PARTS ------------------------------
#declare ABDOMEN =
object {
  union {
    sphere { 0, 1 scale <25, 35, 27.5> translate <-64, 0, 66> }
    sphere { 0, 1 scale <27.5, 32, 27.5> translate <-77, 0, 63> }
    sphere { 0, 1 scale <23.5, 30, 25> translate <-96, 0, 58> }
    sphere { 0, 1 scale <20, 25, 20> translate <-115, 0, 53> }
    sphere { 0, 1 scale <18, 20, 18> translate <-127, 0, 48> }
    sphere { 0, 1 scale <15, 15, 12.5> translate <-140, 0, 40> }
  }
  texture { BUG_color3 scale <30, 40, 30>  }
  texture { BUG_color4 scale <20, 30, 30> }
  texture { 
    pigment { color Black filter 0.65 }
    finish { phong 1.0 phong_size 20 }
    normal { bumps 0.3 frequency 30 scale 0.3 }
  }
  bounded_by { sphere { <-95, 0, 60>, 65 } }
}

#declare THORAX =
object {
  union {
    sphere { 0, 1 scale <17.5, 10, 10> translate <38, 0, 55> }
    sphere { 0, 1 scale <17.5, 25, 15> translate <11, 0, 55> }
    sphere { 0, 1 scale <22.5, 25, 15> translate <0, 0, 55> }
    sphere { 0, 1 scale <12.5, 20, 12.5> translate <-17, 0, 55> }
    sphere { 0, 1 scale <12.5, 15, 10> translate <-22, 0, 55> }
    sphere { 0, 1 scale <17.5, 9, 7> translate <-38, 0, 55> }
  }
  texture { 
    pigment { color Black }
    normal { bumps 0.5 }
    finish { phong 1.0 }
  }
  bounded_by { sphere { 0, 50 translate <8, 0, 50> } }
}

// ------------------------- FLY HEAD --------------------------------
#declare HEAD =
object {
  union {
    sphere { 0, 1 scale <20, 22, 23.5> translate <65, 0, 62> }
    sphere { 0, 1 scale <15, 15, 12.5> translate <65, 15, 73> }
    sphere { 0, 1 scale <15, 15, 12.5> translate <65, -15, 73> }
    sphere { 0, 1 scale <12.5, 12.5, 12.5> translate <62, 0, 43> }
    //----------- MOUTH PARTS
    sphere { 0, 1 scale <11, 12, 8> translate <63, 0, 34> }
    sphere { 0, 1 scale <7.5, 9, 4> translate <68, 0, 27> }
    sphere { 0, 1 scale <4.5, 6, 2.5> translate <76, 0, 25> }
    sphere { 0, 1 scale <3.5, 4, 2> translate <81, 0, 26> }
    //------------BRIDGE
    sphere { 0, 1 scale <4, 8, 5> translate <82, 0, 46> }
    sphere { 0, 1 scale <2.5, 5, 3> translate <80, 0, 40> }
  }
  texture { BUG_color3 scale <30, 40, 30> }
  texture { BUG_color4 scale <50, 30, 30> }
  texture {
    pigment { color Black filter 0.55 }
    finish { phong 1.0 phong_size 20 }
    normal { bumps 0.3 frequency 30 scale 0.3 }
  }
  bounded_by { sphere { <65, 0, 58>, 41 } }
}

// ------------------------ FLY WING -------------------------------------

#declare WING1 =
object {
  union {
    difference {
      sphere { 0, 1 scale <40, 80, 0.01> rotate z*-68 translate <-93, -56, 0> }
      sphere { 0, 1 scale <15, 30, 0.01> rotate z*-50 translate <-20, -31, 0> }
    }
    sphere { 0, 1 scale <15, 30, 0.01> rotate z*-50 translate <-20, -31, 0> }
  }
  //texture { pigment { color MediumGoldenrod filter 0.6 } }
  texture { 
    material_map {
      gif "wing.gif"
      texture { pigment { color Gray filter 0.57 } }
      texture { pigment { color Clear } }
      texture { 
        pigment {
          gradient x
          color_map { 
            [0.0 0.6 color White filter 0.60 color MediumGoldenrod filter 0.55 ]
            [0.6 1.01 color MediumGoldenrod filter 0.55 color White filter 0.60 ]
          }
        }
        scale <120, 100,10>
        translate x*-40
        rotate z*-20
      }
    }
    scale <220, 90, 1>
    rotate z*-150
    translate <-163 -180, -93>
    //finish { phong 0.5 phong_size 50 diffuse 0.9 }
  }
}
  
// --------------- BACK MOUND FOR WINGS -----------------------
#declare BACK =
object {
  union {
    sphere { 0, 1 scale <32, 30, 15> translate <6, 0, 85> }
    sphere { 0, 1 scale <34, 34, 35> translate <6, 0, 70> }
  }
  texture { BUG_color3 scale <30, 10, 30>  }
  texture { BUG_color4 scale <32, 30, 30> }
  texture { 
    pigment { color DarkGreen filter 0.85 }
    finish { phong 1.0 phong_size 20 }
    normal { bumps 0.3 frequency 30 scale 0.3 }
  }
}

// --------------- FLY EYES -----------------------------
#declare EYE =
object {
  sphere { 0, 1 scale <10, 12, 12> }
  texture { 
    pigment { color Orange }
    finish { ambient 0.2 diffuse 0.3 phong 1.0 }
  }
}

// -----------COMBINE HEAD PARTS-------------------
#declare FLY_HEAD =
union {
  object { HEAD  }
  object { EYE translate <65, 20, 76> }
  object { EYE translate <65, -20, 76> }
  union { antler translate <-5, 0, 8> }
  bounded_by { sphere { 0, 50 translate <75, 0, 50> } }
  scale 1.2
}

// -------- ASSEMBLE THE BODY PARTS-----------
#declare FLY =
union {
  object { FLY_HEAD translate x*-15 }
  object { ABDOMEN }
  object { THORAX scale <1, 1.2, 1.2> }
  object { leg }
  object { leg2 }
  object { WING1 translate z*94 }
  object { WING1 rotate x*180 translate z*94 }
  object { BACK }
  bounded_by { sphere { 0, 200 translate y*20 } }
}

// ------------------- STRAIGHT PIN ----------------------
#declare PIN =
   union {
      object {
         sphere { 0, 1 scale <15, 15, 2> translate z*170 }
         texture { SILVER }
      }
      object {
         Connector_1
         scale 5
         rotate y*90
         translate x*170
         texture { SILVER }
      }
      object {
         sphere { 0, 5 translate z*165 }
         texture { SILVER }
      }
      object {
         quadric { Connector_2 }
         clipped_by {
            plane { x, 4.999248 }
            plane { x, 1.999699 inverse }
         }
         translate x*-4.999248
         scale <57.657995, 1, 1>
         translate x*-0.086705
         rotate y*180
         rotate y*90
         translate z*165
         texture { SILVER }
      }
      object {
         sphere { 0, 2 translate z*-8 }
         texture { SILVER }
      }
      bounded_by { sphere { 0, 102.046864 translate z*82.5 } }
      rotate x*180
   }