//{------------------------------------------------------M. MILLER 1/3/92 }
//{-----------------THE TRAIN---------------------------------------------}
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//DECLARE TRAIN colors

#declare GOLD = 
texture {
  pigment { color red 0.6 green 0.6 blue 0 }
  finish {
    crand 0.02
    ambient 0.4
    diffuse 0.7
    reflection { 0.6 }
    brilliance 8
    phong 0.8
    phong_size 50
  }
}

#declare SILVER = 
texture {
  pigment { color red 0.7 green 0.7 blue 0.7 }
  finish {  
    crand 0.02
    ambient 0.4
    diffuse 0.7
    reflection { 0.5 }
    brilliance 7
    specular 0.5
  }
}

#declare BOD_color1 = texture { pigment { color rgb <0.60,0,0.11> } finish { diffuse 0.8 phong 1 } }
#declare BOD_color2 = texture { pigment { color Scarlet } finish { diffuse 0.4 reflection { 0.1 } phong 1 } }
#declare BOD_color3 = texture { pigment { color rgb <0.60,0,0.11> } finish { diffuse 0.8 phong 1 } }
#declare BOD_color4 = texture { BRASS }
#declare BOD_color5 = texture { pigment { color rgb 0.2  } finish { ambient 0.2 diffuse 0.7  phong 1 } }
#declare BOD_color6 = texture { pigment { color rgb 0.15 } finish { diffuse 1 reflection { 0.2 } phong 1 } }

//{-----------DECLARE MAIN TRUNK---------------}
#declare TRUNK = 
object {
  union {
    object { X_Disk scale  <240, 50, 50> }
    object { QSphere scale < 30, 30, 20> translate <160, 50, 0> }
    object { QSphere scale < 30, 30, 20> translate <180, 50, 0> }
    object { X_Disk scale  < 20, 30, 20> translate <160, 50, 0> }
    object { Cube scale    <120,  3, 55> translate x*120 }
  }
  texture { BOD_color1 }
  bounded_by { object { X_Disk scale <250, 70, 56> translate <-5, 10, 0> } }
}

#declare BRASS_RINGS =
object {
  union {
    object { QSphere scale   <5, 55, 55> translate  x*95 }
    object { QSphere scale   <5, 55, 55> translate x*175 }
    object { QSphere scale   <5, 55, 55> translate x*240 }
    object { Cube    scale <120,  3, 55> translate x*120 }
  }
  texture { BOD_color4 }
  bounded_by { object { X_Disk scale <250, 70, 56> translate <-5, 10, 0> } }
}

#declare MAIN_TRUNK = 
union {
  object { TRUNK }
  object { BRASS_RINGS }
}

//{------------- CABIN ROOF -----------------}
#declare CROOF = 
object {
  difference {
    union {
      object { Cube scale <35, 10, 20> translate <75, 90, 0> }
      object { X_Disk scale <150, 93, 93> }
    }
    plane { y, 60 }
  }
  texture { BOD_color2 }
}

//{------------ CABIN ----------------------}
#declare TCABIN = 
object {
  difference {
    object { Cube scale <55, 60, 70> }
    object { Cube scale <10, 20, 80> translate <-35, 30, 0> }
    object { Cube scale <30, 20, 80> translate < 15, 30, 0> }
    object { Cube scale <50, 50, 65> translate y*5 }
    object { Cube scale <40, 20, 80> translate <25, -60, 0> }
  }
  texture {
    material_map {
//      <1 -1 0> 
      gif "tcabin.gif" 
      texture { BOD_color1 finish { phong 0.5 phong_size 50 diffuse 0.9 } } 
      texture { BOD_color2 finish { phong 0.5 phong_size 50 diffuse 0.9 } } 
      texture { BOD_color3 finish { phong 0.5 phong_size 50 diffuse 0.9 } } 
      texture { BOD_color4 finish { phong 0.5 phong_size 50 diffuse 0.9 } }
    }
    scale <110, 120, 1>
    translate <-55, -60, -1>
  }
  bounded_by { object { Cube scale 80 translate <-10, 20, 0> } }  
}

#declare CABIN = 
union {
  object { CROOF translate x*-85 } 
  object { TCABIN } 
}

//{------------ FRONT NOSE ------------------}
#declare TNOSE = 
object {
  union {
    object { X_Disk  scale <80, 50, 50> translate 0 } 
    object { QSphere scale  <5, 55, 55> translate x*80 } 
    object { QSphere scale <10, 45, 45> translate x*80 } 
    object { X_Disk  scale <10, 15, 15> translate x*87 } 
    object { QSphere scale <10, 10, 10> translate <70, 60, 0> } 
    object { X_Disk  scale <20, 10, 10> translate <70, 60, 0> } 
    object { Y_Disk  scale <15, 20, 15> translate <25, 50, 0> } 
    object { DCone   scale <30, 65, 30> translate <25, 40, 0> } 
    object { Y_Disk  scale <25,  5, 25> translate <25, 70, 0> } 
  } 
  texture { BOD_color6 } 
  bounded_by { object { Cube scale <60, 95, 60 > translate <50, 30, 0> } }  
}

//{----------- TRAIN FRAME ------------------}
#declare TFRAME =
object {
  union {
    object { Cube scale <235, 30, 40> translate 0 } 
    object { Cube scale  <25, 40, 80> translate x*130 } 
    object { Cube scale  <40, 15, 20> translate <-225, -25, 0> } 
    object { Cube scale  <15, 30, 85> translate x*130 } 
    object { Cube scale  <40,  3, 70> translate x*195 } 
  } 
  texture { BOD_color5 } 
  bounded_by { object { Cube scale <270, 60, 90 > translate 0 } }  
}

//{------- GOLD STACKS -----------------------}
#declare STACK1 = 
union {
  object { Y_Disk scale <5, 20, 5> } 
  object { Y_Disk scale <8, 10, 8> translate y*20 } 
}

//{-------- STACKS ---------------------------}
#declare STACKS = 
object {
  union {
    object { STACK1 translate <-285, 210, 0> } 
    object { STACK1 translate <-245, 190, 0> } 
    object { STACK1 translate <-225, 190, 0> } 
    object { STACK1 scale <2, 1, 2> translate <-160, 200, 0> } 

    object { Y_Disk  scale <15, 40, 15> translate <-285, 170, 0> } 
    object { QSphere scale <15, 10, 15> translate <-285, 210, 0> } 
    object { Y_Disk  scale <20, 20, 20> translate <-235, 170, 0> } 

    object { Y_Disk scale <35, 10, 35> translate <-65, 230, 0> } 
    object { Y_Disk scale <25, 10, 25> translate <-65, 240, 0> } 
    object { X_Disk scale 10 translate y*190 } 
  } 
  texture { BOD_color4 } 
  bounded_by { object { Cube scale <180, 50, 45> translate <-130, 210, 0> } }  
}

//{----------- SIDE PANEL ---------------------}
#declare SIDE_PANEL =
object {
  union {
    object { Cube scale <65, 35,  2.5> } 
    object { Cube scale <55, 25,  7.5> } 
    object { Cube scale <85, 10,  2.5> translate <150, -5,    0> } 
    object { Cube scale <25,  6,  7>   translate <130, -50,   1> } 
    object { Cube scale <10, 17,  7>   translate <115, -38,   1> } 
    object { Cube scale <60, 2.5, 2.5> translate <120, -22.5, 0> } 
  } 
  texture { BOD_color5 } 
  bounded_by { object { Cube scale <160, 60, 8> translate <85, -10, 0> } }  
}

//{-------- SPOKE -----------}
#declare SPOKE = 
union {
  object { Cube scale <42, 2.5, 2> }
  object { X_Disk scale <84, 5, 4> translate x*-42 } 
}

//{------------ MAKE WHEEL ---}
#declare WHEEL1 =
object {
  union {
    object { SPOKE rotate z*0 } 
    object { SPOKE rotate z*45 } 
    object { SPOKE rotate z*90 } 
    object { SPOKE rotate z*-45 } 
    object { Z_Disk scale <20, 20, 10> translate z*-5 } 
    object { Z_Disk scale 10 translate z*-8 } 
  } 
  texture { BOD_color2 } 
  bounded_by { object { Z_Disk scale <48, 48, 18> translate z*-9 } }  
}

#declare RIM =
object {
  difference {
    object { Z_Disk scale <45, 45, 12> translate z*-6 } 
    object { Cylinder_Z  scale <40, 40, 1> } 
  } // end_difference
  texture { SILVER } 
  bounded_by { object { Z_Disk scale <48, 48, 13> translate z*-6.5 } }  
}

#declare WHEEL =
union {
  object { WHEEL1 } 
  object { RIM } 
  bounded_by { object { Z_Disk scale <48, 48, 12> translate z*-6 } }  
}

//{----------- SMALL WHEEL -----------------}
#declare S_WHEEL = 
object { WHEEL scale <0.6, 0.6, 1> } 

#declare COW =
object { 
  intersection {
    plane {  z, 1 } 
    plane { -z, 1.1 } 
    plane { -y, 1 } 
    plane {  x, 0.5 rotate  z*45 translate y*-0.5 rotate x*-45 } 
    plane { -x, 0.5 rotate z*-45 translate y*-0.5 rotate x*-45 } 
  }
}

#declare CUTTER = object { Cube scale <1, 5, 20> } 

#declare C_CATCH = 
object {
  difference {
    object { COW scale <10, 5, 10> } 
    object { CUTTER translate <  1.5, 1, 0> } 
    object { CUTTER translate <  4.5, 1, 0> } 
    object { CUTTER translate <  7.5, 1, 0> } 
    object { CUTTER translate < -1.5, 1, 0> } 
    object { CUTTER translate < -4.5, 1, 0> } 
    object { CUTTER translate < -7.5, 1, 0> } 
    object { CUTTER translate <-10.5, 1, 0> } 
    object { CUTTER translate < 10.5, 1, 0> } 
    object { COW scale <10, 5, 10> translate <0, -0.5, 2> } 
  }
  texture { SILVER } 
  bounded_by { object { Cube scale <10, 5, 10> } }  
}

#declare COW_CATCH =
object {
  union {
    object { C_CATCH scale <4.8, 5, 4> translate <0, -10, -45> } 
    object { Cube scale <70, 30, 5> } 
  }
  texture { BOD_color5 } 
  rotate y*-90 
}

#declare DOT_R = object { QSphere scale 5 } 

//{---------------CREATE THICK GOLD RAIL-----------------}
#declare THICK_RAIL =
object {
  union {
    object { DOT_R translate 0 } 
    object { DOT_R translate x*130 } 
    object { DOT_R translate <130, -30, 0> } 
    object { DOT_R translate <300, -30, 0> } 
    object { DOT_R translate <350, -80, 0> } 
    object { DOT_R translate <370, -80, 0> } 
    object { X_Disk scale <130, 5, 5> translate 0 } 
    object { X_Disk scale <170, 5, 5> translate <130, -30, 0> } 
    object { Y_Disk scale <5, 30, 5> translate <130, -30, 0> } 
    object { X_Disk scale <20, 5, 5> translate <350, -80, 0> } 
    object { X_Disk scale <70, 5, 5> rotate z*-45 translate <300, -30, 0> } 
  }
  texture { BOD_color4 } 
  bounded_by { object { Cube scale <200, 70, 10> translate <190, -35, 0> } }  
}

#declare POST = object { QSphere scale <4, 4, 8> } 

#declare THIN_RAIL =
object {
  union {
    object { POST } 
    object { POST translate x*120 } 
    object { POST translate x*240 } 
    object { X_Disk scale <240, 2, 2> translate z*-2 } 
  } 
  texture { BOD_color4 } 
  bounded_by { object { X_Disk scale <250, 9, 9> translate x*-5 } }  
}

//{----------------------WHEEL DRIVE-------------------}
#declare WHEEL_DRIVE =
object {
  union {
    object { Z_Disk scale <7, 7, 12> translate z*-4 } 
    object { Z_Disk scale <7, 7, 12> translate <130, 0, -4> } 
    object { Z_Disk scale <7, 7, 12> translate <150, 25, -4> } 
    object { Cube scale <65, 3, 2> translate x*65 } 
    object { Cube scale <15, 3, 2> rotate z*4 translate <140, 10, 0> } 
    object { Cube scale <55, 3, 2> translate <140, 39, 4> } 
  } 
  texture { SILVER } 
  bounded_by { object { Cube scale <130, 40, 12> translate <120, 20, 0> } }  
}

//-------------- PUT THE TRAIN MODEL TOGETHER -------------------------}
//{********* NOTE: ANYTHING WITH // IN THIS union ARE DETAILS ON THE BACK SIDE OF TRAIN }
#declare XTRAIN =
union {
  union {
    object { MAIN_TRUNK translate <-330, 130, 0> } 
    object { CABIN translate <-385, 130, 0> } 
    object { TNOSE translate <-90, 130, 0> } 
    object { TFRAME translate <-200, 60, 0> } 
    object { STACKS }
    object { SIDE_PANEL translate <-265, 105, -67.5> } 
    object { SIDE_PANEL translate <-265, 105, 67.5> } 
    object { WHEEL translate <-280, 45, -50> } 
    object { WHEEL translate <-280, 45, 50> } 
    object { WHEEL translate <-150, 45, -50> } 
    object { WHEEL translate <-150, 45, 50> } 
    object { S_WHEEL translate <0, 28, -50> } 
    object { S_WHEEL translate <0, 28, 50> } 
    object { THICK_RAIL translate <-330, 140, 67.5> } 
    object { THICK_RAIL translate <-330, 140, -67.5> } 
    object { THIN_RAIL translate <-300, 160, 45> } 
    object { THIN_RAIL translate <-300, 160, -45> } 
    object { WHEEL_DRIVE translate <-270, 30, 67.5> } 
    object { WHEEL_DRIVE translate <-270, 30, -71.5> } 
    object { COW_CATCH scale <0.7, 1, 1.1>  translate <43, 45, 0> } 
    object { QSphere scale <5, 10.3, 10.3> translate <10, 130, 0> } 
  } 
  texture { BOD_color4 }  
  bounded_by { object { Cube scale <330, 140, 120> translate <-160, 130, 0> } }  
}

#declare SMOKE =
object { 
  union {
    object { QSphere scale  <15, 40, 15> translate 0 } 
    object { QSphere scale  <20, 20, 20> translate y*30 } 
    object { QSphere scale  <25, 20, 25> translate  <-10,  50, 0> } 
    object { QSphere scale  <30, 25, 30> translate  <-40,  60, 0> } 
    object { QSphere scale  <50, 25, 35> translate  <-60,  70, 0> } 
    object { QSphere scale <170, 25, 40> translate  <-90,  80, 0> } 
    object { QSphere scale <170, 25, 40> translate <-100, 100, 0> } 
    object { QSphere scale  <50, 10, 30> translate <-120, 110, 0> } 
  }
  texture {
    pigment {
      bozo
      turbulence 0.4
      color_map {
        [0 0.1     color White filter 0.8 color White filter 0.9]
        [0.1 0.5   color White filter 0.9 color White filter 0.8 ]
        [0.5 1.001 color White filter 0.8 color White filter 1.0]
      }
    rotate z*90 
    scale <40, 30, 20>
    }
    finish { crand 0.05 }
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0 0.2    color White filter 0.7 color White filter 0.8]
        [0.2 0.4  color White filter 0.8 color White filter 1.0]
        [0.4 1.01 color White filter 1   color White filter 1.0]
      }
    }
    scale <300, 140, 40>
    translate y*-160
  }
  bounded_by { object { Cube scale <400, 120, 50> translate <-160, 30, 0> } }  
}

//{---------- THE WHOLE Kit n' Cabosse -----------------------}
#declare TRAIN =
union {
  object { SMOKE scale <1, 1.2, 1> translate <-65, 260, 0> } 
  object { XTRAIN } 
}