//------------------------ TRAIN STATION     M.MILLER 1/15/91
//-------------------------Rendered in about 40 Hours +a0.1 on a 486 /33
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "stat.inc"
#include "toytrain.inc"
#include "marb.inc"
#include "turn16_x.inc"
#include "plant.inc"

camera {
  location <-80, 450, -1550>
  direction z*1.6
  up y
  right x*image_width/image_height
  look_at <-80, 140, 0>
}

//-----------LIGHTS-------------------------------
light_source { <2000, 300, -1800> color rgb 1 }
light_source { <100, 1000, -1000> color rgb 1 }

//------------- rotate IONIC TURN --------------------------
#declare TURN = object { turn16 scale <1, 6, 1> }

//---------------BUILD THE IONIC-16 CAPITAL-----------------------------
#declare T16 = union {
  object { 
    union { //----------CAPITAL BELLY
      object { Y_Disk scale <8.5, 2, 8.5> translate 0 }
      object { Y_Disk scale <9, 12, 9> translate y*2 }
      object { Z_Disk scale <4.5, 4.8, 12> translate <-8.5, 9.3, -10> }
      object { Z_Disk scale <4.5, 4.8, 12> translate <8.5, 9.3, -10> }
      object { QSphere scale <11, 1, 11> translate y*8 }
    }
    texture { STONE4 }
  bounded_by { Y_Disk scale <17, 15, 17> translate <0, -0.5, -2> } 
  }
  object { TURN rotate x*90 rotate z*90 translate <-8, 9, -9> } 
  object { TURN rotate x*90 rotate z*90 rotate y*180 translate <8, 9, -9> } 
  object {
    X_Disk scale <16, 0.5, 3> translate <-8, 13.5, -9>
    texture { STONE4 }
  }
  bounded_by { Y_Disk scale <22, 16, 22> translate <0, -1, -2> } 
}

//----------WALL BASE----------
#declare WALL_BASE = 
object { 
  union {
    box { -1, 1 scale <24, 3,  6> translate  y*3 }
    box { -1, 1 scale <10, 3, 16> translate  y*3 }
    box { -1, 1 scale <23, 5,  5> translate y*11 }
    box { -1, 1 scale < 9, 5, 15> translate y*11 }
    object { Y_Disk scale <8.5, 4, 8.5> translate <0, 16, -6> }
  }
  texture { ST6 scale <15, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
  texture { ST7 scale <20, 12, 5> rotate z*-40 finish { phong 1 } }
  bounded_by { box { -1, 1 scale <25, 11, 17> translate y*12 } } 
}

//------------- CREAM ROSE COLUMN-----------------
#declare COLUM16 = 
object { 
  Y_Disk scale <8, 58, 8>
  texture { ST3 scale <6, 10, 1> finish { diffuse 0.5 } }
  texture { ST2 scale <15, 20, 3> rotate z*35 finish { ambient 0.2 phong 1.0 phong_size 50 } }
}

#declare WALL16 = 
box { -1, 1
  scale <22, 39, 4>
  texture { ST6 scale <8, 8, 2> finish { ambient 0.2 diffuse 0.4 } }
  texture { ST7 scale <10, 7, 2> rotate z*-50 finish { diffuse 0.4 } }
  texture { ST13 scale <45, 70, 4> rotate z*30 finish { diffuse 0.5 } }
  texture { pigment { color SeaGreen filter 0.8 } finish { diffuse 0.5 } }
  texture { ST11 scale <45, 50, 3> rotate z*-50 finish { diffuse 0.5 phong 1.0 } }
} 

//----------MAKE WALL WITH MODING & COLUMN----------
#declare LOWER_WALL = 
union {
  object { WALL_BASE translate 0 } 
  object { WALL_BASE scale <1, 0.5, 1> rotate z*180 translate y*100 } 
  object { T16 translate <0, 78, -6> } 
  object { COLUM16 translate <0, 20, -6> } 
  object { WALL16 translate y*54 } 
  bounded_by { box { -1, 1 scale <25, 55, 18> translate y*54 } } 
}

//----------LARGE ARCH MOLDING -------------------
#declare L_ARCH = 
object {
  difference {
    object { Cylinder_Z scale <40, 40, 1> }
    object { Cylinder_Z scale <33, 33, 1> }
    plane { -z, 5 inverse } 
    plane { -z, -5 } 
    plane { -x, 0 } 
  } 
  texture { ST6 scale <15, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
  texture { ST7 scale <20, 12, 5> rotate z*-40 finish { phong 1.0 } }
  bounded_by { box { -1, 1 scale <24, 24, 12> translate <-19, 22, 0> } } 
}

//----------APEX ARCH MOLDING -------------------
#declare APEX = 
object {
  difference {
    union {
      object { Cylinder_Z scale <9.375, 9.375, 1> translate x*-5 }
      object { Cylinder_Z scale <9.375, 9.375, 1> translate x*5 }
    }
    object { Cylinder_Z scale <5, 5, 1> translate x*-5 }
    object { Cylinder_Z scale <5, 5, 1> translate x*5 }
    plane { -z,  5 inverse } 
    plane { -z, -5 } 
    plane { -x, -5 } 
    plane {  x, -5 } 
  } 
  texture { STONE4 }
  bounded_by { box { -1, 1 scale 12 translate 0 } }  
}

//----------SMALL ARCH MOLDING -------------------
#declare S_ARCH = object { L_ARCH scale <0.625, 0.625, 0.9> } 

#declare UPPER_WALL =
object {
  union {
    difference {
      box { -1, 1 scale <55, 25, 4.5> translate <0, 25, -4.5> }
      object { Cylinder_Z scale <42, 40, 1> }
    } 
    difference {
      box { -1, 1 scale <68, 25, 4.5> translate <0, 25, 4.5> }
      object { Cylinder_Z scale <28, 25, 1> }
    } 
  }
  texture { ST6 scale <20, 30, 2> finish { ambient 0.2 diffuse 0.3 } }
  texture { ST7 scale <20, 30, 2> rotate z*-50  finish { diffuse 0.4 } }
  texture { ST13 scale <80, 90, 4> rotate z*30 finish { diffuse 0.4 } }
  texture { pigment { color SeaGreen filter 0.8 } finish { diffuse 0.4 } }
  texture { ST11 scale <75, 60, 3> rotate z*-50 finish { diffuse 0.5 phong 1.0 } }
  bounded_by { box { -1, 1 scale <70, 30, 10> translate y*28 } } 
}

#declare WEDGE =   //--------------MAKE WEDGE---------------
intersection {
  plane {  z, 1 } 
  plane { -z, 1 } 
  plane {  y, 1 } 
  plane { -y, 1 } 
  plane {  x, 1 rotate z*-20 } 
  plane { -x, 1 rotate  z*20 } 
  scale 1
}

#declare WEDGE2 = //----------WEDGE GROUP--------------
object {
  union {
    object { WEDGE scale <10, 11, 14> translate z*2 }
    object { WEDGE scale <20, 7.5, 12> translate <0, -2, 2> }
  }
  texture { ST6 scale <5, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
  texture { ST7 scale <7, 3, 5> rotate z*-40 finish { phong 1.0 } }
}

#declare WEDGE_KEY = object { WEDGE2 scale <0.4, 0.75, 0.5> } 

//------------------ STATION TOP --------------------------
#declare S_ROOF =
box { -1, 1
  scale <72, 3, 200> translate <0, 158, 185>
  texture { STONE4 }
}

//--------- INSIDE WALLS -------------------
#declare INNER_WALL = 
box { -1, 1
  scale <10, 300, 200>
  texture { STONE2 }
}

//----------BUILD THE STATION WALL----------
#declare ST_W = 
union {
  object { S_ROOF } 
  object { LOWER_WALL translate x*-47 } 
  object { LOWER_WALL translate x*47 } 
  object { L_ARCH translate <-5, 102, -10> } 
  object { S_ARCH translate <-5, 100, 2> } 
  object { L_ARCH rotate y*180 translate <5, 102, -10> } 
  object { S_ARCH rotate y*180 translate <5, 100, 2> } 
  //object { APEX translate y*132 } 
  object { UPPER_WALL translate y*100 } 
  object { WEDGE_KEY translate <0, 140, -11> } 
  object { WEDGE_KEY scale 0.8 translate <0, 125, -4> } 
  object { WALL_BASE scale <1, 0.5, 1> rotate z*180 rotate y*180 translate <-47, 155, 0> } 
  object { WALL_BASE scale <1, 0.5, 1> rotate z*180 rotate y*180 translate <47, 155, 0> } 
  bounded_by { box { -1, 1 scale <95, 93, 18> translate y*90 } } 
}

//---------------- 2 WALLS TOGETHER ---------------------------
#declare STATION_WALL = 
union {
  object { ST_W } 
  object { ST_W translate x*136 } 
}

//------------------ BUILD THE STAIRS -------------------------
#declare SWALL_COL = 
texture { ST6 finish { ambient 0.4 diffuse 0.7 } scale <40, 50, 2> rotate z*-25 }
texture { pigment { color rgbf<0.40,0.33,0.33,0.3> } finish { diffuse 0.5 } }
texture { BUTT_CRACK scale <90, 140, 50> finish { phong 1.0 } }

//----------- STAIR WALLS ----------------------------
#declare S_WALL = 
object {
  union {    
    difference {
      box { -1, 1 scale <120, 75, 35> }
      plane { y, 0 rotate z*32.5 translate y*22.5 inverse } 
    } 
    difference {
      box { -1, 1 scale <120, 105, 20> translate y*50 }
      plane { y, 0 rotate z*32.5 translate y*80 inverse } 
    } 
    box { -1, 1 scale <135, 6, 35> rotate z*32.5 translate y*77 }
  }
  texture { SWALL_COL }
  bounded_by { box { -1, 1 scale <130, 120, 40> translate y*45 } } 
}

#declare TRED = box { -1, 1 scale <35, 5, 210> }
#declare RISER = box { -1, 1 scale <5, 15, 210> }

//----------------- CORNER POST --------------------------------------
#declare FAT_POST = 
object { 
  union{
    box { -1, 1 scale <30, 60, 30> translate 0 }
    box { -1, 1 scale <35, 10, 35> translate y*-50 }
    box { -1, 1 scale <35, 10, 35> translate y*42 }
  }
  texture { ST6 scale <25, 20, 3> finish { ambient 0.2 diffuse 0.8 } }
  texture { ST7 scale <20, 17, 5> rotate z*-40 finish { phong 1.0 } }// END_texture
  bounded_by { box { -1, 1 scale <40, 70, 40 > translate 0 } }
}

//------------------ MAKE VASE FOR POST -------------------------
#declare B_VASE = //----------------BOTTOM OF VASE----------
object { 
  difference {
	union {
	  object { QSphere scale <12, 20, 22> }
	  object { QSphere scale <12, 20, 22> rotate <0, 45, 0> }
	  object { QSphere scale <12, 20, 22> rotate <0, 90, 0> }
	  object { QSphere scale <12, 20, 22> rotate <0, 135, 0> }
    }
	plane { -y, 0.2 } 
  }
}

#declare T_VASE =   //------------------TOP OF VASE--------
object { 
  union {
	object { QSphere scale <13, 5, 13> translate 0 }
	object { QSphere scale <6, 10, 6>  translate y*6 }
  }
}

#declare VASE = //-----------JOIN TOP & BOTTOM OF VASE ----------- 
object { 
  union {
	object { B_VASE }
	object { T_VASE }   
  }
  texture { ST3 scale <18, 10, 1> finish { diffuse 0.5 } }
  texture { ST2 scale <20, 20, 3> rotate z*35 finish { ambient 0.2 phong 1.0 phong_size 50 } }// END_texture
  bounded_by { box { -30, 30 } } 
  scale 1.5
}

#declare STEP_COL = 
texture { ST6 finish { ambient 0.3 diffuse 0.8 } scale <40, 50, 2> rotate z*-25 }
texture { pigment { color rgbf<0.46,0.33,0.33,0.5> } finish { diffuse 0.5 } }// END_texture
texture { BUTT_CRACK scale <52, 80, 90> finish { phong 1.0 reflection 0.2 } }// END_texture

//-------------------- STEPS -----------------------------------------
#declare STAIR = 
object { 
  union {
    object { RISER translate <-65, -60, 0> }
    object { TRED translate <-45, -40, 0> }
    object { RISER translate <-5, -30, 0> }
    object { TRED translate <15, -10, 0> }
    object { RISER translate x*55 }
    object { TRED translate <75, 20, 0> }
  }
  texture { STEP_COL } 
  bounded_by { box { -1, 1 scale <110, 60, 240> translate <15, -25, 0> } } 
}

//------------- STEPS, STEP WALLS, & CORNER POSTS ----------------------
#declare STEPS = 
union {
  object { S_WALL translate z*-240 } 
  object { S_WALL translate z*240 } 
  object { STAIR translate 0 } 
  object { FAT_POST translate <140, 115, 240> } 
  object { FAT_POST translate <140, 115, -240> } 
  bounded_by { box { -1, 1 scale <160, 140, 290> translate <30, 55, 0> } } 
}

//-------------- CHECKER FLOOR texture { S ---------------------
#declare T1 = texture { ST6 finish { ambient 0.2 diffuse 0.4 } scale <2.5, 2.3, 0.3> rotate z*40 }
#declare T2 = texture { ST6 finish { ambient 0.4 diffuse 0.7 } scale <2.3, 3.5, 0.3> rotate z*-25 }

//------------------- MARBLE FLOOR ----------------------
#declare MFLOOR = 
box { -1, 1 scale <1470, 1510, 5>

  texture { 
    checker  
    texture { T1 } 
    texture { T2 } 
    //scale <50, 50, 2> 
    scale <100, 100, 4> 
  }
  //texture {
  //  checker 
  //  texture { pigment { color DimGray filter 0.3 } }
  //  texture { pigment { color DimGray filter 0.5 } } 
  //  //finish { phong 1.0 reflection { 0.3 } } 
  //  scale <105, 107.8, 2> 
  //}
  rotate x*90
  translate <1000, 0, 1000>
}

//------------------ FLOOR BASE -------------------------
#declare FLOOR_BASE = 
box { -1, 1
  scale <1450, 200, 1490> translate <1000, -200, 1000>
  texture { ST3 scale <300, 60, 20> finish { diffuse 0.5 } }// END_texture
  texture { ST2 scale <500, 90, 60> finish { ambient 0.2 } rotate z*35 }
  texture { pigment { color DimGray filter 0.4 } finish { phong 1.0 phong_size 50 } }
} 

//------------------ FLOOR TRIM -------------------------
#declare FLOOR_TRIM = 
box { -1, 1
  scale <465, 20, 20> translate <0, -25, -488>
  texture { ST3 scale <190, 30, 20> finish { diffuse 0.5 } }
  texture { ST2 scale <300, 40, 60> rotate z*35 finish { ambient 0.2 phong 1.0 phong_size 50 } }
} 

//----------------- MAKE CROSS RAIL -------------------------
//---------- CROSS ----------------
#declare CROSS = 
object { 
  union {
    object { Cylinder_Y scale <2.5, 80, 2.5> translate y*-40 rotate z*45 }
    object { Cylinder_Y scale <2.5, 80, 2.5> translate y*-40 rotate z*-45 }
    object { Cylinder_Y scale <2.5, 50, 2.5> translate < 25, -25, 0> rotate 0 }
    object { Cylinder_Y scale <2.5, 50, 2.5> translate <-25, -25, 0> rotate 0 }
  }
  texture { BRASS }
  clipped_by { box { -1, 1 scale <30, 25, 3> } } // END_CLIP
  bounded_by { box { -1, 1 scale <30, 25, 3> } } 
}

#declare HOR_RAIL =
object {
  Cylinder_X scale <480, 3, 4> translate x*-240
  texture { BRASS }
} 

#declare CROSS_RAIL = 
union {
  object { CROSS translate x*-175 } 
  object { CROSS translate x*-105 } 
  object { CROSS translate  x*-35 } 
  object { CROSS translate   x*35 } 
  object { CROSS translate  x*105 } 
  object { CROSS translate  x*175 } 
  object { HOR_RAIL translate  y*25 } 
  object { HOR_RAIL translate y*-25 } 
  bounded_by { box { -1, 1 scale <245, 60, 5> } } 
  scale <1, 1.22, 1>
}


//--------------- BUILD BRIDGE SECTION ------------------------------
#declare BRIDGE =
object {
  difference {
    union {
      box { -1, 1 scale <200, 160, 100> } 
      box { -1, 1 scale <200,  10, 110> translate y*135 } 
    }
    object { Cylinder_Z scale <60, 60, 1> translate <-100, 50, 0> }
    object { Cylinder_Z scale <60, 60, 1> translate < 100, 50, 0> }
    box { -1, 1 scale <60, 120, 160> translate <-100, -70, 0> } 
    box { -1, 1 scale <60, 120, 160> translate < 100, -70, 0> } 
  } 
  texture { ST3 scale <100, 60, 20> finish { diffuse 0.5 } }
  texture { ST2 scale <200, 90, 60> finish { ambient 0.2 } rotate z*35 }
  texture { pigment { color DimGray filter 0.6 } finish { ambient 0.2 phong 1.0 phong_size 30 } }// END_texture
  bounded_by { box { -1, 1 scale <201, 161, 121> } } 
  scale <2, 2, 2.2>
}

//------------ TOP OF BRIDGE -----------------
#declare BR_BASE = 
box { -1, 1
  scale <3000, 10, 130>
  texture { pigment { color DimGray } finish { crand 0.05 ambient 0.2 diffuse 0.5 } }
}

//------------ SILVER RAILS -----------------
#declare S_RAILS = 
object { 
  union {
    box { -1, 1 scale <3000, 10, 10> translate <0, 10, -100> }
    box { -1, 1 scale <3000, 10, 10> translate <0, 10,  100> }
  } 
  texture { SILVER }
}

#declare TRACKS = 
union {
  object { BR_BASE } 
  object { S_RAILS } 
  bounded_by { box { -1, 1 scale <3000, 20, 135> } } 
}

//---------- RELECTION plane FOR LOWER BRIDGE --------
object {
  plane { y, -320 } 
  texture { pigment { color Black } finish { reflection 0.9 } }// END_texture
}

//--------------------------  THE SCENE -----------------------------
#declare SCENE = 
union {

  object { S_ROOF scale 4 } 
  object { MFLOOR translate 0 } 
  object { FLOOR_BASE } 
  object { STEPS rotate y*-90 translate <300, -50, -610> } 

  object { STATION_WALL scale 4 translate y*4.5 } 
  object { STATION_WALL scale 4 translate <-30, 4.5, 1600> } 

  object { FLOOR_TRIM } 

  object { CROSS_RAIL translate <-162, 60, -470> } 
  object { CROSS_RAIL rotate y*90 translate <-430, 60, -220> } 
  object { CROSS_RAIL rotate y*90 translate <-430, 60,  270> } 
  object { CROSS_RAIL translate <810, 60, -470> } 

  object { FAT_POST translate <-430,  60, -470> } 
  object { FAT_POST translate <-430,  60,   25> } 
  object { FAT_POST translate <  60, -65, -760> } 
  object { FAT_POST translate <-430,  60,  515> } 

  object { VASE translate <-430, 150, -470> } 
  object { VASE translate <-430, 150,   25> } 
  object { VASE translate <  60,  25, -760> } 
  object { VASE translate <  60, 150, -470> } 
  object { VASE translate < 540, 150, -470> } 
  object { VASE translate <-430, 150,  515> } 

  object { BRIDGE translate <- 870, -320, 800> } 
  object { BRIDGE translate <-1670, -320, 800> } 
  object { BRIDGE translate <-2470, -320, 800> } 
  object { BRIDGE translate <-3270, -320, 800> } 

  object { TRACKS translate <-1000, 0, 800> } 

  object { XTRAIN scale 2 /*rotate y*180*/ translate <-1170, 20, 800> } 

  rotate y*35
}

object { SCENE }

//------------- ********************************************  -----------
object { PLANT1 scale 13 translate <-400, -15, -550> } 


/*
//-------------- WORLD -----------------------------------
#declare Zenith = color rgb<0,0,0.93>;
#declare MidSky = color rgb<0.55,0.55,1>;
#declare HighHorizon = color rgb <0.73,0.73,0.98>;
#declare Groundcolor = color ForestGreen;
#declare Rose = color rgb<0.96,0.59,0.66>;
#declare LowHorizon = color CadetBlue;

#declare Clouds1 = 
texture {        
  pigment {
    bozo
    turbulence 0.6
    color_map {
      [0.0 0.5   color rgbf 1           color rgbf 1]
      [0.5 0.8   color White filter 0.5 color Rose]
      [0.8 1.001 color Rose             color DimGray ]
    }
    scale <1, 0.7, 1>
  }
}

#declare WORLD =
union {
  // -----------------Sky sphere------------------------------------- 
  object {
    QSphere scale <6000, 6000, 12000>
    texture {
      pigment {
        gradient y
        color_map {
          [0.0 0.10 color LowHorizon color HighHorizon]
          [0.10 0.15 color HighHorizon color HighHorizon]
          [0.15 0.70 color HighHorizon color MidSky]
          [0.70 0.9 color MidSky color Zenith]
          [0.9 1.01 color Zenith color LowHorizon]
        }
      }
      finish { ambient 0.6 diffuse 0.2 }
      scale <6000, 6000, 1600>
      translate <0, 0, 0>
    }
    texture { Clouds1 scale <3000, 1050, 4050> finish { ambient 0.6 diffuse 0.3 } }
    translate z*400
  }
  object { QSphere scale <6000, 6000, 12000>
    texture { pigment { color Black } finish { ambient 0.8 diffuse 0.0 } }
  }
  rotate y*35
}  

object { WORLD }

//888888888888888888888888888888888888888888888888888888888888


*/
//--------------------BACKDROP---------------------------------
//------MULTI texture { - Gif W/Gradation color Tint--------------
box { -1, 1 scale <20000, 15000, 1>

  texture { 
    pigment {
      image_map {
        //<1, -1, 0>
        // gif "sky1.gif"
        gif "cloud3.gif"
      }
    }
    finish { ambient 1.0 diffuse 0 }
    scale <4000, 3000, 2>
    translate <-2000, -500, -2> 
  }

//  texture { 
//    pigment {
//      gradient y
//      color_map {
//	    [0.0 0.3 color Salmon                color BlueViolet filter 0.3]
//	    [0.3 0.8 color BlueViolet filter 0.3 color Black filter 0.2]
//	    [0.8 1.0 color Black filter 0.2      color Black filter 0]
//	  }
//	}
//	scale <4000, 3000, 1>
//	translate y*-1500 
//	finish {
//	  ambient 1
//	  diffuse 0
//    }
//  } 
  scale 1
  translate <0, -600, 2700>
}