//------------ SHAPES DATA ---------------------------------
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Cylinder_X = quadric { <0, 1, 1>, 0, 0, -1 }
#declare Cylinder_Y = quadric { <1, 0, 1>, 0, 0, -1 }
#declare Cylinder_Z = quadric { <1, 1, 0>, 0, 0, -1 }
#declare Cone_X = quadric { <-1,  1,  1>, 0, 0, 0 }
#declare Cone_Y = quadric { < 1, -1,  1>, 0, 0, 0 }
#declare Cone_Z = quadric { < 1,  1, -1>, 0, 0, 0 }

#declare DCone = // ---------CONE POINT DOWN /POINT at 000--------
intersection {
  object { Cone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 }
}

#declare UCone = // ---------CONE POINT UP /POINT at 000--------
intersection {
  object { Cone_Y scale 1 }
  plane { y,  0 }
  plane { y, -1 inverse }
}

#declare Cube = 
intersection {
  plane {  z, 1 }
  plane { -z, 1 }
  plane {  y, 1 }
  plane { -y, 1 }
  plane {  x, 1 }
  plane { -x, 1 }
}

#declare X_Disk = 
intersection {
  object { Cylinder_X }
  plane { x, 0 inverse }
  plane { x, 1 }
}

#declare Y_Disk = 
intersection {
  object { Cylinder_Y }
  plane { y, 0 inverse }
  plane { y, 1 }
}

#declare Z_Disk =
intersection {
  object { Cylinder_Z }
  plane { z, 0 inverse }
  plane { z, 1 }
}

#declare QSphere = quadric { 1, 0, 0, -1 }

//----------- DIRECT FROM COLORS.DAT ----------------------------------
#declare White = color red 1 green 1 blue 1.0;
#declare Black = color red 0 green 0 blue 0.0;
#declare BlueViolet = color red 0.62352 green 0.372549 blue 0.623529;
#declare CadetBlue = color red 0.372549 green 0.623529 blue 0.623529;
#declare DimGray = color red 0.329412 green 0.329412 blue 0.329412;
#declare ForestGreen = color red 0.137255 green 0.556863 blue 0.137255;
#declare Gold = color red 0.8 green 0.498039 blue 0.196078;
#declare Salmon = color red 0.435294 green 0.258824 blue 0.258824;
#declare SeaGreen = color red 0.137255 green 0.556863 blue 0.419608;
#declare Feldspar = color red 0.82 green 0.57 blue 0.46;
#declare DarkGreen = color red 0.184314 green 0.309804 blue 0.184314;
#declare Scarlet = color red 0.55 green 0.09 blue 0.09;
#declare Yellow = color red 1 green 1.0;

//-------------- TEXTURES ---------------------------------
#declare STONE1 = texture { pigment { color DimGray } finish { diffuse 1 ambient 0.4 phong 1 } }
#declare STONE2 = texture { pigment { color Salmon } finish { phong 1 } }
#declare STONE3 = texture { pigment { color DimGray } finish { phong 1 } }
#declare STONE4 = texture { pigment { color Feldspar } finish { ambient 0.2 diffuse 0.8 phong 1 } }
#declare BRASS = texture { pigment { color rgb<0.80,0.58,0.0> } finish { metallic ambient 0.4 diffuse 0.3 reflection { 0.5 } brilliance 6 phong 1 } }

#declare SILVER =
texture { //---------Bright REFLECTIVE SILVER-----------
  pigment { color rgb 0.7 }
  finish {
    reflection { 0.9 }
    brilliance 7.0
    crand 0.02 
    ambient 0.4 
    diffuse 0.7
    specular 0.5
  }
}

// #declare LIGHT = 
// OBJECT SPHERE <0 0 0> 1 END_SPHERE
// TEXTURE COLOR White END_TEXTURE
// LIGHT_SOURCE COLOR White END_OBJECT
