//----------- DATA FILE THAT CREATES A LEAF, A STEM, A HOUSE PLANT
//------------------------------------------------M.MILLER 1/13/91
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------------------------------THE LEAF
#declare SPONGY = 
texture {
  pigment {
    gradient x
    color_map {
      [0.000 0.308   color rgbf<0.196, 0.275, 0.047, 0> color rgbf<0.420, 0.439, 0.227, 0>]
      [0.308 0.402   color rgbf<0.420, 0.439, 0.227, 0> color rgbf<0.329, 0.392, 0.184, 0>]
      [0.402 0.547   color rgbf<0.329, 0.392, 0.184, 0> color rgbf<0.282, 0.353, 0.149, 0>]
      [0.547 0.761   color rgbf<0.282, 0.353, 0.149, 0> color rgbf<0.196, 0.275, 0.208, 0>]
      [0.761 0.983   color rgbf<0.196, 0.275, 0.208, 0> color rgbf<0.196, 0.275, 0.047, 0>]
      [0.983 1.001   color rgbf<0.196, 0.275, 0.047, 0> color rgbf<0.196, 0.275, 0.047, 0>]
    }
  }
  finish { ambient 0.2 }
}
texture {
  pigment { color Yellow filter 0.9 }
  finish {
    phong 1.0
    phong_size 20
  }
  normal {
    bumps 0.5
    scale 0.2
  }
}

#declare Dot =
quadric {
  1, 1, 1, -1
  rotate z*90
}

#declare Connector_1 = 
object {
  quadric {
    <0, 1, 1>, 0, 0, -1
  }
  texture { SPONGY }
  clipped_by {
    plane {  x, 1}
    plane { -x, 0}
  }
}

#declare Connector_2  =
quadric {
  <1, -1, 1>, 0, 0, 0
  rotate z*90
}

//------------------------ START THE LEAF -----------------
#declare LEAF_L =
   union {
      object { Dot  texture { SPONGY }
            scale     < 0.750000,  0.750000,  0.750000>
            translate <-0.450000,  0,  0>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.745767}
            plane { x, 0.696049 inverse}
         }
         translate <-0.745767,  0,  0>
         scale     < 9.372300,  1,  1>
         translate <-0.079571,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  39.536614>
         rotate    < 0,  97.907163,  0>
         translate <-0.450000,  0,  0>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.700000,  0.700000,  0.700000>
            translate <-0.500000,  0.300000, -0.360000>
      }

      object { Connector_1
         scale     < 0.412311,  0.700000,  0.700000>
         rotate    < 0,  0,  75.963757>
         rotate    < 0,  90,  0>
         translate <-0.500000,  0.300000, -0.360000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.700000,  0.700000,  0.700000>
            translate <-0.500000,  0.700000, -0.460000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.694439}
            plane { x, 0.659717 inverse}
         }
         translate <-0.694439,  0,  0>
         scale     < 7.885663,  1,  1>
         translate <-0.088063,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  76.047264>
         rotate    < 0,  63.434949,  0>
         translate <-0.500000,  0.700000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.665000,  0.665000,  0.665000>
            translate <-0.470000,  0.970000, -0.520000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.652713}
            plane { x, 0.588914 inverse}
         }
         translate <-0.652713,  0,  0>
         scale     < 5.129679,  1,  1>
         translate <-0.127242,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  76.270955>
         rotate    < 0,  29.744881,  0>
         translate <-0.470000,  0.970000, -0.520000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.600000,  0.600000,  0.600000>
            translate <-0.400000,  1.300000, -0.560000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.569210}
            plane { x, 0.474342 inverse}
         }
         translate <-0.569210,  0,  0>
         scale     < 3,  1,  1>
         translate <-0.189737,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  71.565051>
         translate <-0.400000,  1.300000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.500000,  0.500000,  0.500000>
            translate <-0.300000,  1.600000, -0.560000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.476731}
            plane { x, 0.381385 inverse}
         }
         translate <-0.476731,  0,  0>
         scale     < 3.162278,  1,  1>
         translate <-0.150756,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  64.760598>
         rotate    < 0, -45,  0>
         translate <-0.300000,  1.600000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.400000,  0.400000,  0.400000>
            translate <-0.200000,  1.900000, -0.460000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.384642}
            plane { x, 0.269250 inverse}
         }
         translate <-0.384642,  0,  0>
         scale     < 3.503966,  1,  1>
         translate <-0.109773,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  60.347246>
         rotate    < 0, -56.309932,  0>
         translate <-0.200000,  1.900000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.280000,  0.280000,  0.280000>
            translate <-0.080000,  2.280000, -0.280000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.275907}
            plane { x, 0.197076 inverse}
         }
         translate <-0.275907,  0,  0>
         scale     < 5.783868,  1,  1>
         translate <-0.047703,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  42.958491>
         rotate    < 0, -81.634114,  0>
         translate <-0.080000,  2.280000, -0.280000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.200000,  0.200000,  0.200000>
            translate <-0.030000,  2.600000,  0.060000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.173770}
            plane { x, 0.086885 inverse}
         }
         translate <-0.173770,  0,  0>
         scale     < 1.754993,  1,  1>
         translate <-0.099015,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  81.950533>
         rotate    < 0,  45,  0>
         translate <-0.030000,  2.600000,  0.060000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.100000,  0.100000,  0.100000>
            translate <-0.010000,  2.800000,  0.040000>
      }

      bounded_by { Dot scale 2.417294 translate <-0.450000,  1.075000, -0.217500> }
   }

//------------------LEFT----------------------------
#declare LEAF_LEFT = 
      object { LEAF_L
      bounded_by { Dot scale 2.417294 translate <-0.450000,  1.075000, -0.217500> }
   }


//------------------------ THE RIGHT HALF OF LEAF -----------------
#declare LEAF_R =
   union {
      object { Dot  texture { SPONGY }
            scale     < 0.750000,  0.750000,  0.750000>
            translate < 0.450000,  0,  0>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.745767}
            plane { x, 0.696049 inverse}
         }
         translate <-0.745767,  0,  0>
         scale     < 9.372300,  1,  1>
         translate <-0.079571,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  39.536614>
         rotate    < 0,  82.092837,  0>
         translate < 0.450000,  0,  0>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.700000,  0.700000,  0.700000>
            translate < 0.500000,  0.300000, -0.360000>
      }

      object { Connector_1
         scale     < 0.412311,  0.700000,  0.700000>
         rotate    < 0,  0,  75.963757>
         rotate    < 0,  90,  0>
         translate < 0.500000,  0.300000, -0.360000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.700000,  0.700000,  0.700000>
            translate < 0.500000,  0.700000, -0.460000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.694439}
            plane { x, 0.659717 inverse}
         }
         translate <-0.694439,  0,  0>
         scale     < 7.885663,  1,  1>
         translate <-0.088063,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  76.047264>
         rotate    < 0,  116.565051,  0>
         translate < 0.500000,  0.700000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.665000,  0.665000,  0.665000>
            translate < 0.470000,  0.970000, -0.520000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.652713}
            plane { x, 0.588914 inverse}
         }
         translate <-0.652713,  0,  0>
         scale     < 5.129679,  1,  1>
         translate <-0.127242,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  76.270955>
         rotate    < 0,  150.255119,  0>
         translate < 0.470000,  0.970000, -0.520000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.600000,  0.600000,  0.600000>
            translate < 0.400000,  1.300000, -0.560000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.569210}
            plane { x, 0.474342 inverse}
         }
         translate <-0.569210,  0,  0>
         scale     < 3,  1,  1>
         translate <-0.189737,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  71.565051>
         rotate    < 0, -180,  0>
         translate < 0.400000,  1.300000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.500000,  0.500000,  0.500000>
            translate < 0.300000,  1.600000, -0.560000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.476731}
            plane { x, 0.381385 inverse}
         }
         translate <-0.476731,  0,  0>
         scale     < 3.162278,  1,  1>
         translate <-0.150756,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  64.760598>
         rotate    < 0, -135,  0>
         translate < 0.300000,  1.600000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.400000,  0.400000,  0.400000>
            translate < 0.200000,  1.900000, -0.460000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.384642}
            plane { x, 0.269250 inverse}
         }
         translate <-0.384642,  0,  0>
         scale     < 3.503966,  1,  1>
         translate <-0.109773,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  60.347246>
         rotate    < 0, -123.690068,  0>
         translate < 0.200000,  1.900000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.280000,  0.280000,  0.280000>
            translate < 0.080000,  2.280000, -0.280000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.275907}
            plane { x, 0.197076 inverse}
         }
         translate <-0.275907,  0,  0>
         scale     < 5.783868,  1,  1>
         translate <-0.047703,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  42.958491>
         rotate    < 0, -98.365886,  0>
         translate < 0.080000,  2.280000, -0.280000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.200000,  0.200000,  0.200000>
            translate < 0.030000,  2.600000,  0.060000>
      }

      object { Connector_2  texture { SPONGY }
          clipped_by {
            plane { x, 0.173770}
            plane { x, 0.086885 inverse}
         }
         translate <-0.173770,  0,  0>
         scale     < 1.754993,  1,  1>
         translate <-0.099015,  0,  0>
         rotate    < 0,  180,  0>
         rotate    < 0,  0,  81.950533>
         rotate    < 0,  135,  0>
         translate < 0.030000,  2.600000,  0.060000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.100000,  0.100000,  0.100000>
            translate < 0.010000,  2.800000,  0.040000>
      }
      bounded_by { Dot scale 2.417294 translate < 0.450000,  1.075000, -0.217500> }
   }

//---------------------RIGHT---------------------------
#declare LEAF_RIGHT = 
   object { LEAF_R
      bounded_by { Dot scale 2.417294 translate < 0.450000,  1.075000, -0.217500> }
   }

//----------------- THE STEM -------------------------------
#declare STEM =
   union {
      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  2.280000, -0.280000>
      }

      object { Connector_1
         scale     < 0.420476,  0.140000,  0.140000>
         rotate    < 0,  0, -64.653824>
         rotate    < 0,  90,  0>
         translate < 0,  2.280000, -0.280000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  1.900000, -0.460000>
      }

      object { Connector_1
         scale     < 0.316228,  0.140000,  0.140000>
         rotate    < 0,  0, -71.565051>
         rotate    < 0,  90,  0>
         translate < 0,  1.900000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  1.600000, -0.560000>
      }

      object { Connector_1
         scale     < 0.300000,  0.140000,  0.140000>
         rotate    < 0,  0, -90>
         translate < 0,  1.600000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  1.300000, -0.560000>
      }

      object { Connector_1
         scale     < 0.332415,  0.140000,  0.140000>
         rotate    < 0,  0, -83.088773>
         rotate    < 0, -90,  0>
         translate < 0,  1.300000, -0.560000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  0.970000, -0.520000>
      }

      object { Connector_1
         scale     < 0.276586,  0.140000,  0.140000>
         rotate    < 0,  0, -77.471192>
         rotate    < 0, -90,  0>
         translate < 0,  0.970000, -0.520000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  0.700000, -0.460000>
      }

      object { Connector_1
         scale     < 0.412311,  0.140000,  0.140000>
         rotate    < 0,  0, -75.963757>
         rotate    < 0, -90,  0>
         translate < 0,  0.700000, -0.460000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0,  0.300000, -0.360000>
      }

      object { Connector_1
         scale     < 0.468615,  0.140000,  0.140000>
         rotate    < 0,  0, -39.805571>
         rotate    < 0, -90,  0>
         translate < 0,  0.300000, -0.360000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
      }

      object { Connector_1
         scale     < 0.951315,  0.140000,  0.140000>
         rotate    < 0,  0, -39.882685>
         rotate    < 0, -90,  0>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.140000,  0.140000,  0.140000>
            translate < 0, -0.610000,  0.730000>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.159913}
            plane { x, 0.139924 inverse}
         }
         translate <-0.139924,  0,  0>
         scale     < 30.397368,  1,  1>
         translate < 0.004603,  0,  0>
         rotate    < 0,  0, -27.407575>
         rotate    < 0, -90,  0>
         translate < 0, -0.610000,  0.730000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.160000,  0.160000,  0.160000>
            translate < 0, -0.890000,  1.270000>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.164996}
            plane { x, 0.159996 inverse}
         }
         translate <-0.159996,  0,  0>
         scale     < 148.926156,  1,  1>
         translate < 0.001074,  0,  0>
         rotate    < 0,  0, -14.782726>
         rotate    < 0, -90,  0>
         translate < 0, -0.890000,  1.270000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.165000,  0.165000,  0.165000>
            translate < 0, -1.080000,  1.990000>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.184920}
            plane { x, 0.164929 inverse}
         }
         translate <-0.164929,  0,  0>
         scale     < 34,  1,  1>
         translate < 0.004851,  0,  0>
         rotate    < 0,  0, -1.684684>
         rotate    < 0, -90,  0>
         translate < 0, -1.080000,  1.990000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.185000,  0.185000,  0.185000>
            translate < 0, -1.100000,  2.670000>
      }

      object { Connector_1
         scale     < 0.565155,  0.185000,  0.185000>
         rotate    < 0,  0,  13.298570>
         rotate    < 0, -90,  0>
         translate < 0, -1.100000,  2.670000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.185000,  0.185000,  0.185000>
            translate < 0, -0.970000,  3.220000>
      }

      object { Connector_1
         scale     < 0.505668,  0.185000,  0.185000>
         rotate    < 0,  0,  24.537728>
         rotate    < 0, -90,  0>
         translate < 0, -0.970000,  3.220000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.185000,  0.185000,  0.185000>
            translate < 0, -0.760000,  3.680000>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.199923}
            plane { x, 0.184929 inverse}
         }
         translate <-0.184929,  0,  0>
         scale     < 36.121708,  1,  1>
         translate < 0.005120,  0,  0>
         rotate    < 0,  0,  37.504142>
         rotate    < 0, -90,  0>
         translate < 0, -0.760000,  3.680000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.200000,  0.200000,  0.200000>
            translate < 0, -0.430000,  4.110000>
      }

      object { Connector_2  texture { SPONGY } 
          clipped_by {
            plane { x, 0.249004}
            plane { x, 0.199204 inverse}
         }
         translate <-0.199204,  0,  0>
         scale     < 11.171392,  1,  1>
         translate < 0.017832,  0,  0>
         rotate    < 0,  0,  50.063617>
         rotate    < 0, -90,  0>
         translate < 0, -0.430000,  4.110000>
      }

      object { Dot  texture { SPONGY }
            scale     < 0.250000,  0.250000,  0.250000>
            translate < 0,  0,  4.470000>
      }
      bounded_by { Dot scale 3.621382 translate < 0,  0.567500,  2.010000> }
   }

//---------------------- PUT BOTH HALFS TOGETHER -----------------------
#declare THE_LEAF =
union {
  object { LEAF_RIGHT }
  object { LEAF_LEFT }
}

#declare LEAF_N_STEM = 
union {
  object { THE_LEAF scale <1, 1, 0.5> translate y*0.5 }
  object { STEM scale <0.8, 1, 1> }
  translate z*-4.47
  rotate z*180
  rotate x*40
}

#declare PLANT1 =
union {
  object { LEAF_N_STEM }
  object { LEAF_N_STEM rotate y*90 }
  object { LEAF_N_STEM rotate y*180 translate -y }
  object { LEAF_N_STEM rotate y*270 }
  object { LEAF_N_STEM rotate y*60  translate y*2 }
  object { LEAF_N_STEM rotate y*150 translate y*1.5 }
  object { LEAF_N_STEM rotate y*240 translate y*2 }
  object { LEAF_N_STEM rotate y*330 translate y*2 }
  object { LEAF_N_STEM rotate y*20  translate y*4 }
  object { LEAF_N_STEM rotate y*110 translate y*3 }
  object { LEAF_N_STEM rotate y*200 translate y*4 }
  object { LEAF_N_STEM rotate y*290 translate y*3.5 }
  object { LEAF_N_STEM rotate y*100 translate y*5 }
  object { LEAF_N_STEM rotate y*200 translate y*6 }
  object { LEAF_N_STEM rotate y*260 translate y*6 }
  object { LEAF_N_STEM rotate y*10  translate y*5.5 }
  object { LEAF_N_STEM rotate y*40  translate y*8 }
  object { LEAF_N_STEM rotate y*130 translate y*7 }
  object { LEAF_N_STEM rotate y*230 translate y*8 }
  object { LEAF_N_STEM rotate y*310 translate y*7.5 }
  object { LEAF_N_STEM rotate y*110 translate y*9 }
  object { LEAF_N_STEM rotate y*190 translate y*10 }
  object { LEAF_N_STEM rotate y*280 translate y*10 }
  object { LEAF_N_STEM translate y*-9.5 }
  object { LEAF_N_STEM rotate y*82  translate y*12 }
  object { LEAF_N_STEM rotate y*170 translate y*11 }
  object { LEAF_N_STEM rotate y*250 translate y*12 }
  object { LEAF_N_STEM rotate y*350 translate y*11.5 }
  bounded_by { Y_Disk scale <10, 25, 10> translate y*-20 }
}