/*
 * Concept (20101109): wooden disks with hexagonal truchet tiling, - floating on water o placed on sand? - with a little figure mumbling? - with some marbles into?
 * 20101111
 * 20101112
 *
 * @todo	A better sand
 *
 * Credits: Odd macro http://www.spiritone.com/~english/cyclopedia/walk.html 
 *			Drop_From_Point from POV-Wiki
 */
#include "functions.inc"
#include "transforms.inc"
 
#local from_top=0;      //0: standard camera - 1: top camera
#local adapt_camera=0;  //0: adapt camera - 1: fixed camera
#local same_texture=0;  //0: each tile has a random texture modifier - 1: each tile has the same texture - 2:  each tile has the same texture with a different texture for the truchet tile
#local on_plane=0;      //0: on a plane - 1: on a surface
#local golden_sand=0;   //0: brown sand - 1: golden sando
 
global_settings {
  assumed_gamma 1.0
}
// ----------------------------------------

camera {
    #if(from_top=1)
    	orthographic
    	location 5*y
    #else
    	#if(adapt_camera=1)
	        location  <0.0, 1.9, -3.0>
	        location  <0.0, 1.9, -4.0>
	        direction 1.5*z
	        right     x*image_width/image_height
        #else
	        location  <0.0, 2, -2.0>
        #end
    #end
    look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}
// ----------------------------------------

//Thanks to--------------------------------
//http://www.spiritone.com/~english/cyclopedia/walk.html
#macro Odd(a)
  #local o = 1;
  #local i = int(a)/2;
  #if ( i = (int(i)) ) 
    #local o = 0;
  #end
  o 
#end

// From pov-wiki ---------------------------------------------
#macro Drop_From_Point(Surface, Object, Point, Direction, AdjustNormal)
    //Allow the user to pass scalars as vectors
    #local Point = Point + <0,0,0>;

    //Trace onto the surface
    #local N = <0,0,0>;
    #local S = trace(Surface, Point, Direction, N);
    //#local S = trace(Surface, Point, <0,0,0>-Point, N);

    //Check if we hit the surface
    #if (vlength(N)>0)
        //place the object
        object {
            Object
   
			//Adjust the Normal if the user wants us to
			#if (AdjustNormal) Reorient_Trans(y,N) #end
			//Translate to final position
			translate S
        }
    #end
#end
// --
// ----------------------------------------

//Textures --------------------------------
// Reference from textures.inc
#declare DMFLightOak =  
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.1 rgb <0.42, 0.26, 0.15>]
        [0.9 rgb <0.52, 0.37, 0.26>]
    }
}

// From Moray - Dark_Green_Glass
#declare Dark_Green_Glass = material {   
  texture {      
     pigment {
        color rgbf <0.1, 0.7, 0.8, 0.8>
     }      
     finish {
        ambient 0.1
        diffuse 0.1
        specular 1.0
        roughness 0.001
        reflection {
           0.25 , 0.25
           fresnel  off
           falloff  1.0
           exponent 1.0
           metallic 0.0
        }
     }
  }   
  interior {
     ior 1.5
  }
}

// From Moray - Crystal
#declare Crystal = material {
  texture {      
     pigment {
        color rgbf <0.98, 0.98, 0.98, 0.9>
     }      
     finish  {
        ambient 0.1
        diffuse 0.1
        phong 1.0
        phong_size 100.0
        specular 0.8
        roughness 0.0003
        reflection {
           0.1 , 0.1
           fresnel  off
           falloff  1.0
           exponent 1.0
           metallic 0.0
        }
     }
  }   
  interior {
     ior 1.45
  }
}

#declare f_marb=finish{
    ambient 0.1
    diffuse 0.1
    phong 1.0
    phong_size 100.0
    specular 0.8
    roughness 0.0003
    reflection {
       0.1 , 0.1
       fresnel  off
       falloff  1.0
       exponent 1.0
       metallic 0.0
    }
}

#declare i_marb=interior {
     ior 1.45
}


#declare t_tile=texture{pigment{color rgb z}};
#declare t_truchet=texture{pigment{color rgb y}};

#declare t_tile = texture{
    pigment {
        wood
        turbulence 0.05            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.3
        color_map {
            [0.1 rgb <0.42, 0.26, 0.15>]
            [0.9 rgb <0.52, 0.37, 0.26>]
        }
    }
    normal {
        wood
        turbulence 0.05            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.3
    }
    rotate 90*x
}

#declare t_truchet = texture{
    pigment {
        wood
        turbulence 0.05            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.3
        color_map {
            [0.1 rgb <0.42, 0.26, 0.15>]
            [0.9 rgb <0.52, 0.37, 0.26>]
        }
    }
    normal {
        wood
        turbulence 0.05            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.3
    } 
    rotate 90*x
}

#declare t_bark = texture{
    pigment {
        wood
        turbulence 0.12            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.63
        color_map {
            [0.1 rgb <0.42, 0.26, 0.15>*0.3]
            [0.9 rgb <0.52, 0.37, 0.26>*0.2]
        }
    }
    normal {
        wood
        turbulence 0.12            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        scale 0.63
    }
    //rotate 90*x
}
                 
#declare t_sandish=texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.941176, 0.878431, 0.792157, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        scale  0.01
     }
    //finish { crand 0.1 }
}

#declare t_golden_sand=texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <1, 0.827, 0.141, 0.0, 0.0> ]
           //[ 1.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.470588, 0.305882, 0.121569, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        scale  0.01
     }
}

#if(golden_sand)
	#declare t_sand=t_golden_sand;
#else
	#declare t_sand=t_sandish;
#end


#declare t_h=texture {
    pigment {
      agate
      color_map {
			 	[0.0 rgb 0]
			 	[0.12 rgb <0.57,0.825,0.35>*.8]
			 	[0.6 rgb <0.57,0.825,0.35>*0.4]
      }
      scale .25
      turbulence 0.2
    }
    normal { agate 0.75 scale 0.25  turbulence 0.2}
    finish { phong 0.1 } 
	scale 0.01
}
/*
#declare t_h=texture{
    gradient y
    texture_map{
        [0.3  t_h scale 10]
        [0.6  pigment{rgb x+y} finish{phong 1}]
        [1.0  t_h scale 10]
        //[1.0  t_h finish{ambient .2 diffuse .8]
    }
    scale 0.1
    
}
*/

#declare t_sandish_h=texture {
    pigment {
      agate
      color_map {
           [ 0.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.941176, 0.878431, 0.792157, 0.0, 0.0> ]
      }
      scale .25
      turbulence 0.2
    }
    normal { agate 0.75 scale 0.25  turbulence 0.2}
    finish { phong 0.1 } 
	scale 0.01
}
#declare t_golden_h=texture {
    pigment {
      agate
      color_map {
           [ 0.0     rgbft <1, 0.827, 0.141, 0.0, 0.0> ]
           //[ 1.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.470588, 0.305882, 0.121569, 0.0, 0.0> ]
      }
      scale .25
      turbulence 0.2
    }
    normal { agate 0.75 scale 0.25  turbulence 0.2}
    finish { phong 0.1 } 
	scale 0.01
}

#if(golden_sand)
	#declare t_sand=texture{t_golden_h scale 2};
#else
	#declare t_sand=texture{t_sandish_h scale 2};
#end



// ----------------------------------------

// Objects --------------------------------
// Base tile
#declare r_tile=0.5;
#declare h_tile=0.2*r_tile;
#declare w_tile=cylinder{
	<0,0,0>, <0,h_tile,0>, r_tile
	#if(same_texture=1)
		texture{t_tile}
	#end
	};

// Base tile with bark
#declare p_trunk=0.94;
#declare w_tile=union{
	cylinder{<0,0,0>, <0,h_tile,0>, r_tile*p_trunk
	#if(same_texture=1)
		texture{t_tile}
	#end
	}
	difference{
		cylinder{<0,0,0>, <0,h_tile,0>, r_tile}
		cylinder{<0,-0.1,0>, <0,h_tile+0.1,0>, r_tile*p_trunk}
		texture{t_bark}
	}
};

// Base tile with the Truchet tiling
#declare r_base=r_tile/sqrt(3);
#declare r_in=0.2*r_base;
#declare w_tile=difference{
	object{w_tile}
	union{
		torus{r_base r_in translate <-r_base*2,h_tile,0>}
		torus{r_base r_in translate <r_base,h_tile,r_tile>}
		torus{r_base r_in translate <r_base,h_tile,-r_tile>}
        #if(same_texture=1)
		    texture{t_truchet}
		#end
	}
	#if(same_texture=2)
		texture{t_tile}
	#end
};

// Very small dunes
#declare sand=isosurface {
	function {
		y-sin(x*3*pi)*0.1-f_noise3d(x,y,z)-sin(z*2*pi)*0.1*f_noise3d(0,0,z)
	}
	accuracy 0.01
  	contained_by {box {<-2,-0.6,-2>, <2, 1.2, 2>}}
  	max_gradient 2.0
}
#declare sand=object{sand
  	translate <0,-0.2,0>
  	scale<6,0.4,6>
 }

// ----------------------------------------

// Scene ----------------------------------
// Small dunes
plane {
	y, 0
  	texture {t_sand}
}
object {sand
  	texture {t_sand}
}     

// Tiles placement
#declare iXstart=-4;
#declare iXmax=4;
#declare iZstart=-3;
#declare iZmax=6;

/*
#declare iXstart=-2;
#declare iXmax=3;
#declare iZstart=-1;
#declare iZmax=4;
*/

#declare S1=seed(30047); // ;-)
#declare rnd_trig=0.5;
#declare rnd_marble=0.8;

#local iX=iXstart;    

#while(iX<=iXmax)
	#local iZ=iZstart;
	#while(iZ<=iZmax)
		#local rota=0;
		#if(rand(S1)<=rnd_trig)
			#local rota=60;
		#end
		//What are we placing?
		#local to_be_placed=union{
			//The tile
	  		object{w_tile
		  		#if(same_texture=0)
		  			texture{t_tile scale 1.2-0.8*rand(S1) rotate 360*rand(S1)*y}
		  		#end
		  	}
		  	//A marble?
		  	#if(rand(S1)<=rnd_marble)
		  		#local alfa=(120*rand(S1)-60)*pi/180;
		  		sphere{0 r_in translate <-r_base*2,h_tile,0> translate <r_base*cos(alfa),0,r_base*sin(alfa)> material{texture{pigment{color rgbf<0.5+0.5*rand(S1),0.5+0.5*rand(S1),0.5+0.5*rand(S1),0.9>} finish{f_marb}} interior{i_marb}}}      		  		
		  		
		  	#end
  			#if(on_plane=0)
  				rotate <3*rand(S1),0,2*rand(S1)>
  				//ToDo: adjust translation
  			#end
  			rotate rota*y
  		};
  		// Where is the initial position?
  		#local start_point=<r_tile*sqrt(3)*iX,20,2*r_tile*iZ+r_tile*Odd(iX)>;
		// Where place and orient them?
		Drop_From_Point(sand, to_be_placed, start_point, -y, on)
		#local iZ=iZ+1;
	#end
	#local iX=iX+1;
#end
