/*

 rounded_lprism_single.pov

 An example showing how to make a single rounded_lprism object without holes.

*/


// **** example ****

#include "rounded_lprism.inc"

// our object has only one point set
#declare pts = array[1]{
 
 // the outside points go clockwise
 // remember, the structure is this: < xpos, ypos, point_radius >
 array[4]{
  <-1, -1,  0>,
  <0,  1,   0.5>,
  <1,  -1,  0>,
  <0,  0,   0>
 }
 
}

// here we place the object
object{
 rounded_lprism_autofit(pts, -0.5, 0.5, 0, 0.07)
  
 // you don't always have to pre-declare your arrays, this also works:
 // rounded_lprism_autofit( array[1]{array[4]{<-1,-1,0>,<0,1,.5>,<1,-1,0>,<0,0,0>}}, -0.5, 0.5, 0, 0.07 )
 
 pigment{rgb x}
 finish{phong 1}
}

// this cage lets us visualize the linear point set
object{
 rounded_lprism_cage(pts, -0.5, 0.5, 5/image_width)
 pigment{rgb x+y}
}

// **** end example ****



plane{y,-1-5/image_width pigment{rgb .5}}

light_source{<-.25,1,-.5>*100000, 1.5}

camera{
 look_at 0
 location <3,5,-10>
 angle 19
}