/*

 rounded_lprism_holes.pov

 An example showing how to make a rounded_lprism object with holes.

*/


// **** example ****

#include "rounded_lprism.inc"

// our object has three point sets
// the first point set is always the containing object, the rest are always holes
#declare pts = array[3]{
 
 // the outside points go clockwise
 array[4]{
  <-1, -1,  .01>,
  <-1,  1,  0>,
  <1,   1,  .01>,
  <1,  -1,  0>
 },
 
 // a hole
 // the inside points go counter-clockwise
 array[4]{
  <-.5, -.25, 0>,
  <.5,  -.25, 0>,
  <.5,   .75, 0>,
  <-.5,  .75, 0>
 },
 
 // another hole
 array[4]{
  <-.125, -.75, 0>,
  <.125,  -.75, 0>,
  <.125,  -.5, 0>,
  <-.125, -.5,  0>
 }
 
}

// here we use the autofit_chamfered version
object{
 rounded_lprism_autofit_chamfered(pts, -0.5, 0.5, 1, 0.05)
 pigment{rgb x}
 finish{phong 1}
}

// this cage lets us visualize the linear point set
object{
 rounded_lprism_cage(pts, -0.5, 0.5, 5/image_width)
 pigment{rgb x+y}
}

// **** end example ****



plane{y,-1-5/image_width pigment{rgb .5}}

light_source{<-.25,1,-.5>*100000, 1.5}

camera{
 look_at 0
 location <3,5,-10>
 angle 19
}