/*

 rounded_lprism_holefill.pov

 An example showing how to make a hole and then fill it with another rounded_lprism object.

*/


// **** example ****

#include "rounded_lprism.inc"
#include "arrays.inc"

// our first object has two point sets
// the first point set is always the containing object, the rest are always holes
#declare pts = array[2]{
 
 // the outside points go clockwise
 array[4]{
  <-1, -1,  0>,
  <-1,  1,  1>,
  <1,   1,  0>,
  <1,  -1,  1>
 },
 
 // the hole in question
 // the inside points go counter-clockwise
 array[4]{
  <-.5, -.5, 0>,
  <.5,  -.5, 1>,
  <.5,   .5, 0>,
  <-.5,  .5, 1>
 }
 
}

// here we place our first object (red)
object{
 rounded_lprism_autofit_chamfered(pts, -0.2, 0.2, 0, 0.05)
 pigment{rgb x}
 finish{phong 1}
}

// we reverse the hole's point set by using a macro from arrays.inc
Reverse_Array(pts[1])

// and we place the new object with the reversed array (blue)
object{
 rounded_lprism_autofit_chamfered( array[1]{ pts[1] }, -0.2, 0.2, 0, 0.05)
 pigment{rgb z}
 finish{phong 1}
}

// **** end example ****



plane{y,-1-5/image_width pigment{rgb .5}}

light_source{<-.25,1,-.5>*100000, 1.5}

camera{
 look_at 0
 location <3,5,-10>
 angle 19
}