/*

 rounded_lprism_free.pov

 With the free version, you can use larger radii for your points.

*/


// **** example ****

#include "rounded_lprism.inc"

// our object has only one point set
#declare pts = array[1]{
 
 // the outside points go clockwise
 array[4]{
  <-1, -1,  0>,
  <-1,  1,  0>,
  <1,  1,   2-0.07>, // 2 minus bevel
  <1,  -1,  0>
 }
 
}

// here we place the object
object{
 rounded_lprism_free(pts, -0.5, 0.5, 0, 0.07)
  
 pigment{rgb x}
 finish{phong 1}
}

// this cage lets us visualize the linear point set
object{
 rounded_lprism_cage(pts, -0.5, 0.5, 5/image_width)
 pigment{rgb x+y}
}

// **** end example ****



plane{y,-1-5/image_width pigment{rgb .5}}

light_source{<-.25,1,-.5>*100000, 1.5}

camera{
 look_at 0
 location <3,5,-10>
 angle 19
}