/*

 lbViewPoints.pov
 
 Use this file to view different point sets to get an idea of what the
 final effect will look like. Render at 512x384 or greater.
 
 copy and paste these:
 "lbPtsCross.inc"     - an equidistant cross
 "lbPtsDisc.inc"      - a disc with falloff
 "lbPtsDiscHQ.inc"    - a higher-quality version of lbPtsDisc
 "lbPtsLinear.inc"    - a straight line
 "lbPtsSquashed.inc"  - kind of a mix between lbPtsDisc and lbPtsLinear
 "lbPtsStar.inc"      - a six-pointed star
 "lbPtsStarburst.inc" - a semi-random starburst
                                            
*/


// enter the file name you wish to view here
#declare input_file_name = "lbPtsStarburst.inc"

// change size of point representation
#declare point_size = .01;


// ...

default{finish{ambient 1}}

camera{
 orthographic
 location -z*10
 look_at 0
 angle 15
}

#include input_file_name

// displays the points
union{
 #declare V=0;
 #declare R=seed(1234);
 #while(V<dimension_size(lb_pts,1))
  sphere{<lb_pts[V].x,lb_pts[V].y,rand(R)*.01>,point_size pigment{rgb 1 transmit 1-lb_pts[V].z}}
  #declare V=V+1;
 #end
 translate -x*.5/1.5
}

// red frame
union{
 box{<-1,-1,1.1>,<1,1,2> scale<.975,.975,1>pigment{rgb x*.75}}
 box{<-1,-1,1>,<1,1,2> scale<.96,.96,1>}
 translate -x*.5/1.5
}

#declare text_object_file_name=
text{ttf"crystal.ttf" input_file_name 1 0 scale .1}

#declare text_object_num_points=
text{ttf"crystal.ttf" concat("point count: ",str(dimension_size(lb_pts,1),0,0)) 1 0 scale .1}

#declare text_union=
union{
 text{ttf"crystal.ttf" "viewing" 1,0 scale .1 translate<(1.25-max_extent(text_object_file_name).x),.95-max_extent(text_object_file_name).y,0>}
 object{text_object_file_name translate<(1.25-max_extent(text_object_file_name).x),.95-max_extent(text_object_file_name).y-.1,0>}
 object{text_object_num_points translate<(1.25-max_extent(text_object_num_points).x),-1+max_extent(text_object_num_points).y,0>}
}

// white text
object{text_union pigment{rgb 1}}

// black text border
#declare V=0;
#while(V<8)
 object{text_union matrix<1,0,0,0,1,0,sin(pi/4*V)*.25,cos(pi/4*V)*.25,1,0,0,0> translate z*.1}
 #declare V=V+1;
#end