// Persistence of Vision Ray Tracer Scene Description File
// File: mbsdl.inc
// Vers: 3.6.1, 3.7
// Desc: Mandelbulb Functions in POV-Ray Scene Description Language
// Date: 12/18/09, 12/27/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html
// Cite: http://www.bugman123.com/Hypercomplex/index.html
// Cite: http://www.fractalforums.com/videos/3d-mandelbrot-set-phase-shift-animations/
// Cite: http://math.unipa.it/~grim/Jbarrallo.PDF

// WARNING: Include this file first in a scene.
// WARNING: This recursive function is invalid SDL and can crash POV-Ray.

#ifndef(Mbsdl_Inc_Temp)
#declare Mbsdl_Inc_Temp = version;
#version 3.6;

#ifdef(View_POV_Include_Stack)
#   debug "including mbsdl.inc\n"
#end

//This is based on the consistent Positive Z-Component mandelbulb function,
// (when all three powers are the same) with phase shift (Phi) by Paul Nylander,
// and my smooth return value formulation based on the Normalized Iteration Count algorithm.
// Use phase=pi for Daniel White's original formula, as generalized by Paul Nylander.
// Use phase = -pi/2 for the Cosine Variation.
//     {x,y,z}n = rn{cos(theta)cos(phi),sin(theta)cos(phi),sin(phi)}, r=sqrt(x^2+y^2+z^2),
//     theta=n tan-1(y/x), phi=n sin-1(z/r)+Phi

#declare mbsdl_recurse = function( mbsdl_r_p_r, mbsdl_r_p_theta, mbsdl_r_p_phi, mbsdl_r_phase, mbsdl_r_i,mbsdl_r_i_bailout, mbsdl_r_r2_bailout, x,y,z, mbsdl_r_x,mbsdl_r_y,mbsdl_r_z) {
   select(mbsdl_r_i > mbsdl_r_i_bailout | pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) >mbsdl_r_r2_bailout, 0, 
      mbsdl_recurse( mbsdl_r_p_r,mbsdl_r_p_theta, mbsdl_r_p_phi, mbsdl_r_phase, mbsdl_r_i+1,mbsdl_r_i_bailout, mbsdl_r_r2_bailout, x,y,z,
      
         x + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * cos( atan2(mbsdl_r_y, mbsdl_r_x) * mbsdl_r_p_theta )
             * cos( atan2(mbsdl_r_z, sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)) )
                    * mbsdl_r_p_phi + mbsdl_r_phase),
          
         y + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * sin( atan2(mbsdl_r_y, mbsdl_r_x) * mbsdl_r_p_theta)
             * cos( atan2(mbsdl_r_z, sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)) )
                    * mbsdl_r_p_phi + mbsdl_r_phase),
           
         z + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * sin( atan2(mbsdl_r_z, sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)) )
             * mbsdl_r_p_phi + mbsdl_r_phase)
      ),
      1/( mbsdl_r_i+log(log(mbsdl_r_r2_bailout) / log((mbsdl_r_i>(mbsdl_r_i_bailout-1))+pow(mbsdl_r_x,2)+pow(mbsdl_r_y,2)+pow(mbsdl_r_z,2))) / log(mbsdl_r_p_r) )
   )//end recursion select loop
};

#declare f_mandelbulb = function(x,y,z, mbsdl_f_p_r, mbsdl_f_p_theta, mbsdl_f_p_phi, mbsdl_f_phase, mbsdl_f_i_bailout, mbsdl_f_r_bailout){
    mbsdl_recurse( mbsdl_f_p_r, mbsdl_f_p_theta, mbsdl_f_p_phi,mbsdl_f_phase,1,int(mbsdl_f_i_bailout-1), pow(mbsdl_f_r_bailout,2), x,y,z, x,y,z)
};

#version Mbsdl_Inc_Temp;
#end//mbsdl.inc
