// Persistence of Vision Ray Tracer Scene Description File
// File: mb_powers.pov
// Vers: 3.6.1, 3.7
// Desc: Example Showing Mandelbulb Powers 1-7
// Date: 12/18/09, 12/27/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html
// Cite: http://www.bugman123.com/Hypercomplex/index.html

// Render at 4:3.

#if(file_exists("mbsdl.inc"))
#debug "NOTICE: Using mandelbulb recursive SDL function.\n"
#include "mbsdl.inc" // Include this first.
#end
#ifndef(Mbsdl_Inc_Temp)
#debug "NOTICE: Using mandelbulb internal function patch.\n"
#declare f_mandelbulb=function{internal(79)};
#end

#include "stage1.inc"

#local mb_power = 8 ;

#local mb_phase = 0 ;
#while(mb_phase < 2*pi)

isosurface{
   function{f_mandelbulb(x,y,z, mb_power,mb_power,mb_power, mb_phase, 3, 3)}
   threshold    1/3
   max_gradient 25
   accuracy     0.001
   contained_by{sphere{<0,0,0>,1.5}}
   texture{
      pigment{White}
      }
   translate <2.5*cos(mb_phase),1.5*sin(mb_phase),0>
   }

#local mb_phase = mb_phase +pi/2;

#end
