// Persistence of Vision Ray Tracer Scene Description File
// File: mb_multi_p.pov
// Vers: 3.6.1, 3.7
// Desc: Example Showing Mandelbulb Power Combinations
// Date: 12/18/09, 12/27/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html
// Cite: http://www.bugman123.com/Hypercomplex/index.html
//
// This scene shows the results of combining two different powers in each 'bulb.
// Some attempt is made to keep the feature size about the same for all six combinations shown.

#if(file_exists("mbsdl.inc"))
#debug "NOTICE: Using mandelbulb recursive SDL function.\n"
#include "mbsdl.inc" // Include this first.
#end
#ifndef(Mbsdl_Inc_Temp)
#debug "NOTICE: Using mandelbulb internal function patch.\n"
#declare f_mandelbulb=function{internal(79)};
#end

#include "stage1.inc"

#local mb_power = array[2];
#local mb_power[0]     =  8  ;// This is the power common to all 'bulbs.
#local mb_power[1]     =  5  ;// This is the other power.

#local mb_i_target     =  3  ;// Target number of iterations.

// Set parameters for the first 'bulb in the upper-left corner.
#local mb_bulb_number  =  1  ;
#local mb_x            = -2.5;
#local mb_y            =  1.7;

#while(mb_bulb_number < 7)

#local mb_p_r     = mb_power[mod(mb_bulb_number,8)/4];
#local mb_p_theta = mb_power[mod(mb_bulb_number,4)/2];
#local mb_p_phi   = mb_power[mod(mb_bulb_number,2)]; 

#local mb_iterations = int(mb_i_target - (mb_p_theta+mb_p_phi)/max(mb_power[0],mb_power[1]) +2.5);

#debug concat("Bulb Number: " , str(mb_bulb_number, 2,0),
            "; iterations: "  , str(mb_iterations,  4,1),
            "; p_r: "         , str(mb_p_r,         4,1),
            "; p_theta: "     , str(mb_p_theta,     4,1),
            "; p_hi: "        , str(mb_p_phi,       4,1), ".\n")
isosurface{
   function{f_mandelbulb(x,y,z, mb_p_r,mb_p_theta,mb_p_phi, -pi/2, mb_iterations, 3)}
   threshold    1/(1.01*mb_iterations)
   max_gradient 10
   accuracy     0.001
   contained_by{sphere{<0,0,0>,1.2}}// Lower power mandelbulbs do not fit in this.
   texture{
      pigment{White}
      }
   translate <mb_x,mb_y,0>
   }

#local mb_x = mb_x +2.6;

#if(mb_x > 3)
#local mb_x = -2.5;
#local mb_y = mb_y -3;
#end

#local mb_bulb_number = mb_bulb_number +1;
#end//looping through the 'bulbs.
