// +W1024 +H768 +A0.1
/* 
 * Chrismas 2009
 * Paolo Gibellini
 *
 * Credits:
 * - DAZ reindeer (sorry, no time to model one)
 * - Texture and camera modifier from Rune's POV-Ray sample file "Black and White Stripes"
 *
 */
 
//--------------------------------------------------------------------------
global_settings {
    assumed_gamma 1.2
}

#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "math.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "metals.inc"
#include "golds.inc"
//--------------------------------------------------------------------------

// camera ------------------------------------------------------------------
camera {angle 75 location  <0.0 , 1.0 ,-2.0> right x*image_width/image_height look_at   <0.0 , 1.0 , 0.0>}

// A small sphere around the camera location with a
// contrast enhasing texture.
// (Also try to render with this sphere commented out
// to see how the scene looks without the filter.)
sphere {
   <0.0 , 1.0 ,-2.0>, 0.001 hollow
   pigment {color rgb 0.5 transmit 100}
   finish {ambient 1 diffuse 0}
}

// A light source
light_source {<0,10,0>, color 1}

#default {
   texture {
      pigment {
         gradient y
         triangle_wave
         color_map {[0, rgb 0.5][1, rgb 1.0]}
         scale 0.3 rotate 20
      }
      finish {ambient 0.55 diffuse 0.25}
   }
}

#declare t_stripes=texture {
      pigment {
         gradient y
         triangle_wave
         color_map {[0, rgb 0.5][1, rgb 1.0]}
         scale 0.05 rotate 20
      }
      finish {ambient 0.55 diffuse 0.25}
}


// sky -------------------------------------------------------------- 
plane{<0,1,0>,1 hollow
texture{pigment {rgb 1}  } scale 10000}
//-------------------------------------------------------------------------- 


// Settings ================================================================
// Segment radius 
#declare R1=0.5;
#declare r1=0.1;
#declare Sr=seed(123);
#local rotmax=30;

// Trunk radius
#declare T1=0.12;
#declare t1=0.07;
#declare t_shift=4;

// Star miscellaneous
#declare s_scale=0.8;
#declare r3=sqrt(3);
// =========================================================================
  
// Objects -----------------------------------------------------------------  
// Mountain
#declare mountain=height_field{ tga "MountLo3.tga" smooth double_illuminate
              translate<-0.5,-0.001,-0.5>
              rotate<0,-70,0>
              scale<100,5,100>
              //texture{t_snow}
              translate<2,0,30>
}

// Base leaves slice
#declare tree_segment=union {
	cylinder{<0,-r1,0> <0,r1,0> R1}
	torus{R1 r1}
}

// Tree
#macro tree(n_seg, t_seg, t_trnk)
	#local i=0;
	#local transy=0;
	union {
		//Leaves
		union{
		#while(i<n_seg)
			#local rotx=rand(Sr)*rotmax-rotmax/2;
			#local rotz=rand(Sr)*rotmax-rotmax/2;
			//#local transy=i*2*r1;
			#local transy=transy+2*r1-pow(0.8,i)*R1*abs(sin(max(rotx,rotz)))/3;
			object{tree_segment scale <pow(0.8,i),1,pow(0.8,i)> rotate<rotx,0,rotz> translate <0,transy,0>}
			#local i=i+1;
		#end
			//texture{t_seg}
		}
		//Trunk
		cone{<0,-t_shift*r1,0> T1 <0,(n_seg-1)*r1,0> t1 /*texture{t_trnk}*/}
		//Center base in <0,0,0>
		translate <0,t_shift*r1,0>
	}
#end

// Sparkles
#declare sparkle=sphere { 0, 0.1
	pigment {rgbt <1,1,1,1> }
	hollow
	interior {
		media {
			emission 1
			density {
				spherical density_map {
					[0 rgb 0]
					[0.4 rgb <1,0,0>]
					[0.8 rgb <1,1,0>]
					[1 rgb 1]
				}
			}
		}
	}
} 

// Stars
#declare s_base=prism {
    linear_sweep
    cubic_spline
    -0.1,
    0.1,
    6,
    <0,0.5>, <0.5,0.5*(1-r3)>, <-0.5,0.5*(1-r3)>,
    <0,0.5>, <0.5,0.5*(1-r3)>, <-0.5,0.5*(1-r3)>
    // Centered on <0,0,0>
    translate (1/r3-1/2)*z
}

// Star type 1
#declare esa_star_base=union {
	object{s_base}
	object{s_base rotate 180*y}
}

#declare esa_star=union {
	difference{
		object{esa_star_base}
		object{esa_star_base scale <s_scale,1.1,s_scale>}
	}
	object{esa_star_base scale <s_scale*s_scale,1.1,s_scale*s_scale>}
}

// Star type 2
#declare bitri_star=union {
	difference{
		object{s_base}
		object{s_base scale <s_scale,1.1,s_scale>}
	}
	difference{
		object{s_base}
		object{s_base scale <s_scale,1.1,s_scale>}
		rotate 180*y
	}
	object{esa_star_base scale <s_scale*s_scale*s_scale,1.1,s_scale*s_scale*s_scale> rotate 30*y}
}

// Star type 2L
#declare empty_star=union {
	difference{
		object{s_base}
		object{s_base scale <s_scale,1.1,s_scale>}
	}
	difference{
		object{s_base}
		object{s_base scale <s_scale,1.1,s_scale>}
		rotate 180*y
	}
}

// Star type 3
#declare bibitri_star=union{
	object{bitri_star scale 0.4*y}
	object{bitri_star scale 0.4*y rotate 90*z}
}

// Star type 3L
#declare empty_bitri_star=union{
	object{empty_star scale 0.4*y}
	object{empty_star scale 0.4*y rotate 90*z}
}

// Star type 4
#declare tribitri_star=union{
	object{bitri_star scale 0.1*y}
	object{bitri_star scale 0.1*y rotate 90*z}
	object{bitri_star scale 0.1*y rotate 90*x}
}

// Star type 4L
#declare empty_tribitri_star=union{
	object{empty_bitri_star scale 0.1*y}
	object{empty_bitri_star scale 0.1*y rotate 90*z}
	object{empty_bitri_star scale 0.1*y rotate 90*x}
}

// Superquadric Ellipsoid Star
#declare superelli_star=superellipsoid {<2.70,2.70>}

// Other composite
#declare spherelli_star=union{
	object{superelli_star}
	sphere{0 0.6}
};

#declare boxelli_star=union{
	object{superelli_star}
	box{-0.4 0.4}
};

#declare star_1=object{tribitri_star scale 0.1 /*texture{t_gold}*/};
#declare star_2=object{boxelli_star scale 0.1 /*texture{t_gold}*/};

#declare sparkle_star_1=union{
	object{empty_tribitri_star scale 0.1 /*texture{t_gold}*/}
	object{sparkle}
	//scale 2
};

// Snowflakes
#declare snowflake=sphere{0 0.01 /*texture{t_snow}*/}


//-------------------------------------------------------------------------- 
  
// Scene ------------------------------------------------------------------- 
// ground
plane { <0,1,0>, 0 /*texture{t_snow}*/ double_illuminate}

// Mountain
object{mountain}

// Trees zone
#declare tree_zone=box{<-20,-1,-3> <20,1,70>}

// Object placement
#declare Sb=seed(7); //4
#declare St=seed(21);
#declare Ss=seed(212);
#declare Normal=<0,0,0>;
#declare m_min=min_extent(tree_zone);
#declare m_max=max_extent(tree_zone);

#declare m_steps=40;
#declare l_steps=10;
#declare t_stop=0.25;
#declare s1_stop=0.65;
#declare ss_range=4;

// Trees, some snowflakes and sparkle stars
#local place_light=1;
#local i_light=0;
#local i=0;
#while (i<=m_steps)
	#local j=0;
	#local m_x=m_min.x+(m_max.x-m_min.x)*i/m_steps;
	#while (j<=m_steps)
		#local m_z=m_min.z+(m_max.z-m_min.z)*j/m_steps;
		//What kind of object are we placing?
		#local ra=rand(Sb);
		#local ob=object{snowflake rotate 20*y translate ss_range*rand(Ss)*y};
		#if(ra<=t_stop)
			#local ob=object{tree(6+4*rand(St),texture{t_tree pigment{color rgb <0.3,0.9-rand(St)*.2,0.2+0.6*rand(St)>}},t_trunk) translate -0.05*y};
		#end
		#if(ra>t_stop & ra<=s1_stop)
			#local ob=object{snowflake rotate 20*y translate ss_range*rand(Ss)*y};
		#end
		// Place the object
		#declare Intersection=trace(mountain, <m_x,10,m_z>, -y, Normal);
		#if(vlength(Normal) > 0)
			#local correction=rand(Sb)*2-4;
			object{ob rotate correction translate Intersection}
		#end
		// Place sparkle stars between the objects
		#declare Intersection=trace(mountain, <m_x+(m_max.x-m_min.x)*0.5/m_steps,10,m_z+(m_max.z-m_min.z)*0.5/m_steps>, -y, Normal);
		#if(vlength(Normal) > 0)
			#local correction=rand(Sb)*20-40;
			object{snowflake rotate correction translate Intersection translate ss_range*rand(Ss)*y/2}
		#end
		#local j=j+1;
	#end
	#local i=i+1;
#end


// Other snowflakes, and colored spots in an external loop
// Snow zone
#declare snow_zone=box{<-20,1,-3> <20,20,70>}
#declare m_min=min_extent(snow_zone);
#declare m_max=max_extent(snow_zone);

#declare sparkle_steps=10;
#local i=0;
#while (i<=sparkle_steps)
	#local j=0;
	#local m_x=m_min.x+(m_max.x-m_min.x)*i/sparkle_steps;
	#while (j<=sparkle_steps)
		#local k=0;
		#local m_z=m_min.z+(m_max.z-m_min.z)*j/sparkle_steps;
		#while (k<=sparkle_steps)
			#local m_y=m_min.y+(m_max.y-m_min.y)*k/sparkle_steps;
			#local correction=rand(Sb)*0.2-0.1;
			object{snowflake translate <m_x,m_y,m_z>+correction}
			#local k=k+1;
		#end
		#local j=j+1;
	#end
	#local i=i+1;
#end

//And now... a cute little reindeer?
#include "renna_POV_geom_bw.inc"
#declare r_min=min_extent(renna_);
#declare r_max=max_extent(renna_);

#declare Normal=<0,0,0>;
#declare Intersection=trace(mountain, <0,10,-1>, -y, Normal);
object{renna_ translate Intersection-(r_max.y-r_min.y)/2 translate <0.05,0.1,0> texture{t_stripes rotate 40*y}}
//--------------------------------------------------------------------------
