// Persistence of Vision Ray Tracer Scene Description File
// File: mbsdl_standalone.pov
// Vers: 3.6, 3.7
// Desc: Minimal Stand-alone Mandelbulb Scene Example
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

// WARNING: Declare this function definition first in a scene.
// WARNING: This recursive function is invalid SDL and can crash POV-Ray.

#declare mbsdl_recurse = function( mbsdl_r_p_r, mbsdl_r_p_theta, mbsdl_r_p_phi, mbsdl_r_i,mbsdl_r_i_bailout, mbsdl_r_r2_bailout, x,y,z, mbsdl_r_x,mbsdl_r_y,mbsdl_r_z) {
   select(mbsdl_r_i > mbsdl_r_i_bailout | pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) >mbsdl_r_r2_bailout, 0, 
      mbsdl_recurse( mbsdl_r_p_r,mbsdl_r_p_theta, mbsdl_r_p_phi, mbsdl_r_i+1,mbsdl_r_i_bailout, mbsdl_r_r2_bailout, x,y,z,
      
         x + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * sin( atan2( sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)), mbsdl_r_z) * mbsdl_r_p_theta)
             * cos( atan2(mbsdl_r_y,mbsdl_r_x) * mbsdl_r_p_phi),
          
         y + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * sin( atan2( sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)), mbsdl_r_z) * mbsdl_r_p_theta)
             * sin( atan2(mbsdl_r_y,mbsdl_r_x) * mbsdl_r_p_phi),
           
         z + pow(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2) + pow(mbsdl_r_z,2) , 0.5*mbsdl_r_p_r)
             * cos( atan2( sqrt(pow(mbsdl_r_x,2) + pow(mbsdl_r_y,2)), mbsdl_r_z) * mbsdl_r_p_theta)
      ),
      1/( mbsdl_r_i+log(log(mbsdl_r_r2_bailout) / log((mbsdl_r_i>(mbsdl_r_i_bailout-1))+pow(mbsdl_r_x,2)+pow(mbsdl_r_y,2)+pow(mbsdl_r_z,2))) / log(mbsdl_r_p_r) )
   )//end recursion select loop
};

#declare f_mandelbulb = function(x,y,z, mbsdl_f_p_r, mbsdl_f_p_theta, mbsdl_f_p_phi,  mbsdl_f_i_bailout, mbsdl_f_r_bailout){
    mbsdl_recurse( mbsdl_f_p_r, mbsdl_f_p_theta, mbsdl_f_p_phi,1,int(mbsdl_f_i_bailout-1), pow(mbsdl_f_r_bailout,2), x,y,z, x,y,z)
}

isosurface {
   function{f_mandelbulb(x,y,z, 8,8,8, 3, 3)}
   threshold 1/3.1
   max_gradient 20
   accuracy 0.001
   contained_by{sphere{<0,0,0>,1.2}}
   texture{
      pigment{rgb<1,1,1>}
   }
}
   
light_source {
   <-30, 30, -30>
   color rgb <1, 1, 1>
   translate <-30, 30, -30>
}

camera {
   location  <0.0, 0.5, -4.0>
   direction 1.5*z
   right     x*image_width/image_height
   look_at   <0.0, 0.0,  0.0>
}