// Persistence of Vision Ray Tracer Scene Description File
// File: mbsdl_powers.pov
// Vers: 3.6, 3.7
// Desc: Example Showing Mandelbulb Powers 1-7
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

#include "mbsdl.inc" // Include this first.
#include "stage1.inc"

#local mbsdl_quality =   3  ;// Use negative values for low-quality previews.

// Set parameters for the first 'bulb in the upper-left corner.
#local mbsdl_power   =  2  ;
#local mbsdl_x       = -2.5;
#local mbsdl_y       =  1.7;

#while(mbsdl_power < 8)

#local mbsdl_iterations   = 1.05*(7-mbsdl_power/2);
// This does not do a very good job of estimating the max_gradient needed.
#local mbsdl_max_gradient = exp( 1.5*pow(0.5*mbsdl_power, mbsdl_iterations+log(mbsdl_power)-5) + mbsdl_quality);
#local mbsdl_accuracy     = 0.01/mbsdl_max_gradient;
#debug concat("Power: "       , str(mbsdl_power,        3, 0),
            "; iterations: "  , str(mbsdl_iterations,   5, 1),
            "; max_gradient: ", str(mbsdl_max_gradient, 6, 1),
            "; accuracy: "    , str(mbsdl_accuracy,    14,12), ".\n")
isosurface{
   function{f_mandelbulb(x,y,z, mbsdl_power,mbsdl_power,mbsdl_power, mbsdl_iterations, 3)}
   threshold    1/mbsdl_iterations
   max_gradient mbsdl_max_gradient
   accuracy     mbsdl_accuracy
   contained_by{sphere{<0,0,0>,1.2}}// Lower power mandelbulbs do not fit in this.
   texture{
      pigment{White}
      }
   translate <mbsdl_x,mbsdl_y,0>
   }

#local mbsdl_x = mbsdl_x +2.6;

#if(mbsdl_x > 3)
#local mbsdl_x = -2.5;
#local mbsdl_y = mbsdl_y -3;
#end

#local mbsdl_power = mbsdl_power +1;

#end