// Persistence of Vision Ray Tracer Scene Description File
// File: mbsdl_pattern.pov
// Vers: 3.6, 3.7
// Desc: Basic Mandelbulb Pattern Example
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

#version 3.6;

#include "mbsdl.inc" // Include this first.
#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}

sphere {
  0.0, 1
  texture {
    pigment {
      function { f_mandelbulb(x,y,z, 8,8,8, 100, 3 ) }
      frequency 8
      color_map {
        [0.00 color rgb <1.0,0.4,0.2> ]
        [0.33 color rgb <0.2,0.4,1.0> ]
        [0.66 color rgb <0.4,1.0,0.2> ]
        [1.00 color rgb <1.0,0.4,0.2> ]
      }
    }
    finish{
      specular 0.6
    }
  }
}

//640x480: xxx sec
