// Persistence of Vision Ray Tracer Scene Description File
// File: mbsdl_powers.pov
// Vers: 3.6, 3.7
// Desc: Example Showing Mandelbulb Power Combinations
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html
//
// This scene shows the results of combining two different powers in each 'bulb.
// Some attempt is made to keep the feature size about the same for all six combinations shown.

#include "mbsdl.inc" // Include this first.
#include "stage1.inc"

#local mbsdl_power = array[2];
#local mbsdl_power[0]     =  8  ;// This is the power common to all 'bulbs.
#local mbsdl_power[1]     =  5  ;// This is the other power.

#local mbsdl_i_target     =  3  ;// Minimum number of iterations corresponding to the highest power.

// Set parameters for the first 'bulb in the upper-left corner.
#local mbsdl_bulb_number  =  1  ;
#local mbsdl_x            = -2.5;
#local mbsdl_y            =  1.7;

#while(mbsdl_bulb_number < 7)

#local mbsdl_p_r     = mbsdl_power[mod(mbsdl_bulb_number,8)/4];
#local mbsdl_p_theta = mbsdl_power[mod(mbsdl_bulb_number,4)/2];
#local mbsdl_p_phi   = mbsdl_power[mod(mbsdl_bulb_number,2)]; 

#local mbsdl_iterations = int(mbsdl_i_target - (mbsdl_p_theta+mbsdl_p_phi)/max(mbsdl_power[0],mbsdl_power[1]) +2.5);

#debug concat("Bulb Number: " , str(mbsdl_bulb_number, 2,0),
            "; iterations: "  , str(mbsdl_iterations,  4,1),
            "; p_r: "         , str(mbsdl_p_r,         4,1),
            "; p_theta: "     , str(mbsdl_p_theta,     4,1),
            "; p_hi: "        , str(mbsdl_p_phi,       4,1), ".\n")
isosurface{
   function{f_mandelbulb(x,y,z, mbsdl_p_r,mbsdl_p_theta,mbsdl_p_phi, mbsdl_iterations, 3)}
   threshold    1/(1.01*mbsdl_iterations)
   max_gradient 10
   accuracy     0.001
   contained_by{sphere{<0,0,0>,1.2}}// Lower power mandelbulbs do not fit in this.
   texture{
      pigment{White}
      }
   translate <mbsdl_x,mbsdl_y,0>
   }

#local mbsdl_x = mbsdl_x +2.6;

#if(mbsdl_x > 3)
#local mbsdl_x = -2.5;
#local mbsdl_y = mbsdl_y -3;
#end

#local mbsdl_bulb_number = mbsdl_bulb_number +1;
#end//looping through the 'bulbs.
