// Persistence of Vision Ray Tracer Scene Description File
// File: mb_standalone.pov
// Vers: 3.6, 3.7
// Desc: Minimal Stand-alone Mandelbulb Scene Example
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

#declare f_mandelbulb=function{internal(79)};

isosurface {
   function{f_mandelbulb(x,y,z, 8,8,8, 3, 3)}
   threshold 1/3.1
   max_gradient 20
   accuracy 0.001
   contained_by{sphere{<0,0,0>,1.2}}
   texture{
      pigment{rgb<1,1,1>}
   }
}
   
light_source {
   <-30, 30, -30>
   color rgb <1, 1, 1>
   translate <-30, 30, -30>
}

camera {
   location  <0.0, 0.5, -4.0>
   direction 1.5*z
   right     x*image_width/image_height
   look_at   <0.0, 0.0,  0.0>
}