// Persistence of Vision Ray Tracer Scene Description File
// File: mb_powers.pov
// Vers: 3.6, 3.7
// Desc: Example Showing Mandelbulb Powers 1-7
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html
// Render at 4:3.

#include "stage1.inc"

#declare f_mandelbulb=function{internal(79)};

#local mb_quality =   3  ;// Use negative values for low-quality previews.

// Set parameters for the first 'bulb in the upper-left corner.
#local mb_power   =  2  ;
#local mb_x       = -2.5;
#local mb_y       =  1.7;

#while(mb_power < 8)

#local mb_iterations   = 1.05*(7-mb_power/2);
// This does not do a very good job of estimating the max_gradient needed.
#local mb_max_gradient = exp( 1.5*pow(0.5*mb_power, mb_iterations+log(mb_power)-5) + mb_quality);
#local mb_accuracy     = 0.01/mb_max_gradient;
#debug concat("Power: "       , str(mb_power,        3, 0),
            "; iterations: "  , str(mb_iterations,   5, 1),
            "; max_gradient: ", str(mb_max_gradient, 6, 1),
            "; accuracy: "    , str(mb_accuracy,    14,12), ".\n")
isosurface{
   function{f_mandelbulb(x,y,z, mb_power,mb_power,mb_power, mb_iterations, 3)}
   threshold    1/mb_iterations
   max_gradient mb_max_gradient
   accuracy     mb_accuracy
   contained_by{sphere{<0,0,0>,1.2}}// Lower power mandelbulbs do not fit in this.
   texture{
      pigment{White}
      }
   translate <mb_x,mb_y,0>
   }

#local mb_x = mb_x +2.6;

#if(mb_x > 3)
#local mb_x = -2.5;
#local mb_y = mb_y -3;
#end

#local mb_power = mb_power +1;

#end
