// Persistence of Vision Ray Tracer Scene Description File
// File: mb_media.pov
// Vers: 3.6, 3.7
// Desc: Mandelbulb Media Example
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

#include "colors.inc"

#declare f_mandelbulb=function{internal(79)};

#local mb_power   =   8 ;// Mandelbulb Power
#local mb_i       =  50 ;// Maximum Number of Iterations
#local mb_quality =   2 ;// Must be >0.

sphere{<0,0,0>,2.99 hollow
  interior{
    media{
      method 3 intervals 1 samples mb_i*mb_quality
      emission 2
      density{
        function {f_mandelbulb(x,y,z, mb_power,mb_power,mb_power, mb_i, 3 )}
        color_map {
          [0               Red      ]// Interior color
          [1/mb_i       Black    ]// Highest iteration start color
          [1/mb_i       White    ]
          [2/mb_i       White    ]// Second-highest iteration
          [1/12      0.500*Yellow   ]  
          [1/ 6      0.050*Green    ]   
          [1/ 3  rgb 0.010*Magenta  ]
          [1/ 2      0.005*Blue     ]// Iteration 2 start color
          [1               Black    ]// Iteration 1 start color
        }//end color_map
      }//end density
    }//end media
  }//end interior
  texture{pigment{color Clear}}
}//end sphere

camera {
  location  <0.01, 0, 3.1>
  up y sky y
  right     x*image_width/image_height
  look_at   <0.001, 0.001,  0.001>
}
