// Persistence of Vision Ray Tracer Scene Description File
// File: mb_basic.pov
// Vers: 3.6, 3.7
// Desc: Basic Scene Example
// Date: 12/18/09
// Auth: David Wagner
// Cite: http://www.skytopia.com/project/fractal/2mandelbulb.html

#version 3.6;

#include "colors.inc"

#declare f_mandelbulb=function{internal(79)};

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}

isosurface {
  function {f_mandelbulb(x,y,z, 8,8,8, 3, 3)}
  threshold 1/3
  max_gradient 20
  accuracy 0.001
  contained_by {sphere{<0,0,0>,1.2}}
  texture {
    pigment {
      function { f_mandelbulb(x,y,z, 8,8,8, 20, 3 ) }
      scale 1.05
      frequency 8
      color_map {
        [0.00 color rgb <1.0,0.4,0.2> ]
        [0.33 color rgb <0.2,0.4,1.0> ]
        [0.66 color rgb <0.4,1.0,0.2> ]
        [1.00 color rgb <1.0,0.4,0.2> ]
      }
    }
    finish{
      specular 0.6
    }
  }
}

