/*

 superellipsoidal.pov
 2009 Sam Benge
 
 This file shows how the superellipsoidal
 pigment can flatten the edges of a height
 field while perserving as much original
 height information as possible.
 
 A spherical pigment would clip too much
 detail off the corners, a boxed pigment
 would add unwanted diagonal ridges.
 
*/

#include"hf_tools.inc"

camera{
 location<0,10,-10>
 look_at<0,-.25,0>
 angle 27
}

light_source{
 <-1,.5,-.25>*100000, 1.5
}

#declare height_pigment=
pigment{
 // Value must be an even integer (eg. 2,4,6,28,etc).
 superellipsoidal(.3)
 
 // taper the function to smoothly join with a plane
 poly_wave 4
 
 pigment_map{
  [0 rgb 0]
  [1 image_map{png"mountains.png"interpolate 2 }]
 }
}

union{
 plane{y,0}
 height_field{
  function 512, 512{
   pigment{ height_pigment }
  }
  smooth
 
  // center the height field and transform it
  translate-(x+z)/2
  scale<7,1.5,7>
  //rotate y*22
 }
 pigment{ rgb 1 }
}