/*

 edged2.pov
 2009 Sam Benge
 
 First render edge_maker.pov (see scene
 file for specifics).
 
 This file shows how pre-rendering an
 edge map and applying it later can
 be faster than computing it on-the-
 fly.
 
*/

#include"hf_tools.inc"

camera{
 location<0,10,-10>
 look_at<0,-.4,0>
 angle 30
}

light_source{
 <-1,.5,-.25>*100000, 2
}

#declare height_pigment=
pigment{
 image_map{png"mountains.png"interpolate 2 }
}

#declare edge_pigment=
pigment{
 image_map{png"edge_maker.png"interpolate 2 }
}

height_field{
 function 513, 513{
  pigment{ height_pigment }
 }
 smooth
 
 pigment{
  pigment_pattern{ edge_pigment }
  
  // accentuate the edges
  color_map{[.3 rgb 0][.5 rgb .33][.8 rgb 1]}
  
  // place the angle map correctly onto the height field
  rotate x*270 translate z
 }
 // center the height field and transform it
 translate -1/2
 scale<7,1.5,7>
}