/*

 edged.pov
 2009 Sam Benge
 
 This file displays a height field with an edge
 map applied to it. Used in this manner you can
 apply different pigments, normals, or entire
 textures to outside and inside edges. It can be
 used to simulate weathering, among other things.
 
*/

#include"hf_tools.inc"

camera{
 location<0,10,-10>
 look_at<0,-.4,0>
 angle 30
}

light_source{
 <-1,.5,-.25>*100000, 2
}

// a switch to change between available height pigments (below)
#declare which_pigment = 1; // 0, 1

// a declared pigment to be used both as a height
// field and as an edge map
#declare height_pigment=
pigment{
 #switch(which_pigment)
  #case(0)
   crackle
   scale .25
  #break
  #case(1)
   image_map{png"mountains.png" interpolate 2 once}
  #break
 #end
}

height_field{
 function 513, 513{
  pigment{ height_pigment }
 }
 smooth
 
 pigment{
  // the edge map
  edge_map(height_pigment, .015, .0035, .2)
  
  // accentuate the edges
  color_map{[.3 rgb 0][.5 rgb .33][.8 rgb 1]}
  
  // place the angle map correctly onto the height field
  rotate x*270 translate z
 }
 // center the height field and transform it
 translate -1/2
 scale<7,1.5,7>
}