/*

 angle_mapped.pov
 2009 Sam Benge
 
 This file illustrates the basic use of the
 angle_map() pigment.
 
*/

#include"hf_tools.inc"

camera{
 location<0,10,-10>
 look_at<0,-.5,0>
 angle 30
}

light_source{
 <-1,.5,.25>*100000, 2
}

// a declared pigment to be used both as a height
// field and as an angle map
#declare height_pigment=
pigment{
 crackle form x
 scale .2
 color_map{[0 rgb 1][1 rgb 0]}
}

height_field{
 function 512, 512{
  pigment{ height_pigment }
 }
 smooth
 
 pigment{
  // the angle map
  angle_map(height_pigment)
  
  //
  triangle_wave
  frequency 6
  
  // place the angle map correctly onto the height field
  rotate x*270 translate z
 }
 // center the height field and transform it
 translate -1/2
 scale<7,1.5,7>
}