/*

 angle_map_advanced.pov
 2009 Sam Benge
 
 This file illustrates a more complicated use of the
 angle_map() pigment.
 
*/

#default{finish{ambient 0}}

#include"hf_tools.inc"

camera{
 location<0,10,-10>
 look_at<0,-.4,0>
 angle 20
}

light_source{
 <-1,.5,.25>*100000, 2
 area_light x*7000,z*7000,2,2
 jitter adaptive 1
}

light_source{
 <0,1,1>*100000, <.2,.3,.5>
 area_light x*20000,z*20000,2,2
 jitter adaptive 1
}

// a switch to change between available height pigments (below)
#declare which_pigment = 1; // 0, 1

// a declared pigment to be used both as a height
// field and as an angle map
#declare height_pigment=
pigment{
 #switch(which_pigment)
  #case(0)
   crackle form x
   scale .2 poly_wave 3
   color_map{[0 rgb 1][1 rgb 0]}
  #break
  #case(1)
   crackle metric 2 form x turbulence .3 lambda 1.5
   scale .25
   color_map{[0 rgb 1][1 rgb 0]}
  #break
 #end
}

// a stretched granite pigment
#declare a_pattern=
pigment{
 granite
 scale<.025,1,1>
}

#declare fallen_grass=
pigment{
 // the angle map
 angle_map(height_pigment)
  
 // a pigment_map based on the angle map
 pigment_map{
  #declare R=seed(1234);
  #declare V=0;
  #while(V<1)
   [V
    // the granite pigment
    a_pattern
     
    // jitter the pigment
    translate rand(R)*100
     
    // Notice how the pigment is rotated along the
    // z axis.
    rotate z*V*360
   ]
    
   #declare V=V+1/50;
  #end
 }
  
 // place the angle map correctly onto the height field
 rotate x*270 translate z
}

height_field{
 function 512, 512{
  pigment{ height_pigment }
 }
 smooth
 
 pigment{pigment_pattern{fallen_grass} color_map{[0 rgb 0][1 rgb<.2,1,.2>]}}
 normal{pigment_pattern{fallen_grass} -.05 accuracy .002}
 
 // center the height field and transform it
 translate -1/2
 scale<7,1.5,7>
 //rotate y*22
}