//blobinit_2.inc - Blobfield include file 

#declare blobfield_start_x = -5;
#declare blobfield_start_y = -3;
#declare blobfield_start_z = 2.5;

#declare displace_start = 0.2;

#declare blobfield_x = blobfield_start_x;
#declare blobfield_y = blobfield_start_y;
#declare blobfield_z = blobfield_start_z;

#declare blob_x_fac = 0.5;
#declare blob_y_fac = 0.5;

#declare z_loops = 3;

#declare displace_fac = displace_start;                                                                       

#declare red_val = 1;
#declare blue_val = 0;
#declare green_val = 0;

#declare color_count = 1;

#while (z_loops > 0)
        #declare x_loops = 20;
        #declare blobfield_x = blobfield_start_x;
               
        blob
        {           
                threshold 1.5
                        
                #declare rand_val_1 = seed(12345);                
                #declare rand_val_2 = seed(54321);
                #declare rand_val_3 = seed(-12345);
                #declare rand_val_4 = seed(-54321);
                        
                #while (x_loops > 0)
                        #declare y_loops = 12;
                        #declare blobfield_y = blobfield_start_y;
                        
                        #while (y_loops > 0)      
                                #if (z_loops = 3)                              
                                        #declare displacement_dir = 10 * rand(rand_val_1);
                                #end
                                #if (z_loops = 2)
                                        #declare displacement_dir = 10 * rand(rand_val_2);
                                #end        
                                #if (z_loops = 1)
                                        #declare displacement_dir = 10 * rand(rand_val_3);
                                #end      
                                
                                #debug concat("Displacement Decide: ",str(displacement_dir,2,1),"\n")
                                        
                                #declare z_trans = blobfield_z;
                                                                       
                                #if (displacement_dir <= 5)    
                                        #declare z_trans = z_trans - displace_fac;                    
                                #else
                                        #declare z_trans = z_trans + displace_fac;
                                #end                                
                                
                                #declare color_decide = 10 * rand(rand_val_4);
                                
                                #if (color_decide <= 3.5)
                                        #declare color_count = 1;
                                #end                             
                                
                                #if (color_decide >= 3.5)
                                        #if (color_decide <= 7.5)
                                                #declare color_count = 2;
                                        #end
                                #end
                                
                                #if (color_decide >= 7.5)
                                        #declare color_count = 3;
                                #end
                                        
                                sphere { <blobfield_x,blobfield_y,z_trans>, .75, 0.8 
                                        texture{
                                                #if (color_count = 1)
                                                        #ifdef (final)
                                                                pigment {color Red transmit 0.375}         
                                                        #else   
                                                                pigment {color Red}
                                                        #end
                                                                
                                                #end
                                                
                                                #if (color_count = 2)              
                                                        #ifdef (final)
                                                                pigment {color Coral transmit 0.375}
                                                        #else
                                                                pigment {color Coral}
                                                        #end        
                                                #end                              
                                                
                                                #if (color_count = 3)                
                                                        #ifdef (final)
                                                                pigment {color Firebrick transmit 0.375}
                                                        #else
                                                                pigment {color Firebrick}
                                                        #end        
                                                #end
                                                
                                                #ifdef (final)
							finish
                                                        {
							       ambient 0.1
							       diffuse 0.8	 
                                                               reflection
								 {
								   0.35 , 0.5
								     fresnel  on
								     falloff  1.15
								     exponent 1.05
								     metallic 1.25
								 }
                                                        }
                                                #end        
                                               }
                                       }                       
                                /*
                                #if (red_val > 0)
                                        #declare red_val = red_val - 0.25;
                                #else
                                        #declare red_val = 1;
                                #end      
                                      
                                #if (green_val < 0.1)
                                        #declare green_val = green_val + 0.25;
                                #else
                                        #declare green_val = 0;
                                #end      
                                
                                #if (blue_val < 0.5)
                                        #declare blue_val = blue_val + 0.25;
                                #else
                                        #declare blue_val = 0;
                                #end      
                                */
                                #declare blobfield_y = blobfield_y + blob_y_fac;
                                
                                #declare y_loops = y_loops - 1;
                        #end
                        
                        #declare blobfield_x = blobfield_x + blob_x_fac;
                        
                        #declare x_loops = x_loops - 1;
                #end
                
                sturm 1
                photons
		{
			collect off
		}
        }
        
        #declare blobfield_z = blobfield_z - 0.75;
        
        #declare z_loops = z_loops - 1;
#end
