/*

opalB.pov
2009 Samuel Benge

requires:
POV-Ray 3.7b
transforms.inc
stoneA_POV_geom.inc
inclusionA_POV_geom.inc

render at w768 x h768 or similar

*/

#include"transforms.inc"
#include"stoneA_POV_geom.inc"
#include"inclusionA_POV_geom.inc"

global_settings{ max_trace_level 40 }

#default{ finish{ambient 0 } }

camera{ 
 right x up y
 location<0,0,-20>
 look_at<0,0,0>
 angle 11
}

// a meek light :)
#declare lpos = <-1,.5,-.5>;
#declare lcol = <1,.975,.85>*12.4;
light_source{lpos*100000,lcol}

// this provides the highlight for the stone finish
// notice how it points towards the light_source
sky_sphere{
 pigment{
  pigment_pattern{
   spherical scale 2 translate y
   poly_wave 7
   Point_At_Trans(lpos)
  }
  pigment_map{
   [.5 rgb 0]
   [.55 rgb lcol]
  }
 }
}

// the stone itself
#declare stoneA__null__=
object{
 stoneA__null__
 rotate y*270
 scale<1,1,.5>
}

#declare R=seed(008);

// the points array.
// this doesn't have to be an array, it could be
// computed later. but I left it around after an
// earlier experiment
#declare nPts=1400;
#declare pts=array[nPts];
#declare V=0;
#while(V<nPts)
 #declare mine=min_extent(stoneA__null__);
 #declare maxe=max_extent(stoneA__null__);
 // generate randomly-placed points based on the size of the input mesh
 #declare pts[V]=mine+<rand(R)*(maxe.x-mine.x),rand(R)*(maxe.y-mine.y),rand(R)*(maxe.z-mine.z)>;
 #declare V=V+1;
#end

// the "dirs" array holds directional vectors for testing around points later on.
// you can use any points for this, such as dodecahedral or icosahedral,
// as long you you update nDirs
#declare nDirs=6;
#declare dirs=array[nDirs]{ // an octahedron
 <0,-1,0>,
 <0,0,1>,
 <-1,0,0>,
 <1,0,0>,
 <0,1,0>,
 <0,0,-1>
}

// this is the pattern that will be tested later
#declare objPattern=
function{
 pattern{
  object{stoneA__null__}
 }
}

#declare V=0;
union{
 union{
  #while(V<nPts)
   #declare dv=0;
   #declare ct=0;
   #declare Radius=.025+rand(R)*.35; // this is the testing radius for each inclusion
   #while(dv<nDirs) // go through all the testing directions
    // if a point is outside the object, add to counting variable ct
    #if(objPattern(pts[V].x+dirs[dv].x*Radius,pts[V].y+dirs[dv].y*Radius,pts[V].z+dirs[dv].z*Radius)=0)
     #declare ct=ct+1;
    #end
    #declare dv=dv+1;
   #end
   #if(ct=0) // if counting variable ct is still 0, then place an object
    object{ // disc-shaped inclusion
     inclusionA__null__
     scale Radius*.85
     rotate y*rand(R)*360
     rotate x*60
     rotate<rand(R)-rand(R),0,rand(R)-rand(R)>*<25,0,15>+z*pts[V].x*20+z*pts[V].y*30
     translate pts[V]
     pigment{ // color each inclusion
      rgb<rand(R),rand(R),rand(R)>
      transmit 1
     }
     finish{ // add metallic specular to bring out color
      diffuse 0
      specular .02 roughness .025 metallic 1
     }
     normal{ // add surface normal to hide disc shape
      crackle 10 accuracy .001
      scale .1+rand(R)*.2
      warp{turbulence .15 lambda 2.25}
     }
     interior{ior 1.6}
     no_shadow
    }
   #end
   #declare V=V+1;
  #end
 }
 object{ // finally, the stone, with media
  stoneA__null__
  pigment{rgb 0 transmit 1}
  finish{reflection{0,1 fresnel}}
  interior{
   ior 1.6
   media{
    scattering{5,<.01,.02,.04>}
    absorption .3
   }
  }
 }
 hollow
}