//////////////////////////////////////////
//                                      //
// Luminous Color Bleeding version 5    //
//       2009  Samuel T. Benge          //
//         distribute freely            //
//                                      //
//////////////////////////////////////////

// remember to keep the output image size the same as the input image size
// render without aa for speed
// beware of using png files which may have their own gamma values.....

// you can change the gamma, if needed
//global_settings{assumed_gamma 1.0}
//global_settings{assumed_gamma 2.2}

// global ambient value - do not change
#default{finish{ambient 1}}

// don't change the camera
camera{
 orthographic
 right x*2 up y*2
 location z*-1
 look_at 0 
}

// "pts_circle.inc" provides the points to be used for the bloom effect.
// It is a circular array of 226 points.
// A perfect array would use 256 points to max out the
// size limitation for pigment_maps.
#include"pts_circle.inc"

// **********************************************************************
// begin user settings
// **********************************************************************

// it all starts here
#declare image_pigment=
pigment{
 image_map{
  // your image file here
  //tga".."
  
  
  once
  
  // Interpolation helps to enhance the antialiasing of the original image.
  //interpolate 2
 }
  
  // these warp statements reduce unwanted edge artifacts
  warp{repeat x flip x}
  warp{repeat y flip y}
 
 // image orientation - do not change
 #declare image_scale = 2;
 scale image_scale translate (image_scale/2)*<-1,-1,0>
}

// intensity of glare effect
#declare intensity = 1;

// quality of the effect
// use values between 0 and 1 (with 1 being best [and slowest])
#declare quality = .3;

// intensity falloff method
// 0 = constant falloff
// 1 = intensity divided by distance - default
// 2 = inverse square of distance
#declare falloff_method = 1;

// radius of effect
// change independent values for width/height
#declare rad = <2,1>*.05;

// rotate the effect
// useful when using disproportionate radii
#declare rotation = 1;

// change the intensity of the whole image 
#declare overall_intensity = 3; // default 3

// the the darkness of dark areas, useful for contrast adjustment
#declare overall_darkness = 0; // default 0

// poly_wave value for glare effect only
// Lower values will make more of the image produce glare, higher values
// will cause only the brighter spots to cast a glare.
#declare pw = 3;

// poly_wave value for original image
// useful for adjusting to different gammas
#declare image_pw = 2; // default 2.0

// intensity of original colors, increase to saturate (and brighten) image
#declare image_intensity = 1; // default 1.0


// **********************************************************************
// end user settings
// **********************************************************************

// **********************************************************************
// no need to change below code

// image as a function
#declare figm=
function{
 pigment{
  average
  pigment_map{
   
   #declare V=0;
   #while(V<dimension_size(pts_circle,1))
    [
     #if(falloff_method=0)
      1
     #end
     #if(falloff_method=1)
      1/vlength(pts_circle[V])
     #end
     #if(falloff_method=2)
      pow(vlength(pts_circle[V])-1,2)
     #end
     
     image_pigment
     rotate z*rotation
     translate<pts_circle[V].x*rad.x,pts_circle[V].y*rad.y,0>
     rotate -z*rotation
    ]
    #declare V=V+1/quality;
   #end
  }
 }
}

#declare figm2=
function{pigment{image_pigment}}

#declare image_pigment2=
pigment{
 average
 pigment_map{
  [1
   #declare f1=function{pigment{function{figm2(x,y,z).x}poly_wave image_pw color_map{[0 rgb 0][1 rgb image_intensity]}}}
   #declare f2=function{pigment{function{figm(x,y,z).x}poly_wave pw color_map{[0 rgb 0][1 rgb intensity]}}}
   #declare f=
   function{
    #if(intensity>0)
     (f1(x,y,z).x+f2(x,y,z).x)
     #else
     f1(x,y,z).x
    #end
   }
   function{select(f(x,y,z)-1,f(x,y,z),1)}
   color_map{[0 rgb -overall_darkness][1 rgb x*overall_intensity ]}
   #undef f1
   #undef f2
   #undef f
  ]
  [1
   #declare f1=function{pigment{function{figm2(x,y,z).y}poly_wave image_pw color_map{[0 rgb 0][1 rgb image_intensity]}}}
   #declare f2=function{pigment{function{figm(x,y,z).y}poly_wave pw color_map{[0 rgb 0][1 rgb intensity]}}}
   #declare f=
   function{
    #if(intensity>0)
     (f1(x,y,z).y+f2(x,y,z).y)
     #else
     f1(x,y,z).y
    #end
   }
   function{select(f(x,y,z)-1,f(x,y,z),1)}
   color_map{[0 rgb -overall_darkness][1 rgb y*overall_intensity ]}
   #undef f1
   #undef f2
   #undef f
  ]
  [1
   #declare f1=function{pigment{function{figm2(x,y,z).z}poly_wave image_pw color_map{[0 rgb 0][1 rgb image_intensity]}}}
   #declare f2=function{pigment{function{figm(x,y,z).z}poly_wave pw color_map{[0 rgb 0][1 rgb intensity]}}}
   #declare f=
   function{
    #if(intensity>0)
     (f1(x,y,z).z+f2(x,y,z).z)
     #else
     f1(x,y,z).z
    #end
   }
   function{select(f(x,y,z)-1,f(x,y,z),1)}
   color_map{[0 rgb -overall_darkness][1 rgb z*overall_intensity ]}
  ]
 }
}

// underlying, unaffected image
#declare image=
plane{z,0
 pigment{
  image_pigment2
 }
}
object{image translate z*.001}

