/*
  Persistence of Vision Ray Tracer include file
  
  Creates a basic figurine, approximately 6' tall.
  For use with Theatresys v1 +
  
  Contents:
    WoodFigure(Position) - creates a figure with feet at Position
  
  If used alone, first declare UnitMult to be your scaling factor
    from cm to whatever you are using as a base unit
  
  Modeled by Christopher Shake

  This work is licensed under the Creative Commons Attribution-Noncommercial 3.0 Unported License
  http://creativecommons.org/licenses/by-nc/3.0/
*/
// Figure.pov: Exported from Wings 3D 0.99.04a 
#ifndef(WOOD_FIGURE_PROP_INC_TEMP)
#declare WOOD_FIGURE_PROP_INC_TEMP = version;
#version 3.5;

// Creates a figure with feet at Position
// Head is in +y, facing -z
#macro WoodFigure(Position) 
merge{
  object{ wo_0_RightWrist }
  object{ wo_1_RightHand }
  object{ wo_2_LeftWrist }
  object{ wo_3_LeftForearm }
  object{ wo_4_LeftHand }
  object{ wo_5_RightForearm }
  object{ wo_6_LeftElbow }
  object{ wo_7_RightElbow }
  object{ wo_8_LeftUpperArm }
  object{ wo_9_RightUpperArm }
  object{ wo_10_RightShoulder }
  object{ wo_11_LeftShoulder }
  object{ wo_12_LeftFoot }
  object{ wo_13_RightFoot }
  object{ wo_14_LeftAnkle }
  object{ wo_15_RightAnkle }
  object{ wo_16_LeftShin }
  object{ wo_17_RightShin }
  object{ wo_18_LeftKnee }
  object{ wo_19_RightKnee }
  object{ wo_20_LeftThigh }
  object{ wo_21_LeftHip }
  object{ wo_22_RightHip }
  object{ wo_23_RightThigh }
  object{ wo_24_Torso }
  scale <-1,1,-1>*82.271*UnitMult
  texture{pigment{color rgb <0.59,0.41,0.31>}finish{diffuse 0.1}}
  translate Position
}
#end

#declare wm_default = texture{
	 pigment{
		 color rgbf <1.000000, 1.000000, 1.000000, 0.000000>
	 }
	 finish {
		 ambient rgb <0.000000, 0.000000, 0.000000>
		 diffuse 0.700000
		 brilliance 1.000000
		 metallic 0.000000
		 specular 1.000000
		 roughness 0.010000
	 }
}
#declare wo_0_RightWrist = mesh2{
	 vertex_vectors { 114, <0.171391, 1.003446, -0.000000>, <0.172441, 1.003446, 0.005276>, <0.175430, 1.003446, 0.009750>, <0.179903, 1.003446, 0.012739>, <0.185179, 1.003446, 0.013788>, <0.190456, 1.003446, 0.012739>, <0.194929, 1.003446, 0.009750>, <0.197918, 1.003446, 0.005276>, <0.198967, 1.003446, -0.000000>, <0.197918, 1.003446, -0.005276>, 
			<0.194929, 1.003446, -0.009750>, <0.190456, 1.003446, -0.012739>, <0.185179, 1.003446, -0.013788>, <0.179903, 1.003446, -0.012739>, <0.175430, 1.003446, -0.009750>, <0.172441, 1.003446, -0.005276>, <0.159702, 0.995635, -0.000000>, <0.161641, 0.995635, 0.009750>, <0.167164, 0.995635, 0.018015>, <0.175430, 0.995635, 0.023538>, <0.185179, 0.995635, 0.025477>, 
			<0.194929, 0.995635, 0.023538>, <0.203194, 0.995635, 0.018015>, <0.208717, 0.995635, 0.009750>, <0.210656, 0.995635, 0.000000>, <0.208717, 0.995635, -0.009750>, <0.203194, 0.995635, -0.018015>, <0.194929, 0.995635, -0.023538>, <0.185179, 0.995635, -0.025477>, <0.175430, 0.995635, -0.023538>, <0.167164, 0.995635, -0.018015>, <0.161641, 0.995635, -0.009750>, 
			<0.151892, 0.983946, -0.000000>, <0.154426, 0.983946, 0.012739>, <0.161641, 0.983946, 0.023538>, <0.172441, 0.983946, 0.030754>, <0.185179, 0.983946, 0.033288>, <0.197918, 0.983946, 0.030754>, <0.208717, 0.983946, 0.023538>, <0.215933, 0.983946, 0.012739>, <0.218467, 0.983946, 0.000000>, <0.215933, 0.983946, -0.012739>, <0.208717, 0.983946, -0.023538>, 
			<0.197918, 0.983946, -0.030754>, <0.185179, 0.983946, -0.033288>, <0.172441, 0.983946, -0.030754>, <0.161641, 0.983946, -0.023538>, <0.154426, 0.983946, -0.012739>, <0.149149, 0.970158, -0.000000>, <0.151892, 0.970158, 0.013788>, <0.159702, 0.970158, 0.025477>, <0.171391, 0.970158, 0.033288>, <0.185179, 0.970158, 0.036030>, <0.198967, 0.970158, 0.033288>, 
			<0.210656, 0.970158, 0.025477>, <0.218467, 0.970158, 0.013788>, <0.221209, 0.970158, 0.000000>, <0.218467, 0.970158, -0.013788>, <0.210656, 0.970158, -0.025477>, <0.198967, 0.970158, -0.033288>, <0.185179, 0.970158, -0.036030>, <0.171391, 0.970158, -0.033288>, <0.159702, 0.970158, -0.025477>, <0.151892, 0.970158, -0.013788>, <0.151892, 0.956370, -0.000000>, 
			<0.154426, 0.956370, 0.012739>, <0.161641, 0.956370, 0.023538>, <0.172441, 0.956370, 0.030754>, <0.185179, 0.956370, 0.033288>, <0.197918, 0.956370, 0.030754>, <0.208717, 0.956370, 0.023538>, <0.215933, 0.956370, 0.012739>, <0.218467, 0.956370, 0.000000>, <0.215933, 0.956370, -0.012739>, <0.208717, 0.956370, -0.023538>, <0.197918, 0.956370, -0.030754>, 
			<0.185179, 0.956370, -0.033288>, <0.172441, 0.956370, -0.030754>, <0.161641, 0.956370, -0.023538>, <0.154426, 0.956370, -0.012739>, <0.159702, 0.944681, -0.000000>, <0.161641, 0.944681, 0.009750>, <0.167164, 0.944681, 0.018015>, <0.175430, 0.944681, 0.023538>, <0.185179, 0.944681, 0.025477>, <0.194929, 0.944681, 0.023538>, <0.203194, 0.944681, 0.018015>, 
			<0.208717, 0.944681, 0.009750>, <0.210656, 0.944681, 0.000000>, <0.208717, 0.944681, -0.009750>, <0.203194, 0.944681, -0.018015>, <0.194929, 0.944681, -0.023538>, <0.185179, 0.944681, -0.025477>, <0.175430, 0.944681, -0.023538>, <0.167164, 0.944681, -0.018015>, <0.161641, 0.944681, -0.009750>, <0.171391, 0.936871, -0.000000>, <0.172441, 0.936871, 0.005276>, 
			<0.175430, 0.936871, 0.009750>, <0.179903, 0.936871, 0.012739>, <0.185179, 0.936871, 0.013788>, <0.190456, 0.936871, 0.012739>, <0.194929, 0.936871, 0.009750>, <0.197918, 0.936871, 0.005276>, <0.198967, 0.936871, -0.000000>, <0.197918, 0.936871, -0.005276>, <0.194929, 0.936871, -0.009750>, <0.190456, 0.936871, -0.012739>, <0.185179, 0.936871, -0.013788>, 
			<0.179903, 0.936871, -0.012739>, <0.175430, 0.936871, -0.009750>, <0.172441, 0.936871, -0.005276>, <0.185179, 1.006188, -0.000000>, <0.185179, 0.934128, -0.000000>}
	 //#local average_center = <0.185179, 0.970158, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, 0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.608176, -0.752769, -0.251915>, <-0.706555, -0.707599, -0.009151>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.690908, -0.345848, -0.634851>, <-0.853471, -0.409068, -0.322878>, <-0.921955, -0.382443, 0.061129>, <-0.828382, -0.382443, 0.409293>, <-0.653142, -0.383160, 0.653142>, 
			<-0.375186, -0.409068, 0.831805>, <0.024145, -0.356654, 0.933924>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.707107, 0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.707107, 0.000000, -0.707107>, <-0.907221, -0.039720, -0.418775>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.686460, -0.028393, 0.726613>, <-0.320722, 0.000000, 0.947173>, <0.039720, 0.039720, 0.998421>, <0.345383, -0.039720, 0.937621>, <0.686460, 0.028393, 0.726613>, <0.907221, -0.039720, 0.418775>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, 0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.409293, 0.382443, 0.828382>, 
			<-0.028309, 0.409068, 0.912065>, <0.379704, 0.356654, 0.853594>, <0.653142, 0.383160, 0.653142>, <0.853594, 0.356654, 0.379704>, <0.686014, 0.727193, -0.023971>, <0.617517, 0.734948, -0.280222>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.023971, 0.727193, -0.686014>, <-0.280222, 0.734948, -0.617517>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <-0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.382195, 0.924082, -0.000000>, <0.395277, 0.907921, -0.139414>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <0.000000, 0.924082, -0.382195>, <-0.139414, 0.907921, -0.395277>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, -0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <-0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <44, 60, 59>, 0, <59, 43, 44>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <76, 75, 59>, 0, <59, 60, 76>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <62, 78, 77>, 0, <77, 61, 62>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 80>, 0, <97, 96, 80>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 84>, 0, <101, 100, 84>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <43, 59, 58>, <58, 42, 43>, <44, 60, 59>, <59, 43, 44>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <76, 75, 59>, <59, 60, 76>, <77, 76, 60>, 
			<60, 61, 77>, <62, 78, 77>, <77, 61, 62>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 80>, <97, 96, 80>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 84>, <101, 100, 84>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_1_RightHand = mesh2{
	 vertex_vectors { 65, <0.192266, 0.897165, -0.015567>, <0.193718, 0.910897, -0.014382>, <0.194949, 0.922539, -0.011008>, <0.195771, 0.930317, -0.005957>, <0.196060, 0.933049, -0.000000>, <0.195771, 0.930317, 0.005957>, <0.194949, 0.922539, 0.011008>, <0.193718, 0.910897, 0.014382>, <0.192266, 0.897165, 0.015567>, <0.190814, 0.883432, 0.014382>, 
			<0.189583, 0.871791, 0.011008>, <0.188760, 0.864012, 0.005957>, <0.188471, 0.861280, -0.000000>, <0.188760, 0.864012, -0.005957>, <0.189583, 0.871791, -0.011008>, <0.190814, 0.883432, -0.014382>, <0.183497, 0.898092, -0.028764>, <0.186180, 0.923466, -0.026574>, <0.188454, 0.944977, -0.020339>, <0.189974, 0.959350, -0.011008>, <0.190508, 0.964397, -0.000000>, 
			<0.189974, 0.959350, 0.011008>, <0.188454, 0.944977, 0.020339>, <0.186180, 0.923466, 0.026574>, <0.183497, 0.898092, 0.028764>, <0.180814, 0.872718, 0.026574>, <0.178539, 0.851207, 0.020339>, <0.177019, 0.836834, 0.011008>, <0.176486, 0.831787, -0.000000>, <0.177019, 0.836834, -0.011008>, <0.178539, 0.851207, -0.020339>, <0.180814, 0.872718, -0.026574>, 
			<0.170373, 0.899480, -0.037582>, <0.173878, 0.932632, -0.034721>, <0.176850, 0.960738, -0.026574>, <0.178836, 0.979517, -0.014382>, <0.179533, 0.986112, -0.000000>, <0.178836, 0.979517, 0.014382>, <0.176850, 0.960738, 0.026574>, <0.173878, 0.932632, 0.034721>, <0.170373, 0.899480, 0.037582>, <0.166867, 0.866327, 0.034721>, <0.163896, 0.838221, 0.026574>, 
			<0.161910, 0.819442, 0.014382>, <0.161212, 0.812848, -0.000000>, <0.161910, 0.819442, -0.014382>, <0.163896, 0.838221, -0.026574>, <0.166867, 0.866327, -0.034721>, <0.154892, 0.901116, -0.040678>, <0.158687, 0.937001, -0.037582>, <0.161903, 0.967422, -0.028764>, <0.164053, 0.987749, -0.015567>, <0.164807, 0.994886, -0.000000>, <0.164053, 0.987749, 0.015567>, 
			<0.161903, 0.967422, 0.028764>, <0.158687, 0.937001, 0.037582>, <0.154892, 0.901116, 0.040678>, <0.151098, 0.865232, 0.037582>, <0.147881, 0.834811, 0.028764>, <0.145732, 0.814484, 0.015567>, <0.144977, 0.807347, -0.000000>, <0.145732, 0.814484, -0.015567>, <0.147881, 0.834811, -0.028764>, <0.151098, 0.865232, -0.037582>, <0.195345, 0.896839, -0.000000>}
	 //#local average_center = <0.175566, 0.898930, -0.000000>;
	 normal_vectors { 65, <-0.901880, 0.105128, 0.419000>, <-0.916146, 0.035279, 0.399290>, <-0.945320, -0.027606, 0.324973>, <-0.978532, -0.091878, 0.184483>, <-0.994974, -0.096814, -0.025576>, <-0.977713, -0.075344, -0.195963>, <-0.945320, -0.027606, -0.324973>, <-0.916146, 0.035279, -0.399290>, <-0.901880, 0.105128, -0.419000>, <-0.919698, 0.162024, -0.357636>, 
			<-0.918642, 0.224700, -0.324973>, <-0.937677, 0.294497, -0.184483>, <-0.958781, 0.284146, -0.000000>, <-0.937677, 0.294497, 0.184483>, <-0.918642, 0.224700, 0.324973>, <-0.919698, 0.162024, 0.357636>, <-0.702858, 0.078351, 0.707002>, <-0.736491, -0.040919, 0.675209>, <-0.808679, -0.157987, 0.566638>, <-0.877400, -0.307140, 0.368557>, <-0.957750, -0.286424, 0.026026>, 
			<-0.896785, -0.289078, -0.334980>, <-0.808679, -0.157987, -0.566638>, <-0.736491, -0.040919, -0.675209>, <-0.702858, 0.078351, -0.707002>, <-0.755617, 0.194143, -0.625581>, <-0.757754, 0.323621, -0.566638>, <-0.798463, 0.456090, -0.392988>, <-0.872350, 0.487581, -0.035624>, <-0.793761, 0.483848, 0.368557>, <-0.757754, 0.323621, 0.566638>, <-0.755617, 0.194143, 0.625581>, 
			<-0.380424, 0.042402, 0.923840>, <-0.420663, -0.119184, 0.899354>, <-0.485593, -0.332637, 0.808426>, <-0.613710, -0.599331, 0.513967>, <-0.762112, -0.644629, -0.060319>, <-0.643849, -0.540425, -0.541663>, <-0.485593, -0.332637, -0.808426>, <-0.420663, -0.119184, -0.899354>, <-0.380424, 0.042402, -0.923840>, <-0.446095, 0.207994, -0.870481>, <-0.434366, 0.403957, -0.805075>, 
			<-0.521962, 0.651389, -0.550680>, <-0.543541, 0.838512, 0.038231>, <-0.462023, 0.647774, 0.605742>, <-0.434366, 0.403957, 0.805075>, <-0.446095, 0.207994, 0.870481>, <0.752596, -0.098307, 0.651102>, <0.736481, -0.218765, 0.640107>, <0.578488, -0.388275, 0.717352>, <0.537360, -0.608672, 0.583749>, <-0.165673, -0.974456, 0.151614>, <0.101367, -0.754074, -0.648920>, 
			<0.851501, -0.289417, -0.437245>, <0.401005, -0.237159, -0.884845>, <0.630053, -0.088811, -0.771457>, <0.500986, 0.106730, -0.858849>, <0.432180, 0.377725, -0.818868>, <0.649945, 0.594162, -0.473860>, <0.238042, 0.971255, 0.000000>, <0.408575, 0.727627, 0.551023>, <0.849337, 0.168802, 0.500132>, <0.062811, 0.176033, 0.982378>, <-0.994456, 0.105153, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 126, <0, 64, 1>, 0, <1, 64, 2>, 0, <2, 64, 3>, 0, <3, 64, 4>, 0, <4, 64, 5>, 0, <5, 64, 6>, 0, <6, 64, 7>, 0, <7, 64, 8>, 0, <8, 64, 9>, 0, <9, 64, 10>, 0, 
			<10, 64, 11>, 0, <11, 64, 12>, 0, <12, 64, 13>, 0, <13, 64, 14>, 0, <14, 64, 15>, 0, <15, 64, 0>, 0, <1, 17, 16>, 0, <1, 16, 0>, 0, <2, 18, 17>, 0, <2, 17, 1>, 0, <3, 19, 18>, 0, 
			<3, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 4>, 0, <21, 20, 4>, 0, <6, 22, 5>, 0, <22, 21, 5>, 0, <7, 23, 6>, 0, <23, 22, 6>, 0, <8, 24, 7>, 0, <24, 23, 7>, 0, 
			<9, 25, 8>, 0, <25, 24, 8>, 0, <10, 26, 25>, 0, <25, 9, 10>, 0, <11, 27, 26>, 0, <26, 10, 11>, 0, <28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <30, 29, 13>, 0, 
			<13, 14, 30>, 0, <31, 30, 14>, 0, <14, 15, 31>, 0, <0, 16, 31>, 0, <0, 31, 15>, 0, <17, 33, 32>, 0, <17, 32, 16>, 0, <18, 34, 33>, 0, <18, 33, 17>, 0, <19, 35, 34>, 0, <19, 34, 18>, 0, 
			<20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 21>, 0, <38, 37, 21>, 0, <23, 39, 22>, 0, <39, 38, 22>, 0, <24, 40, 23>, 0, <40, 39, 23>, 0, <25, 41, 24>, 0, 
			<41, 40, 24>, 0, <26, 42, 41>, 0, <41, 25, 26>, 0, <27, 43, 42>, 0, <42, 26, 27>, 0, <28, 44, 43>, 0, <28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <46, 45, 29>, 0, <29, 30, 46>, 0, 
			<47, 46, 30>, 0, <30, 31, 47>, 0, <16, 32, 47>, 0, <16, 47, 31>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <34, 50, 49>, 0, <34, 49, 33>, 0, <35, 51, 34>, 0, <51, 50, 34>, 0, <36, 52, 35>, 0, 
			<52, 51, 35>, 0, <37, 53, 36>, 0, <53, 52, 36>, 0, <38, 54, 53>, 0, <38, 53, 37>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 39>, 0, <56, 55, 39>, 0, <41, 57, 40>, 0, <57, 56, 40>, 0, 
			<42, 58, 57>, 0, <42, 57, 41>, 0, <43, 59, 58>, 0, <43, 58, 42>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, <45, 61, 44>, 0, <61, 60, 44>, 0, <46, 62, 45>, 0, <62, 61, 45>, 0, <47, 63, 46>, 0, 
			<63, 62, 46>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <48, 62, 63>, 0, <49, 54, 55>, 0, <49, 55, 56>, 0, <51, 53, 54>, 0, <53, 51, 52>, 0, <54, 49, 50>, 0, <54, 50, 51>, 0, <56, 57, 48>, 0, 
			<56, 48, 49>, 0, <57, 58, 62>, 0, <57, 62, 48>, 0, <58, 59, 62>, 0, <59, 60, 61>, 0, <59, 61, 62>, 0}
	 normal_indices { 126, <0, 64, 1>, <1, 64, 2>, <2, 64, 3>, <3, 64, 4>, <4, 64, 5>, <5, 64, 6>, <6, 64, 7>, <7, 64, 8>, <8, 64, 9>, <9, 64, 10>, 
			<10, 64, 11>, <11, 64, 12>, <12, 64, 13>, <13, 64, 14>, <14, 64, 15>, <15, 64, 0>, <1, 17, 16>, <1, 16, 0>, <2, 18, 17>, <2, 17, 1>, <3, 19, 18>, 
			<3, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 4>, <21, 20, 4>, <6, 22, 5>, <22, 21, 5>, <7, 23, 6>, <23, 22, 6>, <8, 24, 7>, <24, 23, 7>, 
			<9, 25, 8>, <25, 24, 8>, <10, 26, 25>, <25, 9, 10>, <11, 27, 26>, <26, 10, 11>, <28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <30, 29, 13>, 
			<13, 14, 30>, <31, 30, 14>, <14, 15, 31>, <0, 16, 31>, <0, 31, 15>, <17, 33, 32>, <17, 32, 16>, <18, 34, 33>, <18, 33, 17>, <19, 35, 34>, <19, 34, 18>, 
			<20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 21>, <38, 37, 21>, <23, 39, 22>, <39, 38, 22>, <24, 40, 23>, <40, 39, 23>, <25, 41, 24>, 
			<41, 40, 24>, <26, 42, 41>, <41, 25, 26>, <27, 43, 42>, <42, 26, 27>, <28, 44, 43>, <28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <46, 45, 29>, <29, 30, 46>, 
			<47, 46, 30>, <30, 31, 47>, <16, 32, 47>, <16, 47, 31>, <33, 49, 48>, <33, 48, 32>, <34, 50, 49>, <34, 49, 33>, <35, 51, 34>, <51, 50, 34>, <36, 52, 35>, 
			<52, 51, 35>, <37, 53, 36>, <53, 52, 36>, <38, 54, 53>, <38, 53, 37>, <39, 55, 38>, <55, 54, 38>, <40, 56, 39>, <56, 55, 39>, <41, 57, 40>, <57, 56, 40>, 
			<42, 58, 57>, <42, 57, 41>, <43, 59, 58>, <43, 58, 42>, <44, 60, 59>, <44, 59, 43>, <45, 61, 44>, <61, 60, 44>, <46, 62, 45>, <62, 61, 45>, <47, 63, 46>, 
			<63, 62, 46>, <32, 48, 63>, <32, 63, 47>, <48, 62, 63>, <49, 54, 55>, <49, 55, 56>, <51, 53, 54>, <53, 51, 52>, <54, 49, 50>, <54, 50, 51>, <56, 57, 48>, 
			<56, 48, 49>, <57, 58, 62>, <57, 62, 48>, <58, 59, 62>, <59, 60, 61>, <59, 61, 62>}
	 uv_indices { 126, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}

#declare wo_2_LeftWrist = mesh2{
	 vertex_vectors { 114, <-0.334291, 2.446140, -0.000000>, <-0.333241, 2.446140, 0.005276>, <-0.330253, 2.446140, 0.009750>, <-0.325779, 2.446140, 0.012739>, <-0.320503, 2.446140, 0.013788>, <-0.315226, 2.446140, 0.012739>, <-0.310753, 2.446140, 0.009750>, <-0.307764, 2.446140, 0.005276>, <-0.306715, 2.446140, -0.000000>, <-0.307764, 2.446140, -0.005276>, 
			<-0.310753, 2.446140, -0.009750>, <-0.315226, 2.446140, -0.012739>, <-0.320503, 2.446140, -0.013788>, <-0.325779, 2.446140, -0.012739>, <-0.330253, 2.446140, -0.009750>, <-0.333241, 2.446140, -0.005276>, <-0.345980, 2.438329, -0.000000>, <-0.344041, 2.438329, 0.009750>, <-0.338518, 2.438329, 0.018015>, <-0.330253, 2.438329, 0.023538>, <-0.320503, 2.438329, 0.025477>, 
			<-0.310753, 2.438329, 0.023538>, <-0.302488, 2.438329, 0.018015>, <-0.296965, 2.438329, 0.009750>, <-0.295026, 2.438329, 0.000000>, <-0.296965, 2.438329, -0.009750>, <-0.302488, 2.438329, -0.018015>, <-0.310753, 2.438329, -0.023538>, <-0.320503, 2.438329, -0.025477>, <-0.330253, 2.438329, -0.023538>, <-0.338518, 2.438329, -0.018015>, <-0.344041, 2.438329, -0.009750>, 
			<-0.353790, 2.426640, -0.000000>, <-0.351257, 2.426640, 0.012739>, <-0.344041, 2.426640, 0.023538>, <-0.333241, 2.426640, 0.030754>, <-0.320503, 2.426640, 0.033288>, <-0.307764, 2.426640, 0.030754>, <-0.296965, 2.426640, 0.023538>, <-0.289749, 2.426640, 0.012739>, <-0.287215, 2.426640, 0.000000>, <-0.289749, 2.426640, -0.012739>, <-0.296965, 2.426640, -0.023538>, 
			<-0.307764, 2.426640, -0.030754>, <-0.320503, 2.426640, -0.033288>, <-0.333241, 2.426640, -0.030754>, <-0.344041, 2.426640, -0.023538>, <-0.351257, 2.426640, -0.012739>, <-0.356533, 2.412852, -0.000000>, <-0.353790, 2.412852, 0.013788>, <-0.345980, 2.412852, 0.025477>, <-0.334291, 2.412852, 0.033288>, <-0.320503, 2.412852, 0.036030>, <-0.306715, 2.412852, 0.033288>, 
			<-0.295026, 2.412852, 0.025477>, <-0.287215, 2.412852, 0.013788>, <-0.284473, 2.412852, 0.000000>, <-0.287215, 2.412852, -0.013788>, <-0.295026, 2.412852, -0.025477>, <-0.306715, 2.412852, -0.033288>, <-0.320503, 2.412852, -0.036030>, <-0.334291, 2.412852, -0.033288>, <-0.345980, 2.412852, -0.025477>, <-0.353790, 2.412852, -0.013788>, <-0.353790, 2.399064, -0.000000>, 
			<-0.351257, 2.399064, 0.012739>, <-0.344041, 2.399064, 0.023538>, <-0.333241, 2.399064, 0.030754>, <-0.320503, 2.399064, 0.033288>, <-0.307764, 2.399064, 0.030754>, <-0.296965, 2.399064, 0.023538>, <-0.289749, 2.399064, 0.012739>, <-0.287215, 2.399064, 0.000000>, <-0.289749, 2.399064, -0.012739>, <-0.296965, 2.399064, -0.023538>, <-0.307764, 2.399064, -0.030754>, 
			<-0.320503, 2.399064, -0.033288>, <-0.333241, 2.399064, -0.030754>, <-0.344041, 2.399064, -0.023538>, <-0.351257, 2.399064, -0.012739>, <-0.345980, 2.387375, -0.000000>, <-0.344041, 2.387375, 0.009750>, <-0.338518, 2.387375, 0.018015>, <-0.330253, 2.387375, 0.023538>, <-0.320503, 2.387375, 0.025477>, <-0.310753, 2.387375, 0.023538>, <-0.302488, 2.387375, 0.018015>, 
			<-0.296965, 2.387375, 0.009750>, <-0.295026, 2.387375, 0.000000>, <-0.296965, 2.387375, -0.009750>, <-0.302488, 2.387375, -0.018015>, <-0.310753, 2.387375, -0.023538>, <-0.320503, 2.387375, -0.025477>, <-0.330253, 2.387375, -0.023538>, <-0.338518, 2.387375, -0.018015>, <-0.344041, 2.387375, -0.009750>, <-0.334291, 2.379564, -0.000000>, <-0.333241, 2.379564, 0.005276>, 
			<-0.330253, 2.379564, 0.009750>, <-0.325779, 2.379564, 0.012739>, <-0.320503, 2.379564, 0.013788>, <-0.315226, 2.379564, 0.012739>, <-0.310753, 2.379564, 0.009750>, <-0.307764, 2.379564, 0.005276>, <-0.306715, 2.379564, -0.000000>, <-0.307764, 2.379564, -0.005276>, <-0.310753, 2.379564, -0.009750>, <-0.315226, 2.379564, -0.012739>, <-0.320503, 2.379564, -0.013788>, 
			<-0.325779, 2.379564, -0.012739>, <-0.330253, 2.379564, -0.009750>, <-0.333241, 2.379564, -0.005276>, <-0.320503, 2.448882, -0.000000>, <-0.320503, 2.376822, -0.000000>}
	 //#local average_center = <-0.320503, 2.412852, -0.000000>;
	 normal_vectors { 114, <0.418540, -0.907921, -0.022464>, <0.353102, -0.924082, -0.146260>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.677747, -0.734948, 0.022578>, <0.642967, -0.727193, -0.240380>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.642967, -0.727193, -0.240380>, <-0.677747, -0.734948, 0.022578>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.261932, -0.707599, 0.656274>, <0.000000, -0.752769, 0.658285>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.690908, -0.345848, -0.634851>, <-0.855231, -0.383155, -0.348957>, <-0.912065, -0.409068, 0.028309>, <-0.828382, -0.382443, 0.409293>, <-0.634851, -0.345848, 0.690908>, 
			<-0.348957, -0.383155, 0.855231>, <0.028309, -0.409068, 0.912065>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.707107, 0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.707107, 0.000000, -0.707107>, <-0.907221, -0.039720, -0.418775>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.418775, -0.039720, 0.907221>, <-0.028393, 0.028393, 0.999194>, <0.382683, 0.000000, 0.923880>, <0.707107, 0.000000, 0.707107>, <0.907221, -0.039720, 0.418775>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, -0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.353478, 0.383160, 0.853371>, 
			<0.033749, 0.419315, 0.907213>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.280222, 0.734948, 0.617517>, <-0.023971, 0.727193, 0.686014>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, -0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 0>, 0, <17, 16, 0>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <40, 39, 23>, 0, <23, 24, 40>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <44, 43, 27>, 0, 
			<27, 28, 44>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <75, 59, 60>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 0>, <17, 16, 0>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <40, 39, 23>, <23, 24, 40>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <44, 43, 27>, 
			<27, 28, 44>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <60, 59, 43>, <43, 44, 60>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <75, 59, 60>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_3_LeftForearm = mesh2{
	 vertex_vectors { 112, <-0.367519, 2.069592, 0.000000>, <-0.370738, 2.070410, 0.016698>, <-0.379905, 2.072740, 0.030853>, <-0.393624, 2.076227, 0.040312>, <-0.409807, 2.080341, 0.043633>, <-0.425990, 2.084455, 0.040312>, <-0.439709, 2.087942, 0.030853>, <-0.448876, 2.090272, 0.016698>, <-0.452095, 2.091090, 0.000000>, <-0.448876, 2.090272, -0.016698>, 
			<-0.439709, 2.087942, -0.030853>, <-0.425990, 2.084455, -0.040312>, <-0.409807, 2.080341, -0.043633>, <-0.393624, 2.076227, -0.040312>, <-0.379905, 2.072740, -0.030853>, <-0.370738, 2.070410, -0.016698>, <-0.298993, 2.373018, 0.000000>, <-0.301597, 2.373679, 0.013507>, <-0.309012, 2.375564, 0.024958>, <-0.320110, 2.378385, 0.032609>, <-0.333201, 2.381713, 0.035296>, 
			<-0.346292, 2.385040, 0.032609>, <-0.357390, 2.387861, 0.024958>, <-0.364805, 2.389746, 0.013507>, <-0.367409, 2.390408, 0.000000>, <-0.364805, 2.389746, -0.013507>, <-0.357390, 2.387861, -0.024958>, <-0.346292, 2.385040, -0.032609>, <-0.333201, 2.381713, -0.035296>, <-0.320110, 2.378385, -0.032609>, <-0.309012, 2.375564, -0.024958>, <-0.301597, 2.373679, -0.013507>, 
			<-0.381096, 2.059884, 0.013613>, <-0.378472, 2.059217, 0.000000>, <-0.381096, 2.059884, -0.013613>, <-0.388570, 2.061784, -0.025154>, <-0.399755, 2.064627, -0.032866>, <-0.412949, 2.067981, -0.035574>, <-0.426143, 2.071335, -0.032866>, <-0.437328, 2.074178, -0.025154>, <-0.444801, 2.076078, -0.013613>, <-0.447426, 2.076745, 0.000000>, <-0.444801, 2.076078, 0.013613>, 
			<-0.437328, 2.074178, 0.025154>, <-0.426143, 2.071335, 0.032866>, <-0.412949, 2.067981, 0.035574>, <-0.399755, 2.064627, 0.032866>, <-0.388570, 2.061784, 0.025154>, <-0.407155, 2.057156, 0.003431>, <-0.406494, 2.056988, 0.000000>, <-0.407155, 2.057156, -0.003431>, <-0.409038, 2.057634, -0.006339>, <-0.411857, 2.058351, -0.008282>, <-0.415182, 2.059196, -0.008965>, 
			<-0.418507, 2.060041, -0.008282>, <-0.421325, 2.060758, -0.006339>, <-0.423209, 2.061236, -0.003431>, <-0.423870, 2.061405, 0.000000>, <-0.423209, 2.061236, 0.003431>, <-0.421325, 2.060758, 0.006339>, <-0.418507, 2.060041, 0.008282>, <-0.415182, 2.059196, 0.008965>, <-0.411857, 2.058351, 0.008282>, <-0.409038, 2.057634, 0.006339>, <-0.304313, 2.384505, 0.000000>, 
			<-0.306328, 2.385017, 0.010451>, <-0.312066, 2.386476, 0.019311>, <-0.320652, 2.388658, 0.025231>, <-0.330781, 2.391233, 0.027310>, <-0.340910, 2.393808, 0.025231>, <-0.349497, 2.395990, 0.019311>, <-0.355234, 2.397449, 0.010451>, <-0.357249, 2.397961, 0.000000>, <-0.355234, 2.397449, -0.010451>, <-0.349497, 2.395990, -0.019311>, <-0.340910, 2.393808, -0.025231>, 
			<-0.330781, 2.391233, -0.027310>, <-0.320652, 2.388658, -0.025231>, <-0.312066, 2.386476, -0.019311>, <-0.306328, 2.385017, -0.010451>, <-0.319317, 2.397906, 0.000000>, <-0.320015, 2.398084, 0.003623>, <-0.322004, 2.398589, 0.006694>, <-0.324981, 2.399346, 0.008746>, <-0.328492, 2.400238, 0.009467>, <-0.332003, 2.401131, 0.008746>, <-0.334980, 2.401888, 0.006694>, 
			<-0.336969, 2.402393, 0.003623>, <-0.337667, 2.402571, 0.000000>, <-0.336969, 2.402393, -0.003623>, <-0.334980, 2.401888, -0.006694>, <-0.332003, 2.401131, -0.008746>, <-0.328492, 2.400238, -0.009467>, <-0.324981, 2.399346, -0.008746>, <-0.322004, 2.398589, -0.006694>, <-0.320015, 2.398084, -0.003623>, <-0.347032, 2.150393, -0.018053>, <-0.356942, 2.152912, -0.033357>, 
			<-0.371775, 2.156683, -0.043583>, <-0.389271, 2.161130, -0.047174>, <-0.406767, 2.165577, -0.043583>, <-0.421600, 2.169348, -0.033357>, <-0.431511, 2.171867, -0.018053>, <-0.434991, 2.172752, 0.000000>, <-0.431511, 2.171867, 0.018053>, <-0.421600, 2.169348, 0.033357>, <-0.406767, 2.165577, 0.043583>, <-0.389271, 2.161130, 0.047174>, <-0.371775, 2.156683, 0.043583>, 
			<-0.356942, 2.152912, 0.033357>, <-0.347032, 2.150393, 0.018053>, <-0.343551, 2.149509, 0.000000>}
	 //#local average_center = <-0.374240, 2.220262, 0.000000>;
	 normal_vectors { 112, <-0.821483, 0.569170, 0.034808>, <-0.771555, 0.541824, -0.333361>, <-0.630440, 0.415751, -0.655513>, <-0.336204, 0.393457, -0.855663>, <0.012342, 0.304860, -0.952317>, <0.405628, 0.242595, -0.881257>, <0.724119, 0.124544, -0.678337>, <0.912557, 0.023535, -0.408271>, <0.995263, 0.092715, -0.029257>, <0.927350, -0.015574, 0.373871>, 
			<0.724119, 0.124544, 0.678337>, <0.405628, 0.242595, 0.881257>, <0.012342, 0.304860, 0.952317>, <-0.336204, 0.393457, 0.855663>, <-0.630440, 0.415751, 0.655513>, <-0.782612, 0.507541, 0.360445>, <-0.997058, -0.073036, 0.023262>, <-0.907298, -0.185341, -0.377436>, <-0.698521, -0.130480, -0.703594>, <-0.411984, -0.311245, -0.856385>, <-0.028771, -0.363766, -0.931046>, 
			<0.311990, -0.450384, -0.836550>, <0.608360, -0.462677, -0.644847>, <0.696561, -0.610423, -0.377076>, <0.787146, -0.616053, -0.029672>, <0.749259, -0.562233, 0.350008>, <0.608360, -0.462677, 0.644847>, <0.311990, -0.450384, 0.836550>, <-0.028771, -0.363766, 0.931046>, <-0.411984, -0.311245, 0.856385>, <-0.698521, -0.130480, 0.703594>, <-0.899367, -0.142469, 0.413329>, 
			<-0.303113, 0.931307, -0.201963>, <-0.404715, 0.914263, -0.018136>, <-0.431594, 0.873783, 0.224122>, <-0.270715, 0.847134, 0.457249>, <-0.019046, 0.816230, 0.577414>, <0.225590, 0.784952, 0.577026>, <0.422814, 0.704046, 0.570567>, <0.588440, 0.661266, 0.465258>, <0.769972, 0.582601, 0.260229>, <0.747351, 0.664289, 0.013632>, <0.746743, 0.621707, -0.236337>, 
			<0.588440, 0.661266, -0.465258>, <0.422814, 0.704046, -0.570567>, <0.225590, 0.784952, -0.577026>, <-0.019046, 0.816230, -0.577414>, <-0.270715, 0.847134, -0.457249>, <0.100878, 0.992256, -0.072473>, <0.084820, 0.996338, -0.010824>, <0.074988, 0.994626, 0.071392>, <0.138578, 0.982673, 0.123088>, <0.180561, 0.965838, 0.185889>, <0.240463, 0.945994, 0.217423>, 
			<0.311223, 0.934577, 0.172356>, <0.362331, 0.925797, 0.107780>, <0.393225, 0.917944, 0.052472>, <0.401254, 0.915903, -0.010824>, <0.361106, 0.931186, -0.049943>, <0.362331, 0.925797, -0.107780>, <0.321102, 0.925496, -0.200872>, <0.240463, 0.945994, -0.217423>, <0.192182, 0.969047, -0.154964>, <0.138578, 0.982673, -0.123088>, <-0.802936, -0.595973, -0.010472>, 
			<-0.717589, -0.660586, -0.220665>, <-0.625308, -0.621490, -0.471954>, <-0.402491, -0.723891, -0.560341>, <-0.201177, -0.748935, -0.631367>, <0.033762, -0.808654, -0.587315>, <0.271069, -0.849340, -0.452927>, <0.389508, -0.898425, -0.202772>, <0.383002, -0.923556, 0.018801>, <0.420607, -0.879008, 0.224578>, <0.271069, -0.849340, 0.452927>, <0.033762, -0.808654, 0.587315>, 
			<-0.201177, -0.748935, 0.631367>, <-0.402491, -0.723891, 0.560341>, <-0.625308, -0.621490, 0.471954>, <-0.760241, -0.606826, 0.231939>, <-0.469212, -0.882946, -0.015729>, <-0.411569, -0.908489, -0.072517>, <-0.412650, -0.897323, -0.156625>, <-0.358520, -0.897855, -0.255578>, <-0.253093, -0.900527, -0.353546>, <-0.165390, -0.960174, -0.225192>, <-0.087494, -0.979975, -0.178870>, 
			<-0.032708, -0.993901, -0.105317>, <-0.009373, -0.999832, -0.015729>, <0.005590, -0.994589, 0.103736>, <-0.087494, -0.979975, 0.178870>, <-0.147523, -0.951488, 0.270013>, <-0.253093, -0.900527, 0.353546>, <-0.341363, -0.915444, 0.213154>, <-0.412650, -0.897323, 0.156625>, <-0.457544, -0.885911, 0.076252>, <-0.896583, 0.222902, 0.382692>, <-0.686489, 0.169498, 0.707109>, 
			<-0.372066, 0.089574, 0.923874>, <-0.001180, -0.004701, 0.999988>, <0.369703, -0.098977, 0.923863>, <0.684121, -0.178899, 0.707088>, <0.876344, -0.237514, 0.419057>, <0.965853, -0.250501, 0.066158>, <0.902661, -0.241421, -0.356256>, <0.684121, -0.178899, -0.707088>, <0.369703, -0.098977, -0.923863>, <-0.001180, -0.004701, -0.999988>, <-0.372066, 0.089574, -0.923874>, 
			<-0.686489, 0.169498, -0.707109>, <-0.896583, 0.222902, -0.382692>, <-0.966429, 0.256933, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <49, 50, 56>, 0, <49, 56, 57>, 0, <50, 51, 55>, 0, <50, 55, 56>, 0, <51, 52, 54>, 0, <51, 54, 55>, 0, <52, 53, 54>, 0, <60, 61, 62>, 0, <62, 59, 60>, 0, <62, 63, 59>, 0, 
			<63, 58, 59>, 0, <63, 48, 58>, 0, <48, 49, 57>, 0, <48, 57, 58>, 0, <83, 84, 85>, 0, <85, 82, 83>, 0, <85, 86, 82>, 0, <86, 81, 82>, 0, <86, 87, 81>, 0, <87, 88, 80>, 0, <87, 80, 81>, 0, 
			<88, 89, 95>, 0, <88, 95, 80>, 0, <89, 90, 94>, 0, <89, 94, 95>, 0, <90, 91, 93>, 0, <90, 93, 94>, 0, <91, 92, 93>, 0, <0, 111, 15>, 0, <111, 96, 15>, 0, <15, 96, 14>, 0, <96, 97, 14>, 0, 
			<14, 97, 13>, 0, <97, 98, 13>, 0, <13, 98, 12>, 0, <98, 99, 12>, 0, <12, 99, 11>, 0, <99, 100, 11>, 0, <11, 100, 10>, 0, <100, 101, 10>, 0, <10, 101, 9>, 0, <101, 102, 9>, 0, <9, 102, 103>, 0, 
			<9, 103, 8>, 0, <8, 103, 104>, 0, <8, 104, 7>, 0, <7, 104, 105>, 0, <7, 105, 6>, 0, <6, 105, 106>, 0, <6, 106, 5>, 0, <5, 106, 107>, 0, <5, 107, 4>, 0, <4, 107, 108>, 0, <4, 108, 3>, 0, 
			<3, 108, 109>, 0, <3, 109, 2>, 0, <2, 109, 110>, 0, <2, 110, 1>, 0, <1, 110, 111>, 0, <111, 0, 1>, 0, <33, 32, 1>, 0, <1, 0, 33>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <35, 34, 15>, 0, 
			<15, 14, 35>, 0, <13, 36, 35>, 0, <13, 35, 14>, 0, <12, 37, 36>, 0, <12, 36, 13>, 0, <11, 38, 37>, 0, <11, 37, 12>, 0, <39, 38, 11>, 0, <11, 10, 39>, 0, <40, 39, 10>, 0, <10, 9, 40>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 8>, 0, <42, 41, 8>, 0, <6, 43, 42>, 0, <42, 7, 6>, 0, <5, 44, 43>, 0, <43, 6, 5>, 0, <4, 45, 5>, 0, <45, 44, 5>, 0, <3, 46, 4>, 0, 
			<46, 45, 4>, 0, <2, 47, 3>, 0, <47, 46, 3>, 0, <1, 32, 47>, 0, <1, 47, 2>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <35, 51, 50>, 0, <35, 50, 34>, 0, 
			<36, 52, 51>, 0, <36, 51, 35>, 0, <37, 53, 52>, 0, <37, 52, 36>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <39, 55, 54>, 0, <54, 38, 39>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 43>, 0, <60, 59, 43>, 0, <45, 61, 60>, 0, <60, 44, 45>, 0, <46, 62, 45>, 0, <62, 61, 45>, 0, 
			<47, 63, 46>, 0, <63, 62, 46>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 17>, 0, <66, 65, 17>, 0, <19, 67, 66>, 0, <19, 66, 18>, 0, <68, 67, 19>, 0, 
			<19, 20, 68>, 0, <69, 68, 20>, 0, <20, 21, 69>, 0, <70, 69, 21>, 0, <21, 22, 70>, 0, <23, 71, 70>, 0, <23, 70, 22>, 0, <24, 72, 71>, 0, <24, 71, 23>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<74, 73, 25>, 0, <25, 26, 74>, 0, <27, 75, 74>, 0, <74, 26, 27>, 0, <28, 76, 75>, 0, <75, 27, 28>, 0, <29, 77, 76>, 0, <76, 28, 29>, 0, <30, 78, 29>, 0, <78, 77, 29>, 0, <31, 79, 78>, 0, 
			<78, 30, 31>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 66>, 0, <83, 82, 66>, 0, <84, 83, 67>, 0, <67, 68, 84>, 0, 
			<85, 84, 68>, 0, <68, 69, 85>, 0, <86, 85, 69>, 0, <69, 70, 86>, 0, <87, 86, 70>, 0, <70, 71, 87>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <74, 90, 89>, 0, 
			<89, 73, 74>, 0, <75, 91, 90>, 0, <90, 74, 75>, 0, <76, 92, 91>, 0, <91, 75, 76>, 0, <77, 93, 92>, 0, <92, 76, 77>, 0, <78, 94, 93>, 0, <93, 77, 78>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <96, 111, 16>, 0, <16, 31, 96>, 0, <97, 96, 31>, 0, <31, 30, 97>, 0, <98, 97, 30>, 0, <30, 29, 98>, 0, <99, 98, 29>, 0, <29, 28, 99>, 0, <100, 99, 28>, 0, 
			<28, 27, 100>, 0, <101, 100, 27>, 0, <27, 26, 101>, 0, <102, 101, 26>, 0, <26, 25, 102>, 0, <24, 103, 25>, 0, <103, 102, 25>, 0, <23, 104, 24>, 0, <104, 103, 24>, 0, <22, 105, 104>, 0, <104, 23, 22>, 0, 
			<21, 106, 105>, 0, <105, 22, 21>, 0, <20, 107, 106>, 0, <106, 21, 20>, 0, <19, 108, 107>, 0, <107, 20, 19>, 0, <18, 109, 108>, 0, <108, 19, 18>, 0, <17, 110, 109>, 0, <109, 18, 17>, 0, <16, 111, 110>, 0, 
			<110, 17, 16>, 0}
	 normal_indices { 220, <49, 50, 56>, <49, 56, 57>, <50, 51, 55>, <50, 55, 56>, <51, 52, 54>, <51, 54, 55>, <52, 53, 54>, <60, 61, 62>, <62, 59, 60>, <62, 63, 59>, 
			<63, 58, 59>, <63, 48, 58>, <48, 49, 57>, <48, 57, 58>, <83, 84, 85>, <85, 82, 83>, <85, 86, 82>, <86, 81, 82>, <86, 87, 81>, <87, 88, 80>, <87, 80, 81>, 
			<88, 89, 95>, <88, 95, 80>, <89, 90, 94>, <89, 94, 95>, <90, 91, 93>, <90, 93, 94>, <91, 92, 93>, <0, 111, 15>, <111, 96, 15>, <15, 96, 14>, <96, 97, 14>, 
			<14, 97, 13>, <97, 98, 13>, <13, 98, 12>, <98, 99, 12>, <12, 99, 11>, <99, 100, 11>, <11, 100, 10>, <100, 101, 10>, <10, 101, 9>, <101, 102, 9>, <9, 102, 103>, 
			<9, 103, 8>, <8, 103, 104>, <8, 104, 7>, <7, 104, 105>, <7, 105, 6>, <6, 105, 106>, <6, 106, 5>, <5, 106, 107>, <5, 107, 4>, <4, 107, 108>, <4, 108, 3>, 
			<3, 108, 109>, <3, 109, 2>, <2, 109, 110>, <2, 110, 1>, <1, 110, 111>, <111, 0, 1>, <33, 32, 1>, <1, 0, 33>, <34, 33, 0>, <0, 15, 34>, <35, 34, 15>, 
			<15, 14, 35>, <13, 36, 35>, <13, 35, 14>, <12, 37, 36>, <12, 36, 13>, <11, 38, 37>, <11, 37, 12>, <39, 38, 11>, <11, 10, 39>, <40, 39, 10>, <10, 9, 40>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 8>, <42, 41, 8>, <6, 43, 42>, <42, 7, 6>, <5, 44, 43>, <43, 6, 5>, <4, 45, 5>, <45, 44, 5>, <3, 46, 4>, 
			<46, 45, 4>, <2, 47, 3>, <47, 46, 3>, <1, 32, 47>, <1, 47, 2>, <49, 48, 32>, <32, 33, 49>, <50, 49, 33>, <33, 34, 50>, <35, 51, 50>, <35, 50, 34>, 
			<36, 52, 51>, <36, 51, 35>, <37, 53, 52>, <37, 52, 36>, <54, 53, 37>, <37, 38, 54>, <39, 55, 54>, <54, 38, 39>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 57>, <57, 41, 42>, <43, 59, 42>, <59, 58, 42>, <44, 60, 43>, <60, 59, 43>, <45, 61, 60>, <60, 44, 45>, <46, 62, 45>, <62, 61, 45>, 
			<47, 63, 46>, <63, 62, 46>, <32, 48, 47>, <48, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 17>, <66, 65, 17>, <19, 67, 66>, <19, 66, 18>, <68, 67, 19>, 
			<19, 20, 68>, <69, 68, 20>, <20, 21, 69>, <70, 69, 21>, <21, 22, 70>, <23, 71, 70>, <23, 70, 22>, <24, 72, 71>, <24, 71, 23>, <73, 72, 24>, <24, 25, 73>, 
			<74, 73, 25>, <25, 26, 74>, <27, 75, 74>, <74, 26, 27>, <28, 76, 75>, <75, 27, 28>, <29, 77, 76>, <76, 28, 29>, <30, 78, 29>, <78, 77, 29>, <31, 79, 78>, 
			<78, 30, 31>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 66>, <83, 82, 66>, <84, 83, 67>, <67, 68, 84>, 
			<85, 84, 68>, <68, 69, 85>, <86, 85, 69>, <69, 70, 86>, <87, 86, 70>, <70, 71, 87>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <74, 90, 89>, 
			<89, 73, 74>, <75, 91, 90>, <90, 74, 75>, <76, 92, 91>, <91, 75, 76>, <77, 93, 92>, <92, 76, 77>, <78, 94, 93>, <93, 77, 78>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>, <96, 111, 16>, <16, 31, 96>, <97, 96, 31>, <31, 30, 97>, <98, 97, 30>, <30, 29, 98>, <99, 98, 29>, <29, 28, 99>, <100, 99, 28>, 
			<28, 27, 100>, <101, 100, 27>, <27, 26, 101>, <102, 101, 26>, <26, 25, 102>, <24, 103, 25>, <103, 102, 25>, <23, 104, 24>, <104, 103, 24>, <22, 105, 104>, <104, 23, 22>, 
			<21, 106, 105>, <105, 22, 21>, <20, 107, 106>, <106, 21, 20>, <19, 108, 107>, <107, 20, 19>, <18, 109, 108>, <108, 19, 18>, <17, 110, 109>, <109, 18, 17>, <16, 111, 110>, 
			<110, 17, 16>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_4_LeftHand = mesh2{
	 vertex_vectors { 65, <-0.286742, 2.487944, -0.015567>, <-0.295618, 2.477366, -0.014382>, <-0.303143, 2.468398, -0.011008>, <-0.308171, 2.462406, -0.005957>, <-0.309936, 2.460302, -0.000000>, <-0.308171, 2.462406, 0.005957>, <-0.303143, 2.468398, 0.011008>, <-0.295618, 2.477366, 0.014382>, <-0.286742, 2.487944, 0.015567>, <-0.277866, 2.498522, 0.014382>, 
			<-0.270341, 2.507490, 0.011008>, <-0.265313, 2.513482, 0.005957>, <-0.263547, 2.515586, -0.000000>, <-0.265313, 2.513482, -0.005957>, <-0.270341, 2.507490, -0.011008>, <-0.277866, 2.498522, -0.014382>, <-0.279987, 2.482276, -0.028764>, <-0.296388, 2.462730, -0.026574>, <-0.310292, 2.446160, -0.020339>, <-0.319582, 2.435088, -0.011008>, <-0.322845, 2.431200, -0.000000>, 
			<-0.319582, 2.435088, 0.011008>, <-0.310292, 2.446160, 0.020339>, <-0.296388, 2.462730, 0.026574>, <-0.279987, 2.482276, 0.028764>, <-0.263586, 2.501822, 0.026574>, <-0.249682, 2.518392, 0.020339>, <-0.240392, 2.529464, 0.011008>, <-0.237129, 2.533352, -0.000000>, <-0.240392, 2.529464, -0.011008>, <-0.249682, 2.518392, -0.020339>, <-0.263586, 2.501822, -0.026574>, 
			<-0.269877, 2.473793, -0.037582>, <-0.291306, 2.448255, -0.034721>, <-0.309473, 2.426605, -0.026574>, <-0.321611, 2.412139, -0.014382>, <-0.325874, 2.407059, -0.000000>, <-0.321611, 2.412139, 0.014382>, <-0.309473, 2.426605, 0.026574>, <-0.291306, 2.448255, 0.034721>, <-0.269877, 2.473793, 0.037582>, <-0.248449, 2.499331, 0.034721>, <-0.230282, 2.520981, 0.026574>, 
			<-0.218143, 2.535447, 0.014382>, <-0.213881, 2.540527, -0.000000>, <-0.218143, 2.535447, -0.014382>, <-0.230282, 2.520981, -0.026574>, <-0.248449, 2.499331, -0.034721>, <-0.257952, 2.463787, -0.040678>, <-0.281147, 2.436145, -0.037582>, <-0.300810, 2.412711, -0.028764>, <-0.313949, 2.397053, -0.015567>, <-0.318563, 2.391555, -0.000000>, <-0.313949, 2.397053, 0.015567>, 
			<-0.300810, 2.412711, 0.028764>, <-0.281147, 2.436145, 0.037582>, <-0.257952, 2.463787, 0.040678>, <-0.234758, 2.491429, 0.037582>, <-0.215095, 2.514863, 0.028764>, <-0.201956, 2.530521, 0.015567>, <-0.197342, 2.536019, -0.000000>, <-0.201956, 2.530521, -0.015567>, <-0.215095, 2.514863, -0.028764>, <-0.234758, 2.491429, -0.037582>, <-0.289114, 2.489935, -0.000000>}
	 //#local average_center = <-0.273878, 2.477150, -0.000000>;
	 normal_vectors { 65, <0.689277, -0.591047, 0.419000>, <0.740132, -0.541085, 0.399290>, <0.799461, -0.505228, 0.324973>, <0.862913, -0.470475, 0.184483>, <0.879308, -0.475567, -0.025576>, <0.852996, -0.483731, -0.195963>, <0.799461, -0.505228, -0.324973>, <0.740132, -0.541085, -0.399290>, <0.689277, -0.591047, -0.419000>, <0.672269, -0.648191, -0.357636>, 
			<0.636377, -0.699583, -0.324973>, <0.613171, -0.768106, -0.184483>, <0.636458, -0.771312, 0.000000>, <0.613171, -0.768106, 0.184483>, <0.636377, -0.699583, 0.324973>, <0.672269, -0.648191, 0.357636>, <0.569069, -0.464819, 0.678309>, <0.633697, -0.377519, 0.675209>, <0.758972, -0.320754, 0.566638>, <0.882580, -0.258094, 0.392988>, <0.968319, -0.249017, 0.018669>, 
			<0.892559, -0.284572, -0.349795>, <0.758972, -0.320754, -0.566638>, <0.633697, -0.377519, -0.675209>, <0.569069, -0.464819, -0.678309>, <0.500807, -0.561285, -0.658902>, <0.447675, -0.691743, -0.566638>, <0.407432, -0.824354, -0.392988>, <0.451120, -0.891752, -0.035624>, <0.388024, -0.844750, 0.368557>, <0.447675, -0.691743, 0.566638>, <0.500807, -0.561285, 0.658902>, 
			<0.339393, -0.284784, 0.896499>, <0.415477, -0.136163, 0.899354>, <0.592298, -0.032217, 0.805075>, <0.838580, 0.125608, 0.530101>, <0.988684, 0.150013, 0.000000>, <0.838580, 0.125608, -0.530101>, <0.592298, -0.032217, -0.805075>, <0.415477, -0.136163, -0.899354>, <0.339393, -0.284784, -0.896499>, <0.206241, -0.385521, -0.899354>, <0.134579, -0.577705, -0.805075>, 
			<0.068996, -0.831860, -0.550680>, <-0.017646, -0.999113, 0.038231>, <0.021303, -0.795376, 0.605742>, <0.134579, -0.577705, 0.805075>, <0.206241, -0.385521, 0.899354>, <-0.487246, 0.408848, 0.771645>, <-0.488612, 0.592893, 0.640107>, <-0.028144, 0.573292, 0.818868>, <-0.309470, 0.860734, 0.404185>, <0.757416, 0.652933, 0.000000>, <-0.065340, 0.844736, -0.531179>, 
			<-0.376107, 0.712898, -0.591879>, <-0.200094, 0.420727, -0.884845>, <-0.378586, 0.317671, -0.869343>, <-0.589060, 0.277416, -0.758979>, <-0.569469, -0.071834, -0.818868>, <-0.870998, -0.129685, -0.473860>, <-0.740042, -0.672561, 0.000000>, <-0.745372, -0.375226, 0.551023>, <-0.798736, 0.334499, 0.500132>, <-0.231593, -0.082629, 0.969297>, <0.766044, -0.642788, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 126, <0, 64, 1>, 0, <1, 64, 2>, 0, <2, 64, 3>, 0, <3, 64, 4>, 0, <4, 64, 5>, 0, <5, 64, 6>, 0, <6, 64, 7>, 0, <7, 64, 8>, 0, <8, 64, 9>, 0, <9, 64, 10>, 0, 
			<10, 64, 11>, 0, <11, 64, 12>, 0, <12, 64, 13>, 0, <13, 64, 14>, 0, <14, 64, 15>, 0, <15, 64, 0>, 0, <1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 18>, 0, 
			<3, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 4>, 0, <21, 20, 4>, 0, <5, 6, 22>, 0, <5, 22, 21>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, 
			<25, 24, 8>, 0, <8, 9, 25>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <11, 27, 26>, 0, <11, 26, 10>, 0, <28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <13, 14, 30>, 0, 
			<13, 30, 29>, 0, <14, 15, 31>, 0, <14, 31, 30>, 0, <0, 16, 31>, 0, <0, 31, 15>, 0, <17, 33, 32>, 0, <32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 34>, 0, <34, 18, 19>, 0, 
			<20, 36, 35>, 0, <35, 19, 20>, 0, <37, 36, 20>, 0, <20, 21, 37>, 0, <38, 37, 21>, 0, <21, 22, 38>, 0, <39, 38, 22>, 0, <22, 23, 39>, 0, <40, 39, 23>, 0, <23, 24, 40>, 0, <25, 41, 40>, 0, 
			<40, 24, 25>, 0, <26, 42, 41>, 0, <41, 25, 26>, 0, <27, 43, 42>, 0, <42, 26, 27>, 0, <28, 44, 43>, 0, <28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <46, 45, 29>, 0, <29, 30, 46>, 0, 
			<47, 46, 30>, 0, <30, 31, 47>, 0, <32, 47, 31>, 0, <31, 16, 32>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, <34, 50, 49>, 0, <49, 33, 34>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <36, 52, 35>, 0, 
			<52, 51, 35>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, <38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <41, 57, 56>, 0, <56, 40, 41>, 0, 
			<42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <44, 60, 59>, 0, <59, 43, 44>, 0, <61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, 
			<46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <48, 62, 63>, 0, <49, 54, 55>, 0, <49, 55, 56>, 0, <51, 53, 54>, 0, <53, 51, 52>, 0, <54, 49, 50>, 0, <54, 50, 51>, 0, <56, 57, 48>, 0, 
			<56, 48, 49>, 0, <57, 58, 62>, 0, <57, 62, 48>, 0, <58, 59, 62>, 0, <59, 60, 61>, 0, <59, 61, 62>, 0}
	 normal_indices { 126, <0, 64, 1>, <1, 64, 2>, <2, 64, 3>, <3, 64, 4>, <4, 64, 5>, <5, 64, 6>, <6, 64, 7>, <7, 64, 8>, <8, 64, 9>, <9, 64, 10>, 
			<10, 64, 11>, <11, 64, 12>, <12, 64, 13>, <13, 64, 14>, <14, 64, 15>, <15, 64, 0>, <1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 18>, 
			<3, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 4>, <21, 20, 4>, <5, 6, 22>, <5, 22, 21>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, 
			<25, 24, 8>, <8, 9, 25>, <10, 26, 25>, <10, 25, 9>, <11, 27, 26>, <11, 26, 10>, <28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <13, 14, 30>, 
			<13, 30, 29>, <14, 15, 31>, <14, 31, 30>, <0, 16, 31>, <0, 31, 15>, <17, 33, 32>, <32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 34>, <34, 18, 19>, 
			<20, 36, 35>, <35, 19, 20>, <37, 36, 20>, <20, 21, 37>, <38, 37, 21>, <21, 22, 38>, <39, 38, 22>, <22, 23, 39>, <40, 39, 23>, <23, 24, 40>, <25, 41, 40>, 
			<40, 24, 25>, <26, 42, 41>, <41, 25, 26>, <27, 43, 42>, <42, 26, 27>, <28, 44, 43>, <28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <46, 45, 29>, <29, 30, 46>, 
			<47, 46, 30>, <30, 31, 47>, <32, 47, 31>, <31, 16, 32>, <33, 49, 48>, <48, 32, 33>, <34, 50, 49>, <49, 33, 34>, <35, 51, 50>, <50, 34, 35>, <36, 52, 35>, 
			<52, 51, 35>, <37, 53, 52>, <52, 36, 37>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, <38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <41, 57, 56>, <56, 40, 41>, 
			<42, 58, 57>, <57, 41, 42>, <43, 59, 58>, <58, 42, 43>, <44, 60, 59>, <59, 43, 44>, <61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, 
			<46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <48, 62, 63>, <49, 54, 55>, <49, 55, 56>, <51, 53, 54>, <53, 51, 52>, <54, 49, 50>, <54, 50, 51>, <56, 57, 48>, 
			<56, 48, 49>, <57, 58, 62>, <57, 62, 48>, <58, 59, 62>, <59, 60, 61>, <59, 61, 62>}
	 uv_indices { 126, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_5_RightForearm = mesh2{
	 vertex_vectors { 112, <0.267141, 1.305940, 0.000000>, <0.270240, 1.304744, 0.016698>, <0.279065, 1.301339, 0.030853>, <0.292271, 1.296244, 0.040312>, <0.307850, 1.290233, 0.043633>, <0.323428, 1.284223, 0.040312>, <0.336635, 1.279127, 0.030853>, <0.345459, 1.275722, 0.016698>, <0.348558, 1.274527, 0.000000>, <0.345459, 1.275722, -0.016698>, 
			<0.336635, 1.279127, -0.030853>, <0.323428, 1.284223, -0.040312>, <0.307850, 1.290233, -0.043633>, <0.292271, 1.296244, -0.040312>, <0.279065, 1.301339, -0.030853>, <0.270240, 1.304744, -0.016698>, <0.162987, 1.012827, 0.000000>, <0.165494, 1.011860, 0.013507>, <0.172632, 1.009106, 0.024958>, <0.183315, 1.004984, 0.032609>, <0.195917, 1.000122, 0.035296>, 
			<0.208518, 0.995260, 0.032609>, <0.219202, 0.991138, 0.024958>, <0.226340, 0.988384, 0.013507>, <0.228846, 0.987417, 0.000000>, <0.226340, 0.988384, -0.013507>, <0.219202, 0.991138, -0.024958>, <0.208518, 0.995260, -0.032609>, <0.195917, 1.000122, -0.035296>, <0.183315, 1.004984, -0.032609>, <0.172632, 1.009106, -0.024958>, <0.165494, 1.011860, -0.013507>, 
			<0.281778, 1.313962, 0.013613>, <0.279251, 1.314936, 0.000000>, <0.281778, 1.313962, -0.013613>, <0.288972, 1.311186, -0.025154>, <0.299739, 1.307032, -0.032866>, <0.312440, 1.302131, -0.035574>, <0.325141, 1.297231, -0.032866>, <0.335908, 1.293077, -0.025154>, <0.343103, 1.290301, -0.013613>, <0.345629, 1.289326, 0.000000>, <0.343103, 1.290301, 0.013613>, 
			<0.335908, 1.293077, 0.025154>, <0.325141, 1.297231, 0.032866>, <0.312440, 1.302131, 0.035574>, <0.299739, 1.307032, 0.032866>, <0.288972, 1.311186, 0.025154>, <0.307976, 1.313569, 0.003431>, <0.307340, 1.313815, 0.000000>, <0.307976, 1.313569, -0.003431>, <0.309789, 1.312870, -0.006339>, <0.312503, 1.311823, -0.008282>, <0.315703, 1.310588, -0.008965>, 
			<0.318904, 1.309353, -0.008282>, <0.321617, 1.308306, -0.006339>, <0.323430, 1.307607, -0.003431>, <0.324067, 1.307361, 0.000000>, <0.323430, 1.307607, 0.003431>, <0.321617, 1.308306, 0.006339>, <0.318904, 1.309353, 0.008282>, <0.315703, 1.310588, 0.008965>, <0.312503, 1.311823, 0.008282>, <0.309789, 1.312870, 0.006339>, <0.166902, 1.000788, 0.000000>, 
			<0.168841, 1.000040, 0.010451>, <0.174365, 0.997909, 0.019311>, <0.182631, 0.994720, 0.025231>, <0.192381, 0.990958, 0.027310>, <0.202131, 0.987196, 0.025231>, <0.210397, 0.984007, 0.019311>, <0.215920, 0.981876, 0.010451>, <0.217860, 0.981127, 0.000000>, <0.215920, 0.981876, -0.010451>, <0.210397, 0.984007, -0.019311>, <0.202131, 0.987196, -0.025231>, 
			<0.192381, 0.990958, -0.027310>, <0.182631, 0.994720, -0.025231>, <0.174365, 0.997909, -0.019311>, <0.168841, 1.000040, -0.010451>, <0.180204, 0.985696, 0.000000>, <0.180876, 0.985437, 0.003623>, <0.182791, 0.984698, 0.006694>, <0.185656, 0.983593, 0.008746>, <0.189036, 0.982289, 0.009467>, <0.192416, 0.980985, 0.008746>, <0.195281, 0.979879, 0.006694>, 
			<0.197196, 0.979140, 0.003623>, <0.197868, 0.978881, 0.000000>, <0.197196, 0.979140, -0.003623>, <0.195281, 0.979879, -0.006694>, <0.192416, 0.980985, -0.008746>, <0.189036, 0.982289, -0.009467>, <0.185656, 0.983593, -0.008746>, <0.182791, 0.984698, -0.006694>, <0.180876, 0.985437, -0.003623>, <0.237182, 1.228151, -0.018053>, <0.246723, 1.224470, -0.033357>, 
			<0.261001, 1.218961, -0.043583>, <0.277844, 1.212463, -0.047174>, <0.294686, 1.205965, -0.043583>, <0.308964, 1.200456, -0.033357>, <0.318505, 1.196775, -0.018053>, <0.321855, 1.195482, 0.000000>, <0.318505, 1.196775, 0.018053>, <0.308964, 1.200456, 0.033357>, <0.294686, 1.205965, 0.043583>, <0.277844, 1.212463, 0.047174>, <0.261001, 1.218961, 0.043583>, 
			<0.246723, 1.224470, 0.033357>, <0.237182, 1.228151, 0.018053>, <0.233832, 1.229444, 0.000000>}
	 //#local average_center = <0.255882, 1.155541, 0.000000>;
	 normal_vectors { 112, <0.724463, -0.689314, 0.000000>, <0.759844, -0.558585, -0.332596>, <0.562455, -0.536962, -0.628742>, <0.286981, -0.430677, -0.855663>, <-0.048541, -0.301223, -0.952317>, <-0.431620, -0.192589, -0.881257>, <-0.733795, -0.037469, -0.678337>, <-0.908871, 0.085252, -0.408271>, <-0.999223, 0.026408, -0.029257>, <-0.918904, 0.125843, 0.373871>, 
			<-0.733795, -0.037469, 0.678337>, <-0.431620, -0.192589, 0.881257>, <-0.048541, -0.301223, 0.952317>, <0.286981, -0.430677, 0.855663>, <0.562455, -0.536962, 0.628742>, <0.759844, -0.558585, 0.332596>, <0.997331, 0.065387, 0.032478>, <0.939620, -0.023381, -0.341421>, <0.740107, 0.100655, -0.664914>, <0.446102, 0.259995, -0.856385>, <0.071864, 0.357756, -0.931046>, 
			<-0.256163, 0.484318, -0.836550>, <-0.525484, 0.588229, -0.614698>, <-0.642143, 0.697941, -0.317065>, <-0.740567, 0.671940, -0.007532>, <-0.729227, 0.601350, 0.326508>, <-0.525484, 0.588229, 0.614698>, <-0.256163, 0.484318, 0.836550>, <0.071864, 0.357756, 0.931046>, <0.446102, 0.259995, 0.856385>, <0.740107, 0.100655, 0.664914>, <0.925542, -0.081350, 0.369803>, 
			<0.297756, -0.923414, -0.242173>, <0.293063, -0.956093, -0.000000>, <0.297756, -0.923414, 0.242173>, <0.112319, -0.886218, 0.449446>, <-0.078244, -0.812694, 0.577414>, <-0.299990, -0.727138, 0.617476>, <-0.486450, -0.699731, 0.523204>, <-0.662966, -0.586525, 0.465258>, <-0.833844, -0.486811, 0.260229>, <-0.821107, -0.570611, 0.013632>, <-0.815435, -0.528404, -0.236337>, 
			<-0.662966, -0.586525, -0.465258>, <-0.486450, -0.699731, -0.523204>, <-0.299990, -0.727138, -0.617476>, <-0.078244, -0.812694, -0.577414>, <0.112319, -0.886218, -0.449446>, <-0.218267, -0.973194, -0.072473>, <-0.179594, -0.983741, -0.000000>, <-0.218267, -0.973194, 0.072473>, <-0.254558, -0.959192, 0.123088>, <-0.294239, -0.937480, 0.185889>, <-0.364125, -0.898780, 0.244147>, 
			<-0.422728, -0.894307, 0.146680>, <-0.469951, -0.876088, 0.107780>, <-0.499690, -0.864613, 0.052472>, <-0.507419, -0.861631, -0.010824>, <-0.469376, -0.881585, -0.049943>, <-0.469951, -0.876088, -0.107780>, <-0.434072, -0.883529, -0.175952>, <-0.364125, -0.898780, -0.244147>, <-0.306159, -0.939283, -0.154964>, <-0.254558, -0.959192, -0.123088>, <0.868165, 0.496164, -0.010472>, 
			<0.801786, 0.541228, -0.253398>, <0.667473, 0.572915, -0.475655>, <0.504566, 0.636497, -0.583339>, <0.306555, 0.732303, -0.608077>, <0.062730, 0.806924, -0.587315>, <-0.130488, 0.881473, -0.453849>, <-0.290579, 0.914176, -0.282570>, <-0.281661, 0.959252, -0.022402>, <-0.326176, 0.908421, 0.261497>, <-0.130488, 0.881473, 0.453849>, <0.062730, 0.806924, 0.587315>, 
			<0.306555, 0.732303, 0.608077>, <0.504566, 0.636497, 0.583339>, <0.667473, 0.572915, 0.475655>, <0.831173, 0.490040, 0.262701>, <0.570971, 0.820819, -0.015729>, <0.516779, 0.853042, -0.072517>, <0.516522, 0.841827, -0.156625>, <0.454230, 0.841840, -0.291514>, <0.341575, 0.885305, -0.315532>, <0.278502, 0.933662, -0.225192>, <0.203516, 0.962594, -0.178870>, 
			<0.112833, 0.988184, -0.103736>, <0.176648, 0.984274, 0.000000>, <0.112833, 0.988184, 0.103736>, <0.203516, 0.962594, 0.178870>, <0.259728, 0.927165, 0.270013>, <0.341575, 0.885305, 0.315532>, <0.443269, 0.860693, 0.250441>, <0.516522, 0.841827, 0.156625>, <0.559740, 0.825153, 0.076252>, <0.845402, -0.331126, 0.419108>, <0.661434, -0.250004, 0.707109>, 
			<0.358759, -0.133224, 0.923874>, <0.001731, 0.004528, 0.999988>, <-0.355294, 0.142278, 0.923863>, <-0.657964, 0.259056, 0.707088>, <-0.841843, 0.340135, 0.419057>, <-0.929170, 0.363684, 0.066158>, <-0.867509, 0.347146, -0.356256>, <-0.657964, 0.259056, -0.707088>, <-0.355294, 0.142278, -0.923863>, <0.001731, 0.004528, -0.999988>, <0.358759, -0.133224, -0.923874>, 
			<0.661434, -0.250004, -0.707109>, <0.845402, -0.331126, -0.419108>, <0.934700, -0.355438, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <49, 50, 56>, 0, <49, 56, 57>, 0, <50, 51, 55>, 0, <50, 55, 56>, 0, <51, 52, 54>, 0, <51, 54, 55>, 0, <52, 53, 54>, 0, <60, 61, 62>, 0, <62, 59, 60>, 0, <62, 63, 59>, 0, 
			<63, 58, 59>, 0, <63, 48, 58>, 0, <48, 49, 57>, 0, <48, 57, 58>, 0, <83, 84, 85>, 0, <85, 82, 83>, 0, <85, 86, 82>, 0, <86, 81, 82>, 0, <86, 87, 81>, 0, <87, 88, 80>, 0, <87, 80, 81>, 0, 
			<88, 89, 95>, 0, <88, 95, 80>, 0, <89, 90, 94>, 0, <89, 94, 95>, 0, <90, 91, 93>, 0, <90, 93, 94>, 0, <91, 92, 93>, 0, <0, 111, 15>, 0, <111, 96, 15>, 0, <96, 97, 14>, 0, <14, 15, 96>, 0, 
			<97, 98, 13>, 0, <13, 14, 97>, 0, <98, 99, 12>, 0, <12, 13, 98>, 0, <99, 100, 11>, 0, <11, 12, 99>, 0, <100, 101, 10>, 0, <10, 11, 100>, 0, <101, 102, 9>, 0, <9, 10, 101>, 0, <9, 102, 103>, 0, 
			<9, 103, 8>, 0, <8, 103, 104>, 0, <8, 104, 7>, 0, <7, 104, 105>, 0, <105, 6, 7>, 0, <6, 105, 106>, 0, <106, 5, 6>, 0, <5, 106, 107>, 0, <107, 4, 5>, 0, <4, 107, 108>, 0, <108, 3, 4>, 0, 
			<3, 108, 109>, 0, <109, 2, 3>, 0, <2, 109, 110>, 0, <110, 1, 2>, 0, <1, 110, 111>, 0, <111, 0, 1>, 0, <0, 33, 32>, 0, <0, 32, 1>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <14, 35, 34>, 0, 
			<34, 15, 14>, 0, <13, 36, 35>, 0, <35, 14, 13>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <11, 38, 37>, 0, <37, 12, 11>, 0, <10, 39, 11>, 0, <39, 38, 11>, 0, <9, 40, 10>, 0, <40, 39, 10>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 8>, 0, <42, 41, 8>, 0, <6, 43, 42>, 0, <6, 42, 7>, 0, <5, 44, 43>, 0, <5, 43, 6>, 0, <45, 44, 5>, 0, <5, 4, 45>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <47, 46, 3>, 0, <3, 2, 47>, 0, <32, 47, 2>, 0, <2, 1, 32>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, <34, 50, 49>, 0, <49, 33, 34>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, 
			<36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <38, 54, 53>, 0, <53, 37, 38>, 0, <39, 55, 54>, 0, <54, 38, 39>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 43>, 0, <60, 59, 43>, 0, <45, 61, 44>, 0, <61, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, 
			<63, 62, 46>, 0, <46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 65>, 0, <65, 17, 18>, 0, <19, 67, 66>, 0, <66, 18, 19>, 0, <20, 68, 19>, 0, 
			<68, 67, 19>, 0, <21, 69, 20>, 0, <69, 68, 20>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 22>, 0, <71, 70, 22>, 0, <72, 71, 23>, 0, <23, 24, 72>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<26, 74, 73>, 0, <26, 73, 25>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <28, 76, 75>, 0, <28, 75, 27>, 0, <29, 77, 76>, 0, <29, 76, 28>, 0, <78, 77, 29>, 0, <29, 30, 78>, 0, <79, 78, 30>, 0, 
			<30, 31, 79>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 66>, 0, <83, 82, 66>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 68>, 0, <85, 84, 68>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 70>, 0, <87, 86, 70>, 0, <72, 88, 87>, 0, <72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <74, 90, 89>, 0, 
			<74, 89, 73>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <78, 94, 93>, 0, <93, 77, 78>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <31, 96, 111>, 0, <31, 111, 16>, 0, <30, 97, 31>, 0, <97, 96, 31>, 0, <29, 98, 30>, 0, <98, 97, 30>, 0, <28, 99, 29>, 0, <99, 98, 29>, 0, <27, 100, 28>, 0, 
			<100, 99, 28>, 0, <26, 101, 27>, 0, <101, 100, 27>, 0, <25, 102, 26>, 0, <102, 101, 26>, 0, <24, 103, 25>, 0, <103, 102, 25>, 0, <23, 104, 24>, 0, <104, 103, 24>, 0, <22, 105, 104>, 0, <22, 104, 23>, 0, 
			<21, 106, 105>, 0, <21, 105, 22>, 0, <20, 107, 106>, 0, <20, 106, 21>, 0, <19, 108, 107>, 0, <19, 107, 20>, 0, <18, 109, 108>, 0, <18, 108, 19>, 0, <17, 110, 109>, 0, <17, 109, 18>, 0, <111, 110, 17>, 0, 
			<17, 16, 111>, 0}
	 normal_indices { 220, <49, 50, 56>, <49, 56, 57>, <50, 51, 55>, <50, 55, 56>, <51, 52, 54>, <51, 54, 55>, <52, 53, 54>, <60, 61, 62>, <62, 59, 60>, <62, 63, 59>, 
			<63, 58, 59>, <63, 48, 58>, <48, 49, 57>, <48, 57, 58>, <83, 84, 85>, <85, 82, 83>, <85, 86, 82>, <86, 81, 82>, <86, 87, 81>, <87, 88, 80>, <87, 80, 81>, 
			<88, 89, 95>, <88, 95, 80>, <89, 90, 94>, <89, 94, 95>, <90, 91, 93>, <90, 93, 94>, <91, 92, 93>, <0, 111, 15>, <111, 96, 15>, <96, 97, 14>, <14, 15, 96>, 
			<97, 98, 13>, <13, 14, 97>, <98, 99, 12>, <12, 13, 98>, <99, 100, 11>, <11, 12, 99>, <100, 101, 10>, <10, 11, 100>, <101, 102, 9>, <9, 10, 101>, <9, 102, 103>, 
			<9, 103, 8>, <8, 103, 104>, <8, 104, 7>, <7, 104, 105>, <105, 6, 7>, <6, 105, 106>, <106, 5, 6>, <5, 106, 107>, <107, 4, 5>, <4, 107, 108>, <108, 3, 4>, 
			<3, 108, 109>, <109, 2, 3>, <2, 109, 110>, <110, 1, 2>, <1, 110, 111>, <111, 0, 1>, <0, 33, 32>, <0, 32, 1>, <34, 33, 0>, <0, 15, 34>, <14, 35, 34>, 
			<34, 15, 14>, <13, 36, 35>, <35, 14, 13>, <12, 37, 36>, <36, 13, 12>, <11, 38, 37>, <37, 12, 11>, <10, 39, 11>, <39, 38, 11>, <9, 40, 10>, <40, 39, 10>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 8>, <42, 41, 8>, <6, 43, 42>, <6, 42, 7>, <5, 44, 43>, <5, 43, 6>, <45, 44, 5>, <5, 4, 45>, <46, 45, 4>, 
			<4, 3, 46>, <47, 46, 3>, <3, 2, 47>, <32, 47, 2>, <2, 1, 32>, <49, 48, 32>, <32, 33, 49>, <34, 50, 49>, <49, 33, 34>, <35, 51, 50>, <50, 34, 35>, 
			<36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <38, 54, 53>, <53, 37, 38>, <39, 55, 54>, <54, 38, 39>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 57>, <57, 41, 42>, <43, 59, 42>, <59, 58, 42>, <44, 60, 43>, <60, 59, 43>, <45, 61, 44>, <61, 60, 44>, <62, 61, 45>, <45, 46, 62>, 
			<63, 62, 46>, <46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <17, 65, 64>, <64, 16, 17>, <18, 66, 65>, <65, 17, 18>, <19, 67, 66>, <66, 18, 19>, <20, 68, 19>, 
			<68, 67, 19>, <21, 69, 20>, <69, 68, 20>, <22, 70, 21>, <70, 69, 21>, <23, 71, 22>, <71, 70, 22>, <72, 71, 23>, <23, 24, 72>, <73, 72, 24>, <24, 25, 73>, 
			<26, 74, 73>, <26, 73, 25>, <27, 75, 74>, <27, 74, 26>, <28, 76, 75>, <28, 75, 27>, <29, 77, 76>, <29, 76, 28>, <78, 77, 29>, <29, 30, 78>, <79, 78, 30>, 
			<30, 31, 79>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 66>, <83, 82, 66>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 68>, <85, 84, 68>, <70, 86, 69>, <86, 85, 69>, <71, 87, 70>, <87, 86, 70>, <72, 88, 87>, <72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <74, 90, 89>, 
			<74, 89, 73>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, <78, 94, 93>, <93, 77, 78>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>, <31, 96, 111>, <31, 111, 16>, <30, 97, 31>, <97, 96, 31>, <29, 98, 30>, <98, 97, 30>, <28, 99, 29>, <99, 98, 29>, <27, 100, 28>, 
			<100, 99, 28>, <26, 101, 27>, <101, 100, 27>, <25, 102, 26>, <102, 101, 26>, <24, 103, 25>, <103, 102, 25>, <23, 104, 24>, <104, 103, 24>, <22, 105, 104>, <22, 104, 23>, 
			<21, 106, 105>, <21, 105, 22>, <20, 107, 106>, <20, 106, 21>, <19, 108, 107>, <19, 107, 20>, <18, 109, 108>, <18, 108, 19>, <17, 110, 109>, <17, 109, 18>, <111, 110, 17>, 
			<17, 16, 111>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_6_LeftElbow = mesh2{
	 vertex_vectors { 114, <-0.428394, 2.087597, -0.000000>, <-0.427101, 2.087597, 0.006498>, <-0.423420, 2.087597, 0.012007>, <-0.417911, 2.087597, 0.015688>, <-0.411413, 2.087597, 0.016980>, <-0.404915, 2.087597, 0.015688>, <-0.399406, 2.087597, 0.012007>, <-0.395725, 2.087597, 0.006498>, <-0.394433, 2.087597, 0.000000>, <-0.395725, 2.087597, -0.006498>, 
			<-0.399406, 2.087597, -0.012007>, <-0.404915, 2.087597, -0.015688>, <-0.411413, 2.087597, -0.016980>, <-0.417911, 2.087597, -0.015688>, <-0.423420, 2.087597, -0.012007>, <-0.427101, 2.087597, -0.006498>, <-0.442789, 2.077978, -0.000000>, <-0.440401, 2.077978, 0.012007>, <-0.433599, 2.077978, 0.022186>, <-0.423420, 2.077978, 0.028988>, <-0.411413, 2.077978, 0.031376>, 
			<-0.399406, 2.077978, 0.028988>, <-0.389227, 2.077978, 0.022186>, <-0.382426, 2.077978, 0.012007>, <-0.380037, 2.077978, 0.000000>, <-0.382426, 2.077978, -0.012007>, <-0.389227, 2.077978, -0.022186>, <-0.399406, 2.077978, -0.028988>, <-0.411413, 2.077978, -0.031376>, <-0.423420, 2.077978, -0.028988>, <-0.433599, 2.077978, -0.022186>, <-0.440401, 2.077978, -0.012007>, 
			<-0.452408, 2.063583, -0.000000>, <-0.449287, 2.063583, 0.015688>, <-0.440401, 2.063583, 0.028988>, <-0.427101, 2.063583, 0.037874>, <-0.411413, 2.063583, 0.040995>, <-0.395725, 2.063583, 0.037874>, <-0.382426, 2.063583, 0.028988>, <-0.373539, 2.063583, 0.015688>, <-0.370419, 2.063583, 0.000000>, <-0.373539, 2.063583, -0.015688>, <-0.382426, 2.063583, -0.028988>, 
			<-0.395725, 2.063583, -0.037874>, <-0.411413, 2.063583, -0.040995>, <-0.427101, 2.063583, -0.037874>, <-0.440401, 2.063583, -0.028988>, <-0.449287, 2.063583, -0.015688>, <-0.455785, 2.046603, -0.000000>, <-0.452408, 2.046603, 0.016980>, <-0.442789, 2.046603, 0.031376>, <-0.428394, 2.046603, 0.040995>, <-0.411413, 2.046603, 0.044372>, <-0.394433, 2.046603, 0.040995>, 
			<-0.380037, 2.046603, 0.031376>, <-0.370419, 2.046603, 0.016980>, <-0.367041, 2.046603, 0.000000>, <-0.370419, 2.046603, -0.016980>, <-0.380037, 2.046603, -0.031376>, <-0.394433, 2.046603, -0.040995>, <-0.411413, 2.046603, -0.044372>, <-0.428394, 2.046603, -0.040995>, <-0.442789, 2.046603, -0.031376>, <-0.452408, 2.046603, -0.016980>, <-0.452408, 2.029622, -0.000000>, 
			<-0.449287, 2.029622, 0.015688>, <-0.440401, 2.029622, 0.028988>, <-0.427101, 2.029622, 0.037874>, <-0.411413, 2.029622, 0.040995>, <-0.395725, 2.029622, 0.037874>, <-0.382426, 2.029622, 0.028988>, <-0.373539, 2.029622, 0.015688>, <-0.370419, 2.029622, 0.000000>, <-0.373539, 2.029622, -0.015688>, <-0.382426, 2.029622, -0.028988>, <-0.395725, 2.029622, -0.037874>, 
			<-0.411413, 2.029622, -0.040995>, <-0.427101, 2.029622, -0.037874>, <-0.440401, 2.029622, -0.028988>, <-0.449287, 2.029622, -0.015688>, <-0.442789, 2.015227, -0.000000>, <-0.440401, 2.015227, 0.012007>, <-0.433599, 2.015227, 0.022186>, <-0.423420, 2.015227, 0.028988>, <-0.411413, 2.015227, 0.031376>, <-0.399406, 2.015227, 0.028988>, <-0.389227, 2.015227, 0.022186>, 
			<-0.382426, 2.015227, 0.012007>, <-0.380037, 2.015227, 0.000000>, <-0.382426, 2.015227, -0.012007>, <-0.389227, 2.015227, -0.022186>, <-0.399406, 2.015227, -0.028988>, <-0.411413, 2.015227, -0.031376>, <-0.423420, 2.015227, -0.028988>, <-0.433599, 2.015227, -0.022186>, <-0.440401, 2.015227, -0.012007>, <-0.428394, 2.005608, -0.000000>, <-0.427101, 2.005608, 0.006498>, 
			<-0.423420, 2.005608, 0.012007>, <-0.417911, 2.005608, 0.015688>, <-0.411413, 2.005608, 0.016980>, <-0.404915, 2.005608, 0.015688>, <-0.399406, 2.005608, 0.012007>, <-0.395725, 2.005608, 0.006498>, <-0.394433, 2.005608, 0.000000>, <-0.395725, 2.005608, -0.006498>, <-0.399406, 2.005608, -0.012007>, <-0.404915, 2.005608, -0.015688>, <-0.411413, 2.005608, -0.016980>, 
			<-0.417911, 2.005608, -0.015688>, <-0.423420, 2.005608, -0.012007>, <-0.427101, 2.005608, -0.006498>, <-0.411413, 2.090975, -0.000000>, <-0.411413, 2.002230, -0.000000>}
	 //#local average_center = <-0.411413, 2.046603, -0.000000>;
	 normal_vectors { 114, <0.418540, -0.907921, -0.022464>, <0.353102, -0.924082, -0.146260>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.146260, -0.924082, 0.353102>, <-0.022464, -0.907921, 0.418540>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.677747, -0.734948, 0.022578>, <0.642967, -0.727193, -0.240380>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <-0.023971, -0.727193, -0.686014>, 
			<-0.280222, -0.734948, -0.617517>, <-0.531679, -0.659268, -0.531679>, <-0.642967, -0.727193, -0.240380>, <-0.677747, -0.734948, 0.022578>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.251915, -0.752769, 0.608176>, <-0.009151, -0.707599, 0.706555>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.004888, -0.383155, -0.923671>, <-0.375186, -0.409068, -0.831805>, <-0.690908, -0.345848, -0.634851>, <-0.855231, -0.383155, -0.348957>, <-0.912065, -0.409068, 0.028309>, <-0.828382, -0.382443, 0.409293>, <-0.653142, -0.383160, 0.653142>, 
			<-0.353478, -0.383160, 0.853371>, <0.061129, -0.382443, 0.921955>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <1.000000, 0.000000, 0.000000>, <0.923880, -0.000000, -0.382683>, <0.707107, -0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.028393, 0.028393, -0.999194>, <-0.382683, 0.000000, -0.923880>, 
			<-0.707107, 0.000000, -0.707107>, <-0.923880, 0.000000, -0.382683>, <-0.998421, -0.039720, -0.039720>, <-0.934000, 0.028393, 0.356143>, <-0.705558, -0.066159, 0.705558>, <-0.381845, 0.066159, 0.921855>, <0.000000, 0.000000, 1.000000>, <0.382683, -0.000000, 0.923880>, <0.707107, 0.000000, 0.707107>, <0.923880, -0.000000, 0.382683>, <0.921955, 0.382443, 0.061129>, 
			<0.853471, 0.409068, -0.322878>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <0.033749, 0.419315, -0.907213>, <-0.322878, 0.409068, -0.853471>, <-0.634851, 0.345848, -0.690908>, <-0.828382, 0.382443, -0.409293>, <-0.923682, 0.383160, 0.000000>, <-0.825240, 0.419315, 0.378356>, <-0.669649, 0.321155, 0.669649>, <-0.378356, 0.419315, 0.825240>, 
			<-0.028309, 0.409068, 0.912065>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.828382, 0.382443, 0.409293>, <0.686014, 0.727193, -0.023971>, <0.617517, 0.734948, -0.280222>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.023971, 0.727193, -0.686014>, <-0.280222, 0.734948, -0.617517>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.382195, 0.924082, -0.000000>, <0.395277, 0.907921, -0.139414>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <0.000000, 0.924082, -0.382195>, <-0.139414, 0.907921, -0.395277>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, -0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 0>, 0, <17, 16, 0>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<12, 28, 27>, 0, <12, 27, 11>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 20>, 0, <37, 36, 20>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <40, 39, 23>, 0, <23, 24, 40>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <65, 64, 48>, 0, <48, 49, 65>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <69, 68, 52>, 0, <52, 53, 69>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<72, 71, 55>, 0, <55, 56, 72>, 0, <57, 73, 72>, 0, <72, 56, 57>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <59, 75, 74>, 0, <74, 58, 59>, 0, <76, 75, 59>, 0, <59, 60, 76>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <64, 79, 63>, 0, <63, 48, 64>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 80>, 0, <97, 96, 80>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 84>, 0, <101, 100, 84>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 0>, <17, 16, 0>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<12, 28, 27>, <12, 27, 11>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 20>, <37, 36, 20>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <40, 39, 23>, <23, 24, 40>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <43, 59, 58>, <58, 42, 43>, <60, 59, 43>, <43, 44, 60>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <65, 64, 48>, <48, 49, 65>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <69, 68, 52>, <52, 53, 69>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<72, 71, 55>, <55, 56, 72>, <57, 73, 72>, <72, 56, 57>, <74, 73, 57>, <57, 58, 74>, <59, 75, 74>, <74, 58, 59>, <76, 75, 59>, <59, 60, 76>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <64, 79, 63>, <63, 48, 64>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 80>, <97, 96, 80>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 84>, <101, 100, 84>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_7_RightElbow = mesh2{
	 vertex_vectors { 114, <0.295692, 1.365864, -0.000000>, <0.296985, 1.365864, 0.006498>, <0.300666, 1.365864, 0.012007>, <0.306175, 1.365864, 0.015688>, <0.312673, 1.365864, 0.016980>, <0.319171, 1.365864, 0.015688>, <0.324680, 1.365864, 0.012007>, <0.328361, 1.365864, 0.006498>, <0.329653, 1.365864, 0.000000>, <0.328361, 1.365864, -0.006498>, 
			<0.324680, 1.365864, -0.012007>, <0.319171, 1.365864, -0.015688>, <0.312673, 1.365864, -0.016980>, <0.306175, 1.365864, -0.015688>, <0.300666, 1.365864, -0.012007>, <0.296985, 1.365864, -0.006498>, <0.281297, 1.356246, -0.000000>, <0.283685, 1.356246, 0.012007>, <0.290487, 1.356246, 0.022186>, <0.300666, 1.356246, 0.028988>, <0.312673, 1.356246, 0.031376>, 
			<0.324680, 1.356246, 0.028988>, <0.334859, 1.356246, 0.022186>, <0.341660, 1.356246, 0.012007>, <0.344049, 1.356246, 0.000000>, <0.341660, 1.356246, -0.012007>, <0.334859, 1.356246, -0.022186>, <0.324680, 1.356246, -0.028988>, <0.312673, 1.356246, -0.031376>, <0.300666, 1.356246, -0.028988>, <0.290487, 1.356246, -0.022186>, <0.283685, 1.356246, -0.012007>, 
			<0.271678, 1.341850, -0.000000>, <0.274799, 1.341850, 0.015688>, <0.283685, 1.341850, 0.028988>, <0.296985, 1.341850, 0.037874>, <0.312673, 1.341850, 0.040995>, <0.328361, 1.341850, 0.037874>, <0.341660, 1.341850, 0.028988>, <0.350547, 1.341850, 0.015688>, <0.353667, 1.341850, 0.000000>, <0.350547, 1.341850, -0.015688>, <0.341660, 1.341850, -0.028988>, 
			<0.328361, 1.341850, -0.037874>, <0.312673, 1.341850, -0.040995>, <0.296985, 1.341850, -0.037874>, <0.283685, 1.341850, -0.028988>, <0.274799, 1.341850, -0.015688>, <0.268300, 1.324870, -0.000000>, <0.271678, 1.324870, 0.016980>, <0.281297, 1.324870, 0.031376>, <0.295692, 1.324870, 0.040995>, <0.312673, 1.324870, 0.044372>, <0.329653, 1.324870, 0.040995>, 
			<0.344049, 1.324870, 0.031376>, <0.353667, 1.324870, 0.016980>, <0.357045, 1.324870, 0.000000>, <0.353667, 1.324870, -0.016980>, <0.344049, 1.324870, -0.031376>, <0.329653, 1.324870, -0.040995>, <0.312673, 1.324870, -0.044372>, <0.295692, 1.324870, -0.040995>, <0.281297, 1.324870, -0.031376>, <0.271678, 1.324870, -0.016980>, <0.271678, 1.307889, -0.000000>, 
			<0.274799, 1.307889, 0.015688>, <0.283685, 1.307889, 0.028988>, <0.296985, 1.307889, 0.037874>, <0.312673, 1.307889, 0.040995>, <0.328361, 1.307889, 0.037874>, <0.341660, 1.307889, 0.028988>, <0.350547, 1.307889, 0.015688>, <0.353667, 1.307889, 0.000000>, <0.350547, 1.307889, -0.015688>, <0.341660, 1.307889, -0.028988>, <0.328361, 1.307889, -0.037874>, 
			<0.312673, 1.307889, -0.040995>, <0.296985, 1.307889, -0.037874>, <0.283685, 1.307889, -0.028988>, <0.274799, 1.307889, -0.015688>, <0.281297, 1.293494, -0.000000>, <0.283685, 1.293494, 0.012007>, <0.290487, 1.293494, 0.022186>, <0.300666, 1.293494, 0.028988>, <0.312673, 1.293494, 0.031376>, <0.324680, 1.293494, 0.028988>, <0.334859, 1.293494, 0.022186>, 
			<0.341660, 1.293494, 0.012007>, <0.344049, 1.293494, 0.000000>, <0.341660, 1.293494, -0.012007>, <0.334859, 1.293494, -0.022186>, <0.324680, 1.293494, -0.028988>, <0.312673, 1.293494, -0.031376>, <0.300666, 1.293494, -0.028988>, <0.290487, 1.293494, -0.022186>, <0.283685, 1.293494, -0.012007>, <0.295692, 1.283875, -0.000000>, <0.296985, 1.283875, 0.006498>, 
			<0.300666, 1.283875, 0.012007>, <0.306175, 1.283875, 0.015688>, <0.312673, 1.283875, 0.016980>, <0.319171, 1.283875, 0.015688>, <0.324680, 1.283875, 0.012007>, <0.328361, 1.283875, 0.006498>, <0.329653, 1.283875, 0.000000>, <0.328361, 1.283875, -0.006498>, <0.324680, 1.283875, -0.012007>, <0.319171, 1.283875, -0.015688>, <0.312673, 1.283875, -0.016980>, 
			<0.306175, 1.283875, -0.015688>, <0.300666, 1.283875, -0.012007>, <0.296985, 1.283875, -0.006498>, <0.312673, 1.369242, -0.000000>, <0.312673, 1.280498, -0.000000>}
	 //#local average_center = <0.312673, 1.324870, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, -0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <-0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.686014, -0.727193, -0.023971>, <0.617517, -0.734948, -0.280222>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <-0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.642967, -0.727193, -0.240380>, <-0.677747, -0.734948, 0.022578>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.907213, -0.419315, 0.033749>, <0.853371, -0.383160, -0.353478>, <0.653142, -0.383160, -0.653142>, <0.379704, -0.356654, -0.853594>, <0.000000, -0.443376, -0.896335>, <-0.379704, -0.356654, -0.853594>, <-0.690908, -0.345848, -0.634851>, <-0.825240, -0.419315, -0.378356>, <-0.912065, -0.409068, -0.028309>, <-0.853594, -0.356654, 0.379704>, <-0.634851, -0.345848, 0.690908>, 
			<-0.343013, -0.443376, 0.828106>, <-0.004888, -0.383155, 0.923671>, <0.379704, -0.356654, 0.853594>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <1.000000, 0.000000, -0.000000>, <0.923880, 0.000000, -0.382683>, <0.707107, 0.000000, -0.707107>, <0.345383, 0.039720, -0.937621>, <-0.028393, -0.028393, -0.999194>, <-0.382683, 0.000000, -0.923880>, 
			<-0.686460, 0.028393, -0.726613>, <-0.934000, -0.028393, -0.356143>, <-0.997809, -0.000000, 0.066159>, <-0.923880, 0.000000, 0.382683>, <-0.726613, 0.028393, 0.686460>, <-0.356143, -0.028393, 0.934000>, <0.066159, 0.000000, 0.997809>, <0.418775, 0.039720, 0.907221>, <0.707107, 0.000000, 0.707107>, <0.907221, -0.039720, 0.418775>, <0.907213, 0.419315, 0.033749>, 
			<0.853371, 0.383160, -0.353478>, <0.653142, 0.383160, -0.653142>, <0.409293, 0.382443, -0.828382>, <0.061129, 0.382443, -0.921955>, <-0.353478, 0.383160, -0.853371>, <-0.653142, 0.383160, -0.653142>, <-0.828382, 0.382443, -0.409293>, <-0.912065, 0.409068, -0.028309>, <-0.853594, 0.356654, 0.379704>, <-0.653142, 0.383160, 0.653142>, <-0.375186, 0.409068, 0.831805>, 
			<-0.004888, 0.383155, 0.923671>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.280222, 0.734948, 0.617517>, <-0.023971, 0.727193, 0.686014>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 16>, 0, 
			<33, 32, 16>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <40, 39, 23>, 0, <23, 24, 40>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <36, 52, 35>, 0, <52, 51, 35>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <40, 56, 55>, 0, <40, 55, 39>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, 
			<45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <49, 65, 48>, 0, <65, 64, 48>, 0, <50, 66, 65>, 0, 
			<65, 49, 50>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <68, 67, 51>, 0, <51, 52, 68>, 0, <69, 68, 52>, 0, <52, 53, 69>, 0, <54, 70, 69>, 0, <69, 53, 54>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<72, 71, 55>, 0, <55, 56, 72>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <58, 74, 73>, 0, <73, 57, 58>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <76, 75, 59>, 0, <59, 60, 76>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 16>, 
			<33, 32, 16>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <40, 39, 23>, <23, 24, 40>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <48, 32, 33>, 
			<50, 49, 33>, <33, 34, 50>, <35, 51, 50>, <50, 34, 35>, <36, 52, 35>, <52, 51, 35>, <37, 53, 52>, <52, 36, 37>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <40, 56, 55>, <40, 55, 39>, <41, 57, 56>, <41, 56, 40>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <44, 60, 59>, <44, 59, 43>, 
			<45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <49, 65, 48>, <65, 64, 48>, <50, 66, 65>, 
			<65, 49, 50>, <67, 66, 50>, <50, 51, 67>, <68, 67, 51>, <51, 52, 68>, <69, 68, 52>, <52, 53, 69>, <54, 70, 69>, <69, 53, 54>, <71, 70, 54>, <54, 55, 71>, 
			<72, 71, 55>, <55, 56, 72>, <73, 72, 56>, <56, 57, 73>, <58, 74, 73>, <73, 57, 58>, <75, 74, 58>, <58, 59, 75>, <76, 75, 59>, <59, 60, 76>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_8_LeftUpperArm = mesh2{
	 vertex_vectors { 112, <-0.137362, 1.751365, 0.000000>, <-0.140526, 1.749101, 0.019562>, <-0.149537, 1.742653, 0.036145>, <-0.163023, 1.733002, 0.047226>, <-0.178931, 1.721618, 0.051117>, <-0.194839, 1.710234, 0.047226>, <-0.208325, 1.700583, 0.036145>, <-0.217336, 1.694135, 0.019562>, <-0.220500, 1.691870, 0.000000>, <-0.217336, 1.694135, -0.019562>, 
			<-0.208325, 1.700583, -0.036145>, <-0.194839, 1.710234, -0.047226>, <-0.178931, 1.721618, -0.051117>, <-0.163023, 1.733002, -0.047226>, <-0.149537, 1.742653, -0.036145>, <-0.140526, 1.749101, -0.019562>, <-0.357303, 2.041928, -0.000000>, <-0.359862, 2.040096, 0.015824>, <-0.367152, 2.034880, 0.029238>, <-0.378061, 2.027073, 0.038202>, <-0.390929, 2.017865, 0.041349>, 
			<-0.403797, 2.008656, 0.038202>, <-0.414706, 2.000849, 0.029238>, <-0.421995, 1.995633, 0.015824>, <-0.424555, 1.993802, 0.000000>, <-0.421995, 1.995633, -0.015824>, <-0.414706, 2.000849, -0.029238>, <-0.403797, 2.008656, -0.038202>, <-0.390929, 2.017865, -0.041349>, <-0.378061, 2.027073, -0.038202>, <-0.367152, 2.034880, -0.029238>, <-0.359862, 2.040096, -0.015824>, 
			<-0.138925, 1.731875, 0.015948>, <-0.136346, 1.733721, 0.000000>, <-0.138925, 1.731875, -0.015948>, <-0.146272, 1.726618, -0.029468>, <-0.157267, 1.718749, -0.038502>, <-0.170236, 1.709468, -0.041675>, <-0.183206, 1.700187, -0.038502>, <-0.194201, 1.692319, -0.029468>, <-0.201548, 1.687062, -0.015948>, <-0.204127, 1.685216, 0.000000>, <-0.201548, 1.687062, 0.015948>, 
			<-0.194201, 1.692319, 0.029468>, <-0.183206, 1.700187, 0.038502>, <-0.170236, 1.709468, 0.041675>, <-0.157267, 1.718749, 0.038502>, <-0.146272, 1.726618, 0.029468>, <-0.156166, 1.706479, 0.004019>, <-0.155516, 1.706944, 0.000000>, <-0.156166, 1.706479, -0.004019>, <-0.158018, 1.705154, -0.007426>, <-0.160788, 1.703171, -0.009703>, <-0.164057, 1.700833, -0.010502>, 
			<-0.167325, 1.698494, -0.009703>, <-0.170096, 1.696511, -0.007426>, <-0.171947, 1.695186, -0.004019>, <-0.172597, 1.694721, 0.000000>, <-0.171947, 1.695186, 0.004019>, <-0.170096, 1.696511, 0.007426>, <-0.167325, 1.698494, 0.009703>, <-0.164057, 1.700833, 0.010502>, <-0.160788, 1.703171, 0.009703>, <-0.158018, 1.705154, 0.007426>, <-0.371608, 2.045842, 0.000000>, 
			<-0.373589, 2.044424, 0.012243>, <-0.379228, 2.040388, 0.022623>, <-0.387669, 2.034348, 0.029558>, <-0.397626, 2.027223, 0.031993>, <-0.407582, 2.020098, 0.029558>, <-0.416023, 2.014058, 0.022623>, <-0.421663, 2.010022, 0.012243>, <-0.423643, 2.008604, 0.000000>, <-0.421663, 2.010022, -0.012243>, <-0.416023, 2.014058, -0.022623>, <-0.407582, 2.020098, -0.029558>, 
			<-0.397626, 2.027223, -0.031993>, <-0.387669, 2.034348, -0.029558>, <-0.379228, 2.040388, -0.022623>, <-0.373589, 2.044424, -0.012243>, <-0.394942, 2.042529, 0.000000>, <-0.395628, 2.042038, 0.004244>, <-0.397583, 2.040639, 0.007842>, <-0.400509, 2.038545, 0.010246>, <-0.403961, 2.036075, 0.011090>, <-0.407412, 2.033605, 0.010246>, <-0.410338, 2.031512, 0.007842>, 
			<-0.412293, 2.030112, 0.004244>, <-0.412980, 2.029621, 0.000000>, <-0.412293, 2.030112, -0.004244>, <-0.410338, 2.031512, -0.007842>, <-0.407412, 2.033605, -0.010246>, <-0.403961, 2.036075, -0.011090>, <-0.400509, 2.038545, -0.010246>, <-0.397583, 2.040639, -0.007842>, <-0.395628, 2.042038, -0.004244>, <-0.194240, 1.830746, -0.021149>, <-0.203982, 1.823775, -0.039078>, 
			<-0.218563, 1.813341, -0.051058>, <-0.235761, 1.801033, -0.055264>, <-0.252960, 1.788726, -0.051058>, <-0.267540, 1.778292, -0.039078>, <-0.277283, 1.771320, -0.021149>, <-0.280704, 1.768872, 0.000000>, <-0.277283, 1.771320, 0.021149>, <-0.267540, 1.778292, 0.039078>, <-0.252960, 1.788726, 0.051058>, <-0.235761, 1.801033, 0.055264>, <-0.218563, 1.813341, 0.051058>, 
			<-0.203982, 1.823775, 0.039078>, <-0.194240, 1.830746, 0.021149>, <-0.190819, 1.833194, -0.000000>}
	 //#local average_center = <-0.277357, 1.859159, 0.000000>;
	 normal_vectors { 112, <-0.931297, -0.361951, -0.040955>, <-0.889388, -0.268665, -0.369875>, <-0.719829, -0.147327, -0.678337>, <-0.467182, 0.033471, -0.883527>, <-0.222495, 0.310916, -0.924028>, <0.166170, 0.441662, -0.881659>, <0.410210, 0.660615, -0.628742>, <0.511108, 0.795220, -0.326180>, <0.601924, 0.798537, -0.005104>, <0.595910, 0.730938, 0.332596>, 
			<0.410210, 0.660615, 0.628742>, <0.166170, 0.441662, 0.881659>, <-0.222495, 0.310916, 0.924028>, <-0.467182, 0.033471, 0.883527>, <-0.719829, -0.147327, 0.678337>, <-0.885234, -0.310736, 0.346128>, <-0.493119, -0.869355, 0.032478>, <-0.509430, -0.806798, -0.299263>, <-0.361587, -0.701000, -0.614698>, <-0.128466, -0.481021, -0.867246>, <0.267055, -0.373184, -0.888491>, 
			<0.494323, -0.089332, -0.864676>, <0.741750, 0.087730, -0.664914>, <0.903881, 0.257740, -0.341421>, <0.968289, 0.249832, 0.000000>, <0.903881, 0.257740, 0.341421>, <0.741750, 0.087730, 0.664914>, <0.494323, -0.089332, 0.864676>, <0.267055, -0.373184, 0.888491>, <-0.128466, -0.481021, 0.867246>, <-0.361587, -0.701000, 0.614698>, <-0.555567, -0.764682, 0.326508>, 
			<-0.908205, 0.316419, -0.273938>, <-0.959940, 0.280207, 0.000000>, <-0.908205, 0.316419, 0.273938>, <-0.788633, 0.401987, 0.465258>, <-0.618623, 0.523648, 0.585746>, <-0.457712, 0.639608, 0.617577>, <-0.296034, 0.754497, 0.585746>, <-0.126024, 0.876158, 0.465258>, <0.051154, 0.964191, 0.260229>, <-0.005817, 0.999664, -0.025259>, <-0.006452, 0.961726, -0.273938>, 
			<-0.126024, 0.876158, -0.465258>, <-0.296034, 0.754497, -0.585746>, <-0.457712, 0.639608, -0.617577>, <-0.618623, 0.523648, -0.585746>, <-0.788633, 0.401987, -0.465258>, <-0.700132, 0.712083, -0.052472>, <-0.683107, 0.730318, 0.000000>, <-0.700132, 0.712083, 0.052472>, <-0.674209, 0.730634, 0.107780>, <-0.641333, 0.746815, 0.175952>, <-0.561924, 0.785234, 0.260095>, 
			<-0.515175, 0.844441, 0.146680>, <-0.474013, 0.873896, 0.107780>, <-0.448091, 0.892447, 0.052472>, <-0.470844, 0.882217, -0.000000>, <-0.448091, 0.892447, -0.052472>, <-0.474013, 0.873896, -0.107780>, <-0.499937, 0.848000, -0.175952>, <-0.561924, 0.785234, -0.260095>, <-0.633048, 0.760089, -0.146680>, <-0.674209, 0.730634, -0.107780>, <-0.062189, -0.998009, -0.010472>, 
			<-0.019846, -0.967709, -0.251289>, <0.094217, -0.886084, -0.453849>, <0.262636, -0.765561, -0.587315>, <0.450702, -0.662118, -0.598721>, <0.615782, -0.512063, -0.598836>, <0.789592, -0.387682, -0.475655>, <0.911704, -0.323397, -0.253398>, <0.972019, -0.234517, 0.013454>, <0.911836, -0.300203, 0.280060>, <0.789592, -0.387682, 0.475655>, <0.615782, -0.512063, 0.598836>, 
			<0.450702, -0.662118, 0.598721>, <0.262636, -0.765561, 0.587315>, <0.094217, -0.886084, 0.453849>, <-0.088504, -0.961138, 0.261497>, <0.372344, -0.927962, -0.015729>, <0.391924, -0.913950, -0.105317>, <0.437894, -0.881053, -0.178870>, <0.483453, -0.832686, -0.270013>, <0.563261, -0.746822, -0.353546>, <0.650911, -0.728615, -0.213154>, <0.710727, -0.685810, -0.156625>, 
			<0.713781, -0.696604, -0.072517>, <0.758187, -0.651847, -0.015729>, <0.748397, -0.658853, 0.076252>, <0.710727, -0.685810, 0.156625>, <0.660497, -0.705991, 0.255578>, <0.563261, -0.746822, 0.353546>, <0.503255, -0.834279, 0.225192>, <0.437894, -0.881053, 0.178870>, <0.356499, -0.928519, 0.103736>, <-0.729959, -0.539954, 0.419057>, <-0.572216, -0.415446, 0.707088>, 
			<-0.343514, -0.240148, 0.907925>, <0.002821, -0.003942, 0.999988>, <0.349109, 0.232241, 0.907847>, <0.577841, 0.407550, 0.707109>, <0.735659, 0.532122, 0.419108>, <0.819592, 0.572242, 0.028410>, <0.744915, 0.546509, -0.382661>, <0.577841, 0.407550, -0.707109>, <0.349109, 0.232241, -0.907847>, <0.002821, -0.003942, -0.999988>, <-0.343514, -0.240148, -0.907925>, 
			<-0.572216, -0.415446, -0.707088>, <-0.748495, -0.541593, -0.382665>, <-0.806087, -0.591115, 0.028410>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <49, 50, 56>, 0, <49, 56, 57>, 0, <50, 51, 55>, 0, <50, 55, 56>, 0, <51, 52, 54>, 0, <51, 54, 55>, 0, <52, 53, 54>, 0, <60, 61, 62>, 0, <62, 59, 60>, 0, <62, 63, 59>, 0, 
			<63, 58, 59>, 0, <63, 48, 58>, 0, <48, 49, 57>, 0, <48, 57, 58>, 0, <83, 84, 85>, 0, <85, 82, 83>, 0, <85, 86, 82>, 0, <86, 81, 82>, 0, <86, 87, 81>, 0, <87, 88, 80>, 0, <87, 80, 81>, 0, 
			<88, 89, 95>, 0, <88, 95, 80>, 0, <89, 90, 94>, 0, <89, 94, 95>, 0, <90, 91, 93>, 0, <90, 93, 94>, 0, <91, 92, 93>, 0, <0, 111, 15>, 0, <111, 96, 15>, 0, <15, 96, 97>, 0, <15, 97, 14>, 0, 
			<14, 97, 98>, 0, <14, 98, 13>, 0, <13, 98, 99>, 0, <13, 99, 12>, 0, <12, 99, 11>, 0, <99, 100, 11>, 0, <11, 100, 101>, 0, <11, 101, 10>, 0, <10, 101, 102>, 0, <10, 102, 9>, 0, <9, 102, 103>, 0, 
			<9, 103, 8>, 0, <8, 103, 104>, 0, <8, 104, 7>, 0, <7, 104, 6>, 0, <104, 105, 6>, 0, <6, 105, 5>, 0, <105, 106, 5>, 0, <5, 106, 107>, 0, <5, 107, 4>, 0, <4, 107, 3>, 0, <107, 108, 3>, 0, 
			<3, 108, 2>, 0, <108, 109, 2>, 0, <2, 109, 1>, 0, <109, 110, 1>, 0, <1, 110, 0>, 0, <110, 111, 0>, 0, <33, 32, 1>, 0, <1, 0, 33>, 0, <15, 34, 33>, 0, <33, 0, 15>, 0, <14, 35, 34>, 0, 
			<34, 15, 14>, 0, <13, 36, 35>, 0, <35, 14, 13>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <38, 37, 12>, 0, <12, 11, 38>, 0, <39, 38, 11>, 0, <11, 10, 39>, 0, <40, 39, 10>, 0, <10, 9, 40>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 41>, 0, <41, 8, 7>, 0, <6, 43, 42>, 0, <42, 7, 6>, 0, <5, 44, 43>, 0, <43, 6, 5>, 0, <4, 45, 44>, 0, <44, 5, 4>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <47, 46, 3>, 0, <3, 2, 47>, 0, <32, 47, 2>, 0, <2, 1, 32>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, 
			<52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <38, 54, 53>, 0, <53, 37, 38>, 0, <39, 55, 54>, 0, <54, 38, 39>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 41>, 0, <58, 57, 41>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 43>, 0, <60, 59, 43>, 0, <45, 61, 44>, 0, <61, 60, 44>, 0, <46, 62, 61>, 0, <46, 61, 45>, 0, 
			<47, 63, 62>, 0, <47, 62, 46>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 65>, 0, <18, 65, 17>, 0, <19, 67, 66>, 0, <19, 66, 18>, 0, <20, 68, 67>, 0, 
			<20, 67, 19>, 0, <21, 69, 20>, 0, <69, 68, 20>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 22>, 0, <71, 70, 22>, 0, <24, 72, 23>, 0, <72, 71, 23>, 0, <25, 73, 72>, 0, <25, 72, 24>, 0, 
			<26, 74, 73>, 0, <26, 73, 25>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <28, 76, 75>, 0, <28, 75, 27>, 0, <29, 77, 28>, 0, <77, 76, 28>, 0, <30, 78, 29>, 0, <78, 77, 29>, 0, <31, 79, 30>, 0, 
			<79, 78, 30>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 81>, 0, <66, 81, 65>, 0, <67, 83, 82>, 0, <67, 82, 66>, 0, <68, 84, 83>, 0, <68, 83, 67>, 0, 
			<69, 85, 84>, 0, <69, 84, 68>, 0, <70, 86, 85>, 0, <70, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <91, 90, 74>, 0, <74, 75, 91>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <77, 93, 76>, 0, <93, 92, 76>, 0, <78, 94, 77>, 0, <94, 93, 77>, 0, <79, 95, 78>, 0, <95, 94, 78>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <31, 96, 111>, 0, <31, 111, 16>, 0, <30, 97, 96>, 0, <96, 31, 30>, 0, <29, 98, 97>, 0, <97, 30, 29>, 0, <99, 98, 29>, 0, <29, 28, 99>, 0, <27, 100, 99>, 0, 
			<99, 28, 27>, 0, <26, 101, 100>, 0, <100, 27, 26>, 0, <25, 102, 101>, 0, <101, 26, 25>, 0, <24, 103, 25>, 0, <103, 102, 25>, 0, <23, 104, 103>, 0, <103, 24, 23>, 0, <105, 104, 23>, 0, <23, 22, 105>, 0, 
			<106, 105, 22>, 0, <22, 21, 106>, 0, <107, 106, 21>, 0, <21, 20, 107>, 0, <19, 108, 107>, 0, <107, 20, 19>, 0, <109, 108, 19>, 0, <19, 18, 109>, 0, <110, 109, 18>, 0, <18, 17, 110>, 0, <111, 110, 17>, 0, 
			<17, 16, 111>, 0}
	 normal_indices { 220, <49, 50, 56>, <49, 56, 57>, <50, 51, 55>, <50, 55, 56>, <51, 52, 54>, <51, 54, 55>, <52, 53, 54>, <60, 61, 62>, <62, 59, 60>, <62, 63, 59>, 
			<63, 58, 59>, <63, 48, 58>, <48, 49, 57>, <48, 57, 58>, <83, 84, 85>, <85, 82, 83>, <85, 86, 82>, <86, 81, 82>, <86, 87, 81>, <87, 88, 80>, <87, 80, 81>, 
			<88, 89, 95>, <88, 95, 80>, <89, 90, 94>, <89, 94, 95>, <90, 91, 93>, <90, 93, 94>, <91, 92, 93>, <0, 111, 15>, <111, 96, 15>, <15, 96, 97>, <15, 97, 14>, 
			<14, 97, 98>, <14, 98, 13>, <13, 98, 99>, <13, 99, 12>, <12, 99, 11>, <99, 100, 11>, <11, 100, 101>, <11, 101, 10>, <10, 101, 102>, <10, 102, 9>, <9, 102, 103>, 
			<9, 103, 8>, <8, 103, 104>, <8, 104, 7>, <7, 104, 6>, <104, 105, 6>, <6, 105, 5>, <105, 106, 5>, <5, 106, 107>, <5, 107, 4>, <4, 107, 3>, <107, 108, 3>, 
			<3, 108, 2>, <108, 109, 2>, <2, 109, 1>, <109, 110, 1>, <1, 110, 0>, <110, 111, 0>, <33, 32, 1>, <1, 0, 33>, <15, 34, 33>, <33, 0, 15>, <14, 35, 34>, 
			<34, 15, 14>, <13, 36, 35>, <35, 14, 13>, <12, 37, 36>, <36, 13, 12>, <38, 37, 12>, <12, 11, 38>, <39, 38, 11>, <11, 10, 39>, <40, 39, 10>, <10, 9, 40>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 41>, <41, 8, 7>, <6, 43, 42>, <42, 7, 6>, <5, 44, 43>, <43, 6, 5>, <4, 45, 44>, <44, 5, 4>, <46, 45, 4>, 
			<4, 3, 46>, <47, 46, 3>, <3, 2, 47>, <32, 47, 2>, <2, 1, 32>, <33, 49, 48>, <33, 48, 32>, <50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, 
			<52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <38, 54, 53>, <53, 37, 38>, <39, 55, 54>, <54, 38, 39>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 41>, <58, 57, 41>, <43, 59, 42>, <59, 58, 42>, <44, 60, 43>, <60, 59, 43>, <45, 61, 44>, <61, 60, 44>, <46, 62, 61>, <46, 61, 45>, 
			<47, 63, 62>, <47, 62, 46>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 65>, <18, 65, 17>, <19, 67, 66>, <19, 66, 18>, <20, 68, 67>, 
			<20, 67, 19>, <21, 69, 20>, <69, 68, 20>, <22, 70, 21>, <70, 69, 21>, <23, 71, 22>, <71, 70, 22>, <24, 72, 23>, <72, 71, 23>, <25, 73, 72>, <25, 72, 24>, 
			<26, 74, 73>, <26, 73, 25>, <27, 75, 74>, <27, 74, 26>, <28, 76, 75>, <28, 75, 27>, <29, 77, 28>, <77, 76, 28>, <30, 78, 29>, <78, 77, 29>, <31, 79, 30>, 
			<79, 78, 30>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 81>, <66, 81, 65>, <67, 83, 82>, <67, 82, 66>, <68, 84, 83>, <68, 83, 67>, 
			<69, 85, 84>, <69, 84, 68>, <70, 86, 85>, <70, 85, 69>, <71, 87, 86>, <71, 86, 70>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <91, 90, 74>, <74, 75, 91>, <92, 91, 75>, <75, 76, 92>, <77, 93, 76>, <93, 92, 76>, <78, 94, 77>, <94, 93, 77>, <79, 95, 78>, <95, 94, 78>, 
			<64, 80, 95>, <95, 79, 64>, <31, 96, 111>, <31, 111, 16>, <30, 97, 96>, <96, 31, 30>, <29, 98, 97>, <97, 30, 29>, <99, 98, 29>, <29, 28, 99>, <27, 100, 99>, 
			<99, 28, 27>, <26, 101, 100>, <100, 27, 26>, <25, 102, 101>, <101, 26, 25>, <24, 103, 25>, <103, 102, 25>, <23, 104, 103>, <103, 24, 23>, <105, 104, 23>, <23, 22, 105>, 
			<106, 105, 22>, <22, 21, 106>, <107, 106, 21>, <21, 20, 107>, <19, 108, 107>, <107, 20, 19>, <109, 108, 19>, <19, 18, 109>, <110, 109, 18>, <18, 17, 110>, <111, 110, 17>, 
			<17, 16, 111>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_9_RightUpperArm = mesh2{
	 vertex_vectors { 112, <0.130516, 1.680968, 0.000000>, <0.134167, 1.682313, 0.019562>, <0.144564, 1.686144, 0.036145>, <0.160125, 1.691878, 0.047226>, <0.178480, 1.698642, 0.051117>, <0.196835, 1.705405, 0.047226>, <0.212396, 1.711139, 0.036145>, <0.222793, 1.714970, 0.019562>, <0.226444, 1.716316, 0.000000>, <0.222793, 1.714970, -0.019562>, 
			<0.212396, 1.711139, -0.036145>, <0.196835, 1.705405, -0.047226>, <0.178480, 1.698642, -0.051117>, <0.160125, 1.691878, -0.047226>, <0.144564, 1.686144, -0.036145>, <0.134167, 1.682313, -0.019562>, <0.265636, 1.342525, -0.000000>, <0.268589, 1.343614, 0.015824>, <0.277000, 1.346713, 0.029238>, <0.289587, 1.351351, 0.038202>, <0.304435, 1.356822, 0.041349>, 
			<0.319282, 1.362293, 0.038202>, <0.331870, 1.366931, 0.029238>, <0.340280, 1.370030, 0.015824>, <0.343234, 1.371119, 0.000000>, <0.340280, 1.370030, -0.015824>, <0.331870, 1.366931, -0.029238>, <0.319282, 1.362293, -0.038202>, <0.304435, 1.356822, -0.041349>, <0.289587, 1.351351, -0.038202>, <0.277000, 1.346713, -0.029238>, <0.268589, 1.343614, -0.015824>, 
			<0.137186, 1.699348, 0.015948>, <0.134210, 1.698251, 0.000000>, <0.137186, 1.699348, -0.015948>, <0.145663, 1.702471, -0.029468>, <0.158350, 1.707146, -0.038502>, <0.173314, 1.712660, -0.041675>, <0.188279, 1.718175, -0.038502>, <0.200965, 1.722849, -0.029468>, <0.209442, 1.725973, -0.015948>, <0.212419, 1.727070, 0.000000>, <0.209442, 1.725973, 0.015948>, 
			<0.200965, 1.722849, 0.029468>, <0.188279, 1.718175, 0.038502>, <0.173314, 1.712660, 0.041675>, <0.158350, 1.707146, 0.038502>, <0.145663, 1.702471, 0.029468>, <0.160538, 1.719270, 0.004019>, <0.159788, 1.718993, 0.000000>, <0.160538, 1.719270, -0.004019>, <0.162675, 1.720057, -0.007426>, <0.165872, 1.721235, -0.009703>, <0.169643, 1.722625, -0.010502>, 
			<0.173414, 1.724014, -0.009703>, <0.176611, 1.725192, -0.007426>, <0.178747, 1.725979, -0.004019>, <0.179497, 1.726256, 0.000000>, <0.178747, 1.725979, 0.004019>, <0.176611, 1.725192, 0.007426>, <0.173414, 1.724014, 0.009703>, <0.169643, 1.722625, 0.010502>, <0.165872, 1.721235, 0.009703>, <0.162675, 1.720057, 0.007426>, <0.278393, 1.334962, 0.000000>, 
			<0.280679, 1.335804, 0.012243>, <0.287186, 1.338202, 0.022623>, <0.296925, 1.341791, 0.029558>, <0.308414, 1.346024, 0.031993>, <0.319902, 1.350257, 0.029558>, <0.329641, 1.353846, 0.022623>, <0.336149, 1.356244, 0.012243>, <0.338434, 1.357086, 0.000000>, <0.336149, 1.356244, -0.012243>, <0.329641, 1.353846, -0.022623>, <0.319902, 1.350257, -0.029558>, 
			<0.308414, 1.346024, -0.031993>, <0.296925, 1.341791, -0.029558>, <0.287186, 1.338202, -0.022623>, <0.280679, 1.335804, -0.012243>, <0.301771, 1.331976, 0.000000>, <0.302563, 1.332267, 0.004244>, <0.304819, 1.333099, 0.007842>, <0.308195, 1.334343, 0.010246>, <0.312177, 1.335810, 0.011090>, <0.316160, 1.337278, 0.010246>, <0.319536, 1.338522, 0.007842>, 
			<0.321791, 1.339353, 0.004244>, <0.322584, 1.339645, 0.000000>, <0.321791, 1.339353, -0.004244>, <0.319536, 1.338522, -0.007842>, <0.316160, 1.337278, -0.010246>, <0.312177, 1.335810, -0.011090>, <0.308195, 1.334343, -0.010246>, <0.304819, 1.333099, -0.007842>, <0.302563, 1.332267, -0.004244>, <0.164336, 1.589356, -0.021149>, <0.175577, 1.593498, -0.039078>, 
			<0.192400, 1.599697, -0.051058>, <0.212245, 1.607010, -0.055264>, <0.232089, 1.614322, -0.051058>, <0.248912, 1.620521, -0.039078>, <0.260153, 1.624663, -0.021149>, <0.264101, 1.626118, 0.000000>, <0.260153, 1.624663, 0.021149>, <0.248912, 1.620521, 0.039078>, <0.232089, 1.614322, 0.051058>, <0.212245, 1.607010, 0.055264>, <0.192400, 1.599697, 0.051058>, 
			<0.175577, 1.593498, 0.039078>, <0.164336, 1.589356, 0.021149>, <0.160389, 1.587902, -0.000000>}
	 //#local average_center = <0.236958, 1.539942, 0.000000>;
	 normal_vectors { 112, <0.999229, -0.039257, 0.000000>, <0.920708, 0.111876, -0.373871>, <0.733142, -0.048606, -0.678337>, <0.428646, -0.199121, -0.881257>, <0.043962, -0.301926, -0.952317>, <-0.293488, -0.426270, -0.855663>, <-0.583813, -0.479026, -0.655513>, <-0.668846, -0.653915, -0.353610>, <-0.791943, -0.610574, -0.005104>, <-0.725620, -0.586136, 0.360445>, 
			<-0.583813, -0.479026, 0.655513>, <-0.293488, -0.426270, 0.855663>, <0.043962, -0.301926, 0.952317>, <0.428646, -0.199121, 0.881257>, <0.733142, -0.048606, 0.678337>, <0.920708, 0.111876, 0.373871>, <0.705783, 0.707683, 0.032478>, <0.704940, 0.643040, -0.299263>, <0.534355, 0.580183, -0.614698>, <0.263488, 0.480373, -0.836550>, <-0.066424, 0.358806, -0.931046>, 
			<-0.442103, 0.266739, -0.856385>, <-0.738493, 0.111881, -0.664914>, <-0.939866, -0.009111, -0.341421>, <-0.996224, 0.080522, 0.032478>, <-0.926671, -0.067287, 0.369803>, <-0.738493, 0.111881, 0.664914>, <-0.442103, 0.266739, 0.856385>, <-0.066424, 0.358806, 0.931046>, <0.263488, 0.480373, 0.836550>, <0.534355, 0.580183, 0.614698>, <0.738273, 0.590208, 0.326508>, 
			<0.826356, -0.499416, -0.260229>, <0.784448, -0.620194, -0.000000>, <0.826356, -0.499416, 0.260229>, <0.653984, -0.596523, 0.465258>, <0.475770, -0.707037, 0.523204>, <0.288914, -0.731609, 0.617476>, <0.065895, -0.813788, 0.577414>, <-0.181199, -0.870684, 0.457249>, <-0.277906, -0.939909, 0.198339>, <-0.373663, -0.926889, -0.035389>, <-0.204673, -0.957768, -0.201963>, 
			<-0.181199, -0.870684, -0.457249>, <0.065895, -0.813788, -0.577414>, <0.288914, -0.731609, -0.617476>, <0.475770, -0.707037, -0.523204>, <0.653984, -0.596523, -0.465258>, <0.486505, -0.872101, -0.052472>, <0.465258, -0.885175, -0.000000>, <0.486505, -0.872101, 0.052472>, <0.456594, -0.883122, 0.107780>, <0.420606, -0.890018, 0.175952>, <0.350436, -0.904205, 0.244147>, 
			<0.291862, -0.943823, 0.154964>, <0.239965, -0.962947, 0.123088>, <0.203465, -0.976396, 0.072473>, <0.164636, -0.986354, 0.000000>, <0.203465, -0.976396, -0.072473>, <0.239965, -0.962947, -0.123088>, <0.279971, -0.941839, -0.185889>, <0.350436, -0.904205, -0.244147>, <0.409101, -0.900623, -0.146680>, <0.456594, -0.883122, -0.107780>, <0.324323, 0.945888, -0.010472>, 
			<0.275467, 0.927886, -0.251289>, <0.143857, 0.879390, -0.453849>, <-0.050471, 0.807783, -0.587315>, <-0.277931, 0.723968, -0.631367>, <-0.475551, 0.678136, -0.560341>, <-0.658697, 0.582984, -0.475655>, <-0.799747, 0.531009, -0.280060>, <-0.844953, 0.534372, -0.022402>, <-0.823637, 0.502604, 0.262701>, <-0.658697, 0.582984, 0.475655>, <-0.475551, 0.678136, 0.560341>, 
			<-0.277931, 0.723968, 0.631367>, <-0.050471, 0.807783, 0.587315>, <0.143857, 0.879390, 0.453849>, <0.339932, 0.903363, 0.261497>, <-0.113243, 0.993443, -0.015729>, <-0.135835, 0.985118, -0.105317>, <-0.188877, 0.965573, -0.178870>, <-0.245620, 0.931002, -0.270013>, <-0.345321, 0.869344, -0.353546>, <-0.434664, 0.875005, -0.213154>, <-0.503681, 0.849573, -0.156625>, 
			<-0.547146, 0.833557, -0.076252>, <-0.517302, 0.855803, 0.000000>, <-0.547146, 0.833557, 0.076252>, <-0.503681, 0.849573, 0.156625>, <-0.449900, 0.855728, 0.255578>, <-0.345321, 0.869344, 0.353546>, <-0.264293, 0.937783, 0.225192>, <-0.188877, 0.965573, 0.178870>, <-0.097816, 0.989783, 0.103736>, <0.846910, 0.327314, 0.419057>, <0.661821, 0.249036, 0.707088>, 
			<0.357414, 0.136867, 0.923863>, <-0.001662, 0.004553, 0.999988>, <-0.360740, -0.127761, 0.923874>, <-0.665154, -0.239932, 0.707109>, <-0.850332, -0.318251, 0.419108>, <-0.941894, -0.334706, 0.028410>, <-0.863068, -0.329672, -0.382661>, <-0.665154, -0.239932, -0.707109>, <-0.360740, -0.127761, -0.923874>, <-0.001662, 0.004553, -0.999988>, <0.357414, 0.136867, -0.923863>, 
			<0.661821, 0.249036, -0.707088>, <0.846910, 0.327314, -0.419057>, <0.936637, 0.350301, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <49, 50, 56>, 0, <49, 56, 57>, 0, <50, 51, 55>, 0, <50, 55, 56>, 0, <51, 52, 54>, 0, <51, 54, 55>, 0, <52, 53, 54>, 0, <60, 61, 62>, 0, <62, 59, 60>, 0, <62, 63, 59>, 0, 
			<63, 58, 59>, 0, <63, 48, 58>, 0, <48, 49, 57>, 0, <48, 57, 58>, 0, <83, 84, 85>, 0, <85, 82, 83>, 0, <85, 86, 82>, 0, <86, 81, 82>, 0, <86, 87, 81>, 0, <87, 88, 80>, 0, <87, 80, 81>, 0, 
			<88, 89, 95>, 0, <88, 95, 80>, 0, <89, 90, 94>, 0, <89, 94, 95>, 0, <90, 91, 93>, 0, <90, 93, 94>, 0, <91, 92, 93>, 0, <0, 111, 15>, 0, <111, 96, 15>, 0, <15, 96, 97>, 0, <97, 14, 15>, 0, 
			<14, 97, 98>, 0, <98, 13, 14>, 0, <13, 98, 99>, 0, <99, 12, 13>, 0, <12, 99, 100>, 0, <100, 11, 12>, 0, <11, 100, 101>, 0, <101, 10, 11>, 0, <10, 101, 102>, 0, <102, 9, 10>, 0, <9, 102, 103>, 0, 
			<9, 103, 8>, 0, <8, 103, 104>, 0, <8, 104, 7>, 0, <104, 105, 6>, 0, <6, 7, 104>, 0, <105, 106, 5>, 0, <5, 6, 105>, 0, <106, 107, 4>, 0, <4, 5, 106>, 0, <107, 108, 3>, 0, <3, 4, 107>, 0, 
			<108, 109, 2>, 0, <2, 3, 108>, 0, <109, 110, 1>, 0, <1, 2, 109>, 0, <1, 110, 111>, 0, <111, 0, 1>, 0, <0, 33, 32>, 0, <0, 32, 1>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <14, 35, 34>, 0, 
			<14, 34, 15>, 0, <13, 36, 35>, 0, <13, 35, 14>, 0, <12, 37, 13>, 0, <37, 36, 13>, 0, <11, 38, 12>, 0, <38, 37, 12>, 0, <10, 39, 11>, 0, <39, 38, 11>, 0, <9, 40, 39>, 0, <39, 10, 9>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 41>, 0, <41, 8, 7>, 0, <6, 43, 7>, 0, <43, 42, 7>, 0, <5, 44, 43>, 0, <5, 43, 6>, 0, <4, 45, 44>, 0, <4, 44, 5>, 0, <3, 46, 45>, 0, 
			<3, 45, 4>, 0, <2, 47, 3>, 0, <47, 46, 3>, 0, <1, 32, 2>, 0, <32, 47, 2>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, 
			<52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <38, 54, 37>, 0, <54, 53, 37>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 39>, 0, <56, 55, 39>, 0, <41, 57, 40>, 0, 
			<57, 56, 40>, 0, <42, 58, 57>, 0, <42, 57, 41>, 0, <43, 59, 58>, 0, <43, 58, 42>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, <45, 61, 60>, 0, <45, 60, 44>, 0, <46, 62, 61>, 0, <46, 61, 45>, 0, 
			<47, 63, 62>, 0, <47, 62, 46>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 65>, 0, <65, 17, 18>, 0, <19, 67, 66>, 0, <66, 18, 19>, 0, <20, 68, 67>, 0, 
			<67, 19, 20>, 0, <21, 69, 68>, 0, <68, 20, 21>, 0, <70, 69, 21>, 0, <21, 22, 70>, 0, <71, 70, 22>, 0, <22, 23, 71>, 0, <72, 71, 23>, 0, <23, 24, 72>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<26, 74, 73>, 0, <73, 25, 26>, 0, <27, 75, 74>, 0, <74, 26, 27>, 0, <76, 75, 27>, 0, <27, 28, 76>, 0, <77, 76, 28>, 0, <28, 29, 77>, 0, <78, 77, 29>, 0, <29, 30, 78>, 0, <79, 78, 30>, 0, 
			<30, 31, 79>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 81>, 0, <81, 65, 66>, 0, <67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 85>, 0, <70, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, <72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <91, 90, 74>, 0, <74, 75, 91>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <94, 93, 77>, 0, <77, 78, 94>, 0, <95, 94, 78>, 0, <78, 79, 95>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <31, 96, 111>, 0, <31, 111, 16>, 0, <30, 97, 96>, 0, <30, 96, 31>, 0, <29, 98, 97>, 0, <29, 97, 30>, 0, <28, 99, 98>, 0, <28, 98, 29>, 0, <27, 100, 99>, 0, 
			<27, 99, 28>, 0, <26, 101, 100>, 0, <26, 100, 27>, 0, <25, 102, 101>, 0, <25, 101, 26>, 0, <24, 103, 25>, 0, <103, 102, 25>, 0, <23, 104, 103>, 0, <103, 24, 23>, 0, <22, 105, 23>, 0, <105, 104, 23>, 0, 
			<21, 106, 22>, 0, <106, 105, 22>, 0, <20, 107, 21>, 0, <107, 106, 21>, 0, <19, 108, 20>, 0, <108, 107, 20>, 0, <18, 109, 19>, 0, <109, 108, 19>, 0, <17, 110, 18>, 0, <110, 109, 18>, 0, <111, 110, 17>, 0, 
			<17, 16, 111>, 0}
	 normal_indices { 220, <49, 50, 56>, <49, 56, 57>, <50, 51, 55>, <50, 55, 56>, <51, 52, 54>, <51, 54, 55>, <52, 53, 54>, <60, 61, 62>, <62, 59, 60>, <62, 63, 59>, 
			<63, 58, 59>, <63, 48, 58>, <48, 49, 57>, <48, 57, 58>, <83, 84, 85>, <85, 82, 83>, <85, 86, 82>, <86, 81, 82>, <86, 87, 81>, <87, 88, 80>, <87, 80, 81>, 
			<88, 89, 95>, <88, 95, 80>, <89, 90, 94>, <89, 94, 95>, <90, 91, 93>, <90, 93, 94>, <91, 92, 93>, <0, 111, 15>, <111, 96, 15>, <15, 96, 97>, <97, 14, 15>, 
			<14, 97, 98>, <98, 13, 14>, <13, 98, 99>, <99, 12, 13>, <12, 99, 100>, <100, 11, 12>, <11, 100, 101>, <101, 10, 11>, <10, 101, 102>, <102, 9, 10>, <9, 102, 103>, 
			<9, 103, 8>, <8, 103, 104>, <8, 104, 7>, <104, 105, 6>, <6, 7, 104>, <105, 106, 5>, <5, 6, 105>, <106, 107, 4>, <4, 5, 106>, <107, 108, 3>, <3, 4, 107>, 
			<108, 109, 2>, <2, 3, 108>, <109, 110, 1>, <1, 2, 109>, <1, 110, 111>, <111, 0, 1>, <0, 33, 32>, <0, 32, 1>, <34, 33, 0>, <0, 15, 34>, <14, 35, 34>, 
			<14, 34, 15>, <13, 36, 35>, <13, 35, 14>, <12, 37, 13>, <37, 36, 13>, <11, 38, 12>, <38, 37, 12>, <10, 39, 11>, <39, 38, 11>, <9, 40, 39>, <39, 10, 9>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 41>, <41, 8, 7>, <6, 43, 7>, <43, 42, 7>, <5, 44, 43>, <5, 43, 6>, <4, 45, 44>, <4, 44, 5>, <3, 46, 45>, 
			<3, 45, 4>, <2, 47, 3>, <47, 46, 3>, <1, 32, 2>, <32, 47, 2>, <33, 49, 48>, <33, 48, 32>, <50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, 
			<52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <38, 54, 37>, <54, 53, 37>, <39, 55, 38>, <55, 54, 38>, <40, 56, 39>, <56, 55, 39>, <41, 57, 40>, 
			<57, 56, 40>, <42, 58, 57>, <42, 57, 41>, <43, 59, 58>, <43, 58, 42>, <44, 60, 59>, <44, 59, 43>, <45, 61, 60>, <45, 60, 44>, <46, 62, 61>, <46, 61, 45>, 
			<47, 63, 62>, <47, 62, 46>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 65>, <65, 17, 18>, <19, 67, 66>, <66, 18, 19>, <20, 68, 67>, 
			<67, 19, 20>, <21, 69, 68>, <68, 20, 21>, <70, 69, 21>, <21, 22, 70>, <71, 70, 22>, <22, 23, 71>, <72, 71, 23>, <23, 24, 72>, <73, 72, 24>, <24, 25, 73>, 
			<26, 74, 73>, <73, 25, 26>, <27, 75, 74>, <74, 26, 27>, <76, 75, 27>, <27, 28, 76>, <77, 76, 28>, <28, 29, 77>, <78, 77, 29>, <29, 30, 78>, <79, 78, 30>, 
			<30, 31, 79>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 81>, <81, 65, 66>, <67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 84>, <84, 68, 69>, <70, 86, 85>, <70, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, <72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <91, 90, 74>, <74, 75, 91>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, <94, 93, 77>, <77, 78, 94>, <95, 94, 78>, <78, 79, 95>, 
			<64, 80, 95>, <95, 79, 64>, <31, 96, 111>, <31, 111, 16>, <30, 97, 96>, <30, 96, 31>, <29, 98, 97>, <29, 97, 30>, <28, 99, 98>, <28, 98, 29>, <27, 100, 99>, 
			<27, 99, 28>, <26, 101, 100>, <26, 100, 27>, <25, 102, 101>, <25, 101, 26>, <24, 103, 25>, <103, 102, 25>, <23, 104, 103>, <103, 24, 23>, <22, 105, 23>, <105, 104, 23>, 
			<21, 106, 22>, <106, 105, 22>, <20, 107, 21>, <107, 106, 21>, <19, 108, 20>, <108, 107, 20>, <18, 109, 19>, <109, 108, 19>, <17, 110, 18>, <110, 109, 18>, <111, 110, 17>, 
			<17, 16, 111>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_10_RightShoulder = mesh2{
	 vertex_vectors { 114, <0.119074, 1.777537, -0.000000>, <0.121113, 1.777537, 0.010251>, <0.126920, 1.777537, 0.018942>, <0.135611, 1.777537, 0.024749>, <0.145862, 1.777537, 0.026788>, <0.156113, 1.777537, 0.024749>, <0.164804, 1.777537, 0.018942>, <0.170611, 1.777537, 0.010251>, <0.172650, 1.777537, 0.000000>, <0.170611, 1.777537, -0.010251>, 
			<0.164804, 1.777537, -0.018942>, <0.156113, 1.777537, -0.024749>, <0.145862, 1.777537, -0.026788>, <0.135611, 1.777537, -0.024749>, <0.126920, 1.777537, -0.018942>, <0.121113, 1.777537, -0.010251>, <0.096365, 1.762362, -0.000000>, <0.100132, 1.762362, 0.018942>, <0.110862, 1.762362, 0.035000>, <0.126920, 1.762362, 0.045730>, <0.145862, 1.762362, 0.049497>, 
			<0.164804, 1.762362, 0.045730>, <0.180862, 1.762362, 0.035000>, <0.191592, 1.762362, 0.018942>, <0.195360, 1.762362, 0.000000>, <0.191592, 1.762362, -0.018942>, <0.180862, 1.762362, -0.035000>, <0.164804, 1.762362, -0.045730>, <0.145862, 1.762362, -0.049497>, <0.126920, 1.762362, -0.045730>, <0.110862, 1.762362, -0.035000>, <0.100132, 1.762362, -0.018942>, 
			<0.081191, 1.739653, -0.000000>, <0.086113, 1.739653, 0.024749>, <0.100132, 1.739653, 0.045730>, <0.121113, 1.739653, 0.059749>, <0.145862, 1.739653, 0.064672>, <0.170611, 1.739653, 0.059749>, <0.191592, 1.739653, 0.045730>, <0.205611, 1.739653, 0.024749>, <0.210534, 1.739653, 0.000000>, <0.205611, 1.739653, -0.024749>, <0.191592, 1.739653, -0.045730>, 
			<0.170611, 1.739653, -0.059749>, <0.145862, 1.739653, -0.064672>, <0.121113, 1.739653, -0.059749>, <0.100132, 1.739653, -0.045730>, <0.086113, 1.739653, -0.024749>, <0.075862, 1.712865, -0.000000>, <0.081191, 1.712865, 0.026788>, <0.096365, 1.712865, 0.049497>, <0.119074, 1.712865, 0.064672>, <0.145862, 1.712865, 0.070000>, <0.172650, 1.712865, 0.064672>, 
			<0.195360, 1.712865, 0.049497>, <0.210534, 1.712865, 0.026788>, <0.215862, 1.712865, 0.000000>, <0.210534, 1.712865, -0.026788>, <0.195360, 1.712865, -0.049497>, <0.172650, 1.712865, -0.064672>, <0.145862, 1.712865, -0.070000>, <0.119074, 1.712865, -0.064672>, <0.096365, 1.712865, -0.049497>, <0.081191, 1.712865, -0.026788>, <0.081191, 1.686077, -0.000000>, 
			<0.086113, 1.686077, 0.024749>, <0.100132, 1.686077, 0.045730>, <0.121113, 1.686077, 0.059749>, <0.145862, 1.686077, 0.064672>, <0.170611, 1.686077, 0.059749>, <0.191592, 1.686077, 0.045730>, <0.205611, 1.686077, 0.024749>, <0.210534, 1.686077, 0.000000>, <0.205611, 1.686077, -0.024749>, <0.191592, 1.686077, -0.045730>, <0.170611, 1.686077, -0.059749>, 
			<0.145862, 1.686077, -0.064672>, <0.121113, 1.686077, -0.059749>, <0.100132, 1.686077, -0.045730>, <0.086113, 1.686077, -0.024749>, <0.096365, 1.663368, -0.000000>, <0.100132, 1.663368, 0.018942>, <0.110862, 1.663368, 0.035000>, <0.126920, 1.663368, 0.045730>, <0.145862, 1.663368, 0.049497>, <0.164804, 1.663368, 0.045730>, <0.180862, 1.663368, 0.035000>, 
			<0.191592, 1.663368, 0.018942>, <0.195360, 1.663368, 0.000000>, <0.191592, 1.663368, -0.018942>, <0.180862, 1.663368, -0.035000>, <0.164804, 1.663368, -0.045730>, <0.145862, 1.663368, -0.049497>, <0.126920, 1.663368, -0.045730>, <0.110862, 1.663368, -0.035000>, <0.100132, 1.663368, -0.018942>, <0.119074, 1.648193, -0.000000>, <0.121113, 1.648193, 0.010251>, 
			<0.126920, 1.648193, 0.018942>, <0.135611, 1.648193, 0.024749>, <0.145862, 1.648193, 0.026788>, <0.156113, 1.648193, 0.024749>, <0.164804, 1.648193, 0.018942>, <0.170611, 1.648193, 0.010251>, <0.172650, 1.648193, 0.000000>, <0.170611, 1.648193, -0.010251>, <0.164804, 1.648193, -0.018942>, <0.156113, 1.648193, -0.024749>, <0.145862, 1.648193, -0.026788>, 
			<0.135611, 1.648193, -0.024749>, <0.126920, 1.648193, -0.018942>, <0.121113, 1.648193, -0.010251>, <0.145862, 1.782865, -0.000000>, <0.145862, 1.642865, -0.000000>}
	 //#local average_center = <0.145862, 1.712865, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, -0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.395277, -0.907921, -0.139414>, <-0.382195, -0.924082, 0.000000>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <-0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, -0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.617517, -0.734948, -0.280222>, <-0.686014, -0.727193, -0.023971>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.261932, -0.707599, 0.656274>, <-0.000000, -0.752769, 0.658285>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.653142, -0.383160, -0.653142>, <0.379704, -0.356654, -0.853594>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.653142, -0.383160, -0.653142>, <-0.853371, -0.383160, -0.353478>, <-0.921955, -0.382443, 0.061129>, <-0.828382, -0.382443, 0.409293>, <-0.634851, -0.345848, 0.690908>, 
			<-0.378356, -0.419315, 0.825240>, <-0.028309, -0.409068, 0.912065>, <0.379704, -0.356654, 0.853594>, <0.653142, -0.383160, 0.653142>, <0.853594, -0.356654, 0.379704>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.686460, -0.028393, -0.726613>, <0.382683, 0.000000, -0.923880>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.726613, -0.028393, -0.686460>, <-0.923880, 0.000000, -0.382683>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.381845, -0.066159, 0.921855>, <0.028393, 0.028393, 0.999194>, <0.418775, 0.039720, 0.907221>, <0.726613, -0.028393, 0.686460>, <0.923880, 0.000000, 0.382683>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, 0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.353478, 0.383160, 0.853371>, 
			<0.033749, 0.419315, 0.907213>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.023971, 0.727193, -0.686014>, <-0.280222, 0.734948, -0.617517>, <-0.531679, 0.659268, -0.531679>, 
			<-0.642967, 0.727193, -0.240380>, <-0.677747, 0.734948, 0.022578>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.280222, 0.734948, 0.617517>, <-0.023971, 0.727193, 0.686014>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.000000, 0.924082, -0.382195>, <-0.139414, 0.907921, -0.395277>, <-0.312929, 0.896745, -0.312929>, <-0.353102, 0.924082, -0.146260>, <-0.418540, 0.907921, -0.022464>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <-0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <-0.000000, -1.000000, 0.000000>, <-0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <44, 43, 27>, 0, 
			<27, 28, 44>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <39, 55, 54>, 0, 
			<54, 38, 39>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, 
			<45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <47, 63, 62>, 0, <62, 46, 47>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 84>, 0, <101, 100, 84>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <104, 103, 87>, 0, <87, 88, 104>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <44, 43, 27>, 
			<27, 28, 44>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <35, 51, 50>, <50, 34, 35>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <39, 55, 54>, 
			<54, 38, 39>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <44, 60, 59>, <44, 59, 43>, 
			<45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, <47, 63, 62>, <62, 46, 47>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 84>, <101, 100, 84>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <104, 103, 87>, <87, 88, 104>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_11_LeftShoulder = mesh2{
	 vertex_vectors { 114, <-0.171495, 1.777537, -0.000000>, <-0.169456, 1.777537, 0.010251>, <-0.163649, 1.777537, 0.018942>, <-0.154958, 1.777537, 0.024749>, <-0.144707, 1.777537, 0.026788>, <-0.134456, 1.777537, 0.024749>, <-0.125765, 1.777537, 0.018942>, <-0.119958, 1.777537, 0.010251>, <-0.117919, 1.777537, 0.000000>, <-0.119958, 1.777537, -0.010251>, 
			<-0.125765, 1.777537, -0.018942>, <-0.134456, 1.777537, -0.024749>, <-0.144707, 1.777537, -0.026788>, <-0.154958, 1.777537, -0.024749>, <-0.163649, 1.777537, -0.018942>, <-0.169456, 1.777537, -0.010251>, <-0.194204, 1.762362, -0.000000>, <-0.190437, 1.762362, 0.018942>, <-0.179707, 1.762362, 0.035000>, <-0.163649, 1.762362, 0.045730>, <-0.144707, 1.762362, 0.049497>, 
			<-0.125765, 1.762362, 0.045730>, <-0.109707, 1.762362, 0.035000>, <-0.098977, 1.762362, 0.018942>, <-0.095209, 1.762362, 0.000000>, <-0.098977, 1.762362, -0.018942>, <-0.109707, 1.762362, -0.035000>, <-0.125765, 1.762362, -0.045730>, <-0.144707, 1.762362, -0.049497>, <-0.163649, 1.762362, -0.045730>, <-0.179707, 1.762362, -0.035000>, <-0.190437, 1.762362, -0.018942>, 
			<-0.209378, 1.739653, -0.000000>, <-0.204456, 1.739653, 0.024749>, <-0.190437, 1.739653, 0.045730>, <-0.169456, 1.739653, 0.059749>, <-0.144707, 1.739653, 0.064672>, <-0.119958, 1.739653, 0.059749>, <-0.098977, 1.739653, 0.045730>, <-0.084958, 1.739653, 0.024749>, <-0.080035, 1.739653, 0.000000>, <-0.084958, 1.739653, -0.024749>, <-0.098977, 1.739653, -0.045730>, 
			<-0.119958, 1.739653, -0.059749>, <-0.144707, 1.739653, -0.064672>, <-0.169456, 1.739653, -0.059749>, <-0.190437, 1.739653, -0.045730>, <-0.204456, 1.739653, -0.024749>, <-0.214707, 1.712865, -0.000000>, <-0.209378, 1.712865, 0.026788>, <-0.194204, 1.712865, 0.049497>, <-0.171495, 1.712865, 0.064672>, <-0.144707, 1.712865, 0.070000>, <-0.117919, 1.712865, 0.064672>, 
			<-0.095209, 1.712865, 0.049497>, <-0.080035, 1.712865, 0.026788>, <-0.074707, 1.712865, 0.000000>, <-0.080035, 1.712865, -0.026788>, <-0.095209, 1.712865, -0.049497>, <-0.117919, 1.712865, -0.064672>, <-0.144707, 1.712865, -0.070000>, <-0.171495, 1.712865, -0.064672>, <-0.194204, 1.712865, -0.049497>, <-0.209378, 1.712865, -0.026788>, <-0.209378, 1.686077, -0.000000>, 
			<-0.204456, 1.686077, 0.024749>, <-0.190437, 1.686077, 0.045730>, <-0.169456, 1.686077, 0.059749>, <-0.144707, 1.686077, 0.064672>, <-0.119958, 1.686077, 0.059749>, <-0.098977, 1.686077, 0.045730>, <-0.084958, 1.686077, 0.024749>, <-0.080035, 1.686077, 0.000000>, <-0.084958, 1.686077, -0.024749>, <-0.098977, 1.686077, -0.045730>, <-0.119958, 1.686077, -0.059749>, 
			<-0.144707, 1.686077, -0.064672>, <-0.169456, 1.686077, -0.059749>, <-0.190437, 1.686077, -0.045730>, <-0.204456, 1.686077, -0.024749>, <-0.194204, 1.663368, -0.000000>, <-0.190437, 1.663368, 0.018942>, <-0.179707, 1.663368, 0.035000>, <-0.163649, 1.663368, 0.045730>, <-0.144707, 1.663368, 0.049497>, <-0.125765, 1.663368, 0.045730>, <-0.109707, 1.663368, 0.035000>, 
			<-0.098977, 1.663368, 0.018942>, <-0.095209, 1.663368, 0.000000>, <-0.098977, 1.663368, -0.018942>, <-0.109707, 1.663368, -0.035000>, <-0.125765, 1.663368, -0.045730>, <-0.144707, 1.663368, -0.049497>, <-0.163649, 1.663368, -0.045730>, <-0.179707, 1.663368, -0.035000>, <-0.190437, 1.663368, -0.018942>, <-0.171495, 1.648193, -0.000000>, <-0.169456, 1.648193, 0.010251>, 
			<-0.163649, 1.648193, 0.018942>, <-0.154958, 1.648193, 0.024749>, <-0.144707, 1.648193, 0.026788>, <-0.134456, 1.648193, 0.024749>, <-0.125765, 1.648193, 0.018942>, <-0.119958, 1.648193, 0.010251>, <-0.117919, 1.648193, 0.000000>, <-0.119958, 1.648193, -0.010251>, <-0.125765, 1.648193, -0.018942>, <-0.134456, 1.648193, -0.024749>, <-0.144707, 1.648193, -0.026788>, 
			<-0.154958, 1.648193, -0.024749>, <-0.163649, 1.648193, -0.018942>, <-0.169456, 1.648193, -0.010251>, <-0.144707, 1.782865, -0.000000>, <-0.144707, 1.642865, -0.000000>}
	 //#local average_center = <-0.144707, 1.712865, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, -0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.395277, -0.907921, -0.139414>, <-0.382195, -0.924082, 0.000000>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <-0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, -0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <-0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.617517, -0.734948, -0.280222>, <-0.686014, -0.727193, -0.023971>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.653142, -0.383160, -0.653142>, <-0.853371, -0.383160, -0.353478>, <-0.921955, -0.382443, 0.061129>, <-0.828382, -0.382443, 0.409293>, <-0.634851, -0.345848, 0.690908>, 
			<-0.343013, -0.443376, 0.828106>, <-0.004888, -0.383155, 0.923671>, <0.379704, -0.356654, 0.853594>, <0.653142, -0.383160, 0.653142>, <0.853594, -0.356654, 0.379704>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.707107, 0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.726613, -0.028393, -0.686460>, <-0.923880, 0.000000, -0.382683>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.381845, -0.066159, 0.921855>, <0.028393, 0.028393, 0.999194>, <0.418775, 0.039720, 0.907221>, <0.726613, -0.028393, 0.686460>, <0.923880, 0.000000, 0.382683>, <0.912065, 0.409068, -0.028309>, 
			<0.825240, 0.419315, -0.378356>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, 0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.379704, 0.356654, 0.853594>, 
			<-0.000000, 0.443376, 0.896335>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.677747, 0.734948, 0.022578>, <0.642967, 0.727193, -0.240380>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, -0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.240380, 0.727193, 0.642967>, <0.022578, 0.734948, 0.677747>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.146260, 0.924082, 0.353102>, <-0.022464, 0.907921, 0.418540>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <-0.000000, -1.000000, 0.000000>, <-0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <39, 55, 54>, 0, 
			<54, 38, 39>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, 
			<45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <47, 63, 62>, 0, <62, 46, 47>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 64>, 0, <81, 80, 64>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <108, 107, 91>, 0, <91, 92, 108>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <39, 55, 54>, 
			<54, 38, 39>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <44, 60, 59>, <44, 59, 43>, 
			<45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, <47, 63, 62>, <62, 46, 47>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 64>, <81, 80, 64>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <108, 107, 91>, <91, 92, 108>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_12_LeftFoot = mesh2{
	 vertex_vectors { 65, <-0.160537, 0.062482, 0.166634>, <-0.158984, 0.060468, 0.184624>, <-0.154560, 0.058760, 0.199876>, <-0.147939, 0.057618, 0.210067>, <-0.140129, 0.057217, 0.213645>, <-0.132320, 0.057618, 0.210067>, <-0.125699, 0.058760, 0.199876>, <-0.121275, 0.060468, 0.184624>, <-0.119722, 0.062482, 0.166634>, <-0.121275, 0.064497, 0.148644>, 
			<-0.125699, 0.066205, 0.133392>, <-0.132320, 0.067346, 0.123201>, <-0.140129, 0.067747, 0.119623>, <-0.147939, 0.067346, 0.123201>, <-0.154560, 0.066205, 0.133392>, <-0.158984, 0.064497, 0.148644>, <-0.177838, 0.050994, 0.165347>, <-0.174967, 0.047271, 0.198589>, <-0.166793, 0.044115, 0.226771>, <-0.154560, 0.042006, 0.245601>, <-0.140129, 0.041266, 0.252213>, 
			<-0.125699, 0.042006, 0.245601>, <-0.113465, 0.044115, 0.226771>, <-0.105291, 0.047271, 0.198589>, <-0.102421, 0.050994, 0.165347>, <-0.105291, 0.054717, 0.132105>, <-0.113465, 0.057873, 0.103924>, <-0.125699, 0.059982, 0.085094>, <-0.140129, 0.060722, 0.078482>, <-0.154560, 0.059982, 0.085094>, <-0.166793, 0.057873, 0.103924>, <-0.174967, 0.054717, 0.132105>, 
			<-0.189398, 0.033801, 0.163422>, <-0.185648, 0.028937, 0.206855>, <-0.174967, 0.024813, 0.243675>, <-0.158984, 0.022058, 0.268278>, <-0.140129, 0.021090, 0.276917>, <-0.121275, 0.022058, 0.268278>, <-0.105291, 0.024813, 0.243675>, <-0.094611, 0.028937, 0.206855>, <-0.090861, 0.033801, 0.163422>, <-0.094611, 0.038665, 0.119989>, <-0.105291, 0.042788, 0.083169>, 
			<-0.121275, 0.045544, 0.058566>, <-0.140129, 0.046511, 0.049927>, <-0.158984, 0.045544, 0.058566>, <-0.174967, 0.042788, 0.083169>, <-0.185648, 0.038665, 0.119989>, <-0.193457, 0.013520, 0.161151>, <-0.189398, 0.008255, 0.208162>, <-0.177838, 0.003792, 0.248016>, <-0.160537, 0.000809, 0.274646>, <-0.140129, -0.000238, 0.283997>, <-0.119722, 0.000809, 0.274646>, 
			<-0.102421, 0.003792, 0.248016>, <-0.090861, 0.008255, 0.208162>, <-0.086801, 0.013520, 0.161151>, <-0.090861, 0.018785, 0.114139>, <-0.102421, 0.023248, 0.074285>, <-0.119722, 0.026230, 0.047655>, <-0.140129, 0.027277, 0.038304>, <-0.160537, 0.026230, 0.047655>, <-0.177838, 0.023248, 0.074285>, <-0.189398, 0.018785, 0.114139>, <-0.140129, 0.066516, 0.167086>}
	 //#local average_center = <-0.140129, 0.040604, 0.164184>;
	 normal_vectors { 65, <0.382592, -0.918177, -0.102828>, <0.399290, -0.902276, -0.162682>, <0.324973, -0.917236, -0.230372>, <0.195963, -0.938597, -0.283961>, <-0.000000, -0.947032, -0.321140>, <-0.195963, -0.938597, -0.283961>, <-0.324973, -0.917236, -0.230372>, <-0.399290, -0.902276, -0.162682>, <-0.382592, -0.918177, -0.102828>, <-0.399290, -0.915910, -0.040939>, 
			<-0.324973, -0.945473, 0.021765>, <-0.195963, -0.978159, 0.069302>, <0.000000, -0.994609, 0.103694>, <0.195963, -0.978159, 0.069302>, <0.324973, -0.945473, 0.021765>, <0.399290, -0.915910, -0.040939>, <0.658683, -0.747746, -0.083741>, <0.675209, -0.710433, -0.198438>, <0.566638, -0.755740, -0.328296>, <0.349795, -0.821684, -0.449976>, <0.000000, -0.833085, -0.553144>, 
			<-0.349795, -0.821684, -0.449976>, <-0.566638, -0.755740, -0.328296>, <-0.675209, -0.710433, -0.198438>, <-0.658683, -0.747746, -0.083741>, <-0.675209, -0.736729, 0.036368>, <-0.566638, -0.809640, 0.152987>, <-0.349795, -0.900867, 0.257066>, <0.000000, -0.934807, 0.355156>, <0.349795, -0.900867, 0.257066>, <0.566638, -0.809640, 0.152987>, <0.675209, -0.736729, 0.036368>, 
			<0.896499, -0.440293, -0.049309>, <0.899354, -0.385163, -0.206909>, <0.805075, -0.431862, -0.406633>, <0.550680, -0.517927, -0.654602>, <0.000000, -0.490972, -0.871176>, <-0.550680, -0.517927, -0.654602>, <-0.805075, -0.431862, -0.406633>, <-0.899354, -0.385163, -0.206909>, <-0.896499, -0.440293, -0.049309>, <-0.899354, -0.421391, 0.116582>, <-0.805075, -0.511114, 0.301028>, 
			<-0.530101, -0.628861, 0.568795>, <0.000000, -0.740363, 0.672208>, <0.530101, -0.628861, 0.568795>, <0.805075, -0.511114, 0.301028>, <0.899354, -0.421391, 0.116582>, <0.771645, 0.632102, 0.070790>, <0.640107, 0.766303, -0.055165>, <0.818868, 0.434505, -0.375048>, <0.473860, 0.653603, -0.590135>, <0.000000, 0.244038, -0.969766>, <-0.551023, 0.413063, -0.725088>, 
			<-0.591879, 0.775593, -0.219397>, <-0.884845, 0.442643, -0.145316>, <-0.869343, 0.491138, 0.055003>, <-0.758979, 0.607165, 0.235163>, <-0.818868, 0.340777, 0.461872>, <-0.404185, 0.734182, 0.545538>, <-0.000000, -0.269372, 0.963036>, <0.531179, 0.522010, 0.667349>, <0.500132, 0.793119, 0.347607>, <0.969297, 0.099913, 0.224678>, <0.000000, -0.993787, -0.111295>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 126, <0, 64, 1>, 0, <1, 64, 2>, 0, <2, 64, 3>, 0, <3, 64, 4>, 0, <4, 64, 5>, 0, <5, 64, 6>, 0, <6, 64, 7>, 0, <7, 64, 8>, 0, <8, 64, 9>, 0, <9, 64, 10>, 0, 
			<10, 64, 11>, 0, <11, 64, 12>, 0, <12, 64, 13>, 0, <13, 64, 14>, 0, <14, 64, 15>, 0, <15, 64, 0>, 0, <1, 17, 16>, 0, <1, 16, 0>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 18>, 0, 
			<18, 2, 3>, 0, <4, 20, 19>, 0, <4, 19, 3>, 0, <5, 21, 4>, 0, <21, 20, 4>, 0, <22, 21, 5>, 0, <5, 6, 22>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <7, 8, 24>, 0, <7, 24, 23>, 0, 
			<9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <11, 27, 26>, 0, <11, 26, 10>, 0, <12, 28, 27>, 0, <12, 27, 11>, 0, <12, 13, 29>, 0, <12, 29, 28>, 0, <14, 30, 13>, 0, 
			<30, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, <17, 32, 16>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 34>, 0, <34, 18, 19>, 0, 
			<20, 36, 35>, 0, <20, 35, 19>, 0, <20, 21, 37>, 0, <20, 37, 36>, 0, <38, 37, 21>, 0, <21, 22, 38>, 0, <39, 38, 22>, 0, <22, 23, 39>, 0, <23, 24, 40>, 0, <23, 40, 39>, 0, <25, 41, 40>, 0, 
			<25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <27, 43, 42>, 0, <27, 42, 26>, 0, <28, 44, 43>, 0, <28, 43, 27>, 0, <28, 29, 45>, 0, <28, 45, 44>, 0, <30, 46, 29>, 0, <46, 45, 29>, 0, 
			<31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <34, 50, 49>, 0, <49, 33, 34>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <36, 52, 51>, 0, 
			<51, 35, 36>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, <38, 39, 55>, 0, <39, 40, 56>, 0, <39, 56, 55>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, 
			<42, 58, 57>, 0, <42, 57, 41>, 0, <43, 59, 58>, 0, <43, 58, 42>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, <45, 61, 60>, 0, <45, 60, 44>, 0, <45, 46, 62>, 0, <45, 62, 61>, 0, <47, 63, 46>, 0, 
			<63, 62, 46>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <48, 62, 63>, 0, <49, 54, 55>, 0, <49, 55, 56>, 0, <51, 53, 54>, 0, <53, 51, 52>, 0, <54, 49, 50>, 0, <54, 50, 51>, 0, <56, 57, 48>, 0, 
			<56, 48, 49>, 0, <57, 58, 62>, 0, <57, 62, 48>, 0, <58, 59, 62>, 0, <59, 60, 61>, 0, <59, 61, 62>, 0}
	 normal_indices { 126, <0, 64, 1>, <1, 64, 2>, <2, 64, 3>, <3, 64, 4>, <4, 64, 5>, <5, 64, 6>, <6, 64, 7>, <7, 64, 8>, <8, 64, 9>, <9, 64, 10>, 
			<10, 64, 11>, <11, 64, 12>, <12, 64, 13>, <13, 64, 14>, <14, 64, 15>, <15, 64, 0>, <1, 17, 16>, <1, 16, 0>, <2, 18, 17>, <17, 1, 2>, <3, 19, 18>, 
			<18, 2, 3>, <4, 20, 19>, <4, 19, 3>, <5, 21, 4>, <21, 20, 4>, <22, 21, 5>, <5, 6, 22>, <23, 22, 6>, <6, 7, 23>, <7, 8, 24>, <7, 24, 23>, 
			<9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <11, 27, 26>, <11, 26, 10>, <12, 28, 27>, <12, 27, 11>, <12, 13, 29>, <12, 29, 28>, <14, 30, 13>, 
			<30, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, <17, 32, 16>, <18, 34, 33>, <33, 17, 18>, <19, 35, 34>, <34, 18, 19>, 
			<20, 36, 35>, <20, 35, 19>, <20, 21, 37>, <20, 37, 36>, <38, 37, 21>, <21, 22, 38>, <39, 38, 22>, <22, 23, 39>, <23, 24, 40>, <23, 40, 39>, <25, 41, 40>, 
			<25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <27, 43, 42>, <27, 42, 26>, <28, 44, 43>, <28, 43, 27>, <28, 29, 45>, <28, 45, 44>, <30, 46, 29>, <46, 45, 29>, 
			<31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <33, 48, 32>, <34, 50, 49>, <49, 33, 34>, <35, 51, 50>, <50, 34, 35>, <36, 52, 51>, 
			<51, 35, 36>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, <38, 39, 55>, <39, 40, 56>, <39, 56, 55>, <41, 57, 56>, <41, 56, 40>, 
			<42, 58, 57>, <42, 57, 41>, <43, 59, 58>, <43, 58, 42>, <60, 59, 43>, <43, 44, 60>, <45, 61, 60>, <45, 60, 44>, <45, 46, 62>, <45, 62, 61>, <47, 63, 46>, 
			<63, 62, 46>, <32, 48, 47>, <48, 63, 47>, <48, 62, 63>, <49, 54, 55>, <49, 55, 56>, <51, 53, 54>, <53, 51, 52>, <54, 49, 50>, <54, 50, 51>, <56, 57, 48>, 
			<56, 48, 49>, <57, 58, 62>, <57, 62, 48>, <58, 59, 62>, <59, 60, 61>, <59, 61, 62>}
	 uv_indices { 126, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_13_RightFoot = mesh2{
	 vertex_vectors { 65, <0.051102, 0.052870, 0.057299>, <0.052655, 0.052870, 0.075402>, <0.057079, 0.052870, 0.090749>, <0.063700, 0.052870, 0.101004>, <0.071509, 0.052870, 0.104604>, <0.079319, 0.052870, 0.101004>, <0.085940, 0.052870, 0.090749>, <0.090364, 0.052870, 0.075402>, <0.091917, 0.052870, 0.057299>, <0.090364, 0.052870, 0.039196>, 
			<0.085940, 0.052870, 0.023849>, <0.079319, 0.052870, 0.013595>, <0.071509, 0.052870, 0.009994>, <0.063700, 0.052870, 0.013595>, <0.057079, 0.052870, 0.023849>, <0.052655, 0.052870, 0.039196>, <0.033801, 0.041310, 0.057299>, <0.036671, 0.041310, 0.090749>, <0.044845, 0.041310, 0.119106>, <0.057079, 0.041310, 0.138054>, <0.071509, 0.041310, 0.144708>, 
			<0.085940, 0.041310, 0.138054>, <0.098173, 0.041310, 0.119106>, <0.106348, 0.041310, 0.090749>, <0.109218, 0.041310, 0.057299>, <0.106348, 0.041310, 0.023849>, <0.098173, 0.041310, -0.004508>, <0.085940, 0.041310, -0.023456>, <0.071509, 0.041310, -0.030109>, <0.057079, 0.041310, -0.023456>, <0.044845, 0.041310, -0.004508>, <0.036671, 0.041310, 0.023849>, 
			<0.022241, 0.024009, 0.057299>, <0.025991, 0.024009, 0.101004>, <0.036671, 0.024009, 0.138054>, <0.052655, 0.024009, 0.162811>, <0.071509, 0.024009, 0.171504>, <0.090364, 0.024009, 0.162811>, <0.106348, 0.024009, 0.138054>, <0.117028, 0.024009, 0.101004>, <0.120778, 0.024009, 0.057299>, <0.117028, 0.024009, 0.013595>, <0.106348, 0.024009, -0.023456>, 
			<0.090364, 0.024009, -0.048212>, <0.071509, 0.024009, -0.056905>, <0.052655, 0.024009, -0.048212>, <0.036671, 0.024009, -0.023456>, <0.025991, 0.024009, 0.013595>, <0.018181, 0.003602, 0.057299>, <0.022241, 0.003602, 0.104604>, <0.033801, 0.003602, 0.144708>, <0.051102, 0.003602, 0.171504>, <0.071509, 0.003602, 0.180914>, <0.091917, 0.003602, 0.171504>, 
			<0.109218, 0.003602, 0.144708>, <0.120778, 0.003602, 0.104604>, <0.124837, 0.003602, 0.057299>, <0.120778, 0.003602, 0.009994>, <0.109218, 0.003602, -0.030109>, <0.091917, 0.003602, -0.056905>, <0.071509, 0.003602, -0.066315>, <0.051102, 0.003602, -0.056905>, <0.033801, 0.003602, -0.030109>, <0.022241, 0.003602, 0.009994>, <0.071509, 0.056930, 0.057299>}
	 //#local average_center = <0.071509, 0.030855, 0.057299>;
	 normal_vectors { 65, <0.382592, -0.923917, 0.000000>, <0.399290, -0.914776, -0.061252>, <0.324973, -0.937177, -0.126856>, <0.195963, -0.964369, -0.177736>, <-0.000000, -0.976889, -0.213745>, <-0.195963, -0.964369, -0.177736>, <-0.324973, -0.937177, -0.126856>, <-0.399290, -0.914776, -0.061252>, <-0.382592, -0.923917, -0.000000>, <-0.399290, -0.914776, 0.061252>, 
			<-0.324973, -0.937177, 0.126856>, <-0.195963, -0.964369, 0.177736>, <-0.000000, -0.976889, 0.213745>, <0.195963, -0.964369, 0.177736>, <0.324973, -0.937177, 0.126856>, <0.399290, -0.914776, 0.061252>, <0.658683, -0.752420, -0.000000>, <0.675209, -0.728105, -0.118137>, <0.566638, -0.787583, -0.242146>, <0.349795, -0.866660, -0.355731>, <-0.000000, -0.889472, -0.456989>, 
			<-0.349795, -0.866660, -0.355731>, <-0.566638, -0.787583, -0.242146>, <-0.675209, -0.728105, -0.118137>, <-0.658683, -0.752420, -0.000000>, <-0.675209, -0.728105, 0.118137>, <-0.566638, -0.787583, 0.242146>, <-0.349795, -0.866660, 0.355731>, <0.000000, -0.889472, 0.456989>, <0.349795, -0.866660, 0.355731>, <0.566638, -0.787583, 0.242146>, <0.675209, -0.728105, 0.118137>, 
			<0.896499, -0.443046, -0.000000>, <0.899354, -0.405798, -0.162757>, <0.805075, -0.474435, -0.356042>, <0.530101, -0.561650, -0.635250>, <-0.085017, -0.613858, -0.784825>, <-0.550680, -0.587564, -0.592892>, <-0.805075, -0.474435, -0.356042>, <-0.899354, -0.405798, -0.162757>, <-0.896499, -0.443046, -0.000000>, <-0.899354, -0.405798, 0.162757>, <-0.805075, -0.474435, 0.356042>, 
			<-0.530101, -0.561650, 0.635250>, <-0.000000, -0.660949, 0.750431>, <0.530101, -0.561650, 0.635250>, <0.805075, -0.474435, 0.356042>, <0.899354, -0.405798, 0.162757>, <0.771645, 0.636054, 0.000000>, <0.640107, 0.755402, -0.140109>, <0.818868, 0.390065, -0.421076>, <0.404185, 0.790337, -0.460437>, <0.151614, -0.062288, -0.986475>, <-0.551023, 0.329798, -0.766556>, 
			<-0.591879, 0.746357, -0.304354>, <-0.884845, 0.423720, -0.193678>, <-0.869343, 0.494208, -0.000000>, <-0.758979, 0.629566, 0.166128>, <-0.818868, 0.390065, 0.421076>, <-0.404185, 0.790337, 0.460437>, <-0.000000, -0.160517, 0.987033>, <0.531179, 0.593040, 0.605106>, <0.500132, 0.826879, 0.257176>, <0.969297, 0.124298, 0.212163>, <0.000000, -1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 126, <0, 64, 1>, 0, <1, 64, 2>, 0, <2, 64, 3>, 0, <3, 64, 4>, 0, <4, 64, 5>, 0, <5, 64, 6>, 0, <6, 64, 7>, 0, <7, 64, 8>, 0, <8, 64, 9>, 0, <9, 64, 10>, 0, 
			<10, 64, 11>, 0, <11, 64, 12>, 0, <12, 64, 13>, 0, <13, 64, 14>, 0, <14, 64, 15>, 0, <15, 64, 0>, 0, <1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 18>, 0, 
			<18, 2, 3>, 0, <4, 20, 19>, 0, <4, 19, 3>, 0, <5, 21, 4>, 0, <21, 20, 4>, 0, <22, 21, 5>, 0, <5, 6, 22>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, 
			<9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <11, 27, 26>, 0, <11, 26, 10>, 0, <12, 28, 27>, 0, <12, 27, 11>, 0, <12, 13, 29>, 0, <12, 29, 28>, 0, <14, 30, 13>, 0, 
			<30, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, <32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 34>, 0, <34, 18, 19>, 0, 
			<20, 36, 35>, 0, <20, 35, 19>, 0, <20, 21, 37>, 0, <20, 37, 36>, 0, <38, 37, 21>, 0, <21, 22, 38>, 0, <39, 38, 22>, 0, <22, 23, 39>, 0, <23, 24, 40>, 0, <23, 40, 39>, 0, <25, 41, 40>, 0, 
			<25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <27, 43, 42>, 0, <27, 42, 26>, 0, <28, 44, 43>, 0, <28, 43, 27>, 0, <28, 29, 45>, 0, <28, 45, 44>, 0, <30, 46, 29>, 0, <46, 45, 29>, 0, 
			<31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, <34, 50, 49>, 0, <34, 49, 33>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <52, 51, 35>, 0, 
			<35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, <38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, 
			<42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 58>, 0, <43, 58, 42>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, <45, 61, 60>, 0, <60, 44, 45>, 0, <45, 46, 62>, 0, <45, 62, 61>, 0, <63, 62, 46>, 0, 
			<46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <48, 62, 63>, 0, <49, 54, 55>, 0, <49, 55, 56>, 0, <51, 53, 54>, 0, <53, 51, 52>, 0, <54, 49, 50>, 0, <54, 50, 51>, 0, <56, 57, 48>, 0, 
			<56, 48, 49>, 0, <57, 58, 62>, 0, <57, 62, 48>, 0, <58, 59, 62>, 0, <59, 60, 61>, 0, <59, 61, 62>, 0}
	 normal_indices { 126, <0, 64, 1>, <1, 64, 2>, <2, 64, 3>, <3, 64, 4>, <4, 64, 5>, <5, 64, 6>, <6, 64, 7>, <7, 64, 8>, <8, 64, 9>, <9, 64, 10>, 
			<10, 64, 11>, <11, 64, 12>, <12, 64, 13>, <13, 64, 14>, <14, 64, 15>, <15, 64, 0>, <1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 18>, 
			<18, 2, 3>, <4, 20, 19>, <4, 19, 3>, <5, 21, 4>, <21, 20, 4>, <22, 21, 5>, <5, 6, 22>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, 
			<9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <11, 27, 26>, <11, 26, 10>, <12, 28, 27>, <12, 27, 11>, <12, 13, 29>, <12, 29, 28>, <14, 30, 13>, 
			<30, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, <32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 34>, <34, 18, 19>, 
			<20, 36, 35>, <20, 35, 19>, <20, 21, 37>, <20, 37, 36>, <38, 37, 21>, <21, 22, 38>, <39, 38, 22>, <22, 23, 39>, <23, 24, 40>, <23, 40, 39>, <25, 41, 40>, 
			<25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <27, 43, 42>, <27, 42, 26>, <28, 44, 43>, <28, 43, 27>, <28, 29, 45>, <28, 45, 44>, <30, 46, 29>, <46, 45, 29>, 
			<31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <48, 32, 33>, <34, 50, 49>, <34, 49, 33>, <35, 51, 50>, <50, 34, 35>, <52, 51, 35>, 
			<35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, <38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <41, 57, 56>, <41, 56, 40>, 
			<42, 58, 57>, <57, 41, 42>, <43, 59, 58>, <43, 58, 42>, <60, 59, 43>, <43, 44, 60>, <45, 61, 60>, <60, 44, 45>, <45, 46, 62>, <45, 62, 61>, <63, 62, 46>, 
			<46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <48, 62, 63>, <49, 54, 55>, <49, 55, 56>, <51, 53, 54>, <53, 51, 52>, <54, 49, 50>, <54, 50, 51>, <56, 57, 48>, 
			<56, 48, 49>, <57, 58, 62>, <57, 62, 48>, <58, 59, 62>, <59, 60, 61>, <59, 61, 62>}
	 uv_indices { 126, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_14_LeftAnkle = mesh2{
	 vertex_vectors { 114, <-0.158273, 0.124065, 0.106885>, <-0.157002, 0.124065, 0.113276>, <-0.153382, 0.124065, 0.118694>, <-0.147963, 0.124065, 0.122315>, <-0.141572, 0.124065, 0.123586>, <-0.135181, 0.124065, 0.122315>, <-0.129762, 0.124065, 0.118694>, <-0.126142, 0.124065, 0.113276>, <-0.124870, 0.124065, 0.106885>, <-0.126142, 0.124065, 0.100493>, 
			<-0.129762, 0.124065, 0.095075>, <-0.135181, 0.124065, 0.091454>, <-0.141572, 0.124065, 0.090183>, <-0.147963, 0.124065, 0.091454>, <-0.153382, 0.124065, 0.095075>, <-0.157002, 0.124065, 0.100493>, <-0.172432, 0.114604, 0.106885>, <-0.170083, 0.114604, 0.118694>, <-0.163393, 0.114604, 0.128706>, <-0.153382, 0.114604, 0.135396>, <-0.141572, 0.114604, 0.137745>, 
			<-0.129762, 0.114604, 0.135396>, <-0.119750, 0.114604, 0.128706>, <-0.113061, 0.114604, 0.118694>, <-0.110712, 0.114604, 0.106885>, <-0.113061, 0.114604, 0.095075>, <-0.119750, 0.114604, 0.085063>, <-0.129762, 0.114604, 0.078373>, <-0.141572, 0.114604, 0.076024>, <-0.153382, 0.114604, 0.078373>, <-0.163393, 0.114604, 0.085063>, <-0.170083, 0.114604, 0.095075>, 
			<-0.181893, 0.100445, 0.106885>, <-0.178824, 0.100445, 0.122315>, <-0.170083, 0.100445, 0.135396>, <-0.157002, 0.100445, 0.144136>, <-0.141572, 0.100445, 0.147206>, <-0.126142, 0.100445, 0.144136>, <-0.113061, 0.100445, 0.135396>, <-0.104320, 0.100445, 0.122315>, <-0.101251, 0.100445, 0.106885>, <-0.104320, 0.100445, 0.091454>, <-0.113061, 0.100445, 0.078373>, 
			<-0.126142, 0.100445, 0.069633>, <-0.141572, 0.100445, 0.066564>, <-0.157002, 0.100445, 0.069633>, <-0.170083, 0.100445, 0.078373>, <-0.178824, 0.100445, 0.091454>, <-0.185215, 0.083744, 0.106885>, <-0.181893, 0.083744, 0.123586>, <-0.172432, 0.083744, 0.137745>, <-0.158273, 0.083744, 0.147206>, <-0.141572, 0.083744, 0.150528>, <-0.124870, 0.083744, 0.147206>, 
			<-0.110712, 0.083744, 0.137745>, <-0.101251, 0.083744, 0.123586>, <-0.097929, 0.083744, 0.106885>, <-0.101251, 0.083744, 0.090183>, <-0.110712, 0.083744, 0.076024>, <-0.124870, 0.083744, 0.066564>, <-0.141572, 0.083744, 0.063242>, <-0.158273, 0.083744, 0.066564>, <-0.172432, 0.083744, 0.076024>, <-0.181893, 0.083744, 0.090183>, <-0.181893, 0.067042, 0.106885>, 
			<-0.178824, 0.067042, 0.122315>, <-0.170083, 0.067042, 0.135396>, <-0.157002, 0.067042, 0.144136>, <-0.141572, 0.067042, 0.147206>, <-0.126142, 0.067042, 0.144136>, <-0.113061, 0.067042, 0.135396>, <-0.104320, 0.067042, 0.122315>, <-0.101251, 0.067042, 0.106885>, <-0.104320, 0.067042, 0.091454>, <-0.113061, 0.067042, 0.078373>, <-0.126142, 0.067042, 0.069633>, 
			<-0.141572, 0.067042, 0.066564>, <-0.157002, 0.067042, 0.069633>, <-0.170083, 0.067042, 0.078373>, <-0.178824, 0.067042, 0.091454>, <-0.172432, 0.052883, 0.106885>, <-0.170083, 0.052883, 0.118694>, <-0.163393, 0.052883, 0.128706>, <-0.153382, 0.052883, 0.135396>, <-0.141572, 0.052883, 0.137745>, <-0.129762, 0.052883, 0.135396>, <-0.119750, 0.052883, 0.128706>, 
			<-0.113061, 0.052883, 0.118694>, <-0.110712, 0.052883, 0.106885>, <-0.113061, 0.052883, 0.095075>, <-0.119750, 0.052883, 0.085063>, <-0.129762, 0.052883, 0.078373>, <-0.141572, 0.052883, 0.076024>, <-0.153382, 0.052883, 0.078373>, <-0.163393, 0.052883, 0.085063>, <-0.170083, 0.052883, 0.095075>, <-0.158273, 0.043423, 0.106885>, <-0.157002, 0.043423, 0.113276>, 
			<-0.153382, 0.043423, 0.118694>, <-0.147963, 0.043423, 0.122315>, <-0.141572, 0.043423, 0.123586>, <-0.135181, 0.043423, 0.122315>, <-0.129762, 0.043423, 0.118694>, <-0.126142, 0.043423, 0.113276>, <-0.124870, 0.043423, 0.106885>, <-0.126142, 0.043423, 0.100493>, <-0.129762, 0.043423, 0.095075>, <-0.135181, 0.043423, 0.091454>, <-0.141572, 0.043423, 0.090183>, 
			<-0.147963, 0.043423, 0.091454>, <-0.153382, 0.043423, 0.095075>, <-0.157002, 0.043423, 0.100493>, <-0.141572, 0.127387, 0.106885>, <-0.141572, 0.040101, 0.106885>}
	 //#local average_center = <-0.141572, 0.083744, 0.106885>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, 0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.608176, -0.752769, -0.251915>, <-0.706555, -0.707599, -0.009151>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.896335, -0.443376, -0.000000>, <0.853594, -0.356654, -0.379704>, <0.634851, -0.345848, -0.690908>, <0.378356, -0.419315, -0.825240>, <0.028309, -0.409068, -0.912065>, <-0.379704, -0.356654, -0.853594>, <-0.690908, -0.345848, -0.634851>, <-0.828106, -0.443376, -0.343013>, <-0.923671, -0.383155, -0.004888>, <-0.853594, -0.356654, 0.379704>, <-0.653142, -0.383160, 0.653142>, 
			<-0.353478, -0.383160, 0.853371>, <0.033749, -0.419315, 0.907213>, <0.379704, -0.356654, 0.853594>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.999194, -0.028393, 0.028393>, <0.921855, 0.066159, -0.381845>, <0.707107, 0.000000, -0.707107>, <0.381845, -0.066159, -0.921855>, <0.000000, 0.000000, -1.000000>, <-0.381845, 0.066159, -0.921855>, 
			<-0.707107, -0.000000, -0.707107>, <-0.921855, -0.066159, -0.381845>, <-0.999194, 0.028393, 0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.382683, 0.000000, 0.923880>, <-0.000000, 0.000000, 1.000000>, <0.418775, 0.039720, 0.907221>, <0.677904, -0.039720, 0.734076>, <0.896538, 0.000000, 0.442968>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, -0.000000>, <-0.853594, 0.356654, 0.379704>, <-0.653142, 0.383160, 0.653142>, <-0.353478, 0.383160, 0.853371>, 
			<0.033749, 0.419315, 0.907213>, <0.348957, 0.383155, 0.855231>, <0.669649, 0.321155, 0.669649>, <0.855231, 0.383155, 0.348957>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.280222, 0.734948, 0.617517>, <-0.023971, 0.727193, 0.686014>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <40, 56, 55>, 0, <40, 55, 39>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <58, 74, 73>, 0, <73, 57, 58>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <63, 79, 78>, 0, <78, 62, 63>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <48, 32, 33>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <40, 56, 55>, <40, 55, 39>, <41, 57, 56>, <41, 56, 40>, <58, 57, 41>, <41, 42, 58>, <43, 59, 58>, <58, 42, 43>, <60, 59, 43>, <43, 44, 60>, 
			<45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <58, 74, 73>, <73, 57, 58>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <63, 79, 78>, <78, 62, 63>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_15_RightAnkle = mesh2{
	 vertex_vectors { 114, <0.050960, 0.097214, -0.000000>, <0.052231, 0.097214, 0.006391>, <0.055852, 0.097214, 0.011810>, <0.061270, 0.097214, 0.015430>, <0.067661, 0.097214, 0.016701>, <0.074053, 0.097214, 0.015430>, <0.079471, 0.097214, 0.011810>, <0.083092, 0.097214, 0.006391>, <0.084363, 0.097214, 0.000000>, <0.083092, 0.097214, -0.006391>, 
			<0.079471, 0.097214, -0.011810>, <0.074053, 0.097214, -0.015430>, <0.067661, 0.097214, -0.016701>, <0.061270, 0.097214, -0.015430>, <0.055852, 0.097214, -0.011810>, <0.052231, 0.097214, -0.006391>, <0.036801, 0.087754, -0.000000>, <0.039150, 0.087754, 0.011810>, <0.045840, 0.087754, 0.021822>, <0.055852, 0.087754, 0.028511>, <0.067661, 0.087754, 0.030860>, 
			<0.079471, 0.087754, 0.028511>, <0.089483, 0.087754, 0.021822>, <0.096173, 0.087754, 0.011810>, <0.098522, 0.087754, 0.000000>, <0.096173, 0.087754, -0.011810>, <0.089483, 0.087754, -0.021822>, <0.079471, 0.087754, -0.028511>, <0.067661, 0.087754, -0.030860>, <0.055852, 0.087754, -0.028511>, <0.045840, 0.087754, -0.021822>, <0.039150, 0.087754, -0.011810>, 
			<0.027341, 0.073595, -0.000000>, <0.030410, 0.073595, 0.015430>, <0.039150, 0.073595, 0.028511>, <0.052231, 0.073595, 0.037252>, <0.067661, 0.073595, 0.040321>, <0.083092, 0.073595, 0.037252>, <0.096173, 0.073595, 0.028511>, <0.104913, 0.073595, 0.015430>, <0.107982, 0.073595, 0.000000>, <0.104913, 0.073595, -0.015430>, <0.096173, 0.073595, -0.028511>, 
			<0.083092, 0.073595, -0.037252>, <0.067661, 0.073595, -0.040321>, <0.052231, 0.073595, -0.037252>, <0.039150, 0.073595, -0.028511>, <0.030410, 0.073595, -0.015430>, <0.024018, 0.056893, -0.000000>, <0.027341, 0.056893, 0.016701>, <0.036801, 0.056893, 0.030860>, <0.050960, 0.056893, 0.040321>, <0.067661, 0.056893, 0.043643>, <0.084363, 0.056893, 0.040321>, 
			<0.098522, 0.056893, 0.030860>, <0.107982, 0.056893, 0.016701>, <0.111304, 0.056893, 0.000000>, <0.107982, 0.056893, -0.016701>, <0.098522, 0.056893, -0.030860>, <0.084363, 0.056893, -0.040321>, <0.067661, 0.056893, -0.043643>, <0.050960, 0.056893, -0.040321>, <0.036801, 0.056893, -0.030860>, <0.027341, 0.056893, -0.016701>, <0.027341, 0.040192, -0.000000>, 
			<0.030410, 0.040192, 0.015430>, <0.039150, 0.040192, 0.028511>, <0.052231, 0.040192, 0.037252>, <0.067661, 0.040192, 0.040321>, <0.083092, 0.040192, 0.037252>, <0.096173, 0.040192, 0.028511>, <0.104913, 0.040192, 0.015430>, <0.107982, 0.040192, 0.000000>, <0.104913, 0.040192, -0.015430>, <0.096173, 0.040192, -0.028511>, <0.083092, 0.040192, -0.037252>, 
			<0.067661, 0.040192, -0.040321>, <0.052231, 0.040192, -0.037252>, <0.039150, 0.040192, -0.028511>, <0.030410, 0.040192, -0.015430>, <0.036801, 0.026033, -0.000000>, <0.039150, 0.026033, 0.011810>, <0.045840, 0.026033, 0.021822>, <0.055852, 0.026033, 0.028511>, <0.067661, 0.026033, 0.030860>, <0.079471, 0.026033, 0.028511>, <0.089483, 0.026033, 0.021822>, 
			<0.096173, 0.026033, 0.011810>, <0.098522, 0.026033, 0.000000>, <0.096173, 0.026033, -0.011810>, <0.089483, 0.026033, -0.021822>, <0.079471, 0.026033, -0.028511>, <0.067661, 0.026033, -0.030860>, <0.055852, 0.026033, -0.028511>, <0.045840, 0.026033, -0.021822>, <0.039150, 0.026033, -0.011810>, <0.050960, 0.016573, -0.000000>, <0.052231, 0.016573, 0.006391>, 
			<0.055852, 0.016573, 0.011810>, <0.061270, 0.016573, 0.015430>, <0.067661, 0.016573, 0.016701>, <0.074053, 0.016573, 0.015430>, <0.079471, 0.016573, 0.011810>, <0.083092, 0.016573, 0.006391>, <0.084363, 0.016573, 0.000000>, <0.083092, 0.016573, -0.006391>, <0.079471, 0.016573, -0.011810>, <0.074053, 0.016573, -0.015430>, <0.067661, 0.016573, -0.016701>, 
			<0.061270, 0.016573, -0.015430>, <0.055852, 0.016573, -0.011810>, <0.052231, 0.016573, -0.006391>, <0.067661, 0.100536, -0.000000>, <0.067661, 0.013250, -0.000000>}
	 //#local average_center = <0.067661, 0.056893, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.395277, -0.907921, -0.139414>, <-0.382195, -0.924082, 0.000000>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, 0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.617517, -0.734948, -0.280222>, <-0.686014, -0.727193, -0.023971>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.896335, -0.443376, 0.000000>, <0.853594, -0.356654, -0.379704>, <0.634851, -0.345848, -0.690908>, <0.378356, -0.419315, -0.825240>, <0.000000, -0.383160, -0.923682>, <-0.378356, -0.419315, -0.825240>, <-0.669649, -0.321155, -0.669649>, <-0.828106, -0.443376, -0.343013>, <-0.923671, -0.383155, -0.004888>, <-0.853594, -0.356654, 0.379704>, <-0.634851, -0.345848, 0.690908>, 
			<-0.343013, -0.443376, 0.828106>, <0.024145, -0.356654, 0.933924>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.999194, -0.028393, 0.028393>, <0.937621, 0.039720, -0.345383>, <0.726613, 0.028393, -0.686460>, <0.381845, -0.066159, -0.921855>, <0.039720, 0.039720, -0.998421>, <-0.356143, -0.028393, -0.934000>, 
			<-0.677904, 0.039720, -0.734076>, <-0.912269, -0.028393, -0.408607>, <-0.999194, 0.028393, 0.028393>, <-0.907221, 0.039720, 0.418775>, <-0.707107, 0.000000, 0.707107>, <-0.381845, -0.066159, 0.921855>, <-0.000000, 0.066159, 0.997809>, <0.382683, 0.000000, 0.923880>, <0.677904, -0.039720, 0.734076>, <0.896538, 0.000000, 0.442968>, <0.923671, 0.383155, -0.004888>, 
			<0.831805, 0.409068, -0.375186>, <0.653142, 0.383160, -0.653142>, <0.379704, 0.356654, -0.853594>, <-0.028309, 0.409068, -0.912065>, <-0.409293, 0.382443, -0.828382>, <-0.690908, 0.345848, -0.634851>, <-0.855231, 0.383155, -0.348957>, <-0.896335, 0.443376, -0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.379704, 0.356654, 0.853594>, 
			<-0.000000, 0.443376, 0.896335>, <0.348957, 0.383155, 0.855231>, <0.669649, 0.321155, 0.669649>, <0.855231, 0.383155, 0.348957>, <0.686014, 0.727193, -0.023971>, <0.617517, 0.734948, -0.280222>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <0.000000, 0.752769, -0.658285>, <-0.261932, 0.707599, -0.656274>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, -0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.382195, 0.924082, -0.000000>, <0.395277, 0.907921, -0.139414>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <0.000000, 0.924082, -0.382195>, <-0.139414, 0.907921, -0.395277>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, -0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, -0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 36>, 0, <53, 52, 36>, 0, <38, 54, 53>, 0, <53, 37, 38>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <40, 56, 55>, 0, <40, 55, 39>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <50, 66, 65>, 0, 
			<65, 49, 50>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <54, 70, 69>, 0, <69, 53, 54>, 0, <55, 71, 70>, 0, <70, 54, 55>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <63, 79, 78>, 0, <78, 62, 63>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 68>, 0, <85, 84, 68>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 80>, 0, <97, 96, 80>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 84>, 0, <101, 100, 84>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <48, 32, 33>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <36, 52, 51>, <51, 35, 36>, <37, 53, 36>, <53, 52, 36>, <38, 54, 53>, <53, 37, 38>, <55, 54, 38>, 
			<38, 39, 55>, <40, 56, 55>, <40, 55, 39>, <41, 57, 56>, <41, 56, 40>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <44, 60, 59>, <44, 59, 43>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <49, 65, 64>, <64, 48, 49>, <50, 66, 65>, 
			<65, 49, 50>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <54, 70, 69>, <69, 53, 54>, <55, 71, 70>, <70, 54, 55>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <63, 79, 78>, <78, 62, 63>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 68>, <85, 84, 68>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 80>, <97, 96, 80>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 84>, <101, 100, 84>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_16_LeftShin = mesh2{
	 vertex_vectors { 112, <-0.195654, 0.539294, 0.106885>, <-0.191763, 0.539294, 0.126446>, <-0.180683, 0.539294, 0.143030>, <-0.164099, 0.539294, 0.154110>, <-0.144538, 0.539294, 0.158001>, <-0.124976, 0.539294, 0.154110>, <-0.108393, 0.539294, 0.143030>, <-0.097312, 0.539294, 0.126446>, <-0.093421, 0.539294, 0.106885>, <-0.097312, 0.539294, 0.087323>, 
			<-0.108393, 0.539294, 0.070740>, <-0.124976, 0.539294, 0.059659>, <-0.144538, 0.539294, 0.055768>, <-0.164099, 0.539294, 0.059659>, <-0.180683, 0.539294, 0.070740>, <-0.191763, 0.539294, 0.087323>, <-0.185887, 0.121102, 0.106885>, <-0.182739, 0.121102, 0.122708>, <-0.173776, 0.121102, 0.136123>, <-0.160361, 0.121102, 0.145086>, <-0.144538, 0.121102, 0.148234>, 
			<-0.128714, 0.121102, 0.145086>, <-0.115299, 0.121102, 0.136123>, <-0.106336, 0.121102, 0.122708>, <-0.103189, 0.121102, 0.106885>, <-0.106336, 0.121102, 0.091061>, <-0.115299, 0.121102, 0.077646>, <-0.128714, 0.121102, 0.068683>, <-0.144538, 0.121102, 0.065535>, <-0.160361, 0.121102, 0.068683>, <-0.173776, 0.121102, 0.077646>, <-0.182739, 0.121102, 0.091061>, 
			<-0.183040, 0.556445, 0.122833>, <-0.186213, 0.556445, 0.106885>, <-0.183040, 0.556445, 0.090936>, <-0.174006, 0.556445, 0.077416>, <-0.160486, 0.556445, 0.068382>, <-0.144538, 0.556445, 0.065210>, <-0.128590, 0.556445, 0.068382>, <-0.115069, 0.556445, 0.077416>, <-0.106035, 0.556445, 0.090936>, <-0.102863, 0.556445, 0.106885>, <-0.106035, 0.556445, 0.122833>, 
			<-0.115069, 0.556445, 0.136353>, <-0.128590, 0.556445, 0.145387>, <-0.144538, 0.556445, 0.148559>, <-0.160486, 0.556445, 0.145387>, <-0.174006, 0.556445, 0.136353>, <-0.154240, 0.568635, 0.110904>, <-0.155040, 0.568635, 0.106885>, <-0.154240, 0.568635, 0.102866>, <-0.151964, 0.568635, 0.099459>, <-0.148557, 0.568635, 0.097182>, <-0.144538, 0.568635, 0.096383>, 
			<-0.140519, 0.568635, 0.097182>, <-0.137112, 0.568635, 0.099459>, <-0.134835, 0.568635, 0.102866>, <-0.134036, 0.568635, 0.106885>, <-0.134835, 0.568635, 0.110904>, <-0.137112, 0.568635, 0.114311>, <-0.140519, 0.568635, 0.116587>, <-0.144538, 0.568635, 0.117387>, <-0.148557, 0.568635, 0.116587>, <-0.151964, 0.568635, 0.114311>, <-0.176531, 0.107891, 0.106885>, 
			<-0.174096, 0.107891, 0.119128>, <-0.167160, 0.107891, 0.129507>, <-0.156781, 0.107891, 0.136443>, <-0.144538, 0.107891, 0.138878>, <-0.132294, 0.107891, 0.136443>, <-0.121915, 0.107891, 0.129507>, <-0.114980, 0.107891, 0.119128>, <-0.112544, 0.107891, 0.106885>, <-0.114980, 0.107891, 0.094641>, <-0.121915, 0.107891, 0.084262>, <-0.132294, 0.107891, 0.077327>, 
			<-0.144538, 0.107891, 0.074891>, <-0.156781, 0.107891, 0.077327>, <-0.167160, 0.107891, 0.084262>, <-0.174096, 0.107891, 0.094641>, <-0.155628, 0.095395, 0.106885>, <-0.154784, 0.095395, 0.111129>, <-0.152380, 0.095395, 0.114727>, <-0.148782, 0.095395, 0.117131>, <-0.144538, 0.095395, 0.117975>, <-0.140294, 0.095395, 0.117131>, <-0.136696, 0.095395, 0.114727>, 
			<-0.134292, 0.095395, 0.111129>, <-0.133447, 0.095395, 0.106885>, <-0.134292, 0.095395, 0.102641>, <-0.136696, 0.095395, 0.099043>, <-0.140294, 0.095395, 0.096638>, <-0.144538, 0.095395, 0.095794>, <-0.148782, 0.095395, 0.096638>, <-0.152380, 0.095395, 0.099043>, <-0.154784, 0.095395, 0.102641>, <-0.195595, 0.427189, 0.085736>, <-0.183616, 0.427189, 0.067807>, 
			<-0.165687, 0.427189, 0.055827>, <-0.144538, 0.427189, 0.051620>, <-0.123389, 0.427189, 0.055827>, <-0.105460, 0.427189, 0.067807>, <-0.093480, 0.427189, 0.085736>, <-0.089273, 0.427189, 0.106885>, <-0.093480, 0.427189, 0.128033>, <-0.105460, 0.427189, 0.145962>, <-0.123389, 0.427189, 0.157942>, <-0.144538, 0.427189, 0.162149>, <-0.165687, 0.427189, 0.157942>, 
			<-0.183616, 0.427189, 0.145962>, <-0.195595, 0.427189, 0.128033>, <-0.199802, 0.427189, 0.106885>}
	 //#local average_center = <-0.144538, 0.345136, 0.106885>;
	 normal_vectors { 112, <0.953583, -0.299722, -0.029083>, <0.884644, -0.221130, -0.410495>, <0.678492, -0.267343, -0.684234>, <0.365000, -0.267343, -0.891797>, <-0.029083, -0.299722, -0.953583>, <-0.426911, -0.266802, -0.864039>, <-0.696536, -0.312532, -0.645881>, <-0.907627, -0.234436, -0.348213>, <-0.949232, -0.312532, 0.035818>, <-0.915802, -0.221130, 0.335274>, 
			<-0.725068, -0.266802, 0.634897>, <-0.368754, -0.267346, 0.890251>, <0.063761, -0.266802, 0.961640>, <0.426911, -0.266802, 0.864039>, <0.725068, -0.266802, 0.634897>, <0.915802, -0.221130, 0.335274>, <0.943619, 0.325069, 0.062566>, <0.871032, 0.364838, -0.328932>, <0.709460, 0.269494, -0.651183>, <0.418910, 0.325069, -0.847847>, <0.062566, 0.325069, -0.943619>, 
			<-0.361816, 0.325707, -0.873501>, <-0.709460, 0.269494, -0.651183>, <-0.840106, 0.416088, -0.347983>, <-0.958006, 0.285723, 0.024227>, <-0.840948, 0.380278, 0.384961>, <-0.709460, 0.269494, 0.651183>, <-0.388996, 0.285723, 0.875811>, <-0.000000, 0.416088, 0.909325>, <0.388996, 0.285723, 0.875811>, <0.668549, 0.325707, 0.668549>, <0.847847, 0.325069, 0.418910>, 
			<0.638643, -0.718104, -0.276517>, <0.563076, -0.826405, 0.000000>, <0.638643, -0.718104, 0.276517>, <0.476116, -0.703144, 0.528111>, <0.235280, -0.753049, 0.614459>, <-0.026241, -0.785839, 0.617874>, <-0.244535, -0.798555, 0.550011>, <-0.476116, -0.703144, 0.528111>, <-0.638643, -0.718104, 0.276517>, <-0.657724, -0.753049, -0.017773>, <-0.560799, -0.785839, -0.260694>, 
			<-0.476116, -0.703144, -0.528111>, <-0.212207, -0.785839, -0.580883>, <0.015441, -0.798555, -0.601723>, <0.235280, -0.753049, -0.614459>, <0.476116, -0.703144, -0.528111>, <0.210697, -0.974945, -0.071344>, <0.246383, -0.969173, -0.000000>, <0.175664, -0.982652, 0.059482>, <0.149533, -0.977384, 0.149533>, <0.059482, -0.982652, 0.175664>, <0.000000, -0.989001, 0.147910>, 
			<-0.059482, -0.982652, 0.175664>, <-0.149533, -0.977384, 0.149533>, <-0.210697, -0.974945, 0.071344>, <-0.276517, -0.960834, -0.018334>, <-0.136651, -0.989001, -0.056603>, <-0.149533, -0.977384, -0.149533>, <-0.056603, -0.989001, -0.136651>, <-0.012270, -0.982652, -0.185055>, <0.059482, -0.982652, -0.175664>, <0.149533, -0.977384, -0.149533>, <0.678576, 0.734461, -0.010088>, 
			<0.577887, 0.780224, -0.239369>, <0.515141, 0.685026, -0.515141>, <0.250360, 0.734461, -0.630783>, <-0.010088, 0.734461, -0.678576>, <-0.239369, 0.780224, -0.577887>, <-0.515141, 0.685026, -0.515141>, <-0.577887, 0.780224, -0.239369>, <-0.678576, 0.734461, -0.010088>, <-0.630783, 0.734461, 0.250360>, <-0.515141, 0.685026, 0.515141>, <-0.250360, 0.734461, 0.630783>, 
			<-0.000000, 0.780224, 0.625500>, <0.250360, 0.734461, 0.630783>, <0.515141, 0.685026, 0.515141>, <0.630783, 0.734461, 0.250360>, <0.394870, 0.918364, -0.026182>, <0.195803, 0.977284, -0.081104>, <0.214452, 0.952901, -0.214452>, <0.085316, 0.963970, -0.251960>, <-0.017599, 0.963970, -0.265430>, <-0.081104, 0.977284, -0.195803>, <-0.214452, 0.952901, -0.214452>, 
			<-0.245263, 0.964119, -0.101591>, <-0.394870, 0.918364, -0.026182>, <-0.251960, 0.963970, 0.085316>, <-0.214452, 0.952901, 0.214452>, <-0.085316, 0.963970, 0.251960>, <-0.000000, 0.977284, 0.211936>, <0.085316, 0.963970, 0.251960>, <0.214452, 0.952901, 0.214452>, <0.302040, 0.947793, 0.102274>, <0.923867, 0.004225, 0.382690>, <0.686697, 0.010110, 0.726873>, 
			<0.345648, -0.004018, 0.938356>, <-0.028409, 0.010110, 0.999545>, <-0.382680, 0.004225, 0.923871>, <-0.658770, 0.004215, 0.752332>, <-0.912588, 0.010110, 0.408756>, <-0.999955, -0.009517, 0.000000>, <-0.923730, 0.017966, -0.382622>, <-0.686739, -0.001664, -0.726902>, <-0.345648, -0.004018, -0.938356>, <0.000011, 0.004225, -0.999991>, <0.382690, 0.004225, -0.923867>, 
			<0.707108, 0.004225, -0.707093>, <0.923876, 0.004225, -0.382670>, <0.999991, 0.004225, 0.000011>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <56, 57, 58>, 0, <58, 55, 56>, 0, <58, 59, 55>, 0, <59, 54, 55>, 0, <59, 60, 54>, 0, <60, 53, 54>, 0, <60, 61, 53>, 0, <61, 52, 53>, 0, <61, 62, 52>, 0, <62, 51, 52>, 0, 
			<62, 63, 51>, 0, <63, 50, 51>, 0, <63, 48, 50>, 0, <48, 49, 50>, 0, <87, 88, 89>, 0, <89, 86, 87>, 0, <89, 90, 86>, 0, <90, 85, 86>, 0, <90, 91, 85>, 0, <91, 84, 85>, 0, <91, 92, 84>, 0, 
			<92, 83, 84>, 0, <92, 93, 83>, 0, <93, 82, 83>, 0, <93, 94, 82>, 0, <94, 81, 82>, 0, <94, 95, 81>, 0, <95, 80, 81>, 0, <111, 96, 15>, 0, <15, 0, 111>, 0, <96, 97, 14>, 0, <14, 15, 96>, 0, 
			<97, 98, 13>, 0, <13, 14, 97>, 0, <98, 99, 12>, 0, <12, 13, 98>, 0, <99, 100, 11>, 0, <11, 12, 99>, 0, <11, 100, 101>, 0, <101, 10, 11>, 0, <10, 101, 102>, 0, <102, 9, 10>, 0, <9, 102, 103>, 0, 
			<103, 8, 9>, 0, <103, 104, 7>, 0, <7, 8, 103>, 0, <7, 104, 105>, 0, <105, 6, 7>, 0, <105, 106, 5>, 0, <5, 6, 105>, 0, <106, 107, 4>, 0, <4, 5, 106>, 0, <107, 108, 3>, 0, <3, 4, 107>, 0, 
			<108, 109, 2>, 0, <2, 3, 108>, 0, <109, 110, 1>, 0, <1, 2, 109>, 0, <110, 111, 0>, 0, <0, 1, 110>, 0, <0, 33, 32>, 0, <0, 32, 1>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <14, 35, 34>, 0, 
			<14, 34, 15>, 0, <13, 36, 35>, 0, <13, 35, 14>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <11, 38, 37>, 0, <37, 12, 11>, 0, <10, 39, 11>, 0, <39, 38, 11>, 0, <9, 40, 10>, 0, <40, 39, 10>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 41>, 0, <41, 8, 7>, 0, <6, 43, 42>, 0, <6, 42, 7>, 0, <5, 44, 43>, 0, <5, 43, 6>, 0, <4, 45, 44>, 0, <4, 44, 5>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <2, 47, 3>, 0, <47, 46, 3>, 0, <1, 32, 2>, 0, <32, 47, 2>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, 
			<36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <38, 54, 37>, 0, <54, 53, 37>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, <61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, 
			<63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 17>, 0, <66, 65, 17>, 0, <19, 67, 66>, 0, <66, 18, 19>, 0, <20, 68, 67>, 0, 
			<67, 19, 20>, 0, <21, 69, 68>, 0, <68, 20, 21>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 70>, 0, <23, 70, 22>, 0, <72, 71, 23>, 0, <23, 24, 72>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<74, 73, 25>, 0, <25, 26, 74>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <28, 76, 75>, 0, <28, 75, 27>, 0, <77, 76, 28>, 0, <28, 29, 77>, 0, <78, 77, 29>, 0, <29, 30, 78>, 0, <31, 79, 78>, 0, 
			<78, 30, 31>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <31, 96, 16>, 0, <96, 111, 16>, 0, <30, 97, 31>, 0, <97, 96, 31>, 0, <29, 98, 97>, 0, <29, 97, 30>, 0, <28, 99, 29>, 0, <99, 98, 29>, 0, <27, 100, 99>, 0, 
			<27, 99, 28>, 0, <26, 101, 27>, 0, <101, 100, 27>, 0, <25, 102, 26>, 0, <102, 101, 26>, 0, <24, 103, 102>, 0, <24, 102, 25>, 0, <23, 104, 24>, 0, <104, 103, 24>, 0, <22, 105, 104>, 0, <22, 104, 23>, 0, 
			<21, 106, 105>, 0, <21, 105, 22>, 0, <20, 107, 21>, 0, <107, 106, 21>, 0, <19, 108, 20>, 0, <108, 107, 20>, 0, <18, 109, 19>, 0, <109, 108, 19>, 0, <17, 110, 18>, 0, <110, 109, 18>, 0, <16, 111, 17>, 0, 
			<111, 110, 17>, 0}
	 normal_indices { 220, <56, 57, 58>, <58, 55, 56>, <58, 59, 55>, <59, 54, 55>, <59, 60, 54>, <60, 53, 54>, <60, 61, 53>, <61, 52, 53>, <61, 62, 52>, <62, 51, 52>, 
			<62, 63, 51>, <63, 50, 51>, <63, 48, 50>, <48, 49, 50>, <87, 88, 89>, <89, 86, 87>, <89, 90, 86>, <90, 85, 86>, <90, 91, 85>, <91, 84, 85>, <91, 92, 84>, 
			<92, 83, 84>, <92, 93, 83>, <93, 82, 83>, <93, 94, 82>, <94, 81, 82>, <94, 95, 81>, <95, 80, 81>, <111, 96, 15>, <15, 0, 111>, <96, 97, 14>, <14, 15, 96>, 
			<97, 98, 13>, <13, 14, 97>, <98, 99, 12>, <12, 13, 98>, <99, 100, 11>, <11, 12, 99>, <11, 100, 101>, <101, 10, 11>, <10, 101, 102>, <102, 9, 10>, <9, 102, 103>, 
			<103, 8, 9>, <103, 104, 7>, <7, 8, 103>, <7, 104, 105>, <105, 6, 7>, <105, 106, 5>, <5, 6, 105>, <106, 107, 4>, <4, 5, 106>, <107, 108, 3>, <3, 4, 107>, 
			<108, 109, 2>, <2, 3, 108>, <109, 110, 1>, <1, 2, 109>, <110, 111, 0>, <0, 1, 110>, <0, 33, 32>, <0, 32, 1>, <34, 33, 0>, <0, 15, 34>, <14, 35, 34>, 
			<14, 34, 15>, <13, 36, 35>, <13, 35, 14>, <12, 37, 36>, <36, 13, 12>, <11, 38, 37>, <37, 12, 11>, <10, 39, 11>, <39, 38, 11>, <9, 40, 10>, <40, 39, 10>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 41>, <41, 8, 7>, <6, 43, 42>, <6, 42, 7>, <5, 44, 43>, <5, 43, 6>, <4, 45, 44>, <4, 44, 5>, <46, 45, 4>, 
			<4, 3, 46>, <2, 47, 3>, <47, 46, 3>, <1, 32, 2>, <32, 47, 2>, <33, 49, 48>, <33, 48, 32>, <50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, 
			<36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <38, 54, 37>, <54, 53, 37>, <39, 55, 38>, <55, 54, 38>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 57>, <57, 41, 42>, <43, 59, 42>, <59, 58, 42>, <44, 60, 59>, <44, 59, 43>, <61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, 
			<63, 62, 46>, <46, 47, 63>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 17>, <66, 65, 17>, <19, 67, 66>, <66, 18, 19>, <20, 68, 67>, 
			<67, 19, 20>, <21, 69, 68>, <68, 20, 21>, <22, 70, 21>, <70, 69, 21>, <23, 71, 70>, <23, 70, 22>, <72, 71, 23>, <23, 24, 72>, <73, 72, 24>, <24, 25, 73>, 
			<74, 73, 25>, <25, 26, 74>, <27, 75, 74>, <27, 74, 26>, <28, 76, 75>, <28, 75, 27>, <77, 76, 28>, <28, 29, 77>, <78, 77, 29>, <29, 30, 78>, <31, 79, 78>, 
			<78, 30, 31>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, <94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>, <31, 96, 16>, <96, 111, 16>, <30, 97, 31>, <97, 96, 31>, <29, 98, 97>, <29, 97, 30>, <28, 99, 29>, <99, 98, 29>, <27, 100, 99>, 
			<27, 99, 28>, <26, 101, 27>, <101, 100, 27>, <25, 102, 26>, <102, 101, 26>, <24, 103, 102>, <24, 102, 25>, <23, 104, 24>, <104, 103, 24>, <22, 105, 104>, <22, 104, 23>, 
			<21, 106, 105>, <21, 105, 22>, <20, 107, 21>, <107, 106, 21>, <19, 108, 20>, <108, 107, 20>, <18, 109, 19>, <109, 108, 19>, <17, 110, 18>, <110, 109, 18>, <16, 111, 17>, 
			<111, 110, 17>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_17_RightShin = mesh2{
	 vertex_vectors { 112, <0.015686, 0.512444, 0.000000>, <0.019577, 0.512444, 0.019562>, <0.030658, 0.512444, 0.036145>, <0.047241, 0.512444, 0.047226>, <0.066803, 0.512444, 0.051117>, <0.086364, 0.512444, 0.047226>, <0.102948, 0.512444, 0.036145>, <0.114028, 0.512444, 0.019562>, <0.117919, 0.512444, 0.000000>, <0.114028, 0.512444, -0.019562>, 
			<0.102948, 0.512444, -0.036145>, <0.086364, 0.512444, -0.047226>, <0.066803, 0.512444, -0.051117>, <0.047241, 0.512444, -0.047226>, <0.030658, 0.512444, -0.036145>, <0.019577, 0.512444, -0.019562>, <0.025453, 0.094251, -0.000000>, <0.028601, 0.094251, 0.015824>, <0.037564, 0.094251, 0.029238>, <0.050979, 0.094251, 0.038202>, <0.066803, 0.094251, 0.041349>, 
			<0.082626, 0.094251, 0.038202>, <0.096041, 0.094251, 0.029238>, <0.105004, 0.094251, 0.015824>, <0.108152, 0.094251, 0.000000>, <0.105004, 0.094251, -0.015824>, <0.096041, 0.094251, -0.029238>, <0.082626, 0.094251, -0.038202>, <0.066803, 0.094251, -0.041349>, <0.050979, 0.094251, -0.038202>, <0.037564, 0.094251, -0.029238>, <0.028601, 0.094251, -0.015824>, 
			<0.028300, 0.529595, 0.015948>, <0.025128, 0.529595, 0.000000>, <0.028300, 0.529595, -0.015948>, <0.037334, 0.529595, -0.029468>, <0.050854, 0.529595, -0.038502>, <0.066803, 0.529595, -0.041675>, <0.082751, 0.529595, -0.038502>, <0.096271, 0.529595, -0.029468>, <0.105305, 0.529595, -0.015948>, <0.108477, 0.529595, 0.000000>, <0.105305, 0.529595, 0.015948>, 
			<0.096271, 0.529595, 0.029468>, <0.082751, 0.529595, 0.038502>, <0.066803, 0.529595, 0.041675>, <0.050854, 0.529595, 0.038502>, <0.037334, 0.529595, 0.029468>, <0.057100, 0.541785, 0.004019>, <0.056301, 0.541785, 0.000000>, <0.057100, 0.541785, -0.004019>, <0.059376, 0.541785, -0.007426>, <0.062784, 0.541785, -0.009703>, <0.066803, 0.541785, -0.010502>, 
			<0.070822, 0.541785, -0.009703>, <0.074229, 0.541785, -0.007426>, <0.076505, 0.541785, -0.004019>, <0.077305, 0.541785, 0.000000>, <0.076505, 0.541785, 0.004019>, <0.074229, 0.541785, 0.007426>, <0.070822, 0.541785, 0.009703>, <0.066803, 0.541785, 0.010502>, <0.062784, 0.541785, 0.009703>, <0.059376, 0.541785, 0.007426>, <0.034809, 0.081041, 0.000000>, 
			<0.037245, 0.081041, 0.012243>, <0.044180, 0.081041, 0.022623>, <0.054559, 0.081041, 0.029558>, <0.066803, 0.081041, 0.031993>, <0.079046, 0.081041, 0.029558>, <0.089425, 0.081041, 0.022623>, <0.096361, 0.081041, 0.012243>, <0.098796, 0.081041, 0.000000>, <0.096361, 0.081041, -0.012243>, <0.089425, 0.081041, -0.022623>, <0.079046, 0.081041, -0.029558>, 
			<0.066803, 0.081041, -0.031993>, <0.054559, 0.081041, -0.029558>, <0.044180, 0.081041, -0.022623>, <0.037245, 0.081041, -0.012243>, <0.055712, 0.068545, 0.000000>, <0.056556, 0.068545, 0.004244>, <0.058961, 0.068545, 0.007842>, <0.062558, 0.068545, 0.010246>, <0.066803, 0.068545, 0.011090>, <0.071047, 0.068545, 0.010246>, <0.074645, 0.068545, 0.007842>, 
			<0.077049, 0.068545, 0.004244>, <0.077893, 0.068545, 0.000000>, <0.077049, 0.068545, -0.004244>, <0.074645, 0.068545, -0.007842>, <0.071047, 0.068545, -0.010246>, <0.066803, 0.068545, -0.011090>, <0.062558, 0.068545, -0.010246>, <0.058961, 0.068545, -0.007842>, <0.056556, 0.068545, -0.004244>, <0.015745, 0.400338, -0.021149>, <0.027725, 0.400338, -0.039078>, 
			<0.045654, 0.400338, -0.051058>, <0.066803, 0.400338, -0.055264>, <0.087951, 0.400338, -0.051058>, <0.105880, 0.400338, -0.039078>, <0.117860, 0.400338, -0.021149>, <0.122067, 0.400338, 0.000000>, <0.117860, 0.400338, 0.021149>, <0.105880, 0.400338, 0.039078>, <0.087951, 0.400338, 0.051058>, <0.066803, 0.400338, 0.055264>, <0.045654, 0.400338, 0.051058>, 
			<0.027725, 0.400338, 0.039078>, <0.015745, 0.400338, 0.021149>, <0.011538, 0.400338, -0.000000>}
	 //#local average_center = <0.066803, 0.318286, 0.000000>;
	 normal_vectors { 112, <0.963593, -0.267343, -0.004060>, <0.888690, -0.267343, -0.372502>, <0.678492, -0.267343, -0.684234>, <0.365000, -0.267343, -0.891797>, <-0.004060, -0.267343, -0.963593>, <-0.372502, -0.267343, -0.888690>, <-0.684234, -0.267343, -0.678492>, <-0.892126, -0.299722, -0.338051>, <-0.961640, -0.266802, 0.063761>, <-0.864039, -0.266802, 0.426911>, 
			<-0.660215, -0.221130, 0.717787>, <-0.338051, -0.299722, 0.892126>, <0.063761, -0.266802, 0.961640>, <0.426911, -0.266802, 0.864039>, <0.717787, -0.221130, 0.660215>, <0.891797, -0.267343, 0.365000>, <0.943619, 0.325069, 0.062566>, <0.871032, 0.364838, -0.328932>, <0.709460, 0.269494, -0.651183>, <0.418910, 0.325069, -0.847847>, <0.024227, 0.285723, -0.958006>, 
			<-0.347983, 0.416088, -0.840106>, <-0.687810, 0.232023, -0.687810>, <-0.840106, 0.416088, -0.347983>, <-0.945453, 0.325701, -0.006120>, <-0.875827, 0.325701, 0.356155>, <-0.709460, 0.269494, 0.651183>, <-0.383323, 0.364838, 0.848503>, <-0.006120, 0.325701, 0.945453>, <0.356155, 0.325701, 0.875827>, <0.687810, 0.232023, 0.687810>, <0.840948, 0.380278, 0.384961>, 
			<0.590501, -0.752453, -0.291759>, <0.617874, -0.785839, -0.026241>, <0.614459, -0.753049, 0.235280>, <0.525745, -0.668718, 0.525745>, <0.235280, -0.753049, 0.614459>, <-0.026241, -0.785839, 0.617874>, <-0.244535, -0.798555, 0.550011>, <-0.525745, -0.668718, 0.525745>, <-0.614459, -0.753049, 0.235280>, <-0.617874, -0.785839, -0.026241>, <-0.550011, -0.798555, -0.244535>, 
			<-0.528111, -0.703144, -0.476116>, <-0.291759, -0.752453, -0.590501>, <-0.026241, -0.785839, -0.617874>, <0.235280, -0.753049, -0.614459>, <0.476116, -0.703144, -0.528111>, <0.210697, -0.974945, -0.071344>, <0.246383, -0.969173, -0.000000>, <0.175664, -0.982652, 0.059482>, <0.149533, -0.977384, 0.149533>, <0.059482, -0.982652, 0.175664>, <0.000000, -0.989001, 0.147910>, 
			<-0.059482, -0.982652, 0.175664>, <-0.149533, -0.977384, 0.149533>, <-0.210697, -0.974945, 0.071344>, <-0.246383, -0.969173, 0.000000>, <-0.175664, -0.982652, -0.059482>, <-0.149533, -0.977384, -0.149533>, <-0.059482, -0.982652, -0.175664>, <0.000000, -0.989001, -0.147910>, <0.059482, -0.982652, -0.175664>, <0.149533, -0.977384, -0.149533>, <0.678576, 0.734461, -0.010088>, 
			<0.577887, 0.780224, -0.239369>, <0.515141, 0.685026, -0.515141>, <0.250360, 0.734461, -0.630783>, <-0.010088, 0.734461, -0.678576>, <-0.239369, 0.780224, -0.577887>, <-0.515141, 0.685026, -0.515141>, <-0.577887, 0.780224, -0.239369>, <-0.678576, 0.734461, -0.010088>, <-0.630783, 0.734461, 0.250360>, <-0.515141, 0.685026, 0.515141>, <-0.239369, 0.780224, 0.577887>, 
			<-0.010088, 0.734461, 0.678576>, <0.250360, 0.734461, 0.630783>, <0.515141, 0.685026, 0.515141>, <0.630783, 0.734461, 0.250360>, <0.394870, 0.918364, -0.026182>, <0.195803, 0.977284, -0.081104>, <0.214452, 0.952901, -0.214452>, <0.085316, 0.963970, -0.251960>, <-0.017599, 0.963970, -0.265430>, <-0.081104, 0.977284, -0.195803>, <-0.214452, 0.952901, -0.214452>, 
			<-0.245263, 0.964119, -0.101591>, <-0.394870, 0.918364, -0.026182>, <-0.251960, 0.963970, 0.085316>, <-0.214452, 0.952901, 0.214452>, <-0.081104, 0.977284, 0.195803>, <-0.017599, 0.963970, 0.265430>, <0.085316, 0.963970, 0.251960>, <0.214452, 0.952901, 0.214452>, <0.302040, 0.947793, 0.102274>, <0.912588, 0.010110, 0.408756>, <0.678430, -0.004018, 0.734654>, 
			<0.382670, 0.004225, 0.923876>, <-0.000011, 0.004225, 0.999991>, <-0.382690, 0.004225, 0.923867>, <-0.707108, 0.004225, 0.707093>, <-0.923876, 0.004225, 0.382670>, <-0.999991, 0.004225, -0.000011>, <-0.912588, 0.010110, -0.408756>, <-0.678430, -0.004018, -0.734654>, <-0.356263, 0.010110, -0.934331>, <0.039756, -0.004018, -0.999201>, <0.382690, 0.004225, -0.923867>, 
			<0.707108, 0.004225, -0.707093>, <0.923876, 0.004225, -0.382670>, <0.999991, 0.004225, 0.000011>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 220, <56, 57, 58>, 0, <58, 55, 56>, 0, <58, 59, 55>, 0, <59, 54, 55>, 0, <59, 60, 54>, 0, <60, 53, 54>, 0, <60, 61, 53>, 0, <61, 52, 53>, 0, <61, 62, 52>, 0, <62, 51, 52>, 0, 
			<62, 63, 51>, 0, <63, 50, 51>, 0, <63, 48, 50>, 0, <48, 49, 50>, 0, <87, 88, 89>, 0, <89, 86, 87>, 0, <89, 90, 86>, 0, <90, 85, 86>, 0, <90, 91, 85>, 0, <91, 84, 85>, 0, <91, 92, 84>, 0, 
			<92, 83, 84>, 0, <92, 93, 83>, 0, <93, 82, 83>, 0, <93, 94, 82>, 0, <94, 81, 82>, 0, <94, 95, 81>, 0, <95, 80, 81>, 0, <111, 96, 15>, 0, <15, 0, 111>, 0, <96, 97, 14>, 0, <14, 15, 96>, 0, 
			<97, 98, 13>, 0, <13, 14, 97>, 0, <98, 99, 12>, 0, <12, 13, 98>, 0, <99, 100, 11>, 0, <11, 12, 99>, 0, <100, 101, 10>, 0, <10, 11, 100>, 0, <101, 102, 9>, 0, <9, 10, 101>, 0, <102, 103, 8>, 0, 
			<8, 9, 102>, 0, <103, 104, 7>, 0, <7, 8, 103>, 0, <104, 105, 6>, 0, <6, 7, 104>, 0, <105, 106, 5>, 0, <5, 6, 105>, 0, <106, 107, 4>, 0, <4, 5, 106>, 0, <107, 108, 3>, 0, <3, 4, 107>, 0, 
			<108, 109, 2>, 0, <2, 3, 108>, 0, <109, 110, 1>, 0, <1, 2, 109>, 0, <110, 111, 0>, 0, <0, 1, 110>, 0, <33, 32, 1>, 0, <1, 0, 33>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <14, 35, 15>, 0, 
			<35, 34, 15>, 0, <13, 36, 35>, 0, <13, 35, 14>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <11, 38, 37>, 0, <37, 12, 11>, 0, <10, 39, 11>, 0, <39, 38, 11>, 0, <9, 40, 39>, 0, <9, 39, 10>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 41>, 0, <41, 8, 7>, 0, <6, 43, 7>, 0, <43, 42, 7>, 0, <5, 44, 6>, 0, <44, 43, 6>, 0, <45, 44, 5>, 0, <5, 4, 45>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <2, 47, 3>, 0, <47, 46, 3>, 0, <1, 32, 2>, 0, <32, 47, 2>, 0, <33, 49, 48>, 0, <33, 48, 32>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, 
			<36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <38, 54, 37>, 0, <54, 53, 37>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 41>, 0, <58, 57, 41>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, <45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, 
			<63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 17>, 0, <66, 65, 17>, 0, <19, 67, 66>, 0, <66, 18, 19>, 0, <20, 68, 67>, 0, 
			<67, 19, 20>, 0, <21, 69, 68>, 0, <68, 20, 21>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 70>, 0, <23, 70, 22>, 0, <72, 71, 23>, 0, <23, 24, 72>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<74, 73, 25>, 0, <25, 26, 74>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <76, 75, 27>, 0, <27, 28, 76>, 0, <77, 76, 28>, 0, <28, 29, 77>, 0, <78, 77, 29>, 0, <29, 30, 78>, 0, <31, 79, 78>, 0, 
			<78, 30, 31>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <92, 91, 75>, 0, <75, 76, 92>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0, <31, 96, 16>, 0, <96, 111, 16>, 0, <30, 97, 96>, 0, <30, 96, 31>, 0, <29, 98, 30>, 0, <98, 97, 30>, 0, <28, 99, 29>, 0, <99, 98, 29>, 0, <27, 100, 28>, 0, 
			<100, 99, 28>, 0, <26, 101, 27>, 0, <101, 100, 27>, 0, <25, 102, 26>, 0, <102, 101, 26>, 0, <24, 103, 25>, 0, <103, 102, 25>, 0, <23, 104, 24>, 0, <104, 103, 24>, 0, <22, 105, 104>, 0, <22, 104, 23>, 0, 
			<21, 106, 22>, 0, <106, 105, 22>, 0, <20, 107, 106>, 0, <20, 106, 21>, 0, <19, 108, 20>, 0, <108, 107, 20>, 0, <18, 109, 19>, 0, <109, 108, 19>, 0, <17, 110, 18>, 0, <110, 109, 18>, 0, <16, 111, 17>, 0, 
			<111, 110, 17>, 0}
	 normal_indices { 220, <56, 57, 58>, <58, 55, 56>, <58, 59, 55>, <59, 54, 55>, <59, 60, 54>, <60, 53, 54>, <60, 61, 53>, <61, 52, 53>, <61, 62, 52>, <62, 51, 52>, 
			<62, 63, 51>, <63, 50, 51>, <63, 48, 50>, <48, 49, 50>, <87, 88, 89>, <89, 86, 87>, <89, 90, 86>, <90, 85, 86>, <90, 91, 85>, <91, 84, 85>, <91, 92, 84>, 
			<92, 83, 84>, <92, 93, 83>, <93, 82, 83>, <93, 94, 82>, <94, 81, 82>, <94, 95, 81>, <95, 80, 81>, <111, 96, 15>, <15, 0, 111>, <96, 97, 14>, <14, 15, 96>, 
			<97, 98, 13>, <13, 14, 97>, <98, 99, 12>, <12, 13, 98>, <99, 100, 11>, <11, 12, 99>, <100, 101, 10>, <10, 11, 100>, <101, 102, 9>, <9, 10, 101>, <102, 103, 8>, 
			<8, 9, 102>, <103, 104, 7>, <7, 8, 103>, <104, 105, 6>, <6, 7, 104>, <105, 106, 5>, <5, 6, 105>, <106, 107, 4>, <4, 5, 106>, <107, 108, 3>, <3, 4, 107>, 
			<108, 109, 2>, <2, 3, 108>, <109, 110, 1>, <1, 2, 109>, <110, 111, 0>, <0, 1, 110>, <33, 32, 1>, <1, 0, 33>, <34, 33, 0>, <0, 15, 34>, <14, 35, 15>, 
			<35, 34, 15>, <13, 36, 35>, <13, 35, 14>, <12, 37, 36>, <36, 13, 12>, <11, 38, 37>, <37, 12, 11>, <10, 39, 11>, <39, 38, 11>, <9, 40, 39>, <9, 39, 10>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 41>, <41, 8, 7>, <6, 43, 7>, <43, 42, 7>, <5, 44, 6>, <44, 43, 6>, <45, 44, 5>, <5, 4, 45>, <46, 45, 4>, 
			<4, 3, 46>, <2, 47, 3>, <47, 46, 3>, <1, 32, 2>, <32, 47, 2>, <33, 49, 48>, <33, 48, 32>, <50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, 
			<36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <38, 54, 37>, <54, 53, 37>, <39, 55, 38>, <55, 54, 38>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 41>, <58, 57, 41>, <43, 59, 42>, <59, 58, 42>, <44, 60, 59>, <44, 59, 43>, <45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, 
			<63, 62, 46>, <46, 47, 63>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 17>, <66, 65, 17>, <19, 67, 66>, <66, 18, 19>, <20, 68, 67>, 
			<67, 19, 20>, <21, 69, 68>, <68, 20, 21>, <22, 70, 21>, <70, 69, 21>, <23, 71, 70>, <23, 70, 22>, <72, 71, 23>, <23, 24, 72>, <73, 72, 24>, <24, 25, 73>, 
			<74, 73, 25>, <25, 26, 74>, <27, 75, 74>, <27, 74, 26>, <76, 75, 27>, <27, 28, 76>, <77, 76, 28>, <28, 29, 77>, <78, 77, 29>, <29, 30, 78>, <31, 79, 78>, 
			<78, 30, 31>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <92, 91, 75>, <75, 76, 92>, <93, 92, 76>, <76, 77, 93>, <94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>, <31, 96, 16>, <96, 111, 16>, <30, 97, 96>, <30, 96, 31>, <29, 98, 30>, <98, 97, 30>, <28, 99, 29>, <99, 98, 29>, <27, 100, 28>, 
			<100, 99, 28>, <26, 101, 27>, <101, 100, 27>, <25, 102, 26>, <102, 101, 26>, <24, 103, 25>, <103, 102, 25>, <23, 104, 24>, <104, 103, 24>, <22, 105, 104>, <22, 104, 23>, 
			<21, 106, 22>, <106, 105, 22>, <20, 107, 106>, <20, 106, 21>, <19, 108, 20>, <108, 107, 20>, <18, 109, 19>, <109, 108, 19>, <17, 110, 18>, <110, 109, 18>, <16, 111, 17>, 
			<111, 110, 17>}
	 uv_indices { 220, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>}
}
#declare wo_18_LeftKnee = mesh2{
	 vertex_vectors { 114, <-0.161502, 0.630936, 0.106885>, <-0.159985, 0.630936, 0.114512>, <-0.155665, 0.630936, 0.120977>, <-0.149199, 0.630936, 0.125298>, <-0.141572, 0.630936, 0.126815>, <-0.133945, 0.630936, 0.125298>, <-0.127479, 0.630936, 0.120977>, <-0.123159, 0.630936, 0.114512>, <-0.121642, 0.630936, 0.106885>, <-0.123159, 0.630936, 0.099258>, 
			<-0.127479, 0.630936, 0.092792>, <-0.133945, 0.630936, 0.088472>, <-0.141572, 0.630936, 0.086954>, <-0.149199, 0.630936, 0.088472>, <-0.155665, 0.630936, 0.092792>, <-0.159985, 0.630936, 0.099258>, <-0.178398, 0.619646, 0.106885>, <-0.175595, 0.619646, 0.120977>, <-0.167612, 0.619646, 0.132925>, <-0.155665, 0.619646, 0.140908>, <-0.141572, 0.619646, 0.143711>, 
			<-0.127479, 0.619646, 0.140908>, <-0.115532, 0.619646, 0.132925>, <-0.107549, 0.619646, 0.120977>, <-0.104746, 0.619646, 0.106885>, <-0.107549, 0.619646, 0.092792>, <-0.115532, 0.619646, 0.080845>, <-0.127479, 0.619646, 0.072862>, <-0.141572, 0.619646, 0.070059>, <-0.155665, 0.619646, 0.072862>, <-0.167612, 0.619646, 0.080845>, <-0.175595, 0.619646, 0.092792>, 
			<-0.189688, 0.602750, 0.106885>, <-0.186025, 0.602750, 0.125298>, <-0.175595, 0.602750, 0.140908>, <-0.159985, 0.602750, 0.151338>, <-0.141572, 0.602750, 0.155000>, <-0.123159, 0.602750, 0.151338>, <-0.107549, 0.602750, 0.140908>, <-0.097119, 0.602750, 0.125298>, <-0.093456, 0.602750, 0.106885>, <-0.097119, 0.602750, 0.088472>, <-0.107549, 0.602750, 0.072862>, 
			<-0.123159, 0.602750, 0.062432>, <-0.141572, 0.602750, 0.058769>, <-0.159985, 0.602750, 0.062432>, <-0.175595, 0.602750, 0.072862>, <-0.186025, 0.602750, 0.088472>, <-0.193652, 0.582820, 0.106885>, <-0.189688, 0.582820, 0.126815>, <-0.178398, 0.582820, 0.143711>, <-0.161502, 0.582820, 0.155000>, <-0.141572, 0.582820, 0.158965>, <-0.121642, 0.582820, 0.155000>, 
			<-0.104746, 0.582820, 0.143711>, <-0.093456, 0.582820, 0.126815>, <-0.089492, 0.582820, 0.106885>, <-0.093456, 0.582820, 0.086954>, <-0.104746, 0.582820, 0.070059>, <-0.121642, 0.582820, 0.058769>, <-0.141572, 0.582820, 0.054805>, <-0.161502, 0.582820, 0.058769>, <-0.178398, 0.582820, 0.070059>, <-0.189688, 0.582820, 0.086954>, <-0.189688, 0.562890, 0.106885>, 
			<-0.186025, 0.562890, 0.125298>, <-0.175595, 0.562890, 0.140908>, <-0.159985, 0.562890, 0.151338>, <-0.141572, 0.562890, 0.155000>, <-0.123159, 0.562890, 0.151338>, <-0.107549, 0.562890, 0.140908>, <-0.097119, 0.562890, 0.125298>, <-0.093456, 0.562890, 0.106885>, <-0.097119, 0.562890, 0.088472>, <-0.107549, 0.562890, 0.072862>, <-0.123159, 0.562890, 0.062432>, 
			<-0.141572, 0.562890, 0.058769>, <-0.159985, 0.562890, 0.062432>, <-0.175595, 0.562890, 0.072862>, <-0.186025, 0.562890, 0.088472>, <-0.178398, 0.545994, 0.106885>, <-0.175595, 0.545994, 0.120977>, <-0.167612, 0.545994, 0.132925>, <-0.155665, 0.545994, 0.140908>, <-0.141572, 0.545994, 0.143711>, <-0.127479, 0.545994, 0.140908>, <-0.115532, 0.545994, 0.132925>, 
			<-0.107549, 0.545994, 0.120977>, <-0.104746, 0.545994, 0.106885>, <-0.107549, 0.545994, 0.092792>, <-0.115532, 0.545994, 0.080845>, <-0.127479, 0.545994, 0.072862>, <-0.141572, 0.545994, 0.070059>, <-0.155665, 0.545994, 0.072862>, <-0.167612, 0.545994, 0.080845>, <-0.175595, 0.545994, 0.092792>, <-0.161502, 0.534704, 0.106885>, <-0.159985, 0.534704, 0.114512>, 
			<-0.155665, 0.534704, 0.120977>, <-0.149199, 0.534704, 0.125298>, <-0.141572, 0.534704, 0.126815>, <-0.133945, 0.534704, 0.125298>, <-0.127479, 0.534704, 0.120977>, <-0.123159, 0.534704, 0.114512>, <-0.121642, 0.534704, 0.106885>, <-0.123159, 0.534704, 0.099258>, <-0.127479, 0.534704, 0.092792>, <-0.133945, 0.534704, 0.088472>, <-0.141572, 0.534704, 0.086954>, 
			<-0.149199, 0.534704, 0.088472>, <-0.155665, 0.534704, 0.092792>, <-0.159985, 0.534704, 0.099258>, <-0.141572, 0.634900, 0.106885>, <-0.141572, 0.530740, 0.106885>}
	 //#local average_center = <-0.141572, 0.582820, 0.106885>;
	 normal_vectors { 114, <0.382195, -0.924082, -0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, -0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.608176, -0.752769, -0.251915>, <-0.706555, -0.707599, -0.009151>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.280222, -0.734948, 0.617517>, <-0.023971, -0.727193, 0.686014>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.690908, -0.345848, -0.634851>, <-0.828106, -0.443376, -0.343013>, <-0.923671, -0.383155, -0.004888>, <-0.853594, -0.356654, 0.379704>, <-0.634851, -0.345848, 0.690908>, 
			<-0.322878, -0.409068, 0.853471>, <0.033749, -0.419315, 0.907213>, <0.379704, -0.356654, 0.853594>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.734076, -0.039720, -0.677904>, <0.442968, 0.000000, -0.896538>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.707107, 0.000000, -0.707107>, <-0.921855, -0.066159, -0.381845>, <-0.999194, 0.028393, 0.028393>, <-0.907221, 0.039720, 0.418775>, <-0.707107, 0.000000, 0.707107>, <-0.418775, -0.039720, 0.907221>, <-0.000000, 0.000000, 1.000000>, <0.418775, 0.039720, 0.907221>, <0.707107, 0.000000, 0.707107>, <0.907221, -0.039720, 0.418775>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.669649, 0.321155, -0.669649>, <0.348957, 0.383155, -0.855231>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853371, 0.383160, -0.353478>, <-0.907213, 0.419315, 0.033749>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.379704, 0.356654, 0.853594>, 
			<-0.000000, 0.443376, 0.896335>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.617517, 0.734948, -0.280222>, <-0.686014, 0.727193, -0.023971>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <-0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, -0.000000>, <0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <28, 44, 43>, 0, 
			<28, 43, 27>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 32>, 0, <49, 48, 32>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <36, 52, 35>, 0, <52, 51, 35>, 0, <37, 53, 36>, 0, <53, 52, 36>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <40, 56, 55>, 0, <40, 55, 39>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <51, 67, 66>, 0, <66, 50, 51>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <88, 87, 71>, 0, 
			<71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <28, 44, 43>, 
			<28, 43, 27>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 32>, <49, 48, 32>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <36, 52, 35>, <52, 51, 35>, <37, 53, 36>, <53, 52, 36>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <40, 56, 55>, <40, 55, 39>, <41, 57, 56>, <41, 56, 40>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <60, 59, 43>, <43, 44, 60>, 
			<45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <51, 67, 66>, <66, 50, 51>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <88, 87, 71>, 
			<71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_19_RightKnee = mesh2{
	 vertex_vectors { 114, <0.047731, 0.604086, -0.000000>, <0.049248, 0.604086, 0.007627>, <0.053569, 0.604086, 0.014093>, <0.060034, 0.604086, 0.018413>, <0.067661, 0.604086, 0.019930>, <0.075288, 0.604086, 0.018413>, <0.081754, 0.604086, 0.014093>, <0.086074, 0.604086, 0.007627>, <0.087592, 0.604086, 0.000000>, <0.086074, 0.604086, -0.007627>, 
			<0.081754, 0.604086, -0.014093>, <0.075288, 0.604086, -0.018413>, <0.067661, 0.604086, -0.019930>, <0.060034, 0.604086, -0.018413>, <0.053569, 0.604086, -0.014093>, <0.049248, 0.604086, -0.007627>, <0.030835, 0.592796, -0.000000>, <0.033639, 0.592796, 0.014093>, <0.041621, 0.592796, 0.026040>, <0.053569, 0.592796, 0.034023>, <0.067661, 0.592796, 0.036826>, 
			<0.081754, 0.592796, 0.034023>, <0.093701, 0.592796, 0.026040>, <0.101684, 0.592796, 0.014093>, <0.104488, 0.592796, 0.000000>, <0.101684, 0.592796, -0.014093>, <0.093701, 0.592796, -0.026040>, <0.081754, 0.592796, -0.034023>, <0.067661, 0.592796, -0.036826>, <0.053569, 0.592796, -0.034023>, <0.041621, 0.592796, -0.026040>, <0.033639, 0.592796, -0.014093>, 
			<0.019546, 0.575900, -0.000000>, <0.023208, 0.575900, 0.018413>, <0.033639, 0.575900, 0.034023>, <0.049248, 0.575900, 0.044453>, <0.067661, 0.575900, 0.048116>, <0.086074, 0.575900, 0.044453>, <0.101684, 0.575900, 0.034023>, <0.112114, 0.575900, 0.018413>, <0.115777, 0.575900, 0.000000>, <0.112114, 0.575900, -0.018413>, <0.101684, 0.575900, -0.034023>, 
			<0.086074, 0.575900, -0.044453>, <0.067661, 0.575900, -0.048116>, <0.049248, 0.575900, -0.044453>, <0.033639, 0.575900, -0.034023>, <0.023208, 0.575900, -0.018413>, <0.015581, 0.555970, -0.000000>, <0.019546, 0.555970, 0.019930>, <0.030835, 0.555970, 0.036826>, <0.047731, 0.555970, 0.048116>, <0.067661, 0.555970, 0.052080>, <0.087592, 0.555970, 0.048116>, 
			<0.104488, 0.555970, 0.036826>, <0.115777, 0.555970, 0.019930>, <0.119741, 0.555970, 0.000000>, <0.115777, 0.555970, -0.019930>, <0.104488, 0.555970, -0.036826>, <0.087592, 0.555970, -0.048116>, <0.067661, 0.555970, -0.052080>, <0.047731, 0.555970, -0.048116>, <0.030835, 0.555970, -0.036826>, <0.019546, 0.555970, -0.019930>, <0.019546, 0.536040, -0.000000>, 
			<0.023208, 0.536040, 0.018413>, <0.033639, 0.536040, 0.034023>, <0.049248, 0.536040, 0.044453>, <0.067661, 0.536040, 0.048116>, <0.086074, 0.536040, 0.044453>, <0.101684, 0.536040, 0.034023>, <0.112114, 0.536040, 0.018413>, <0.115777, 0.536040, 0.000000>, <0.112114, 0.536040, -0.018413>, <0.101684, 0.536040, -0.034023>, <0.086074, 0.536040, -0.044453>, 
			<0.067661, 0.536040, -0.048116>, <0.049248, 0.536040, -0.044453>, <0.033639, 0.536040, -0.034023>, <0.023208, 0.536040, -0.018413>, <0.030835, 0.519144, -0.000000>, <0.033639, 0.519144, 0.014093>, <0.041621, 0.519144, 0.026040>, <0.053569, 0.519144, 0.034023>, <0.067661, 0.519144, 0.036826>, <0.081754, 0.519144, 0.034023>, <0.093701, 0.519144, 0.026040>, 
			<0.101684, 0.519144, 0.014093>, <0.104488, 0.519144, 0.000000>, <0.101684, 0.519144, -0.014093>, <0.093701, 0.519144, -0.026040>, <0.081754, 0.519144, -0.034023>, <0.067661, 0.519144, -0.036826>, <0.053569, 0.519144, -0.034023>, <0.041621, 0.519144, -0.026040>, <0.033639, 0.519144, -0.014093>, <0.047731, 0.507854, -0.000000>, <0.049248, 0.507854, 0.007627>, 
			<0.053569, 0.507854, 0.014093>, <0.060034, 0.507854, 0.018413>, <0.067661, 0.507854, 0.019930>, <0.075288, 0.507854, 0.018413>, <0.081754, 0.507854, 0.014093>, <0.086074, 0.507854, 0.007627>, <0.087592, 0.507854, 0.000000>, <0.086074, 0.507854, -0.007627>, <0.081754, 0.507854, -0.014093>, <0.075288, 0.507854, -0.018413>, <0.067661, 0.507854, -0.019930>, 
			<0.060034, 0.507854, -0.018413>, <0.053569, 0.507854, -0.014093>, <0.049248, 0.507854, -0.007627>, <0.067661, 0.608050, -0.000000>, <0.067661, 0.503890, -0.000000>}
	 //#local average_center = <0.067661, 0.555970, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, 0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.608176, -0.752769, -0.251915>, <-0.706555, -0.707599, -0.009151>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.261932, -0.707599, 0.656274>, <0.000000, -0.752769, 0.658285>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.896335, -0.443376, 0.000000>, <0.853594, -0.356654, -0.379704>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <0.000000, -0.443376, -0.896335>, <-0.379704, -0.356654, -0.853594>, <-0.690908, -0.345848, -0.634851>, <-0.828106, -0.443376, -0.343013>, <-0.923671, -0.383155, -0.004888>, <-0.853594, -0.356654, 0.379704>, <-0.653142, -0.383160, 0.653142>, 
			<-0.409293, -0.382443, 0.828382>, <0.000000, -0.383160, 0.923682>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.999194, -0.028393, 0.028393>, <0.921855, 0.066159, -0.381845>, <0.707107, 0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.028393, -0.028393, -0.999194>, <-0.381845, 0.066159, -0.921855>, 
			<-0.707107, 0.000000, -0.707107>, <-0.921855, -0.066159, -0.381845>, <-0.999194, 0.028393, 0.028393>, <-0.907221, 0.039720, 0.418775>, <-0.686460, -0.028393, 0.726613>, <-0.345383, -0.039720, 0.937621>, <0.000000, 0.066159, 0.997809>, <0.382683, 0.000000, 0.923880>, <0.707107, 0.000000, 0.707107>, <0.907221, -0.039720, 0.418775>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, -0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.379704, 0.356654, 0.853594>, 
			<-0.000000, 0.443376, 0.896335>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, -0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <44, 43, 27>, 0, 
			<27, 28, 44>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <33, 49, 48>, 0, <48, 32, 33>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <36, 52, 35>, 0, <52, 51, 35>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <40, 56, 55>, 0, <40, 55, 39>, 0, <41, 57, 56>, 0, <41, 56, 40>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <44, 60, 59>, 0, <59, 43, 44>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 47>, 0, <48, 63, 47>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <60, 76, 75>, 0, <60, 75, 59>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <44, 43, 27>, 
			<27, 28, 44>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <33, 49, 48>, <48, 32, 33>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <36, 52, 35>, <52, 51, 35>, <37, 53, 52>, <52, 36, 37>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <40, 56, 55>, <40, 55, 39>, <41, 57, 56>, <41, 56, 40>, <58, 57, 41>, <41, 42, 58>, <43, 59, 58>, <58, 42, 43>, <44, 60, 59>, <59, 43, 44>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <32, 48, 47>, <48, 63, 47>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <60, 76, 75>, <60, 75, 59>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_20_LeftThigh = mesh2{
	 vertex_vectors { 96, <-0.141100, 1.033475, 0.005087>, <-0.136293, 1.038605, 0.028983>, <-0.122603, 1.041574, 0.049580>, <-0.102114, 1.041930, 0.063741>, <-0.077946, 1.039620, 0.069312>, <-0.053778, 1.034995, 0.065442>, <-0.033289, 1.028758, 0.052723>, <-0.019599, 1.021861, 0.033090>, <-0.014791, 1.015352, 0.009531>, <-0.019599, 1.010222, -0.014365>, 
			<-0.033289, 1.007253, -0.034962>, <-0.053778, 1.006897, -0.049123>, <-0.077946, 1.009207, -0.054694>, <-0.102114, 1.013833, -0.050824>, <-0.122603, 1.020069, -0.038105>, <-0.136293, 1.026966, -0.018472>, <-0.187189, 0.629524, 0.104157>, <-0.183526, 0.633433, 0.122366>, <-0.173094, 0.635695, 0.138061>, <-0.157482, 0.635967, 0.148852>, <-0.139066, 0.634206, 0.153096>, 
			<-0.120649, 0.630682, 0.150148>, <-0.105037, 0.625930, 0.140456>, <-0.094605, 0.620674, 0.125495>, <-0.090942, 0.615714, 0.107544>, <-0.094605, 0.611805, 0.089335>, <-0.105037, 0.609543, 0.073640>, <-0.120649, 0.609271, 0.062849>, <-0.139066, 0.611032, 0.058605>, <-0.157482, 0.614556, 0.061553>, <-0.173094, 0.619308, 0.071245>, <-0.183526, 0.624564, 0.086206>, 
			<-0.120250, 1.051791, 0.019913>, <-0.123942, 1.047851, 0.001561>, <-0.120250, 1.042852, -0.016532>, <-0.109736, 1.037555, -0.031610>, <-0.094000, 1.032766, -0.041379>, <-0.075439, 1.029213, -0.044350>, <-0.056878, 1.027439, -0.040072>, <-0.041143, 1.027713, -0.029196>, <-0.030629, 1.029993, -0.013378>, <-0.026937, 1.033932, 0.004974>, <-0.030629, 1.038931, 0.023067>, 
			<-0.041143, 1.044229, 0.038145>, <-0.056878, 1.049018, 0.047914>, <-0.075439, 1.052570, 0.050886>, <-0.094000, 1.054345, 0.046608>, <-0.109736, 1.054071, 0.035732>, <-0.084950, 1.055351, 0.004590>, <-0.085880, 1.054358, -0.000035>, <-0.084950, 1.053098, -0.004594>, <-0.082300, 1.051763, -0.008394>, <-0.078335, 1.050557, -0.010856>, <-0.073658, 1.049661, -0.011605>, 
			<-0.068980, 1.049214, -0.010527>, <-0.065015, 1.049283, -0.007786>, <-0.062365, 1.049858, -0.003800>, <-0.061435, 1.050851, 0.000825>, <-0.062365, 1.052110, 0.005385>, <-0.065015, 1.053445, 0.009184>, <-0.068980, 1.054652, 0.011646>, <-0.073658, 1.055547, 0.012395>, <-0.078335, 1.055994, 0.011317>, <-0.082300, 1.055925, 0.008576>, <-0.178231, 0.615269, 0.107653>, 
			<-0.175397, 0.618294, 0.121742>, <-0.167326, 0.620044, 0.133886>, <-0.155246, 0.620254, 0.142235>, <-0.140996, 0.618892, 0.145519>, <-0.126747, 0.616165, 0.143238>, <-0.114667, 0.612488, 0.135739>, <-0.106596, 0.608422, 0.124163>, <-0.103761, 0.604584, 0.110274>, <-0.106596, 0.601560, 0.096185>, <-0.114667, 0.599809, 0.084041>, <-0.126747, 0.599599, 0.075692>, 
			<-0.140996, 0.600961, 0.072407>, <-0.155246, 0.603688, 0.074689>, <-0.167326, 0.607365, 0.082188>, <-0.175397, 0.611432, 0.093763>, <-0.155730, 0.599772, 0.111454>, <-0.154748, 0.600821, 0.116338>, <-0.151950, 0.601428, 0.120547>, <-0.147762, 0.601500, 0.123441>, <-0.142823, 0.601028, 0.124580>, <-0.137883, 0.600083, 0.123789>, <-0.133696, 0.598808, 0.121189>, 
			<-0.130898, 0.597399, 0.117177>, <-0.129915, 0.596068, 0.112362>, <-0.130898, 0.595020, 0.107478>, <-0.133696, 0.594413, 0.103269>, <-0.137883, 0.594340, 0.100374>, <-0.142823, 0.594813, 0.099236>, <-0.147762, 0.595758, 0.100027>, <-0.151950, 0.597032, 0.102626>, <-0.154748, 0.598442, 0.106639>}
	 //#local average_center = <-0.108321, 0.824729, 0.056282>;
	 normal_vectors { 96, <0.856128, -0.508244, 0.093447>, <0.787869, -0.538960, -0.297969>, <0.607828, -0.510162, -0.608506>, <0.300596, -0.578409, -0.758343>, <-0.027301, -0.611925, -0.790445>, <-0.347821, -0.489271, -0.799772>, <-0.663221, -0.400247, -0.632408>, <-0.885050, -0.298919, -0.356840>, <-0.981447, -0.186214, 0.045670>, <-0.881904, -0.181343, 0.435155>, 
			<-0.714086, -0.067173, 0.696828>, <-0.413284, -0.061003, 0.908557>, <-0.056975, -0.094269, 0.993915>, <0.343673, -0.114752, 0.932052>, <0.653333, -0.272154, 0.706461>, <0.860539, -0.298056, 0.413081>, <0.974001, 0.226399, 0.008080>, <0.906067, 0.189356, -0.378400>, <0.710865, 0.094207, -0.696991>, <0.442621, 0.018673, -0.896514>, <0.052418, 0.122244, -0.991115>, 
			<-0.356854, 0.203245, -0.911782>, <-0.642623, 0.297129, -0.706223>, <-0.822592, 0.398139, -0.405989>, <-0.835117, 0.541012, -0.099424>, <-0.813443, 0.515284, 0.269802>, <-0.595830, 0.541885, 0.592746>, <-0.293784, 0.600388, 0.743792>, <0.088478, 0.601289, 0.794118>, <0.405806, 0.499308, 0.765515>, <0.660834, 0.423948, 0.619328>, <0.880456, 0.323628, 0.346501>, 
			<0.360671, -0.931656, 0.043971>, <0.427519, -0.877987, 0.215329>, <0.422045, -0.803612, 0.419625>, <0.256166, -0.757305, 0.600723>, <0.074831, -0.703789, 0.706457>, <-0.136404, -0.664785, 0.734476>, <-0.342438, -0.675272, 0.653256>, <-0.558100, -0.609164, 0.563422>, <-0.634476, -0.678227, 0.370741>, <-0.600154, -0.776861, 0.190528>, <-0.634476, -0.772800, -0.014872>, 
			<-0.520277, -0.832848, -0.188881>, <-0.345378, -0.887759, -0.304298>, <-0.136404, -0.929175, -0.343552>, <0.081791, -0.931565, -0.354255>, <0.286028, -0.936072, -0.204833>, <0.001600, -0.983952, 0.178427>, <0.110258, -0.965296, 0.236742>, <-0.002406, -0.951897, 0.306410>, <-0.040028, -0.934711, 0.353146>, <-0.093521, -0.919613, 0.381531>, <-0.154739, -0.908900, 0.387243>, 
			<-0.193262, -0.917925, 0.346502>, <-0.271285, -0.895646, 0.352452>, <-0.323226, -0.902481, 0.284700>, <-0.353107, -0.908655, 0.222851>, <-0.294147, -0.939132, 0.177505>, <-0.263317, -0.956436, 0.126073>, <-0.214364, -0.972519, 0.090860>, <-0.154739, -0.984933, 0.077225>, <-0.074652, -0.994717, 0.070457>, <-0.025224, -0.990599, 0.134452>, <0.730454, 0.660721, -0.172871>, 
			<0.639337, 0.664580, -0.386758>, <0.589801, 0.552317, -0.589135>, <0.368041, 0.556037, -0.745231>, <0.120297, 0.655550, -0.745509>, <-0.111833, 0.646067, -0.755043>, <-0.313971, 0.706417, -0.634348>, <-0.450903, 0.773650, -0.445144>, <-0.501783, 0.837530, -0.216234>, <-0.458864, 0.888333, 0.017532>, <-0.364335, 0.890329, 0.273083>, <-0.111833, 0.922097, 0.370446>, 
			<0.120297, 0.926092, 0.357605>, <0.363370, 0.820766, 0.440800>, <0.557353, 0.791191, 0.251744>, <0.687536, 0.723841, 0.057874>, <0.479802, 0.846360, -0.231225>, <0.313298, 0.902813, -0.294573>, <0.326677, 0.854901, -0.403022>, <0.216034, 0.871207, -0.440825>, <0.143611, 0.899861, -0.411858>, <0.068230, 0.892415, -0.446027>, <-0.009666, 0.914402, -0.404692>, 
			<-0.107373, 0.928628, -0.355134>, <-0.205685, 0.944718, -0.255348>, <-0.076119, 0.983472, -0.164282>, <-0.044869, 0.997673, -0.051328>, <0.068230, 0.997516, -0.017486>, <0.143611, 0.988308, -0.051222>, <0.241443, 0.970304, 0.014659>, <0.315489, 0.946037, -0.074026>, <0.402036, 0.906341, -0.130053>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 188, <56, 57, 58>, 0, <58, 55, 56>, 0, <58, 59, 55>, 0, <59, 54, 55>, 0, <59, 60, 54>, 0, <60, 53, 54>, 0, <60, 61, 53>, 0, <61, 52, 53>, 0, <61, 62, 52>, 0, <62, 51, 52>, 0, 
			<62, 63, 51>, 0, <63, 50, 51>, 0, <63, 48, 50>, 0, <48, 49, 50>, 0, <87, 88, 89>, 0, <89, 86, 87>, 0, <89, 90, 86>, 0, <90, 85, 86>, 0, <90, 91, 85>, 0, <91, 84, 85>, 0, <91, 92, 84>, 0, 
			<92, 83, 84>, 0, <92, 93, 83>, 0, <93, 82, 83>, 0, <93, 94, 82>, 0, <94, 81, 82>, 0, <94, 95, 81>, 0, <95, 80, 81>, 0, <16, 31, 15>, 0, <15, 0, 16>, 0, <31, 30, 14>, 0, <14, 15, 31>, 0, 
			<30, 29, 13>, 0, <13, 14, 30>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <12, 28, 27>, 0, <12, 27, 11>, 0, <11, 27, 26>, 0, <26, 10, 11>, 0, <10, 26, 25>, 0, <25, 9, 10>, 0, <25, 24, 8>, 0, 
			<8, 9, 25>, 0, <8, 24, 23>, 0, <23, 7, 8>, 0, <7, 23, 22>, 0, <22, 6, 7>, 0, <6, 22, 21>, 0, <21, 5, 6>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, 
			<19, 18, 2>, 0, <2, 3, 19>, 0, <18, 17, 1>, 0, <1, 2, 18>, 0, <17, 16, 0>, 0, <0, 1, 17>, 0, <0, 33, 32>, 0, <0, 32, 1>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <14, 35, 34>, 0, 
			<34, 15, 14>, 0, <13, 36, 35>, 0, <35, 14, 13>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <11, 38, 37>, 0, <37, 12, 11>, 0, <10, 39, 38>, 0, <10, 38, 11>, 0, <9, 40, 39>, 0, <9, 39, 10>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 8>, 0, <42, 41, 8>, 0, <6, 43, 7>, 0, <43, 42, 7>, 0, <5, 44, 6>, 0, <44, 43, 6>, 0, <45, 44, 5>, 0, <5, 4, 45>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <47, 46, 3>, 0, <3, 2, 47>, 0, <1, 32, 47>, 0, <1, 47, 2>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, <34, 50, 49>, 0, <49, 33, 34>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, 
			<36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <38, 54, 53>, 0, <53, 37, 38>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 41>, 0, <58, 57, 41>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 43>, 0, <60, 59, 43>, 0, <45, 61, 44>, 0, <61, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, 
			<47, 63, 62>, 0, <47, 62, 46>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <66, 65, 17>, 0, <17, 18, 66>, 0, <67, 66, 18>, 0, <18, 19, 67>, 0, <20, 68, 67>, 0, 
			<67, 19, 20>, 0, <21, 69, 20>, 0, <69, 68, 20>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 22>, 0, <71, 70, 22>, 0, <72, 71, 23>, 0, <23, 24, 72>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<74, 73, 25>, 0, <25, 26, 74>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <28, 76, 75>, 0, <28, 75, 27>, 0, <77, 76, 28>, 0, <28, 29, 77>, 0, <30, 78, 77>, 0, <77, 29, 30>, 0, <31, 79, 78>, 0, 
			<78, 30, 31>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 68>, 0, <85, 84, 68>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 70>, 0, <87, 86, 70>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <78, 94, 93>, 0, <93, 77, 78>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0}
	 normal_indices { 188, <56, 57, 58>, <58, 55, 56>, <58, 59, 55>, <59, 54, 55>, <59, 60, 54>, <60, 53, 54>, <60, 61, 53>, <61, 52, 53>, <61, 62, 52>, <62, 51, 52>, 
			<62, 63, 51>, <63, 50, 51>, <63, 48, 50>, <48, 49, 50>, <87, 88, 89>, <89, 86, 87>, <89, 90, 86>, <90, 85, 86>, <90, 91, 85>, <91, 84, 85>, <91, 92, 84>, 
			<92, 83, 84>, <92, 93, 83>, <93, 82, 83>, <93, 94, 82>, <94, 81, 82>, <94, 95, 81>, <95, 80, 81>, <16, 31, 15>, <15, 0, 16>, <31, 30, 14>, <14, 15, 31>, 
			<30, 29, 13>, <13, 14, 30>, <13, 29, 28>, <13, 28, 12>, <12, 28, 27>, <12, 27, 11>, <11, 27, 26>, <26, 10, 11>, <10, 26, 25>, <25, 9, 10>, <25, 24, 8>, 
			<8, 9, 25>, <8, 24, 23>, <23, 7, 8>, <7, 23, 22>, <22, 6, 7>, <6, 22, 21>, <21, 5, 6>, <5, 21, 20>, <20, 4, 5>, <4, 20, 3>, <20, 19, 3>, 
			<19, 18, 2>, <2, 3, 19>, <18, 17, 1>, <1, 2, 18>, <17, 16, 0>, <0, 1, 17>, <0, 33, 32>, <0, 32, 1>, <34, 33, 0>, <0, 15, 34>, <14, 35, 34>, 
			<34, 15, 14>, <13, 36, 35>, <35, 14, 13>, <12, 37, 36>, <36, 13, 12>, <11, 38, 37>, <37, 12, 11>, <10, 39, 38>, <10, 38, 11>, <9, 40, 39>, <9, 39, 10>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 8>, <42, 41, 8>, <6, 43, 7>, <43, 42, 7>, <5, 44, 6>, <44, 43, 6>, <45, 44, 5>, <5, 4, 45>, <46, 45, 4>, 
			<4, 3, 46>, <47, 46, 3>, <3, 2, 47>, <1, 32, 47>, <1, 47, 2>, <49, 48, 32>, <32, 33, 49>, <34, 50, 49>, <49, 33, 34>, <35, 51, 50>, <50, 34, 35>, 
			<36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <38, 54, 53>, <53, 37, 38>, <39, 55, 38>, <55, 54, 38>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 41>, <58, 57, 41>, <43, 59, 42>, <59, 58, 42>, <44, 60, 43>, <60, 59, 43>, <45, 61, 44>, <61, 60, 44>, <62, 61, 45>, <45, 46, 62>, 
			<47, 63, 62>, <47, 62, 46>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <66, 65, 17>, <17, 18, 66>, <67, 66, 18>, <18, 19, 67>, <20, 68, 67>, 
			<67, 19, 20>, <21, 69, 20>, <69, 68, 20>, <22, 70, 21>, <70, 69, 21>, <23, 71, 22>, <71, 70, 22>, <72, 71, 23>, <23, 24, 72>, <73, 72, 24>, <24, 25, 73>, 
			<74, 73, 25>, <25, 26, 74>, <27, 75, 74>, <27, 74, 26>, <28, 76, 75>, <28, 75, 27>, <77, 76, 28>, <28, 29, 77>, <30, 78, 77>, <77, 29, 30>, <31, 79, 78>, 
			<78, 30, 31>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 68>, <85, 84, 68>, <70, 86, 69>, <86, 85, 69>, <71, 87, 70>, <87, 86, 70>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, <78, 94, 93>, <93, 77, 78>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>}
	 uv_indices { 188, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>}
}
#declare wo_21_LeftHip = mesh2{
	 vertex_vectors { 114, <-0.096111, 1.151168, -0.000000>, <-0.094072, 1.151168, 0.010251>, <-0.088265, 1.151168, 0.018942>, <-0.079575, 1.151168, 0.024749>, <-0.069323, 1.151168, 0.026788>, <-0.059072, 1.151168, 0.024749>, <-0.050382, 1.151168, 0.018942>, <-0.044575, 1.151168, 0.010251>, <-0.042536, 1.151168, 0.000000>, <-0.044575, 1.151168, -0.010251>, 
			<-0.050382, 1.151168, -0.018942>, <-0.059072, 1.151168, -0.024749>, <-0.069323, 1.151168, -0.026788>, <-0.079575, 1.151168, -0.024749>, <-0.088265, 1.151168, -0.018942>, <-0.094072, 1.151168, -0.010251>, <-0.118821, 1.135994, -0.000000>, <-0.115053, 1.135994, 0.018942>, <-0.104323, 1.135994, 0.035000>, <-0.088265, 1.135994, 0.045730>, <-0.069323, 1.135994, 0.049497>, 
			<-0.050382, 1.135994, 0.045730>, <-0.034323, 1.135994, 0.035000>, <-0.023594, 1.135994, 0.018942>, <-0.019826, 1.135994, 0.000000>, <-0.023594, 1.135994, -0.018942>, <-0.034323, 1.135994, -0.035000>, <-0.050382, 1.135994, -0.045730>, <-0.069323, 1.135994, -0.049497>, <-0.088265, 1.135994, -0.045730>, <-0.104323, 1.135994, -0.035000>, <-0.115053, 1.135994, -0.018942>, 
			<-0.133995, 1.113285, -0.000000>, <-0.129072, 1.113285, 0.024749>, <-0.115053, 1.113285, 0.045730>, <-0.094072, 1.113285, 0.059749>, <-0.069323, 1.113285, 0.064672>, <-0.044575, 1.113285, 0.059749>, <-0.023594, 1.113285, 0.045730>, <-0.009575, 1.113285, 0.024749>, <-0.004652, 1.113285, 0.000000>, <-0.009575, 1.113285, -0.024749>, <-0.023594, 1.113285, -0.045730>, 
			<-0.044575, 1.113285, -0.059749>, <-0.069323, 1.113285, -0.064672>, <-0.094072, 1.113285, -0.059749>, <-0.115053, 1.113285, -0.045730>, <-0.129072, 1.113285, -0.024749>, <-0.139323, 1.086497, -0.000000>, <-0.133995, 1.086497, 0.026788>, <-0.118821, 1.086497, 0.049497>, <-0.096111, 1.086497, 0.064672>, <-0.069323, 1.086497, 0.070000>, <-0.042536, 1.086497, 0.064672>, 
			<-0.019826, 1.086497, 0.049497>, <-0.004652, 1.086497, 0.026788>, <0.000677, 1.086497, 0.000000>, <-0.004652, 1.086497, -0.026788>, <-0.019826, 1.086497, -0.049497>, <-0.042536, 1.086497, -0.064672>, <-0.069323, 1.086497, -0.070000>, <-0.096111, 1.086497, -0.064672>, <-0.118821, 1.086497, -0.049497>, <-0.133995, 1.086497, -0.026788>, <-0.133995, 1.059709, -0.000000>, 
			<-0.129072, 1.059709, 0.024749>, <-0.115053, 1.059709, 0.045730>, <-0.094072, 1.059709, 0.059749>, <-0.069323, 1.059709, 0.064672>, <-0.044575, 1.059709, 0.059749>, <-0.023594, 1.059709, 0.045730>, <-0.009575, 1.059709, 0.024749>, <-0.004652, 1.059709, 0.000000>, <-0.009575, 1.059709, -0.024749>, <-0.023594, 1.059709, -0.045730>, <-0.044575, 1.059709, -0.059749>, 
			<-0.069323, 1.059709, -0.064672>, <-0.094072, 1.059709, -0.059749>, <-0.115053, 1.059709, -0.045730>, <-0.129072, 1.059709, -0.024749>, <-0.118821, 1.036999, -0.000000>, <-0.115053, 1.036999, 0.018942>, <-0.104323, 1.036999, 0.035000>, <-0.088265, 1.036999, 0.045730>, <-0.069323, 1.036999, 0.049497>, <-0.050382, 1.036999, 0.045730>, <-0.034323, 1.036999, 0.035000>, 
			<-0.023594, 1.036999, 0.018942>, <-0.019826, 1.036999, 0.000000>, <-0.023594, 1.036999, -0.018942>, <-0.034323, 1.036999, -0.035000>, <-0.050382, 1.036999, -0.045730>, <-0.069323, 1.036999, -0.049497>, <-0.088265, 1.036999, -0.045730>, <-0.104323, 1.036999, -0.035000>, <-0.115053, 1.036999, -0.018942>, <-0.096111, 1.021825, -0.000000>, <-0.094072, 1.021825, 0.010251>, 
			<-0.088265, 1.021825, 0.018942>, <-0.079575, 1.021825, 0.024749>, <-0.069323, 1.021825, 0.026788>, <-0.059072, 1.021825, 0.024749>, <-0.050382, 1.021825, 0.018942>, <-0.044575, 1.021825, 0.010251>, <-0.042536, 1.021825, 0.000000>, <-0.044575, 1.021825, -0.010251>, <-0.050382, 1.021825, -0.018942>, <-0.059072, 1.021825, -0.024749>, <-0.069323, 1.021825, -0.026788>, 
			<-0.079575, 1.021825, -0.024749>, <-0.088265, 1.021825, -0.018942>, <-0.094072, 1.021825, -0.010251>, <-0.069323, 1.156497, -0.000000>, <-0.069323, 1.016497, -0.000000>}
	 //#local average_center = <-0.069323, 1.086497, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.353102, -0.924082, -0.146260>, <-0.418540, -0.907921, -0.022464>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.146260, -0.924082, 0.353102>, <-0.022464, -0.907921, 0.418540>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.658285, -0.752769, 0.000000>, <0.656274, -0.707599, -0.261932>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <0.000000, -0.752769, -0.658285>, 
			<-0.261932, -0.707599, -0.656274>, <-0.531679, -0.659268, -0.531679>, <-0.608176, -0.752769, -0.251915>, <-0.706555, -0.707599, -0.009151>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.240380, -0.727193, 0.642967>, <0.022578, -0.734948, 0.677747>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.912065, -0.409068, -0.028309>, <0.828382, -0.382443, -0.409293>, <0.634851, -0.345848, -0.690908>, <0.348957, -0.383155, -0.855231>, <-0.028309, -0.409068, -0.912065>, <-0.409293, -0.382443, -0.828382>, <-0.690908, -0.345848, -0.634851>, <-0.853471, -0.409068, -0.322878>, <-0.921955, -0.382443, 0.061129>, <-0.828382, -0.382443, 0.409293>, <-0.653142, -0.383160, 0.653142>, 
			<-0.379704, -0.356654, 0.853594>, <0.028309, -0.409068, 0.912065>, <0.409293, -0.382443, 0.828382>, <0.690908, -0.345848, 0.634851>, <0.855231, -0.383155, 0.348957>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.707107, 0.000000, -0.707107>, <0.418775, -0.039720, -0.907221>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.707107, 0.000000, -0.707107>, <-0.907221, -0.039720, -0.418775>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.686460, -0.028393, 0.726613>, <-0.345383, 0.039720, 0.937621>, <0.000000, 0.000000, 1.000000>, <0.382683, 0.000000, 0.923880>, <0.707107, 0.000000, 0.707107>, <0.907221, -0.039720, 0.418775>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, -0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.409293, 0.382443, 0.828382>, 
			<-0.028309, 0.409068, 0.912065>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.706555, 0.707599, -0.009151>, <0.608176, 0.752769, -0.251915>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.009151, 0.707599, -0.706555>, <-0.251915, 0.752769, -0.608176>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, -0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <-0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.418540, 0.907921, -0.022464>, <0.353102, 0.924082, -0.146260>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <-0.022464, 0.907921, -0.418540>, <-0.146260, 0.924082, -0.353102>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, -0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <-0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <-0.000000, -1.000000, -0.000000>, <-0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <8, 24, 23>, 0, <8, 23, 7>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<12, 28, 27>, 0, <12, 27, 11>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 32>, 0, 
			<32, 16, 17>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 36>, 0, <36, 20, 21>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <44, 43, 27>, 0, 
			<27, 28, 44>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <55, 54, 38>, 0, 
			<38, 39, 55>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <43, 59, 58>, 0, <58, 42, 43>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <63, 62, 46>, 0, <46, 47, 63>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <76, 75, 59>, 0, <59, 60, 76>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 96>, 0, <96, 80, 81>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 100>, 0, <100, 84, 85>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <8, 24, 23>, <8, 23, 7>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<12, 28, 27>, <12, 27, 11>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 32>, 
			<32, 16, 17>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 36>, <36, 20, 21>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <44, 43, 27>, 
			<27, 28, 44>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <55, 54, 38>, 
			<38, 39, 55>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <43, 59, 58>, <58, 42, 43>, <60, 59, 43>, <43, 44, 60>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <63, 62, 46>, <46, 47, 63>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <76, 75, 59>, <59, 60, 76>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 96>, <96, 80, 81>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 100>, <100, 84, 85>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_22_RightHip = mesh2{
	 vertex_vectors { 114, <0.040874, 1.151168, -0.000000>, <0.042913, 1.151168, 0.010251>, <0.048720, 1.151168, 0.018942>, <0.057410, 1.151168, 0.024749>, <0.067661, 1.151168, 0.026788>, <0.077913, 1.151168, 0.024749>, <0.086603, 1.151168, 0.018942>, <0.092410, 1.151168, 0.010251>, <0.094449, 1.151168, 0.000000>, <0.092410, 1.151168, -0.010251>, 
			<0.086603, 1.151168, -0.018942>, <0.077913, 1.151168, -0.024749>, <0.067661, 1.151168, -0.026788>, <0.057410, 1.151168, -0.024749>, <0.048720, 1.151168, -0.018942>, <0.042913, 1.151168, -0.010251>, <0.018164, 1.135994, -0.000000>, <0.021932, 1.135994, 0.018942>, <0.032661, 1.135994, 0.035000>, <0.048720, 1.135994, 0.045730>, <0.067661, 1.135994, 0.049497>, 
			<0.086603, 1.135994, 0.045730>, <0.102661, 1.135994, 0.035000>, <0.113391, 1.135994, 0.018942>, <0.117159, 1.135994, 0.000000>, <0.113391, 1.135994, -0.018942>, <0.102661, 1.135994, -0.035000>, <0.086603, 1.135994, -0.045730>, <0.067661, 1.135994, -0.049497>, <0.048720, 1.135994, -0.045730>, <0.032661, 1.135994, -0.035000>, <0.021932, 1.135994, -0.018942>, 
			<0.002990, 1.113285, -0.000000>, <0.007913, 1.113285, 0.024749>, <0.021932, 1.113285, 0.045730>, <0.042913, 1.113285, 0.059749>, <0.067661, 1.113285, 0.064672>, <0.092410, 1.113285, 0.059749>, <0.113391, 1.113285, 0.045730>, <0.127410, 1.113285, 0.024749>, <0.132333, 1.113285, 0.000000>, <0.127410, 1.113285, -0.024749>, <0.113391, 1.113285, -0.045730>, 
			<0.092410, 1.113285, -0.059749>, <0.067661, 1.113285, -0.064672>, <0.042913, 1.113285, -0.059749>, <0.021932, 1.113285, -0.045730>, <0.007913, 1.113285, -0.024749>, <-0.002339, 1.086497, -0.000000>, <0.002990, 1.086497, 0.026788>, <0.018164, 1.086497, 0.049497>, <0.040874, 1.086497, 0.064672>, <0.067661, 1.086497, 0.070000>, <0.094449, 1.086497, 0.064672>, 
			<0.117159, 1.086497, 0.049497>, <0.132333, 1.086497, 0.026788>, <0.137661, 1.086497, 0.000000>, <0.132333, 1.086497, -0.026788>, <0.117159, 1.086497, -0.049497>, <0.094449, 1.086497, -0.064672>, <0.067661, 1.086497, -0.070000>, <0.040874, 1.086497, -0.064672>, <0.018164, 1.086497, -0.049497>, <0.002990, 1.086497, -0.026788>, <0.002990, 1.059709, -0.000000>, 
			<0.007913, 1.059709, 0.024749>, <0.021932, 1.059709, 0.045730>, <0.042913, 1.059709, 0.059749>, <0.067661, 1.059709, 0.064672>, <0.092410, 1.059709, 0.059749>, <0.113391, 1.059709, 0.045730>, <0.127410, 1.059709, 0.024749>, <0.132333, 1.059709, 0.000000>, <0.127410, 1.059709, -0.024749>, <0.113391, 1.059709, -0.045730>, <0.092410, 1.059709, -0.059749>, 
			<0.067661, 1.059709, -0.064672>, <0.042913, 1.059709, -0.059749>, <0.021932, 1.059709, -0.045730>, <0.007913, 1.059709, -0.024749>, <0.018164, 1.036999, -0.000000>, <0.021932, 1.036999, 0.018942>, <0.032661, 1.036999, 0.035000>, <0.048720, 1.036999, 0.045730>, <0.067661, 1.036999, 0.049497>, <0.086603, 1.036999, 0.045730>, <0.102661, 1.036999, 0.035000>, 
			<0.113391, 1.036999, 0.018942>, <0.117159, 1.036999, 0.000000>, <0.113391, 1.036999, -0.018942>, <0.102661, 1.036999, -0.035000>, <0.086603, 1.036999, -0.045730>, <0.067661, 1.036999, -0.049497>, <0.048720, 1.036999, -0.045730>, <0.032661, 1.036999, -0.035000>, <0.021932, 1.036999, -0.018942>, <0.040874, 1.021825, -0.000000>, <0.042913, 1.021825, 0.010251>, 
			<0.048720, 1.021825, 0.018942>, <0.057410, 1.021825, 0.024749>, <0.067661, 1.021825, 0.026788>, <0.077913, 1.021825, 0.024749>, <0.086603, 1.021825, 0.018942>, <0.092410, 1.021825, 0.010251>, <0.094449, 1.021825, 0.000000>, <0.092410, 1.021825, -0.010251>, <0.086603, 1.021825, -0.018942>, <0.077913, 1.021825, -0.024749>, <0.067661, 1.021825, -0.026788>, 
			<0.057410, 1.021825, -0.024749>, <0.048720, 1.021825, -0.018942>, <0.042913, 1.021825, -0.010251>, <0.067661, 1.156497, -0.000000>, <0.067661, 1.016497, -0.000000>}
	 //#local average_center = <0.067661, 1.086497, -0.000000>;
	 normal_vectors { 114, <0.382195, -0.924082, 0.000000>, <0.395277, -0.907921, -0.139414>, <0.312929, -0.896745, -0.312929>, <0.139414, -0.907921, -0.395277>, <0.000000, -0.924082, -0.382195>, <-0.139414, -0.907921, -0.395277>, <-0.312929, -0.896745, -0.312929>, <-0.395277, -0.907921, -0.139414>, <-0.382195, -0.924082, 0.000000>, <-0.395277, -0.907921, 0.139414>, 
			<-0.312929, -0.896745, 0.312929>, <-0.139414, -0.907921, 0.395277>, <0.000000, -0.924082, 0.382195>, <0.139414, -0.907921, 0.395277>, <0.312929, -0.896745, 0.312929>, <0.395277, -0.907921, 0.139414>, <0.686014, -0.727193, -0.023971>, <0.617517, -0.734948, -0.280222>, <0.531679, -0.659268, -0.531679>, <0.261932, -0.707599, -0.656274>, <-0.023971, -0.727193, -0.686014>, 
			<-0.280222, -0.734948, -0.617517>, <-0.531679, -0.659268, -0.531679>, <-0.617517, -0.734948, -0.280222>, <-0.686014, -0.727193, -0.023971>, <-0.656274, -0.707599, 0.261932>, <-0.531679, -0.659268, 0.531679>, <-0.261932, -0.707599, 0.656274>, <0.000000, -0.752769, 0.658285>, <0.261932, -0.707599, 0.656274>, <0.531679, -0.659268, 0.531679>, <0.656274, -0.707599, 0.261932>, 
			<0.923671, -0.383155, -0.004888>, <0.831805, -0.409068, -0.375186>, <0.653142, -0.383160, -0.653142>, <0.379704, -0.356654, -0.853594>, <-0.004888, -0.383155, -0.923671>, <-0.375186, -0.409068, -0.831805>, <-0.653142, -0.383160, -0.653142>, <-0.853371, -0.383160, -0.353478>, <-0.921955, -0.382443, 0.061129>, <-0.828382, -0.382443, 0.409293>, <-0.634851, -0.345848, 0.690908>, 
			<-0.348957, -0.383155, 0.855231>, <0.028309, -0.409068, 0.912065>, <0.409293, -0.382443, 0.828382>, <0.653142, -0.383160, 0.653142>, <0.853594, -0.356654, 0.379704>, <0.997809, 0.000000, 0.066159>, <0.934000, 0.028393, -0.356143>, <0.686460, -0.028393, -0.726613>, <0.382683, 0.000000, -0.923880>, <0.066159, 0.000000, -0.997809>, <-0.356143, 0.028393, -0.934000>, 
			<-0.726613, -0.028393, -0.686460>, <-0.923880, 0.000000, -0.382683>, <-0.999194, 0.028393, -0.028393>, <-0.923880, 0.000000, 0.382683>, <-0.707107, 0.000000, 0.707107>, <-0.382683, 0.000000, 0.923880>, <0.000000, 0.000000, 1.000000>, <0.382683, 0.000000, 0.923880>, <0.726613, -0.028393, 0.686460>, <0.923880, 0.000000, 0.382683>, <0.923671, 0.383155, -0.004888>, 
			<0.828106, 0.443376, -0.343013>, <0.690908, 0.345848, -0.634851>, <0.379704, 0.356654, -0.853594>, <-0.004888, 0.383155, -0.923671>, <-0.343013, 0.443376, -0.828106>, <-0.634851, 0.345848, -0.690908>, <-0.853594, 0.356654, -0.379704>, <-0.896335, 0.443376, -0.000000>, <-0.855231, 0.383155, 0.348957>, <-0.690908, 0.345848, 0.634851>, <-0.409293, 0.382443, 0.828382>, 
			<-0.028309, 0.409068, 0.912065>, <0.348957, 0.383155, 0.855231>, <0.634851, 0.345848, 0.690908>, <0.853594, 0.356654, 0.379704>, <0.686014, 0.727193, -0.023971>, <0.617517, 0.734948, -0.280222>, <0.531679, 0.659268, -0.531679>, <0.261932, 0.707599, -0.656274>, <-0.023971, 0.727193, -0.686014>, <-0.280222, 0.734948, -0.617517>, <-0.531679, 0.659268, -0.531679>, 
			<-0.656274, 0.707599, -0.261932>, <-0.658285, 0.752769, 0.000000>, <-0.656274, 0.707599, 0.261932>, <-0.531679, 0.659268, 0.531679>, <-0.261932, 0.707599, 0.656274>, <0.000000, 0.752769, 0.658285>, <0.261932, 0.707599, 0.656274>, <0.531679, 0.659268, 0.531679>, <0.656274, 0.707599, 0.261932>, <0.382195, 0.924082, -0.000000>, <0.395277, 0.907921, -0.139414>, 
			<0.312929, 0.896745, -0.312929>, <0.139414, 0.907921, -0.395277>, <0.000000, 0.924082, -0.382195>, <-0.139414, 0.907921, -0.395277>, <-0.312929, 0.896745, -0.312929>, <-0.395277, 0.907921, -0.139414>, <-0.382195, 0.924082, 0.000000>, <-0.395277, 0.907921, 0.139414>, <-0.312929, 0.896745, 0.312929>, <-0.139414, 0.907921, 0.395277>, <0.000000, 0.924082, 0.382195>, 
			<0.139414, 0.907921, 0.395277>, <0.312929, 0.896745, 0.312929>, <0.395277, 0.907921, 0.139414>, <0.000000, -1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 224, <0, 112, 1>, 0, <1, 112, 2>, 0, <2, 112, 3>, 0, <3, 112, 4>, 0, <4, 112, 5>, 0, <5, 112, 6>, 0, <6, 112, 7>, 0, <7, 112, 8>, 0, <8, 112, 9>, 0, <9, 112, 10>, 0, 
			<10, 112, 11>, 0, <11, 112, 12>, 0, <12, 112, 13>, 0, <13, 112, 14>, 0, <14, 112, 15>, 0, <15, 112, 0>, 0, <97, 113, 96>, 0, <98, 113, 97>, 0, <99, 113, 98>, 0, <100, 113, 99>, 0, <101, 113, 100>, 0, 
			<102, 113, 101>, 0, <103, 113, 102>, 0, <104, 113, 103>, 0, <105, 113, 104>, 0, <106, 113, 105>, 0, <107, 113, 106>, 0, <108, 113, 107>, 0, <109, 113, 108>, 0, <110, 113, 109>, 0, <111, 113, 110>, 0, <96, 113, 111>, 0, 
			<1, 17, 16>, 0, <16, 0, 1>, 0, <2, 18, 17>, 0, <17, 1, 2>, 0, <3, 19, 2>, 0, <19, 18, 2>, 0, <4, 20, 3>, 0, <20, 19, 3>, 0, <5, 21, 20>, 0, <20, 4, 5>, 0, <6, 22, 21>, 0, 
			<21, 5, 6>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, <9, 25, 24>, 0, <9, 24, 8>, 0, <10, 26, 25>, 0, <10, 25, 9>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, 
			<28, 27, 11>, 0, <11, 12, 28>, 0, <13, 29, 28>, 0, <13, 28, 12>, 0, <14, 30, 29>, 0, <14, 29, 13>, 0, <15, 31, 14>, 0, <31, 30, 14>, 0, <0, 16, 15>, 0, <16, 31, 15>, 0, <17, 33, 16>, 0, 
			<33, 32, 16>, 0, <18, 34, 33>, 0, <33, 17, 18>, 0, <19, 35, 18>, 0, <35, 34, 18>, 0, <20, 36, 19>, 0, <36, 35, 19>, 0, <21, 37, 20>, 0, <37, 36, 20>, 0, <22, 38, 37>, 0, <37, 21, 22>, 0, 
			<39, 38, 22>, 0, <22, 23, 39>, 0, <24, 40, 39>, 0, <24, 39, 23>, 0, <25, 41, 40>, 0, <25, 40, 24>, 0, <26, 42, 41>, 0, <26, 41, 25>, 0, <43, 42, 26>, 0, <26, 27, 43>, 0, <44, 43, 27>, 0, 
			<27, 28, 44>, 0, <29, 45, 44>, 0, <29, 44, 28>, 0, <30, 46, 45>, 0, <30, 45, 29>, 0, <31, 47, 30>, 0, <47, 46, 30>, 0, <16, 32, 31>, 0, <32, 47, 31>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, 
			<50, 49, 33>, 0, <33, 34, 50>, 0, <35, 51, 50>, 0, <50, 34, 35>, 0, <52, 51, 35>, 0, <35, 36, 52>, 0, <53, 52, 36>, 0, <36, 37, 53>, 0, <54, 53, 37>, 0, <37, 38, 54>, 0, <39, 55, 54>, 0, 
			<54, 38, 39>, 0, <56, 55, 39>, 0, <39, 40, 56>, 0, <57, 56, 40>, 0, <40, 41, 57>, 0, <58, 57, 41>, 0, <41, 42, 58>, 0, <59, 58, 42>, 0, <42, 43, 59>, 0, <60, 59, 43>, 0, <43, 44, 60>, 0, 
			<61, 60, 44>, 0, <44, 45, 61>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, <47, 63, 62>, 0, <62, 46, 47>, 0, <48, 63, 47>, 0, <47, 32, 48>, 0, <49, 65, 64>, 0, <64, 48, 49>, 0, <66, 65, 49>, 0, 
			<49, 50, 66>, 0, <67, 66, 50>, 0, <50, 51, 67>, 0, <52, 68, 67>, 0, <67, 51, 52>, 0, <53, 69, 68>, 0, <68, 52, 53>, 0, <70, 69, 53>, 0, <53, 54, 70>, 0, <71, 70, 54>, 0, <54, 55, 71>, 0, 
			<56, 72, 71>, 0, <56, 71, 55>, 0, <73, 72, 56>, 0, <56, 57, 73>, 0, <74, 73, 57>, 0, <57, 58, 74>, 0, <75, 74, 58>, 0, <58, 59, 75>, 0, <76, 75, 59>, 0, <59, 60, 76>, 0, <77, 76, 60>, 0, 
			<60, 61, 77>, 0, <78, 77, 61>, 0, <61, 62, 78>, 0, <79, 78, 62>, 0, <62, 63, 79>, 0, <48, 64, 79>, 0, <79, 63, 48>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, 
			<67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, <69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <72, 88, 87>, 0, 
			<72, 87, 71>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, <73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, 
			<94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, <64, 80, 95>, 0, <95, 79, 64>, 0, <81, 97, 80>, 0, <97, 96, 80>, 0, <82, 98, 81>, 0, <98, 97, 81>, 0, <83, 99, 98>, 0, 
			<98, 82, 83>, 0, <84, 100, 99>, 0, <99, 83, 84>, 0, <85, 101, 84>, 0, <101, 100, 84>, 0, <86, 102, 85>, 0, <102, 101, 85>, 0, <87, 103, 102>, 0, <87, 102, 86>, 0, <88, 104, 103>, 0, <88, 103, 87>, 0, 
			<105, 104, 88>, 0, <88, 89, 105>, 0, <106, 105, 89>, 0, <89, 90, 106>, 0, <91, 107, 106>, 0, <91, 106, 90>, 0, <92, 108, 107>, 0, <92, 107, 91>, 0, <109, 108, 92>, 0, <92, 93, 109>, 0, <110, 109, 93>, 0, 
			<93, 94, 110>, 0, <95, 111, 110>, 0, <110, 94, 95>, 0, <80, 96, 111>, 0, <111, 95, 80>, 0}
	 normal_indices { 224, <0, 112, 1>, <1, 112, 2>, <2, 112, 3>, <3, 112, 4>, <4, 112, 5>, <5, 112, 6>, <6, 112, 7>, <7, 112, 8>, <8, 112, 9>, <9, 112, 10>, 
			<10, 112, 11>, <11, 112, 12>, <12, 112, 13>, <13, 112, 14>, <14, 112, 15>, <15, 112, 0>, <97, 113, 96>, <98, 113, 97>, <99, 113, 98>, <100, 113, 99>, <101, 113, 100>, 
			<102, 113, 101>, <103, 113, 102>, <104, 113, 103>, <105, 113, 104>, <106, 113, 105>, <107, 113, 106>, <108, 113, 107>, <109, 113, 108>, <110, 113, 109>, <111, 113, 110>, <96, 113, 111>, 
			<1, 17, 16>, <16, 0, 1>, <2, 18, 17>, <17, 1, 2>, <3, 19, 2>, <19, 18, 2>, <4, 20, 3>, <20, 19, 3>, <5, 21, 20>, <20, 4, 5>, <6, 22, 21>, 
			<21, 5, 6>, <23, 22, 6>, <6, 7, 23>, <24, 23, 7>, <7, 8, 24>, <9, 25, 24>, <9, 24, 8>, <10, 26, 25>, <10, 25, 9>, <27, 26, 10>, <10, 11, 27>, 
			<28, 27, 11>, <11, 12, 28>, <13, 29, 28>, <13, 28, 12>, <14, 30, 29>, <14, 29, 13>, <15, 31, 14>, <31, 30, 14>, <0, 16, 15>, <16, 31, 15>, <17, 33, 16>, 
			<33, 32, 16>, <18, 34, 33>, <33, 17, 18>, <19, 35, 18>, <35, 34, 18>, <20, 36, 19>, <36, 35, 19>, <21, 37, 20>, <37, 36, 20>, <22, 38, 37>, <37, 21, 22>, 
			<39, 38, 22>, <22, 23, 39>, <24, 40, 39>, <24, 39, 23>, <25, 41, 40>, <25, 40, 24>, <26, 42, 41>, <26, 41, 25>, <43, 42, 26>, <26, 27, 43>, <44, 43, 27>, 
			<27, 28, 44>, <29, 45, 44>, <29, 44, 28>, <30, 46, 45>, <30, 45, 29>, <31, 47, 30>, <47, 46, 30>, <16, 32, 31>, <32, 47, 31>, <49, 48, 32>, <32, 33, 49>, 
			<50, 49, 33>, <33, 34, 50>, <35, 51, 50>, <50, 34, 35>, <52, 51, 35>, <35, 36, 52>, <53, 52, 36>, <36, 37, 53>, <54, 53, 37>, <37, 38, 54>, <39, 55, 54>, 
			<54, 38, 39>, <56, 55, 39>, <39, 40, 56>, <57, 56, 40>, <40, 41, 57>, <58, 57, 41>, <41, 42, 58>, <59, 58, 42>, <42, 43, 59>, <60, 59, 43>, <43, 44, 60>, 
			<61, 60, 44>, <44, 45, 61>, <62, 61, 45>, <45, 46, 62>, <47, 63, 62>, <62, 46, 47>, <48, 63, 47>, <47, 32, 48>, <49, 65, 64>, <64, 48, 49>, <66, 65, 49>, 
			<49, 50, 66>, <67, 66, 50>, <50, 51, 67>, <52, 68, 67>, <67, 51, 52>, <53, 69, 68>, <68, 52, 53>, <70, 69, 53>, <53, 54, 70>, <71, 70, 54>, <54, 55, 71>, 
			<56, 72, 71>, <56, 71, 55>, <73, 72, 56>, <56, 57, 73>, <74, 73, 57>, <57, 58, 74>, <75, 74, 58>, <58, 59, 75>, <76, 75, 59>, <59, 60, 76>, <77, 76, 60>, 
			<60, 61, 77>, <78, 77, 61>, <61, 62, 78>, <79, 78, 62>, <62, 63, 79>, <48, 64, 79>, <79, 63, 48>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, 
			<67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, <69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <72, 88, 87>, 
			<72, 87, 71>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, <73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, 
			<94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, <64, 80, 95>, <95, 79, 64>, <81, 97, 80>, <97, 96, 80>, <82, 98, 81>, <98, 97, 81>, <83, 99, 98>, 
			<98, 82, 83>, <84, 100, 99>, <99, 83, 84>, <85, 101, 84>, <101, 100, 84>, <86, 102, 85>, <102, 101, 85>, <87, 103, 102>, <87, 102, 86>, <88, 104, 103>, <88, 103, 87>, 
			<105, 104, 88>, <88, 89, 105>, <106, 105, 89>, <89, 90, 106>, <91, 107, 106>, <91, 106, 90>, <92, 108, 107>, <92, 107, 91>, <109, 108, 92>, <92, 93, 109>, <110, 109, 93>, 
			<93, 94, 110>, <95, 111, 110>, <110, 94, 95>, <80, 96, 111>, <111, 95, 80>}
	 uv_indices { 224, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}
#declare wo_23_RightThigh = mesh2{
	 vertex_vectors { 96, <0.002963, 1.020070, -0.000000>, <0.007822, 1.020070, 0.024431>, <0.021661, 1.020070, 0.045142>, <0.042372, 1.020070, 0.058980>, <0.066803, 1.020070, 0.063840>, <0.091233, 1.020070, 0.058980>, <0.111944, 1.020070, 0.045142>, <0.125783, 1.020070, 0.024431>, <0.130643, 1.020070, 0.000000>, <0.125783, 1.020070, -0.024431>, 
			<0.111944, 1.020070, -0.045142>, <0.091233, 1.020070, -0.058980>, <0.066803, 1.020070, -0.063840>, <0.042372, 1.020070, -0.058980>, <0.021661, 1.020070, -0.045142>, <0.007822, 1.020070, -0.024431>, <0.018156, 0.601878, -0.000000>, <0.021859, 0.601878, 0.018616>, <0.032405, 0.601878, 0.034398>, <0.048187, 0.601878, 0.044943>, <0.066803, 0.601878, 0.048646>, 
			<0.085419, 0.601878, 0.044943>, <0.101201, 0.601878, 0.034398>, <0.111746, 0.601878, 0.018616>, <0.115449, 0.601878, 0.000000>, <0.111746, 0.601878, -0.018616>, <0.101201, 0.601878, -0.034398>, <0.085419, 0.601878, -0.044943>, <0.066803, 0.601878, -0.048646>, <0.048187, 0.601878, -0.044943>, <0.032405, 0.601878, -0.034398>, <0.021859, 0.601878, -0.018616>, 
			<0.021506, 1.037221, 0.018763>, <0.017773, 1.037221, 0.000000>, <0.021506, 1.037221, -0.018763>, <0.032134, 1.037221, -0.034669>, <0.048040, 1.037221, -0.045297>, <0.066803, 1.037221, -0.049029>, <0.085565, 1.037221, -0.045297>, <0.101471, 1.037221, -0.034669>, <0.112100, 1.037221, -0.018763>, <0.115832, 1.037221, 0.000000>, <0.112100, 1.037221, 0.018763>, 
			<0.101471, 1.037221, 0.034669>, <0.085565, 1.037221, 0.045297>, <0.066803, 1.037221, 0.049029>, <0.048040, 1.037221, 0.045297>, <0.032134, 1.037221, 0.034669>, <0.055388, 1.049411, 0.004728>, <0.054447, 1.049411, -0.000000>, <0.055388, 1.049411, -0.004728>, <0.058066, 1.049411, -0.008737>, <0.062074, 1.049411, -0.011415>, <0.066803, 1.049411, -0.012355>, 
			<0.071531, 1.049411, -0.011415>, <0.075539, 1.049411, -0.008737>, <0.078217, 1.049411, -0.004728>, <0.079158, 1.049411, 0.000000>, <0.078217, 1.049411, 0.004728>, <0.075539, 1.049411, 0.008737>, <0.071531, 1.049411, 0.011415>, <0.066803, 1.049411, 0.012355>, <0.062074, 1.049411, 0.011415>, <0.058066, 1.049411, 0.008737>, <0.029163, 0.588667, 0.000000>, 
			<0.032028, 0.588667, 0.014404>, <0.040188, 0.588667, 0.026615>, <0.052399, 0.588667, 0.034774>, <0.066803, 0.588667, 0.037639>, <0.081206, 0.588667, 0.034774>, <0.093418, 0.588667, 0.026615>, <0.101577, 0.588667, 0.014404>, <0.104442, 0.588667, 0.000000>, <0.101577, 0.588667, -0.014404>, <0.093418, 0.588667, -0.026615>, <0.081206, 0.588667, -0.034774>, 
			<0.066803, 0.588667, -0.037639>, <0.052399, 0.588667, -0.034774>, <0.040188, 0.588667, -0.026615>, <0.032028, 0.588667, -0.014404>, <0.053755, 0.576171, 0.000000>, <0.054748, 0.576171, 0.004993>, <0.057577, 0.576171, 0.009226>, <0.061810, 0.576171, 0.012054>, <0.066803, 0.576171, 0.013047>, <0.071796, 0.576171, 0.012054>, <0.076029, 0.576171, 0.009226>, 
			<0.078857, 0.576171, 0.004993>, <0.079850, 0.576171, 0.000000>, <0.078857, 0.576171, -0.004993>, <0.076029, 0.576171, -0.009226>, <0.071796, 0.576171, -0.012054>, <0.066803, 0.576171, -0.013047>, <0.061810, 0.576171, -0.012054>, <0.057577, 0.576171, -0.009226>, <0.054748, 0.576171, -0.004993>}
	 //#local average_center = <0.066803, 0.812236, 0.000000>;
	 normal_vectors { 96, <0.942853, -0.333103, -0.008381>, <0.840527, -0.385209, -0.380957>, <0.652533, -0.257936, -0.712510>, <0.353071, -0.333103, -0.874290>, <-0.030303, -0.385209, -0.922332>, <-0.417770, -0.332465, -0.845538>, <-0.712510, -0.257936, -0.652533>, <-0.863720, -0.385209, -0.324964>, <-0.941049, -0.332465, 0.062395>, <-0.831545, -0.405663, 0.379436>, 
			<-0.691690, -0.207677, 0.691690>, <-0.353071, -0.333103, 0.874290>, <0.030303, -0.385209, 0.922332>, <0.379436, -0.405663, 0.831545>, <0.691690, -0.207677, 0.691690>, <0.874290, -0.333103, 0.353071>, <0.931687, 0.357970, 0.061775>, <0.856287, 0.403520, -0.322405>, <0.704759, 0.293882, -0.645715>, <0.413614, 0.357970, -0.837127>, <0.061775, 0.357970, -0.931687>, 
			<-0.322405, 0.403520, -0.856287>, <-0.645715, 0.293882, -0.704759>, <-0.837127, 0.357970, -0.413614>, <-0.914485, 0.403520, -0.029823>, <-0.868458, 0.312618, 0.384775>, <-0.660063, 0.358655, 0.660063>, <-0.413614, 0.357970, 0.837127>, <-0.029823, 0.403520, 0.914485>, <0.384775, 0.312618, 0.868458>, <0.660063, 0.358655, 0.660063>, <0.837127, 0.357970, 0.413614>, 
			<0.440511, -0.879009, -0.182466>, <0.554988, -0.831723, -0.015007>, <0.518485, -0.831723, 0.198520>, <0.444697, -0.777489, 0.444697>, <0.198520, -0.831723, 0.518485>, <-0.000000, -0.879009, 0.476805>, <-0.198520, -0.831723, 0.518485>, <-0.444697, -0.777489, 0.444697>, <-0.518485, -0.831723, 0.198520>, <-0.554988, -0.831723, -0.015007>, <-0.440511, -0.879009, -0.182466>, 
			<-0.444697, -0.777489, -0.444697>, <-0.198520, -0.831723, -0.518485>, <0.000000, -0.879009, -0.476805>, <0.198520, -0.831723, -0.518485>, <0.444697, -0.777489, -0.444697>, <0.147462, -0.987180, -0.061081>, <0.238727, -0.970958, -0.015829>, <0.151503, -0.987125, 0.051301>, <0.128970, -0.983226, 0.128970>, <0.051301, -0.987125, 0.151503>, <0.000000, -0.991826, 0.127597>, 
			<-0.051301, -0.987125, 0.151503>, <-0.128970, -0.983226, 0.128970>, <-0.181741, -0.981419, 0.061539>, <-0.238727, -0.970958, -0.015829>, <-0.117884, -0.991826, -0.048829>, <-0.128970, -0.983226, -0.128970>, <-0.051301, -0.987125, -0.151503>, <0.000000, -0.991826, -0.127597>, <0.051301, -0.987125, -0.151503>, <0.128970, -0.983226, -0.128970>, <0.622806, 0.782305, -0.010515>, 
			<0.524674, 0.823096, -0.217327>, <0.477294, 0.737821, -0.477294>, <0.228623, 0.782305, -0.579422>, <-0.010515, 0.782305, -0.622806>, <-0.217327, 0.823096, -0.524674>, <-0.477294, 0.737821, -0.477294>, <-0.562300, 0.800110, -0.208907>, <-0.590061, 0.807148, 0.018436>, <-0.579422, 0.782305, 0.228623>, <-0.477294, 0.737821, 0.477294>, <-0.228623, 0.782305, 0.579422>, 
			<-0.000000, 0.823096, 0.567903>, <0.228623, 0.782305, 0.579422>, <0.477294, 0.737821, 0.477294>, <0.579422, 0.782305, 0.228623>, <0.346464, 0.937782, -0.022972>, <0.171529, 0.982614, -0.071050>, <0.187789, 0.964090, -0.187789>, <0.074704, 0.972495, -0.220620>, <-0.015410, 0.972495, -0.232415>, <-0.071050, 0.982614, -0.171529>, <-0.187789, 0.964090, -0.187789>, 
			<-0.214749, 0.972610, -0.088952>, <-0.346464, 0.937782, -0.022972>, <-0.220620, 0.972495, 0.074704>, <-0.187789, 0.964090, 0.187789>, <-0.074704, 0.972495, 0.220620>, <-0.000000, 0.982614, 0.185662>, <0.074704, 0.972495, 0.220620>, <0.187789, 0.964090, 0.187789>, <0.264540, 0.960205, 0.089576>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 188, <56, 57, 58>, 0, <58, 55, 56>, 0, <58, 59, 55>, 0, <59, 54, 55>, 0, <59, 60, 54>, 0, <60, 53, 54>, 0, <60, 61, 53>, 0, <61, 52, 53>, 0, <61, 62, 52>, 0, <62, 51, 52>, 0, 
			<62, 63, 51>, 0, <63, 50, 51>, 0, <63, 48, 50>, 0, <48, 49, 50>, 0, <87, 88, 89>, 0, <89, 86, 87>, 0, <89, 90, 86>, 0, <90, 85, 86>, 0, <90, 91, 85>, 0, <91, 84, 85>, 0, <91, 92, 84>, 0, 
			<92, 83, 84>, 0, <92, 93, 83>, 0, <93, 82, 83>, 0, <93, 94, 82>, 0, <94, 81, 82>, 0, <94, 95, 81>, 0, <95, 80, 81>, 0, <16, 31, 15>, 0, <15, 0, 16>, 0, <31, 30, 14>, 0, <14, 15, 31>, 0, 
			<14, 30, 29>, 0, <29, 13, 14>, 0, <29, 28, 12>, 0, <12, 13, 29>, 0, <28, 27, 11>, 0, <11, 12, 28>, 0, <27, 26, 10>, 0, <10, 11, 27>, 0, <10, 26, 25>, 0, <25, 9, 10>, 0, <25, 24, 8>, 0, 
			<8, 9, 25>, 0, <24, 23, 7>, 0, <7, 8, 24>, 0, <23, 22, 6>, 0, <6, 7, 23>, 0, <22, 21, 5>, 0, <5, 6, 22>, 0, <21, 20, 4>, 0, <4, 5, 21>, 0, <20, 19, 3>, 0, <3, 4, 20>, 0, 
			<19, 18, 2>, 0, <2, 3, 19>, 0, <18, 17, 1>, 0, <1, 2, 18>, 0, <17, 16, 0>, 0, <0, 1, 17>, 0, <33, 32, 1>, 0, <1, 0, 33>, 0, <34, 33, 0>, 0, <0, 15, 34>, 0, <35, 34, 15>, 0, 
			<15, 14, 35>, 0, <13, 36, 35>, 0, <35, 14, 13>, 0, <12, 37, 36>, 0, <36, 13, 12>, 0, <11, 38, 12>, 0, <38, 37, 12>, 0, <10, 39, 11>, 0, <39, 38, 11>, 0, <9, 40, 39>, 0, <39, 10, 9>, 0, 
			<8, 41, 40>, 0, <40, 9, 8>, 0, <7, 42, 41>, 0, <41, 8, 7>, 0, <6, 43, 7>, 0, <43, 42, 7>, 0, <5, 44, 43>, 0, <5, 43, 6>, 0, <4, 45, 44>, 0, <4, 44, 5>, 0, <46, 45, 4>, 0, 
			<4, 3, 46>, 0, <47, 46, 3>, 0, <3, 2, 47>, 0, <1, 32, 47>, 0, <1, 47, 2>, 0, <49, 48, 32>, 0, <32, 33, 49>, 0, <50, 49, 33>, 0, <33, 34, 50>, 0, <51, 50, 34>, 0, <34, 35, 51>, 0, 
			<36, 52, 51>, 0, <51, 35, 36>, 0, <37, 53, 52>, 0, <52, 36, 37>, 0, <38, 54, 37>, 0, <54, 53, 37>, 0, <39, 55, 38>, 0, <55, 54, 38>, 0, <40, 56, 55>, 0, <55, 39, 40>, 0, <41, 57, 56>, 0, 
			<56, 40, 41>, 0, <42, 58, 57>, 0, <57, 41, 42>, 0, <43, 59, 42>, 0, <59, 58, 42>, 0, <44, 60, 59>, 0, <44, 59, 43>, 0, <45, 61, 60>, 0, <45, 60, 44>, 0, <62, 61, 45>, 0, <45, 46, 62>, 0, 
			<63, 62, 46>, 0, <46, 47, 63>, 0, <32, 48, 63>, 0, <32, 63, 47>, 0, <17, 65, 64>, 0, <64, 16, 17>, 0, <18, 66, 17>, 0, <66, 65, 17>, 0, <19, 67, 66>, 0, <66, 18, 19>, 0, <20, 68, 67>, 0, 
			<67, 19, 20>, 0, <21, 69, 68>, 0, <68, 20, 21>, 0, <22, 70, 21>, 0, <70, 69, 21>, 0, <23, 71, 70>, 0, <23, 70, 22>, 0, <24, 72, 71>, 0, <24, 71, 23>, 0, <73, 72, 24>, 0, <24, 25, 73>, 0, 
			<74, 73, 25>, 0, <25, 26, 74>, 0, <27, 75, 74>, 0, <27, 74, 26>, 0, <28, 76, 75>, 0, <28, 75, 27>, 0, <77, 76, 28>, 0, <28, 29, 77>, 0, <78, 77, 29>, 0, <29, 30, 78>, 0, <31, 79, 78>, 0, 
			<78, 30, 31>, 0, <16, 64, 79>, 0, <79, 31, 16>, 0, <65, 81, 80>, 0, <80, 64, 65>, 0, <66, 82, 65>, 0, <82, 81, 65>, 0, <67, 83, 82>, 0, <82, 66, 67>, 0, <68, 84, 83>, 0, <83, 67, 68>, 0, 
			<69, 85, 84>, 0, <84, 68, 69>, 0, <70, 86, 69>, 0, <86, 85, 69>, 0, <71, 87, 86>, 0, <71, 86, 70>, 0, <88, 87, 71>, 0, <71, 72, 88>, 0, <89, 88, 72>, 0, <72, 73, 89>, 0, <90, 89, 73>, 0, 
			<73, 74, 90>, 0, <75, 91, 90>, 0, <75, 90, 74>, 0, <76, 92, 91>, 0, <76, 91, 75>, 0, <93, 92, 76>, 0, <76, 77, 93>, 0, <94, 93, 77>, 0, <77, 78, 94>, 0, <79, 95, 94>, 0, <94, 78, 79>, 0, 
			<64, 80, 95>, 0, <95, 79, 64>, 0}
	 normal_indices { 188, <56, 57, 58>, <58, 55, 56>, <58, 59, 55>, <59, 54, 55>, <59, 60, 54>, <60, 53, 54>, <60, 61, 53>, <61, 52, 53>, <61, 62, 52>, <62, 51, 52>, 
			<62, 63, 51>, <63, 50, 51>, <63, 48, 50>, <48, 49, 50>, <87, 88, 89>, <89, 86, 87>, <89, 90, 86>, <90, 85, 86>, <90, 91, 85>, <91, 84, 85>, <91, 92, 84>, 
			<92, 83, 84>, <92, 93, 83>, <93, 82, 83>, <93, 94, 82>, <94, 81, 82>, <94, 95, 81>, <95, 80, 81>, <16, 31, 15>, <15, 0, 16>, <31, 30, 14>, <14, 15, 31>, 
			<14, 30, 29>, <29, 13, 14>, <29, 28, 12>, <12, 13, 29>, <28, 27, 11>, <11, 12, 28>, <27, 26, 10>, <10, 11, 27>, <10, 26, 25>, <25, 9, 10>, <25, 24, 8>, 
			<8, 9, 25>, <24, 23, 7>, <7, 8, 24>, <23, 22, 6>, <6, 7, 23>, <22, 21, 5>, <5, 6, 22>, <21, 20, 4>, <4, 5, 21>, <20, 19, 3>, <3, 4, 20>, 
			<19, 18, 2>, <2, 3, 19>, <18, 17, 1>, <1, 2, 18>, <17, 16, 0>, <0, 1, 17>, <33, 32, 1>, <1, 0, 33>, <34, 33, 0>, <0, 15, 34>, <35, 34, 15>, 
			<15, 14, 35>, <13, 36, 35>, <35, 14, 13>, <12, 37, 36>, <36, 13, 12>, <11, 38, 12>, <38, 37, 12>, <10, 39, 11>, <39, 38, 11>, <9, 40, 39>, <39, 10, 9>, 
			<8, 41, 40>, <40, 9, 8>, <7, 42, 41>, <41, 8, 7>, <6, 43, 7>, <43, 42, 7>, <5, 44, 43>, <5, 43, 6>, <4, 45, 44>, <4, 44, 5>, <46, 45, 4>, 
			<4, 3, 46>, <47, 46, 3>, <3, 2, 47>, <1, 32, 47>, <1, 47, 2>, <49, 48, 32>, <32, 33, 49>, <50, 49, 33>, <33, 34, 50>, <51, 50, 34>, <34, 35, 51>, 
			<36, 52, 51>, <51, 35, 36>, <37, 53, 52>, <52, 36, 37>, <38, 54, 37>, <54, 53, 37>, <39, 55, 38>, <55, 54, 38>, <40, 56, 55>, <55, 39, 40>, <41, 57, 56>, 
			<56, 40, 41>, <42, 58, 57>, <57, 41, 42>, <43, 59, 42>, <59, 58, 42>, <44, 60, 59>, <44, 59, 43>, <45, 61, 60>, <45, 60, 44>, <62, 61, 45>, <45, 46, 62>, 
			<63, 62, 46>, <46, 47, 63>, <32, 48, 63>, <32, 63, 47>, <17, 65, 64>, <64, 16, 17>, <18, 66, 17>, <66, 65, 17>, <19, 67, 66>, <66, 18, 19>, <20, 68, 67>, 
			<67, 19, 20>, <21, 69, 68>, <68, 20, 21>, <22, 70, 21>, <70, 69, 21>, <23, 71, 70>, <23, 70, 22>, <24, 72, 71>, <24, 71, 23>, <73, 72, 24>, <24, 25, 73>, 
			<74, 73, 25>, <25, 26, 74>, <27, 75, 74>, <27, 74, 26>, <28, 76, 75>, <28, 75, 27>, <77, 76, 28>, <28, 29, 77>, <78, 77, 29>, <29, 30, 78>, <31, 79, 78>, 
			<78, 30, 31>, <16, 64, 79>, <79, 31, 16>, <65, 81, 80>, <80, 64, 65>, <66, 82, 65>, <82, 81, 65>, <67, 83, 82>, <82, 66, 67>, <68, 84, 83>, <83, 67, 68>, 
			<69, 85, 84>, <84, 68, 69>, <70, 86, 69>, <86, 85, 69>, <71, 87, 86>, <71, 86, 70>, <88, 87, 71>, <71, 72, 88>, <89, 88, 72>, <72, 73, 89>, <90, 89, 73>, 
			<73, 74, 90>, <75, 91, 90>, <75, 90, 74>, <76, 92, 91>, <76, 91, 75>, <93, 92, 76>, <76, 77, 93>, <94, 93, 77>, <77, 78, 94>, <79, 95, 94>, <94, 78, 79>, 
			<64, 80, 95>, <95, 79, 64>}
	 uv_indices { 188, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>}
}
#declare wo_24_Torso = mesh2{
	 vertex_vectors { 835, <-0.046816, 2.212021, 0.000000>, <-0.043252, 2.212021, 0.017916>, <-0.033104, 2.212021, 0.033104>, <-0.017916, 2.212021, 0.043252>, <-0.000000, 2.212021, 0.046816>, <0.017916, 2.212021, 0.043252>, <0.033104, 2.212021, 0.033104>, <0.043252, 2.212021, 0.017916>, <0.046816, 2.212021, 0.000000>, <0.043252, 2.212021, -0.017916>, 
			<0.033104, 2.212021, -0.033104>, <0.017916, 2.212021, -0.043252>, <0.000000, 2.212021, -0.046816>, <-0.017916, 2.212021, -0.043252>, <-0.033104, 2.212021, -0.033104>, <-0.043252, 2.212021, -0.017916>, <-0.084739, 2.185737, -0.000000>, <-0.078289, 2.185737, 0.032428>, <-0.059920, 2.185737, 0.059920>, <-0.032428, 2.185737, 0.078289>, <-0.000000, 2.185737, 0.084739>, 
			<0.032428, 2.185737, 0.078289>, <0.059920, 2.185737, 0.059920>, <0.078289, 2.185737, 0.032428>, <0.084739, 2.185737, 0.000000>, <0.078289, 2.185737, -0.032428>, <0.059920, 2.185737, -0.059920>, <0.032428, 2.185737, -0.078289>, <0.000000, 2.185737, -0.084739>, <-0.032428, 2.185737, -0.078289>, <-0.059920, 2.185737, -0.059920>, <-0.078289, 2.185737, -0.032428>, 
			<-0.110717, 2.146104, -0.000000>, <-0.102289, 2.146104, 0.042370>, <-0.078289, 2.146104, 0.078289>, <-0.042370, 2.146104, 0.102289>, <-0.000000, 2.146104, 0.110717>, <0.042370, 2.146104, 0.102289>, <0.078289, 2.146104, 0.078289>, <0.102289, 2.146104, 0.042370>, <0.110717, 2.146104, 0.000000>, <0.102289, 2.146104, -0.042370>, <0.078289, 2.146104, -0.078289>, 
			<0.042370, 2.146104, -0.102289>, <0.000000, 2.146104, -0.110717>, <-0.042370, 2.146104, -0.102289>, <-0.078289, 2.146104, -0.078289>, <-0.102289, 2.146104, -0.042370>, <-0.116484, 2.076564, -0.000000>, <-0.107617, 2.076564, 0.044576>, <-0.082366, 2.076564, 0.082366>, <-0.044576, 2.076564, 0.107617>, <-0.000000, 2.076564, 0.116484>, <0.044576, 2.076564, 0.107617>, 
			<0.082366, 2.076564, 0.082366>, <0.107617, 2.076564, 0.044576>, <0.116484, 2.076564, 0.000000>, <0.107617, 2.076564, -0.044576>, <0.082366, 2.076564, -0.082366>, <0.044576, 2.076564, -0.107617>, <0.000000, 2.076564, -0.116484>, <-0.044576, 2.076564, -0.107617>, <-0.082366, 2.076564, -0.082366>, <-0.107617, 2.076564, -0.044576>, <-0.107617, 2.011395, -0.000000>, 
			<-0.099425, 2.011395, 0.041183>, <-0.076097, 2.011395, 0.076097>, <-0.041183, 2.011395, 0.099425>, <-0.000000, 2.011395, 0.107617>, <0.041183, 2.011395, 0.099425>, <0.076097, 2.011395, 0.076097>, <0.099425, 2.011395, 0.041183>, <0.107617, 2.011395, 0.000000>, <0.099425, 2.011395, -0.041183>, <0.076097, 2.011395, -0.076097>, <0.041183, 2.011395, -0.099425>, 
			<0.000000, 2.011395, -0.107617>, <-0.041183, 2.011395, -0.099425>, <-0.076097, 2.011395, -0.076097>, <-0.099425, 2.011395, -0.041183>, <-0.082366, 1.938636, -0.000000>, <-0.076097, 1.938636, 0.031520>, <-0.058242, 1.938636, 0.058242>, <-0.031520, 1.938636, 0.076097>, <-0.000000, 1.938636, 0.082366>, <0.031520, 1.938636, 0.076097>, <0.058242, 1.938636, 0.058242>, 
			<0.076097, 1.938636, 0.031520>, <0.082366, 1.938636, 0.000000>, <0.076097, 1.938636, -0.031520>, <0.058242, 1.938636, -0.058242>, <0.031520, 1.938636, -0.076097>, <0.000000, 1.938636, -0.082366>, <-0.031520, 1.938636, -0.076097>, <-0.058242, 1.938636, -0.058242>, <-0.076097, 1.938636, -0.031520>, <-0.000000, 2.222900, 0.000000>, <-0.046881, 2.211824, 0.009325>, 
			<-0.046881, 2.211824, -0.009325>, <-0.066567, 2.200910, -0.000000>, <-0.027195, 2.218358, 0.000000>, <-0.039744, 2.211824, 0.026556>, <-0.061499, 2.200910, 0.025474>, <-0.025125, 2.218358, 0.010407>, <-0.026556, 2.211824, 0.039744>, <-0.047070, 2.200910, 0.047070>, <-0.019230, 2.218358, 0.019230>, <-0.009325, 2.211824, 0.046881>, <-0.025474, 2.200910, 0.061499>, 
			<-0.010407, 2.218358, 0.025125>, <0.009325, 2.211824, 0.046881>, <-0.000000, 2.200910, 0.066567>, <-0.000000, 2.218358, 0.027195>, <0.026556, 2.211824, 0.039744>, <0.025474, 2.200910, 0.061499>, <0.010407, 2.218358, 0.025125>, <0.039744, 2.211824, 0.026556>, <0.047070, 2.200910, 0.047070>, <0.019230, 2.218358, 0.019230>, <0.046881, 2.211824, 0.009325>, 
			<0.061499, 2.200910, 0.025474>, <0.025125, 2.218358, 0.010407>, <0.046881, 2.211824, -0.009325>, <0.066567, 2.200910, 0.000000>, <0.027195, 2.218358, 0.000000>, <0.039744, 2.211824, -0.026556>, <0.061499, 2.200910, -0.025474>, <0.025125, 2.218358, -0.010407>, <0.026556, 2.211824, -0.039744>, <0.047070, 2.200910, -0.047070>, <0.019230, 2.218358, -0.019230>, 
			<0.009325, 2.211824, -0.046881>, <0.025474, 2.200910, -0.061499>, <0.010407, 2.218358, -0.025125>, <-0.009325, 2.211824, -0.046881>, <0.000000, 2.200910, -0.066567>, <0.000000, 2.218358, -0.027195>, <-0.026556, 2.211824, -0.039744>, <-0.025474, 2.200910, -0.061499>, <-0.010407, 2.218358, -0.025125>, <-0.039744, 2.211824, -0.026556>, <-0.047070, 2.200910, -0.047070>, 
			<-0.019230, 2.218358, -0.019230>, <-0.061499, 2.200910, -0.025474>, <-0.025125, 2.218358, -0.010407>, <-0.083095, 2.185737, 0.016529>, <-0.083095, 2.185737, -0.016529>, <-0.099624, 2.167212, -0.000000>, <-0.070445, 2.185737, 0.047070>, <-0.092040, 2.167212, 0.038124>, <-0.047070, 2.185737, 0.070445>, <-0.070445, 2.167212, 0.070445>, <-0.016529, 2.185737, 0.083095>, 
			<-0.038124, 2.167212, 0.092040>, <0.016529, 2.185737, 0.083095>, <-0.000000, 2.167212, 0.099624>, <0.047070, 2.185737, 0.070445>, <0.038124, 2.167212, 0.092040>, <0.070445, 2.185737, 0.047070>, <0.070445, 2.167212, 0.070445>, <0.083095, 2.185737, 0.016529>, <0.092040, 2.167212, 0.038124>, <0.083095, 2.185737, -0.016529>, <0.099624, 2.167212, 0.000000>, 
			<0.070445, 2.185737, -0.047070>, <0.092040, 2.167212, -0.038124>, <0.047070, 2.185737, -0.070445>, <0.070445, 2.167212, -0.070445>, <0.016529, 2.185737, -0.083095>, <0.038124, 2.167212, -0.092040>, <-0.016529, 2.185737, -0.083095>, <0.000000, 2.167212, -0.099624>, <-0.047070, 2.185737, -0.070445>, <-0.038124, 2.167212, -0.092040>, <-0.070445, 2.185737, -0.047070>, 
			<-0.070445, 2.167212, -0.070445>, <-0.092040, 2.167212, -0.038124>, <-0.108569, 2.146104, 0.021596>, <-0.108569, 2.146104, -0.021596>, <-0.117514, 2.123182, -0.000000>, <-0.092040, 2.146104, 0.061499>, <-0.108569, 2.123182, 0.044971>, <-0.061499, 2.146104, 0.092040>, <-0.083095, 2.123182, 0.083095>, <-0.021596, 2.146104, 0.108569>, <-0.044971, 2.123182, 0.108569>, 
			<0.021596, 2.146104, 0.108569>, <-0.000000, 2.123182, 0.117514>, <0.061499, 2.146104, 0.092040>, <0.044971, 2.123182, 0.108569>, <0.092040, 2.146104, 0.061499>, <0.083095, 2.123182, 0.083095>, <0.108569, 2.146104, 0.021596>, <0.108569, 2.123182, 0.044971>, <0.108569, 2.146104, -0.021596>, <0.117514, 2.123182, 0.000000>, <0.092040, 2.146104, -0.061499>, 
			<0.108569, 2.123182, -0.044971>, <0.061499, 2.146104, -0.092040>, <0.083095, 2.123182, -0.083095>, <0.021596, 2.146104, -0.108569>, <0.044971, 2.123182, -0.108569>, <-0.021596, 2.146104, -0.108569>, <0.000000, 2.123182, -0.117514>, <-0.061499, 2.146104, -0.092040>, <-0.044971, 2.123182, -0.108569>, <-0.092040, 2.146104, -0.061499>, <-0.083095, 2.123182, -0.083095>, 
			<-0.108569, 2.123182, -0.044971>, <-0.114224, 2.076564, 0.022721>, <-0.114224, 2.076564, -0.022721>, <-0.114224, 2.043347, -0.000000>, <-0.096834, 2.076564, 0.064703>, <-0.105529, 2.043347, 0.043712>, <-0.064703, 2.076564, 0.096834>, <-0.080769, 2.043347, 0.080769>, <-0.022721, 2.076564, 0.114224>, <-0.043712, 2.043347, 0.105529>, <0.022721, 2.076564, 0.114224>, 
			<-0.000000, 2.043347, 0.114224>, <0.064703, 2.076564, 0.096834>, <0.043712, 2.043347, 0.105529>, <0.096834, 2.076564, 0.064703>, <0.080769, 2.043347, 0.080769>, <0.114224, 2.076564, 0.022721>, <0.105529, 2.043347, 0.043712>, <0.114224, 2.076564, -0.022721>, <0.114224, 2.043347, 0.000000>, <0.096834, 2.076564, -0.064703>, <0.105529, 2.043347, -0.043712>, 
			<0.064703, 2.076564, -0.096834>, <0.080769, 2.043347, -0.080769>, <0.022721, 2.076564, -0.114224>, <0.043712, 2.043347, -0.105529>, <-0.022721, 2.076564, -0.114224>, <0.000000, 2.043347, -0.114224>, <-0.064703, 2.076564, -0.096834>, <-0.043712, 2.043347, -0.105529>, <-0.096834, 2.076564, -0.064703>, <-0.080769, 2.043347, -0.080769>, <-0.105529, 2.043347, -0.043712>, 
			<-0.105529, 2.011395, 0.020991>, <-0.105529, 2.011395, -0.020991>, <-0.096834, 1.981970, -0.000000>, <-0.089463, 2.011395, 0.059777>, <-0.089463, 1.981970, 0.037057>, <-0.059777, 2.011395, 0.089463>, <-0.068472, 1.981970, 0.068472>, <-0.020991, 2.011395, 0.105529>, <-0.037057, 1.981970, 0.089463>, <0.020991, 2.011395, 0.105529>, <-0.000000, 1.981970, 0.096834>, 
			<0.059777, 2.011395, 0.089463>, <0.037057, 1.981970, 0.089463>, <0.089463, 2.011395, 0.059777>, <0.068472, 1.981970, 0.068472>, <0.105529, 2.011395, 0.020991>, <0.089463, 1.981970, 0.037057>, <0.105529, 2.011395, -0.020991>, <0.096834, 1.981970, 0.000000>, <0.089463, 2.011395, -0.059777>, <0.089463, 1.981970, -0.037057>, <0.059777, 2.011395, -0.089463>, 
			<0.068472, 1.981970, -0.068472>, <0.020991, 2.011395, -0.105529>, <0.037057, 1.981970, -0.089463>, <-0.020991, 2.011395, -0.105529>, <0.000000, 1.981970, -0.096834>, <-0.059777, 2.011395, -0.089463>, <-0.037057, 1.981970, -0.089463>, <-0.089463, 2.011395, -0.059777>, <-0.068472, 1.981970, -0.068472>, <-0.089463, 1.981970, -0.037057>, <-0.080769, 1.938636, 0.016066>, 
			<-0.080769, 1.938636, -0.016066>, <-0.064703, 1.894284, -0.000000>, <-0.068472, 1.938636, 0.045752>, <-0.059777, 1.894284, 0.024761>, <-0.045752, 1.938636, 0.068472>, <-0.045752, 1.894284, 0.045752>, <-0.016066, 1.938636, 0.080769>, <-0.024761, 1.894284, 0.059777>, <0.016066, 1.938636, 0.080769>, <-0.000000, 1.894284, 0.064703>, <0.045752, 1.938636, 0.068472>, 
			<0.024761, 1.894284, 0.059777>, <0.068472, 1.938636, 0.045752>, <0.045752, 1.894284, 0.045752>, <0.080769, 1.938636, 0.016066>, <0.059777, 1.894284, 0.024761>, <0.080769, 1.938636, -0.016066>, <0.064703, 1.894284, 0.000000>, <0.068472, 1.938636, -0.045752>, <0.059777, 1.894284, -0.024761>, <0.045752, 1.938636, -0.068472>, <0.045752, 1.894284, -0.045752>, 
			<0.016066, 1.938636, -0.080769>, <0.024761, 1.894284, -0.059777>, <-0.016066, 1.938636, -0.080769>, <0.000000, 1.894284, -0.064703>, <-0.045752, 1.938636, -0.068472>, <-0.024761, 1.894284, -0.059777>, <-0.068472, 1.938636, -0.045752>, <-0.045752, 1.894284, -0.045752>, <-0.059777, 1.894284, -0.024761>, <-0.030562, 2.217568, 0.006079>, <-0.025909, 2.217568, 0.017312>, 
			<-0.017312, 2.217568, 0.025909>, <-0.006079, 2.217568, 0.030562>, <0.006079, 2.217568, 0.030562>, <0.017312, 2.217568, 0.025909>, <0.025909, 2.217568, 0.017312>, <0.030562, 2.217568, 0.006079>, <0.030562, 2.217568, -0.006079>, <0.025909, 2.217568, -0.017312>, <0.017312, 2.217568, -0.025909>, <0.006079, 2.217568, -0.030562>, <-0.006079, 2.217568, -0.030562>, 
			<-0.017312, 2.217568, -0.025909>, <-0.025909, 2.217568, -0.017312>, <-0.030562, 2.217568, -0.006079>, <-0.065275, 2.200910, 0.012984>, <-0.055338, 2.200910, 0.036975>, <-0.036975, 2.200910, 0.055338>, <-0.012984, 2.200910, 0.065275>, <0.012984, 2.200910, 0.065275>, <0.036975, 2.200910, 0.055338>, <0.055338, 2.200910, 0.036975>, <0.065275, 2.200910, 0.012984>, 
			<0.065275, 2.200910, -0.012984>, <0.055338, 2.200910, -0.036975>, <0.036975, 2.200910, -0.055338>, <0.012984, 2.200910, -0.065275>, <-0.012984, 2.200910, -0.065275>, <-0.036975, 2.200910, -0.055338>, <-0.055338, 2.200910, -0.036975>, <-0.065275, 2.200910, -0.012984>, <-0.097691, 2.167212, 0.019432>, <-0.082819, 2.167212, 0.055338>, <-0.055338, 2.167212, 0.082819>, 
			<-0.019432, 2.167212, 0.097691>, <0.019432, 2.167212, 0.097691>, <0.055338, 2.167212, 0.082819>, <0.082819, 2.167212, 0.055338>, <0.097691, 2.167212, 0.019432>, <0.097691, 2.167212, -0.019432>, <0.082819, 2.167212, -0.055338>, <0.055338, 2.167212, -0.082819>, <0.019432, 2.167212, -0.097691>, <-0.019432, 2.167212, -0.097691>, <-0.055338, 2.167212, -0.082819>, 
			<-0.082819, 2.167212, -0.055338>, <-0.097691, 2.167212, -0.019432>, <-0.115235, 2.123182, 0.022922>, <-0.097691, 2.123182, 0.065275>, <-0.065275, 2.123182, 0.097691>, <-0.022922, 2.123182, 0.115235>, <0.022922, 2.123182, 0.115235>, <0.065275, 2.123182, 0.097691>, <0.097691, 2.123182, 0.065275>, <0.115235, 2.123182, 0.022922>, <0.115235, 2.123182, -0.022922>, 
			<0.097691, 2.123182, -0.065275>, <0.065275, 2.123182, -0.097691>, <0.022922, 2.123182, -0.115235>, <-0.022922, 2.123182, -0.115235>, <-0.065275, 2.123182, -0.097691>, <-0.097691, 2.123182, -0.065275>, <-0.115235, 2.123182, -0.022922>, <-0.112008, 2.043347, 0.022280>, <-0.094956, 2.043347, 0.063448>, <-0.063448, 2.043347, 0.094956>, <-0.022280, 2.043347, 0.112008>, 
			<0.022280, 2.043347, 0.112008>, <0.063448, 2.043347, 0.094956>, <0.094956, 2.043347, 0.063448>, <0.112008, 2.043347, 0.022280>, <0.112008, 2.043347, -0.022280>, <0.094956, 2.043347, -0.063448>, <0.063448, 2.043347, -0.094956>, <0.022280, 2.043347, -0.112008>, <-0.022280, 2.043347, -0.112008>, <-0.063448, 2.043347, -0.094956>, <-0.094956, 2.043347, -0.063448>, 
			<-0.112008, 2.043347, -0.022280>, <-0.094956, 1.981970, 0.018888>, <-0.080500, 1.981970, 0.053788>, <-0.053788, 1.981970, 0.080500>, <-0.018888, 1.981970, 0.094956>, <0.018888, 1.981970, 0.094956>, <0.053788, 1.981970, 0.080500>, <0.080500, 1.981970, 0.053788>, <0.094956, 1.981970, 0.018888>, <0.094956, 1.981970, -0.018888>, <0.080500, 1.981970, -0.053788>, 
			<0.053788, 1.981970, -0.080500>, <0.018888, 1.981970, -0.094956>, <-0.018888, 1.981970, -0.094956>, <-0.053788, 1.981970, -0.080500>, <-0.080500, 1.981970, -0.053788>, <-0.094956, 1.981970, -0.018888>, <-0.063448, 1.894284, 0.012620>, <-0.053788, 1.894284, 0.035940>, <-0.035940, 1.894284, 0.053788>, <-0.012620, 1.894284, 0.063448>, <0.012620, 1.894284, 0.063448>, 
			<0.035940, 1.894284, 0.053788>, <0.053788, 1.894284, 0.035940>, <0.063448, 1.894284, 0.012620>, <0.063448, 1.894284, -0.012620>, <0.053788, 1.894284, -0.035940>, <0.035940, 1.894284, -0.053788>, <0.012620, 1.894284, -0.063448>, <-0.012620, 1.894284, -0.063448>, <-0.035940, 1.894284, -0.053788>, <-0.053788, 1.894284, -0.035940>, <-0.063448, 1.894284, -0.012620>, 
			<-0.063448, 1.834781, -0.012620>, <-0.064703, 1.834781, -0.000000>, <-0.063448, 1.834781, 0.012620>, <-0.059777, 1.834781, 0.024761>, <-0.053788, 1.834781, 0.035940>, <-0.045752, 1.834781, 0.045752>, <-0.035940, 1.834781, 0.053788>, <-0.024761, 1.834781, 0.059777>, <-0.012620, 1.834781, 0.063448>, <-0.000000, 1.834781, 0.064703>, <0.012620, 1.834781, 0.063448>, 
			<0.024761, 1.834781, 0.059777>, <0.035940, 1.834781, 0.053788>, <0.045752, 1.834781, 0.045752>, <0.053788, 1.834781, 0.035940>, <0.059777, 1.834781, 0.024761>, <0.063448, 1.834781, 0.012620>, <0.064703, 1.834781, 0.000000>, <0.063448, 1.834781, -0.012620>, <0.059777, 1.834781, -0.024761>, <0.053788, 1.834781, -0.035940>, <0.045752, 1.834781, -0.045752>, 
			<0.035940, 1.834781, -0.053788>, <0.024761, 1.834781, -0.059777>, <0.012620, 1.834781, -0.063448>, <0.000000, 1.834781, -0.064703>, <-0.012620, 1.834781, -0.063448>, <-0.024761, 1.834781, -0.059777>, <-0.035940, 1.834781, -0.053788>, <-0.045752, 1.834781, -0.045752>, <-0.053788, 1.834781, -0.035940>, <-0.059777, 1.834781, -0.024761>, <-0.075941, 1.817590, -0.000000>, 
			<-0.070161, 1.817590, 0.029061>, <-0.053699, 1.817590, 0.053699>, <-0.029061, 1.817590, 0.070161>, <-0.000000, 1.817590, 0.075941>, <0.029061, 1.817590, 0.070161>, <0.053699, 1.817590, 0.053699>, <0.070161, 1.817590, 0.029061>, <0.075941, 1.817590, 0.000000>, <0.070161, 1.817590, -0.029061>, <0.053699, 1.817590, -0.053699>, <0.029061, 1.817590, -0.070161>, 
			<0.000000, 1.817590, -0.075941>, <-0.029061, 1.817590, -0.070161>, <-0.053699, 1.817590, -0.053699>, <-0.070161, 1.817590, -0.029061>, <-0.112963, 1.076686, -0.000000>, <-0.104364, 1.076686, 0.026551>, <-0.079877, 1.076686, 0.039779>, <-0.035275, 1.076686, 0.034094>, <0.000000, 1.076686, 0.006755>, <0.035275, 1.076686, 0.034094>, <0.079877, 1.076686, 0.039779>, 
			<0.104364, 1.076686, 0.026551>, <0.112963, 1.076686, 0.000000>, <0.104364, 1.076686, -0.026551>, <0.079877, 1.076686, -0.039779>, <0.035275, 1.076686, -0.034094>, <0.000000, 1.076686, -0.006755>, <-0.035275, 1.076686, -0.034094>, <-0.079877, 1.076686, -0.039779>, <-0.104364, 1.076686, -0.026551>, <-0.074233, 1.817590, 0.014766>, <-0.074233, 1.817590, -0.014766>, 
			<-0.098765, 1.369767, -0.000000>, <-0.062932, 1.817590, 0.042050>, <-0.091247, 1.369767, 0.037796>, <-0.042050, 1.817590, 0.062932>, <-0.069837, 1.369767, 0.069837>, <-0.014766, 1.817590, 0.074233>, <-0.037796, 1.369767, 0.091247>, <0.014766, 1.817590, 0.074233>, <-0.000000, 1.369767, 0.098765>, <0.042050, 1.817590, 0.062932>, <0.037796, 1.369767, 0.091247>, 
			<0.062932, 1.817590, 0.042050>, <0.069837, 1.369767, 0.069837>, <0.074233, 1.817590, 0.014766>, <0.091247, 1.369767, 0.037796>, <0.074233, 1.817590, -0.014766>, <0.098765, 1.369767, 0.000000>, <0.062932, 1.817590, -0.042050>, <0.091247, 1.369767, -0.037796>, <0.042050, 1.817590, -0.062932>, <0.069837, 1.369767, -0.069837>, <0.014766, 1.817590, -0.074233>, 
			<0.037796, 1.369767, -0.091247>, <-0.014766, 1.817590, -0.074233>, <0.000000, 1.369767, -0.098765>, <-0.042050, 1.817590, -0.062932>, <-0.037796, 1.369767, -0.091247>, <-0.062932, 1.817590, -0.042050>, <-0.069837, 1.369767, -0.069837>, <-0.091247, 1.369767, -0.037796>, <-0.110771, 1.076686, 0.018288>, <-0.110771, 1.076686, -0.018288>, <-0.093907, 1.076686, 0.038539>, 
			<-0.062747, 1.076686, 0.040499>, <-0.022034, 1.076686, 0.036960>, <0.022034, 1.076686, 0.036960>, <0.062747, 1.076686, 0.040499>, <0.093907, 1.076686, 0.038539>, <0.110771, 1.076686, 0.018288>, <0.110771, 1.076686, -0.018288>, <0.093907, 1.076686, -0.038539>, <0.062747, 1.076686, -0.040499>, <0.022034, 1.076686, -0.036960>, <-0.022034, 1.076686, -0.036960>, 
			<-0.062747, 1.076686, -0.040499>, <-0.093907, 1.076686, -0.038539>, <-0.096849, 1.369767, -0.019264>, <-0.082105, 1.369767, -0.054860>, <-0.054860, 1.369767, -0.082105>, <-0.019264, 1.369767, -0.096849>, <0.019264, 1.369767, -0.096849>, <0.054860, 1.369767, -0.082105>, <0.082105, 1.369767, -0.054860>, <0.096849, 1.369767, -0.019264>, <0.096849, 1.369767, 0.019264>, 
			<0.082105, 1.369767, 0.054860>, <0.054860, 1.369767, 0.082105>, <0.019264, 1.369767, 0.096849>, <-0.019264, 1.369767, 0.096849>, <-0.054860, 1.369767, 0.082105>, <-0.082105, 1.369767, 0.054860>, <-0.096849, 1.369767, 0.019264>, <-0.141648, 1.208772, 0.023386>, <-0.144852, 1.575201, 0.028813>, <-0.120084, 1.208772, 0.066597>, <-0.122799, 1.575201, 0.082052>, 
			<-0.080237, 1.208772, 0.099669>, <-0.082052, 1.575201, 0.122799>, <-0.028176, 1.208772, 0.117568>, <-0.028813, 1.575201, 0.144852>, <0.028176, 1.208772, 0.117568>, <0.028813, 1.575201, 0.144852>, <0.080237, 1.208772, 0.099669>, <0.082052, 1.575201, 0.122799>, <0.120084, 1.208772, 0.066597>, <0.122799, 1.575201, 0.082052>, <0.141648, 1.208772, 0.023386>, 
			<0.144852, 1.575201, 0.028813>, <0.141648, 1.208772, -0.023386>, <0.144852, 1.575201, -0.028813>, <0.120084, 1.208772, -0.066597>, <0.122799, 1.575201, -0.082052>, <0.080237, 1.208772, -0.099669>, <0.082052, 1.575201, -0.122799>, <0.028176, 1.208772, -0.117568>, <0.028813, 1.575201, -0.144852>, <-0.028176, 1.208772, -0.117568>, <-0.028813, 1.575201, -0.144852>, 
			<-0.080237, 1.208772, -0.099669>, <-0.082052, 1.575201, -0.122799>, <-0.120084, 1.208772, -0.066597>, <-0.122799, 1.575201, -0.082052>, <-0.141648, 1.208772, -0.023386>, <-0.144852, 1.575201, -0.028813>, <-0.133455, 1.208772, -0.045881>, <-0.102142, 1.208772, -0.084778>, <-0.055279, 1.208772, -0.110767>, <0.000000, 1.208772, -0.119894>, <0.055279, 1.208772, -0.110767>, 
			<0.102142, 1.208772, -0.084778>, <0.133455, 1.208772, -0.045881>, <0.144450, 1.208772, 0.000000>, <0.133455, 1.208772, 0.045881>, <0.102142, 1.208772, 0.084778>, <0.055279, 1.208772, 0.110767>, <-0.000000, 1.208772, 0.119894>, <-0.055279, 1.208772, 0.110767>, <-0.102142, 1.208772, 0.084778>, <-0.133455, 1.208772, 0.045881>, <-0.144450, 1.208772, -0.000000>, 
			<-0.136473, 1.575201, -0.056529>, <-0.104452, 1.575201, -0.104452>, <-0.056529, 1.575201, -0.136473>, <0.000000, 1.575201, -0.147717>, <0.056529, 1.575201, -0.136473>, <0.104452, 1.575201, -0.104452>, <0.136473, 1.575201, -0.056529>, <0.147717, 1.575201, 0.000000>, <0.136473, 1.575201, 0.056529>, <0.104452, 1.575201, 0.104452>, <0.056529, 1.575201, 0.136473>, 
			<-0.000000, 1.575201, 0.147717>, <-0.056529, 1.575201, 0.136473>, <-0.104452, 1.575201, 0.104452>, <-0.136473, 1.575201, 0.056529>, <-0.147717, 1.575201, -0.000000>, <-0.104297, 1.456453, -0.000000>, <-0.096358, 1.456453, 0.039913>, <-0.073749, 1.456453, 0.073749>, <-0.039913, 1.456453, 0.096358>, <-0.000000, 1.456453, 0.104297>, <0.039913, 1.456453, 0.096358>, 
			<0.073749, 1.456453, 0.073749>, <0.096358, 1.456453, 0.039913>, <0.104297, 1.456453, 0.000000>, <0.096358, 1.456453, -0.039913>, <0.073749, 1.456453, -0.073749>, <0.039913, 1.456453, -0.096358>, <0.000000, 1.456453, -0.104297>, <-0.039913, 1.456453, -0.096358>, <-0.073749, 1.456453, -0.073749>, <-0.096358, 1.456453, -0.039913>, <-0.142011, 1.140102, -0.000000>, 
			<-0.131201, 1.140102, 0.045106>, <-0.100417, 1.140102, 0.083346>, <-0.054345, 1.140102, 0.108897>, <-0.000000, 1.140102, 0.117869>, <0.054345, 1.140102, 0.108897>, <0.100417, 1.140102, 0.083346>, <0.131201, 1.140102, 0.045106>, <0.142011, 1.140102, 0.000000>, <0.131201, 1.140102, -0.045106>, <0.100417, 1.140102, -0.083346>, <0.054345, 1.140102, -0.108897>, 
			<0.000000, 1.140102, -0.117869>, <-0.054345, 1.140102, -0.108897>, <-0.100417, 1.140102, -0.083346>, <-0.131201, 1.140102, -0.045106>, <-0.102273, 1.456453, -0.020343>, <-0.129036, 1.299153, -0.021303>, <-0.086703, 1.456453, -0.057933>, <-0.109391, 1.299153, -0.060667>, <-0.057933, 1.456453, -0.086703>, <-0.073093, 1.299153, -0.090795>, <-0.020343, 1.456453, -0.102273>, 
			<-0.025667, 1.299153, -0.107100>, <0.020343, 1.456453, -0.102273>, <0.025667, 1.299153, -0.107100>, <0.057933, 1.456453, -0.086703>, <0.073093, 1.299153, -0.090795>, <0.086703, 1.456453, -0.057933>, <0.109391, 1.299153, -0.060667>, <0.102273, 1.456453, -0.020343>, <0.129036, 1.299153, -0.021303>, <0.102273, 1.456453, 0.020343>, <0.129036, 1.299153, 0.021303>, 
			<0.086703, 1.456453, 0.057933>, <0.109391, 1.299153, 0.060667>, <0.057933, 1.456453, 0.086703>, <0.073093, 1.299153, 0.090795>, <0.020343, 1.456453, 0.102273>, <0.025667, 1.299153, 0.107100>, <-0.020343, 1.456453, 0.102273>, <-0.025667, 1.299153, 0.107100>, <-0.057933, 1.456453, 0.086703>, <-0.073093, 1.299153, 0.090795>, <-0.086703, 1.456453, 0.057933>, 
			<-0.109391, 1.299153, 0.060667>, <-0.102273, 1.456453, 0.020343>, <-0.129036, 1.299153, 0.021303>, <-0.139256, 1.140102, 0.022991>, <-0.118055, 1.140102, 0.065472>, <-0.078882, 1.140102, 0.097986>, <-0.027700, 1.140102, 0.115582>, <0.027700, 1.140102, 0.115582>, <0.078882, 1.140102, 0.097986>, <0.118055, 1.140102, 0.065472>, <0.139256, 1.140102, 0.022991>, 
			<0.139256, 1.140102, -0.022991>, <0.118055, 1.140102, -0.065472>, <0.078882, 1.140102, -0.097986>, <0.027700, 1.140102, -0.115582>, <-0.027700, 1.140102, -0.115582>, <-0.078882, 1.140102, -0.097986>, <-0.118055, 1.140102, -0.065472>, <-0.139256, 1.140102, -0.022991>, <-0.121572, 1.299153, -0.041796>, <-0.093047, 1.299153, -0.077229>, <-0.050357, 1.299153, -0.100905>, 
			<0.000000, 1.299153, -0.109219>, <0.050357, 1.299153, -0.100905>, <0.093047, 1.299153, -0.077229>, <0.121572, 1.299153, -0.041796>, <0.131589, 1.299153, 0.000000>, <0.121572, 1.299153, 0.041796>, <0.093047, 1.299153, 0.077229>, <0.050357, 1.299153, 0.100905>, <-0.000000, 1.299153, 0.109219>, <-0.050357, 1.299153, 0.100905>, <-0.093047, 1.299153, 0.077229>, 
			<-0.121572, 1.299153, 0.041796>, <-0.131589, 1.299153, -0.000000>, <-0.156686, 1.748824, 0.031167>, <-0.134174, 1.789440, 0.026689>, <-0.132832, 1.748824, 0.088756>, <-0.113747, 1.789440, 0.076003>, <-0.088756, 1.748824, 0.132832>, <-0.076003, 1.789440, 0.113747>, <-0.031167, 1.748824, 0.156686>, <-0.026689, 1.789440, 0.134174>, <0.031167, 1.748824, 0.156686>, 
			<0.026689, 1.789440, 0.134174>, <0.088756, 1.748824, 0.132832>, <0.076003, 1.789440, 0.113747>, <0.132832, 1.748824, 0.088756>, <0.113747, 1.789440, 0.076003>, <0.156686, 1.748824, 0.031167>, <0.134174, 1.789440, 0.026689>, <0.156686, 1.748824, -0.031167>, <0.134174, 1.789440, -0.026689>, <0.132832, 1.748824, -0.088756>, <0.113747, 1.789440, -0.076003>, 
			<0.088756, 1.748824, -0.132832>, <0.076003, 1.789440, -0.113747>, <0.031167, 1.748824, -0.156686>, <0.026689, 1.789440, -0.134174>, <-0.031167, 1.748824, -0.156686>, <-0.026689, 1.789440, -0.134174>, <-0.088756, 1.748824, -0.132832>, <-0.076003, 1.789440, -0.113747>, <-0.132832, 1.748824, -0.088756>, <-0.113747, 1.789440, -0.076003>, <-0.156686, 1.748824, -0.031167>, 
			<-0.134174, 1.789440, -0.026689>, <-0.147623, 1.748824, -0.061147>, <-0.126437, 1.789471, -0.052372>, <-0.112986, 1.748824, -0.112986>, <-0.096771, 1.789471, -0.096771>, <-0.061147, 1.748824, -0.147623>, <-0.052372, 1.789471, -0.126437>, <0.000000, 1.748824, -0.159786>, <0.000000, 1.789471, -0.136854>, <0.061147, 1.748824, -0.147623>, <0.052372, 1.789471, -0.126437>, 
			<0.112986, 1.748824, -0.112986>, <0.096771, 1.789471, -0.096771>, <0.147623, 1.748824, -0.061147>, <0.126437, 1.789471, -0.052372>, <0.159786, 1.748824, 0.000000>, <0.136854, 1.789471, 0.000000>, <0.147623, 1.748824, 0.061147>, <0.126437, 1.789471, 0.052372>, <0.112986, 1.748824, 0.112986>, <0.096771, 1.789471, 0.096771>, <0.061147, 1.748824, 0.147623>, 
			<0.052372, 1.789471, 0.126437>, <-0.000000, 1.748824, 0.159786>, <-0.000000, 1.789471, 0.136854>, <-0.061147, 1.748824, 0.147623>, <-0.052372, 1.789471, 0.126437>, <-0.112986, 1.748824, 0.112986>, <-0.096771, 1.789471, 0.096771>, <-0.147623, 1.748824, 0.061147>, <-0.126437, 1.789471, 0.052372>, <-0.159786, 1.748824, -0.000000>, <-0.136854, 1.789471, -0.000000>, 
			<-0.161439, 1.662012, -0.000000>, <-0.149150, 1.662012, 0.061780>, <-0.114155, 1.662012, 0.114155>, <-0.061780, 1.662012, 0.149150>, <-0.000000, 1.662012, 0.161439>, <0.061780, 1.662012, 0.149150>, <0.114155, 1.662012, 0.114155>, <0.149150, 1.662012, 0.061780>, <0.161439, 1.662012, 0.000000>, <0.149150, 1.662012, -0.061780>, <0.114155, 1.662012, -0.114155>, 
			<0.061780, 1.662012, -0.149150>, <0.000000, 1.662012, -0.161439>, <-0.061780, 1.662012, -0.149150>, <-0.114155, 1.662012, -0.114155>, <-0.149150, 1.662012, -0.061780>, <-0.158307, 1.662012, -0.031489>, <-0.134207, 1.662012, -0.089674>, <-0.089674, 1.662012, -0.134207>, <-0.031489, 1.662012, -0.158307>, <0.031489, 1.662012, -0.158307>, <0.089674, 1.662012, -0.134207>, 
			<0.134207, 1.662012, -0.089674>, <0.158307, 1.662012, -0.031489>, <0.158307, 1.662012, 0.031489>, <0.134207, 1.662012, 0.089674>, <0.089674, 1.662012, 0.134207>, <0.031489, 1.662012, 0.158307>, <-0.031489, 1.662012, 0.158307>, <-0.089674, 1.662012, 0.134207>, <-0.134207, 1.662012, 0.089674>, <-0.158307, 1.662012, 0.031489>, <-0.010150, 1.061447, 0.006755>, 
			<-0.010150, 1.061447, -0.006755>, <-0.022034, 1.061447, -0.036960>, <-0.035275, 1.061447, -0.034094>, <-0.062747, 1.061447, -0.040499>, <-0.079877, 1.061447, -0.039779>, <-0.093907, 1.061447, -0.038539>, <-0.104364, 1.061447, -0.026551>, <-0.110771, 1.061447, -0.018288>, <-0.112963, 1.061447, -0.000000>, <-0.110771, 1.061447, 0.018288>, <-0.104364, 1.061447, 0.026551>, 
			<-0.093907, 1.061447, 0.038539>, <-0.079877, 1.061447, 0.039779>, <-0.062747, 1.061447, 0.040499>, <-0.035275, 1.061447, 0.034094>, <-0.022034, 1.061447, 0.036960>, <0.010306, 1.061537, -0.006755>, <0.010306, 1.061537, 0.006755>, <0.022034, 1.061537, 0.036960>, <0.035275, 1.061537, 0.034094>, <0.062747, 1.061537, 0.040499>, <0.079877, 1.061537, 0.039779>, 
			<0.093907, 1.061537, 0.038539>, <0.104364, 1.061537, 0.026551>, <0.110771, 1.061537, 0.018288>, <0.112963, 1.061537, 0.000000>, <0.110771, 1.061537, -0.018288>, <0.104364, 1.061537, -0.026551>, <0.093907, 1.061537, -0.038539>, <0.079877, 1.061537, -0.039779>, <0.062747, 1.061537, -0.040499>, <0.035275, 1.061537, -0.034094>, <0.022034, 1.061537, -0.036960>}
	 //#local average_center = <0.000000, 1.777258, -0.000000>;
	 normal_vectors { 835, <0.396328, -0.918083, -0.006945>, <0.382462, -0.913125, -0.141159>, <0.290419, -0.911764, -0.290419>, <0.141159, -0.913125, -0.382462>, <-0.006945, -0.918083, -0.396328>, <-0.141159, -0.913125, -0.382462>, <-0.290419, -0.911764, -0.290419>, <-0.382462, -0.913125, -0.141159>, <-0.396328, -0.918083, -0.006945>, <-0.382462, -0.913125, 0.141159>, 
			<-0.290419, -0.911764, 0.290419>, <-0.141159, -0.913125, 0.382462>, <-0.006945, -0.918083, 0.396328>, <0.141159, -0.913125, 0.382462>, <0.290419, -0.911764, 0.290419>, <0.382462, -0.913125, 0.141159>, <0.690109, -0.723706, 0.000000>, <0.660251, -0.700448, -0.270998>, <0.520797, -0.676419, -0.520797>, <0.270998, -0.700448, -0.660251>, <-0.011122, -0.710472, -0.703637>, 
			<-0.270998, -0.700448, -0.660251>, <-0.520797, -0.676419, -0.520797>, <-0.660251, -0.700448, -0.270998>, <-0.713699, -0.700448, -0.002298>, <-0.660251, -0.700448, 0.270998>, <-0.520797, -0.676419, 0.520797>, <-0.270998, -0.700448, 0.660251>, <-0.002298, -0.700448, 0.713699>, <0.270998, -0.700448, 0.660251>, <0.520797, -0.676419, 0.520797>, <0.660251, -0.700448, 0.270998>, 
			<0.913577, -0.406665, 0.000000>, <0.855749, -0.363543, -0.368144>, <0.654190, -0.376591, -0.655907>, <0.353388, -0.376591, -0.856327>, <0.017691, -0.394629, -0.918670>, <-0.368144, -0.363543, -0.855749>, <-0.655907, -0.376591, -0.654190>, <-0.856327, -0.376591, -0.353388>, <-0.926379, -0.376591, -0.001215>, <-0.855749, -0.363543, 0.368144>, <-0.654190, -0.376591, 0.655907>, 
			<-0.353388, -0.376591, 0.856327>, <-0.001215, -0.376591, 0.926379>, <0.368144, -0.363543, 0.855749>, <0.637089, -0.394629, 0.662107>, <0.856327, -0.376591, 0.353388>, <0.998985, 0.040414, 0.019887>, <0.922957, 0.045000, -0.382264>, <0.706414, 0.045000, -0.706367>, <0.369213, 0.041726, -0.928408>, <0.019887, 0.040414, -0.998985>, <-0.382264, 0.045000, -0.922957>, 
			<-0.696166, 0.048265, -0.716257>, <-0.922931, 0.045000, -0.382327>, <-0.998985, 0.040414, -0.019887>, <-0.922957, 0.045000, 0.382264>, <-0.716257, 0.048265, 0.696166>, <-0.382327, 0.045000, 0.922931>, <-0.019887, 0.040414, 0.998985>, <0.382264, 0.045000, 0.922957>, <0.696166, 0.048265, 0.716257>, <0.922931, 0.045000, 0.382327>, <0.957401, 0.288155, 0.018725>, 
			<0.888766, 0.274041, -0.367420>, <0.680507, 0.274041, -0.679567>, <0.387508, 0.259766, -0.884511>, <0.018725, 0.288155, -0.957401>, <-0.367420, 0.274041, -0.888766>, <-0.679567, 0.274041, -0.680507>, <-0.884511, 0.259766, -0.387508>, <-0.957401, 0.288155, 0.018725>, <-0.888766, 0.274041, 0.367420>, <-0.696498, 0.259766, 0.668888>, <-0.397288, 0.273902, 0.875866>, 
			<-0.013946, 0.284137, 0.958682>, <0.367420, 0.274041, 0.888766>, <0.679567, 0.274041, 0.680507>, <0.884511, 0.259766, 0.387508>, <0.937673, 0.347256, -0.013479>, <0.876525, 0.338083, -0.342644>, <0.678679, 0.338083, -0.651993>, <0.360629, 0.334578, -0.870634>, <-0.013479, 0.347256, -0.937673>, <-0.342644, 0.338083, -0.876525>, <-0.651993, 0.338083, -0.678679>, 
			<-0.870634, 0.334578, -0.360629>, <-0.937673, 0.347256, -0.013479>, <-0.876525, 0.338083, 0.342644>, <-0.678679, 0.338083, 0.651993>, <-0.360629, 0.334578, 0.870634>, <-0.013479, 0.347256, 0.937673>, <0.360629, 0.334578, 0.870634>, <0.651993, 0.338083, 0.678679>, <0.870634, 0.334578, 0.360629>, <0.006822, -0.999953, 0.006822>, <0.381871, -0.918503, -0.102604>, 
			<0.399502, -0.911908, 0.093924>, <0.555143, -0.831749, 0.003270>, <0.236666, -0.971591, 0.000000>, <0.363028, -0.902528, -0.231631>, <0.529571, -0.821664, -0.210767>, <0.223109, -0.969804, -0.098499>, <0.231631, -0.902528, -0.363028>, <0.419242, -0.805278, -0.419242>, <0.162177, -0.974709, -0.153759>, <0.093924, -0.911908, -0.399502>, <0.210767, -0.821664, -0.529571>, 
			<0.099635, -0.966023, -0.238478>, <-0.102604, -0.918503, -0.381871>, <0.003270, -0.831749, -0.555143>, <-0.000000, -0.971591, -0.236666>, <-0.231631, -0.902528, -0.363028>, <-0.210767, -0.821664, -0.529571>, <-0.098499, -0.969804, -0.223109>, <-0.363028, -0.902528, -0.231631>, <-0.419242, -0.805278, -0.419242>, <-0.151707, -0.976714, -0.151707>, <-0.381871, -0.918503, -0.102604>, 
			<-0.529571, -0.821664, -0.210767>, <-0.223109, -0.969804, -0.098499>, <-0.399502, -0.911908, 0.093924>, <-0.569917, -0.821664, -0.007934>, <-0.236666, -0.971591, -0.000000>, <-0.363028, -0.902528, 0.231631>, <-0.529571, -0.821664, 0.210767>, <-0.238478, -0.966023, 0.099635>, <-0.231631, -0.902528, 0.363028>, <-0.419242, -0.805278, 0.419242>, <-0.153759, -0.974709, 0.162177>, 
			<-0.102604, -0.918503, 0.381871>, <-0.210767, -0.821664, 0.529571>, <-0.098499, -0.969804, 0.223109>, <0.093924, -0.911908, 0.399502>, <-0.007934, -0.821664, 0.569917>, <0.000000, -0.971591, 0.236666>, <0.231631, -0.902528, 0.363028>, <0.210767, -0.821664, 0.529571>, <0.099635, -0.966023, 0.238478>, <0.363028, -0.902528, 0.231631>, <0.419242, -0.805278, 0.419242>, 
			<0.167348, -0.971591, 0.167348>, <0.529571, -0.821664, 0.210767>, <0.238478, -0.966023, 0.099635>, <0.700490, -0.700381, -0.137039>, <0.700490, -0.700381, 0.137039>, <0.818120, -0.575048, 0.000000>, <0.594726, -0.700381, -0.394673>, <0.773249, -0.548368, -0.318399>, <0.394673, -0.700381, -0.594726>, <0.586110, -0.531996, -0.611110>, <0.137039, -0.700381, -0.700490>, 
			<0.318399, -0.548368, -0.773249>, <-0.148818, -0.714379, -0.683751>, <-0.001748, -0.548368, -0.836235>, <-0.394673, -0.700381, -0.594726>, <-0.318399, -0.548368, -0.773249>, <-0.594726, -0.700381, -0.394673>, <-0.611110, -0.531996, -0.586110>, <-0.676915, -0.723641, -0.134647>, <-0.773249, -0.548368, -0.318399>, <-0.700490, -0.700381, 0.137039>, <-0.836235, -0.548368, -0.001748>, 
			<-0.594726, -0.700381, 0.394673>, <-0.773249, -0.548368, 0.318399>, <-0.394673, -0.700381, 0.594726>, <-0.586110, -0.531996, 0.611110>, <-0.134647, -0.723641, 0.676915>, <-0.318399, -0.548368, 0.773249>, <0.137039, -0.700381, 0.700490>, <-0.001748, -0.548368, 0.836235>, <0.394673, -0.700381, 0.594726>, <0.318399, -0.548368, 0.773249>, <0.594726, -0.700381, 0.394673>, 
			<0.611110, -0.531996, 0.586110>, <0.773249, -0.548368, 0.318399>, <0.908835, -0.376531, -0.179564>, <0.908835, -0.376531, 0.179564>, <0.987837, -0.154827, -0.014369>, <0.765700, -0.358223, -0.534209>, <0.911211, -0.101644, -0.399204>, <0.513692, -0.376531, -0.770938>, <0.700368, -0.132730, -0.701332>, <0.179564, -0.376531, -0.908835>, <0.395277, -0.163632, -0.903870>, 
			<-0.166513, -0.389439, -0.905876>, <-0.014369, -0.154827, -0.987837>, <-0.534209, -0.358223, -0.765700>, <-0.399204, -0.101644, -0.911211>, <-0.770938, -0.376531, -0.513692>, <-0.701332, -0.132730, -0.700368>, <-0.896051, -0.406601, -0.178236>, <-0.915966, -0.132730, -0.378668>, <-0.908835, -0.376531, 0.179564>, <-0.990618, -0.132658, 0.032841>, <-0.765700, -0.358223, 0.534209>, 
			<-0.911211, -0.101644, 0.399204>, <-0.513692, -0.376531, 0.770938>, <-0.700368, -0.132730, 0.701332>, <-0.178236, -0.406601, 0.896051>, <-0.378668, -0.132730, 0.915966>, <0.179564, -0.376531, 0.908835>, <0.032841, -0.132658, 0.990618>, <0.534209, -0.358223, 0.765700>, <0.399204, -0.101644, 0.911211>, <0.767642, -0.363485, 0.527830>, <0.708667, -0.154827, 0.688346>, 
			<0.915966, -0.132730, 0.378668>, <0.982265, 0.048256, -0.181181>, <0.979786, 0.044991, 0.194925>, <0.990777, 0.135502, -0.000000>, <0.830646, 0.044991, -0.554980>, <0.915475, 0.135502, -0.378874>, <0.555035, 0.044991, -0.830609>, <0.700799, 0.135502, -0.700371>, <0.175726, 0.049559, -0.983191>, <0.379434, 0.135502, -0.915243>, <-0.181181, 0.048256, -0.982265>, 
			<0.000000, 0.135502, -0.990777>, <-0.538796, 0.040406, -0.841467>, <-0.378874, 0.135502, -0.915475>, <-0.830609, 0.044991, -0.555035>, <-0.712885, 0.148953, -0.685279>, <-0.979786, 0.044991, -0.194925>, <-0.915243, 0.135502, -0.379434>, <-0.982265, 0.048256, 0.181181>, <-0.990777, 0.135502, -0.000000>, <-0.841467, 0.040406, 0.538796>, <-0.915475, 0.135502, 0.378874>, 
			<-0.555035, 0.044991, 0.830609>, <-0.685279, 0.148953, 0.712885>, <-0.194925, 0.044991, 0.979786>, <-0.379434, 0.135502, 0.915243>, <0.181181, 0.048256, 0.982265>, <0.013945, 0.125845, 0.991952>, <0.538796, 0.040406, 0.841467>, <0.378874, 0.135502, 0.915475>, <0.830609, 0.044991, 0.555035>, <0.712885, 0.148953, 0.685279>, <0.915243, 0.135502, 0.379434>, 
			<0.942947, 0.284089, -0.173620>, <0.943392, 0.263817, 0.201028>, <0.943835, 0.330417, 0.000158>, <0.800012, 0.273993, -0.533768>, <0.871930, 0.330417, -0.361336>, <0.534851, 0.273993, -0.799288>, <0.667281, 0.330417, -0.667504>, <0.201028, 0.263817, -0.943392>, <0.360574, 0.334977, -0.870503>, <-0.173620, 0.284089, -0.942947>, <0.000158, 0.330417, -0.943835>, 
			<-0.533768, 0.273993, -0.800012>, <-0.361336, 0.330417, -0.871930>, <-0.799288, 0.273993, -0.534851>, <-0.667504, 0.330417, -0.667281>, <-0.943252, 0.273993, -0.187625>, <-0.870503, 0.334977, -0.360574>, <-0.943379, 0.273993, 0.186985>, <-0.943835, 0.330417, 0.000158>, <-0.800012, 0.273993, 0.533768>, <-0.871930, 0.330417, 0.361336>, <-0.560032, 0.273859, 0.781899>, 
			<-0.657317, 0.332342, 0.676375>, <-0.218182, 0.273859, 0.936695>, <-0.343504, 0.333096, 0.878096>, <0.186985, 0.273993, 0.943379>, <0.018865, 0.327618, 0.944622>, <0.533768, 0.273993, 0.800012>, <0.343504, 0.333096, 0.878096>, <0.799288, 0.273993, 0.534851>, <0.667504, 0.330417, 0.667281>, <0.870503, 0.334977, 0.360574>, <0.915520, 0.348694, -0.200590>, 
			<0.921195, 0.343424, 0.182917>, <0.988386, 0.150614, -0.020229>, <0.787011, 0.347200, -0.509966>, <0.896595, 0.215237, -0.387027>, <0.531948, 0.347200, -0.772324>, <0.680237, 0.215237, -0.700679>, <0.182917, 0.343424, -0.921195>, <0.360319, 0.215237, -0.907658>, <-0.200590, 0.348694, -0.915520>, <-0.020229, 0.150614, -0.988386>, <-0.509966, 0.347200, -0.787011>, 
			<-0.387027, 0.215237, -0.896595>, <-0.772324, 0.347200, -0.531948>, <-0.700679, 0.215237, -0.680237>, <-0.915520, 0.348694, -0.200590>, <-0.907658, 0.215237, -0.360319>, <-0.921195, 0.343424, 0.182917>, <-0.988386, 0.150614, 0.020229>, <-0.787011, 0.347200, 0.509966>, <-0.896595, 0.215237, 0.387027>, <-0.531948, 0.347200, 0.772324>, <-0.680237, 0.215237, 0.700679>, 
			<-0.200590, 0.348694, 0.915520>, <-0.360319, 0.215237, 0.907658>, <0.182917, 0.343424, 0.921195>, <0.020229, 0.150614, 0.988386>, <0.519952, 0.352295, 0.778163>, <0.387027, 0.215237, 0.896595>, <0.772324, 0.347200, 0.531948>, <0.700679, 0.215237, 0.680237>, <0.907658, 0.215237, 0.360319>, <0.253056, -0.966329, -0.046599>, <0.235404, -0.959085, -0.157292>, 
			<0.146373, -0.964669, -0.219062>, <0.046599, -0.966329, -0.253056>, <-0.046599, -0.966329, -0.253056>, <-0.157292, -0.959085, -0.235404>, <-0.235404, -0.959085, -0.157292>, <-0.253056, -0.966329, -0.046599>, <-0.253056, -0.966329, 0.046599>, <-0.219062, -0.964669, 0.146373>, <-0.157292, -0.959085, 0.235404>, <-0.046599, -0.966329, 0.253056>, <0.046599, -0.966329, 0.253056>, 
			<0.146373, -0.964669, 0.219062>, <0.219062, -0.964669, 0.146373>, <0.253056, -0.966329, 0.046599>, <0.551614, -0.828013, -0.100581>, <0.473660, -0.820225, -0.320744>, <0.320744, -0.820225, -0.473660>, <0.115067, -0.820225, -0.560349>, <-0.100581, -0.828013, -0.551614>, <-0.320744, -0.820225, -0.473660>, <-0.473660, -0.820225, -0.320744>, <-0.536162, -0.837350, -0.106649>, 
			<-0.560349, -0.820225, 0.115067>, <-0.473660, -0.820225, 0.320744>, <-0.320744, -0.820225, 0.473660>, <-0.106649, -0.837350, 0.536162>, <0.115067, -0.820225, 0.560349>, <0.320744, -0.820225, 0.473660>, <0.473660, -0.820225, 0.320744>, <0.560349, -0.820225, 0.115067>, <0.820548, -0.548296, -0.161470>, <0.695475, -0.536650, -0.477830>, <0.463189, -0.548296, -0.696296>, 
			<0.161470, -0.548296, -0.820548>, <-0.159617, -0.574975, -0.802450>, <-0.477830, -0.536650, -0.695475>, <-0.696296, -0.548296, -0.463189>, <-0.802450, -0.574975, -0.159617>, <-0.820548, -0.548296, 0.161470>, <-0.695475, -0.536650, 0.477830>, <-0.463189, -0.548296, 0.696296>, <-0.159617, -0.574975, 0.802450>, <0.161470, -0.548296, 0.820548>, <0.477830, -0.536650, 0.695475>, 
			<0.696296, -0.548296, 0.463189>, <0.820548, -0.548296, 0.161470>, <0.965324, -0.132636, -0.224850>, <0.823744, -0.132705, -0.551212>, <0.550100, -0.132705, -0.824487>, <0.207136, -0.110518, -0.972050>, <-0.224850, -0.132636, -0.965324>, <-0.551212, -0.132705, -0.823744>, <-0.824487, -0.132705, -0.550100>, <-0.971613, -0.154800, -0.178899>, <-0.965324, -0.132636, 0.224850>, 
			<-0.823744, -0.132705, 0.551212>, <-0.550100, -0.132705, 0.824487>, <-0.178899, -0.154800, 0.971613>, <0.224850, -0.132636, 0.965324>, <0.551212, -0.132705, 0.823744>, <0.837959, -0.101626, 0.536188>, <0.972241, -0.132705, 0.192709>, <0.965932, 0.148926, -0.211652>, <0.823969, 0.135477, -0.550201>, <0.550695, 0.135477, -0.823639>, <0.212721, 0.121951, -0.969473>, 
			<-0.211652, 0.148926, -0.965932>, <-0.562473, 0.125822, -0.817186>, <-0.823639, 0.135477, -0.550695>, <-0.969473, 0.121951, -0.212721>, <-0.965932, 0.148926, 0.211652>, <-0.817186, 0.125822, 0.562473>, <-0.550695, 0.135477, 0.823639>, <-0.193583, 0.135477, 0.971685>, <0.211652, 0.148926, 0.965932>, <0.562473, 0.125822, 0.817186>, <0.823639, 0.135477, 0.550695>, 
			<0.969473, 0.121951, 0.212721>, <0.927275, 0.325793, -0.184446>, <0.784701, 0.330361, -0.524506>, <0.524249, 0.330361, -0.784872>, <0.184288, 0.330361, -0.925689>, <-0.184446, 0.325793, -0.927275>, <-0.524506, 0.330361, -0.784701>, <-0.784872, 0.330361, -0.524249>, <-0.927275, 0.325793, -0.184446>, <-0.925689, 0.330361, 0.184288>, <-0.784701, 0.330361, 0.524506>, 
			<-0.498630, 0.330206, 0.801456>, <-0.171423, 0.328376, 0.928861>, <0.184288, 0.330361, 0.925689>, <0.513834, 0.328376, 0.792555>, <0.784872, 0.330361, 0.524249>, <0.925689, 0.330361, 0.184288>, <0.962994, 0.188398, -0.192738>, <0.810802, 0.150588, -0.565618>, <0.532630, 0.150588, -0.832844>, <0.160202, 0.188302, -0.968957>, <-0.192738, 0.188398, -0.962994>, 
			<-0.565618, 0.150588, -0.810802>, <-0.832844, 0.150588, -0.532630>, <-0.968957, 0.188302, -0.160202>, <-0.962994, 0.188398, 0.192738>, <-0.810802, 0.150588, 0.565618>, <-0.532630, 0.150588, 0.832844>, <-0.160202, 0.188302, 0.968957>, <0.192738, 0.188398, 0.962994>, <0.565618, 0.150588, 0.810802>, <0.832844, 0.150588, 0.532630>, <0.968957, 0.188302, 0.160202>, 
			<0.939816, -0.282543, 0.192134>, <0.958806, -0.284063, 0.000362>, <0.959533, -0.224345, -0.170193>, <0.898382, -0.283897, -0.335131>, <0.813235, -0.282429, -0.508805>, <0.679494, -0.323367, -0.658575>, <0.537161, -0.282543, -0.794750>, <0.367253, -0.284063, -0.885682>, <0.192134, -0.282543, -0.939816>, <0.000362, -0.284063, -0.958806>, <-0.170193, -0.224345, -0.959533>, 
			<-0.335131, -0.283897, -0.898382>, <-0.508805, -0.282429, -0.813235>, <-0.658575, -0.323367, -0.679494>, <-0.794750, -0.282543, -0.537161>, <-0.885682, -0.284063, -0.367253>, <-0.951623, -0.224345, -0.209960>, <-0.958246, -0.283897, -0.034175>, <-0.946042, -0.282429, 0.158863>, <-0.898382, -0.283897, 0.335131>, <-0.813235, -0.282429, 0.508805>, <-0.679494, -0.323367, 0.658575>, 
			<-0.537161, -0.282543, 0.794750>, <-0.367253, -0.284063, 0.885682>, <-0.209960, -0.224345, 0.951623>, <-0.034175, -0.283897, 0.958246>, <0.158863, -0.282429, 0.946042>, <0.335131, -0.283897, 0.898382>, <0.508805, -0.282429, 0.813235>, <0.658575, -0.323367, 0.679494>, <0.794750, -0.282543, 0.537161>, <0.885682, -0.284063, 0.367253>, <0.696582, -0.717266, 0.017399>, 
			<0.601397, -0.756571, -0.256751>, <0.408274, -0.816471, -0.408274>, <0.256751, -0.756571, -0.601397>, <0.017399, -0.717266, -0.696582>, <-0.256751, -0.756571, -0.601397>, <-0.408274, -0.816471, -0.408274>, <-0.601397, -0.756571, -0.256751>, <-0.696582, -0.717266, 0.017399>, <-0.601397, -0.756571, 0.256751>, <-0.408274, -0.816471, 0.408274>, <-0.256751, -0.756571, 0.601397>, 
			<0.017399, -0.717266, 0.696582>, <0.256751, -0.756571, 0.601397>, <0.408274, -0.816471, 0.408274>, <0.601397, -0.756571, 0.256751>, <0.985069, 0.170409, -0.024486>, <0.754765, 0.187522, -0.628621>, <0.130011, 0.333127, -0.933876>, <0.039341, 0.336578, -0.940833>, <0.179811, 0.895138, -0.407917>, <0.058637, 0.336507, -0.939854>, <-0.138176, 0.332926, -0.932774>, 
			<-0.762301, 0.187522, -0.619461>, <-0.976996, 0.213250, 0.001833>, <-0.754765, 0.187522, 0.628621>, <-0.130011, 0.333127, 0.933876>, <-0.039341, 0.336578, 0.940833>, <-0.185065, 0.893942, 0.408189>, <-0.058637, 0.336507, 0.939854>, <0.138176, 0.332926, 0.932774>, <0.762301, 0.187522, 0.619461>, <0.674013, -0.727532, -0.128077>, <0.641816, -0.754861, 0.135118>, 
			<0.975662, -0.218793, 0.014617>, <0.541253, -0.754861, -0.370445>, <0.907515, -0.158615, -0.388919>, <0.370445, -0.754861, -0.541253>, <0.692932, -0.106877, -0.713037>, <0.135118, -0.754861, -0.641816>, <0.374832, -0.058535, -0.925243>, <-0.128077, -0.727532, -0.674013>, <0.019952, -0.020475, -0.999591>, <-0.370445, -0.754861, -0.541253>, <-0.343726, -0.058488, -0.937247>, 
			<-0.541253, -0.754861, -0.370445>, <-0.668449, -0.106765, -0.736055>, <-0.674013, -0.727532, -0.128077>, <-0.893634, -0.158459, -0.419891>, <-0.641816, -0.754861, 0.135118>, <-0.975662, -0.218793, -0.014617>, <-0.541253, -0.754861, 0.370445>, <-0.907515, -0.158615, 0.388919>, <-0.370445, -0.754861, 0.541253>, <-0.692932, -0.106877, 0.713037>, <-0.128077, -0.727532, 0.674013>, 
			<-0.374832, -0.058535, 0.925243>, <0.135118, -0.754861, 0.641816>, <-0.019952, -0.020475, 0.999591>, <0.370445, -0.754861, 0.541253>, <0.343726, -0.058488, 0.937247>, <0.541253, -0.754861, 0.370445>, <0.668449, -0.106765, 0.736055>, <0.893634, -0.158459, 0.419891>, <0.895532, 0.255224, -0.364530>, <0.922890, 0.254347, 0.289106>, <0.481339, 0.320035, -0.816021>, 
			<-0.043775, 0.384594, -0.922047>, <-0.291342, 0.620226, -0.728313>, <0.226069, 0.553824, -0.801356>, <-0.005693, 0.383312, -0.923601>, <-0.579111, 0.315635, -0.751668>, <-0.920673, 0.224764, -0.319127>, <-0.895532, 0.255224, 0.364530>, <-0.481339, 0.320035, 0.816021>, <0.043775, 0.384594, 0.922047>, <0.291051, 0.621663, 0.727203>, <-0.226301, 0.552470, 0.802225>, 
			<0.005693, 0.383312, 0.923601>, <0.579111, 0.315635, 0.751668>, <0.956702, -0.175750, 0.232019>, <0.796635, -0.134321, 0.589348>, <0.516071, -0.080126, 0.852790>, <0.160155, -0.045299, 0.986052>, <-0.192272, -0.045327, 0.980294>, <-0.543850, -0.080200, 0.835341>, <-0.815871, -0.134459, 0.562384>, <-0.963998, -0.175892, 0.199423>, <-0.956702, -0.175750, -0.232019>, 
			<-0.796635, -0.134321, -0.589348>, <-0.516071, -0.080126, -0.852790>, <-0.160155, -0.045299, -0.986052>, <0.192272, -0.045327, -0.980294>, <0.543850, -0.080200, -0.835341>, <0.815871, -0.134459, -0.562384>, <0.963998, -0.175892, -0.199423>, <0.966448, -0.034940, -0.254475>, <0.949559, 0.250926, -0.188078>, <0.779016, -0.050104, -0.624999>, <0.790302, 0.269643, -0.550196>, 
			<0.485568, -0.046675, -0.872952>, <0.519593, 0.269643, -0.810750>, <0.163111, -0.044427, -0.985607>, <0.188078, 0.250926, -0.949559>, <-0.190043, -0.044353, -0.980773>, <-0.174578, 0.264313, -0.948505>, <-0.511500, -0.046496, -0.858025>, <-0.550196, 0.269643, -0.790302>, <-0.788605, -0.038087, -0.613719>, <-0.810750, 0.269643, -0.519593>, <-0.979538, -0.052557, -0.194275>, 
			<-0.949559, 0.250926, -0.188078>, <-0.966448, -0.034940, 0.254475>, <-0.949559, 0.250926, 0.188078>, <-0.788605, -0.038087, 0.613719>, <-0.804868, 0.250926, 0.537796>, <-0.485568, -0.046675, 0.872952>, <-0.537796, 0.250926, 0.804868>, <-0.151532, -0.054876, 0.986928>, <-0.188078, 0.250926, 0.949559>, <0.190043, -0.044353, 0.980773>, <0.188078, 0.250926, 0.949559>, 
			<0.511500, -0.046496, 0.858025>, <0.550196, 0.269643, 0.790302>, <0.788605, -0.038087, 0.613719>, <0.810750, 0.269643, 0.519593>, <0.977209, -0.034825, 0.209404>, <0.949559, 0.250926, 0.188078>, <0.910326, -0.051486, 0.410677>, <0.653522, -0.064327, 0.754170>, <0.352794, -0.045213, 0.934608>, <0.027479, -0.044015, 0.998653>, <-0.325616, -0.045346, 0.944414>, 
			<-0.639178, -0.048355, 0.767537>, <-0.903095, -0.068803, 0.423894>, <-0.997806, -0.052861, 0.039855>, <-0.910326, -0.051486, -0.410677>, <-0.653522, -0.064327, -0.754170>, <-0.352794, -0.045213, -0.934608>, <-0.011818, -0.054537, -0.998442>, <0.325616, -0.045346, -0.944414>, <0.639178, -0.048355, -0.767537>, <0.894226, -0.051690, -0.444621>, <0.997702, -0.065537, -0.017169>, 
			<0.901350, 0.219490, 0.373352>, <0.696293, 0.237484, 0.677331>, <0.384087, 0.237484, 0.892232>, <0.000000, 0.282182, 0.959361>, <-0.384087, 0.237484, 0.892232>, <-0.684476, 0.250970, 0.684476>, <-0.892232, 0.237484, 0.384087>, <-0.959361, 0.282182, 0.000000>, <-0.901350, 0.219490, -0.373352>, <-0.696293, 0.237484, -0.677331>, <-0.384087, 0.237484, -0.892232>, 
			<0.018766, 0.269688, -0.962765>, <0.373352, 0.219490, -0.901350>, <0.677331, 0.237484, -0.696293>, <0.892232, 0.237484, -0.384087>, <0.959361, 0.282182, -0.000000>, <0.983948, 0.177328, -0.020040>, <0.903748, 0.205702, -0.375401>, <0.691295, 0.205702, -0.692675>, <0.359531, 0.225818, -0.905397>, <-0.032426, 0.205594, -0.978100>, <-0.375401, 0.205702, -0.903748>, 
			<-0.692675, 0.205702, -0.691295>, <-0.905397, 0.225818, -0.359531>, <-0.983948, 0.177328, 0.020040>, <-0.903748, 0.205702, 0.375401>, <-0.681586, 0.177328, 0.709927>, <-0.344345, 0.205594, 0.916056>, <0.020040, 0.177328, 0.983948>, <0.375401, 0.205702, 0.903748>, <0.692675, 0.205702, 0.691295>, <0.905397, 0.225818, 0.359531>, <0.965947, 0.258151, 0.017423>, 
			<0.839737, 0.281468, -0.464347>, <0.556639, 0.315624, -0.768462>, <0.234309, 0.481134, -0.844754>, <0.013881, 0.520431, -0.853791>, <-0.208273, 0.480170, -0.852091>, <-0.560478, 0.274126, -0.781485>, <-0.823504, 0.280788, -0.492950>, <-0.973058, 0.230552, -0.001813>, <-0.842925, 0.250528, 0.476144>, <-0.556639, 0.315624, 0.768462>, <-0.234309, 0.481134, 0.844754>, 
			<-0.013881, 0.520431, 0.853791>, <0.208273, 0.480170, 0.852091>, <0.560478, 0.274126, 0.781485>, <0.823504, 0.280788, 0.492950>, <0.965537, 0.205561, 0.159636>, <0.943161, -0.260047, 0.206939>, <0.814226, 0.205665, 0.542898>, <0.764189, -0.240985, 0.598282>, <0.544489, 0.205665, 0.813163>, <0.489986, -0.183294, 0.852242>, <0.191858, 0.205665, 0.959631>, 
			<0.169333, -0.140401, 0.975507>, <-0.159636, 0.205561, 0.965537>, <-0.186761, -0.144977, 0.971649>, <-0.529495, 0.225778, 0.817716>, <-0.489986, -0.183294, 0.852242>, <-0.802116, 0.225778, 0.552842>, <-0.764189, -0.240985, 0.598282>, <-0.959631, 0.205665, 0.191858>, <-0.943161, -0.260047, 0.206939>, <-0.965537, 0.205561, -0.159636>, <-0.934147, -0.279791, -0.221554>, 
			<-0.814226, 0.205665, -0.542898>, <-0.764189, -0.240985, -0.598282>, <-0.544489, 0.205665, -0.813163>, <-0.489986, -0.183294, -0.852242>, <-0.211235, 0.177297, -0.961221>, <-0.169333, -0.140401, -0.975507>, <0.159636, 0.205561, -0.965537>, <0.169333, -0.140401, -0.975507>, <0.542898, 0.205665, -0.814226>, <0.489986, -0.183294, -0.852242>, <0.813163, 0.205665, -0.544489>, 
			<0.764189, -0.240985, -0.598282>, <0.959631, 0.205665, -0.191858>, <0.943161, -0.260047, -0.206939>, <0.960117, 0.190092, -0.205035>, <0.773719, 0.222427, -0.593200>, <0.414544, 0.368300, -0.832171>, <0.170119, 0.360862, -0.916972>, <-0.134744, 0.360796, -0.922860>, <-0.385858, 0.367464, -0.846217>, <-0.751306, 0.269691, -0.602334>, <-0.946358, 0.229256, -0.227702>, 
			<-0.960117, 0.190092, 0.205035>, <-0.751306, 0.269691, 0.602334>, <-0.414544, 0.368300, 0.832171>, <-0.170119, 0.360862, 0.916972>, <0.134744, 0.360796, 0.922860>, <0.385858, 0.367464, 0.846217>, <0.751306, 0.269691, 0.602334>, <0.949224, 0.189978, 0.250763>, <0.866602, -0.264800, 0.422945>, <0.635924, -0.212444, 0.741935>, <0.332943, -0.158182, 0.929584>, 
			<-0.011717, -0.135230, 0.990745>, <-0.332943, -0.158182, 0.929584>, <-0.635924, -0.212444, 0.741935>, <-0.866602, -0.264800, 0.422945>, <-0.966436, -0.255787, -0.023957>, <-0.866602, -0.264800, -0.422945>, <-0.635924, -0.212444, -0.741935>, <-0.332943, -0.158182, -0.929584>, <-0.000000, -0.138227, -0.990401>, <0.332943, -0.158182, -0.929584>, <0.635924, -0.212444, -0.741935>, 
			<0.866602, -0.264800, -0.422945>, <0.958722, -0.284344, -0.000000>, <0.952342, -0.228578, -0.201982>, <0.665878, -0.735783, -0.123411>, <0.817624, -0.181734, -0.546319>, <0.587855, -0.703745, -0.398961>, <0.546319, -0.181734, -0.817624>, <0.398961, -0.703745, -0.587855>, <0.201982, -0.228578, -0.952342>, <0.123411, -0.735783, -0.665878>, <-0.201982, -0.228578, -0.952342>, 
			<-0.123411, -0.735783, -0.665878>, <-0.546319, -0.181734, -0.817624>, <-0.398961, -0.703745, -0.587855>, <-0.817624, -0.181734, -0.546319>, <-0.587855, -0.703745, -0.398961>, <-0.952342, -0.228578, -0.201982>, <-0.665878, -0.735783, -0.123411>, <-0.952342, -0.228578, 0.201982>, <-0.665878, -0.735783, 0.123411>, <-0.817624, -0.181734, 0.546319>, <-0.587855, -0.703745, 0.398961>, 
			<-0.546319, -0.181734, 0.817624>, <-0.398961, -0.703745, 0.587855>, <-0.201982, -0.228578, 0.952342>, <-0.123411, -0.735783, 0.665878>, <0.201982, -0.228578, 0.952342>, <0.123411, -0.735783, 0.665878>, <0.546319, -0.181734, 0.817624>, <0.398961, -0.703745, 0.587855>, <0.817624, -0.181734, 0.546319>, <0.587855, -0.703745, 0.398961>, <0.952342, -0.228578, 0.201982>, 
			<0.665878, -0.735783, 0.123411>, <0.870734, -0.311762, 0.380298>, <0.628227, -0.735741, 0.253012>, <0.664066, -0.343561, 0.664066>, <0.479058, -0.735532, 0.479058>, <0.380298, -0.311762, 0.870734>, <0.253012, -0.735741, 0.628227>, <0.000000, -0.343561, 0.939130>, <-0.000000, -0.804003, 0.594626>, <-0.380298, -0.311762, 0.870734>, <-0.253012, -0.735741, 0.628227>, 
			<-0.664066, -0.343561, 0.664066>, <-0.479058, -0.735532, 0.479058>, <-0.870734, -0.311762, 0.380298>, <-0.628227, -0.735741, 0.253012>, <-0.939130, -0.343561, -0.000000>, <-0.594626, -0.804003, -0.000000>, <-0.870734, -0.311762, -0.380298>, <-0.628227, -0.735741, -0.253012>, <-0.664066, -0.343561, -0.664066>, <-0.479058, -0.735532, -0.479058>, <-0.380298, -0.311762, -0.870734>, 
			<-0.253012, -0.735741, -0.628227>, <-0.000000, -0.343561, -0.939130>, <-0.000000, -0.804003, -0.594626>, <0.380298, -0.311762, -0.870734>, <0.253012, -0.735741, -0.628227>, <0.664066, -0.343561, -0.664066>, <0.479058, -0.735532, -0.479058>, <0.870734, -0.311762, -0.380298>, <0.628227, -0.735741, -0.253012>, <0.939130, -0.343561, 0.000000>, <0.594626, -0.804003, 0.000000>, 
			<0.997630, 0.068812, 0.000000>, <0.923159, 0.039487, -0.382385>, <0.706555, 0.039487, -0.706555>, <0.382385, 0.039487, -0.923159>, <0.000000, 0.068812, -0.997630>, <-0.382385, 0.039487, -0.923159>, <-0.706555, 0.039487, -0.706555>, <-0.923159, 0.039487, -0.382385>, <-0.997630, 0.068812, -0.000000>, <-0.923159, 0.039487, 0.382385>, <-0.706555, 0.039487, 0.706555>, 
			<-0.382385, 0.039487, 0.923159>, <0.000000, 0.068812, 0.997630>, <0.382385, 0.039487, 0.923159>, <0.706555, 0.039487, 0.706555>, <0.923159, 0.039487, 0.382385>, <0.973166, 0.086351, 0.213289>, <0.827462, 0.098059, 0.552893>, <0.552893, 0.098059, 0.827462>, <0.213289, 0.086351, 0.973166>, <-0.213289, 0.086351, 0.973166>, <-0.552893, 0.098059, 0.827462>, 
			<-0.827462, 0.098059, 0.552893>, <-0.973166, 0.086351, 0.213289>, <-0.973166, 0.086351, -0.213289>, <-0.827462, 0.098059, -0.552893>, <-0.552893, 0.098059, -0.827462>, <-0.213289, 0.086351, -0.973166>, <0.213289, 0.086351, -0.973166>, <0.552893, 0.098059, -0.827462>, <0.827462, 0.098059, -0.552893>, <0.973166, 0.086351, -0.213289>, <-0.667330, 0.723023, -0.178629>, 
			<-0.514453, 0.837539, 0.184028>, <-0.394512, 0.548655, 0.737114>, <0.039501, 0.806227, 0.590286>, <-0.097522, 0.709994, 0.697423>, <0.034415, 0.800068, 0.598921>, <0.311873, 0.335495, 0.888920>, <0.459553, 0.800107, 0.385540>, <0.729912, 0.567272, 0.381356>, <0.947324, 0.318034, 0.037838>, <0.664931, 0.718572, -0.203769>, <0.466885, 0.800107, -0.376627>, 
			<0.535181, 0.335495, -0.775258>, <0.043608, 0.800068, -0.598322>, <-0.033839, 0.709994, -0.703394>, <-0.048895, 0.806227, -0.589582>, <-0.196903, 0.387958, -0.900399>, <0.574754, 0.803843, 0.153278>, <0.614362, 0.758095, -0.218752>, <0.395937, 0.549388, -0.735803>, <-0.039501, 0.806227, -0.590286>, <0.097522, 0.709994, -0.697423>, <-0.034415, 0.800068, -0.598921>, 
			<-0.311873, 0.335495, -0.888920>, <-0.459553, 0.800107, -0.385540>, <-0.616394, 0.718572, -0.322046>, <-0.947324, 0.318034, -0.037838>, <-0.787387, 0.567272, 0.241296>, <-0.466885, 0.800107, 0.376627>, <-0.535181, 0.335495, 0.775258>, <-0.043608, 0.800068, 0.598322>, <0.033839, 0.709994, 0.703394>, <0.048895, 0.806227, 0.589582>, <0.197801, 0.388476, 0.899978>}
	 uv_vectors { 0}
	 texture_list { 1, texture{wm_default}}
	 face_indices { 1666, <0, 100, 305>, 0, <0, 305, 97>, 0, <1, 97, 103>, 0, <97, 305, 103>, 0, <96, 103, 305>, 0, <305, 100, 96>, 0, <1, 103, 306>, 0, <1, 306, 101>, 0, <2, 101, 306>, 0, <2, 306, 106>, 0, 
			<106, 306, 103>, 0, <103, 96, 106>, 0, <2, 106, 307>, 0, <2, 307, 104>, 0, <3, 104, 307>, 0, <3, 307, 109>, 0, <96, 109, 307>, 0, <307, 106, 96>, 0, <109, 308, 107>, 0, <107, 3, 109>, 0, <4, 107, 308>, 0, 
			<4, 308, 112>, 0, <96, 112, 308>, 0, <308, 109, 96>, 0, <4, 112, 309>, 0, <4, 309, 110>, 0, <5, 110, 115>, 0, <110, 309, 115>, 0, <96, 115, 309>, 0, <309, 112, 96>, 0, <5, 115, 310>, 0, <5, 310, 113>, 0, 
			<6, 113, 310>, 0, <310, 118, 6>, 0, <118, 310, 115>, 0, <115, 96, 118>, 0, <6, 118, 311>, 0, <6, 311, 116>, 0, <7, 116, 311>, 0, <311, 121, 7>, 0, <121, 311, 118>, 0, <118, 96, 121>, 0, <7, 121, 119>, 0, 
			<121, 312, 119>, 0, <8, 119, 312>, 0, <312, 124, 8>, 0, <96, 124, 312>, 0, <96, 312, 121>, 0, <8, 124, 313>, 0, <313, 122, 8>, 0, <122, 313, 127>, 0, <127, 9, 122>, 0, <96, 127, 313>, 0, <96, 313, 124>, 0, 
			<9, 127, 314>, 0, <314, 125, 9>, 0, <10, 125, 314>, 0, <314, 130, 10>, 0, <96, 130, 314>, 0, <96, 314, 127>, 0, <10, 130, 315>, 0, <315, 128, 10>, 0, <11, 128, 315>, 0, <315, 133, 11>, 0, <133, 315, 130>, 0, 
			<130, 96, 133>, 0, <11, 133, 131>, 0, <133, 316, 131>, 0, <12, 131, 316>, 0, <316, 136, 12>, 0, <96, 136, 316>, 0, <96, 316, 133>, 0, <12, 136, 317>, 0, <317, 134, 12>, 0, <134, 317, 139>, 0, <139, 13, 134>, 0, 
			<96, 139, 317>, 0, <96, 317, 136>, 0, <13, 139, 318>, 0, <318, 137, 13>, 0, <14, 137, 318>, 0, <14, 318, 142>, 0, <96, 142, 318>, 0, <96, 318, 139>, 0, <14, 142, 319>, 0, <319, 140, 14>, 0, <15, 140, 319>, 0, 
			<15, 319, 144>, 0, <96, 144, 319>, 0, <319, 142, 96>, 0, <144, 320, 98>, 0, <98, 15, 144>, 0, <320, 100, 0>, 0, <0, 98, 320>, 0, <100, 320, 96>, 0, <320, 144, 96>, 0, <102, 321, 1>, 0, <321, 97, 1>, 0, 
			<97, 321, 0>, 0, <321, 99, 0>, 0, <16, 99, 321>, 0, <16, 321, 145>, 0, <17, 145, 102>, 0, <145, 321, 102>, 0, <105, 322, 2>, 0, <322, 101, 2>, 0, <101, 322, 102>, 0, <102, 1, 101>, 0, <17, 102, 322>, 0, 
			<17, 322, 148>, 0, <18, 148, 105>, 0, <148, 322, 105>, 0, <108, 323, 104>, 0, <108, 104, 3>, 0, <104, 323, 2>, 0, <323, 105, 2>, 0, <105, 323, 150>, 0, <150, 18, 105>, 0, <19, 150, 323>, 0, <19, 323, 108>, 0, 
			<111, 324, 107>, 0, <111, 107, 4>, 0, <107, 324, 3>, 0, <324, 108, 3>, 0, <108, 324, 152>, 0, <152, 19, 108>, 0, <20, 152, 324>, 0, <20, 324, 111>, 0, <114, 325, 5>, 0, <325, 110, 5>, 0, <110, 325, 4>, 0, 
			<325, 111, 4>, 0, <20, 111, 325>, 0, <20, 325, 154>, 0, <21, 154, 114>, 0, <154, 325, 114>, 0, <117, 326, 6>, 0, <326, 113, 6>, 0, <113, 326, 114>, 0, <114, 5, 113>, 0, <21, 114, 326>, 0, <21, 326, 156>, 0, 
			<22, 156, 117>, 0, <156, 326, 117>, 0, <120, 327, 116>, 0, <116, 7, 120>, 0, <327, 117, 6>, 0, <6, 116, 327>, 0, <22, 117, 158>, 0, <117, 327, 158>, 0, <23, 158, 327>, 0, <327, 120, 23>, 0, <328, 119, 8>, 0, 
			<8, 123, 328>, 0, <328, 120, 7>, 0, <7, 119, 328>, 0, <23, 120, 160>, 0, <120, 328, 160>, 0, <160, 328, 123>, 0, <123, 24, 160>, 0, <329, 122, 9>, 0, <9, 126, 329>, 0, <122, 329, 123>, 0, <122, 123, 8>, 0, 
			<24, 123, 329>, 0, <329, 162, 24>, 0, <162, 329, 126>, 0, <126, 25, 162>, 0, <330, 125, 10>, 0, <10, 129, 330>, 0, <125, 330, 126>, 0, <125, 126, 9>, 0, <25, 126, 330>, 0, <330, 164, 25>, 0, <164, 330, 129>, 0, 
			<129, 26, 164>, 0, <132, 331, 128>, 0, <128, 11, 132>, 0, <331, 129, 10>, 0, <10, 128, 331>, 0, <26, 129, 166>, 0, <129, 331, 166>, 0, <27, 166, 331>, 0, <331, 132, 27>, 0, <332, 131, 12>, 0, <12, 135, 332>, 0, 
			<332, 132, 11>, 0, <11, 131, 332>, 0, <27, 132, 168>, 0, <132, 332, 168>, 0, <168, 332, 135>, 0, <135, 28, 168>, 0, <333, 134, 13>, 0, <13, 138, 333>, 0, <134, 333, 135>, 0, <134, 135, 12>, 0, <28, 135, 333>, 0, 
			<333, 170, 28>, 0, <170, 333, 138>, 0, <138, 29, 170>, 0, <334, 137, 14>, 0, <14, 141, 334>, 0, <137, 334, 138>, 0, <137, 138, 13>, 0, <29, 138, 334>, 0, <334, 172, 29>, 0, <172, 334, 141>, 0, <141, 30, 172>, 0, 
			<143, 335, 140>, 0, <143, 140, 15>, 0, <140, 335, 14>, 0, <335, 141, 14>, 0, <141, 335, 174>, 0, <174, 30, 141>, 0, <31, 174, 335>, 0, <31, 335, 143>, 0, <0, 99, 98>, 0, <99, 336, 98>, 0, <15, 98, 336>, 0, 
			<336, 143, 15>, 0, <143, 336, 146>, 0, <146, 31, 143>, 0, <336, 99, 16>, 0, <16, 146, 336>, 0, <149, 337, 17>, 0, <337, 145, 17>, 0, <145, 337, 147>, 0, <147, 16, 145>, 0, <32, 147, 337>, 0, <32, 337, 177>, 0, 
			<33, 177, 149>, 0, <177, 337, 149>, 0, <151, 338, 18>, 0, <338, 148, 18>, 0, <148, 338, 149>, 0, <149, 17, 148>, 0, <33, 149, 338>, 0, <33, 338, 180>, 0, <34, 180, 338>, 0, <338, 151, 34>, 0, <153, 339, 150>, 0, 
			<153, 150, 19>, 0, <150, 339, 18>, 0, <339, 151, 18>, 0, <34, 151, 182>, 0, <151, 339, 182>, 0, <35, 182, 339>, 0, <35, 339, 153>, 0, <155, 340, 152>, 0, <155, 152, 20>, 0, <152, 340, 19>, 0, <340, 153, 19>, 0, 
			<153, 340, 184>, 0, <184, 35, 153>, 0, <36, 184, 340>, 0, <36, 340, 155>, 0, <157, 341, 21>, 0, <341, 154, 21>, 0, <154, 341, 20>, 0, <341, 155, 20>, 0, <155, 341, 186>, 0, <186, 36, 155>, 0, <37, 186, 157>, 0, 
			<186, 341, 157>, 0, <159, 342, 22>, 0, <342, 156, 22>, 0, <156, 342, 157>, 0, <157, 21, 156>, 0, <37, 157, 342>, 0, <37, 342, 188>, 0, <38, 188, 342>, 0, <342, 159, 38>, 0, <161, 343, 158>, 0, <158, 23, 161>, 0, 
			<343, 159, 22>, 0, <22, 158, 343>, 0, <38, 159, 190>, 0, <159, 343, 190>, 0, <39, 190, 343>, 0, <343, 161, 39>, 0, <344, 160, 24>, 0, <24, 163, 344>, 0, <344, 161, 23>, 0, <23, 160, 344>, 0, <39, 161, 192>, 0, 
			<161, 344, 192>, 0, <192, 344, 163>, 0, <163, 40, 192>, 0, <345, 162, 25>, 0, <25, 165, 345>, 0, <162, 345, 163>, 0, <162, 163, 24>, 0, <40, 163, 345>, 0, <345, 194, 40>, 0, <194, 345, 165>, 0, <165, 41, 194>, 0, 
			<346, 164, 26>, 0, <26, 167, 346>, 0, <164, 346, 165>, 0, <164, 165, 25>, 0, <41, 165, 346>, 0, <346, 196, 41>, 0, <42, 196, 346>, 0, <346, 167, 42>, 0, <169, 347, 166>, 0, <166, 27, 169>, 0, <347, 167, 26>, 0, 
			<26, 166, 347>, 0, <42, 167, 198>, 0, <167, 347, 198>, 0, <43, 198, 347>, 0, <347, 169, 43>, 0, <348, 168, 28>, 0, <28, 171, 348>, 0, <348, 169, 27>, 0, <27, 168, 348>, 0, <43, 169, 200>, 0, <169, 348, 200>, 0, 
			<200, 348, 171>, 0, <171, 44, 200>, 0, <349, 170, 29>, 0, <29, 173, 349>, 0, <170, 349, 171>, 0, <170, 171, 28>, 0, <44, 171, 349>, 0, <349, 202, 44>, 0, <202, 349, 173>, 0, <173, 45, 202>, 0, <350, 172, 30>, 0, 
			<30, 175, 350>, 0, <172, 350, 173>, 0, <172, 173, 29>, 0, <45, 173, 350>, 0, <350, 204, 45>, 0, <46, 204, 350>, 0, <350, 175, 46>, 0, <176, 351, 174>, 0, <176, 174, 31>, 0, <174, 351, 30>, 0, <351, 175, 30>, 0, 
			<46, 175, 206>, 0, <175, 351, 206>, 0, <47, 206, 351>, 0, <47, 351, 176>, 0, <16, 147, 146>, 0, <147, 352, 146>, 0, <31, 146, 352>, 0, <352, 176, 31>, 0, <176, 352, 178>, 0, <178, 47, 176>, 0, <352, 147, 32>, 0, 
			<32, 178, 352>, 0, <181, 353, 33>, 0, <353, 177, 33>, 0, <177, 353, 179>, 0, <179, 32, 177>, 0, <48, 179, 209>, 0, <179, 353, 209>, 0, <49, 209, 353>, 0, <353, 181, 49>, 0, <183, 354, 180>, 0, <180, 34, 183>, 0, 
			<354, 181, 33>, 0, <33, 180, 354>, 0, <49, 181, 212>, 0, <181, 354, 212>, 0, <50, 212, 354>, 0, <354, 183, 50>, 0, <185, 355, 182>, 0, <182, 35, 185>, 0, <355, 183, 34>, 0, <34, 182, 355>, 0, <50, 183, 214>, 0, 
			<183, 355, 214>, 0, <51, 214, 355>, 0, <355, 185, 51>, 0, <187, 356, 184>, 0, <187, 184, 36>, 0, <184, 356, 35>, 0, <356, 185, 35>, 0, <51, 185, 356>, 0, <51, 356, 216>, 0, <52, 216, 356>, 0, <356, 187, 52>, 0, 
			<189, 357, 37>, 0, <357, 186, 37>, 0, <186, 357, 187>, 0, <187, 36, 186>, 0, <52, 187, 218>, 0, <187, 357, 218>, 0, <53, 218, 357>, 0, <357, 189, 53>, 0, <191, 358, 188>, 0, <188, 38, 191>, 0, <358, 189, 37>, 0, 
			<37, 188, 358>, 0, <53, 189, 220>, 0, <189, 358, 220>, 0, <54, 220, 358>, 0, <358, 191, 54>, 0, <193, 359, 190>, 0, <190, 39, 193>, 0, <359, 191, 38>, 0, <38, 190, 359>, 0, <54, 191, 222>, 0, <191, 359, 222>, 0, 
			<55, 222, 359>, 0, <359, 193, 55>, 0, <360, 192, 40>, 0, <40, 195, 360>, 0, <360, 193, 39>, 0, <39, 192, 360>, 0, <55, 193, 224>, 0, <193, 360, 224>, 0, <56, 224, 360>, 0, <360, 195, 56>, 0, <361, 194, 41>, 0, 
			<41, 197, 361>, 0, <194, 361, 195>, 0, <194, 195, 40>, 0, <56, 195, 226>, 0, <195, 361, 226>, 0, <57, 226, 361>, 0, <361, 197, 57>, 0, <199, 362, 196>, 0, <196, 42, 199>, 0, <362, 197, 41>, 0, <41, 196, 362>, 0, 
			<57, 197, 228>, 0, <197, 362, 228>, 0, <58, 228, 362>, 0, <362, 199, 58>, 0, <201, 363, 198>, 0, <198, 43, 201>, 0, <363, 199, 42>, 0, <42, 198, 363>, 0, <58, 199, 230>, 0, <199, 363, 230>, 0, <59, 230, 363>, 0, 
			<363, 201, 59>, 0, <364, 200, 44>, 0, <44, 203, 364>, 0, <364, 201, 43>, 0, <43, 200, 364>, 0, <59, 201, 232>, 0, <201, 364, 232>, 0, <60, 232, 364>, 0, <364, 203, 60>, 0, <365, 202, 45>, 0, <45, 205, 365>, 0, 
			<202, 365, 203>, 0, <202, 203, 44>, 0, <60, 203, 234>, 0, <203, 365, 234>, 0, <61, 234, 365>, 0, <365, 205, 61>, 0, <207, 366, 204>, 0, <204, 46, 207>, 0, <366, 205, 45>, 0, <45, 204, 366>, 0, <61, 205, 236>, 0, 
			<205, 366, 236>, 0, <62, 236, 366>, 0, <366, 207, 62>, 0, <208, 367, 206>, 0, <206, 47, 208>, 0, <206, 367, 207>, 0, <207, 46, 206>, 0, <62, 207, 238>, 0, <207, 367, 238>, 0, <63, 238, 367>, 0, <367, 208, 63>, 0, 
			<32, 179, 178>, 0, <179, 368, 178>, 0, <47, 178, 368>, 0, <368, 208, 47>, 0, <208, 368, 210>, 0, <208, 210, 63>, 0, <210, 368, 48>, 0, <368, 179, 48>, 0, <213, 369, 209>, 0, <209, 49, 213>, 0, <209, 369, 211>, 0, 
			<211, 48, 209>, 0, <211, 369, 241>, 0, <241, 64, 211>, 0, <65, 241, 369>, 0, <369, 213, 65>, 0, <215, 370, 212>, 0, <212, 50, 215>, 0, <370, 213, 49>, 0, <49, 212, 370>, 0, <65, 213, 244>, 0, <213, 370, 244>, 0, 
			<66, 244, 370>, 0, <370, 215, 66>, 0, <217, 371, 214>, 0, <214, 51, 217>, 0, <371, 215, 50>, 0, <50, 214, 371>, 0, <66, 215, 246>, 0, <215, 371, 246>, 0, <67, 246, 371>, 0, <371, 217, 67>, 0, <219, 372, 216>, 0, 
			<216, 52, 219>, 0, <372, 217, 51>, 0, <51, 216, 372>, 0, <67, 217, 248>, 0, <217, 372, 248>, 0, <68, 248, 219>, 0, <248, 372, 219>, 0, <221, 373, 218>, 0, <218, 53, 221>, 0, <218, 373, 219>, 0, <219, 52, 218>, 0, 
			<219, 373, 250>, 0, <250, 68, 219>, 0, <69, 250, 373>, 0, <373, 221, 69>, 0, <223, 374, 54>, 0, <374, 220, 54>, 0, <374, 221, 53>, 0, <53, 220, 374>, 0, <69, 221, 252>, 0, <221, 374, 252>, 0, <70, 252, 374>, 0, 
			<374, 223, 70>, 0, <225, 375, 222>, 0, <222, 55, 225>, 0, <375, 223, 54>, 0, <54, 222, 375>, 0, <70, 223, 254>, 0, <223, 375, 254>, 0, <71, 254, 375>, 0, <375, 225, 71>, 0, <227, 376, 224>, 0, <224, 56, 227>, 0, 
			<376, 225, 55>, 0, <55, 224, 376>, 0, <71, 225, 256>, 0, <225, 376, 256>, 0, <256, 376, 227>, 0, <227, 72, 256>, 0, <229, 377, 226>, 0, <226, 57, 229>, 0, <226, 377, 227>, 0, <227, 56, 226>, 0, <72, 227, 258>, 0, 
			<227, 377, 258>, 0, <73, 258, 377>, 0, <377, 229, 73>, 0, <231, 378, 58>, 0, <378, 228, 58>, 0, <378, 229, 57>, 0, <57, 228, 378>, 0, <73, 229, 260>, 0, <229, 378, 260>, 0, <74, 260, 378>, 0, <378, 231, 74>, 0, 
			<233, 379, 230>, 0, <230, 59, 233>, 0, <379, 231, 58>, 0, <58, 230, 379>, 0, <74, 231, 262>, 0, <231, 379, 262>, 0, <75, 262, 379>, 0, <379, 233, 75>, 0, <235, 380, 232>, 0, <232, 60, 235>, 0, <380, 233, 59>, 0, 
			<59, 232, 380>, 0, <75, 233, 264>, 0, <233, 380, 264>, 0, <76, 264, 380>, 0, <380, 235, 76>, 0, <237, 381, 234>, 0, <234, 61, 237>, 0, <234, 381, 235>, 0, <235, 60, 234>, 0, <76, 235, 266>, 0, <235, 381, 266>, 0, 
			<77, 266, 381>, 0, <381, 237, 77>, 0, <239, 382, 62>, 0, <382, 236, 62>, 0, <382, 237, 61>, 0, <61, 236, 382>, 0, <77, 237, 268>, 0, <237, 382, 268>, 0, <78, 268, 382>, 0, <382, 239, 78>, 0, <240, 383, 238>, 0, 
			<238, 63, 240>, 0, <383, 239, 62>, 0, <62, 238, 383>, 0, <78, 239, 270>, 0, <239, 383, 270>, 0, <79, 270, 383>, 0, <383, 240, 79>, 0, <211, 384, 210>, 0, <210, 48, 211>, 0, <63, 210, 384>, 0, <63, 384, 240>, 0, 
			<240, 384, 242>, 0, <240, 242, 79>, 0, <242, 384, 211>, 0, <242, 211, 64>, 0, <245, 385, 241>, 0, <245, 241, 65>, 0, <241, 385, 243>, 0, <243, 64, 241>, 0, <80, 243, 385>, 0, <80, 385, 273>, 0, <81, 273, 385>, 0, 
			<81, 385, 245>, 0, <247, 386, 244>, 0, <244, 66, 247>, 0, <386, 245, 65>, 0, <65, 244, 386>, 0, <81, 245, 276>, 0, <245, 386, 276>, 0, <82, 276, 386>, 0, <386, 247, 82>, 0, <249, 387, 246>, 0, <246, 67, 249>, 0, 
			<387, 247, 66>, 0, <66, 246, 387>, 0, <82, 247, 278>, 0, <247, 387, 278>, 0, <83, 278, 387>, 0, <387, 249, 83>, 0, <251, 388, 68>, 0, <388, 248, 68>, 0, <248, 388, 249>, 0, <249, 67, 248>, 0, <83, 249, 388>, 0, 
			<83, 388, 280>, 0, <84, 280, 251>, 0, <280, 388, 251>, 0, <253, 389, 250>, 0, <253, 250, 69>, 0, <250, 389, 251>, 0, <251, 68, 250>, 0, <84, 251, 389>, 0, <84, 389, 282>, 0, <85, 282, 389>, 0, <85, 389, 253>, 0, 
			<255, 390, 252>, 0, <252, 70, 255>, 0, <390, 253, 69>, 0, <69, 252, 390>, 0, <85, 253, 284>, 0, <253, 390, 284>, 0, <86, 284, 390>, 0, <390, 255, 86>, 0, <257, 391, 254>, 0, <254, 71, 257>, 0, <391, 255, 70>, 0, 
			<70, 254, 391>, 0, <86, 255, 286>, 0, <255, 391, 286>, 0, <87, 286, 391>, 0, <391, 257, 87>, 0, <259, 392, 256>, 0, <256, 72, 259>, 0, <256, 392, 257>, 0, <256, 257, 71>, 0, <87, 257, 392>, 0, <392, 288, 87>, 0, 
			<88, 288, 392>, 0, <392, 259, 88>, 0, <261, 393, 258>, 0, <258, 73, 261>, 0, <393, 259, 72>, 0, <72, 258, 393>, 0, <88, 259, 290>, 0, <259, 393, 290>, 0, <89, 290, 393>, 0, <393, 261, 89>, 0, <263, 394, 260>, 0, 
			<260, 74, 263>, 0, <394, 261, 73>, 0, <73, 260, 394>, 0, <89, 261, 292>, 0, <261, 394, 292>, 0, <90, 292, 394>, 0, <394, 263, 90>, 0, <265, 395, 75>, 0, <395, 262, 75>, 0, <262, 395, 263>, 0, <263, 74, 262>, 0, 
			<90, 263, 294>, 0, <263, 395, 294>, 0, <91, 294, 395>, 0, <395, 265, 91>, 0, <396, 264, 76>, 0, <76, 267, 396>, 0, <264, 396, 265>, 0, <264, 265, 75>, 0, <91, 265, 396>, 0, <396, 296, 91>, 0, <92, 296, 396>, 0, 
			<396, 267, 92>, 0, <269, 397, 266>, 0, <266, 77, 269>, 0, <397, 267, 76>, 0, <76, 266, 397>, 0, <92, 267, 298>, 0, <267, 397, 298>, 0, <93, 298, 397>, 0, <397, 269, 93>, 0, <271, 398, 268>, 0, <268, 78, 271>, 0, 
			<398, 269, 77>, 0, <77, 268, 398>, 0, <93, 269, 398>, 0, <93, 398, 300>, 0, <94, 300, 398>, 0, <398, 271, 94>, 0, <272, 399, 270>, 0, <270, 79, 272>, 0, <399, 271, 78>, 0, <78, 270, 399>, 0, <94, 271, 302>, 0, 
			<271, 399, 302>, 0, <95, 302, 399>, 0, <399, 272, 95>, 0, <64, 243, 400>, 0, <400, 242, 64>, 0, <242, 400, 272>, 0, <272, 79, 242>, 0, <400, 274, 95>, 0, <95, 272, 400>, 0, <274, 400, 243>, 0, <274, 243, 80>, 0, 
			<277, 401, 273>, 0, <277, 273, 81>, 0, <273, 401, 80>, 0, <401, 275, 80>, 0, <279, 402, 276>, 0, <276, 82, 279>, 0, <276, 402, 277>, 0, <277, 81, 276>, 0, <281, 403, 278>, 0, <278, 83, 281>, 0, <278, 403, 279>, 0, 
			<279, 82, 278>, 0, <283, 404, 84>, 0, <404, 280, 84>, 0, <280, 404, 281>, 0, <281, 83, 280>, 0, <285, 405, 282>, 0, <285, 282, 85>, 0, <282, 405, 84>, 0, <405, 283, 84>, 0, <287, 406, 284>, 0, <284, 86, 287>, 0, 
			<284, 406, 285>, 0, <285, 85, 284>, 0, <289, 407, 286>, 0, <286, 87, 289>, 0, <286, 407, 287>, 0, <287, 86, 286>, 0, <408, 288, 88>, 0, <88, 291, 408>, 0, <288, 408, 289>, 0, <288, 289, 87>, 0, <293, 409, 290>, 0, 
			<290, 89, 293>, 0, <409, 291, 88>, 0, <88, 290, 409>, 0, <295, 410, 292>, 0, <292, 90, 295>, 0, <292, 410, 293>, 0, <293, 89, 292>, 0, <297, 411, 294>, 0, <294, 91, 297>, 0, <294, 411, 295>, 0, <295, 90, 294>, 0, 
			<412, 296, 92>, 0, <92, 299, 412>, 0, <296, 412, 297>, 0, <296, 297, 91>, 0, <301, 413, 298>, 0, <298, 93, 301>, 0, <413, 299, 92>, 0, <92, 298, 413>, 0, <303, 414, 300>, 0, <300, 94, 303>, 0, <300, 414, 301>, 0, 
			<301, 93, 300>, 0, <304, 415, 302>, 0, <302, 95, 304>, 0, <302, 415, 303>, 0, <303, 94, 302>, 0, <80, 275, 416>, 0, <416, 274, 80>, 0, <274, 416, 304>, 0, <304, 95, 274>, 0, <418, 417, 416>, 0, <416, 275, 418>, 0, 
			<419, 418, 275>, 0, <275, 401, 419>, 0, <420, 419, 401>, 0, <401, 277, 420>, 0, <421, 420, 277>, 0, <277, 402, 421>, 0, <422, 421, 402>, 0, <402, 279, 422>, 0, <423, 422, 279>, 0, <279, 403, 423>, 0, <424, 423, 403>, 0, 
			<403, 281, 424>, 0, <425, 424, 281>, 0, <281, 404, 425>, 0, <426, 425, 404>, 0, <404, 283, 426>, 0, <427, 426, 283>, 0, <283, 405, 427>, 0, <428, 427, 405>, 0, <405, 285, 428>, 0, <429, 428, 285>, 0, <285, 406, 429>, 0, 
			<430, 429, 406>, 0, <406, 287, 430>, 0, <431, 430, 287>, 0, <287, 407, 431>, 0, <432, 431, 407>, 0, <407, 289, 432>, 0, <433, 432, 289>, 0, <289, 408, 433>, 0, <434, 433, 408>, 0, <408, 291, 434>, 0, <435, 434, 291>, 0, 
			<291, 409, 435>, 0, <436, 435, 409>, 0, <409, 293, 436>, 0, <437, 436, 293>, 0, <293, 410, 437>, 0, <438, 437, 410>, 0, <410, 295, 438>, 0, <439, 438, 295>, 0, <295, 411, 439>, 0, <440, 439, 411>, 0, <411, 297, 440>, 0, 
			<441, 440, 297>, 0, <297, 412, 441>, 0, <442, 441, 412>, 0, <412, 299, 442>, 0, <443, 442, 299>, 0, <299, 413, 443>, 0, <444, 443, 413>, 0, <413, 301, 444>, 0, <445, 444, 301>, 0, <301, 414, 445>, 0, <446, 445, 414>, 0, 
			<414, 303, 446>, 0, <447, 446, 303>, 0, <303, 415, 447>, 0, <448, 447, 415>, 0, <415, 304, 448>, 0, <417, 448, 304>, 0, <304, 416, 417>, 0, <576, 785, 769>, 0, <576, 769, 608>, 0, <593, 784, 785>, 0, <593, 785, 576>, 0, 
			<642, 575, 577>, 0, <642, 577, 689>, 0, <625, 688, 575>, 0, <575, 592, 625>, 0, <574, 593, 624>, 0, <574, 624, 643>, 0, <594, 783, 786>, 0, <594, 786, 574>, 0, <573, 687, 639>, 0, <639, 578, 573>, 0, <640, 687, 573>, 0, 
			<573, 577, 640>, 0, <572, 594, 623>, 0, <572, 623, 645>, 0, <595, 782, 787>, 0, <595, 787, 572>, 0, <579, 571, 686>, 0, <579, 686, 638>, 0, <639, 686, 571>, 0, <571, 578, 639>, 0, <570, 595, 622>, 0, <570, 622, 647>, 0, 
			<596, 781, 570>, 0, <781, 788, 570>, 0, <580, 569, 685>, 0, <580, 685, 637>, 0, <638, 685, 569>, 0, <569, 579, 638>, 0, <568, 596, 649>, 0, <596, 621, 649>, 0, <597, 780, 789>, 0, <597, 789, 568>, 0, <581, 567, 684>, 0, 
			<581, 684, 636>, 0, <637, 684, 567>, 0, <567, 580, 637>, 0, <597, 620, 651>, 0, <651, 566, 597>, 0, <598, 779, 790>, 0, <598, 790, 566>, 0, <582, 565, 683>, 0, <582, 683, 635>, 0, <636, 683, 565>, 0, <565, 581, 636>, 0, 
			<598, 619, 653>, 0, <653, 564, 598>, 0, <599, 778, 791>, 0, <599, 791, 564>, 0, <563, 682, 634>, 0, <634, 583, 563>, 0, <635, 682, 563>, 0, <563, 582, 635>, 0, <562, 599, 618>, 0, <562, 618, 655>, 0, <600, 777, 562>, 0, 
			<777, 792, 562>, 0, <584, 561, 681>, 0, <584, 681, 633>, 0, <634, 681, 561>, 0, <561, 583, 634>, 0, <560, 600, 657>, 0, <600, 617, 657>, 0, <601, 776, 793>, 0, <601, 793, 560>, 0, <585, 559, 680>, 0, <585, 680, 632>, 0, 
			<633, 680, 559>, 0, <559, 584, 633>, 0, <558, 601, 616>, 0, <558, 616, 659>, 0, <602, 775, 794>, 0, <602, 794, 558>, 0, <557, 679, 631>, 0, <631, 586, 557>, 0, <632, 679, 557>, 0, <557, 585, 632>, 0, <556, 602, 615>, 0, 
			<556, 615, 661>, 0, <603, 774, 795>, 0, <603, 795, 556>, 0, <587, 555, 678>, 0, <587, 678, 630>, 0, <631, 678, 555>, 0, <555, 586, 631>, 0, <554, 603, 614>, 0, <614, 663, 554>, 0, <773, 796, 554>, 0, <554, 604, 773>, 0, 
			<588, 553, 677>, 0, <588, 677, 629>, 0, <630, 677, 553>, 0, <553, 587, 630>, 0, <604, 613, 665>, 0, <665, 552, 604>, 0, <605, 772, 797>, 0, <605, 797, 552>, 0, <589, 551, 676>, 0, <589, 676, 628>, 0, <629, 676, 551>, 0, 
			<551, 588, 629>, 0, <550, 605, 612>, 0, <550, 612, 667>, 0, <606, 771, 798>, 0, <606, 798, 550>, 0, <590, 549, 675>, 0, <590, 675, 627>, 0, <628, 675, 549>, 0, <549, 589, 628>, 0, <548, 606, 611>, 0, <548, 611, 669>, 0, 
			<607, 770, 799>, 0, <607, 799, 548>, 0, <591, 547, 674>, 0, <591, 674, 626>, 0, <627, 674, 547>, 0, <547, 590, 627>, 0, <546, 607, 610>, 0, <610, 671, 546>, 0, <769, 800, 546>, 0, <546, 608, 769>, 0, <592, 545, 673>, 0, 
			<592, 673, 625>, 0, <626, 673, 545>, 0, <545, 591, 626>, 0, <802, 803, 804>, 0, <802, 804, 816>, 0, <804, 805, 815>, 0, <804, 815, 816>, 0, <805, 806, 814>, 0, <805, 814, 815>, 0, <806, 807, 808>, 0, <806, 808, 812>, 0, 
			<808, 809, 811>, 0, <808, 811, 812>, 0, <809, 810, 811>, 0, <812, 813, 814>, 0, <812, 814, 806>, 0, <816, 817, 801>, 0, <816, 801, 802>, 0, <608, 609, 641>, 0, <641, 576, 608>, 0, <641, 624, 576>, 0, <624, 593, 576>, 0, 
			<577, 575, 688>, 0, <577, 688, 640>, 0, <642, 704, 592>, 0, <592, 575, 642>, 0, <574, 786, 593>, 0, <786, 784, 593>, 0, <643, 623, 594>, 0, <594, 574, 643>, 0, <573, 578, 644>, 0, <578, 690, 644>, 0, <573, 644, 689>, 0, 
			<573, 689, 577>, 0, <572, 787, 594>, 0, <787, 783, 594>, 0, <645, 622, 595>, 0, <595, 572, 645>, 0, <646, 571, 579>, 0, <646, 579, 691>, 0, <571, 646, 690>, 0, <571, 690, 578>, 0, <570, 788, 595>, 0, <788, 782, 595>, 0, 
			<647, 621, 596>, 0, <596, 570, 647>, 0, <580, 692, 648>, 0, <648, 569, 580>, 0, <569, 648, 691>, 0, <569, 691, 579>, 0, <568, 789, 781>, 0, <781, 596, 568>, 0, <620, 597, 568>, 0, <568, 649, 620>, 0, <567, 581, 693>, 0, 
			<693, 650, 567>, 0, <650, 692, 567>, 0, <692, 580, 567>, 0, <566, 790, 597>, 0, <790, 780, 597>, 0, <651, 619, 598>, 0, <598, 566, 651>, 0, <565, 582, 694>, 0, <694, 652, 565>, 0, <652, 693, 581>, 0, <652, 581, 565>, 0, 
			<564, 791, 598>, 0, <791, 779, 598>, 0, <653, 618, 599>, 0, <599, 564, 653>, 0, <563, 583, 695>, 0, <695, 654, 563>, 0, <654, 694, 582>, 0, <654, 582, 563>, 0, <562, 792, 599>, 0, <792, 778, 599>, 0, <655, 617, 600>, 0, 
			<600, 562, 655>, 0, <584, 696, 656>, 0, <656, 561, 584>, 0, <656, 695, 583>, 0, <656, 583, 561>, 0, <560, 793, 777>, 0, <777, 600, 560>, 0, <616, 601, 560>, 0, <560, 657, 616>, 0, <658, 559, 585>, 0, <658, 585, 697>, 0, 
			<658, 696, 559>, 0, <696, 584, 559>, 0, <558, 794, 601>, 0, <794, 776, 601>, 0, <659, 615, 602>, 0, <602, 558, 659>, 0, <660, 557, 586>, 0, <660, 586, 698>, 0, <557, 660, 697>, 0, <557, 697, 585>, 0, <556, 795, 602>, 0, 
			<795, 775, 602>, 0, <661, 614, 603>, 0, <603, 556, 661>, 0, <662, 555, 587>, 0, <662, 587, 699>, 0, <555, 662, 698>, 0, <555, 698, 586>, 0, <554, 796, 603>, 0, <796, 774, 603>, 0, <663, 613, 554>, 0, <613, 604, 554>, 0, 
			<553, 588, 664>, 0, <588, 700, 664>, 0, <553, 664, 699>, 0, <553, 699, 587>, 0, <552, 797, 773>, 0, <552, 773, 604>, 0, <665, 612, 552>, 0, <612, 605, 552>, 0, <551, 589, 701>, 0, <701, 666, 551>, 0, <666, 700, 588>, 0, 
			<588, 551, 666>, 0, <550, 798, 605>, 0, <798, 772, 605>, 0, <667, 611, 606>, 0, <606, 550, 667>, 0, <549, 590, 702>, 0, <702, 668, 549>, 0, <668, 701, 589>, 0, <668, 589, 549>, 0, <548, 799, 606>, 0, <799, 771, 606>, 0, 
			<669, 610, 607>, 0, <607, 548, 669>, 0, <547, 591, 703>, 0, <703, 670, 547>, 0, <670, 702, 590>, 0, <670, 590, 547>, 0, <546, 800, 607>, 0, <800, 770, 607>, 0, <671, 609, 608>, 0, <671, 608, 546>, 0, <545, 592, 672>, 0, 
			<592, 704, 672>, 0, <672, 703, 591>, 0, <672, 591, 545>, 0, <449, 768, 482>, 0, <768, 736, 482>, 0, <464, 482, 736>, 0, <736, 738, 464>, 0, <689, 512, 529>, 0, <689, 529, 642>, 0, <514, 688, 625>, 0, <514, 625, 465>, 0, 
			<530, 643, 512>, 0, <643, 624, 512>, 0, <510, 734, 463>, 0, <734, 740, 463>, 0, <479, 639, 528>, 0, <639, 687, 528>, 0, <528, 687, 640>, 0, <528, 640, 480>, 0, <531, 645, 511>, 0, <645, 623, 511>, 0, <508, 732, 742>, 0, 
			<508, 742, 462>, 0, <478, 638, 527>, 0, <638, 686, 527>, 0, <527, 686, 479>, 0, <686, 639, 479>, 0, <532, 647, 509>, 0, <647, 622, 509>, 0, <506, 730, 744>, 0, <506, 744, 461>, 0, <477, 637, 526>, 0, <637, 685, 526>, 0, 
			<526, 685, 638>, 0, <526, 638, 478>, 0, <533, 649, 507>, 0, <649, 621, 507>, 0, <728, 746, 460>, 0, <460, 504, 728>, 0, <525, 476, 636>, 0, <525, 636, 684>, 0, <525, 684, 637>, 0, <637, 477, 525>, 0, <534, 651, 505>, 0, 
			<651, 620, 505>, 0, <726, 748, 459>, 0, <459, 502, 726>, 0, <475, 635, 683>, 0, <683, 524, 475>, 0, <524, 683, 636>, 0, <636, 476, 524>, 0, <535, 653, 503>, 0, <653, 619, 503>, 0, <500, 724, 750>, 0, <500, 750, 458>, 0, 
			<474, 634, 523>, 0, <634, 682, 523>, 0, <523, 682, 635>, 0, <635, 475, 523>, 0, <536, 655, 501>, 0, <655, 618, 501>, 0, <498, 722, 752>, 0, <498, 752, 457>, 0, <473, 633, 522>, 0, <633, 681, 522>, 0, <522, 681, 634>, 0, 
			<522, 634, 474>, 0, <537, 657, 499>, 0, <657, 617, 499>, 0, <720, 754, 456>, 0, <456, 496, 720>, 0, <521, 472, 632>, 0, <521, 632, 680>, 0, <521, 680, 473>, 0, <680, 633, 473>, 0, <538, 659, 497>, 0, <659, 616, 497>, 0, 
			<718, 756, 455>, 0, <455, 494, 718>, 0, <631, 679, 520>, 0, <520, 471, 631>, 0, <520, 679, 632>, 0, <520, 632, 472>, 0, <539, 661, 495>, 0, <661, 615, 495>, 0, <492, 716, 758>, 0, <758, 454, 492>, 0, <630, 678, 519>, 0, 
			<519, 470, 630>, 0, <678, 631, 471>, 0, <471, 519, 678>, 0, <540, 663, 493>, 0, <663, 614, 493>, 0, <490, 714, 760>, 0, <760, 453, 490>, 0, <629, 677, 518>, 0, <518, 469, 629>, 0, <518, 677, 630>, 0, <518, 630, 470>, 0, 
			<541, 665, 491>, 0, <665, 613, 491>, 0, <488, 712, 452>, 0, <712, 762, 452>, 0, <517, 468, 628>, 0, <517, 628, 676>, 0, <517, 676, 629>, 0, <517, 629, 469>, 0, <542, 667, 489>, 0, <667, 612, 489>, 0, <486, 710, 451>, 0, 
			<710, 764, 451>, 0, <467, 627, 675>, 0, <467, 675, 516>, 0, <516, 675, 628>, 0, <516, 628, 468>, 0, <543, 669, 487>, 0, <669, 611, 487>, 0, <484, 708, 766>, 0, <766, 450, 484>, 0, <466, 626, 515>, 0, <626, 674, 515>, 0, 
			<515, 674, 627>, 0, <515, 627, 467>, 0, <544, 671, 485>, 0, <671, 610, 485>, 0, <481, 706, 768>, 0, <768, 449, 481>, 0, <625, 673, 513>, 0, <513, 465, 625>, 0, <513, 673, 626>, 0, <513, 626, 466>, 0, <529, 641, 483>, 0, 
			<641, 609, 483>, 0, <512, 624, 529>, 0, <624, 641, 529>, 0, <514, 480, 640>, 0, <514, 640, 688>, 0, <483, 704, 642>, 0, <483, 642, 529>, 0, <738, 734, 510>, 0, <738, 510, 464>, 0, <511, 623, 530>, 0, <623, 643, 530>, 0, 
			<690, 511, 530>, 0, <690, 530, 644>, 0, <512, 689, 644>, 0, <512, 644, 530>, 0, <732, 508, 463>, 0, <463, 740, 732>, 0, <509, 622, 531>, 0, <622, 645, 531>, 0, <691, 509, 531>, 0, <691, 531, 646>, 0, <511, 690, 646>, 0, 
			<511, 646, 531>, 0, <730, 506, 462>, 0, <462, 742, 730>, 0, <507, 621, 532>, 0, <621, 647, 532>, 0, <507, 532, 692>, 0, <532, 648, 692>, 0, <509, 691, 648>, 0, <509, 648, 532>, 0, <744, 728, 504>, 0, <504, 461, 744>, 0, 
			<505, 620, 533>, 0, <620, 649, 533>, 0, <505, 533, 650>, 0, <505, 650, 693>, 0, <692, 650, 533>, 0, <533, 507, 692>, 0, <746, 726, 502>, 0, <502, 460, 746>, 0, <503, 619, 534>, 0, <619, 651, 534>, 0, <503, 534, 652>, 0, 
			<503, 652, 694>, 0, <693, 652, 534>, 0, <693, 534, 505>, 0, <724, 500, 459>, 0, <459, 748, 724>, 0, <501, 618, 535>, 0, <618, 653, 535>, 0, <501, 535, 654>, 0, <501, 654, 695>, 0, <694, 654, 535>, 0, <694, 535, 503>, 0, 
			<722, 498, 458>, 0, <458, 750, 722>, 0, <499, 617, 536>, 0, <617, 655, 536>, 0, <499, 536, 656>, 0, <499, 656, 696>, 0, <695, 656, 536>, 0, <695, 536, 501>, 0, <752, 720, 496>, 0, <496, 457, 752>, 0, <497, 616, 537>, 0, 
			<616, 657, 537>, 0, <697, 497, 537>, 0, <697, 537, 658>, 0, <658, 537, 499>, 0, <499, 696, 658>, 0, <754, 718, 494>, 0, <494, 456, 754>, 0, <495, 615, 538>, 0, <615, 659, 538>, 0, <698, 495, 538>, 0, <698, 538, 660>, 0, 
			<497, 697, 660>, 0, <497, 660, 538>, 0, <756, 716, 455>, 0, <716, 492, 455>, 0, <493, 614, 539>, 0, <614, 661, 539>, 0, <699, 493, 539>, 0, <699, 539, 662>, 0, <495, 698, 662>, 0, <495, 662, 539>, 0, <758, 714, 454>, 0, 
			<714, 490, 454>, 0, <491, 613, 540>, 0, <613, 663, 540>, 0, <540, 664, 700>, 0, <700, 491, 540>, 0, <493, 699, 664>, 0, <493, 664, 540>, 0, <760, 712, 488>, 0, <760, 488, 453>, 0, <489, 612, 541>, 0, <612, 665, 541>, 0, 
			<489, 541, 666>, 0, <489, 666, 701>, 0, <700, 666, 541>, 0, <700, 541, 491>, 0, <762, 710, 486>, 0, <762, 486, 452>, 0, <487, 611, 542>, 0, <611, 667, 542>, 0, <487, 542, 668>, 0, <487, 668, 702>, 0, <701, 668, 542>, 0, 
			<701, 542, 489>, 0, <764, 708, 451>, 0, <708, 484, 451>, 0, <485, 610, 543>, 0, <610, 669, 543>, 0, <485, 543, 670>, 0, <485, 670, 703>, 0, <702, 670, 543>, 0, <702, 543, 487>, 0, <766, 706, 450>, 0, <706, 481, 450>, 0, 
			<483, 609, 544>, 0, <609, 671, 544>, 0, <483, 544, 672>, 0, <672, 704, 483>, 0, <703, 672, 544>, 0, <703, 544, 485>, 0, <419, 481, 418>, 0, <481, 449, 418>, 0, <418, 449, 417>, 0, <449, 482, 417>, 0, <417, 482, 448>, 0, 
			<482, 464, 448>, 0, <448, 464, 447>, 0, <464, 510, 447>, 0, <447, 510, 446>, 0, <510, 463, 446>, 0, <446, 463, 508>, 0, <446, 508, 445>, 0, <445, 508, 462>, 0, <445, 462, 444>, 0, <444, 462, 506>, 0, <444, 506, 443>, 0, 
			<443, 506, 461>, 0, <443, 461, 442>, 0, <442, 461, 504>, 0, <442, 504, 441>, 0, <504, 460, 440>, 0, <440, 441, 504>, 0, <460, 502, 439>, 0, <439, 440, 460>, 0, <502, 459, 438>, 0, <438, 439, 502>, 0, <438, 459, 500>, 0, 
			<438, 500, 437>, 0, <437, 500, 458>, 0, <437, 458, 436>, 0, <436, 458, 498>, 0, <436, 498, 435>, 0, <435, 498, 457>, 0, <435, 457, 434>, 0, <434, 457, 496>, 0, <434, 496, 433>, 0, <496, 456, 432>, 0, <432, 433, 496>, 0, 
			<456, 494, 431>, 0, <431, 432, 456>, 0, <494, 455, 430>, 0, <430, 431, 494>, 0, <430, 455, 492>, 0, <492, 429, 430>, 0, <429, 492, 454>, 0, <454, 428, 429>, 0, <428, 454, 490>, 0, <490, 427, 428>, 0, <427, 490, 426>, 0, 
			<490, 453, 426>, 0, <426, 453, 425>, 0, <453, 488, 425>, 0, <425, 488, 424>, 0, <488, 452, 424>, 0, <424, 452, 423>, 0, <452, 486, 423>, 0, <423, 486, 422>, 0, <486, 451, 422>, 0, <422, 451, 484>, 0, <484, 421, 422>, 0, 
			<421, 484, 450>, 0, <450, 420, 421>, 0, <420, 450, 481>, 0, <481, 419, 420>, 0, <722, 750, 721>, 0, <750, 749, 721>, 0, <751, 752, 722>, 0, <722, 721, 751>, 0, <741, 742, 732>, 0, <732, 731, 741>, 0, <736, 768, 767>, 0, 
			<767, 735, 736>, 0, <719, 753, 754>, 0, <754, 720, 719>, 0, <749, 750, 724>, 0, <724, 723, 749>, 0, <716, 756, 755>, 0, <716, 755, 715>, 0, <727, 745, 746>, 0, <746, 728, 727>, 0, <743, 744, 730>, 0, <730, 729, 743>, 0, 
			<717, 755, 718>, 0, <755, 756, 718>, 0, <735, 737, 738>, 0, <735, 738, 736>, 0, <709, 763, 710>, 0, <763, 764, 710>, 0, <705, 767, 706>, 0, <767, 768, 706>, 0, <734, 738, 737>, 0, <737, 733, 734>, 0, <733, 739, 734>, 0, 
			<739, 740, 734>, 0, <715, 757, 716>, 0, <757, 758, 716>, 0, <710, 762, 761>, 0, <761, 709, 710>, 0, <708, 764, 763>, 0, <708, 763, 707>, 0, <725, 747, 726>, 0, <747, 748, 726>, 0, <711, 761, 762>, 0, <711, 762, 712>, 0, 
			<730, 742, 729>, 0, <742, 741, 729>, 0, <720, 752, 751>, 0, <720, 751, 719>, 0, <712, 760, 759>, 0, <759, 711, 712>, 0, <707, 765, 708>, 0, <765, 766, 708>, 0, <758, 757, 713>, 0, <713, 714, 758>, 0, <766, 765, 705>, 0, 
			<705, 706, 766>, 0, <718, 754, 753>, 0, <718, 753, 717>, 0, <728, 744, 743>, 0, <728, 743, 727>, 0, <726, 746, 745>, 0, <726, 745, 725>, 0, <713, 759, 714>, 0, <759, 760, 714>, 0, <724, 748, 747>, 0, <724, 747, 723>, 0, 
			<732, 740, 739>, 0, <732, 739, 731>, 0, <735, 767, 769>, 0, <735, 769, 785>, 0, <785, 784, 735>, 0, <784, 737, 735>, 0, <786, 783, 733>, 0, <783, 739, 733>, 0, <787, 782, 731>, 0, <782, 741, 731>, 0, <788, 781, 729>, 0, 
			<781, 743, 729>, 0, <789, 780, 727>, 0, <780, 745, 727>, 0, <790, 779, 725>, 0, <779, 747, 725>, 0, <791, 778, 723>, 0, <778, 749, 723>, 0, <792, 777, 721>, 0, <777, 751, 721>, 0, <793, 776, 719>, 0, <776, 753, 719>, 0, 
			<794, 775, 717>, 0, <775, 755, 717>, 0, <795, 774, 715>, 0, <774, 757, 715>, 0, <796, 773, 713>, 0, <773, 759, 713>, 0, <797, 772, 711>, 0, <772, 761, 711>, 0, <798, 771, 709>, 0, <771, 763, 709>, 0, <799, 770, 707>, 0, 
			<770, 765, 707>, 0, <800, 769, 705>, 0, <769, 767, 705>, 0, <733, 737, 784>, 0, <733, 784, 786>, 0, <731, 739, 783>, 0, <731, 783, 787>, 0, <729, 741, 782>, 0, <729, 782, 788>, 0, <727, 743, 781>, 0, <727, 781, 789>, 0, 
			<725, 745, 780>, 0, <725, 780, 790>, 0, <723, 747, 779>, 0, <723, 779, 791>, 0, <721, 749, 778>, 0, <721, 778, 792>, 0, <719, 751, 777>, 0, <719, 777, 793>, 0, <717, 753, 776>, 0, <717, 776, 794>, 0, <715, 755, 775>, 0, 
			<715, 775, 795>, 0, <713, 757, 774>, 0, <713, 774, 796>, 0, <711, 759, 773>, 0, <711, 773, 797>, 0, <709, 761, 772>, 0, <709, 772, 798>, 0, <707, 763, 771>, 0, <707, 771, 799>, 0, <705, 765, 770>, 0, <705, 770, 800>, 0, 
			<821, 819, 820>, 0, <821, 818, 819>, 0, <825, 823, 824>, 0, <825, 831, 823>, 0, <826, 827, 828>, 0, <828, 829, 826>, 0, <829, 825, 826>, 0, <831, 825, 829>, 0, <831, 829, 830>, 0, <831, 832, 823>, 0, <832, 822, 823>, 0, 
			<832, 833, 822>, 0, <833, 821, 822>, 0, <818, 821, 833>, 0, <818, 833, 834>, 0, <477, 802, 801>, 0, <477, 801, 469>, 0, <526, 803, 802>, 0, <802, 477, 526>, 0, <804, 803, 526>, 0, <526, 478, 804>, 0, <805, 804, 478>, 0, 
			<478, 527, 805>, 0, <806, 805, 527>, 0, <527, 479, 806>, 0, <807, 806, 479>, 0, <479, 528, 807>, 0, <808, 807, 528>, 0, <528, 480, 808>, 0, <809, 808, 480>, 0, <480, 514, 809>, 0, <810, 809, 514>, 0, <514, 465, 810>, 0, 
			<811, 810, 465>, 0, <465, 513, 811>, 0, <812, 811, 513>, 0, <513, 466, 812>, 0, <813, 812, 466>, 0, <466, 515, 813>, 0, <814, 813, 515>, 0, <515, 467, 814>, 0, <815, 814, 467>, 0, <467, 516, 815>, 0, <816, 815, 516>, 0, 
			<516, 468, 816>, 0, <817, 816, 468>, 0, <468, 517, 817>, 0, <801, 817, 517>, 0, <517, 469, 801>, 0, <469, 819, 818>, 0, <818, 477, 469>, 0, <518, 820, 819>, 0, <819, 469, 518>, 0, <821, 820, 518>, 0, <518, 470, 821>, 0, 
			<822, 821, 470>, 0, <470, 519, 822>, 0, <823, 822, 519>, 0, <519, 471, 823>, 0, <824, 823, 471>, 0, <471, 520, 824>, 0, <825, 824, 520>, 0, <520, 472, 825>, 0, <826, 825, 472>, 0, <472, 521, 826>, 0, <827, 826, 521>, 0, 
			<521, 473, 827>, 0, <828, 827, 473>, 0, <473, 522, 828>, 0, <829, 828, 522>, 0, <522, 474, 829>, 0, <830, 829, 474>, 0, <474, 523, 830>, 0, <831, 830, 523>, 0, <523, 475, 831>, 0, <832, 831, 475>, 0, <475, 524, 832>, 0, 
			<833, 832, 524>, 0, <524, 476, 833>, 0, <834, 833, 476>, 0, <476, 525, 834>, 0, <818, 834, 525>, 0, <525, 477, 818>, 0}
	 normal_indices { 1666, <0, 100, 305>, <0, 305, 97>, <1, 97, 103>, <97, 305, 103>, <96, 103, 305>, <305, 100, 96>, <1, 103, 306>, <1, 306, 101>, <2, 101, 306>, <2, 306, 106>, 
			<106, 306, 103>, <103, 96, 106>, <2, 106, 307>, <2, 307, 104>, <3, 104, 307>, <3, 307, 109>, <96, 109, 307>, <307, 106, 96>, <109, 308, 107>, <107, 3, 109>, <4, 107, 308>, 
			<4, 308, 112>, <96, 112, 308>, <308, 109, 96>, <4, 112, 309>, <4, 309, 110>, <5, 110, 115>, <110, 309, 115>, <96, 115, 309>, <309, 112, 96>, <5, 115, 310>, <5, 310, 113>, 
			<6, 113, 310>, <310, 118, 6>, <118, 310, 115>, <115, 96, 118>, <6, 118, 311>, <6, 311, 116>, <7, 116, 311>, <311, 121, 7>, <121, 311, 118>, <118, 96, 121>, <7, 121, 119>, 
			<121, 312, 119>, <8, 119, 312>, <312, 124, 8>, <96, 124, 312>, <96, 312, 121>, <8, 124, 313>, <313, 122, 8>, <122, 313, 127>, <127, 9, 122>, <96, 127, 313>, <96, 313, 124>, 
			<9, 127, 314>, <314, 125, 9>, <10, 125, 314>, <314, 130, 10>, <96, 130, 314>, <96, 314, 127>, <10, 130, 315>, <315, 128, 10>, <11, 128, 315>, <315, 133, 11>, <133, 315, 130>, 
			<130, 96, 133>, <11, 133, 131>, <133, 316, 131>, <12, 131, 316>, <316, 136, 12>, <96, 136, 316>, <96, 316, 133>, <12, 136, 317>, <317, 134, 12>, <134, 317, 139>, <139, 13, 134>, 
			<96, 139, 317>, <96, 317, 136>, <13, 139, 318>, <318, 137, 13>, <14, 137, 318>, <14, 318, 142>, <96, 142, 318>, <96, 318, 139>, <14, 142, 319>, <319, 140, 14>, <15, 140, 319>, 
			<15, 319, 144>, <96, 144, 319>, <319, 142, 96>, <144, 320, 98>, <98, 15, 144>, <320, 100, 0>, <0, 98, 320>, <100, 320, 96>, <320, 144, 96>, <102, 321, 1>, <321, 97, 1>, 
			<97, 321, 0>, <321, 99, 0>, <16, 99, 321>, <16, 321, 145>, <17, 145, 102>, <145, 321, 102>, <105, 322, 2>, <322, 101, 2>, <101, 322, 102>, <102, 1, 101>, <17, 102, 322>, 
			<17, 322, 148>, <18, 148, 105>, <148, 322, 105>, <108, 323, 104>, <108, 104, 3>, <104, 323, 2>, <323, 105, 2>, <105, 323, 150>, <150, 18, 105>, <19, 150, 323>, <19, 323, 108>, 
			<111, 324, 107>, <111, 107, 4>, <107, 324, 3>, <324, 108, 3>, <108, 324, 152>, <152, 19, 108>, <20, 152, 324>, <20, 324, 111>, <114, 325, 5>, <325, 110, 5>, <110, 325, 4>, 
			<325, 111, 4>, <20, 111, 325>, <20, 325, 154>, <21, 154, 114>, <154, 325, 114>, <117, 326, 6>, <326, 113, 6>, <113, 326, 114>, <114, 5, 113>, <21, 114, 326>, <21, 326, 156>, 
			<22, 156, 117>, <156, 326, 117>, <120, 327, 116>, <116, 7, 120>, <327, 117, 6>, <6, 116, 327>, <22, 117, 158>, <117, 327, 158>, <23, 158, 327>, <327, 120, 23>, <328, 119, 8>, 
			<8, 123, 328>, <328, 120, 7>, <7, 119, 328>, <23, 120, 160>, <120, 328, 160>, <160, 328, 123>, <123, 24, 160>, <329, 122, 9>, <9, 126, 329>, <122, 329, 123>, <122, 123, 8>, 
			<24, 123, 329>, <329, 162, 24>, <162, 329, 126>, <126, 25, 162>, <330, 125, 10>, <10, 129, 330>, <125, 330, 126>, <125, 126, 9>, <25, 126, 330>, <330, 164, 25>, <164, 330, 129>, 
			<129, 26, 164>, <132, 331, 128>, <128, 11, 132>, <331, 129, 10>, <10, 128, 331>, <26, 129, 166>, <129, 331, 166>, <27, 166, 331>, <331, 132, 27>, <332, 131, 12>, <12, 135, 332>, 
			<332, 132, 11>, <11, 131, 332>, <27, 132, 168>, <132, 332, 168>, <168, 332, 135>, <135, 28, 168>, <333, 134, 13>, <13, 138, 333>, <134, 333, 135>, <134, 135, 12>, <28, 135, 333>, 
			<333, 170, 28>, <170, 333, 138>, <138, 29, 170>, <334, 137, 14>, <14, 141, 334>, <137, 334, 138>, <137, 138, 13>, <29, 138, 334>, <334, 172, 29>, <172, 334, 141>, <141, 30, 172>, 
			<143, 335, 140>, <143, 140, 15>, <140, 335, 14>, <335, 141, 14>, <141, 335, 174>, <174, 30, 141>, <31, 174, 335>, <31, 335, 143>, <0, 99, 98>, <99, 336, 98>, <15, 98, 336>, 
			<336, 143, 15>, <143, 336, 146>, <146, 31, 143>, <336, 99, 16>, <16, 146, 336>, <149, 337, 17>, <337, 145, 17>, <145, 337, 147>, <147, 16, 145>, <32, 147, 337>, <32, 337, 177>, 
			<33, 177, 149>, <177, 337, 149>, <151, 338, 18>, <338, 148, 18>, <148, 338, 149>, <149, 17, 148>, <33, 149, 338>, <33, 338, 180>, <34, 180, 338>, <338, 151, 34>, <153, 339, 150>, 
			<153, 150, 19>, <150, 339, 18>, <339, 151, 18>, <34, 151, 182>, <151, 339, 182>, <35, 182, 339>, <35, 339, 153>, <155, 340, 152>, <155, 152, 20>, <152, 340, 19>, <340, 153, 19>, 
			<153, 340, 184>, <184, 35, 153>, <36, 184, 340>, <36, 340, 155>, <157, 341, 21>, <341, 154, 21>, <154, 341, 20>, <341, 155, 20>, <155, 341, 186>, <186, 36, 155>, <37, 186, 157>, 
			<186, 341, 157>, <159, 342, 22>, <342, 156, 22>, <156, 342, 157>, <157, 21, 156>, <37, 157, 342>, <37, 342, 188>, <38, 188, 342>, <342, 159, 38>, <161, 343, 158>, <158, 23, 161>, 
			<343, 159, 22>, <22, 158, 343>, <38, 159, 190>, <159, 343, 190>, <39, 190, 343>, <343, 161, 39>, <344, 160, 24>, <24, 163, 344>, <344, 161, 23>, <23, 160, 344>, <39, 161, 192>, 
			<161, 344, 192>, <192, 344, 163>, <163, 40, 192>, <345, 162, 25>, <25, 165, 345>, <162, 345, 163>, <162, 163, 24>, <40, 163, 345>, <345, 194, 40>, <194, 345, 165>, <165, 41, 194>, 
			<346, 164, 26>, <26, 167, 346>, <164, 346, 165>, <164, 165, 25>, <41, 165, 346>, <346, 196, 41>, <42, 196, 346>, <346, 167, 42>, <169, 347, 166>, <166, 27, 169>, <347, 167, 26>, 
			<26, 166, 347>, <42, 167, 198>, <167, 347, 198>, <43, 198, 347>, <347, 169, 43>, <348, 168, 28>, <28, 171, 348>, <348, 169, 27>, <27, 168, 348>, <43, 169, 200>, <169, 348, 200>, 
			<200, 348, 171>, <171, 44, 200>, <349, 170, 29>, <29, 173, 349>, <170, 349, 171>, <170, 171, 28>, <44, 171, 349>, <349, 202, 44>, <202, 349, 173>, <173, 45, 202>, <350, 172, 30>, 
			<30, 175, 350>, <172, 350, 173>, <172, 173, 29>, <45, 173, 350>, <350, 204, 45>, <46, 204, 350>, <350, 175, 46>, <176, 351, 174>, <176, 174, 31>, <174, 351, 30>, <351, 175, 30>, 
			<46, 175, 206>, <175, 351, 206>, <47, 206, 351>, <47, 351, 176>, <16, 147, 146>, <147, 352, 146>, <31, 146, 352>, <352, 176, 31>, <176, 352, 178>, <178, 47, 176>, <352, 147, 32>, 
			<32, 178, 352>, <181, 353, 33>, <353, 177, 33>, <177, 353, 179>, <179, 32, 177>, <48, 179, 209>, <179, 353, 209>, <49, 209, 353>, <353, 181, 49>, <183, 354, 180>, <180, 34, 183>, 
			<354, 181, 33>, <33, 180, 354>, <49, 181, 212>, <181, 354, 212>, <50, 212, 354>, <354, 183, 50>, <185, 355, 182>, <182, 35, 185>, <355, 183, 34>, <34, 182, 355>, <50, 183, 214>, 
			<183, 355, 214>, <51, 214, 355>, <355, 185, 51>, <187, 356, 184>, <187, 184, 36>, <184, 356, 35>, <356, 185, 35>, <51, 185, 356>, <51, 356, 216>, <52, 216, 356>, <356, 187, 52>, 
			<189, 357, 37>, <357, 186, 37>, <186, 357, 187>, <187, 36, 186>, <52, 187, 218>, <187, 357, 218>, <53, 218, 357>, <357, 189, 53>, <191, 358, 188>, <188, 38, 191>, <358, 189, 37>, 
			<37, 188, 358>, <53, 189, 220>, <189, 358, 220>, <54, 220, 358>, <358, 191, 54>, <193, 359, 190>, <190, 39, 193>, <359, 191, 38>, <38, 190, 359>, <54, 191, 222>, <191, 359, 222>, 
			<55, 222, 359>, <359, 193, 55>, <360, 192, 40>, <40, 195, 360>, <360, 193, 39>, <39, 192, 360>, <55, 193, 224>, <193, 360, 224>, <56, 224, 360>, <360, 195, 56>, <361, 194, 41>, 
			<41, 197, 361>, <194, 361, 195>, <194, 195, 40>, <56, 195, 226>, <195, 361, 226>, <57, 226, 361>, <361, 197, 57>, <199, 362, 196>, <196, 42, 199>, <362, 197, 41>, <41, 196, 362>, 
			<57, 197, 228>, <197, 362, 228>, <58, 228, 362>, <362, 199, 58>, <201, 363, 198>, <198, 43, 201>, <363, 199, 42>, <42, 198, 363>, <58, 199, 230>, <199, 363, 230>, <59, 230, 363>, 
			<363, 201, 59>, <364, 200, 44>, <44, 203, 364>, <364, 201, 43>, <43, 200, 364>, <59, 201, 232>, <201, 364, 232>, <60, 232, 364>, <364, 203, 60>, <365, 202, 45>, <45, 205, 365>, 
			<202, 365, 203>, <202, 203, 44>, <60, 203, 234>, <203, 365, 234>, <61, 234, 365>, <365, 205, 61>, <207, 366, 204>, <204, 46, 207>, <366, 205, 45>, <45, 204, 366>, <61, 205, 236>, 
			<205, 366, 236>, <62, 236, 366>, <366, 207, 62>, <208, 367, 206>, <206, 47, 208>, <206, 367, 207>, <207, 46, 206>, <62, 207, 238>, <207, 367, 238>, <63, 238, 367>, <367, 208, 63>, 
			<32, 179, 178>, <179, 368, 178>, <47, 178, 368>, <368, 208, 47>, <208, 368, 210>, <208, 210, 63>, <210, 368, 48>, <368, 179, 48>, <213, 369, 209>, <209, 49, 213>, <209, 369, 211>, 
			<211, 48, 209>, <211, 369, 241>, <241, 64, 211>, <65, 241, 369>, <369, 213, 65>, <215, 370, 212>, <212, 50, 215>, <370, 213, 49>, <49, 212, 370>, <65, 213, 244>, <213, 370, 244>, 
			<66, 244, 370>, <370, 215, 66>, <217, 371, 214>, <214, 51, 217>, <371, 215, 50>, <50, 214, 371>, <66, 215, 246>, <215, 371, 246>, <67, 246, 371>, <371, 217, 67>, <219, 372, 216>, 
			<216, 52, 219>, <372, 217, 51>, <51, 216, 372>, <67, 217, 248>, <217, 372, 248>, <68, 248, 219>, <248, 372, 219>, <221, 373, 218>, <218, 53, 221>, <218, 373, 219>, <219, 52, 218>, 
			<219, 373, 250>, <250, 68, 219>, <69, 250, 373>, <373, 221, 69>, <223, 374, 54>, <374, 220, 54>, <374, 221, 53>, <53, 220, 374>, <69, 221, 252>, <221, 374, 252>, <70, 252, 374>, 
			<374, 223, 70>, <225, 375, 222>, <222, 55, 225>, <375, 223, 54>, <54, 222, 375>, <70, 223, 254>, <223, 375, 254>, <71, 254, 375>, <375, 225, 71>, <227, 376, 224>, <224, 56, 227>, 
			<376, 225, 55>, <55, 224, 376>, <71, 225, 256>, <225, 376, 256>, <256, 376, 227>, <227, 72, 256>, <229, 377, 226>, <226, 57, 229>, <226, 377, 227>, <227, 56, 226>, <72, 227, 258>, 
			<227, 377, 258>, <73, 258, 377>, <377, 229, 73>, <231, 378, 58>, <378, 228, 58>, <378, 229, 57>, <57, 228, 378>, <73, 229, 260>, <229, 378, 260>, <74, 260, 378>, <378, 231, 74>, 
			<233, 379, 230>, <230, 59, 233>, <379, 231, 58>, <58, 230, 379>, <74, 231, 262>, <231, 379, 262>, <75, 262, 379>, <379, 233, 75>, <235, 380, 232>, <232, 60, 235>, <380, 233, 59>, 
			<59, 232, 380>, <75, 233, 264>, <233, 380, 264>, <76, 264, 380>, <380, 235, 76>, <237, 381, 234>, <234, 61, 237>, <234, 381, 235>, <235, 60, 234>, <76, 235, 266>, <235, 381, 266>, 
			<77, 266, 381>, <381, 237, 77>, <239, 382, 62>, <382, 236, 62>, <382, 237, 61>, <61, 236, 382>, <77, 237, 268>, <237, 382, 268>, <78, 268, 382>, <382, 239, 78>, <240, 383, 238>, 
			<238, 63, 240>, <383, 239, 62>, <62, 238, 383>, <78, 239, 270>, <239, 383, 270>, <79, 270, 383>, <383, 240, 79>, <211, 384, 210>, <210, 48, 211>, <63, 210, 384>, <63, 384, 240>, 
			<240, 384, 242>, <240, 242, 79>, <242, 384, 211>, <242, 211, 64>, <245, 385, 241>, <245, 241, 65>, <241, 385, 243>, <243, 64, 241>, <80, 243, 385>, <80, 385, 273>, <81, 273, 385>, 
			<81, 385, 245>, <247, 386, 244>, <244, 66, 247>, <386, 245, 65>, <65, 244, 386>, <81, 245, 276>, <245, 386, 276>, <82, 276, 386>, <386, 247, 82>, <249, 387, 246>, <246, 67, 249>, 
			<387, 247, 66>, <66, 246, 387>, <82, 247, 278>, <247, 387, 278>, <83, 278, 387>, <387, 249, 83>, <251, 388, 68>, <388, 248, 68>, <248, 388, 249>, <249, 67, 248>, <83, 249, 388>, 
			<83, 388, 280>, <84, 280, 251>, <280, 388, 251>, <253, 389, 250>, <253, 250, 69>, <250, 389, 251>, <251, 68, 250>, <84, 251, 389>, <84, 389, 282>, <85, 282, 389>, <85, 389, 253>, 
			<255, 390, 252>, <252, 70, 255>, <390, 253, 69>, <69, 252, 390>, <85, 253, 284>, <253, 390, 284>, <86, 284, 390>, <390, 255, 86>, <257, 391, 254>, <254, 71, 257>, <391, 255, 70>, 
			<70, 254, 391>, <86, 255, 286>, <255, 391, 286>, <87, 286, 391>, <391, 257, 87>, <259, 392, 256>, <256, 72, 259>, <256, 392, 257>, <256, 257, 71>, <87, 257, 392>, <392, 288, 87>, 
			<88, 288, 392>, <392, 259, 88>, <261, 393, 258>, <258, 73, 261>, <393, 259, 72>, <72, 258, 393>, <88, 259, 290>, <259, 393, 290>, <89, 290, 393>, <393, 261, 89>, <263, 394, 260>, 
			<260, 74, 263>, <394, 261, 73>, <73, 260, 394>, <89, 261, 292>, <261, 394, 292>, <90, 292, 394>, <394, 263, 90>, <265, 395, 75>, <395, 262, 75>, <262, 395, 263>, <263, 74, 262>, 
			<90, 263, 294>, <263, 395, 294>, <91, 294, 395>, <395, 265, 91>, <396, 264, 76>, <76, 267, 396>, <264, 396, 265>, <264, 265, 75>, <91, 265, 396>, <396, 296, 91>, <92, 296, 396>, 
			<396, 267, 92>, <269, 397, 266>, <266, 77, 269>, <397, 267, 76>, <76, 266, 397>, <92, 267, 298>, <267, 397, 298>, <93, 298, 397>, <397, 269, 93>, <271, 398, 268>, <268, 78, 271>, 
			<398, 269, 77>, <77, 268, 398>, <93, 269, 398>, <93, 398, 300>, <94, 300, 398>, <398, 271, 94>, <272, 399, 270>, <270, 79, 272>, <399, 271, 78>, <78, 270, 399>, <94, 271, 302>, 
			<271, 399, 302>, <95, 302, 399>, <399, 272, 95>, <64, 243, 400>, <400, 242, 64>, <242, 400, 272>, <272, 79, 242>, <400, 274, 95>, <95, 272, 400>, <274, 400, 243>, <274, 243, 80>, 
			<277, 401, 273>, <277, 273, 81>, <273, 401, 80>, <401, 275, 80>, <279, 402, 276>, <276, 82, 279>, <276, 402, 277>, <277, 81, 276>, <281, 403, 278>, <278, 83, 281>, <278, 403, 279>, 
			<279, 82, 278>, <283, 404, 84>, <404, 280, 84>, <280, 404, 281>, <281, 83, 280>, <285, 405, 282>, <285, 282, 85>, <282, 405, 84>, <405, 283, 84>, <287, 406, 284>, <284, 86, 287>, 
			<284, 406, 285>, <285, 85, 284>, <289, 407, 286>, <286, 87, 289>, <286, 407, 287>, <287, 86, 286>, <408, 288, 88>, <88, 291, 408>, <288, 408, 289>, <288, 289, 87>, <293, 409, 290>, 
			<290, 89, 293>, <409, 291, 88>, <88, 290, 409>, <295, 410, 292>, <292, 90, 295>, <292, 410, 293>, <293, 89, 292>, <297, 411, 294>, <294, 91, 297>, <294, 411, 295>, <295, 90, 294>, 
			<412, 296, 92>, <92, 299, 412>, <296, 412, 297>, <296, 297, 91>, <301, 413, 298>, <298, 93, 301>, <413, 299, 92>, <92, 298, 413>, <303, 414, 300>, <300, 94, 303>, <300, 414, 301>, 
			<301, 93, 300>, <304, 415, 302>, <302, 95, 304>, <302, 415, 303>, <303, 94, 302>, <80, 275, 416>, <416, 274, 80>, <274, 416, 304>, <304, 95, 274>, <418, 417, 416>, <416, 275, 418>, 
			<419, 418, 275>, <275, 401, 419>, <420, 419, 401>, <401, 277, 420>, <421, 420, 277>, <277, 402, 421>, <422, 421, 402>, <402, 279, 422>, <423, 422, 279>, <279, 403, 423>, <424, 423, 403>, 
			<403, 281, 424>, <425, 424, 281>, <281, 404, 425>, <426, 425, 404>, <404, 283, 426>, <427, 426, 283>, <283, 405, 427>, <428, 427, 405>, <405, 285, 428>, <429, 428, 285>, <285, 406, 429>, 
			<430, 429, 406>, <406, 287, 430>, <431, 430, 287>, <287, 407, 431>, <432, 431, 407>, <407, 289, 432>, <433, 432, 289>, <289, 408, 433>, <434, 433, 408>, <408, 291, 434>, <435, 434, 291>, 
			<291, 409, 435>, <436, 435, 409>, <409, 293, 436>, <437, 436, 293>, <293, 410, 437>, <438, 437, 410>, <410, 295, 438>, <439, 438, 295>, <295, 411, 439>, <440, 439, 411>, <411, 297, 440>, 
			<441, 440, 297>, <297, 412, 441>, <442, 441, 412>, <412, 299, 442>, <443, 442, 299>, <299, 413, 443>, <444, 443, 413>, <413, 301, 444>, <445, 444, 301>, <301, 414, 445>, <446, 445, 414>, 
			<414, 303, 446>, <447, 446, 303>, <303, 415, 447>, <448, 447, 415>, <415, 304, 448>, <417, 448, 304>, <304, 416, 417>, <576, 785, 769>, <576, 769, 608>, <593, 784, 785>, <593, 785, 576>, 
			<642, 575, 577>, <642, 577, 689>, <625, 688, 575>, <575, 592, 625>, <574, 593, 624>, <574, 624, 643>, <594, 783, 786>, <594, 786, 574>, <573, 687, 639>, <639, 578, 573>, <640, 687, 573>, 
			<573, 577, 640>, <572, 594, 623>, <572, 623, 645>, <595, 782, 787>, <595, 787, 572>, <579, 571, 686>, <579, 686, 638>, <639, 686, 571>, <571, 578, 639>, <570, 595, 622>, <570, 622, 647>, 
			<596, 781, 570>, <781, 788, 570>, <580, 569, 685>, <580, 685, 637>, <638, 685, 569>, <569, 579, 638>, <568, 596, 649>, <596, 621, 649>, <597, 780, 789>, <597, 789, 568>, <581, 567, 684>, 
			<581, 684, 636>, <637, 684, 567>, <567, 580, 637>, <597, 620, 651>, <651, 566, 597>, <598, 779, 790>, <598, 790, 566>, <582, 565, 683>, <582, 683, 635>, <636, 683, 565>, <565, 581, 636>, 
			<598, 619, 653>, <653, 564, 598>, <599, 778, 791>, <599, 791, 564>, <563, 682, 634>, <634, 583, 563>, <635, 682, 563>, <563, 582, 635>, <562, 599, 618>, <562, 618, 655>, <600, 777, 562>, 
			<777, 792, 562>, <584, 561, 681>, <584, 681, 633>, <634, 681, 561>, <561, 583, 634>, <560, 600, 657>, <600, 617, 657>, <601, 776, 793>, <601, 793, 560>, <585, 559, 680>, <585, 680, 632>, 
			<633, 680, 559>, <559, 584, 633>, <558, 601, 616>, <558, 616, 659>, <602, 775, 794>, <602, 794, 558>, <557, 679, 631>, <631, 586, 557>, <632, 679, 557>, <557, 585, 632>, <556, 602, 615>, 
			<556, 615, 661>, <603, 774, 795>, <603, 795, 556>, <587, 555, 678>, <587, 678, 630>, <631, 678, 555>, <555, 586, 631>, <554, 603, 614>, <614, 663, 554>, <773, 796, 554>, <554, 604, 773>, 
			<588, 553, 677>, <588, 677, 629>, <630, 677, 553>, <553, 587, 630>, <604, 613, 665>, <665, 552, 604>, <605, 772, 797>, <605, 797, 552>, <589, 551, 676>, <589, 676, 628>, <629, 676, 551>, 
			<551, 588, 629>, <550, 605, 612>, <550, 612, 667>, <606, 771, 798>, <606, 798, 550>, <590, 549, 675>, <590, 675, 627>, <628, 675, 549>, <549, 589, 628>, <548, 606, 611>, <548, 611, 669>, 
			<607, 770, 799>, <607, 799, 548>, <591, 547, 674>, <591, 674, 626>, <627, 674, 547>, <547, 590, 627>, <546, 607, 610>, <610, 671, 546>, <769, 800, 546>, <546, 608, 769>, <592, 545, 673>, 
			<592, 673, 625>, <626, 673, 545>, <545, 591, 626>, <802, 803, 804>, <802, 804, 816>, <804, 805, 815>, <804, 815, 816>, <805, 806, 814>, <805, 814, 815>, <806, 807, 808>, <806, 808, 812>, 
			<808, 809, 811>, <808, 811, 812>, <809, 810, 811>, <812, 813, 814>, <812, 814, 806>, <816, 817, 801>, <816, 801, 802>, <608, 609, 641>, <641, 576, 608>, <641, 624, 576>, <624, 593, 576>, 
			<577, 575, 688>, <577, 688, 640>, <642, 704, 592>, <592, 575, 642>, <574, 786, 593>, <786, 784, 593>, <643, 623, 594>, <594, 574, 643>, <573, 578, 644>, <578, 690, 644>, <573, 644, 689>, 
			<573, 689, 577>, <572, 787, 594>, <787, 783, 594>, <645, 622, 595>, <595, 572, 645>, <646, 571, 579>, <646, 579, 691>, <571, 646, 690>, <571, 690, 578>, <570, 788, 595>, <788, 782, 595>, 
			<647, 621, 596>, <596, 570, 647>, <580, 692, 648>, <648, 569, 580>, <569, 648, 691>, <569, 691, 579>, <568, 789, 781>, <781, 596, 568>, <620, 597, 568>, <568, 649, 620>, <567, 581, 693>, 
			<693, 650, 567>, <650, 692, 567>, <692, 580, 567>, <566, 790, 597>, <790, 780, 597>, <651, 619, 598>, <598, 566, 651>, <565, 582, 694>, <694, 652, 565>, <652, 693, 581>, <652, 581, 565>, 
			<564, 791, 598>, <791, 779, 598>, <653, 618, 599>, <599, 564, 653>, <563, 583, 695>, <695, 654, 563>, <654, 694, 582>, <654, 582, 563>, <562, 792, 599>, <792, 778, 599>, <655, 617, 600>, 
			<600, 562, 655>, <584, 696, 656>, <656, 561, 584>, <656, 695, 583>, <656, 583, 561>, <560, 793, 777>, <777, 600, 560>, <616, 601, 560>, <560, 657, 616>, <658, 559, 585>, <658, 585, 697>, 
			<658, 696, 559>, <696, 584, 559>, <558, 794, 601>, <794, 776, 601>, <659, 615, 602>, <602, 558, 659>, <660, 557, 586>, <660, 586, 698>, <557, 660, 697>, <557, 697, 585>, <556, 795, 602>, 
			<795, 775, 602>, <661, 614, 603>, <603, 556, 661>, <662, 555, 587>, <662, 587, 699>, <555, 662, 698>, <555, 698, 586>, <554, 796, 603>, <796, 774, 603>, <663, 613, 554>, <613, 604, 554>, 
			<553, 588, 664>, <588, 700, 664>, <553, 664, 699>, <553, 699, 587>, <552, 797, 773>, <552, 773, 604>, <665, 612, 552>, <612, 605, 552>, <551, 589, 701>, <701, 666, 551>, <666, 700, 588>, 
			<588, 551, 666>, <550, 798, 605>, <798, 772, 605>, <667, 611, 606>, <606, 550, 667>, <549, 590, 702>, <702, 668, 549>, <668, 701, 589>, <668, 589, 549>, <548, 799, 606>, <799, 771, 606>, 
			<669, 610, 607>, <607, 548, 669>, <547, 591, 703>, <703, 670, 547>, <670, 702, 590>, <670, 590, 547>, <546, 800, 607>, <800, 770, 607>, <671, 609, 608>, <671, 608, 546>, <545, 592, 672>, 
			<592, 704, 672>, <672, 703, 591>, <672, 591, 545>, <449, 768, 482>, <768, 736, 482>, <464, 482, 736>, <736, 738, 464>, <689, 512, 529>, <689, 529, 642>, <514, 688, 625>, <514, 625, 465>, 
			<530, 643, 512>, <643, 624, 512>, <510, 734, 463>, <734, 740, 463>, <479, 639, 528>, <639, 687, 528>, <528, 687, 640>, <528, 640, 480>, <531, 645, 511>, <645, 623, 511>, <508, 732, 742>, 
			<508, 742, 462>, <478, 638, 527>, <638, 686, 527>, <527, 686, 479>, <686, 639, 479>, <532, 647, 509>, <647, 622, 509>, <506, 730, 744>, <506, 744, 461>, <477, 637, 526>, <637, 685, 526>, 
			<526, 685, 638>, <526, 638, 478>, <533, 649, 507>, <649, 621, 507>, <728, 746, 460>, <460, 504, 728>, <525, 476, 636>, <525, 636, 684>, <525, 684, 637>, <637, 477, 525>, <534, 651, 505>, 
			<651, 620, 505>, <726, 748, 459>, <459, 502, 726>, <475, 635, 683>, <683, 524, 475>, <524, 683, 636>, <636, 476, 524>, <535, 653, 503>, <653, 619, 503>, <500, 724, 750>, <500, 750, 458>, 
			<474, 634, 523>, <634, 682, 523>, <523, 682, 635>, <635, 475, 523>, <536, 655, 501>, <655, 618, 501>, <498, 722, 752>, <498, 752, 457>, <473, 633, 522>, <633, 681, 522>, <522, 681, 634>, 
			<522, 634, 474>, <537, 657, 499>, <657, 617, 499>, <720, 754, 456>, <456, 496, 720>, <521, 472, 632>, <521, 632, 680>, <521, 680, 473>, <680, 633, 473>, <538, 659, 497>, <659, 616, 497>, 
			<718, 756, 455>, <455, 494, 718>, <631, 679, 520>, <520, 471, 631>, <520, 679, 632>, <520, 632, 472>, <539, 661, 495>, <661, 615, 495>, <492, 716, 758>, <758, 454, 492>, <630, 678, 519>, 
			<519, 470, 630>, <678, 631, 471>, <471, 519, 678>, <540, 663, 493>, <663, 614, 493>, <490, 714, 760>, <760, 453, 490>, <629, 677, 518>, <518, 469, 629>, <518, 677, 630>, <518, 630, 470>, 
			<541, 665, 491>, <665, 613, 491>, <488, 712, 452>, <712, 762, 452>, <517, 468, 628>, <517, 628, 676>, <517, 676, 629>, <517, 629, 469>, <542, 667, 489>, <667, 612, 489>, <486, 710, 451>, 
			<710, 764, 451>, <467, 627, 675>, <467, 675, 516>, <516, 675, 628>, <516, 628, 468>, <543, 669, 487>, <669, 611, 487>, <484, 708, 766>, <766, 450, 484>, <466, 626, 515>, <626, 674, 515>, 
			<515, 674, 627>, <515, 627, 467>, <544, 671, 485>, <671, 610, 485>, <481, 706, 768>, <768, 449, 481>, <625, 673, 513>, <513, 465, 625>, <513, 673, 626>, <513, 626, 466>, <529, 641, 483>, 
			<641, 609, 483>, <512, 624, 529>, <624, 641, 529>, <514, 480, 640>, <514, 640, 688>, <483, 704, 642>, <483, 642, 529>, <738, 734, 510>, <738, 510, 464>, <511, 623, 530>, <623, 643, 530>, 
			<690, 511, 530>, <690, 530, 644>, <512, 689, 644>, <512, 644, 530>, <732, 508, 463>, <463, 740, 732>, <509, 622, 531>, <622, 645, 531>, <691, 509, 531>, <691, 531, 646>, <511, 690, 646>, 
			<511, 646, 531>, <730, 506, 462>, <462, 742, 730>, <507, 621, 532>, <621, 647, 532>, <507, 532, 692>, <532, 648, 692>, <509, 691, 648>, <509, 648, 532>, <744, 728, 504>, <504, 461, 744>, 
			<505, 620, 533>, <620, 649, 533>, <505, 533, 650>, <505, 650, 693>, <692, 650, 533>, <533, 507, 692>, <746, 726, 502>, <502, 460, 746>, <503, 619, 534>, <619, 651, 534>, <503, 534, 652>, 
			<503, 652, 694>, <693, 652, 534>, <693, 534, 505>, <724, 500, 459>, <459, 748, 724>, <501, 618, 535>, <618, 653, 535>, <501, 535, 654>, <501, 654, 695>, <694, 654, 535>, <694, 535, 503>, 
			<722, 498, 458>, <458, 750, 722>, <499, 617, 536>, <617, 655, 536>, <499, 536, 656>, <499, 656, 696>, <695, 656, 536>, <695, 536, 501>, <752, 720, 496>, <496, 457, 752>, <497, 616, 537>, 
			<616, 657, 537>, <697, 497, 537>, <697, 537, 658>, <658, 537, 499>, <499, 696, 658>, <754, 718, 494>, <494, 456, 754>, <495, 615, 538>, <615, 659, 538>, <698, 495, 538>, <698, 538, 660>, 
			<497, 697, 660>, <497, 660, 538>, <756, 716, 455>, <716, 492, 455>, <493, 614, 539>, <614, 661, 539>, <699, 493, 539>, <699, 539, 662>, <495, 698, 662>, <495, 662, 539>, <758, 714, 454>, 
			<714, 490, 454>, <491, 613, 540>, <613, 663, 540>, <540, 664, 700>, <700, 491, 540>, <493, 699, 664>, <493, 664, 540>, <760, 712, 488>, <760, 488, 453>, <489, 612, 541>, <612, 665, 541>, 
			<489, 541, 666>, <489, 666, 701>, <700, 666, 541>, <700, 541, 491>, <762, 710, 486>, <762, 486, 452>, <487, 611, 542>, <611, 667, 542>, <487, 542, 668>, <487, 668, 702>, <701, 668, 542>, 
			<701, 542, 489>, <764, 708, 451>, <708, 484, 451>, <485, 610, 543>, <610, 669, 543>, <485, 543, 670>, <485, 670, 703>, <702, 670, 543>, <702, 543, 487>, <766, 706, 450>, <706, 481, 450>, 
			<483, 609, 544>, <609, 671, 544>, <483, 544, 672>, <672, 704, 483>, <703, 672, 544>, <703, 544, 485>, <419, 481, 418>, <481, 449, 418>, <418, 449, 417>, <449, 482, 417>, <417, 482, 448>, 
			<482, 464, 448>, <448, 464, 447>, <464, 510, 447>, <447, 510, 446>, <510, 463, 446>, <446, 463, 508>, <446, 508, 445>, <445, 508, 462>, <445, 462, 444>, <444, 462, 506>, <444, 506, 443>, 
			<443, 506, 461>, <443, 461, 442>, <442, 461, 504>, <442, 504, 441>, <504, 460, 440>, <440, 441, 504>, <460, 502, 439>, <439, 440, 460>, <502, 459, 438>, <438, 439, 502>, <438, 459, 500>, 
			<438, 500, 437>, <437, 500, 458>, <437, 458, 436>, <436, 458, 498>, <436, 498, 435>, <435, 498, 457>, <435, 457, 434>, <434, 457, 496>, <434, 496, 433>, <496, 456, 432>, <432, 433, 496>, 
			<456, 494, 431>, <431, 432, 456>, <494, 455, 430>, <430, 431, 494>, <430, 455, 492>, <492, 429, 430>, <429, 492, 454>, <454, 428, 429>, <428, 454, 490>, <490, 427, 428>, <427, 490, 426>, 
			<490, 453, 426>, <426, 453, 425>, <453, 488, 425>, <425, 488, 424>, <488, 452, 424>, <424, 452, 423>, <452, 486, 423>, <423, 486, 422>, <486, 451, 422>, <422, 451, 484>, <484, 421, 422>, 
			<421, 484, 450>, <450, 420, 421>, <420, 450, 481>, <481, 419, 420>, <722, 750, 721>, <750, 749, 721>, <751, 752, 722>, <722, 721, 751>, <741, 742, 732>, <732, 731, 741>, <736, 768, 767>, 
			<767, 735, 736>, <719, 753, 754>, <754, 720, 719>, <749, 750, 724>, <724, 723, 749>, <716, 756, 755>, <716, 755, 715>, <727, 745, 746>, <746, 728, 727>, <743, 744, 730>, <730, 729, 743>, 
			<717, 755, 718>, <755, 756, 718>, <735, 737, 738>, <735, 738, 736>, <709, 763, 710>, <763, 764, 710>, <705, 767, 706>, <767, 768, 706>, <734, 738, 737>, <737, 733, 734>, <733, 739, 734>, 
			<739, 740, 734>, <715, 757, 716>, <757, 758, 716>, <710, 762, 761>, <761, 709, 710>, <708, 764, 763>, <708, 763, 707>, <725, 747, 726>, <747, 748, 726>, <711, 761, 762>, <711, 762, 712>, 
			<730, 742, 729>, <742, 741, 729>, <720, 752, 751>, <720, 751, 719>, <712, 760, 759>, <759, 711, 712>, <707, 765, 708>, <765, 766, 708>, <758, 757, 713>, <713, 714, 758>, <766, 765, 705>, 
			<705, 706, 766>, <718, 754, 753>, <718, 753, 717>, <728, 744, 743>, <728, 743, 727>, <726, 746, 745>, <726, 745, 725>, <713, 759, 714>, <759, 760, 714>, <724, 748, 747>, <724, 747, 723>, 
			<732, 740, 739>, <732, 739, 731>, <735, 767, 769>, <735, 769, 785>, <785, 784, 735>, <784, 737, 735>, <786, 783, 733>, <783, 739, 733>, <787, 782, 731>, <782, 741, 731>, <788, 781, 729>, 
			<781, 743, 729>, <789, 780, 727>, <780, 745, 727>, <790, 779, 725>, <779, 747, 725>, <791, 778, 723>, <778, 749, 723>, <792, 777, 721>, <777, 751, 721>, <793, 776, 719>, <776, 753, 719>, 
			<794, 775, 717>, <775, 755, 717>, <795, 774, 715>, <774, 757, 715>, <796, 773, 713>, <773, 759, 713>, <797, 772, 711>, <772, 761, 711>, <798, 771, 709>, <771, 763, 709>, <799, 770, 707>, 
			<770, 765, 707>, <800, 769, 705>, <769, 767, 705>, <733, 737, 784>, <733, 784, 786>, <731, 739, 783>, <731, 783, 787>, <729, 741, 782>, <729, 782, 788>, <727, 743, 781>, <727, 781, 789>, 
			<725, 745, 780>, <725, 780, 790>, <723, 747, 779>, <723, 779, 791>, <721, 749, 778>, <721, 778, 792>, <719, 751, 777>, <719, 777, 793>, <717, 753, 776>, <717, 776, 794>, <715, 755, 775>, 
			<715, 775, 795>, <713, 757, 774>, <713, 774, 796>, <711, 759, 773>, <711, 773, 797>, <709, 761, 772>, <709, 772, 798>, <707, 763, 771>, <707, 771, 799>, <705, 765, 770>, <705, 770, 800>, 
			<821, 819, 820>, <821, 818, 819>, <825, 823, 824>, <825, 831, 823>, <826, 827, 828>, <828, 829, 826>, <829, 825, 826>, <831, 825, 829>, <831, 829, 830>, <831, 832, 823>, <832, 822, 823>, 
			<832, 833, 822>, <833, 821, 822>, <818, 821, 833>, <818, 833, 834>, <477, 802, 801>, <477, 801, 469>, <526, 803, 802>, <802, 477, 526>, <804, 803, 526>, <526, 478, 804>, <805, 804, 478>, 
			<478, 527, 805>, <806, 805, 527>, <527, 479, 806>, <807, 806, 479>, <479, 528, 807>, <808, 807, 528>, <528, 480, 808>, <809, 808, 480>, <480, 514, 809>, <810, 809, 514>, <514, 465, 810>, 
			<811, 810, 465>, <465, 513, 811>, <812, 811, 513>, <513, 466, 812>, <813, 812, 466>, <466, 515, 813>, <814, 813, 515>, <515, 467, 814>, <815, 814, 467>, <467, 516, 815>, <816, 815, 516>, 
			<516, 468, 816>, <817, 816, 468>, <468, 517, 817>, <801, 817, 517>, <517, 469, 801>, <469, 819, 818>, <818, 477, 469>, <518, 820, 819>, <819, 469, 518>, <821, 820, 518>, <518, 470, 821>, 
			<822, 821, 470>, <470, 519, 822>, <823, 822, 519>, <519, 471, 823>, <824, 823, 471>, <471, 520, 824>, <825, 824, 520>, <520, 472, 825>, <826, 825, 472>, <472, 521, 826>, <827, 826, 521>, 
			<521, 473, 827>, <828, 827, 473>, <473, 522, 828>, <829, 828, 522>, <522, 474, 829>, <830, 829, 474>, <474, 523, 830>, <831, 830, 523>, <523, 475, 831>, <832, 831, 475>, <475, 524, 832>, 
			<833, 832, 524>, <524, 476, 833>, <834, 833, 476>, <476, 525, 834>, <818, 834, 525>, <525, 477, 818>}
	 uv_indices { 1666, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, 
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>}
}

#version WOOD_FIGURE_PROP_INC_TEMP;
#end