// ------------------------------------------------------------
// Persistence of Vision Ray Tracer Include File
// Transmission Spectral Data library for PoV-Ray
// ------------------------------------------------------------
// Interpreted from LeeFilters graphs by Christopher Shake
// ------------------------------------------------------------
/*
	These are Lee Filters gel colors
	
	Theater uses 'transmission' to define the amount of light passed
	through each filter, but POV-Ray uses 'filter' to identify transmitted
	light that is colored by the object pigment, so each color should be
	used as a color pigment with filter=1
	
	Each color is specified with 'TS_Lxxx' for Transmission Spectrum
	All are splines of transmissino spectrums, needs CIE.inc to convert
	to usable RGB format with 'ReflectiveSpectrum()'

	Contents:
	[TS_Lxxx] - [Name]
	L002 - Rose Pink
	L003 - Lavender Tint
	L004 - Medium Bastard Amber
	L007 - Pale Yellow
	L008 - Dark Salmon
	L009 - Pale Amber Gold
	L010 - Medium Yellow
	L013 - Straw Tint
	L015 - Deep Straw
	L017 - Surprise Pink
	L019 - Fire
	L020 - Medium Amber
	L021 - Gold Amber
	L022 - Dark Amber
	L024 - Scarlet
	L025 - Sunset Red
	L026 - Bright Red
	L027 - Medium Red
	L029 - Plasa Red
	L035 - Light Pink
	L036 - Medium Pink
	L039 - Pink Carnation
	L046 - Dark Magenta
	L048 - Rose Purple
	L049 - Medium Purple
	L052 - Light Lavender
	L053 - Paler Lavender
	L058 - Lavender
	L061 - Mist Blue
	L063 - Pale Blue
	L068 - Sky Blue
	L071 - Tokyo Blue
	L075 - Evening Blue
	L079 - Just Blue
	L085 - Deeper Blue
	L088 - Lime Green
	L089 - Moss Green
	L090 - Dark Yellow Green
	L100 - Spring Yellow
	L101 - Yellow
	L102 - Light Amber
	L103 - Straw
	L104 - Deep Amber
	L105 - Orange
	L106 - Primary Red
	L107 - Light Rose
	L108 - English Rose
	L109 - Light Salmon
	L110 - Middle Rose
	L111 - Dark Pink
	L113 - Magenta
	L115 - Peacock Blue
	L116 - Medium Blue
	L117 - Steel Blue
	L118 - Light Blue
	L119 - Dark Blue
	L120 - Deep Blue
	L121 - LEE Green
	L122 - Fern Green
	L124 - Dark Green
	L126 - Mauve
	L127 - Smokey Pink
	L128 - Bright Pink
	L130 - Clear
	L131 - Marine Blue
	L132 - Medium Blue
	L134 - Golden Amber
	L135 - Deep Golden Amber
	L136 - Pale Lavender
	L137 - Special Lavender
	L138 - Pale Green
	L139 - Primary Green
	L140 - Summer Blue
	L141 - Bright Blue
	L142 - Pale Violet
	L143 - Pale Navy Blue
	L144 - No Color Blue
	L147 - Apricot
	L148 - Bright Rose
	L151 - Gold Tint
	L152 - Pale Gold
	L153 - Pale Salmon
	L154 - Pale Rose
	L156 - Chocolate
	L157 - Pink
	L158 - Deep Orange
	L159 - No Color Straw
	L161 - Slate Blue
	L162 - Bastard Amber
	L164 - Flame Red
	L165 - Daylight Blue
	L166 - Pale Red
	L169 - Lilac Tint
	L170 - Deep Lavender
	L172 - Lagoon Blue
	L174 - Dark Steel Blue
	L176 - Loving Amber
	L179 - Chrome Orange
	L180 - Dark Lavender
	L181 - Congo Blue
	L182 - Light Red
	L183 - Moonlight Blue
	L184 - Cosmetic Peach
	L185 - Cosmetic Burgundy
	L186 - Cosmetic Silver Rose
	L187 - Cosmetic Rouge
	L188 - Cosmetic Highlight
	L189 - Cosmetic Silver Moss
	L190 - Cosmetic Emerald
	L191 - Cosmetic Aqua Blue
	L192 - Flesh Pink
	L193 - Rosy Amber
	L194 - Surprise Pink
	L195 - Zenith Blue
	L196 - True Blue
	L197 - Alice Blue
	L198 - Palace Blue
	L199 - Regal Blue
	L200 - Double C.T. Blue (3200K to 26000K)
	L201 - Full C.T. Blue (3200K to 5700K)
	L202 - Half C.T. Blue (3200K to 4300K)
	L203 - Quarter C.T. Blue (3200K to 3600K)
	L204 - Full C.T. Orange (6500K to 3200K)
	L205 - Half C.T. Orange (6500K to 3800K)
	L206 - Quarter C.T. Orange (6500K to 4600K)
	L207 - Full C.T. Orange + 0.3ND (6500K to 3200K, minus 1 stop)
	L208 - Full C.T. Orange + 0.6ND (6500K to 3200K, minus 2 stops)
	L209 - 0.3ND (minus 1 stop)
	L210 - 0.6ND (minus 2 stops)
	L211 - 0.9ND (minus 3 stops)
	L212 - L.C.T. Yellow Y1 (arc to 3200K)
	L213 - White Flame Green (absorbs arc UV)
	L218 - Eighth C.T. Blue (3200K to 3400K)
	L219 - LEE Fluorescent Green
	L223 - Eighth C.T. Orange (6500K to 5550K)
	L226 - Lee U.V.
	L230 - Super Correction L.C.T. Yellow
	L232 - Super Correction W.F. Green to Tungsten (arc to 3200K)
	L236 - H.M.I. (to Tungsten)
	L237 - C.I.D (to Tungsten)
	L238 - C.S.I. (to Tungsten)
	L239 - Polariser ****
	L241 - LEE Fluorescent 5700K
	L242 - LEE Fluorescent 4300K
	L243 - LEE Fluorescent 3600K
	L244 - LEE Plus Green
	L245 - Half Plus Green
	L246 - Quarter Plus Green
	L247 - LEE Minus Green
	L248 - Half Minus Green
	L249 - Quarter Minus Green
	L278 - Eighth Plus Green
	L279 - Eighth Minus Green
	L281 - Three Quarter C.T. Blue
	L285 - Three Quarter C.T. Orange
	L298 - 0.15ND (minus half stop)
	L299 - 1.2ND (minus 4 stops)
	L322 - Soft Green
	L323 - Jade
	L325 - Mallard Green
	L327 - Forest Green
	L328 - Follies Pink
	L332 - Special Rose Pink
	L341 - Plum
	L343 - Special Medium Lavender
	L344 - Violet
	L345 - Fuchsia Pink
	L352 - Glacier Blue
	L353 - Lighter Blue
	L354 - Special Steel Blue
	L363 - Special Medium Blue
	L366 - Cornflower
	L441 - Full C.T. Straw (6500K to 3200K)
	L442 - Half C.T. Straw (6500K to 4300K)
	L443 - Quarter C.T. Straw (6500K to 5100K)
	L444 - Eighth C.T. Straw (6500K to 5700K)
	L700 - Perfect Lavender
	L701 - Provence
	L702 - Special Pale Lavender
	L703 - Cold Lavender
	L704 - Lily
	L705 - Lily Frost ****
	L706 - King Fals Lavender
	L707 - Ultimate Violet
	L708 - Cool Lavender
	L709 - Electric Lilac
	L710 - Spir Special Blue
	L711 - Cold Blue
	L712 - Bedford Blue
	L713 - J.Winter Blue
	L714 - Elysian Blue
	L715 - Cabana Blue
	L716 - Mikkel Blue
	L717 - Shanklin Frost ****
	L718 - Half Shanklin Frost ****
	L719 - Color Wash Blue
	L720 - Durham Daylight Frost
	L721 - Berry Blue
	L722 - Bray Blue
	L723 - Virgin Blue
	L724 - Ocean Blue
	L725 - Old Steel Blue
	L727 - QFD Blue
	L728 - Steel Green
	L729 - Scuba Blue
	L730 - Liberty Green
	L731 - Dirty Ice
	L733 - Damp Squib
	L735 - Velvet Green
	L736 - Twickenham Green
	L738 - JAS Green
	L740 - Aurora Borealis Green
	L741 - Mustard Yellow
	L742 - Bram Brown
	L744 - Dirty White
	L746 - Brown
	L747 - Easy White
	L748 - Seedy Pink
	L749 - Hampshire Rose ****
	L750 - Durham Frost ****
	L763 - Wheat
	L764 - Sun Color Straw
	L765 - LEE Yellow
	L767 - Oklahoma Yellow
	L768 - Egg Yolk Yellow
	L770 - Burnt Yellow
	L773 - Cardbox Amber
	L774 - Soft Amber Key 1
	L775 - Soft Amber Key 2
	L776 - Nectarine
	L777 - Rust
	L778 - Millennium Gold
	L779 - Bastard Pink
	L780 - AS Golden Amber
	L781 - Terry Red
	L787 - Marius Red
	L789 - Blood Red
	L790 - Moroccan Pink
	L791 - Moroccan Frost ****
	L793 - Vanity Fair
	L794 - Pretty 'n Pink
	L795 - Magical Magenta
	L797 - Deep Purple
	L798 - Chrysalis Pink
	L799 - Special KH Lavender
*/

// Standard include file beginning stuff 
#ifndef (tspd_leefilters_Inc_Temp)
#declare tspd_leefilters_Inc_Temp = version;
#version 3.5;

#ifdef(View_POV_Include_Stack)
  #debug "Including tspd_leefilters.inc"
#end                   


//-------------------------------------------------------------
// Begin Filter Definitions
//-------------------------------------------------------------

// #002 - Rose Pink
#declare TS_L002 = spline{linear_spline
357.143, 0.604167
404.511, 0.666667
424.812, 0.6875
431.579, 0.694444
445.113, 0.638889
454.135, 0.576389
465.414, 0.520833
472.18, 0.472222
481.203, 0.409722
490.226, 0.347222
499.248, 0.284722
501.504, 0.194444
517.293, 0.166667
535.338, 0.125
548.872, 0.0763889
553.383, 0.0625
564.662, 0.125
571.429, 0.194444
575.94, 0.270833
589.474, 0.375
591.729, 0.409722
593.985, 0.722222
603.008, 0.798611
625.564, 0.826389
639.098, 0.847222
648.12, 0.875
663.91, 0.868056
681.955, 0.854167
700, 0.854167
758.647, 0.854167
}

// #003 - Lavender Tint
#declare TS_L003 = spline{linear_spline
370.896, 0.808219
400, 0.849315
411.194, 0.856164
424.627, 0.863014
444.776, 0.849315
451.493, 0.856164
460.448, 0.842466
467.164, 0.821918
476.119, 0.835616
482.836, 0.821918
487.313, 0.808219
496.269, 0.815068
507.463, 0.828767
511.94, 0.815068
520.896, 0.753425
529.851, 0.787671
536.567, 0.787671
545.522, 0.746575
554.478, 0.726027
558.955, 0.732877
565.672, 0.746575
574.627, 0.746575
579.104, 0.726027
585.821, 0.69863
594.776, 0.705479
599.254, 0.732877
605.97, 0.767123
614.925, 0.780822
635.075, 0.808219
646.269, 0.863014
650.746, 0.90411
657.463, 0.917808
670.896, 0.924658
686.567, 0.876712
693.284, 0.863014
700, 0.90411
708.955, 0.938356
762.687, 0.952055
}

// #004 - Medium Bastard Amber
#declare TS_L004 = spline{linear_spline
369.784, 0.450331
404.317, 0.437086
412.95, 0.403974
421.583, 0.403974
438.849, 0.437086
456.115, 0.476821
460.432, 0.503311
473.381, 0.503311
486.331, 0.456954
505.755, 0.417219
523.022, 0.437086
540.288, 0.476821
557.554, 0.516556
564.029, 0.562914
568.345, 0.741722
572.662, 0.788079
579.137, 0.854305
594.245, 0.900662
609.353, 0.927152
641.727, 0.887417
663.309, 0.900662
682.734, 0.92053
747.482, 0.92053
}

// #007 - Pale Yellow
#declare TS_L007 = spline{linear_spline
380.475, 0.0466667
399.741, 0.12
406.072, 0.186667
408.043, 0.273333
412.201, 0.346667
416.374, 0.413333
422.719, 0.473333
435.554, 0.526667
450.547, 0.58
461.122, 0.68
465.237, 0.773333
473.727, 0.84
488.777, 0.866667
506.072, 0.853333
534.058, 0.886667
555.612, 0.9
568.576, 0.893333
579.324, 0.913333
583.626, 0.92
596.604, 0.906667
609.554, 0.906667
635.424, 0.92
652.691, 0.92
680.777, 0.906667
700.173, 0.92
730.36, 0.933333
}

// #008 - Dark Salmon
#declare TS_L008 = spline{linear_spline
374.101, 0.139073
404.317, 0.152318
425.899, 0.152318
441.007, 0.112583
453.957, 0.0596026
473.381, 0.0331126
488.489, 0.00662252
510.072, 0.0331126
529.496, 0.0662252
542.446, 0.119205
551.079, 0.178808
561.871, 0.344371
576.978, 0.516556
585.612, 0.649007
596.403, 0.774834
607.194, 0.834437
622.302, 0.880795
665.468, 0.874172
687.05, 0.887417
697.842, 0.900662
730.216, 0.913907
}

// #009 - Pale Amber Gold
#declare TS_L009 = spline{linear_spline
374.101, 0.373333
404.317, 0.393333
421.583, 0.386667
436.691, 0.34
458.273, 0.353333
469.065, 0.406667
473.381, 0.473333
475.54, 0.5
488.489, 0.546667
505.755, 0.586667
525.18, 0.62
538.129, 0.673333
557.554, 0.706667
570.504, 0.8
579.137, 0.86
589.928, 0.92
602.878, 0.913333
624.46, 0.9
646.043, 0.933333
663.309, 0.9
674.101, 0.893333
693.525, 0.92
723.741, 0.953333
}

// #010 - Medium Yellow
#declare TS_L010 = spline{linear_spline
371.324, 0
466.176, 0
477.206, 0.115646
486.029, 0.340136
488.235, 0.482993
490.441, 0.612245
499.265, 0.70068
508.088, 0.761905
514.706, 0.829932
530.147, 0.829932
547.794, 0.870748
567.647, 0.884354
589.706, 0.897959
638.235, 0.891156
658.088, 0.911565
675.735, 0.904762
684.559, 0.904762
702.206, 0.911565
733.088, 0.918367
}

// #013 - Straw Tint
#declare TS_L013 = spline{linear_spline
371.942, 0.304636
404.317, 0.311258
423.741, 0.284768
443.165, 0.258278
451.799, 0.238411
460.432, 0.231788
469.065, 0.291391
482.014, 0.377483
494.964, 0.430464
518.705, 0.596026
529.496, 0.655629
538.129, 0.715232
546.763, 0.768212
561.871, 0.821192
576.978, 0.860927
600.719, 0.86755
620.144, 0.84106
646.043, 0.860927
669.784, 0.900662
691.367, 0.913907
721.583, 0.89404
743.165, 0.880795
}

// #015 - Deep Straw
#declare TS_L015 = spline{linear_spline
378.723, 0
478.723, 0
487.234, 0.00194688
497.872, 0.0613267
506.383, 0.114059
514.894, 0.179864
521.277, 0.219413
527.66, 0.232819
534.043, 0.291976
538.298, 0.351022
548.936, 0.528049
553.191, 0.593631
561.702, 0.750939
568.085, 0.764344
578.723, 0.823724
595.745, 0.844222
606.383, 0.844778
625.532, 0.878459
640.426, 0.866166
657.447, 0.886664
676.596, 0.887665
697.872, 0.875706
727.66, 0.864191
}

// #017 - Surprise Pink
#declare TS_L017 = spline{linear_spline
367.626, 0.198675
404.317, 0.18543
423.741, 0.15894
441.007, 0.119205
458.273, 0.0794702
466.906, 0.0596026
494.964, 0.0662252
512.23, 0.10596
527.338, 0.152318
538.129, 0.172185
576.978, 0.238411
596.403, 0.251656
611.511, 0.304636
622.302, 0.357616
639.568, 0.456954
643.885, 0.490066
652.518, 0.509934
663.309, 0.456954
669.784, 0.370861
671.942, 0.311258
676.259, 0.291391
682.734, 0.311258
689.209, 0.357616
695.683, 0.423841
710.791, 0.589404
743.165, 0.708609
}

// #019 - Fire
#declare TS_L019 = spline{linear_spline
370.213, 0.0128205
406.383, 0.0128205
451.064, 0.0128205
491.489, 0.025641
519.149, 0.0448718
540.426, 0.0384615
555.319, 0.0128205
568.085, 0.0128205
574.468, 0.0320513
582.979, 0.205128
591.489, 0.442308
593.617, 0.596154
600, 0.698718
608.511, 0.75
619.149, 0.807692
629.787, 0.858974
642.553, 0.878205
665.957, 0.878205
757.447, 0.871795
}

// #020 - Medium Amber
#declare TS_L020 = spline{linear_spline
365.957, 0.203947
404.255, 0.144737
419.149, 0.105263
436.17, 0.0592105
455.319, 0.0263158
472.34, 0.0131579
491.489, 0.0197368
508.511, 0.0526316
521.277, 0.105263
529.787, 0.164474
536.17, 0.315789
544.681, 0.381579
553.191, 0.440789
563.83, 0.486842
576.596, 0.618421
582.979, 0.717105
595.745, 0.782895
608.511, 0.835526
640.426, 0.875
661.702, 0.875
685.106, 0.881579
738.298, 0.927632
}

// #021 - Gold Amber
#declare TS_L021 = spline{linear_spline
370, 0.0666667
400, 0.04
432.143, 0
453.571, 0
475, 0
496.429, 0
517.857, 0
532.857, 0.04
543.571, 0.1
554.286, 0.153333
571.429, 0.42
582.143, 0.653333
592.857, 0.773333
603.571, 0.826667
616.429, 0.88
637.857, 0.88
659.286, 0.886667
676.429, 0.913333
700, 0.88
764.286, 0.833333
}

// #022 - Dark Amber
#declare TS_L022 = spline{linear_spline
366.197, 0.0130719
404.225, 0.0130719
425.352, 0.0130719
446.479, 0.0130719
469.718, 0
501.408, 0
516.197, 0.0130719
533.099, 0.0522876
550, 0.0915033
556.338, 0.0980392
573.239, 0.0915033
583.803, 0.27451
592.254, 0.398693
596.479, 0.562092
600.704, 0.679739
607.042, 0.777778
619.718, 0.836601
634.507, 0.843137
655.634, 0.843137
670.423, 0.862745
691.549, 0.856209
750.704, 0.836601
}

// #024 - Scarlet
#declare TS_L024 = spline{linear_spline
365.714, 0.112583
404.286, 0.145695
425.714, 0.152318
440.714, 0.10596
453.571, 0.0529801
472.857, 0.0264901
487.857, 0
511.429, 0.013245
532.857, 0.0198675
556.429, 0.0529801
571.429, 0.0993377
577.857, 0.198675
586.429, 0.456954
592.857, 0.622517
605.714, 0.701987
616.429, 0.761589
629.286, 0.807947
644.286, 0.854305
663.571, 0.887417
697.857, 0.913907
749.286, 0.933775
}

// #025 - Sunset Red
#declare TS_L025 = spline{linear_spline
372.143, 0.0789474
404.286, 0.0855263
425.714, 0.0789474
442.857, 0.0460526
455.714, 0.0328947
475, 0.0592105
494.286, 0.0855263
515.714, 0.0921053
532.857, 0.131579
547.857, 0.164474
560.714, 0.111842
569.286, 0.105263
573.571, 0.177632
575.714, 0.243421
580, 0.309211
582.143, 0.375
584.286, 0.440789
586.429, 0.506579
590.714, 0.572368
592.857, 0.631579
597.143, 0.697368
603.571, 0.756579
612.143, 0.815789
627.143, 0.868421
644.286, 0.855263
661.429, 0.848684
678.571, 0.888158
697.857, 0.881579
753.571, 0.861842
}

// #026 - Bright Red
#declare TS_L026 = spline{linear_spline
367.857, 4.44089e-16
520, 0.00657895
541.429, 0.00657895
560.714, 0.00657895
582.143, 0.0131579
595, 0.0657895
603.571, 0.125
605.714, 0.184211
614.286, 0.414474
625, 0.631579
637.857, 0.697368
650.714, 0.75
674.286, 0.782895
693.571, 0.802632
730, 0.894737
777.143, 0.934211
}

// #027 - Medium Red
#declare TS_L027 = spline{linear_spline
365.957, 0
595.745, 0
608.511, 0.0131579
621.277, 0.0657895
631.915, 0.203947
640.426, 0.322368
644.681, 0.388158
648.936, 0.453947
655.319, 0.513158
663.83, 0.572368
672.34, 0.631579
685.106, 0.684211
697.872, 0.736842
751.064, 0.822368
}

// #029 - Plasa Red
#declare TS_L029 = spline{linear_spline
368.31, 0
573.239, 0
581.69, 0.0196078
592.254, 0.104575
602.817, 0.235294
609.155, 0.313725
613.38, 0.379085
619.718, 0.464052
628.169, 0.522876
638.732, 0.581699
651.408, 0.627451
668.31, 0.666667
683.099, 0.712418
689.437, 0.732026
725.352, 0.771242
750.704, 0.771242
}

// #035 - Light Pink
#declare TS_L035 = spline{linear_spline
363.83, 0.686275
406.383, 0.72549
427.66, 0.732026
444.681, 0.699346
457.447, 0.653595
468.085, 0.594771
478.723, 0.535948
493.617, 0.490196
497.872, 0.457516
510.638, 0.457516
527.66, 0.490196
544.681, 0.45098
559.574, 0.411765
568.085, 0.588235
578.723, 0.764706
587.234, 0.823529
602.128, 0.875817
621.277, 0.869281
638.298, 0.888889
648.936, 0.901961
670.213, 0.901961
689.362, 0.882353
768.085, 0.895425
}

// #036 - Medium Pink
#declare TS_L036 = spline{linear_spline
365.957, 0.627451
404.255, 0.588235
421.277, 0.54902
434.043, 0.496732
448.936, 0.45098
463.83, 0.405229
478.723, 0.359477
489.362, 0.27451
493.617, 0.267974
497.872, 0.222222
510.638, 0.222222
525.532, 0.261438
540.426, 0.235294
551.064, 0.228758
557.447, 0.359477
565.957, 0.372549
568.085, 0.581699
578.723, 0.797386
591.489, 0.849673
597.872, 0.856209
619.149, 0.862745
636.17, 0.895425
655.319, 0.908497
676.596, 0.888889
695.745, 0.875817
772.34, 0.928105
}

// #039 - Pink Carnation
#declare TS_L039 = spline{linear_spline
370.213, 0.843137
408.511, 0.843137
410.638, 0.810458
414.894, 0.810458
417.021, 0.849673
425.532, 0.849673
429.787, 0.803922
436.17, 0.803922
440.426, 0.843137
446.809, 0.862745
451.064, 0.849673
455.319, 0.803922
461.702, 0.784314
472.34, 0.797386
487.234, 0.718954
502.128, 0.673203
512.766, 0.627451
517.021, 0.575163
523.404, 0.51634
538.298, 0.464052
548.936, 0.411765
559.574, 0.366013
568.085, 0.392157
570.213, 0.490196
578.723, 0.555556
585.106, 0.614379
593.617, 0.732026
610.638, 0.836601
619.149, 0.908497
631.915, 0.928105
653.191, 0.928105
674.468, 0.934641
695.745, 0.934641
757.447, 0.934641
}

// #046 - Dark Magenta
#declare TS_L046 = spline{linear_spline
404.225, 0.0522876
425.352, 0.0392157
446.479, 0.0457516
454.93, 0.0522876
476.056, 0.0653595
499.296, 0.0522876
518.31, 0.0196078
524.648, 0
545.775, 0
566.901, 0
588.028, 0
602.817, 0.0457516
611.268, 0.0980392
617.606, 0.215686
630.282, 0.437908
638.732, 0.529412
647.183, 0.588235
657.746, 0.647059
668.31, 0.699346
680.986, 0.75817
693.662, 0.803922
752.817, 0.915033
}

// #048 - Rose Purple
#declare TS_L048 = spline{linear_spline
363.83, 0.287582
406.383, 0.326797
421.277, 0.372549
436.17, 0.424837
446.809, 0.477124
465.957, 0.503268
478.723, 0.464052
487.234, 0.405229
495.745, 0.339869
504.255, 0.281046
510.638, 0.222222
519.149, 0.156863
525.532, 0.0980392
538.298, 0.0522876
555.319, 0.00653595
565.957, 0
576.596, 0.0326797
600, 0.254902
610.638, 0.30719
625.532, 0.352941
640.426, 0.405229
653.191, 0.575163
661.702, 0.633987
672.34, 0.69281
680.851, 0.751634
691.489, 0.810458
702.128, 0.882353
736.17, 0.921569
}

// #049 - Medium Purple
#declare TS_L049 = spline{linear_spline
373.288, 0.203822
406.164, 0.254777
418.493, 0.299363
439.041, 0.318471
453.425, 0.267516
461.644, 0.210191
471.918, 0.159236
482.192, 0.101911
494.521, 0.0509554
508.904, 0
584.932, 0
591.096, 0.0127389
603.425, 0.0636943
613.699, 0.11465
630.137, 0.152866
636.301, 0.203822
646.575, 0.343949
652.74, 0.503185
667.123, 0.694268
673.288, 0.757962
677.397, 0.815287
683.562, 0.840764
693.836, 0.853503
759.589, 0.878981
}

// #052 - Light Lavender
#declare TS_L052 = spline{linear_spline
370.629, 0.56129
406.294, 0.625806
420.979, 0.664516
437.762, 0.709677
454.545, 0.716129
471.329, 0.670968
477.622, 0.632258
488.112, 0.574194
498.601, 0.522581
513.287, 0.393548
519.58, 0.335484
530.07, 0.277419
540.559, 0.219355
551.049, 0.16129
565.734, 0.135484
584.615, 0.322581
586.713, 0.367742
595.105, 0.374194
611.888, 0.335484
620.28, 0.329032
628.671, 0.387097
639.161, 0.587097
649.65, 0.716129
655.944, 0.780645
658.042, 0.8
666.434, 0.858065
683.217, 0.896774
700, 0.922581
752.448, 0.929032
}

// #053 - Paler Lavender
#declare TS_L053 = spline{linear_spline
366.197, 0.714286
404.225, 0.727273
419.014, 0.772727
423.239, 0.805195
433.803, 0.805195
446.479, 0.792208
454.93, 0.798701
473.944, 0.785714
482.394, 0.74026
495.07, 0.733766
511.972, 0.701299
524.648, 0.649351
535.211, 0.590909
545.775, 0.532468
564.789, 0.512987
571.127, 0.512987
579.577, 0.551948
585.915, 0.571429
598.592, 0.564935
611.268, 0.525974
621.831, 0.525974
630.282, 0.558442
632.394, 0.662338
636.62, 0.74026
647.183, 0.792208
657.746, 0.857143
676.761, 0.876623
695.775, 0.88961
769.718, 0.896104
}

// #058 - Lavender
#declare TS_L058 = spline{linear_spline
370.213, 0.346405
408.511, 0.424837
419.149, 0.48366
431.915, 0.535948
442.553, 0.588235
459.574, 0.568627
472.34, 0.51634
485.106, 0.339869
497.872, 0.294118
508.511, 0.235294
512.766, 0.176471
521.277, 0.117647
529.787, 0.0588235
534.043, 0.0196078
548.936, 0
570.213, 0
580.851, 0.0130719
595.745, 0.0588235
614.894, 0.0849673
634.043, 0.0588235
644.681, 0.117647
653.191, 0.176471
659.574, 0.372549
665.957, 0.509804
678.723, 0.712418
685.106, 0.771242
693.617, 0.836601
704.255, 0.862745
746.809, 0.869281
}

// #061 - Mist Blue
#declare TS_L061 = spline{linear_spline
365.957, 0.712418
410.638, 0.816993
427.66, 0.856209
448.936, 0.862745
465.957, 0.843137
482.979, 0.810458
500, 0.75817
512.766, 0.712418
525.532, 0.660131
540.426, 0.607843
551.064, 0.555556
568.085, 0.581699
578.723, 0.588235
591.489, 0.496732
600, 0.437908
619.149, 0.437908
636.17, 0.470588
651.064, 0.431373
657.447, 0.411765
668.085, 0.437908
674.468, 0.503268
678.723, 0.568627
682.979, 0.627451
693.617, 0.686275
725.532, 0.816993
}

// #063 - Pale Blue
#declare TS_L063 = spline{linear_spline
364.085, 0.705882
404.225, 0.797386
419.014, 0.862745
442.254, 0.823529
452.817, 0.810458
459.155, 0.836601
478.169, 0.823529
490.845, 0.777778
499.296, 0.718954
511.972, 0.666667
522.535, 0.607843
533.099, 0.54902
539.437, 0.490196
550, 0.45098
564.789, 0.48366
579.577, 0.405229
590.141, 0.346405
609.155, 0.320261
628.169, 0.346405
647.183, 0.333333
653.521, 0.30719
661.972, 0.326797
674.648, 0.379085
683.099, 0.535948
693.662, 0.607843
714.789, 0.673203
771.831, 0.745098
}

// #068 - Sky Blue
#declare TS_L068 = spline{linear_spline
366.197, 0.189542
406.338, 0.294118
419.014, 0.346405
431.69, 0.437908
435.915, 0.503268
440.141, 0.568627
444.366, 0.627451
450.704, 0.69281
465.493, 0.718954
476.056, 0.666667
486.62, 0.607843
499.296, 0.431373
505.634, 0.372549
514.085, 0.30719
520.423, 0.248366
528.873, 0.183007
535.211, 0.130719
547.887, 0.0784314
564.789, 0.0653595
579.577, 0.0196078
585.915, 0
607.042, 0
628.169, 0
640.845, 0.0130719
651.408, 0.0718954
664.085, 0.124183
676.761, 0.169935
683.099, 0.235294
689.437, 0.294118
697.887, 0.359477
700, 0.424837
702.113, 0.620915
702.113, 0.620915
714.789, 0.777778
754.93, 0.823529
}

// #071 - Tokyo Blue
#declare TS_L071 = spline{linear_spline
366.434, 0
406.294, 0.0454545
423.077, 0.0909091
431.469, 0.142857
441.958, 0.220779
446.154, 0.285714
448.252, 0.337662
456.643, 0.350649
467.133, 0.311688
473.427, 0.123377
479.72, 0.038961
494.406, 0
515.385, 0
536.364, 0
557.343, 0
578.322, 0
599.301, 0
620.28, 0
641.259, 0
664.336, 0.012987
683.217, 0.038961
697.902, 0.0844156
746.154, 0.253247
}

// #075 - Evening Blue
#declare TS_L075 = spline{linear_spline
368.31, 0.383117
402.113, 0.441558
416.901, 0.480519
425.352, 0.538961
435.915, 0.623377
440.141, 0.701299
448.592, 0.746753
450.704, 0.772727
459.155, 0.779221
463.38, 0.720779
473.944, 0.675325
476.056, 0.655844
488.732, 0.564935
495.07, 0.512987
499.296, 0.448052
507.746, 0.38961
522.535, 0.168831
535.211, 0.116883
550, 0.0779221
564.789, 0.025974
575.352, 0
585.915, 0.012987
602.817, 0.0454545
623.944, 0.0324675
630.282, 0.025974
638.732, 0.0844156
647.183, 0.142857
655.634, 0.201299
661.972, 0.266234
668.31, 0.331169
680.986, 0.474026
687.324, 0.532468
691.549, 0.584416
695.775, 0.636364
752.817, 0.746753
}

// #079 - Just Blue
#declare TS_L079 = spline{linear_spline
370.423, 0.201299
404.225, 0.285714
414.789, 0.337662
425.352, 0.396104
427.465, 0.461039
435.915, 0.525974
440.141, 0.590909
446.479, 0.649351
459.155, 0.649351
476.056, 0.597403
492.958, 0.415584
499.296, 0.357143
507.746, 0.292208
516.197, 0.233766
520.423, 0.175325
535.211, 0.123377
547.887, 0.0649351
564.789, 0.0194805
579.577, 0
600.704, 0
621.831, 0
642.958, 0
651.408, 0
655.634, 0.025974
666.197, 0.0844156
668.31, 0.12987
674.648, 0.142857
685.211, 0.207792
689.437, 0.272727
695.775, 0.331169
700, 0.396104
719.014, 0.512987
746.479, 0.623377
}

// #085 - Deeper Blue
#declare TS_L085 = spline{linear_spline
365.957, 0
404.255, 0.0196078
421.277, 0.0588235
436.17, 0.104575
446.809, 0.163399
457.447, 0.235294
465.957, 0.294118
470.213, 0.339869
489.362, 0.281046
497.872, 0.215686
506.383, 0.156863
517.021, 0.104575
529.787, 0.0522876
546.809, 0
568.085, 0
589.362, 0
610.638, 0
631.915, 0
653.191, 0
657.447, 0.0130719
670.213, 0.0653595
687.234, 0.111111
689.362, 0.137255
697.872, 0.196078
702.128, 0.30719
734.043, 0.418301
780.851, 0.444444
}

// #088 - Lime Green
#declare TS_L088 = spline{linear_spline
364.181, 0.0454545
406.379, 0.0194805
427.492, 0.012987
448.619, 0.012987
463.586, 0.0974026
476.715, 0.311688
487.786, 0.551948
494.741, 0.844156
503.288, 0.88961
516.005, 0.909091
537.104, 0.896104
551.811, 0.857143
562.264, 0.805195
574.817, 0.746753
585.271, 0.694805
589.441, 0.668831
597.768, 0.61039
608.208, 0.551948
616.549, 0.5
622.805, 0.461039
633.368, 0.461039
639.693, 0.454545
658.679, 0.441558
669.01, 0.331169
671.012, 0.279221
677.35, 0.279221
683.702, 0.285714
687.996, 0.318182
692.359, 0.383117
696.721, 0.448052
701.043, 0.493506
718.067, 0.551948
745.642, 0.603896
}

// #089 - Moss Green
#declare TS_L089 = spline{linear_spline
368.31, 0
438.028, 0
446.479, 0.012987
459.155, 0.0649351
471.831, 0.116883
484.507, 0.344156
492.958, 0.474026
503.521, 0.525974
511.972, 0.538961
522.535, 0.519481
535.211, 0.467532
545.775, 0.409091
552.113, 0.344156
560.563, 0.285714
566.901, 0.220779
575.352, 0.162338
585.915, 0.0974026
596.479, 0.038961
615.493, 0.025974
630.282, 0.0649351
649.296, 0.0519481
670.423, 0.0584416
683.099, 0.11039
691.549, 0.227273
700, 0.324675
723.239, 0.38961
769.718, 0.454545
}

// #090 - Dark Yellow Green
#declare TS_L090 = spline{linear_spline
366.434, 0
450.35, 0
458.741, 0.0130719
469.231, 0.0653595
481.818, 0.117647
494.406, 0.169935
506.993, 0.228758
513.287, 0.281046
521.678, 0.281046
532.168, 0.202614
542.657, 0.143791
551.049, 0.0849673
563.636, 0.0261438
576.224, 0
597.203, 0
618.182, 0
639.161, 0
660.14, 0
681.119, 0
689.51, 0
700, 0.0392157
731.469, 0.111111
771.329, 0.150327
}

// #100 - Spring Yellow
#declare TS_L100 = spline{linear_spline
370.423, 0.000648629
452.817, 0.00542068
459.155, 0.00528169
465.493, 0.0709322
469.718, 0.136629
488.732, 0.728317
492.958, 0.840067
495.07, 0.866336
507.746, 0.879216
522.535, 0.924944
526.761, 0.951168
537.324, 0.944357
543.662, 0.898165
550, 0.865132
556.338, 0.87815
569.014, 0.930504
575.352, 0.943523
581.69, 0.910489
590.141, 0.864251
596.479, 0.857533
609.155, 0.857255
626.056, 0.896358
626.056, 0.896358
640.845, 0.849981
659.859, 0.849564
672.535, 0.796655
680.986, 0.763575
691.549, 0.78308
700, 0.822368
719.014, 0.861425
746.479, 0.900297
}

// #101 - Yellow
#declare TS_L101 = spline{linear_spline
366.197, 0
438.028, 0
454.93, 0.012987
471.831, 0.0519481
482.394, 0.149351
495.07, 0.24026
501.408, 0.298701
503.521, 0.357143
509.859, 0.396104
518.31, 0.487013
520.423, 0.525974
526.761, 0.545455
528.873, 0.584416
535.211, 0.642857
539.437, 0.74026
550, 0.798701
562.676, 0.850649
571.127, 0.876623
585.915, 0.88961
598.592, 0.88961
602.817, 0.87013
609.155, 0.857143
623.944, 0.87013
638.732, 0.844156
659.859, 0.850649
680.986, 0.857143
704.225, 0.850649
769.718, 0.850649
}

// #102 - Light Amber
#declare TS_L102 = spline{linear_spline
368.31, 0.0519481
406.338, 0.0714286
416.901, 0.0649351
425.352, 0.0844156
440.141, 0.12987
452.817, 0.181818
465.493, 0.233766
480.282, 0.279221
492.958, 0.331169
501.408, 0.38961
503.521, 0.422078
511.972, 0.441558
524.648, 0.5
537.324, 0.545455
552.113, 0.590909
564.789, 0.688312
575.352, 0.779221
577.465, 0.818182
585.915, 0.837662
594.366, 0.850649
611.268, 0.824675
617.606, 0.805195
626.056, 0.811688
638.732, 0.837662
661.972, 0.831169
683.099, 0.831169
702.113, 0.850649
771.831, 0.883117
}

// #103 - Straw
#declare TS_L103 = spline{linear_spline
366.197, 0.535484
404.225, 0.529032
425.352, 0.522581
431.69, 0.516129
452.817, 0.503226
471.831, 0.529032
488.732, 0.56129
503.521, 0.6
511.972, 0.664516
518.31, 0.716129
526.761, 0.8
528.873, 0.83871
539.437, 0.845161
560.563, 0.832258
575.352, 0.851613
590.141, 0.851613
594.366, 0.877419
613.38, 0.870968
623.944, 0.883871
642.958, 0.909677
661.972, 0.890323
683.099, 0.890323
693.662, 0.870968
700, 0.890323
729.577, 0.935484
776.056, 0.941935
}

// #104 - Deep Amber
#declare TS_L104 = spline{linear_spline
372.34, 0.0392157
402.128, 0.0196078
412.766, 0
434.043, 0
444.681, 0.0130719
461.702, 0.0522876
476.596, 0.0915033
493.617, 0.137255
506.383, 0.183007
517.021, 0.261438
525.532, 0.392157
538.298, 0.562092
548.936, 0.673203
551.064, 0.738562
553.191, 0.784314
563.83, 0.843137
570.213, 0.882353
582.979, 0.901961
602.128, 0.888889
610.638, 0.869281
625.532, 0.849673
636.17, 0.862745
648.936, 0.915033
663.83, 0.882353
682.979, 0.882353
700, 0.921569
768.085, 0.947712
}

// #105 - Orange
#declare TS_L105 = spline{linear_spline
372.34, 0.0394737
408.511, 0
429.787, 0
446.809, 0
457.447, 0
493.617, 0
508.511, 0
527.66, 0.00657895
546.809, 0.0460526
557.447, 0.0986842
559.574, 0.177632
568.085, 0.25
576.596, 0.480263
585.106, 0.644737
593.617, 0.710526
600, 0.796053
606.383, 0.861842
627.66, 0.875
648.936, 0.881579
672.34, 0.861842
702.128, 0.888158
763.83, 0.921053
}

// #106 - Primary Red
#declare TS_L106 = spline{linear_spline
365.957, 0
404.255, 0
425.532, 0
446.809, 0
468.085, 0
489.362, 0
510.638, 0
531.915, 0
548.936, 0
563.83, 0.0130719
580.851, 0.0522876
600, 0.183007
610.638, 0.294118
617.021, 0.529412
619.149, 0.660131
623.404, 0.72549
629.787, 0.751634
636.17, 0.771242
646.809, 0.771242
661.702, 0.75817
670.213, 0.777778
680.851, 0.784314
693.617, 0.75817
710.638, 0.771242
770.213, 0.823529
}

// #107 - Light Rose
#declare TS_L107 = spline{linear_spline
374.648, 0.477124
406.338, 0.522876
414.789, 0.529412
421.127, 0.496732
433.803, 0.444444
446.479, 0.392157
461.268, 0.346405
473.944, 0.294118
490.845, 0.254902
507.746, 0.228758
514.085, 0.248366
524.648, 0.261438
539.437, 0.267974
556.338, 0.300654
566.901, 0.346405
577.465, 0.424837
581.69, 0.581699
585.915, 0.712418
594.366, 0.79085
607.042, 0.843137
619.718, 0.849673
628.169, 0.882353
638.732, 0.895425
655.634, 0.862745
664.085, 0.849673
676.761, 0.901961
683.099, 0.915033
693.662, 0.901961
700, 0.875817
735.915, 0.862745
}

// #108 - English Rose
#declare TS_L108 = spline{linear_spline
372.34, 0.424837
404.255, 0.411765
423.404, 0.392157
444.681, 0.379085
457.447, 0.326797
472.34, 0.287582
478.723, 0.27451
497.872, 0.287582
517.021, 0.300654
529.787, 0.359477
538.298, 0.411765
557.447, 0.45098
565.957, 0.503268
570.213, 0.581699
574.468, 0.660131
582.979, 0.738562
589.362, 0.797386
597.872, 0.856209
600, 0.882353
606.383, 0.915033
612.766, 0.928105
631.915, 0.908497
634.043, 0.882353
640.426, 0.869281
653.191, 0.888889
670.213, 0.928105
689.362, 0.921569
700, 0.888889
742.553, 0.816993
}

// #109 - Light Salmon
#declare TS_L109 = spline{linear_spline
363.83, 0.476821
404.255, 0.496689
423.404, 0.483444
436.17, 0.437086
448.936, 0.377483
461.702, 0.324503
472.34, 0.271523
489.362, 0.231788
508.511, 0.225166
527.66, 0.258278
544.681, 0.298013
557.447, 0.350993
563.83, 0.417219
568.085, 0.536424
580.851, 0.662252
593.617, 0.781457
612.766, 0.801325
625.532, 0.847682
638.298, 0.827815
653.191, 0.81457
670.213, 0.860927
680.851, 0.81457
693.617, 0.847682
702.128, 0.874172
740.426, 0.907285
}

// #110 - Middle Rose
#declare TS_L110 = spline{linear_spline
370, 0.562914
406.429, 0.635762
423.571, 0.635762
442.857, 0.602649
455.714, 0.556291
464.286, 0.490066
472.857, 0.437086
487.857, 0.377483
498.571, 0.324503
507.143, 0.298013
513.571, 0.238411
517.857, 0.218543
530.714, 0.225166
547.857, 0.264901
554.286, 0.304636
560.714, 0.317881
567.143, 0.417219
575.714, 0.476821
582.143, 0.536424
590.714, 0.695364
599.286, 0.754967
612.143, 0.807947
627.143, 0.847682
650.714, 0.854305
676.429, 0.880795
697.857, 0.880795
777.143, 0.880795
}

// #111 - Dark Pink
#declare TS_L111 = spline{linear_spline
370.213, 0.529412
404.255, 0.522876
425.532, 0.509804
442.553, 0.470588
457.447, 0.424837
470.213, 0.379085
476.596, 0.30719
487.234, 0.215686
497.872, 0.163399
517.021, 0.124183
531.915, 0.0849673
540.426, 0.0392157
546.809, 0.0392157
559.574, 0.0261438
563.83, 0.0522876
576.596, 0.215686
585.106, 0.477124
589.362, 0.51634
597.872, 0.588235
604.255, 0.712418
608.511, 0.751634
619.149, 0.803922
629.787, 0.836601
653.191, 0.830065
672.34, 0.810458
678.723, 0.803922
700, 0.810458
759.574, 0.856209
}

// #113 - Magenta
#declare TS_L113 = spline{linear_spline
372.143, 0.177632
404.286, 0.164474
423.571, 0.131579
440.714, 0.0986842
453.571, 0.0592105
477.143, 0.0328947
502.857, 0
524.286, 0
545.714, 0
562.857, 0.0197368
580, 0.0526316
590.714, 0.0986842
597.143, 0.151316
599.286, 0.355263
603.571, 0.486842
603.571, 0.486842
607.857, 0.631579
610, 0.710526
618.571, 0.743421
620.714, 0.789474
629.286, 0.822368
642.143, 0.868421
652.857, 0.894737
670, 0.914474
691.429, 0.907895
760, 0.888158
}

// #115 - Peacock Blue
#declare TS_L115 = spline{linear_spline
374.468, 0.137255
402.128, 0.176471
412.766, 0.222222
421.277, 0.281046
429.787, 0.339869
438.298, 0.411765
446.809, 0.470588
453.191, 0.535948
463.83, 0.588235
472.34, 0.647059
482.979, 0.732026
489.362, 0.764706
497.872, 0.771242
517.021, 0.751634
525.532, 0.686275
538.298, 0.555556
553.191, 0.398693
559.574, 0.339869
570.213, 0.254902
580.851, 0.196078
589.362, 0.137255
602.128, 0.0588235
610.638, 0.0326797
638.298, 0.0196078
653.191, 0.00653595
663.83, 0.0261438
682.979, 0.0588235
700, 0.0849673
748.936, 0.183007
}

// #116 - Medium Blue
#declare TS_L116 = spline{linear_spline
368.085, 0.0394737
404.255, 0.0592105
419.149, 0.105263
431.915, 0.157895
440.426, 0.217105
451.064, 0.269737
455.319, 0.302632
463.83, 0.315789
472.34, 0.375
480.851, 0.427632
491.489, 0.5
495.745, 0.526316
506.383, 0.539474
517.021, 0.467105
521.277, 0.375
529.787, 0.315789
534.043, 0.223684
540.426, 0.171053
553.191, 0.118421
563.83, 0.0723684
578.723, 0.0328947
589.362, 0
610.638, 0
631.915, 0
653.191, 0
674.468, 0
695.745, 0
774.468, 0
}

// #117 - Steel Blue
#declare TS_L117 = spline{linear_spline
365.957, 0.875817
404.255, 0.882353
425.532, 0.882353
442.553, 0.869281
461.702, 0.836601
476.596, 0.797386
491.489, 0.751634
506.383, 0.705882
523.404, 0.660131
536.17, 0.607843
548.936, 0.555556
555.319, 0.496732
561.702, 0.437908
570.213, 0.372549
576.596, 0.300654
585.106, 0.24183
602.128, 0.222222
617.021, 0.27451
621.277, 0.320261
625.532, 0.333333
638.298, 0.333333
651.064, 0.281046
659.574, 0.222222
663.83, 0.183007
674.468, 0.124183
680.851, 0.0980392
691.489, 0.104575
700, 0.163399
725.532, 0.228758
768.085, 0.294118
}

// #118 - Light Blue
#declare TS_L118 = spline{linear_spline
368.085, 0.263158
389.362, 0.269737
406.383, 0.302632
412.766, 0.368421
417.021, 0.427632
423.404, 0.493421
427.66, 0.559211
434.043, 0.618421
442.553, 0.677632
446.809, 0.717105
457.447, 0.717105
468.085, 0.736842
487.234, 0.717105
500, 0.664474
510.638, 0.611842
519.149, 0.552632
531.915, 0.493421
546.809, 0.447368
553.191, 0.342105
559.574, 0.276316
565.957, 0.217105
574.468, 0.157895
589.362, 0.0657895
595.745, 0.0394737
604.255, 0.0131579
614.894, 0.0197368
636.17, 0.0394737
655.319, 0.0131579
670.213, 0
680.851, 0.0131579
695.745, 0.0592105
702.128, 0.111842
714.894, 0.164474
729.787, 0.210526
}

// #119 - Dark Blue
#declare TS_L119 = spline{linear_spline
374.468, 0.366013
391.489, 0.385621
408.511, 0.418301
412.766, 0.437908
421.277, 0.464052
427.66, 0.48366
440.426, 0.477124
453.191, 0.431373
461.702, 0.372549
476.596, 0.326797
487.234, 0.261438
495.745, 0.202614
506.383, 0.143791
508.511, 0.124183
514.894, 0.0653595
534.043, 0.0261438
542.553, 0
587.234, 0.00653595
610.638, 0.0130719
625.532, 0
657.447, 0
676.596, 0
685.106, 0.0130719
700, 0.0588235
717.021, 0.150327
736.17, 0.189542
755.319, 0.215686
}

// #120 - Deep Blue
#declare TS_L120 = spline{linear_spline
363.571, 0.211921
385, 0.238411
404.286, 0.291391
410.714, 0.350993
427.857, 0.324503
442.857, 0.278146
453.571, 0.218543
468.571, 0.172185
485.714, 0.13245
500.714, 0.0860927
515.714, 0.0463576
535, 0.0198675
552.143, 0
667.857, 0
678.571, 0.013245
695.714, 0.0596026
715, 0.145695
740.714, 0.211921
770.714, 0.245033
}

// #121 - LEE Green
#declare TS_L121 = spline{linear_spline
370.629, 0.0649351
397.902, 0.025974
425.175, 0
431.469, 0.012987
446.154, 0.0584416
454.545, 0.116883
469.231, 0.25974
477.622, 0.318182
481.818, 0.454545
492.308, 0.525974
494.406, 0.623377
500.699, 0.707792
504.895, 0.772727
509.091, 0.844156
511.189, 0.87013
523.776, 0.88961
538.462, 0.857143
548.951, 0.779221
555.245, 0.714286
563.636, 0.62987
567.832, 0.532468
582.517, 0.5
588.811, 0.422078
593.007, 0.331169
607.692, 0.318182
626.573, 0.285714
639.161, 0.233766
651.748, 0.188312
662.238, 0.103896
668.531, 0.0844156
679.021, 0.103896
689.51, 0.162338
695.804, 0.220779
700, 0.285714
714.685, 0.38961
758.741, 0.474026
}

// #122 - Fern Green
#declare TS_L122 = spline{linear_spline
372.34, 0.118421
404.255, 0.0855263
425.532, 0.0723684
444.681, 0.0855263
461.702, 0.118421
472.34, 0.177632
476.596, 0.342105
480.851, 0.453947
485.106, 0.506579
487.234, 0.605263
495.745, 0.664474
506.383, 0.723684
508.511, 0.756579
517.021, 0.763158
534.043, 0.730263
544.681, 0.671053
553.191, 0.605263
559.574, 0.539474
563.83, 0.473684
591.489, 0.269737
593.617, 0.197368
604.255, 0.184211
621.277, 0.144737
638.298, 0.111842
653.191, 0.0657895
663.83, 0.0657895
668.085, 0.0921053
674.468, 0.184211
685.106, 0.230263
687.234, 0.25
693.617, 0.309211
702.128, 0.407895
723.404, 0.460526
757.447, 0.532895
}

// #124 - Dark Green
#declare TS_L124 = spline{linear_spline
367.857, 0.0397351
404.286, 0.0264901
425.714, 0.013245
436.429, 0
447.143, 0.013245
462.143, 0.0596026
472.857, 0.119205
481.429, 0.238411
485.714, 0.377483
494.286, 0.470199
498.571, 0.529801
502.857, 0.642384
505, 0.596026
509.286, 0.655629
515.714, 0.682119
524.286, 0.655629
532.857, 0.596026
539.286, 0.529801
547.857, 0.417219
554.286, 0.350993
558.571, 0.291391
565, 0.225166
569.286, 0.172185
586.429, 0.0927152
599.286, 0.00662252
603.571, 0
625, 0
646.429, 0
667.857, 0
689.286, 0
700, 0.0198675
721.429, 0.0993377
760, 0.152318
}

// #126 - Mauve
#declare TS_L126 = spline{linear_spline
376.596, 0.313725
404.255, 0.366013
410.638, 0.392157
421.277, 0.398693
436.17, 0.359477
448.936, 0.300654
459.574, 0.248366
470.213, 0.189542
478.723, 0.130719
489.362, 0.0718954
502.128, 0.0261438
519.149, 0
576.596, 0
587.234, 0.00653595
608.511, 0.0196078
623.404, 0.0653595
634.043, 0.124183
640.426, 0.176471
646.809, 0.235294
651.064, 0.313725
657.447, 0.359477
661.702, 0.470588
670.213, 0.555556
672.34, 0.647059
676.596, 0.666667
682.979, 0.751634
687.234, 0.816993
691.489, 0.862745
695.745, 0.875817
721.277, 0.908497
759.574, 0.928105
}

// #127 - Smokey Pink
#declare TS_L127 = spline{linear_spline
372.34, 0.117647
404.255, 0.124183
414.894, 0.111111
425.532, 0.124183
444.681, 0.104575
468.085, 0.0980392
525.532, 0.0915033
544.681, 0.0718954
561.702, 0.0326797
582.979, 0.0392157
591.489, 0.0849673
604.255, 0.137255
608.511, 0.176471
617.021, 0.235294
625.532, 0.294118
634.043, 0.366013
642.553, 0.424837
653.191, 0.48366
661.702, 0.555556
668.085, 0.614379
676.596, 0.679739
682.979, 0.738562
689.362, 0.79085
700, 0.862745
727.66, 0.901961
774.468, 0.921569
}

// #128 - Bright Pink
#declare TS_L128 = spline{linear_spline
374.825, 0.350649
387.413, 0.38961
412.587, 0.428571
423.077, 0.402597
435.664, 0.350649
446.154, 0.292208
458.741, 0.246753
467.133, 0.188312
475.524, 0.12987
490.21, 0.0779221
504.895, 0.038961
517.483, 0.00649351
542.657, 0
555.245, 0.012987
572.028, 0.0519481
584.615, 0.103896
593.007, 0.149351
597.203, 0.207792
605.594, 0.233766
609.79, 0.402597
622.378, 0.577922
628.671, 0.753247
637.063, 0.818182
649.65, 0.87013
664.336, 0.837662
683.217, 0.863636
702.098, 0.87013
754.545, 0.883117
}

// #130 - Clear
#declare TS_L130 = spline{linear_spline
368.31, 0.843137
387.324, 0.856209
406.338, 0.869281
416.901, 0.862745
427.465, 0.862745
448.592, 0.869281
463.38, 0.869281
482.394, 0.882353
492.958, 0.875817
499.296, 0.869281
514.085, 0.908497
518.31, 0.941176
524.648, 0.888889
530.986, 0.869281
543.662, 0.869281
564.789, 0.869281
585.915, 0.869281
602.817, 0.875817
623.944, 0.875817
636.62, 0.869281
651.408, 0.862745
666.197, 0.875817
674.648, 0.869281
695.775, 0.869281
744.366, 0.869281
}

// #131 - Marine Blue
#declare TS_L131 = spline{linear_spline
372.535, 0.320261
404.225, 0.359477
421.127, 0.398693
427.465, 0.418301
442.254, 0.464052
450.704, 0.522876
459.155, 0.581699
471.831, 0.640523
482.394, 0.751634
484.507, 0.79085
495.07, 0.764706
501.408, 0.738562
509.859, 0.738562
522.535, 0.686275
524.648, 0.666667
535.211, 0.607843
573.239, 0.313725
581.69, 0.254902
585.915, 0.235294
594.366, 0.176471
598.592, 0.124183
611.268, 0.0784314
621.831, 0.0326797
628.169, 0.0392157
645.07, 0.0784314
651.408, 0.0915033
661.972, 0.0980392
672.535, 0.0653595
676.761, 0.0588235
680.986, 0.0588235
687.324, 0.104575
695.775, 0.163399
700, 0.202614
731.69, 0.27451
767.606, 0.333333
}

// #132 - Medium Blue
#declare TS_L132 = spline{linear_spline
376.596, 0.177632
404.255, 0.276316
410.638, 0.342105
419.149, 0.434211
425.532, 0.493421
434.043, 0.559211
436.17, 0.625
446.809, 0.644737
457.447, 0.638158
465.957, 0.625
478.723, 0.572368
489.362, 0.513158
491.489, 0.447368
495.745, 0.414474
504.255, 0.355263
514.894, 0.289474
523.404, 0.230263
527.66, 0.177632
531.915, 0.131579
538.298, 0.118421
553.191, 0.0723684
568.085, 0.0263158
576.596, 0
597.872, 0
619.149, 0
640.426, 0
659.574, 0.0263158
680.851, 0.0328947
689.362, 0.0921053
700, 0.151316
727.66, 0.282895
763.83, 0.309211
}

// #134 - Golden Amber
#declare TS_L134 = spline{linear_spline
365.957, 0.104575
404.255, 0.0915033
425.532, 0.0849673
440.426, 0.0784314
461.702, 0.0718954
474.468, 0.0784314
491.489, 0.117647
506.383, 0.156863
525.532, 0.189542
544.681, 0.222222
559.574, 0.261438
572.34, 0.333333
580.851, 0.398693
595.745, 0.490196
602.128, 0.54902
610.638, 0.614379
625.532, 0.745098
631.915, 0.810458
644.681, 0.856209
653.191, 0.856209
672.34, 0.882353
691.489, 0.895425
717.021, 0.856209
776.596, 0.843137
}

// #135 - Deep Golden Amber
#declare TS_L135 = spline{linear_spline
363.83, 0
404.255, 0
425.532, 0
446.809, 0
468.085, 0
489.362, 0
510.638, 0
534.043, 0.0130719
551.064, 0.0522876
563.83, 0.104575
576.596, 0.176471
587.234, 0.333333
602.128, 0.581699
606.383, 0.647059
617.021, 0.784314
625.532, 0.843137
638.298, 0.895425
657.447, 0.895425
676.596, 0.882353
697.872, 0.895425
731.915, 0.921569
780.851, 0.908497
}

// #136 - Pale Lavender
#declare TS_L136 = spline{linear_spline
368.085, 0.627451
404.255, 0.679739
421.277, 0.712418
438.298, 0.679739
453.191, 0.633987
465.957, 0.588235
480.851, 0.535948
497.872, 0.496732
508.511, 0.444444
523.404, 0.411765
527.66, 0.405229
540.426, 0.359477
555.319, 0.313725
572.34, 0.27451
587.234, 0.313725
589.362, 0.359477
602.128, 0.411765
614.894, 0.464052
625.532, 0.522876
634.043, 0.581699
646.809, 0.633987
657.447, 0.686275
665.957, 0.745098
676.596, 0.803922
687.234, 0.856209
695.745, 0.888889
727.66, 0.869281
778.723, 0.875817
}

// #137 - Special Lavender
#declare TS_L137 = spline{linear_spline
370.213, 0.588235
404.255, 0.647059
414.894, 0.705882
434.043, 0.745098
451.064, 0.72549
465.957, 0.686275
478.723, 0.594771
482.979, 0.51634
491.489, 0.424837
493.617, 0.405229
502.128, 0.392157
508.511, 0.326797
517.021, 0.267974
525.532, 0.20915
542.553, 0.163399
555.319, 0.111111
563.83, 0.0784314
572.34, 0.0849673
585.106, 0.130719
587.234, 0.163399
595.745, 0.189542
597.872, 0.202614
612.766, 0.248366
625.532, 0.346405
629.787, 0.411765
642.553, 0.464052
655.319, 0.588235
665.957, 0.647059
670.213, 0.705882
678.723, 0.771242
695.745, 0.816993
729.787, 0.901961
770.213, 0.901961
}

// #138 - Pale Green
#declare TS_L138 = spline{linear_spline
372.34, 0.0657895
404.255, 0.0657895
421.277, 0.0986842
431.915, 0.157895
442.553, 0.217105
451.064, 0.276316
463.83, 0.381579
472.34, 0.440789
476.596, 0.5
478.723, 0.585526
485.106, 0.684211
487.234, 0.756579
489.362, 0.776316
504.255, 0.835526
514.894, 0.855263
525.532, 0.855263
538.298, 0.802632
555.319, 0.763158
568.085, 0.710526
582.979, 0.605263
595.745, 0.546053
612.766, 0.506579
621.277, 0.453947
631.915, 0.361842
638.298, 0.276316
640.426, 0.217105
646.809, 0.210526
655.319, 0.223684
657.447, 0.269737
659.574, 0.309211
663.83, 0.342105
670.213, 0.401316
674.468, 0.434211
680.851, 0.493421
685.106, 0.539474
691.489, 0.611842
702.128, 0.651316
717.021, 0.697368
751.064, 0.736842
}

// #139 - Primary Green
#declare TS_L139 = spline{linear_spline
368.085, 0
400, 0
410.638, 0.0131579
431.915, 0.0131579
453.191, 0.0131579
459.574, 0.0197368
476.596, 0.0592105
487.234, 0.111842
497.872, 0.171053
504.255, 0.230263
510.638, 0.296053
514.894, 0.328947
523.404, 0.342105
538.298, 0.315789
544.681, 0.25
548.936, 0.230263
559.574, 0.171053
572.34, 0.118421
585.106, 0.0723684
602.128, 0.0263158
621.277, 0.0131579
642.553, 0.0131579
663.83, 0.0131579
685.106, 0.0131579
731.915, 0.0131579
}

// #140 - Summer Blue
#declare TS_L140 = spline{linear_spline
366.197, 0.512987
408.451, 0.62987
416.901, 0.688312
427.465, 0.746753
442.254, 0.792208
459.155, 0.824675
476.056, 0.798701
492.958, 0.75974
505.634, 0.707792
514.085, 0.649351
526.761, 0.551948
535.211, 0.493506
543.662, 0.435065
554.225, 0.376623
564.789, 0.318182
579.577, 0.220779
592.254, 0.168831
607.042, 0.123377
615.493, 0.0714286
621.831, 0.0454545
630.282, 0.0649351
638.732, 0.123377
649.296, 0.188312
657.746, 0.201299
668.31, 0.188312
683.099, 0.227273
691.549, 0.292208
695.775, 0.350649
700, 0.428571
729.577, 0.538961
776.056, 0.597403
}

// #141 - Bright Blue
#declare TS_L141 = spline{linear_spline
370.629, 0.331169
391.608, 0.383117
406.294, 0.467532
410.49, 0.532468
416.783, 0.62987
420.979, 0.662338
429.371, 0.675325
446.154, 0.688312
458.741, 0.675325
469.231, 0.623377
479.72, 0.564935
490.21, 0.506494
504.895, 0.461039
515.385, 0.402597
523.776, 0.344156
536.364, 0.292208
542.657, 0.233766
551.049, 0.168831
561.538, 0.116883
576.224, 0.0714286
593.007, 0.038961
613.986, 0.012987
639.161, 0
647.552, 0.012987
658.042, 0.00649351
674.825, 0.00649351
689.51, 0.012987
702.098, 0.0194805
762.937, 0.025974
}

// #142 - Pale Violet
#declare TS_L142 = spline{linear_spline
383.099, 0.681818
404.225, 0.720779
412.676, 0.74026
423.239, 0.74026
442.254, 0.714286
454.93, 0.668831
469.718, 0.623377
482.394, 0.571429
495.07, 0.519481
503.521, 0.441558
509.859, 0.383117
514.085, 0.344156
524.648, 0.285714
533.099, 0.227273
543.662, 0.136364
556.338, 0.0844156
566.901, 0.012987
579.577, 0.00649351
585.915, 0.025974
598.592, 0.0779221
602.817, 0.103896
611.268, 0.116883
615.493, 0.103896
626.056, 0.123377
632.394, 0.201299
634.507, 0.272727
642.958, 0.350649
649.296, 0.396104
653.521, 0.474026
661.972, 0.532468
666.197, 0.571429
672.535, 0.649351
678.873, 0.805195
683.099, 0.837662
687.324, 0.863636
697.887, 0.876623
727.465, 0.896104
765.493, 0.902597
}

// #143 - Pale Navy Blue
#declare TS_L143 = spline{linear_spline
372.535, 0.233766
404.225, 0.292208
416.901, 0.344156
431.69, 0.38961
448.592, 0.428571
465.493, 0.474026
484.507, 0.448052
499.296, 0.409091
516.197, 0.363636
526.761, 0.311688
539.437, 0.253247
550, 0.194805
560.563, 0.149351
579.577, 0.0909091
583.803, 0.0584416
598.592, 0.0454545
613.38, 0.0454545
628.169, 0.0714286
647.183, 0.103896
664.085, 0.0584416
674.648, 0.0584416
683.099, 0.103896
691.549, 0.25974
693.662, 0.324675
702.113, 0.467532
716.901, 0.597403
752.817, 0.649351
786.62, 0.649351
}

// #144 - No Color Blue
#declare TS_L144 = spline{linear_spline
368.31, 0.298701
404.225, 0.454545
410.563, 0.519481
419.014, 0.62987
427.465, 0.688312
438.028, 0.720779
469.718, 0.714286
486.62, 0.681818
501.408, 0.636364
511.972, 0.577922
520.423, 0.519481
526.761, 0.454545
533.099, 0.38961
541.549, 0.331169
552.113, 0.194805
562.676, 0.12987
579.577, 0.0844156
596.479, 0.0584416
615.493, 0.0649351
636.62, 0.0714286
645.07, 0.0844156
651.408, 0.0714286
661.972, 0.0324675
668.31, 0.025974
678.873, 0.0324675
683.099, 0.0649351
689.437, 0.12987
695.775, 0.188312
697.887, 0.214286
706.338, 0.344156
731.69, 0.415584
767.606, 0.467532
}

// #147 - Apricot
#declare TS_L147 = spline{linear_spline
368.531, 0.279221
404.196, 0.272727
423.077, 0.253247
435.664, 0.194805
448.252, 0.149351
462.937, 0.11039
479.72, 0.0974026
486.014, 0.11039
498.601, 0.162338
511.189, 0.214286
523.776, 0.266234
534.266, 0.318182
544.755, 0.376623
553.147, 0.480519
561.538, 0.512987
569.93, 0.551948
574.126, 0.623377
582.517, 0.675325
586.713, 0.733766
590.909, 0.811688
605.594, 0.844156
611.888, 0.863636
620.28, 0.857143
626.573, 0.844156
634.965, 0.850649
647.552, 0.883117
658.042, 0.863636
666.434, 0.831169
674.825, 0.837662
691.608, 0.883117
702.098, 0.850649
720.979, 0.831169
752.448, 0.831169
}

// #148 - Bright Rose
#declare TS_L148 = spline{linear_spline
368.31, 0.0519481
402.113, 0.12987
412.676, 0.181818
423.239, 0.214286
429.577, 0.24026
440.141, 0.227273
452.817, 0.181818
469.718, 0.136364
478.169, 0.0714286
497.183, 0.0519481
516.197, 0.025974
524.648, 0.0324675
545.775, 0.0324675
560.563, 0.038961
577.465, 0.0714286
594.366, 0.116883
604.93, 0.168831
609.155, 0.266234
615.493, 0.337662
619.718, 0.461039
626.056, 0.564935
636.62, 0.707792
649.296, 0.779221
661.972, 0.831169
678.873, 0.863636
689.437, 0.876623
697.887, 0.863636
738.028, 0.811688
778.169, 0.779221
}

// #151 - Gold Tint
#declare TS_L151 = spline{linear_spline
370.213, 0.529412
400, 0.54902
412.766, 0.588235
419.149, 0.562092
434.043, 0.581699
453.191, 0.562092
463.83, 0.542484
470.213, 0.490196
480.851, 0.464052
500, 0.444444
514.894, 0.464052
531.915, 0.509804
542.553, 0.562092
555.319, 0.614379
563.83, 0.673203
578.723, 0.79085
585.106, 0.830065
591.489, 0.843137
604.255, 0.849673
610.638, 0.836601
625.532, 0.875817
644.681, 0.862745
661.702, 0.895425
674.468, 0.915033
682.979, 0.856209
691.489, 0.843137
700, 0.882353
719.149, 0.901961
772.34, 0.928105
}

// #152 - Pale Gold
#declare TS_L152 = spline{linear_spline
383.099, 0.542484
406.338, 0.575163
425.352, 0.562092
442.254, 0.562092
450.704, 0.529412
454.93, 0.496732
465.493, 0.48366
473.944, 0.457516
484.507, 0.464052
501.408, 0.496732
514.085, 0.54902
524.648, 0.601307
535.211, 0.738562
543.662, 0.803922
556.338, 0.856209
573.239, 0.908497
579.577, 0.882353
583.803, 0.862745
598.592, 0.862745
609.155, 0.849673
617.606, 0.875817
623.944, 0.882353
632.394, 0.849673
638.732, 0.836601
649.296, 0.869281
670.423, 0.882353
680.986, 0.836601
687.324, 0.803922
700, 0.816993
719.014, 0.836601
750.704, 0.869281
}

// #153 - Pale Salmon
#declare TS_L153 = spline{linear_spline
369.778, 0.694805
382.468, 0.701299
405.68, 0.688312
411.935, 0.649351
418.26, 0.642857
435.092, 0.61039
445.656, 0.61039
447.7, 0.577922
451.829, 0.532468
456.055, 0.532468
475, 0.5
491.833, 0.467532
500.16, 0.409091
506.484, 0.402597
517.061, 0.409091
529.779, 0.428571
548.806, 0.435065
557.381, 0.493506
568.067, 0.551948
574.529, 0.61039
578.946, 0.701299
589.647, 0.766234
600.32, 0.818182
606.727, 0.850649
617.304, 0.857143
632.093, 0.857143
651.162, 0.883117
657.527, 0.896104
668.09, 0.896104
674.305, 0.837662
680.643, 0.837662
699.698, 0.857143
720.839, 0.863636
750.416, 0.863636
}

// #154 - Pale Rose
#declare TS_L154 = spline{linear_spline
376.761, 0.677419
404.225, 0.709677
423.239, 0.703226
433.803, 0.645161
452.817, 0.612903
461.268, 0.56129
478.169, 0.522581
484.507, 0.535484
492.958, 0.516129
499.296, 0.496774
509.859, 0.516129
524.648, 0.56129
541.549, 0.593548
558.451, 0.632258
571.127, 0.683871
577.465, 0.716129
588.028, 0.767742
600.704, 0.832258
613.38, 0.858065
630.282, 0.845161
640.845, 0.83871
649.296, 0.864516
666.197, 0.851613
676.761, 0.83871
691.549, 0.864516
700, 0.883871
765.493, 0.883871
}

// #156 - Chocolate
#declare TS_L156 = spline{linear_spline
372.917, 0.309677
406.25, 0.283871
416.667, 0.232258
435.417, 0.2
445.833, 0.148387
456.25, 0.0967742
475, 0.0709677
493.75, 0.103226
508.333, 0.141935
522.917, 0.193548
541.667, 0.225806
558.333, 0.264516
566.667, 0.264516
581.25, 0.219355
589.583, 0.193548
602.083, 0.212903
618.75, 0.245161
627.083, 0.303226
633.333, 0.4
639.583, 0.458065
643.75, 0.490323
652.083, 0.509677
656.25, 0.535484
662.5, 0.503226
670.833, 0.445161
681.25, 0.445161
687.5, 0.509677
693.75, 0.574194
700, 0.632258
722.917, 0.709677
764.583, 0.754839
}

// #157 - Pink
#declare TS_L157 = spline{linear_spline
370.423, 0.402597
380.986, 0.402597
404.225, 0.402597
423.239, 0.38961
435.915, 0.337662
448.592, 0.285714
463.38, 0.24026
478.169, 0.188312
490.845, 0.136364
495.07, 0.103896
503.521, 0.0909091
509.859, 0.0844156
530.986, 0.0844156
550, 0.116883
564.789, 0.155844
573.239, 0.207792
577.465, 0.376623
583.803, 0.454545
592.254, 0.506494
594.366, 0.62987
600.704, 0.668831
602.817, 0.733766
609.155, 0.772727
617.606, 0.831169
632.394, 0.831169
647.183, 0.850649
653.521, 0.87013
666.197, 0.87013
689.437, 0.876623
710.563, 0.87013
780.282, 0.883117
}

// #158 - Deep Orange
#declare TS_L158 = spline{linear_spline
372.34, 0.0124693
404.255, 0.0197006
425.532, 0.033236
444.681, 0.0271172
465.957, 0.0210448
495.745, 0.00208594
504.255, 0.0153433
519.149, 0.0548834
534.043, 0.107495
546.809, 0.160061
557.447, 0.212581
572.34, 0.324016
580.851, 0.409169
595.745, 0.514069
604.255, 0.573077
617.021, 0.749826
625.532, 0.808835
640.426, 0.861447
657.447, 0.881426
678.723, 0.881889
731.915, 0.889584
772.34, 0.897001
}

// #159 - No Color Straw
#declare TS_L159 = spline{linear_spline
376.761, 0.712418
391.549, 0.705882
404.225, 0.69281
414.789, 0.673203
421.127, 0.69281
425.352, 0.718954
438.028, 0.72549
457.042, 0.745098
469.718, 0.745098
476.056, 0.764706
482.394, 0.79085
492.958, 0.803922
509.859, 0.836601
518.31, 0.849673
526.761, 0.823529
537.324, 0.843137
556.338, 0.849673
562.676, 0.908497
566.901, 0.875817
579.577, 0.862745
590.141, 0.862745
609.155, 0.895425
632.394, 0.888889
653.521, 0.875817
680.986, 0.895425
700, 0.862745
719.014, 0.843137
752.817, 0.823529
}

// #161 - Slate Blue
#declare TS_L161 = spline{linear_spline
382.979, 0.54902
404.255, 0.581699
414.894, 0.640523
423.404, 0.699346
429.787, 0.75817
438.298, 0.816993
453.191, 0.797386
463.83, 0.745098
472.34, 0.653595
476.596, 0.588235
491.489, 0.444444
504.255, 0.392157
517.021, 0.339869
525.532, 0.281046
542.553, 0.235294
553.191, 0.183007
561.702, 0.124183
563.83, 0.0980392
578.723, 0.0522876
589.362, 0.0849673
604.255, 0.0915033
612.766, 0.0653595
627.66, 0.0522876
638.298, 0.202614
648.936, 0.287582
655.319, 0.346405
661.702, 0.398693
670.213, 0.457516
685.106, 0.614379
689.362, 0.679739
691.489, 0.738562
697.872, 0.803922
714.894, 0.849673
763.83, 0.901961
}

// #162 - Bastard Amber
#declare TS_L162 = spline{linear_spline
370.629, 0.733766
404.196, 0.727273
423.077, 0.701299
439.86, 0.675325
448.252, 0.623377
465.035, 0.584416
481.818, 0.545455
490.21, 0.545455
509.091, 0.564935
525.874, 0.603896
538.462, 0.655844
548.951, 0.707792
557.343, 0.766234
569.93, 0.811688
574.126, 0.850649
588.811, 0.863636
605.594, 0.902597
622.378, 0.876623
628.671, 0.876623
647.552, 0.876623
664.336, 0.837662
672.727, 0.824675
687.413, 0.863636
706.294, 0.88961
750.35, 0.922078
779.72, 0.909091
}

// #164 - Flame Red
#declare TS_L164 = spline{linear_spline
376.923, 0.025974
404.196, 0.0324675
425.175, 0.038961
435.664, 0.025974
444.056, 0.038961
450.35, 0.038961
465.035, 0.038961
496.503, 0.0324675
517.483, 0.0324675
523.776, 0.0454545
536.364, 0.0519481
553.147, 0.025974
559.441, 0
572.028, 0.012987
584.615, 0.0584416
586.713, 0.123377
588.811, 0.5
593.007, 0.512987
597.203, 0.623377
601.399, 0.636364
607.692, 0.681818
616.084, 0.753247
622.378, 0.805195
632.867, 0.863636
637.063, 0.883117
645.455, 0.88961
664.336, 0.896104
683.217, 0.922078
700, 0.909091
746.154, 0.909091
771.329, 0.915584
}

// #165 - Daylight Blue
#declare TS_L165 = spline{linear_spline
381.119, 0.409091
391.608, 0.428571
404.196, 0.467532
408.392, 0.532468
412.587, 0.616883
416.783, 0.649351
420.979, 0.714286
427.273, 0.772727
433.566, 0.824675
450.35, 0.805195
460.839, 0.753247
471.329, 0.694805
479.72, 0.636364
486.014, 0.603896
492.308, 0.590909
506.993, 0.545455
515.385, 0.487013
521.678, 0.448052
532.168, 0.396104
540.559, 0.311688
548.951, 0.246753
563.636, 0.149351
574.126, 0.0909091
582.517, 0.0584416
590.909, 0.0584416
611.888, 0.0649351
622.378, 0.0454545
630.769, 0.038961
647.552, 0.0519481
653.846, 0.116883
660.14, 0.142857
668.531, 0.162338
679.021, 0.220779
687.413, 0.279221
689.51, 0.357143
691.608, 0.422078
693.706, 0.467532
697.902, 0.480519
710.49, 0.532468
758.741, 0.551948
}

// #166 - Pale Red
#declare TS_L166 = spline{linear_spline
379.021, 0.233766
406.294, 0.272727
414.685, 0.292208
423.077, 0.272727
437.762, 0.227273
448.252, 0.168831
458.741, 0.116883
465.035, 0.0779221
473.427, 0.0714286
481.818, 0.0584416
500.699, 0.0324675
511.189, 0.038961
530.07, 0.0584416
544.755, 0.103896
555.245, 0.162338
574.126, 0.363636
576.224, 0.454545
588.811, 0.538961
609.79, 0.733766
616.084, 0.805195
632.867, 0.837662
653.846, 0.844156
672.727, 0.876623
691.608, 0.876623
700, 0.857143
729.371, 0.850649
771.329, 0.831169
}

// #169 - Lilac Tint
#declare TS_L169 = spline{linear_spline
370.423, 0.714286
404.225, 0.753247
408.451, 0.772727
416.901, 0.766234
421.127, 0.779221
425.352, 0.792208
438.028, 0.772727
448.592, 0.798701
452.817, 0.785714
457.042, 0.74026
465.493, 0.74026
482.394, 0.707792
486.62, 0.688312
499.296, 0.681818
503.521, 0.642857
514.085, 0.636364
530.986, 0.603896
539.437, 0.545455
558.451, 0.532468
573.239, 0.493506
575.352, 0.461039
583.803, 0.474026
585.915, 0.487013
596.479, 0.545455
607.042, 0.603896
617.606, 0.662338
628.169, 0.720779
642.958, 0.766234
655.634, 0.811688
666.197, 0.87013
685.211, 0.922078
700, 0.902597
719.014, 0.863636
773.944, 0.831169
}

// #170 - Deep Lavender
#declare TS_L170 = spline{linear_spline
370.629, 0.477419
385.315, 0.516129
402.098, 0.56129
416.783, 0.612903
431.469, 0.632258
435.664, 0.593548
448.252, 0.541935
462.937, 0.496774
467.133, 0.464516
477.622, 0.458065
481.818, 0.406452
488.112, 0.4
500.699, 0.348387
504.895, 0.329032
517.483, 0.322581
530.07, 0.270968
542.657, 0.219355
555.245, 0.174194
572.028, 0.129032
576.224, 0.122581
590.909, 0.167742
603.497, 0.212903
613.986, 0.270968
616.084, 0.335484
622.378, 0.393548
632.867, 0.451613
643.357, 0.503226
651.748, 0.56129
662.238, 0.619355
670.629, 0.677419
674.825, 0.76129
685.315, 0.812903
695.804, 0.851613
720.979, 0.845161
771.329, 0.832258
}

// #172 - Lagoon Blue
#declare TS_L172 = spline{linear_spline
366.937, 0.12987
389.949, 0.175325
404.627, 0.220779
413.082, 0.279221
419.467, 0.344156
427.963, 0.422078
436.418, 0.480519
442.803, 0.545455
455.438, 0.61039
465.977, 0.668831
474.432, 0.727273
480.777, 0.772727
487.04, 0.779221
503.626, 0.74026
513.934, 0.688312
515.923, 0.642857
519.954, 0.577922
530.1, 0.448052
536.134, 0.344156
542.248, 0.279221
544.264, 0.246753
550.392, 0.188312
560.593, 0.0844156
570.887, 0.025974
581.25, 0
602.083, 0
622.917, 0
643.75, 0
664.583, 0
685.417, 0
704.167, 0
739.583, 0
768.75, 0
}

// #174 - Dark Steel Blue
#declare TS_L174 = spline{linear_spline
372.535, 0.51634
389.437, 0.522876
406.338, 0.555556
414.789, 0.588235
416.901, 0.69281
431.69, 0.718954
452.817, 0.75817
463.38, 0.718954
471.831, 0.666667
482.394, 0.601307
499.296, 0.562092
509.859, 0.503268
516.197, 0.431373
528.873, 0.392157
543.662, 0.339869
550, 0.281046
558.451, 0.222222
569.014, 0.163399
579.577, 0.0980392
598.592, 0.117647
619.718, 0.111111
628.169, 0.130719
630.282, 0.189542
636.62, 0.222222
642.958, 0.261438
647.183, 0.379085
655.634, 0.431373
666.197, 0.490196
676.761, 0.54902
687.324, 0.601307
695.775, 0.660131
710.563, 0.732026
738.028, 0.777778
763.38, 0.784314
}

// #176 - Loving Amber
#declare TS_L176 = spline{linear_spline
370.629, 0.454545
387.413, 0.461039
404.196, 0.467532
414.685, 0.480519
423.077, 0.467532
437.762, 0.480519
452.448, 0.428571
465.035, 0.383117
481.818, 0.337662
490.21, 0.285714
494.406, 0.246753
502.797, 0.24026
521.678, 0.233766
536.364, 0.279221
546.853, 0.337662
559.441, 0.383117
565.734, 0.512987
574.126, 0.577922
576.224, 0.694805
582.517, 0.753247
588.811, 0.818182
601.399, 0.863636
611.888, 0.883117
632.867, 0.88961
651.748, 0.876623
660.14, 0.883117
681.119, 0.883117
697.902, 0.844156
735.664, 0.850649
775.524, 0.850649
}

// #179 - Chrome Orange
#declare TS_L179 = spline{linear_spline
368.531, 0
404.196, 0
425.175, 0
433.566, 0.012987
446.154, 0.00649351
462.937, 0.00649351
488.112, 0.025974
504.895, 0.0584416
515.385, 0.11039
523.776, 0.175325
530.07, 0.233766
536.364, 0.298701
544.755, 0.38961
555.245, 0.5
559.441, 0.655844
567.832, 0.720779
582.517, 0.837662
586.713, 0.87013
597.203, 0.876623
620.28, 0.88961
637.063, 0.876623
647.552, 0.88961
653.846, 0.88961
668.531, 0.88961
681.119, 0.909091
687.413, 0.896104
697.902, 0.915584
725.175, 0.941558
771.329, 0.941558
}

// #180 - Dark Lavender
#declare TS_L180 = spline{linear_spline
368.531, 0.415584
389.51, 0.435065
406.294, 0.474026
418.881, 0.525974
427.273, 0.584416
433.566, 0.616883
450.35, 0.636364
462.937, 0.584416
473.427, 0.525974
483.916, 0.448052
494.406, 0.38961
502.797, 0.331169
511.189, 0.272727
521.678, 0.214286
527.972, 0.155844
534.266, 0.0974026
551.049, 0.038961
576.224, 0
599.301, 0
611.888, 0.012987
626.573, 0.0584416
637.063, 0.11039
649.65, 0.194805
658.042, 0.253247
664.336, 0.318182
666.434, 0.487013
670.629, 0.532468
674.825, 0.597403
681.119, 0.655844
685.315, 0.720779
689.51, 0.805195
700, 0.87013
716.783, 0.915584
767.133, 0.922078
}

// #181 - Congo Blue
#declare TS_L181 = spline{linear_spline
372.535, 0.337662
391.549, 0.357143
404.225, 0.376623
406.338, 0.409091
414.789, 0.422078
421.127, 0.402597
433.803, 0.350649
446.479, 0.298701
459.155, 0.246753
465.493, 0.194805
476.056, 0.136364
484.507, 0.0714286
488.732, 0.025974
497.183, 0.0194805
501.408, 0
522.535, 0
543.662, 0
564.789, 0
585.915, 0
607.042, 0
628.169, 0
651.408, 0.012987
661.972, 0.0714286
670.423, 0.123377
680.986, 0.220779
687.324, 0.285714
691.549, 0.344156
700, 0.519481
712.676, 0.62987
742.254, 0.688312
773.944, 0.714286
}

// #182 - Light Red
#declare TS_L182 = spline{linear_spline
370.629, 0.00645161
404.196, 0.00645161
425.175, 0
446.154, 0.00645161
467.133, 0.0129032
488.112, 0.0193548
509.091, 0.0193548
530.07, 0.0129032
538.462, 0
553.147, 0.00645161
582.517, 0.0516129
595.105, 0.103226
607.692, 0.154839
613.986, 0.277419
618.182, 0.367742
622.378, 0.432258
628.671, 0.490323
632.867, 0.6
637.063, 0.703226
643.357, 0.767742
655.944, 0.819355
670.629, 0.864516
700, 0.877419
735.664, 0.883871
775.524, 0.890323
}

// #183 - Moonlight Blue
#declare TS_L183 = spline{linear_spline
370.629, 0.219355
391.608, 0.251613
406.294, 0.277419
412.587, 0.335484
418.881, 0.4
423.077, 0.445161
429.371, 0.509677
437.762, 0.625806
452.448, 0.670968
465.035, 0.651613
473.427, 0.593548
488.112, 0.522581
498.601, 0.464516
511.189, 0.412903
521.678, 0.36129
532.168, 0.303226
540.559, 0.245161
551.049, 0.187097
563.636, 0.135484
574.126, 0.0774194
588.811, 0.0322581
605.594, 0
626.573, 0
647.552, 0
666.434, 0
687.413, 0
700, 0.0387097
714.685, 0.0903226
748.252, 0.135484
773.427, 0.141935
}

// #184 - Cosmetic Peach
#declare TS_L184 = spline{linear_spline
368.531, 0.519481
381.119, 0.532468
404.196, 0.538961
425.175, 0.545455
446.154, 0.538961
465.035, 0.525974
483.916, 0.538961
496.503, 0.551948
517.483, 0.564935
536.364, 0.584416
546.853, 0.597403
567.832, 0.61039
613.986, 0.655844
630.769, 0.62987
645.455, 0.681818
660.14, 0.727273
681.119, 0.727273
700, 0.75974
720.979, 0.805195
771.329, 0.837662
}

// #185 - Cosmetic Burgundy
#declare TS_L185 = spline{linear_spline
366.197, 0.506494
383.099, 0.512987
404.225, 0.525974
425.352, 0.532468
444.366, 0.538961
454.93, 0.532468
476.056, 0.538961
480.282, 0.545455
501.408, 0.551948
524.648, 0.538961
545.775, 0.538961
554.225, 0.532468
564.789, 0.551948
579.577, 0.590909
598.592, 0.616883
619.718, 0.62987
636.62, 0.662338
655.634, 0.681818
674.648, 0.707792
693.662, 0.733766
738.028, 0.779221
784.507, 0.824675
}

// #186 - Cosmetic Silver Rose
#declare TS_L186 = spline{linear_spline
366.434, 0.554839
385.315, 0.574194
404.196, 0.6
423.077, 0.619355
444.056, 0.619355
465.035, 0.619355
486.014, 0.593548
504.895, 0.567742
523.776, 0.554839
536.364, 0.548387
557.343, 0.548387
561.538, 0.554839
576.224, 0.6
590.909, 0.645161
601.399, 0.683871
618.182, 0.696774
637.063, 0.729032
655.944, 0.729032
670.629, 0.735484
691.608, 0.748387
733.566, 0.774194
773.427, 0.787097
}

// #187 - Cosmetic Rouge
#declare TS_L187 = spline{linear_spline
368.31, 0.496732
404.225, 0.48366
425.352, 0.470588
444.366, 0.470588
454.93, 0.48366
473.944, 0.51634
490.845, 0.542484
511.972, 0.555556
533.099, 0.555556
550, 0.529412
558.451, 0.503268
566.901, 0.51634
583.803, 0.588235
594.366, 0.647059
609.155, 0.686275
632.394, 0.699346
651.408, 0.718954
672.535, 0.72549
693.662, 0.718954
742.254, 0.732026
769.718, 0.732026
}

// #188 - Cosmetic Highlight
#declare TS_L188 = spline{linear_spline
366.197, 0.584416
404.225, 0.584416
425.352, 0.584416
446.479, 0.584416
480.282, 0.571429
495.07, 0.577922
514.085, 0.603896
533.099, 0.616883
547.887, 0.649351
562.676, 0.694805
596.479, 0.720779
619.718, 0.733766
640.845, 0.74026
651.408, 0.74026
672.535, 0.74026
693.662, 0.753247
735.915, 0.753247
771.831, 0.75974
}

// #189 - Cosmetic Silver Moss
#declare TS_L189 = spline{linear_spline
371.069, 0.597403
381.708, 0.597403
403.026, 0.577922
420.13, 0.538961
439.334, 0.512987
452.045, 0.538961
464.7, 0.590909
473.1, 0.642857
481.487, 0.701299
500.594, 0.720779
521.857, 0.727273
562.255, 0.74026
596.311, 0.733766
611.232, 0.720779
638.851, 0.74026
655.927, 0.714286
670.917, 0.668831
687.883, 0.694805
700.539, 0.746753
717.477, 0.785714
755.651, 0.844156
}

// #190 - Cosmetic Emerald
#declare TS_L190 = spline{linear_spline
382.281, 0.612903
394.93, 0.6
405.466, 0.587097
411.749, 0.56129
424.439, 0.567742
443.467, 0.574194
460.436, 0.606452
475.307, 0.645161
494.375, 0.670968
513.335, 0.645161
521.826, 0.664516
534.502, 0.664516
553.476, 0.645161
566.165, 0.651613
583.053, 0.645161
591.49, 0.63871
597.774, 0.612903
606.17, 0.587097
616.733, 0.587097
635.775, 0.6
654.748, 0.580645
665.189, 0.522581
675.738, 0.516129
682.131, 0.541935
690.704, 0.6
692.885, 0.632258
701.39, 0.658065
716.247, 0.690323
747.937, 0.690323
}

// #191 - Cosmetic Aqua Blue
#declare TS_L191 = spline{linear_spline
368.31, 0.571429
391.549, 0.603896
406.338, 0.642857
412.676, 0.655844
425.352, 0.662338
446.479, 0.662338
467.606, 0.668831
486.62, 0.688312
507.746, 0.688312
524.648, 0.681818
545.775, 0.675325
564.789, 0.662338
588.028, 0.636364
604.93, 0.603896
609.155, 0.584416
623.944, 0.584416
638.732, 0.590909
655.634, 0.564935
668.31, 0.506494
674.648, 0.480519
680.986, 0.506494
689.437, 0.564935
695.775, 0.636364
702.113, 0.649351
719.014, 0.675325
750.704, 0.688312
773.944, 0.694805
}

// #192 - Flesh Pink
#declare TS_L192 = spline{linear_spline
368.531, 0.37013
387.413, 0.396104
404.196, 0.428571
425.175, 0.441558
441.958, 0.409091
456.643, 0.363636
469.231, 0.311688
479.72, 0.253247
490.21, 0.201299
504.895, 0.155844
521.678, 0.116883
527.972, 0.0974026
538.462, 0.11039
551.049, 0.0779221
557.343, 0.0714286
563.636, 0.11039
582.517, 0.350649
584.615, 0.467532
593.007, 0.493506
597.203, 0.597403
601.399, 0.662338
611.888, 0.75974
620.28, 0.818182
639.161, 0.831169
660.14, 0.824675
679.021, 0.837662
685.315, 0.857143
697.902, 0.863636
725.175, 0.837662
771.329, 0.824675
}

// #193 - Rosy Amber
#declare TS_L193 = spline{linear_spline
370.629, 0.324675
387.413, 0.324675
406.294, 0.337662
427.273, 0.331169
446.154, 0.318182
465.035, 0.279221
479.72, 0.233766
492.308, 0.188312
509.091, 0.149351
527.972, 0.12987
544.755, 0.123377
559.441, 0.162338
574.126, 0.214286
584.615, 0.266234
595.105, 0.324675
607.692, 0.681818
620.28, 0.75974
630.769, 0.811688
651.748, 0.844156
670.629, 0.844156
691.608, 0.850649
737.762, 0.850649
771.329, 0.831169
}

// #194 - Surprise Pink
#declare TS_L194 = spline{linear_spline
368.531, 0.419355
383.217, 0.419355
404.196, 0.445161
416.783, 0.490323
429.371, 0.541935
441.958, 0.554839
448.252, 0.541935
452.448, 0.503226
460.839, 0.496774
473.427, 0.43871
483.916, 0.387097
488.112, 0.36129
492.308, 0.322581
502.797, 0.329032
515.385, 0.277419
525.874, 0.225806
538.462, 0.167742
542.657, 0.135484
551.049, 0.116129
557.343, 0.083871
567.832, 0.0903226
595.105, 0.109677
611.888, 0.148387
616.084, 0.174194
622.378, 0.212903
628.671, 0.225806
641.259, 0.277419
643.357, 0.322581
649.65, 0.335484
655.944, 0.387097
662.238, 0.509677
668.531, 0.574194
674.825, 0.632258
683.217, 0.690323
697.902, 0.709677
731.469, 0.709677
754.545, 0.696774
}

// #195 - Zenith Blue
#declare TS_L195 = spline{linear_spline
374.825, 0.309677
385.315, 0.322581
397.902, 0.367742
410.49, 0.425806
418.881, 0.483871
423.077, 0.554839
439.86, 0.593548
456.643, 0.593548
467.133, 0.541935
473.427, 0.477419
477.622, 0.419355
486.014, 0.354839
492.308, 0.296774
494.406, 0.270968
502.797, 0.212903
509.091, 0.148387
519.58, 0.0903226
525.874, 0.0258065
536.364, 0
559.441, 0
580.42, 0
601.399, 0
622.378, 0
643.357, 0
664.336, 0
670.629, 0.0129032
689.51, 0.0387097
700, 0.083871
714.685, 0.16129
746.154, 0.219355
777.622, 0.264516
}

// #196 - True Blue
#declare TS_L196 = spline{linear_spline
370.629, 0.636364
404.196, 0.681818
425.175, 0.694805
444.056, 0.694805
458.741, 0.649351
469.231, 0.590909
479.72, 0.532468
490.21, 0.474026
500.699, 0.415584
513.287, 0.363636
525.874, 0.318182
538.462, 0.25974
551.049, 0.207792
557.343, 0.149351
572.028, 0.103896
576.224, 0.0714286
586.713, 0.0714286
603.497, 0.103896
622.378, 0.136364
630.769, 0.194805
639.161, 0.253247
645.455, 0.311688
651.748, 0.350649
658.042, 0.337662
668.531, 0.285714
679.021, 0.279221
687.413, 0.305195
702.098, 0.344156
720.979, 0.38961
754.545, 0.441558
}

// #197 - Alice Blue
#declare TS_L197 = spline{linear_spline
366.197, 0.435065
389.437, 0.454545
404.225, 0.493506
425.352, 0.512987
444.366, 0.5
454.93, 0.474026
469.718, 0.435065
484.507, 0.363636
497.183, 0.311688
499.296, 0.279221
509.859, 0.220779
520.423, 0.168831
528.873, 0.11039
543.662, 0.0649351
562.676, 0.025974
581.69, 0.025974
600.704, 0.0519481
615.493, 0.0974026
621.831, 0.123377
628.169, 0.136364
649.296, 0.136364
664.085, 0.175325
674.648, 0.233766
678.873, 0.383117
683.099, 0.448052
691.549, 0.506494
702.113, 0.551948
716.901, 0.584416
750.704, 0.649351
769.718, 0.668831
}

// #198 - Palace Blue
#declare TS_L198 = spline{linear_spline
370.629, 0.103896
389.51, 0.116883
406.294, 0.155844
420.979, 0.201299
431.469, 0.25974
439.86, 0.279221
448.252, 0.279221
458.741, 0.227273
469.231, 0.175325
483.916, 0.123377
498.601, 0.0844156
519.58, 0.0649351
553.147, 0.0519481
576.224, 0.0324675
595.105, 0.0194805
616.084, 0.0194805
637.063, 0.025974
641.259, 0.0324675
658.042, 0.0454545
679.021, 0.0454545
695.804, 0.0779221
702.098, 0.116883
729.371, 0.201299
769.231, 0.220779
}

// #199 - Regal Blue
#declare TS_L199 = spline{linear_spline
370.629, 0.174194
391.608, 0.206452
404.196, 0.270968
408.392, 0.335484
414.685, 0.393548
420.979, 0.458065
427.273, 0.516129
435.664, 0.6
452.448, 0.606452
462.937, 0.548387
471.329, 0.490323
483.916, 0.387097
490.21, 0.329032
496.503, 0.270968
502.797, 0.212903
511.189, 0.129032
521.678, 0.0774194
540.559, 0.0387097
557.343, 0.0193548
578.322, 0.0193548
605.594, 0.0322581
622.378, 0.0322581
641.259, 0.0451613
653.846, 0.0967742
664.336, 0.16129
676.923, 0.141935
687.413, 0.193548
693.706, 0.258065
700, 0.393548
708.392, 0.464516
731.469, 0.509677
767.133, 0.541935
}

// #200 - Double C.T. Blue (3200K to 26000K)
#declare TS_L200 = spline{linear_spline
367.007, 0.383117
388.202, 0.415584
405.213, 0.467532
413.787, 0.525974
424.46, 0.577922
437.246, 0.62987
460.499, 0.636364
477.318, 0.597403
487.745, 0.532468
524.977, 0.155844
537.543, 0.103896
552.25, 0.0649351
558.533, 0.038961
569.124, 0.0519481
584.009, 0.0974026
603.036, 0.103896
611.419, 0.0714286
626.221, 0.0779221
638.924, 0.0909091
653.727, 0.0974026
670.505, 0.038961
685.376, 0.0779221
693.95, 0.136364
702.524, 0.194805
711.085, 0.246753
736.533, 0.292208
764.011, 0.298701
}

// #201 - Full C.T. Blue (3200K to 5700K)
#declare TS_L201 = spline{linear_spline
370.423, 0.493506
389.437, 0.506494
400, 0.532468
416.901, 0.584416
419.014, 0.649351
429.577, 0.681818
442.254, 0.746753
459.155, 0.766234
478.169, 0.753247
490.845, 0.694805
509.859, 0.662338
511.972, 0.642857
516.197, 0.584416
526.761, 0.525974
537.324, 0.467532
550, 0.383117
554.225, 0.318182
566.901, 0.298701
585.915, 0.344156
602.817, 0.324675
617.606, 0.285714
626.056, 0.25974
638.732, 0.279221
653.521, 0.292208
661.972, 0.272727
668.31, 0.194805
670.423, 0.168831
676.761, 0.201299
685.211, 0.25974
689.437, 0.324675
693.662, 0.38961
700, 0.435065
712.676, 0.461039
744.366, 0.5
778.169, 0.506494
}

// #202 - Half C.T. Blue (3200K to 4300K)
#declare TS_L202 = spline{linear_spline
370.423, 0.620915
387.324, 0.653595
404.225, 0.699346
414.789, 0.751634
429.577, 0.797386
440.141, 0.843137
450.704, 0.823529
457.042, 0.843137
469.718, 0.810458
473.944, 0.823529
482.394, 0.849673
488.732, 0.830065
497.183, 0.764706
520.423, 0.72549
526.761, 0.640523
530.986, 0.575163
537.324, 0.529412
547.887, 0.503268
562.676, 0.522876
581.69, 0.555556
590.141, 0.555556
607.042, 0.51634
613.38, 0.457516
634.507, 0.457516
645.07, 0.477124
653.521, 0.470588
659.859, 0.444444
668.31, 0.352941
678.873, 0.352941
687.324, 0.437908
691.549, 0.503268
693.662, 0.562092
697.887, 0.575163
731.69, 0.620915
771.831, 0.640523
}

// #203 - Quarter C.T. Blue (3200K to 3600K)
#declare TS_L203 = spline{linear_spline
379.167, 0.62987
393.75, 0.662338
406.25, 0.714286
410.417, 0.779221
427.083, 0.805195
439.583, 0.798701
443.75, 0.824675
452.083, 0.831169
462.5, 0.818182
468.75, 0.837662
475, 0.87013
483.333, 0.857143
487.5, 0.837662
500, 0.837662
508.333, 0.805195
512.5, 0.766234
520.833, 0.753247
535.417, 0.707792
543.75, 0.668831
552.083, 0.668831
572.917, 0.675325
581.25, 0.668831
597.917, 0.62987
618.75, 0.616883
639.583, 0.603896
639.583, 0.603896
656.25, 0.564935
670.833, 0.519481
670.833, 0.519481
675, 0.493506
683.333, 0.525974
691.667, 0.590909
691.667, 0.590909
697.917, 0.649351
712.5, 0.688312
739.583, 0.720779
770.833, 0.720779
}

// #204 - Full C.T. Orange (6500K to 3200K)
#declare TS_L204 = spline{linear_spline
368.531, 0.0909091
387.413, 0.0974026
406.294, 0.11039
427.273, 0.116883
446.154, 0.142857
460.839, 0.181818
473.427, 0.24026
481.818, 0.292208
494.406, 0.344156
506.993, 0.38961
523.776, 0.435065
538.462, 0.480519
551.049, 0.532468
569.93, 0.62987
580.42, 0.681818
595.105, 0.733766
607.692, 0.779221
622.378, 0.831169
634.965, 0.876623
653.846, 0.909091
672.727, 0.88961
691.608, 0.909091
716.783, 0.954545
748.252, 0.961039
}

// #205 - Half C.T. Orange (6500K to 3800K)
#declare TS_L205 = spline{linear_spline
375, 0.303226
391.667, 0.316129
406.25, 0.348387
418.75, 0.4
422.917, 0.419355
435.417, 0.419355
443.75, 0.374194
452.083, 0.380645
462.5, 0.432258
475, 0.483871
487.5, 0.535484
502.083, 0.587097
516.667, 0.632258
533.333, 0.658065
552.083, 0.690323
568.75, 0.735484
581.25, 0.787097
583.333, 0.812903
591.667, 0.83871
608.333, 0.870968
627.083, 0.903226
645.833, 0.909677
656.25, 0.877419
664.583, 0.883871
683.333, 0.903226
697.917, 0.909677
727.083, 0.922581
756.25, 0.922581
}

// #206 - Quarter C.T. Orange (6500K to 4600K)
#declare TS_L206 = spline{linear_spline
368.085, 0.464052
385.106, 0.477124
404.255, 0.509804
423.404, 0.535948
440.426, 0.542484
459.574, 0.54902
474.468, 0.594771
491.489, 0.633987
493.617, 0.653595
497.872, 0.686275
506.383, 0.699346
519.149, 0.718954
531.915, 0.72549
538.298, 0.751634
557.447, 0.777778
572.34, 0.823529
582.979, 0.856209
604.255, 0.869281
614.894, 0.869281
634.043, 0.888889
653.191, 0.908497
674.468, 0.908497
691.489, 0.895425
702.128, 0.901961
731.915, 0.901961
763.83, 0.908497
}

// #207 - Full C.T. Orange + 0.3ND (6500K to 3200K, minus 1 stop)
#declare TS_L207 = spline{linear_spline
374.825, 0.0118972
391.608, 0.0450913
404.196, 0.0586232
420.979, 0.0658432
441.958, 0.0732449
454.545, 0.0737898
460.839, 0.0935428
477.622, 0.13323
492.308, 0.172827
506.993, 0.218917
517.483, 0.232359
536.364, 0.246163
551.049, 0.292253
569.93, 0.325538
586.713, 0.365226
601.399, 0.411316
618.182, 0.44451
634.965, 0.484198
651.748, 0.497911
662.238, 0.491872
670.629, 0.440287
674.825, 0.36904
681.119, 0.349832
687.413, 0.41504
691.608, 0.467169
693.706, 0.512715
697.902, 0.532377
716.783, 0.591636
750.35, 0.63205
779.72, 0.626828
}

// #208 - Full C.T. Orange + 0.6ND (6500K to 3200K, minus 2 stops)
#declare TS_L208 = spline{linear_spline
370.423, 0.00653595
389.437, 0.0196078
404.225, 0.0392157
412.676, 0.0522876
423.239, 0.0392157
429.577, 0.0261438
438.028, 0.0392157
459.155, 0.0522876
478.169, 0.0588235
486.62, 0.0784314
497.183, 0.0849673
507.746, 0.0980392
528.873, 0.0980392
533.099, 0.104575
552.113, 0.130719
566.901, 0.130719
577.465, 0.150327
594.366, 0.189542
615.493, 0.196078
628.169, 0.196078
634.507, 0.215686
642.958, 0.254902
657.746, 0.254902
666.197, 0.196078
670.423, 0.150327
676.761, 0.137255
678.873, 0.176471
685.211, 0.235294
689.437, 0.300654
697.887, 0.385621
716.901, 0.444444
754.93, 0.496732
782.394, 0.48366
}

// #209 - 0.3ND (minus 1 stop)
#declare TS_L209 = spline{linear_spline
370.423, 0.467532
389.437, 0.467532
404.225, 0.474026
425.352, 0.480519
431.69, 0.5
444.366, 0.506494
463.38, 0.493506
471.831, 0.474026
484.507, 0.493506
503.521, 0.467532
520.423, 0.5
539.437, 0.5
547.887, 0.519481
564.789, 0.519481
581.69, 0.506494
598.592, 0.487013
619.718, 0.487013
626.056, 0.493506
645.07, 0.519481
653.521, 0.519481
664.085, 0.506494
668.31, 0.480519
672.535, 0.428571
678.873, 0.428571
687.324, 0.480519
691.549, 0.545455
700, 0.649351
716.901, 0.675325
746.479, 0.694805
771.831, 0.694805
}

// #210 - 0.6ND (minus 2 stops)
#declare TS_L210 = spline{linear_spline
370.423, 0.188312
391.549, 0.207792
404.225, 0.220779
425.352, 0.233766
444.366, 0.214286
452.817, 0.194805
463.38, 0.207792
478.169, 0.220779
501.408, 0.246753
522.535, 0.246753
554.225, 0.25974
583.803, 0.25974
590.141, 0.220779
598.592, 0.214286
636.62, 0.266234
655.634, 0.298701
664.085, 0.24026
668.31, 0.201299
676.761, 0.201299
687.324, 0.311688
693.662, 0.37013
702.113, 0.422078
725.352, 0.474026
761.268, 0.506494
}

// #211 - 0.9ND (minus 3 stops)
#declare TS_L211 = spline{linear_spline
368.31, 0.0974026
385.211, 0.11039
406.338, 0.11039
427.465, 0.11039
446.479, 0.0909091
454.93, 0.0714286
476.056, 0.0844156
482.394, 0.0909091
499.296, 0.123377
509.859, 0.136364
530.986, 0.116883
539.437, 0.12987
558.451, 0.149351
573.239, 0.142857
592.254, 0.116883
604.93, 0.0974026
619.718, 0.0909091
634.507, 0.103896
651.408, 0.136364
661.972, 0.142857
672.535, 0.11039
678.873, 0.11039
687.324, 0.175325
700, 0.253247
712.676, 0.298701
750.704, 0.357143
778.169, 0.37013
}

// #212 - L.C.T. Yellow Y1 (arc to 3200K)
#declare TS_L212 = spline{linear_spline
368.31, 0.207792
387.324, 0.266234
404.225, 0.311688
412.676, 0.37013
425.352, 0.422078
444.366, 0.435065
454.93, 0.487013
467.606, 0.538961
478.169, 0.597403
486.62, 0.655844
495.07, 0.714286
505.634, 0.772727
507.746, 0.785714
514.085, 0.811688
522.535, 0.831169
530.986, 0.837662
543.662, 0.88961
558.451, 0.88961
566.901, 0.902597
588.028, 0.88961
592.254, 0.922078
602.817, 0.928571
611.268, 0.928571
628.169, 0.896104
647.183, 0.922078
653.521, 0.902597
664.085, 0.896104
672.535, 0.915584
689.437, 0.922078
700, 0.928571
719.014, 0.922078
765.493, 0.909091
}

// #213 - White Flame Green (absorbs arc UV)
#declare TS_L213 = spline{linear_spline
368.531, 0.109677
391.608, 0.174194
404.196, 0.251613
412.587, 0.309677
420.979, 0.367742
425.175, 0.432258
429.371, 0.490323
431.469, 0.541935
437.762, 0.548387
456.643, 0.580645
469.231, 0.625806
477.622, 0.690323
486.014, 0.748387
492.308, 0.793548
500.699, 0.851613
517.483, 0.858065
523.776, 0.877419
534.266, 0.883871
551.049, 0.83871
559.441, 0.812903
567.832, 0.832258
578.322, 0.832258
584.615, 0.76129
588.811, 0.735484
601.399, 0.683871
618.182, 0.645161
626.573, 0.619355
637.063, 0.625806
645.455, 0.658065
655.944, 0.651613
664.336, 0.580645
670.629, 0.516129
679.021, 0.483871
683.217, 0.541935
687.413, 0.632258
693.706, 0.716129
704.196, 0.741935
727.273, 0.787097
760.839, 0.793548
}

// #218 - Eighth C.T. Blue (3200K to 3400K)
#declare TS_L218 = spline{linear_spline
374.648, 0.772727
391.549, 0.779221
404.225, 0.818182
419.014, 0.857143
431.69, 0.863636
440.141, 0.87013
459.155, 0.88961
476.056, 0.876623
484.507, 0.88961
501.408, 0.922078
516.197, 0.876623
528.873, 0.824675
545.775, 0.831169
562.676, 0.805195
583.803, 0.818182
596.479, 0.766234
609.155, 0.75974
628.169, 0.772727
647.183, 0.733766
659.859, 0.681818
668.31, 0.597403
678.873, 0.603896
687.324, 0.675325
695.775, 0.733766
706.338, 0.785714
731.69, 0.831169
767.606, 0.857143
}

// #219 - LEE Fluorescent Green
#declare TS_L219 = spline{linear_spline
368.31, 0.266234
389.437, 0.253247
404.225, 0.227273
423.239, 0.220779
442.254, 0.253247
454.93, 0.298701
463.38, 0.363636
473.944, 0.422078
482.394, 0.474026
488.732, 0.577922
497.183, 0.623377
505.634, 0.636364
509.859, 0.603896
514.085, 0.519481
524.648, 0.422078
537.324, 0.37013
545.775, 0.311688
556.338, 0.25974
569.014, 0.201299
583.803, 0.155844
592.254, 0.142857
609.155, 0.116883
626.056, 0.155844
630.282, 0.214286
642.958, 0.227273
653.521, 0.279221
668.31, 0.331169
678.873, 0.383117
685.211, 0.448052
687.324, 0.545455
700, 0.649351
731.69, 0.694805
778.169, 0.707792
}

// #223 - Eighth C.T. Orange (6500K to 5550K)
#declare TS_L223 = spline{linear_spline
370.629, 0.603896
389.51, 0.616883
404.196, 0.62987
423.077, 0.655844
441.958, 0.681818
458.741, 0.714286
462.937, 0.720779
492.308, 0.74026
511.189, 0.766234
527.972, 0.805195
542.657, 0.831169
561.538, 0.824675
595.105, 0.87013
609.79, 0.863636
630.769, 0.857143
647.552, 0.88961
668.531, 0.88961
676.923, 0.876623
689.51, 0.88961
700, 0.902597
725.175, 0.941558
754.545, 0.941558
}

// #226 - Lee U.V.
#declare TS_L226 = spline{linear_spline
370.423, 0.292208
387.324, 0.331169
400, 0.38961
408.451, 0.461039
412.676, 0.525974
421.127, 0.62987
429.577, 0.688312
433.803, 0.75974
440.141, 0.824675
459.155, 0.831169
478.169, 0.850649
495.07, 0.837662
514.085, 0.857143
530.986, 0.87013
545.775, 0.857143
558.451, 0.850649
564.789, 0.876623
592.254, 0.87013
607.042, 0.896104
628.169, 0.87013
638.732, 0.87013
647.183, 0.896104
666.197, 0.896104
672.535, 0.876623
685.211, 0.883117
700, 0.902597
721.127, 0.922078
748.592, 0.909091
778.169, 0.915584
}

// #230 - Super Correction L.C.T. Yellow
#declare TS_L230 = spline{linear_spline
370.423, 0.0844156
389.437, 0.0844156
404.225, 0.103896
423.239, 0.123377
438.028, 0.168831
450.704, 0.214286
467.606, 0.25974
484.507, 0.305195
488.732, 0.324675
499.296, 0.344156
530.986, 0.331169
543.662, 0.331169
550, 0.350649
558.451, 0.357143
571.127, 0.350649
585.915, 0.38961
600.704, 0.441558
609.155, 0.454545
630.282, 0.454545
649.296, 0.487013
668.31, 0.467532
680.986, 0.545455
700, 0.714286
716.901, 0.753247
738.028, 0.75974
}

// #232 - Super Correction W.F. Green to Tungsten (arc to 3200K)
#declare TS_L232 = spline{linear_spline
370.629, 0.0324675
387.413, 0.0324675
404.196, 0.0519481
423.077, 0.0779221
441.958, 0.11039
465.035, 0.12987
481.818, 0.168831
494.406, 0.220779
500.699, 0.246753
511.189, 0.253247
538.462, 0.272727
551.049, 0.324675
559.441, 0.344156
578.322, 0.376623
586.713, 0.454545
595.105, 0.5
601.399, 0.532468
609.79, 0.551948
632.867, 0.538961
647.552, 0.571429
660.14, 0.558442
664.336, 0.415584
672.727, 0.350649
679.021, 0.324675
687.413, 0.37013
689.51, 0.422078
695.804, 0.487013
700, 0.538961
710.49, 0.571429
741.958, 0.623377
}

// #236 - H.M.I. (to Tungsten)
#declare TS_L236 = spline{linear_spline
368.31, 0.104575
383.099, 0.0915033
404.225, 0.0980392
423.239, 0.111111
438.028, 0.156863
442.254, 0.196078
448.592, 0.215686
461.268, 0.254902
473.944, 0.30719
486.62, 0.379085
499.296, 0.431373
518.31, 0.431373
537.324, 0.444444
552.113, 0.496732
556.338, 0.535948
564.789, 0.542484
569.014, 0.54902
581.69, 0.601307
590.141, 0.686275
604.93, 0.771242
615.493, 0.830065
632.394, 0.862745
647.183, 0.875817
666.197, 0.882353
685.211, 0.895425
697.887, 0.915033
725.352, 0.915033
759.155, 0.915033
}

// #237 - C.I.D (to Tungsten)
#declare TS_L237 = spline{linear_spline
370.629, 0.0974026
385.315, 0.0844156
402.098, 0.0974026
429.371, 0.116883
448.252, 0.142857
465.035, 0.181818
479.72, 0.227273
488.112, 0.266234
498.601, 0.318182
504.895, 0.331169
515.385, 0.337662
534.266, 0.318182
540.559, 0.305195
553.147, 0.324675
565.734, 0.272727
572.028, 0.279221
578.322, 0.402597
588.811, 0.461039
595.105, 0.701299
603.497, 0.720779
609.79, 0.753247
620.28, 0.772727
634.965, 0.811688
641.259, 0.844156
660.14, 0.837662
672.727, 0.837662
679.021, 0.857143
691.608, 0.909091
704.196, 0.909091
729.371, 0.915584
767.133, 0.915584
}

// #238 - C.S.I. (to Tungsten)
#declare TS_L238 = spline{linear_spline
370.629, 0.136364
389.51, 0.142857
406.294, 0.181818
425.175, 0.207792
444.056, 0.220779
460.839, 0.266234
475.524, 0.305195
490.21, 0.357143
500.699, 0.448052
509.091, 0.461039
517.483, 0.448052
527.972, 0.396104
538.462, 0.337662
548.951, 0.279221
565.734, 0.246753
572.028, 0.181818
580.42, 0.168831
593.007, 0.357143
607.692, 0.5
613.986, 0.571429
624.476, 0.62987
634.965, 0.681818
643.357, 0.694805
660.14, 0.733766
674.825, 0.779221
683.217, 0.837662
700, 0.883117
731.469, 0.902597
777.622, 0.902597
}

// #239 - Polariser ****
#declare TS_L239 = spline{linear_spline
370.629, 0.292208
389.51, 0.305195
406.294, 0.337662
425.175, 0.363636
446.154, 0.376623
452.448, 0.383117
471.329, 0.415584
486.014, 0.454545
517.483, 0.474026
536.364, 0.506494
559.441, 0.525974
576.224, 0.493506
580.42, 0.487013
582.517, 0.532468
603.497, 0.545455
624.476, 0.519481
651.748, 0.506494
676.923, 0.512987
700, 0.519481
723.077, 0.519481
760.839, 0.506494
}

// #241 - LEE Fluorescent 5700K
#declare TS_L241 = spline{linear_spline
370.423, 0.253247
389.437, 0.25974
404.225, 0.279221
423.239, 0.311688
440.141, 0.344156
446.479, 0.350649
465.493, 0.383117
484.507, 0.493506
497.183, 0.5
511.972, 0.454545
520.423, 0.396104
533.099, 0.344156
547.887, 0.305195
560.563, 0.246753
571.127, 0.194805
579.577, 0.194805
585.915, 0.227273
592.254, 0.24026
602.817, 0.233766
617.606, 0.201299
623.944, 0.168831
636.62, 0.168831
653.521, 0.12987
670.423, 0.0909091
685.211, 0.12987
695.775, 0.194805
702.113, 0.227273
721.127, 0.25974
746.479, 0.279221
}

// #242 - LEE Fluorescent 4300K
#declare TS_L242 = spline{linear_spline
366.434, 0.253247
381.119, 0.253247
406.294, 0.272727
425.175, 0.292208
444.056, 0.318182
460.839, 0.363636
471.329, 0.415584
481.818, 0.525974
494.406, 0.584416
498.601, 0.623377
504.895, 0.636364
523.776, 0.623377
534.266, 0.564935
544.755, 0.506494
553.147, 0.454545
565.734, 0.396104
572.028, 0.350649
578.322, 0.350649
584.615, 0.383117
593.007, 0.383117
605.594, 0.331169
611.888, 0.292208
616.084, 0.253247
626.573, 0.246753
632.867, 0.24026
653.846, 0.24026
664.336, 0.181818
672.727, 0.123377
674.825, 0.103896
683.217, 0.149351
687.413, 0.220779
693.706, 0.285714
697.902, 0.344156
706.294, 0.454545
723.077, 0.5
769.231, 0.506494
}

// #243 - LEE Fluorescent 3600K
#declare TS_L243 = spline{linear_spline
368.31, 0.272727
391.549, 0.272727
404.225, 0.285714
425.352, 0.298701
444.366, 0.324675
459.155, 0.37013
473.944, 0.422078
488.732, 0.558442
490.845, 0.623377
505.634, 0.675325
520.423, 0.642857
524.648, 0.636364
539.437, 0.636364
543.662, 0.61039
545.775, 0.571429
554.225, 0.558442
575.352, 0.538961
590.141, 0.467532
596.479, 0.428571
600.704, 0.415584
611.268, 0.402597
615.493, 0.376623
619.718, 0.344156
626.056, 0.305195
634.507, 0.298701
653.521, 0.285714
664.085, 0.227273
666.197, 0.201299
672.535, 0.168831
680.986, 0.175325
685.211, 0.285714
689.437, 0.37013
695.775, 0.5
704.225, 0.525974
712.676, 0.558442
744.366, 0.577922
765.493, 0.590909
}

// #244 - LEE Plus Green
#declare TS_L244 = spline{linear_spline
370.423, 0.376623
385.211, 0.363636
406.338, 0.363636
410.563, 0.357143
423.239, 0.357143
427.465, 0.363636
442.254, 0.383117
446.479, 0.383117
450.704, 0.38961
454.93, 0.38961
467.606, 0.415584
482.394, 0.545455
486.62, 0.603896
492.958, 0.623377
495.07, 0.649351
499.296, 0.668831
503.521, 0.675325
509.859, 0.701299
524.648, 0.792208
526.761, 0.818182
528.873, 0.850649
533.099, 0.863636
539.437, 0.863636
545.775, 0.837662
556.338, 0.792208
560.563, 0.785714
569.014, 0.766234
573.239, 0.75974
583.803, 0.727273
602.817, 0.623377
615.493, 0.545455
619.718, 0.532468
630.282, 0.519481
632.394, 0.519481
645.07, 0.519481
651.408, 0.519481
666.197, 0.441558
672.535, 0.441558
676.761, 0.454545
685.211, 0.577922
695.775, 0.701299
700, 0.720779
725.352, 0.753247
778.169, 0.779221
}

// #245 - Half Plus Green
#declare TS_L245 = spline{linear_spline
372.34, 0.554953
387.234, 0.542206
404.255, 0.542576
425.532, 0.54304
448.936, 0.54355
459.574, 0.569925
476.596, 0.622584
485.106, 0.668521
495.745, 0.766792
500, 0.812636
508.511, 0.825893
525.532, 0.826264
529.787, 0.832893
538.298, 0.84615
546.809, 0.879015
551.064, 0.872572
555.319, 0.846521
565.957, 0.794465
568.085, 0.78144
572.34, 0.781532
582.979, 0.794836
595.745, 0.782042
602.128, 0.73643
627.66, 0.723914
642.553, 0.717703
648.936, 0.711306
653.191, 0.711399
659.574, 0.685394
661.702, 0.665832
672.34, 0.574561
676.596, 0.568118
680.851, 0.574746
685.106, 0.587911
695.745, 0.666574
697.872, 0.692764
700, 0.745098
717.021, 0.791221
753.191, 0.818152
}

// #246 - Quarter Plus Green
#declare TS_L246 = spline{linear_spline
364.085, 0.681818
380.986, 0.675325
404.225, 0.707792
408.451, 0.694805
412.676, 0.694805
421.127, 0.720779
429.577, 0.720779
438.028, 0.707792
446.479, 0.727273
450.704, 0.727273
454.93, 0.720779
457.042, 0.720779
463.38, 0.75974
471.831, 0.792208
480.282, 0.824675
484.507, 0.831169
488.732, 0.837662
497.183, 0.837662
501.408, 0.831169
503.521, 0.818182
514.085, 0.818182
518.31, 0.831169
522.535, 0.837662
539.437, 0.863636
547.887, 0.87013
573.239, 0.850649
583.803, 0.857143
596.479, 0.844156
604.93, 0.831169
617.606, 0.792208
621.831, 0.785714
630.282, 0.772727
645.07, 0.785714
649.296, 0.779221
657.746, 0.753247
672.535, 0.668831
676.761, 0.668831
691.549, 0.746753
700, 0.805195
723.239, 0.863636
776.056, 0.876623
}

// #247 - LEE Minus Green
#declare TS_L247 = spline{linear_spline
372.535, 0.707792
391.549, 0.688312
404.225, 0.694805
412.676, 0.688312
416.901, 0.681818
425.352, 0.675325
429.577, 0.668831
438.028, 0.662338
452.817, 0.662338
457.042, 0.668831
465.493, 0.681818
473.944, 0.701299
480.282, 0.707792
492.958, 0.720779
505.634, 0.707792
511.972, 0.616883
518.31, 0.564935
522.535, 0.525974
528.873, 0.506494
530.986, 0.506494
535.211, 0.5
541.549, 0.474026
550, 0.409091
556.338, 0.383117
564.789, 0.376623
566.901, 0.383117
594.366, 0.688312
600.704, 0.74026
607.042, 0.779221
615.493, 0.818182
623.944, 0.837662
628.169, 0.844156
630.282, 0.844156
653.521, 0.857143
668.31, 0.876623
674.648, 0.876623
689.437, 0.857143
700, 0.87013
714.789, 0.902597
767.606, 0.902597
}

// #248 - Half Minus Green
#declare TS_L248 = spline{linear_spline
370.423, 0.707792
387.324, 0.74026
404.225, 0.733766
408.451, 0.720779
419.014, 0.707792
429.577, 0.707792
438.028, 0.720779
446.479, 0.727273
450.704, 0.727273
452.817, 0.720779
459.155, 0.746753
467.606, 0.753247
471.831, 0.75974
482.394, 0.772727
486.62, 0.779221
495.07, 0.785714
505.634, 0.785714
511.972, 0.727273
522.535, 0.688312
526.761, 0.675325
530.986, 0.675325
535.211, 0.668831
541.549, 0.668831
550, 0.636364
556.338, 0.597403
564.789, 0.571429
573.239, 0.564935
575.352, 0.571429
579.577, 0.649351
594.366, 0.785714
598.592, 0.837662
607.042, 0.850649
611.268, 0.857143
615.493, 0.87013
619.718, 0.896104
623.944, 0.896104
628.169, 0.896104
636.62, 0.87013
645.07, 0.909091
649.296, 0.909091
653.521, 0.915584
661.972, 0.915584
666.197, 0.902597
670.423, 0.896104
678.873, 0.876623
683.099, 0.876623
691.549, 0.896104
695.775, 0.902597
700, 0.909091
727.465, 0.928571
769.718, 0.915584
}

// #249 - Quarter Minus Green
#declare TS_L249 = spline{linear_spline
376.761, 0.792208
389.437, 0.811688
400, 0.818182
406.338, 0.824675
414.789, 0.818182
421.127, 0.805195
429.577, 0.805195
433.803, 0.824675
438.028, 0.837662
446.479, 0.837662
448.592, 0.831169
452.817, 0.837662
461.268, 0.87013
465.493, 0.87013
473.944, 0.850649
482.394, 0.844156
486.62, 0.844156
495.07, 0.857143
505.634, 0.844156
511.972, 0.837662
526.761, 0.746753
533.099, 0.727273
537.324, 0.720779
541.549, 0.720779
545.775, 0.727273
550, 0.746753
554.225, 0.74026
560.563, 0.714286
564.789, 0.688312
569.014, 0.675325
573.239, 0.688312
585.915, 0.779221
592.254, 0.850649
596.479, 0.863636
604.93, 0.863636
609.155, 0.863636
619.718, 0.88961
623.944, 0.902597
630.282, 0.902597
634.507, 0.896104
640.845, 0.88961
649.296, 0.88961
653.521, 0.88961
657.746, 0.896104
668.31, 0.909091
676.761, 0.915584
689.437, 0.915584
693.662, 0.909091
700, 0.902597
733.803, 0.863636
782.394, 0.766234
}

// #278 - Eighth Plus Green
#declare TS_L278 = spline{linear_spline
370.213, 0.72
389.362, 0.72
404.255, 0.726667
408.511, 0.726667
419.149, 0.746667
427.66, 0.773333
436.17, 0.78
442.553, 0.78
446.809, 0.773333
453.191, 0.773333
461.702, 0.806667
468.085, 0.806667
478.723, 0.806667
495.745, 0.86
504.255, 0.86
510.638, 0.84
525.532, 0.84
548.936, 0.86
559.574, 0.866667
570.213, 0.853333
587.234, 0.84
604.255, 0.833333
642.553, 0.833333
646.809, 0.826667
663.83, 0.8
668.085, 0.786667
676.596, 0.78
685.106, 0.786667
695.745, 0.813333
700, 0.833333
725.532, 0.866667
768.085, 0.86
780.851, 0.78
}

// #279 - Eighth Minus Green
#declare TS_L279 = spline{linear_spline
370.423, 0.862745
385.211, 0.875817
404.225, 0.875817
408.451, 0.875817
412.676, 0.882353
419.014, 0.882353
423.239, 0.849673
431.69, 0.843137
438.028, 0.843137
448.592, 0.869281
450.704, 0.875817
452.817, 0.869281
457.042, 0.875817
463.38, 0.882353
473.944, 0.875817
478.169, 0.875817
486.62, 0.856209
499.296, 0.843137
503.521, 0.843137
514.085, 0.869281
518.31, 0.875817
524.648, 0.875817
528.873, 0.875817
537.324, 0.816993
543.662, 0.79085
552.113, 0.764706
560.563, 0.75817
564.789, 0.764706
569.014, 0.784314
577.465, 0.856209
590.141, 0.862745
596.479, 0.862745
604.93, 0.882353
609.155, 0.888889
617.606, 0.908497
619.718, 0.908497
638.732, 0.888889
659.859, 0.888889
664.085, 0.895425
670.423, 0.901961
676.761, 0.908497
685.211, 0.888889
704.225, 0.888889
733.803, 0.882353
757.042, 0.882353
}

// #281 - Three Quarter C.T. Blue
#declare TS_L281 = spline{linear_spline
368.31, 0.58373
385.211, 0.61007
404.225, 0.629962
408.451, 0.630053
423.239, 0.656347
429.577, 0.669471
438.028, 0.75407
444.366, 0.786675
448.592, 0.799753
454.93, 0.793397
461.268, 0.774053
465.493, 0.735184
467.606, 0.722243
473.944, 0.72238
480.282, 0.748491
484.507, 0.742089
488.732, 0.696726
495.07, 0.696863
503.521, 0.677565
507.746, 0.671163
511.972, 0.658268
518.31, 0.638924
524.648, 0.600101
526.761, 0.548198
530.986, 0.541796
537.324, 0.509466
539.437, 0.490031
547.887, 0.425279
554.225, 0.379962
558.451, 0.367066
562.676, 0.360664
564.789, 0.341229
571.127, 0.308899
577.465, 0.309036
592.254, 0.361304
596.479, 0.354902
600.704, 0.3485
604.93, 0.335605
609.155, 0.329202
615.493, 0.309859
619.718, 0.303457
623.944, 0.297055
634.507, 0.297284
638.732, 0.303869
649.296, 0.317084
657.746, 0.317267
666.197, 0.284983
672.535, 0.28512
680.986, 0.343744
697.887, 0.441513
700, 0.461039
716.901, 0.500366
750.704, 0.520578
780.282, 0.521218
}

// #285 - Three Quarter C.T. Orange
#declare TS_L285 = spline{linear_spline
366.197, 0.111111
387.324, 0.169935
406.338, 0.20915
423.239, 0.235294
433.803, 0.248366
442.254, 0.254902
446.479, 0.261438
454.93, 0.261438
459.155, 0.267974
463.38, 0.27451
471.831, 0.30719
484.507, 0.392157
490.845, 0.405229
495.07, 0.418301
503.521, 0.424837
505.634, 0.437908
509.859, 0.444444
522.535, 0.496732
528.873, 0.51634
533.099, 0.51634
537.324, 0.509804
541.549, 0.51634
554.225, 0.568627
566.901, 0.627451
569.014, 0.69281
575.352, 0.732026
588.028, 0.784314
592.254, 0.803922
598.592, 0.849673
613.38, 0.869281
621.831, 0.901961
630.282, 0.934641
642.958, 0.869281
647.183, 0.862745
651.408, 0.875817
653.521, 0.875817
657.746, 0.895425
661.972, 0.901961
666.197, 0.908497
674.648, 0.908497
678.873, 0.901961
685.211, 0.869281
689.437, 0.862745
700, 0.888889
725.352, 0.921569
782.394, 0.915033
}

// #298 - 0.15ND (minus half stop)
#declare TS_L298 = spline{linear_spline
368.31, 0.558442
387.324, 0.590909
406.338, 0.616883
414.789, 0.623377
454.93, 0.623377
473.944, 0.61039
482.394, 0.603896
499.296, 0.623377
511.972, 0.636364
520.423, 0.649351
528.873, 0.662338
537.324, 0.668831
545.775, 0.655844
550, 0.655844
554.225, 0.649351
569.014, 0.649351
573.239, 0.655844
596.479, 0.655844
598.592, 0.649351
607.042, 0.642857
623.944, 0.649351
638.732, 0.655844
647.183, 0.655844
651.408, 0.655844
661.972, 0.62987
672.535, 0.584416
676.761, 0.564935
680.986, 0.564935
689.437, 0.597403
693.662, 0.642857
700, 0.662338
708.451, 0.675325
725.352, 0.707792
765.493, 0.707792
}

// #299 - 1.2ND (minus 4 stops)
#declare TS_L299 = spline{linear_spline
370.423, 0.0445252
389.437, 0.0578373
404.225, 0.0581554
425.352, 0.0586097
450.704, 0.0591549
463.38, 0.0400727
480.282, 0.059791
501.408, 0.0796002
530.986, 0.0802363
545.775, 0.0547478
564.789, 0.0551567
583.803, 0.0297592
607.042, 0.030259
626.056, 0.0435711
638.732, 0.0631985
647.183, 0.0633803
657.746, 0.037801
672.535, 0.0316674
683.099, 0.0318946
691.549, 0.0643344
700, 0.16129
714.789, 0.219673
744.366, 0.271922
773.944, 0.272558
}

// #322 - Soft Green
#declare TS_L322 = spline{linear_spline
370.423, 0.196078
389.437, 0.20915
406.338, 0.235294
410.563, 0.24183
421.127, 0.27451
425.352, 0.281046
435.915, 0.320261
444.366, 0.366013
457.042, 0.411765
459.155, 0.424837
469.718, 0.477124
471.831, 0.503268
478.169, 0.594771
486.62, 0.673203
495.07, 0.72549
505.634, 0.745098
511.972, 0.718954
524.648, 0.620915
539.437, 0.509804
550, 0.444444
552.113, 0.431373
558.451, 0.30719
564.789, 0.261438
571.127, 0.189542
577.465, 0.143791
590.141, 0.0718954
592.254, 0.0588235
598.592, 0.0326797
607.042, 0.0261438
613.38, 0.0261438
626.056, 0.0392157
642.958, 0.0392157
647.183, 0.0326797
653.521, 0.0196078
657.746, 0.0326797
661.972, 0.0392157
672.535, 0.0849673
680.986, 0.143791
700, 0.261438
721.127, 0.352941
761.268, 0.418301
}

// #323 - Jade
#declare TS_L323 = spline{linear_spline
368.531, 0.141935
385.315, 0.16129
406.294, 0.174194
414.685, 0.174194
416.783, 0.180645
420.979, 0.174194
425.175, 0.174194
429.371, 0.167742
437.762, 0.180645
448.252, 0.212903
456.643, 0.270968
467.133, 0.296774
473.427, 0.348387
488.112, 0.606452
494.406, 0.670968
500.699, 0.722581
509.091, 0.76129
511.189, 0.767742
517.483, 0.729032
525.874, 0.696774
534.266, 0.658065
536.364, 0.63871
553.147, 0.36129
563.636, 0.296774
569.93, 0.180645
578.322, 0.122581
586.713, 0.0774194
603.497, 0.0129032
605.594, 0.0129032
609.79, 0
626.573, 0.00645161
634.965, 0.0322581
645.455, 0.0258065
653.846, 0.0193548
660.14, 0.0193548
664.336, 0.0258065
670.629, 0.0258065
674.825, 0.0322581
679.021, 0.0322581
685.315, 0.0580645
700, 0.167742
710.49, 0.23871
765.035, 0.309677
}

// #325 - Mallard Green
#declare TS_L325 = spline{linear_spline
383.099, 0.0261438
389.437, 0.0326797
402.113, 0.0326797
412.676, 0.0261438
423.239, 0
440.141, 0
446.479, 0.0130719
452.817, 0.0130719
463.38, 0.0326797
473.944, 0.0849673
476.056, 0.0980392
484.507, 0.20915
492.958, 0.313725
499.296, 0.346405
503.521, 0.352941
507.746, 0.359477
514.085, 0.346405
518.31, 0.30719
520.423, 0.267974
524.648, 0.169935
539.437, 0.117647
552.113, 0.0784314
556.338, 0.0718954
566.901, 0.0392157
571.127, 0.0130719
592.254, 0
613.38, 0
638.732, 0
647.183, 0.0196078
651.408, 0.0261438
661.972, 0.0392157
668.31, 0.0392157
672.535, 0.0457516
676.761, 0.0522876
689.437, 0.0915033
697.887, 0.124183
700, 0.130719
721.127, 0.189542
778.169, 0.222222
}

// #327 - Forest Green
#declare TS_L327 = spline{linear_spline
366.197, 0.025974
387.324, 0.025974
406.338, 0.0519481
412.676, 0.0519481
416.901, 0.0584416
427.465, 0.0584416
431.69, 0.0649351
440.141, 0.0649351
444.366, 0.0714286
459.155, 0.0714286
467.606, 0.0844156
480.282, 0.103896
492.958, 0.142857
499.296, 0.168831
511.972, 0.168831
526.761, 0.142857
543.662, 0.0844156
547.887, 0.0779221
564.789, 0.0519481
607.042, 0
628.169, 0
651.408, 0
655.634, 0.00649351
659.859, 0.00649351
664.085, 0.012987
672.535, 0.025974
680.986, 0.0324675
700, 0.0649351
731.69, 0.11039
776.056, 0.149351
}

// #328 - Follies Pink
#declare TS_L328 = spline{linear_spline
364.085, 0.435065
380.986, 0.467532
404.225, 0.493506
408.451, 0.493506
429.577, 0.525974
440.141, 0.525974
450.704, 0.5
465.493, 0.454545
469.718, 0.409091
471.831, 0.357143
478.169, 0.305195
486.62, 0.246753
497.183, 0.188312
499.296, 0.155844
514.085, 0.0844156
522.535, 0.0324675
526.761, 0.025974
533.099, 0.012987
537.324, 0
564.789, 0
571.127, 0.012987
594.366, 0.38961
596.479, 0.564935
600.704, 0.655844
611.268, 0.753247
613.38, 0.772727
623.944, 0.818182
632.394, 0.837662
642.958, 0.850649
649.296, 0.850649
653.521, 0.837662
659.859, 0.844156
666.197, 0.876623
670.423, 0.876623
697.887, 0.863636
727.465, 0.863636
769.718, 0.805195
}

// #332 - Special Rose Pink
#declare TS_L332 = spline{linear_spline
370.423, 0.136364
385.211, 0.168831
402.113, 0.181818
421.127, 0.214286
431.69, 0.227273
442.254, 0.227273
448.592, 0.214286
467.606, 0.136364
482.394, 0.0584416
495.07, 0.0194805
499.296, 0
520.423, 0
541.549, 0
575.352, 0
579.577, 0.012987
590.141, 0.0714286
598.592, 0.175325
604.93, 0.5
613.38, 0.532468
617.606, 0.733766
632.394, 0.831169
634.507, 0.844156
638.732, 0.850649
647.183, 0.87013
655.634, 0.87013
659.859, 0.863636
668.31, 0.863636
678.873, 0.88961
685.211, 0.896104
691.549, 0.909091
706.338, 0.88961
750.704, 0.863636
773.944, 0.837662
}

// #341 - Plum
#declare TS_L341 = spline{linear_spline
368.31, 0.162338
385.211, 0.227273
404.225, 0.272727
419.014, 0.298701
423.239, 0.311688
435.915, 0.311688
446.479, 0.279221
454.93, 0.292208
469.718, 0.337662
476.056, 0.344156
480.282, 0.350649
482.394, 0.363636
486.62, 0.357143
495.07, 0.331169
501.408, 0.279221
509.859, 0.25974
520.423, 0.214286
530.986, 0.162338
533.099, 0.149351
537.324, 0.11039
552.113, 0.0974026
569.014, 0.12987
577.465, 0.181818
585.915, 0.246753
594.366, 0.272727
600.704, 0.292208
604.93, 0.298701
609.155, 0.292208
613.38, 0.279221
619.718, 0.279221
634.507, 0.357143
642.958, 0.435065
653.521, 0.474026
659.859, 0.519481
661.972, 0.538961
672.535, 0.636364
678.873, 0.714286
680.986, 0.772727
685.211, 0.857143
695.775, 0.902597
700, 0.909091
729.577, 0.922078
771.831, 0.909091
}

// #343 - Special Medium Lavender
#declare TS_L343 = spline{linear_spline
370.629, 0.207792
387.413, 0.24026
404.196, 0.292208
416.783, 0.331169
429.371, 0.409091
435.664, 0.461039
444.056, 0.506494
448.252, 0.512987
450.35, 0.519481
458.741, 0.5
471.329, 0.409091
475.524, 0.396104
477.622, 0.331169
479.72, 0.246753
498.601, 0.142857
502.797, 0.0974026
515.385, 0.0584416
523.776, 0.025974
534.266, 0
555.245, 0
576.224, 0
601.399, 0
603.497, 0
607.692, 0
632.867, 0.00649351
641.259, 0.0974026
651.748, 0.155844
662.238, 0.227273
666.434, 0.246753
672.727, 0.532468
676.923, 0.603896
683.217, 0.733766
697.902, 0.831169
700, 0.837662
}

// #344 - Violet
#declare TS_L344 = spline{linear_spline
370.629, 0.531832
385.315, 0.558124
406.294, 0.584552
414.685, 0.584733
423.077, 0.610889
429.371, 0.636999
433.566, 0.630597
437.762, 0.604713
454.545, 0.605077
458.741, 0.624648
462.937, 0.618245
477.622, 0.573109
481.818, 0.566706
488.112, 0.547362
498.601, 0.495641
500.699, 0.411271
502.797, 0.398329
506.993, 0.320498
517.483, 0.262283
527.972, 0.204069
536.364, 0.171783
540.559, 0.100445
544.755, 0.0745618
559.441, 0.00345109
563.636, 0.00354191
576.224, 0.0362819
590.909, 0.0495868
603.497, 0.0888203
609.79, 0.134411
622.378, 0.23858
628.671, 0.290664
641.259, 0.349378
643.357, 0.36241
651.748, 0.421034
660.14, 0.479657
668.531, 0.544773
679.021, 0.616429
685.315, 0.6815
697.902, 0.798656
700, 0.805195
720.979, 0.86409
762.937, 0.884479
781.818, 0.878394
}

// #345 - Fuchsia Pink
#declare TS_L345 = spline{linear_spline
366.197, 0.38961
380.986, 0.461039
404.225, 0.493506
412.676, 0.519481
429.577, 0.545455
438.028, 0.564935
446.479, 0.603896
459.155, 0.525974
465.493, 0.474026
482.394, 0.38961
492.958, 0.298701
507.746, 0.24026
518.31, 0.162338
524.648, 0.142857
541.549, 0.0779221
545.775, 0.0714286
550, 0.0779221
554.225, 0.0844156
560.563, 0.0974026
575.352, 0.168831
577.465, 0.181818
579.577, 0.201299
588.028, 0.246753
600.704, 0.285714
604.93, 0.292208
628.169, 0.272727
642.958, 0.298701
653.521, 0.298701
657.746, 0.285714
661.972, 0.253247
668.31, 0.194805
676.761, 0.162338
680.986, 0.168831
689.437, 0.207792
700, 0.285714
714.789, 0.350649
754.93, 0.38961
}

// #352 - Glacier Blue
#declare TS_L352 = spline{linear_spline
370.629, 0.376623
387.413, 0.422078
406.294, 0.480519
412.587, 0.597403
416.783, 0.62987
420.979, 0.675325
423.077, 0.688312
431.469, 0.701299
437.762, 0.727273
446.154, 0.772727
450.35, 0.772727
454.545, 0.746753
462.937, 0.74026
469.231, 0.74026
475.524, 0.714286
477.622, 0.701299
483.916, 0.62987
490.21, 0.597403
502.797, 0.551948
506.993, 0.525974
513.287, 0.493506
517.483, 0.435065
523.776, 0.396104
530.07, 0.376623
536.364, 0.305195
544.755, 0.227273
553.147, 0.194805
561.538, 0.162338
569.93, 0.0909091
574.126, 0.0779221
582.517, 0.0714286
590.909, 0.0714286
601.399, 0.038961
603.497, 0.025974
607.692, 0.0194805
613.986, 0
620.28, 0
624.476, 0.012987
628.671, 0.0194805
634.965, 0.0454545
639.161, 0.0649351
643.357, 0.103896
647.552, 0.116883
674.825, 0.136364
683.217, 0.194805
695.804, 0.285714
700, 0.318182
710.49, 0.37013
741.958, 0.428571
762.937, 0.461039
}

// #353 - Lighter Blue
#declare TS_L353 = spline{linear_spline
3, 95
9, 90
18, 83
22, 74
28, 63
29, 54
31, 52
35, 49
37, 49
39, 48
42, 44
44, 44
48, 47
52, 47
60, 44
65, 53
69, 59
73, 63
77, 70
80, 83
82, 88
89, 101
94, 109
100, 134
106, 145
110, 150
114, 154
117, 157
121, 158
123, 157
126, 153
131, 151
132, 151
135, 151
137, 151
139, 152
144, 154
149, 149
156, 135
158, 129
165, 115
181, 105
197, 103
}

// #354 - Special Steel Blue
#declare TS_L354 = spline{linear_spline
370.213, 0.30719
387.234, 0.326797
397.872, 0.359477
408.511, 0.392157
412.766, 0.457516
425.532, 0.529412
431.915, 0.555556
438.298, 0.647059
451.064, 0.686275
455.319, 0.699346
459.574, 0.699346
470.213, 0.72549
474.468, 0.732026
491.489, 0.738562
500, 0.764706
504.255, 0.764706
514.894, 0.718954
525.532, 0.660131
531.915, 0.640523
536.17, 0.633987
546.809, 0.575163
551.064, 0.470588
553.191, 0.424837
555.319, 0.424837
563.83, 0.385621
572.34, 0.320261
578.723, 0.248366
582.979, 0.156863
587.234, 0.0784314
593.617, 0.0326797
608.511, 0.0196078
617.021, 0.0196078
621.277, 0.0261438
625.532, 0.0261438
629.787, 0.0326797
631.915, 0.0326797
636.17, 0.0392157
642.553, 0.0392157
646.809, 0.0457516
651.064, 0.0457516
655.319, 0.0392157
670.213, 0.0196078
676.596, 0.0130719
682.979, 0.0130719
687.234, 0.0196078
697.872, 0.0392157
700, 0.0457516
727.66, 0.0849673
751.064, 0.104575
}

// #363 - Special Medium Blue
#declare TS_L363 = spline{linear_spline
372.535, 0.124183
397.887, 0.176471
408.451, 0.222222
412.676, 0.287582
421.127, 0.379085
425.352, 0.45098
429.577, 0.490196
435.915, 0.51634
440.141, 0.529412
444.366, 0.529412
446.479, 0.535948
454.93, 0.503268
463.38, 0.444444
473.944, 0.366013
482.394, 0.202614
490.845, 0.156863
514.085, 0.0588235
524.648, 0.0261438
533.099, 0.0130719
537.324, 0
558.451, 0
579.577, 0
600.704, 0
621.831, 0
642.958, 0
672.535, 0
676.761, 0.0130719
685.211, 0.0718954
695.775, 0.137255
700, 0.169935
729.577, 0.254902
765.493, 0.300654
}

// #366 - Cornflower
#declare TS_L366 = spline{linear_spline
371.997, 0.254902
393.041, 0.294118
403.521, 0.333333
405.634, 0.333333
416.045, 0.405229
420.215, 0.431373
428.597, 0.464052
432.781, 0.48366
436.979, 0.496732
445.402, 0.509804
449.6, 0.522876
451.712, 0.522876
453.797, 0.535948
462.234, 0.542484
468.572, 0.542484
477.051, 0.529412
487.655, 0.509804
500.414, 0.470588
508.989, 0.411765
519.677, 0.352941
534.687, 0.248366
543.344, 0.150327
562.51, 0.0784314
568.931, 0.0392157
573.184, 0.0261438
579.536, 0.0196078
583.761, 0.0196078
592.143, 0.0522876
600.497, 0.0980392
604.709, 0.104575
608.934, 0.104575
619.553, 0.0784314
623.806, 0.0653595
628.045, 0.0588235
632.27, 0.0588235
636.468, 0.0718954
642.709, 0.117647
646.866, 0.150327
651.036, 0.176471
661.378, 0.281046
671.9, 0.300654
676.139, 0.294118
686.703, 0.294118
697.017, 0.411765
701.174, 0.444444
717.965, 0.496732
745.347, 0.535948
}

// #441 - Full C.T. Straw (6500K to 3200K)
#declare TS_L441 = spline{linear_spline
365.714, 0.197368
389.286, 0.171053
404.286, 0.144737
412.857, 0.118421
415, 0.105263
419.286, 0.0986842
427.857, 0.0789474
432.143, 0.0789474
436.429, 0.0723684
445, 0.0789474
449.286, 0.0921053
453.571, 0.0986842
462.143, 0.138158
470.714, 0.223684
477.143, 0.342105
483.571, 0.407895
490, 0.440789
494.286, 0.453947
500.714, 0.453947
502.857, 0.440789
507.143, 0.440789
511.429, 0.434211
520, 0.427632
537.143, 0.427632
545.714, 0.480263
560.714, 0.493421
569.286, 0.513158
573.571, 0.611842
582.143, 0.671053
586.429, 0.730263
588.571, 0.802632
592.857, 0.848684
599.286, 0.861842
603.571, 0.868421
612.143, 0.868421
616.429, 0.855263
620.714, 0.848684
625, 0.842105
631.429, 0.842105
642.143, 0.881579
644.286, 0.894737
652.857, 0.901316
661.429, 0.901316
665.714, 0.894737
670, 0.888158
674.286, 0.875
682.857, 0.875
693.571, 0.901316
697.857, 0.907895
700, 0.914474
730, 0.927632
764.286, 0.907895
}

// #442 - Half C.T. Straw (6500K to 4300K)
#declare TS_L442 = spline{linear_spline
372.727, 0.428571
387.413, 0.415584
406.294, 0.383117
429.371, 0.311688
435.664, 0.279221
444.056, 0.272727
450.35, 0.292208
452.448, 0.292208
456.643, 0.318182
458.741, 0.331169
471.329, 0.435065
475.524, 0.545455
481.818, 0.603896
488.112, 0.636364
492.308, 0.642857
500.699, 0.655844
506.993, 0.655844
511.189, 0.649351
521.678, 0.636364
530.07, 0.636364
534.266, 0.642857
538.462, 0.649351
548.951, 0.681818
557.343, 0.681818
561.538, 0.668831
565.734, 0.668831
572.028, 0.694805
574.126, 0.714286
580.42, 0.785714
584.615, 0.831169
590.909, 0.863636
599.301, 0.850649
603.497, 0.837662
611.888, 0.837662
618.182, 0.850649
626.573, 0.88961
632.867, 0.88961
643.357, 0.87013
651.748, 0.857143
658.042, 0.857143
668.531, 0.883117
676.923, 0.922078
683.217, 0.948052
700, 0.948052
746.154, 0.935065
773.427, 0.915584
}

// #443 - Quarter C.T. Straw (6500K to 5100K)
#declare TS_L443 = spline{linear_spline
366.197, 0.623377
389.437, 0.623377
406.338, 0.577922
414.789, 0.538961
429.577, 0.5
438.028, 0.487013
448.592, 0.512987
459.155, 0.558442
461.268, 0.571429
463.38, 0.597403
469.718, 0.649351
473.944, 0.668831
480.282, 0.727273
484.507, 0.74026
488.732, 0.746753
497.183, 0.75974
501.408, 0.75974
503.521, 0.746753
507.746, 0.746753
514.085, 0.746753
524.648, 0.746753
528.873, 0.753247
543.662, 0.753247
547.887, 0.746753
554.225, 0.746753
558.451, 0.753247
571.127, 0.792208
575.352, 0.811688
577.465, 0.811688
579.577, 0.824675
583.803, 0.831169
588.028, 0.837662
592.254, 0.844156
596.479, 0.844156
600.704, 0.850649
615.493, 0.87013
634.507, 0.857143
649.296, 0.857143
659.859, 0.876623
674.648, 0.902597
678.873, 0.909091
685.211, 0.909091
689.437, 0.896104
721.127, 0.857143
767.606, 0.837662
}

// #444 - Eighth C.T. Straw (6500K to 5700K)
#declare TS_L444 = spline{linear_spline
368.531, 0.668831
383.217, 0.688312
406.294, 0.707792
414.685, 0.714286
418.881, 0.688312
423.077, 0.662338
433.566, 0.662338
439.86, 0.681818
448.252, 0.694805
452.448, 0.681818
456.643, 0.688312
462.937, 0.733766
467.133, 0.772727
471.329, 0.792208
479.72, 0.798701
483.916, 0.798701
488.112, 0.824675
490.21, 0.844156
494.406, 0.850649
498.601, 0.844156
504.895, 0.824675
513.287, 0.818182
523.776, 0.818182
527.972, 0.824675
536.364, 0.831169
540.559, 0.824675
544.755, 0.818182
551.049, 0.818182
555.245, 0.824675
559.441, 0.824675
569.93, 0.850649
574.126, 0.857143
578.322, 0.87013
584.615, 0.87013
593.007, 0.850649
597.203, 0.857143
605.594, 0.863636
609.79, 0.87013
618.182, 0.876623
645.455, 0.88961
668.531, 0.909091
672.727, 0.909091
681.119, 0.922078
691.608, 0.935065
700, 0.941558
723.077, 0.948052
760.839, 0.948052
}

// #700 - Perfect Lavender
#declare TS_L700 = spline{linear_spline
376.259, 0.2
389.209, 0.233333
400, 0.28
412.95, 0.34
425.899, 0.433333
436.691, 0.506667
443.165, 0.533333
456.115, 0.52
466.906, 0.446667
479.856, 0.326667
492.806, 0.226667
503.597, 0.12
516.547, 0.0533333
535.971, 0.0133333
551.079, 0
576.978, 0
596.403, 0.02
609.353, 0.0266667
624.46, 0.0133333
635.252, 0.0333333
646.043, 0.06
652.518, 0.22
661.151, 0.393333
667.626, 0.56
676.259, 0.693333
684.892, 0.793333
691.367, 0.846667
702.158, 0.88
728.058, 0.913333
760.432, 0.92
}

// #701 - Provence
#declare TS_L701 = spline{linear_spline
382.09, 0.451389
388.806, 0.472222
400, 0.493056
411.194, 0.534722
420.149, 0.576389
424.627, 0.625
435.821, 0.666667
444.776, 0.673611
455.97, 0.652778
462.687, 0.576389
473.881, 0.5
478.358, 0.465278
482.836, 0.402778
491.791, 0.305556
500.746, 0.194444
505.224, 0.152778
511.94, 0.104167
532.09, 0.0486111
545.522, 0.0208333
558.955, 0.00694444
572.388, 0.00694444
588.06, 0.0416667
597.015, 0.0972222
608.209, 0.104167
621.642, 0.0833333
630.597, 0.0763889
639.552, 0.125
648.507, 0.25
657.463, 0.451389
666.418, 0.611111
668.657, 0.729167
677.612, 0.826389
693.284, 0.888889
702.239, 0.923611
729.104, 0.951389
758.209, 0.958333
}

// #702 - Special Pale Lavender
#declare TS_L702 = spline{linear_spline
350, 0.626761
381.818, 0.661972
404.545, 0.711268
415.909, 0.746479
420.455, 0.753521
431.818, 0.774648
443.182, 0.802817
447.727, 0.802817
450, 0.795775
454.545, 0.795775
463.636, 0.802817
468.182, 0.802817
475, 0.78169
479.545, 0.774648
484.091, 0.760563
490.909, 0.760563
500, 0.71831
504.545, 0.697183
513.636, 0.647887
518.182, 0.640845
522.727, 0.626761
531.818, 0.56338
543.182, 0.5
552.273, 0.471831
563.636, 0.457746
565.909, 0.457746
570.455, 0.450704
575, 0.450704
586.364, 0.485915
588.636, 0.5
600, 0.56338
609.091, 0.570423
620.455, 0.521127
629.545, 0.514085
636.364, 0.542254
640.909, 0.577465
652.273, 0.746479
659.091, 0.788732
668.182, 0.830986
677.273, 0.838028
688.636, 0.866197
697.727, 0.894366
700, 0.894366
722.727, 0.93662
756.818, 0.943662
}

// #703 - Cold Lavender
#declare TS_L703 = spline{linear_spline
371.942, 0.413333
389.209, 0.453333
400, 0.493333
410.791, 0.56
419.424, 0.573333
430.216, 0.58
438.849, 0.6
445.324, 0.606667
451.799, 0.58
458.273, 0.56
466.906, 0.54
482.014, 0.453333
488.489, 0.406667
494.964, 0.346667
505.755, 0.28
516.547, 0.2
520.863, 0.173333
531.655, 0.16
538.129, 0.146667
551.079, 0.08
559.712, 0.0666667
572.662, 0.106667
581.295, 0.2
589.928, 0.266667
596.403, 0.313333
602.878, 0.32
607.194, 0.306667
615.827, 0.293333
628.777, 0.293333
635.252, 0.306667
648.201, 0.3
654.676, 0.286667
658.993, 0.26
667.626, 0.22
671.942, 0.2
678.417, 0.213333
687.05, 0.273333
695.683, 0.36
704.317, 0.406667
721.583, 0.453333
769.065, 0.5
}

// #704 - Lily
#declare TS_L704 = spline{linear_spline
340.909, 0.601399
377.273, 0.664336
404.545, 0.741259
415.909, 0.776224
420.455, 0.783217
429.545, 0.804196
436.364, 0.825175
456.818, 0.825175
465.909, 0.804196
475, 0.769231
486.364, 0.72028
500, 0.643357
504.545, 0.608392
511.364, 0.538462
518.182, 0.475524
525, 0.440559
529.545, 0.41958
552.273, 0.237762
559.091, 0.195804
565.909, 0.195804
572.727, 0.223776
575, 0.237762
595.455, 0.482517
604.545, 0.51049
609.091, 0.503497
622.727, 0.461538
629.545, 0.461538
636.364, 0.48951
650, 0.643357
656.818, 0.72028
665.909, 0.825175
670.455, 0.867133
677.273, 0.888112
681.818, 0.902098
700, 0.902098
736.364, 0.916084
777.273, 0.895105
}

// #705 - Lily Frost ****
#declare TS_L705 = spline{linear_spline
370.423, 0.642857
389.437, 0.694805
406.338, 0.733766
419.014, 0.772727
423.239, 0.779221
429.577, 0.798701
433.803, 0.805195
438.028, 0.818182
446.479, 0.824675
450.704, 0.824675
452.817, 0.818182
457.042, 0.811688
467.606, 0.785714
482.394, 0.727273
490.845, 0.668831
505.634, 0.584416
518.31, 0.467532
520.423, 0.448052
530.986, 0.38961
543.662, 0.311688
547.887, 0.272727
552.113, 0.227273
556.338, 0.181818
562.676, 0.162338
575.352, 0.214286
585.915, 0.344156
594.366, 0.409091
598.592, 0.441558
604.93, 0.474026
609.155, 0.474026
617.606, 0.448052
621.831, 0.428571
623.944, 0.428571
628.169, 0.422078
634.507, 0.435065
642.958, 0.519481
651.408, 0.681818
661.972, 0.785714
668.31, 0.844156
674.648, 0.863636
680.986, 0.883117
687.324, 0.88961
702.113, 0.902597
731.69, 0.915584
769.718, 0.915584
}

// #706 - King Fals Lavender
#declare TS_L706 = spline{linear_spline
364.085, 0.214286
383.099, 0.253247
404.225, 0.305195
412.676, 0.37013
419.014, 0.396104
423.239, 0.409091
427.465, 0.422078
438.028, 0.448052
444.366, 0.454545
448.592, 0.454545
461.268, 0.409091
469.718, 0.37013
478.169, 0.305195
484.507, 0.25974
486.62, 0.246753
499.296, 0.155844
514.085, 0.0649351
522.535, 0.0454545
528.873, 0.038961
556.338, 0.00649351
571.127, 0
575.352, 0.012987
579.577, 0.0194805
583.803, 0.0324675
588.028, 0.038961
594.366, 0.0649351
602.817, 0.0714286
609.155, 0.0714286
613.38, 0.0649351
617.606, 0.0649351
628.169, 0.0584416
636.62, 0.0649351
645.07, 0.0714286
649.296, 0.0779221
655.634, 0.0779221
668.31, 0.038961
674.648, 0.0324675
678.873, 0.038961
683.099, 0.0454545
687.324, 0.0584416
691.549, 0.0974026
702.113, 0.220779
719.014, 0.266234
752.817, 0.311688
}

// #707 - Ultimate Violet
#declare TS_L707 = spline{linear_spline
377.083, 0.109677
393.75, 0.122581
402.083, 0.167742
412.5, 0.219355
425, 0.316129
433.333, 0.393548
437.5, 0.425806
443.75, 0.458065
447.917, 0.451613
452.083, 0.43871
456.25, 0.406452
462.5, 0.341935
468.75, 0.283871
477.083, 0.206452
481.25, 0.167742
487.5, 0.116129
500, 0.0451613
502.083, 0.0387097
516.667, 0
537.5, 0
558.333, 0
579.167, 0
600, 0
620.833, 0
643.75, 0
647.917, 0.0193548
652.083, 0.0322581
656.25, 0.0774194
668.75, 0.322581
675, 0.470968
679.167, 0.567742
683.333, 0.651613
687.5, 0.716129
691.667, 0.780645
693.75, 0.8
704.167, 0.83871
739.583, 0.858065
777.083, 0.851613
}

// #708 - Cool Lavender
#declare TS_L708 = spline{linear_spline
373.288, 0.598726
393.836, 0.636943
406.164, 0.687898
412.329, 0.719745
416.438, 0.732484
422.603, 0.732484
426.712, 0.738854
434.932, 0.783439
441.096, 0.783439
445.205, 0.77707
453.425, 0.789809
457.534, 0.802548
465.753, 0.796178
476.027, 0.77707
486.301, 0.751592
490.411, 0.745223
498.63, 0.719745
508.904, 0.66242
519.178, 0.605096
531.507, 0.547771
547.945, 0.452229
558.219, 0.375796
570.548, 0.375796
574.658, 0.382166
578.767, 0.394904
582.877, 0.401274
586.986, 0.407643
591.096, 0.420382
601.37, 0.420382
603.425, 0.407643
609.589, 0.407643
613.699, 0.394904
617.808, 0.388535
621.918, 0.382166
626.027, 0.375796
634.247, 0.388535
644.521, 0.44586
646.575, 0.464968
654.795, 0.509554
660.959, 0.509554
669.178, 0.477707
673.288, 0.477707
679.452, 0.496815
687.671, 0.579618
691.781, 0.624204
700, 0.719745
710.274, 0.757962
736.986, 0.802548
763.699, 0.802548
}

// #709 - Electric Lilac
#declare TS_L709 = spline{linear_spline
387.234, 0.519737
400, 0.559211
412.766, 0.592105
419.149, 0.625
421.277, 0.638158
425.532, 0.638158
429.787, 0.631579
440.426, 0.690789
444.681, 0.703947
448.936, 0.697368
451.064, 0.690789
455.319, 0.677632
461.702, 0.671053
470.213, 0.703947
476.596, 0.677632
489.362, 0.598684
495.745, 0.578947
500, 0.572368
504.255, 0.552632
514.894, 0.473684
519.149, 0.434211
523.404, 0.394737
534.043, 0.328947
544.681, 0.276316
557.447, 0.203947
565.957, 0.177632
570.213, 0.164474
574.468, 0.157895
582.979, 0.171053
591.489, 0.217105
597.872, 0.236842
602.128, 0.236842
606.383, 0.236842
610.638, 0.230263
619.149, 0.197368
621.277, 0.190789
629.787, 0.197368
638.298, 0.276316
642.553, 0.342105
648.936, 0.447368
653.191, 0.513158
657.447, 0.578947
661.702, 0.657895
668.085, 0.723684
674.468, 0.756579
689.362, 0.809211
691.489, 0.809211
700, 0.848684
725.532, 0.894737
770.213, 0.934211
}

// #710 - Spir Special Blue
#declare TS_L710 = spline{linear_spline
368.531, 0.257388
385.315, 0.335168
404.196, 0.412993
410.49, 0.464742
423.077, 0.516625
435.664, 0.568509
444.056, 0.581593
450.35, 0.58818
452.448, 0.581773
456.643, 0.581863
460.839, 0.575502
475.524, 0.511302
479.72, 0.492037
488.112, 0.427701
496.503, 0.356914
498.601, 0.344056
509.091, 0.266862
521.678, 0.157455
540.559, 0.0868938
557.343, 0.0291902
563.636, 0.0228739
569.93, 0.0230092
578.322, 0.0360929
584.615, 0.0555831
588.811, 0.062125
597.203, 0.0881119
605.594, 0.0882924
616.084, 0.0691631
620.28, 0.0628017
622.378, 0.0628468
626.573, 0.0629371
630.769, 0.0630273
641.259, 0.0890593
647.552, 0.115001
649.65, 0.127949
651.748, 0.127995
653.846, 0.140943
658.042, 0.141033
666.434, 0.121859
670.629, 0.102594
676.923, 0.0962779
685.315, 0.128716
691.608, 0.19982
697.902, 0.316084
714.685, 0.432574
765.035, 0.491721
}

// #711 - Cold Blue
#declare TS_L711 = spline{linear_spline
368.31, 0.201299
385.211, 0.24026
404.225, 0.324675
414.789, 0.376623
419.014, 0.402597
425.352, 0.422078
429.577, 0.428571
438.028, 0.428571
442.254, 0.422078
450.704, 0.409091
457.042, 0.383117
471.831, 0.311688
495.07, 0.233766
499.296, 0.220779
503.521, 0.214286
507.746, 0.201299
526.761, 0.175325
530.986, 0.168831
560.563, 0.168831
564.789, 0.162338
581.69, 0.149351
596.479, 0.149351
611.268, 0.116883
638.732, 0.11039
655.634, 0.11039
666.197, 0.0844156
670.423, 0.0714286
678.873, 0.0649351
685.211, 0.0649351
695.775, 0.12987
700, 0.162338
706.338, 0.207792
731.69, 0.25974
767.606, 0.298701
}

// #712 - Bedford Blue
#declare TS_L712 = spline{linear_spline
400, 0.251656
410.791, 0.377483
415.108, 0.450331
417.266, 0.516556
428.058, 0.596026
432.374, 0.622517
441.007, 0.668874
451.799, 0.668874
456.115, 0.662252
466.906, 0.635762
484.173, 0.549669
486.331, 0.529801
501.439, 0.417219
510.072, 0.357616
516.547, 0.291391
529.496, 0.198675
531.655, 0.178808
538.129, 0.125828
544.604, 0.0993377
551.079, 0.0728477
553.237, 0.0596026
557.554, 0.0529801
570.504, 0.013245
579.137, 0
587.77, 0.00662252
598.561, 0.0397351
613.669, 0.0331126
620.144, 0.013245
628.777, 0.00662252
630.935, 0.013245
635.252, 0.0198675
641.727, 0.0596026
643.885, 0.0794702
654.676, 0.258278
663.309, 0.364238
674.101, 0.410596
676.259, 0.410596
684.892, 0.463576
693.525, 0.576159
700, 0.695364
717.266, 0.741722
760.432, 0.781457
}

// #713 - J.Winter Blue
#declare TS_L713 = spline{linear_spline
370.833, 0
387.5, 0.0258065
406.25, 0.0709677
412.5, 0.109677
420.833, 0.135484
433.333, 0.193548
437.5, 0.212903
445.833, 0.245161
450, 0.245161
460.417, 0.212903
464.583, 0.193548
472.917, 0.135484
483.333, 0.0903226
495.833, 0.0387097
502.083, 0.0193548
510.417, 0
531.25, 0
552.083, 0
572.917, 0
593.75, 0
614.583, 0
635.417, 0
656.25, 0
677.083, 0
700, 0
743.75, 0
775, 0
}

// #714 - Elysian Blue
#declare TS_L714 = spline{linear_spline
379.851, 0.159722
391.045, 0.194444
400, 0.243056
413.433, 0.326389
429.104, 0.430556
444.776, 0.493056
458.209, 0.5
471.642, 0.479167
480.597, 0.423611
494.03, 0.3125
502.985, 0.236111
509.701, 0.180556
511.94, 0.131944
525.373, 0.0763889
541.045, 0.0208333
558.955, 0
576.866, 2.22045e-16
592.537, 0.00694444
610.448, 0.00694444
621.642, 2.22045e-16
641.791, 0.0138889
655.224, 0.0277778
666.418, 0.0347222
675.373, 0.0277778
688.806, 0.0625
695.522, 0.131944
704.478, 0.1875
733.582, 0.270833
778.358, 0.284722
}

// #715 - Cabana Blue
#declare TS_L715 = spline{linear_spline
368.31, 0.300654
389.437, 0.366013
406.338, 0.444444
412.676, 0.503268
423.239, 0.594771
427.465, 0.627451
438.028, 0.712418
442.254, 0.732026
448.592, 0.738562
461.268, 0.686275
471.831, 0.620915
505.634, 0.294118
514.085, 0.196078
524.648, 0.117647
533.099, 0.0849673
547.887, 0.0392157
552.113, 0.0326797
556.338, 0.0261438
562.676, 0.0196078
575.352, 0
585.915, 0.0130719
602.817, 0.0196078
615.493, 0.0130719
626.056, 0
632.394, 0.0130719
640.845, 0.0261438
649.296, 0.0784314
655.634, 0.143791
659.859, 0.202614
668.31, 0.300654
676.761, 0.359477
685.211, 0.437908
689.437, 0.503268
695.775, 0.575163
704.225, 0.653595
733.803, 0.705882
767.606, 0.751634
}

// #716 - Mikkel Blue
#declare TS_L716 = spline{linear_spline
374.468, 0.0921053
391.489, 0.0986842
404.255, 0.138158
414.894, 0.223684
419.149, 0.289474
425.532, 0.355263
429.787, 0.434211
434.043, 0.5
436.17, 0.552632
442.553, 0.592105
444.681, 0.605263
451.064, 0.618421
457.447, 0.585526
472.34, 0.467105
478.723, 0.394737
491.489, 0.236842
497.872, 0.171053
500, 0.151316
504.255, 0.111842
514.894, 0.0592105
527.66, 0.0131579
531.915, 0
553.191, 0
574.468, 0
595.745, 0
617.021, 0
648.936, 0
661.702, 0.0131579
665.957, 0.0197368
680.851, 0.0657895
689.362, 0.118421
695.745, 0.190789
702.128, 0.256579
717.021, 0.328947
757.447, 0.381579
}

// #717 - Shanklin Frost ****
#declare TS_L717 = spline{linear_spline
378.261, 0.536913
393.478, 0.583893
406.522, 0.630872
415.217, 0.684564
426.087, 0.724832
430.435, 0.731544
441.304, 0.758389
452.174, 0.771812
456.522, 0.771812
467.391, 0.771812
471.739, 0.778523
480.435, 0.744966
484.783, 0.738255
493.478, 0.718121
502.174, 0.677852
504.348, 0.651007
506.522, 0.644295
513.043, 0.577181
521.739, 0.510067
534.783, 0.422819
558.696, 0.194631
565.217, 0.167785
569.565, 0.167785
576.087, 0.194631
578.261, 0.214765
582.609, 0.255034
586.957, 0.288591
591.304, 0.302013
595.652, 0.308725
604.348, 0.261745
615.217, 0.241611
621.739, 0.234899
632.609, 0.234899
641.304, 0.248322
645.652, 0.261745
654.348, 0.268456
658.696, 0.268456
667.391, 0.241611
673.913, 0.208054
678.261, 0.201342
682.609, 0.208054
686.957, 0.228188
693.478, 0.295302
700, 0.369128
710.87, 0.422819
745.652, 0.483221
778.261, 0.503356
}

// #718 - Half Shanklin Frost ****
#declare TS_L718 = spline{linear_spline
376.429, 0.68
391.429, 0.7
406.429, 0.746667
421.429, 0.793333
432.143, 0.793333
436.429, 0.806667
438.571, 0.806667
455.714, 0.826667
462.143, 0.826667
466.429, 0.82
472.857, 0.82
477.143, 0.813333
485.714, 0.806667
492.143, 0.786667
496.429, 0.786667
500.714, 0.78
517.857, 0.686667
532.857, 0.626667
543.571, 0.56
550, 0.493333
556.429, 0.426667
560.714, 0.4
565, 0.393333
569.286, 0.4
580, 0.486667
586.429, 0.513333
592.857, 0.513333
601.429, 0.486667
610, 0.446667
614.286, 0.44
618.571, 0.433333
627.143, 0.426667
637.857, 0.426667
650.714, 0.446667
655, 0.44
665.714, 0.386667
672.143, 0.346667
678.571, 0.346667
682.857, 0.373333
685, 0.393333
689.286, 0.44
697.857, 0.533333
712.857, 0.613333
764.286, 0.686667
}

// #719 - Color Wash Blue
#declare TS_L719 = spline{linear_spline
375, 0.393548
391.667, 0.425806
406.25, 0.477419
427.083, 0.580645
429.167, 0.593548
433.333, 0.619355
439.583, 0.645161
445.833, 0.625806
450, 0.625806
454.167, 0.645161
466.667, 0.606452
468.75, 0.606452
470.833, 0.619355
475, 0.619355
485.417, 0.56129
497.917, 0.503226
506.25, 0.458065
514.583, 0.36129
518.75, 0.296774
529.167, 0.23871
535.417, 0.2
537.5, 0.187097
547.917, 0.129032
560.417, 0.0774194
564.583, 0.0709677
572.917, 0.0580645
585.417, 0.0645161
591.667, 0.103226
602.083, 0.109677
610.417, 0.0903226
614.583, 0.083871
618.75, 0.0709677
627.083, 0.0645161
633.333, 0.0903226
637.5, 0.122581
641.667, 0.167742
647.917, 0.23871
652.083, 0.348387
658.333, 0.393548
664.583, 0.432258
668.75, 0.445161
672.917, 0.451613
681.25, 0.503226
683.333, 0.522581
687.5, 0.632258
697.917, 0.709677
700, 0.716129
714.583, 0.76129
741.667, 0.780645
762.5, 0.780645
}

// #720 - Durham Daylight Frost
#declare TS_L720 = spline{linear_spline
368.085, 0.526316
382.979, 0.572368
404.255, 0.631579
419.149, 0.723684
427.66, 0.743421
431.915, 0.75
436.17, 0.763158
440.426, 0.769737
444.681, 0.776316
451.064, 0.782895
453.191, 0.776316
455.319, 0.782895
459.574, 0.776316
463.83, 0.776316
474.468, 0.756579
480.851, 0.743421
495.745, 0.671053
500, 0.644737
517.021, 0.486842
525.532, 0.414474
538.298, 0.342105
542.553, 0.302632
551.064, 0.197368
559.574, 0.157895
563.83, 0.157895
572.34, 0.190789
574.468, 0.203947
580.851, 0.256579
591.489, 0.269737
595.745, 0.263158
604.255, 0.223684
608.511, 0.217105
612.766, 0.203947
621.277, 0.197368
629.787, 0.197368
638.298, 0.217105
648.936, 0.230263
651.064, 0.230263
653.191, 0.217105
655.319, 0.217105
665.957, 0.164474
670.213, 0.151316
674.468, 0.151316
680.851, 0.171053
691.489, 0.276316
700, 0.401316
727.66, 0.513158
763.83, 0.578947
}

// #721 - Berry Blue
#declare TS_L721 = spline{linear_spline
368.31, 0.169935
389.437, 0.20915
406.338, 0.294118
414.789, 0.392157
419.014, 0.418301
429.577, 0.477124
442.254, 0.555556
446.479, 0.568627
450.704, 0.568627
454.93, 0.555556
457.042, 0.555556
473.944, 0.464052
484.507, 0.385621
490.845, 0.326797
501.408, 0.228758
505.634, 0.183007
516.197, 0.0980392
530.986, 0.0522876
535.211, 0.0457516
541.549, 0.0261438
545.775, 0.0196078
547.887, 0.0130719
552.113, 0
573.239, 0
594.366, 0
615.493, 0
636.62, 0
657.746, 0
691.549, 0
700, 0.0261438
719.014, 0.0784314
748.592, 0.143791
}

// #722 - Bray Blue
#declare TS_L722 = spline{linear_spline
376.596, 0.0915033
391.489, 0.111111
402.128, 0.143791
414.894, 0.228758
421.277, 0.287582
434.043, 0.392157
438.298, 0.431373
444.681, 0.477124
451.064, 0.48366
453.191, 0.477124
457.447, 0.48366
468.085, 0.457516
474.468, 0.431373
489.362, 0.320261
500, 0.235294
504.255, 0.202614
512.766, 0.143791
529.787, 0.0457516
538.298, 0.0196078
544.681, 0.0130719
548.936, 0
570.213, 0
600, 0
602.128, 0
606.383, 0
627.66, 0
648.936, 0
685.106, 0
693.617, 0.0261438
704.255, 0.0718954
727.66, 0.124183
780.851, 0.156863
}

// #723 - Virgin Blue
#declare TS_L723 = spline{linear_spline
373.288, 0.22293
389.726, 0.248408
406.164, 0.299363
420.548, 0.388535
422.603, 0.394904
428.767, 0.420382
441.096, 0.477707
445.205, 0.484076
447.26, 0.496815
451.37, 0.496815
455.479, 0.484076
467.808, 0.464968
473.973, 0.426752
484.247, 0.356688
494.521, 0.273885
502.74, 0.216561
506.849, 0.152866
515.068, 0.11465
523.288, 0.0764331
539.726, 0.0318471
543.836, 0.0254777
547.945, 0.0191083
556.164, 0.0127389
566.438, 0
576.712, 0.0191083
615.753, 0.0191083
626.027, 0.00636943
634.247, 0.0127389
638.356, 0.0127389
650.685, 0.0318471
656.849, 0.0318471
665.068, 0.0191083
671.233, 0.0191083
681.507, 0.0191083
685.616, 0.0254777
695.89, 0.089172
700, 0.127389
712.329, 0.184713
734.932, 0.229299
759.589, 0.261146
}

// #724 - Ocean Blue
#declare TS_L724 = spline{linear_spline
365.714, 0.519737
382.857, 0.565789
404.286, 0.631579
417.143, 0.710526
427.857, 0.763158
438.571, 0.828947
451.429, 0.848684
455.714, 0.848684
460, 0.848684
464.286, 0.848684
468.571, 0.835526
472.857, 0.828947
479.286, 0.809211
483.571, 0.802632
496.429, 0.75
509.286, 0.671053
539.286, 0.447368
556.429, 0.342105
571.429, 0.197368
577.857, 0.157895
582.143, 0.144737
584.286, 0.144737
601.429, 0.125
612.143, 0.0921053
616.429, 0.0855263
625, 0.0723684
627.143, 0.0723684
635.714, 0.0789474
644.286, 0.125
650.714, 0.157895
652.857, 0.157895
655, 0.171053
667.857, 0.151316
676.429, 0.151316
682.857, 0.177632
685, 0.203947
691.429, 0.269737
697.857, 0.335526
700, 0.348684
717.143, 0.375
749.286, 0.401316
}

// #725 - Old Steel Blue
#declare TS_L725 = spline{linear_spline
370.423, 0.69281
387.324, 0.712418
404.225, 0.751634
412.676, 0.777778
416.901, 0.777778
421.127, 0.803922
425.352, 0.823529
433.803, 0.849673
440.141, 0.849673
448.592, 0.882353
450.704, 0.888889
452.817, 0.882353
457.042, 0.888889
459.155, 0.888889
467.606, 0.843137
471.831, 0.836601
480.282, 0.875817
484.507, 0.875817
499.296, 0.79085
503.521, 0.784314
505.634, 0.784314
509.859, 0.79085
514.085, 0.784314
530.986, 0.679739
537.324, 0.640523
547.887, 0.614379
550, 0.614379
552.113, 0.601307
556.338, 0.594771
558.451, 0.581699
571.127, 0.457516
577.465, 0.405229
583.803, 0.385621
592.254, 0.379085
596.479, 0.379085
602.817, 0.352941
604.93, 0.352941
617.606, 0.300654
626.056, 0.287582
630.282, 0.27451
634.507, 0.27451
642.958, 0.313725
645.07, 0.333333
653.521, 0.379085
657.746, 0.385621
659.859, 0.385621
668.31, 0.326797
676.761, 0.320261
680.986, 0.326797
689.437, 0.405229
693.662, 0.470588
697.887, 0.568627
719.014, 0.620915
754.93, 0.647059
}

// #727 - QFD Blue
#declare TS_L727 = spline{linear_spline
369.784, 0
402.158, 0
417.266, 0.0333333
434.532, 0.08
445.324, 0.153333
458.273, 0.193333
469.065, 0.293333
482.014, 0.38
492.806, 0.42
499.281, 0.38
505.755, 0.313333
516.547, 0.22
525.18, 0.0933333
535.971, 0.04
548.921, 0
572.662, 0
624.46, 0
671.942, 0
736.691, 0.00666667
777.698, 0
}

// #728 - Steel Green
#declare TS_L728 = spline{linear_spline
368.31, 0.398693
389.437, 0.418301
404.225, 0.45098
412.676, 0.496732
416.901, 0.496732
421.127, 0.490196
425.352, 0.490196
435.915, 0.529412
444.366, 0.503268
448.592, 0.503268
459.155, 0.542484
463.38, 0.562092
471.831, 0.562092
480.282, 0.627451
490.845, 0.679739
492.958, 0.679739
497.183, 0.673203
503.521, 0.673203
509.859, 0.686275
518.31, 0.653595
537.324, 0.555556
543.662, 0.522876
554.225, 0.405229
556.338, 0.385621
558.451, 0.359477
564.789, 0.320261
569.014, 0.320261
577.465, 0.352941
581.69, 0.379085
590.141, 0.392157
596.479, 0.359477
607.042, 0.300654
615.493, 0.27451
626.056, 0.27451
630.282, 0.27451
647.183, 0.300654
649.296, 0.300654
661.972, 0.254902
670.423, 0.20915
674.648, 0.202614
683.099, 0.235294
691.549, 0.326797
693.662, 0.379085
697.887, 0.437908
700, 0.45098
716.901, 0.529412
759.155, 0.54902
}

// #729 - Scuba Blue
#declare TS_L729 = spline{linear_spline
368.085, 0
402.128, 0
410.638, 0.0131579
419.149, 0.0328947
423.404, 0.0394737
427.66, 0.0526316
429.787, 0.0526316
451.064, 0.138158
455.319, 0.157895
463.83, 0.190789
470.213, 0.25
478.723, 0.315789
485.106, 0.375
489.362, 0.427632
493.617, 0.447368
497.872, 0.453947
502.128, 0.447368
508.511, 0.394737
519.149, 0.282895
527.66, 0.157895
536.17, 0.0592105
546.809, 0.0131579
551.064, 0
574.468, 0
595.745, 0
617.021, 0
638.298, 0
659.574, 0
700, 0
734.043, 0
776.596, 0
}

// #730 - Liberty Green
#declare TS_L730 = spline{linear_spline
366.197, 0.588235
380.986, 0.594771
404.225, 0.568627
408.451, 0.568627
419.014, 0.535948
427.465, 0.529412
431.69, 0.535948
442.254, 0.562092
450.704, 0.594771
454.93, 0.614379
463.38, 0.673203
473.944, 0.764706
484.507, 0.823529
488.732, 0.836601
490.845, 0.836601
511.972, 0.803922
524.648, 0.75817
539.437, 0.718954
547.887, 0.686275
550, 0.679739
554.225, 0.666667
564.789, 0.614379
577.465, 0.535948
583.803, 0.509804
600.704, 0.48366
604.93, 0.464052
609.155, 0.457516
617.606, 0.431373
626.056, 0.424837
634.507, 0.437908
645.07, 0.503268
651.408, 0.529412
657.746, 0.54902
664.085, 0.54902
668.31, 0.535948
674.648, 0.535948
683.099, 0.568627
689.437, 0.627451
697.887, 0.699346
700, 0.705882
712.676, 0.738562
740.141, 0.745098
778.169, 0.738562
}

// #731 - Dirty Ice
#declare TS_L731 = spline{linear_spline
379.597, 0.546667
390.388, 0.546667
399.007, 0.54
409.77, 0.526667
416.259, 0.533333
426.993, 0.506667
435.612, 0.5
444.345, 0.546667
457.353, 0.573333
466.101, 0.626667
474.906, 0.706667
481.439, 0.733333
492.201, 0.72
500.878, 0.74
507.396, 0.76
513.899, 0.773333
526.777, 0.74
535.324, 0.7
548.288, 0.706667
554.777, 0.713333
563.309, 0.666667
576.129, 0.606667
582.532, 0.573333
597.612, 0.56
612.59, 0.5
627.64, 0.473333
638.489, 0.5
645.036, 0.533333
653.698, 0.546667
662.259, 0.513333
666.475, 0.466667
672.95, 0.466667
681.683, 0.513333
688.36, 0.606667
695.007, 0.686667
703.712, 0.72
723.209, 0.753333
753.482, 0.78
781.54, 0.78
}

// #733 - Damp Squib
#declare TS_L733 = spline{linear_spline
371.942, 0.513333
380.576, 0.526667
400, 0.486667
421.583, 0.453333
432.374, 0.453333
445.324, 0.48
458.273, 0.506667
471.223, 0.58
482.014, 0.633333
503.597, 0.653333
514.388, 0.68
523.022, 0.693333
535.971, 0.68
542.446, 0.673333
551.079, 0.693333
557.554, 0.706667
572.662, 0.653333
587.77, 0.606667
602.878, 0.56
615.827, 0.526667
626.619, 0.52
637.41, 0.553333
648.201, 0.573333
658.993, 0.56
663.309, 0.513333
671.942, 0.493333
678.417, 0.526667
687.05, 0.64
695.683, 0.746667
700, 0.773333
725.899, 0.806667
753.957, 0.84
790.647, 0.82
}

// #735 - Velvet Green
#declare TS_L735 = spline{linear_spline
372.34, 0
419.149, 0
448.936, 0
459.574, 0
465.957, 0.0326797
472.34, 0.0980392
480.851, 0.20915
489.362, 0.30719
493.617, 0.392157
500, 0.437908
508.511, 0.444444
512.766, 0.431373
517.021, 0.392157
529.787, 0.235294
540.426, 0.111111
548.936, 0.0457516
557.447, 0.0130719
561.702, 0
582.979, 0
604.255, 0
625.532, 0
646.809, 0
668.085, 0
689.362, 0
723.404, 0
}

// #736 - Twickenham Green
#declare TS_L736 = spline{linear_spline
371.233, 0
404.11, 0
424.658, 0
445.205, 0
465.753, 0
486.301, 0
490.411, 0.0127389
498.63, 0.0700637
508.904, 0.127389
513.014, 0.184713
519.178, 0.203822
521.233, 0.216561
529.452, 0.22293
537.671, 0.191083
545.89, 0.133758
558.219, 0.044586
566.438, 0.0127389
568.493, 0.0127389
570.548, 0
584.932, 0
648.63, 0
697.945, 0
736.986, 0
759.589, 0
}

// #738 - JAS Green
#declare TS_L738 = spline{linear_spline
372.535, 0
412.676, 0
461.268, 0
469.718, 0.00653595
476.056, 0.0326797
482.394, 0.156863
486.62, 0.339869
490.845, 0.522876
499.296, 0.712418
505.634, 0.75817
514.085, 0.803922
522.535, 0.810458
526.761, 0.803922
539.437, 0.751634
552.113, 0.686275
556.338, 0.653595
558.451, 0.620915
564.789, 0.54902
571.127, 0.477124
583.803, 0.359477
596.479, 0.254902
602.817, 0.222222
609.155, 0.169935
617.606, 0.143791
626.056, 0.137255
630.282, 0.137255
634.507, 0.143791
642.958, 0.150327
647.183, 0.156863
651.408, 0.156863
661.972, 0.117647
670.423, 0.0849673
676.761, 0.0784314
685.211, 0.0980392
693.662, 0.163399
695.775, 0.189542
702.113, 0.248366
721.127, 0.300654
754.93, 0.352941
778.169, 0.352941
}

// #740 - Aurora Borealis Green
#declare TS_L740 = spline{linear_spline
370.833, 0
404.167, 0
425, 0
445.833, 0
466.667, 0
487.5, 0
525, 0
529.167, 0.0129032
537.5, 0.0451613
543.75, 0.083871
550, 0.109677
554.167, 0.116129
564.583, 0.0645161
572.917, 0.0387097
579.167, 0.0193548
589.583, 0
622.917, 0
679.167, 0
733.333, 0
766.667, 0
}

// #741 - Mustard Yellow
#declare TS_L741 = spline{linear_spline
370.833, 0
404.167, 0
425, 0
445.833, 0
466.667, 0
487.5, 0
508.333, 0
529.167, 0
550, 0
554.167, 0.0129032
562.5, 0.0451613
566.667, 0.083871
572.917, 0.103226
577.083, 0.109677
585.417, 0.0709677
593.75, 0.0516129
604.167, 0.0193548
610.417, 0.0129032
614.583, 0
635.417, 0
656.25, 0
691.667, 0
702.083, 0.0387097
718.75, 0.083871
750, 0.0903226
777.083, 0.0903226
}

// #742 - Bram Brown
#declare TS_L742 = spline{linear_spline
369.784, 0.00666667
400, 0
404.317, 0.00666667
415.108, 0.02
436.691, 0.02
458.273, 0.0333333
475.54, 0.0533333
484.173, 0.0866667
499.281, 0.113333
514.388, 0.106667
535.971, 0.1
553.237, 0.1
570.504, 0.113333
581.295, 0.14
589.928, 0.153333
611.511, 0.153333
624.46, 0.166667
628.777, 0.18
639.568, 0.213333
652.518, 0.246667
661.151, 0.253333
669.784, 0.24
678.417, 0.266667
687.05, 0.393333
695.683, 0.526667
697.842, 0.593333
712.95, 0.646667
732.374, 0.706667
775.54, 0.766667
}

// #744 - Dirty White
#declare TS_L744 = spline{linear_spline
375.342, 0.229299
389.726, 0.216561
404.11, 0.165605
418.493, 0.0955414
426.712, 0.0828025
434.932, 0.0828025
445.205, 0.101911
453.425, 0.127389
461.644, 0.178344
463.699, 0.203822
471.918, 0.292994
482.192, 0.426752
488.356, 0.471338
494.521, 0.471338
498.63, 0.458599
506.849, 0.452229
523.288, 0.452229
539.726, 0.464968
543.836, 0.464968
554.11, 0.484076
560.274, 0.509554
566.438, 0.56051
572.603, 0.649682
584.932, 0.738854
597.26, 0.802548
605.479, 0.815287
609.589, 0.821656
617.808, 0.821656
621.918, 0.815287
630.137, 0.802548
642.466, 0.802548
650.685, 0.815287
656.849, 0.815287
671.233, 0.770701
679.452, 0.764331
693.836, 0.821656
697.945, 0.828025
700, 0.834395
718.493, 0.872611
757.534, 0.872611
780.137, 0.878981
}

// #746 - Brown
#declare TS_L746 = spline{linear_spline
366.197, 0
400, 0.00649351
427.465, 0.00649351
459.155, 0.012987
488.732, 0.012987
503.521, 0.012987
524.648, 0.012987
554.225, 0.012987
564.789, 0.0194805
585.915, 0.0194805
598.592, 0.025974
621.831, 0.0194805
628.169, 0.012987
634.507, 0.00649351
642.958, 0.012987
651.408, 0.0324675
655.634, 0.0324675
676.761, 0.012987
685.211, 0.025974
693.662, 0.0584416
695.775, 0.0779221
700, 0.12987
716.901, 0.162338
742.254, 0.201299
773.944, 0.201299
}

// #747 - Easy White
#declare TS_L747 = spline{linear_spline
373.288, 0.216561
381.507, 0.242038
393.836, 0.22293
406.164, 0.203822
410.274, 0.191083
418.493, 0.184713
426.712, 0.178344
439.041, 0.178344
443.151, 0.184713
449.315, 0.184713
453.425, 0.191083
461.644, 0.197452
465.753, 0.203822
473.973, 0.210191
476.027, 0.210191
486.301, 0.210191
492.466, 0.210191
496.575, 0.203822
500.685, 0.203822
504.795, 0.197452
521.233, 0.197452
525.342, 0.203822
529.452, 0.203822
533.562, 0.216561
545.89, 0.235669
550, 0.242038
554.11, 0.248408
558.219, 0.261146
562.329, 0.267516
564.384, 0.280255
570.548, 0.324841
576.712, 0.388535
580.822, 0.407643
582.877, 0.426752
591.096, 0.458599
605.479, 0.43949
617.808, 0.43949
632.192, 0.43949
648.63, 0.464968
656.849, 0.44586
667.123, 0.363057
673.288, 0.343949
677.397, 0.343949
681.507, 0.356688
683.562, 0.375796
687.671, 0.43949
691.781, 0.503185
695.89, 0.573248
702.055, 0.649682
722.603, 0.700637
759.589, 0.738854
}

// #748 - Seedy Pink
#declare TS_L748 = spline{linear_spline
378.571, 0.198675
393.571, 0.198675
406.429, 0.192053
415, 0.192053
419.286, 0.18543
427.857, 0.178808
432.143, 0.172185
451.429, 0.145695
455.714, 0.139073
464.286, 0.125828
472.857, 0.119205
481.429, 0.112583
485.714, 0.10596
490, 0.10596
494.286, 0.0993377
498.571, 0.0993377
500.714, 0.0927152
502.857, 0.0596026
505, 0.0927152
513.571, 0.0860927
522.143, 0.0794702
530.714, 0.0794702
535, 0.0728477
539.286, 0.0728477
550, 0.0529801
556.429, 0.0331126
565, 0.0264901
569.286, 0.0264901
577.857, 0.0596026
588.571, 0.119205
601.429, 0.198675
607.857, 0.231788
618.571, 0.271523
627.143, 0.284768
637.857, 0.324503
648.571, 0.397351
652.857, 0.430464
659.286, 0.496689
672.143, 0.609272
674.286, 0.615894
680.714, 0.668874
691.429, 0.728477
700, 0.761589
725.714, 0.821192
781.429, 0.834437
}

// #749 - Hampshire Rose ****
#declare TS_L749 = spline{linear_spline
377.397, 0.66879
406.164, 0.675159
414.384, 0.66879
422.603, 0.66242
430.822, 0.66242
441.096, 0.643312
449.315, 0.624204
457.534, 0.617834
459.589, 0.605096
463.699, 0.605096
471.918, 0.585987
488.356, 0.56051
502.74, 0.541401
513.014, 0.541401
521.233, 0.56051
525.342, 0.566879
533.562, 0.592357
541.781, 0.598726
545.89, 0.598726
552.055, 0.611465
556.164, 0.643312
564.384, 0.707006
572.603, 0.77707
574.658, 0.796178
580.822, 0.834395
586.986, 0.853503
593.151, 0.859873
597.26, 0.866242
601.37, 0.866242
611.644, 0.88535
619.863, 0.904459
621.918, 0.904459
626.027, 0.904459
632.192, 0.904459
636.301, 0.898089
644.521, 0.89172
652.74, 0.88535
669.178, 0.88535
673.288, 0.89172
677.397, 0.898089
685.616, 0.910828
691.781, 0.910828
695.89, 0.904459
697.945, 0.904459
745.205, 0.917197
776.027, 0.917197
}

// #750 - Durham Frost ****
#declare TS_L750 = spline{linear_spline
368.085, 0.895425
385.106, 0.895425
404.255, 0.895425
408.511, 0.901961
434.043, 0.901961
438.298, 0.908497
451.064, 0.908497
453.191, 0.901961
457.447, 0.908497
472.34, 0.908497
478.723, 0.908497
500, 0.908497
521.277, 0.908497
561.702, 0.908497
574.468, 0.915033
585.106, 0.915033
595.745, 0.915033
617.021, 0.915033
625.532, 0.921569
638.298, 0.915033
659.574, 0.915033
700, 0.915033
748.936, 0.915033
778.723, 0.915033
}

// #763 - Wheat
#declare TS_L763 = spline{linear_spline
369.741, 0.270968
386.881, 0.316129
404.055, 0.367742
414.959, 0.432258
419.423, 0.477419
428.01, 0.503226
432.201, 0.496774
440.584, 0.483871
449.239, 0.522581
457.792, 0.541935
459.905, 0.541935
468.423, 0.554839
477.215, 0.619355
481.611, 0.651613
485.904, 0.664516
496.57, 0.683871
505.361, 0.748387
511.767, 0.76129
516.027, 0.767742
520.252, 0.767742
524.443, 0.76129
526.556, 0.76129
530.781, 0.76129
532.894, 0.76129
543.73, 0.812903
550.17, 0.832258
554.43, 0.83871
556.508, 0.832258
571.331, 0.83871
575.591, 0.845161
582.031, 0.864516
586.29, 0.870968
599.069, 0.890323
609.632, 0.890323
613.823, 0.883871
639.175, 0.883871
643.435, 0.890323
662.449, 0.890323
668.719, 0.877419
675.023, 0.870968
685.586, 0.870968
689.846, 0.877419
694.071, 0.877419
698.33, 0.883871
700.443, 0.883871
715.3, 0.896774
747.058, 0.909677
782.974, 0.909677
}

// #764 - Sun Color Straw
#declare TS_L764 = spline{linear_spline
365.957, 0.0460526
385.106, 0.111842
404.255, 0.223684
419.149, 0.342105
427.66, 0.355263
442.553, 0.355263
453.191, 0.375
476.596, 0.473684
485.106, 0.565789
493.617, 0.611842
500, 0.631579
504.255, 0.638158
519.149, 0.697368
527.66, 0.703947
534.043, 0.703947
540.426, 0.736842
546.809, 0.809211
555.319, 0.835526
572.34, 0.828947
576.596, 0.835526
585.106, 0.861842
593.617, 0.894737
597.872, 0.901316
602.128, 0.901316
610.638, 0.881579
617.021, 0.855263
625.532, 0.868421
634.043, 0.894737
642.553, 0.901316
646.809, 0.901316
657.447, 0.875
665.957, 0.861842
670.213, 0.861842
680.851, 0.881579
685.106, 0.894737
693.617, 0.901316
700, 0.901316
740.426, 0.927632
770.213, 0.907895
}

// #765 - LEE Yellow
#declare TS_L765 = spline{linear_spline
372.535, 0.388158
385.211, 0.394737
404.225, 0.381579
412.676, 0.355263
416.901, 0.348684
421.127, 0.335526
425.352, 0.335526
429.577, 0.328947
440.141, 0.328947
448.592, 0.309211
454.93, 0.282895
457.042, 0.282895
461.268, 0.276316
469.718, 0.289474
478.169, 0.315789
482.394, 0.322368
488.732, 0.348684
490.845, 0.368421
499.296, 0.486842
503.521, 0.552632
511.972, 0.625
522.535, 0.717105
524.648, 0.736842
533.099, 0.809211
539.437, 0.828947
543.662, 0.835526
550, 0.835526
552.113, 0.828947
562.676, 0.855263
575.352, 0.907895
579.577, 0.914474
602.817, 0.888158
613.38, 0.914474
621.831, 0.940789
630.282, 0.947368
640.845, 0.927632
645.07, 0.914474
653.521, 0.907895
659.859, 0.907895
668.31, 0.927632
672.535, 0.934211
676.761, 0.947368
680.986, 0.947368
685.211, 0.953947
689.437, 0.953947
697.887, 0.940789
700, 0.927632
744.366, 0.921053
776.056, 0.901316
}

// #767 - Oklahoma Yellow
#declare TS_L767 = spline{linear_spline
378.571, 0
404.286, 0
425.714, 0
447.143, 0
479.286, 0
483.571, 0.013245
490, 0.0397351
496.429, 0.0993377
500.714, 0.172185
505, 0.245033
509.286, 0.311258
513.571, 0.377483
517.857, 0.437086
524.286, 0.523179
530.714, 0.589404
537.143, 0.649007
543.571, 0.721854
552.143, 0.774834
560.714, 0.807947
565, 0.807947
567.143, 0.821192
573.571, 0.821192
582.143, 0.84106
586.429, 0.847682
595, 0.86755
605.714, 0.86755
610, 0.860927
625, 0.860927
635.714, 0.887417
650.714, 0.887417
652.857, 0.880795
655, 0.887417
667.857, 0.86755
682.857, 0.86755
687.143, 0.874172
691.429, 0.874172
697.857, 0.887417
700, 0.880795
740.714, 0.913907
783.571, 0.907285
}

// #768 - Egg Yolk Yellow
#declare TS_L768 = spline{linear_spline
374.101, 0
428.058, 0
475.54, 0
497.122, 0.0333333
518.705, 0.1
529.496, 0.153333
535.971, 0.28
544.604, 0.473333
553.237, 0.633333
555.396, 0.693333
564.029, 0.8
574.82, 0.786667
587.77, 0.846667
589.928, 0.86
598.561, 0.853333
602.878, 0.826667
609.353, 0.833333
615.827, 0.866667
622.302, 0.886667
626.619, 0.88
635.252, 0.846667
643.885, 0.84
652.518, 0.88
656.835, 0.893333
665.468, 0.893333
674.101, 0.86
684.892, 0.86
695.683, 0.886667
710.791, 0.906667
738.849, 0.913333
760.432, 0.9
}

// #770 - Burnt Yellow
#declare TS_L770 = spline{linear_spline
373.288, 0
406.164, 0
426.712, 0
447.26, 0
484.247, 0
488.356, 0.0127389
498.63, 0.044586
500.685, 0.0573248
502.74, 0.0573248
508.904, 0.089172
517.123, 0.121019
531.507, 0.197452
535.616, 0.203822
545.89, 0.254777
547.945, 0.273885
562.329, 0.579618
574.658, 0.770701
586.986, 0.828025
593.151, 0.847134
597.26, 0.853503
601.37, 0.859873
607.534, 0.866242
634.247, 0.878981
654.795, 0.878981
675.342, 0.878981
700, 0.878981
773.973, 0.872611
}

// #773 - Cardbox Amber
#declare TS_L773 = spline{linear_spline
366.197, 0.402597
383.099, 0.409091
404.225, 0.409091
412.676, 0.402597
421.127, 0.396104
425.352, 0.38961
431.69, 0.38961
435.915, 0.383117
442.254, 0.383117
454.93, 0.363636
463.38, 0.357143
473.944, 0.331169
482.394, 0.324675
484.507, 0.324675
490.845, 0.318182
505.634, 0.318182
511.972, 0.331169
520.423, 0.376623
528.873, 0.396104
533.099, 0.409091
535.211, 0.409091
537.324, 0.422078
541.549, 0.428571
545.775, 0.441558
547.887, 0.441558
554.225, 0.506494
562.676, 0.668831
577.465, 0.779221
588.028, 0.837662
594.366, 0.857143
602.817, 0.863636
604.93, 0.863636
609.155, 0.863636
615.493, 0.863636
628.169, 0.883117
636.62, 0.88961
640.845, 0.883117
645.07, 0.876623
651.408, 0.863636
653.521, 0.850649
657.746, 0.844156
668.31, 0.798701
674.648, 0.792208
680.986, 0.805195
687.324, 0.857143
693.662, 0.883117
697.887, 0.88961
700, 0.896104
733.803, 0.909091
765.493, 0.88961
}

// #774 - Soft Amber Key 1
#declare TS_L774 = spline{linear_spline
370, 0.516556
385, 0.516556
404.286, 0.523179
412.857, 0.516556
421.429, 0.509934
430, 0.509934
445, 0.483444
449.286, 0.476821
457.857, 0.470199
466.429, 0.476821
475, 0.496689
490, 0.529801
505, 0.556291
513.571, 0.569536
522.143, 0.576159
532.857, 0.602649
537.143, 0.609272
550, 0.642384
562.857, 0.668874
567.143, 0.688742
582.143, 0.834437
597.143, 0.900662
610, 0.907285
614.286, 0.907285
618.571, 0.913907
644.286, 0.913907
663.571, 0.92053
674.286, 0.913907
687.143, 0.92053
710.714, 0.913907
766.429, 0.92053
}

// #775 - Soft Amber Key 2
#declare TS_L775 = spline{linear_spline
370.423, 0.326797
385.211, 0.339869
404.225, 0.339869
412.676, 0.333333
416.901, 0.326797
427.465, 0.326797
440.141, 0.294118
457.042, 0.281046
463.38, 0.281046
478.169, 0.30719
482.394, 0.320261
486.62, 0.326797
495.07, 0.352941
499.296, 0.359477
509.859, 0.385621
514.085, 0.385621
518.31, 0.392157
530.986, 0.411765
550, 0.48366
554.225, 0.490196
564.789, 0.509804
571.127, 0.562092
585.915, 0.771242
590.141, 0.810458
596.479, 0.849673
604.93, 0.875817
609.155, 0.875817
613.38, 0.882353
615.493, 0.882353
638.732, 0.895425
659.859, 0.895425
700, 0.895425
757.042, 0.895425
773.944, 0.895425
}

// #776 - Nectarine
#declare TS_L776 = spline{linear_spline
366.197, 0.254902
383.099, 0.261438
404.225, 0.261438
412.676, 0.261438
416.901, 0.254902
429.577, 0.254902
433.803, 0.248366
438.028, 0.24183
446.479, 0.222222
465.493, 0.222222
476.056, 0.248366
486.62, 0.27451
490.845, 0.281046
495.07, 0.287582
503.521, 0.287582
514.085, 0.30719
518.31, 0.320261
522.535, 0.326797
533.099, 0.359477
537.324, 0.366013
547.887, 0.398693
550, 0.411765
552.113, 0.411765
566.901, 0.490196
569.014, 0.509804
588.028, 0.803922
598.592, 0.862745
600.704, 0.875817
604.93, 0.882353
609.155, 0.869281
617.606, 0.862745
626.056, 0.849673
630.282, 0.856209
638.732, 0.882353
645.07, 0.908497
649.296, 0.908497
653.521, 0.895425
657.746, 0.888889
666.197, 0.875817
674.648, 0.875817
678.873, 0.882353
689.437, 0.895425
700, 0.895425
746.479, 0.908497
773.944, 0.882353
}

// #777 - Rust
#declare TS_L777 = spline{linear_spline
372.535, 0
404.225, 0
425.352, 0
446.479, 0
467.606, 0
501.408, 0
505.634, 0.012987
514.085, 0.0324675
518.31, 0.038961
522.535, 0.0519481
526.761, 0.0584416
541.549, 0.103896
558.451, 0.155844
566.901, 0.162338
569.014, 0.162338
596.479, 0.493506
604.93, 0.525974
611.268, 0.545455
613.38, 0.545455
621.831, 0.577922
628.169, 0.597403
645.07, 0.597403
649.296, 0.603896
657.746, 0.649351
666.197, 0.681818
668.31, 0.681818
672.535, 0.681818
680.986, 0.701299
695.775, 0.772727
700, 0.785714
723.239, 0.850649
773.944, 0.883117
}

// #778 - Millennium Gold
#declare TS_L778 = spline{linear_spline
370.213, 0
385.106, 0.00653595
404.255, 0.0196078
412.766, 0.0196078
417.021, 0.0130719
434.043, 0.0130719
438.298, 0
448.936, 0
459.574, 0
480.851, 0
512.766, 0
517.021, 0.0130719
523.404, 0.0130719
527.66, 0.0196078
536.17, 0.0326797
546.809, 0.0718954
555.319, 0.117647
568.085, 0.183007
572.34, 0.228758
587.234, 0.535948
595.745, 0.666667
602.128, 0.732026
612.766, 0.777778
625.532, 0.816993
634.043, 0.823529
657.447, 0.823529
661.702, 0.830065
668.085, 0.836601
672.34, 0.843137
680.851, 0.849673
700, 0.849673
731.915, 0.849673
768.085, 0.849673
}

// #779 - Bastard Pink
#declare TS_L779 = spline{linear_spline
365.714, 0.236842
382.857, 0.236842
404.286, 0.236842
412.857, 0.230263
421.429, 0.217105
434.286, 0.197368
445, 0.171053
453.571, 0.151316
464.286, 0.138158
472.857, 0.131579
483.571, 0.105263
500.714, 0.0460526
505, 0.0394737
509.286, 0.0394737
513.571, 0.0460526
517.857, 0.0460526
522.143, 0.0328947
526.429, 0.0263158
530.714, 0.0131579
532.857, 0.0131579
543.571, 0.0131579
547.857, 0.0197368
552.143, 0.0394737
558.571, 0.125
575.714, 0.736842
590.714, 0.822368
601.429, 0.875
605.714, 0.888158
637.857, 0.875
642.143, 0.881579
650.714, 0.901316
655, 0.907895
663.571, 0.921053
670, 0.921053
678.571, 0.888158
689.286, 0.875
695.714, 0.875
700, 0.868421
742.857, 0.881579
770.714, 0.868421
}

// #780 - AS Golden Amber
#declare TS_L780 = spline{linear_spline
371.942, 0.00662252
410.791, 0.00662252
458.273, 0.00662252
501.439, 0
523.022, 0.00662252
538.129, 0.0198675
551.079, 0.0397351
559.712, 0.0728477
568.345, 0.178808
572.662, 0.324503
579.137, 0.503311
583.453, 0.609272
589.928, 0.649007
592.086, 0.695364
600.719, 0.735099
605.036, 0.768212
613.669, 0.801325
624.46, 0.801325
628.777, 0.794702
635.252, 0.794702
639.568, 0.801325
646.043, 0.807947
650.36, 0.827815
665.468, 0.807947
678.417, 0.807947
691.367, 0.847682
702.158, 0.854305
734.532, 0.880795
769.065, 0.86755
}

// #781 - Terry Red
#declare TS_L781 = spline{linear_spline
368.31, 0
404.225, 0
425.352, 0
446.479, 0
467.606, 0
488.732, 0
526.761, 0
530.986, 0.0130719
541.549, 0.0326797
547.887, 0.0457516
552.113, 0.0392157
566.901, 0.0196078
573.239, 0.0392157
579.577, 0.111111
598.592, 0.653595
604.93, 0.745098
613.38, 0.803922
621.831, 0.836601
626.056, 0.843137
634.507, 0.849673
636.62, 0.849673
657.746, 0.856209
670.423, 0.856209
674.648, 0.862745
683.099, 0.862745
687.324, 0.869281
693.662, 0.869281
697.887, 0.875817
700, 0.875817
727.465, 0.901961
773.944, 0.895425
}

// #787 - Marius Red
#declare TS_L787 = spline{linear_spline
366.434, 0
402.098, 0
423.077, 0
444.056, 0
465.035, 0
486.014, 0
506.993, 0
527.972, 0
548.951, 0
569.93, 0
601.399, 0
609.79, 0.0194805
622.378, 0.012987
628.671, 0.012987
639.161, 0.038961
649.65, 0.136364
651.748, 0.253247
664.336, 0.480519
672.727, 0.694805
679.021, 0.733766
685.315, 0.785714
691.608, 0.811688
695.804, 0.811688
727.273, 0.850649
771.329, 0.857143
}

// #789 - Blood Red
#declare TS_L789 = spline{linear_spline
368.31, 0
404.225, 0
425.352, 0
446.479, 0
467.606, 0
488.732, 0
509.859, 0
530.986, 0
552.113, 0
590.141, 0
594.366, 0.0130719
607.042, 0.0522876
617.606, 0.0653595
626.056, 0.0718954
630.282, 0.0784314
634.507, 0.0784314
638.732, 0.0849673
653.521, 0.104575
657.746, 0.0980392
668.31, 0.0588235
672.535, 0.0522876
676.761, 0.0457516
680.986, 0.0522876
687.324, 0.0915033
695.775, 0.169935
712.676, 0.267974
738.028, 0.313725
767.606, 0.339869
}

// #790 - Moroccan Pink
#declare TS_L790 = spline{linear_spline
364.336, 0.402597
404.196, 0.467532
408.392, 0.467532
412.587, 0.474026
416.783, 0.474026
420.979, 0.480519
431.469, 0.493506
435.664, 0.487013
444.056, 0.467532
450.35, 0.461039
467.133, 0.402597
479.72, 0.363636
483.916, 0.357143
504.895, 0.337662
513.287, 0.337662
523.776, 0.363636
536.364, 0.402597
540.559, 0.422078
557.343, 0.5
569.93, 0.603896
580.42, 0.675325
588.811, 0.74026
593.007, 0.779221
607.692, 0.844156
611.888, 0.850649
616.084, 0.857143
628.671, 0.876623
639.161, 0.909091
643.357, 0.915584
651.748, 0.928571
655.944, 0.922078
679.021, 0.88961
681.119, 0.88961
723.077, 0.928571
771.329, 0.954545
}

// #791 - Moroccan Frost ****
#declare TS_L791 = spline{linear_spline
364.085, 0.411765
406.338, 0.477124
423.239, 0.503268
431.69, 0.509804
440.141, 0.509804
450.704, 0.490196
454.93, 0.470588
457.042, 0.470588
465.493, 0.437908
482.394, 0.385621
486.62, 0.379085
492.958, 0.366013
507.746, 0.359477
511.972, 0.359477
522.535, 0.379085
528.873, 0.398693
533.099, 0.405229
547.887, 0.45098
560.563, 0.542484
562.676, 0.562092
577.465, 0.647059
600.704, 0.797386
611.268, 0.862745
617.606, 0.882353
621.831, 0.888889
634.507, 0.901961
655.634, 0.901961
661.972, 0.908497
700, 0.908497
776.056, 0.888889
}

// #793 - Vanity Fair
#declare TS_L793 = spline{linear_spline
366.434, 0.279221
406.294, 0.318182
416.783, 0.331169
423.077, 0.331169
427.273, 0.337662
439.86, 0.337662
450.35, 0.311688
465.035, 0.220779
469.231, 0.194805
477.622, 0.136364
488.112, 0.0779221
500.699, 0.038961
517.483, 0
538.462, 0
559.441, 0
580.42, 0
584.615, 0.0194805
586.713, 0.0194805
593.007, 0.0519481
595.105, 0.0779221
601.399, 0.311688
618.182, 0.675325
628.671, 0.766234
649.65, 0.863636
653.846, 0.876623
676.923, 0.87013
681.119, 0.87013
685.315, 0.883117
689.51, 0.88961
697.902, 0.902597
700, 0.902597
760.839, 0.896104
}

// #794 - Pretty 'n Pink
#declare TS_L794 = spline{linear_spline
376.596, 0.585526
404.255, 0.631579
408.511, 0.657895
421.277, 0.657895
440.426, 0.684211
457.447, 0.644737
472.34, 0.598684
482.979, 0.539474
495.745, 0.493421
504.255, 0.447368
512.766, 0.388158
517.021, 0.342105
525.532, 0.335526
540.426, 0.302632
548.936, 0.243421
555.319, 0.190789
561.702, 0.157895
568.085, 0.184211
574.468, 0.243421
578.723, 0.309211
580.851, 0.368421
585.106, 0.447368
589.362, 0.513158
591.489, 0.578947
595.745, 0.644737
600, 0.703947
606.383, 0.769737
612.766, 0.828947
614.894, 0.861842
623.404, 0.888158
627.66, 0.914474
638.298, 0.907895
657.447, 0.894737
676.596, 0.927632
695.745, 0.907895
753.191, 0.848684
}

// #795 - Magical Magenta
#declare TS_L795 = spline{linear_spline
378.261, 0.406667
404.348, 0.48
421.739, 0.513333
441.304, 0.533333
452.174, 0.52
460.87, 0.46
471.739, 0.406667
478.261, 0.34
484.783, 0.28
491.304, 0.213333
497.826, 0.153333
504.348, 0.1
515.217, 0.04
532.609, 0.0133333
550, 0
573.913, 0
582.609, 0.02
591.304, 0.08
595.652, 0.146667
600, 0.226667
604.348, 0.293333
608.696, 0.36
613.043, 0.44
617.391, 0.506667
621.739, 0.573333
626.087, 0.633333
630.435, 0.7
636.957, 0.766667
643.478, 0.826667
647.826, 0.866667
656.522, 0.88
678.261, 0.886667
700, 0.9
754.348, 0.9
}

// #797 - Deep Purple
#declare TS_L797 = spline{linear_spline
374.648, 0.124183
393.662, 0.163399
410.563, 0.215686
412.676, 0.215686
425.352, 0.261438
427.465, 0.261438
442.254, 0.30719
452.817, 0.248366
467.606, 0.156863
480.282, 0.0849673
492.958, 0.0326797
501.408, 0.00653595
530.986, 0.00653595
573.239, 0.00653595
596.479, 0.0130719
613.38, 0.0522876
619.718, 0.0457516
638.732, 0.0588235
645.07, 0.117647
653.521, 0.222222
655.634, 0.333333
661.972, 0.444444
666.197, 0.54902
674.648, 0.660131
680.986, 0.764706
691.549, 0.836601
697.887, 0.856209
712.676, 0.869281
735.915, 0.882353
}

// #798 - Chrysalis Pink
#declare TS_L798 = spline{linear_spline
389.209, 0.311258
404.317, 0.357616
415.108, 0.417219
425.899, 0.470199
438.849, 0.529801
451.799, 0.523179
460.432, 0.463576
469.065, 0.403974
475.54, 0.337748
482.014, 0.278146
488.489, 0.211921
494.964, 0.152318
503.597, 0.0927152
514.388, 0.0397351
531.655, 0.00662252
564.029, 0.00662252
587.77, 0.0198675
607.194, 0.0463576
628.777, 0.0331126
641.727, 0.0794702
648.201, 0.139073
652.518, 0.205298
656.835, 0.271523
658.993, 0.337748
661.151, 0.403974
665.468, 0.470199
667.626, 0.536424
669.784, 0.596026
674.101, 0.662252
676.259, 0.728477
682.734, 0.794702
687.05, 0.854305
697.842, 0.92053
717.266, 0.960265
}

// #799 - Special KH Lavender
#declare TS_L799 = spline{linear_spline
412.5, 0.193548
420.833, 0.251613
431.25, 0.309677
439.583, 0.367742
450, 0.380645
460.417, 0.329032
468.75, 0.264516
472.917, 0.2
481.25, 0.141935
487.5, 0.0774194
497.917, 0.0387097
506.25, 0.0129032
527.083, 0
572.917, 0
620.833, 0.00645161
641.667, 0.0129032
658.333, 0.0516129
670.833, 0.0645161
681.25, 0.0967742
689.583, 0.187097
700, 0.316129
}

//=============================================================
       
#version tspd_leefilters_Inc_Temp;
#end // eof
