// ------------------------------------------------------------
// Persistence of Vision Ray Tracer Include File
// Transmission Spectral Data library for PoV-Ray
// ------------------------------------------------------------
// Color Scroller Standard Strings
// ------------------------------------------------------------
/*
  Apollo Gel Strings:
    AC_GS_T : Smart Color Theater Gel String
    AC_GS_R : Smart Color Rock 'n Roll Gel String
  ChromaQ Gel Strings: (Rosco Based)
    CQ_16_T : Chroma-Q 16 Color Theater Gel String
    CQ_16_R : Chroma-Q 16 Color Rock and Roll Gel String
    CQ_20_T : Chroma-Q 20 Color Theater Gel String
    CQ_20_R : Chroma-Q 20 Color Rock and Roll Gel String
*/
#ifndef(COLORSTRINGS_INC_TEMP)
#declare COLORSTRINGS_INC_TEMP = version;
#version 3.5;

#include "tspd_roscolux.inc"
#include "tspd_apollogels.inc"

#ifdef(View_POV_Include_Stack)
	#debug "including tspd_colorstrings.inc\n"
#end

// AC_GS_T : Theater String
#declare AC_GS_T = array[16] {
	TS_R00,		// Clear
	TS_AP6300,	// Neon Yellow
	TS_AP7150,	// Santa Fe Amber
	TS_AP7650,	// Coral Amber
	TS_AP7550,	// Spiced Rum Amber
	TS_AP7600,	// Apollo Orange
	TS_AP8250,	// Vixen Red
	TS_AP8450,	// Spanked Pink
	TS_AP8750,	// Hot Pink
	TS_AP3250,	// Dominant Lavender
	TS_AP3700,	// Groovy Grape
	TS_AP4800,	// Ice Blue
	TS_AP4450,	// Heavenly Blue
	TS_AP4400,	// After Hours Blue
	TS_AP5960,	// Margarita Green
	TS_AP5500	// Neptune Blue Green
}

// AC_GS_R : Rock 'n Roll String
#declare AC_GS_R = array [16] {
	TS_R00,		// Clear
	TS_AP6400,	// Pilsner Yellow
	TS_AP7600,	// Apollo Orange
	TS_AP7450,	// Golden Amber
	TS_AP8300,	// Diva Red
	TS_AP8350,	// Bludgeon Red
	TS_AP8750,	// Hot Pink
	TS_AP3150,	// Sour Grape
	TS_AP3700,	// Groovy Grape
	TS_AP3900,	// Voodoo Lavender
	TS_AP4450,	// Heavenly Blue
	TS_AP4250,	// Apollo Blue
	TS_AP4200,	// Bright Blue
	TS_AP4950,	// Caribbean Blue
	TS_AP5500,	// Neptune Blue Green
	TS_AP5400	// Rock 'n Roll Green
}

// Chroma-Q 16 Color Theater Gel String
#declare CQ_16_T = array[16] {
	TS_R00,		// Clear
	TS_R12,		// Straw
	TS_R09,		// Pale Amber Gold
	TS_R02,		// Bastard Amber
	TS_R32,		// Medium Salmon Pink
	TS_R23,		// Orange
	TS_R25,		// Orange Red
	TS_R31,		// Salmon Pink
	TS_R339,	// Broadway Pink
	TS_R52,		// Light Lavender
	TS_R56,		// Gypsy Lavender
	TS_R363,	// Aquamarine
	TS_R77,		// Green Blue
	TS_R80,		// Primary Blue
	TS_R88,		// Light Green
	TS_R93		// Blue Green
}

// Chroma-Q 16 Color Rock and Roll Gel String
#declare CQ_16_R = array[16] {
	TS_R00,		// Clear
	TS_R312,	// Canary
	TS_R23,		// Orange
	TS_R21,		// Golden Amber
	TS_R26,		// Light Red
	TS_R27,		// Medium Red
	TS_R339,	// Broadway Pink
	TS_R49,		// Medium Purple
	TS_R56,		// Gypsy Lavender
	TS_R382,	// Congo Blue
	TS_R77,		// Green Blue
	TS_R68,		// Sky Blue
	TS_R80,		// Primary Blue
	TS_R73,		// Peacock Blue
	TS_R93,		// Blue Green
	TS_R90		// Dark Yellow Green
}

// Chroma-Q 20 Color Theater Gel String
#declare CQ_20_T = array[20] {
	TS_R00,		// Clear
	TS_R12,		// Straw
	TS_R09,		// Pale Amber Gold
	TS_R02,		// Bastard Amber
	TS_R32,		// Medium Salmon Pink
	TS_R23,		// Orange
	TS_R25,		// Orange Red
	TS_R31,		// Salmon Pink
	TS_R339,	// Broadway Pink
	TS_R52,		// Light Lavender
	TS_R56,		// Gypsy Lavender
	TS_R363,	// Aquamarine
	TS_R77,		// Green Blue
	TS_R80,		// Primary Blue
	TS_R88,		// Light Green
	TS_R93,		// Blue Green
	TS_R365,	// Tharon Delft Blue
	TS_R33,		// No Color Pink
	TS_R333,	// Blush Pink
	TS_R321		// Soft Golden Amber
}

// Chroma-Q 20 Color Rock and Roll Gel String
#declare CQ_20_R = array[16] {
	TS_R00,		// Clear
	TS_R312,	// Canary
	TS_R23,		// Orange
	TS_R21,		// Golden Amber
	TS_R26,		// Light Red
	TS_R27,		// Medium Red
	TS_R339,	// Broadway Pink
	TS_R49,		// Medium Purple
	TS_R56,		// Gypsy Lavender
	TS_R382,	// Congo Blue
	TS_R77,		// Green Blue
	TS_R68,		// Sky Blue
	TS_R80,		// Primary Blue
	TS_R73,		// Peacock Blue
	TS_R93,		// Blue Green
	TS_R90,		// Dark Yellow Green
	TS_R321,	// Soft Golden Amber
	TS_R39,		// Skelton Exotic Sangria
	TS_R42,		// Deep Salmon
	TS_R343		// Neon Pink
}

#version COLORSTRINGS_INC_TEMP;
#end