// ------------------------------------------------------------
// Persistence of Vision Ray Tracer Include File
// Transmission Spectral Data library for PoV-Ray
// ------------------------------------------------------------
// Interpreted from Apollo graphs by Christopher Shake
// ------------------------------------------------------------
/*
	These are Apollo gel colors
	
	Theater uses 'transmission' to define the amount of light passed
	through each filter, but POV-Ray uses 'filter' to identify transmitted
	light that is colored by the object pigment, so each color should be
	used as a color pigment with filter=1
	
	Each color is specified with 'TS_APxxxx' for Transmission Spectrum
	All are splines of transmissino spectrums, needs CIE.inc to convert
	to usable RGB format with 'ReflectiveSpectrum()'

	Contents:
	[TS_APxxxx] - [Name]
	AP1050 - Soft Diffusion
	AP1100 - Hard Diffusion
	AP1150 - Linear Diffusion
	AP1200 - Early Morning Frost
	AP1400 - Weaved Diffusion
	AP1450 - Light Weaved Diffusion
	AP1500 - Flat Diffusion
	AP1550 - Textured Diffusion
	AP1600 - White Diffusion
	AP1650 - Light Textured Diffusion
	AP1800 - Red Diffusion
	AP1900 - Blue Diffusion
	AP1950 - Green Diffusion
	AP2000 - Apollo Blue Full CTB
	AP2010 - Apollo Blue 3/4 CTB
	AP2020 - Apollo Blue 1/2 CTB
	AP2030 - Apollo Blue 1/3 CTB
	AP2040 - Apollo Blue 1/4 CTB
	AP2080 - Apollo Blue 1/8 CTB
	AP2090 - Apollo Blue 2X CTB
	AP2100 - Apollo Orange Full CTO
	AP2110 - Apollo Orange 3/4 CTO
	AP2120 - Apollo Orange 1/2 CTO
	AP2140 - Apollo Orange 1/4 CTO
	AP2180 - Apollo Orange 1/8 CTO
	AP2190 - Apollo Orange 2X CTO
	AP2200 - Apollo Straw Full CTS
	AP2220 - Apollo Straw 1/2 CTS
	AP2240 - Apollo Straw 1/4 CTS
	AP2280 - Apollo Straw 1/8 CTS
	AP2310 - .3 Neutral Density
	AP2320 - .6 Neutral Density
	AP2330 - .9 Neutral Density
	AP3000 - Simply Mauvelous
	AP3050 - Purple Mist
	AP3100 - Precious Purple
	AP3150 - Sour Grape
	AP3180 - Purplexed
	AP3200 - Submissive Lavender
	AP3230 - Lavender Retriever
	AP3250 - Dominant Lavender
	AP3300 - Whispering Lavender
	AP3350 - Breathless Lavender
	AP3400 - Luscious Lilac
	AP3450 - Bodacious Blueberry
	AP3500 - Apollo Lavender
	AP3540 - Malice Blue
	AP3550 - Late Night Lavender
	AP3600 - Flirtatious Lavender
	AP3700 - Groovy Grape
	AP3800 - Cowboys & Indigo
	AP3850 - King Congo Blue
	AP3900 - Voodoo Lavender
	AP4050 - Seductive Blue
	AP4100 - Mournful Blue
	AP4150 - New York Blue
	AP4200 - Bright Blue
	AP4250 - Apollo Blue
	AP4270 - Rhythm & Blue
	AP4300 - London Blue
	AP4350 - Sultry Blue
	AP4400 - After Hours Blue
	AP4450 - Heavenly Blue
	AP4500 - Ozone Blue
	AP4600 - Electric Blue
	AP4630 - Kablueie
	AP4650 - Crisp Blue
	AP4680 - Blue Moon
	AP4700 - Timid Blue
	AP4720 - Baby Boy Blue
	AP4750 - Monday Morning Blue
	AP4800 - Ice Blue
	AP4830 - Blue My Mind
	AP4850 - Robin's Egg Blue
	AP4900 - Island Blue
	AP4950 - Caribbean Blue
	AP4970 - Atlantic Green Blue
	AP4990 - Hero Blue
	AP5300 - Apollo Green
	AP5400 - Rock 'n Roll Green
	AP5500 - Neptune Blue Green
	AP5600 - Montego Blue Green
	AP5700 - Kelly Green
	AP5800 - Envy Green
	AP5900 - Cactus Juice Green
	AP5940 - Putting Green
	AP5960 - Margarita Green
	AP6100 - Chablis Yellow (No Longer Available)
	AP6150 - Yellow Snow
	AP6200 - Banana Yellow
	AP6300 - Neon Yellow
	AP6400 - Pilsner Yellow
	AP6500 - Bikini Yellow
	AP6600 - Harvest Gold
	AP6700 - Whiskey Tint (No Longer Available)
	AP6800 - Mustard
	AP6900 - Butterscotch
	AP7050 - Fatherless Amber
	AP7100 - Hot Cocoa
	AP7150 - Santa Fe Amber
	AP7200 - Adobe Orange
	AP7250 - Nude Gold
	AP7300 - Bashful Amber
	AP7330 - Rust Assured
	AP7350 - Fool's Gold Amber
	AP7400 - Apollo Gold
	AP7420 - Just Peachy
	AP7450 - Golden Amber
	AP7500 - Burnt Orange
	AP7550 - Spiced Rum Amber
	AP7570 - Trick or Treat
	AP7600 - Apollo Orange
	AP7650 - Coral Amber
	AP7670 - Salmon"illa"
	AP7700 - Peach Amber
	AP7750 - Sailor's Delight Orange
	AP7800 - Apricot Orange
	AP7850 - Hot Lava Orange
	AP7900 - Kiss Me Tint
	AP8100 - Mango Craze
	AP8200 - Scandalous Scarlet
	AP8250 - Vixen Red
	AP8300 - Diva Red
	AP8310 - Cherry Lewis
	AP8320 - Tasty Apple Red
	AP8350 - Bludgeon Red
	AP8400 - Lipstick Red
	AP8430 - Front Rose
	AP8440 - Watermelon Wine
	AP8445 - Flamingo Pink
	AP8450 - Spanked Pink
	AP8500 - Tease Pink
	AP8530 - Pink Pong
	AP8550 - Bit of Pink
	AP8600 - Cotton Candy Pink
	AP8630 - V.I.Pink
	AP8650 - In the Pink
	AP8680 - Pinkerbell
	AP8700 - Tickled Pink
	AP8710 - Rebecca's Pink Ribbon
	AP8730 - Screamin' Pink
	AP8750 - Hot Pink
	AP8800 - Sassy Pink
	AP8840 - Ruby Slippers
	AP8850 - Apollo Magenta
	AP8900 - Passion Pink
	AP3520 - Alexander The Grape
	AP4130 - Blurple
	AP4870 - Bluetylicious
	AP5430 - Green Gello
	AP7630 - Peach My Interest
	AP7770 - Hot Wings
*/

// Standard include file beginning stuff 
#ifndef (tspd_apollogels_Inc_Temp)
#declare tspd_apollogels_Inc_Temp = version;
#version 3.5;

#ifdef(View_POV_Include_Stack)
  #debug "Including tspd_apollogels.inc"
#end                   


//-------------------------------------------------------------
// Begin Filter Definitions
//-------------------------------------------------------------

// #AP1050 - Soft Diffusion
#declare TS_AP1050 = spline{linear_spline
277.848, 0.00740741
312.658, 0.00740741
315.823, 0.148148
318.987, 0.22963
334.81, 0.274074
366.456, 0.311111
401.266, 0.333333
432.911, 0.348148
455.063, 0.355556
486.709, 0.362963
502.532, 0.362963
534.177, 0.37037
553.165, 0.377778
584.81, 0.377778
603.797, 0.385185
635.443, 0.385185
705.063, 0.4
736.709, 0.4
755.696, 0.4
787.342, 0.4
809.494, 0.4
866.456, 0.407407
}

// #AP1100 - Hard Diffusion
#declare TS_AP1100 = spline{linear_spline
312.658, 0.00740741
331.646, 0.0222222
353.797, 0.037037
385.443, 0.0444444
401.266, 0.0518519
432.911, 0.0518519
455.063, 0.0592593
486.709, 0.0592593
502.532, 0.0592593
534.177, 0.0666667
553.165, 0.0666667
584.81, 0.0666667
603.797, 0.0666667
635.443, 0.0740741
654.43, 0.0740741
686.076, 0.0740741
705.063, 0.0740741
736.709, 0.0814815
755.696, 0.0814815
787.342, 0.0814815
}

// #AP1150 - Linear Diffusion
#declare TS_AP1150 = spline{linear_spline
312.658, 312.658
318.987, 0.162963
328.481, 0.192593
353.797, 0.222222
382.278, 0.244444
407.595, 0.266667
439.241, 0.274074
455.063, 0.281481
486.709, 0.281481
512.025, 0.296296
556.329, 0.296296
619.62, 0.311111
660.759, 0.318519
708.228, 0.318519
739.873, 0.325926
755.696, 0.325926
787.342, 0.325926
}

// #AP1200 - Early Morning Frost
#declare TS_AP1200 = spline{linear_spline
306.329, 0.00740741
315.823, 0.0666667
318.987, 0.311111
322.152, 0.459259
328.481, 0.562963
331.646, 0.637037
350.633, 0.696296
366.456, 0.725926
375.949, 0.748148
391.772, 0.755556
401.266, 0.762963
410.759, 0.777778
417.089, 0.762963
426.582, 0.785185
432.911, 0.77037
445.57, 0.792593
451.899, 0.777778
461.392, 0.792593
474.051, 0.785185
483.544, 0.8
496.203, 0.785185
502.532, 0.8
518.354, 0.785185
531.013, 0.807407
534.177, 0.8
540.506, 0.785185
559.494, 0.814815
568.987, 0.792593
578.481, 0.792593
587.975, 0.814815
594.304, 0.814815
597.468, 0.814815
600.633, 0.792593
613.291, 0.792593
625.949, 0.822222
648.101, 0.792593
663.924, 0.822222
686.076, 0.792593
705.063, 0.82963
736.709, 0.8
755.696, 0.822222
771.519, 0.82963
777.848, 0.807407
796.835, 0.8
}

// #AP1400 - Weaved Diffusion
#declare TS_AP1400 = spline{linear_spline
306.329, 0.237037
337.975, 0.251852
353.797, 0.259259
385.443, 0.259259
401.266, 0.259259
432.911, 0.259259
455.063, 0.259259
486.709, 0.259259
502.532, 0.259259
534.177, 0.259259
553.165, 0.259259
584.81, 0.259259
603.797, 0.259259
635.443, 0.259259
654.43, 0.259259
686.076, 0.259259
705.063, 0.259259
736.709, 0.259259
784.177, 0.259259
800, 0.251852
}

// #AP1450 - Light Weaved Diffusion
#declare TS_AP1450 = spline{linear_spline
306.329, 0.244444
337.975, 0.251852
353.797, 0.251852
385.443, 0.251852
401.266, 0.251852
432.911, 0.251852
455.063, 0.251852
486.709, 0.251852
502.532, 0.251852
534.177, 0.251852
553.165, 0.251852
584.81, 0.251852
603.797, 0.244444
635.443, 0.251852
654.43, 0.251852
686.076, 0.251852
705.063, 0.244444
730.38, 0.251852
755.696, 0.244444
787.342, 0.244444
}

// #AP1500 - Flat Diffusion
#declare TS_AP1500 = spline{linear_spline
303.145, 0.00740741
312.579, 0.0148148
315.723, 0.111111
322.013, 0.192593
337.736, 0.222222
356.604, 0.244444
384.906, 0.274074
425.786, 0.296296
491.824, 0.318519
545.283, 0.340741
598.742, 0.355556
655.346, 0.362963
686.792, 0.37037
705.66, 0.377778
737.107, 0.385185
787.421, 0.392593
803.145, 0.4
}

// #AP1550 - Textured Diffusion
#declare TS_AP1550 = spline{linear_spline
306.329, 0.00740741
312.658, 0.037037
318.987, 0.185185
325.316, 0.362963
328.481, 0.459259
353.797, 0.518519
379.114, 0.562963
429.747, 0.592593
496.203, 0.6
565.823, 0.607407
648.101, 0.614815
705.063, 0.622222
736.709, 0.622222
755.696, 0.622222
787.342, 0.62963
}

// #AP1600 - White Diffusion
#declare TS_AP1600 = spline{linear_spline
303.165, 0
322.152, 0.0148148
353.797, 0.0296296
385.443, 0.037037
401.266, 0.037037
432.911, 0.037037
455.063, 0.0444444
486.709, 0.0444444
502.532, 0.037037
534.177, 0.0444444
553.165, 0.0444444
584.81, 0.0444444
603.797, 0.0444444
635.443, 0.0444444
705.063, 0.0518519
736.709, 0.0518519
755.696, 0.0518519
787.342, 0.0518519
}

// #AP1650 - Light Textured Diffusion
#declare TS_AP1650 = spline{linear_spline
306.329, 0.00740741
312.658, 0.185185
315.823, 0.348148
322.152, 0.422222
331.646, 0.488889
353.797, 0.525926
375.949, 0.57037
385.443, 0.562963
394.937, 0.577778
404.43, 0.57037
417.089, 0.592593
426.582, 0.577778
436.076, 0.6
455.063, 0.592593
483.544, 0.6
496.203, 0.614815
512.025, 0.6
527.848, 0.622222
546.835, 0.6
568.987, 0.622222
587.975, 0.607407
603.797, 0.622222
616.456, 0.62963
632.278, 0.614815
654.43, 0.62963
667.089, 0.637037
686.076, 0.62963
705.063, 0.622222
733.544, 0.644444
755.696, 0.62963
784.177, 0.637037
}

// #AP1800 - Red Diffusion
#declare TS_AP1800 = spline{linear_spline
300, 0
578.481, 0
591.139, 0.0296296
597.468, 0.0888889
603.797, 0.148148
613.291, 0.244444
625.949, 0.325926
644.937, 0.385185
682.911, 0.42963
727.215, 0.459259
774.684, 0.488889
803.165, 0.503704
}

// #AP1900 - Blue Diffusion
#declare TS_AP1900 = spline{linear_spline
300, 0
347.771, 0.0518519
379.618, 0.0888889
401.911, 0.155556
424.204, 0.266667
433.758, 0.340741
446.497, 0.362963
465.605, 0.325926
481.529, 0.259259
494.268, 0.185185
513.376, 0.111111
532.484, 0.0296296
554.777, 0.0148148
577.07, 0
634.395, 0
650.318, 0.0222222
663.057, 0.0888889
682.166, 0.155556
688.535, 0.22963
698.089, 0.303704
714.013, 0.362963
739.49, 0.414815
764.968, 0.437037
800, 0.451852
}

// #AP1950 - Green Diffusion
#declare TS_AP1950 = spline{linear_spline
306.369, 0
335.032, 0
354.14, 0
382.803, 0
401.911, 0
433.758, 0
468.79, 0.00740741
484.713, 0.037037
494.268, 0.111111
510.191, 0.155556
516.561, 0.17037
529.299, 0.177778
548.408, 0.118519
561.146, 0.0518519
577.07, 0.00740741
605.732, 0
637.58, 0
656.688, 0
688.535, 0
710.828, 0
733.121, 0.0444444
745.86, 0.111111
764.968, 0.214815
784.076, 0.311111
800, 0.37037
}

// #AP2000 - Apollo Blue Full CTB
#declare TS_AP2000 = spline{linear_spline
300, 0
325.316, 0.0223881
328.481, 0.0671642
337.975, 0.0895522
341.139, 0.0671642
360.127, 0.0820896
372.785, 0.156716
385.443, 0.268657
394.937, 0.38806
404.43, 0.477612
420.253, 0.597015
429.747, 0.634328
439.241, 0.649254
461.392, 0.634328
477.215, 0.574627
493.038, 0.507463
508.861, 0.432836
521.519, 0.380597
534.177, 0.30597
546.835, 0.276119
556.329, 0.253731
559.494, 0.216418
578.481, 0.223881
591.139, 0.268657
600.633, 0.238806
606.962, 0.201493
616.456, 0.164179
632.278, 0.164179
641.772, 0.186567
651.266, 0.186567
663.924, 0.164179
667.089, 0.119403
679.747, 0.126866
692.405, 0.231343
701.899, 0.373134
711.392, 0.5
730.38, 0.626866
752.532, 0.753731
771.519, 0.820896
781.013, 0.850746
793.671, 0.865672
}

// #AP2010 - Apollo Blue 3/4 CTB
#declare TS_AP2010 = spline{linear_spline
317.857, 0.0336134
321.429, 0.092437
328.571, 0.12605
342.857, 0.117647
357.143, 0.142857
371.429, 0.218487
382.143, 0.352941
392.857, 0.462185
410.714, 0.579832
425, 0.655462
453.571, 0.655462
471.429, 0.613445
496.429, 0.546218
510.714, 0.445378
539.286, 0.361345
553.571, 0.310924
564.286, 0.302521
575, 0.319328
589.286, 0.344538
596.429, 0.327731
610.714, 0.268908
614.286, 0.252101
621.429, 0.235294
639.286, 0.260504
650, 0.260504
660.714, 0.218487
664.286, 0.184874
678.571, 0.210084
682.143, 0.252101
689.286, 0.352941
696.429, 0.462185
707.143, 0.596639
714.286, 0.663866
725, 0.722689
746.429, 0.781513
757.143, 0.865546
778.571, 0.915966
800, 0.92437
}

// #AP2020 - Apollo Blue 1/2 CTB
#declare TS_AP2020 = spline{linear_spline
317.123, 0.000276182
320.548, 0.121299
327.397, 0.226248
347.945, 0.22658
361.644, 0.267123
375.342, 0.396376
385.616, 0.493316
395.89, 0.582192
406.164, 0.671067
426.712, 0.735915
436.986, 0.719951
447.26, 0.76044
457.534, 0.704154
471.233, 0.720504
484.932, 0.664273
491.781, 0.648255
502.055, 0.624227
508.904, 0.584015
522.603, 0.543913
539.726, 0.503867
556.849, 0.447691
570.548, 0.447912
580.822, 0.480336
587.671, 0.472382
601.37, 0.43228
608.219, 0.392068
621.918, 0.368095
635.616, 0.376381
645.89, 0.392676
656.164, 0.320261
666.438, 0.288168
680.137, 0.304518
683.562, 0.377154
693.836, 0.506352
704.11, 0.611357
714.384, 0.692167
724.658, 0.781043
734.932, 0.829596
752.055, 0.846001
769.178, 0.854342
789.726, 0.90306
800, 0.927419
}

// #AP2030 - Apollo Blue 1/3 CTB
#declare TS_AP2030 = spline{linear_spline
318.116, 0
324.871, 0.135593
328.095, 0.245763
335.219, 0.279661
353.273, 0.29661
367.459, 0.381356
374.429, 0.457627
392.176, 0.559322
395.462, 0.652542
406.301, 0.661017
416.925, 0.728814
424.232, 0.711864
445.879, 0.737288
460.495, 0.70339
471.334, 0.711864
482.388, 0.661017
486.134, 0.627119
500.626, 0.627119
518.988, 0.559322
544.535, 0.508475
562.743, 0.483051
587.921, 0.533898
598.944, 0.491525
617.275, 0.432203
635.329, 0.449153
646.137, 0.466102
660.876, 0.398305
664.745, 0.330508
671.899, 0.355932
682.431, 0.449153
689.247, 0.567797
696.309, 0.618644
699.687, 0.686441
728.242, 0.805085
749.675, 0.889831
767.79, 0.889831
782.375, 0.864407
793.214, 0.872881
}

// #AP2040 - Apollo Blue 1/4 CTB
#declare TS_AP2040 = spline{linear_spline
324.415, 0.00859697
329.917, 0.221802
332.669, 0.328404
339.431, 0.361302
356.855, 0.369785
370.266, 0.451972
386.6, 0.616174
396.745, 0.66552
399.897, 0.714752
413.652, 0.747765
423.911, 0.78072
438.01, 0.764558
444.888, 0.781064
455.548, 0.756648
469.532, 0.756878
483.861, 0.707932
497.788, 0.716357
508.563, 0.67555
536.933, 0.618638
550.86, 0.627063
575.447, 0.611073
585.649, 0.652224
596.08, 0.660591
610.523, 0.595254
624.736, 0.562701
642.045, 0.587575
652.361, 0.612334
659.869, 0.538686
667.148, 0.497822
671.103, 0.432313
678.038, 0.440624
684.629, 0.498109
690.933, 0.596573
697.238, 0.695037
707.267, 0.760775
727.728, 0.834881
755.353, 0.884514
772.547, 0.925779
797.077, 0.917985
}

// #AP2080 - Apollo Blue 1/8 CTB
#declare TS_AP2080 = spline{linear_spline
321.305, 0.00797825
326.003, 0.3329
333.597, 0.47444
355.02, 0.51575
373.134, 0.623781
398.458, 0.765026
412.582, 0.748124
419.881, 0.806335
423.338, 0.781278
437.64, 0.814373
444.672, 0.797589
473.039, 0.797116
487.075, 0.755215
504.923, 0.788251
518.9, 0.729685
526.05, 0.746232
540.264, 0.754329
547.119, 0.687548
572.088, 0.728799
596.968, 0.745051
611.004, 0.70315
625.158, 0.694581
646.493, 0.710892
656.894, 0.644052
663.72, 0.568938
670.752, 0.552154
677.903, 0.568702
685.29, 0.651912
696.43, 0.793393
707.186, 0.826547
721.459, 0.851309
739.395, 0.909343
757.213, 0.934046
781.886, 0.891969
799.705, 0.916672
}

// #AP2090 - Apollo Blue 2X CTB
#declare TS_AP2090 = spline{linear_spline
323.782, 0.00806452
333.959, 0.016129
357.659, 0.0483871
374.501, 0.0967742
384.485, 0.16129
391.206, 0.185484
397.789, 0.25
400.971, 0.314516
414.439, 0.354839
421.023, 0.419355
434.491, 0.459677
444.64, 0.475806
465.295, 0.403226
479.147, 0.330645
503.423, 0.193548
534.365, 0.0967742
558.311, 0.0564516
568.625, 0.0241935
585.605, 0.0322581
599.155, 0.0483871
612.761, 0.0483871
626.476, 0.016129
643.428, 0.0322581
660.27, 0.0806452
670.447, 0.0887097
680.733, 0.0645161
694.201, 0.104839
700.565, 0.233871
703.692, 0.314516
713.732, 0.362903
723.634, 0.451613
736.801, 0.580645
760.199, 0.701613
800.658, 0.806452
}

// #AP2100 - Apollo Orange Full CTO
#declare TS_AP2100 = spline{linear_spline
318.349, 0
329.086, 0.340659
343.049, 0.384615
356.911, 0.406593
379.746, 0.384615
388.467, 0.285714
397.288, 0.208791
410.646, 0.120879
428.692, 0.0549451
447.091, 0.0659341
461.256, 0.153846
475.572, 0.274725
485.301, 0.395604
499.062, 0.395604
517.209, 0.351648
530.87, 0.32967
544.833, 0.373626
562.98, 0.32967
572.709, 0.450549
582.639, 0.615385
592.267, 0.714286
597.258, 0.802198
615.657, 0.813187
638.693, 0.835165
656.941, 0.813187
665.813, 0.747253
679.625, 0.758242
689.152, 0.835165
703.065, 0.868132
730.638, 0.879121
767.537, 0.923077
799.546, 0.901099
}

// #AP2110 - Apollo Orange 3/4 CTO
#declare TS_AP2110 = spline{linear_spline
318.115, 0.000307031
324.47, 0.246177
327.326, 0.45809
359.779, 0.501013
374.455, 0.450414
381.916, 0.391219
385.846, 0.30654
396.93, 0.247406
411.759, 0.154437
430.028, 0.112373
447.989, 0.155051
458.551, 0.239975
465.398, 0.350261
475.929, 0.44366
493.951, 0.469389
519.527, 0.4105
526.773, 0.410623
533.927, 0.436168
544.796, 0.436352
555.757, 0.411115
566.257, 0.512987
576.666, 0.640282
579.982, 0.725084
590.482, 0.826957
601.197, 0.869512
623.027, 0.844458
640.989, 0.887135
670.126, 0.845256
709.764, 0.90525
720.571, 0.922383
746.055, 0.888916
760.577, 0.880688
800.276, 0.923733
}

// #AP2120 - Apollo Orange 1/2 CTO
#declare TS_AP2120 = spline{linear_spline
323.49, 0.00756365
336.913, 0.547033
353.691, 0.586449
370.47, 0.609993
400.671, 0.506339
427.517, 0.267817
447.651, 0.267498
464.43, 0.346596
481.208, 0.544743
487.919, 0.608128
497.987, 0.623841
514.765, 0.599766
528.188, 0.567807
544.966, 0.599286
561.745, 0.567274
575.168, 0.61468
585.235, 0.789123
595.302, 0.860392
615.436, 0.844199
628.859, 0.899542
638.926, 0.915255
648.993, 0.899222
665.772, 0.811654
675.839, 0.819431
689.262, 0.890647
706.04, 0.930063
722.819, 0.89805
763.087, 0.94503
796.644, 0.904815
}

// #AP2140 - Apollo Orange 1/4 CTO
#declare TS_AP2140 = spline{linear_spline
317.36, 0
329.813, 0.586284
357.934, 0.684993
378.795, 0.692912
395.897, 0.61825
412.855, 0.502267
433.572, 0.468867
447.661, 0.526485
461.693, 0.567575
468.867, 0.633572
483.099, 0.732511
500.373, 0.707432
510.846, 0.723788
531.564, 0.690387
569.928, 0.73934
584.161, 0.838278
594.806, 0.904218
622.439, 0.862439
643.415, 0.903415
670.99, 0.845108
698.996, 0.91076
712.884, 0.910531
744.075, 0.893486
771.908, 0.909555
796.27, 0.925681
}

// #AP2180 - Apollo Orange 1/8 CTO
#declare TS_AP2180 = spline{linear_spline
314.423, 0.000324114
319.231, 0.348747
333.654, 0.641206
352.885, 0.697818
372.115, 0.743194
386.538, 0.698574
396.154, 0.710026
405.769, 0.654062
415.385, 0.654278
439.423, 0.621111
449.038, 0.688742
463.462, 0.700303
477.885, 0.790514
487.5, 0.79073
501.923, 0.768583
516.346, 0.802615
530.769, 0.780467
554.808, 0.792243
583.654, 0.849071
622.115, 0.849935
641.346, 0.884075
660.577, 0.862035
679.808, 0.873704
699.038, 0.91908
718.269, 0.919512
751.923, 0.875324
800, 0.94382
}

// #AP2190 - Apollo Orange 2X CTO
#declare TS_AP2190 = spline{linear_spline
314.214, 0.00823367
332.484, 0.160466
339.636, 0.177294
357.335, 0.16852
368.033, 0.185288
392.584, 0.1086
406.557, 0.0490414
427.712, 0.0147845
452.563, 0.0228379
463.231, 0.0311317
470.443, 0.0649077
484.927, 0.149408
502.747, 0.17453
523.872, 0.131799
534.479, 0.123144
545.177, 0.139912
562.846, 0.122664
573.574, 0.147906
589.02, 0.503576
600.168, 0.647455
635.928, 0.731594
650.021, 0.705932
663.784, 0.587055
674.331, 0.561452
688.635, 0.595108
696.238, 0.739047
710.662, 0.806599
721.329, 0.814893
753.543, 0.899092
774.848, 0.907206
781.85, 0.881664
803.125, 0.881303
}

// #AP2200 - Apollo Straw Full CTS
#declare TS_AP2200 = spline{linear_spline
310.275, 0
316.876, 0.0723085
325.963, 0.418936
336.071, 0.46716
346.346, 0.466994
349.688, 0.491134
370.43, 0.434348
391.642, 0.240457
409.126, 0.135337
426.416, 0.0866707
446.882, 0.110534
460.222, 0.215158
469.917, 0.384356
483.34, 0.464785
493.531, 0.488814
514.219, 0.448158
531.232, 0.480141
555.206, 0.479755
568.298, 0.656963
581.335, 0.850301
608.595, 0.890184
635.939, 0.905872
653.256, 0.849141
670.298, 0.87306
680.379, 0.929349
697.448, 0.945202
731.779, 0.920455
766, 0.927968
800.221, 0.93548
}

// #AP2220 - Apollo Straw 1/2 CTS
#declare TS_AP2220 = spline{linear_spline
321.127, 0.00826446
331.69, 0.512397
363.38, 0.578512
377.465, 0.553719
398.592, 0.413223
412.676, 0.297521
430.282, 0.206612
447.887, 0.214876
465.493, 0.305785
469.014, 0.471074
483.099, 0.628099
493.662, 0.644628
511.268, 0.595041
528.873, 0.603306
553.521, 0.578512
564.085, 0.636364
581.69, 0.793388
599.296, 0.834711
616.901, 0.892562
627.465, 0.892562
659.155, 0.793388
673.239, 0.801653
680.282, 0.884298
697.887, 0.917355
715.493, 0.892562
743.662, 0.950413
761.268, 0.942149
778.873, 0.909091
796.479, 0.909091
}

// #AP2240 - Apollo Straw 1/4 CTS
#declare TS_AP2240 = spline{linear_spline
314.286, 0
323.81, 0.0668807
333.333, 0.628464
361.905, 0.706474
376.19, 0.728625
395.238, 0.660781
409.524, 0.559337
428.571, 0.480257
447.619, 0.524773
471.429, 0.670305
485.714, 0.804815
495.238, 0.804601
509.524, 0.759337
519.048, 0.781594
542.857, 0.736116
571.429, 0.780417
600, 0.903371
619.048, 0.880471
647.619, 0.879829
666.667, 0.823221
676.19, 0.823007
685.714, 0.901445
704.762, 0.934724
728.571, 0.911717
752.381, 0.922418
776.19, 0.944355
800, 0.921348
}

// #AP2280 - Apollo Straw 1/8 CTS
#declare TS_AP2280 = spline{linear_spline
316.693, 0.00775194
335.478, 0.643411
345.53, 0.658915
345.685, 0.705426
362.3, 0.689922
369.121, 0.736434
379.07, 0.72093
389.121, 0.736434
405.556, 0.666667
415.53, 0.658915
428.708, 0.612403
445.375, 0.612403
462.3, 0.689922
482.636, 0.790698
502.687, 0.806202
519.302, 0.790698
539.328, 0.79845
559.199, 0.75969
579.406, 0.821705
586.176, 0.852713
612.997, 0.899225
636.227, 0.868217
659.432, 0.829457
672.687, 0.806202
686.227, 0.868217
699.742, 0.922481
753.178, 0.953488
779.716, 0.914729
799.69, 0.906977
}

// #AP2310 - .3 Neutral Density
#declare TS_AP2310 = spline{linear_spline
300, 0
303.456, 0.0160553
338.152, 0.21661
365.772, 0.337052
386.563, 0.449385
407.026, 0.465712
420.714, 0.489931
437.722, 0.490204
451.382, 0.506422
471.683, 0.474747
498.868, 0.467182
529.564, 0.491673
553.483, 0.524056
597.649, 0.508762
617.922, 0.469087
631.528, 0.469304
645.243, 0.501524
652.046, 0.501633
668.782, 0.421901
682.388, 0.422118
693.001, 0.542288
710.743, 0.758572
717.655, 0.790682
744.977, 0.82312
786.04, 0.895777
803.075, 0.904049
}

// #AP2320 - .6 Neutral Density
#declare TS_AP2320 = spline{linear_spline
327.211, 0
385.034, 0.193548
402.041, 0.225806
439.456, 0.258065
483.673, 0.209677
500.68, 0.209677
524.49, 0.25
548.299, 0.258065
565.306, 0.274194
585.714, 0.274194
606.122, 0.233871
616.327, 0.201613
636.735, 0.193548
646.939, 0.241935
653.741, 0.25
674.15, 0.185484
680.952, 0.185484
697.959, 0.41129
725.17, 0.717742
745.578, 0.798387
776.19, 0.854839
800, 0.862903
}

// #AP2330 - .9 Neutral Density
#declare TS_AP2330 = spline{linear_spline
318.987, 0.00740741
360.127, 0.037037
398.101, 0.0962963
417.089, 0.103704
436.076, 0.125926
448.734, 0.125926
467.722, 0.103704
508.861, 0.0962963
527.848, 0.125926
546.835, 0.111111
565.823, 0.133333
584.81, 0.133333
600.633, 0.125926
616.456, 0.0962963
629.114, 0.0888889
638.608, 0.0962963
654.43, 0.125926
657.595, 0.125926
670.253, 0.103704
679.747, 0.103704
689.241, 0.133333
695.57, 0.237037
714.557, 0.451852
724.051, 0.555556
746.203, 0.696296
774.684, 0.777778
800, 0.8
}

// #AP3000 - Simply Mauvelous
#declare TS_AP3000 = spline{linear_spline
300, 0.0967742
327.211, 0.104839
347.619, 0.129032
354.422, 0.169355
364.626, 0.241935
378.231, 0.41129
385.034, 0.475806
388.435, 0.475806
398.639, 0.443548
402.041, 0.33871
412.245, 0.25
425.85, 0.145161
442.857, 0.0725806
466.667, 0.0564516
493.878, 0.0483871
514.286, 0.0725806
548.299, 0.0725806
565.306, 0.0725806
578.912, 0.0887097
599.32, 0.145161
612.925, 0.25
623.129, 0.395161
643.537, 0.604839
657.143, 0.75
667.347, 0.83871
691.156, 0.895161
714.966, 0.919355
738.776, 0.927419
765.986, 0.91129
782.993, 0.887097
796.599, 0.870968
}

// #AP3050 - Purple Mist
#declare TS_AP3050 = spline{linear_spline
300, 0.0888889
318.987, 0.252133
334.81, 0.385701
356.962, 0.519362
379.114, 0.623394
382.278, 0.690108
398.101, 0.734787
407.595, 0.72752
420.253, 0.646226
439.241, 0.542804
451.899, 0.424473
467.722, 0.306188
474.051, 0.195171
489.873, 0.0917018
502.532, 0.0622597
512.025, 0.0327707
531.013, 0.033052
556.329, 0.0408345
568.987, 0.100281
578.481, 0.322644
587.975, 0.530192
597.468, 0.671074
606.962, 0.804548
622.785, 0.893671
654.43, 0.916362
686.076, 0.916831
705.063, 0.917112
736.709, 0.917581
755.696, 0.917862
787.342, 0.925738
}

// #AP3100 - Precious Purple
#declare TS_AP3100 = spline{linear_spline
303.145, 0.00740741
318.868, 0.0222222
328.302, 0.237037
337.736, 0.274074
353.459, 0.296296
378.616, 0.392593
410.063, 0.481481
416.352, 0.518519
422.642, 0.525926
428.931, 0.540741
444.654, 0.503704
463.522, 0.422222
479.245, 0.296296
494.969, 0.207407
513.836, 0.118519
523.27, 0.0814815
535.849, 0.0740741
554.717, 0.0296296
564.151, 0.0296296
576.73, 0.0444444
586.164, 0.133333
595.597, 0.22963
608.176, 0.274074
630.189, 0.340741
642.767, 0.466667
652.201, 0.637037
658.491, 0.733333
674.214, 0.881481
686.792, 0.903704
705.66, 0.874074
724.528, 0.911111
737.107, 0.933333
759.119, 0.896296
771.698, 0.896296
787.421, 0.925926
796.855, 0.933333
}

// #AP3150 - Sour Grape
#declare TS_AP3150 = spline{linear_spline
316.34, 0.00763359
322.876, 0.0458015
332.68, 0.0534351
342.484, 0.0381679
355.556, 0.0381679
381.699, 0.145038
394.771, 0.229008
417.647, 0.274809
427.451, 0.29771
433.987, 0.320611
443.791, 0.320611
447.059, 0.274809
456.863, 0.251908
466.667, 0.167939
473.203, 0.114504
479.739, 0.0687023
486.275, 0.0305344
496.078, 0
584.314, 0
597.386, 0.0458015
603.922, 0.129771
623.529, 0.206107
636.601, 0.267176
643.137, 0.40458
652.941, 0.450382
666.013, 0.519084
675.817, 0.557252
682.353, 0.633588
692.157, 0.763359
698.693, 0.793893
701.961, 0.832061
731.373, 0.839695
754.248, 0.885496
770.588, 0.908397
786.928, 0.870229
800, 0.854962
}

// #AP3180 - Purplexed
#declare TS_AP3180 = spline{linear_spline
299.751, 0.0725806
330.352, 0.137097
360.953, 0.201613
367.72, 0.225806
400.088, 0.774194
413.677, 0.806452
427.403, 0.798387
441.35, 0.725806
451.955, 0.629032
462.34, 0.596774
476.342, 0.508065
490.428, 0.395161
504.209, 0.370968
518.322, 0.25
532.021, 0.25
545.609, 0.282258
562.87, 0.241935
569.664, 0.258065
582.838, 0.41129
596.26, 0.491935
616.698, 0.524194
630.507, 0.491935
640.864, 0.467742
654.452, 0.5
667.405, 0.717742
684.031, 0.862903
700.933, 0.927419
721.426, 0.943548
762.522, 0.943548
800.193, 0.943548
}

// #AP3200 - Submissive Lavender
#declare TS_AP3200 = spline{linear_spline
312.739, 0
315.924, 0.134328
325.478, 0.402985
328.662, 0.492537
341.401, 0.58209
347.771, 0.589552
357.325, 0.626866
360.51, 0.641791
373.248, 0.626866
376.433, 0.649254
382.803, 0.69403
392.357, 0.664179
398.726, 0.708955
408.28, 0.738806
414.65, 0.723881
424.204, 0.738806
430.573, 0.768657
440.127, 0.768657
443.312, 0.746269
456.051, 0.753731
471.975, 0.738806
481.529, 0.731343
507.006, 0.656716
529.299, 0.567164
548.408, 0.485075
557.962, 0.455224
573.885, 0.470149
583.439, 0.514925
592.994, 0.559701
605.732, 0.567164
612.102, 0.559701
621.656, 0.567164
628.025, 0.604478
637.58, 0.679104
650.318, 0.768657
663.057, 0.820896
666.242, 0.828358
678.981, 0.843284
688.535, 0.865672
707.643, 0.910448
717.197, 0.947761
726.752, 0.962687
755.414, 0.895522
771.338, 0.88806
784.076, 0.895522
796.815, 0.910448
}

// #AP3230 - Lavender Retriever
#declare TS_AP3230 = spline{linear_spline
312.658, 0
325.316, 0.268657
331.646, 0.410448
344.304, 0.462687
369.62, 0.522388
391.772, 0.574627
407.595, 0.626866
413.924, 0.641791
436.076, 0.664179
442.405, 0.679104
451.899, 0.641791
470.886, 0.641791
483.544, 0.58209
508.861, 0.529851
521.519, 0.440299
527.848, 0.395522
550, 0.343284
562.658, 0.291045
572.152, 0.291045
591.139, 0.41791
603.797, 0.477612
629.114, 0.455224
641.772, 0.559701
651.266, 0.708955
663.924, 0.813433
670.253, 0.828358
698.734, 0.858209
708.228, 0.880597
724.051, 0.925373
746.203, 0.910448
768.354, 0.880597
800, 0.910448
}

// #AP3250 - Dominant Lavender
#declare TS_AP3250 = spline{linear_spline
318.868, 0
328.302, 0.291045
337.736, 0.41791
347.17, 0.432836
356.604, 0.455224
366.038, 0.477612
384.906, 0.529851
397.484, 0.559701
400.629, 0.589552
413.208, 0.604478
422.642, 0.649254
428.931, 0.649254
447.799, 0.708955
460.377, 0.686567
469.811, 0.701493
479.245, 0.671642
491.824, 0.58209
504.403, 0.522388
513.836, 0.477612
520.126, 0.395522
523.27, 0.365672
535.849, 0.320896
548.428, 0.261194
557.862, 0.201493
567.296, 0.179104
579.874, 0.238806
595.597, 0.350746
605.031, 0.38806
614.465, 0.373134
623.899, 0.358209
630.189, 0.380597
645.912, 0.485075
649.057, 0.574627
652.201, 0.671642
667.925, 0.768657
680.503, 0.850746
696.226, 0.902985
721.384, 0.902985
743.396, 0.947761
762.264, 0.962687
800, 0.895522
}

// #AP3300 - Whispering Lavender
#declare TS_AP3300 = spline{linear_spline
317.007, 0
327.211, 0.548387
337.415, 0.580645
340.816, 0.629032
351.02, 0.645161
361.224, 0.677419
374.83, 0.677419
378.231, 0.709677
395.238, 0.733871
402.041, 0.758065
422.449, 0.766129
429.252, 0.790323
439.456, 0.822581
449.66, 0.806452
463.265, 0.83871
487.075, 0.782258
493.878, 0.806452
504.082, 0.758065
514.286, 0.725806
517.687, 0.685484
534.694, 0.653226
551.701, 0.596774
565.306, 0.540323
582.313, 0.548387
599.32, 0.596774
609.524, 0.572581
619.728, 0.564516
633.333, 0.58871
643.537, 0.725806
660.544, 0.83871
684.354, 0.895161
708.163, 0.919355
718.367, 0.919355
748.98, 0.943548
765.986, 0.935484
776.19, 0.91129
789.796, 0.91129
800, 0.919355
}

// #AP3350 - Breathless Lavender
#declare TS_AP3350 = spline{linear_spline
318.964, 0.00740741
321.308, 0.266667
323.793, 0.481481
333.169, 0.518519
342.405, 0.6
351.875, 0.607407
361.299, 0.62963
364.369, 0.659259
380.169, 0.666667
386.404, 0.696296
405.251, 0.740741
430.427, 0.785185
443.015, 0.807407
468.378, 0.792593
487.506, 0.748148
500.398, 0.674074
516.456, 0.6
535.724, 0.511111
548.64, 0.42963
570.816, 0.422222
580.192, 0.459259
592.804, 0.474074
602.157, 0.518519
611.721, 0.496296
627.473, 0.518519
642.897, 0.644444
658.392, 0.748148
664.51, 0.814815
676.981, 0.874074
689.498, 0.918519
705.321, 0.918519
718.073, 0.888889
737.06, 0.888889
752.766, 0.925926
759.048, 0.940741
768.495, 0.955556
777.965, 0.962963
}

// #AP3400 - Luscious Lilac
#declare TS_AP3400 = spline{linear_spline
312.658, 0.0516567
322.152, 0.257679
334.81, 0.41963
347.468, 0.485992
360.127, 0.508237
385.443, 0.545374
404.43, 0.597124
413.924, 0.648734
432.911, 0.71519
451.899, 0.730175
461.392, 0.74502
470.886, 0.701042
493.038, 0.671956
499.367, 0.605873
515.19, 0.51787
531.013, 0.429868
543.671, 0.334466
556.329, 0.275828
578.481, 0.232036
594.304, 0.269034
603.797, 0.298585
610.127, 0.291325
616.456, 0.26936
629.114, 0.269546
641.772, 0.306497
648.101, 0.43159
654.43, 0.571389
663.924, 0.711234
670.253, 0.799563
679.747, 0.814408
698.734, 0.873511
727.215, 0.9254
746.203, 0.933032
765.19, 0.911253
793.671, 0.93373
}

// #AP3450 - Bodacious Blueberry
#declare TS_AP3450 = spline{linear_spline
325.316, 0
341.139, 0.12782
369.62, 0.180451
379.114, 0.225564
391.772, 0.240602
413.924, 0.338346
426.582, 0.443609
445.57, 0.571429
455.063, 0.593985
467.722, 0.548872
483.544, 0.451128
496.203, 0.338346
505.696, 0.203008
518.354, 0.120301
531.013, 0.075188
537.342, 0.0300752
550, 0.0150376
565.823, 0
587.975, 0
610.127, 0.0225564
625.949, 0
648.101, 0.0300752
654.43, 0.0977444
660.759, 0.285714
667.089, 0.496241
679.747, 0.669173
689.241, 0.796992
711.392, 0.894737
724.051, 0.917293
739.873, 0.902256
758.861, 0.932331
777.848, 0.924812
800, 0.909774
}

// #AP3500 - Apollo Lavender
#declare TS_AP3500 = spline{linear_spline
309.434, 0
315.723, 0.0146907
318.868, 0.0444945
325.157, 0.156341
334.591, 0.283066
347.17, 0.37243
375.472, 0.409321
381.761, 0.454004
397.484, 0.468694
410.063, 0.543133
425.786, 0.6026
432.075, 0.624894
444.654, 0.669483
457.233, 0.65437
469.811, 0.669107
476.101, 0.624237
488.679, 0.564348
498.113, 0.519431
510.692, 0.459542
513.836, 0.369943
523.27, 0.302638
538.994, 0.183
557.862, 0.115554
573.585, 0.11532
592.453, 0.167277
608.176, 0.219281
627.044, 0.181686
639.623, 0.211349
645.912, 0.323195
655.346, 0.546935
664.78, 0.643809
674.214, 0.785459
689.937, 0.874777
708.805, 0.896884
740.252, 0.903877
768.553, 0.903454
796.855, 0.932883
}

// #AP3540 - Malice Blue
#declare TS_AP3540 = spline{linear_spline
308.762, 0.424
332.381, 0.48
359.184, 0.6
385.905, 0.744
402.776, 0.784
416.435, 0.768
426.748, 0.736
444.082, 0.64
461.442, 0.536
478.884, 0.408
496.272, 0.296
513.578, 0.208
520.571, 0.152
544.463, 0.128
561.605, 0.088
595.646, 0.08
619.429, 0.088
633.143, 0.056
650.122, 0.064
656.707, 0.128
669.415, 0.392
682.095, 0.664
691.782, 0.816
708.544, 0.888
732.272, 0.912
769.687, 0.912
796.925, 0.904
}

// #AP3550 - Late Night Lavender
#declare TS_AP3550 = spline{linear_spline
325.478, 0.00784295
331.847, 0.0527141
347.771, 0.112653
354.14, 0.157524
379.618, 0.195218
405.096, 0.285151
421.019, 0.404791
433.758, 0.501996
443.312, 0.546915
456.051, 0.554568
468.79, 0.509982
481.529, 0.405694
494.268, 0.286482
507.006, 0.167269
522.93, 0.0630288
542.038, 0.0185379
551.592, 0.00375511
589.809, 0.00432551
602.548, 0.0343664
618.471, 0.034604
628.025, 0.0048959
643.949, 0.0499097
653.503, 0.139605
656.688, 0.24413
666.242, 0.505466
675.796, 0.714564
685.35, 0.804259
707.643, 0.886681
710.828, 0.931505
720.382, 0.946573
739.49, 0.909545
755.414, 0.887394
771.338, 0.917483
784.076, 0.947524
800, 0.932836
}

// #AP3600 - Flirtatious Lavender
#declare TS_AP3600 = spline{linear_spline
322.727, 0
329.695, 0.146154
339.685, 0.223077
369.081, 0.276923
401.748, 0.338462
418.257, 0.423077
441.309, 0.523077
451.099, 0.538462
476.948, 0.5
486.389, 0.407692
505.519, 0.3
514.935, 0.2
527.597, 0.1
540.41, 0.0461538
556.618, 0.0384615
585.864, 0.0461538
608.741, 0.0923077
624.925, 0.0769231
644.68, 0.161538
651.648, 0.307692
665.46, 0.561538
675.649, 0.7
698.851, 0.846154
718.407, 0.869231
738.037, 0.915385
754.321, 0.930769
773.751, 0.915385
793.182, 0.9
802.947, 0.907692
}

// #AP3700 - Groovy Grape
#declare TS_AP3700 = spline{linear_spline
319.108, 0
328.662, 0.0902256
341.401, 0.142857
360.51, 0.157895
373.248, 0.203008
395.541, 0.323308
417.834, 0.421053
440.127, 0.526316
449.682, 0.526316
462.42, 0.443609
475.159, 0.330827
491.083, 0.180451
503.822, 0.075188
519.745, 0.0300752
535.669, 0
583.439, 0
605.732, 0.0451128
621.656, 0.037594
631.21, 0.0526316
640.764, 0.105263
653.503, 0.345865
663.057, 0.62406
675.796, 0.81203
694.904, 0.902256
714.013, 0.909774
723.567, 0.902256
739.49, 0.932331
758.599, 0.909774
764.968, 0.902256
780.892, 0.894737
793.631, 0.909774
}

// #AP3800 - Cowboys & Indigo
#declare TS_AP3800 = spline{linear_spline
303.247, 0
351.948, 0
368.207, 0.00775194
391.035, 0.0387597
413.888, 0.0775194
433.62, 0.155039
446.783, 0.209302
466.088, 0.155039
491.76, 0.0620155
514.286, 0
644.131, 0
663.938, 0.0930233
673.93, 0.170543
690.919, 0.403101
704.737, 0.658915
724.695, 0.806202
744.402, 0.875969
767.18, 0.891473
799.673, 0.899225
}

// #AP3850 - King Congo Blue
#declare TS_AP3850 = spline{linear_spline
303.165, 0
379.114, 0.00632911
404.43, 0.0811364
420.253, 0.171124
439.241, 0.230989
442.405, 0.23846
458.228, 0.208147
470.886, 0.140287
493.038, 0.0346912
508.861, 0
641.772, 0
663.924, 0.0321214
682.911, 0.0468735
692.405, 0.17455
714.557, 0.490007
730.38, 0.647663
752.532, 0.760112
774.684, 0.834967
781.013, 0.84991
803.165, 0.842058
}

// #AP3900 - Voodoo Lavender
#declare TS_AP3900 = spline{linear_spline
303.205, 2.22045e-16
351.282, 2.22045e-16
386.418, 0.037594
405.432, 0.105263
421.12, 0.210526
433.459, 0.360902
442.833, 0.43609
452.473, 0.428571
465.438, 0.383459
468.787, 0.338346
488.331, 0.240602
501.537, 0.120301
521.009, 0.0451128
537.155, 0.0075188
652.564, 2.22045e-16
671.65, 0.0451128
683.989, 0.195489
696.159, 0.398496
711.461, 0.62406
714.546, 0.661654
726.957, 0.789474
742.862, 0.827068
762.045, 0.842105
771.539, 0.879699
797.18, 0.879699
}

// #AP4050 - Seductive Blue
#declare TS_AP4050 = spline{linear_spline
303.226, 0
364.516, 0
396.774, 0.0378788
409.677, 0.106061
425.806, 0.204545
441.935, 0.295455
451.613, 0.325758
474.194, 0.287879
480.645, 0.19697
500, 0.0984848
522.581, 0.0227273
535.484, 0
654.839, 0.00757576
683.871, 0.0454545
696.774, 0.265152
709.677, 0.515152
729.032, 0.69697
748.387, 0.787879
767.742, 0.833333
783.871, 0.825758
800, 0.848485
}

// #AP4100 - Mournful Blue
#declare TS_AP4100 = spline{linear_spline
300, 0
354.117, 0.00740741
395.376, 0.0518519
410.97, 0.155556
432.885, 0.274074
445.435, 0.333333
464.803, 0.251852
484.336, 0.118519
506.912, 0.0296296
526.091, 0.00740741
634.371, 0.00740741
675.631, 0.0518519
694.503, 0.125926
700.33, 0.296296
718.684, 0.533333
734.135, 0.681481
752.984, 0.762963
778.273, 0.822222
797.334, 0.837037
}

// #AP4150 - New York Blue
#declare TS_AP4150 = spline{linear_spline
303.205, 0
354.487, 0
383.333, 0.0517677
399.359, 0.112131
418.59, 0.202749
437.821, 0.384275
447.436, 0.452312
463.462, 0.429341
476.282, 0.300359
492.308, 0.13345
524.359, 0.00417638
652.564, 0
678.205, 0.0397242
687.821, 0.130488
694.231, 0.266754
707.051, 0.493833
719.872, 0.645153
729.487, 0.735917
748.718, 0.803807
774.359, 0.886752
787.179, 0.901709
803.205, 0.893891
}

// #AP4200 - Bright Blue
#declare TS_AP4200 = spline{linear_spline
303.181, 0.0075188
328.846, 0
344.775, 0.0300752
376.61, 0.0977444
395.503, 0.203008
414.204, 0.368421
429.796, 0.503759
442.206, 0.631579
458.28, 0.616541
474.571, 0.533835
491.079, 0.383459
504.285, 0.263158
520.672, 0.150376
533.806, 0.0526316
559.615, 0
639.744, 0
665.12, 0.0827068
680.976, 0.135338
693.243, 0.308271
701.942, 0.593985
717.607, 0.706767
739.657, 0.827068
761.804, 0.917293
774.6, 0.924812
797.108, 0.902256
}

// #AP4250 - Apollo Blue
#declare TS_AP4250 = spline{linear_spline
304.673, 0
342.056, 0.0212876
370.093, 0.0762201
388.785, 0.164694
412.15, 0.31973
421.495, 0.452856
440.187, 0.619107
449.533, 0.641121
468.224, 0.574039
496.262, 0.395639
510.28, 0.206438
533.645, 0.0614746
566.355, 0.00519211
645.794, 0.00342679
655.14, 0.0365524
683.178, 0.0692627
692.523, 0.269055
711.215, 0.579751
739.252, 0.712461
762.617, 0.834164
781.308, 0.867082
800, 0.877778
}

// #AP4270 - Rhythm & Blue
#declare TS_AP4270 = spline{linear_spline
304.288, 0.252033
342.043, 0.276423
359.389, 0.341463
380.41, 0.479675
394.331, 0.544715
418.527, 0.609756
439.325, 0.682927
453.024, 0.682927
469.952, 0.626016
486.686, 0.512195
510.157, 0.365854
543.68, 0.154472
567.43, 0.0894309
591.263, 0.0487805
615.403, 0.097561
639.264, 0.0650407
656.86, 0.203252
671.478, 0.471545
682.531, 0.699187
689.715, 0.796748
700.128, 0.837398
710.513, 0.869919
727.692, 0.886179
761.967, 0.894309
789.308, 0.878049
799.499, 0.853659
}

// #AP4300 - London Blue
#declare TS_AP4300 = spline{linear_spline
315.924, 0
331.847, 0.11194
357.325, 0.171642
385.987, 0.253731
411.465, 0.425373
433.758, 0.589552
446.497, 0.634328
456.051, 0.58209
465.605, 0.574627
481.529, 0.485075
500.637, 0.358209
522.93, 0.201493
542.038, 0.0895522
570.701, 0.0223881
580.255, 0
602.548, 0.0149254
624.841, 0.00746269
640.764, 0.0298507
650.318, 0.0820896
653.503, 0.19403
669.427, 0.320896
682.166, 0.462687
691.72, 0.626866
701.274, 0.761194
710.828, 0.783582
733.121, 0.865672
749.045, 0.910448
774.522, 0.880597
784.076, 0.873134
800, 0.88806
}

// #AP4350 - Sultry Blue
#declare TS_AP4350 = spline{linear_spline
315.746, 0.00722767
325.344, 0.0593232
347.426, 0.0813817
376.031, 0.17797
385.723, 0.259915
392.247, 0.334444
408.345, 0.453607
424.419, 0.565307
437.42, 0.699441
447.064, 0.766462
472.173, 0.751162
484.353, 0.624114
499.84, 0.549256
508.969, 0.452105
521.054, 0.295208
530.136, 0.183132
539.428, 0.138217
570.521, 0.0258131
601.966, 0.0253438
630.22, 0.00999671
642.892, 0.0396583
655.705, 0.114094
671.521, 0.143709
684.334, 0.218144
687.76, 0.307645
701.089, 0.546252
710.968, 0.687896
733.332, 0.799503
755.531, 0.858873
787.164, 0.918102
799.789, 0.932839
}

// #AP4400 - After Hours Blue
#declare TS_AP4400 = spline{linear_spline
306.411, 0
370.516, 0
392.76, 0.0587555
405.268, 0.156312
423.897, 0.344002
432.983, 0.509278
439.249, 0.554297
452.022, 0.569143
461.758, 0.531402
478.122, 0.425893
498.005, 0.222586
511.187, 0.109606
527.455, 0.0341736
556.399, 0.00366318
687.815, 0.00168699
706.975, 0.0239553
725.724, 0.174049
747.366, 0.421844
769.224, 0.601967
787.974, 0.752061
797.518, 0.774473
}

// #AP4450 - Heavenly Blue
#declare TS_AP4450 = spline{linear_spline
306.329, 0
322.152, 0.0223881
356.962, 0.0298507
379.114, 0.0820896
394.937, 0.216418
413.924, 0.410448
423.418, 0.522388
432.911, 0.567164
442.405, 0.664179
464.557, 0.701493
483.544, 0.641791
496.203, 0.559701
512.025, 0.440299
534.177, 0.238806
553.165, 0.119403
565.823, 0.0746269
575.316, 0.0298507
613.291, 0.00746269
635.443, 0
644.937, 0.0298507
676.582, 0.0298507
692.405, 0.134328
714.557, 0.283582
733.544, 0.462687
752.532, 0.58209
781.013, 0.708955
803.165, 0.798507
}

// #AP4500 - Ozone Blue
#declare TS_AP4500 = spline{linear_spline
312.658, 0.00721988
315.823, 0.0738397
322.152, 0.110783
341.139, 0.140131
356.962, 0.199156
379.114, 0.361791
404.43, 0.583638
429.747, 0.731411
451.899, 0.79775
455.063, 0.775481
467.722, 0.775293
486.709, 0.708345
508.861, 0.604313
527.848, 0.433662
537.342, 0.329817
553.165, 0.277731
568.987, 0.166385
581.646, 0.106939
597.468, 0.106704
603.797, 0.099203
622.785, 0.0544773
644.937, 0.16526
657.595, 0.20211
667.089, 0.187154
676.582, 0.187014
686.076, 0.283169
692.405, 0.468261
711.392, 0.667979
727.215, 0.771449
743.038, 0.823066
762.025, 0.845007
777.848, 0.85218
800, 0.903704
}

// #AP4600 - Electric Blue
#declare TS_AP4600 = spline{linear_spline
314.388, 0
325.18, 0.109244
350.36, 0.159664
368.345, 0.252101
389.928, 0.428571
407.914, 0.579832
422.302, 0.638655
429.496, 0.731092
443.885, 0.747899
458.273, 0.798319
469.065, 0.739496
476.259, 0.747899
494.245, 0.663866
505.036, 0.563025
515.827, 0.529412
530.216, 0.411765
533.813, 0.336134
541.007, 0.294118
562.59, 0.159664
580.576, 0.0672269
598.561, 0.0840336
623.741, 0.0336134
641.727, 0.0840336
656.115, 0.201681
674.101, 0.210084
681.295, 0.226891
688.489, 0.310924
710.072, 0.655462
720.863, 0.731092
735.252, 0.815126
746.043, 0.865546
756.835, 0.882353
778.417, 0.87395
792.806, 0.890756
800, 0.915966
}

// #AP4630 - Kablueie
#declare TS_AP4630 = spline{linear_spline
309.554, 0
338.217, 0.395522
354.14, 0.58209
357.325, 0.619403
370.064, 0.634328
395.541, 0.61194
411.465, 0.708955
414.65, 0.791045
427.389, 0.776119
436.943, 0.843284
456.051, 0.768657
465.605, 0.80597
475.159, 0.791045
487.898, 0.69403
503.822, 0.634328
526.115, 0.462687
538.854, 0.395522
570.701, 0.253731
583.439, 0.186567
605.732, 0.186567
618.471, 0.156716
628.025, 0.156716
647.134, 0.402985
675.796, 0.574627
691.72, 0.776119
704.459, 0.835821
729.936, 0.880597
755.414, 0.895522
787.261, 0.895522
}

// #AP4650 - Crisp Blue
#declare TS_AP4650 = spline{linear_spline
309.615, 0
322.436, 0.151175
344.872, 0.241744
380.128, 0.415453
405.769, 0.581731
437.821, 0.725185
447.436, 0.709887
457.051, 0.74762
473.077, 0.686772
485.897, 0.66385
511.538, 0.489219
527.564, 0.367764
537.179, 0.291861
553.205, 0.200709
569.231, 0.124709
578.846, 0.116987
601.282, 0.124223
617.308, 0.0936772
623.718, 0.101156
633.333, 0.146465
652.564, 0.335567
668.59, 0.350476
678.205, 0.395785
681.41, 0.463918
691.026, 0.653166
707.051, 0.774136
729.487, 0.87228
767.949, 0.947455
787.179, 0.924437
800, 0.931818
}

// #AP4680 - Blue Moon
#declare TS_AP4680 = spline{linear_spline
313.245, 0.00769231
346.358, 0.215385
399.338, 0.584615
442.384, 0.746154
462.252, 0.684615
475.497, 0.669231
492.053, 0.553846
508.609, 0.453846
535.099, 0.292308
551.656, 0.230769
578.146, 0.107692
601.325, 0.123077
624.503, 0.0692308
644.371, 0.138462
657.616, 0.330769
677.483, 0.369231
694.04, 0.569231
707.285, 0.730769
737.086, 0.830769
763.576, 0.876923
800, 0.9
}

// #AP4700 - Timid Blue
#declare TS_AP4700 = spline{linear_spline
312.797, 0.00746269
325.139, 0.156716
347.551, 0.164179
353.889, 0.186567
372.618, 0.343284
388.045, 0.529851
403.76, 0.626866
422.799, 0.686567
445.211, 0.69403
457.96, 0.716418
470.924, 0.671642
486.926, 0.679104
509.625, 0.597015
529.095, 0.522388
542.179, 0.440299
551.89, 0.410448
564.878, 0.358209
587.266, 0.373134
603.483, 0.313433
616.447, 0.268657
632.448, 0.276119
651.56, 0.313433
667.777, 0.253731
674.235, 0.238806
683.73, 0.276119
699.086, 0.485075
711.524, 0.604478
727.215, 0.708955
736.687, 0.753731
752.641, 0.776119
774.861, 0.843284
800.335, 0.895522
}

// #AP4720 - Baby Boy Blue
#declare TS_AP4720 = spline{linear_spline
309.804, 0
326.144, 0.0685515
345.752, 0.0753914
352.288, 0.0905913
371.895, 0.120687
398.039, 0.0884633
427.451, 0.0793434
450.327, 0.0550236
496.078, 0.0141359
522.222, 0.0284238
541.83, 0.0507676
564.706, 0.0341997
581.046, 0.134215
600.654, 0.737954
616.993, 0.853473
630.065, 0.860617
643.137, 0.906521
669.281, 0.874297
682.353, 0.912449
698.693, 0.911689
718.301, 0.879769
741.176, 0.925217
760.784, 0.939808
780.392, 0.907889
800, 0.930233
}

// #AP4750 - Monday Morning Blue
#declare TS_AP4750 = spline{linear_spline
314.282, 0
331.711, 0.439603
361.244, 0.574195
397.434, 0.640765
426.725, 0.741467
462.915, 0.808037
484.096, 0.77342
532.873, 0.602275
574.51, 0.431373
588.429, 0.380053
602.953, 0.413459
624.135, 0.378843
638.78, 0.429194
646.889, 0.564512
654.757, 0.66594
684.047, 0.766642
699.298, 0.901719
742.266, 0.917211
771.072, 0.950133
799.637, 0.949165
}

// #AP4800 - Ice Blue
#declare TS_AP4800 = spline{linear_spline
313.072, 0
322.876, 0.307692
329.412, 0.369231
342.484, 0.423077
355.556, 0.446154
365.359, 0.546154
378.431, 0.576923
391.503, 0.661538
404.575, 0.684615
414.379, 0.753846
420.915, 0.738462
437.255, 0.815385
450.327, 0.807692
466.667, 0.846154
479.739, 0.792308
496.078, 0.8
522.222, 0.661538
545.098, 0.584615
564.706, 0.476923
584.314, 0.384615
597.386, 0.392308
623.529, 0.323077
636.601, 0.346154
649.673, 0.515385
659.477, 0.530769
669.281, 0.523077
688.889, 0.615385
701.961, 0.761538
721.569, 0.846154
747.712, 0.892308
770.588, 0.923077
800, 0.923077
}

// #AP4830 - Blue My Mind
#declare TS_AP4830 = spline{linear_spline
298.86, 0.330645
346.58, 0.491935
387.347, 0.669355
411.318, 0.717742
431.785, 0.782258
452.308, 0.830645
486.763, 0.83871
504.116, 0.806452
528.393, 0.766129
542.464, 0.685484
563.32, 0.637097
580.979, 0.516129
608.704, 0.475806
633.037, 0.419355
639.961, 0.41129
646.691, 0.459677
656.869, 0.508065
660.317, 0.508065
674.555, 0.379032
681.563, 0.346774
688.432, 0.354839
698.304, 0.491935
714.766, 0.717742
728.198, 0.822581
752.169, 0.870968
776.196, 0.903226
800.334, 0.903226
}

// #AP4850 - Robin's Egg Blue
#declare TS_AP4850 = spline{linear_spline
306.369, 2.22045e-16
319.417, 0.0970149
341.734, 0.104478
367.568, 0.216418
374.389, 0.358209
394.068, 0.537313
404.002, 0.656716
416.86, 0.69403
423.467, 0.768657
439.438, 0.783582
452.32, 0.828358
461.802, 0.80597
471.452, 0.835821
480.958, 0.820896
487.185, 0.776119
506.27, 0.768657
521.86, 0.664179
540.517, 0.522388
549.952, 0.485075
562.24, 0.343284
571.532, 0.261194
587.242, 0.19403
606.089, 0.11194
625.126, 0.0895522
641.097, 0.104478
654.002, 0.156716
673.063, 0.141791
682.641, 0.149254
689.224, 0.216418
699.349, 0.395522
722.283, 0.597015
741.772, 0.716418
761.166, 0.80597
783.649, 0.865672
799.572, 0.865672
}

// #AP4900 - Island Blue
#declare TS_AP4900 = spline{linear_spline
306.494, 0
316.234, 0.0150193
335.714, 0
361.688, 0.0372261
377.922, 0.098047
390.909, 0.273421
407.143, 0.402944
423.377, 0.501933
449.351, 0.585506
475.325, 0.722514
504.545, 0.744969
517.532, 0.660801
533.766, 0.56895
546.753, 0.492416
559.74, 0.324279
569.481, 0.156191
588.961, 0.0566571
611.688, 0.0181422
647.403, 0.0252305
663.636, 0.00971548
683.117, 0.0323188
699.351, 0.108407
705.844, 0.199911
722.078, 0.3218
735.065, 0.474274
761.039, 0.672351
780.519, 0.763656
796.753, 0.824477
}

// #AP4950 - Caribbean Blue
#declare TS_AP4950 = spline{linear_spline
313.071, 0
319.707, 0.030466
345.85, 0.0300638
365.633, 0.0836057
382.248, 0.167965
399.115, 0.329244
422.166, 0.382736
458.514, 0.505254
481.791, 0.627972
491.494, 0.597054
511.075, 0.58906
527.062, 0.481122
546.242, 0.350058
565.422, 0.218994
581.434, 0.118747
597.572, 0.0569604
626.932, 0.0411241
649.907, 0.0715399
669.464, 0.0558544
682.585, 0.0710372
695.958, 0.163139
716.319, 0.393595
736.579, 0.593283
756.614, 0.723744
786.401, 0.838671
799.573, 0.869237
}

// #AP4970 - Atlantic Green Blue
#declare TS_AP4970 = spline{linear_spline
303.571, 0
357.143, 0.00826446
389.286, 0.0578512
421.429, 0.157025
457.143, 0.289256
482.143, 0.380165
503.571, 0.297521
521.429, 0.198347
539.286, 0.0991736
564.286, 0.0413223
585.714, 0
675, 0.00826446
696.429, 0.0495868
700, 0.0826446
721.429, 0.256198
742.857, 0.46281
757.143, 0.595041
771.429, 0.652893
796.429, 0.752066
}

// #AP4990 - Hero Blue
#declare TS_AP4990 = spline{linear_spline
306.494, 0
355.195, 0.00679092
371.429, 0.0370774
390.909, 0.128383
416.883, 0.24249
439.61, 0.349014
459.091, 0.363983
478.571, 0.363686
498.052, 0.271785
517.532, 0.149351
533.766, 0.0422326
556.494, 0.00371766
647.403, 0.00232973
666.883, 0.0249331
686.364, 0.0628036
692.857, 0.154308
718.831, 0.466888
741.558, 0.680282
764.286, 0.763904
800, 0.832061
}

// #AP5300 - Apollo Green
#declare TS_AP5300 = spline{linear_spline
303.226, 2.22045e-16
332.258, 2.22045e-16
348.387, 0.0225564
364.516, 2.22045e-16
470.968, 2.22045e-16
487.097, 0.0526316
490.323, 0.210526
503.226, 0.203008
516.129, 0.142857
529.032, 0.0526316
558.065, 0.0075188
638.71, 2.22045e-16
654.839, 0.037594
667.742, 0.0902256
680.645, 0.0902256
706.452, 0.556391
722.581, 0.736842
748.387, 0.842105
774.194, 0.902256
796.774, 0.909774
}

// #AP5400 - Rock 'n Roll Green
#declare TS_AP5400 = spline{linear_spline
303.226, 0
458.065, 0
470.968, 0.0125611
483.871, 0.0578201
506.452, 0.216569
519.355, 0.269404
535.484, 0.231281
551.613, 0.140127
567.742, 0.0641251
590.323, 0.00317693
683.871, 0.00175953
709.677, 0.0468231
722.581, 0.160264
741.935, 0.326637
758.065, 0.508211
777.419, 0.62913
796.774, 0.704594
}

// #AP5500 - Neptune Blue Green
#declare TS_AP5500 = spline{linear_spline
306.452, 0
364.516, 0.0075188
390.323, 0.075188
419.355, 0.075188
438.71, 0.0902256
448.387, 0.112782
464.516, 0.210526
483.871, 0.511278
500, 0.481203
512.903, 0.413534
522.581, 0.285714
541.935, 0.142857
554.839, 0.0676692
567.742, 0.037594
583.871, 0.0075188
667.742, 0.0075188
690.323, 0.0300752
703.226, 0.0676692
709.677, 0.135338
722.581, 0.315789
745.161, 0.526316
764.516, 0.669173
780.645, 0.766917
800, 0.804511
}

// #AP5600 - Montego Blue Green
#declare TS_AP5600 = spline{linear_spline
309.554, 0
319.108, 0.0820896
328.662, 0.11194
338.217, 0.126866
350.955, 0.149254
370.064, 0.231343
389.172, 0.246269
405.096, 0.19403
411.465, 0.164179
424.204, 0.156716
436.943, 0.171642
446.497, 0.19403
459.236, 0.320896
484.713, 0.671642
497.452, 0.664179
513.376, 0.574627
522.93, 0.477612
532.484, 0.343284
557.962, 0.253731
570.701, 0.156716
580.255, 0.0970149
599.363, 0.0895522
615.287, 0.0522388
637.58, 0.0746269
653.503, 0.216418
672.611, 0.216418
678.981, 0.238806
685.35, 0.30597
701.274, 0.626866
710.828, 0.641791
717.197, 0.708955
742.675, 0.820896
761.783, 0.873134
787.261, 0.88806
800, 0.902985
}

// #AP5700 - Kelly Green
#declare TS_AP5700 = spline{linear_spline
306.41, 0
348.075, 0
393.233, 0.0888236
431.741, 0.103282
444.633, 0.125645
474.032, 0.298135
484.153, 0.455877
513.071, 0.477999
532.108, 0.417562
550.88, 0.274423
572.881, 0.138754
585.411, 0.0483397
610.907, 0.00284351
668.572, 0
694.38, 0.046701
710.767, 0.159237
720.719, 0.26435
733.78, 0.339342
743.901, 0.497084
769.999, 0.639549
799.301, 0.781965
}

// #AP5800 - Envy Green
#declare TS_AP5800 = spline{linear_spline
312.821, 0
322.436, 0.0298507
348.077, 0.0223881
360.897, 0.0373134
370.513, 0.0671642
392.949, 0.0522388
418.59, 0.00746269
428.205, 0.00746269
444.231, 0.0149254
460.256, 0.0970149
469.872, 0.223881
482.692, 0.552239
501.923, 0.708955
514.744, 0.671642
533.974, 0.619403
550, 0.477612
559.615, 0.440299
569.231, 0.291045
601.282, 0.126866
610.897, 0.0820896
623.718, 0.0671642
642.949, 0.0970149
665.385, 0.0373134
678.205, 0.0447761
703.846, 0.276119
729.487, 0.574627
758.333, 0.738806
780.769, 0.835821
800, 0.858209
}

// #AP5900 - Cactus Juice Green
#declare TS_AP5900 = spline{linear_spline
300, 0
319.108, 0
328.662, 0.0222222
354.14, 0.0222222
379.618, 0.0592593
414.65, 0
459.236, 0.00740741
471.975, 0.0666667
491.083, 0.703704
503.822, 0.762963
516.561, 0.711111
532.484, 0.681481
545.223, 0.548148
567.516, 0.4
583.439, 0.214815
599.363, 0.125926
615.287, 0.0814815
631.21, 0.0592593
643.949, 0.0740741
659.873, 0.0888889
682.166, 0.0444444
691.72, 0.0666667
698.089, 0.125926
714.013, 0.333333
729.936, 0.555556
752.229, 0.725926
784.076, 0.844444
803.185, 0.881481
}

// #AP5940 - Putting Green
#declare TS_AP5940 = spline{linear_spline
303.165, 0.0149254
353.797, 0.0298507
379.114, 0.0746269
401.266, 0.0597015
410.759, 0.0373134
432.911, 0.0447761
464.557, 0.0522388
483.544, 0.149254
489.873, 0.283582
499.367, 0.470149
508.861, 0.589552
521.519, 0.634328
531.013, 0.679104
543.671, 0.671642
556.329, 0.641791
568.987, 0.529851
584.81, 0.432836
597.468, 0.358209
603.797, 0.253731
619.62, 0.223881
635.443, 0.231343
648.101, 0.238806
657.595, 0.208955
660.759, 0.11194
676.582, 0.0820896
689.241, 0.11194
698.734, 0.335821
714.557, 0.552239
736.709, 0.731343
755.696, 0.858209
777.848, 0.880597
800, 0.873134
}

// #AP5960 - Margarita Green
#declare TS_AP5960 = spline{linear_spline
306.329, 0.358209
363.291, 0.462687
375.949, 0.492537
388.608, 0.432836
401.266, 0.328358
426.582, 0.208955
445.57, 0.253731
458.228, 0.365672
474.051, 0.619403
486.709, 0.798507
499.367, 0.835821
515.19, 0.813433
527.848, 0.813433
559.494, 0.738806
603.797, 0.649254
613.291, 0.619403
632.278, 0.626866
657.595, 0.567164
670.253, 0.537313
679.747, 0.567164
686.076, 0.664179
708.228, 0.783582
749.367, 0.865672
800, 0.947761
}

// #AP6100 - Chablis Yellow (No Longer Available)
#declare TS_AP6100 = spline{linear_spline
303.472, 0
318.761, 0.596774
335.814, 0.685484
352.923, 0.758065
380.757, 0.741935
405.427, 0.637097
426.512, 0.564516
440.261, 0.604839
464.427, 0.645161
474.423, 0.766129
502.117, 0.790323
508.921, 0.830645
519.226, 0.862903
533.199, 0.83871
550.392, 0.887097
567.781, 0.879032
574.838, 0.846774
592.115, 0.870968
609.392, 0.895161
630.365, 0.854839
657.891, 0.927419
682.336, 0.887097
710.114, 0.887097
720.363, 0.935484
727.195, 0.967742
744.668, 0.935484
755.169, 0.91129
789.919, 0.903226
}

// #AP6150 - Yellow Snow
#declare TS_AP6150 = spline{linear_spline
306.369, 0.626866
338.217, 0.626866
354.14, 0.626866
370.064, 0.567164
376.433, 0.470149
389.172, 0.41791
405.096, 0.402985
427.389, 0.455224
456.051, 0.61194
481.529, 0.738806
500.637, 0.798507
522.93, 0.843284
554.777, 0.873134
586.624, 0.880597
605.732, 0.880597
637.58, 0.880597
653.503, 0.880597
685.35, 0.880597
707.643, 0.880597
739.49, 0.880597
755.414, 0.880597
787.261, 0.880597
}

// #AP6200 - Banana Yellow
#declare TS_AP6200 = spline{linear_spline
290.446, 0
300, 0
312.739, 0.00746269
322.293, 0.19403
331.847, 0.298507
344.586, 0.320896
360.51, 0.291045
370.064, 0.208955
376.433, 0.0820896
382.803, 0.0223881
405.096, 0
436.943, 0
465.605, 0
481.529, 0.0373134
491.083, 0.522388
494.268, 0.626866
519.745, 0.738806
522.93, 0.80597
535.669, 0.80597
554.777, 0.850746
564.331, 0.858209
583.439, 0.843284
592.994, 0.850746
596.178, 0.88806
608.917, 0.902985
631.21, 0.850746
647.134, 0.850746
659.873, 0.895522
672.611, 0.910448
691.72, 0.895522
701.274, 0.880597
720.382, 0.91791
733.121, 0.947761
749.045, 0.932836
780.892, 0.873134
803.185, 0.895522
}

// #AP6300 - Neon Yellow
#declare TS_AP6300 = spline{linear_spline
312.739, 0
319.108, 0.0970149
325.478, 0.186567
350.955, 0.19403
363.694, 0.0970149
376.433, 0.00746269
405.096, 0
436.943, 0
465.605, 0.0223881
481.529, 0.0970149
487.898, 0.268657
494.268, 0.559701
510.191, 0.850746
526.115, 0.88806
538.854, 0.880597
551.592, 0.91791
564.331, 0.925373
589.809, 0.910448
608.917, 0.91791
631.21, 0.902985
653.503, 0.925373
682.166, 0.947761
710.828, 0.91791
742.675, 0.940299
777.707, 0.91791
800, 0.925373
}

// #AP6400 - Pilsner Yellow
#declare TS_AP6400 = spline{linear_spline
300, 0.0075188
312.739, 0.11259
319.108, 0.360615
325.478, 0.398113
347.771, 0.450409
363.694, 0.480245
379.618, 0.419855
392.357, 0.351995
417.834, 0.193717
436.943, 0.133279
456.051, 0.132992
471.975, 0.200421
491.083, 0.320435
503.822, 0.387912
538.854, 0.755807
554.777, 0.815718
580.255, 0.852928
605.732, 0.860064
634.395, 0.88219
653.503, 0.89694
685.35, 0.896461
714.013, 0.89603
745.86, 0.895551
755.414, 0.902926
787.261, 0.902447
}

// #AP6500 - Bikini Yellow
#declare TS_AP6500 = spline{linear_spline
303.185, 0
312.739, 0
322.293, 0.0298507
328.662, 0.0522388
347.771, 0.0671642
366.879, 0.0223881
376.433, 0
405.096, 0
436.943, 0
471.975, 0.00746269
484.713, 0.0522388
510.191, 0.597015
529.299, 0.738806
538.854, 0.813433
564.331, 0.865672
577.07, 0.902985
602.548, 0.865672
624.841, 0.910448
643.949, 0.91791
659.873, 0.895522
678.981, 0.932836
701.274, 0.925373
710.828, 0.895522
729.936, 0.895522
742.675, 0.947761
755.414, 0.962687
784.076, 0.932836
800, 0.910448
}

// #AP6600 - Harvest Gold
#declare TS_AP6600 = spline{linear_spline
312.658, 0
318.987, 0.474074
328.481, 0.592593
337.975, 0.659259
350.633, 0.688889
369.62, 0.674074
385.443, 0.607407
394.937, 0.540741
407.595, 0.451852
423.418, 0.392593
436.076, 0.392593
445.57, 0.422222
458.228, 0.503704
470.886, 0.666667
483.544, 0.725926
502.532, 0.777778
512.025, 0.792593
524.684, 0.748148
546.835, 0.755556
556.329, 0.740741
568.987, 0.725926
575.316, 0.755556
584.81, 0.822222
594.304, 0.888889
613.291, 0.874074
632.278, 0.874074
648.101, 0.918519
663.924, 0.903704
682.911, 0.888889
698.734, 0.911111
705.063, 0.940741
724.051, 0.940741
749.367, 0.896296
771.519, 0.925926
796.835, 0.925926
}

// #AP6700 - Whiskey Tint (No Longer Available)
#declare TS_AP6700 = spline{linear_spline
290.446, 0
322.293, 0
325.478, 0.246269
331.847, 0.335821
344.586, 0.402985
354.14, 0.425373
363.694, 0.455224
379.618, 0.455224
398.726, 0.395522
408.28, 0.320896
433.758, 0.253731
452.866, 0.261194
471.975, 0.320896
487.898, 0.380597
529.299, 0.567164
538.854, 0.701493
554.777, 0.813433
561.146, 0.850746
573.885, 0.865672
602.548, 0.865672
615.287, 0.895522
628.025, 0.895522
643.949, 0.873134
659.873, 0.895522
691.72, 0.902985
717.197, 0.902985
736.306, 0.940299
761.783, 0.910448
800, 0.91791
}

// #AP6800 - Mustard
#declare TS_AP6800 = spline{linear_spline
287.261, 0
312.739, 0
322.293, 0.186567
344.586, 0.238806
363.694, 0.246269
373.248, 0.208955
385.987, 0.134328
408.28, 0.0746269
430.573, 0.0298507
459.236, 0.0522388
475.159, 0.126866
487.898, 0.19403
497.452, 0.268657
510.191, 0.320896
522.93, 0.38806
564.331, 0.820896
570.701, 0.850746
586.624, 0.858209
615.287, 0.880597
631.21, 0.858209
640.764, 0.873134
653.503, 0.895522
675.796, 0.865672
707.643, 0.925373
717.197, 0.910448
745.86, 0.895522
761.783, 0.932836
774.522, 0.925373
796.815, 0.895522
}

// #AP6900 - Butterscotch
#declare TS_AP6900 = spline{linear_spline
284.076, 0
319.108, 0
328.662, 0.0746269
360.51, 0.119403
389.172, 0.0298507
405.096, 0.00746269
436.943, 0
462.42, 0.00746269
503.822, 0.141791
516.561, 0.208955
538.854, 0.38806
557.962, 0.746269
567.516, 0.813433
573.885, 0.858209
586.624, 0.873134
608.917, 0.858209
624.841, 0.895522
653.503, 0.880597
688.535, 0.932836
717.197, 0.902985
733.121, 0.902985
749.045, 0.947761
774.522, 0.902985
800, 0.925373
}

// #AP7050 - Fatherless Amber
#declare TS_AP7050 = spline{linear_spline
271.338, 0
312.739, 0
315.924, 0.119403
322.293, 0.179104
325.478, 0.402985
341.401, 0.455224
363.694, 0.522388
370.064, 0.544776
392.357, 0.552239
405.096, 0.544776
433.758, 0.552239
449.682, 0.567164
475.159, 0.477612
494.268, 0.470149
516.561, 0.522388
535.669, 0.58209
561.146, 0.731343
573.885, 0.865672
596.178, 0.895522
612.102, 0.880597
643.949, 0.865672
653.503, 0.865672
672.611, 0.813433
694.904, 0.850746
701.274, 0.88806
755.414, 0.947761
784.076, 0.91791
}

// #AP7100 - Hot Cocoa
#declare TS_AP7100 = spline{linear_spline
284.076, 0
315.924, 0
319.108, 0.134328
344.586, 0.141791
354.14, 0.186567
363.694, 0.231343
373.248, 0.246269
395.541, 0.216418
405.096, 0.201493
427.389, 0.149254
449.682, 0.201493
456.051, 0.223881
478.344, 0.276119
491.083, 0.283582
497.452, 0.276119
529.299, 0.261194
551.592, 0.223881
573.885, 0.283582
577.07, 0.410448
586.624, 0.477612
605.732, 0.455224
637.58, 0.447761
653.503, 0.432836
659.873, 0.365672
669.427, 0.335821
678.981, 0.358209
698.089, 0.604478
723.567, 0.731343
739.49, 0.791045
761.783, 0.88806
780.892, 0.895522
803.185, 0.865672
}

// #AP7150 - Santa Fe Amber
#declare TS_AP7150 = spline{linear_spline
277.707, 0
319.108, 0
322.293, 0.246269
354.14, 0.343284
363.694, 0.395522
376.433, 0.395522
392.357, 0.373134
456.051, 0.216418
484.713, 0.19403
503.822, 0.253731
516.561, 0.335821
526.115, 0.410448
570.701, 0.835821
577.07, 0.865672
596.178, 0.873134
612.102, 0.88806
631.21, 0.925373
653.503, 0.895522
682.166, 0.932836
694.904, 0.925373
710.828, 0.902985
736.306, 0.902985
755.414, 0.947761
784.076, 0.940299
}

// #AP7200 - Adobe Orange
#declare TS_AP7200 = spline{linear_spline
306.369, 0.00746269
315.924, 0.0149254
322.293, 0.134328
331.847, 0.223881
363.694, 0.291045
392.357, 0.298507
411.465, 0.276119
443.312, 0.268657
456.051, 0.246269
478.344, 0.19403
494.268, 0.179104
513.376, 0.216418
532.484, 0.276119
545.223, 0.335821
551.592, 0.485075
564.331, 0.544776
570.701, 0.619403
589.809, 0.843284
621.656, 0.880597
643.949, 0.925373
663.057, 0.902985
678.981, 0.91791
710.828, 0.932836
739.49, 0.925373
755.414, 0.925373
784.076, 0.947761
}

// #AP7250 - Nude Gold
#declare TS_AP7250 = spline{linear_spline
280.892, 0
306.369, 0
312.739, 0.0970149
325.478, 0.223881
328.662, 0.455224
354.14, 0.537313
370.064, 0.589552
385.987, 0.61194
405.096, 0.589552
424.204, 0.529851
456.051, 0.380597
465.605, 0.335821
475.159, 0.343284
500.637, 0.395522
519.745, 0.567164
526.115, 0.656716
554.777, 0.738806
564.331, 0.80597
570.701, 0.850746
580.255, 0.858209
605.732, 0.88806
634.395, 0.910448
659.873, 0.880597
678.981, 0.925373
704.459, 0.962687
726.752, 0.902985
745.86, 0.902985
755.414, 0.932836
787.261, 0.932836
806.369, 0.91791
825.478, 0.91791
}

// #AP7300 - Bashful Amber
#declare TS_AP7300 = spline{linear_spline
280.892, 0
312.739, 0
315.924, 0.201493
328.662, 0.298507
338.217, 0.485075
354.14, 0.514925
366.879, 0.58209
385.987, 0.641791
398.726, 0.619403
405.096, 0.634328
427.389, 0.597015
456.051, 0.462687
478.344, 0.410448
507.006, 0.38806
522.93, 0.470149
554.777, 0.589552
570.701, 0.649254
586.624, 0.768657
596.178, 0.843284
605.732, 0.902985
634.395, 0.895522
653.503, 0.940299
669.427, 0.955224
682.166, 0.925373
694.904, 0.902985
707.643, 0.91791
736.306, 0.947761
758.599, 0.910448
780.892, 0.910448
800, 0.962687
}

// #AP7330 - Rust Assured
#declare TS_AP7330 = spline{linear_spline
280.892, 0
306.346, 0
313.119, 0.119403
326.167, 0.216418
345.394, 0.253731
367.402, 0.164179
392.428, 0.0223881
405.096, 0
436.943, 0
459.259, 0.00746269
475.373, 0.0671642
485.26, 0.171642
491.867, 0.246269
498.379, 0.291045
530.226, 0.291045
565.353, 0.320896
575.145, 0.395522
591.52, 0.537313
598.127, 0.61194
611.151, 0.701493
627.241, 0.753731
659.017, 0.731343
671.518, 0.656716
687.442, 0.656716
703.603, 0.731343
716.556, 0.798507
729.509, 0.865672
742.366, 0.902985
761.403, 0.880597
793.25, 0.880597
}

// #AP7350 - Fool's Gold Amber
#declare TS_AP7350 = spline{linear_spline
277.707, 0
306.369, 0.00746269
315.924, 0.0671642
338.217, 0.0970149
363.694, 0.119403
405.096, 0.0522388
433.758, 0.0223881
471.975, 0.00746269
491.083, 0.0522388
513.376, 0.164179
522.93, 0.238806
535.669, 0.335821
551.592, 0.544776
567.516, 0.731343
583.439, 0.798507
596.178, 0.865672
602.548, 0.865672
618.471, 0.843284
628.025, 0.865672
643.949, 0.902985
675.796, 0.880597
698.089, 0.925373
710.828, 0.947761
726.752, 0.932836
749.045, 0.88806
774.522, 0.940299
800, 0.940299
}

// #AP7400 - Apollo Gold
#declare TS_AP7400 = spline{linear_spline
284.076, 0
312.739, 0.00746269
328.662, 0.395522
341.401, 0.447761
357.325, 0.492537
366.879, 0.470149
385.987, 0.41791
405.096, 0.246269
417.834, 0.179104
424.204, 0.149254
443.312, 0.156716
465.605, 0.223881
475.159, 0.350746
487.898, 0.425373
500.637, 0.447761
513.376, 0.440299
529.299, 0.402985
535.669, 0.425373
545.223, 0.462687
561.146, 0.485075
570.701, 0.537313
577.07, 0.61194
589.809, 0.828358
605.732, 0.873134
634.395, 0.865672
653.503, 0.895522
685.35, 0.902985
717.197, 0.91791
726.752, 0.947761
745.86, 0.940299
771.338, 0.902985
800, 0.925373
}

// #AP7420 - Just Peachy
#declare TS_AP7420 = spline{linear_spline
306.41, 0
338.462, 0
354.487, 0
386.538, 0.00746269
396.154, 0.0671642
415.385, 0.0895522
447.436, 0.104478
457.051, 0.126866
473.077, 0.19403
482.692, 0.298507
501.923, 0.335821
524.359, 0.283582
543.59, 0.276119
562.821, 0.208955
575.641, 0.238806
582.051, 0.447761
594.872, 0.634328
607.692, 0.753731
630.128, 0.80597
639.744, 0.835821
655.769, 0.835821
684.615, 0.865672
700.641, 0.873134
716.667, 0.895522
748.718, 0.902985
758.333, 0.895522
790.385, 0.902985
}

// #AP7450 - Golden Amber
#declare TS_AP7450 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0.00746269
385.987, 0.00746269
405.096, 0.00746269
436.943, 0
456.051, 0
487.898, 0
510.191, 0.00746269
519.745, 0.0373134
538.854, 0.126866
551.592, 0.276119
570.701, 0.597015
605.732, 0.791045
612.102, 0.820896
631.21, 0.828358
643.949, 0.873134
669.427, 0.858209
682.166, 0.895522
688.535, 0.91791
707.643, 0.895522
720.382, 0.902985
733.121, 0.932836
758.599, 0.880597
768.153, 0.873134
780.892, 0.932836
803.185, 0.955224
}

// #AP7500 - Burnt Orange
#declare TS_AP7500 = spline{linear_spline
300, 0.0895522
312.739, 0.0970149
331.847, 0.134328
354.14, 0.164179
360.51, 0.19403
379.618, 0.208955
405.096, 0.208955
433.758, 0.179104
475.159, 0.104478
503.822, 0.104478
513.376, 0.119403
529.299, 0.179104
542.038, 0.350746
551.592, 0.529851
567.516, 0.567164
580.255, 0.768657
583.439, 0.80597
602.548, 0.828358
618.471, 0.902985
628.025, 0.902985
647.134, 0.858209
656.688, 0.910448
675.796, 0.91791
698.089, 0.858209
720.382, 0.925373
752.229, 0.880597
764.968, 0.925373
793.631, 0.940299
}

// #AP7550 - Spiced Rum Amber
#declare TS_AP7550 = spline{linear_spline
293.075, 0
314.081, 0.000461681
319.968, 0.164589
340.282, 0.280009
361.404, 0.280702
383.102, 0.199446
404.917, 0.101801
419.575, 0.0203139
447.622, 0.037627
475.208, 0.120499
495.406, 0.252308
530.84, 0.220683
551.731, 0.254155
572.853, 0.254848
585.203, 0.501154
604.709, 0.731302
639.451, 0.798015
674.307, 0.848338
702.008, 0.91482
730.055, 0.932133
751.408, 0.900046
765.374, 0.916898
800.577, 0.918052
}

// #AP7570 - Trick or Treat
#declare TS_AP7570 = spline{linear_spline
306.369, 0.470149
335.032, 0.440299
357.325, 0.410448
370.064, 0.208955
385.987, 0.0746269
405.096, 0.0373134
436.943, 0.0223881
503.822, 0.0298507
522.93, 0.0373134
529.299, 0.0746269
557.962, 0.365672
577.07, 0.544776
583.439, 0.619403
605.732, 0.761194
612.102, 0.791045
628.025, 0.813433
653.503, 0.813433
678.981, 0.858209
707.643, 0.835821
717.197, 0.873134
733.121, 0.873134
755.414, 0.865672
784.076, 0.880597
}

// #AP7600 - Apollo Orange
#declare TS_AP7600 = spline{linear_spline
280.892, 0
319.108, 0
328.662, 0.0447761
354.14, 0.0597015
379.618, 0.11194
398.726, 0.11194
421.019, 0.0746269
446.497, 0.0298507
468.79, 0.00746269
500.637, 0.00746269
529.299, 0.0447761
557.962, 0.171642
573.885, 0.365672
589.809, 0.731343
605.732, 0.791045
628.025, 0.843284
640.764, 0.902985
663.057, 0.880597
675.796, 0.895522
691.72, 0.902985
707.643, 0.88806
733.121, 0.925373
758.599, 0.902985
764.968, 0.91791
774.522, 0.947761
790.446, 0.955224
}

// #AP7650 - Coral Amber
#declare TS_AP7650 = spline{linear_spline
303.185, 0
325.478, 0.395522
354.14, 0.425373
379.618, 0.440299
405.096, 0.455224
436.943, 0.470149
456.051, 0.425373
475.159, 0.373134
497.452, 0.320896
526.115, 0.335821
548.408, 0.38806
592.994, 0.768657
618.471, 0.895522
653.503, 0.91791
685.35, 0.932836
714.013, 0.925373
745.86, 0.91791
755.414, 0.91791
787.261, 0.91791
}

// #AP7670 - Salmon"illa"
#declare TS_AP7670 = spline{linear_spline
284.076, 0
344.586, 0
357.325, 0.149254
366.879, 0.223881
379.618, 0.380597
405.096, 0.380597
433.758, 0.365672
465.605, 0.268657
494.268, 0.238806
522.93, 0.223881
542.038, 0.268657
561.146, 0.320896
570.701, 0.38806
583.439, 0.679104
599.363, 0.850746
631.21, 0.88806
659.873, 0.895522
691.72, 0.873134
701.274, 0.88806
723.567, 0.91791
755.414, 0.902985
787.261, 0.895522
}

// #AP7700 - Peach Amber
#declare TS_AP7700 = spline{linear_spline
300, 0.340741
312.821, 0.311111
322.436, 0.111111
328.846, 0.340741
332.051, 0.17037
354.487, 0.00740741
360.897, 0.0592593
373.718, 0
376.923, 0.0296296
386.538, 0
399.359, 0.0222222
405.769, 0.00740741
437.821, 0.00740741
457.051, 0
489.103, 0
521.154, 0
543.59, 0
562.821, 0.0592593
591.667, 0.533333
601.282, 0.607407
607.692, 0.651852
639.744, 0.688889
665.385, 0.711111
678.205, 0.733333
694.231, 0.740741
713.462, 0.785185
742.308, 0.8
748.718, 0.82963
758.333, 0.837037
790.385, 0.82963
803.205, 0.859259
}

// #AP7750 - Sailor's Delight Orange
#declare TS_AP7750 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0
405.096, 0
436.943, 0
456.051, 0
487.898, 0
516.561, 0.0223881
526.115, 0.0447761
545.223, 0.0223881
557.962, 0.00746269
567.516, 0.0223881
573.885, 0.0671642
592.994, 0.559701
605.732, 0.761194
615.287, 0.828358
631.21, 0.895522
650.318, 0.873134
672.611, 0.910448
691.72, 0.865672
704.459, 0.910448
720.382, 0.910448
739.49, 0.873134
758.599, 0.925373
771.338, 0.955224
784.076, 0.932836
796.815, 0.895522
}

// #AP7800 - Apricot Orange
#declare TS_AP7800 = spline{linear_spline
284.076, 0
309.554, 0
319.108, 0.126866
344.586, 0.179104
354.14, 0.201493
376.433, 0.253731
405.096, 0.268657
433.758, 0.246269
456.051, 0.186567
478.344, 0.126866
507.006, 0.11194
532.484, 0.149254
542.038, 0.223881
564.331, 0.320896
573.885, 0.514925
583.439, 0.679104
596.178, 0.820896
628.025, 0.880597
653.503, 0.895522
685.35, 0.895522
701.274, 0.880597
717.197, 0.895522
745.86, 0.895522
768.153, 0.91791
796.815, 0.940299
}

// #AP7850 - Hot Lava Orange
#declare TS_AP7850 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0
405.096, 0
436.943, 0
456.051, 0
487.898, 0
519.745, 0
532.484, 0.0447761
567.516, 0.0522388
580.255, 0.156716
596.178, 0.462687
602.548, 0.731343
612.102, 0.798507
631.21, 0.865672
659.873, 0.865672
672.611, 0.895522
691.72, 0.880597
707.643, 0.91791
729.936, 0.902985
752.229, 0.932836
774.522, 0.91791
796.815, 0.947761
}

// #AP7900 - Kiss Me Tint
#declare TS_AP7900 = spline{linear_spline
280.892, 0
312.739, 0
319.108, 0.119403
328.662, 0.589552
354.14, 0.634328
385.987, 0.641791
405.096, 0.671642
433.758, 0.671642
440.127, 0.686567
456.051, 0.664179
484.713, 0.634328
494.268, 0.604478
510.191, 0.604478
516.561, 0.641791
535.669, 0.641791
554.777, 0.656716
570.701, 0.723881
586.624, 0.791045
618.471, 0.925373
631.21, 0.940299
643.949, 0.925373
666.242, 0.880597
685.35, 0.932836
691.72, 0.962687
710.828, 0.962687
736.306, 0.925373
749.045, 0.902985
761.783, 0.91791
790.446, 0.947761
}

// #AP8100 - Mango Craze
#declare TS_AP8100 = spline{linear_spline
280.892, 0
312.739, 0
322.293, 0.0372588
325.478, 0.067286
350.955, 0.0744217
373.248, 0.119199
405.096, 0.0886452
433.758, 0.0656578
478.344, 0.0123557
513.376, 0.0193477
538.854, 0.0565586
554.777, 0.0488003
577.07, 0.0484651
602.548, 0.702217
612.102, 0.78478
621.656, 0.852306
647.134, 0.897036
669.427, 0.866625
694.904, 0.903836
720.382, 0.880897
742.675, 0.933193
768.153, 0.93281
787.261, 0.909966
800, 0.924812
}

// #AP8200 - Scandalous Scarlet
#declare TS_AP8200 = spline{linear_spline
277.707, 0
315.924, 0.00740741
347.771, 0.037037
370.064, 0.0740741
405.096, 0.125926
427.389, 0.125926
475.159, 0.00740741
507.006, 0
538.854, 0
561.146, 0
580.255, 0.0962963
589.809, 0.303704
596.178, 0.377778
602.548, 0.607407
618.471, 0.718519
637.58, 0.777778
643.949, 0.82963
653.503, 0.837037
669.427, 0.82963
682.166, 0.851852
694.904, 0.874074
710.828, 0.859259
742.675, 0.851852
764.968, 0.888889
796.815, 0.896296
}

// #AP8250 - Vixen Red
#declare TS_AP8250 = spline{linear_spline
306.369, 0
338.217, 0.00746269
354.14, 0.00746269
385.987, 0
405.096, 0
436.943, 0.00746269
456.051, 0.00746269
487.898, 0
519.745, 0
554.777, 0.00746269
586.624, 0.104478
596.178, 0.238806
602.548, 0.597015
618.471, 0.731343
634.395, 0.798507
653.503, 0.835821
682.166, 0.858209
698.089, 0.88806
707.643, 0.880597
720.382, 0.850746
736.306, 0.858209
755.414, 0.880597
784.076, 0.858209
}

// #AP8300 - Diva Red
#declare TS_AP8300 = spline{linear_spline
290.446, 0
341.401, 0.0298507
354.14, 0.00746269
385.987, 0
414.65, 0.00746269
436.943, 0.0298507
456.051, 0.00746269
487.898, 0
519.745, 0
557.962, 0.00746269
583.439, 0.0447761
596.178, 0.11194
605.732, 0.5
618.471, 0.679104
637.58, 0.776119
653.503, 0.798507
682.166, 0.820896
698.089, 0.865672
707.643, 0.850746
720.382, 0.820896
733.121, 0.835821
739.49, 0.865672
755.414, 0.865672
768.153, 0.850746
780.892, 0.865672
796.815, 0.902985
}

// #AP8310 - Cherry Lewis
#declare TS_AP8310 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0
405.096, 0
436.943, 0
456.051, 0
487.898, 0
519.745, 0
567.516, 0
583.439, 0.0223881
589.809, 0.0895522
608.917, 0.328358
624.841, 0.574627
628.025, 0.656716
650.318, 0.761194
682.166, 0.776119
701.274, 0.828358
714.013, 0.850746
726.752, 0.820896
745.86, 0.873134
755.414, 0.880597
777.707, 0.835821
800, 0.880597
}

// #AP8320 - Tasty Apple Red
#declare TS_AP8320 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0
405.096, 0
436.943, 0
456.051, 0
487.898, 0
519.745, 0
554.777, 0
586.624, 0
602.548, 0.0149254
637.58, 0.604478
656.688, 0.679104
678.981, 0.716418
691.72, 0.761194
701.274, 0.768657
729.936, 0.791045
755.414, 0.813433
787.261, 0.798507
}

// #AP8350 - Bludgeon Red
#declare TS_AP8350 = spline{linear_spline
306.369, 0
338.217, 0
354.14, 0
385.987, 0
405.096, 0
436.943, 0
456.051, 0
487.898, 0
519.745, 0
554.777, 0
586.624, 0
596.178, 0.00746269
618.471, 0.186567
637.58, 0.402985
653.503, 0.410448
669.427, 0.350746
672.611, 0.320896
682.166, 0.373134
698.089, 0.641791
720.382, 0.738806
749.045, 0.776119
755.414, 0.791045
777.707, 0.843284
800, 0.865672
}

// #AP8400 - Lipstick Red
#declare TS_AP8400 = spline{linear_spline
280.892, 0
306.369, 0
312.739, 0.0746269
319.108, 0.104478
354.14, 0.0522388
382.803, 0.0298507
405.096, 0.0373134
433.758, 0.0597015
471.975, 0.00746269
503.822, 0
535.669, 0
554.777, 0.00746269
567.516, 0.0223881
580.255, 0.0671642
592.994, 0.126866
628.025, 0.731343
653.503, 0.768657
672.611, 0.828358
685.35, 0.843284
698.089, 0.820896
707.643, 0.820896
717.197, 0.858209
729.936, 0.873134
755.414, 0.843284
774.522, 0.88806
800, 0.902985
}

// #AP8430 - Front Rose
#declare TS_AP8430 = spline{linear_spline
300, 0.0970149
309.554, 0.141791
319.108, 0.216418
331.847, 0.365672
360.51, 0.544776
373.248, 0.61194
392.357, 0.746269
408.28, 0.746269
424.204, 0.656716
433.758, 0.589552
456.051, 0.425373
465.605, 0.350746
484.713, 0.156716
503.822, 0.0373134
516.561, 0.00746269
548.408, 0
567.516, 0.0149254
586.624, 0.462687
605.732, 0.761194
615.287, 0.835821
628.025, 0.902985
653.503, 0.91791
685.35, 0.925373
717.197, 0.925373
749.045, 0.925373
755.414, 0.925373
787.261, 0.925373
}

// #AP8440 - Watermelon Wine
#declare TS_AP8440 = spline{linear_spline
306.369, 0.420957
328.662, 0.375509
347.771, 0.315071
366.879, 0.284709
398.726, 0.276711
417.834, 0.283942
436.943, 0.231023
459.236, 0.110387
481.529, 0.0724582
510.191, 0.041952
538.854, 0.0565586
561.146, 0.071261
567.516, 0.0937216
589.809, 0.597146
612.102, 0.754705
615.287, 0.807289
628.025, 0.814616
647.134, 0.80681
653.503, 0.844308
666.242, 0.874192
678.981, 0.858963
691.72, 0.851252
707.643, 0.903644
726.752, 0.903357
742.675, 0.873042
764.968, 0.91782
777.707, 0.925147
796.815, 0.879747
}

// #AP8445 - Flamingo Pink
#declare TS_AP8445 = spline{linear_spline
306.369, 0.649254
338.217, 0.649254
354.14, 0.649254
385.987, 0.656716
414.65, 0.619403
459.236, 0.320896
475.159, 0.268657
494.268, 0.208955
519.745, 0.186567
548.408, 0.223881
567.516, 0.253731
586.624, 0.514925
605.732, 0.731343
618.471, 0.798507
637.58, 0.858209
653.503, 0.873134
685.35, 0.880597
707.643, 0.880597
739.49, 0.880597
755.414, 0.880597
787.261, 0.873134
}

// #AP8450 - Spanked Pink
#declare TS_AP8450 = spline{linear_spline
280.892, 0
309.554, 0
312.739, 0.134328
322.293, 0.365672
328.662, 0.402985
344.586, 0.41791
354.14, 0.492537
370.064, 0.514925
395.541, 0.559701
405.096, 0.58209
430.573, 0.58209
462.42, 0.38806
497.452, 0.276119
510.191, 0.238806
522.93, 0.246269
554.777, 0.335821
564.331, 0.402985
589.809, 0.776119
605.732, 0.835821
634.395, 0.858209
656.688, 0.880597
688.535, 0.91791
707.643, 0.947761
717.197, 0.932836
739.49, 0.88806
761.783, 0.925373
774.522, 0.940299
790.446, 0.91791
}

// #AP8500 - Tease Pink
#declare TS_AP8500 = spline{linear_spline
280.892, 0
312.739, 0
319.108, 0.0223881
322.293, 0.365672
328.662, 0.395522
331.847, 0.440299
347.771, 0.447761
360.51, 0.485075
370.064, 0.537313
392.357, 0.58209
405.096, 0.597015
417.834, 0.61194
430.573, 0.597015
443.312, 0.574627
456.051, 0.5
475.159, 0.470149
497.452, 0.320896
519.745, 0.276119
548.408, 0.253731
564.331, 0.246269
570.701, 0.350746
583.439, 0.477612
586.624, 0.686567
596.178, 0.820896
605.732, 0.828358
631.21, 0.865672
653.503, 0.925373
678.981, 0.902985
698.089, 0.925373
723.567, 0.940299
752.229, 0.895522
768.153, 0.895522
800, 0.962687
}

// #AP8530 - Pink Pong
#declare TS_AP8530 = spline{linear_spline
274.522, 0
312.739, 0
328.662, 0.5
354.14, 0.529851
379.618, 0.58209
405.096, 0.626866
433.758, 0.656716
456.051, 0.634328
481.529, 0.589552
503.822, 0.470149
513.376, 0.41791
522.93, 0.410448
542.038, 0.410448
551.592, 0.343284
570.701, 0.358209
602.548, 0.828358
618.471, 0.895522
634.395, 0.91791
647.134, 0.895522
659.873, 0.880597
678.981, 0.925373
694.904, 0.925373
714.013, 0.880597
733.121, 0.880597
749.045, 0.925373
768.153, 0.910448
800, 0.895522
}

// #AP8550 - Bit of Pink
#declare TS_AP8550 = spline{linear_spline
277.707, 0
309.554, 0
325.478, 0.626866
338.217, 0.649254
347.771, 0.641791
357.325, 0.686567
370.064, 0.679104
373.248, 0.731343
382.803, 0.746269
395.541, 0.731343
405.096, 0.776119
430.573, 0.791045
440.127, 0.753731
449.682, 0.768657
468.79, 0.686567
491.083, 0.671642
507.006, 0.604478
513.376, 0.574627
529.299, 0.574627
554.777, 0.529851
567.516, 0.58209
586.624, 0.776119
599.363, 0.843284
615.287, 0.895522
647.134, 0.910448
653.503, 0.902985
685.35, 0.910448
694.904, 0.91791
726.752, 0.940299
755.414, 0.940299
787.261, 0.932836
}

// #AP8600 - Cotton Candy Pink
#declare TS_AP8600 = spline{linear_spline
284.076, 0
306.369, 0
309.554, 0.19403
315.924, 0.238806
328.662, 0.567164
331.847, 0.597015
354.14, 0.604478
363.694, 0.671642
373.248, 0.686567
382.803, 0.731343
392.357, 0.716418
405.096, 0.746269
417.834, 0.731343
424.204, 0.753731
430.573, 0.768657
446.497, 0.723881
465.605, 0.649254
491.083, 0.61194
500.637, 0.552239
526.115, 0.492537
545.223, 0.507463
564.331, 0.5
583.439, 0.761194
592.994, 0.835821
602.548, 0.880597
621.656, 0.843284
631.21, 0.895522
650.318, 0.91791
672.611, 0.873134
694.904, 0.932836
710.828, 0.940299
729.936, 0.895522
752.229, 0.895522
764.968, 0.925373
793.631, 0.940299
}

// #AP8630 - V.I.Pink
#declare TS_AP8630 = spline{linear_spline
296.815, 0
322.293, 0.148148
331.847, 0.214815
354.14, 0.355556
363.694, 0.422222
382.803, 0.518519
405.096, 0.555556
436.943, 0.57037
462.42, 0.444444
471.975, 0.377778
481.529, 0.296296
507.006, 0.192593
510.191, 0.155556
529.299, 0.162963
554.777, 0.140741
564.331, 0.133333
570.701, 0.185185
605.732, 0.762963
615.287, 0.82963
621.656, 0.859259
640.764, 0.866667
653.503, 0.881481
666.242, 0.896296
694.904, 0.866667
720.382, 0.911111
745.86, 0.911111
758.599, 0.866667
768.153, 0.837037
784.076, 0.822222
803.185, 0.814815
}

// #AP8650 - In the Pink
#declare TS_AP8650 = spline{linear_spline
277.707, 0
319.108, 0
328.662, 0.38806
338.217, 0.410448
354.14, 0.365672
370.064, 0.425373
382.803, 0.529851
405.096, 0.544776
417.834, 0.567164
430.573, 0.544776
446.497, 0.574627
462.42, 0.514925
471.975, 0.492537
481.529, 0.455224
491.083, 0.380597
516.561, 0.149254
535.669, 0.119403
548.408, 0.0597015
561.146, 0.0373134
573.885, 0.134328
589.809, 0.350746
602.548, 0.604478
612.102, 0.738806
624.841, 0.80597
631.21, 0.843284
643.949, 0.858209
663.057, 0.895522
694.904, 0.895522
736.306, 0.932836
764.968, 0.910448
793.631, 0.902985
}

// #AP8680 - Pinkerbell
#declare TS_AP8680 = spline{linear_spline
287.261, 0
309.554, 0
319.108, 0.485075
328.662, 0.58209
347.771, 0.597015
354.14, 0.649254
373.248, 0.686567
379.618, 0.738806
395.541, 0.746269
405.096, 0.768657
430.573, 0.791045
449.682, 0.753731
468.79, 0.753731
494.268, 0.671642
513.376, 0.619403
519.745, 0.597015
542.038, 0.597015
551.592, 0.567164
564.331, 0.559701
583.439, 0.708955
605.732, 0.798507
634.395, 0.813433
653.503, 0.835821
678.981, 0.828358
698.089, 0.895522
710.828, 0.910448
726.752, 0.902985
758.599, 0.895522
777.707, 0.91791
796.815, 0.932836
}

// #AP8700 - Tickled Pink
#declare TS_AP8700 = spline{linear_spline
284.076, 0
312.739, 0
322.293, 0.425373
325.478, 0.559701
335.032, 0.61194
354.14, 0.61194
363.694, 0.641791
376.433, 0.649254
389.172, 0.69403
395.541, 0.679104
408.28, 0.69403
417.834, 0.656716
427.389, 0.686567
449.682, 0.701493
456.051, 0.738806
471.975, 0.69403
494.268, 0.69403
500.637, 0.634328
510.191, 0.567164
519.745, 0.492537
538.854, 0.462687
554.777, 0.38806
561.146, 0.373134
570.701, 0.41791
586.624, 0.716418
605.732, 0.783582
624.841, 0.835821
631.21, 0.865672
653.503, 0.858209
672.611, 0.850746
682.166, 0.880597
704.459, 0.925373
714.013, 0.932836
733.121, 0.91791
752.229, 0.895522
771.338, 0.925373
796.815, 0.940299
}

// #AP8710 - Rebecca's Pink Ribbon
#declare TS_AP8710 = spline{linear_spline
300, 0.365672
325.478, 0.544776
335.032, 0.619403
354.14, 0.738806
360.51, 0.783582
373.248, 0.791045
405.096, 0.783582
433.758, 0.746269
446.497, 0.723881
465.605, 0.604478
497.452, 0.373134
522.93, 0.276119
529.299, 0.238806
548.408, 0.238806
561.146, 0.291045
580.255, 0.425373
605.732, 0.731343
618.471, 0.798507
637.58, 0.858209
653.503, 0.873134
685.35, 0.880597
707.643, 0.880597
739.49, 0.880597
755.414, 0.880597
787.261, 0.873134
}

// #AP8730 - Screamin' Pink
#declare TS_AP8730 = spline{linear_spline
290.446, 0.0373134
303.185, 0.0895522
325.478, 0.283582
338.217, 0.395522
357.325, 0.5
370.064, 0.552239
379.618, 0.679104
401.911, 0.723881
414.65, 0.708955
424.204, 0.671642
436.943, 0.604478
456.051, 0.425373
462.42, 0.350746
475.159, 0.253731
484.713, 0.186567
507.006, 0.0671642
532.484, 0.0298507
570.701, 0.0597015
577.07, 0.141791
583.439, 0.410448
608.917, 0.768657
618.471, 0.835821
628.025, 0.895522
656.688, 0.91791
688.535, 0.91791
707.643, 0.91791
739.49, 0.91791
755.414, 0.91791
787.261, 0.91791
}

// #AP8750 - Hot Pink
#declare TS_AP8750 = spline{linear_spline
293.631, 0
319.108, 0
325.478, 0.0820896
335.032, 0.149254
360.51, 0.119403
376.433, 0.186567
389.172, 0.253731
401.911, 0.30597
411.465, 0.328358
433.758, 0.335821
443.312, 0.298507
459.236, 0.261194
471.975, 0.19403
491.083, 0.0522388
503.822, 0.00746269
535.669, 0
580.255, 0
599.363, 0.164179
605.732, 0.455224
624.841, 0.731343
637.58, 0.798507
653.503, 0.835821
682.166, 0.865672
707.643, 0.873134
726.752, 0.910448
761.783, 0.91791
800, 0.895522
}

// #AP8800 - Sassy Pink
#declare TS_AP8800 = spline{linear_spline
277.707, 0
319.108, 0
325.478, 0.208955
328.662, 0.365672
350.955, 0.395522
363.694, 0.373134
373.248, 0.485075
405.096, 0.589552
414.65, 0.619403
427.389, 0.604478
436.943, 0.641791
456.051, 0.649254
465.605, 0.58209
478.344, 0.529851
494.268, 0.380597
522.93, 0.126866
557.962, 0.0298507
580.255, 0.0447761
592.994, 0.268657
599.363, 0.5
605.732, 0.597015
618.471, 0.619403
634.395, 0.664179
637.58, 0.753731
653.503, 0.791045
672.611, 0.850746
694.904, 0.925373
704.459, 0.925373
717.197, 0.895522
733.121, 0.895522
755.414, 0.932836
777.707, 0.925373
800, 0.88806
}

// #AP8840 - Ruby Slippers
#declare TS_AP8840 = spline{linear_spline
306.369, 0
338.217, 0
366.879, 0.0223881
395.541, 0.0522388
427.389, 0.0895522
452.866, 0.0970149
462.42, 0.0373134
478.344, 0.00746269
510.191, 0
542.038, 0
580.255, 0.0149254
596.178, 0.11194
615.287, 0.604478
637.58, 0.791045
653.503, 0.843284
682.166, 0.843284
694.904, 0.88806
710.828, 0.880597
720.382, 0.843284
736.306, 0.850746
764.968, 0.873134
800, 0.902985
}

// #AP8850 - Apollo Magenta
#declare TS_AP8850 = spline{linear_spline
306.369, 0
338.217, 0
370.064, 0.0223881
398.726, 0.0597015
421.019, 0.0970149
446.497, 0.0597015
456.051, 0.0373134
471.975, 0.00746269
503.822, 0
535.669, 0
554.777, 0
586.624, 0.00746269
596.178, 0.0447761
612.102, 0.156716
621.656, 0.223881
637.58, 0.373134
643.949, 0.447761
672.611, 0.761194
691.72, 0.820896
717.197, 0.858209
729.936, 0.902985
749.045, 0.910448
758.599, 0.88806
780.892, 0.940299
800, 0.955224
}

// #AP8900 - Passion Pink
#declare TS_AP8900 = spline{linear_spline
277.564, 0
319.231, 0
334.969, 0.0895522
357.477, 0.0671642
370.226, 0.0895522
376.469, 0.141791
395.508, 0.201493
405.052, 0.223881
417.777, 0.253731
430.573, 0.261194
456.31, 0.231343
469.346, 0.164179
492.164, 0.0447761
508.309, 0.00746269
540.385, 0
556.41, 0
588.438, 0.00746269
600.875, 0.126866
615.92, 0.432836
637.471, 0.708955
653.306, 0.768657
678.827, 0.80597
697.819, 0.880597
707.386, 0.895522
723.507, 0.865672
752.234, 0.902985
771.465, 0.902985
797.297, 0.843284
}

// #AP3520 - Alexander The Grape
#declare TS_AP3520 = spline{linear_spline
300, 0.208791
309.434, 0.241758
318.868, 0.747253
323.585, 0.230769
337.736, 0.494505
342.453, 0.32967
361.321, 0.307692
370.755, 0.428571
389.623, 0.516484
408.491, 0.604396
422.642, 0.67033
432.075, 0.758242
455.66, 0.769231
479.245, 0.659341
488.679, 0.549451
498.113, 0.505495
512.264, 0.384615
521.698, 0.252747
550, 0.120879
573.585, 0.0659341
597.17, 0.131868
606.604, 0.142857
625.472, 0.10989
639.623, 0.175824
649.057, 0.241758
658.491, 0.615385
663.208, 0.747253
677.358, 0.835165
696.226, 0.901099
738.679, 0.89011
762.264, 0.923077
785.849, 0.89011
800, 0.89011
}

// #AP4130 - Blurple
#declare TS_AP4130 = spline{linear_spline
304.717, 0.977778
314.151, 0.522222
314.151, 0.522222
333.019, 0.511111
342.453, 0.3
356.604, 0.222222
384.906, 0.288889
413.208, 0.366667
436.792, 0.477778
460.377, 0.411111
479.245, 0.311111
493.396, 0.222222
512.264, 0.133333
526.415, 0.0444444
559.434, 0.0111111
606.604, 0.0111111
644.34, 0
658.491, 0.177778
677.358, 0.666667
691.509, 0.755556
700.943, 0.844444
715.094, 0.844444
752.83, 0.877778
800, 0.888889
}

// #AP4870 - Bluetylicious
#declare TS_AP4870 = spline{linear_spline
297.097, 0.615385
314.047, 0.021978
326.695, 0.340659
346.651, 0.10989
351.006, 0.186813
360.388, 0.197802
364.846, 0.252747
374.228, 0.263736
378.893, 0.274725
388.016, 0.340659
406.469, 0.428571
420.568, 0.43956
439.229, 0.483516
462.14, 0.626374
475.928, 0.703297
495.159, 0.626374
500.238, 0.549451
514.597, 0.505495
529.681, 0.307692
548.963, 0.21978
573.274, 0.0659341
606.396, 0.043956
629.981, 0.043956
648.435, 0.131868
657.713, 0.164835
676.581, 0.164835
689.592, 0.406593
707.371, 0.637363
735.103, 0.758242
758.221, 0.857143
781.806, 0.857143
796.009, 0.846154
}

// #AP5430 - Green Gello
#declare TS_AP5430 = spline{linear_spline
304.717, 0.010989
314.151, 0.285714
318.868, 0.120879
323.585, 0.0989011
333.019, 0.021978
351.887, 0.0659341
366.038, 0.010989
380.189, 0.010989
394.34, 0
465.094, 0
488.679, 0.043956
498.113, 0.131868
502.83, 0.252747
521.698, 0.340659
531.132, 0.307692
545.283, 0.164835
559.434, 0.0549451
583.019, 0
700.943, 0
719.811, 0.0659341
738.679, 0.186813
757.547, 0.362637
776.415, 0.538462
804.717, 0.703297
}

// #AP7630 - Peach My Interest
#declare TS_AP7630 = spline{linear_spline
300, 0.933333
309.524, 0.911111
314.286, 0.622222
323.81, 0.966667
328.571, 0.611111
338.095, 0.822222
342.857, 0.666667
366.667, 0.644444
371.429, 0.633333
380.952, 0.655556
385.714, 0.622222
395.238, 0.644444
409.524, 0.622222
423.81, 0.622222
476.19, 0.488889
509.524, 0.477778
552.381, 0.588889
557.143, 0.633333
576.19, 0.744444
595.238, 0.844444
609.524, 0.888889
628.571, 0.855556
638.095, 0.844444
657.143, 0.911111
671.429, 0.922222
695.238, 0.877778
728.571, 0.955556
752.381, 0.9
780.952, 0.888889
795.238, 0.922222
}

// #AP7770 - Hot Wings
#declare TS_AP7770 = spline{linear_spline
298.344, 0.344444
308.12, 0.311111
318.75, 0.1
327.244, 0.333333
332.105, 0.322222
352.885, 0
357.479, 0.0444444
372.062, 0.0111111
386.592, 0
550, 0
568.75, 0.1
572.543, 0.311111
585.844, 0.544444
604.647, 0.633333
623.665, 0.677778
642.842, 0.688889
666.72, 0.722222
685.897, 0.733333
709.722, 0.777778
728.9, 0.788889
747.97, 0.822222
786.378, 0.833333
795.94, 0.844444
}

//=============================================================
       
#version tspd_apollogels_Inc_Temp;
#end // eof
