#declare Global_TheatreSys_Unit = 4; // feet
#include "../theatresys.inc"
#include "../tspd_roscolux.inc"
#include "../wood_figure.inc"
#include "../PowersTheatre.inc"

#declare Lightsys_Brightness = 1/100;

global_settings{
	#if(version<3.7)
		assumed_gamma 1.0
	#end
	radiosity{}
}

// Create the Theatre
InsertPowersTheatre()
InsertMasking(2,1)
InsertMasking(3,1)
InsertMasking(4,1)
InsertMasking(5,1)
InsertCyc(25)

// sit in the audience and look at the stage
SitAudienceCenter()

// Create figures to light
WoodFigure(<0,0,5>)
WoodFigure(<-4,0,8>)
WoodFigure(<4,0,16>)

#declare C1 = 1; // circuit for top R68
#declare C2 = 0.35; // circuit for top R08
#declare C3 = 0.8; // circuit for front lights

#declare C10 = 0.1; // circuit for the red cyc channel
#declare C11 = 0.4; // circuit for the green cyc channel
#declare C12 = 0.7; // circuit for the blue cyc channel

// Put 40-degree instruments on each electric, pointing down
// Put both R68 and R08 instruments next to each other, 5 per electric
#local elec = 0;
#local maxpos = 1;
#local stagewidth = 32;
#local numinstr = 5;
#while(elec<=4)
	#local pos = -1;
	#while(pos<=maxpos)
		#local position = ElectricPosition(elec,pos*(stagewidth/2*0.8));
		#local floorposition = <position.x,0,position.z>;
			Shakespeare_S640(position-0.5*x,floorposition,C1,0.25)
			InsertGel(TS_R68)
			Shakespeare_S640(position+0.5*x,floorposition,C2,0.25)
			InsertGel(TS_R08)
		#local pos=pos+2/(numinstr-1);
	#end
	#local elec=elec+1;
#end

// Add some front light, R16, on the first few electrics
#local elec = 0;
#local maxelec = 3;
#local pos = -1;
#local numinstr = 3;
#while (elec < maxelec)
	#local pos = -1;
	#while(pos<=maxpos)
		#local position = ElectricPosition(elec,pos*(stagewidth/2*0.8));
		#local floorposition = <position.x,0,position.z+5>;
			Shakespeare_S650(position,floorposition,C3,0.5)
			InsertGel(TS_R16)
		#local pos=pos+2/(numinstr-1);
	#end
	#local elec = elec+1;
#end

// Add a sky-colored cyc wash
#local stripCircuits=array[3] {C10,C11,C12}
#local stripColors=array[3] {TS_R27,TS_R91,TS_R80}
#local pos=-3;
#while (pos<=3)// Top Cyc Wash
	PAR38_6ft_3ckt(<6.1*pos,25.5,21>,x,<6.1*pos,10.5,25>,stripCircuits,"PAR38_250FL",stripColors)
	#local pos = pos+1;
#end
