#declare Global_TheatreSys_Unit = 4; // feet
#include "../theatresys.inc"
#include "../tspd_roscolux.inc"
#include "../wood_figure.inc"

#declare Lightsys_Brightness = 1/100;

global_settings{
	#if(version<3.7)
		assumed_gamma 1.0
	#end
}

// Create ground plane
plane{y,0 texture{BlackPaintTexture}}

// Create figure to light
WoodFigure(0)

// Put a 26degree instrument directly above the figure,
//	pointing at the head, and with a soft edge
SourceFour_26(20*y,6*y,1,0.5)
// Make it primary blue (Roscolux #80)
InsertGel(TS_R80)

// stand 10 feet in front of the figure, a bit to the side
// look at the torso
camera{
	location <2,6,-10>
	look_at <0,4,0>
}

// Put a 19 degree instrument just to the left of the camera
// Point it at the head, give it a hard edge, make it 1% brightness
SourceFour_19(<1,6,-10>,<0,5.5,0>,0.01,1)
// Give it a slightly rose tint (Roscolux #05)
InsertGel(TS_R05)
