#declare Global_TheatreSys_Unit = 4; // feet
#include "../theatresys.inc"
#include "../tspd_roscolux.inc"
#include "../wood_figure.inc"

#declare Lightsys_Brightness = 1/50;

global_settings{
	#if(version<3.7)
		assumed_gamma 1.0
	#end
	radiosity{}
}

// Create ground plane
plane{y,0 texture{BlackPaintTexture}}

// Create figure to light
WoodFigure(0)

// Put a 26degree instrument directly above the figure,
//	pointing at the head, and with a soft edge
SourceFour_26(20*y,6*y,1,0.5)
// Make it primary blue (Roscolux #80)
InsertGel(TS_R80)

// stand 10 feet in front of the figure, a bit to the side
// look at the torso
camera{
	location <2,6,-10>
	look_at <0,4,0>
}

// Add red front light pointing up
SourceFour_36(<0,0.1,-2>,<0,4,0>,0.2,0.3)
InsertGel(TS_R26)

// Create another figure
WoodFigure(<-3,0,0>)


// Give it some better looking light,
#declare Use_Soft_Shadows=1;
#declare Gobo_Blur_Amount=10;
SourceFour_36(<-2,20,-20>,<-3,4,0>,0.5,0.5)
// Make it a more natural color
InsertGel(TS_R06)
// Cut it off the other figure
ShutterCutRight(0.82,0)


// Add another light with a green leafy pattern
#local leafGobo = pigment{image_map{jpeg "77805.jpg" once filter all 1}} //http://www.rosco.com/images/Gobos/Steel/Large/77805.jpg
SourceFour_26(<-4,20,-20>,<-3,4,0>,0.5,0.5)
InsertGobo(leafGobo,0)
ShutterCutRight(0.82,0)
InsertGel(TS_R386)
