/*
  Persistence of Vision Ray Tracer include file
  
  PowersTheatre
  - Provides a basic proscenium theatre space with a smoothed triangle mesh.

  Modeled after the Harvey M. Powers Theatre at Bucknell Unversity.
  
  Original Vectorworks model by Heath Hansum
  Converted to stl and modified by Christopher Shake
*/
#ifndef(POWERSTHEATRE_INC_TEMP)
#declare POWERSTHEATRE_INC_TEMP = version;
#version 3.5;

#include "PowersPositions.inc"
// Gives a proscenium theatre with centerline/plasterline at <0,0,0>
// Unit = cm unless GlobalTheaterSysUnit has been defined and theatersys.inc already included
#macro PowersTheatre()
  #ifndef(UnitMult)
    #local UnitMult = 1;
  #end
  object{m_PowersTheatre scale <1,1,-1>*UnitMult}
#end

// Name of the solid: PowersTheatre
// Generated by stl2pov 2.4.2 on Tue Mar 10 18:15:31 2009
// ! Warning: some edges are not used by two triangles.
//   (There might be visible gaps between triangles.)
#declare m_PowersTheatre = mesh {
  triangle { // #1
		<-503.35,0,-29.65>,
		<-542.95,0,-29.65>,
		<-503.35,0,-30.9>
  }
  triangle { // #2
		<-548.5,0,-29.65>,
		<-548.5,0,-30.9>,
		<-544.2,0,-29.65>
  }
  triangle { // #3
		<-548.5,0,-30.9>,
		<-503.35,0,-30.9>,
		<-544.2,0,-29.65>
  }
  triangle { // #4
		<-544.2,0,-12.05>,
		<-544.2,0,-29.65>,
		<-542.95,0,-12.05>
  }
  triangle { // #5
		<-542.95,0,-12.05>,
		<-544.2,0,-29.65>,
		<-542.95,0,-29.65>
  }
  triangle { // #6
		<-544.2,0,-29.65>,
		<-503.35,0,-30.9>,
		<-542.95,0,-29.65>
  }
  triangle { // #7
		<-503.35,694.05,-29.65>,
		<-503.35,694.05,-30.9>,
		<-542.95,694.05,-29.65>
  }
  triangle { // #8
		<-548.5,694.05,-29.65>,
		<-544.2,694.05,-29.65>,
		<-548.5,694.05,-30.9>
  }
  triangle { // #9
		<-548.5,694.05,-30.9>,
		<-544.2,694.05,-29.65>,
		<-503.35,694.05,-30.9>
  }
  triangle { // #10
		<-542.95,694.05,-12.05>,
		<-542.95,694.05,-29.65>,
		<-544.2,694.05,-12.05>
  }
  triangle { // #11
		<-544.2,694.05,-12.05>,
		<-542.95,694.05,-29.65>,
		<-544.2,694.05,-29.65>
  }
  triangle { // #12
		<-544.2,694.05,-29.65>,
		<-542.95,694.05,-29.65>,
		<-503.35,694.05,-30.9>
  }
  triangle { // #13
		<-544.2,0,-12.05>,
		<-544.2,694.05,-12.05>,
		<-544.2,0,-29.65>
  }
  triangle { // #14
		<-544.2,694.05,-29.65>,
		<-544.2,0,-29.65>,
		<-544.2,694.05,-12.05>
  }
  triangle { // #15
		<-542.95,0,-12.05>,
		<-542.95,694.05,-12.05>,
		<-544.2,0,-12.05>
  }
  triangle { // #16
		<-544.2,694.05,-12.05>,
		<-544.2,0,-12.05>,
		<-542.95,694.05,-12.05>
  }
  triangle { // #17
		<-542.95,0,-29.65>,
		<-542.95,694.05,-29.65>,
		<-542.95,0,-12.05>
  }
  triangle { // #18
		<-542.95,694.05,-12.05>,
		<-542.95,0,-12.05>,
		<-542.95,694.05,-29.65>
  }
  triangle { // #19
		<-503.35,0,-29.65>,
		<-503.35,694.05,-29.65>,
		<-542.95,0,-29.65>
  }
  triangle { // #20
		<-542.95,694.05,-29.65>,
		<-542.95,0,-29.65>,
		<-503.35,694.05,-29.65>
  }
  triangle { // #21
		<-503.35,0,-30.9>,
		<-503.35,694.05,-30.9>,
		<-503.35,0,-29.65>
  }
  triangle { // #22
		<-503.35,694.05,-29.65>,
		<-503.35,0,-29.65>,
		<-503.35,694.05,-30.9>
  }
  triangle { // #23
		<-548.5,0,-30.9>,
		<-548.5,694.05,-30.9>,
		<-503.35,0,-30.9>
  }
  triangle { // #24
		<-503.35,694.05,-30.9>,
		<-503.35,0,-30.9>,
		<-548.5,694.05,-30.9>
  }
  triangle { // #25
		<-548.5,0,-29.65>,
		<-548.5,694.05,-29.65>,
		<-548.5,0,-30.9>
  }
  triangle { // #26
		<-548.5,694.05,-30.9>,
		<-548.5,0,-30.9>,
		<-548.5,694.05,-29.65>
  }
  triangle { // #27
		<-544.2,0,-29.65>,
		<-544.2,694.05,-29.65>,
		<-548.5,0,-29.65>
  }
  triangle { // #28
		<-548.5,694.05,-29.65>,
		<-548.5,0,-29.65>,
		<-544.2,694.05,-29.65>
  }
  triangle { // #29
		<512.4,-5.85,-30.9>,
		<552,-5.85,-29.65>,
		<512.4,-5.85,-29.65>
  }
  triangle { // #30
		<553.25,-5.85,-29.65>,
		<557.5,-5.85,-30.9>,
		<557.5,-5.85,-29.65>
  }
  triangle { // #31
		<553.25,-5.85,-29.65>,
		<512.4,-5.85,-30.9>,
		<557.5,-5.85,-30.9>
  }
  triangle { // #32
		<552,-5.85,-12.05>,
		<553.25,-5.85,-29.65>,
		<553.25,-5.85,-12.05>
  }
  triangle { // #33
		<552,-5.85,-29.65>,
		<553.25,-5.85,-29.65>,
		<552,-5.85,-12.05>
  }
  triangle { // #34
		<552,-5.85,-29.65>,
		<512.4,-5.85,-30.9>,
		<553.25,-5.85,-29.65>
  }
  triangle { // #35
		<552,694.05,-29.65>,
		<512.4,694.05,-30.9>,
		<512.4,694.05,-29.65>
  }
  triangle { // #36
		<557.5,694.05,-30.9>,
		<553.25,694.05,-29.65>,
		<557.5,694.05,-29.65>
  }
  triangle { // #37
		<512.4,694.05,-30.9>,
		<553.25,694.05,-29.65>,
		<557.5,694.05,-30.9>
  }
  triangle { // #38
		<553.25,694.05,-12.05>,
		<552,694.05,-29.65>,
		<552,694.05,-12.05>
  }
  triangle { // #39
		<553.25,694.05,-29.65>,
		<552,694.05,-29.65>,
		<553.25,694.05,-12.05>
  }
  triangle { // #40
		<512.4,694.05,-30.9>,
		<552,694.05,-29.65>,
		<553.25,694.05,-29.65>
  }
  triangle { // #41
		<553.25,-5.85,-29.65>,
		<553.25,694.05,-12.05>,
		<553.25,-5.85,-12.05>
  }
  triangle { // #42
		<553.25,694.05,-12.05>,
		<553.25,-5.85,-29.65>,
		<553.25,694.05,-29.65>
  }
  triangle { // #43
		<553.25,-5.85,-12.05>,
		<552,694.05,-12.05>,
		<552,-5.85,-12.05>
  }
  triangle { // #44
		<552,694.05,-12.05>,
		<553.25,-5.85,-12.05>,
		<553.25,694.05,-12.05>
  }
  triangle { // #45
		<552,-5.85,-12.05>,
		<552,694.05,-29.65>,
		<552,-5.85,-29.65>
  }
  triangle { // #46
		<552,694.05,-29.65>,
		<552,-5.85,-12.05>,
		<552,694.05,-12.05>
  }
  triangle { // #47
		<552,-5.85,-29.65>,
		<512.4,694.05,-29.65>,
		<512.4,-5.85,-29.65>
  }
  triangle { // #48
		<512.4,694.05,-29.65>,
		<552,-5.85,-29.65>,
		<552,694.05,-29.65>
  }
  triangle { // #49
		<512.4,-5.85,-29.65>,
		<512.4,694.05,-30.9>,
		<512.4,-5.85,-30.9>
  }
  triangle { // #50
		<512.4,694.05,-30.9>,
		<512.4,-5.85,-29.65>,
		<512.4,694.05,-29.65>
  }
  triangle { // #51
		<512.4,-5.85,-30.9>,
		<557.5,694.05,-30.9>,
		<557.5,-5.85,-30.9>
  }
  triangle { // #52
		<557.5,694.05,-30.9>,
		<512.4,-5.85,-30.9>,
		<512.4,694.05,-30.9>
  }
  triangle { // #53
		<557.5,-5.85,-30.9>,
		<557.5,694.05,-29.65>,
		<557.5,-5.85,-29.65>
  }
  triangle { // #54
		<557.5,694.05,-29.65>,
		<557.5,-5.85,-30.9>,
		<557.5,694.05,-30.9>
  }
  triangle { // #55
		<557.5,-5.85,-29.65>,
		<553.25,694.05,-29.65>,
		<553.25,-5.85,-29.65>
  }
  triangle { // #56
		<553.25,694.05,-29.65>,
		<557.5,-5.85,-29.65>,
		<557.5,694.05,-29.65>
  }
  triangle { // #57
		<844.45,544.1,-42.3>,
		<824.5,544.1,-42.2>,
		<844.45,544.1,-528>
  }
  triangle { // #58
		<642.5,544.1,-2.1>,
		<645.7,544.1,-784.5>,
		<824.35,544.1,-2>
  }
  triangle { // #59
		<824.35,544.1,-2>,
		<645.7,544.1,-784.5>,
		<824.5,544.1,-42.2>
  }
  triangle { // #60
		<748.55,544.1,-784.5>,
		<748.55,544.1,-528>,
		<645.7,544.1,-784.5>
  }
  triangle { // #61
		<645.7,544.1,-784.5>,
		<748.55,544.1,-528>,
		<824.5,544.1,-42.2>
  }
  triangle { // #62
		<748.55,544.1,-528>,
		<844.45,544.1,-528>,
		<824.5,544.1,-42.2>
  }
  triangle { // #63
		<844.45,574.25,-42.3>,
		<844.45,574.25,-528>,
		<824.5,574.25,-42.2>
  }
  triangle { // #64
		<642.5,574.25,-2.1>,
		<824.35,574.25,-2>,
		<645.7,574.25,-784.5>
  }
  triangle { // #65
		<824.35,574.25,-2>,
		<824.5,574.25,-42.2>,
		<645.7,574.25,-784.5>
  }
  triangle { // #66
		<748.55,574.25,-784.5>,
		<645.7,574.25,-784.5>,
		<748.55,574.25,-528>
  }
  triangle { // #67
		<645.7,574.25,-784.5>,
		<824.5,574.25,-42.2>,
		<748.55,574.25,-528>
  }
  triangle { // #68
		<748.55,574.25,-528>,
		<824.5,574.25,-42.2>,
		<844.45,574.25,-528>
  }
  triangle { // #69
		<645.7,544.1,-784.5>,
		<645.7,574.25,-784.5>,
		<748.55,544.1,-784.5>
  }
  triangle { // #70
		<748.55,574.25,-784.5>,
		<748.55,544.1,-784.5>,
		<645.7,574.25,-784.5>
  }
  triangle { // #71
		<642.5,544.1,-2.1>,
		<642.5,574.25,-2.1>,
		<645.7,544.1,-784.5>
  }
  triangle { // #72
		<645.7,574.25,-784.5>,
		<645.7,544.1,-784.5>,
		<642.5,574.25,-2.1>
  }
  triangle { // #73
		<824.35,544.1,-2>,
		<824.35,574.25,-2>,
		<642.5,544.1,-2.1>
  }
  triangle { // #74
		<642.5,574.25,-2.1>,
		<642.5,544.1,-2.1>,
		<824.35,574.25,-2>
  }
  triangle { // #75
		<824.5,544.1,-42.2>,
		<824.5,574.25,-42.2>,
		<824.35,544.1,-2>
  }
  triangle { // #76
		<824.35,574.25,-2>,
		<824.35,544.1,-2>,
		<824.5,574.25,-42.2>
  }
  triangle { // #77
		<844.45,544.1,-42.3>,
		<844.45,574.25,-42.3>,
		<824.5,544.1,-42.2>
  }
  triangle { // #78
		<824.5,574.25,-42.2>,
		<824.5,544.1,-42.2>,
		<844.45,574.25,-42.3>
  }
  triangle { // #79
		<844.45,544.1,-528>,
		<844.45,574.25,-528>,
		<844.45,544.1,-42.3>
  }
  triangle { // #80
		<844.45,574.25,-42.3>,
		<844.45,544.1,-42.3>,
		<844.45,574.25,-528>
  }
  triangle { // #81
		<748.55,544.1,-528>,
		<748.55,574.25,-528>,
		<844.45,544.1,-528>
  }
  triangle { // #82
		<844.45,574.25,-528>,
		<844.45,544.1,-528>,
		<748.55,574.25,-528>
  }
  triangle { // #83
		<748.55,544.1,-784.5>,
		<748.55,574.25,-784.5>,
		<748.55,544.1,-528>
  }
  triangle { // #84
		<748.55,574.25,-528>,
		<748.55,544.1,-528>,
		<748.55,574.25,-784.5>
  }
  triangle { // #85
		<585.45,1060.85,-681.4>,
		<585.45,1060.85,-784.25>,
		<621.95,1060.85,-638.6>
  }
  triangle { // #86
		<621.95,1060.85,-2>,
		<621.95,1060.85,-638.6>,
		<753.95,1060.85,-2.1>
  }
  triangle { // #87
		<753.95,1060.85,-2.1>,
		<621.95,1060.85,-638.6>,
		<753.95,1060.85,-784.5>
  }
  triangle { // #88
		<753.95,1060.85,-784.5>,
		<621.95,1060.85,-638.6>,
		<585.45,1060.85,-784.5>
  }
  triangle { // #89
		<585.45,1060.85,-784.5>,
		<621.95,1060.85,-638.6>,
		<585.45,1060.85,-784.25>
  }
  triangle { // #90
		<585.45,1080.95,-681.4>,
		<621.95,1080.95,-638.6>,
		<585.45,1080.95,-784.25>
  }
  triangle { // #91
		<621.95,1080.95,-2>,
		<753.95,1080.95,-2.1>,
		<621.95,1080.95,-638.6>
  }
  triangle { // #92
		<753.95,1080.95,-2.1>,
		<753.95,1080.95,-784.5>,
		<621.95,1080.95,-638.6>
  }
  triangle { // #93
		<753.95,1080.95,-784.5>,
		<585.45,1080.95,-784.5>,
		<621.95,1080.95,-638.6>
  }
  triangle { // #94
		<585.45,1080.95,-784.5>,
		<585.45,1080.95,-784.25>,
		<621.95,1080.95,-638.6>
  }
  triangle { // #95
		<585.45,1060.85,-784.25>,
		<585.45,1080.95,-784.25>,
		<585.45,1060.85,-784.5>
  }
  triangle { // #96
		<585.45,1080.95,-784.5>,
		<585.45,1060.85,-784.5>,
		<585.45,1080.95,-784.25>
  }
  smooth_triangle { // #97
		<585.45,1060.85,-681.4>, <-0.889,-0.457,0>,
		<585.45,1080.95,-681.4>, <-0.974,-0.229,0>,
		<585.45,1060.85,-784.25>, <-1,0,0>
  }
  smooth_triangle { // #98
		<585.45,1080.95,-784.25>, <-1,0,0>,
		<585.45,1060.85,-784.25>, <-1,0,0>,
		<585.45,1080.95,-681.4>, <-0.974,-0.229,0>
  }
  smooth_triangle { // #99
		<621.95,1060.85,-638.6>, <-0.974,-0.229,0>,
		<621.95,1080.95,-638.6>, <-0.889,-0.457,0>,
		<585.45,1060.85,-681.4>, <-0.889,-0.457,0>
  }
  smooth_triangle { // #100
		<585.45,1080.95,-681.4>, <-0.974,-0.229,0>,
		<585.45,1060.85,-681.4>, <-0.889,-0.457,0>,
		<621.95,1080.95,-638.6>, <-0.889,-0.457,0>
  }
  triangle { // #101
		<621.95,1060.85,-2>,
		<621.95,1080.95,-2>,
		<621.95,1060.85,-638.6>
  }
  triangle { // #102
		<621.95,1080.95,-638.6>,
		<621.95,1060.85,-638.6>,
		<621.95,1080.95,-2>
  }
  triangle { // #103
		<753.95,1060.85,-2.1>,
		<753.95,1080.95,-2.1>,
		<621.95,1060.85,-2>
  }
  triangle { // #104
		<621.95,1080.95,-2>,
		<621.95,1060.85,-2>,
		<753.95,1080.95,-2.1>
  }
  triangle { // #105
		<753.95,1060.85,-784.5>,
		<753.95,1080.95,-784.5>,
		<753.95,1060.85,-2.1>
  }
  triangle { // #106
		<753.95,1080.95,-2.1>,
		<753.95,1060.85,-2.1>,
		<753.95,1080.95,-784.5>
  }
  triangle { // #107
		<585.45,1060.85,-784.5>,
		<585.45,1080.95,-784.5>,
		<753.95,1060.85,-784.5>
  }
  triangle { // #108
		<753.95,1080.95,-784.5>,
		<753.95,1060.85,-784.5>,
		<585.45,1080.95,-784.5>
  }
  triangle { // #109
		<-766.75,208.7,-824.75>,
		<-653.6,208.7,-784.5>,
		<-766.75,208.7,-784.5>
  }
  triangle { // #110
		<-653.6,208.7,-784.5>,
		<-766.75,208.7,-824.75>,
		<-653.6,208.7,-824.75>
  }
  triangle { // #111
		<-766.75,1306,-784.5>,
		<-653.6,1306,-824.75>,
		<-766.75,1306,-824.75>
  }
  triangle { // #112
		<-653.6,1306,-824.75>,
		<-766.75,1306,-784.5>,
		<-653.6,1306,-784.5>
  }
  triangle { // #113
		<-766.75,208.7,-784.5>,
		<-766.75,1306,-824.75>,
		<-766.75,208.7,-824.75>
  }
  triangle { // #114
		<-766.75,1306,-824.75>,
		<-766.75,208.7,-784.5>,
		<-766.75,1306,-784.5>
  }
  triangle { // #115
		<-766.75,208.7,-824.75>,
		<-653.6,1306,-824.75>,
		<-653.6,208.7,-824.75>
  }
  triangle { // #116
		<-653.6,1306,-824.75>,
		<-766.75,208.7,-824.75>,
		<-766.75,1306,-824.75>
  }
  triangle { // #117
		<-653.6,208.7,-824.75>,
		<-653.6,1306,-784.5>,
		<-653.6,208.7,-784.5>
  }
  triangle { // #118
		<-653.6,1306,-784.5>,
		<-653.6,208.7,-824.75>,
		<-653.6,1306,-824.75>
  }
  triangle { // #119
		<-653.6,208.7,-784.5>,
		<-766.75,1306,-784.5>,
		<-766.75,208.7,-784.5>
  }
  triangle { // #120
		<-766.75,1306,-784.5>,
		<-653.6,208.7,-784.5>,
		<-653.6,1306,-784.5>
  }
  triangle { // #121
		<-845.35,544.1,-744.25>,
		<-825.25,544.1,-744.25>,
		<-845.35,544.1,-39.7>
  }
  triangle { // #122
		<-825.25,544.1,-784.5>,
		<-730.3,544.1,-784.5>,
		<-825.25,544.1,-744.25>
  }
  triangle { // #123
		<-730.3,544.1,-784.5>,
		<-730.3,544.1,-2>,
		<-825.25,544.1,-744.25>
  }
  triangle { // #124
		<-824.9,544.1,-2>,
		<-824.9,544.1,-39.7>,
		<-730.3,544.1,-2>
  }
  triangle { // #125
		<-730.3,544.1,-2>,
		<-824.9,544.1,-39.7>,
		<-825.25,544.1,-744.25>
  }
  triangle { // #126
		<-824.9,544.1,-39.7>,
		<-845.35,544.1,-39.7>,
		<-825.25,544.1,-744.25>
  }
  triangle { // #127
		<-845.35,574.25,-744.25>,
		<-845.35,574.25,-39.7>,
		<-825.25,574.25,-744.25>
  }
  triangle { // #128
		<-824.9,574.25,-2>,
		<-730.3,574.25,-2>,
		<-824.9,574.25,-39.7>
  }
  triangle { // #129
		<-730.3,574.25,-2>,
		<-730.3,574.25,-784.5>,
		<-824.9,574.25,-39.7>
  }
  triangle { // #130
		<-730.3,574.25,-784.5>,
		<-825.25,574.25,-784.5>,
		<-824.9,574.25,-39.7>
  }
  triangle { // #131
		<-825.25,574.25,-784.5>,
		<-825.25,574.25,-744.25>,
		<-824.9,574.25,-39.7>
  }
  triangle { // #132
		<-824.9,574.25,-39.7>,
		<-825.25,574.25,-744.25>,
		<-845.35,574.25,-39.7>
  }
  triangle { // #133
		<-730.3,544.1,-784.5>,
		<-730.3,574.25,-784.5>,
		<-730.3,544.1,-2>
  }
  triangle { // #134
		<-730.3,574.25,-2>,
		<-730.3,544.1,-2>,
		<-730.3,574.25,-784.5>
  }
  triangle { // #135
		<-825.25,544.1,-784.5>,
		<-825.25,574.25,-784.5>,
		<-730.3,544.1,-784.5>
  }
  triangle { // #136
		<-730.3,574.25,-784.5>,
		<-730.3,544.1,-784.5>,
		<-825.25,574.25,-784.5>
  }
  triangle { // #137
		<-825.25,544.1,-744.25>,
		<-825.25,574.25,-744.25>,
		<-825.25,544.1,-784.5>
  }
  triangle { // #138
		<-825.25,574.25,-784.5>,
		<-825.25,544.1,-784.5>,
		<-825.25,574.25,-744.25>
  }
  triangle { // #139
		<-845.35,544.1,-744.25>,
		<-845.35,574.25,-744.25>,
		<-825.25,544.1,-744.25>
  }
  triangle { // #140
		<-825.25,574.25,-744.25>,
		<-825.25,544.1,-744.25>,
		<-845.35,574.25,-744.25>
  }
  triangle { // #141
		<-845.35,544.1,-39.7>,
		<-845.35,574.25,-39.7>,
		<-845.35,544.1,-744.25>
  }
  triangle { // #142
		<-845.35,574.25,-744.25>,
		<-845.35,544.1,-744.25>,
		<-845.35,574.25,-39.7>
  }
  triangle { // #143
		<-824.9,544.1,-39.7>,
		<-824.9,574.25,-39.7>,
		<-845.35,544.1,-39.7>
  }
  triangle { // #144
		<-845.35,574.25,-39.7>,
		<-845.35,544.1,-39.7>,
		<-824.9,574.25,-39.7>
  }
  triangle { // #145
		<-824.9,544.1,-2>,
		<-824.9,574.25,-2>,
		<-824.9,544.1,-39.7>
  }
  triangle { // #146
		<-824.9,574.25,-39.7>,
		<-824.9,544.1,-39.7>,
		<-824.9,574.25,-2>
  }
  triangle { // #147
		<-730.3,544.1,-2>,
		<-730.3,574.25,-2>,
		<-824.9,544.1,-2>
  }
  triangle { // #148
		<-824.9,574.25,-2>,
		<-824.9,544.1,-2>,
		<-730.3,574.25,-2>
  }
  triangle { // #149
		<-1187.35,214.7,-652.5>,
		<-885.6,214.7,-622.3>,
		<-1187.35,214.7,-622.3>
  }
  triangle { // #150
		<-885.6,214.7,-622.3>,
		<-1187.35,214.7,-652.5>,
		<-885.6,214.7,-652.5>
  }
  triangle { // #151
		<-1187.35,574.25,-622.3>,
		<-885.6,574.25,-652.5>,
		<-1187.35,574.25,-652.5>
  }
  triangle { // #152
		<-885.6,574.25,-652.5>,
		<-1187.35,574.25,-622.3>,
		<-885.6,574.25,-622.3>
  }
  triangle { // #153
		<-1187.35,214.7,-622.3>,
		<-1187.35,574.25,-652.5>,
		<-1187.35,214.7,-652.5>
  }
  triangle { // #154
		<-1187.35,574.25,-652.5>,
		<-1187.35,214.7,-622.3>,
		<-1187.35,574.25,-622.3>
  }
  triangle { // #155
		<-1187.35,214.7,-652.5>,
		<-885.6,574.25,-652.5>,
		<-885.6,214.7,-652.5>
  }
  triangle { // #156
		<-885.6,574.25,-652.5>,
		<-1187.35,214.7,-652.5>,
		<-1187.35,574.25,-652.5>
  }
  triangle { // #157
		<-885.6,214.7,-652.5>,
		<-885.6,574.25,-622.3>,
		<-885.6,214.7,-622.3>
  }
  triangle { // #158
		<-885.6,574.25,-622.3>,
		<-885.6,214.7,-652.5>,
		<-885.6,574.25,-652.5>
  }
  triangle { // #159
		<-885.6,214.7,-622.3>,
		<-1187.35,574.25,-622.3>,
		<-1187.35,214.7,-622.3>
  }
  triangle { // #160
		<-1187.35,574.25,-622.3>,
		<-885.6,214.7,-622.3>,
		<-885.6,574.25,-622.3>
  }
  triangle { // #161
		<-885.6,544.1,-543.1>,
		<-844.85,544.1,-59.8>,
		<-885.6,544.1,-59.8>
  }
  triangle { // #162
		<-844.85,544.1,-59.8>,
		<-885.6,544.1,-543.1>,
		<-844.85,544.1,-543.1>
  }
  triangle { // #163
		<-885.6,1306,-59.8>,
		<-844.85,1306,-543.1>,
		<-885.6,1306,-543.1>
  }
  triangle { // #164
		<-844.85,1306,-543.1>,
		<-885.6,1306,-59.8>,
		<-844.85,1306,-59.8>
  }
  triangle { // #165
		<-885.6,544.1,-59.8>,
		<-885.6,1306,-543.1>,
		<-885.6,544.1,-543.1>
  }
  triangle { // #166
		<-885.6,1306,-543.1>,
		<-885.6,544.1,-59.8>,
		<-885.6,1306,-59.8>
  }
  triangle { // #167
		<-885.6,544.1,-543.1>,
		<-844.85,1306,-543.1>,
		<-844.85,544.1,-543.1>
  }
  triangle { // #168
		<-844.85,1306,-543.1>,
		<-885.6,544.1,-543.1>,
		<-885.6,1306,-543.1>
  }
  triangle { // #169
		<-844.85,544.1,-543.1>,
		<-844.85,1306,-59.8>,
		<-844.85,544.1,-59.8>
  }
  triangle { // #170
		<-844.85,1306,-59.8>,
		<-844.85,544.1,-543.1>,
		<-844.85,1306,-543.1>
  }
  triangle { // #171
		<-844.85,544.1,-59.8>,
		<-885.6,1306,-59.8>,
		<-885.6,544.1,-59.8>
  }
  triangle { // #172
		<-885.6,1306,-59.8>,
		<-844.85,544.1,-59.8>,
		<-844.85,1306,-59.8>
  }
  triangle { // #173
		<844.45,544.1,-543.1>,
		<884.7,544.1,-62.35>,
		<844.45,544.1,-62.35>
  }
  triangle { // #174
		<884.7,544.1,-62.35>,
		<844.45,544.1,-543.1>,
		<884.7,544.1,-543.1>
  }
  triangle { // #175
		<844.45,1306,-62.35>,
		<884.7,1306,-543.1>,
		<844.45,1306,-543.1>
  }
  triangle { // #176
		<884.7,1306,-543.1>,
		<844.45,1306,-62.35>,
		<884.7,1306,-62.35>
  }
  triangle { // #177
		<844.45,544.1,-62.35>,
		<844.45,1306,-543.1>,
		<844.45,544.1,-543.1>
  }
  triangle { // #178
		<844.45,1306,-543.1>,
		<844.45,544.1,-62.35>,
		<844.45,1306,-62.35>
  }
  triangle { // #179
		<844.45,544.1,-543.1>,
		<884.7,1306,-543.1>,
		<884.7,544.1,-543.1>
  }
  triangle { // #180
		<884.7,1306,-543.1>,
		<844.45,544.1,-543.1>,
		<844.45,1306,-543.1>
  }
  triangle { // #181
		<884.7,544.1,-543.1>,
		<884.7,1306,-62.35>,
		<884.7,544.1,-62.35>
  }
  triangle { // #182
		<884.7,1306,-62.35>,
		<884.7,544.1,-543.1>,
		<884.7,1306,-543.1>
  }
  triangle { // #183
		<884.7,544.1,-62.35>,
		<844.45,1306,-62.35>,
		<844.45,544.1,-62.35>
  }
  triangle { // #184
		<844.45,1306,-62.35>,
		<884.7,544.1,-62.35>,
		<884.7,1306,-62.35>
  }
  triangle { // #185
		<1192.75,208.7,-649.65>,
		<1387,208.7,-609.6>,
		<1192.75,208.7,-609.6>
  }
  triangle { // #186
		<1387,208.7,-609.6>,
		<1192.75,208.7,-649.65>,
		<1387,208.7,-649.65>
  }
  triangle { // #187
		<1192.75,574.25,-609.6>,
		<1387,574.25,-649.65>,
		<1192.75,574.25,-649.65>
  }
  triangle { // #188
		<1387,574.25,-649.65>,
		<1192.75,574.25,-609.6>,
		<1387,574.25,-609.6>
  }
  triangle { // #189
		<1192.75,208.7,-609.6>,
		<1192.75,574.25,-649.65>,
		<1192.75,208.7,-649.65>
  }
  triangle { // #190
		<1192.75,574.25,-649.65>,
		<1192.75,208.7,-609.6>,
		<1192.75,574.25,-609.6>
  }
  triangle { // #191
		<1192.75,208.7,-649.65>,
		<1387,574.25,-649.65>,
		<1387,208.7,-649.65>
  }
  triangle { // #192
		<1387,574.25,-649.65>,
		<1192.75,208.7,-649.65>,
		<1192.75,574.25,-649.65>
  }
  triangle { // #193
		<1387,208.7,-649.65>,
		<1387,574.25,-609.6>,
		<1387,208.7,-609.6>
  }
  triangle { // #194
		<1387,574.25,-609.6>,
		<1387,208.7,-649.65>,
		<1387,574.25,-649.65>
  }
  triangle { // #195
		<1387,208.7,-609.6>,
		<1192.75,574.25,-609.6>,
		<1192.75,208.7,-609.6>
  }
  triangle { // #196
		<1192.75,574.25,-609.6>,
		<1387,208.7,-609.6>,
		<1387,574.25,-609.6>
  }
  triangle { // #197
		<1831.75,308.65,-321.05>,
		<1861.95,308.65,-60.45>,
		<1831.75,308.65,-60.45>
  }
  triangle { // #198
		<1861.95,308.65,-60.45>,
		<1831.75,308.65,-321.05>,
		<1861.95,308.65,-321.05>
  }
  triangle { // #199
		<1831.75,574.25,-60.45>,
		<1861.95,574.25,-321.05>,
		<1831.75,574.25,-321.05>
  }
  triangle { // #200
		<1861.95,574.25,-321.05>,
		<1831.75,574.25,-60.45>,
		<1861.95,574.25,-60.45>
  }
  triangle { // #201
		<1831.75,308.65,-60.45>,
		<1831.75,574.25,-321.05>,
		<1831.75,308.65,-321.05>
  }
  triangle { // #202
		<1831.75,574.25,-321.05>,
		<1831.75,308.65,-60.45>,
		<1831.75,574.25,-60.45>
  }
  triangle { // #203
		<1831.75,308.65,-321.05>,
		<1861.95,574.25,-321.05>,
		<1861.95,308.65,-321.05>
  }
  triangle { // #204
		<1861.95,574.25,-321.05>,
		<1831.75,308.65,-321.05>,
		<1831.75,574.25,-321.05>
  }
  triangle { // #205
		<1861.95,308.65,-321.05>,
		<1861.95,574.25,-60.45>,
		<1861.95,308.65,-60.45>
  }
  triangle { // #206
		<1861.95,574.25,-60.45>,
		<1861.95,308.65,-321.05>,
		<1861.95,574.25,-321.05>
  }
  triangle { // #207
		<1861.95,308.65,-60.45>,
		<1831.75,574.25,-60.45>,
		<1831.75,308.65,-60.45>
  }
  triangle { // #208
		<1831.75,574.25,-60.45>,
		<1861.95,308.65,-60.45>,
		<1861.95,574.25,-60.45>
  }
  triangle { // #209
		<-1760.95,308.65,-652.5>,
		<-1500.4,308.65,-622.3>,
		<-1760.95,308.65,-622.3>
  }
  triangle { // #210
		<-1500.4,308.65,-622.3>,
		<-1760.95,308.65,-652.5>,
		<-1500.4,308.65,-652.5>
  }
  triangle { // #211
		<-1760.95,574.25,-622.3>,
		<-1500.4,574.25,-652.5>,
		<-1760.95,574.25,-652.5>
  }
  triangle { // #212
		<-1500.4,574.25,-652.5>,
		<-1760.95,574.25,-622.3>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #213
		<-1760.95,308.65,-622.3>,
		<-1760.95,574.25,-652.5>,
		<-1760.95,308.65,-652.5>
  }
  triangle { // #214
		<-1760.95,574.25,-652.5>,
		<-1760.95,308.65,-622.3>,
		<-1760.95,574.25,-622.3>
  }
  triangle { // #215
		<-1760.95,308.65,-652.5>,
		<-1500.4,574.25,-652.5>,
		<-1500.4,308.65,-652.5>
  }
  triangle { // #216
		<-1500.4,574.25,-652.5>,
		<-1760.95,308.65,-652.5>,
		<-1760.95,574.25,-652.5>
  }
  triangle { // #217
		<-1500.4,308.65,-652.5>,
		<-1500.4,574.25,-622.3>,
		<-1500.4,308.65,-622.3>
  }
  triangle { // #218
		<-1500.4,574.25,-622.3>,
		<-1500.4,308.65,-652.5>,
		<-1500.4,574.25,-652.5>
  }
  triangle { // #219
		<-1500.4,308.65,-622.3>,
		<-1760.95,574.25,-622.3>,
		<-1760.95,308.65,-622.3>
  }
  triangle { // #220
		<-1760.95,574.25,-622.3>,
		<-1500.4,308.65,-622.3>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #221
		<-347.9,0,-784.5>,
		<-286.65,0,-763.9>,
		<-347.9,0,-763.9>
  }
  triangle { // #222
		<-286.65,0,-763.9>,
		<-347.9,0,-784.5>,
		<-286.65,0,-784.5>
  }
  triangle { // #223
		<-347.9,1306,-763.9>,
		<-286.65,1306,-784.5>,
		<-347.9,1306,-784.5>
  }
  triangle { // #224
		<-286.65,1306,-784.5>,
		<-347.9,1306,-763.9>,
		<-286.65,1306,-763.9>
  }
  triangle { // #225
		<-347.9,0,-763.9>,
		<-347.9,1306,-784.5>,
		<-347.9,0,-784.5>
  }
  triangle { // #226
		<-347.9,1306,-784.5>,
		<-347.9,0,-763.9>,
		<-347.9,1306,-763.9>
  }
  triangle { // #227
		<-347.9,0,-784.5>,
		<-286.65,1306,-784.5>,
		<-286.65,0,-784.5>
  }
  triangle { // #228
		<-286.65,1306,-784.5>,
		<-347.9,0,-784.5>,
		<-347.9,1306,-784.5>
  }
  triangle { // #229
		<-286.65,0,-784.5>,
		<-286.65,1306,-763.9>,
		<-286.65,0,-763.9>
  }
  triangle { // #230
		<-286.65,1306,-763.9>,
		<-286.65,0,-784.5>,
		<-286.65,1306,-784.5>
  }
  triangle { // #231
		<-286.65,0,-763.9>,
		<-347.9,1306,-763.9>,
		<-347.9,0,-763.9>
  }
  triangle { // #232
		<-347.9,1306,-763.9>,
		<-286.65,0,-763.9>,
		<-286.65,1306,-763.9>
  }
  triangle { // #233
		<285.75,0,-763.9>,
		<347.05,0,-784.5>,
		<347.05,0,-763.9>
  }
  triangle { // #234
		<347.05,0,-784.5>,
		<285.75,0,-763.9>,
		<285.75,0,-784.5>
  }
  triangle { // #235
		<285.75,1306,-763.9>,
		<347.05,1306,-784.5>,
		<285.75,1306,-784.5>
  }
  triangle { // #236
		<347.05,1306,-784.5>,
		<285.75,1306,-763.9>,
		<347.05,1306,-763.9>
  }
  triangle { // #237
		<285.75,0,-763.9>,
		<285.75,1306,-784.5>,
		<285.75,0,-784.5>
  }
  triangle { // #238
		<285.75,1306,-784.5>,
		<285.75,0,-763.9>,
		<285.75,1306,-763.9>
  }
  triangle { // #239
		<285.75,0,-784.5>,
		<347.05,1306,-784.5>,
		<347.05,0,-784.5>
  }
  triangle { // #240
		<347.05,1306,-784.5>,
		<285.75,0,-784.5>,
		<285.75,1306,-784.5>
  }
  triangle { // #241
		<347.05,0,-784.5>,
		<347.05,1306,-763.9>,
		<347.05,0,-763.9>
  }
  triangle { // #242
		<347.05,1306,-763.9>,
		<347.05,0,-784.5>,
		<347.05,1306,-784.5>
  }
  triangle { // #243
		<347.05,0,-763.9>,
		<285.75,1306,-763.9>,
		<285.75,0,-763.9>
  }
  triangle { // #244
		<285.75,1306,-763.9>,
		<347.05,0,-763.9>,
		<347.05,1306,-763.9>
  }
  triangle { // #245
		<652.35,208.7,-824.75>,
		<765.5,208.7,-784.5>,
		<652.35,208.7,-784.5>
  }
  triangle { // #246
		<765.5,208.7,-784.5>,
		<652.35,208.7,-824.75>,
		<765.5,208.7,-824.75>
  }
  triangle { // #247
		<652.35,1306,-784.5>,
		<765.5,1306,-824.75>,
		<652.35,1306,-824.75>
  }
  triangle { // #248
		<765.5,1306,-824.75>,
		<652.35,1306,-784.5>,
		<765.5,1306,-784.5>
  }
  triangle { // #249
		<652.35,208.7,-784.5>,
		<652.35,1306,-824.75>,
		<652.35,208.7,-824.75>
  }
  triangle { // #250
		<652.35,1306,-824.75>,
		<652.35,208.7,-784.5>,
		<652.35,1306,-784.5>
  }
  triangle { // #251
		<652.35,208.7,-824.75>,
		<765.5,1306,-824.75>,
		<765.5,208.7,-824.75>
  }
  triangle { // #252
		<765.5,1306,-824.75>,
		<652.35,208.7,-824.75>,
		<652.35,1306,-824.75>
  }
  triangle { // #253
		<765.5,208.7,-824.75>,
		<765.5,1306,-784.5>,
		<765.5,208.7,-784.5>
  }
  triangle { // #254
		<765.5,1306,-784.5>,
		<765.5,208.7,-824.75>,
		<765.5,1306,-824.75>
  }
  triangle { // #255
		<765.5,208.7,-784.5>,
		<652.35,1306,-784.5>,
		<652.35,208.7,-784.5>
  }
  triangle { // #256
		<652.35,1306,-784.5>,
		<765.5,208.7,-784.5>,
		<765.5,1306,-784.5>
  }
  triangle { // #257
		<906.1,208.7,-649.8>,
		<1016.7,208.7,-609.6>,
		<906.1,208.7,-609.6>
  }
  triangle { // #258
		<1016.7,208.7,-609.6>,
		<906.1,208.7,-649.8>,
		<1016.7,208.7,-649.8>
  }
  triangle { // #259
		<906.1,574.25,-609.6>,
		<1016.7,574.25,-649.8>,
		<906.1,574.25,-649.8>
  }
  triangle { // #260
		<1016.7,574.25,-649.8>,
		<906.1,574.25,-609.6>,
		<1016.7,574.25,-609.6>
  }
  triangle { // #261
		<906.1,208.7,-609.6>,
		<906.1,574.25,-649.8>,
		<906.1,208.7,-649.8>
  }
  triangle { // #262
		<906.1,574.25,-649.8>,
		<906.1,208.7,-609.6>,
		<906.1,574.25,-609.6>
  }
  triangle { // #263
		<906.1,208.7,-649.8>,
		<1016.7,574.25,-649.8>,
		<1016.7,208.7,-649.8>
  }
  triangle { // #264
		<1016.7,574.25,-649.8>,
		<906.1,208.7,-649.8>,
		<906.1,574.25,-649.8>
  }
  triangle { // #265
		<1016.7,208.7,-649.8>,
		<1016.7,574.25,-609.6>,
		<1016.7,208.7,-609.6>
  }
  triangle { // #266
		<1016.7,574.25,-609.6>,
		<1016.7,208.7,-649.8>,
		<1016.7,574.25,-649.8>
  }
  triangle { // #267
		<1016.7,208.7,-609.6>,
		<906.1,574.25,-609.6>,
		<906.1,208.7,-609.6>
  }
  triangle { // #268
		<906.1,574.25,-609.6>,
		<1016.7,208.7,-609.6>,
		<1016.7,574.25,-609.6>
  }
  triangle { // #269
		<1013.9,0,-649.8>,
		<1192.75,0,-609.6>,
		<1013.9,0,-609.6>
  }
  triangle { // #270
		<1192.75,0,-609.6>,
		<1013.9,0,-649.8>,
		<1192.75,0,-649.8>
  }
  triangle { // #271
		<1013.9,574.25,-609.6>,
		<1192.75,574.25,-649.8>,
		<1013.9,574.25,-649.8>
  }
  triangle { // #272
		<1192.75,574.25,-649.8>,
		<1013.9,574.25,-609.6>,
		<1192.75,574.25,-609.6>
  }
  triangle { // #273
		<1013.9,0,-609.6>,
		<1013.9,574.25,-649.8>,
		<1013.9,0,-649.8>
  }
  triangle { // #274
		<1013.9,574.25,-649.8>,
		<1013.9,0,-609.6>,
		<1013.9,574.25,-609.6>
  }
  triangle { // #275
		<1013.9,0,-649.8>,
		<1192.75,574.25,-649.8>,
		<1192.75,0,-649.8>
  }
  triangle { // #276
		<1192.75,574.25,-649.8>,
		<1013.9,0,-649.8>,
		<1013.9,574.25,-649.8>
  }
  triangle { // #277
		<1192.75,0,-649.8>,
		<1192.75,574.25,-609.6>,
		<1192.75,0,-609.6>
  }
  triangle { // #278
		<1192.75,574.25,-609.6>,
		<1192.75,0,-649.8>,
		<1192.75,574.25,-649.8>
  }
  triangle { // #279
		<1192.75,0,-609.6>,
		<1013.9,574.25,-609.6>,
		<1013.9,0,-609.6>
  }
  triangle { // #280
		<1013.9,574.25,-609.6>,
		<1192.75,0,-609.6>,
		<1192.75,574.25,-609.6>
  }
  triangle { // #281
		<754.1,0,-821.85>,
		<761.65,0,-824.75>,
		<754.1,0,-818.4>
  }
  triangle { // #282
		<761.65,0,-827.8>,
		<761.65,0,-824.75>,
		<758.2,0,-826.55>
  }
  triangle { // #283
		<958.9,0,-818.75>,
		<884.7,0,-818.75>,
		<957.45,0,-824.75>
  }
  triangle { // #284
		<957.45,0,-824.75>,
		<884.7,0,-818.75>,
		<761.65,0,-824.75>
  }
  triangle { // #285
		<752.55,0,-821.85>,
		<754.1,0,-821.85>,
		<752.55,0,-818.4>
  }
  triangle { // #286
		<752.55,0,-818.4>,
		<754.1,0,-821.85>,
		<754.1,0,-818.4>
  }
  triangle { // #287
		<907.65,0,-605.8>,
		<907.65,0,-609.6>,
		<909.2,0,-605.8>
  }
  triangle { // #288
		<909.2,0,-605.8>,
		<907.65,0,-609.6>,
		<911.4,0,-606.75>
  }
  triangle { // #289
		<916.75,0,-611.8>,
		<915.2,0,-611.8>,
		<916.75,0,-615.85>
  }
  triangle { // #290
		<916.75,0,-615.85>,
		<915.2,0,-611.8>,
		<915.2,0,-615.85>
  }
  triangle { // #291
		<754.1,0,-826.55>,
		<758.2,0,-826.55>,
		<754.1,0,-821.85>
  }
  triangle { // #292
		<915.2,0,-606.75>,
		<911.4,0,-606.75>,
		<915.2,0,-611.8>
  }
  triangle { // #293
		<911.4,0,-606.75>,
		<907.65,0,-609.6>,
		<915.2,0,-611.8>
  }
  triangle { // #294
		<915.2,0,-620.6>,
		<915.2,0,-615.85>,
		<908.9,0,-620.6>
  }
  triangle { // #295
		<754.1,0,-813.65>,
		<754.1,0,-818.4>,
		<761.5,0,-813.65>
  }
  triangle { // #296
		<908.9,0,-649.8>,
		<908.9,0,-620.6>,
		<884.7,0,-649.8>
  }
  triangle { // #297
		<824.35,0,-744.25>,
		<824.35,0,-784.5>,
		<844.45,0,-744.25>
  }
  triangle { // #298
		<761.5,0,-784.5>,
		<761.5,0,-813.65>,
		<824.35,0,-784.5>
  }
  triangle { // #299
		<884.7,0,-543.1>,
		<844.45,0,-543.1>,
		<884.7,0,-609.6>
  }
  triangle { // #300
		<844.45,0,-543.1>,
		<844.45,0,-744.25>,
		<884.7,0,-609.6>
  }
  triangle { // #301
		<758.2,0,-826.55>,
		<761.65,0,-824.75>,
		<754.1,0,-821.85>
  }
  triangle { // #302
		<915.2,0,-611.8>,
		<907.65,0,-609.6>,
		<915.2,0,-615.85>
  }
  triangle { // #303
		<915.2,0,-615.85>,
		<907.65,0,-609.6>,
		<908.9,0,-620.6>
  }
  triangle { // #304
		<907.65,0,-609.6>,
		<884.7,0,-609.6>,
		<908.9,0,-620.6>
  }
  triangle { // #305
		<908.9,0,-620.6>,
		<884.7,0,-609.6>,
		<884.7,0,-649.8>
  }
  triangle { // #306
		<884.7,0,-609.6>,
		<844.45,0,-744.25>,
		<884.7,0,-649.8>
  }
  triangle { // #307
		<884.7,0,-649.8>,
		<844.45,0,-744.25>,
		<884.7,0,-818.75>
  }
  triangle { // #308
		<844.45,0,-744.25>,
		<824.35,0,-784.5>,
		<884.7,0,-818.75>
  }
  triangle { // #309
		<884.7,0,-818.75>,
		<824.35,0,-784.5>,
		<761.65,0,-824.75>
  }
  triangle { // #310
		<824.35,0,-784.5>,
		<761.5,0,-813.65>,
		<761.65,0,-824.75>
  }
  triangle { // #311
		<761.5,0,-813.65>,
		<754.1,0,-818.4>,
		<761.65,0,-824.75>
  }
  triangle { // #312
		<957.45,0,-824.75>,
		<957.45,1306,-824.75>,
		<958.9,0,-818.75>
  }
  triangle { // #313
		<958.9,1306,-818.75>,
		<958.9,0,-818.75>,
		<957.45,1306,-824.75>
  }
  triangle { // #314
		<761.65,0,-824.75>,
		<761.65,1306,-824.75>,
		<957.45,0,-824.75>
  }
  triangle { // #315
		<957.45,1306,-824.75>,
		<957.45,0,-824.75>,
		<761.65,1306,-824.75>
  }
  triangle { // #316
		<761.65,0,-827.8>,
		<761.65,1306,-827.8>,
		<761.65,0,-824.75>
  }
  triangle { // #317
		<761.65,1306,-824.75>,
		<761.65,0,-824.75>,
		<761.65,1306,-827.8>
  }
  smooth_triangle { // #318
		<758.2,0,-826.55>, <-0.115,0.993,0>,
		<758.2,1306,-826.55>, <-0.231,0.973,0>,
		<761.65,0,-827.8>, <-0.342,0.94,0>
  }
  smooth_triangle { // #319
		<761.65,1306,-827.8>, <-0.342,0.94,0>,
		<761.65,0,-827.8>, <-0.342,0.94,0>,
		<758.2,1306,-826.55>, <-0.231,0.973,0>
  }
  smooth_triangle { // #320
		<754.1,0,-826.55>, <0,1,0>,
		<754.1,1306,-826.55>, <0,1,0>,
		<758.2,0,-826.55>, <-0.115,0.993,0>
  }
  smooth_triangle { // #321
		<758.2,1306,-826.55>, <-0.231,0.973,0>,
		<758.2,0,-826.55>, <-0.115,0.993,0>,
		<754.1,1306,-826.55>, <0,1,0>
  }
  triangle { // #322
		<754.1,0,-821.85>,
		<754.1,1306,-821.85>,
		<754.1,0,-826.55>
  }
  triangle { // #323
		<754.1,1306,-826.55>,
		<754.1,0,-826.55>,
		<754.1,1306,-821.85>
  }
  triangle { // #324
		<752.55,0,-821.85>,
		<752.55,1306,-821.85>,
		<754.1,0,-821.85>
  }
  triangle { // #325
		<754.1,1306,-821.85>,
		<754.1,0,-821.85>,
		<752.55,1306,-821.85>
  }
  triangle { // #326
		<752.55,0,-818.4>,
		<752.55,1306,-818.4>,
		<752.55,0,-821.85>
  }
  triangle { // #327
		<752.55,1306,-821.85>,
		<752.55,0,-821.85>,
		<752.55,1306,-818.4>
  }
  triangle { // #328
		<754.1,0,-818.4>,
		<754.1,1306,-818.4>,
		<752.55,0,-818.4>
  }
  triangle { // #329
		<752.55,1306,-818.4>,
		<752.55,0,-818.4>,
		<754.1,1306,-818.4>
  }
  triangle { // #330
		<754.1,0,-813.65>,
		<754.1,1306,-813.65>,
		<754.1,0,-818.4>
  }
  triangle { // #331
		<754.1,1306,-818.4>,
		<754.1,0,-818.4>,
		<754.1,1306,-813.65>
  }
  triangle { // #332
		<761.5,0,-813.65>,
		<761.5,1306,-813.65>,
		<754.1,0,-813.65>
  }
  triangle { // #333
		<754.1,1306,-813.65>,
		<754.1,0,-813.65>,
		<761.5,1306,-813.65>
  }
  triangle { // #334
		<761.5,0,-784.5>,
		<761.5,1306,-784.5>,
		<761.5,0,-813.65>
  }
  triangle { // #335
		<761.5,1306,-813.65>,
		<761.5,0,-813.65>,
		<761.5,1306,-784.5>
  }
  triangle { // #336
		<824.35,0,-784.5>,
		<824.35,1306,-784.5>,
		<761.5,0,-784.5>
  }
  triangle { // #337
		<761.5,1306,-784.5>,
		<761.5,0,-784.5>,
		<824.35,1306,-784.5>
  }
  triangle { // #338
		<824.35,0,-744.25>,
		<824.35,1306,-744.25>,
		<824.35,0,-784.5>
  }
  triangle { // #339
		<824.35,1306,-784.5>,
		<824.35,0,-784.5>,
		<824.35,1306,-744.25>
  }
  triangle { // #340
		<844.45,0,-744.25>,
		<844.45,1306,-744.25>,
		<824.35,0,-744.25>
  }
  triangle { // #341
		<824.35,1306,-744.25>,
		<824.35,0,-744.25>,
		<844.45,1306,-744.25>
  }
  triangle { // #342
		<844.45,0,-543.1>,
		<844.45,1306,-543.1>,
		<844.45,0,-744.25>
  }
  triangle { // #343
		<844.45,1306,-744.25>,
		<844.45,0,-744.25>,
		<844.45,1306,-543.1>
  }
  triangle { // #344
		<884.7,0,-543.1>,
		<884.7,1306,-543.1>,
		<844.45,0,-543.1>
  }
  triangle { // #345
		<844.45,1306,-543.1>,
		<844.45,0,-543.1>,
		<884.7,1306,-543.1>
  }
  triangle { // #346
		<958.9,0,-818.75>,
		<958.9,1306,-818.75>,
		<884.7,0,-818.75>
  }
  triangle { // #347
		<884.7,1306,-818.75>,
		<884.7,0,-818.75>,
		<958.9,1306,-818.75>
  }
  triangle { // #348
		<916.75,0,-615.85>,
		<915.2,0,-615.85>,
		<916.75,210.75,-615.85>
  }
  triangle { // #349
		<915.2,210.75,-615.85>,
		<916.75,210.75,-615.85>,
		<915.2,0,-615.85>
  }
  triangle { // #350
		<916.75,210.75,-611.8>,
		<916.75,0,-611.8>,
		<916.75,210.75,-615.85>
  }
  triangle { // #351
		<916.75,0,-615.85>,
		<916.75,210.75,-615.85>,
		<916.75,0,-611.8>
  }
  triangle { // #352
		<915.2,0,-611.8>,
		<916.75,0,-611.8>,
		<915.2,210.75,-611.8>
  }
  triangle { // #353
		<916.75,210.75,-611.8>,
		<915.2,210.75,-611.8>,
		<916.75,0,-611.8>
  }
  triangle { // #354
		<915.2,210.75,-606.75>,
		<915.2,0,-606.75>,
		<915.2,210.75,-611.8>
  }
  triangle { // #355
		<915.2,0,-611.8>,
		<915.2,210.75,-611.8>,
		<915.2,0,-606.75>
  }
  smooth_triangle { // #356
		<911.4,210.75,-606.75>, <0.267,-0.964,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<915.2,210.75,-606.75>, <0,-1,0>
  }
  smooth_triangle { // #357
		<915.2,0,-606.75>, <0,-1,0>,
		<915.2,210.75,-606.75>, <0,-1,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>
  }
  smooth_triangle { // #358
		<909.2,210.75,-605.8>, <0.134,-0.991,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<911.4,210.75,-606.75>, <0.267,-0.964,0>
  }
  smooth_triangle { // #359
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<911.4,210.75,-606.75>, <0.267,-0.964,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>
  }
  smooth_triangle { // #360
		<907.65,210.75,-605.8>, <0,-1,0>,
		<907.65,0,-605.8>, <0,-1,0>,
		<909.2,210.75,-605.8>, <0.134,-0.991,0>
  }
  smooth_triangle { // #361
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<909.2,210.75,-605.8>, <0.134,-0.991,0>,
		<907.65,0,-605.8>, <0,-1,0>
  }
  triangle { // #362
		<907.65,210.75,-609.6>,
		<907.65,0,-609.6>,
		<907.65,210.75,-605.8>
  }
  triangle { // #363
		<907.65,0,-605.8>,
		<907.65,210.75,-605.8>,
		<907.65,0,-609.6>
  }
  triangle { // #364
		<909.2,210.75,-605.8>,
		<911.4,210.75,-606.75>,
		<907.65,210.75,-605.8>
  }
  triangle { // #365
		<916.75,210.75,-615.85>,
		<915.2,210.75,-615.85>,
		<916.75,210.75,-611.8>
  }
  triangle { // #366
		<916.75,210.75,-611.8>,
		<915.2,210.75,-615.85>,
		<915.2,210.75,-611.8>
  }
  triangle { // #367
		<915.2,210.75,-606.75>,
		<915.2,210.75,-611.8>,
		<911.4,210.75,-606.75>
  }
  triangle { // #368
		<906.8,210.75,-609.6>,
		<907.65,210.75,-609.6>,
		<906.8,210.75,-617.7>
  }
  triangle { // #369
		<906.8,210.75,-617.7>,
		<907.65,210.75,-609.6>,
		<915.2,210.75,-617.7>
  }
  triangle { // #370
		<915.2,210.75,-617.7>,
		<907.65,210.75,-609.6>,
		<915.2,210.75,-615.85>
  }
  triangle { // #371
		<915.2,210.75,-615.85>,
		<907.65,210.75,-609.6>,
		<915.2,210.75,-611.8>
  }
  triangle { // #372
		<915.2,210.75,-611.8>,
		<907.65,210.75,-609.6>,
		<911.4,210.75,-606.75>
  }
  triangle { // #373
		<907.65,210.75,-609.6>,
		<907.65,210.75,-605.8>,
		<911.4,210.75,-606.75>
  }
  triangle { // #374
		<906.8,574.25,-609.6>,
		<906.8,210.75,-609.6>,
		<906.8,574.25,-617.7>
  }
  triangle { // #375
		<906.8,210.75,-617.7>,
		<906.8,574.25,-617.7>,
		<906.8,210.75,-609.6>
  }
  triangle { // #376
		<906.8,574.25,-617.7>,
		<906.8,210.75,-617.7>,
		<915.2,574.25,-617.7>
  }
  triangle { // #377
		<915.2,210.75,-617.7>,
		<915.2,574.25,-617.7>,
		<906.8,210.75,-617.7>
  }
  triangle { // #378
		<906.8,574.25,-609.6>,
		<884.7,574.25,-609.6>,
		<906.8,210.75,-609.6>
  }
  triangle { // #379
		<907.65,210.75,-609.6>,
		<906.8,210.75,-609.6>,
		<907.65,0,-609.6>
  }
  triangle { // #380
		<907.65,0,-609.6>,
		<906.8,210.75,-609.6>,
		<884.7,0,-609.6>
  }
  triangle { // #381
		<884.7,0,-609.6>,
		<906.8,210.75,-609.6>,
		<884.7,574.25,-609.6>
  }
  triangle { // #382
		<915.2,574.25,-617.7>,
		<915.2,210.75,-617.7>,
		<915.2,574.25,-620.6>
  }
  triangle { // #383
		<915.2,210.75,-615.85>,
		<915.2,0,-615.85>,
		<915.2,210.75,-617.7>
  }
  triangle { // #384
		<915.2,0,-615.85>,
		<915.2,0,-620.6>,
		<915.2,210.75,-617.7>
  }
  triangle { // #385
		<915.2,0,-620.6>,
		<915.2,574.25,-620.6>,
		<915.2,210.75,-617.7>
  }
  triangle { // #386
		<884.7,0,-649.8>,
		<884.7,0,-818.75>,
		<884.7,574.25,-649.8>
  }
  triangle { // #387
		<884.7,0,-609.6>,
		<884.7,574.25,-609.6>,
		<884.7,0,-543.1>
  }
  triangle { // #388
		<884.7,0,-543.1>,
		<884.7,574.25,-609.6>,
		<884.7,1306,-543.1>
  }
  triangle { // #389
		<884.7,1306,-543.1>,
		<884.7,574.25,-609.6>,
		<884.7,1306,-818.75>
  }
  triangle { // #390
		<884.7,574.25,-609.6>,
		<884.7,574.25,-649.8>,
		<884.7,1306,-818.75>
  }
  triangle { // #391
		<884.7,1306,-818.75>,
		<884.7,574.25,-649.8>,
		<884.7,0,-818.75>
  }
  triangle { // #392
		<908.9,574.25,-649.8>,
		<908.9,0,-649.8>,
		<884.7,574.25,-649.8>
  }
  triangle { // #393
		<884.7,0,-649.8>,
		<884.7,574.25,-649.8>,
		<908.9,0,-649.8>
  }
  triangle { // #394
		<908.9,574.25,-620.6>,
		<908.9,0,-620.6>,
		<908.9,574.25,-649.8>
  }
  triangle { // #395
		<908.9,0,-649.8>,
		<908.9,574.25,-649.8>,
		<908.9,0,-620.6>
  }
  triangle { // #396
		<915.2,574.25,-620.6>,
		<915.2,0,-620.6>,
		<908.9,574.25,-620.6>
  }
  triangle { // #397
		<908.9,0,-620.6>,
		<908.9,574.25,-620.6>,
		<915.2,0,-620.6>
  }
  triangle { // #398
		<758.2,1306,-826.55>,
		<754.1,1306,-821.85>,
		<761.65,1306,-824.75>
  }
  triangle { // #399
		<761.65,1306,-827.8>,
		<758.2,1306,-826.55>,
		<761.65,1306,-824.75>
  }
  triangle { // #400
		<958.9,1306,-818.75>,
		<957.45,1306,-824.75>,
		<884.7,1306,-818.75>
  }
  triangle { // #401
		<957.45,1306,-824.75>,
		<761.65,1306,-824.75>,
		<884.7,1306,-818.75>
  }
  triangle { // #402
		<844.45,1306,-543.1>,
		<884.7,1306,-543.1>,
		<844.45,1306,-744.25>
  }
  triangle { // #403
		<884.7,1306,-543.1>,
		<884.7,1306,-818.75>,
		<844.45,1306,-744.25>
  }
  triangle { // #404
		<752.55,1306,-818.4>,
		<754.1,1306,-818.4>,
		<752.55,1306,-821.85>
  }
  triangle { // #405
		<752.55,1306,-821.85>,
		<754.1,1306,-818.4>,
		<754.1,1306,-821.85>
  }
  triangle { // #406
		<754.1,1306,-826.55>,
		<754.1,1306,-821.85>,
		<758.2,1306,-826.55>
  }
  triangle { // #407
		<754.1,1306,-813.65>,
		<761.5,1306,-813.65>,
		<754.1,1306,-818.4>
  }
  triangle { // #408
		<824.35,1306,-744.25>,
		<844.45,1306,-744.25>,
		<824.35,1306,-784.5>
  }
  triangle { // #409
		<844.45,1306,-744.25>,
		<884.7,1306,-818.75>,
		<824.35,1306,-784.5>
  }
  triangle { // #410
		<884.7,1306,-818.75>,
		<761.65,1306,-824.75>,
		<824.35,1306,-784.5>
  }
  triangle { // #411
		<824.35,1306,-784.5>,
		<761.65,1306,-824.75>,
		<761.5,1306,-784.5>
  }
  triangle { // #412
		<761.5,1306,-784.5>,
		<761.65,1306,-824.75>,
		<761.5,1306,-813.65>
  }
  triangle { // #413
		<761.5,1306,-813.65>,
		<761.65,1306,-824.75>,
		<754.1,1306,-818.4>
  }
  triangle { // #414
		<754.1,1306,-818.4>,
		<761.65,1306,-824.75>,
		<754.1,1306,-821.85>
  }
  triangle { // #415
		<908.9,574.25,-620.6>,
		<908.9,574.25,-649.8>,
		<906.8,574.25,-617.7>
  }
  triangle { // #416
		<915.2,574.25,-617.7>,
		<915.2,574.25,-620.6>,
		<906.8,574.25,-617.7>
  }
  triangle { // #417
		<915.2,574.25,-620.6>,
		<908.9,574.25,-620.6>,
		<906.8,574.25,-617.7>
  }
  triangle { // #418
		<906.8,574.25,-609.6>,
		<906.8,574.25,-617.7>,
		<884.7,574.25,-609.6>
  }
  triangle { // #419
		<884.7,574.25,-609.6>,
		<906.8,574.25,-617.7>,
		<884.7,574.25,-649.8>
  }
  triangle { // #420
		<884.7,574.25,-649.8>,
		<906.8,574.25,-617.7>,
		<908.9,574.25,-649.8>
  }
  triangle { // #421
		<-1504.8,0,-630.65>,
		<-1500.4,0,-622.3>,
		<-1504.8,0,-622.3>
  }
  triangle { // #422
		<-1500.4,0,-622.3>,
		<-1504.8,0,-641.3>,
		<-1500.4,0,-647.6>
  }
  triangle { // #423
		<-1500.4,0,-622.3>,
		<-1504.8,0,-634.4>,
		<-1504.8,0,-641.3>
  }
  triangle { // #424
		<-1512.35,0,-634.4>,
		<-1504.8,0,-630.65>,
		<-1512.35,0,-630.65>
  }
  triangle { // #425
		<-1504.8,0,-634.4>,
		<-1504.8,0,-630.65>,
		<-1512.35,0,-634.4>
  }
  triangle { // #426
		<-1500.4,0,-622.3>,
		<-1504.8,0,-630.65>,
		<-1504.8,0,-634.4>
  }
  triangle { // #427
		<-1500.4,308.65,-622.3>,
		<-1504.8,308.65,-630.65>,
		<-1504.8,308.65,-622.3>
  }
  triangle { // #428
		<-1504.8,308.65,-641.3>,
		<-1500.4,308.65,-622.3>,
		<-1500.4,308.65,-647.6>
  }
  triangle { // #429
		<-1504.8,308.65,-634.4>,
		<-1500.4,308.65,-622.3>,
		<-1504.8,308.65,-641.3>
  }
  triangle { // #430
		<-1512.35,308.65,-630.65>,
		<-1504.8,308.65,-634.4>,
		<-1512.35,308.65,-634.4>
  }
  triangle { // #431
		<-1504.8,308.65,-630.65>,
		<-1504.8,308.65,-634.4>,
		<-1512.35,308.65,-630.65>
  }
  triangle { // #432
		<-1504.8,308.65,-630.65>,
		<-1500.4,308.65,-622.3>,
		<-1504.8,308.65,-634.4>
  }
  triangle { // #433
		<-1500.4,0,-647.6>,
		<-1500.4,308.65,-622.3>,
		<-1500.4,0,-622.3>
  }
  triangle { // #434
		<-1500.4,308.65,-622.3>,
		<-1500.4,0,-647.6>,
		<-1500.4,308.65,-647.6>
  }
  triangle { // #435
		<-1500.4,0,-622.3>,
		<-1504.8,308.65,-622.3>,
		<-1504.8,0,-622.3>
  }
  triangle { // #436
		<-1504.8,308.65,-622.3>,
		<-1500.4,0,-622.3>,
		<-1500.4,308.65,-622.3>
  }
  triangle { // #437
		<-1504.8,0,-622.3>,
		<-1504.8,308.65,-630.65>,
		<-1504.8,0,-630.65>
  }
  triangle { // #438
		<-1504.8,308.65,-630.65>,
		<-1504.8,0,-622.3>,
		<-1504.8,308.65,-622.3>
  }
  triangle { // #439
		<-1504.8,0,-630.65>,
		<-1512.35,308.65,-630.65>,
		<-1512.35,0,-630.65>
  }
  triangle { // #440
		<-1512.35,308.65,-630.65>,
		<-1504.8,0,-630.65>,
		<-1504.8,308.65,-630.65>
  }
  triangle { // #441
		<-1512.35,0,-630.65>,
		<-1512.35,308.65,-634.4>,
		<-1512.35,0,-634.4>
  }
  triangle { // #442
		<-1512.35,308.65,-634.4>,
		<-1512.35,0,-630.65>,
		<-1512.35,308.65,-630.65>
  }
  triangle { // #443
		<-1512.35,0,-634.4>,
		<-1504.8,308.65,-634.4>,
		<-1504.8,0,-634.4>
  }
  triangle { // #444
		<-1504.8,308.65,-634.4>,
		<-1512.35,0,-634.4>,
		<-1512.35,308.65,-634.4>
  }
  smooth_triangle { // #445
		<-1504.8,0,-634.4>, <-1,0,0>,
		<-1504.8,308.65,-641.3>, <-0.98,0.199,0>,
		<-1504.8,0,-641.3>, <-0.917,0.399,0>
  }
  smooth_triangle { // #446
		<-1504.8,308.65,-641.3>, <-0.98,0.199,0>,
		<-1504.8,0,-634.4>, <-1,0,0>,
		<-1504.8,308.65,-634.4>, <-1,0,0>
  }
  smooth_triangle { // #447
		<-1504.8,0,-641.3>, <-0.917,0.399,0>,
		<-1500.4,308.65,-647.6>, <-0.819,0.573,0>,
		<-1500.4,0,-647.6>, <-0.819,0.573,0>
  }
  smooth_triangle { // #448
		<-1500.4,308.65,-647.6>, <-0.819,0.573,0>,
		<-1504.8,0,-641.3>, <-0.917,0.399,0>,
		<-1504.8,308.65,-641.3>, <-0.98,0.199,0>
  }
  triangle { // #449
		<-1500.4,0,-652.5>,
		<-1441.3,0,-652.5>,
		<-1500.4,0,-622.3>
  }
  triangle { // #450
		<-1441.3,0,-702.15>,
		<-1411.15,0,-695.55>,
		<-1441.3,0,-652.5>
  }
  triangle { // #451
		<-1411.15,0,-695.55>,
		<-1411.15,0,-652.5>,
		<-1441.3,0,-652.5>
  }
  triangle { // #452
		<-1187.35,0,-685.9>,
		<-1187.35,0,-622.3>,
		<-1207.45,0,-683.8>
  }
  triangle { // #453
		<-1207.45,0,-683.8>,
		<-1187.35,0,-622.3>,
		<-1207.45,0,-652.5>
  }
  triangle { // #454
		<-1187.35,0,-622.3>,
		<-1500.4,0,-622.3>,
		<-1207.45,0,-652.5>
  }
  triangle { // #455
		<-1207.45,0,-652.5>,
		<-1500.4,0,-622.3>,
		<-1411.15,0,-652.5>
  }
  triangle { // #456
		<-1411.15,0,-652.5>,
		<-1500.4,0,-622.3>,
		<-1441.3,0,-652.5>
  }
  triangle { // #457
		<-1500.4,574.25,-652.5>,
		<-1500.4,574.25,-622.3>,
		<-1441.3,574.25,-652.5>
  }
  triangle { // #458
		<-1441.3,574.25,-702.15>,
		<-1441.3,574.25,-652.5>,
		<-1411.15,574.25,-695.55>
  }
  triangle { // #459
		<-1411.15,574.25,-695.55>,
		<-1441.3,574.25,-652.5>,
		<-1411.15,574.25,-652.5>
  }
  triangle { // #460
		<-1187.35,574.25,-685.9>,
		<-1207.45,574.25,-683.8>,
		<-1187.35,574.25,-622.3>
  }
  triangle { // #461
		<-1207.45,574.25,-683.8>,
		<-1207.45,574.25,-652.5>,
		<-1187.35,574.25,-622.3>
  }
  triangle { // #462
		<-1187.35,574.25,-622.3>,
		<-1207.45,574.25,-652.5>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #463
		<-1207.45,574.25,-652.5>,
		<-1411.15,574.25,-652.5>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #464
		<-1411.15,574.25,-652.5>,
		<-1441.3,574.25,-652.5>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #465
		<-1441.3,0,-652.5>,
		<-1441.3,574.25,-652.5>,
		<-1441.3,0,-702.15>
  }
  triangle { // #466
		<-1441.3,574.25,-702.15>,
		<-1441.3,0,-702.15>,
		<-1441.3,574.25,-652.5>
  }
  triangle { // #467
		<-1500.4,0,-652.5>,
		<-1500.4,574.25,-652.5>,
		<-1441.3,0,-652.5>
  }
  triangle { // #468
		<-1441.3,574.25,-652.5>,
		<-1441.3,0,-652.5>,
		<-1500.4,574.25,-652.5>
  }
  triangle { // #469
		<-1500.4,0,-622.3>,
		<-1500.4,574.25,-622.3>,
		<-1500.4,0,-652.5>
  }
  triangle { // #470
		<-1500.4,574.25,-652.5>,
		<-1500.4,0,-652.5>,
		<-1500.4,574.25,-622.3>
  }
  triangle { // #471
		<-1187.35,0,-622.3>,
		<-1187.35,574.25,-622.3>,
		<-1500.4,0,-622.3>
  }
  triangle { // #472
		<-1500.4,574.25,-622.3>,
		<-1500.4,0,-622.3>,
		<-1187.35,574.25,-622.3>
  }
  triangle { // #473
		<-1187.35,0,-685.9>,
		<-1187.35,574.25,-685.9>,
		<-1187.35,0,-622.3>
  }
  triangle { // #474
		<-1187.35,574.25,-622.3>,
		<-1187.35,0,-622.3>,
		<-1187.35,574.25,-685.9>
  }
  triangle { // #475
		<-1207.45,0,-683.8>,
		<-1207.45,574.25,-683.8>,
		<-1187.35,0,-685.9>
  }
  triangle { // #476
		<-1187.35,574.25,-685.9>,
		<-1187.35,0,-685.9>,
		<-1207.45,574.25,-683.8>
  }
  triangle { // #477
		<-1207.45,0,-652.5>,
		<-1207.45,574.25,-652.5>,
		<-1207.45,0,-683.8>
  }
  triangle { // #478
		<-1207.45,574.25,-683.8>,
		<-1207.45,0,-683.8>,
		<-1207.45,574.25,-652.5>
  }
  triangle { // #479
		<-1411.15,0,-652.5>,
		<-1411.15,574.25,-652.5>,
		<-1207.45,0,-652.5>
  }
  triangle { // #480
		<-1207.45,574.25,-652.5>,
		<-1207.45,0,-652.5>,
		<-1411.15,574.25,-652.5>
  }
  triangle { // #481
		<-1411.15,0,-695.55>,
		<-1411.15,574.25,-695.55>,
		<-1411.15,0,-652.5>
  }
  triangle { // #482
		<-1411.15,574.25,-652.5>,
		<-1411.15,0,-652.5>,
		<-1411.15,574.25,-695.55>
  }
  triangle { // #483
		<-1441.3,0,-702.15>,
		<-1441.3,574.25,-702.15>,
		<-1411.15,0,-695.55>
  }
  triangle { // #484
		<-1411.15,574.25,-695.55>,
		<-1411.15,0,-695.55>,
		<-1441.3,574.25,-702.15>
  }
  triangle { // #485
		<-752.5,233.85,171.45>,
		<-849.1,233.85,192.4>,
		<-757.95,233.85,157.35>
  }
  triangle { // #486
		<-849.1,233.85,192.4>,
		<-752.5,233.85,171.45>,
		<-844,233.85,206.8>
  }
  triangle { // #487
		<-752.5,687.45,171.45>,
		<-849.1,687.45,192.4>,
		<-844,687.45,206.8>
  }
  triangle { // #488
		<-849.1,687.45,192.4>,
		<-752.5,687.45,171.45>,
		<-757.95,687.45,157.35>
  }
  triangle { // #489
		<-757.95,233.85,157.35>,
		<-752.5,687.45,171.45>,
		<-752.5,233.85,171.45>
  }
  triangle { // #490
		<-752.5,687.45,171.45>,
		<-757.95,233.85,157.35>,
		<-757.95,687.45,157.35>
  }
  triangle { // #491
		<-752.5,233.85,171.45>,
		<-844,687.45,206.8>,
		<-844,233.85,206.8>
  }
  triangle { // #492
		<-844,687.45,206.8>,
		<-752.5,233.85,171.45>,
		<-752.5,687.45,171.45>
  }
  triangle { // #493
		<-844,233.85,206.8>,
		<-849.1,687.45,192.4>,
		<-849.1,233.85,192.4>
  }
  triangle { // #494
		<-849.1,687.45,192.4>,
		<-844,233.85,206.8>,
		<-844,687.45,206.8>
  }
  triangle { // #495
		<-849.1,233.85,192.4>,
		<-757.95,687.45,157.35>,
		<-757.95,233.85,157.35>
  }
  triangle { // #496
		<-757.95,687.45,157.35>,
		<-849.1,233.85,192.4>,
		<-849.1,687.45,192.4>
  }
  triangle { // #497
		<904.8,208.7,-2.6>,
		<1009.8,208.7,28.3>,
		<904.8,208.7,28.3>
  }
  triangle { // #498
		<1009.8,208.7,28.3>,
		<904.8,208.7,-2.6>,
		<1009.8,208.7,-2.6>
  }
  triangle { // #499
		<904.8,574.25,28.3>,
		<1009.8,574.25,-2.6>,
		<904.8,574.25,-2.6>
  }
  triangle { // #500
		<1009.8,574.25,-2.6>,
		<904.8,574.25,28.3>,
		<1009.8,574.25,28.3>
  }
  triangle { // #501
		<904.8,208.7,28.3>,
		<904.8,574.25,-2.6>,
		<904.8,208.7,-2.6>
  }
  triangle { // #502
		<904.8,574.25,-2.6>,
		<904.8,208.7,28.3>,
		<904.8,574.25,28.3>
  }
  triangle { // #503
		<904.8,208.7,-2.6>,
		<1009.8,574.25,-2.6>,
		<1009.8,208.7,-2.6>
  }
  triangle { // #504
		<1009.8,574.25,-2.6>,
		<904.8,208.7,-2.6>,
		<904.8,574.25,-2.6>
  }
  triangle { // #505
		<1009.8,208.7,-2.6>,
		<1009.8,574.25,28.3>,
		<1009.8,208.7,28.3>
  }
  triangle { // #506
		<1009.8,574.25,28.3>,
		<1009.8,208.7,-2.6>,
		<1009.8,574.25,-2.6>
  }
  triangle { // #507
		<1009.8,208.7,28.3>,
		<904.8,574.25,28.3>,
		<904.8,208.7,28.3>
  }
  triangle { // #508
		<904.8,574.25,28.3>,
		<1009.8,208.7,28.3>,
		<1009.8,574.25,28.3>
  }
  triangle { // #509
		<1009.8,0,-2.6>,
		<1006.8,0,-5.05>,
		<1009.8,0,-5.05>
  }
  triangle { // #510
		<1002.55,0,-3.6>,
		<1009.8,0,-2.6>,
		<1002.55,0,-2.6>
  }
  triangle { // #511
		<1003.25,0,-3.6>,
		<1009.8,0,-2.6>,
		<1002.55,0,-3.6>
  }
  triangle { // #512
		<1006.8,0,-5.05>,
		<1009.8,0,-2.6>,
		<1003.25,0,-3.6>
  }
  triangle { // #513
		<1006.8,215.95,-5.05>,
		<1009.8,215.95,-2.6>,
		<1009.8,215.95,-5.05>
  }
  triangle { // #514
		<1009.8,215.95,-2.6>,
		<1002.55,215.95,-3.6>,
		<1002.55,215.95,-2.6>
  }
  triangle { // #515
		<1009.8,215.95,-2.6>,
		<1003.25,215.95,-3.6>,
		<1002.55,215.95,-3.6>
  }
  triangle { // #516
		<1009.8,215.95,-2.6>,
		<1006.8,215.95,-5.05>,
		<1003.25,215.95,-3.6>
  }
  triangle { // #517
		<1009.8,0,-2.6>,
		<1002.55,215.95,-2.6>,
		<1002.55,0,-2.6>
  }
  triangle { // #518
		<1002.55,215.95,-2.6>,
		<1009.8,0,-2.6>,
		<1009.8,215.95,-2.6>
  }
  triangle { // #519
		<1002.55,0,-2.6>,
		<1002.55,215.95,-3.6>,
		<1002.55,0,-3.6>
  }
  triangle { // #520
		<1002.55,215.95,-3.6>,
		<1002.55,0,-2.6>,
		<1002.55,215.95,-2.6>
  }
  smooth_triangle { // #521
		<1002.55,0,-3.6>, <0,1,0>,
		<1003.25,215.95,-3.6>, <-0.129,0.992,0>,
		<1003.25,0,-3.6>, <-0.258,0.966,0>
  }
  smooth_triangle { // #522
		<1003.25,215.95,-3.6>, <-0.129,0.992,0>,
		<1002.55,0,-3.6>, <0,1,0>,
		<1002.55,215.95,-3.6>, <0,1,0>
  }
  smooth_triangle { // #523
		<1003.25,0,-3.6>, <-0.258,0.966,0>,
		<1006.8,215.95,-5.05>, <-0.258,0.966,0>,
		<1006.8,0,-5.05>, <-0.129,0.992,0>
  }
  smooth_triangle { // #524
		<1006.8,215.95,-5.05>, <-0.258,0.966,0>,
		<1003.25,0,-3.6>, <-0.258,0.966,0>,
		<1003.25,215.95,-3.6>, <-0.129,0.992,0>
  }
  smooth_triangle { // #525
		<1006.8,0,-5.05>, <-0.129,0.992,0>,
		<1009.8,215.95,-5.05>, <0,1,0>,
		<1009.8,0,-5.05>, <0,1,0>
  }
  smooth_triangle { // #526
		<1009.8,215.95,-5.05>, <0,1,0>,
		<1006.8,0,-5.05>, <-0.129,0.992,0>,
		<1006.8,215.95,-5.05>, <-0.258,0.966,0>
  }
  triangle { // #527
		<1009.8,0,-5.05>,
		<1009.8,215.95,-2.6>,
		<1009.8,0,-2.6>
  }
  triangle { // #528
		<1009.8,215.95,-2.6>,
		<1009.8,0,-5.05>,
		<1009.8,215.95,-5.05>
  }
  triangle { // #529
		<912.7,0,0.8>,
		<908.45,0,-5.05>,
		<912,0,-3.6>
  }
  triangle { // #530
		<914.25,0,4.35>,
		<912.7,0,0.8>,
		<914.25,0,0.8>
  }
  triangle { // #531
		<912.7,0,4.35>,
		<912.7,0,0.8>,
		<914.25,0,4.35>
  }
  triangle { // #532
		<912.7,0,0.8>,
		<912,0,-3.6>,
		<912.7,0,-3.6>
  }
  triangle { // #533
		<905.45,0,9.4>,
		<912.7,0,4.35>,
		<912.7,0,9.4>
  }
  triangle { // #534
		<905.45,0,-5.05>,
		<912.7,0,4.35>,
		<905.45,0,9.4>
  }
  triangle { // #535
		<905.45,0,-5.05>,
		<912.7,0,0.8>,
		<912.7,0,4.35>
  }
  triangle { // #536
		<908.45,0,-5.05>,
		<912.7,0,0.8>,
		<905.45,0,-5.05>
  }
  triangle { // #537
		<908.45,215.95,-5.05>,
		<912.7,215.95,0.8>,
		<912,215.95,-3.6>
  }
  triangle { // #538
		<914.25,215.95,0.8>,
		<912.7,215.95,4.35>,
		<914.25,215.95,4.35>
  }
  triangle { // #539
		<912.7,215.95,0.8>,
		<912.7,215.95,4.35>,
		<914.25,215.95,0.8>
  }
  triangle { // #540
		<912,215.95,-3.6>,
		<912.7,215.95,0.8>,
		<912.7,215.95,-3.6>
  }
  triangle { // #541
		<912.7,215.95,4.35>,
		<905.45,215.95,9.4>,
		<912.7,215.95,9.4>
  }
  triangle { // #542
		<912.7,215.95,4.35>,
		<905.45,215.95,-5.05>,
		<905.45,215.95,9.4>
  }
  triangle { // #543
		<912.7,215.95,0.8>,
		<905.45,215.95,-5.05>,
		<912.7,215.95,4.35>
  }
  triangle { // #544
		<912.7,215.95,0.8>,
		<908.45,215.95,-5.05>,
		<905.45,215.95,-5.05>
  }
  triangle { // #545
		<905.45,0,9.4>,
		<905.45,215.95,-5.05>,
		<905.45,0,-5.05>
  }
  triangle { // #546
		<905.45,215.95,-5.05>,
		<905.45,0,9.4>,
		<905.45,215.95,9.4>
  }
  smooth_triangle { // #547
		<905.45,0,-5.05>, <0,1,0>,
		<908.45,215.95,-5.05>, <0.129,0.992,0>,
		<908.45,0,-5.05>, <0.258,0.966,0>
  }
  smooth_triangle { // #548
		<908.45,215.95,-5.05>, <0.129,0.992,0>,
		<905.45,0,-5.05>, <0,1,0>,
		<905.45,215.95,-5.05>, <0,1,0>
  }
  smooth_triangle { // #549
		<908.45,0,-5.05>, <0.258,0.966,0>,
		<912,215.95,-3.6>, <0.258,0.966,0>,
		<912,0,-3.6>, <0.129,0.992,0>
  }
  smooth_triangle { // #550
		<912,215.95,-3.6>, <0.258,0.966,0>,
		<908.45,0,-5.05>, <0.258,0.966,0>,
		<908.45,215.95,-5.05>, <0.129,0.992,0>
  }
  smooth_triangle { // #551
		<912,0,-3.6>, <0.129,0.992,0>,
		<912.7,215.95,-3.6>, <0,1,0>,
		<912.7,0,-3.6>, <0,1,0>
  }
  smooth_triangle { // #552
		<912.7,215.95,-3.6>, <0,1,0>,
		<912,0,-3.6>, <0.129,0.992,0>,
		<912,215.95,-3.6>, <0.258,0.966,0>
  }
  triangle { // #553
		<912.7,0,-3.6>,
		<912.7,215.95,0.8>,
		<912.7,0,0.8>
  }
  triangle { // #554
		<912.7,215.95,0.8>,
		<912.7,0,-3.6>,
		<912.7,215.95,-3.6>
  }
  triangle { // #555
		<912.7,0,0.8>,
		<914.25,215.95,0.8>,
		<914.25,0,0.8>
  }
  triangle { // #556
		<914.25,215.95,0.8>,
		<912.7,0,0.8>,
		<912.7,215.95,0.8>
  }
  triangle { // #557
		<914.25,0,0.8>,
		<914.25,215.95,4.35>,
		<914.25,0,4.35>
  }
  triangle { // #558
		<914.25,215.95,4.35>,
		<914.25,0,0.8>,
		<914.25,215.95,0.8>
  }
  triangle { // #559
		<914.25,0,4.35>,
		<912.7,215.95,4.35>,
		<912.7,0,4.35>
  }
  triangle { // #560
		<912.7,215.95,4.35>,
		<914.25,0,4.35>,
		<914.25,215.95,4.35>
  }
  triangle { // #561
		<912.7,0,4.35>,
		<912.7,215.95,9.4>,
		<912.7,0,9.4>
  }
  triangle { // #562
		<912.7,215.95,9.4>,
		<912.7,0,4.35>,
		<912.7,215.95,4.35>
  }
  triangle { // #563
		<912.7,0,9.4>,
		<905.45,215.95,9.4>,
		<905.45,0,9.4>
  }
  triangle { // #564
		<905.45,215.95,9.4>,
		<912.7,0,9.4>,
		<912.7,215.95,9.4>
  }
  triangle { // #565
		<905.45,208.7,-2.6>,
		<905.45,209.4,-3.6>,
		<905.45,208.7,-3.6>
  }
  triangle { // #566
		<905.45,212.9,-5.05>,
		<905.45,215.95,-2.6>,
		<905.45,215.95,-5.05>
  }
  triangle { // #567
		<905.45,212.9,-5.05>,
		<905.45,208.7,-2.6>,
		<905.45,215.95,-2.6>
  }
  triangle { // #568
		<905.45,209.4,-3.6>,
		<905.45,208.7,-2.6>,
		<905.45,212.9,-5.05>
  }
  triangle { // #569
		<1009.8,209.4,-3.6>,
		<1009.8,208.7,-2.6>,
		<1009.8,208.7,-3.6>
  }
  triangle { // #570
		<1009.8,215.95,-2.6>,
		<1009.8,212.9,-5.05>,
		<1009.8,215.95,-5.05>
  }
  triangle { // #571
		<1009.8,208.7,-2.6>,
		<1009.8,212.9,-5.05>,
		<1009.8,215.95,-2.6>
  }
  triangle { // #572
		<1009.8,208.7,-2.6>,
		<1009.8,209.4,-3.6>,
		<1009.8,212.9,-5.05>
  }
  triangle { // #573
		<905.45,208.7,-2.6>,
		<1009.8,215.95,-2.6>,
		<905.45,215.95,-2.6>
  }
  triangle { // #574
		<1009.8,215.95,-2.6>,
		<905.45,208.7,-2.6>,
		<1009.8,208.7,-2.6>
  }
  triangle { // #575
		<905.45,215.95,-2.6>,
		<1009.8,215.95,-5.05>,
		<905.45,215.95,-5.05>
  }
  triangle { // #576
		<1009.8,215.95,-5.05>,
		<905.45,215.95,-2.6>,
		<1009.8,215.95,-2.6>
  }
  smooth_triangle { // #577
		<905.45,215.95,-5.05>, <0,1,0>,
		<1009.8,212.9,-5.05>, <0,0.992,-0.129>,
		<905.45,212.9,-5.05>, <0,0.966,-0.258>
  }
  smooth_triangle { // #578
		<1009.8,212.9,-5.05>, <0,0.992,-0.129>,
		<905.45,215.95,-5.05>, <0,1,0>,
		<1009.8,215.95,-5.05>, <0,1,0>
  }
  smooth_triangle { // #579
		<905.45,212.9,-5.05>, <0,0.966,-0.258>,
		<1009.8,209.4,-3.6>, <0,0.966,-0.258>,
		<905.45,209.4,-3.6>, <0,0.992,-0.129>
  }
  smooth_triangle { // #580
		<1009.8,209.4,-3.6>, <0,0.966,-0.258>,
		<905.45,212.9,-5.05>, <0,0.966,-0.258>,
		<1009.8,212.9,-5.05>, <0,0.992,-0.129>
  }
  smooth_triangle { // #581
		<905.45,209.4,-3.6>, <0,0.992,-0.129>,
		<1009.8,208.7,-3.6>, <0,1,0>,
		<905.45,208.7,-3.6>, <0,1,0>
  }
  smooth_triangle { // #582
		<1009.8,208.7,-3.6>, <0,1,0>,
		<905.45,209.4,-3.6>, <0,0.992,-0.129>,
		<1009.8,209.4,-3.6>, <0,0.966,-0.258>
  }
  triangle { // #583
		<905.45,208.7,-3.6>,
		<1009.8,208.7,-2.6>,
		<905.45,208.7,-2.6>
  }
  triangle { // #584
		<1009.8,208.7,-2.6>,
		<905.45,208.7,-3.6>,
		<1009.8,208.7,-3.6>
  }
  triangle { // #585
		<-840.35,-99,321.9>,
		<-725,-99,341.8>,
		<-840.35,-99,335.1>
  }
  triangle { // #586
		<-695.2,-99,254.3>,
		<-682.05,-99,261.85>,
		<-725,-99,341.8>
  }
  triangle { // #587
		<-682.05,-99,261.85>,
		<-715.2,-99,354.7>,
		<-725,-99,341.8>
  }
  triangle { // #588
		<-715.2,-99,354.7>,
		<-840.35,-99,335.1>,
		<-725,-99,341.8>
  }
  triangle { // #589
		<-840.35,806.25,321.9>,
		<-840.35,806.25,335.1>,
		<-725,806.25,341.8>
  }
  triangle { // #590
		<-695.2,806.25,254.3>,
		<-725,806.25,341.8>,
		<-682.05,806.25,261.85>
  }
  triangle { // #591
		<-682.05,806.25,261.85>,
		<-725,806.25,341.8>,
		<-715.2,806.25,354.7>
  }
  triangle { // #592
		<-715.2,806.25,354.7>,
		<-725,806.25,341.8>,
		<-840.35,806.25,335.1>
  }
  triangle { // #593
		<-695.2,-99,254.3>,
		<-695.2,806.25,254.3>,
		<-682.05,-99,261.85>
  }
  triangle { // #594
		<-682.05,806.25,261.85>,
		<-682.05,-99,261.85>,
		<-695.2,806.25,254.3>
  }
  triangle { // #595
		<-725,-99,341.8>,
		<-725,806.25,341.8>,
		<-695.2,-99,254.3>
  }
  triangle { // #596
		<-695.2,806.25,254.3>,
		<-695.2,-99,254.3>,
		<-725,806.25,341.8>
  }
  triangle { // #597
		<-840.35,-99,321.9>,
		<-840.35,806.25,321.9>,
		<-725,-99,341.8>
  }
  triangle { // #598
		<-725,806.25,341.8>,
		<-725,-99,341.8>,
		<-840.35,806.25,321.9>
  }
  triangle { // #599
		<-840.35,-99,335.1>,
		<-840.35,806.25,335.1>,
		<-840.35,-99,321.9>
  }
  triangle { // #600
		<-840.35,806.25,321.9>,
		<-840.35,-99,321.9>,
		<-840.35,806.25,335.1>
  }
  smooth_triangle { // #601
		<-715.2,-99,354.7>, <-0.155,-0.988,0>,
		<-715.2,806.25,354.7>, <-0.155,-0.988,0>,
		<-840.35,-99,335.1>, <-0.166,-0.986,0>
  }
  smooth_triangle { // #602
		<-840.35,806.25,335.1>, <-0.177,-0.984,0>,
		<-840.35,-99,335.1>, <-0.166,-0.986,0>,
		<-715.2,806.25,354.7>, <-0.155,-0.988,0>
  }
  triangle { // #603
		<-682.05,-99,261.85>,
		<-682.05,806.25,261.85>,
		<-715.2,-99,354.7>
  }
  triangle { // #604
		<-715.2,806.25,354.7>,
		<-715.2,-99,354.7>,
		<-682.05,806.25,261.85>
  }
  triangle { // #605
		<-840.4,-99,483.9>,
		<-781.15,-99,505.3>,
		<-840.35,-99,499.05>
  }
  triangle { // #606
		<-840.15,-99,678.8>,
		<-760.8,-99,492.25>,
		<-840,-99,725.25>
  }
  triangle { // #607
		<-781.15,-99,505.3>,
		<-760.8,-99,492.25>,
		<-840.15,-99,678.8>
  }
  triangle { // #608
		<-781.15,-99,505.3>,
		<-840.4,-99,483.9>,
		<-760.8,-99,492.25>
  }
  triangle { // #609
		<-781.15,806.25,505.3>,
		<-840.4,806.25,483.9>,
		<-840.35,806.25,499.05>
  }
  triangle { // #610
		<-760.8,806.25,492.25>,
		<-840.15,806.25,678.8>,
		<-840,806.25,725.25>
  }
  triangle { // #611
		<-760.8,806.25,492.25>,
		<-781.15,806.25,505.3>,
		<-840.15,806.25,678.8>
  }
  triangle { // #612
		<-840.4,806.25,483.9>,
		<-781.15,806.25,505.3>,
		<-760.8,806.25,492.25>
  }
  triangle { // #613
		<-840.35,-99,499.05>,
		<-840.4,806.25,483.9>,
		<-840.4,-99,483.9>
  }
  triangle { // #614
		<-840.4,806.25,483.9>,
		<-840.35,-99,499.05>,
		<-840.35,806.25,499.05>
  }
  triangle { // #615
		<-840.4,-99,483.9>,
		<-760.8,806.25,492.25>,
		<-760.8,-99,492.25>
  }
  triangle { // #616
		<-760.8,806.25,492.25>,
		<-840.4,-99,483.9>,
		<-840.4,806.25,483.9>
  }
  triangle { // #617
		<-760.8,-99,492.25>,
		<-840,806.25,725.25>,
		<-840,-99,725.25>
  }
  triangle { // #618
		<-840,806.25,725.25>,
		<-760.8,-99,492.25>,
		<-760.8,806.25,492.25>
  }
  smooth_triangle { // #619
		<-840,-99,725.25>, <-1,-0.003,0>,
		<-840.15,806.25,678.8>, <-0.994,0.107,0>,
		<-840.15,-99,678.8>, <-0.976,0.216,0>
  }
  smooth_triangle { // #620
		<-840.15,806.25,678.8>, <-0.994,0.107,0>,
		<-840,-99,725.25>, <-1,-0.003,0>,
		<-840,806.25,725.25>, <-1,-0.003,0>
  }
  smooth_triangle { // #621
		<-840.15,-99,678.8>, <-0.976,0.216,0>,
		<-781.15,806.25,505.3>, <-0.947,0.322,0>,
		<-781.15,-99,505.3>, <-0.947,0.322,0>
  }
  smooth_triangle { // #622
		<-781.15,806.25,505.3>, <-0.947,0.322,0>,
		<-840.15,-99,678.8>, <-0.976,0.216,0>,
		<-840.15,806.25,678.8>, <-0.994,0.107,0>
  }
  triangle { // #623
		<-781.15,-99,505.3>,
		<-840.35,806.25,499.05>,
		<-840.35,-99,499.05>
  }
  triangle { // #624
		<-840.35,806.25,499.05>,
		<-781.15,-99,505.3>,
		<-781.15,806.25,505.3>
  }
  triangle { // #625
		<-840,-99,1093>,
		<-796.55,-99,896.1>,
		<-839.5,-99,1196.75>
  }
  triangle { // #626
		<-796.55,-99,896.1>,
		<-840,-99,1093>,
		<-811.05,-99,896.1>
  }
  triangle { // #627
		<-840,806.25,1093>,
		<-796.55,806.25,896.1>,
		<-811.05,806.25,896.1>
  }
  triangle { // #628
		<-796.55,806.25,896.1>,
		<-840,806.25,1093>,
		<-839.5,806.25,1196.75>
  }
  smooth_triangle { // #629
		<-840,-99,1093>, <-0.995,0.096,0>,
		<-811.05,806.25,896.1>, <-0.979,0.202,0>,
		<-811.05,-99,896.1>, <-0.966,0.257,0>
  }
  smooth_triangle { // #630
		<-811.05,806.25,896.1>, <-0.979,0.202,0>,
		<-840,-99,1093>, <-0.995,0.096,0>,
		<-840,806.25,1093>, <-0.999,0.045,0>
  }
  triangle { // #631
		<-811.05,-99,896.1>,
		<-796.55,806.25,896.1>,
		<-796.55,-99,896.1>
  }
  triangle { // #632
		<-796.55,806.25,896.1>,
		<-811.05,-99,896.1>,
		<-811.05,806.25,896.1>
  }
  triangle { // #633
		<-796.55,-99,896.1>,
		<-839.5,806.25,1196.75>,
		<-839.5,-99,1196.75>
  }
  triangle { // #634
		<-839.5,806.25,1196.75>,
		<-796.55,-99,896.1>,
		<-796.55,806.25,896.1>
  }
  smooth_triangle { // #635
		<-839.5,-99,1196.75>, <-1,-0.005,0>,
		<-840,806.25,1093>, <-0.999,0.045,0>,
		<-840,-99,1093>, <-0.995,0.096,0>
  }
  smooth_triangle { // #636
		<-840,806.25,1093>, <-0.999,0.045,0>,
		<-839.5,-99,1196.75>, <-1,-0.005,0>,
		<-839.5,806.25,1196.75>, <-1,-0.005,0>
  }
  triangle { // #637
		<-793.65,-99,887.9>,
		<-797,806.25,897.25>,
		<-797,-99,897.25>
  }
  triangle { // #638
		<-797,806.25,897.25>,
		<-793.65,-99,887.9>,
		<-793.65,806.25,887.9>
  }
  triangle { // #639
		<-790.45,-99,879.05>,
		<-793.65,806.25,887.9>,
		<-793.65,-99,887.9>
  }
  triangle { // #640
		<-793.65,806.25,887.9>,
		<-790.45,-99,879.05>,
		<-790.45,806.25,879.05>
  }
  triangle { // #641
		<-787.45,-99,870.7>,
		<-790.45,806.25,879.05>,
		<-790.45,-99,879.05>
  }
  triangle { // #642
		<-790.45,806.25,879.05>,
		<-787.45,-99,870.7>,
		<-787.45,806.25,870.7>
  }
  triangle { // #643
		<-784.6,-99,862.85>,
		<-787.45,806.25,870.7>,
		<-787.45,-99,870.7>
  }
  triangle { // #644
		<-787.45,806.25,870.7>,
		<-784.6,-99,862.85>,
		<-784.6,806.25,862.85>
  }
  triangle { // #645
		<-781.85,-99,855.45>,
		<-784.6,806.25,862.85>,
		<-784.6,-99,862.85>
  }
  triangle { // #646
		<-784.6,806.25,862.85>,
		<-781.85,-99,855.45>,
		<-781.85,806.25,855.45>
  }
  triangle { // #647
		<-779.3,-99,848.6>,
		<-781.85,806.25,855.45>,
		<-781.85,-99,855.45>
  }
  triangle { // #648
		<-781.85,806.25,855.45>,
		<-779.3,-99,848.6>,
		<-779.3,806.25,848.6>
  }
  triangle { // #649
		<-776.9,-99,842.2>,
		<-779.3,806.25,848.6>,
		<-779.3,-99,848.6>
  }
  triangle { // #650
		<-779.3,806.25,848.6>,
		<-776.9,-99,842.2>,
		<-776.9,806.25,842.2>
  }
  triangle { // #651
		<-774.65,-99,836.3>,
		<-776.9,806.25,842.2>,
		<-776.9,-99,842.2>
  }
  triangle { // #652
		<-776.9,806.25,842.2>,
		<-774.65,-99,836.3>,
		<-774.65,806.25,836.3>
  }
  triangle { // #653
		<-772.55,-99,830.9>,
		<-774.65,806.25,836.3>,
		<-774.65,-99,836.3>
  }
  triangle { // #654
		<-774.65,806.25,836.3>,
		<-772.55,-99,830.9>,
		<-772.55,806.25,830.9>
  }
  triangle { // #655
		<-770.6,-99,826>,
		<-772.55,806.25,830.9>,
		<-772.55,-99,830.9>
  }
  triangle { // #656
		<-772.55,806.25,830.9>,
		<-770.6,-99,826>,
		<-770.6,806.25,826>
  }
  triangle { // #657
		<-768.8,-99,821.6>,
		<-770.6,806.25,826>,
		<-770.6,-99,826>
  }
  triangle { // #658
		<-770.6,806.25,826>,
		<-768.8,-99,821.6>,
		<-768.8,806.25,821.6>
  }
  triangle { // #659
		<-767.15,-99,817.65>,
		<-768.8,806.25,821.6>,
		<-768.8,-99,821.6>
  }
  triangle { // #660
		<-768.8,806.25,821.6>,
		<-767.15,-99,817.65>,
		<-767.15,806.25,817.65>
  }
  triangle { // #661
		<-765.7,-99,814.25>,
		<-767.15,806.25,817.65>,
		<-767.15,-99,817.65>
  }
  smooth_triangle { // #662
		<-767.15,806.25,817.65>, <0.92,-0.393,0>,
		<-765.7,-99,814.25>, <0.916,-0.402,0>,
		<-765.7,806.25,814.25>, <0.913,-0.407,0>
  }
  smooth_triangle { // #663
		<-764.35,-99,811.3>, <0.908,-0.419,0>,
		<-765.7,806.25,814.25>, <0.913,-0.407,0>,
		<-765.7,-99,814.25>, <0.916,-0.402,0>
  }
  smooth_triangle { // #664
		<-765.7,806.25,814.25>, <0.913,-0.407,0>,
		<-764.35,-99,811.3>, <0.908,-0.419,0>,
		<-764.35,806.25,811.3>, <0.905,-0.426,0>
  }
  smooth_triangle { // #665
		<-763.2,-99,808.85>, <0.896,-0.443,0>,
		<-764.35,806.25,811.3>, <0.905,-0.426,0>,
		<-764.35,-99,811.3>, <0.908,-0.419,0>
  }
  smooth_triangle { // #666
		<-764.35,806.25,811.3>, <0.905,-0.426,0>,
		<-763.2,-99,808.85>, <0.896,-0.443,0>,
		<-763.2,806.25,808.85>, <0.891,-0.454,0>
  }
  smooth_triangle { // #667
		<-762.15,-99,806.9>, <0.883,-0.469,0>,
		<-763.2,806.25,808.85>, <0.891,-0.454,0>,
		<-763.2,-99,808.85>, <0.896,-0.443,0>
  }
  smooth_triangle { // #668
		<-763.2,806.25,808.85>, <0.891,-0.454,0>,
		<-762.15,-99,806.9>, <0.883,-0.469,0>,
		<-762.15,806.25,806.9>, <0.88,-0.474,0>
  }
  smooth_triangle { // #669
		<-761.25,-99,805.2>, <0.88,-0.476,0>,
		<-762.15,806.25,806.9>, <0.88,-0.474,0>,
		<-762.15,-99,806.9>, <0.883,-0.469,0>
  }
  triangle { // #670
		<-762.15,806.25,806.9>,
		<-761.25,-99,805.2>,
		<-761.25,806.25,805.2>
  }
  triangle { // #671
		<-760.3,-99,803.45>,
		<-761.25,806.25,805.2>,
		<-761.25,-99,805.2>
  }
  triangle { // #672
		<-761.25,806.25,805.2>,
		<-760.3,-99,803.45>,
		<-760.3,806.25,803.45>
  }
  triangle { // #673
		<-759.4,-99,801.65>,
		<-760.3,806.25,803.45>,
		<-760.3,-99,803.45>
  }
  triangle { // #674
		<-760.3,806.25,803.45>,
		<-759.4,-99,801.65>,
		<-759.4,806.25,801.65>
  }
  triangle { // #675
		<-758.45,-99,799.85>,
		<-759.4,806.25,801.65>,
		<-759.4,-99,801.65>
  }
  triangle { // #676
		<-759.4,806.25,801.65>,
		<-758.45,-99,799.85>,
		<-758.45,806.25,799.85>
  }
  triangle { // #677
		<-757.55,-99,798>,
		<-758.45,806.25,799.85>,
		<-758.45,-99,799.85>
  }
  triangle { // #678
		<-758.45,806.25,799.85>,
		<-757.55,-99,798>,
		<-757.55,806.25,798>
  }
  triangle { // #679
		<-756.7,-99,796.15>,
		<-757.55,806.25,798>,
		<-757.55,-99,798>
  }
  triangle { // #680
		<-757.55,806.25,798>,
		<-756.7,-99,796.15>,
		<-756.7,806.25,796.15>
  }
  triangle { // #681
		<-755.8,-99,794.25>,
		<-756.7,806.25,796.15>,
		<-756.7,-99,796.15>
  }
  triangle { // #682
		<-756.7,806.25,796.15>,
		<-755.8,-99,794.25>,
		<-755.8,806.25,794.25>
  }
  triangle { // #683
		<-754.95,-99,792.3>,
		<-755.8,806.25,794.25>,
		<-755.8,-99,794.25>
  }
  triangle { // #684
		<-755.8,806.25,794.25>,
		<-754.95,-99,792.3>,
		<-754.95,806.25,792.3>
  }
  triangle { // #685
		<-754.1,-99,790.35>,
		<-754.95,806.25,792.3>,
		<-754.95,-99,792.3>
  }
  triangle { // #686
		<-754.95,806.25,792.3>,
		<-754.1,-99,790.35>,
		<-754.1,806.25,790.35>
  }
  triangle { // #687
		<-753.25,-99,788.4>,
		<-754.1,806.25,790.35>,
		<-754.1,-99,790.35>
  }
  triangle { // #688
		<-754.1,806.25,790.35>,
		<-753.25,-99,788.4>,
		<-753.25,806.25,788.4>
  }
  triangle { // #689
		<-752.4,-99,786.35>,
		<-753.25,806.25,788.4>,
		<-753.25,-99,788.4>
  }
  triangle { // #690
		<-753.25,806.25,788.4>,
		<-752.4,-99,786.35>,
		<-752.4,806.25,786.35>
  }
  triangle { // #691
		<-751.55,-99,784.3>,
		<-752.4,806.25,786.35>,
		<-752.4,-99,786.35>
  }
  triangle { // #692
		<-752.4,806.25,786.35>,
		<-751.55,-99,784.3>,
		<-751.55,806.25,784.3>
  }
  triangle { // #693
		<-750.75,-99,782.25>,
		<-751.55,806.25,784.3>,
		<-751.55,-99,784.3>
  }
  triangle { // #694
		<-751.55,806.25,784.3>,
		<-750.75,-99,782.25>,
		<-750.75,806.25,782.25>
  }
  triangle { // #695
		<-749.95,-99,780.1>,
		<-750.75,806.25,782.25>,
		<-750.75,-99,782.25>
  }
  triangle { // #696
		<-750.75,806.25,782.25>,
		<-749.95,-99,780.1>,
		<-749.95,806.25,780.1>
  }
  triangle { // #697
		<-749.15,-99,778>,
		<-749.95,806.25,780.1>,
		<-749.95,-99,780.1>
  }
  triangle { // #698
		<-749.95,806.25,780.1>,
		<-749.15,-99,778>,
		<-749.15,806.25,778>
  }
  triangle { // #699
		<-748.35,-99,775.8>,
		<-749.15,806.25,778>,
		<-749.15,-99,778>
  }
  triangle { // #700
		<-749.15,806.25,778>,
		<-748.35,-99,775.8>,
		<-748.35,806.25,775.8>
  }
  triangle { // #701
		<-747.55,-99,773.65>,
		<-748.35,806.25,775.8>,
		<-748.35,-99,775.8>
  }
  smooth_triangle { // #702
		<-748.35,806.25,775.8>, <0.942,-0.335,0>,
		<-747.55,-99,773.65>, <0.945,-0.326,0>,
		<-747.55,806.25,773.65>, <0.947,-0.32,0>
  }
  smooth_triangle { // #703
		<-746.85,-99,771.5>, <0.951,-0.31,0>,
		<-747.55,806.25,773.65>, <0.947,-0.32,0>,
		<-747.55,-99,773.65>, <0.945,-0.326,0>
  }
  smooth_triangle { // #704
		<-747.55,806.25,773.65>, <0.947,-0.32,0>,
		<-746.85,-99,771.5>, <0.951,-0.31,0>,
		<-746.85,806.25,771.5>, <0.953,-0.304,0>
  }
  smooth_triangle { // #705
		<-746.2,-99,769.35>, <0.956,-0.293,0>,
		<-746.85,806.25,771.5>, <0.953,-0.304,0>,
		<-746.85,-99,771.5>, <0.951,-0.31,0>
  }
  smooth_triangle { // #706
		<-746.85,806.25,771.5>, <0.953,-0.304,0>,
		<-746.2,-99,769.35>, <0.956,-0.293,0>,
		<-746.2,806.25,769.35>, <0.958,-0.287,0>
  }
  smooth_triangle { // #707
		<-745.55,-99,767.25>, <0.961,-0.276,0>,
		<-746.2,806.25,769.35>, <0.958,-0.287,0>,
		<-746.2,-99,769.35>, <0.956,-0.293,0>
  }
  smooth_triangle { // #708
		<-746.2,806.25,769.35>, <0.958,-0.287,0>,
		<-745.55,-99,767.25>, <0.961,-0.276,0>,
		<-745.55,806.25,767.25>, <0.963,-0.27,0>
  }
  smooth_triangle { // #709
		<-745,-99,765.15>, <0.966,-0.258,0>,
		<-745.55,806.25,767.25>, <0.963,-0.27,0>,
		<-745.55,-99,767.25>, <0.961,-0.276,0>
  }
  smooth_triangle { // #710
		<-745.55,806.25,767.25>, <0.963,-0.27,0>,
		<-745,-99,765.15>, <0.966,-0.258,0>,
		<-745,806.25,765.15>, <0.968,-0.252,0>
  }
  smooth_triangle { // #711
		<-744.45,-99,763.05>, <0.971,-0.239,0>,
		<-745,806.25,765.15>, <0.968,-0.252,0>,
		<-745,-99,765.15>, <0.966,-0.258,0>
  }
  smooth_triangle { // #712
		<-745,806.25,765.15>, <0.968,-0.252,0>,
		<-744.45,-99,763.05>, <0.971,-0.239,0>,
		<-744.45,806.25,763.05>, <0.972,-0.233,0>
  }
  smooth_triangle { // #713
		<-744,-99,761>, <0.975,-0.22,0>,
		<-744.45,806.25,763.05>, <0.972,-0.233,0>,
		<-744.45,-99,763.05>, <0.971,-0.239,0>
  }
  smooth_triangle { // #714
		<-744.45,806.25,763.05>, <0.972,-0.233,0>,
		<-744,-99,761>, <0.975,-0.22,0>,
		<-744,806.25,761>, <0.977,-0.214,0>
  }
  smooth_triangle { // #715
		<-743.55,-99,759>, <0.98,-0.201,0>,
		<-744,806.25,761>, <0.977,-0.214,0>,
		<-744,-99,761>, <0.975,-0.22,0>
  }
  smooth_triangle { // #716
		<-744,806.25,761>, <0.977,-0.214,0>,
		<-743.55,-99,759>, <0.98,-0.201,0>,
		<-743.55,806.25,759>, <0.981,-0.194,0>
  }
  smooth_triangle { // #717
		<-743.2,-99,756.95>, <0.984,-0.18,0>,
		<-743.55,806.25,759>, <0.981,-0.194,0>,
		<-743.55,-99,759>, <0.98,-0.201,0>
  }
  smooth_triangle { // #718
		<-743.55,806.25,759>, <0.981,-0.194,0>,
		<-743.2,-99,756.95>, <0.984,-0.18,0>,
		<-743.2,806.25,756.95>, <0.985,-0.173,0>
  }
  smooth_triangle { // #719
		<-742.85,-99,755>, <0.987,-0.159,0>,
		<-743.2,806.25,756.95>, <0.985,-0.173,0>,
		<-743.2,-99,756.95>, <0.984,-0.18,0>
  }
  smooth_triangle { // #720
		<-743.2,806.25,756.95>, <0.985,-0.173,0>,
		<-742.85,-99,755>, <0.987,-0.159,0>,
		<-742.85,806.25,755>, <0.988,-0.152,0>
  }
  smooth_triangle { // #721
		<-742.55,-99,753>, <0.99,-0.138,0>,
		<-742.85,806.25,755>, <0.988,-0.152,0>,
		<-742.85,-99,755>, <0.987,-0.159,0>
  }
  smooth_triangle { // #722
		<-742.85,806.25,755>, <0.988,-0.152,0>,
		<-742.55,-99,753>, <0.99,-0.138,0>,
		<-742.55,806.25,753>, <0.991,-0.13,0>
  }
  smooth_triangle { // #723
		<-742.3,-99,751.05>, <0.993,-0.115,0>,
		<-742.55,806.25,753>, <0.991,-0.13,0>,
		<-742.55,-99,753>, <0.99,-0.138,0>
  }
  smooth_triangle { // #724
		<-742.55,806.25,753>, <0.991,-0.13,0>,
		<-742.3,-99,751.05>, <0.993,-0.115,0>,
		<-742.3,806.25,751.05>, <0.994,-0.108,0>
  }
  smooth_triangle { // #725
		<-742.1,-99,749.1>, <0.996,-0.092,0>,
		<-742.3,806.25,751.05>, <0.994,-0.108,0>,
		<-742.3,-99,751.05>, <0.993,-0.115,0>
  }
  smooth_triangle { // #726
		<-742.3,806.25,751.05>, <0.994,-0.108,0>,
		<-742.1,-99,749.1>, <0.996,-0.092,0>,
		<-742.1,806.25,749.1>, <0.996,-0.085,0>
  }
  smooth_triangle { // #727
		<-741.95,-99,747.2>, <0.998,-0.069,0>,
		<-742.1,806.25,749.1>, <0.996,-0.085,0>,
		<-742.1,-99,749.1>, <0.996,-0.092,0>
  }
  smooth_triangle { // #728
		<-742.1,806.25,749.1>, <0.996,-0.085,0>,
		<-741.95,-99,747.2>, <0.998,-0.069,0>,
		<-741.95,806.25,747.2>, <0.998,-0.061,0>
  }
  smooth_triangle { // #729
		<-741.85,-99,745.3>, <0.999,-0.045,0>,
		<-741.95,806.25,747.2>, <0.998,-0.061,0>,
		<-741.95,-99,747.2>, <0.998,-0.069,0>
  }
  smooth_triangle { // #730
		<-741.95,806.25,747.2>, <0.998,-0.061,0>,
		<-741.85,-99,745.3>, <0.999,-0.045,0>,
		<-741.85,806.25,745.3>, <0.999,-0.036,0>
  }
  smooth_triangle { // #731
		<-741.8,-99,743.45>, <1,-0.022,0>,
		<-741.85,806.25,745.3>, <0.999,-0.036,0>,
		<-741.85,-99,745.3>, <0.999,-0.045,0>
  }
  smooth_triangle { // #732
		<-741.85,806.25,745.3>, <0.999,-0.036,0>,
		<-741.8,-99,743.45>, <1,-0.022,0>,
		<-741.8,806.25,743.45>, <1,-0.015,0>
  }
  smooth_triangle { // #733
		<-741.8,-99,741.6>, <1,-0.003,0>,
		<-741.8,806.25,743.45>, <1,-0.015,0>,
		<-741.8,-99,743.45>, <1,-0.022,0>
  }
  smooth_triangle { // #734
		<-741.8,806.25,743.45>, <1,-0.015,0>,
		<-741.8,-99,741.6>, <1,-0.003,0>,
		<-741.8,806.25,741.6>, <1,0.002,0>
  }
  smooth_triangle { // #735
		<-741.8,-99,739.9>, <1,0.014,0>,
		<-741.8,806.25,741.6>, <1,0.002,0>,
		<-741.8,-99,741.6>, <1,-0.003,0>
  }
  smooth_triangle { // #736
		<-741.8,806.25,741.6>, <1,0.002,0>,
		<-741.8,-99,739.9>, <1,0.014,0>,
		<-741.8,806.25,739.9>, <1,0.02,0>
  }
  smooth_triangle { // #737
		<-741.85,-99,738.25>, <0.999,0.033,0>,
		<-741.8,806.25,739.9>, <1,0.02,0>,
		<-741.8,-99,739.9>, <1,0.014,0>
  }
  smooth_triangle { // #738
		<-741.8,806.25,739.9>, <1,0.02,0>,
		<-741.85,-99,738.25>, <0.999,0.033,0>,
		<-741.85,806.25,738.25>, <0.999,0.039,0>
  }
  smooth_triangle { // #739
		<-741.95,-99,736.7>, <0.999,0.054,0>,
		<-741.85,806.25,738.25>, <0.999,0.039,0>,
		<-741.85,-99,738.25>, <0.999,0.033,0>
  }
  smooth_triangle { // #740
		<-741.85,806.25,738.25>, <0.999,0.039,0>,
		<-741.95,-99,736.7>, <0.999,0.054,0>,
		<-741.95,806.25,736.7>, <0.998,0.061,0>
  }
  smooth_triangle { // #741
		<-742.05,-99,735.3>, <0.997,0.077,0>,
		<-741.95,806.25,736.7>, <0.998,0.061,0>,
		<-741.95,-99,736.7>, <0.999,0.054,0>
  }
  smooth_triangle { // #742
		<-741.95,806.25,736.7>, <0.998,0.061,0>,
		<-742.05,-99,735.3>, <0.997,0.077,0>,
		<-742.05,806.25,735.3>, <0.996,0.086,0>
  }
  smooth_triangle { // #743
		<-742.15,-99,733.95>, <0.994,0.105,0>,
		<-742.05,806.25,735.3>, <0.996,0.086,0>,
		<-742.05,-99,735.3>, <0.997,0.077,0>
  }
  smooth_triangle { // #744
		<-742.05,806.25,735.3>, <0.996,0.086,0>,
		<-742.15,-99,733.95>, <0.994,0.105,0>,
		<-742.15,806.25,733.95>, <0.993,0.115,0>
  }
  smooth_triangle { // #745
		<-742.3,-99,732.7>, <0.991,0.136,0>,
		<-742.15,806.25,733.95>, <0.993,0.115,0>,
		<-742.15,-99,733.95>, <0.994,0.105,0>
  }
  smooth_triangle { // #746
		<-742.15,806.25,733.95>, <0.993,0.115,0>,
		<-742.3,-99,732.7>, <0.991,0.136,0>,
		<-742.3,806.25,732.7>, <0.989,0.147,0>
  }
  smooth_triangle { // #747
		<-742.5,-99,731.55>, <0.985,0.171,0>,
		<-742.3,806.25,732.7>, <0.989,0.147,0>,
		<-742.3,-99,732.7>, <0.991,0.136,0>
  }
  smooth_triangle { // #748
		<-742.3,806.25,732.7>, <0.989,0.147,0>,
		<-742.5,-99,731.55>, <0.985,0.171,0>,
		<-742.5,806.25,731.55>, <0.983,0.184,0>
  }
  smooth_triangle { // #749
		<-742.7,-99,730.45>, <0.977,0.213,0>,
		<-742.5,806.25,731.55>, <0.983,0.184,0>,
		<-742.5,-99,731.55>, <0.985,0.171,0>
  }
  smooth_triangle { // #750
		<-742.5,806.25,731.55>, <0.983,0.184,0>,
		<-742.7,-99,730.45>, <0.977,0.213,0>,
		<-742.7,806.25,730.45>, <0.974,0.228,0>
  }
  smooth_triangle { // #751
		<-742.95,-99,729.5>, <0.973,0.233,0>,
		<-742.7,806.25,730.45>, <0.974,0.228,0>,
		<-742.7,-99,730.45>, <0.977,0.213,0>
  }
  smooth_triangle { // #752
		<-742.7,806.25,730.45>, <0.974,0.228,0>,
		<-742.95,-99,729.5>, <0.973,0.233,0>,
		<-742.95,806.25,729.5>, <0.975,0.222,0>
  }
  smooth_triangle { // #753
		<-743.2,-99,728.3>, <0.97,0.243,0>,
		<-742.95,806.25,729.5>, <0.975,0.222,0>,
		<-742.95,-99,729.5>, <0.973,0.233,0>
  }
  smooth_triangle { // #754
		<-742.95,806.25,729.5>, <0.975,0.222,0>,
		<-743.2,-99,728.3>, <0.97,0.243,0>,
		<-743.2,806.25,728.3>, <0.962,0.274,0>
  }
  smooth_triangle { // #755
		<-743.8,-99,726.55>, <0.868,0.496,0>,
		<-743.2,806.25,728.3>, <0.962,0.274,0>,
		<-743.2,-99,728.3>, <0.97,0.243,0>
  }
  smooth_triangle { // #756
		<-743.2,806.25,728.3>, <0.962,0.274,0>,
		<-743.8,-99,726.55>, <0.868,0.496,0>,
		<-743.8,806.25,726.55>, <0.741,0.672,0>
  }
  smooth_triangle { // #757
		<-745.65,-99,725.15>, <0.444,0.896,0>,
		<-743.8,806.25,726.55>, <0.741,0.672,0>,
		<-743.8,-99,726.55>, <0.868,0.496,0>
  }
  smooth_triangle { // #758
		<-743.8,806.25,726.55>, <0.741,0.672,0>,
		<-745.65,-99,725.15>, <0.444,0.896,0>,
		<-745.65,806.25,725.15>, <0.285,0.959,0>
  }
  smooth_triangle { // #759
		<-746.6,-99,725.05>, <0.12,0.993,0>,
		<-745.65,806.25,725.15>, <0.285,0.959,0>,
		<-745.65,-99,725.15>, <0.444,0.896,0>
  }
  smooth_triangle { // #760
		<-745.65,806.25,725.15>, <0.285,0.959,0>,
		<-746.6,-99,725.05>, <0.12,0.993,0>,
		<-746.6,806.25,725.05>, <0.118,0.993,0>
  }
  triangle { // #761
		<-747.45,-99,724.95>,
		<-746.6,806.25,725.05>,
		<-746.6,-99,725.05>
  }
  triangle { // #762
		<-746.6,806.25,725.05>,
		<-747.45,-99,724.95>,
		<-747.45,806.25,724.95>
  }
  triangle { // #763
		<-748.25,-99,724.85>,
		<-747.45,806.25,724.95>,
		<-747.45,-99,724.95>
  }
  triangle { // #764
		<-747.45,806.25,724.95>,
		<-748.25,-99,724.85>,
		<-748.25,806.25,724.85>
  }
  triangle { // #765
		<-749.05,-99,724.8>,
		<-748.25,806.25,724.85>,
		<-748.25,-99,724.85>
  }
  triangle { // #766
		<-748.25,806.25,724.85>,
		<-749.05,-99,724.8>,
		<-749.05,806.25,724.8>
  }
  triangle { // #767
		<-749.8,-99,724.75>,
		<-749.05,806.25,724.8>,
		<-749.05,-99,724.8>
  }
  triangle { // #768
		<-749.05,806.25,724.8>,
		<-749.8,-99,724.75>,
		<-749.8,806.25,724.75>
  }
  triangle { // #769
		<-750.45,-99,724.65>,
		<-749.8,806.25,724.75>,
		<-749.8,-99,724.75>
  }
  triangle { // #770
		<-749.8,806.25,724.75>,
		<-750.45,-99,724.65>,
		<-750.45,806.25,724.65>
  }
  triangle { // #771
		<-751.1,-99,724.65>,
		<-750.45,806.25,724.65>,
		<-750.45,-99,724.65>
  }
  triangle { // #772
		<-750.45,806.25,724.65>,
		<-751.1,-99,724.65>,
		<-751.1,806.25,724.65>
  }
  triangle { // #773
		<-751.7,-99,724.6>,
		<-751.1,806.25,724.65>,
		<-751.1,-99,724.65>
  }
  smooth_triangle { // #774
		<-751.1,806.25,724.65>, <0.058,0.998,0>,
		<-751.7,-99,724.6>, <0.048,0.999,0>,
		<-751.7,806.25,724.6>, <0.042,0.999,0>
  }
  smooth_triangle { // #775
		<-752.25,-99,724.6>, <0.03,1,0>,
		<-751.7,806.25,724.6>, <0.042,0.999,0>,
		<-751.7,-99,724.6>, <0.048,0.999,0>
  }
  smooth_triangle { // #776
		<-751.7,806.25,724.6>, <0.042,0.999,0>,
		<-752.25,-99,724.6>, <0.03,1,0>,
		<-752.25,806.25,724.6>, <0.024,1,0>
  }
  smooth_triangle { // #777
		<-752.75,-99,724.55>, <0.01,1,0>,
		<-752.25,806.25,724.6>, <0.024,1,0>,
		<-752.25,-99,724.6>, <0.03,1,0>
  }
  smooth_triangle { // #778
		<-752.25,806.25,724.6>, <0.024,1,0>,
		<-752.75,-99,724.55>, <0.01,1,0>,
		<-752.75,806.25,724.55>, <0.002,1,0>
  }
  smooth_triangle { // #779
		<-753.25,-99,724.55>, <-0.015,1,0>,
		<-752.75,806.25,724.55>, <0.002,1,0>,
		<-752.75,-99,724.55>, <0.01,1,0>
  }
  smooth_triangle { // #780
		<-752.75,806.25,724.55>, <0.002,1,0>,
		<-753.25,-99,724.55>, <-0.015,1,0>,
		<-753.25,806.25,724.55>, <-0.024,1,0>
  }
  smooth_triangle { // #781
		<-753.65,-99,724.6>, <-0.045,0.999,0>,
		<-753.25,806.25,724.55>, <-0.024,1,0>,
		<-753.25,-99,724.55>, <-0.015,1,0>
  }
  smooth_triangle { // #782
		<-753.25,806.25,724.55>, <-0.024,1,0>,
		<-753.65,-99,724.6>, <-0.045,0.999,0>,
		<-753.65,806.25,724.6>, <-0.057,0.998,0>
  }
  smooth_triangle { // #783
		<-754.05,-99,724.6>, <-0.082,0.997,0>,
		<-753.65,806.25,724.6>, <-0.057,0.998,0>,
		<-753.65,-99,724.6>, <-0.045,0.999,0>
  }
  smooth_triangle { // #784
		<-753.65,806.25,724.6>, <-0.057,0.998,0>,
		<-754.05,-99,724.6>, <-0.082,0.997,0>,
		<-754.05,806.25,724.6>, <-0.097,0.995,0>
  }
  smooth_triangle { // #785
		<-754.35,-99,724.65>, <-0.13,0.991,0>,
		<-754.05,806.25,724.6>, <-0.097,0.995,0>,
		<-754.05,-99,724.6>, <-0.082,0.997,0>
  }
  smooth_triangle { // #786
		<-754.05,806.25,724.6>, <-0.097,0.995,0>,
		<-754.35,-99,724.65>, <-0.13,0.991,0>,
		<-754.35,806.25,724.65>, <-0.149,0.989,0>
  }
  smooth_triangle { // #787
		<-754.65,-99,724.7>, <-0.192,0.981,0>,
		<-754.35,806.25,724.65>, <-0.149,0.989,0>,
		<-754.35,-99,724.65>, <-0.13,0.991,0>
  }
  smooth_triangle { // #788
		<-754.35,806.25,724.65>, <-0.149,0.989,0>,
		<-754.65,-99,724.7>, <-0.192,0.981,0>,
		<-754.65,806.25,724.7>, <-0.217,0.976,0>
  }
  smooth_triangle { // #789
		<-754.9,-99,724.75>, <-0.313,0.95,0>,
		<-754.65,806.25,724.7>, <-0.217,0.976,0>,
		<-754.65,-99,724.7>, <-0.192,0.981,0>
  }
  smooth_triangle { // #790
		<-754.65,806.25,724.7>, <-0.217,0.976,0>,
		<-754.9,-99,724.75>, <-0.313,0.95,0>,
		<-754.9,806.25,724.75>, <-0.383,0.924,0>
  }
  smooth_triangle { // #791
		<-755.1,-99,724.85>, <-0.53,0.848,0>,
		<-754.9,806.25,724.75>, <-0.383,0.924,0>,
		<-754.9,-99,724.75>, <-0.313,0.95,0>
  }
  smooth_triangle { // #792
		<-754.9,806.25,724.75>, <-0.383,0.924,0>,
		<-755.1,-99,724.85>, <-0.53,0.848,0>,
		<-755.1,806.25,724.85>, <-0.605,0.796,0>
  }
  smooth_triangle { // #793
		<-755.3,-99,725.05>, <-0.719,0.695,0>,
		<-755.1,806.25,724.85>, <-0.605,0.796,0>,
		<-755.1,-99,724.85>, <-0.53,0.848,0>
  }
  smooth_triangle { // #794
		<-755.1,806.25,724.85>, <-0.605,0.796,0>,
		<-755.3,-99,725.05>, <-0.719,0.695,0>,
		<-755.3,806.25,725.05>, <-0.761,0.649,0>
  }
  smooth_triangle { // #795
		<-755.55,-99,725.35>, <-0.824,0.567,0>,
		<-755.3,806.25,725.05>, <-0.761,0.649,0>,
		<-755.3,-99,725.05>, <-0.719,0.695,0>
  }
  smooth_triangle { // #796
		<-755.3,806.25,725.05>, <-0.761,0.649,0>,
		<-755.55,-99,725.35>, <-0.824,0.567,0>,
		<-755.55,806.25,725.35>, <-0.846,0.532,0>
  }
  smooth_triangle { // #797
		<-755.75,-99,725.75>, <-0.882,0.471,0>,
		<-755.55,806.25,725.35>, <-0.846,0.532,0>,
		<-755.55,-99,725.35>, <-0.824,0.567,0>
  }
  smooth_triangle { // #798
		<-755.55,806.25,725.35>, <-0.846,0.532,0>,
		<-755.75,-99,725.75>, <-0.882,0.471,0>,
		<-755.75,806.25,725.75>, <-0.896,0.445,0>
  }
  smooth_triangle { // #799
		<-755.95,-99,726.2>, <-0.917,0.399,0>,
		<-755.75,806.25,725.75>, <-0.896,0.445,0>,
		<-755.75,-99,725.75>, <-0.882,0.471,0>
  }
  smooth_triangle { // #800
		<-755.75,806.25,725.75>, <-0.896,0.445,0>,
		<-755.95,-99,726.2>, <-0.917,0.399,0>,
		<-755.95,806.25,726.2>, <-0.925,0.379,0>
  }
  smooth_triangle { // #801
		<-756.15,-99,726.75>, <-0.939,0.344,0>,
		<-755.95,806.25,726.2>, <-0.925,0.379,0>,
		<-755.95,-99,726.2>, <-0.917,0.399,0>
  }
  smooth_triangle { // #802
		<-755.95,806.25,726.2>, <-0.925,0.379,0>,
		<-756.15,-99,726.75>, <-0.939,0.344,0>,
		<-756.15,806.25,726.75>, <-0.944,0.329,0>
  }
  smooth_triangle { // #803
		<-756.4,-99,727.4>, <-0.953,0.301,0>,
		<-756.15,806.25,726.75>, <-0.944,0.329,0>,
		<-756.15,-99,726.75>, <-0.939,0.344,0>
  }
  smooth_triangle { // #804
		<-756.15,806.25,726.75>, <-0.944,0.329,0>,
		<-756.4,-99,727.4>, <-0.953,0.301,0>,
		<-756.4,806.25,727.4>, <-0.957,0.289,0>
  }
  smooth_triangle { // #805
		<-756.6,-99,728.1>, <-0.964,0.267,0>,
		<-756.4,806.25,727.4>, <-0.957,0.289,0>,
		<-756.4,-99,727.4>, <-0.953,0.301,0>
  }
  smooth_triangle { // #806
		<-756.4,806.25,727.4>, <-0.957,0.289,0>,
		<-756.6,-99,728.1>, <-0.964,0.267,0>,
		<-756.6,806.25,728.1>, <-0.966,0.258,0>
  }
  smooth_triangle { // #807
		<-756.8,-99,728.9>, <-0.971,0.24,0>,
		<-756.6,806.25,728.1>, <-0.966,0.258,0>,
		<-756.6,-99,728.1>, <-0.964,0.267,0>
  }
  smooth_triangle { // #808
		<-756.6,806.25,728.1>, <-0.966,0.258,0>,
		<-756.8,-99,728.9>, <-0.971,0.24,0>,
		<-756.8,806.25,728.9>, <-0.973,0.232,0>
  }
  smooth_triangle { // #809
		<-757,-99,729.85>, <-0.976,0.217,0>,
		<-756.8,806.25,728.9>, <-0.973,0.232,0>,
		<-756.8,-99,728.9>, <-0.971,0.24,0>
  }
  smooth_triangle { // #810
		<-756.8,806.25,728.9>, <-0.973,0.232,0>,
		<-757,-99,729.85>, <-0.976,0.217,0>,
		<-757,806.25,729.85>, <-0.978,0.21,0>
  }
  smooth_triangle { // #811
		<-757.2,-99,730.8>, <-0.98,0.198,0>,
		<-757,806.25,729.85>, <-0.978,0.21,0>,
		<-757,-99,729.85>, <-0.976,0.217,0>
  }
  smooth_triangle { // #812
		<-757,806.25,729.85>, <-0.978,0.21,0>,
		<-757.2,-99,730.8>, <-0.98,0.198,0>,
		<-757.2,806.25,730.8>, <-0.981,0.192,0>
  }
  smooth_triangle { // #813
		<-757.4,-99,731.9>, <-0.983,0.182,0>,
		<-757.2,806.25,730.8>, <-0.981,0.192,0>,
		<-757.2,-99,730.8>, <-0.98,0.198,0>
  }
  triangle { // #814
		<-757.2,806.25,730.8>,
		<-757.4,-99,731.9>,
		<-757.4,806.25,731.9>
  }
  triangle { // #815
		<-757.65,-99,733.1>,
		<-757.4,806.25,731.9>,
		<-757.4,-99,731.9>
  }
  triangle { // #816
		<-757.4,806.25,731.9>,
		<-757.65,-99,733.1>,
		<-757.65,806.25,733.1>
  }
  triangle { // #817
		<-757.85,-99,734.35>,
		<-757.65,806.25,733.1>,
		<-757.65,-99,733.1>
  }
  triangle { // #818
		<-757.65,806.25,733.1>,
		<-757.85,-99,734.35>,
		<-757.85,806.25,734.35>
  }
  triangle { // #819
		<-758.05,-99,735.7>,
		<-757.85,806.25,734.35>,
		<-757.85,-99,734.35>
  }
  triangle { // #820
		<-757.85,806.25,734.35>,
		<-758.05,-99,735.7>,
		<-758.05,806.25,735.7>
  }
  triangle { // #821
		<-758.25,-99,737.1>,
		<-758.05,806.25,735.7>,
		<-758.05,-99,735.7>
  }
  triangle { // #822
		<-758.05,806.25,735.7>,
		<-758.25,-99,737.1>,
		<-758.25,806.25,737.1>
  }
  triangle { // #823
		<-758.65,-99,739.75>,
		<-758.25,806.25,737.1>,
		<-758.25,-99,737.1>
  }
  triangle { // #824
		<-758.25,806.25,737.1>,
		<-758.65,-99,739.75>,
		<-758.65,806.25,739.75>
  }
  triangle { // #825
		<-759.05,-99,742.35>,
		<-758.65,806.25,739.75>,
		<-758.65,-99,739.75>
  }
  triangle { // #826
		<-758.65,806.25,739.75>,
		<-759.05,-99,742.35>,
		<-759.05,806.25,742.35>
  }
  triangle { // #827
		<-759.45,-99,744.85>,
		<-759.05,806.25,742.35>,
		<-759.05,-99,742.35>
  }
  triangle { // #828
		<-759.05,806.25,742.35>,
		<-759.45,-99,744.85>,
		<-759.45,806.25,744.85>
  }
  triangle { // #829
		<-759.85,-99,747.3>,
		<-759.45,806.25,744.85>,
		<-759.45,-99,744.85>
  }
  triangle { // #830
		<-759.45,806.25,744.85>,
		<-759.85,-99,747.3>,
		<-759.85,806.25,747.3>
  }
  triangle { // #831
		<-760.25,-99,749.7>,
		<-759.85,806.25,747.3>,
		<-759.85,-99,747.3>
  }
  triangle { // #832
		<-759.85,806.25,747.3>,
		<-760.25,-99,749.7>,
		<-760.25,806.25,749.7>
  }
  triangle { // #833
		<-760.65,-99,752>,
		<-760.25,806.25,749.7>,
		<-760.25,-99,749.7>
  }
  triangle { // #834
		<-760.25,806.25,749.7>,
		<-760.65,-99,752>,
		<-760.65,806.25,752>
  }
  triangle { // #835
		<-761.05,-99,754.3>,
		<-760.65,806.25,752>,
		<-760.65,-99,752>
  }
  triangle { // #836
		<-760.65,806.25,752>,
		<-761.05,-99,754.3>,
		<-761.05,806.25,754.3>
  }
  triangle { // #837
		<-761.45,-99,756.5>,
		<-761.05,806.25,754.3>,
		<-761.05,-99,754.3>
  }
  triangle { // #838
		<-761.05,806.25,754.3>,
		<-761.45,-99,756.5>,
		<-761.45,806.25,756.5>
  }
  triangle { // #839
		<-761.85,-99,758.6>,
		<-761.45,806.25,756.5>,
		<-761.45,-99,756.5>
  }
  triangle { // #840
		<-761.45,806.25,756.5>,
		<-761.85,-99,758.6>,
		<-761.85,806.25,758.6>
  }
  triangle { // #841
		<-762.3,-99,760.7>,
		<-761.85,806.25,758.6>,
		<-761.85,-99,758.6>
  }
  triangle { // #842
		<-761.85,806.25,758.6>,
		<-762.3,-99,760.7>,
		<-762.3,806.25,760.7>
  }
  triangle { // #843
		<-762.7,-99,762.7>,
		<-762.3,806.25,760.7>,
		<-762.3,-99,760.7>
  }
  triangle { // #844
		<-762.3,806.25,760.7>,
		<-762.7,-99,762.7>,
		<-762.7,806.25,762.7>
  }
  triangle { // #845
		<-763.15,-99,764.65>,
		<-762.7,806.25,762.7>,
		<-762.7,-99,762.7>
  }
  triangle { // #846
		<-762.7,806.25,762.7>,
		<-763.15,-99,764.65>,
		<-763.15,806.25,764.65>
  }
  triangle { // #847
		<-763.55,-99,766.55>,
		<-763.15,806.25,764.65>,
		<-763.15,-99,764.65>
  }
  triangle { // #848
		<-763.15,806.25,764.65>,
		<-763.55,-99,766.55>,
		<-763.55,806.25,766.55>
  }
  triangle { // #849
		<-764,-99,768.35>,
		<-763.55,806.25,766.55>,
		<-763.55,-99,766.55>
  }
  triangle { // #850
		<-763.55,806.25,766.55>,
		<-764,-99,768.35>,
		<-764,806.25,768.35>
  }
  triangle { // #851
		<-764.4,-99,770.1>,
		<-764,806.25,768.35>,
		<-764,-99,768.35>
  }
  triangle { // #852
		<-764,806.25,768.35>,
		<-764.4,-99,770.1>,
		<-764.4,806.25,770.1>
  }
  triangle { // #853
		<-764.85,-99,771.8>,
		<-764.4,806.25,770.1>,
		<-764.4,-99,770.1>
  }
  smooth_triangle { // #854
		<-764.4,806.25,770.1>, <-0.97,0.243,0>,
		<-764.85,-99,771.8>, <-0.968,0.251,0>,
		<-764.85,806.25,771.8>, <-0.967,0.256,0>
  }
  smooth_triangle { // #855
		<-765.3,-99,773.55>, <-0.964,0.268,0>,
		<-764.85,806.25,771.8>, <-0.967,0.256,0>,
		<-764.85,-99,771.8>, <-0.968,0.251,0>
  }
  smooth_triangle { // #856
		<-764.85,806.25,771.8>, <-0.967,0.256,0>,
		<-765.3,-99,773.55>, <-0.964,0.268,0>,
		<-765.3,806.25,773.55>, <-0.962,0.274,0>
  }
  smooth_triangle { // #857
		<-765.85,-99,775.35>, <-0.958,0.285,0>,
		<-765.3,806.25,773.55>, <-0.962,0.274,0>,
		<-765.3,-99,773.55>, <-0.964,0.268,0>
  }
  smooth_triangle { // #858
		<-765.3,806.25,773.55>, <-0.962,0.274,0>,
		<-765.85,-99,775.35>, <-0.958,0.285,0>,
		<-765.85,806.25,775.35>, <-0.957,0.291,0>
  }
  smooth_triangle { // #859
		<-766.4,-99,777.25>, <-0.953,0.301,0>,
		<-765.85,806.25,775.35>, <-0.957,0.291,0>,
		<-765.85,-99,775.35>, <-0.958,0.285,0>
  }
  triangle { // #860
		<-765.85,806.25,775.35>,
		<-766.4,-99,777.25>,
		<-766.4,806.25,777.25>
  }
  triangle { // #861
		<-767.05,-99,779.25>,
		<-766.4,806.25,777.25>,
		<-766.4,-99,777.25>
  }
  triangle { // #862
		<-766.4,806.25,777.25>,
		<-767.05,-99,779.25>,
		<-767.05,806.25,779.25>
  }
  triangle { // #863
		<-767.8,-99,781.3>,
		<-767.05,806.25,779.25>,
		<-767.05,-99,779.25>
  }
  triangle { // #864
		<-767.05,806.25,779.25>,
		<-767.8,-99,781.3>,
		<-767.8,806.25,781.3>
  }
  triangle { // #865
		<-768.55,-99,783.5>,
		<-767.8,806.25,781.3>,
		<-767.8,-99,781.3>
  }
  triangle { // #866
		<-767.8,806.25,781.3>,
		<-768.55,-99,783.5>,
		<-768.55,806.25,783.5>
  }
  triangle { // #867
		<-769.4,-99,785.75>,
		<-768.55,806.25,783.5>,
		<-768.55,-99,783.5>
  }
  triangle { // #868
		<-768.55,806.25,783.5>,
		<-769.4,-99,785.75>,
		<-769.4,806.25,785.75>
  }
  triangle { // #869
		<-770.3,-99,788.15>,
		<-769.4,806.25,785.75>,
		<-769.4,-99,785.75>
  }
  triangle { // #870
		<-769.4,806.25,785.75>,
		<-770.3,-99,788.15>,
		<-770.3,806.25,788.15>
  }
  triangle { // #871
		<-771.3,-99,790.6>,
		<-770.3,806.25,788.15>,
		<-770.3,-99,788.15>
  }
  triangle { // #872
		<-770.3,806.25,788.15>,
		<-771.3,-99,790.6>,
		<-771.3,806.25,790.6>
  }
  triangle { // #873
		<-772.3,-99,793.15>,
		<-771.3,806.25,790.6>,
		<-771.3,-99,790.6>
  }
  triangle { // #874
		<-771.3,806.25,790.6>,
		<-772.3,-99,793.15>,
		<-772.3,806.25,793.15>
  }
  triangle { // #875
		<-773.4,-99,795.8>,
		<-772.3,806.25,793.15>,
		<-772.3,-99,793.15>
  }
  triangle { // #876
		<-772.3,806.25,793.15>,
		<-773.4,-99,795.8>,
		<-773.4,806.25,795.8>
  }
  triangle { // #877
		<-774.55,-99,798.55>,
		<-773.4,806.25,795.8>,
		<-773.4,-99,795.8>
  }
  triangle { // #878
		<-773.4,806.25,795.8>,
		<-774.55,-99,798.55>,
		<-774.55,806.25,798.55>
  }
  triangle { // #879
		<-775.8,-99,801.4>,
		<-774.55,806.25,798.55>,
		<-774.55,-99,798.55>
  }
  triangle { // #880
		<-774.55,806.25,798.55>,
		<-775.8,-99,801.4>,
		<-775.8,806.25,801.4>
  }
  triangle { // #881
		<-777.05,-99,804.3>,
		<-775.8,806.25,801.4>,
		<-775.8,-99,801.4>
  }
  triangle { // #882
		<-775.8,806.25,801.4>,
		<-777.05,-99,804.3>,
		<-777.05,806.25,804.3>
  }
  triangle { // #883
		<-778.4,-99,807.35>,
		<-777.05,806.25,804.3>,
		<-777.05,-99,804.3>
  }
  triangle { // #884
		<-777.05,806.25,804.3>,
		<-778.4,-99,807.35>,
		<-778.4,806.25,807.35>
  }
  triangle { // #885
		<-779.8,-99,810.45>,
		<-778.4,806.25,807.35>,
		<-778.4,-99,807.35>
  }
  triangle { // #886
		<-778.4,806.25,807.35>,
		<-779.8,-99,810.45>,
		<-779.8,806.25,810.45>
  }
  triangle { // #887
		<-781.3,-99,813.75>,
		<-779.8,806.25,810.45>,
		<-779.8,-99,810.45>
  }
  triangle { // #888
		<-779.8,806.25,810.45>,
		<-781.3,-99,813.75>,
		<-781.3,806.25,813.75>
  }
  triangle { // #889
		<-782.85,-99,817.3>,
		<-781.3,806.25,813.75>,
		<-781.3,-99,813.75>
  }
  triangle { // #890
		<-781.3,806.25,813.75>,
		<-782.85,-99,817.3>,
		<-782.85,806.25,817.3>
  }
  triangle { // #891
		<-784.45,-99,821.15>,
		<-782.85,806.25,817.3>,
		<-782.85,-99,817.3>
  }
  triangle { // #892
		<-782.85,806.25,817.3>,
		<-784.45,-99,821.15>,
		<-784.45,806.25,821.15>
  }
  triangle { // #893
		<-786.1,-99,825.3>,
		<-784.45,806.25,821.15>,
		<-784.45,-99,821.15>
  }
  triangle { // #894
		<-784.45,806.25,821.15>,
		<-786.1,-99,825.3>,
		<-786.1,806.25,825.3>
  }
  triangle { // #895
		<-787.85,-99,829.7>,
		<-786.1,806.25,825.3>,
		<-786.1,-99,825.3>
  }
  triangle { // #896
		<-786.1,806.25,825.3>,
		<-787.85,-99,829.7>,
		<-787.85,806.25,829.7>
  }
  triangle { // #897
		<-789.6,-99,834.35>,
		<-787.85,806.25,829.7>,
		<-787.85,-99,829.7>
  }
  triangle { // #898
		<-787.85,806.25,829.7>,
		<-789.6,-99,834.35>,
		<-789.6,806.25,834.35>
  }
  triangle { // #899
		<-791.45,-99,839.3>,
		<-789.6,806.25,834.35>,
		<-789.6,-99,834.35>
  }
  triangle { // #900
		<-789.6,806.25,834.35>,
		<-791.45,-99,839.3>,
		<-791.45,806.25,839.3>
  }
  triangle { // #901
		<-793.4,-99,844.5>,
		<-791.45,806.25,839.3>,
		<-791.45,-99,839.3>
  }
  triangle { // #902
		<-791.45,806.25,839.3>,
		<-793.4,-99,844.5>,
		<-793.4,806.25,844.5>
  }
  triangle { // #903
		<-795.4,-99,850>,
		<-793.4,806.25,844.5>,
		<-793.4,-99,844.5>
  }
  triangle { // #904
		<-793.4,806.25,844.5>,
		<-795.4,-99,850>,
		<-795.4,806.25,850>
  }
  triangle { // #905
		<-797.4,-99,855.75>,
		<-795.4,806.25,850>,
		<-795.4,-99,850>
  }
  triangle { // #906
		<-795.4,806.25,850>,
		<-797.4,-99,855.75>,
		<-797.4,806.25,855.75>
  }
  triangle { // #907
		<-799.55,-99,861.8>,
		<-797.4,806.25,855.75>,
		<-797.4,-99,855.75>
  }
  triangle { // #908
		<-797.4,806.25,855.75>,
		<-799.55,-99,861.8>,
		<-799.55,806.25,861.8>
  }
  triangle { // #909
		<-801.7,-99,868.1>,
		<-799.55,806.25,861.8>,
		<-799.55,-99,861.8>
  }
  triangle { // #910
		<-799.55,806.25,861.8>,
		<-801.7,-99,868.1>,
		<-801.7,806.25,868.1>
  }
  triangle { // #911
		<-803.95,-99,874.7>,
		<-801.7,806.25,868.1>,
		<-801.7,-99,868.1>
  }
  triangle { // #912
		<-801.7,806.25,868.1>,
		<-803.95,-99,874.7>,
		<-803.95,806.25,874.7>
  }
  triangle { // #913
		<-806.25,-99,881.55>,
		<-803.95,806.25,874.7>,
		<-803.95,-99,874.7>
  }
  triangle { // #914
		<-803.95,806.25,874.7>,
		<-806.25,-99,881.55>,
		<-806.25,806.25,881.55>
  }
  triangle { // #915
		<-808.6,-99,888.7>,
		<-806.25,806.25,881.55>,
		<-806.25,-99,881.55>
  }
  triangle { // #916
		<-806.25,806.25,881.55>,
		<-808.6,-99,888.7>,
		<-808.6,806.25,888.7>
  }
  smooth_triangle { // #917
		<-811.05,-99,896.1>, <-0.966,0.257,0>,
		<-808.6,806.25,888.7>, <-0.95,0.313,0>,
		<-808.6,-99,888.7>, <-0.95,0.314,0>
  }
  smooth_triangle { // #918
		<-808.6,806.25,888.7>, <-0.95,0.313,0>,
		<-811.05,-99,896.1>, <-0.966,0.257,0>,
		<-811.05,806.25,896.1>, <-0.979,0.202,0>
  }
  triangle { // #919
		<-811.05,-99,896.1>,
		<-797,-99,897.25>,
		<-797,806.25,897.25>
  }
  triangle { // #920
		<-797,806.25,897.25>,
		<-811.05,806.25,896.1>,
		<-811.05,-99,896.1>
  }
  triangle { // #921
		<843.65,-99,1196.8>,
		<800.7,-99,896.1>,
		<844.15,-99,1093>
  }
  triangle { // #922
		<815.2,-99,896.1>,
		<844.15,-99,1093>,
		<800.7,-99,896.1>
  }
  triangle { // #923
		<815.2,806.25,896.1>,
		<800.7,806.25,896.1>,
		<844.15,806.25,1093>
  }
  triangle { // #924
		<843.65,806.25,1196.8>,
		<844.15,806.25,1093>,
		<800.7,806.25,896.1>
  }
  smooth_triangle { // #925
		<815.2,-99,896.1>, <0.989,0.146,0>,
		<815.2,806.25,896.1>, <0.989,0.146,0>,
		<844.15,-99,1093>, <0.995,0.096,0>
  }
  smooth_triangle { // #926
		<844.15,806.25,1093>, <0.999,0.045,0>,
		<844.15,-99,1093>, <0.995,0.096,0>,
		<815.2,806.25,896.1>, <0.989,0.146,0>
  }
  triangle { // #927
		<800.7,-99,896.1>,
		<800.7,806.25,896.1>,
		<815.2,-99,896.1>
  }
  triangle { // #928
		<815.2,806.25,896.1>,
		<815.2,-99,896.1>,
		<800.7,806.25,896.1>
  }
  triangle { // #929
		<843.65,-99,1196.8>,
		<843.65,806.25,1196.8>,
		<800.7,-99,896.1>
  }
  triangle { // #930
		<800.7,806.25,896.1>,
		<800.7,-99,896.1>,
		<843.65,806.25,1196.8>
  }
  smooth_triangle { // #931
		<844.15,-99,1093>, <0.995,0.096,0>,
		<844.15,806.25,1093>, <0.999,0.045,0>,
		<843.65,-99,1196.8>, <1,-0.005,0>
  }
  smooth_triangle { // #932
		<843.65,806.25,1196.8>, <1,-0.005,0>,
		<843.65,-99,1196.8>, <1,-0.005,0>,
		<844.15,806.25,1093>, <0.999,0.045,0>
  }
  triangle { // #933
		<843.8,-99,499.05>,
		<784.6,-99,505.3>,
		<843.85,-99,483.9>
  }
  triangle { // #934
		<843.45,-99,725.25>,
		<764.25,-99,492.25>,
		<843.6,-99,678.8>
  }
  triangle { // #935
		<843.6,-99,678.8>,
		<764.25,-99,492.25>,
		<784.6,-99,505.3>
  }
  triangle { // #936
		<764.25,-99,492.25>,
		<843.85,-99,483.9>,
		<784.6,-99,505.3>
  }
  triangle { // #937
		<843.8,806.25,499.05>,
		<843.85,806.25,483.9>,
		<784.6,806.25,505.3>
  }
  triangle { // #938
		<843.45,806.25,725.25>,
		<843.6,806.25,678.8>,
		<764.25,806.25,492.25>
  }
  triangle { // #939
		<843.6,806.25,678.8>,
		<784.6,806.25,505.3>,
		<764.25,806.25,492.25>
  }
  triangle { // #940
		<764.25,806.25,492.25>,
		<784.6,806.25,505.3>,
		<843.85,806.25,483.9>
  }
  triangle { // #941
		<843.85,-99,483.9>,
		<843.85,806.25,483.9>,
		<843.8,-99,499.05>
  }
  triangle { // #942
		<843.8,806.25,499.05>,
		<843.8,-99,499.05>,
		<843.85,806.25,483.9>
  }
  triangle { // #943
		<764.25,-99,492.25>,
		<764.25,806.25,492.25>,
		<843.85,-99,483.9>
  }
  triangle { // #944
		<843.85,806.25,483.9>,
		<843.85,-99,483.9>,
		<764.25,806.25,492.25>
  }
  triangle { // #945
		<843.45,-99,725.25>,
		<843.45,806.25,725.25>,
		<764.25,-99,492.25>
  }
  triangle { // #946
		<764.25,806.25,492.25>,
		<764.25,-99,492.25>,
		<843.45,806.25,725.25>
  }
  smooth_triangle { // #947
		<843.6,-99,678.8>, <0.976,0.216,0>,
		<843.6,806.25,678.8>, <0.994,0.107,0>,
		<843.45,-99,725.25>, <1,-0.003,0>
  }
  smooth_triangle { // #948
		<843.45,806.25,725.25>, <1,-0.003,0>,
		<843.45,-99,725.25>, <1,-0.003,0>,
		<843.6,806.25,678.8>, <0.994,0.107,0>
  }
  smooth_triangle { // #949
		<784.6,-99,505.3>, <0.947,0.322,0>,
		<784.6,806.25,505.3>, <0.947,0.322,0>,
		<843.6,-99,678.8>, <0.976,0.216,0>
  }
  smooth_triangle { // #950
		<843.6,806.25,678.8>, <0.994,0.107,0>,
		<843.6,-99,678.8>, <0.976,0.216,0>,
		<784.6,806.25,505.3>, <0.947,0.322,0>
  }
  triangle { // #951
		<843.8,-99,499.05>,
		<843.8,806.25,499.05>,
		<784.6,-99,505.3>
  }
  triangle { // #952
		<784.6,806.25,505.3>,
		<784.6,-99,505.3>,
		<843.8,806.25,499.05>
  }
  triangle { // #953
		<798.6,-99,887.9>,
		<801.95,806.25,897.25>,
		<801.95,-99,897.25>
  }
  triangle { // #954
		<801.95,806.25,897.25>,
		<798.6,-99,887.9>,
		<798.6,806.25,887.9>
  }
  triangle { // #955
		<795.4,-99,879.05>,
		<798.6,806.25,887.9>,
		<798.6,-99,887.9>
  }
  triangle { // #956
		<798.6,806.25,887.9>,
		<795.4,-99,879.05>,
		<795.4,806.25,879.05>
  }
  triangle { // #957
		<792.4,-99,870.7>,
		<795.4,806.25,879.05>,
		<795.4,-99,879.05>
  }
  triangle { // #958
		<795.4,806.25,879.05>,
		<792.4,-99,870.7>,
		<792.4,806.25,870.7>
  }
  triangle { // #959
		<789.55,-99,862.85>,
		<792.4,806.25,870.7>,
		<792.4,-99,870.7>
  }
  triangle { // #960
		<792.4,806.25,870.7>,
		<789.55,-99,862.85>,
		<789.55,806.25,862.85>
  }
  triangle { // #961
		<786.8,-99,855.45>,
		<789.55,806.25,862.85>,
		<789.55,-99,862.85>
  }
  triangle { // #962
		<789.55,806.25,862.85>,
		<786.8,-99,855.45>,
		<786.8,806.25,855.45>
  }
  triangle { // #963
		<784.25,-99,848.6>,
		<786.8,806.25,855.45>,
		<786.8,-99,855.45>
  }
  triangle { // #964
		<786.8,806.25,855.45>,
		<784.25,-99,848.6>,
		<784.25,806.25,848.6>
  }
  triangle { // #965
		<781.85,-99,842.2>,
		<784.25,806.25,848.6>,
		<784.25,-99,848.6>
  }
  triangle { // #966
		<784.25,806.25,848.6>,
		<781.85,-99,842.2>,
		<781.85,806.25,842.2>
  }
  triangle { // #967
		<779.6,-99,836.3>,
		<781.85,806.25,842.2>,
		<781.85,-99,842.2>
  }
  triangle { // #968
		<781.85,806.25,842.2>,
		<779.6,-99,836.3>,
		<779.6,806.25,836.3>
  }
  triangle { // #969
		<777.5,-99,830.9>,
		<779.6,806.25,836.3>,
		<779.6,-99,836.3>
  }
  triangle { // #970
		<779.6,806.25,836.3>,
		<777.5,-99,830.9>,
		<777.5,806.25,830.9>
  }
  triangle { // #971
		<775.55,-99,826>,
		<777.5,806.25,830.9>,
		<777.5,-99,830.9>
  }
  triangle { // #972
		<777.5,806.25,830.9>,
		<775.55,-99,826>,
		<775.55,806.25,826>
  }
  triangle { // #973
		<773.75,-99,821.6>,
		<775.55,806.25,826>,
		<775.55,-99,826>
  }
  triangle { // #974
		<775.55,806.25,826>,
		<773.75,-99,821.6>,
		<773.75,806.25,821.6>
  }
  triangle { // #975
		<772.1,-99,817.65>,
		<773.75,806.25,821.6>,
		<773.75,-99,821.6>
  }
  triangle { // #976
		<773.75,806.25,821.6>,
		<772.1,-99,817.65>,
		<772.1,806.25,817.65>
  }
  triangle { // #977
		<770.65,-99,814.25>,
		<772.1,806.25,817.65>,
		<772.1,-99,817.65>
  }
  smooth_triangle { // #978
		<772.1,806.25,817.65>, <0.92,0.393,0>,
		<770.65,-99,814.25>, <0.916,0.402,0>,
		<770.65,806.25,814.25>, <0.913,0.407,0>
  }
  smooth_triangle { // #979
		<769.3,-99,811.3>, <0.908,0.419,0>,
		<770.65,806.25,814.25>, <0.913,0.407,0>,
		<770.65,-99,814.25>, <0.916,0.402,0>
  }
  smooth_triangle { // #980
		<770.65,806.25,814.25>, <0.913,0.407,0>,
		<769.3,-99,811.3>, <0.908,0.419,0>,
		<769.3,806.25,811.3>, <0.905,0.426,0>
  }
  smooth_triangle { // #981
		<768.15,-99,808.85>, <0.896,0.443,0>,
		<769.3,806.25,811.3>, <0.905,0.426,0>,
		<769.3,-99,811.3>, <0.908,0.419,0>
  }
  smooth_triangle { // #982
		<769.3,806.25,811.3>, <0.905,0.426,0>,
		<768.15,-99,808.85>, <0.896,0.443,0>,
		<768.15,806.25,808.85>, <0.891,0.454,0>
  }
  smooth_triangle { // #983
		<767.1,-99,806.9>, <0.883,0.469,0>,
		<768.15,806.25,808.85>, <0.891,0.454,0>,
		<768.15,-99,808.85>, <0.896,0.443,0>
  }
  smooth_triangle { // #984
		<768.15,806.25,808.85>, <0.891,0.454,0>,
		<767.1,-99,806.9>, <0.883,0.469,0>,
		<767.1,806.25,806.9>, <0.88,0.474,0>
  }
  smooth_triangle { // #985
		<766.2,-99,805.2>, <0.88,0.476,0>,
		<767.1,806.25,806.9>, <0.88,0.474,0>,
		<767.1,-99,806.9>, <0.883,0.469,0>
  }
  triangle { // #986
		<767.1,806.25,806.9>,
		<766.2,-99,805.2>,
		<766.2,806.25,805.2>
  }
  triangle { // #987
		<765.25,-99,803.45>,
		<766.2,806.25,805.2>,
		<766.2,-99,805.2>
  }
  triangle { // #988
		<766.2,806.25,805.2>,
		<765.25,-99,803.45>,
		<765.25,806.25,803.45>
  }
  triangle { // #989
		<764.35,-99,801.65>,
		<765.25,806.25,803.45>,
		<765.25,-99,803.45>
  }
  triangle { // #990
		<765.25,806.25,803.45>,
		<764.35,-99,801.65>,
		<764.35,806.25,801.65>
  }
  triangle { // #991
		<763.4,-99,799.85>,
		<764.35,806.25,801.65>,
		<764.35,-99,801.65>
  }
  triangle { // #992
		<764.35,806.25,801.65>,
		<763.4,-99,799.85>,
		<763.4,806.25,799.85>
  }
  triangle { // #993
		<762.5,-99,798>,
		<763.4,806.25,799.85>,
		<763.4,-99,799.85>
  }
  triangle { // #994
		<763.4,806.25,799.85>,
		<762.5,-99,798>,
		<762.5,806.25,798>
  }
  triangle { // #995
		<761.65,-99,796.15>,
		<762.5,806.25,798>,
		<762.5,-99,798>
  }
  triangle { // #996
		<762.5,806.25,798>,
		<761.65,-99,796.15>,
		<761.65,806.25,796.15>
  }
  triangle { // #997
		<760.75,-99,794.25>,
		<761.65,806.25,796.15>,
		<761.65,-99,796.15>
  }
  triangle { // #998
		<761.65,806.25,796.15>,
		<760.75,-99,794.25>,
		<760.75,806.25,794.25>
  }
  triangle { // #999
		<759.9,-99,792.3>,
		<760.75,806.25,794.25>,
		<760.75,-99,794.25>
  }
  triangle { // #1000
		<760.75,806.25,794.25>,
		<759.9,-99,792.3>,
		<759.9,806.25,792.3>
  }
  triangle { // #1001
		<759.05,-99,790.35>,
		<759.9,806.25,792.3>,
		<759.9,-99,792.3>
  }
  triangle { // #1002
		<759.9,806.25,792.3>,
		<759.05,-99,790.35>,
		<759.05,806.25,790.35>
  }
  triangle { // #1003
		<758.2,-99,788.4>,
		<759.05,806.25,790.35>,
		<759.05,-99,790.35>
  }
  triangle { // #1004
		<759.05,806.25,790.35>,
		<758.2,-99,788.4>,
		<758.2,806.25,788.4>
  }
  triangle { // #1005
		<757.35,-99,786.35>,
		<758.2,806.25,788.4>,
		<758.2,-99,788.4>
  }
  triangle { // #1006
		<758.2,806.25,788.4>,
		<757.35,-99,786.35>,
		<757.35,806.25,786.35>
  }
  triangle { // #1007
		<756.5,-99,784.3>,
		<757.35,806.25,786.35>,
		<757.35,-99,786.35>
  }
  triangle { // #1008
		<757.35,806.25,786.35>,
		<756.5,-99,784.3>,
		<756.5,806.25,784.3>
  }
  triangle { // #1009
		<755.7,-99,782.25>,
		<756.5,806.25,784.3>,
		<756.5,-99,784.3>
  }
  triangle { // #1010
		<756.5,806.25,784.3>,
		<755.7,-99,782.25>,
		<755.7,806.25,782.25>
  }
  triangle { // #1011
		<754.9,-99,780.1>,
		<755.7,806.25,782.25>,
		<755.7,-99,782.25>
  }
  triangle { // #1012
		<755.7,806.25,782.25>,
		<754.9,-99,780.1>,
		<754.9,806.25,780.1>
  }
  triangle { // #1013
		<754.1,-99,778>,
		<754.9,806.25,780.1>,
		<754.9,-99,780.1>
  }
  triangle { // #1014
		<754.9,806.25,780.1>,
		<754.1,-99,778>,
		<754.1,806.25,778>
  }
  triangle { // #1015
		<753.3,-99,775.8>,
		<754.1,806.25,778>,
		<754.1,-99,778>
  }
  triangle { // #1016
		<754.1,806.25,778>,
		<753.3,-99,775.8>,
		<753.3,806.25,775.8>
  }
  triangle { // #1017
		<752.5,-99,773.65>,
		<753.3,806.25,775.8>,
		<753.3,-99,775.8>
  }
  smooth_triangle { // #1018
		<753.3,806.25,775.8>, <0.942,0.335,0>,
		<752.5,-99,773.65>, <0.945,0.326,0>,
		<752.5,806.25,773.65>, <0.947,0.32,0>
  }
  smooth_triangle { // #1019
		<751.8,-99,771.5>, <0.951,0.31,0>,
		<752.5,806.25,773.65>, <0.947,0.32,0>,
		<752.5,-99,773.65>, <0.945,0.326,0>
  }
  smooth_triangle { // #1020
		<752.5,806.25,773.65>, <0.947,0.32,0>,
		<751.8,-99,771.5>, <0.951,0.31,0>,
		<751.8,806.25,771.5>, <0.953,0.304,0>
  }
  smooth_triangle { // #1021
		<751.15,-99,769.35>, <0.956,0.293,0>,
		<751.8,806.25,771.5>, <0.953,0.304,0>,
		<751.8,-99,771.5>, <0.951,0.31,0>
  }
  smooth_triangle { // #1022
		<751.8,806.25,771.5>, <0.953,0.304,0>,
		<751.15,-99,769.35>, <0.956,0.293,0>,
		<751.15,806.25,769.35>, <0.958,0.287,0>
  }
  smooth_triangle { // #1023
		<750.5,-99,767.25>, <0.961,0.276,0>,
		<751.15,806.25,769.35>, <0.958,0.287,0>,
		<751.15,-99,769.35>, <0.956,0.293,0>
  }
  smooth_triangle { // #1024
		<751.15,806.25,769.35>, <0.958,0.287,0>,
		<750.5,-99,767.25>, <0.961,0.276,0>,
		<750.5,806.25,767.25>, <0.963,0.27,0>
  }
  smooth_triangle { // #1025
		<749.95,-99,765.15>, <0.966,0.258,0>,
		<750.5,806.25,767.25>, <0.963,0.27,0>,
		<750.5,-99,767.25>, <0.961,0.276,0>
  }
  smooth_triangle { // #1026
		<750.5,806.25,767.25>, <0.963,0.27,0>,
		<749.95,-99,765.15>, <0.966,0.258,0>,
		<749.95,806.25,765.15>, <0.968,0.252,0>
  }
  smooth_triangle { // #1027
		<749.4,-99,763.05>, <0.971,0.239,0>,
		<749.95,806.25,765.15>, <0.968,0.252,0>,
		<749.95,-99,765.15>, <0.966,0.258,0>
  }
  smooth_triangle { // #1028
		<749.95,806.25,765.15>, <0.968,0.252,0>,
		<749.4,-99,763.05>, <0.971,0.239,0>,
		<749.4,806.25,763.05>, <0.972,0.233,0>
  }
  smooth_triangle { // #1029
		<748.95,-99,761>, <0.975,0.22,0>,
		<749.4,806.25,763.05>, <0.972,0.233,0>,
		<749.4,-99,763.05>, <0.971,0.239,0>
  }
  smooth_triangle { // #1030
		<749.4,806.25,763.05>, <0.972,0.233,0>,
		<748.95,-99,761>, <0.975,0.22,0>,
		<748.95,806.25,761>, <0.977,0.214,0>
  }
  smooth_triangle { // #1031
		<748.5,-99,759>, <0.98,0.201,0>,
		<748.95,806.25,761>, <0.977,0.214,0>,
		<748.95,-99,761>, <0.975,0.22,0>
  }
  smooth_triangle { // #1032
		<748.95,806.25,761>, <0.977,0.214,0>,
		<748.5,-99,759>, <0.98,0.201,0>,
		<748.5,806.25,759>, <0.981,0.194,0>
  }
  smooth_triangle { // #1033
		<748.15,-99,756.95>, <0.984,0.18,0>,
		<748.5,806.25,759>, <0.981,0.194,0>,
		<748.5,-99,759>, <0.98,0.201,0>
  }
  smooth_triangle { // #1034
		<748.5,806.25,759>, <0.981,0.194,0>,
		<748.15,-99,756.95>, <0.984,0.18,0>,
		<748.15,806.25,756.95>, <0.985,0.173,0>
  }
  smooth_triangle { // #1035
		<747.8,-99,755>, <0.987,0.159,0>,
		<748.15,806.25,756.95>, <0.985,0.173,0>,
		<748.15,-99,756.95>, <0.984,0.18,0>
  }
  smooth_triangle { // #1036
		<748.15,806.25,756.95>, <0.985,0.173,0>,
		<747.8,-99,755>, <0.987,0.159,0>,
		<747.8,806.25,755>, <0.988,0.152,0>
  }
  smooth_triangle { // #1037
		<747.5,-99,753>, <0.99,0.138,0>,
		<747.8,806.25,755>, <0.988,0.152,0>,
		<747.8,-99,755>, <0.987,0.159,0>
  }
  smooth_triangle { // #1038
		<747.8,806.25,755>, <0.988,0.152,0>,
		<747.5,-99,753>, <0.99,0.138,0>,
		<747.5,806.25,753>, <0.991,0.13,0>
  }
  smooth_triangle { // #1039
		<747.25,-99,751.05>, <0.993,0.115,0>,
		<747.5,806.25,753>, <0.991,0.13,0>,
		<747.5,-99,753>, <0.99,0.138,0>
  }
  smooth_triangle { // #1040
		<747.5,806.25,753>, <0.991,0.13,0>,
		<747.25,-99,751.05>, <0.993,0.115,0>,
		<747.25,806.25,751.05>, <0.994,0.108,0>
  }
  smooth_triangle { // #1041
		<747.05,-99,749.1>, <0.996,0.092,0>,
		<747.25,806.25,751.05>, <0.994,0.108,0>,
		<747.25,-99,751.05>, <0.993,0.115,0>
  }
  smooth_triangle { // #1042
		<747.25,806.25,751.05>, <0.994,0.108,0>,
		<747.05,-99,749.1>, <0.996,0.092,0>,
		<747.05,806.25,749.1>, <0.996,0.085,0>
  }
  smooth_triangle { // #1043
		<746.9,-99,747.2>, <0.998,0.069,0>,
		<747.05,806.25,749.1>, <0.996,0.085,0>,
		<747.05,-99,749.1>, <0.996,0.092,0>
  }
  smooth_triangle { // #1044
		<747.05,806.25,749.1>, <0.996,0.085,0>,
		<746.9,-99,747.2>, <0.998,0.069,0>,
		<746.9,806.25,747.2>, <0.998,0.061,0>
  }
  smooth_triangle { // #1045
		<746.8,-99,745.3>, <0.999,0.045,0>,
		<746.9,806.25,747.2>, <0.998,0.061,0>,
		<746.9,-99,747.2>, <0.998,0.069,0>
  }
  smooth_triangle { // #1046
		<746.9,806.25,747.2>, <0.998,0.061,0>,
		<746.8,-99,745.3>, <0.999,0.045,0>,
		<746.8,806.25,745.3>, <0.999,0.036,0>
  }
  smooth_triangle { // #1047
		<746.75,-99,743.45>, <1,0.022,0>,
		<746.8,806.25,745.3>, <0.999,0.036,0>,
		<746.8,-99,745.3>, <0.999,0.045,0>
  }
  smooth_triangle { // #1048
		<746.8,806.25,745.3>, <0.999,0.036,0>,
		<746.75,-99,743.45>, <1,0.022,0>,
		<746.75,806.25,743.45>, <1,0.015,0>
  }
  smooth_triangle { // #1049
		<746.75,-99,741.6>, <1,0.003,0>,
		<746.75,806.25,743.45>, <1,0.015,0>,
		<746.75,-99,743.45>, <1,0.022,0>
  }
  smooth_triangle { // #1050
		<746.75,806.25,743.45>, <1,0.015,0>,
		<746.75,-99,741.6>, <1,0.003,0>,
		<746.75,806.25,741.6>, <1,-0.002,0>
  }
  smooth_triangle { // #1051
		<746.75,-99,739.9>, <1,-0.014,0>,
		<746.75,806.25,741.6>, <1,-0.002,0>,
		<746.75,-99,741.6>, <1,0.003,0>
  }
  smooth_triangle { // #1052
		<746.75,806.25,741.6>, <1,-0.002,0>,
		<746.75,-99,739.9>, <1,-0.014,0>,
		<746.75,806.25,739.9>, <1,-0.02,0>
  }
  smooth_triangle { // #1053
		<746.8,-99,738.25>, <0.999,-0.033,0>,
		<746.75,806.25,739.9>, <1,-0.02,0>,
		<746.75,-99,739.9>, <1,-0.014,0>
  }
  smooth_triangle { // #1054
		<746.75,806.25,739.9>, <1,-0.02,0>,
		<746.8,-99,738.25>, <0.999,-0.033,0>,
		<746.8,806.25,738.25>, <0.999,-0.039,0>
  }
  smooth_triangle { // #1055
		<746.9,-99,736.7>, <0.999,-0.054,0>,
		<746.8,806.25,738.25>, <0.999,-0.039,0>,
		<746.8,-99,738.25>, <0.999,-0.033,0>
  }
  smooth_triangle { // #1056
		<746.8,806.25,738.25>, <0.999,-0.039,0>,
		<746.9,-99,736.7>, <0.999,-0.054,0>,
		<746.9,806.25,736.7>, <0.998,-0.061,0>
  }
  smooth_triangle { // #1057
		<747,-99,735.3>, <0.997,-0.078,0>,
		<746.9,806.25,736.7>, <0.998,-0.061,0>,
		<746.9,-99,736.7>, <0.999,-0.054,0>
  }
  smooth_triangle { // #1058
		<746.9,806.25,736.7>, <0.998,-0.061,0>,
		<747,-99,735.3>, <0.997,-0.078,0>,
		<747,806.25,735.3>, <0.996,-0.086,0>
  }
  smooth_triangle { // #1059
		<747.1,-99,733.95>, <0.995,-0.105,0>,
		<747,806.25,735.3>, <0.996,-0.086,0>,
		<747,-99,735.3>, <0.997,-0.078,0>
  }
  smooth_triangle { // #1060
		<747,806.25,735.3>, <0.996,-0.086,0>,
		<747.1,-99,733.95>, <0.995,-0.105,0>,
		<747.1,806.25,733.95>, <0.993,-0.114,0>
  }
  smooth_triangle { // #1061
		<747.25,-99,732.7>, <0.991,-0.136,0>,
		<747.1,806.25,733.95>, <0.993,-0.114,0>,
		<747.1,-99,733.95>, <0.995,-0.105,0>
  }
  smooth_triangle { // #1062
		<747.1,806.25,733.95>, <0.993,-0.114,0>,
		<747.25,-99,732.7>, <0.991,-0.136,0>,
		<747.25,806.25,732.7>, <0.989,-0.147,0>
  }
  smooth_triangle { // #1063
		<747.45,-99,731.55>, <0.985,-0.171,0>,
		<747.25,806.25,732.7>, <0.989,-0.147,0>,
		<747.25,-99,732.7>, <0.991,-0.136,0>
  }
  smooth_triangle { // #1064
		<747.25,806.25,732.7>, <0.989,-0.147,0>,
		<747.45,-99,731.55>, <0.985,-0.171,0>,
		<747.45,806.25,731.55>, <0.983,-0.184,0>
  }
  smooth_triangle { // #1065
		<747.65,-99,730.45>, <0.977,-0.213,0>,
		<747.45,806.25,731.55>, <0.983,-0.184,0>,
		<747.45,-99,731.55>, <0.985,-0.171,0>
  }
  smooth_triangle { // #1066
		<747.45,806.25,731.55>, <0.983,-0.184,0>,
		<747.65,-99,730.45>, <0.977,-0.213,0>,
		<747.65,806.25,730.45>, <0.974,-0.228,0>
  }
  smooth_triangle { // #1067
		<747.9,-99,729.5>, <0.973,-0.232,0>,
		<747.65,806.25,730.45>, <0.974,-0.228,0>,
		<747.65,-99,730.45>, <0.977,-0.213,0>
  }
  smooth_triangle { // #1068
		<747.65,806.25,730.45>, <0.974,-0.228,0>,
		<747.9,-99,729.5>, <0.973,-0.232,0>,
		<747.9,806.25,729.5>, <0.975,-0.222,0>
  }
  smooth_triangle { // #1069
		<748.15,-99,728.3>, <0.97,-0.243,0>,
		<747.9,806.25,729.5>, <0.975,-0.222,0>,
		<747.9,-99,729.5>, <0.973,-0.232,0>
  }
  smooth_triangle { // #1070
		<747.9,806.25,729.5>, <0.975,-0.222,0>,
		<748.15,-99,728.3>, <0.97,-0.243,0>,
		<748.15,806.25,728.3>, <0.962,-0.274,0>
  }
  smooth_triangle { // #1071
		<748.75,-99,726.55>, <0.868,-0.496,0>,
		<748.15,806.25,728.3>, <0.962,-0.274,0>,
		<748.15,-99,728.3>, <0.97,-0.243,0>
  }
  smooth_triangle { // #1072
		<748.15,806.25,728.3>, <0.962,-0.274,0>,
		<748.75,-99,726.55>, <0.868,-0.496,0>,
		<748.75,806.25,726.55>, <0.741,-0.672,0>
  }
  smooth_triangle { // #1073
		<750.6,-99,725.15>, <0.444,-0.896,0>,
		<748.75,806.25,726.55>, <0.741,-0.672,0>,
		<748.75,-99,726.55>, <0.868,-0.496,0>
  }
  smooth_triangle { // #1074
		<748.75,806.25,726.55>, <0.741,-0.672,0>,
		<750.6,-99,725.15>, <0.444,-0.896,0>,
		<750.6,806.25,725.15>, <0.285,-0.959,0>
  }
  smooth_triangle { // #1075
		<751.55,-99,725.05>, <0.12,-0.993,0>,
		<750.6,806.25,725.15>, <0.285,-0.959,0>,
		<750.6,-99,725.15>, <0.444,-0.896,0>
  }
  smooth_triangle { // #1076
		<750.6,806.25,725.15>, <0.285,-0.959,0>,
		<751.55,-99,725.05>, <0.12,-0.993,0>,
		<751.55,806.25,725.05>, <0.118,-0.993,0>
  }
  triangle { // #1077
		<752.4,-99,724.95>,
		<751.55,806.25,725.05>,
		<751.55,-99,725.05>
  }
  triangle { // #1078
		<751.55,806.25,725.05>,
		<752.4,-99,724.95>,
		<752.4,806.25,724.95>
  }
  triangle { // #1079
		<753.2,-99,724.85>,
		<752.4,806.25,724.95>,
		<752.4,-99,724.95>
  }
  triangle { // #1080
		<752.4,806.25,724.95>,
		<753.2,-99,724.85>,
		<753.2,806.25,724.85>
  }
  triangle { // #1081
		<754,-99,724.8>,
		<753.2,806.25,724.85>,
		<753.2,-99,724.85>
  }
  triangle { // #1082
		<753.2,806.25,724.85>,
		<754,-99,724.8>,
		<754,806.25,724.8>
  }
  triangle { // #1083
		<754.75,-99,724.75>,
		<754,806.25,724.8>,
		<754,-99,724.8>
  }
  triangle { // #1084
		<754,806.25,724.8>,
		<754.75,-99,724.75>,
		<754.75,806.25,724.75>
  }
  triangle { // #1085
		<755.4,-99,724.65>,
		<754.75,806.25,724.75>,
		<754.75,-99,724.75>
  }
  triangle { // #1086
		<754.75,806.25,724.75>,
		<755.4,-99,724.65>,
		<755.4,806.25,724.65>
  }
  triangle { // #1087
		<756.05,-99,724.65>,
		<755.4,806.25,724.65>,
		<755.4,-99,724.65>
  }
  triangle { // #1088
		<755.4,806.25,724.65>,
		<756.05,-99,724.65>,
		<756.05,806.25,724.65>
  }
  triangle { // #1089
		<756.65,-99,724.6>,
		<756.05,806.25,724.65>,
		<756.05,-99,724.65>
  }
  smooth_triangle { // #1090
		<756.05,806.25,724.65>, <0.058,-0.998,0>,
		<756.65,-99,724.6>, <0.048,-0.999,0>,
		<756.65,806.25,724.6>, <0.042,-0.999,0>
  }
  smooth_triangle { // #1091
		<757.2,-99,724.6>, <0.03,-1,0>,
		<756.65,806.25,724.6>, <0.042,-0.999,0>,
		<756.65,-99,724.6>, <0.048,-0.999,0>
  }
  smooth_triangle { // #1092
		<756.65,806.25,724.6>, <0.042,-0.999,0>,
		<757.2,-99,724.6>, <0.03,-1,0>,
		<757.2,806.25,724.6>, <0.024,-1,0>
  }
  smooth_triangle { // #1093
		<757.7,-99,724.55>, <0.01,-1,0>,
		<757.2,806.25,724.6>, <0.024,-1,0>,
		<757.2,-99,724.6>, <0.03,-1,0>
  }
  smooth_triangle { // #1094
		<757.2,806.25,724.6>, <0.024,-1,0>,
		<757.7,-99,724.55>, <0.01,-1,0>,
		<757.7,806.25,724.55>, <0.002,-1,0>
  }
  smooth_triangle { // #1095
		<758.2,-99,724.55>, <-0.015,-1,0>,
		<757.7,806.25,724.55>, <0.002,-1,0>,
		<757.7,-99,724.55>, <0.01,-1,0>
  }
  smooth_triangle { // #1096
		<757.7,806.25,724.55>, <0.002,-1,0>,
		<758.2,-99,724.55>, <-0.015,-1,0>,
		<758.2,806.25,724.55>, <-0.024,-1,0>
  }
  smooth_triangle { // #1097
		<758.6,-99,724.6>, <-0.045,-0.999,0>,
		<758.2,806.25,724.55>, <-0.024,-1,0>,
		<758.2,-99,724.55>, <-0.015,-1,0>
  }
  smooth_triangle { // #1098
		<758.2,806.25,724.55>, <-0.024,-1,0>,
		<758.6,-99,724.6>, <-0.045,-0.999,0>,
		<758.6,806.25,724.6>, <-0.057,-0.998,0>
  }
  smooth_triangle { // #1099
		<759,-99,724.6>, <-0.082,-0.997,0>,
		<758.6,806.25,724.6>, <-0.057,-0.998,0>,
		<758.6,-99,724.6>, <-0.045,-0.999,0>
  }
  smooth_triangle { // #1100
		<758.6,806.25,724.6>, <-0.057,-0.998,0>,
		<759,-99,724.6>, <-0.082,-0.997,0>,
		<759,806.25,724.6>, <-0.097,-0.995,0>
  }
  smooth_triangle { // #1101
		<759.3,-99,724.65>, <-0.13,-0.992,0>,
		<759,806.25,724.6>, <-0.097,-0.995,0>,
		<759,-99,724.6>, <-0.082,-0.997,0>
  }
  smooth_triangle { // #1102
		<759,806.25,724.6>, <-0.097,-0.995,0>,
		<759.3,-99,724.65>, <-0.13,-0.992,0>,
		<759.3,806.25,724.65>, <-0.149,-0.989,0>
  }
  smooth_triangle { // #1103
		<759.6,-99,724.7>, <-0.192,-0.981,0>,
		<759.3,806.25,724.65>, <-0.149,-0.989,0>,
		<759.3,-99,724.65>, <-0.13,-0.992,0>
  }
  smooth_triangle { // #1104
		<759.3,806.25,724.65>, <-0.149,-0.989,0>,
		<759.6,-99,724.7>, <-0.192,-0.981,0>,
		<759.6,806.25,724.7>, <-0.217,-0.976,0>
  }
  smooth_triangle { // #1105
		<759.85,-99,724.75>, <-0.313,-0.95,0>,
		<759.6,806.25,724.7>, <-0.217,-0.976,0>,
		<759.6,-99,724.7>, <-0.192,-0.981,0>
  }
  smooth_triangle { // #1106
		<759.6,806.25,724.7>, <-0.217,-0.976,0>,
		<759.85,-99,724.75>, <-0.313,-0.95,0>,
		<759.85,806.25,724.75>, <-0.383,-0.924,0>
  }
  smooth_triangle { // #1107
		<760.05,-99,724.85>, <-0.53,-0.848,0>,
		<759.85,806.25,724.75>, <-0.383,-0.924,0>,
		<759.85,-99,724.75>, <-0.313,-0.95,0>
  }
  smooth_triangle { // #1108
		<759.85,806.25,724.75>, <-0.383,-0.924,0>,
		<760.05,-99,724.85>, <-0.53,-0.848,0>,
		<760.05,806.25,724.85>, <-0.605,-0.796,0>
  }
  smooth_triangle { // #1109
		<760.25,-99,725.05>, <-0.719,-0.695,0>,
		<760.05,806.25,724.85>, <-0.605,-0.796,0>,
		<760.05,-99,724.85>, <-0.53,-0.848,0>
  }
  smooth_triangle { // #1110
		<760.05,806.25,724.85>, <-0.605,-0.796,0>,
		<760.25,-99,725.05>, <-0.719,-0.695,0>,
		<760.25,806.25,725.05>, <-0.761,-0.649,0>
  }
  smooth_triangle { // #1111
		<760.5,-99,725.35>, <-0.824,-0.567,0>,
		<760.25,806.25,725.05>, <-0.761,-0.649,0>,
		<760.25,-99,725.05>, <-0.719,-0.695,0>
  }
  smooth_triangle { // #1112
		<760.25,806.25,725.05>, <-0.761,-0.649,0>,
		<760.5,-99,725.35>, <-0.824,-0.567,0>,
		<760.5,806.25,725.35>, <-0.847,-0.532,0>
  }
  smooth_triangle { // #1113
		<760.7,-99,725.75>, <-0.882,-0.471,0>,
		<760.5,806.25,725.35>, <-0.847,-0.532,0>,
		<760.5,-99,725.35>, <-0.824,-0.567,0>
  }
  smooth_triangle { // #1114
		<760.5,806.25,725.35>, <-0.847,-0.532,0>,
		<760.7,-99,725.75>, <-0.882,-0.471,0>,
		<760.7,806.25,725.75>, <-0.896,-0.445,0>
  }
  smooth_triangle { // #1115
		<760.9,-99,726.2>, <-0.917,-0.399,0>,
		<760.7,806.25,725.75>, <-0.896,-0.445,0>,
		<760.7,-99,725.75>, <-0.882,-0.471,0>
  }
  smooth_triangle { // #1116
		<760.7,806.25,725.75>, <-0.896,-0.445,0>,
		<760.9,-99,726.2>, <-0.917,-0.399,0>,
		<760.9,806.25,726.2>, <-0.925,-0.379,0>
  }
  smooth_triangle { // #1117
		<761.15,-99,726.75>, <-0.939,-0.344,0>,
		<760.9,806.25,726.2>, <-0.925,-0.379,0>,
		<760.9,-99,726.2>, <-0.917,-0.399,0>
  }
  smooth_triangle { // #1118
		<760.9,806.25,726.2>, <-0.925,-0.379,0>,
		<761.15,-99,726.75>, <-0.939,-0.344,0>,
		<761.15,806.25,726.75>, <-0.944,-0.329,0>
  }
  smooth_triangle { // #1119
		<761.35,-99,727.4>, <-0.953,-0.301,0>,
		<761.15,806.25,726.75>, <-0.944,-0.329,0>,
		<761.15,-99,726.75>, <-0.939,-0.344,0>
  }
  smooth_triangle { // #1120
		<761.15,806.25,726.75>, <-0.944,-0.329,0>,
		<761.35,-99,727.4>, <-0.953,-0.301,0>,
		<761.35,806.25,727.4>, <-0.957,-0.289,0>
  }
  smooth_triangle { // #1121
		<761.55,-99,728.1>, <-0.964,-0.267,0>,
		<761.35,806.25,727.4>, <-0.957,-0.289,0>,
		<761.35,-99,727.4>, <-0.953,-0.301,0>
  }
  smooth_triangle { // #1122
		<761.35,806.25,727.4>, <-0.957,-0.289,0>,
		<761.55,-99,728.1>, <-0.964,-0.267,0>,
		<761.55,806.25,728.1>, <-0.966,-0.258,0>
  }
  smooth_triangle { // #1123
		<761.75,-99,728.9>, <-0.971,-0.24,0>,
		<761.55,806.25,728.1>, <-0.966,-0.258,0>,
		<761.55,-99,728.1>, <-0.964,-0.267,0>
  }
  smooth_triangle { // #1124
		<761.55,806.25,728.1>, <-0.966,-0.258,0>,
		<761.75,-99,728.9>, <-0.971,-0.24,0>,
		<761.75,806.25,728.9>, <-0.973,-0.232,0>
  }
  smooth_triangle { // #1125
		<761.95,-99,729.85>, <-0.976,-0.217,0>,
		<761.75,806.25,728.9>, <-0.973,-0.232,0>,
		<761.75,-99,728.9>, <-0.971,-0.24,0>
  }
  smooth_triangle { // #1126
		<761.75,806.25,728.9>, <-0.973,-0.232,0>,
		<761.95,-99,729.85>, <-0.976,-0.217,0>,
		<761.95,806.25,729.85>, <-0.978,-0.211,0>
  }
  smooth_triangle { // #1127
		<762.15,-99,730.8>, <-0.98,-0.198,0>,
		<761.95,806.25,729.85>, <-0.978,-0.211,0>,
		<761.95,-99,729.85>, <-0.976,-0.217,0>
  }
  smooth_triangle { // #1128
		<761.95,806.25,729.85>, <-0.978,-0.211,0>,
		<762.15,-99,730.8>, <-0.98,-0.198,0>,
		<762.15,806.25,730.8>, <-0.981,-0.193,0>
  }
  smooth_triangle { // #1129
		<762.4,-99,731.9>, <-0.983,-0.182,0>,
		<762.15,806.25,730.8>, <-0.981,-0.193,0>,
		<762.15,-99,730.8>, <-0.98,-0.198,0>
  }
  triangle { // #1130
		<762.15,806.25,730.8>,
		<762.4,-99,731.9>,
		<762.4,806.25,731.9>
  }
  triangle { // #1131
		<762.6,-99,733.1>,
		<762.4,806.25,731.9>,
		<762.4,-99,731.9>
  }
  triangle { // #1132
		<762.4,806.25,731.9>,
		<762.6,-99,733.1>,
		<762.6,806.25,733.1>
  }
  triangle { // #1133
		<762.8,-99,734.35>,
		<762.6,806.25,733.1>,
		<762.6,-99,733.1>
  }
  triangle { // #1134
		<762.6,806.25,733.1>,
		<762.8,-99,734.35>,
		<762.8,806.25,734.35>
  }
  triangle { // #1135
		<763,-99,735.7>,
		<762.8,806.25,734.35>,
		<762.8,-99,734.35>
  }
  triangle { // #1136
		<762.8,806.25,734.35>,
		<763,-99,735.7>,
		<763,806.25,735.7>
  }
  triangle { // #1137
		<763.2,-99,737.1>,
		<763,806.25,735.7>,
		<763,-99,735.7>
  }
  triangle { // #1138
		<763,806.25,735.7>,
		<763.2,-99,737.1>,
		<763.2,806.25,737.1>
  }
  triangle { // #1139
		<763.6,-99,739.75>,
		<763.2,806.25,737.1>,
		<763.2,-99,737.1>
  }
  triangle { // #1140
		<763.2,806.25,737.1>,
		<763.6,-99,739.75>,
		<763.6,806.25,739.75>
  }
  triangle { // #1141
		<764,-99,742.35>,
		<763.6,806.25,739.75>,
		<763.6,-99,739.75>
  }
  triangle { // #1142
		<763.6,806.25,739.75>,
		<764,-99,742.35>,
		<764,806.25,742.35>
  }
  triangle { // #1143
		<764.4,-99,744.85>,
		<764,806.25,742.35>,
		<764,-99,742.35>
  }
  triangle { // #1144
		<764,806.25,742.35>,
		<764.4,-99,744.85>,
		<764.4,806.25,744.85>
  }
  triangle { // #1145
		<764.8,-99,747.3>,
		<764.4,806.25,744.85>,
		<764.4,-99,744.85>
  }
  triangle { // #1146
		<764.4,806.25,744.85>,
		<764.8,-99,747.3>,
		<764.8,806.25,747.3>
  }
  triangle { // #1147
		<765.2,-99,749.7>,
		<764.8,806.25,747.3>,
		<764.8,-99,747.3>
  }
  triangle { // #1148
		<764.8,806.25,747.3>,
		<765.2,-99,749.7>,
		<765.2,806.25,749.7>
  }
  triangle { // #1149
		<765.6,-99,752>,
		<765.2,806.25,749.7>,
		<765.2,-99,749.7>
  }
  triangle { // #1150
		<765.2,806.25,749.7>,
		<765.6,-99,752>,
		<765.6,806.25,752>
  }
  triangle { // #1151
		<766,-99,754.3>,
		<765.6,806.25,752>,
		<765.6,-99,752>
  }
  triangle { // #1152
		<765.6,806.25,752>,
		<766,-99,754.3>,
		<766,806.25,754.3>
  }
  triangle { // #1153
		<766.4,-99,756.5>,
		<766,806.25,754.3>,
		<766,-99,754.3>
  }
  triangle { // #1154
		<766,806.25,754.3>,
		<766.4,-99,756.5>,
		<766.4,806.25,756.5>
  }
  triangle { // #1155
		<766.8,-99,758.6>,
		<766.4,806.25,756.5>,
		<766.4,-99,756.5>
  }
  triangle { // #1156
		<766.4,806.25,756.5>,
		<766.8,-99,758.6>,
		<766.8,806.25,758.6>
  }
  triangle { // #1157
		<767.25,-99,760.7>,
		<766.8,806.25,758.6>,
		<766.8,-99,758.6>
  }
  triangle { // #1158
		<766.8,806.25,758.6>,
		<767.25,-99,760.7>,
		<767.25,806.25,760.7>
  }
  triangle { // #1159
		<767.65,-99,762.7>,
		<767.25,806.25,760.7>,
		<767.25,-99,760.7>
  }
  triangle { // #1160
		<767.25,806.25,760.7>,
		<767.65,-99,762.7>,
		<767.65,806.25,762.7>
  }
  triangle { // #1161
		<768.1,-99,764.65>,
		<767.65,806.25,762.7>,
		<767.65,-99,762.7>
  }
  triangle { // #1162
		<767.65,806.25,762.7>,
		<768.1,-99,764.65>,
		<768.1,806.25,764.65>
  }
  triangle { // #1163
		<768.5,-99,766.55>,
		<768.1,806.25,764.65>,
		<768.1,-99,764.65>
  }
  triangle { // #1164
		<768.1,806.25,764.65>,
		<768.5,-99,766.55>,
		<768.5,806.25,766.55>
  }
  triangle { // #1165
		<768.95,-99,768.35>,
		<768.5,806.25,766.55>,
		<768.5,-99,766.55>
  }
  triangle { // #1166
		<768.5,806.25,766.55>,
		<768.95,-99,768.35>,
		<768.95,806.25,768.35>
  }
  triangle { // #1167
		<769.35,-99,770.1>,
		<768.95,806.25,768.35>,
		<768.95,-99,768.35>
  }
  triangle { // #1168
		<768.95,806.25,768.35>,
		<769.35,-99,770.1>,
		<769.35,806.25,770.1>
  }
  triangle { // #1169
		<769.8,-99,771.8>,
		<769.35,806.25,770.1>,
		<769.35,-99,770.1>
  }
  smooth_triangle { // #1170
		<769.35,806.25,770.1>, <-0.97,-0.243,0>,
		<769.8,-99,771.8>, <-0.968,-0.251,0>,
		<769.8,806.25,771.8>, <-0.967,-0.256,0>
  }
  smooth_triangle { // #1171
		<770.25,-99,773.55>, <-0.964,-0.268,0>,
		<769.8,806.25,771.8>, <-0.967,-0.256,0>,
		<769.8,-99,771.8>, <-0.968,-0.251,0>
  }
  smooth_triangle { // #1172
		<769.8,806.25,771.8>, <-0.967,-0.256,0>,
		<770.25,-99,773.55>, <-0.964,-0.268,0>,
		<770.25,806.25,773.55>, <-0.962,-0.274,0>
  }
  smooth_triangle { // #1173
		<770.8,-99,775.35>, <-0.958,-0.286,0>,
		<770.25,806.25,773.55>, <-0.962,-0.274,0>,
		<770.25,-99,773.55>, <-0.964,-0.268,0>
  }
  smooth_triangle { // #1174
		<770.25,806.25,773.55>, <-0.962,-0.274,0>,
		<770.8,-99,775.35>, <-0.958,-0.286,0>,
		<770.8,806.25,775.35>, <-0.957,-0.291,0>
  }
  smooth_triangle { // #1175
		<771.35,-99,777.25>, <-0.953,-0.301,0>,
		<770.8,806.25,775.35>, <-0.957,-0.291,0>,
		<770.8,-99,775.35>, <-0.958,-0.286,0>
  }
  triangle { // #1176
		<770.8,806.25,775.35>,
		<771.35,-99,777.25>,
		<771.35,806.25,777.25>
  }
  triangle { // #1177
		<772,-99,779.25>,
		<771.35,806.25,777.25>,
		<771.35,-99,777.25>
  }
  triangle { // #1178
		<771.35,806.25,777.25>,
		<772,-99,779.25>,
		<772,806.25,779.25>
  }
  triangle { // #1179
		<772.75,-99,781.3>,
		<772,806.25,779.25>,
		<772,-99,779.25>
  }
  triangle { // #1180
		<772,806.25,779.25>,
		<772.75,-99,781.3>,
		<772.75,806.25,781.3>
  }
  triangle { // #1181
		<773.5,-99,783.5>,
		<772.75,806.25,781.3>,
		<772.75,-99,781.3>
  }
  triangle { // #1182
		<772.75,806.25,781.3>,
		<773.5,-99,783.5>,
		<773.5,806.25,783.5>
  }
  triangle { // #1183
		<774.35,-99,785.75>,
		<773.5,806.25,783.5>,
		<773.5,-99,783.5>
  }
  triangle { // #1184
		<773.5,806.25,783.5>,
		<774.35,-99,785.75>,
		<774.35,806.25,785.75>
  }
  triangle { // #1185
		<775.25,-99,788.15>,
		<774.35,806.25,785.75>,
		<774.35,-99,785.75>
  }
  triangle { // #1186
		<774.35,806.25,785.75>,
		<775.25,-99,788.15>,
		<775.25,806.25,788.15>
  }
  triangle { // #1187
		<776.25,-99,790.6>,
		<775.25,806.25,788.15>,
		<775.25,-99,788.15>
  }
  triangle { // #1188
		<775.25,806.25,788.15>,
		<776.25,-99,790.6>,
		<776.25,806.25,790.6>
  }
  triangle { // #1189
		<777.25,-99,793.15>,
		<776.25,806.25,790.6>,
		<776.25,-99,790.6>
  }
  triangle { // #1190
		<776.25,806.25,790.6>,
		<777.25,-99,793.15>,
		<777.25,806.25,793.15>
  }
  triangle { // #1191
		<778.35,-99,795.8>,
		<777.25,806.25,793.15>,
		<777.25,-99,793.15>
  }
  triangle { // #1192
		<777.25,806.25,793.15>,
		<778.35,-99,795.8>,
		<778.35,806.25,795.8>
  }
  triangle { // #1193
		<779.5,-99,798.55>,
		<778.35,806.25,795.8>,
		<778.35,-99,795.8>
  }
  triangle { // #1194
		<778.35,806.25,795.8>,
		<779.5,-99,798.55>,
		<779.5,806.25,798.55>
  }
  triangle { // #1195
		<780.75,-99,801.4>,
		<779.5,806.25,798.55>,
		<779.5,-99,798.55>
  }
  triangle { // #1196
		<779.5,806.25,798.55>,
		<780.75,-99,801.4>,
		<780.75,806.25,801.4>
  }
  triangle { // #1197
		<782,-99,804.3>,
		<780.75,806.25,801.4>,
		<780.75,-99,801.4>
  }
  triangle { // #1198
		<780.75,806.25,801.4>,
		<782,-99,804.3>,
		<782,806.25,804.3>
  }
  triangle { // #1199
		<783.35,-99,807.35>,
		<782,806.25,804.3>,
		<782,-99,804.3>
  }
  triangle { // #1200
		<782,806.25,804.3>,
		<783.35,-99,807.35>,
		<783.35,806.25,807.35>
  }
  triangle { // #1201
		<784.75,-99,810.45>,
		<783.35,806.25,807.35>,
		<783.35,-99,807.35>
  }
  triangle { // #1202
		<783.35,806.25,807.35>,
		<784.75,-99,810.45>,
		<784.75,806.25,810.45>
  }
  triangle { // #1203
		<786.25,-99,813.75>,
		<784.75,806.25,810.45>,
		<784.75,-99,810.45>
  }
  triangle { // #1204
		<784.75,806.25,810.45>,
		<786.25,-99,813.75>,
		<786.25,806.25,813.75>
  }
  triangle { // #1205
		<787.8,-99,817.3>,
		<786.25,806.25,813.75>,
		<786.25,-99,813.75>
  }
  triangle { // #1206
		<786.25,806.25,813.75>,
		<787.8,-99,817.3>,
		<787.8,806.25,817.3>
  }
  triangle { // #1207
		<789.4,-99,821.15>,
		<787.8,806.25,817.3>,
		<787.8,-99,817.3>
  }
  triangle { // #1208
		<787.8,806.25,817.3>,
		<789.4,-99,821.15>,
		<789.4,806.25,821.15>
  }
  triangle { // #1209
		<791.05,-99,825.3>,
		<789.4,806.25,821.15>,
		<789.4,-99,821.15>
  }
  triangle { // #1210
		<789.4,806.25,821.15>,
		<791.05,-99,825.3>,
		<791.05,806.25,825.3>
  }
  triangle { // #1211
		<792.8,-99,829.7>,
		<791.05,806.25,825.3>,
		<791.05,-99,825.3>
  }
  triangle { // #1212
		<791.05,806.25,825.3>,
		<792.8,-99,829.7>,
		<792.8,806.25,829.7>
  }
  triangle { // #1213
		<794.55,-99,834.35>,
		<792.8,806.25,829.7>,
		<792.8,-99,829.7>
  }
  triangle { // #1214
		<792.8,806.25,829.7>,
		<794.55,-99,834.35>,
		<794.55,806.25,834.35>
  }
  triangle { // #1215
		<796.4,-99,839.3>,
		<794.55,806.25,834.35>,
		<794.55,-99,834.35>
  }
  triangle { // #1216
		<794.55,806.25,834.35>,
		<796.4,-99,839.3>,
		<796.4,806.25,839.3>
  }
  triangle { // #1217
		<798.35,-99,844.5>,
		<796.4,806.25,839.3>,
		<796.4,-99,839.3>
  }
  triangle { // #1218
		<796.4,806.25,839.3>,
		<798.35,-99,844.5>,
		<798.35,806.25,844.5>
  }
  triangle { // #1219
		<800.35,-99,850>,
		<798.35,806.25,844.5>,
		<798.35,-99,844.5>
  }
  triangle { // #1220
		<798.35,806.25,844.5>,
		<800.35,-99,850>,
		<800.35,806.25,850>
  }
  triangle { // #1221
		<802.35,-99,855.75>,
		<800.35,806.25,850>,
		<800.35,-99,850>
  }
  triangle { // #1222
		<800.35,806.25,850>,
		<802.35,-99,855.75>,
		<802.35,806.25,855.75>
  }
  triangle { // #1223
		<804.5,-99,861.8>,
		<802.35,806.25,855.75>,
		<802.35,-99,855.75>
  }
  triangle { // #1224
		<802.35,806.25,855.75>,
		<804.5,-99,861.8>,
		<804.5,806.25,861.8>
  }
  triangle { // #1225
		<806.65,-99,868.1>,
		<804.5,806.25,861.8>,
		<804.5,-99,861.8>
  }
  triangle { // #1226
		<804.5,806.25,861.8>,
		<806.65,-99,868.1>,
		<806.65,806.25,868.1>
  }
  triangle { // #1227
		<808.9,-99,874.7>,
		<806.65,806.25,868.1>,
		<806.65,-99,868.1>
  }
  triangle { // #1228
		<806.65,806.25,868.1>,
		<808.9,-99,874.7>,
		<808.9,806.25,874.7>
  }
  triangle { // #1229
		<811.2,-99,881.55>,
		<808.9,806.25,874.7>,
		<808.9,-99,874.7>
  }
  triangle { // #1230
		<808.9,806.25,874.7>,
		<811.2,-99,881.55>,
		<811.2,806.25,881.55>
  }
  triangle { // #1231
		<813.55,-99,888.7>,
		<811.2,806.25,881.55>,
		<811.2,-99,881.55>
  }
  triangle { // #1232
		<811.2,806.25,881.55>,
		<813.55,-99,888.7>,
		<813.55,806.25,888.7>
  }
  triangle { // #1233
		<816,-99,896.1>,
		<813.55,806.25,888.7>,
		<813.55,-99,888.7>
  }
  triangle { // #1234
		<813.55,806.25,888.7>,
		<816,-99,896.1>,
		<816,806.25,896.1>
  }
  triangle { // #1235
		<816,-99,896.1>,
		<801.95,-99,897.25>,
		<801.95,806.25,897.25>
  }
  triangle { // #1236
		<801.95,806.25,897.25>,
		<816,806.25,896.1>,
		<816,-99,896.1>
  }
  triangle { // #1237
		<884.7,0,28.3>,
		<1861.95,0,28.3>,
		<884.7,0,-649.8>
  }
  triangle { // #1238
		<1861.95,0,-649.8>,
		<884.7,0,-649.8>,
		<1861.95,0,28.3>
  }
  triangle { // #1239
		<884.7,-30.2,-649.8>,
		<1861.95,-30.2,-649.8>,
		<884.7,-30.2,28.3>
  }
  triangle { // #1240
		<1861.95,-30.2,28.3>,
		<884.7,-30.2,28.3>,
		<1861.95,-30.2,-649.8>
  }
  triangle { // #1241
		<884.7,0,-649.8>,
		<884.7,-30.2,-649.8>,
		<884.7,0,28.3>
  }
  triangle { // #1242
		<884.7,-30.2,28.3>,
		<884.7,0,28.3>,
		<884.7,-30.2,-649.8>
  }
  triangle { // #1243
		<1861.95,0,-649.8>,
		<1861.95,-30.2,-649.8>,
		<884.7,0,-649.8>
  }
  triangle { // #1244
		<884.7,-30.2,-649.8>,
		<884.7,0,-649.8>,
		<1861.95,-30.2,-649.8>
  }
  triangle { // #1245
		<1861.95,0,28.3>,
		<1861.95,-30.2,28.3>,
		<1861.95,0,-649.8>
  }
  triangle { // #1246
		<1861.95,-30.2,-649.8>,
		<1861.95,0,-649.8>,
		<1861.95,-30.2,28.3>
  }
  triangle { // #1247
		<884.7,0,28.3>,
		<884.7,-30.2,28.3>,
		<1861.95,0,28.3>
  }
  triangle { // #1248
		<1861.95,-30.2,28.3>,
		<1861.95,0,28.3>,
		<884.7,-30.2,28.3>
  }
  triangle { // #1249
		<-885.6,0,28.2>,
		<-885.6,0,-652.5>,
		<-1863.1,0,28.2>
  }
  triangle { // #1250
		<-1863.1,0,-652.5>,
		<-1863.1,0,28.2>,
		<-885.6,0,-652.5>
  }
  triangle { // #1251
		<-1863.1,-30.2,-652.5>,
		<-885.6,-30.2,-652.5>,
		<-1863.1,-30.2,28.2>
  }
  triangle { // #1252
		<-885.6,-30.2,28.2>,
		<-1863.1,-30.2,28.2>,
		<-885.6,-30.2,-652.5>
  }
  triangle { // #1253
		<-1863.1,0,-652.5>,
		<-1863.1,-30.2,-652.5>,
		<-1863.1,0,28.2>
  }
  triangle { // #1254
		<-1863.1,-30.2,28.2>,
		<-1863.1,0,28.2>,
		<-1863.1,-30.2,-652.5>
  }
  triangle { // #1255
		<-885.6,0,-652.5>,
		<-885.6,-30.2,-652.5>,
		<-1863.1,0,-652.5>
  }
  triangle { // #1256
		<-1863.1,-30.2,-652.5>,
		<-1863.1,0,-652.5>,
		<-885.6,-30.2,-652.5>
  }
  triangle { // #1257
		<-885.6,0,28.2>,
		<-885.6,-30.2,28.2>,
		<-885.6,0,-652.5>
  }
  triangle { // #1258
		<-885.6,-30.2,-652.5>,
		<-885.6,0,-652.5>,
		<-885.6,-30.2,28.2>
  }
  triangle { // #1259
		<-1863.1,0,28.2>,
		<-1863.1,-30.2,28.2>,
		<-885.6,0,28.2>
  }
  triangle { // #1260
		<-885.6,-30.2,28.2>,
		<-885.6,0,28.2>,
		<-1863.1,-30.2,28.2>
  }
  triangle { // #1261
		<-885.6,0,29.55>,
		<885.95,0,29.55>,
		<-885.6,0,-824.75>
  }
  triangle { // #1262
		<885.95,0,-824.75>,
		<-885.6,0,-824.75>,
		<885.95,0,29.55>
  }
  triangle { // #1263
		<-885.6,-30.2,-824.75>,
		<885.95,-30.2,-824.75>,
		<-885.6,-30.2,29.55>
  }
  triangle { // #1264
		<885.95,-30.2,29.55>,
		<-885.6,-30.2,29.55>,
		<885.95,-30.2,-824.75>
  }
  triangle { // #1265
		<-885.6,0,-824.75>,
		<-885.6,-30.2,-824.75>,
		<-885.6,0,29.55>
  }
  triangle { // #1266
		<-885.6,-30.2,29.55>,
		<-885.6,0,29.55>,
		<-885.6,-30.2,-824.75>
  }
  triangle { // #1267
		<885.95,0,-824.75>,
		<885.95,-30.2,-824.75>,
		<-885.6,0,-824.75>
  }
  triangle { // #1268
		<-885.6,-30.2,-824.75>,
		<-885.6,0,-824.75>,
		<885.95,-30.2,-824.75>
  }
  triangle { // #1269
		<885.95,0,29.55>,
		<885.95,-30.2,29.55>,
		<885.95,0,-824.75>
  }
  triangle { // #1270
		<885.95,-30.2,-824.75>,
		<885.95,0,-824.75>,
		<885.95,-30.2,29.55>
  }
  triangle { // #1271
		<-885.6,0,29.55>,
		<-885.6,-30.2,29.55>,
		<885.95,0,29.55>
  }
  triangle { // #1272
		<885.95,-30.2,29.55>,
		<885.95,0,29.55>,
		<-885.6,-30.2,29.55>
  }
  triangle { // #1273
		<843.85,144.6,344.05>,
		<884,144.6,474.8>,
		<843.85,144.6,474.8>
  }
  triangle { // #1274
		<884,144.6,474.8>,
		<843.85,144.6,344.05>,
		<884,144.6,344.05>
  }
  triangle { // #1275
		<843.85,806.25,474.8>,
		<884,806.25,344.05>,
		<843.85,806.25,344.05>
  }
  triangle { // #1276
		<884,806.25,344.05>,
		<843.85,806.25,474.8>,
		<884,806.25,474.8>
  }
  triangle { // #1277
		<843.85,144.6,474.8>,
		<843.85,806.25,344.05>,
		<843.85,144.6,344.05>
  }
  triangle { // #1278
		<843.85,806.25,344.05>,
		<843.85,144.6,474.8>,
		<843.85,806.25,474.8>
  }
  triangle { // #1279
		<843.85,144.6,344.05>,
		<884,806.25,344.05>,
		<884,144.6,344.05>
  }
  triangle { // #1280
		<884,806.25,344.05>,
		<843.85,144.6,344.05>,
		<843.85,806.25,344.05>
  }
  triangle { // #1281
		<884,144.6,344.05>,
		<884,806.25,474.8>,
		<884,144.6,474.8>
  }
  triangle { // #1282
		<884,806.25,474.8>,
		<884,144.6,344.05>,
		<884,806.25,344.05>
  }
  triangle { // #1283
		<884,144.6,474.8>,
		<843.85,806.25,474.8>,
		<843.85,144.6,474.8>
  }
  triangle { // #1284
		<843.85,806.25,474.8>,
		<884,144.6,474.8>,
		<884,806.25,474.8>
  }
  triangle { // #1285
		<-880.6,144.6,339.45>,
		<-840.35,144.6,472.5>,
		<-880.6,144.6,472.5>
  }
  triangle { // #1286
		<-840.35,144.6,472.5>,
		<-880.6,144.6,339.45>,
		<-840.35,144.6,339.45>
  }
  triangle { // #1287
		<-880.6,806.25,339.45>,
		<-840.35,806.25,472.5>,
		<-840.35,806.25,339.45>
  }
  triangle { // #1288
		<-840.35,806.25,472.5>,
		<-880.6,806.25,339.45>,
		<-880.6,806.25,472.5>
  }
  triangle { // #1289
		<-880.6,144.6,472.5>,
		<-880.6,806.25,339.45>,
		<-880.6,144.6,339.45>
  }
  triangle { // #1290
		<-880.6,806.25,339.45>,
		<-880.6,144.6,472.5>,
		<-880.6,806.25,472.5>
  }
  triangle { // #1291
		<-880.6,144.6,339.45>,
		<-840.35,806.25,339.45>,
		<-840.35,144.6,339.45>
  }
  triangle { // #1292
		<-840.35,806.25,339.45>,
		<-880.6,144.6,339.45>,
		<-880.6,806.25,339.45>
  }
  triangle { // #1293
		<-840.35,144.6,339.45>,
		<-840.35,806.25,472.5>,
		<-840.35,144.6,472.5>
  }
  triangle { // #1294
		<-840.35,806.25,472.5>,
		<-840.35,144.6,339.45>,
		<-840.35,806.25,339.45>
  }
  triangle { // #1295
		<-840.35,144.6,472.5>,
		<-880.6,806.25,472.5>,
		<-880.6,144.6,472.5>
  }
  triangle { // #1296
		<-880.6,806.25,472.5>,
		<-840.35,144.6,472.5>,
		<-840.35,806.25,472.5>
  }
  triangle { // #1297
		<-824.9,687.45,-2>,
		<-881.85,687.45,39.75>,
		<-881.85,687.45,28.2>
  }
  triangle { // #1298
		<-824.9,687.45,-2>,
		<-845.35,687.45,-39.7>,
		<-824.9,687.45,-39.7>
  }
  triangle { // #1299
		<844.45,687.45,-42.2>,
		<824.35,687.45,-2>,
		<824.5,687.45,-42.2>
  }
  triangle { // #1300
		<-845.35,687.45,-39.7>,
		<-885.6,687.45,-59.8>,
		<-845.35,687.45,-59.8>
  }
  triangle { // #1301
		<-845.35,687.45,-39.7>,
		<-885.6,687.45,28.2>,
		<-885.6,687.45,-59.8>
  }
  triangle { // #1302
		<-824.9,687.45,-2>,
		<-885.6,687.45,28.2>,
		<-845.35,687.45,-39.7>
  }
  triangle { // #1303
		<-824.9,687.45,-2>,
		<-881.85,687.45,28.2>,
		<-885.6,687.45,28.2>
  }
  triangle { // #1304
		<884.7,687.45,-62.35>,
		<844.45,687.45,-42.2>,
		<844.45,687.45,-62.35>
  }
  triangle { // #1305
		<884.7,687.45,40.55>,
		<844.45,687.45,-42.2>,
		<884.7,687.45,-62.35>
  }
  triangle { // #1306
		<884.7,687.45,40.55>,
		<824.35,687.45,-2>,
		<844.45,687.45,-42.2>
  }
  triangle { // #1307
		<613.65,687.45,40.55>,
		<824.35,687.45,-2>,
		<884.7,687.45,40.55>
  }
  triangle { // #1308
		<613.65,687.45,40.55>,
		<-824.9,687.45,-2>,
		<824.35,687.45,-2>
  }
  triangle { // #1309
		<-615.3,687.45,39.75>,
		<-824.9,687.45,-2>,
		<613.65,687.45,40.55>
  }
  triangle { // #1310
		<-881.85,687.45,39.75>,
		<-824.9,687.45,-2>,
		<-615.3,687.45,39.75>
  }
  triangle { // #1311
		<-881.85,1306,39.75>,
		<-824.9,1306,-2>,
		<-881.85,1306,28.2>
  }
  triangle { // #1312
		<-845.35,1306,-39.7>,
		<-824.9,1306,-2>,
		<-824.9,1306,-39.7>
  }
  triangle { // #1313
		<824.35,1306,-2>,
		<844.45,1306,-42.2>,
		<824.5,1306,-42.2>
  }
  triangle { // #1314
		<-885.6,1306,-59.8>,
		<-845.35,1306,-39.7>,
		<-845.35,1306,-59.8>
  }
  triangle { // #1315
		<-885.6,1306,28.2>,
		<-845.35,1306,-39.7>,
		<-885.6,1306,-59.8>
  }
  triangle { // #1316
		<-885.6,1306,28.2>,
		<-824.9,1306,-2>,
		<-845.35,1306,-39.7>
  }
  triangle { // #1317
		<-881.85,1306,28.2>,
		<-824.9,1306,-2>,
		<-885.6,1306,28.2>
  }
  triangle { // #1318
		<844.45,1306,-42.2>,
		<884.7,1306,-62.35>,
		<844.45,1306,-62.35>
  }
  triangle { // #1319
		<844.45,1306,-42.2>,
		<884.7,1306,40.55>,
		<884.7,1306,-62.35>
  }
  triangle { // #1320
		<824.35,1306,-2>,
		<884.7,1306,40.55>,
		<844.45,1306,-42.2>
  }
  triangle { // #1321
		<824.35,1306,-2>,
		<613.65,1306,40.55>,
		<884.7,1306,40.55>
  }
  triangle { // #1322
		<-824.9,1306,-2>,
		<613.65,1306,40.55>,
		<824.35,1306,-2>
  }
  triangle { // #1323
		<-824.9,1306,-2>,
		<-615.3,1306,39.75>,
		<613.65,1306,40.55>
  }
  triangle { // #1324
		<-824.9,1306,-2>,
		<-881.85,1306,39.75>,
		<-615.3,1306,39.75>
  }
  triangle { // #1325
		<844.45,687.45,-42.2>,
		<844.45,1306,-62.35>,
		<844.45,687.45,-62.35>
  }
  triangle { // #1326
		<844.45,1306,-62.35>,
		<844.45,687.45,-42.2>,
		<844.45,1306,-42.2>
  }
  triangle { // #1327
		<844.45,687.45,-62.35>,
		<884.7,1306,-62.35>,
		<884.7,687.45,-62.35>
  }
  triangle { // #1328
		<884.7,1306,-62.35>,
		<844.45,687.45,-62.35>,
		<844.45,1306,-62.35>
  }
  triangle { // #1329
		<884.7,687.45,-62.35>,
		<884.7,1306,40.55>,
		<884.7,687.45,40.55>
  }
  triangle { // #1330
		<884.7,1306,40.55>,
		<884.7,687.45,-62.35>,
		<884.7,1306,-62.35>
  }
  triangle { // #1331
		<884.7,687.45,40.55>,
		<613.65,1306,40.55>,
		<613.65,687.45,40.55>
  }
  triangle { // #1332
		<613.65,1306,40.55>,
		<884.7,687.45,40.55>,
		<884.7,1306,40.55>
  }
  triangle { // #1333
		<613.65,687.45,40.55>,
		<-615.3,1306,39.75>,
		<-615.3,687.45,39.75>
  }
  triangle { // #1334
		<-615.3,1306,39.75>,
		<613.65,687.45,40.55>,
		<613.65,1306,40.55>
  }
  triangle { // #1335
		<-615.3,687.45,39.75>,
		<-881.85,1306,39.75>,
		<-881.85,687.45,39.75>
  }
  triangle { // #1336
		<-881.85,1306,39.75>,
		<-615.3,687.45,39.75>,
		<-615.3,1306,39.75>
  }
  triangle { // #1337
		<-881.85,687.45,39.75>,
		<-881.85,1306,28.2>,
		<-881.85,687.45,28.2>
  }
  triangle { // #1338
		<-881.85,1306,28.2>,
		<-881.85,687.45,39.75>,
		<-881.85,1306,39.75>
  }
  triangle { // #1339
		<-881.85,687.45,28.2>,
		<-885.6,1306,28.2>,
		<-885.6,687.45,28.2>
  }
  triangle { // #1340
		<-885.6,1306,28.2>,
		<-881.85,687.45,28.2>,
		<-881.85,1306,28.2>
  }
  triangle { // #1341
		<-885.6,687.45,28.2>,
		<-885.6,1306,-59.8>,
		<-885.6,687.45,-59.8>
  }
  triangle { // #1342
		<-885.6,1306,-59.8>,
		<-885.6,687.45,28.2>,
		<-885.6,1306,28.2>
  }
  triangle { // #1343
		<-885.6,687.45,-59.8>,
		<-845.35,1306,-59.8>,
		<-845.35,687.45,-59.8>
  }
  triangle { // #1344
		<-845.35,1306,-59.8>,
		<-885.6,687.45,-59.8>,
		<-885.6,1306,-59.8>
  }
  triangle { // #1345
		<-845.35,687.45,-59.8>,
		<-845.35,1306,-39.7>,
		<-845.35,687.45,-39.7>
  }
  triangle { // #1346
		<-845.35,1306,-39.7>,
		<-845.35,687.45,-59.8>,
		<-845.35,1306,-59.8>
  }
  triangle { // #1347
		<-845.35,687.45,-39.7>,
		<-824.9,1306,-39.7>,
		<-824.9,687.45,-39.7>
  }
  triangle { // #1348
		<-824.9,1306,-39.7>,
		<-845.35,687.45,-39.7>,
		<-845.35,1306,-39.7>
  }
  triangle { // #1349
		<-824.9,687.45,-39.7>,
		<-824.9,1306,-2>,
		<-824.9,687.45,-2>
  }
  triangle { // #1350
		<-824.9,1306,-2>,
		<-824.9,687.45,-39.7>,
		<-824.9,1306,-39.7>
  }
  triangle { // #1351
		<-824.9,687.45,-2>,
		<824.35,1306,-2>,
		<824.35,687.45,-2>
  }
  triangle { // #1352
		<824.35,1306,-2>,
		<-824.9,687.45,-2>,
		<-824.9,1306,-2>
  }
  triangle { // #1353
		<824.35,687.45,-2>,
		<824.5,1306,-42.2>,
		<824.5,687.45,-42.2>
  }
  triangle { // #1354
		<824.5,1306,-42.2>,
		<824.35,687.45,-2>,
		<824.35,1306,-2>
  }
  triangle { // #1355
		<824.5,687.45,-42.2>,
		<844.45,1306,-42.2>,
		<844.45,687.45,-42.2>
  }
  triangle { // #1356
		<844.45,1306,-42.2>,
		<824.5,687.45,-42.2>,
		<824.5,1306,-42.2>
  }
  triangle { // #1357
		<716.25,-99,359.95>,
		<732.45,-99,343.7>,
		<718.95,-99,359.05>
  }
  triangle { // #1358
		<732.45,-99,343.7>,
		<682.45,-99,260.55>,
		<700.65,-99,250.15>
  }
  triangle { // #1359
		<732.45,-99,343.7>,
		<716.25,-99,359.95>,
		<682.45,-99,260.55>
  }
  triangle { // #1360
		<732.45,806.25,343.7>,
		<716.25,806.25,359.95>,
		<718.95,806.25,359.05>
  }
  triangle { // #1361
		<682.45,806.25,260.55>,
		<732.45,806.25,343.7>,
		<700.65,806.25,250.15>
  }
  triangle { // #1362
		<716.25,806.25,359.95>,
		<732.45,806.25,343.7>,
		<682.45,806.25,260.55>
  }
  smooth_triangle { // #1363
		<732.45,-99,343.7>, <0.751,-0.661,0>,
		<718.95,806.25,359.05>, <0.523,-0.853,0>,
		<718.95,-99,359.05>, <0.358,-0.934,0>
  }
  smooth_triangle { // #1364
		<718.95,806.25,359.05>, <0.523,-0.853,0>,
		<732.45,-99,343.7>, <0.751,-0.661,0>,
		<732.45,806.25,343.7>, <0.751,-0.661,0>
  }
  smooth_triangle { // #1365
		<718.95,-99,359.05>, <0.358,-0.934,0>,
		<716.25,806.25,359.95>, <0.322,-0.947,0>,
		<716.25,-99,359.95>, <0.322,-0.947,0>
  }
  smooth_triangle { // #1366
		<716.25,806.25,359.95>, <0.322,-0.947,0>,
		<718.95,-99,359.05>, <0.358,-0.934,0>,
		<718.95,806.25,359.05>, <0.523,-0.853,0>
  }
  triangle { // #1367
		<716.25,-99,359.95>,
		<682.45,806.25,260.55>,
		<682.45,-99,260.55>
  }
  smooth_triangle { // #1368
		<682.45,806.25,260.55>, <-0.947,-0.322,0>,
		<716.25,-99,359.95>, <-0.947,-0.322,0>,
		<716.25,806.25,359.95>, <-0.942,-0.335,0>
  }
  triangle { // #1369
		<682.45,-99,260.55>,
		<700.65,806.25,250.15>,
		<700.65,-99,250.15>
  }
  triangle { // #1370
		<700.65,806.25,250.15>,
		<682.45,-99,260.55>,
		<682.45,806.25,260.55>
  }
  triangle { // #1371
		<700.65,-99,250.15>,
		<732.45,806.25,343.7>,
		<732.45,-99,343.7>
  }
  triangle { // #1372
		<732.45,806.25,343.7>,
		<700.65,-99,250.15>,
		<700.65,806.25,250.15>
  }
  triangle { // #1373
		<718.95,143.05,359.05>,
		<764.25,143.05,492.2>,
		<716.25,143.05,359.95>
  }
  triangle { // #1374
		<843.85,143.05,483.8>,
		<718.95,143.05,359.05>,
		<843.85,143.05,337.45>
  }
  triangle { // #1375
		<764.25,143.05,492.2>,
		<718.95,143.05,359.05>,
		<843.85,143.05,483.8>
  }
  triangle { // #1376
		<764.25,806.25,492.2>,
		<718.95,806.25,359.05>,
		<716.25,806.25,359.95>
  }
  triangle { // #1377
		<718.95,806.25,359.05>,
		<843.85,806.25,483.8>,
		<843.85,806.25,337.45>
  }
  triangle { // #1378
		<718.95,806.25,359.05>,
		<764.25,806.25,492.2>,
		<843.85,806.25,483.8>
  }
  triangle { // #1379
		<764.25,143.05,492.2>,
		<716.25,806.25,359.95>,
		<716.25,143.05,359.95>
  }
  triangle { // #1380
		<716.25,806.25,359.95>,
		<764.25,143.05,492.2>,
		<764.25,806.25,492.2>
  }
  smooth_triangle { // #1381
		<716.25,143.05,359.95>, <-0.322,0.947,0>,
		<718.95,806.25,359.05>, <-0.272,0.962,0>,
		<718.95,143.05,359.05>, <-0.221,0.975,0>
  }
  smooth_triangle { // #1382
		<718.95,806.25,359.05>, <-0.272,0.962,0>,
		<716.25,143.05,359.95>, <-0.322,0.947,0>,
		<716.25,806.25,359.95>, <-0.322,0.947,0>
  }
  smooth_triangle { // #1383
		<718.95,143.05,359.05>, <-0.221,0.975,0>,
		<843.85,806.25,337.45>, <-0.17,0.985,0>,
		<843.85,143.05,337.45>, <-0.17,0.985,0>
  }
  smooth_triangle { // #1384
		<843.85,806.25,337.45>, <-0.17,0.985,0>,
		<718.95,143.05,359.05>, <-0.221,0.975,0>,
		<718.95,806.25,359.05>, <-0.272,0.962,0>
  }
  triangle { // #1385
		<843.85,143.05,337.45>,
		<843.85,806.25,483.8>,
		<843.85,143.05,483.8>
  }
  triangle { // #1386
		<843.85,806.25,483.8>,
		<843.85,143.05,337.45>,
		<843.85,806.25,337.45>
  }
  triangle { // #1387
		<843.85,143.05,483.8>,
		<764.25,806.25,492.2>,
		<764.25,143.05,492.2>
  }
  triangle { // #1388
		<764.25,806.25,492.2>,
		<843.85,143.05,483.8>,
		<843.85,806.25,483.8>
  }
  triangle { // #1389
		<-760.4,152.15,492.3>,
		<-715.1,152.15,359.05>,
		<-712.4,152.15,359.95>
  }
  triangle { // #1390
		<-715.1,152.15,359.05>,
		<-840.4,152.15,483.9>,
		<-840.35,152.15,335.1>
  }
  triangle { // #1391
		<-715.1,152.15,359.05>,
		<-760.4,152.15,492.3>,
		<-840.4,152.15,483.9>
  }
  triangle { // #1392
		<-715.1,806.25,359.05>,
		<-760.4,806.25,492.3>,
		<-712.4,806.25,359.95>
  }
  triangle { // #1393
		<-840.4,806.25,483.9>,
		<-715.1,806.25,359.05>,
		<-840.35,806.25,335.1>
  }
  triangle { // #1394
		<-760.4,806.25,492.3>,
		<-715.1,806.25,359.05>,
		<-840.4,806.25,483.9>
  }
  smooth_triangle { // #1395
		<-840.35,152.15,335.1>, <0.188,0.982,0>,
		<-715.1,806.25,359.05>, <0.233,0.972,0>,
		<-715.1,152.15,359.05>, <0.278,0.961,0>
  }
  smooth_triangle { // #1396
		<-715.1,806.25,359.05>, <0.233,0.972,0>,
		<-840.35,152.15,335.1>, <0.188,0.982,0>,
		<-840.35,806.25,335.1>, <0.188,0.982,0>
  }
  smooth_triangle { // #1397
		<-715.1,152.15,359.05>, <0.278,0.961,0>,
		<-712.4,806.25,359.95>, <0.322,0.947,0>,
		<-712.4,152.15,359.95>, <0.322,0.947,0>
  }
  smooth_triangle { // #1398
		<-712.4,806.25,359.95>, <0.322,0.947,0>,
		<-715.1,152.15,359.05>, <0.278,0.961,0>,
		<-715.1,806.25,359.05>, <0.233,0.972,0>
  }
  triangle { // #1399
		<-712.4,152.15,359.95>,
		<-760.4,806.25,492.3>,
		<-760.4,152.15,492.3>
  }
  smooth_triangle { // #1400
		<-760.4,806.25,492.3>, <0.94,-0.341,0>,
		<-712.4,152.15,359.95>, <0.94,-0.341,0>,
		<-712.4,806.25,359.95>, <0.945,-0.328,0>
  }
  triangle { // #1401
		<-760.4,152.15,492.3>,
		<-840.4,806.25,483.9>,
		<-840.4,152.15,483.9>
  }
  triangle { // #1402
		<-840.4,806.25,483.9>,
		<-760.4,152.15,492.3>,
		<-760.4,806.25,492.3>
  }
  triangle { // #1403
		<-840.4,152.15,483.9>,
		<-840.35,806.25,335.1>,
		<-840.35,152.15,335.1>
  }
  triangle { // #1404
		<-840.35,806.25,335.1>,
		<-840.4,152.15,483.9>,
		<-840.4,806.25,483.9>
  }
  triangle { // #1405
		<-727.7,-99,340.9>,
		<-840.35,-99,335.1>,
		<-840.35,-99,321.9>
  }
  triangle { // #1406
		<-678.6,-99,260.55>,
		<-727.7,-99,340.9>,
		<-696.8,-99,250.15>
  }
  triangle { // #1407
		<-712.4,-99,359.95>,
		<-727.7,-99,340.9>,
		<-678.6,-99,260.55>
  }
  triangle { // #1408
		<-715.1,-99,359.05>,
		<-727.7,-99,340.9>,
		<-712.4,-99,359.95>
  }
  triangle { // #1409
		<-840.35,-99,335.1>,
		<-727.7,-99,340.9>,
		<-715.1,-99,359.05>
  }
  triangle { // #1410
		<-840.35,806.25,335.1>,
		<-727.7,806.25,340.9>,
		<-840.35,806.25,321.9>
  }
  triangle { // #1411
		<-727.7,806.25,340.9>,
		<-678.6,806.25,260.55>,
		<-696.8,806.25,250.15>
  }
  triangle { // #1412
		<-727.7,806.25,340.9>,
		<-712.4,806.25,359.95>,
		<-678.6,806.25,260.55>
  }
  triangle { // #1413
		<-727.7,806.25,340.9>,
		<-715.1,806.25,359.05>,
		<-712.4,806.25,359.95>
  }
  triangle { // #1414
		<-727.7,806.25,340.9>,
		<-840.35,806.25,335.1>,
		<-715.1,806.25,359.05>
  }
  triangle { // #1415
		<-840.35,-99,335.1>,
		<-840.35,806.25,321.9>,
		<-840.35,-99,321.9>
  }
  triangle { // #1416
		<-840.35,806.25,321.9>,
		<-840.35,-99,335.1>,
		<-840.35,806.25,335.1>
  }
  triangle { // #1417
		<-840.35,-99,321.9>,
		<-727.7,806.25,340.9>,
		<-727.7,-99,340.9>
  }
  triangle { // #1418
		<-727.7,806.25,340.9>,
		<-840.35,-99,321.9>,
		<-840.35,806.25,321.9>
  }
  triangle { // #1419
		<-727.7,-99,340.9>,
		<-696.8,806.25,250.15>,
		<-696.8,-99,250.15>
  }
  triangle { // #1420
		<-696.8,806.25,250.15>,
		<-727.7,-99,340.9>,
		<-727.7,806.25,340.9>
  }
  triangle { // #1421
		<-696.8,-99,250.15>,
		<-678.6,806.25,260.55>,
		<-678.6,-99,260.55>
  }
  triangle { // #1422
		<-678.6,806.25,260.55>,
		<-696.8,-99,250.15>,
		<-696.8,806.25,250.15>
  }
  triangle { // #1423
		<-678.6,-99,260.55>,
		<-712.4,806.25,359.95>,
		<-712.4,-99,359.95>
  }
  triangle { // #1424
		<-712.4,806.25,359.95>,
		<-678.6,-99,260.55>,
		<-678.6,806.25,260.55>
  }
  smooth_triangle { // #1425
		<-712.4,-99,359.95>, <-0.322,-0.947,0>,
		<-715.1,806.25,359.05>, <-0.278,-0.961,0>,
		<-715.1,-99,359.05>, <-0.233,-0.972,0>
  }
  smooth_triangle { // #1426
		<-715.1,806.25,359.05>, <-0.278,-0.961,0>,
		<-712.4,-99,359.95>, <-0.322,-0.947,0>,
		<-712.4,806.25,359.95>, <-0.322,-0.947,0>
  }
  smooth_triangle { // #1427
		<-715.1,-99,359.05>, <-0.233,-0.972,0>,
		<-840.35,806.25,335.1>, <-0.177,-0.984,0>,
		<-840.35,-99,335.1>, <-0.166,-0.986,0>
  }
  smooth_triangle { // #1428
		<-840.35,806.25,335.1>, <-0.177,-0.984,0>,
		<-715.1,-99,359.05>, <-0.233,-0.972,0>,
		<-715.1,806.25,359.05>, <-0.278,-0.961,0>
  }
  triangle { // #1429
		<719.1,-99,359.45>,
		<716.25,-99,359.95>,
		<718.95,-99,359.05>
  }
  triangle { // #1430
		<630,-99,381.9>,
		<719.1,-99,359.45>,
		<637.95,-99,406.3>
  }
  triangle { // #1431
		<716.25,-99,359.95>,
		<630,-99,381.9>,
		<708.35,-99,336.65>
  }
  triangle { // #1432
		<716.25,-99,359.95>,
		<719.1,-99,359.45>,
		<630,-99,381.9>
  }
  triangle { // #1433
		<716.25,-79.2,359.95>,
		<719.1,-79.2,359.45>,
		<718.95,-79.2,359.05>
  }
  triangle { // #1434
		<719.1,-79.2,359.45>,
		<630,-79.2,381.9>,
		<637.95,-79.2,406.3>
  }
  triangle { // #1435
		<630,-79.2,381.9>,
		<716.25,-79.2,359.95>,
		<708.35,-79.2,336.65>
  }
  triangle { // #1436
		<719.1,-79.2,359.45>,
		<716.25,-79.2,359.95>,
		<630,-79.2,381.9>
  }
  triangle { // #1437
		<708.35,-99,336.65>,
		<716.25,-79.2,359.95>,
		<716.25,-99,359.95>
  }
  triangle { // #1438
		<716.25,-79.2,359.95>,
		<708.35,-99,336.65>,
		<708.35,-79.2,336.65>
  }
  triangle { // #1439
		<716.25,-99,359.95>,
		<718.95,-79.2,359.05>,
		<718.95,-99,359.05>
  }
  triangle { // #1440
		<718.95,-79.2,359.05>,
		<716.25,-99,359.95>,
		<716.25,-79.2,359.95>
  }
  triangle { // #1441
		<718.95,-99,359.05>,
		<719.1,-79.2,359.45>,
		<719.1,-99,359.45>
  }
  triangle { // #1442
		<719.1,-79.2,359.45>,
		<718.95,-99,359.05>,
		<718.95,-79.2,359.05>
  }
  triangle { // #1443
		<719.1,-99,359.45>,
		<637.95,-79.2,406.3>,
		<637.95,-99,406.3>
  }
  triangle { // #1444
		<637.95,-79.2,406.3>,
		<719.1,-99,359.45>,
		<719.1,-79.2,359.45>
  }
  triangle { // #1445
		<637.95,-99,406.3>,
		<630,-79.2,381.9>,
		<630,-99,381.9>
  }
  triangle { // #1446
		<630,-79.2,381.9>,
		<637.95,-99,406.3>,
		<637.95,-79.2,406.3>
  }
  triangle { // #1447
		<630,-99,381.9>,
		<708.35,-79.2,336.65>,
		<708.35,-99,336.65>
  }
  triangle { // #1448
		<708.35,-79.2,336.65>,
		<630,-99,381.9>,
		<630,-79.2,381.9>
  }
  triangle { // #1449
		<700.1,-99,312.4>,
		<708.35,-99,336.65>,
		<622.1,-99,357.45>
  }
  triangle { // #1450
		<630,-99,381.9>,
		<622.1,-99,357.45>,
		<708.35,-99,336.65>
  }
  triangle { // #1451
		<630,-59.4,381.9>,
		<708.35,-59.4,336.65>,
		<622.1,-59.4,357.45>
  }
  triangle { // #1452
		<700.1,-59.4,312.4>,
		<622.1,-59.4,357.45>,
		<708.35,-59.4,336.65>
  }
  triangle { // #1453
		<630,-99,381.9>,
		<630,-59.4,381.9>,
		<622.1,-99,357.45>
  }
  triangle { // #1454
		<622.1,-59.4,357.45>,
		<622.1,-99,357.45>,
		<630,-59.4,381.9>
  }
  triangle { // #1455
		<708.35,-99,336.65>,
		<708.35,-59.4,336.65>,
		<630,-99,381.9>
  }
  triangle { // #1456
		<630,-59.4,381.9>,
		<630,-99,381.9>,
		<708.35,-59.4,336.65>
  }
  triangle { // #1457
		<700.1,-99,312.4>,
		<700.1,-59.4,312.4>,
		<708.35,-99,336.65>
  }
  triangle { // #1458
		<708.35,-59.4,336.65>,
		<708.35,-99,336.65>,
		<700.1,-59.4,312.4>
  }
  triangle { // #1459
		<622.1,-99,357.45>,
		<622.1,-59.4,357.45>,
		<700.1,-99,312.4>
  }
  triangle { // #1460
		<700.1,-59.4,312.4>,
		<700.1,-99,312.4>,
		<622.1,-59.4,357.45>
  }
  triangle { // #1461
		<691.95,-99,288.45>,
		<700.1,-99,312.4>,
		<614.25,-99,333.25>
  }
  triangle { // #1462
		<622.1,-99,357.45>,
		<614.25,-99,333.25>,
		<700.1,-99,312.4>
  }
  triangle { // #1463
		<622.1,-39.6,357.45>,
		<700.1,-39.6,312.4>,
		<614.25,-39.6,333.25>
  }
  triangle { // #1464
		<691.95,-39.6,288.45>,
		<614.25,-39.6,333.25>,
		<700.1,-39.6,312.4>
  }
  triangle { // #1465
		<614.25,-99,333.25>,
		<614.25,-39.6,333.25>,
		<691.95,-99,288.45>
  }
  triangle { // #1466
		<691.95,-39.6,288.45>,
		<691.95,-99,288.45>,
		<614.25,-39.6,333.25>
  }
  triangle { // #1467
		<622.1,-99,357.45>,
		<622.1,-39.6,357.45>,
		<614.25,-99,333.25>
  }
  triangle { // #1468
		<614.25,-39.6,333.25>,
		<614.25,-99,333.25>,
		<622.1,-39.6,357.45>
  }
  triangle { // #1469
		<700.1,-99,312.4>,
		<700.1,-39.6,312.4>,
		<622.1,-99,357.45>
  }
  triangle { // #1470
		<622.1,-39.6,357.45>,
		<622.1,-99,357.45>,
		<700.1,-39.6,312.4>
  }
  triangle { // #1471
		<691.95,-99,288.45>,
		<691.95,-39.6,288.45>,
		<700.1,-99,312.4>
  }
  triangle { // #1472
		<700.1,-39.6,312.4>,
		<700.1,-99,312.4>,
		<691.95,-39.6,288.45>
  }
  triangle { // #1473
		<684.1,-99,265.35>,
		<691.95,-99,288.45>,
		<606.7,-99,310.05>
  }
  triangle { // #1474
		<614.25,-99,333.25>,
		<606.7,-99,310.05>,
		<691.95,-99,288.45>
  }
  triangle { // #1475
		<614.25,-19.8,333.25>,
		<691.95,-19.8,288.45>,
		<606.7,-19.8,310.05>
  }
  triangle { // #1476
		<684.1,-19.8,265.35>,
		<606.7,-19.8,310.05>,
		<691.95,-19.8,288.45>
  }
  triangle { // #1477
		<606.7,-99,310.05>,
		<606.7,-19.8,310.05>,
		<684.1,-99,265.35>
  }
  triangle { // #1478
		<684.1,-19.8,265.35>,
		<684.1,-99,265.35>,
		<606.7,-19.8,310.05>
  }
  triangle { // #1479
		<614.25,-99,333.25>,
		<614.25,-19.8,333.25>,
		<606.7,-99,310.05>
  }
  triangle { // #1480
		<606.7,-19.8,310.05>,
		<606.7,-99,310.05>,
		<614.25,-19.8,333.25>
  }
  triangle { // #1481
		<691.95,-99,288.45>,
		<691.95,-19.8,288.45>,
		<614.25,-99,333.25>
  }
  triangle { // #1482
		<614.25,-19.8,333.25>,
		<614.25,-99,333.25>,
		<691.95,-19.8,288.45>
  }
  triangle { // #1483
		<684.1,-99,265.35>,
		<684.1,-19.8,265.35>,
		<691.95,-99,288.45>
  }
  triangle { // #1484
		<691.95,-19.8,288.45>,
		<691.95,-99,288.45>,
		<684.1,-19.8,265.35>
  }
  triangle { // #1485
		<-697.5,-99,316.1>,
		<-619.65,-99,361.05>,
		<-705.1,-99,338.4>
  }
  triangle { // #1486
		<-626.75,-99,385.3>,
		<-705.1,-99,338.4>,
		<-619.65,-99,361.05>
  }
  triangle { // #1487
		<-626.75,-59.4,385.3>,
		<-619.65,-59.4,361.05>,
		<-705.1,-59.4,338.4>
  }
  triangle { // #1488
		<-697.5,-59.4,316.1>,
		<-705.1,-59.4,338.4>,
		<-619.65,-59.4,361.05>
  }
  triangle { // #1489
		<-705.1,-99,338.4>,
		<-705.1,-59.4,338.4>,
		<-697.5,-99,316.1>
  }
  triangle { // #1490
		<-697.5,-59.4,316.1>,
		<-697.5,-99,316.1>,
		<-705.1,-59.4,338.4>
  }
  triangle { // #1491
		<-626.75,-99,385.3>,
		<-626.75,-59.4,385.3>,
		<-705.1,-99,338.4>
  }
  triangle { // #1492
		<-705.1,-59.4,338.4>,
		<-705.1,-99,338.4>,
		<-626.75,-59.4,385.3>
  }
  triangle { // #1493
		<-619.65,-99,361.05>,
		<-619.65,-59.4,361.05>,
		<-626.75,-99,385.3>
  }
  triangle { // #1494
		<-626.75,-59.4,385.3>,
		<-626.75,-99,385.3>,
		<-619.65,-59.4,361.05>
  }
  triangle { // #1495
		<-697.5,-99,316.1>,
		<-697.5,-59.4,316.1>,
		<-619.65,-99,361.05>
  }
  triangle { // #1496
		<-619.65,-59.4,361.05>,
		<-619.65,-99,361.05>,
		<-697.5,-59.4,316.1>
  }
  triangle { // #1497
		<-697.5,-99,316.1>,
		<-612.6,-99,336.45>,
		<-619.65,-99,361.05>
  }
  triangle { // #1498
		<-612.6,-99,336.45>,
		<-697.5,-99,316.1>,
		<-689.35,-99,292.15>
  }
  triangle { // #1499
		<-697.5,-39.6,316.1>,
		<-612.6,-39.6,336.45>,
		<-689.35,-39.6,292.15>
  }
  triangle { // #1500
		<-612.6,-39.6,336.45>,
		<-697.5,-39.6,316.1>,
		<-619.65,-39.6,361.05>
  }
  triangle { // #1501
		<-619.65,-99,361.05>,
		<-697.5,-39.6,316.1>,
		<-697.5,-99,316.1>
  }
  triangle { // #1502
		<-697.5,-39.6,316.1>,
		<-619.65,-99,361.05>,
		<-619.65,-39.6,361.05>
  }
  triangle { // #1503
		<-697.5,-99,316.1>,
		<-689.35,-39.6,292.15>,
		<-689.35,-99,292.15>
  }
  triangle { // #1504
		<-689.35,-39.6,292.15>,
		<-697.5,-99,316.1>,
		<-697.5,-39.6,316.1>
  }
  triangle { // #1505
		<-689.35,-99,292.15>,
		<-612.6,-39.6,336.45>,
		<-612.6,-99,336.45>
  }
  triangle { // #1506
		<-612.6,-39.6,336.45>,
		<-689.35,-99,292.15>,
		<-689.35,-39.6,292.15>
  }
  triangle { // #1507
		<-612.6,-99,336.45>,
		<-619.65,-39.6,361.05>,
		<-619.65,-99,361.05>
  }
  triangle { // #1508
		<-619.65,-39.6,361.05>,
		<-612.6,-99,336.45>,
		<-612.6,-39.6,336.45>
  }
  triangle { // #1509
		<-689.35,-99,292.15>,
		<-605.85,-99,312.75>,
		<-612.6,-99,336.45>
  }
  triangle { // #1510
		<-605.85,-99,312.75>,
		<-689.35,-99,292.15>,
		<-681.5,-99,269.05>
  }
  triangle { // #1511
		<-689.35,-19.8,292.15>,
		<-605.85,-19.8,312.75>,
		<-681.5,-19.8,269.05>
  }
  triangle { // #1512
		<-605.85,-19.8,312.75>,
		<-689.35,-19.8,292.15>,
		<-612.6,-19.8,336.45>
  }
  triangle { // #1513
		<-612.6,-99,336.45>,
		<-689.35,-19.8,292.15>,
		<-689.35,-99,292.15>
  }
  triangle { // #1514
		<-689.35,-19.8,292.15>,
		<-612.6,-99,336.45>,
		<-612.6,-19.8,336.45>
  }
  triangle { // #1515
		<-689.35,-99,292.15>,
		<-681.5,-19.8,269.05>,
		<-681.5,-99,269.05>
  }
  triangle { // #1516
		<-681.5,-19.8,269.05>,
		<-689.35,-99,292.15>,
		<-689.35,-19.8,292.15>
  }
  triangle { // #1517
		<-681.5,-99,269.05>,
		<-605.85,-19.8,312.75>,
		<-605.85,-99,312.75>
  }
  triangle { // #1518
		<-605.85,-19.8,312.75>,
		<-681.5,-99,269.05>,
		<-681.5,-19.8,269.05>
  }
  triangle { // #1519
		<-605.85,-99,312.75>,
		<-612.6,-19.8,336.45>,
		<-612.6,-99,336.45>
  }
  triangle { // #1520
		<-612.6,-19.8,336.45>,
		<-605.85,-99,312.75>,
		<-605.85,-19.8,312.75>
  }
  triangle { // #1521
		<843.55,-99,337.45>,
		<883.75,-99,337.45>,
		<843.55,-99,483.9>
  }
  triangle { // #1522
		<731.95,-99,357.15>,
		<843.55,-99,337.45>,
		<771.85,-99,491.4>
  }
  triangle { // #1523
		<771.85,-99,491.4>,
		<843.55,-99,337.45>,
		<843.55,-99,483.9>
  }
  triangle { // #1524
		<884.05,-99,483.9>,
		<843.55,-99,483.9>,
		<883.75,-99,337.45>
  }
  triangle { // #1525
		<843.55,-79.2,337.45>,
		<843.55,-79.2,483.9>,
		<883.75,-79.2,337.45>
  }
  triangle { // #1526
		<731.95,-79.2,357.15>,
		<771.85,-79.2,491.4>,
		<843.55,-79.2,337.45>
  }
  triangle { // #1527
		<771.85,-79.2,491.4>,
		<843.55,-79.2,483.9>,
		<843.55,-79.2,337.45>
  }
  triangle { // #1528
		<884.05,-79.2,483.9>,
		<883.75,-79.2,337.45>,
		<843.55,-79.2,483.9>
  }
  triangle { // #1529
		<731.95,-99,357.15>,
		<731.95,-79.2,357.15>,
		<843.55,-99,337.45>
  }
  triangle { // #1530
		<843.55,-79.2,337.45>,
		<843.55,-99,337.45>,
		<731.95,-79.2,357.15>
  }
  triangle { // #1531
		<771.85,-99,491.4>,
		<771.85,-79.2,491.4>,
		<731.95,-99,357.15>
  }
  triangle { // #1532
		<731.95,-79.2,357.15>,
		<731.95,-99,357.15>,
		<771.85,-79.2,491.4>
  }
  smooth_triangle { // #1533
		<843.55,-99,483.9>, <0.035,-0.999,0>,
		<843.55,-79.2,483.9>, <0.07,-0.998,0>,
		<771.85,-99,491.4>, <0.105,-0.995,0>
  }
  smooth_triangle { // #1534
		<771.85,-79.2,491.4>, <0.105,-0.995,0>,
		<771.85,-99,491.4>, <0.105,-0.995,0>,
		<843.55,-79.2,483.9>, <0.07,-0.998,0>
  }
  smooth_triangle { // #1535
		<884.05,-99,483.9>, <0,-1,0>,
		<884.05,-79.2,483.9>, <0,-1,0>,
		<843.55,-99,483.9>, <0.035,-0.999,0>
  }
  smooth_triangle { // #1536
		<843.55,-79.2,483.9>, <0.07,-0.998,0>,
		<843.55,-99,483.9>, <0.035,-0.999,0>,
		<884.05,-79.2,483.9>, <0,-1,0>
  }
  triangle { // #1537
		<883.75,-99,337.45>,
		<883.75,-79.2,337.45>,
		<884.05,-99,483.9>
  }
  triangle { // #1538
		<884.05,-79.2,483.9>,
		<884.05,-99,483.9>,
		<883.75,-79.2,337.45>
  }
  smooth_triangle { // #1539
		<843.55,-99,337.45>, <-0.116,0.993,0>,
		<843.55,-79.2,337.45>, <-0.058,0.998,0>,
		<883.75,-99,337.45>, <0,1,0>
  }
  smooth_triangle { // #1540
		<883.75,-79.2,337.45>, <0,1,0>,
		<883.75,-99,337.45>, <0,1,0>,
		<843.55,-79.2,337.45>, <-0.058,0.998,0>
  }
  triangle { // #1541
		<1039.55,-99,262.45>,
		<1035.3,-99,235.5>,
		<1041.85,-99,252.8>
  }
  triangle { // #1542
		<1035.3,-99,235.5>,
		<995.1,-99,161.55>,
		<1035.3,-99,161.55>
  }
  triangle { // #1543
		<1035.3,-99,235.5>,
		<940.7,-99,211.7>,
		<995.1,-99,161.55>
  }
  triangle { // #1544
		<1035.3,-99,235.5>,
		<940.7,-99,232.45>,
		<940.7,-99,211.7>
  }
  triangle { // #1545
		<1035.3,-99,235.5>,
		<947.75,-99,262.45>,
		<940.7,-99,232.45>
  }
  triangle { // #1546
		<1035.3,-99,235.5>,
		<1039.55,-99,262.45>,
		<947.75,-99,262.45>
  }
  triangle { // #1547
		<1035.3,-82.5,235.5>,
		<1039.55,-82.5,262.45>,
		<1041.85,-82.5,252.8>
  }
  triangle { // #1548
		<995.1,-82.5,161.55>,
		<1035.3,-82.5,235.5>,
		<1035.3,-82.5,161.55>
  }
  triangle { // #1549
		<940.7,-82.5,211.7>,
		<1035.3,-82.5,235.5>,
		<995.1,-82.5,161.55>
  }
  triangle { // #1550
		<940.7,-82.5,232.45>,
		<1035.3,-82.5,235.5>,
		<940.7,-82.5,211.7>
  }
  triangle { // #1551
		<947.75,-82.5,262.45>,
		<1035.3,-82.5,235.5>,
		<940.7,-82.5,232.45>
  }
  triangle { // #1552
		<1039.55,-82.5,262.45>,
		<1035.3,-82.5,235.5>,
		<947.75,-82.5,262.45>
  }
  smooth_triangle { // #1553
		<995.1,-99,161.55>, <-0.241,0.971,0>,
		<1035.3,-82.5,161.55>, <0,1,0>,
		<1035.3,-99,161.55>, <0,1,0>
  }
  smooth_triangle { // #1554
		<1035.3,-82.5,161.55>, <0,1,0>,
		<995.1,-99,161.55>, <-0.241,0.971,0>,
		<995.1,-82.5,161.55>, <-0.481,0.877,0>
  }
  triangle { // #1555
		<1035.3,-99,161.55>,
		<1035.3,-82.5,235.5>,
		<1035.3,-99,235.5>
  }
  triangle { // #1556
		<1035.3,-82.5,235.5>,
		<1035.3,-99,161.55>,
		<1035.3,-82.5,161.55>
  }
  smooth_triangle { // #1557
		<1035.3,-99,235.5>, <0.971,0.24,0>,
		<1041.85,-82.5,252.8>, <0.986,0.166,0>,
		<1041.85,-99,252.8>, <0.999,-0.038,0>
  }
  smooth_triangle { // #1558
		<1041.85,-82.5,252.8>, <0.986,0.166,0>,
		<1035.3,-99,235.5>, <0.971,0.24,0>,
		<1035.3,-82.5,235.5>, <0.993,0.12,0>
  }
  smooth_triangle { // #1559
		<1041.85,-99,252.8>, <0.999,-0.038,0>,
		<1039.55,-82.5,262.45>, <0.973,-0.232,0>,
		<1039.55,-99,262.45>, <0.973,-0.232,0>
  }
  smooth_triangle { // #1560
		<1039.55,-82.5,262.45>, <0.973,-0.232,0>,
		<1041.85,-99,252.8>, <0.999,-0.038,0>,
		<1041.85,-82.5,252.8>, <0.986,0.166,0>
  }
  triangle { // #1561
		<1039.55,-99,262.45>,
		<947.75,-82.5,262.45>,
		<947.75,-99,262.45>
  }
  triangle { // #1562
		<947.75,-82.5,262.45>,
		<1039.55,-99,262.45>,
		<1039.55,-82.5,262.45>
  }
  smooth_triangle { // #1563
		<947.75,-99,262.45>, <-0.973,-0.229,0>,
		<940.7,-82.5,232.45>, <-0.988,-0.154,0>,
		<940.7,-99,232.45>, <-0.997,-0.077,0>
  }
  smooth_triangle { // #1564
		<940.7,-82.5,232.45>, <-0.988,-0.154,0>,
		<947.75,-99,262.45>, <-0.973,-0.229,0>,
		<947.75,-82.5,262.45>, <-0.973,-0.229,0>
  }
  smooth_triangle { // #1565
		<940.7,-99,232.45>, <-0.997,-0.077,0>,
		<940.7,-82.5,211.7>, <-1,0,0>,
		<940.7,-99,211.7>, <-1,0,0>
  }
  smooth_triangle { // #1566
		<940.7,-82.5,211.7>, <-1,0,0>,
		<940.7,-99,232.45>, <-0.997,-0.077,0>,
		<940.7,-82.5,232.45>, <-0.988,-0.154,0>
  }
  smooth_triangle { // #1567
		<940.7,-99,211.7>, <-0.678,0.735,0>,
		<995.1,-82.5,161.55>, <-0.481,0.877,0>,
		<995.1,-99,161.55>, <-0.241,0.971,0>
  }
  smooth_triangle { // #1568
		<995.1,-82.5,161.55>, <-0.481,0.877,0>,
		<940.7,-99,211.7>, <-0.678,0.735,0>,
		<940.7,-82.5,211.7>, <-0.678,0.735,0>
  }
  triangle { // #1569
		<1035.3,-99,161.55>,
		<1104.8,-99,232.45>,
		<1035.3,-99,232.45>
  }
  triangle { // #1570
		<1104.8,-99,232.45>,
		<1035.3,-99,161.55>,
		<1104.8,-99,161.55>
  }
  triangle { // #1571
		<1035.3,-66,232.45>,
		<1104.8,-66,161.55>,
		<1035.3,-66,161.55>
  }
  triangle { // #1572
		<1104.8,-66,161.55>,
		<1035.3,-66,232.45>,
		<1104.8,-66,232.45>
  }
  triangle { // #1573
		<1035.3,-99,232.45>,
		<1035.3,-66,161.55>,
		<1035.3,-99,161.55>
  }
  triangle { // #1574
		<1035.3,-66,161.55>,
		<1035.3,-99,232.45>,
		<1035.3,-66,232.45>
  }
  triangle { // #1575
		<1035.3,-99,161.55>,
		<1104.8,-66,161.55>,
		<1104.8,-99,161.55>
  }
  triangle { // #1576
		<1104.8,-66,161.55>,
		<1035.3,-99,161.55>,
		<1035.3,-66,161.55>
  }
  triangle { // #1577
		<1104.8,-99,161.55>,
		<1104.8,-66,232.45>,
		<1104.8,-99,232.45>
  }
  triangle { // #1578
		<1104.8,-66,232.45>,
		<1104.8,-99,161.55>,
		<1104.8,-66,161.55>
  }
  triangle { // #1579
		<1104.8,-99,232.45>,
		<1035.3,-66,232.45>,
		<1035.3,-99,232.45>
  }
  triangle { // #1580
		<1035.3,-66,232.45>,
		<1104.8,-99,232.45>,
		<1104.8,-66,232.45>
  }
  triangle { // #1581
		<1035.3,-99,132.2>,
		<1104.8,-99,161.55>,
		<1035.3,-99,161.55>
  }
  triangle { // #1582
		<1104.8,-99,161.55>,
		<1035.3,-99,132.2>,
		<1104.8,-99,132.2>
  }
  triangle { // #1583
		<1035.3,-49.5,132.2>,
		<1104.8,-49.5,161.55>,
		<1104.8,-49.5,132.2>
  }
  triangle { // #1584
		<1104.8,-49.5,161.55>,
		<1035.3,-49.5,132.2>,
		<1035.3,-49.5,161.55>
  }
  triangle { // #1585
		<1035.3,-99,161.55>,
		<1035.3,-49.5,132.2>,
		<1035.3,-99,132.2>
  }
  triangle { // #1586
		<1035.3,-49.5,132.2>,
		<1035.3,-99,161.55>,
		<1035.3,-49.5,161.55>
  }
  triangle { // #1587
		<1035.3,-99,132.2>,
		<1104.8,-49.5,132.2>,
		<1104.8,-99,132.2>
  }
  triangle { // #1588
		<1104.8,-49.5,132.2>,
		<1035.3,-99,132.2>,
		<1035.3,-49.5,132.2>
  }
  triangle { // #1589
		<1104.8,-99,132.2>,
		<1104.8,-49.5,161.55>,
		<1104.8,-99,161.55>
  }
  triangle { // #1590
		<1104.8,-49.5,161.55>,
		<1104.8,-99,132.2>,
		<1104.8,-49.5,132.2>
  }
  triangle { // #1591
		<1104.8,-99,161.55>,
		<1035.3,-49.5,161.55>,
		<1035.3,-99,161.55>
  }
  triangle { // #1592
		<1035.3,-49.5,161.55>,
		<1104.8,-99,161.55>,
		<1104.8,-49.5,161.55>
  }
  triangle { // #1593
		<1035.3,-99,102.8>,
		<1104.8,-99,132.2>,
		<1035.3,-99,132.2>
  }
  triangle { // #1594
		<1104.8,-99,132.2>,
		<1035.3,-99,102.8>,
		<1104.8,-99,102.8>
  }
  triangle { // #1595
		<1035.3,-33,132.2>,
		<1104.8,-33,102.8>,
		<1035.3,-33,102.8>
  }
  triangle { // #1596
		<1104.8,-33,102.8>,
		<1035.3,-33,132.2>,
		<1104.8,-33,132.2>
  }
  triangle { // #1597
		<1035.3,-99,132.2>,
		<1035.3,-33,102.8>,
		<1035.3,-99,102.8>
  }
  triangle { // #1598
		<1035.3,-33,102.8>,
		<1035.3,-99,132.2>,
		<1035.3,-33,132.2>
  }
  triangle { // #1599
		<1035.3,-99,102.8>,
		<1104.8,-33,102.8>,
		<1104.8,-99,102.8>
  }
  triangle { // #1600
		<1104.8,-33,102.8>,
		<1035.3,-99,102.8>,
		<1035.3,-33,102.8>
  }
  triangle { // #1601
		<1104.8,-99,102.8>,
		<1104.8,-33,132.2>,
		<1104.8,-99,132.2>
  }
  triangle { // #1602
		<1104.8,-33,132.2>,
		<1104.8,-99,102.8>,
		<1104.8,-33,102.8>
  }
  triangle { // #1603
		<1104.8,-99,132.2>,
		<1035.3,-33,132.2>,
		<1035.3,-99,132.2>
  }
  triangle { // #1604
		<1035.3,-33,132.2>,
		<1104.8,-99,132.2>,
		<1104.8,-33,132.2>
  }
  triangle { // #1605
		<1035.3,-99,28.3>,
		<1104.8,-99,102.8>,
		<1035.3,-99,102.8>
  }
  triangle { // #1606
		<1104.8,-99,102.8>,
		<1035.3,-99,28.3>,
		<1104.8,-99,28.3>
  }
  triangle { // #1607
		<1035.3,-19,102.8>,
		<1104.8,-19,28.3>,
		<1035.3,-19,28.3>
  }
  triangle { // #1608
		<1104.8,-19,28.3>,
		<1035.3,-19,102.8>,
		<1104.8,-19,102.8>
  }
  triangle { // #1609
		<1035.3,-99,102.8>,
		<1035.3,-19,28.3>,
		<1035.3,-99,28.3>
  }
  triangle { // #1610
		<1035.3,-19,28.3>,
		<1035.3,-99,102.8>,
		<1035.3,-19,102.8>
  }
  triangle { // #1611
		<1035.3,-99,28.3>,
		<1104.8,-19,28.3>,
		<1104.8,-99,28.3>
  }
  triangle { // #1612
		<1104.8,-19,28.3>,
		<1035.3,-99,28.3>,
		<1035.3,-19,28.3>
  }
  triangle { // #1613
		<1104.8,-99,28.3>,
		<1104.8,-19,102.8>,
		<1104.8,-99,102.8>
  }
  triangle { // #1614
		<1104.8,-19,102.8>,
		<1104.8,-99,28.3>,
		<1104.8,-19,28.3>
  }
  triangle { // #1615
		<1104.8,-99,102.8>,
		<1035.3,-19,102.8>,
		<1035.3,-99,102.8>
  }
  triangle { // #1616
		<1035.3,-19,102.8>,
		<1104.8,-99,102.8>,
		<1104.8,-19,102.8>
  }
  triangle { // #1617
		<684.1,0,265.35>,
		<682.45,0,260.55>,
		<606.7,0,310.05>
  }
  triangle { // #1618
		<431.35,0,262.95>,
		<571.45,-0,462.15>,
		<439.55,0,259.4>
  }
  triangle { // #1619
		<439.55,0,29.55>,
		<439.55,0,259.4>,
		<885.95,0,29.55>
  }
  triangle { // #1620
		<1025.9,0,151.85>,
		<1025.9,0,102.8>,
		<991.95,0,151.85>
  }
  triangle { // #1621
		<1035.3,0,102.8>,
		<1035.3,0,28.3>,
		<1025.9,0,102.8>
  }
  triangle { // #1622
		<1035.3,0,28.3>,
		<885.95,0,28.3>,
		<1025.9,0,102.8>
  }
  triangle { // #1623
		<885.95,0,28.3>,
		<885.95,0,29.55>,
		<1025.9,0,102.8>
  }
  triangle { // #1624
		<1025.9,0,102.8>,
		<885.95,0,29.55>,
		<991.95,0,151.85>
  }
  triangle { // #1625
		<931.9,0,232.3>,
		<931.9,0,207.15>,
		<842.6,0,232.3>
  }
  triangle { // #1626
		<991.95,0,151.85>,
		<885.95,0,29.55>,
		<931.9,0,207.15>
  }
  triangle { // #1627
		<885.95,0,29.55>,
		<439.55,0,259.4>,
		<931.9,0,207.15>
  }
  triangle { // #1628
		<931.9,0,207.15>,
		<439.55,0,259.4>,
		<842.6,0,232.3>
  }
  triangle { // #1629
		<571.45,-0,462.15>,
		<644.35,0,426.05>,
		<439.55,0,259.4>
  }
  triangle { // #1630
		<644.35,0,426.05>,
		<606.7,0,310.05>,
		<439.55,0,259.4>
  }
  triangle { // #1631
		<842.6,0,324.7>,
		<842.6,0,232.3>,
		<732.45,0,343.7>
  }
  triangle { // #1632
		<732.45,0,343.7>,
		<842.6,0,232.3>,
		<700.65,0,250.15>
  }
  triangle { // #1633
		<842.6,0,232.3>,
		<439.55,0,259.4>,
		<700.65,0,250.15>
  }
  triangle { // #1634
		<700.65,0,250.15>,
		<439.55,0,259.4>,
		<682.45,0,260.55>
  }
  triangle { // #1635
		<439.55,0,259.4>,
		<606.7,0,310.05>,
		<682.45,0,260.55>
  }
  triangle { // #1636
		<684.1,-99,265.35>,
		<606.7,-99,310.05>,
		<682.45,-99,260.55>
  }
  triangle { // #1637
		<431.35,-99,262.95>,
		<439.55,-99,259.4>,
		<571.45,-99,462.15>
  }
  triangle { // #1638
		<439.55,-99,29.3>,
		<885.95,-99,29.55>,
		<439.55,-99,259.4>
  }
  triangle { // #1639
		<1025.9,-99,151.85>,
		<991.95,-99,151.85>,
		<1025.9,-99,102.8>
  }
  triangle { // #1640
		<1035.3,-99,102.8>,
		<1025.9,-99,102.8>,
		<1035.3,-99,28.3>
  }
  triangle { // #1641
		<1035.3,-99,28.3>,
		<1025.9,-99,102.8>,
		<885.95,-99,28.3>
  }
  triangle { // #1642
		<885.95,-99,28.3>,
		<1025.9,-99,102.8>,
		<885.95,-99,29.55>
  }
  triangle { // #1643
		<1025.9,-99,102.8>,
		<991.95,-99,151.85>,
		<885.95,-99,29.55>
  }
  triangle { // #1644
		<931.9,-99,232.3>,
		<842.6,-99,232.3>,
		<931.9,-99,207.15>
  }
  triangle { // #1645
		<991.95,-99,151.85>,
		<931.9,-99,207.15>,
		<885.95,-99,29.55>
  }
  triangle { // #1646
		<885.95,-99,29.55>,
		<931.9,-99,207.15>,
		<439.55,-99,259.4>
  }
  triangle { // #1647
		<931.9,-99,207.15>,
		<842.6,-99,232.3>,
		<439.55,-99,259.4>
  }
  triangle { // #1648
		<571.45,-99,462.15>,
		<439.55,-99,259.4>,
		<644.35,-99,426.05>
  }
  triangle { // #1649
		<644.35,-99,426.05>,
		<439.55,-99,259.4>,
		<606.7,-99,310.05>
  }
  triangle { // #1650
		<842.6,-99,324.7>,
		<732.45,-99,343.7>,
		<842.6,-99,232.3>
  }
  triangle { // #1651
		<732.45,-99,343.7>,
		<700.65,-99,250.15>,
		<842.6,-99,232.3>
  }
  triangle { // #1652
		<842.6,-99,232.3>,
		<700.65,-99,250.15>,
		<439.55,-99,259.4>
  }
  triangle { // #1653
		<700.65,-99,250.15>,
		<682.45,-99,260.55>,
		<439.55,-99,259.4>
  }
  triangle { // #1654
		<439.55,-99,259.4>,
		<682.45,-99,260.55>,
		<606.7,-99,310.05>
  }
  triangle { // #1655
		<571.45,-0,462.15>,
		<571.45,-99,462.15>,
		<644.35,0,426.05>
  }
  triangle { // #1656
		<644.35,-99,426.05>,
		<644.35,0,426.05>,
		<571.45,-99,462.15>
  }
  triangle { // #1657
		<431.35,0,262.95>,
		<431.35,-99,262.95>,
		<571.45,-0,462.15>
  }
  triangle { // #1658
		<571.45,-99,462.15>,
		<571.45,-0,462.15>,
		<431.35,-99,262.95>
  }
  triangle { // #1659
		<439.55,0,259.4>,
		<439.55,-99,259.4>,
		<431.35,0,262.95>
  }
  triangle { // #1660
		<431.35,-99,262.95>,
		<431.35,0,262.95>,
		<439.55,-99,259.4>
  }
  triangle { // #1661
		<439.55,0,29.55>,
		<439.55,-99,29.3>,
		<439.55,0,259.4>
  }
  triangle { // #1662
		<439.55,-99,259.4>,
		<439.55,0,259.4>,
		<439.55,-99,29.3>
  }
  triangle { // #1663
		<885.95,0,29.55>,
		<885.95,-99,29.55>,
		<439.55,0,29.55>
  }
  triangle { // #1664
		<439.55,-99,29.3>,
		<439.55,0,29.55>,
		<885.95,-99,29.55>
  }
  triangle { // #1665
		<885.95,0,28.3>,
		<885.95,-99,28.3>,
		<885.95,0,29.55>
  }
  triangle { // #1666
		<885.95,-99,29.55>,
		<885.95,0,29.55>,
		<885.95,-99,28.3>
  }
  triangle { // #1667
		<1035.3,0,28.3>,
		<1035.3,-99,28.3>,
		<885.95,0,28.3>
  }
  triangle { // #1668
		<885.95,-99,28.3>,
		<885.95,0,28.3>,
		<1035.3,-99,28.3>
  }
  triangle { // #1669
		<1035.3,0,102.8>,
		<1035.3,-99,102.8>,
		<1035.3,0,28.3>
  }
  triangle { // #1670
		<1035.3,-99,28.3>,
		<1035.3,0,28.3>,
		<1035.3,-99,102.8>
  }
  triangle { // #1671
		<1025.9,0,102.8>,
		<1025.9,-99,102.8>,
		<1035.3,0,102.8>
  }
  triangle { // #1672
		<1035.3,-99,102.8>,
		<1035.3,0,102.8>,
		<1025.9,-99,102.8>
  }
  triangle { // #1673
		<1025.9,0,151.85>,
		<1025.9,-99,151.85>,
		<1025.9,0,102.8>
  }
  triangle { // #1674
		<1025.9,-99,102.8>,
		<1025.9,0,102.8>,
		<1025.9,-99,151.85>
  }
  smooth_triangle { // #1675
		<991.95,0,151.85>, <0.481,-0.877,0>,
		<991.95,-99,151.85>, <0.24,-0.971,0>,
		<1025.9,0,151.85>, <0,-1,0>
  }
  smooth_triangle { // #1676
		<1025.9,-99,151.85>, <0,-1,0>,
		<1025.9,0,151.85>, <0,-1,0>,
		<991.95,-99,151.85>, <0.24,-0.971,0>
  }
  smooth_triangle { // #1677
		<931.9,0,207.15>, <0.678,-0.735,0>,
		<931.9,-99,207.15>, <0.678,-0.735,0>,
		<991.95,0,151.85>, <0.481,-0.877,0>
  }
  smooth_triangle { // #1678
		<991.95,-99,151.85>, <0.24,-0.971,0>,
		<991.95,0,151.85>, <0.481,-0.877,0>,
		<931.9,-99,207.15>, <0.678,-0.735,0>
  }
  triangle { // #1679
		<931.9,0,232.3>,
		<931.9,-99,232.3>,
		<931.9,0,207.15>
  }
  triangle { // #1680
		<931.9,-99,207.15>,
		<931.9,0,207.15>,
		<931.9,-99,232.3>
  }
  triangle { // #1681
		<842.6,0,232.3>,
		<842.6,-99,232.3>,
		<931.9,0,232.3>
  }
  triangle { // #1682
		<931.9,-99,232.3>,
		<931.9,0,232.3>,
		<842.6,-99,232.3>
  }
  triangle { // #1683
		<842.6,0,324.7>,
		<842.6,-99,324.7>,
		<842.6,0,232.3>
  }
  triangle { // #1684
		<842.6,-99,232.3>,
		<842.6,0,232.3>,
		<842.6,-99,324.7>
  }
  smooth_triangle { // #1685
		<732.45,0,343.7>, <0.17,-0.985,0>,
		<732.45,-99,343.7>, <0.488,-0.873,0>,
		<842.6,0,324.7>, <0.17,-0.985,0>
  }
  smooth_triangle { // #1686
		<842.6,-99,324.7>, <0.17,-0.985,0>,
		<842.6,0,324.7>, <0.17,-0.985,0>,
		<732.45,-99,343.7>, <0.488,-0.873,0>
  }
  triangle { // #1687
		<700.65,0,250.15>,
		<700.65,-99,250.15>,
		<732.45,0,343.7>
  }
  triangle { // #1688
		<732.45,-99,343.7>,
		<732.45,0,343.7>,
		<700.65,-99,250.15>
  }
  triangle { // #1689
		<682.45,0,260.55>,
		<682.45,-99,260.55>,
		<700.65,0,250.15>
  }
  triangle { // #1690
		<700.65,-99,250.15>,
		<700.65,0,250.15>,
		<682.45,-99,260.55>
  }
  triangle { // #1691
		<684.1,0,265.35>,
		<684.1,-99,265.35>,
		<682.45,0,260.55>
  }
  triangle { // #1692
		<682.45,-99,260.55>,
		<682.45,0,260.55>,
		<684.1,-99,265.35>
  }
  triangle { // #1693
		<606.7,0,310.05>,
		<606.7,-99,310.05>,
		<684.1,0,265.35>
  }
  triangle { // #1694
		<684.1,-99,265.35>,
		<684.1,0,265.35>,
		<606.7,-99,310.05>
  }
  triangle { // #1695
		<644.35,0,426.05>,
		<644.35,-99,426.05>,
		<606.7,0,310.05>
  }
  triangle { // #1696
		<606.7,-99,310.05>,
		<606.7,0,310.05>,
		<644.35,-99,426.05>
  }
  triangle { // #1697
		<-615.3,233.85,102.65>,
		<-849.1,233.85,192.4>,
		<-615.3,233.85,39.75>
  }
  triangle { // #1698
		<-881.85,233.85,28.2>,
		<-881.85,233.85,39.75>,
		<-1103.8,233.85,28.2>
  }
  triangle { // #1699
		<-1103.8,233.85,28.2>,
		<-881.85,233.85,39.75>,
		<-1103.8,233.85,231.5>
  }
  triangle { // #1700
		<-840.35,233.85,231.5>,
		<-1103.8,233.85,231.5>,
		<-840.35,233.85,205>
  }
  triangle { // #1701
		<-840.35,233.85,205>,
		<-1103.8,233.85,231.5>,
		<-849.1,233.85,192.4>
  }
  triangle { // #1702
		<-1103.8,233.85,231.5>,
		<-881.85,233.85,39.75>,
		<-849.1,233.85,192.4>
  }
  triangle { // #1703
		<-881.85,233.85,39.75>,
		<-615.3,233.85,39.75>,
		<-849.1,233.85,192.4>
  }
  triangle { // #1704
		<-615.3,687.45,102.65>,
		<-615.3,687.45,39.75>,
		<-849.1,687.45,192.4>
  }
  triangle { // #1705
		<-881.85,687.45,28.2>,
		<-1103.8,687.45,28.2>,
		<-881.85,687.45,39.75>
  }
  triangle { // #1706
		<-1103.8,687.45,28.2>,
		<-1103.8,687.45,231.5>,
		<-881.85,687.45,39.75>
  }
  triangle { // #1707
		<-840.35,687.45,231.5>,
		<-840.35,687.45,205>,
		<-1103.8,687.45,231.5>
  }
  triangle { // #1708
		<-840.35,687.45,205>,
		<-849.1,687.45,192.4>,
		<-1103.8,687.45,231.5>
  }
  triangle { // #1709
		<-1103.8,687.45,231.5>,
		<-849.1,687.45,192.4>,
		<-881.85,687.45,39.75>
  }
  triangle { // #1710
		<-881.85,687.45,39.75>,
		<-849.1,687.45,192.4>,
		<-615.3,687.45,39.75>
  }
  triangle { // #1711
		<-840.35,233.85,231.5>,
		<-840.35,687.45,231.5>,
		<-1103.8,233.85,231.5>
  }
  triangle { // #1712
		<-1103.8,687.45,231.5>,
		<-1103.8,233.85,231.5>,
		<-840.35,687.45,231.5>
  }
  smooth_triangle { // #1713
		<-840.35,233.85,205>, <0.918,0.397,0>,
		<-840.35,687.45,205>, <0.98,0.198,0>,
		<-840.35,233.85,231.5>, <1,0,0>
  }
  smooth_triangle { // #1714
		<-840.35,687.45,231.5>, <1,0,0>,
		<-840.35,233.85,231.5>, <1,0,0>,
		<-840.35,687.45,205>, <0.98,0.198,0>
  }
  smooth_triangle { // #1715
		<-849.1,233.85,192.4>, <0.821,0.571,0>,
		<-849.1,687.45,192.4>, <0.821,0.571,0>,
		<-840.35,233.85,205>, <0.918,0.397,0>
  }
  smooth_triangle { // #1716
		<-840.35,687.45,205>, <0.98,0.198,0>,
		<-840.35,233.85,205>, <0.918,0.397,0>,
		<-849.1,687.45,192.4>, <0.821,0.571,0>
  }
  triangle { // #1717
		<-615.3,233.85,102.65>,
		<-615.3,687.45,102.65>,
		<-849.1,233.85,192.4>
  }
  triangle { // #1718
		<-849.1,687.45,192.4>,
		<-849.1,233.85,192.4>,
		<-615.3,687.45,102.65>
  }
  triangle { // #1719
		<-615.3,233.85,39.75>,
		<-615.3,687.45,39.75>,
		<-615.3,233.85,102.65>
  }
  triangle { // #1720
		<-615.3,687.45,102.65>,
		<-615.3,233.85,102.65>,
		<-615.3,687.45,39.75>
  }
  triangle { // #1721
		<-881.85,233.85,39.75>,
		<-881.85,687.45,39.75>,
		<-615.3,233.85,39.75>
  }
  triangle { // #1722
		<-615.3,687.45,39.75>,
		<-615.3,233.85,39.75>,
		<-881.85,687.45,39.75>
  }
  triangle { // #1723
		<-881.85,233.85,28.2>,
		<-881.85,687.45,28.2>,
		<-881.85,233.85,39.75>
  }
  triangle { // #1724
		<-881.85,687.45,39.75>,
		<-881.85,233.85,39.75>,
		<-881.85,687.45,28.2>
  }
  triangle { // #1725
		<-1103.8,233.85,28.2>,
		<-1103.8,687.45,28.2>,
		<-881.85,233.85,28.2>
  }
  triangle { // #1726
		<-881.85,687.45,28.2>,
		<-881.85,233.85,28.2>,
		<-1103.8,687.45,28.2>
  }
  triangle { // #1727
		<-1103.8,233.85,231.5>,
		<-1103.8,687.45,231.5>,
		<-1103.8,233.85,28.2>
  }
  triangle { // #1728
		<-1103.8,687.45,28.2>,
		<-1103.8,233.85,28.2>,
		<-1103.8,687.45,231.5>
  }
  triangle { // #1729
		<512.6,-0,465.5>,
		<515.4,-0,466.65>,
		<510,-0,464.2>
  }
  triangle { // #1730
		<431.35,0,262.95>,
		<432.4,0,265.15>,
		<571.45,-0,462.1>
  }
  triangle { // #1731
		<432.4,0,265.15>,
		<433.95,0,268.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1732
		<433.95,0,268.4>,
		<435.35,0,271.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1733
		<435.35,0,271.4>,
		<436.6,0,274.1>,
		<571.45,-0,462.1>
  }
  triangle { // #1734
		<436.6,0,274.1>,
		<437.75,0,276.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1735
		<437.75,0,276.5>,
		<438.7,0,278.6>,
		<571.45,-0,462.1>
  }
  triangle { // #1736
		<438.7,0,278.6>,
		<439.5,0,280.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1737
		<439.5,0,280.45>,
		<440.15,0,282>,
		<571.45,-0,462.1>
  }
  triangle { // #1738
		<440.15,0,282>,
		<440.75,0,283.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1739
		<440.75,0,283.45>,
		<441.3,0,285>,
		<571.45,-0,462.1>
  }
  triangle { // #1740
		<441.3,0,285>,
		<441.9,0,286.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1741
		<441.9,0,286.55>,
		<442.45,0,288.15>,
		<571.45,-0,462.1>
  }
  triangle { // #1742
		<442.45,0,288.15>,
		<443.05,0,289.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1743
		<443.05,0,289.85>,
		<443.6,0,291.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1744
		<443.6,0,291.55>,
		<444.2,0,293.35>,
		<571.45,-0,462.1>
  }
  triangle { // #1745
		<444.2,0,293.35>,
		<444.75,0,295.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1746
		<444.75,0,295.2>,
		<445.3,0,297.1>,
		<571.45,-0,462.1>
  }
  triangle { // #1747
		<445.3,0,297.1>,
		<445.85,0,298.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1748
		<445.85,0,298.95>,
		<446.45,0,300.8>,
		<571.45,-0,462.1>
  }
  triangle { // #1749
		<446.45,0,300.8>,
		<446.95,0,302.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1750
		<446.95,0,302.7>,
		<447.5,0,304.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1751
		<447.5,0,304.5>,
		<448.05,0,306.35>,
		<571.45,-0,462.1>
  }
  triangle { // #1752
		<448.05,0,306.35>,
		<448.6,0,308.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1753
		<448.6,0,308.2>,
		<449.1,0,310>,
		<571.45,-0,462.1>
  }
  triangle { // #1754
		<449.1,0,310>,
		<449.6,0,311.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1755
		<449.6,0,311.85>,
		<450.1,0,313.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1756
		<450.1,0,313.65>,
		<450.6,0,315.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1757
		<450.6,0,315.5>,
		<451.05,0,317.35>,
		<571.45,-0,462.1>
  }
  triangle { // #1758
		<451.05,0,317.35>,
		<451.45,0,319.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1759
		<451.45,0,319.2>,
		<451.85,0,321.05>,
		<571.45,-0,462.1>
  }
  triangle { // #1760
		<451.85,0,321.05>,
		<452.25,0,322.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1761
		<452.25,0,322.95>,
		<452.6,0,324.8>,
		<571.45,-0,462.1>
  }
  triangle { // #1762
		<452.6,0,324.8>,
		<452.95,0,326.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1763
		<452.95,0,326.7>,
		<453.25,0,328.6>,
		<571.45,-0,462.1>
  }
  triangle { // #1764
		<453.25,0,328.6>,
		<453.6,0,330.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1765
		<453.6,0,330.5>,
		<453.9,0,332.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1766
		<453.9,0,332.4>,
		<454.2,0,334.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1767
		<454.2,0,334.3>,
		<454.45,0,336.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1768
		<454.45,0,336.2>,
		<454.75,0,338.1>,
		<571.45,-0,462.1>
  }
  triangle { // #1769
		<454.75,0,338.1>,
		<455,0,340.05>,
		<571.45,-0,462.1>
  }
  triangle { // #1770
		<455,0,340.05>,
		<455.25,0,341.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1771
		<455.25,0,341.95>,
		<455.45,0,343.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1772
		<455.45,0,343.85>,
		<455.65,0,345.8>,
		<571.45,-0,462.1>
  }
  triangle { // #1773
		<455.65,0,345.8>,
		<455.85,0,347.75>,
		<571.45,-0,462.1>
  }
  triangle { // #1774
		<455.85,0,347.75>,
		<456,0,349.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1775
		<456,0,349.7>,
		<456.15,0,351.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1776
		<456.15,0,351.65>,
		<456.25,0,353.6>,
		<571.45,-0,462.1>
  }
  triangle { // #1777
		<456.25,0,353.6>,
		<456.35,0,355.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1778
		<456.35,0,355.55>,
		<456.45,0,357.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1779
		<456.45,0,357.55>,
		<456.6,0,359.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1780
		<456.6,0,359.5>,
		<456.75,0,361.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1781
		<456.75,0,361.45>,
		<456.9,0,363.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1782
		<456.9,0,363.4>,
		<457.1,0,365.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1783
		<457.1,0,365.3>,
		<457.35,0,367.25>,
		<571.45,-0,462.1>
  }
  triangle { // #1784
		<457.35,0,367.25>,
		<457.6,0,369.15>,
		<571.45,-0,462.1>
  }
  triangle { // #1785
		<457.6,0,369.15>,
		<457.85,0,371.05>,
		<571.45,-0,462.1>
  }
  triangle { // #1786
		<457.85,0,371.05>,
		<458.1,0,373>,
		<571.45,-0,462.1>
  }
  triangle { // #1787
		<458.1,0,373>,
		<458.35,0,374.9>,
		<571.45,-0,462.1>
  }
  triangle { // #1788
		<458.35,0,374.9>,
		<458.55,0,376.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1789
		<458.55,0,376.85>,
		<458.75,0,378.8>,
		<571.45,-0,462.1>
  }
  triangle { // #1790
		<458.75,0,378.8>,
		<458.9,0,380.75>,
		<571.45,-0,462.1>
  }
  triangle { // #1791
		<458.9,0,380.75>,
		<459,0,382.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1792
		<459,0,382.7>,
		<459.1,0,384.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1793
		<459.1,0,384.65>,
		<459.15,0,386.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1794
		<459.15,0,386.65>,
		<459.2,0,388.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1795
		<459.2,0,388.65>,
		<459.3,0,390.6>,
		<571.45,-0,462.1>
  }
  triangle { // #1796
		<459.3,0,390.6>,
		<459.45,0,392.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1797
		<459.45,0,392.55>,
		<459.65,0,394.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1798
		<459.65,0,394.45>,
		<459.9,0,396.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1799
		<459.9,0,396.4>,
		<460.2,0,398.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1800
		<460.2,0,398.3>,
		<460.55,0,400.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1801
		<460.55,0,400.2>,
		<460.95,0,402.05>,
		<571.45,-0,462.1>
  }
  triangle { // #1802
		<460.95,0,402.05>,
		<461.35,0,403.9>,
		<571.45,-0,462.1>
  }
  triangle { // #1803
		<461.35,0,403.9>,
		<461.8,0,405.75>,
		<571.45,-0,462.1>
  }
  triangle { // #1804
		<461.8,0,405.75>,
		<462.3,0,407.6>,
		<571.45,-0,462.1>
  }
  triangle { // #1805
		<462.3,0,407.6>,
		<462.8,0,409.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1806
		<462.8,0,409.45>,
		<463.35,0,411.25>,
		<571.45,-0,462.1>
  }
  triangle { // #1807
		<463.35,0,411.25>,
		<463.95,0,413.05>,
		<571.45,-0,462.1>
  }
  triangle { // #1808
		<463.95,0,413.05>,
		<464.55,0,414.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1809
		<464.55,0,414.85>,
		<465.15,0,416.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1810
		<465.15,0,416.65>,
		<465.8,0,418.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1811
		<465.8,0,418.45>,
		<466.55,0,420.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1812
		<466.55,0,420.2>,
		<467.25,0,421.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1813
		<467.25,0,421.95>,
		<468.05,0,423.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1814
		<468.05,0,423.7>,
		<468.9,0,425.45>,
		<571.45,-0,462.1>
  }
  triangle { // #1815
		<468.9,0,425.45>,
		<469.75,0,427.15>,
		<571.45,-0,462.1>
  }
  triangle { // #1816
		<469.75,0,427.15>,
		<470.7,0,428.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1817
		<470.7,0,428.85>,
		<471.65,0,430.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1818
		<471.65,0,430.55>,
		<472.65,0,432.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1819
		<472.65,0,432.2>,
		<473.7,0,433.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1820
		<473.7,0,433.85>,
		<474.8,0,435.5>,
		<571.45,-0,462.1>
  }
  triangle { // #1821
		<474.8,0,435.5>,
		<476,0,437.1>,
		<571.45,-0,462.1>
  }
  triangle { // #1822
		<476,0,437.1>,
		<477.25,0,438.7>,
		<571.45,-0,462.1>
  }
  triangle { // #1823
		<477.25,0,438.7>,
		<478.55,0,440.25>,
		<571.45,-0,462.1>
  }
  triangle { // #1824
		<478.55,0,440.25>,
		<479.9,0,441.8>,
		<571.45,-0,462.1>
  }
  triangle { // #1825
		<479.9,0,441.8>,
		<481.35,0,443.35>,
		<571.45,-0,462.1>
  }
  triangle { // #1826
		<481.35,0,443.35>,
		<482.8,0,444.9>,
		<571.45,-0,462.1>
  }
  triangle { // #1827
		<482.8,0,444.9>,
		<484.35,0,446.4>,
		<571.45,-0,462.1>
  }
  triangle { // #1828
		<484.35,0,446.4>,
		<485.9,0,447.85>,
		<571.45,-0,462.1>
  }
  triangle { // #1829
		<485.9,0,447.85>,
		<487.55,0,449.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1830
		<487.55,0,449.3>,
		<489.2,0,450.75>,
		<571.45,-0,462.1>
  }
  triangle { // #1831
		<489.2,0,450.75>,
		<490.95,0,452.15>,
		<571.45,-0,462.1>
  }
  triangle { // #1832
		<490.95,0,452.15>,
		<492.75,0,453.55>,
		<571.45,-0,462.1>
  }
  triangle { // #1833
		<492.75,0,453.55>,
		<494.6,0,454.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1834
		<494.6,0,454.95>,
		<496.5,-0,456.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1835
		<496.5,-0,456.3>,
		<498.5,-0,457.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1836
		<498.5,-0,457.65>,
		<500.6,-0,459>,
		<571.45,-0,462.1>
  }
  triangle { // #1837
		<500.6,-0,459>,
		<502.8,-0,460.3>,
		<571.45,-0,462.1>
  }
  triangle { // #1838
		<502.8,-0,460.3>,
		<505.1,-0,461.65>,
		<571.45,-0,462.1>
  }
  triangle { // #1839
		<505.1,-0,461.65>,
		<507.5,-0,462.95>,
		<571.45,-0,462.1>
  }
  triangle { // #1840
		<507.5,-0,462.95>,
		<510,-0,464.2>,
		<571.45,-0,462.1>
  }
  triangle { // #1841
		<571.45,-0,462.1>,
		<510,-0,464.2>,
		<569.55,-0,463.15>
  }
  triangle { // #1842
		<569.55,-0,463.15>,
		<510,-0,464.2>,
		<567.15,-0,464.15>
  }
  triangle { // #1843
		<567.15,-0,464.15>,
		<510,-0,464.2>,
		<564.35,-0,465.05>
  }
  triangle { // #1844
		<564.35,-0,465.05>,
		<510,-0,464.2>,
		<561.15,-0,465.9>
  }
  triangle { // #1845
		<561.15,-0,465.9>,
		<510,-0,464.2>,
		<557.45,-0,466.7>
  }
  triangle { // #1846
		<557.45,-0,466.7>,
		<510,-0,464.2>,
		<553.35,-0,467.4>
  }
  triangle { // #1847
		<553.35,-0,467.4>,
		<510,-0,464.2>,
		<548.85,-0,468>
  }
  triangle { // #1848
		<548.85,-0,468>,
		<510,-0,464.2>,
		<543.9,-0,468.55>
  }
  triangle { // #1849
		<543.9,-0,468.55>,
		<510,-0,464.2>,
		<538.85,-0,468.95>
  }
  triangle { // #1850
		<538.85,-0,468.95>,
		<510,-0,464.2>,
		<534.15,-0,469.15>
  }
  triangle { // #1851
		<534.15,-0,469.15>,
		<510,-0,464.2>,
		<529.75,-0,469.1>
  }
  triangle { // #1852
		<529.75,-0,469.1>,
		<510,-0,464.2>,
		<525.7,-0,468.8>
  }
  triangle { // #1853
		<525.7,-0,468.8>,
		<510,-0,464.2>,
		<521.95,-0,468.3>
  }
  triangle { // #1854
		<521.95,-0,468.3>,
		<510,-0,464.2>,
		<518.5,-0,467.6>
  }
  triangle { // #1855
		<518.5,-0,467.6>,
		<510,-0,464.2>,
		<515.4,-0,466.65>
  }
  triangle { // #1856
		<512.6,-99,465.5>,
		<510,-99,464.2>,
		<515.4,-99,466.65>
  }
  triangle { // #1857
		<431.35,-99,262.95>,
		<571.45,-99,462.1>,
		<432.4,-99,265.15>
  }
  triangle { // #1858
		<432.4,-99,265.15>,
		<571.45,-99,462.1>,
		<433.95,-99,268.4>
  }
  triangle { // #1859
		<433.95,-99,268.4>,
		<571.45,-99,462.1>,
		<435.35,-99,271.4>
  }
  triangle { // #1860
		<435.35,-99,271.4>,
		<571.45,-99,462.1>,
		<436.6,-99,274.1>
  }
  triangle { // #1861
		<436.6,-99,274.1>,
		<571.45,-99,462.1>,
		<437.75,-99,276.5>
  }
  triangle { // #1862
		<437.75,-99,276.5>,
		<571.45,-99,462.1>,
		<438.7,-99,278.6>
  }
  triangle { // #1863
		<438.7,-99,278.6>,
		<571.45,-99,462.1>,
		<439.5,-99,280.45>
  }
  triangle { // #1864
		<439.5,-99,280.45>,
		<571.45,-99,462.1>,
		<440.15,-99,282>
  }
  triangle { // #1865
		<440.15,-99,282>,
		<571.45,-99,462.1>,
		<440.75,-99,283.45>
  }
  triangle { // #1866
		<440.75,-99,283.45>,
		<571.45,-99,462.1>,
		<441.3,-99,285>
  }
  triangle { // #1867
		<441.3,-99,285>,
		<571.45,-99,462.1>,
		<441.9,-99,286.55>
  }
  triangle { // #1868
		<441.9,-99,286.55>,
		<571.45,-99,462.1>,
		<442.45,-99,288.15>
  }
  triangle { // #1869
		<442.45,-99,288.15>,
		<571.45,-99,462.1>,
		<443.05,-99,289.85>
  }
  triangle { // #1870
		<443.05,-99,289.85>,
		<571.45,-99,462.1>,
		<443.6,-99,291.55>
  }
  triangle { // #1871
		<443.6,-99,291.55>,
		<571.45,-99,462.1>,
		<444.2,-99,293.35>
  }
  triangle { // #1872
		<444.2,-99,293.35>,
		<571.45,-99,462.1>,
		<444.75,-99,295.2>
  }
  triangle { // #1873
		<444.75,-99,295.2>,
		<571.45,-99,462.1>,
		<445.3,-99,297.1>
  }
  triangle { // #1874
		<445.3,-99,297.1>,
		<571.45,-99,462.1>,
		<445.85,-99,298.95>
  }
  triangle { // #1875
		<445.85,-99,298.95>,
		<571.45,-99,462.1>,
		<446.45,-99,300.8>
  }
  triangle { // #1876
		<446.45,-99,300.8>,
		<571.45,-99,462.1>,
		<446.95,-99,302.7>
  }
  triangle { // #1877
		<446.95,-99,302.7>,
		<571.45,-99,462.1>,
		<447.5,-99,304.5>
  }
  triangle { // #1878
		<447.5,-99,304.5>,
		<571.45,-99,462.1>,
		<448.05,-99,306.35>
  }
  triangle { // #1879
		<448.05,-99,306.35>,
		<571.45,-99,462.1>,
		<448.6,-99,308.2>
  }
  triangle { // #1880
		<448.6,-99,308.2>,
		<571.45,-99,462.1>,
		<449.1,-99,310>
  }
  triangle { // #1881
		<449.1,-99,310>,
		<571.45,-99,462.1>,
		<449.6,-99,311.85>
  }
  triangle { // #1882
		<449.6,-99,311.85>,
		<571.45,-99,462.1>,
		<450.1,-99,313.65>
  }
  triangle { // #1883
		<450.1,-99,313.65>,
		<571.45,-99,462.1>,
		<450.6,-99,315.5>
  }
  triangle { // #1884
		<450.6,-99,315.5>,
		<571.45,-99,462.1>,
		<451.05,-99,317.35>
  }
  triangle { // #1885
		<451.05,-99,317.35>,
		<571.45,-99,462.1>,
		<451.45,-99,319.2>
  }
  triangle { // #1886
		<451.45,-99,319.2>,
		<571.45,-99,462.1>,
		<451.85,-99,321.05>
  }
  triangle { // #1887
		<451.85,-99,321.05>,
		<571.45,-99,462.1>,
		<452.25,-99,322.95>
  }
  triangle { // #1888
		<452.25,-99,322.95>,
		<571.45,-99,462.1>,
		<452.6,-99,324.8>
  }
  triangle { // #1889
		<452.6,-99,324.8>,
		<571.45,-99,462.1>,
		<452.95,-99,326.7>
  }
  triangle { // #1890
		<452.95,-99,326.7>,
		<571.45,-99,462.1>,
		<453.25,-99,328.6>
  }
  triangle { // #1891
		<453.25,-99,328.6>,
		<571.45,-99,462.1>,
		<453.6,-99,330.5>
  }
  triangle { // #1892
		<453.6,-99,330.5>,
		<571.45,-99,462.1>,
		<453.9,-99,332.4>
  }
  triangle { // #1893
		<453.9,-99,332.4>,
		<571.45,-99,462.1>,
		<454.2,-99,334.3>
  }
  triangle { // #1894
		<454.2,-99,334.3>,
		<571.45,-99,462.1>,
		<454.45,-99,336.2>
  }
  triangle { // #1895
		<454.45,-99,336.2>,
		<571.45,-99,462.1>,
		<454.75,-99,338.1>
  }
  triangle { // #1896
		<454.75,-99,338.1>,
		<571.45,-99,462.1>,
		<455,-99,340.05>
  }
  triangle { // #1897
		<455,-99,340.05>,
		<571.45,-99,462.1>,
		<455.25,-99,341.95>
  }
  triangle { // #1898
		<455.25,-99,341.95>,
		<571.45,-99,462.1>,
		<455.45,-99,343.85>
  }
  triangle { // #1899
		<455.45,-99,343.85>,
		<571.45,-99,462.1>,
		<455.65,-99,345.8>
  }
  triangle { // #1900
		<455.65,-99,345.8>,
		<571.45,-99,462.1>,
		<455.85,-99,347.75>
  }
  triangle { // #1901
		<455.85,-99,347.75>,
		<571.45,-99,462.1>,
		<456,-99,349.7>
  }
  triangle { // #1902
		<456,-99,349.7>,
		<571.45,-99,462.1>,
		<456.15,-99,351.65>
  }
  triangle { // #1903
		<456.15,-99,351.65>,
		<571.45,-99,462.1>,
		<456.25,-99,353.6>
  }
  triangle { // #1904
		<456.25,-99,353.6>,
		<571.45,-99,462.1>,
		<456.35,-99,355.55>
  }
  triangle { // #1905
		<456.35,-99,355.55>,
		<571.45,-99,462.1>,
		<456.45,-99,357.55>
  }
  triangle { // #1906
		<456.45,-99,357.55>,
		<571.45,-99,462.1>,
		<456.6,-99,359.5>
  }
  triangle { // #1907
		<456.6,-99,359.5>,
		<571.45,-99,462.1>,
		<456.75,-99,361.45>
  }
  triangle { // #1908
		<456.75,-99,361.45>,
		<571.45,-99,462.1>,
		<456.9,-99,363.4>
  }
  triangle { // #1909
		<456.9,-99,363.4>,
		<571.45,-99,462.1>,
		<457.1,-99,365.3>
  }
  triangle { // #1910
		<457.1,-99,365.3>,
		<571.45,-99,462.1>,
		<457.35,-99,367.25>
  }
  triangle { // #1911
		<457.35,-99,367.25>,
		<571.45,-99,462.1>,
		<457.6,-99,369.15>
  }
  triangle { // #1912
		<457.6,-99,369.15>,
		<571.45,-99,462.1>,
		<457.85,-99,371.05>
  }
  triangle { // #1913
		<457.85,-99,371.05>,
		<571.45,-99,462.1>,
		<458.1,-99,373>
  }
  triangle { // #1914
		<458.1,-99,373>,
		<571.45,-99,462.1>,
		<458.35,-99,374.9>
  }
  triangle { // #1915
		<458.35,-99,374.9>,
		<571.45,-99,462.1>,
		<458.55,-99,376.85>
  }
  triangle { // #1916
		<458.55,-99,376.85>,
		<571.45,-99,462.1>,
		<458.75,-99,378.8>
  }
  triangle { // #1917
		<458.75,-99,378.8>,
		<571.45,-99,462.1>,
		<458.9,-99,380.75>
  }
  triangle { // #1918
		<458.9,-99,380.75>,
		<571.45,-99,462.1>,
		<459,-99,382.7>
  }
  triangle { // #1919
		<459,-99,382.7>,
		<571.45,-99,462.1>,
		<459.1,-99,384.65>
  }
  triangle { // #1920
		<459.1,-99,384.65>,
		<571.45,-99,462.1>,
		<459.15,-99,386.65>
  }
  triangle { // #1921
		<459.15,-99,386.65>,
		<571.45,-99,462.1>,
		<459.2,-99,388.65>
  }
  triangle { // #1922
		<459.2,-99,388.65>,
		<571.45,-99,462.1>,
		<459.3,-99,390.6>
  }
  triangle { // #1923
		<459.3,-99,390.6>,
		<571.45,-99,462.1>,
		<459.45,-99,392.55>
  }
  triangle { // #1924
		<459.45,-99,392.55>,
		<571.45,-99,462.1>,
		<459.65,-99,394.45>
  }
  triangle { // #1925
		<459.65,-99,394.45>,
		<571.45,-99,462.1>,
		<459.9,-99,396.4>
  }
  triangle { // #1926
		<459.9,-99,396.4>,
		<571.45,-99,462.1>,
		<460.2,-99,398.3>
  }
  triangle { // #1927
		<460.2,-99,398.3>,
		<571.45,-99,462.1>,
		<460.55,-99,400.2>
  }
  triangle { // #1928
		<460.55,-99,400.2>,
		<571.45,-99,462.1>,
		<460.95,-99,402.05>
  }
  triangle { // #1929
		<460.95,-99,402.05>,
		<571.45,-99,462.1>,
		<461.35,-99,403.9>
  }
  triangle { // #1930
		<461.35,-99,403.9>,
		<571.45,-99,462.1>,
		<461.8,-99,405.75>
  }
  triangle { // #1931
		<461.8,-99,405.75>,
		<571.45,-99,462.1>,
		<462.3,-99,407.6>
  }
  triangle { // #1932
		<462.3,-99,407.6>,
		<571.45,-99,462.1>,
		<462.8,-99,409.45>
  }
  triangle { // #1933
		<462.8,-99,409.45>,
		<571.45,-99,462.1>,
		<463.35,-99,411.25>
  }
  triangle { // #1934
		<463.35,-99,411.25>,
		<571.45,-99,462.1>,
		<463.95,-99,413.05>
  }
  triangle { // #1935
		<463.95,-99,413.05>,
		<571.45,-99,462.1>,
		<464.55,-99,414.85>
  }
  triangle { // #1936
		<464.55,-99,414.85>,
		<571.45,-99,462.1>,
		<465.15,-99,416.65>
  }
  triangle { // #1937
		<465.15,-99,416.65>,
		<571.45,-99,462.1>,
		<465.8,-99,418.45>
  }
  triangle { // #1938
		<465.8,-99,418.45>,
		<571.45,-99,462.1>,
		<466.55,-99,420.2>
  }
  triangle { // #1939
		<466.55,-99,420.2>,
		<571.45,-99,462.1>,
		<467.25,-99,421.95>
  }
  triangle { // #1940
		<467.25,-99,421.95>,
		<571.45,-99,462.1>,
		<468.05,-99,423.7>
  }
  triangle { // #1941
		<468.05,-99,423.7>,
		<571.45,-99,462.1>,
		<468.9,-99,425.45>
  }
  triangle { // #1942
		<468.9,-99,425.45>,
		<571.45,-99,462.1>,
		<469.75,-99,427.15>
  }
  triangle { // #1943
		<469.75,-99,427.15>,
		<571.45,-99,462.1>,
		<470.7,-99,428.85>
  }
  triangle { // #1944
		<470.7,-99,428.85>,
		<571.45,-99,462.1>,
		<471.65,-99,430.55>
  }
  triangle { // #1945
		<471.65,-99,430.55>,
		<571.45,-99,462.1>,
		<472.65,-99,432.2>
  }
  triangle { // #1946
		<472.65,-99,432.2>,
		<571.45,-99,462.1>,
		<473.7,-99,433.85>
  }
  triangle { // #1947
		<473.7,-99,433.85>,
		<571.45,-99,462.1>,
		<474.8,-99,435.5>
  }
  triangle { // #1948
		<474.8,-99,435.5>,
		<571.45,-99,462.1>,
		<476,-99,437.1>
  }
  triangle { // #1949
		<476,-99,437.1>,
		<571.45,-99,462.1>,
		<477.25,-99,438.7>
  }
  triangle { // #1950
		<477.25,-99,438.7>,
		<571.45,-99,462.1>,
		<478.55,-99,440.25>
  }
  triangle { // #1951
		<478.55,-99,440.25>,
		<571.45,-99,462.1>,
		<479.9,-99,441.8>
  }
  triangle { // #1952
		<479.9,-99,441.8>,
		<571.45,-99,462.1>,
		<481.35,-99,443.35>
  }
  triangle { // #1953
		<481.35,-99,443.35>,
		<571.45,-99,462.1>,
		<482.8,-99,444.9>
  }
  triangle { // #1954
		<482.8,-99,444.9>,
		<571.45,-99,462.1>,
		<484.35,-99,446.4>
  }
  triangle { // #1955
		<484.35,-99,446.4>,
		<571.45,-99,462.1>,
		<485.9,-99,447.85>
  }
  triangle { // #1956
		<485.9,-99,447.85>,
		<571.45,-99,462.1>,
		<487.55,-99,449.3>
  }
  triangle { // #1957
		<487.55,-99,449.3>,
		<571.45,-99,462.1>,
		<489.2,-99,450.75>
  }
  triangle { // #1958
		<489.2,-99,450.75>,
		<571.45,-99,462.1>,
		<490.95,-99,452.15>
  }
  triangle { // #1959
		<490.95,-99,452.15>,
		<571.45,-99,462.1>,
		<492.75,-99,453.55>
  }
  triangle { // #1960
		<492.75,-99,453.55>,
		<571.45,-99,462.1>,
		<494.6,-99,454.95>
  }
  triangle { // #1961
		<494.6,-99,454.95>,
		<571.45,-99,462.1>,
		<496.5,-99,456.3>
  }
  triangle { // #1962
		<496.5,-99,456.3>,
		<571.45,-99,462.1>,
		<498.5,-99,457.65>
  }
  triangle { // #1963
		<498.5,-99,457.65>,
		<571.45,-99,462.1>,
		<500.6,-99,459>
  }
  triangle { // #1964
		<500.6,-99,459>,
		<571.45,-99,462.1>,
		<502.8,-99,460.3>
  }
  triangle { // #1965
		<502.8,-99,460.3>,
		<571.45,-99,462.1>,
		<505.1,-99,461.65>
  }
  triangle { // #1966
		<505.1,-99,461.65>,
		<571.45,-99,462.1>,
		<507.5,-99,462.95>
  }
  triangle { // #1967
		<507.5,-99,462.95>,
		<571.45,-99,462.1>,
		<510,-99,464.2>
  }
  triangle { // #1968
		<571.45,-99,462.1>,
		<569.55,-99,463.15>,
		<510,-99,464.2>
  }
  triangle { // #1969
		<569.55,-99,463.15>,
		<567.15,-99,464.15>,
		<510,-99,464.2>
  }
  triangle { // #1970
		<567.15,-99,464.15>,
		<564.35,-99,465.05>,
		<510,-99,464.2>
  }
  triangle { // #1971
		<564.35,-99,465.05>,
		<561.15,-99,465.9>,
		<510,-99,464.2>
  }
  triangle { // #1972
		<561.15,-99,465.9>,
		<557.45,-99,466.7>,
		<510,-99,464.2>
  }
  triangle { // #1973
		<557.45,-99,466.7>,
		<553.35,-99,467.4>,
		<510,-99,464.2>
  }
  triangle { // #1974
		<553.35,-99,467.4>,
		<548.85,-99,468>,
		<510,-99,464.2>
  }
  triangle { // #1975
		<548.85,-99,468>,
		<543.9,-99,468.55>,
		<510,-99,464.2>
  }
  triangle { // #1976
		<543.9,-99,468.55>,
		<538.85,-99,468.95>,
		<510,-99,464.2>
  }
  triangle { // #1977
		<538.85,-99,468.95>,
		<534.15,-99,469.15>,
		<510,-99,464.2>
  }
  triangle { // #1978
		<534.15,-99,469.15>,
		<529.75,-99,469.1>,
		<510,-99,464.2>
  }
  triangle { // #1979
		<529.75,-99,469.1>,
		<525.7,-99,468.8>,
		<510,-99,464.2>
  }
  triangle { // #1980
		<525.7,-99,468.8>,
		<521.95,-99,468.3>,
		<510,-99,464.2>
  }
  triangle { // #1981
		<521.95,-99,468.3>,
		<518.5,-99,467.6>,
		<510,-99,464.2>
  }
  triangle { // #1982
		<518.5,-99,467.6>,
		<515.4,-99,466.65>,
		<510,-99,464.2>
  }
  smooth_triangle { // #1983
		<569.55,-0,463.15>, <0.422,-0.907,0>,
		<569.55,-99,463.15>, <0.454,-0.891,0>,
		<571.45,-0,462.1>, <0.486,-0.874,0>
  }
  smooth_triangle { // #1984
		<571.45,-99,462.1>, <0.486,-0.874,0>,
		<571.45,-0,462.1>, <0.486,-0.874,0>,
		<569.55,-99,463.15>, <0.454,-0.891,0>
  }
  smooth_triangle { // #1985
		<567.15,-0,464.15>, <0.339,-0.941,0>,
		<567.15,-99,464.15>, <0.364,-0.931,0>,
		<569.55,-0,463.15>, <0.422,-0.907,0>
  }
  smooth_triangle { // #1986
		<569.55,-99,463.15>, <0.454,-0.891,0>,
		<569.55,-0,463.15>, <0.422,-0.907,0>,
		<567.15,-99,464.15>, <0.364,-0.931,0>
  }
  smooth_triangle { // #1987
		<564.35,-0,465.05>, <0.274,-0.962,0>,
		<564.35,-99,465.05>, <0.294,-0.956,0>,
		<567.15,-0,464.15>, <0.339,-0.941,0>
  }
  smooth_triangle { // #1988
		<567.15,-99,464.15>, <0.364,-0.931,0>,
		<567.15,-0,464.15>, <0.339,-0.941,0>,
		<564.35,-99,465.05>, <0.294,-0.956,0>
  }
  smooth_triangle { // #1989
		<561.15,-0,465.9>, <0.222,-0.975,0>,
		<561.15,-99,465.9>, <0.238,-0.971,0>,
		<564.35,-0,465.05>, <0.274,-0.962,0>
  }
  smooth_triangle { // #1990
		<564.35,-99,465.05>, <0.294,-0.956,0>,
		<564.35,-0,465.05>, <0.274,-0.962,0>,
		<561.15,-99,465.9>, <0.238,-0.971,0>
  }
  smooth_triangle { // #1991
		<557.45,-0,466.7>, <0.181,-0.984,0>,
		<557.45,-99,466.7>, <0.194,-0.981,0>,
		<561.15,-0,465.9>, <0.222,-0.975,0>
  }
  smooth_triangle { // #1992
		<561.15,-99,465.9>, <0.238,-0.971,0>,
		<561.15,-0,465.9>, <0.222,-0.975,0>,
		<557.45,-99,466.7>, <0.194,-0.981,0>
  }
  smooth_triangle { // #1993
		<553.35,-0,467.4>, <0.147,-0.989,0>,
		<553.35,-99,467.4>, <0.157,-0.988,0>,
		<557.45,-0,466.7>, <0.181,-0.984,0>
  }
  smooth_triangle { // #1994
		<557.45,-99,466.7>, <0.194,-0.981,0>,
		<557.45,-0,466.7>, <0.181,-0.984,0>,
		<553.35,-99,467.4>, <0.157,-0.988,0>
  }
  smooth_triangle { // #1995
		<548.85,-0,468>, <0.119,-0.993,0>,
		<548.85,-99,468>, <0.127,-0.992,0>,
		<553.35,-0,467.4>, <0.147,-0.989,0>
  }
  smooth_triangle { // #1996
		<553.35,-99,467.4>, <0.157,-0.988,0>,
		<553.35,-0,467.4>, <0.147,-0.989,0>,
		<548.85,-99,468>, <0.127,-0.992,0>
  }
  smooth_triangle { // #1997
		<543.9,-0,468.55>, <0.089,-0.996,0>,
		<543.9,-99,468.55>, <0.099,-0.995,0>,
		<548.85,-0,468>, <0.119,-0.993,0>
  }
  smooth_triangle { // #1998
		<548.85,-99,468>, <0.127,-0.992,0>,
		<548.85,-0,468>, <0.119,-0.993,0>,
		<543.9,-99,468.55>, <0.099,-0.995,0>
  }
  smooth_triangle { // #1999
		<538.85,-0,468.95>, <0.051,-0.999,0>,
		<538.85,-99,468.95>, <0.065,-0.998,0>,
		<543.9,-0,468.55>, <0.089,-0.996,0>
  }
  smooth_triangle { // #2000
		<543.9,-99,468.55>, <0.099,-0.995,0>,
		<543.9,-0,468.55>, <0.089,-0.996,0>,
		<538.85,-99,468.95>, <0.065,-0.998,0>
  }
  smooth_triangle { // #2001
		<534.15,-0,469.15>, <0.005,-1,0>,
		<534.15,-99,469.15>, <0.021,-1,0>,
		<538.85,-0,468.95>, <0.051,-0.999,0>
  }
  smooth_triangle { // #2002
		<538.85,-99,468.95>, <0.065,-0.998,0>,
		<538.85,-0,468.95>, <0.051,-0.999,0>,
		<534.15,-99,469.15>, <0.021,-1,0>
  }
  smooth_triangle { // #2003
		<529.75,-0,469.1>, <-0.048,-0.999,0>,
		<529.75,-99,469.1>, <-0.029,-1,0>,
		<534.15,-0,469.15>, <0.005,-1,0>
  }
  smooth_triangle { // #2004
		<534.15,-99,469.15>, <0.021,-1,0>,
		<534.15,-0,469.15>, <0.005,-1,0>,
		<529.75,-99,469.1>, <-0.029,-1,0>
  }
  smooth_triangle { // #2005
		<525.7,-0,468.8>, <-0.109,-0.994,0>,
		<525.7,-99,468.8>, <-0.088,-0.996,0>,
		<529.75,-0,469.1>, <-0.048,-0.999,0>
  }
  smooth_triangle { // #2006
		<529.75,-99,469.1>, <-0.029,-1,0>,
		<529.75,-0,469.1>, <-0.048,-0.999,0>,
		<525.7,-99,468.8>, <-0.088,-0.996,0>
  }
  smooth_triangle { // #2007
		<521.95,-0,468.3>, <-0.18,-0.984,0>,
		<521.95,-99,468.3>, <-0.155,-0.988,0>,
		<525.7,-0,468.8>, <-0.109,-0.994,0>
  }
  smooth_triangle { // #2008
		<525.7,-99,468.8>, <-0.088,-0.996,0>,
		<525.7,-0,468.8>, <-0.109,-0.994,0>,
		<521.95,-99,468.3>, <-0.155,-0.988,0>
  }
  smooth_triangle { // #2009
		<518.5,-0,467.6>, <-0.261,-0.965,0>,
		<518.5,-99,467.6>, <-0.233,-0.973,0>,
		<521.95,-0,468.3>, <-0.18,-0.984,0>
  }
  smooth_triangle { // #2010
		<521.95,-99,468.3>, <-0.155,-0.988,0>,
		<521.95,-0,468.3>, <-0.18,-0.984,0>,
		<518.5,-99,467.6>, <-0.233,-0.973,0>
  }
  smooth_triangle { // #2011
		<515.4,-0,466.65>, <-0.352,-0.936,0>,
		<515.4,-99,466.65>, <-0.321,-0.947,0>,
		<518.5,-0,467.6>, <-0.261,-0.965,0>
  }
  smooth_triangle { // #2012
		<518.5,-99,467.6>, <-0.233,-0.973,0>,
		<518.5,-0,467.6>, <-0.261,-0.965,0>,
		<515.4,-99,466.65>, <-0.321,-0.947,0>
  }
  smooth_triangle { // #2013
		<512.6,-0,465.5>, <-0.423,-0.906,0>,
		<512.6,-99,465.5>, <-0.404,-0.915,0>,
		<515.4,-0,466.65>, <-0.352,-0.936,0>
  }
  smooth_triangle { // #2014
		<515.4,-99,466.65>, <-0.321,-0.947,0>,
		<515.4,-0,466.65>, <-0.352,-0.936,0>,
		<512.6,-99,465.5>, <-0.404,-0.915,0>
  }
  smooth_triangle { // #2015
		<510,-0,464.2>, <-0.454,-0.891,0>,
		<510,-99,464.2>, <-0.448,-0.894,0>,
		<512.6,-0,465.5>, <-0.423,-0.906,0>
  }
  smooth_triangle { // #2016
		<512.6,-99,465.5>, <-0.404,-0.915,0>,
		<512.6,-0,465.5>, <-0.423,-0.906,0>,
		<510,-99,464.2>, <-0.448,-0.894,0>
  }
  smooth_triangle { // #2017
		<507.5,-0,462.95>, <-0.472,-0.882,0>,
		<507.5,-99,462.95>, <-0.466,-0.885,0>,
		<510,-0,464.2>, <-0.454,-0.891,0>
  }
  smooth_triangle { // #2018
		<510,-99,464.2>, <-0.448,-0.894,0>,
		<510,-0,464.2>, <-0.454,-0.891,0>,
		<507.5,-99,462.95>, <-0.466,-0.885,0>
  }
  smooth_triangle { // #2019
		<505.1,-0,461.65>, <-0.49,-0.872,0>,
		<505.1,-99,461.65>, <-0.484,-0.875,0>,
		<507.5,-0,462.95>, <-0.472,-0.882,0>
  }
  smooth_triangle { // #2020
		<507.5,-99,462.95>, <-0.466,-0.885,0>,
		<507.5,-0,462.95>, <-0.472,-0.882,0>,
		<505.1,-99,461.65>, <-0.484,-0.875,0>
  }
  smooth_triangle { // #2021
		<502.8,-0,460.3>, <-0.509,-0.861,0>,
		<502.8,-99,460.3>, <-0.503,-0.865,0>,
		<505.1,-0,461.65>, <-0.49,-0.872,0>
  }
  smooth_triangle { // #2022
		<505.1,-99,461.65>, <-0.484,-0.875,0>,
		<505.1,-0,461.65>, <-0.49,-0.872,0>,
		<502.8,-99,460.3>, <-0.503,-0.865,0>
  }
  smooth_triangle { // #2023
		<500.6,-0,459>, <-0.529,-0.848,0>,
		<500.6,-99,459>, <-0.522,-0.853,0>,
		<502.8,-0,460.3>, <-0.509,-0.861,0>
  }
  smooth_triangle { // #2024
		<502.8,-99,460.3>, <-0.503,-0.865,0>,
		<502.8,-0,460.3>, <-0.509,-0.861,0>,
		<500.6,-99,459>, <-0.522,-0.853,0>
  }
  smooth_triangle { // #2025
		<498.5,-0,457.65>, <-0.55,-0.835,0>,
		<498.5,-99,457.65>, <-0.543,-0.84,0>,
		<500.6,-0,459>, <-0.529,-0.848,0>
  }
  smooth_triangle { // #2026
		<500.6,-99,459>, <-0.522,-0.853,0>,
		<500.6,-0,459>, <-0.529,-0.848,0>,
		<498.5,-99,457.65>, <-0.543,-0.84,0>
  }
  smooth_triangle { // #2027
		<496.5,-0,456.3>, <-0.572,-0.82,0>,
		<496.5,-99,456.3>, <-0.565,-0.825,0>,
		<498.5,-0,457.65>, <-0.55,-0.835,0>
  }
  smooth_triangle { // #2028
		<498.5,-99,457.65>, <-0.543,-0.84,0>,
		<498.5,-0,457.65>, <-0.55,-0.835,0>,
		<496.5,-99,456.3>, <-0.565,-0.825,0>
  }
  smooth_triangle { // #2029
		<494.6,0,454.95>, <-0.593,-0.805,0>,
		<494.6,-99,454.95>, <-0.586,-0.81,0>,
		<496.5,-0,456.3>, <-0.572,-0.82,0>
  }
  smooth_triangle { // #2030
		<496.5,-99,456.3>, <-0.565,-0.825,0>,
		<496.5,-0,456.3>, <-0.572,-0.82,0>,
		<494.6,-99,454.95>, <-0.586,-0.81,0>
  }
  smooth_triangle { // #2031
		<492.75,0,453.55>, <-0.611,-0.792,0>,
		<492.75,-99,453.55>, <-0.605,-0.796,0>,
		<494.6,0,454.95>, <-0.593,-0.805,0>
  }
  smooth_triangle { // #2032
		<494.6,-99,454.95>, <-0.586,-0.81,0>,
		<494.6,0,454.95>, <-0.593,-0.805,0>,
		<492.75,-99,453.55>, <-0.605,-0.796,0>
  }
  smooth_triangle { // #2033
		<490.95,0,452.15>, <-0.627,-0.779,0>,
		<490.95,-99,452.15>, <-0.622,-0.783,0>,
		<492.75,0,453.55>, <-0.611,-0.792,0>
  }
  smooth_triangle { // #2034
		<492.75,-99,453.55>, <-0.605,-0.796,0>,
		<492.75,0,453.55>, <-0.611,-0.792,0>,
		<490.95,-99,452.15>, <-0.622,-0.783,0>
  }
  smooth_triangle { // #2035
		<489.2,0,450.75>, <-0.644,-0.765,0>,
		<489.2,-99,450.75>, <-0.638,-0.77,0>,
		<490.95,0,452.15>, <-0.627,-0.779,0>
  }
  smooth_triangle { // #2036
		<490.95,-99,452.15>, <-0.622,-0.783,0>,
		<490.95,0,452.15>, <-0.627,-0.779,0>,
		<489.2,-99,450.75>, <-0.638,-0.77,0>
  }
  smooth_triangle { // #2037
		<487.55,0,449.3>, <-0.661,-0.75,0>,
		<487.55,-99,449.3>, <-0.655,-0.755,0>,
		<489.2,0,450.75>, <-0.644,-0.765,0>
  }
  smooth_triangle { // #2038
		<489.2,-99,450.75>, <-0.638,-0.77,0>,
		<489.2,0,450.75>, <-0.644,-0.765,0>,
		<487.55,-99,449.3>, <-0.655,-0.755,0>
  }
  smooth_triangle { // #2039
		<485.9,0,447.85>, <-0.678,-0.735,0>,
		<485.9,-99,447.85>, <-0.672,-0.74,0>,
		<487.55,0,449.3>, <-0.661,-0.75,0>
  }
  smooth_triangle { // #2040
		<487.55,-99,449.3>, <-0.655,-0.755,0>,
		<487.55,0,449.3>, <-0.661,-0.75,0>,
		<485.9,-99,447.85>, <-0.672,-0.74,0>
  }
  smooth_triangle { // #2041
		<484.35,0,446.4>, <-0.695,-0.719,0>,
		<484.35,-99,446.4>, <-0.689,-0.725,0>,
		<485.9,0,447.85>, <-0.678,-0.735,0>
  }
  smooth_triangle { // #2042
		<485.9,-99,447.85>, <-0.672,-0.74,0>,
		<485.9,0,447.85>, <-0.678,-0.735,0>,
		<484.35,-99,446.4>, <-0.689,-0.725,0>
  }
  smooth_triangle { // #2043
		<482.8,0,444.9>, <-0.712,-0.702,0>,
		<482.8,-99,444.9>, <-0.706,-0.708,0>,
		<484.35,0,446.4>, <-0.695,-0.719,0>
  }
  smooth_triangle { // #2044
		<484.35,-99,446.4>, <-0.689,-0.725,0>,
		<484.35,0,446.4>, <-0.695,-0.719,0>,
		<482.8,-99,444.9>, <-0.706,-0.708,0>
  }
  smooth_triangle { // #2045
		<481.35,0,443.35>, <-0.729,-0.684,0>,
		<481.35,-99,443.35>, <-0.723,-0.69,0>,
		<482.8,0,444.9>, <-0.712,-0.702,0>
  }
  smooth_triangle { // #2046
		<482.8,-99,444.9>, <-0.706,-0.708,0>,
		<482.8,0,444.9>, <-0.712,-0.702,0>,
		<481.35,-99,443.35>, <-0.723,-0.69,0>
  }
  smooth_triangle { // #2047
		<479.9,0,441.8>, <-0.747,-0.665,0>,
		<479.9,-99,441.8>, <-0.741,-0.671,0>,
		<481.35,0,443.35>, <-0.729,-0.684,0>
  }
  smooth_triangle { // #2048
		<481.35,-99,443.35>, <-0.723,-0.69,0>,
		<481.35,0,443.35>, <-0.729,-0.684,0>,
		<479.9,-99,441.8>, <-0.741,-0.671,0>
  }
  smooth_triangle { // #2049
		<478.55,0,440.25>, <-0.765,-0.644,0>,
		<478.55,-99,440.25>, <-0.759,-0.651,0>,
		<479.9,0,441.8>, <-0.747,-0.665,0>
  }
  smooth_triangle { // #2050
		<479.9,-99,441.8>, <-0.741,-0.671,0>,
		<479.9,0,441.8>, <-0.747,-0.665,0>,
		<478.55,-99,440.25>, <-0.759,-0.651,0>
  }
  smooth_triangle { // #2051
		<477.25,0,438.7>, <-0.783,-0.622,0>,
		<477.25,-99,438.7>, <-0.777,-0.629,0>,
		<478.55,0,440.25>, <-0.765,-0.644,0>
  }
  smooth_triangle { // #2052
		<478.55,-99,440.25>, <-0.759,-0.651,0>,
		<478.55,0,440.25>, <-0.765,-0.644,0>,
		<477.25,-99,438.7>, <-0.777,-0.629,0>
  }
  smooth_triangle { // #2053
		<476,0,437.1>, <-0.801,-0.599,0>,
		<476,-99,437.1>, <-0.795,-0.607,0>,
		<477.25,0,438.7>, <-0.783,-0.622,0>
  }
  smooth_triangle { // #2054
		<477.25,-99,438.7>, <-0.777,-0.629,0>,
		<477.25,0,438.7>, <-0.783,-0.622,0>,
		<476,-99,437.1>, <-0.795,-0.607,0>
  }
  smooth_triangle { // #2055
		<474.8,0,435.5>, <-0.818,-0.575,0>,
		<474.8,-99,435.5>, <-0.812,-0.583,0>,
		<476,0,437.1>, <-0.801,-0.599,0>
  }
  smooth_triangle { // #2056
		<476,-99,437.1>, <-0.795,-0.607,0>,
		<476,0,437.1>, <-0.801,-0.599,0>,
		<474.8,-99,435.5>, <-0.812,-0.583,0>
  }
  smooth_triangle { // #2057
		<473.7,0,433.85>, <-0.835,-0.55,0>,
		<473.7,-99,433.85>, <-0.83,-0.558,0>,
		<474.8,0,435.5>, <-0.818,-0.575,0>
  }
  smooth_triangle { // #2058
		<474.8,-99,435.5>, <-0.812,-0.583,0>,
		<474.8,0,435.5>, <-0.818,-0.575,0>,
		<473.7,-99,433.85>, <-0.83,-0.558,0>
  }
  smooth_triangle { // #2059
		<472.65,0,432.2>, <-0.852,-0.524,0>,
		<472.65,-99,432.2>, <-0.846,-0.533,0>,
		<473.7,0,433.85>, <-0.835,-0.55,0>
  }
  smooth_triangle { // #2060
		<473.7,-99,433.85>, <-0.83,-0.558,0>,
		<473.7,0,433.85>, <-0.835,-0.55,0>,
		<472.65,-99,432.2>, <-0.846,-0.533,0>
  }
  smooth_triangle { // #2061
		<471.65,0,430.55>, <-0.866,-0.5,0>,
		<471.65,-99,430.55>, <-0.861,-0.508,0>,
		<472.65,0,432.2>, <-0.852,-0.524,0>
  }
  smooth_triangle { // #2062
		<472.65,-99,432.2>, <-0.846,-0.533,0>,
		<472.65,0,432.2>, <-0.852,-0.524,0>,
		<471.65,-99,430.55>, <-0.861,-0.508,0>
  }
  smooth_triangle { // #2063
		<470.7,0,428.85>, <-0.877,-0.48,0>,
		<470.7,-99,428.85>, <-0.874,-0.486,0>,
		<471.65,0,430.55>, <-0.866,-0.5,0>
  }
  smooth_triangle { // #2064
		<471.65,-99,430.55>, <-0.861,-0.508,0>,
		<471.65,0,430.55>, <-0.866,-0.5,0>,
		<470.7,-99,428.85>, <-0.874,-0.486,0>
  }
  smooth_triangle { // #2065
		<469.75,0,427.15>, <-0.888,-0.46,0>,
		<469.75,-99,427.15>, <-0.884,-0.467,0>,
		<470.7,0,428.85>, <-0.877,-0.48,0>
  }
  smooth_triangle { // #2066
		<470.7,-99,428.85>, <-0.874,-0.486,0>,
		<470.7,0,428.85>, <-0.877,-0.48,0>,
		<469.75,-99,427.15>, <-0.884,-0.467,0>
  }
  smooth_triangle { // #2067
		<468.9,0,425.45>, <-0.898,-0.44,0>,
		<468.9,-99,425.45>, <-0.895,-0.447,0>,
		<469.75,0,427.15>, <-0.888,-0.46,0>
  }
  smooth_triangle { // #2068
		<469.75,-99,427.15>, <-0.884,-0.467,0>,
		<469.75,0,427.15>, <-0.888,-0.46,0>,
		<468.9,-99,425.45>, <-0.895,-0.447,0>
  }
  smooth_triangle { // #2069
		<468.05,0,423.7>, <-0.908,-0.42,0>,
		<468.05,-99,423.7>, <-0.904,-0.427,0>,
		<468.9,0,425.45>, <-0.898,-0.44,0>
  }
  smooth_triangle { // #2070
		<468.9,-99,425.45>, <-0.895,-0.447,0>,
		<468.9,0,425.45>, <-0.898,-0.44,0>,
		<468.05,-99,423.7>, <-0.904,-0.427,0>
  }
  smooth_triangle { // #2071
		<467.25,0,421.95>, <-0.917,-0.399,0>,
		<467.25,-99,421.95>, <-0.914,-0.406,0>,
		<468.05,0,423.7>, <-0.908,-0.42,0>
  }
  smooth_triangle { // #2072
		<468.05,-99,423.7>, <-0.904,-0.427,0>,
		<468.05,0,423.7>, <-0.908,-0.42,0>,
		<467.25,-99,421.95>, <-0.914,-0.406,0>
  }
  smooth_triangle { // #2073
		<466.55,0,420.2>, <-0.926,-0.378,0>,
		<466.55,-99,420.2>, <-0.923,-0.385,0>,
		<467.25,0,421.95>, <-0.917,-0.399,0>
  }
  smooth_triangle { // #2074
		<467.25,-99,421.95>, <-0.914,-0.406,0>,
		<467.25,0,421.95>, <-0.917,-0.399,0>,
		<466.55,-99,420.2>, <-0.923,-0.385,0>
  }
  smooth_triangle { // #2075
		<465.8,0,418.45>, <-0.934,-0.357,0>,
		<465.8,-99,418.45>, <-0.931,-0.364,0>,
		<466.55,0,420.2>, <-0.926,-0.378,0>
  }
  smooth_triangle { // #2076
		<466.55,-99,420.2>, <-0.923,-0.385,0>,
		<466.55,0,420.2>, <-0.926,-0.378,0>,
		<465.8,-99,418.45>, <-0.931,-0.364,0>
  }
  smooth_triangle { // #2077
		<465.15,0,416.65>, <-0.941,-0.337,0>,
		<465.15,-99,416.65>, <-0.939,-0.344,0>,
		<465.8,0,418.45>, <-0.934,-0.357,0>
  }
  smooth_triangle { // #2078
		<465.8,-99,418.45>, <-0.931,-0.364,0>,
		<465.8,0,418.45>, <-0.934,-0.357,0>,
		<465.15,-99,416.65>, <-0.939,-0.344,0>
  }
  smooth_triangle { // #2079
		<464.55,0,414.85>, <-0.947,-0.321,0>,
		<464.55,-99,414.85>, <-0.945,-0.326,0>,
		<465.15,0,416.65>, <-0.941,-0.337,0>
  }
  smooth_triangle { // #2080
		<465.15,-99,416.65>, <-0.939,-0.344,0>,
		<465.15,0,416.65>, <-0.941,-0.337,0>,
		<464.55,-99,414.85>, <-0.945,-0.326,0>
  }
  smooth_triangle { // #2081
		<463.95,0,413.05>, <-0.952,-0.306,0>,
		<463.95,-99,413.05>, <-0.95,-0.311,0>,
		<464.55,0,414.85>, <-0.947,-0.321,0>
  }
  smooth_triangle { // #2082
		<464.55,-99,414.85>, <-0.945,-0.326,0>,
		<464.55,0,414.85>, <-0.947,-0.321,0>,
		<463.95,-99,413.05>, <-0.95,-0.311,0>
  }
  smooth_triangle { // #2083
		<463.35,0,411.25>, <-0.957,-0.291,0>,
		<463.35,-99,411.25>, <-0.955,-0.296,0>,
		<463.95,0,413.05>, <-0.952,-0.306,0>
  }
  smooth_triangle { // #2084
		<463.95,-99,413.05>, <-0.95,-0.311,0>,
		<463.95,0,413.05>, <-0.952,-0.306,0>,
		<463.35,-99,411.25>, <-0.955,-0.296,0>
  }
  smooth_triangle { // #2085
		<462.8,0,409.45>, <-0.961,-0.276,0>,
		<462.8,-99,409.45>, <-0.96,-0.281,0>,
		<463.35,0,411.25>, <-0.957,-0.291,0>
  }
  smooth_triangle { // #2086
		<463.35,-99,411.25>, <-0.955,-0.296,0>,
		<463.35,0,411.25>, <-0.957,-0.291,0>,
		<462.8,-99,409.45>, <-0.96,-0.281,0>
  }
  smooth_triangle { // #2087
		<462.3,0,407.6>, <-0.966,-0.26,0>,
		<462.3,-99,407.6>, <-0.964,-0.265,0>,
		<462.8,0,409.45>, <-0.961,-0.276,0>
  }
  smooth_triangle { // #2088
		<462.8,-99,409.45>, <-0.96,-0.281,0>,
		<462.8,0,409.45>, <-0.961,-0.276,0>,
		<462.3,-99,407.6>, <-0.964,-0.265,0>
  }
  smooth_triangle { // #2089
		<461.8,0,405.75>, <-0.97,-0.245,0>,
		<461.8,-99,405.75>, <-0.968,-0.25,0>,
		<462.3,0,407.6>, <-0.966,-0.26,0>
  }
  smooth_triangle { // #2090
		<462.3,-99,407.6>, <-0.964,-0.265,0>,
		<462.3,0,407.6>, <-0.966,-0.26,0>,
		<461.8,-99,405.75>, <-0.968,-0.25,0>
  }
  smooth_triangle { // #2091
		<461.35,0,403.9>, <-0.973,-0.229,0>,
		<461.35,-99,403.9>, <-0.972,-0.234,0>,
		<461.8,0,405.75>, <-0.97,-0.245,0>
  }
  smooth_triangle { // #2092
		<461.8,-99,405.75>, <-0.968,-0.25,0>,
		<461.8,0,405.75>, <-0.97,-0.245,0>,
		<461.35,-99,403.9>, <-0.972,-0.234,0>
  }
  smooth_triangle { // #2093
		<460.95,0,402.05>, <-0.978,-0.211,0>,
		<460.95,-99,402.05>, <-0.976,-0.217,0>,
		<461.35,0,403.9>, <-0.973,-0.229,0>
  }
  smooth_triangle { // #2094
		<461.35,-99,403.9>, <-0.972,-0.234,0>,
		<461.35,0,403.9>, <-0.973,-0.229,0>,
		<460.95,-99,402.05>, <-0.976,-0.217,0>
  }
  smooth_triangle { // #2095
		<460.55,0,400.2>, <-0.982,-0.187,0>,
		<460.55,-99,400.2>, <-0.981,-0.195,0>,
		<460.95,0,402.05>, <-0.978,-0.211,0>
  }
  smooth_triangle { // #2096
		<460.95,-99,402.05>, <-0.976,-0.217,0>,
		<460.95,0,402.05>, <-0.978,-0.211,0>,
		<460.55,-99,400.2>, <-0.981,-0.195,0>
  }
  smooth_triangle { // #2097
		<460.2,0,398.3>, <-0.987,-0.162,0>,
		<460.2,-99,398.3>, <-0.985,-0.17,0>,
		<460.55,0,400.2>, <-0.982,-0.187,0>
  }
  smooth_triangle { // #2098
		<460.55,-99,400.2>, <-0.981,-0.195,0>,
		<460.55,0,400.2>, <-0.982,-0.187,0>,
		<460.2,-99,398.3>, <-0.985,-0.17,0>
  }
  smooth_triangle { // #2099
		<459.9,0,396.4>, <-0.991,-0.137,0>,
		<459.9,-99,396.4>, <-0.989,-0.145,0>,
		<460.2,0,398.3>, <-0.987,-0.162,0>
  }
  smooth_triangle { // #2100
		<460.2,-99,398.3>, <-0.985,-0.17,0>,
		<460.2,0,398.3>, <-0.987,-0.162,0>,
		<459.9,-99,396.4>, <-0.989,-0.145,0>
  }
  smooth_triangle { // #2101
		<459.65,0,394.45>, <-0.994,-0.112,0>,
		<459.65,-99,394.45>, <-0.993,-0.12,0>,
		<459.9,0,396.4>, <-0.991,-0.137,0>
  }
  smooth_triangle { // #2102
		<459.9,-99,396.4>, <-0.989,-0.145,0>,
		<459.9,0,396.4>, <-0.991,-0.137,0>,
		<459.65,-99,394.45>, <-0.993,-0.12,0>
  }
  smooth_triangle { // #2103
		<459.45,0,392.55>, <-0.996,-0.087,0>,
		<459.45,-99,392.55>, <-0.995,-0.096,0>,
		<459.65,0,394.45>, <-0.994,-0.112,0>
  }
  smooth_triangle { // #2104
		<459.65,-99,394.45>, <-0.993,-0.12,0>,
		<459.65,0,394.45>, <-0.994,-0.112,0>,
		<459.45,-99,392.55>, <-0.995,-0.096,0>
  }
  smooth_triangle { // #2105
		<459.3,0,390.6>, <-0.998,-0.063,0>,
		<459.3,-99,390.6>, <-0.997,-0.071,0>,
		<459.45,0,392.55>, <-0.996,-0.087,0>
  }
  smooth_triangle { // #2106
		<459.45,-99,392.55>, <-0.995,-0.096,0>,
		<459.45,0,392.55>, <-0.996,-0.087,0>,
		<459.3,-99,390.6>, <-0.997,-0.071,0>
  }
  smooth_triangle { // #2107
		<459.2,0,388.65>, <-0.999,-0.039,0>,
		<459.2,-99,388.65>, <-0.999,-0.047,0>,
		<459.3,0,390.6>, <-0.998,-0.063,0>
  }
  smooth_triangle { // #2108
		<459.3,-99,390.6>, <-0.997,-0.071,0>,
		<459.3,0,390.6>, <-0.998,-0.063,0>,
		<459.2,-99,388.65>, <-0.999,-0.047,0>
  }
  triangle { // #2109
		<459.15,0,386.65>,
		<459.15,-99,386.65>,
		<459.2,0,388.65>
  }
  smooth_triangle { // #2110
		<459.2,-99,388.65>, <-0.999,-0.047,0>,
		<459.2,0,388.65>, <-0.999,-0.039,0>,
		<459.15,-99,386.65>, <-1,-0.029,0>
  }
  smooth_triangle { // #2111
		<459.1,0,384.65>, <-0.999,-0.037,0>,
		<459.1,-99,384.65>, <-1,-0.032,0>,
		<459.15,0,386.65>, <-1,-0.028,0>
  }
  triangle { // #2112
		<459.15,-99,386.65>,
		<459.15,0,386.65>,
		<459.1,-99,384.65>
  }
  smooth_triangle { // #2113
		<459,0,382.7>, <-0.999,-0.052,0>,
		<459,-99,382.7>, <-0.999,-0.047,0>,
		<459.1,0,384.65>, <-0.999,-0.037,0>
  }
  smooth_triangle { // #2114
		<459.1,-99,384.65>, <-1,-0.032,0>,
		<459.1,0,384.65>, <-0.999,-0.037,0>,
		<459,-99,382.7>, <-0.999,-0.047,0>
  }
  smooth_triangle { // #2115
		<458.9,0,380.75>, <-0.998,-0.068,0>,
		<458.9,-99,380.75>, <-0.998,-0.063,0>,
		<459,0,382.7>, <-0.999,-0.052,0>
  }
  smooth_triangle { // #2116
		<459,-99,382.7>, <-0.999,-0.047,0>,
		<459,0,382.7>, <-0.999,-0.052,0>,
		<458.9,-99,380.75>, <-0.998,-0.063,0>
  }
  smooth_triangle { // #2117
		<458.75,0,378.8>, <-0.996,-0.084,0>,
		<458.75,-99,378.8>, <-0.997,-0.079,0>,
		<458.9,0,380.75>, <-0.998,-0.068,0>
  }
  smooth_triangle { // #2118
		<458.9,-99,380.75>, <-0.998,-0.063,0>,
		<458.9,0,380.75>, <-0.998,-0.068,0>,
		<458.75,-99,378.8>, <-0.997,-0.079,0>
  }
  smooth_triangle { // #2119
		<458.55,0,376.85>, <-0.995,-0.1,0>,
		<458.55,-99,376.85>, <-0.995,-0.095,0>,
		<458.75,0,378.8>, <-0.996,-0.084,0>
  }
  smooth_triangle { // #2120
		<458.75,-99,378.8>, <-0.997,-0.079,0>,
		<458.75,0,378.8>, <-0.996,-0.084,0>,
		<458.55,-99,376.85>, <-0.995,-0.095,0>
  }
  smooth_triangle { // #2121
		<458.35,0,374.9>, <-0.993,-0.116,0>,
		<458.35,-99,374.9>, <-0.994,-0.111,0>,
		<458.55,0,376.85>, <-0.995,-0.1,0>
  }
  smooth_triangle { // #2122
		<458.55,-99,376.85>, <-0.995,-0.095,0>,
		<458.55,0,376.85>, <-0.995,-0.1,0>,
		<458.35,-99,374.9>, <-0.994,-0.111,0>
  }
  smooth_triangle { // #2123
		<458.1,0,373>, <-0.991,-0.132,0>,
		<458.1,-99,373>, <-0.992,-0.127,0>,
		<458.35,0,374.9>, <-0.993,-0.116,0>
  }
  smooth_triangle { // #2124
		<458.35,-99,374.9>, <-0.994,-0.111,0>,
		<458.35,0,374.9>, <-0.993,-0.116,0>,
		<458.1,-99,373>, <-0.992,-0.127,0>
  }
  triangle { // #2125
		<457.85,0,371.05>,
		<457.85,-99,371.05>,
		<458.1,0,373>
  }
  smooth_triangle { // #2126
		<458.1,-99,373>, <-0.992,-0.127,0>,
		<458.1,0,373>, <-0.991,-0.132,0>,
		<457.85,-99,371.05>, <-0.99,-0.138,0>
  }
  triangle { // #2127
		<457.6,0,369.15>,
		<457.6,-99,369.15>,
		<457.85,0,371.05>
  }
  triangle { // #2128
		<457.85,-99,371.05>,
		<457.85,0,371.05>,
		<457.6,-99,369.15>
  }
  triangle { // #2129
		<457.35,0,367.25>,
		<457.35,-99,367.25>,
		<457.6,0,369.15>
  }
  triangle { // #2130
		<457.6,-99,369.15>,
		<457.6,0,369.15>,
		<457.35,-99,367.25>
  }
  triangle { // #2131
		<457.1,0,365.3>,
		<457.1,-99,365.3>,
		<457.35,0,367.25>
  }
  triangle { // #2132
		<457.35,-99,367.25>,
		<457.35,0,367.25>,
		<457.1,-99,365.3>
  }
  triangle { // #2133
		<456.9,0,363.4>,
		<456.9,-99,363.4>,
		<457.1,0,365.3>
  }
  triangle { // #2134
		<457.1,-99,365.3>,
		<457.1,0,365.3>,
		<456.9,-99,363.4>
  }
  triangle { // #2135
		<456.75,0,361.45>,
		<456.75,-99,361.45>,
		<456.9,0,363.4>
  }
  triangle { // #2136
		<456.9,-99,363.4>,
		<456.9,0,363.4>,
		<456.75,-99,361.45>
  }
  triangle { // #2137
		<456.6,0,359.5>,
		<456.6,-99,359.5>,
		<456.75,0,361.45>
  }
  triangle { // #2138
		<456.75,-99,361.45>,
		<456.75,0,361.45>,
		<456.6,-99,359.5>
  }
  triangle { // #2139
		<456.45,0,357.55>,
		<456.45,-99,357.55>,
		<456.6,0,359.5>
  }
  triangle { // #2140
		<456.6,-99,359.5>,
		<456.6,0,359.5>,
		<456.45,-99,357.55>
  }
  triangle { // #2141
		<456.35,0,355.55>,
		<456.35,-99,355.55>,
		<456.45,0,357.55>
  }
  triangle { // #2142
		<456.45,-99,357.55>,
		<456.45,0,357.55>,
		<456.35,-99,355.55>
  }
  triangle { // #2143
		<456.25,0,353.6>,
		<456.25,-99,353.6>,
		<456.35,0,355.55>
  }
  triangle { // #2144
		<456.35,-99,355.55>,
		<456.35,0,355.55>,
		<456.25,-99,353.6>
  }
  triangle { // #2145
		<456.15,0,351.65>,
		<456.15,-99,351.65>,
		<456.25,0,353.6>
  }
  triangle { // #2146
		<456.25,-99,353.6>,
		<456.25,0,353.6>,
		<456.15,-99,351.65>
  }
  triangle { // #2147
		<456,0,349.7>,
		<456,-99,349.7>,
		<456.15,0,351.65>
  }
  triangle { // #2148
		<456.15,-99,351.65>,
		<456.15,0,351.65>,
		<456,-99,349.7>
  }
  triangle { // #2149
		<455.85,0,347.75>,
		<455.85,-99,347.75>,
		<456,0,349.7>
  }
  triangle { // #2150
		<456,-99,349.7>,
		<456,0,349.7>,
		<455.85,-99,347.75>
  }
  triangle { // #2151
		<455.65,0,345.8>,
		<455.65,-99,345.8>,
		<455.85,0,347.75>
  }
  triangle { // #2152
		<455.85,-99,347.75>,
		<455.85,0,347.75>,
		<455.65,-99,345.8>
  }
  triangle { // #2153
		<455.45,0,343.85>,
		<455.45,-99,343.85>,
		<455.65,0,345.8>
  }
  triangle { // #2154
		<455.65,-99,345.8>,
		<455.65,0,345.8>,
		<455.45,-99,343.85>
  }
  triangle { // #2155
		<455.25,0,341.95>,
		<455.25,-99,341.95>,
		<455.45,0,343.85>
  }
  triangle { // #2156
		<455.45,-99,343.85>,
		<455.45,0,343.85>,
		<455.25,-99,341.95>
  }
  triangle { // #2157
		<455,0,340.05>,
		<455,-99,340.05>,
		<455.25,0,341.95>
  }
  triangle { // #2158
		<455.25,-99,341.95>,
		<455.25,0,341.95>,
		<455,-99,340.05>
  }
  triangle { // #2159
		<454.75,0,338.1>,
		<454.75,-99,338.1>,
		<455,0,340.05>
  }
  triangle { // #2160
		<455,-99,340.05>,
		<455,0,340.05>,
		<454.75,-99,338.1>
  }
  triangle { // #2161
		<454.45,0,336.2>,
		<454.45,-99,336.2>,
		<454.75,0,338.1>
  }
  triangle { // #2162
		<454.75,-99,338.1>,
		<454.75,0,338.1>,
		<454.45,-99,336.2>
  }
  triangle { // #2163
		<454.2,0,334.3>,
		<454.2,-99,334.3>,
		<454.45,0,336.2>
  }
  triangle { // #2164
		<454.45,-99,336.2>,
		<454.45,0,336.2>,
		<454.2,-99,334.3>
  }
  triangle { // #2165
		<453.9,0,332.4>,
		<453.9,-99,332.4>,
		<454.2,0,334.3>
  }
  triangle { // #2166
		<454.2,-99,334.3>,
		<454.2,0,334.3>,
		<453.9,-99,332.4>
  }
  triangle { // #2167
		<453.6,0,330.5>,
		<453.6,-99,330.5>,
		<453.9,0,332.4>
  }
  triangle { // #2168
		<453.9,-99,332.4>,
		<453.9,0,332.4>,
		<453.6,-99,330.5>
  }
  triangle { // #2169
		<453.25,0,328.6>,
		<453.25,-99,328.6>,
		<453.6,0,330.5>
  }
  triangle { // #2170
		<453.6,-99,330.5>,
		<453.6,0,330.5>,
		<453.25,-99,328.6>
  }
  triangle { // #2171
		<452.95,0,326.7>,
		<452.95,-99,326.7>,
		<453.25,0,328.6>
  }
  triangle { // #2172
		<453.25,-99,328.6>,
		<453.25,0,328.6>,
		<452.95,-99,326.7>
  }
  triangle { // #2173
		<452.6,0,324.8>,
		<452.6,-99,324.8>,
		<452.95,0,326.7>
  }
  triangle { // #2174
		<452.95,-99,326.7>,
		<452.95,0,326.7>,
		<452.6,-99,324.8>
  }
  triangle { // #2175
		<452.25,0,322.95>,
		<452.25,-99,322.95>,
		<452.6,0,324.8>
  }
  triangle { // #2176
		<452.6,-99,324.8>,
		<452.6,0,324.8>,
		<452.25,-99,322.95>
  }
  triangle { // #2177
		<451.85,0,321.05>,
		<451.85,-99,321.05>,
		<452.25,0,322.95>
  }
  triangle { // #2178
		<452.25,-99,322.95>,
		<452.25,0,322.95>,
		<451.85,-99,321.05>
  }
  triangle { // #2179
		<451.45,0,319.2>,
		<451.45,-99,319.2>,
		<451.85,0,321.05>
  }
  triangle { // #2180
		<451.85,-99,321.05>,
		<451.85,0,321.05>,
		<451.45,-99,319.2>
  }
  triangle { // #2181
		<451.05,0,317.35>,
		<451.05,-99,317.35>,
		<451.45,0,319.2>
  }
  triangle { // #2182
		<451.45,-99,319.2>,
		<451.45,0,319.2>,
		<451.05,-99,317.35>
  }
  triangle { // #2183
		<450.6,0,315.5>,
		<450.6,-99,315.5>,
		<451.05,0,317.35>
  }
  triangle { // #2184
		<451.05,-99,317.35>,
		<451.05,0,317.35>,
		<450.6,-99,315.5>
  }
  triangle { // #2185
		<450.1,0,313.65>,
		<450.1,-99,313.65>,
		<450.6,0,315.5>
  }
  triangle { // #2186
		<450.6,-99,315.5>,
		<450.6,0,315.5>,
		<450.1,-99,313.65>
  }
  triangle { // #2187
		<449.6,0,311.85>,
		<449.6,-99,311.85>,
		<450.1,0,313.65>
  }
  triangle { // #2188
		<450.1,-99,313.65>,
		<450.1,0,313.65>,
		<449.6,-99,311.85>
  }
  triangle { // #2189
		<449.1,0,310>,
		<449.1,-99,310>,
		<449.6,0,311.85>
  }
  triangle { // #2190
		<449.6,-99,311.85>,
		<449.6,0,311.85>,
		<449.1,-99,310>
  }
  triangle { // #2191
		<448.6,0,308.2>,
		<448.6,-99,308.2>,
		<449.1,0,310>
  }
  triangle { // #2192
		<449.1,-99,310>,
		<449.1,0,310>,
		<448.6,-99,308.2>
  }
  triangle { // #2193
		<448.05,0,306.35>,
		<448.05,-99,306.35>,
		<448.6,0,308.2>
  }
  triangle { // #2194
		<448.6,-99,308.2>,
		<448.6,0,308.2>,
		<448.05,-99,306.35>
  }
  triangle { // #2195
		<447.5,0,304.5>,
		<447.5,-99,304.5>,
		<448.05,0,306.35>
  }
  triangle { // #2196
		<448.05,-99,306.35>,
		<448.05,0,306.35>,
		<447.5,-99,304.5>
  }
  triangle { // #2197
		<446.95,0,302.7>,
		<446.95,-99,302.7>,
		<447.5,0,304.5>
  }
  triangle { // #2198
		<447.5,-99,304.5>,
		<447.5,0,304.5>,
		<446.95,-99,302.7>
  }
  triangle { // #2199
		<446.45,0,300.8>,
		<446.45,-99,300.8>,
		<446.95,0,302.7>
  }
  triangle { // #2200
		<446.95,-99,302.7>,
		<446.95,0,302.7>,
		<446.45,-99,300.8>
  }
  triangle { // #2201
		<445.85,0,298.95>,
		<445.85,-99,298.95>,
		<446.45,0,300.8>
  }
  triangle { // #2202
		<446.45,-99,300.8>,
		<446.45,0,300.8>,
		<445.85,-99,298.95>
  }
  triangle { // #2203
		<445.3,0,297.1>,
		<445.3,-99,297.1>,
		<445.85,0,298.95>
  }
  triangle { // #2204
		<445.85,-99,298.95>,
		<445.85,0,298.95>,
		<445.3,-99,297.1>
  }
  triangle { // #2205
		<444.75,0,295.2>,
		<444.75,-99,295.2>,
		<445.3,0,297.1>
  }
  triangle { // #2206
		<445.3,-99,297.1>,
		<445.3,0,297.1>,
		<444.75,-99,295.2>
  }
  triangle { // #2207
		<444.2,0,293.35>,
		<444.2,-99,293.35>,
		<444.75,0,295.2>
  }
  triangle { // #2208
		<444.75,-99,295.2>,
		<444.75,0,295.2>,
		<444.2,-99,293.35>
  }
  triangle { // #2209
		<443.6,0,291.55>,
		<443.6,-99,291.55>,
		<444.2,0,293.35>
  }
  triangle { // #2210
		<444.2,-99,293.35>,
		<444.2,0,293.35>,
		<443.6,-99,291.55>
  }
  triangle { // #2211
		<443.05,0,289.85>,
		<443.05,-99,289.85>,
		<443.6,0,291.55>
  }
  triangle { // #2212
		<443.6,-99,291.55>,
		<443.6,0,291.55>,
		<443.05,-99,289.85>
  }
  triangle { // #2213
		<442.45,0,288.15>,
		<442.45,-99,288.15>,
		<443.05,0,289.85>
  }
  triangle { // #2214
		<443.05,-99,289.85>,
		<443.05,0,289.85>,
		<442.45,-99,288.15>
  }
  triangle { // #2215
		<441.9,0,286.55>,
		<441.9,-99,286.55>,
		<442.45,0,288.15>
  }
  triangle { // #2216
		<442.45,-99,288.15>,
		<442.45,0,288.15>,
		<441.9,-99,286.55>
  }
  triangle { // #2217
		<441.3,0,285>,
		<441.3,-99,285>,
		<441.9,0,286.55>
  }
  triangle { // #2218
		<441.9,-99,286.55>,
		<441.9,0,286.55>,
		<441.3,-99,285>
  }
  triangle { // #2219
		<440.75,0,283.45>,
		<440.75,-99,283.45>,
		<441.3,0,285>
  }
  triangle { // #2220
		<441.3,-99,285>,
		<441.3,0,285>,
		<440.75,-99,283.45>
  }
  smooth_triangle { // #2221
		<440.15,0,282>, <-0.924,-0.383,0>,
		<440.15,-99,282>, <-0.926,-0.378,0>,
		<440.75,0,283.45>, <-0.93,-0.369,0>
  }
  triangle { // #2222
		<440.75,-99,283.45>,
		<440.75,0,283.45>,
		<440.15,-99,282>
  }
  triangle { // #2223
		<439.5,0,280.45>,
		<439.5,-99,280.45>,
		<440.15,0,282>
  }
  smooth_triangle { // #2224
		<440.15,-99,282>, <-0.926,-0.378,0>,
		<440.15,0,282>, <-0.924,-0.383,0>,
		<439.5,-99,280.45>, <-0.92,-0.393,0>
  }
  triangle { // #2225
		<438.7,0,278.6>,
		<438.7,-99,278.6>,
		<439.5,0,280.45>
  }
  triangle { // #2226
		<439.5,-99,280.45>,
		<439.5,0,280.45>,
		<438.7,-99,278.6>
  }
  triangle { // #2227
		<437.75,0,276.5>,
		<437.75,-99,276.5>,
		<438.7,0,278.6>
  }
  triangle { // #2228
		<438.7,-99,278.6>,
		<438.7,0,278.6>,
		<437.75,-99,276.5>
  }
  triangle { // #2229
		<436.6,0,274.1>,
		<436.6,-99,274.1>,
		<437.75,0,276.5>
  }
  triangle { // #2230
		<437.75,-99,276.5>,
		<437.75,0,276.5>,
		<436.6,-99,274.1>
  }
  triangle { // #2231
		<435.35,0,271.4>,
		<435.35,-99,271.4>,
		<436.6,0,274.1>
  }
  triangle { // #2232
		<436.6,-99,274.1>,
		<436.6,0,274.1>,
		<435.35,-99,271.4>
  }
  triangle { // #2233
		<433.95,0,268.4>,
		<433.95,-99,268.4>,
		<435.35,0,271.4>
  }
  triangle { // #2234
		<435.35,-99,271.4>,
		<435.35,0,271.4>,
		<433.95,-99,268.4>
  }
  triangle { // #2235
		<432.4,0,265.15>,
		<432.4,-99,265.15>,
		<433.95,0,268.4>
  }
  triangle { // #2236
		<433.95,-99,268.4>,
		<433.95,0,268.4>,
		<432.4,-99,265.15>
  }
  smooth_triangle { // #2237
		<431.35,0,262.95>, <-0.862,-0.507,0>,
		<431.35,-99,262.95>, <-0.862,-0.507,0>,
		<432.4,0,265.15>, <-0.901,-0.434,0>
  }
  smooth_triangle { // #2238
		<432.4,-99,265.15>, <-0.901,-0.433,0>,
		<432.4,0,265.15>, <-0.901,-0.434,0>,
		<431.35,-99,262.95>, <-0.862,-0.507,0>
  }
  triangle { // #2239
		<571.45,-0,462.1>,
		<571.45,-99,462.1>,
		<431.35,0,262.95>
  }
  triangle { // #2240
		<431.35,-99,262.95>,
		<431.35,0,262.95>,
		<571.45,-99,462.1>
  }
  triangle { // #2241
		<-539,-0,470.3>,
		<-537.15,-0,469.85>,
		<-540.9,-0,470.65>
  }
  triangle { // #2242
		<-435.1,0,272.6>,
		<-560.2,-0,468.9>,
		<-435.8,0,274.1>
  }
  triangle { // #2243
		<-435.8,0,274.1>,
		<-560.2,-0,468.9>,
		<-436.45,0,275.55>
  }
  triangle { // #2244
		<-436.45,0,275.55>,
		<-560.2,-0,468.9>,
		<-437.1,0,276.95>
  }
  triangle { // #2245
		<-437.1,0,276.95>,
		<-560.2,-0,468.9>,
		<-437.75,0,278.3>
  }
  triangle { // #2246
		<-437.75,0,278.3>,
		<-560.2,-0,468.9>,
		<-438.35,0,279.6>
  }
  triangle { // #2247
		<-438.35,0,279.6>,
		<-560.2,-0,468.9>,
		<-438.9,0,280.85>
  }
  triangle { // #2248
		<-438.9,0,280.85>,
		<-560.2,-0,468.9>,
		<-439.45,0,282.1>
  }
  triangle { // #2249
		<-439.45,0,282.1>,
		<-560.2,-0,468.9>,
		<-440,0,283.25>
  }
  triangle { // #2250
		<-440,0,283.25>,
		<-560.2,-0,468.9>,
		<-440.55,0,284.35>
  }
  triangle { // #2251
		<-440.55,0,284.35>,
		<-560.2,-0,468.9>,
		<-441.05,0,285.4>
  }
  triangle { // #2252
		<-441.05,0,285.4>,
		<-560.2,-0,468.9>,
		<-441.55,0,286.45>
  }
  triangle { // #2253
		<-441.55,0,286.45>,
		<-560.2,-0,468.9>,
		<-442,0,287.4>
  }
  triangle { // #2254
		<-442,0,287.4>,
		<-560.2,-0,468.9>,
		<-442.45,0,288.3>
  }
  triangle { // #2255
		<-442.45,0,288.3>,
		<-560.2,-0,468.9>,
		<-442.85,0,289.15>
  }
  triangle { // #2256
		<-442.85,0,289.15>,
		<-560.2,-0,468.9>,
		<-443.25,0,290>
  }
  triangle { // #2257
		<-443.25,0,290>,
		<-560.2,-0,468.9>,
		<-443.65,0,290.75>
  }
  triangle { // #2258
		<-443.65,0,290.75>,
		<-560.2,-0,468.9>,
		<-444,0,291.5>
  }
  triangle { // #2259
		<-444,0,291.5>,
		<-560.2,-0,468.9>,
		<-444.4,0,292.25>
  }
  triangle { // #2260
		<-444.4,0,292.25>,
		<-560.2,-0,468.9>,
		<-444.75,0,293.05>
  }
  triangle { // #2261
		<-444.75,0,293.05>,
		<-560.2,-0,468.9>,
		<-445.1,0,293.8>
  }
  triangle { // #2262
		<-445.1,0,293.8>,
		<-560.2,-0,468.9>,
		<-445.5,0,294.6>
  }
  triangle { // #2263
		<-445.5,0,294.6>,
		<-560.2,-0,468.9>,
		<-445.85,0,295.4>
  }
  triangle { // #2264
		<-445.85,0,295.4>,
		<-560.2,-0,468.9>,
		<-446.2,0,296.2>
  }
  triangle { // #2265
		<-446.2,0,296.2>,
		<-560.2,-0,468.9>,
		<-446.5,0,297.05>
  }
  triangle { // #2266
		<-446.5,0,297.05>,
		<-560.2,-0,468.9>,
		<-446.85,0,297.85>
  }
  triangle { // #2267
		<-446.85,0,297.85>,
		<-560.2,-0,468.9>,
		<-447.2,0,298.7>
  }
  triangle { // #2268
		<-447.2,0,298.7>,
		<-560.2,-0,468.9>,
		<-447.55,0,299.55>
  }
  triangle { // #2269
		<-447.55,0,299.55>,
		<-560.2,-0,468.9>,
		<-447.85,0,300.45>
  }
  triangle { // #2270
		<-447.85,0,300.45>,
		<-560.2,-0,468.9>,
		<-448.2,0,301.3>
  }
  triangle { // #2271
		<-448.2,0,301.3>,
		<-560.2,-0,468.9>,
		<-448.5,0,302.2>
  }
  triangle { // #2272
		<-448.5,0,302.2>,
		<-560.2,-0,468.9>,
		<-448.85,0,303.1>
  }
  triangle { // #2273
		<-448.85,0,303.1>,
		<-560.2,-0,468.9>,
		<-449.15,0,304>
  }
  triangle { // #2274
		<-449.15,0,304>,
		<-560.2,-0,468.9>,
		<-449.45,0,304.9>
  }
  triangle { // #2275
		<-449.45,0,304.9>,
		<-560.2,-0,468.9>,
		<-449.75,0,305.8>
  }
  triangle { // #2276
		<-449.75,0,305.8>,
		<-560.2,-0,468.9>,
		<-450.05,0,306.75>
  }
  triangle { // #2277
		<-450.05,0,306.75>,
		<-560.2,-0,468.9>,
		<-450.35,0,307.65>
  }
  triangle { // #2278
		<-450.35,0,307.65>,
		<-560.2,-0,468.9>,
		<-450.65,0,308.55>
  }
  triangle { // #2279
		<-450.65,0,308.55>,
		<-560.2,-0,468.9>,
		<-450.95,0,309.45>
  }
  triangle { // #2280
		<-450.95,0,309.45>,
		<-560.2,-0,468.9>,
		<-451.25,0,310.35>
  }
  triangle { // #2281
		<-451.25,0,310.35>,
		<-560.2,-0,468.9>,
		<-451.5,0,311.3>
  }
  triangle { // #2282
		<-451.5,0,311.3>,
		<-560.2,-0,468.9>,
		<-451.8,0,312.2>
  }
  triangle { // #2283
		<-451.8,0,312.2>,
		<-560.2,-0,468.9>,
		<-452.1,0,313.1>
  }
  triangle { // #2284
		<-452.1,0,313.1>,
		<-560.2,-0,468.9>,
		<-452.35,0,314>
  }
  triangle { // #2285
		<-452.35,0,314>,
		<-560.2,-0,468.9>,
		<-452.65,0,314.9>
  }
  triangle { // #2286
		<-452.65,0,314.9>,
		<-560.2,-0,468.9>,
		<-452.9,0,315.8>
  }
  triangle { // #2287
		<-452.9,0,315.8>,
		<-560.2,-0,468.9>,
		<-453.2,0,316.7>
  }
  triangle { // #2288
		<-453.2,0,316.7>,
		<-560.2,-0,468.9>,
		<-453.45,0,317.6>
  }
  triangle { // #2289
		<-453.45,0,317.6>,
		<-560.2,-0,468.9>,
		<-453.7,0,318.5>
  }
  triangle { // #2290
		<-453.7,0,318.5>,
		<-560.2,-0,468.9>,
		<-453.95,0,319.45>
  }
  triangle { // #2291
		<-453.95,0,319.45>,
		<-560.2,-0,468.9>,
		<-454.2,0,320.35>
  }
  triangle { // #2292
		<-454.2,0,320.35>,
		<-560.2,-0,468.9>,
		<-454.45,0,321.25>
  }
  triangle { // #2293
		<-454.45,0,321.25>,
		<-560.2,-0,468.9>,
		<-454.7,0,322.15>
  }
  triangle { // #2294
		<-454.7,0,322.15>,
		<-560.2,-0,468.9>,
		<-454.95,0,323.05>
  }
  triangle { // #2295
		<-454.95,0,323.05>,
		<-560.2,-0,468.9>,
		<-455.2,0,323.95>
  }
  triangle { // #2296
		<-455.2,0,323.95>,
		<-560.2,-0,468.9>,
		<-455.4,0,324.9>
  }
  triangle { // #2297
		<-455.4,0,324.9>,
		<-560.2,-0,468.9>,
		<-455.65,0,325.8>
  }
  triangle { // #2298
		<-455.65,0,325.8>,
		<-560.2,-0,468.9>,
		<-455.85,0,326.7>
  }
  triangle { // #2299
		<-455.85,0,326.7>,
		<-560.2,-0,468.9>,
		<-456.05,0,327.65>
  }
  triangle { // #2300
		<-456.05,0,327.65>,
		<-560.2,-0,468.9>,
		<-456.25,0,328.55>
  }
  triangle { // #2301
		<-456.25,0,328.55>,
		<-560.2,-0,468.9>,
		<-456.45,0,329.5>
  }
  triangle { // #2302
		<-456.45,0,329.5>,
		<-560.2,-0,468.9>,
		<-456.65,0,330.4>
  }
  triangle { // #2303
		<-456.65,0,330.4>,
		<-560.2,-0,468.9>,
		<-456.85,0,331.35>
  }
  triangle { // #2304
		<-456.85,0,331.35>,
		<-560.2,-0,468.9>,
		<-457.05,0,332.25>
  }
  triangle { // #2305
		<-457.05,0,332.25>,
		<-560.2,-0,468.9>,
		<-457.25,0,333.2>
  }
  triangle { // #2306
		<-457.25,0,333.2>,
		<-560.2,-0,468.9>,
		<-457.4,0,334.15>
  }
  triangle { // #2307
		<-457.4,0,334.15>,
		<-560.2,-0,468.9>,
		<-457.6,0,335.05>
  }
  triangle { // #2308
		<-457.6,0,335.05>,
		<-560.2,-0,468.9>,
		<-457.75,0,336>
  }
  triangle { // #2309
		<-457.75,0,336>,
		<-560.2,-0,468.9>,
		<-457.9,0,336.95>
  }
  triangle { // #2310
		<-457.9,0,336.95>,
		<-560.2,-0,468.9>,
		<-458.05,0,337.85>
  }
  triangle { // #2311
		<-458.05,0,337.85>,
		<-560.2,-0,468.9>,
		<-458.25,0,338.8>
  }
  triangle { // #2312
		<-458.25,0,338.8>,
		<-560.2,-0,468.9>,
		<-458.4,0,339.75>
  }
  triangle { // #2313
		<-458.4,0,339.75>,
		<-560.2,-0,468.9>,
		<-458.5,0,340.7>
  }
  triangle { // #2314
		<-458.5,0,340.7>,
		<-560.2,-0,468.9>,
		<-458.65,0,341.65>
  }
  triangle { // #2315
		<-458.65,0,341.65>,
		<-560.2,-0,468.9>,
		<-458.8,0,342.6>
  }
  triangle { // #2316
		<-458.8,0,342.6>,
		<-560.2,-0,468.9>,
		<-458.95,0,343.55>
  }
  triangle { // #2317
		<-458.95,0,343.55>,
		<-560.2,-0,468.9>,
		<-459.05,0,344.45>
  }
  triangle { // #2318
		<-459.05,0,344.45>,
		<-560.2,-0,468.9>,
		<-459.2,0,345.4>
  }
  triangle { // #2319
		<-459.2,0,345.4>,
		<-560.2,-0,468.9>,
		<-459.3,0,346.35>
  }
  triangle { // #2320
		<-459.3,0,346.35>,
		<-560.2,-0,468.9>,
		<-459.4,0,347.3>
  }
  triangle { // #2321
		<-459.4,0,347.3>,
		<-560.2,-0,468.9>,
		<-459.55,0,348.25>
  }
  triangle { // #2322
		<-459.55,0,348.25>,
		<-560.2,-0,468.9>,
		<-459.65,0,349.25>
  }
  triangle { // #2323
		<-459.65,0,349.25>,
		<-560.2,-0,468.9>,
		<-459.75,0,350.2>
  }
  triangle { // #2324
		<-459.75,0,350.2>,
		<-560.2,-0,468.9>,
		<-459.85,0,351.15>
  }
  triangle { // #2325
		<-459.85,0,351.15>,
		<-560.2,-0,468.9>,
		<-460,0,352.1>
  }
  triangle { // #2326
		<-460,0,352.1>,
		<-560.2,-0,468.9>,
		<-460.1,0,353>
  }
  triangle { // #2327
		<-460.1,0,353>,
		<-560.2,-0,468.9>,
		<-460.25,0,353.95>
  }
  triangle { // #2328
		<-460.25,0,353.95>,
		<-560.2,-0,468.9>,
		<-460.4,0,354.9>
  }
  triangle { // #2329
		<-460.4,0,354.9>,
		<-560.2,-0,468.9>,
		<-460.5,0,355.85>
  }
  triangle { // #2330
		<-460.5,0,355.85>,
		<-560.2,-0,468.9>,
		<-460.65,0,356.8>
  }
  triangle { // #2331
		<-460.65,0,356.8>,
		<-560.2,-0,468.9>,
		<-460.8,0,357.75>
  }
  triangle { // #2332
		<-460.8,0,357.75>,
		<-560.2,-0,468.9>,
		<-460.95,0,358.7>
  }
  triangle { // #2333
		<-460.95,0,358.7>,
		<-560.2,-0,468.9>,
		<-461.1,0,359.6>
  }
  triangle { // #2334
		<-461.1,0,359.6>,
		<-560.2,-0,468.9>,
		<-461.3,0,360.55>
  }
  triangle { // #2335
		<-461.3,0,360.55>,
		<-560.2,-0,468.9>,
		<-461.45,0,361.5>
  }
  triangle { // #2336
		<-461.45,0,361.5>,
		<-560.2,-0,468.9>,
		<-461.6,0,362.4>
  }
  triangle { // #2337
		<-461.6,0,362.4>,
		<-560.2,-0,468.9>,
		<-461.8,0,363.35>
  }
  triangle { // #2338
		<-461.8,0,363.35>,
		<-560.2,-0,468.9>,
		<-461.95,0,364.3>
  }
  triangle { // #2339
		<-461.95,0,364.3>,
		<-560.2,-0,468.9>,
		<-462.15,0,365.2>
  }
  triangle { // #2340
		<-462.15,0,365.2>,
		<-560.2,-0,468.9>,
		<-462.3,0,366.15>
  }
  triangle { // #2341
		<-462.3,0,366.15>,
		<-560.2,-0,468.9>,
		<-462.45,0,367.1>
  }
  triangle { // #2342
		<-462.45,0,367.1>,
		<-560.2,-0,468.9>,
		<-462.65,0,368.05>
  }
  triangle { // #2343
		<-462.65,0,368.05>,
		<-560.2,-0,468.9>,
		<-462.8,0,368.95>
  }
  triangle { // #2344
		<-462.8,0,368.95>,
		<-560.2,-0,468.9>,
		<-462.95,0,369.9>
  }
  triangle { // #2345
		<-462.95,0,369.9>,
		<-560.2,-0,468.9>,
		<-463.1,0,370.85>
  }
  triangle { // #2346
		<-463.1,0,370.85>,
		<-560.2,-0,468.9>,
		<-463.25,0,371.8>
  }
  triangle { // #2347
		<-463.25,0,371.8>,
		<-560.2,-0,468.9>,
		<-463.45,0,372.7>
  }
  triangle { // #2348
		<-463.45,0,372.7>,
		<-560.2,-0,468.9>,
		<-463.6,0,373.65>
  }
  triangle { // #2349
		<-463.6,0,373.65>,
		<-560.2,-0,468.9>,
		<-463.7,0,374.6>
  }
  triangle { // #2350
		<-463.7,0,374.6>,
		<-560.2,-0,468.9>,
		<-463.85,0,375.55>
  }
  triangle { // #2351
		<-463.85,0,375.55>,
		<-560.2,-0,468.9>,
		<-464,0,376.5>
  }
  triangle { // #2352
		<-464,0,376.5>,
		<-560.2,-0,468.9>,
		<-464.15,0,377.45>
  }
  triangle { // #2353
		<-464.15,0,377.45>,
		<-560.2,-0,468.9>,
		<-464.3,0,378.35>
  }
  triangle { // #2354
		<-464.3,0,378.35>,
		<-560.2,-0,468.9>,
		<-464.45,0,379.3>
  }
  triangle { // #2355
		<-464.45,0,379.3>,
		<-560.2,-0,468.9>,
		<-464.55,0,380.25>
  }
  triangle { // #2356
		<-464.55,0,380.25>,
		<-560.2,-0,468.9>,
		<-464.7,0,381.2>
  }
  triangle { // #2357
		<-464.7,0,381.2>,
		<-560.2,-0,468.9>,
		<-464.85,0,382.15>
  }
  triangle { // #2358
		<-464.85,0,382.15>,
		<-560.2,-0,468.9>,
		<-465,0,383.1>
  }
  triangle { // #2359
		<-465,0,383.1>,
		<-560.2,-0,468.9>,
		<-465.15,0,384.05>
  }
  triangle { // #2360
		<-465.15,0,384.05>,
		<-560.2,-0,468.9>,
		<-465.25,0,384.95>
  }
  triangle { // #2361
		<-465.25,0,384.95>,
		<-560.2,-0,468.9>,
		<-465.4,0,385.9>
  }
  triangle { // #2362
		<-465.4,0,385.9>,
		<-560.2,-0,468.9>,
		<-465.55,0,386.85>
  }
  triangle { // #2363
		<-465.55,0,386.85>,
		<-560.2,-0,468.9>,
		<-465.7,0,387.8>
  }
  triangle { // #2364
		<-465.7,0,387.8>,
		<-560.2,-0,468.9>,
		<-465.85,0,388.75>
  }
  triangle { // #2365
		<-465.85,0,388.75>,
		<-560.2,-0,468.9>,
		<-466,0,389.7>
  }
  triangle { // #2366
		<-466,0,389.7>,
		<-560.2,-0,468.9>,
		<-466.15,0,390.6>
  }
  triangle { // #2367
		<-466.15,0,390.6>,
		<-560.2,-0,468.9>,
		<-466.3,0,391.55>
  }
  triangle { // #2368
		<-466.3,0,391.55>,
		<-560.2,-0,468.9>,
		<-466.45,0,392.5>
  }
  triangle { // #2369
		<-466.45,0,392.5>,
		<-560.2,-0,468.9>,
		<-466.6,0,393.45>
  }
  triangle { // #2370
		<-466.6,0,393.45>,
		<-560.2,-0,468.9>,
		<-466.75,0,394.35>
  }
  triangle { // #2371
		<-466.75,0,394.35>,
		<-560.2,-0,468.9>,
		<-466.95,0,395.3>
  }
  triangle { // #2372
		<-466.95,0,395.3>,
		<-560.2,-0,468.9>,
		<-467.1,0,396.25>
  }
  triangle { // #2373
		<-467.1,0,396.25>,
		<-560.2,-0,468.9>,
		<-467.25,0,397.2>
  }
  triangle { // #2374
		<-467.25,0,397.2>,
		<-560.2,-0,468.9>,
		<-467.45,0,398.1>
  }
  triangle { // #2375
		<-467.45,0,398.1>,
		<-560.2,-0,468.9>,
		<-467.65,0,399.05>
  }
  triangle { // #2376
		<-467.65,0,399.05>,
		<-560.2,-0,468.9>,
		<-467.8,0,399.95>
  }
  triangle { // #2377
		<-467.8,0,399.95>,
		<-560.2,-0,468.9>,
		<-468,0,400.9>
  }
  triangle { // #2378
		<-468,0,400.9>,
		<-560.2,-0,468.9>,
		<-468.2,0,401.8>
  }
  triangle { // #2379
		<-468.2,0,401.8>,
		<-560.2,-0,468.9>,
		<-468.4,0,402.75>
  }
  triangle { // #2380
		<-468.4,0,402.75>,
		<-560.2,-0,468.9>,
		<-468.65,0,403.65>
  }
  triangle { // #2381
		<-468.65,0,403.65>,
		<-560.2,-0,468.9>,
		<-468.85,0,404.6>
  }
  triangle { // #2382
		<-468.85,0,404.6>,
		<-560.2,-0,468.9>,
		<-469.05,0,405.5>
  }
  triangle { // #2383
		<-469.05,0,405.5>,
		<-560.2,-0,468.9>,
		<-469.3,0,406.4>
  }
  triangle { // #2384
		<-469.3,0,406.4>,
		<-560.2,-0,468.9>,
		<-469.5,0,407.35>
  }
  triangle { // #2385
		<-469.5,0,407.35>,
		<-560.2,-0,468.9>,
		<-469.75,0,408.25>
  }
  triangle { // #2386
		<-469.75,0,408.25>,
		<-560.2,-0,468.9>,
		<-470,0,409.15>
  }
  triangle { // #2387
		<-470,0,409.15>,
		<-560.2,-0,468.9>,
		<-470.25,0,410.05>
  }
  triangle { // #2388
		<-470.25,0,410.05>,
		<-560.2,-0,468.9>,
		<-470.55,0,410.95>
  }
  triangle { // #2389
		<-470.55,0,410.95>,
		<-560.2,-0,468.9>,
		<-470.85,0,411.85>
  }
  triangle { // #2390
		<-470.85,0,411.85>,
		<-560.2,-0,468.9>,
		<-471.15,0,412.75>
  }
  triangle { // #2391
		<-471.15,0,412.75>,
		<-560.2,-0,468.9>,
		<-471.45,0,413.65>
  }
  triangle { // #2392
		<-471.45,0,413.65>,
		<-560.2,-0,468.9>,
		<-471.75,0,414.55>
  }
  triangle { // #2393
		<-471.75,0,414.55>,
		<-560.2,-0,468.9>,
		<-472.1,0,415.4>
  }
  triangle { // #2394
		<-472.1,0,415.4>,
		<-560.2,-0,468.9>,
		<-472.45,0,416.3>
  }
  triangle { // #2395
		<-472.45,0,416.3>,
		<-560.2,-0,468.9>,
		<-472.85,0,417.15>
  }
  triangle { // #2396
		<-472.85,0,417.15>,
		<-560.2,-0,468.9>,
		<-473.2,0,418.05>
  }
  triangle { // #2397
		<-473.2,0,418.05>,
		<-560.2,-0,468.9>,
		<-473.6,0,418.9>
  }
  triangle { // #2398
		<-473.6,0,418.9>,
		<-560.2,-0,468.9>,
		<-474,0,419.75>
  }
  triangle { // #2399
		<-474,0,419.75>,
		<-560.2,-0,468.9>,
		<-474.45,0,420.6>
  }
  triangle { // #2400
		<-474.45,0,420.6>,
		<-560.2,-0,468.9>,
		<-474.9,0,421.5>
  }
  triangle { // #2401
		<-474.9,0,421.5>,
		<-560.2,-0,468.9>,
		<-475.35,0,422.35>
  }
  triangle { // #2402
		<-475.35,0,422.35>,
		<-560.2,-0,468.9>,
		<-475.8,0,423.15>
  }
  triangle { // #2403
		<-475.8,0,423.15>,
		<-560.2,-0,468.9>,
		<-476.25,0,424>
  }
  triangle { // #2404
		<-476.25,0,424>,
		<-560.2,-0,468.9>,
		<-476.75,0,424.85>
  }
  triangle { // #2405
		<-476.75,0,424.85>,
		<-560.2,-0,468.9>,
		<-477.2,0,425.7>
  }
  triangle { // #2406
		<-477.2,0,425.7>,
		<-560.2,-0,468.9>,
		<-477.7,0,426.55>
  }
  triangle { // #2407
		<-477.7,0,426.55>,
		<-560.2,-0,468.9>,
		<-478.2,0,427.35>
  }
  triangle { // #2408
		<-478.2,0,427.35>,
		<-560.2,-0,468.9>,
		<-478.7,0,428.2>
  }
  triangle { // #2409
		<-478.7,0,428.2>,
		<-560.2,-0,468.9>,
		<-479.2,0,429>
  }
  triangle { // #2410
		<-479.2,0,429>,
		<-560.2,-0,468.9>,
		<-479.75,0,429.85>
  }
  triangle { // #2411
		<-479.75,0,429.85>,
		<-560.2,-0,468.9>,
		<-480.25,0,430.65>
  }
  triangle { // #2412
		<-480.25,0,430.65>,
		<-560.2,-0,468.9>,
		<-480.8,0,431.5>
  }
  triangle { // #2413
		<-480.8,0,431.5>,
		<-560.2,-0,468.9>,
		<-481.35,0,432.3>
  }
  triangle { // #2414
		<-481.35,0,432.3>,
		<-560.2,-0,468.9>,
		<-481.9,0,433.15>
  }
  triangle { // #2415
		<-481.9,0,433.15>,
		<-560.2,-0,468.9>,
		<-482.45,0,433.95>
  }
  triangle { // #2416
		<-482.45,0,433.95>,
		<-560.2,-0,468.9>,
		<-483.05,0,434.75>
  }
  triangle { // #2417
		<-483.05,0,434.75>,
		<-560.2,-0,468.9>,
		<-483.6,0,435.55>
  }
  triangle { // #2418
		<-483.6,0,435.55>,
		<-560.2,-0,468.9>,
		<-484.2,0,436.35>
  }
  triangle { // #2419
		<-484.2,0,436.35>,
		<-560.2,-0,468.9>,
		<-484.8,0,437.15>
  }
  triangle { // #2420
		<-484.8,0,437.15>,
		<-560.2,-0,468.9>,
		<-485.45,0,437.95>
  }
  triangle { // #2421
		<-485.45,0,437.95>,
		<-560.2,-0,468.9>,
		<-486.1,0,438.75>
  }
  triangle { // #2422
		<-486.1,0,438.75>,
		<-560.2,-0,468.9>,
		<-486.75,0,439.55>
  }
  triangle { // #2423
		<-486.75,0,439.55>,
		<-560.2,-0,468.9>,
		<-487.45,0,440.3>
  }
  triangle { // #2424
		<-487.45,0,440.3>,
		<-560.2,-0,468.9>,
		<-488.15,0,441.1>
  }
  triangle { // #2425
		<-488.15,0,441.1>,
		<-560.2,-0,468.9>,
		<-488.9,0,441.85>
  }
  triangle { // #2426
		<-488.9,0,441.85>,
		<-560.2,-0,468.9>,
		<-489.65,0,442.6>
  }
  triangle { // #2427
		<-489.65,0,442.6>,
		<-560.2,-0,468.9>,
		<-490.4,0,443.35>
  }
  triangle { // #2428
		<-490.4,0,443.35>,
		<-560.2,-0,468.9>,
		<-491.15,0,444.15>
  }
  triangle { // #2429
		<-491.15,0,444.15>,
		<-560.2,-0,468.9>,
		<-492,0,444.9>
  }
  triangle { // #2430
		<-492,0,444.9>,
		<-560.2,-0,468.9>,
		<-492.8,0,445.6>
  }
  triangle { // #2431
		<-492.8,0,445.6>,
		<-560.2,-0,468.9>,
		<-493.65,0,446.35>
  }
  triangle { // #2432
		<-493.65,0,446.35>,
		<-560.2,-0,468.9>,
		<-494.5,0,447.1>
  }
  triangle { // #2433
		<-494.5,0,447.1>,
		<-560.2,-0,468.9>,
		<-495.4,0,447.85>
  }
  triangle { // #2434
		<-495.4,0,447.85>,
		<-560.2,-0,468.9>,
		<-496.25,0,448.55>
  }
  triangle { // #2435
		<-496.25,0,448.55>,
		<-560.2,-0,468.9>,
		<-497.15,0,449.25>
  }
  triangle { // #2436
		<-497.15,0,449.25>,
		<-560.2,-0,468.9>,
		<-498.1,0,449.95>
  }
  triangle { // #2437
		<-498.1,0,449.95>,
		<-560.2,-0,468.9>,
		<-499,0,450.65>
  }
  triangle { // #2438
		<-499,0,450.65>,
		<-560.2,-0,468.9>,
		<-499.95,0,451.35>
  }
  triangle { // #2439
		<-499.95,0,451.35>,
		<-560.2,-0,468.9>,
		<-500.85,0,452.05>
  }
  triangle { // #2440
		<-500.85,0,452.05>,
		<-560.2,-0,468.9>,
		<-501.8,0,452.7>
  }
  triangle { // #2441
		<-501.8,0,452.7>,
		<-560.2,-0,468.9>,
		<-502.75,0,453.4>
  }
  triangle { // #2442
		<-502.75,0,453.4>,
		<-560.2,-0,468.9>,
		<-503.7,0,454.05>
  }
  triangle { // #2443
		<-503.7,0,454.05>,
		<-560.2,-0,468.9>,
		<-504.7,0,454.7>
  }
  triangle { // #2444
		<-504.7,0,454.7>,
		<-560.2,-0,468.9>,
		<-505.65,0,455.35>
  }
  triangle { // #2445
		<-505.65,0,455.35>,
		<-560.2,-0,468.9>,
		<-506.65,-0,456>
  }
  triangle { // #2446
		<-506.65,-0,456>,
		<-560.2,-0,468.9>,
		<-507.65,-0,456.6>
  }
  triangle { // #2447
		<-507.65,-0,456.6>,
		<-560.2,-0,468.9>,
		<-508.65,-0,457.25>
  }
  triangle { // #2448
		<-508.65,-0,457.25>,
		<-560.2,-0,468.9>,
		<-509.65,-0,457.85>
  }
  triangle { // #2449
		<-509.65,-0,457.85>,
		<-560.2,-0,468.9>,
		<-510.65,-0,458.45>
  }
  triangle { // #2450
		<-510.65,-0,458.45>,
		<-560.2,-0,468.9>,
		<-511.7,-0,459.05>
  }
  triangle { // #2451
		<-511.7,-0,459.05>,
		<-560.2,-0,468.9>,
		<-512.8,-0,459.65>
  }
  triangle { // #2452
		<-512.8,-0,459.65>,
		<-560.2,-0,468.9>,
		<-513.95,-0,460.3>
  }
  triangle { // #2453
		<-513.95,-0,460.3>,
		<-560.2,-0,468.9>,
		<-515.15,-0,460.9>
  }
  triangle { // #2454
		<-515.15,-0,460.9>,
		<-560.2,-0,468.9>,
		<-516.4,-0,461.5>
  }
  triangle { // #2455
		<-516.4,-0,461.5>,
		<-560.2,-0,468.9>,
		<-517.7,-0,462.15>
  }
  triangle { // #2456
		<-517.7,-0,462.15>,
		<-560.2,-0,468.9>,
		<-519.05,-0,462.8>
  }
  triangle { // #2457
		<-519.05,-0,462.8>,
		<-560.2,-0,468.9>,
		<-520.45,-0,463.4>
  }
  triangle { // #2458
		<-520.45,-0,463.4>,
		<-560.2,-0,468.9>,
		<-521.9,-0,464.05>
  }
  triangle { // #2459
		<-521.9,-0,464.05>,
		<-560.2,-0,468.9>,
		<-523.4,-0,464.7>
  }
  triangle { // #2460
		<-523.4,-0,464.7>,
		<-560.2,-0,468.9>,
		<-524.95,-0,465.35>
  }
  triangle { // #2461
		<-524.95,-0,465.35>,
		<-560.2,-0,468.9>,
		<-526.55,-0,466>
  }
  triangle { // #2462
		<-526.55,-0,466>,
		<-560.2,-0,468.9>,
		<-528.2,-0,466.7>
  }
  triangle { // #2463
		<-528.2,-0,466.7>,
		<-560.2,-0,468.9>,
		<-529.9,-0,467.35>
  }
  triangle { // #2464
		<-529.9,-0,467.35>,
		<-560.2,-0,468.9>,
		<-531.65,-0,468>
  }
  triangle { // #2465
		<-531.65,-0,468>,
		<-560.2,-0,468.9>,
		<-533.45,-0,468.7>
  }
  triangle { // #2466
		<-560.2,-0,468.9>,
		<-558.65,-0,469.35>,
		<-533.45,-0,468.7>
  }
  triangle { // #2467
		<-558.65,-0,469.35>,
		<-556.6,-0,469.9>,
		<-533.45,-0,468.7>
  }
  triangle { // #2468
		<-556.6,-0,469.9>,
		<-554.6,-0,470.35>,
		<-533.45,-0,468.7>
  }
  triangle { // #2469
		<-554.6,-0,470.35>,
		<-552.6,-0,470.65>,
		<-533.45,-0,468.7>
  }
  triangle { // #2470
		<-552.6,-0,470.65>,
		<-550.6,-0,470.9>,
		<-533.45,-0,468.7>
  }
  triangle { // #2471
		<-550.6,-0,470.9>,
		<-548.6,-0,471.05>,
		<-533.45,-0,468.7>
  }
  triangle { // #2472
		<-548.6,-0,471.05>,
		<-546.65,-0,471.1>,
		<-533.45,-0,468.7>
  }
  triangle { // #2473
		<-546.65,-0,471.1>,
		<-544.7,-0,471.05>,
		<-533.45,-0,468.7>
  }
  triangle { // #2474
		<-533.45,-0,468.7>,
		<-544.7,-0,471.05>,
		<-535.3,-0,469.35>
  }
  triangle { // #2475
		<-544.7,-0,471.05>,
		<-542.8,-0,470.9>,
		<-535.3,-0,469.35>
  }
  triangle { // #2476
		<-535.3,-0,469.35>,
		<-542.8,-0,470.9>,
		<-537.15,-0,469.85>
  }
  triangle { // #2477
		<-542.8,-0,470.9>,
		<-540.9,-0,470.65>,
		<-537.15,-0,469.85>
  }
  triangle { // #2478
		<-539,-99,470.3>,
		<-540.9,-99,470.65>,
		<-537.15,-99,469.85>
  }
  triangle { // #2479
		<-435.1,-99,272.6>,
		<-435.8,-99,274.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2480
		<-435.8,-99,274.1>,
		<-436.45,-99,275.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2481
		<-436.45,-99,275.55>,
		<-437.1,-99,276.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2482
		<-437.1,-99,276.95>,
		<-437.75,-99,278.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2483
		<-437.75,-99,278.3>,
		<-438.35,-99,279.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2484
		<-438.35,-99,279.6>,
		<-438.9,-99,280.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2485
		<-438.9,-99,280.85>,
		<-439.45,-99,282.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2486
		<-439.45,-99,282.1>,
		<-440,-99,283.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2487
		<-440,-99,283.25>,
		<-440.55,-99,284.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2488
		<-440.55,-99,284.35>,
		<-441.05,-99,285.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2489
		<-441.05,-99,285.4>,
		<-441.55,-99,286.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2490
		<-441.55,-99,286.45>,
		<-442,-99,287.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2491
		<-442,-99,287.4>,
		<-442.45,-99,288.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2492
		<-442.45,-99,288.3>,
		<-442.85,-99,289.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2493
		<-442.85,-99,289.15>,
		<-443.25,-99,290>,
		<-560.2,-99,468.9>
  }
  triangle { // #2494
		<-443.25,-99,290>,
		<-443.65,-99,290.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2495
		<-443.65,-99,290.75>,
		<-444,-99,291.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2496
		<-444,-99,291.5>,
		<-444.4,-99,292.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2497
		<-444.4,-99,292.25>,
		<-444.75,-99,293.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2498
		<-444.75,-99,293.05>,
		<-445.1,-99,293.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2499
		<-445.1,-99,293.8>,
		<-445.5,-99,294.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2500
		<-445.5,-99,294.6>,
		<-445.85,-99,295.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2501
		<-445.85,-99,295.4>,
		<-446.2,-99,296.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2502
		<-446.2,-99,296.2>,
		<-446.5,-99,297.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2503
		<-446.5,-99,297.05>,
		<-446.85,-99,297.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2504
		<-446.85,-99,297.85>,
		<-447.2,-99,298.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2505
		<-447.2,-99,298.7>,
		<-447.55,-99,299.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2506
		<-447.55,-99,299.55>,
		<-447.85,-99,300.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2507
		<-447.85,-99,300.45>,
		<-448.2,-99,301.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2508
		<-448.2,-99,301.3>,
		<-448.5,-99,302.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2509
		<-448.5,-99,302.2>,
		<-448.85,-99,303.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2510
		<-448.85,-99,303.1>,
		<-449.15,-99,304>,
		<-560.2,-99,468.9>
  }
  triangle { // #2511
		<-449.15,-99,304>,
		<-449.45,-99,304.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2512
		<-449.45,-99,304.9>,
		<-449.75,-99,305.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2513
		<-449.75,-99,305.8>,
		<-450.05,-99,306.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2514
		<-450.05,-99,306.75>,
		<-450.35,-99,307.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2515
		<-450.35,-99,307.65>,
		<-450.65,-99,308.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2516
		<-450.65,-99,308.55>,
		<-450.95,-99,309.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2517
		<-450.95,-99,309.45>,
		<-451.25,-99,310.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2518
		<-451.25,-99,310.35>,
		<-451.5,-99,311.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2519
		<-451.5,-99,311.3>,
		<-451.8,-99,312.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2520
		<-451.8,-99,312.2>,
		<-452.1,-99,313.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2521
		<-452.1,-99,313.1>,
		<-452.35,-99,314>,
		<-560.2,-99,468.9>
  }
  triangle { // #2522
		<-452.35,-99,314>,
		<-452.65,-99,314.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2523
		<-452.65,-99,314.9>,
		<-452.9,-99,315.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2524
		<-452.9,-99,315.8>,
		<-453.2,-99,316.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2525
		<-453.2,-99,316.7>,
		<-453.45,-99,317.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2526
		<-453.45,-99,317.6>,
		<-453.7,-99,318.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2527
		<-453.7,-99,318.5>,
		<-453.95,-99,319.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2528
		<-453.95,-99,319.45>,
		<-454.2,-99,320.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2529
		<-454.2,-99,320.35>,
		<-454.45,-99,321.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2530
		<-454.45,-99,321.25>,
		<-454.7,-99,322.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2531
		<-454.7,-99,322.15>,
		<-454.95,-99,323.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2532
		<-454.95,-99,323.05>,
		<-455.2,-99,323.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2533
		<-455.2,-99,323.95>,
		<-455.4,-99,324.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2534
		<-455.4,-99,324.9>,
		<-455.65,-99,325.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2535
		<-455.65,-99,325.8>,
		<-455.85,-99,326.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2536
		<-455.85,-99,326.7>,
		<-456.05,-99,327.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2537
		<-456.05,-99,327.65>,
		<-456.25,-99,328.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2538
		<-456.25,-99,328.55>,
		<-456.45,-99,329.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2539
		<-456.45,-99,329.5>,
		<-456.65,-99,330.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2540
		<-456.65,-99,330.4>,
		<-456.85,-99,331.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2541
		<-456.85,-99,331.35>,
		<-457.05,-99,332.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2542
		<-457.05,-99,332.25>,
		<-457.25,-99,333.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2543
		<-457.25,-99,333.2>,
		<-457.4,-99,334.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2544
		<-457.4,-99,334.15>,
		<-457.6,-99,335.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2545
		<-457.6,-99,335.05>,
		<-457.75,-99,336>,
		<-560.2,-99,468.9>
  }
  triangle { // #2546
		<-457.75,-99,336>,
		<-457.9,-99,336.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2547
		<-457.9,-99,336.95>,
		<-458.05,-99,337.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2548
		<-458.05,-99,337.85>,
		<-458.25,-99,338.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2549
		<-458.25,-99,338.8>,
		<-458.4,-99,339.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2550
		<-458.4,-99,339.75>,
		<-458.5,-99,340.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2551
		<-458.5,-99,340.7>,
		<-458.65,-99,341.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2552
		<-458.65,-99,341.65>,
		<-458.8,-99,342.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2553
		<-458.8,-99,342.6>,
		<-458.95,-99,343.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2554
		<-458.95,-99,343.55>,
		<-459.05,-99,344.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2555
		<-459.05,-99,344.45>,
		<-459.2,-99,345.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2556
		<-459.2,-99,345.4>,
		<-459.3,-99,346.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2557
		<-459.3,-99,346.35>,
		<-459.4,-99,347.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2558
		<-459.4,-99,347.3>,
		<-459.55,-99,348.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2559
		<-459.55,-99,348.25>,
		<-459.65,-99,349.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2560
		<-459.65,-99,349.25>,
		<-459.75,-99,350.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2561
		<-459.75,-99,350.2>,
		<-459.85,-99,351.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2562
		<-459.85,-99,351.15>,
		<-460,-99,352.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2563
		<-460,-99,352.1>,
		<-460.1,-99,353>,
		<-560.2,-99,468.9>
  }
  triangle { // #2564
		<-460.1,-99,353>,
		<-460.25,-99,353.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2565
		<-460.25,-99,353.95>,
		<-460.4,-99,354.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2566
		<-460.4,-99,354.9>,
		<-460.5,-99,355.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2567
		<-460.5,-99,355.85>,
		<-460.65,-99,356.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2568
		<-460.65,-99,356.8>,
		<-460.8,-99,357.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2569
		<-460.8,-99,357.75>,
		<-460.95,-99,358.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2570
		<-460.95,-99,358.7>,
		<-461.1,-99,359.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2571
		<-461.1,-99,359.6>,
		<-461.3,-99,360.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2572
		<-461.3,-99,360.55>,
		<-461.45,-99,361.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2573
		<-461.45,-99,361.5>,
		<-461.6,-99,362.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2574
		<-461.6,-99,362.4>,
		<-461.8,-99,363.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2575
		<-461.8,-99,363.35>,
		<-461.95,-99,364.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2576
		<-461.95,-99,364.3>,
		<-462.15,-99,365.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2577
		<-462.15,-99,365.2>,
		<-462.3,-99,366.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2578
		<-462.3,-99,366.15>,
		<-462.45,-99,367.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2579
		<-462.45,-99,367.1>,
		<-462.65,-99,368.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2580
		<-462.65,-99,368.05>,
		<-462.8,-99,368.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2581
		<-462.8,-99,368.95>,
		<-462.95,-99,369.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2582
		<-462.95,-99,369.9>,
		<-463.1,-99,370.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2583
		<-463.1,-99,370.85>,
		<-463.25,-99,371.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2584
		<-463.25,-99,371.8>,
		<-463.45,-99,372.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2585
		<-463.45,-99,372.7>,
		<-463.6,-99,373.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2586
		<-463.6,-99,373.65>,
		<-463.7,-99,374.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2587
		<-463.7,-99,374.6>,
		<-463.85,-99,375.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2588
		<-463.85,-99,375.55>,
		<-464,-99,376.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2589
		<-464,-99,376.5>,
		<-464.15,-99,377.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2590
		<-464.15,-99,377.45>,
		<-464.3,-99,378.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2591
		<-464.3,-99,378.35>,
		<-464.45,-99,379.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2592
		<-464.45,-99,379.3>,
		<-464.55,-99,380.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2593
		<-464.55,-99,380.25>,
		<-464.7,-99,381.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2594
		<-464.7,-99,381.2>,
		<-464.85,-99,382.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2595
		<-464.85,-99,382.15>,
		<-465,-99,383.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2596
		<-465,-99,383.1>,
		<-465.15,-99,384.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2597
		<-465.15,-99,384.05>,
		<-465.25,-99,384.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2598
		<-465.25,-99,384.95>,
		<-465.4,-99,385.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2599
		<-465.4,-99,385.9>,
		<-465.55,-99,386.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2600
		<-465.55,-99,386.85>,
		<-465.7,-99,387.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2601
		<-465.7,-99,387.8>,
		<-465.85,-99,388.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2602
		<-465.85,-99,388.75>,
		<-466,-99,389.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2603
		<-466,-99,389.7>,
		<-466.15,-99,390.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2604
		<-466.15,-99,390.6>,
		<-466.3,-99,391.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2605
		<-466.3,-99,391.55>,
		<-466.45,-99,392.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2606
		<-466.45,-99,392.5>,
		<-466.6,-99,393.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2607
		<-466.6,-99,393.45>,
		<-466.75,-99,394.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2608
		<-466.75,-99,394.35>,
		<-466.95,-99,395.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2609
		<-466.95,-99,395.3>,
		<-467.1,-99,396.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2610
		<-467.1,-99,396.25>,
		<-467.25,-99,397.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2611
		<-467.25,-99,397.2>,
		<-467.45,-99,398.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2612
		<-467.45,-99,398.1>,
		<-467.65,-99,399.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2613
		<-467.65,-99,399.05>,
		<-467.8,-99,399.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2614
		<-467.8,-99,399.95>,
		<-468,-99,400.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2615
		<-468,-99,400.9>,
		<-468.2,-99,401.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2616
		<-468.2,-99,401.8>,
		<-468.4,-99,402.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2617
		<-468.4,-99,402.75>,
		<-468.65,-99,403.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2618
		<-468.65,-99,403.65>,
		<-468.85,-99,404.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2619
		<-468.85,-99,404.6>,
		<-469.05,-99,405.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2620
		<-469.05,-99,405.5>,
		<-469.3,-99,406.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2621
		<-469.3,-99,406.4>,
		<-469.5,-99,407.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2622
		<-469.5,-99,407.35>,
		<-469.75,-99,408.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2623
		<-469.75,-99,408.25>,
		<-470,-99,409.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2624
		<-470,-99,409.15>,
		<-470.25,-99,410.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2625
		<-470.25,-99,410.05>,
		<-470.55,-99,410.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2626
		<-470.55,-99,410.95>,
		<-470.85,-99,411.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2627
		<-470.85,-99,411.85>,
		<-471.15,-99,412.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2628
		<-471.15,-99,412.75>,
		<-471.45,-99,413.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2629
		<-471.45,-99,413.65>,
		<-471.75,-99,414.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2630
		<-471.75,-99,414.55>,
		<-472.1,-99,415.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2631
		<-472.1,-99,415.4>,
		<-472.45,-99,416.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2632
		<-472.45,-99,416.3>,
		<-472.85,-99,417.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2633
		<-472.85,-99,417.15>,
		<-473.2,-99,418.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2634
		<-473.2,-99,418.05>,
		<-473.6,-99,418.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2635
		<-473.6,-99,418.9>,
		<-474,-99,419.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2636
		<-474,-99,419.75>,
		<-474.45,-99,420.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2637
		<-474.45,-99,420.6>,
		<-474.9,-99,421.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2638
		<-474.9,-99,421.5>,
		<-475.35,-99,422.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2639
		<-475.35,-99,422.35>,
		<-475.8,-99,423.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2640
		<-475.8,-99,423.15>,
		<-476.25,-99,424>,
		<-560.2,-99,468.9>
  }
  triangle { // #2641
		<-476.25,-99,424>,
		<-476.75,-99,424.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2642
		<-476.75,-99,424.85>,
		<-477.2,-99,425.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2643
		<-477.2,-99,425.7>,
		<-477.7,-99,426.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2644
		<-477.7,-99,426.55>,
		<-478.2,-99,427.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2645
		<-478.2,-99,427.35>,
		<-478.7,-99,428.2>,
		<-560.2,-99,468.9>
  }
  triangle { // #2646
		<-478.7,-99,428.2>,
		<-479.2,-99,429>,
		<-560.2,-99,468.9>
  }
  triangle { // #2647
		<-479.2,-99,429>,
		<-479.75,-99,429.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2648
		<-479.75,-99,429.85>,
		<-480.25,-99,430.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2649
		<-480.25,-99,430.65>,
		<-480.8,-99,431.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2650
		<-480.8,-99,431.5>,
		<-481.35,-99,432.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2651
		<-481.35,-99,432.3>,
		<-481.9,-99,433.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2652
		<-481.9,-99,433.15>,
		<-482.45,-99,433.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2653
		<-482.45,-99,433.95>,
		<-483.05,-99,434.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2654
		<-483.05,-99,434.75>,
		<-483.6,-99,435.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2655
		<-483.6,-99,435.55>,
		<-484.2,-99,436.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2656
		<-484.2,-99,436.35>,
		<-484.8,-99,437.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2657
		<-484.8,-99,437.15>,
		<-485.45,-99,437.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2658
		<-485.45,-99,437.95>,
		<-486.1,-99,438.75>,
		<-560.2,-99,468.9>
  }
  triangle { // #2659
		<-486.1,-99,438.75>,
		<-486.75,-99,439.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2660
		<-486.75,-99,439.55>,
		<-487.45,-99,440.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2661
		<-487.45,-99,440.3>,
		<-488.15,-99,441.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2662
		<-488.15,-99,441.1>,
		<-488.9,-99,441.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2663
		<-488.9,-99,441.85>,
		<-489.65,-99,442.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2664
		<-489.65,-99,442.6>,
		<-490.4,-99,443.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2665
		<-490.4,-99,443.35>,
		<-491.15,-99,444.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2666
		<-491.15,-99,444.15>,
		<-492,-99,444.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2667
		<-492,-99,444.9>,
		<-492.8,-99,445.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2668
		<-492.8,-99,445.6>,
		<-493.65,-99,446.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2669
		<-493.65,-99,446.35>,
		<-494.5,-99,447.1>,
		<-560.2,-99,468.9>
  }
  triangle { // #2670
		<-494.5,-99,447.1>,
		<-495.4,-99,447.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2671
		<-495.4,-99,447.85>,
		<-496.25,-99,448.55>,
		<-560.2,-99,468.9>
  }
  triangle { // #2672
		<-496.25,-99,448.55>,
		<-497.15,-99,449.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2673
		<-497.15,-99,449.25>,
		<-498.1,-99,449.95>,
		<-560.2,-99,468.9>
  }
  triangle { // #2674
		<-498.1,-99,449.95>,
		<-499,-99,450.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2675
		<-499,-99,450.65>,
		<-499.95,-99,451.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2676
		<-499.95,-99,451.35>,
		<-500.85,-99,452.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2677
		<-500.85,-99,452.05>,
		<-501.8,-99,452.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2678
		<-501.8,-99,452.7>,
		<-502.75,-99,453.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2679
		<-502.75,-99,453.4>,
		<-503.7,-99,454.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2680
		<-503.7,-99,454.05>,
		<-504.7,-99,454.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2681
		<-504.7,-99,454.7>,
		<-505.65,-99,455.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2682
		<-505.65,-99,455.35>,
		<-506.65,-99,456>,
		<-560.2,-99,468.9>
  }
  triangle { // #2683
		<-506.65,-99,456>,
		<-507.65,-99,456.6>,
		<-560.2,-99,468.9>
  }
  triangle { // #2684
		<-507.65,-99,456.6>,
		<-508.65,-99,457.25>,
		<-560.2,-99,468.9>
  }
  triangle { // #2685
		<-508.65,-99,457.25>,
		<-509.65,-99,457.85>,
		<-560.2,-99,468.9>
  }
  triangle { // #2686
		<-509.65,-99,457.85>,
		<-510.65,-99,458.45>,
		<-560.2,-99,468.9>
  }
  triangle { // #2687
		<-510.65,-99,458.45>,
		<-511.7,-99,459.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2688
		<-511.7,-99,459.05>,
		<-512.8,-99,459.65>,
		<-560.2,-99,468.9>
  }
  triangle { // #2689
		<-512.8,-99,459.65>,
		<-513.95,-99,460.3>,
		<-560.2,-99,468.9>
  }
  triangle { // #2690
		<-513.95,-99,460.3>,
		<-515.15,-99,460.9>,
		<-560.2,-99,468.9>
  }
  triangle { // #2691
		<-515.15,-99,460.9>,
		<-516.4,-99,461.5>,
		<-560.2,-99,468.9>
  }
  triangle { // #2692
		<-516.4,-99,461.5>,
		<-517.7,-99,462.15>,
		<-560.2,-99,468.9>
  }
  triangle { // #2693
		<-517.7,-99,462.15>,
		<-519.05,-99,462.8>,
		<-560.2,-99,468.9>
  }
  triangle { // #2694
		<-519.05,-99,462.8>,
		<-520.45,-99,463.4>,
		<-560.2,-99,468.9>
  }
  triangle { // #2695
		<-520.45,-99,463.4>,
		<-521.9,-99,464.05>,
		<-560.2,-99,468.9>
  }
  triangle { // #2696
		<-521.9,-99,464.05>,
		<-523.4,-99,464.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2697
		<-523.4,-99,464.7>,
		<-524.95,-99,465.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2698
		<-524.95,-99,465.35>,
		<-526.55,-99,466>,
		<-560.2,-99,468.9>
  }
  triangle { // #2699
		<-526.55,-99,466>,
		<-528.2,-99,466.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2700
		<-528.2,-99,466.7>,
		<-529.9,-99,467.35>,
		<-560.2,-99,468.9>
  }
  triangle { // #2701
		<-529.9,-99,467.35>,
		<-531.65,-99,468>,
		<-560.2,-99,468.9>
  }
  triangle { // #2702
		<-531.65,-99,468>,
		<-533.45,-99,468.7>,
		<-560.2,-99,468.9>
  }
  triangle { // #2703
		<-560.2,-99,468.9>,
		<-533.45,-99,468.7>,
		<-558.65,-99,469.35>
  }
  triangle { // #2704
		<-558.65,-99,469.35>,
		<-533.45,-99,468.7>,
		<-556.6,-99,469.9>
  }
  triangle { // #2705
		<-556.6,-99,469.9>,
		<-533.45,-99,468.7>,
		<-554.6,-99,470.35>
  }
  triangle { // #2706
		<-554.6,-99,470.35>,
		<-533.45,-99,468.7>,
		<-552.6,-99,470.65>
  }
  triangle { // #2707
		<-552.6,-99,470.65>,
		<-533.45,-99,468.7>,
		<-550.6,-99,470.9>
  }
  triangle { // #2708
		<-550.6,-99,470.9>,
		<-533.45,-99,468.7>,
		<-548.6,-99,471.05>
  }
  triangle { // #2709
		<-548.6,-99,471.05>,
		<-533.45,-99,468.7>,
		<-546.65,-99,471.1>
  }
  triangle { // #2710
		<-546.65,-99,471.1>,
		<-533.45,-99,468.7>,
		<-544.7,-99,471.05>
  }
  triangle { // #2711
		<-533.45,-99,468.7>,
		<-535.3,-99,469.35>,
		<-544.7,-99,471.05>
  }
  triangle { // #2712
		<-544.7,-99,471.05>,
		<-535.3,-99,469.35>,
		<-542.8,-99,470.9>
  }
  triangle { // #2713
		<-535.3,-99,469.35>,
		<-537.15,-99,469.85>,
		<-542.8,-99,470.9>
  }
  triangle { // #2714
		<-542.8,-99,470.9>,
		<-537.15,-99,469.85>,
		<-540.9,-99,470.65>
  }
  smooth_triangle { // #2715
		<-435.8,0,274.1>, <0.911,-0.413,0>,
		<-435.8,-99,274.1>, <0.911,-0.413,0>,
		<-435.1,0,272.6>, <0.88,-0.476,0>
  }
  smooth_triangle { // #2716
		<-435.1,-99,272.6>, <0.88,-0.476,0>,
		<-435.1,0,272.6>, <0.88,-0.476,0>,
		<-435.8,-99,274.1>, <0.911,-0.413,0>
  }
  triangle { // #2717
		<-436.45,0,275.55>,
		<-436.45,-99,275.55>,
		<-435.8,0,274.1>
  }
  triangle { // #2718
		<-435.8,-99,274.1>,
		<-435.8,0,274.1>,
		<-436.45,-99,275.55>
  }
  triangle { // #2719
		<-437.1,0,276.95>,
		<-437.1,-99,276.95>,
		<-436.45,0,275.55>
  }
  triangle { // #2720
		<-436.45,-99,275.55>,
		<-436.45,0,275.55>,
		<-437.1,-99,276.95>
  }
  triangle { // #2721
		<-437.75,0,278.3>,
		<-437.75,-99,278.3>,
		<-437.1,0,276.95>
  }
  triangle { // #2722
		<-437.1,-99,276.95>,
		<-437.1,0,276.95>,
		<-437.75,-99,278.3>
  }
  triangle { // #2723
		<-438.35,0,279.6>,
		<-438.35,-99,279.6>,
		<-437.75,0,278.3>
  }
  triangle { // #2724
		<-437.75,-99,278.3>,
		<-437.75,0,278.3>,
		<-438.35,-99,279.6>
  }
  triangle { // #2725
		<-438.9,0,280.85>,
		<-438.9,-99,280.85>,
		<-438.35,0,279.6>
  }
  triangle { // #2726
		<-438.35,-99,279.6>,
		<-438.35,0,279.6>,
		<-438.9,-99,280.85>
  }
  triangle { // #2727
		<-439.45,0,282.1>,
		<-439.45,-99,282.1>,
		<-438.9,0,280.85>
  }
  triangle { // #2728
		<-438.9,-99,280.85>,
		<-438.9,0,280.85>,
		<-439.45,-99,282.1>
  }
  triangle { // #2729
		<-440,0,283.25>,
		<-440,-99,283.25>,
		<-439.45,0,282.1>
  }
  triangle { // #2730
		<-439.45,-99,282.1>,
		<-439.45,0,282.1>,
		<-440,-99,283.25>
  }
  triangle { // #2731
		<-440.55,0,284.35>,
		<-440.55,-99,284.35>,
		<-440,0,283.25>
  }
  triangle { // #2732
		<-440,-99,283.25>,
		<-440,0,283.25>,
		<-440.55,-99,284.35>
  }
  triangle { // #2733
		<-441.05,0,285.4>,
		<-441.05,-99,285.4>,
		<-440.55,0,284.35>
  }
  triangle { // #2734
		<-440.55,-99,284.35>,
		<-440.55,0,284.35>,
		<-441.05,-99,285.4>
  }
  triangle { // #2735
		<-441.55,0,286.45>,
		<-441.55,-99,286.45>,
		<-441.05,0,285.4>
  }
  triangle { // #2736
		<-441.05,-99,285.4>,
		<-441.05,0,285.4>,
		<-441.55,-99,286.45>
  }
  triangle { // #2737
		<-442,0,287.4>,
		<-442,-99,287.4>,
		<-441.55,0,286.45>
  }
  triangle { // #2738
		<-441.55,-99,286.45>,
		<-441.55,0,286.45>,
		<-442,-99,287.4>
  }
  triangle { // #2739
		<-442.45,0,288.3>,
		<-442.45,-99,288.3>,
		<-442,0,287.4>
  }
  triangle { // #2740
		<-442,-99,287.4>,
		<-442,0,287.4>,
		<-442.45,-99,288.3>
  }
  triangle { // #2741
		<-442.85,0,289.15>,
		<-442.85,-99,289.15>,
		<-442.45,0,288.3>
  }
  triangle { // #2742
		<-442.45,-99,288.3>,
		<-442.45,0,288.3>,
		<-442.85,-99,289.15>
  }
  triangle { // #2743
		<-443.25,0,290>,
		<-443.25,-99,290>,
		<-442.85,0,289.15>
  }
  triangle { // #2744
		<-442.85,-99,289.15>,
		<-442.85,0,289.15>,
		<-443.25,-99,290>
  }
  triangle { // #2745
		<-443.65,0,290.75>,
		<-443.65,-99,290.75>,
		<-443.25,0,290>
  }
  triangle { // #2746
		<-443.25,-99,290>,
		<-443.25,0,290>,
		<-443.65,-99,290.75>
  }
  triangle { // #2747
		<-444,0,291.5>,
		<-444,-99,291.5>,
		<-443.65,0,290.75>
  }
  triangle { // #2748
		<-443.65,-99,290.75>,
		<-443.65,0,290.75>,
		<-444,-99,291.5>
  }
  triangle { // #2749
		<-444.4,0,292.25>,
		<-444.4,-99,292.25>,
		<-444,0,291.5>
  }
  triangle { // #2750
		<-444,-99,291.5>,
		<-444,0,291.5>,
		<-444.4,-99,292.25>
  }
  triangle { // #2751
		<-444.75,0,293.05>,
		<-444.75,-99,293.05>,
		<-444.4,0,292.25>
  }
  triangle { // #2752
		<-444.4,-99,292.25>,
		<-444.4,0,292.25>,
		<-444.75,-99,293.05>
  }
  triangle { // #2753
		<-445.1,0,293.8>,
		<-445.1,-99,293.8>,
		<-444.75,0,293.05>
  }
  triangle { // #2754
		<-444.75,-99,293.05>,
		<-444.75,0,293.05>,
		<-445.1,-99,293.8>
  }
  triangle { // #2755
		<-445.5,0,294.6>,
		<-445.5,-99,294.6>,
		<-445.1,0,293.8>
  }
  triangle { // #2756
		<-445.1,-99,293.8>,
		<-445.1,0,293.8>,
		<-445.5,-99,294.6>
  }
  triangle { // #2757
		<-445.85,0,295.4>,
		<-445.85,-99,295.4>,
		<-445.5,0,294.6>
  }
  triangle { // #2758
		<-445.5,-99,294.6>,
		<-445.5,0,294.6>,
		<-445.85,-99,295.4>
  }
  triangle { // #2759
		<-446.2,0,296.2>,
		<-446.2,-99,296.2>,
		<-445.85,0,295.4>
  }
  triangle { // #2760
		<-445.85,-99,295.4>,
		<-445.85,0,295.4>,
		<-446.2,-99,296.2>
  }
  triangle { // #2761
		<-446.5,0,297.05>,
		<-446.5,-99,297.05>,
		<-446.2,0,296.2>
  }
  triangle { // #2762
		<-446.2,-99,296.2>,
		<-446.2,0,296.2>,
		<-446.5,-99,297.05>
  }
  triangle { // #2763
		<-446.85,0,297.85>,
		<-446.85,-99,297.85>,
		<-446.5,0,297.05>
  }
  triangle { // #2764
		<-446.5,-99,297.05>,
		<-446.5,0,297.05>,
		<-446.85,-99,297.85>
  }
  triangle { // #2765
		<-447.2,0,298.7>,
		<-447.2,-99,298.7>,
		<-446.85,0,297.85>
  }
  triangle { // #2766
		<-446.85,-99,297.85>,
		<-446.85,0,297.85>,
		<-447.2,-99,298.7>
  }
  triangle { // #2767
		<-447.55,0,299.55>,
		<-447.55,-99,299.55>,
		<-447.2,0,298.7>
  }
  triangle { // #2768
		<-447.2,-99,298.7>,
		<-447.2,0,298.7>,
		<-447.55,-99,299.55>
  }
  triangle { // #2769
		<-447.85,0,300.45>,
		<-447.85,-99,300.45>,
		<-447.55,0,299.55>
  }
  triangle { // #2770
		<-447.55,-99,299.55>,
		<-447.55,0,299.55>,
		<-447.85,-99,300.45>
  }
  triangle { // #2771
		<-448.2,0,301.3>,
		<-448.2,-99,301.3>,
		<-447.85,0,300.45>
  }
  triangle { // #2772
		<-447.85,-99,300.45>,
		<-447.85,0,300.45>,
		<-448.2,-99,301.3>
  }
  triangle { // #2773
		<-448.5,0,302.2>,
		<-448.5,-99,302.2>,
		<-448.2,0,301.3>
  }
  triangle { // #2774
		<-448.2,-99,301.3>,
		<-448.2,0,301.3>,
		<-448.5,-99,302.2>
  }
  triangle { // #2775
		<-448.85,0,303.1>,
		<-448.85,-99,303.1>,
		<-448.5,0,302.2>
  }
  triangle { // #2776
		<-448.5,-99,302.2>,
		<-448.5,0,302.2>,
		<-448.85,-99,303.1>
  }
  triangle { // #2777
		<-449.15,0,304>,
		<-449.15,-99,304>,
		<-448.85,0,303.1>
  }
  triangle { // #2778
		<-448.85,-99,303.1>,
		<-448.85,0,303.1>,
		<-449.15,-99,304>
  }
  triangle { // #2779
		<-449.45,0,304.9>,
		<-449.45,-99,304.9>,
		<-449.15,0,304>
  }
  triangle { // #2780
		<-449.15,-99,304>,
		<-449.15,0,304>,
		<-449.45,-99,304.9>
  }
  triangle { // #2781
		<-449.75,0,305.8>,
		<-449.75,-99,305.8>,
		<-449.45,0,304.9>
  }
  triangle { // #2782
		<-449.45,-99,304.9>,
		<-449.45,0,304.9>,
		<-449.75,-99,305.8>
  }
  triangle { // #2783
		<-450.05,0,306.75>,
		<-450.05,-99,306.75>,
		<-449.75,0,305.8>
  }
  triangle { // #2784
		<-449.75,-99,305.8>,
		<-449.75,0,305.8>,
		<-450.05,-99,306.75>
  }
  triangle { // #2785
		<-450.35,0,307.65>,
		<-450.35,-99,307.65>,
		<-450.05,0,306.75>
  }
  triangle { // #2786
		<-450.05,-99,306.75>,
		<-450.05,0,306.75>,
		<-450.35,-99,307.65>
  }
  triangle { // #2787
		<-450.65,0,308.55>,
		<-450.65,-99,308.55>,
		<-450.35,0,307.65>
  }
  triangle { // #2788
		<-450.35,-99,307.65>,
		<-450.35,0,307.65>,
		<-450.65,-99,308.55>
  }
  triangle { // #2789
		<-450.95,0,309.45>,
		<-450.95,-99,309.45>,
		<-450.65,0,308.55>
  }
  triangle { // #2790
		<-450.65,-99,308.55>,
		<-450.65,0,308.55>,
		<-450.95,-99,309.45>
  }
  triangle { // #2791
		<-451.25,0,310.35>,
		<-451.25,-99,310.35>,
		<-450.95,0,309.45>
  }
  triangle { // #2792
		<-450.95,-99,309.45>,
		<-450.95,0,309.45>,
		<-451.25,-99,310.35>
  }
  triangle { // #2793
		<-451.5,0,311.3>,
		<-451.5,-99,311.3>,
		<-451.25,0,310.35>
  }
  triangle { // #2794
		<-451.25,-99,310.35>,
		<-451.25,0,310.35>,
		<-451.5,-99,311.3>
  }
  triangle { // #2795
		<-451.8,0,312.2>,
		<-451.8,-99,312.2>,
		<-451.5,0,311.3>
  }
  triangle { // #2796
		<-451.5,-99,311.3>,
		<-451.5,0,311.3>,
		<-451.8,-99,312.2>
  }
  triangle { // #2797
		<-452.1,0,313.1>,
		<-452.1,-99,313.1>,
		<-451.8,0,312.2>
  }
  triangle { // #2798
		<-451.8,-99,312.2>,
		<-451.8,0,312.2>,
		<-452.1,-99,313.1>
  }
  triangle { // #2799
		<-452.35,0,314>,
		<-452.35,-99,314>,
		<-452.1,0,313.1>
  }
  triangle { // #2800
		<-452.1,-99,313.1>,
		<-452.1,0,313.1>,
		<-452.35,-99,314>
  }
  triangle { // #2801
		<-452.65,0,314.9>,
		<-452.65,-99,314.9>,
		<-452.35,0,314>
  }
  triangle { // #2802
		<-452.35,-99,314>,
		<-452.35,0,314>,
		<-452.65,-99,314.9>
  }
  triangle { // #2803
		<-452.9,0,315.8>,
		<-452.9,-99,315.8>,
		<-452.65,0,314.9>
  }
  triangle { // #2804
		<-452.65,-99,314.9>,
		<-452.65,0,314.9>,
		<-452.9,-99,315.8>
  }
  triangle { // #2805
		<-453.2,0,316.7>,
		<-453.2,-99,316.7>,
		<-452.9,0,315.8>
  }
  triangle { // #2806
		<-452.9,-99,315.8>,
		<-452.9,0,315.8>,
		<-453.2,-99,316.7>
  }
  triangle { // #2807
		<-453.45,0,317.6>,
		<-453.45,-99,317.6>,
		<-453.2,0,316.7>
  }
  triangle { // #2808
		<-453.2,-99,316.7>,
		<-453.2,0,316.7>,
		<-453.45,-99,317.6>
  }
  triangle { // #2809
		<-453.7,0,318.5>,
		<-453.7,-99,318.5>,
		<-453.45,0,317.6>
  }
  triangle { // #2810
		<-453.45,-99,317.6>,
		<-453.45,0,317.6>,
		<-453.7,-99,318.5>
  }
  triangle { // #2811
		<-453.95,0,319.45>,
		<-453.95,-99,319.45>,
		<-453.7,0,318.5>
  }
  triangle { // #2812
		<-453.7,-99,318.5>,
		<-453.7,0,318.5>,
		<-453.95,-99,319.45>
  }
  triangle { // #2813
		<-454.2,0,320.35>,
		<-454.2,-99,320.35>,
		<-453.95,0,319.45>
  }
  triangle { // #2814
		<-453.95,-99,319.45>,
		<-453.95,0,319.45>,
		<-454.2,-99,320.35>
  }
  triangle { // #2815
		<-454.45,0,321.25>,
		<-454.45,-99,321.25>,
		<-454.2,0,320.35>
  }
  triangle { // #2816
		<-454.2,-99,320.35>,
		<-454.2,0,320.35>,
		<-454.45,-99,321.25>
  }
  triangle { // #2817
		<-454.7,0,322.15>,
		<-454.7,-99,322.15>,
		<-454.45,0,321.25>
  }
  triangle { // #2818
		<-454.45,-99,321.25>,
		<-454.45,0,321.25>,
		<-454.7,-99,322.15>
  }
  triangle { // #2819
		<-454.95,0,323.05>,
		<-454.95,-99,323.05>,
		<-454.7,0,322.15>
  }
  triangle { // #2820
		<-454.7,-99,322.15>,
		<-454.7,0,322.15>,
		<-454.95,-99,323.05>
  }
  triangle { // #2821
		<-455.2,0,323.95>,
		<-455.2,-99,323.95>,
		<-454.95,0,323.05>
  }
  triangle { // #2822
		<-454.95,-99,323.05>,
		<-454.95,0,323.05>,
		<-455.2,-99,323.95>
  }
  triangle { // #2823
		<-455.4,0,324.9>,
		<-455.4,-99,324.9>,
		<-455.2,0,323.95>
  }
  triangle { // #2824
		<-455.2,-99,323.95>,
		<-455.2,0,323.95>,
		<-455.4,-99,324.9>
  }
  triangle { // #2825
		<-455.65,0,325.8>,
		<-455.65,-99,325.8>,
		<-455.4,0,324.9>
  }
  triangle { // #2826
		<-455.4,-99,324.9>,
		<-455.4,0,324.9>,
		<-455.65,-99,325.8>
  }
  triangle { // #2827
		<-455.85,0,326.7>,
		<-455.85,-99,326.7>,
		<-455.65,0,325.8>
  }
  triangle { // #2828
		<-455.65,-99,325.8>,
		<-455.65,0,325.8>,
		<-455.85,-99,326.7>
  }
  triangle { // #2829
		<-456.05,0,327.65>,
		<-456.05,-99,327.65>,
		<-455.85,0,326.7>
  }
  triangle { // #2830
		<-455.85,-99,326.7>,
		<-455.85,0,326.7>,
		<-456.05,-99,327.65>
  }
  triangle { // #2831
		<-456.25,0,328.55>,
		<-456.25,-99,328.55>,
		<-456.05,0,327.65>
  }
  triangle { // #2832
		<-456.05,-99,327.65>,
		<-456.05,0,327.65>,
		<-456.25,-99,328.55>
  }
  triangle { // #2833
		<-456.45,0,329.5>,
		<-456.45,-99,329.5>,
		<-456.25,0,328.55>
  }
  triangle { // #2834
		<-456.25,-99,328.55>,
		<-456.25,0,328.55>,
		<-456.45,-99,329.5>
  }
  triangle { // #2835
		<-456.65,0,330.4>,
		<-456.65,-99,330.4>,
		<-456.45,0,329.5>
  }
  triangle { // #2836
		<-456.45,-99,329.5>,
		<-456.45,0,329.5>,
		<-456.65,-99,330.4>
  }
  triangle { // #2837
		<-456.85,0,331.35>,
		<-456.85,-99,331.35>,
		<-456.65,0,330.4>
  }
  triangle { // #2838
		<-456.65,-99,330.4>,
		<-456.65,0,330.4>,
		<-456.85,-99,331.35>
  }
  triangle { // #2839
		<-457.05,0,332.25>,
		<-457.05,-99,332.25>,
		<-456.85,0,331.35>
  }
  triangle { // #2840
		<-456.85,-99,331.35>,
		<-456.85,0,331.35>,
		<-457.05,-99,332.25>
  }
  triangle { // #2841
		<-457.25,0,333.2>,
		<-457.25,-99,333.2>,
		<-457.05,0,332.25>
  }
  triangle { // #2842
		<-457.05,-99,332.25>,
		<-457.05,0,332.25>,
		<-457.25,-99,333.2>
  }
  triangle { // #2843
		<-457.4,0,334.15>,
		<-457.4,-99,334.15>,
		<-457.25,0,333.2>
  }
  triangle { // #2844
		<-457.25,-99,333.2>,
		<-457.25,0,333.2>,
		<-457.4,-99,334.15>
  }
  triangle { // #2845
		<-457.6,0,335.05>,
		<-457.6,-99,335.05>,
		<-457.4,0,334.15>
  }
  triangle { // #2846
		<-457.4,-99,334.15>,
		<-457.4,0,334.15>,
		<-457.6,-99,335.05>
  }
  triangle { // #2847
		<-457.75,0,336>,
		<-457.75,-99,336>,
		<-457.6,0,335.05>
  }
  triangle { // #2848
		<-457.6,-99,335.05>,
		<-457.6,0,335.05>,
		<-457.75,-99,336>
  }
  triangle { // #2849
		<-457.9,0,336.95>,
		<-457.9,-99,336.95>,
		<-457.75,0,336>
  }
  triangle { // #2850
		<-457.75,-99,336>,
		<-457.75,0,336>,
		<-457.9,-99,336.95>
  }
  triangle { // #2851
		<-458.05,0,337.85>,
		<-458.05,-99,337.85>,
		<-457.9,0,336.95>
  }
  triangle { // #2852
		<-457.9,-99,336.95>,
		<-457.9,0,336.95>,
		<-458.05,-99,337.85>
  }
  triangle { // #2853
		<-458.25,0,338.8>,
		<-458.25,-99,338.8>,
		<-458.05,0,337.85>
  }
  triangle { // #2854
		<-458.05,-99,337.85>,
		<-458.05,0,337.85>,
		<-458.25,-99,338.8>
  }
  triangle { // #2855
		<-458.4,0,339.75>,
		<-458.4,-99,339.75>,
		<-458.25,0,338.8>
  }
  triangle { // #2856
		<-458.25,-99,338.8>,
		<-458.25,0,338.8>,
		<-458.4,-99,339.75>
  }
  triangle { // #2857
		<-458.5,0,340.7>,
		<-458.5,-99,340.7>,
		<-458.4,0,339.75>
  }
  triangle { // #2858
		<-458.4,-99,339.75>,
		<-458.4,0,339.75>,
		<-458.5,-99,340.7>
  }
  triangle { // #2859
		<-458.65,0,341.65>,
		<-458.65,-99,341.65>,
		<-458.5,0,340.7>
  }
  triangle { // #2860
		<-458.5,-99,340.7>,
		<-458.5,0,340.7>,
		<-458.65,-99,341.65>
  }
  triangle { // #2861
		<-458.8,0,342.6>,
		<-458.8,-99,342.6>,
		<-458.65,0,341.65>
  }
  triangle { // #2862
		<-458.65,-99,341.65>,
		<-458.65,0,341.65>,
		<-458.8,-99,342.6>
  }
  triangle { // #2863
		<-458.95,0,343.55>,
		<-458.95,-99,343.55>,
		<-458.8,0,342.6>
  }
  triangle { // #2864
		<-458.8,-99,342.6>,
		<-458.8,0,342.6>,
		<-458.95,-99,343.55>
  }
  triangle { // #2865
		<-459.05,0,344.45>,
		<-459.05,-99,344.45>,
		<-458.95,0,343.55>
  }
  triangle { // #2866
		<-458.95,-99,343.55>,
		<-458.95,0,343.55>,
		<-459.05,-99,344.45>
  }
  triangle { // #2867
		<-459.2,0,345.4>,
		<-459.2,-99,345.4>,
		<-459.05,0,344.45>
  }
  triangle { // #2868
		<-459.05,-99,344.45>,
		<-459.05,0,344.45>,
		<-459.2,-99,345.4>
  }
  triangle { // #2869
		<-459.3,0,346.35>,
		<-459.3,-99,346.35>,
		<-459.2,0,345.4>
  }
  triangle { // #2870
		<-459.2,-99,345.4>,
		<-459.2,0,345.4>,
		<-459.3,-99,346.35>
  }
  triangle { // #2871
		<-459.4,0,347.3>,
		<-459.4,-99,347.3>,
		<-459.3,0,346.35>
  }
  triangle { // #2872
		<-459.3,-99,346.35>,
		<-459.3,0,346.35>,
		<-459.4,-99,347.3>
  }
  triangle { // #2873
		<-459.55,0,348.25>,
		<-459.55,-99,348.25>,
		<-459.4,0,347.3>
  }
  triangle { // #2874
		<-459.4,-99,347.3>,
		<-459.4,0,347.3>,
		<-459.55,-99,348.25>
  }
  triangle { // #2875
		<-459.65,0,349.25>,
		<-459.65,-99,349.25>,
		<-459.55,0,348.25>
  }
  triangle { // #2876
		<-459.55,-99,348.25>,
		<-459.55,0,348.25>,
		<-459.65,-99,349.25>
  }
  triangle { // #2877
		<-459.75,0,350.2>,
		<-459.75,-99,350.2>,
		<-459.65,0,349.25>
  }
  triangle { // #2878
		<-459.65,-99,349.25>,
		<-459.65,0,349.25>,
		<-459.75,-99,350.2>
  }
  triangle { // #2879
		<-459.85,0,351.15>,
		<-459.85,-99,351.15>,
		<-459.75,0,350.2>
  }
  triangle { // #2880
		<-459.75,-99,350.2>,
		<-459.75,0,350.2>,
		<-459.85,-99,351.15>
  }
  triangle { // #2881
		<-460,0,352.1>,
		<-460,-99,352.1>,
		<-459.85,0,351.15>
  }
  triangle { // #2882
		<-459.85,-99,351.15>,
		<-459.85,0,351.15>,
		<-460,-99,352.1>
  }
  triangle { // #2883
		<-460.1,0,353>,
		<-460.1,-99,353>,
		<-460,0,352.1>
  }
  triangle { // #2884
		<-460,-99,352.1>,
		<-460,0,352.1>,
		<-460.1,-99,353>
  }
  triangle { // #2885
		<-460.25,0,353.95>,
		<-460.25,-99,353.95>,
		<-460.1,0,353>
  }
  triangle { // #2886
		<-460.1,-99,353>,
		<-460.1,0,353>,
		<-460.25,-99,353.95>
  }
  triangle { // #2887
		<-460.4,0,354.9>,
		<-460.4,-99,354.9>,
		<-460.25,0,353.95>
  }
  triangle { // #2888
		<-460.25,-99,353.95>,
		<-460.25,0,353.95>,
		<-460.4,-99,354.9>
  }
  triangle { // #2889
		<-460.5,0,355.85>,
		<-460.5,-99,355.85>,
		<-460.4,0,354.9>
  }
  triangle { // #2890
		<-460.4,-99,354.9>,
		<-460.4,0,354.9>,
		<-460.5,-99,355.85>
  }
  triangle { // #2891
		<-460.65,0,356.8>,
		<-460.65,-99,356.8>,
		<-460.5,0,355.85>
  }
  triangle { // #2892
		<-460.5,-99,355.85>,
		<-460.5,0,355.85>,
		<-460.65,-99,356.8>
  }
  triangle { // #2893
		<-460.8,0,357.75>,
		<-460.8,-99,357.75>,
		<-460.65,0,356.8>
  }
  triangle { // #2894
		<-460.65,-99,356.8>,
		<-460.65,0,356.8>,
		<-460.8,-99,357.75>
  }
  triangle { // #2895
		<-460.95,0,358.7>,
		<-460.95,-99,358.7>,
		<-460.8,0,357.75>
  }
  triangle { // #2896
		<-460.8,-99,357.75>,
		<-460.8,0,357.75>,
		<-460.95,-99,358.7>
  }
  triangle { // #2897
		<-461.1,0,359.6>,
		<-461.1,-99,359.6>,
		<-460.95,0,358.7>
  }
  triangle { // #2898
		<-460.95,-99,358.7>,
		<-460.95,0,358.7>,
		<-461.1,-99,359.6>
  }
  triangle { // #2899
		<-461.3,0,360.55>,
		<-461.3,-99,360.55>,
		<-461.1,0,359.6>
  }
  triangle { // #2900
		<-461.1,-99,359.6>,
		<-461.1,0,359.6>,
		<-461.3,-99,360.55>
  }
  triangle { // #2901
		<-461.45,0,361.5>,
		<-461.45,-99,361.5>,
		<-461.3,0,360.55>
  }
  triangle { // #2902
		<-461.3,-99,360.55>,
		<-461.3,0,360.55>,
		<-461.45,-99,361.5>
  }
  triangle { // #2903
		<-461.6,0,362.4>,
		<-461.6,-99,362.4>,
		<-461.45,0,361.5>
  }
  triangle { // #2904
		<-461.45,-99,361.5>,
		<-461.45,0,361.5>,
		<-461.6,-99,362.4>
  }
  triangle { // #2905
		<-461.8,0,363.35>,
		<-461.8,-99,363.35>,
		<-461.6,0,362.4>
  }
  triangle { // #2906
		<-461.6,-99,362.4>,
		<-461.6,0,362.4>,
		<-461.8,-99,363.35>
  }
  triangle { // #2907
		<-461.95,0,364.3>,
		<-461.95,-99,364.3>,
		<-461.8,0,363.35>
  }
  triangle { // #2908
		<-461.8,-99,363.35>,
		<-461.8,0,363.35>,
		<-461.95,-99,364.3>
  }
  triangle { // #2909
		<-462.15,0,365.2>,
		<-462.15,-99,365.2>,
		<-461.95,0,364.3>
  }
  triangle { // #2910
		<-461.95,-99,364.3>,
		<-461.95,0,364.3>,
		<-462.15,-99,365.2>
  }
  triangle { // #2911
		<-462.3,0,366.15>,
		<-462.3,-99,366.15>,
		<-462.15,0,365.2>
  }
  triangle { // #2912
		<-462.15,-99,365.2>,
		<-462.15,0,365.2>,
		<-462.3,-99,366.15>
  }
  triangle { // #2913
		<-462.45,0,367.1>,
		<-462.45,-99,367.1>,
		<-462.3,0,366.15>
  }
  triangle { // #2914
		<-462.3,-99,366.15>,
		<-462.3,0,366.15>,
		<-462.45,-99,367.1>
  }
  triangle { // #2915
		<-462.65,0,368.05>,
		<-462.65,-99,368.05>,
		<-462.45,0,367.1>
  }
  triangle { // #2916
		<-462.45,-99,367.1>,
		<-462.45,0,367.1>,
		<-462.65,-99,368.05>
  }
  triangle { // #2917
		<-462.8,0,368.95>,
		<-462.8,-99,368.95>,
		<-462.65,0,368.05>
  }
  triangle { // #2918
		<-462.65,-99,368.05>,
		<-462.65,0,368.05>,
		<-462.8,-99,368.95>
  }
  triangle { // #2919
		<-462.95,0,369.9>,
		<-462.95,-99,369.9>,
		<-462.8,0,368.95>
  }
  triangle { // #2920
		<-462.8,-99,368.95>,
		<-462.8,0,368.95>,
		<-462.95,-99,369.9>
  }
  triangle { // #2921
		<-463.1,0,370.85>,
		<-463.1,-99,370.85>,
		<-462.95,0,369.9>
  }
  triangle { // #2922
		<-462.95,-99,369.9>,
		<-462.95,0,369.9>,
		<-463.1,-99,370.85>
  }
  triangle { // #2923
		<-463.25,0,371.8>,
		<-463.25,-99,371.8>,
		<-463.1,0,370.85>
  }
  triangle { // #2924
		<-463.1,-99,370.85>,
		<-463.1,0,370.85>,
		<-463.25,-99,371.8>
  }
  triangle { // #2925
		<-463.45,0,372.7>,
		<-463.45,-99,372.7>,
		<-463.25,0,371.8>
  }
  triangle { // #2926
		<-463.25,-99,371.8>,
		<-463.25,0,371.8>,
		<-463.45,-99,372.7>
  }
  triangle { // #2927
		<-463.6,0,373.65>,
		<-463.6,-99,373.65>,
		<-463.45,0,372.7>
  }
  triangle { // #2928
		<-463.45,-99,372.7>,
		<-463.45,0,372.7>,
		<-463.6,-99,373.65>
  }
  triangle { // #2929
		<-463.7,0,374.6>,
		<-463.7,-99,374.6>,
		<-463.6,0,373.65>
  }
  triangle { // #2930
		<-463.6,-99,373.65>,
		<-463.6,0,373.65>,
		<-463.7,-99,374.6>
  }
  triangle { // #2931
		<-463.85,0,375.55>,
		<-463.85,-99,375.55>,
		<-463.7,0,374.6>
  }
  triangle { // #2932
		<-463.7,-99,374.6>,
		<-463.7,0,374.6>,
		<-463.85,-99,375.55>
  }
  triangle { // #2933
		<-464,0,376.5>,
		<-464,-99,376.5>,
		<-463.85,0,375.55>
  }
  triangle { // #2934
		<-463.85,-99,375.55>,
		<-463.85,0,375.55>,
		<-464,-99,376.5>
  }
  triangle { // #2935
		<-464.15,0,377.45>,
		<-464.15,-99,377.45>,
		<-464,0,376.5>
  }
  triangle { // #2936
		<-464,-99,376.5>,
		<-464,0,376.5>,
		<-464.15,-99,377.45>
  }
  triangle { // #2937
		<-464.3,0,378.35>,
		<-464.3,-99,378.35>,
		<-464.15,0,377.45>
  }
  triangle { // #2938
		<-464.15,-99,377.45>,
		<-464.15,0,377.45>,
		<-464.3,-99,378.35>
  }
  triangle { // #2939
		<-464.45,0,379.3>,
		<-464.45,-99,379.3>,
		<-464.3,0,378.35>
  }
  triangle { // #2940
		<-464.3,-99,378.35>,
		<-464.3,0,378.35>,
		<-464.45,-99,379.3>
  }
  triangle { // #2941
		<-464.55,0,380.25>,
		<-464.55,-99,380.25>,
		<-464.45,0,379.3>
  }
  triangle { // #2942
		<-464.45,-99,379.3>,
		<-464.45,0,379.3>,
		<-464.55,-99,380.25>
  }
  triangle { // #2943
		<-464.7,0,381.2>,
		<-464.7,-99,381.2>,
		<-464.55,0,380.25>
  }
  triangle { // #2944
		<-464.55,-99,380.25>,
		<-464.55,0,380.25>,
		<-464.7,-99,381.2>
  }
  triangle { // #2945
		<-464.85,0,382.15>,
		<-464.85,-99,382.15>,
		<-464.7,0,381.2>
  }
  triangle { // #2946
		<-464.7,-99,381.2>,
		<-464.7,0,381.2>,
		<-464.85,-99,382.15>
  }
  triangle { // #2947
		<-465,0,383.1>,
		<-465,-99,383.1>,
		<-464.85,0,382.15>
  }
  triangle { // #2948
		<-464.85,-99,382.15>,
		<-464.85,0,382.15>,
		<-465,-99,383.1>
  }
  triangle { // #2949
		<-465.15,0,384.05>,
		<-465.15,-99,384.05>,
		<-465,0,383.1>
  }
  triangle { // #2950
		<-465,-99,383.1>,
		<-465,0,383.1>,
		<-465.15,-99,384.05>
  }
  triangle { // #2951
		<-465.25,0,384.95>,
		<-465.25,-99,384.95>,
		<-465.15,0,384.05>
  }
  triangle { // #2952
		<-465.15,-99,384.05>,
		<-465.15,0,384.05>,
		<-465.25,-99,384.95>
  }
  triangle { // #2953
		<-465.4,0,385.9>,
		<-465.4,-99,385.9>,
		<-465.25,0,384.95>
  }
  triangle { // #2954
		<-465.25,-99,384.95>,
		<-465.25,0,384.95>,
		<-465.4,-99,385.9>
  }
  triangle { // #2955
		<-465.55,0,386.85>,
		<-465.55,-99,386.85>,
		<-465.4,0,385.9>
  }
  triangle { // #2956
		<-465.4,-99,385.9>,
		<-465.4,0,385.9>,
		<-465.55,-99,386.85>
  }
  triangle { // #2957
		<-465.7,0,387.8>,
		<-465.7,-99,387.8>,
		<-465.55,0,386.85>
  }
  triangle { // #2958
		<-465.55,-99,386.85>,
		<-465.55,0,386.85>,
		<-465.7,-99,387.8>
  }
  triangle { // #2959
		<-465.85,0,388.75>,
		<-465.85,-99,388.75>,
		<-465.7,0,387.8>
  }
  triangle { // #2960
		<-465.7,-99,387.8>,
		<-465.7,0,387.8>,
		<-465.85,-99,388.75>
  }
  triangle { // #2961
		<-466,0,389.7>,
		<-466,-99,389.7>,
		<-465.85,0,388.75>
  }
  triangle { // #2962
		<-465.85,-99,388.75>,
		<-465.85,0,388.75>,
		<-466,-99,389.7>
  }
  triangle { // #2963
		<-466.15,0,390.6>,
		<-466.15,-99,390.6>,
		<-466,0,389.7>
  }
  triangle { // #2964
		<-466,-99,389.7>,
		<-466,0,389.7>,
		<-466.15,-99,390.6>
  }
  triangle { // #2965
		<-466.3,0,391.55>,
		<-466.3,-99,391.55>,
		<-466.15,0,390.6>
  }
  triangle { // #2966
		<-466.15,-99,390.6>,
		<-466.15,0,390.6>,
		<-466.3,-99,391.55>
  }
  triangle { // #2967
		<-466.45,0,392.5>,
		<-466.45,-99,392.5>,
		<-466.3,0,391.55>
  }
  triangle { // #2968
		<-466.3,-99,391.55>,
		<-466.3,0,391.55>,
		<-466.45,-99,392.5>
  }
  triangle { // #2969
		<-466.6,0,393.45>,
		<-466.6,-99,393.45>,
		<-466.45,0,392.5>
  }
  triangle { // #2970
		<-466.45,-99,392.5>,
		<-466.45,0,392.5>,
		<-466.6,-99,393.45>
  }
  triangle { // #2971
		<-466.75,0,394.35>,
		<-466.75,-99,394.35>,
		<-466.6,0,393.45>
  }
  triangle { // #2972
		<-466.6,-99,393.45>,
		<-466.6,0,393.45>,
		<-466.75,-99,394.35>
  }
  triangle { // #2973
		<-466.95,0,395.3>,
		<-466.95,-99,395.3>,
		<-466.75,0,394.35>
  }
  triangle { // #2974
		<-466.75,-99,394.35>,
		<-466.75,0,394.35>,
		<-466.95,-99,395.3>
  }
  triangle { // #2975
		<-467.1,0,396.25>,
		<-467.1,-99,396.25>,
		<-466.95,0,395.3>
  }
  triangle { // #2976
		<-466.95,-99,395.3>,
		<-466.95,0,395.3>,
		<-467.1,-99,396.25>
  }
  triangle { // #2977
		<-467.25,0,397.2>,
		<-467.25,-99,397.2>,
		<-467.1,0,396.25>
  }
  triangle { // #2978
		<-467.1,-99,396.25>,
		<-467.1,0,396.25>,
		<-467.25,-99,397.2>
  }
  triangle { // #2979
		<-467.45,0,398.1>,
		<-467.45,-99,398.1>,
		<-467.25,0,397.2>
  }
  triangle { // #2980
		<-467.25,-99,397.2>,
		<-467.25,0,397.2>,
		<-467.45,-99,398.1>
  }
  triangle { // #2981
		<-467.65,0,399.05>,
		<-467.65,-99,399.05>,
		<-467.45,0,398.1>
  }
  triangle { // #2982
		<-467.45,-99,398.1>,
		<-467.45,0,398.1>,
		<-467.65,-99,399.05>
  }
  triangle { // #2983
		<-467.8,0,399.95>,
		<-467.8,-99,399.95>,
		<-467.65,0,399.05>
  }
  triangle { // #2984
		<-467.65,-99,399.05>,
		<-467.65,0,399.05>,
		<-467.8,-99,399.95>
  }
  triangle { // #2985
		<-468,0,400.9>,
		<-468,-99,400.9>,
		<-467.8,0,399.95>
  }
  triangle { // #2986
		<-467.8,-99,399.95>,
		<-467.8,0,399.95>,
		<-468,-99,400.9>
  }
  triangle { // #2987
		<-468.2,0,401.8>,
		<-468.2,-99,401.8>,
		<-468,0,400.9>
  }
  triangle { // #2988
		<-468,-99,400.9>,
		<-468,0,400.9>,
		<-468.2,-99,401.8>
  }
  triangle { // #2989
		<-468.4,0,402.75>,
		<-468.4,-99,402.75>,
		<-468.2,0,401.8>
  }
  triangle { // #2990
		<-468.2,-99,401.8>,
		<-468.2,0,401.8>,
		<-468.4,-99,402.75>
  }
  triangle { // #2991
		<-468.65,0,403.65>,
		<-468.65,-99,403.65>,
		<-468.4,0,402.75>
  }
  triangle { // #2992
		<-468.4,-99,402.75>,
		<-468.4,0,402.75>,
		<-468.65,-99,403.65>
  }
  triangle { // #2993
		<-468.85,0,404.6>,
		<-468.85,-99,404.6>,
		<-468.65,0,403.65>
  }
  triangle { // #2994
		<-468.65,-99,403.65>,
		<-468.65,0,403.65>,
		<-468.85,-99,404.6>
  }
  triangle { // #2995
		<-469.05,0,405.5>,
		<-469.05,-99,405.5>,
		<-468.85,0,404.6>
  }
  triangle { // #2996
		<-468.85,-99,404.6>,
		<-468.85,0,404.6>,
		<-469.05,-99,405.5>
  }
  triangle { // #2997
		<-469.3,0,406.4>,
		<-469.3,-99,406.4>,
		<-469.05,0,405.5>
  }
  triangle { // #2998
		<-469.05,-99,405.5>,
		<-469.05,0,405.5>,
		<-469.3,-99,406.4>
  }
  triangle { // #2999
		<-469.5,0,407.35>,
		<-469.5,-99,407.35>,
		<-469.3,0,406.4>
  }
  triangle { // #3000
		<-469.3,-99,406.4>,
		<-469.3,0,406.4>,
		<-469.5,-99,407.35>
  }
  triangle { // #3001
		<-469.75,0,408.25>,
		<-469.75,-99,408.25>,
		<-469.5,0,407.35>
  }
  triangle { // #3002
		<-469.5,-99,407.35>,
		<-469.5,0,407.35>,
		<-469.75,-99,408.25>
  }
  triangle { // #3003
		<-470,0,409.15>,
		<-470,-99,409.15>,
		<-469.75,0,408.25>
  }
  triangle { // #3004
		<-469.75,-99,408.25>,
		<-469.75,0,408.25>,
		<-470,-99,409.15>
  }
  triangle { // #3005
		<-470.25,0,410.05>,
		<-470.25,-99,410.05>,
		<-470,0,409.15>
  }
  triangle { // #3006
		<-470,-99,409.15>,
		<-470,0,409.15>,
		<-470.25,-99,410.05>
  }
  triangle { // #3007
		<-470.55,0,410.95>,
		<-470.55,-99,410.95>,
		<-470.25,0,410.05>
  }
  triangle { // #3008
		<-470.25,-99,410.05>,
		<-470.25,0,410.05>,
		<-470.55,-99,410.95>
  }
  triangle { // #3009
		<-470.85,0,411.85>,
		<-470.85,-99,411.85>,
		<-470.55,0,410.95>
  }
  triangle { // #3010
		<-470.55,-99,410.95>,
		<-470.55,0,410.95>,
		<-470.85,-99,411.85>
  }
  triangle { // #3011
		<-471.15,0,412.75>,
		<-471.15,-99,412.75>,
		<-470.85,0,411.85>
  }
  triangle { // #3012
		<-470.85,-99,411.85>,
		<-470.85,0,411.85>,
		<-471.15,-99,412.75>
  }
  triangle { // #3013
		<-471.45,0,413.65>,
		<-471.45,-99,413.65>,
		<-471.15,0,412.75>
  }
  triangle { // #3014
		<-471.15,-99,412.75>,
		<-471.15,0,412.75>,
		<-471.45,-99,413.65>
  }
  triangle { // #3015
		<-471.75,0,414.55>,
		<-471.75,-99,414.55>,
		<-471.45,0,413.65>
  }
  triangle { // #3016
		<-471.45,-99,413.65>,
		<-471.45,0,413.65>,
		<-471.75,-99,414.55>
  }
  triangle { // #3017
		<-472.1,0,415.4>,
		<-472.1,-99,415.4>,
		<-471.75,0,414.55>
  }
  triangle { // #3018
		<-471.75,-99,414.55>,
		<-471.75,0,414.55>,
		<-472.1,-99,415.4>
  }
  triangle { // #3019
		<-472.45,0,416.3>,
		<-472.45,-99,416.3>,
		<-472.1,0,415.4>
  }
  triangle { // #3020
		<-472.1,-99,415.4>,
		<-472.1,0,415.4>,
		<-472.45,-99,416.3>
  }
  triangle { // #3021
		<-472.85,0,417.15>,
		<-472.85,-99,417.15>,
		<-472.45,0,416.3>
  }
  triangle { // #3022
		<-472.45,-99,416.3>,
		<-472.45,0,416.3>,
		<-472.85,-99,417.15>
  }
  triangle { // #3023
		<-473.2,0,418.05>,
		<-473.2,-99,418.05>,
		<-472.85,0,417.15>
  }
  triangle { // #3024
		<-472.85,-99,417.15>,
		<-472.85,0,417.15>,
		<-473.2,-99,418.05>
  }
  triangle { // #3025
		<-473.6,0,418.9>,
		<-473.6,-99,418.9>,
		<-473.2,0,418.05>
  }
  triangle { // #3026
		<-473.2,-99,418.05>,
		<-473.2,0,418.05>,
		<-473.6,-99,418.9>
  }
  triangle { // #3027
		<-474,0,419.75>,
		<-474,-99,419.75>,
		<-473.6,0,418.9>
  }
  triangle { // #3028
		<-473.6,-99,418.9>,
		<-473.6,0,418.9>,
		<-474,-99,419.75>
  }
  triangle { // #3029
		<-474.45,0,420.6>,
		<-474.45,-99,420.6>,
		<-474,0,419.75>
  }
  triangle { // #3030
		<-474,-99,419.75>,
		<-474,0,419.75>,
		<-474.45,-99,420.6>
  }
  triangle { // #3031
		<-474.9,0,421.5>,
		<-474.9,-99,421.5>,
		<-474.45,0,420.6>
  }
  triangle { // #3032
		<-474.45,-99,420.6>,
		<-474.45,0,420.6>,
		<-474.9,-99,421.5>
  }
  triangle { // #3033
		<-475.35,0,422.35>,
		<-475.35,-99,422.35>,
		<-474.9,0,421.5>
  }
  triangle { // #3034
		<-474.9,-99,421.5>,
		<-474.9,0,421.5>,
		<-475.35,-99,422.35>
  }
  triangle { // #3035
		<-475.8,0,423.15>,
		<-475.8,-99,423.15>,
		<-475.35,0,422.35>
  }
  triangle { // #3036
		<-475.35,-99,422.35>,
		<-475.35,0,422.35>,
		<-475.8,-99,423.15>
  }
  triangle { // #3037
		<-476.25,0,424>,
		<-476.25,-99,424>,
		<-475.8,0,423.15>
  }
  triangle { // #3038
		<-475.8,-99,423.15>,
		<-475.8,0,423.15>,
		<-476.25,-99,424>
  }
  triangle { // #3039
		<-476.75,0,424.85>,
		<-476.75,-99,424.85>,
		<-476.25,0,424>
  }
  triangle { // #3040
		<-476.25,-99,424>,
		<-476.25,0,424>,
		<-476.75,-99,424.85>
  }
  triangle { // #3041
		<-477.2,0,425.7>,
		<-477.2,-99,425.7>,
		<-476.75,0,424.85>
  }
  triangle { // #3042
		<-476.75,-99,424.85>,
		<-476.75,0,424.85>,
		<-477.2,-99,425.7>
  }
  triangle { // #3043
		<-477.7,0,426.55>,
		<-477.7,-99,426.55>,
		<-477.2,0,425.7>
  }
  triangle { // #3044
		<-477.2,-99,425.7>,
		<-477.2,0,425.7>,
		<-477.7,-99,426.55>
  }
  triangle { // #3045
		<-478.2,0,427.35>,
		<-478.2,-99,427.35>,
		<-477.7,0,426.55>
  }
  triangle { // #3046
		<-477.7,-99,426.55>,
		<-477.7,0,426.55>,
		<-478.2,-99,427.35>
  }
  triangle { // #3047
		<-478.7,0,428.2>,
		<-478.7,-99,428.2>,
		<-478.2,0,427.35>
  }
  triangle { // #3048
		<-478.2,-99,427.35>,
		<-478.2,0,427.35>,
		<-478.7,-99,428.2>
  }
  triangle { // #3049
		<-479.2,0,429>,
		<-479.2,-99,429>,
		<-478.7,0,428.2>
  }
  triangle { // #3050
		<-478.7,-99,428.2>,
		<-478.7,0,428.2>,
		<-479.2,-99,429>
  }
  triangle { // #3051
		<-479.75,0,429.85>,
		<-479.75,-99,429.85>,
		<-479.2,0,429>
  }
  triangle { // #3052
		<-479.2,-99,429>,
		<-479.2,0,429>,
		<-479.75,-99,429.85>
  }
  triangle { // #3053
		<-480.25,0,430.65>,
		<-480.25,-99,430.65>,
		<-479.75,0,429.85>
  }
  triangle { // #3054
		<-479.75,-99,429.85>,
		<-479.75,0,429.85>,
		<-480.25,-99,430.65>
  }
  triangle { // #3055
		<-480.8,0,431.5>,
		<-480.8,-99,431.5>,
		<-480.25,0,430.65>
  }
  triangle { // #3056
		<-480.25,-99,430.65>,
		<-480.25,0,430.65>,
		<-480.8,-99,431.5>
  }
  triangle { // #3057
		<-481.35,0,432.3>,
		<-481.35,-99,432.3>,
		<-480.8,0,431.5>
  }
  triangle { // #3058
		<-480.8,-99,431.5>,
		<-480.8,0,431.5>,
		<-481.35,-99,432.3>
  }
  triangle { // #3059
		<-481.9,0,433.15>,
		<-481.9,-99,433.15>,
		<-481.35,0,432.3>
  }
  triangle { // #3060
		<-481.35,-99,432.3>,
		<-481.35,0,432.3>,
		<-481.9,-99,433.15>
  }
  triangle { // #3061
		<-482.45,0,433.95>,
		<-482.45,-99,433.95>,
		<-481.9,0,433.15>
  }
  triangle { // #3062
		<-481.9,-99,433.15>,
		<-481.9,0,433.15>,
		<-482.45,-99,433.95>
  }
  triangle { // #3063
		<-483.05,0,434.75>,
		<-483.05,-99,434.75>,
		<-482.45,0,433.95>
  }
  triangle { // #3064
		<-482.45,-99,433.95>,
		<-482.45,0,433.95>,
		<-483.05,-99,434.75>
  }
  triangle { // #3065
		<-483.6,0,435.55>,
		<-483.6,-99,435.55>,
		<-483.05,0,434.75>
  }
  triangle { // #3066
		<-483.05,-99,434.75>,
		<-483.05,0,434.75>,
		<-483.6,-99,435.55>
  }
  triangle { // #3067
		<-484.2,0,436.35>,
		<-484.2,-99,436.35>,
		<-483.6,0,435.55>
  }
  triangle { // #3068
		<-483.6,-99,435.55>,
		<-483.6,0,435.55>,
		<-484.2,-99,436.35>
  }
  triangle { // #3069
		<-484.8,0,437.15>,
		<-484.8,-99,437.15>,
		<-484.2,0,436.35>
  }
  triangle { // #3070
		<-484.2,-99,436.35>,
		<-484.2,0,436.35>,
		<-484.8,-99,437.15>
  }
  triangle { // #3071
		<-485.45,0,437.95>,
		<-485.45,-99,437.95>,
		<-484.8,0,437.15>
  }
  triangle { // #3072
		<-484.8,-99,437.15>,
		<-484.8,0,437.15>,
		<-485.45,-99,437.95>
  }
  triangle { // #3073
		<-486.1,0,438.75>,
		<-486.1,-99,438.75>,
		<-485.45,0,437.95>
  }
  triangle { // #3074
		<-485.45,-99,437.95>,
		<-485.45,0,437.95>,
		<-486.1,-99,438.75>
  }
  triangle { // #3075
		<-486.75,0,439.55>,
		<-486.75,-99,439.55>,
		<-486.1,0,438.75>
  }
  triangle { // #3076
		<-486.1,-99,438.75>,
		<-486.1,0,438.75>,
		<-486.75,-99,439.55>
  }
  triangle { // #3077
		<-487.45,0,440.3>,
		<-487.45,-99,440.3>,
		<-486.75,0,439.55>
  }
  triangle { // #3078
		<-486.75,-99,439.55>,
		<-486.75,0,439.55>,
		<-487.45,-99,440.3>
  }
  triangle { // #3079
		<-488.15,0,441.1>,
		<-488.15,-99,441.1>,
		<-487.45,0,440.3>
  }
  triangle { // #3080
		<-487.45,-99,440.3>,
		<-487.45,0,440.3>,
		<-488.15,-99,441.1>
  }
  triangle { // #3081
		<-488.9,0,441.85>,
		<-488.9,-99,441.85>,
		<-488.15,0,441.1>
  }
  triangle { // #3082
		<-488.15,-99,441.1>,
		<-488.15,0,441.1>,
		<-488.9,-99,441.85>
  }
  triangle { // #3083
		<-489.65,0,442.6>,
		<-489.65,-99,442.6>,
		<-488.9,0,441.85>
  }
  triangle { // #3084
		<-488.9,-99,441.85>,
		<-488.9,0,441.85>,
		<-489.65,-99,442.6>
  }
  triangle { // #3085
		<-490.4,0,443.35>,
		<-490.4,-99,443.35>,
		<-489.65,0,442.6>
  }
  triangle { // #3086
		<-489.65,-99,442.6>,
		<-489.65,0,442.6>,
		<-490.4,-99,443.35>
  }
  triangle { // #3087
		<-491.15,0,444.15>,
		<-491.15,-99,444.15>,
		<-490.4,0,443.35>
  }
  triangle { // #3088
		<-490.4,-99,443.35>,
		<-490.4,0,443.35>,
		<-491.15,-99,444.15>
  }
  triangle { // #3089
		<-492,0,444.9>,
		<-492,-99,444.9>,
		<-491.15,0,444.15>
  }
  triangle { // #3090
		<-491.15,-99,444.15>,
		<-491.15,0,444.15>,
		<-492,-99,444.9>
  }
  triangle { // #3091
		<-492.8,0,445.6>,
		<-492.8,-99,445.6>,
		<-492,0,444.9>
  }
  triangle { // #3092
		<-492,-99,444.9>,
		<-492,0,444.9>,
		<-492.8,-99,445.6>
  }
  triangle { // #3093
		<-493.65,0,446.35>,
		<-493.65,-99,446.35>,
		<-492.8,0,445.6>
  }
  triangle { // #3094
		<-492.8,-99,445.6>,
		<-492.8,0,445.6>,
		<-493.65,-99,446.35>
  }
  triangle { // #3095
		<-494.5,0,447.1>,
		<-494.5,-99,447.1>,
		<-493.65,0,446.35>
  }
  triangle { // #3096
		<-493.65,-99,446.35>,
		<-493.65,0,446.35>,
		<-494.5,-99,447.1>
  }
  triangle { // #3097
		<-495.4,0,447.85>,
		<-495.4,-99,447.85>,
		<-494.5,0,447.1>
  }
  triangle { // #3098
		<-494.5,-99,447.1>,
		<-494.5,0,447.1>,
		<-495.4,-99,447.85>
  }
  triangle { // #3099
		<-496.25,0,448.55>,
		<-496.25,-99,448.55>,
		<-495.4,0,447.85>
  }
  triangle { // #3100
		<-495.4,-99,447.85>,
		<-495.4,0,447.85>,
		<-496.25,-99,448.55>
  }
  triangle { // #3101
		<-497.15,0,449.25>,
		<-497.15,-99,449.25>,
		<-496.25,0,448.55>
  }
  triangle { // #3102
		<-496.25,-99,448.55>,
		<-496.25,0,448.55>,
		<-497.15,-99,449.25>
  }
  triangle { // #3103
		<-498.1,0,449.95>,
		<-498.1,-99,449.95>,
		<-497.15,0,449.25>
  }
  triangle { // #3104
		<-497.15,-99,449.25>,
		<-497.15,0,449.25>,
		<-498.1,-99,449.95>
  }
  triangle { // #3105
		<-499,0,450.65>,
		<-499,-99,450.65>,
		<-498.1,0,449.95>
  }
  triangle { // #3106
		<-498.1,-99,449.95>,
		<-498.1,0,449.95>,
		<-499,-99,450.65>
  }
  triangle { // #3107
		<-499.95,0,451.35>,
		<-499.95,-99,451.35>,
		<-499,0,450.65>
  }
  triangle { // #3108
		<-499,-99,450.65>,
		<-499,0,450.65>,
		<-499.95,-99,451.35>
  }
  triangle { // #3109
		<-500.85,0,452.05>,
		<-500.85,-99,452.05>,
		<-499.95,0,451.35>
  }
  triangle { // #3110
		<-499.95,-99,451.35>,
		<-499.95,0,451.35>,
		<-500.85,-99,452.05>
  }
  triangle { // #3111
		<-501.8,0,452.7>,
		<-501.8,-99,452.7>,
		<-500.85,0,452.05>
  }
  triangle { // #3112
		<-500.85,-99,452.05>,
		<-500.85,0,452.05>,
		<-501.8,-99,452.7>
  }
  triangle { // #3113
		<-502.75,0,453.4>,
		<-502.75,-99,453.4>,
		<-501.8,0,452.7>
  }
  triangle { // #3114
		<-501.8,-99,452.7>,
		<-501.8,0,452.7>,
		<-502.75,-99,453.4>
  }
  triangle { // #3115
		<-503.7,0,454.05>,
		<-503.7,-99,454.05>,
		<-502.75,0,453.4>
  }
  triangle { // #3116
		<-502.75,-99,453.4>,
		<-502.75,0,453.4>,
		<-503.7,-99,454.05>
  }
  triangle { // #3117
		<-504.7,0,454.7>,
		<-504.7,-99,454.7>,
		<-503.7,0,454.05>
  }
  triangle { // #3118
		<-503.7,-99,454.05>,
		<-503.7,0,454.05>,
		<-504.7,-99,454.7>
  }
  triangle { // #3119
		<-505.65,0,455.35>,
		<-505.65,-99,455.35>,
		<-504.7,0,454.7>
  }
  triangle { // #3120
		<-504.7,-99,454.7>,
		<-504.7,0,454.7>,
		<-505.65,-99,455.35>
  }
  triangle { // #3121
		<-506.65,-0,456>,
		<-506.65,-99,456>,
		<-505.65,0,455.35>
  }
  triangle { // #3122
		<-505.65,-99,455.35>,
		<-505.65,0,455.35>,
		<-506.65,-99,456>
  }
  triangle { // #3123
		<-507.65,-0,456.6>,
		<-507.65,-99,456.6>,
		<-506.65,-0,456>
  }
  triangle { // #3124
		<-506.65,-99,456>,
		<-506.65,-0,456>,
		<-507.65,-99,456.6>
  }
  triangle { // #3125
		<-508.65,-0,457.25>,
		<-508.65,-99,457.25>,
		<-507.65,-0,456.6>
  }
  triangle { // #3126
		<-507.65,-99,456.6>,
		<-507.65,-0,456.6>,
		<-508.65,-99,457.25>
  }
  triangle { // #3127
		<-509.65,-0,457.85>,
		<-509.65,-99,457.85>,
		<-508.65,-0,457.25>
  }
  triangle { // #3128
		<-508.65,-99,457.25>,
		<-508.65,-0,457.25>,
		<-509.65,-99,457.85>
  }
  triangle { // #3129
		<-510.65,-0,458.45>,
		<-510.65,-99,458.45>,
		<-509.65,-0,457.85>
  }
  triangle { // #3130
		<-509.65,-99,457.85>,
		<-509.65,-0,457.85>,
		<-510.65,-99,458.45>
  }
  triangle { // #3131
		<-511.7,-0,459.05>,
		<-511.7,-99,459.05>,
		<-510.65,-0,458.45>
  }
  triangle { // #3132
		<-510.65,-99,458.45>,
		<-510.65,-0,458.45>,
		<-511.7,-99,459.05>
  }
  triangle { // #3133
		<-512.8,-0,459.65>,
		<-512.8,-99,459.65>,
		<-511.7,-0,459.05>
  }
  triangle { // #3134
		<-511.7,-99,459.05>,
		<-511.7,-0,459.05>,
		<-512.8,-99,459.65>
  }
  triangle { // #3135
		<-513.95,-0,460.3>,
		<-513.95,-99,460.3>,
		<-512.8,-0,459.65>
  }
  triangle { // #3136
		<-512.8,-99,459.65>,
		<-512.8,-0,459.65>,
		<-513.95,-99,460.3>
  }
  triangle { // #3137
		<-515.15,-0,460.9>,
		<-515.15,-99,460.9>,
		<-513.95,-0,460.3>
  }
  triangle { // #3138
		<-513.95,-99,460.3>,
		<-513.95,-0,460.3>,
		<-515.15,-99,460.9>
  }
  triangle { // #3139
		<-516.4,-0,461.5>,
		<-516.4,-99,461.5>,
		<-515.15,-0,460.9>
  }
  triangle { // #3140
		<-515.15,-99,460.9>,
		<-515.15,-0,460.9>,
		<-516.4,-99,461.5>
  }
  triangle { // #3141
		<-517.7,-0,462.15>,
		<-517.7,-99,462.15>,
		<-516.4,-0,461.5>
  }
  triangle { // #3142
		<-516.4,-99,461.5>,
		<-516.4,-0,461.5>,
		<-517.7,-99,462.15>
  }
  triangle { // #3143
		<-519.05,-0,462.8>,
		<-519.05,-99,462.8>,
		<-517.7,-0,462.15>
  }
  triangle { // #3144
		<-517.7,-99,462.15>,
		<-517.7,-0,462.15>,
		<-519.05,-99,462.8>
  }
  triangle { // #3145
		<-520.45,-0,463.4>,
		<-520.45,-99,463.4>,
		<-519.05,-0,462.8>
  }
  triangle { // #3146
		<-519.05,-99,462.8>,
		<-519.05,-0,462.8>,
		<-520.45,-99,463.4>
  }
  triangle { // #3147
		<-521.9,-0,464.05>,
		<-521.9,-99,464.05>,
		<-520.45,-0,463.4>
  }
  triangle { // #3148
		<-520.45,-99,463.4>,
		<-520.45,-0,463.4>,
		<-521.9,-99,464.05>
  }
  triangle { // #3149
		<-523.4,-0,464.7>,
		<-523.4,-99,464.7>,
		<-521.9,-0,464.05>
  }
  triangle { // #3150
		<-521.9,-99,464.05>,
		<-521.9,-0,464.05>,
		<-523.4,-99,464.7>
  }
  triangle { // #3151
		<-524.95,-0,465.35>,
		<-524.95,-99,465.35>,
		<-523.4,-0,464.7>
  }
  triangle { // #3152
		<-523.4,-99,464.7>,
		<-523.4,-0,464.7>,
		<-524.95,-99,465.35>
  }
  triangle { // #3153
		<-526.55,-0,466>,
		<-526.55,-99,466>,
		<-524.95,-0,465.35>
  }
  triangle { // #3154
		<-524.95,-99,465.35>,
		<-524.95,-0,465.35>,
		<-526.55,-99,466>
  }
  triangle { // #3155
		<-528.2,-0,466.7>,
		<-528.2,-99,466.7>,
		<-526.55,-0,466>
  }
  triangle { // #3156
		<-526.55,-99,466>,
		<-526.55,-0,466>,
		<-528.2,-99,466.7>
  }
  triangle { // #3157
		<-529.9,-0,467.35>,
		<-529.9,-99,467.35>,
		<-528.2,-0,466.7>
  }
  triangle { // #3158
		<-528.2,-99,466.7>,
		<-528.2,-0,466.7>,
		<-529.9,-99,467.35>
  }
  triangle { // #3159
		<-531.65,-0,468>,
		<-531.65,-99,468>,
		<-529.9,-0,467.35>
  }
  triangle { // #3160
		<-529.9,-99,467.35>,
		<-529.9,-0,467.35>,
		<-531.65,-99,468>
  }
  smooth_triangle { // #3161
		<-533.45,-0,468.7>, <0.334,-0.943,0>,
		<-533.45,-99,468.7>, <0.343,-0.939,0>,
		<-531.65,-0,468>, <0.354,-0.935,0>
  }
  triangle { // #3162
		<-531.65,-99,468>,
		<-531.65,-0,468>,
		<-533.45,-99,468.7>
  }
  smooth_triangle { // #3163
		<-535.3,-0,469.35>, <0.293,-0.956,0>,
		<-535.3,-99,469.35>, <0.309,-0.951,0>,
		<-533.45,-0,468.7>, <0.334,-0.943,0>
  }
  smooth_triangle { // #3164
		<-533.45,-99,468.7>, <0.343,-0.939,0>,
		<-533.45,-0,468.7>, <0.334,-0.943,0>,
		<-535.3,-99,469.35>, <0.309,-0.951,0>
  }
  smooth_triangle { // #3165
		<-537.15,-0,469.85>, <0.244,-0.97,0>,
		<-537.15,-99,469.85>, <0.261,-0.965,0>,
		<-535.3,-0,469.35>, <0.293,-0.956,0>
  }
  smooth_triangle { // #3166
		<-535.3,-99,469.35>, <0.309,-0.951,0>,
		<-535.3,-0,469.35>, <0.293,-0.956,0>,
		<-537.15,-99,469.85>, <0.261,-0.965,0>
  }
  smooth_triangle { // #3167
		<-539,-0,470.3>, <0.195,-0.981,0>,
		<-539,-99,470.3>, <0.211,-0.977,0>,
		<-537.15,-0,469.85>, <0.244,-0.97,0>
  }
  smooth_triangle { // #3168
		<-537.15,-99,469.85>, <0.261,-0.965,0>,
		<-537.15,-0,469.85>, <0.244,-0.97,0>,
		<-539,-99,470.3>, <0.211,-0.977,0>
  }
  smooth_triangle { // #3169
		<-540.9,-0,470.65>, <0.144,-0.99,0>,
		<-540.9,-99,470.65>, <0.161,-0.987,0>,
		<-539,-0,470.3>, <0.195,-0.981,0>
  }
  smooth_triangle { // #3170
		<-539,-99,470.3>, <0.211,-0.977,0>,
		<-539,-0,470.3>, <0.195,-0.981,0>,
		<-540.9,-99,470.65>, <0.161,-0.987,0>
  }
  smooth_triangle { // #3171
		<-542.8,-0,470.9>, <0.094,-0.996,0>,
		<-542.8,-99,470.9>, <0.11,-0.994,0>,
		<-540.9,-0,470.65>, <0.144,-0.99,0>
  }
  smooth_triangle { // #3172
		<-540.9,-99,470.65>, <0.161,-0.987,0>,
		<-540.9,-0,470.65>, <0.144,-0.99,0>,
		<-542.8,-99,470.9>, <0.11,-0.994,0>
  }
  smooth_triangle { // #3173
		<-544.7,-0,471.05>, <0.043,-0.999,0>,
		<-544.7,-99,471.05>, <0.06,-0.998,0>,
		<-542.8,-0,470.9>, <0.094,-0.996,0>
  }
  smooth_triangle { // #3174
		<-542.8,-99,470.9>, <0.11,-0.994,0>,
		<-542.8,-0,470.9>, <0.094,-0.996,0>,
		<-544.7,-99,471.05>, <0.06,-0.998,0>
  }
  smooth_triangle { // #3175
		<-546.65,-0,471.1>, <-0.007,-1,0>,
		<-546.65,-99,471.1>, <0.01,-1,0>,
		<-544.7,-0,471.05>, <0.043,-0.999,0>
  }
  smooth_triangle { // #3176
		<-544.7,-99,471.05>, <0.06,-0.998,0>,
		<-544.7,-0,471.05>, <0.043,-0.999,0>,
		<-546.65,-99,471.1>, <0.01,-1,0>
  }
  smooth_triangle { // #3177
		<-548.6,-0,471.05>, <-0.056,-0.998,0>,
		<-548.6,-99,471.05>, <-0.039,-0.999,0>,
		<-546.65,-0,471.1>, <-0.007,-1,0>
  }
  smooth_triangle { // #3178
		<-546.65,-99,471.1>, <0.01,-1,0>,
		<-546.65,-0,471.1>, <-0.007,-1,0>,
		<-548.6,-99,471.05>, <-0.039,-0.999,0>
  }
  smooth_triangle { // #3179
		<-550.6,-0,470.9>, <-0.103,-0.995,0>,
		<-550.6,-99,470.9>, <-0.087,-0.996,0>,
		<-548.6,-0,471.05>, <-0.056,-0.998,0>
  }
  smooth_triangle { // #3180
		<-548.6,-99,471.05>, <-0.039,-0.999,0>,
		<-548.6,-0,471.05>, <-0.056,-0.998,0>,
		<-550.6,-99,470.9>, <-0.087,-0.996,0>
  }
  smooth_triangle { // #3181
		<-552.6,-0,470.65>, <-0.149,-0.989,0>,
		<-552.6,-99,470.65>, <-0.134,-0.991,0>,
		<-550.6,-0,470.9>, <-0.103,-0.995,0>
  }
  smooth_triangle { // #3182
		<-550.6,-99,470.9>, <-0.087,-0.996,0>,
		<-550.6,-0,470.9>, <-0.103,-0.995,0>,
		<-552.6,-99,470.65>, <-0.134,-0.991,0>
  }
  smooth_triangle { // #3183
		<-554.6,-0,470.35>, <-0.194,-0.981,0>,
		<-554.6,-99,470.35>, <-0.179,-0.984,0>,
		<-552.6,-0,470.65>, <-0.149,-0.989,0>
  }
  smooth_triangle { // #3184
		<-552.6,-99,470.65>, <-0.134,-0.991,0>,
		<-552.6,-0,470.65>, <-0.149,-0.989,0>,
		<-554.6,-99,470.35>, <-0.179,-0.984,0>
  }
  smooth_triangle { // #3185
		<-556.6,-0,469.9>, <-0.236,-0.972,0>,
		<-556.6,-99,469.9>, <-0.222,-0.975,0>,
		<-554.6,-0,470.35>, <-0.194,-0.981,0>
  }
  smooth_triangle { // #3186
		<-554.6,-99,470.35>, <-0.179,-0.984,0>,
		<-554.6,-0,470.35>, <-0.194,-0.981,0>,
		<-556.6,-99,469.9>, <-0.222,-0.975,0>
  }
  smooth_triangle { // #3187
		<-558.65,-0,469.35>, <-0.277,-0.961,0>,
		<-558.65,-99,469.35>, <-0.264,-0.965,0>,
		<-556.6,-0,469.9>, <-0.236,-0.972,0>
  }
  smooth_triangle { // #3188
		<-556.6,-99,469.9>, <-0.222,-0.975,0>,
		<-556.6,-0,469.9>, <-0.236,-0.972,0>,
		<-558.65,-99,469.35>, <-0.264,-0.965,0>
  }
  smooth_triangle { // #3189
		<-560.2,-0,468.9>, <-0.4,-0.916,0>,
		<-560.2,-99,468.9>, <-0.346,-0.938,0>,
		<-558.65,-0,469.35>, <-0.277,-0.961,0>
  }
  smooth_triangle { // #3190
		<-558.65,-99,469.35>, <-0.264,-0.965,0>,
		<-558.65,-0,469.35>, <-0.277,-0.961,0>,
		<-560.2,-99,468.9>, <-0.346,-0.938,0>
  }
  triangle { // #3191
		<-435.1,0,272.6>,
		<-435.1,-99,272.6>,
		<-560.2,-0,468.9>
  }
  triangle { // #3192
		<-560.2,-99,468.9>,
		<-560.2,-0,468.9>,
		<-435.1,-99,272.6>
  }
  triangle { // #3193
		<-681.4,0,268.8>,
		<-605.85,0,312.75>,
		<-678.6,0,260.55>
  }
  triangle { // #3194
		<-435.1,0,272.6>,
		<-445.3,0,268.25>,
		<-560.2,-0,468.9>
  }
  triangle { // #3195
		<-1103.8,0,231.5>,
		<-840.35,0,231.5>,
		<-1103.8,0,28.2>
  }
  triangle { // #3196
		<-1103.8,0,28.2>,
		<-840.35,0,231.5>,
		<-445.3,0,29.5>
  }
  triangle { // #3197
		<-445.3,0,29.5>,
		<-840.35,0,231.5>,
		<-445.3,0,268.25>
  }
  triangle { // #3198
		<-560.2,-0,468.9>,
		<-445.3,0,268.25>,
		<-639.05,0,428.8>
  }
  triangle { // #3199
		<-639.05,0,428.8>,
		<-445.3,0,268.25>,
		<-605.85,0,312.75>
  }
  triangle { // #3200
		<-840.35,0,321.9>,
		<-727.7,0,340.9>,
		<-840.35,0,231.5>
  }
  triangle { // #3201
		<-727.7,0,340.9>,
		<-696.8,0,250.15>,
		<-840.35,0,231.5>
  }
  triangle { // #3202
		<-840.35,0,231.5>,
		<-696.8,0,250.15>,
		<-445.3,0,268.25>
  }
  triangle { // #3203
		<-696.8,0,250.15>,
		<-678.6,0,260.55>,
		<-445.3,0,268.25>
  }
  triangle { // #3204
		<-445.3,0,268.25>,
		<-678.6,0,260.55>,
		<-605.85,0,312.75>
  }
  triangle { // #3205
		<-681.4,-99,268.8>,
		<-678.6,-99,260.55>,
		<-605.85,-99,312.75>
  }
  triangle { // #3206
		<-435.1,-99,272.6>,
		<-560.2,-99,468.9>,
		<-445.3,-99,268.25>
  }
  triangle { // #3207
		<-1103.8,-99,231.5>,
		<-1103.8,-99,28.2>,
		<-840.35,-99,231.5>
  }
  triangle { // #3208
		<-1103.8,-99,28.2>,
		<-445.3,-99,28.2>,
		<-840.35,-99,231.5>
  }
  triangle { // #3209
		<-445.3,-99,28.2>,
		<-445.3,-99,268.25>,
		<-840.35,-99,231.5>
  }
  triangle { // #3210
		<-560.2,-99,468.9>,
		<-639.05,-99,428.8>,
		<-445.3,-99,268.25>
  }
  triangle { // #3211
		<-639.05,-99,428.8>,
		<-605.85,-99,312.75>,
		<-445.3,-99,268.25>
  }
  triangle { // #3212
		<-840.35,-99,321.9>,
		<-840.35,-99,231.5>,
		<-727.7,-99,340.9>
  }
  triangle { // #3213
		<-727.7,-99,340.9>,
		<-840.35,-99,231.5>,
		<-696.8,-99,250.15>
  }
  triangle { // #3214
		<-840.35,-99,231.5>,
		<-445.3,-99,268.25>,
		<-696.8,-99,250.15>
  }
  triangle { // #3215
		<-696.8,-99,250.15>,
		<-445.3,-99,268.25>,
		<-678.6,-99,260.55>
  }
  triangle { // #3216
		<-445.3,-99,268.25>,
		<-605.85,-99,312.75>,
		<-678.6,-99,260.55>
  }
  triangle { // #3217
		<-445.3,0,268.25>,
		<-445.3,-99,268.25>,
		<-445.3,0,29.5>
  }
  triangle { // #3218
		<-445.3,-99,28.2>,
		<-445.3,0,29.5>,
		<-445.3,-99,268.25>
  }
  triangle { // #3219
		<-435.1,0,272.6>,
		<-435.1,-99,272.6>,
		<-445.3,0,268.25>
  }
  triangle { // #3220
		<-445.3,-99,268.25>,
		<-445.3,0,268.25>,
		<-435.1,-99,272.6>
  }
  triangle { // #3221
		<-560.2,-0,468.9>,
		<-560.2,-99,468.9>,
		<-435.1,0,272.6>
  }
  triangle { // #3222
		<-435.1,-99,272.6>,
		<-435.1,0,272.6>,
		<-560.2,-99,468.9>
  }
  smooth_triangle { // #3223
		<-639.05,0,428.8>, <-0.453,-0.891,0>,
		<-639.05,-99,428.8>, <-0.453,-0.891,0>,
		<-560.2,-0,468.9>, <-0.4,-0.916,0>
  }
  smooth_triangle { // #3224
		<-560.2,-99,468.9>, <-0.346,-0.938,0>,
		<-560.2,-0,468.9>, <-0.4,-0.916,0>,
		<-639.05,-99,428.8>, <-0.453,-0.891,0>
  }
  triangle { // #3225
		<-605.85,0,312.75>,
		<-605.85,-99,312.75>,
		<-639.05,0,428.8>
  }
  triangle { // #3226
		<-639.05,-99,428.8>,
		<-639.05,0,428.8>,
		<-605.85,-99,312.75>
  }
  triangle { // #3227
		<-681.4,0,268.8>,
		<-681.4,-99,268.8>,
		<-605.85,0,312.75>
  }
  triangle { // #3228
		<-605.85,-99,312.75>,
		<-605.85,0,312.75>,
		<-681.4,-99,268.8>
  }
  triangle { // #3229
		<-678.6,0,260.55>,
		<-678.6,-99,260.55>,
		<-681.4,0,268.8>
  }
  triangle { // #3230
		<-681.4,-99,268.8>,
		<-681.4,0,268.8>,
		<-678.6,-99,260.55>
  }
  triangle { // #3231
		<-696.8,0,250.15>,
		<-696.8,-99,250.15>,
		<-678.6,0,260.55>
  }
  triangle { // #3232
		<-678.6,-99,260.55>,
		<-678.6,0,260.55>,
		<-696.8,-99,250.15>
  }
  triangle { // #3233
		<-727.7,0,340.9>,
		<-727.7,-99,340.9>,
		<-696.8,0,250.15>
  }
  triangle { // #3234
		<-696.8,-99,250.15>,
		<-696.8,0,250.15>,
		<-727.7,-99,340.9>
  }
  triangle { // #3235
		<-840.35,0,321.9>,
		<-840.35,-99,321.9>,
		<-727.7,0,340.9>
  }
  triangle { // #3236
		<-727.7,-99,340.9>,
		<-727.7,0,340.9>,
		<-840.35,-99,321.9>
  }
  triangle { // #3237
		<-840.35,0,231.5>,
		<-840.35,-99,231.5>,
		<-840.35,0,321.9>
  }
  triangle { // #3238
		<-840.35,-99,321.9>,
		<-840.35,0,321.9>,
		<-840.35,-99,231.5>
  }
  triangle { // #3239
		<-1103.8,0,231.5>,
		<-1103.8,-99,231.5>,
		<-840.35,0,231.5>
  }
  triangle { // #3240
		<-840.35,-99,231.5>,
		<-840.35,0,231.5>,
		<-1103.8,-99,231.5>
  }
  triangle { // #3241
		<-1103.8,0,28.2>,
		<-1103.8,-99,28.2>,
		<-1103.8,0,231.5>
  }
  triangle { // #3242
		<-1103.8,-99,231.5>,
		<-1103.8,0,231.5>,
		<-1103.8,-99,28.2>
  }
  triangle { // #3243
		<-445.3,0,29.5>,
		<-445.3,-99,28.2>,
		<-1103.8,0,28.2>
  }
  triangle { // #3244
		<-1103.8,-99,28.2>,
		<-1103.8,0,28.2>,
		<-445.3,-99,28.2>
  }
  triangle { // #3245
		<-351,0,172.95>,
		<-445.3,0,12.8>,
		<-354.85,0,175.15>
  }
  triangle { // #3246
		<-442.85,0,263.7>,
		<-445.3,0,12.8>,
		<-445.3,0,268.25>
  }
  triangle { // #3247
		<-440.3,0,259.25>,
		<-445.3,0,12.8>,
		<-442.85,0,263.7>
  }
  triangle { // #3248
		<-437.65,0,254.85>,
		<-445.3,0,12.8>,
		<-440.3,0,259.25>
  }
  triangle { // #3249
		<-434.9,0,250.55>,
		<-445.3,0,12.8>,
		<-437.65,0,254.85>
  }
  triangle { // #3250
		<-432.05,0,246.3>,
		<-445.3,0,12.8>,
		<-434.9,0,250.55>
  }
  triangle { // #3251
		<-429.1,0,242.1>,
		<-445.3,0,12.8>,
		<-432.05,0,246.3>
  }
  triangle { // #3252
		<-426.05,0,238>,
		<-445.3,0,12.8>,
		<-429.1,0,242.1>
  }
  triangle { // #3253
		<-422.9,0,233.9>,
		<-445.3,0,12.8>,
		<-426.05,0,238>
  }
  triangle { // #3254
		<-419.65,0,229.9>,
		<-445.3,0,12.8>,
		<-422.9,0,233.9>
  }
  triangle { // #3255
		<-416.3,0,226>,
		<-445.3,0,12.8>,
		<-419.65,0,229.9>
  }
  triangle { // #3256
		<-412.85,0,222.15>,
		<-445.3,0,12.8>,
		<-416.3,0,226>
  }
  triangle { // #3257
		<-409.25,0,218.35>,
		<-445.3,0,12.8>,
		<-412.85,0,222.15>
  }
  triangle { // #3258
		<-405.6,0,214.6>,
		<-445.3,0,12.8>,
		<-409.25,0,218.35>
  }
  triangle { // #3259
		<-401.85,0,210.95>,
		<-445.3,0,12.8>,
		<-405.6,0,214.6>
  }
  triangle { // #3260
		<-398,0,207.35>,
		<-445.3,0,12.8>,
		<-401.85,0,210.95>
  }
  triangle { // #3261
		<-394.05,0,203.8>,
		<-445.3,0,12.8>,
		<-398,0,207.35>
  }
  triangle { // #3262
		<-390.05,0,200.35>,
		<-445.3,0,12.8>,
		<-394.05,0,203.8>
  }
  triangle { // #3263
		<-386.05,0,197.05>,
		<-445.3,0,12.8>,
		<-390.05,0,200.35>
  }
  triangle { // #3264
		<-382.1,0,193.85>,
		<-445.3,0,12.8>,
		<-386.05,0,197.05>
  }
  triangle { // #3265
		<-378.15,0,190.8>,
		<-445.3,0,12.8>,
		<-382.1,0,193.85>
  }
  triangle { // #3266
		<-374.25,0,187.9>,
		<-445.3,0,12.8>,
		<-378.15,0,190.8>
  }
  triangle { // #3267
		<-370.3,0,185.1>,
		<-445.3,0,12.8>,
		<-374.25,0,187.9>
  }
  triangle { // #3268
		<-366.4,0,182.4>,
		<-445.3,0,12.8>,
		<-370.3,0,185.1>
  }
  triangle { // #3269
		<-362.55,0,179.85>,
		<-445.3,0,12.8>,
		<-366.4,0,182.4>
  }
  triangle { // #3270
		<-358.7,0,177.45>,
		<-445.3,0,12.8>,
		<-362.55,0,179.85>
  }
  triangle { // #3271
		<-354.85,0,175.15>,
		<-445.3,0,12.8>,
		<-358.7,0,177.45>
  }
  triangle { // #3272
		<-0.45,0,12.8>,
		<-4.2,0,172.95>,
		<-0.45,0,172.95>
  }
  triangle { // #3273
		<-445.3,0,12.8>,
		<-4.2,0,172.95>,
		<-0.45,0,12.8>
  }
  triangle { // #3274
		<-445.3,0,12.8>,
		<-8,0,172.9>,
		<-4.2,0,172.95>
  }
  triangle { // #3275
		<-445.3,0,12.8>,
		<-11.75,0,172.9>,
		<-8,0,172.9>
  }
  triangle { // #3276
		<-445.3,0,12.8>,
		<-15.5,0,172.85>,
		<-11.75,0,172.9>
  }
  triangle { // #3277
		<-445.3,0,12.8>,
		<-19.3,0,172.8>,
		<-15.5,0,172.85>
  }
  triangle { // #3278
		<-445.3,0,12.8>,
		<-23.05,0,172.75>,
		<-19.3,0,172.8>
  }
  triangle { // #3279
		<-445.3,0,12.8>,
		<-26.85,0,172.65>,
		<-23.05,0,172.75>
  }
  triangle { // #3280
		<-445.3,0,12.8>,
		<-30.6,0,172.55>,
		<-26.85,0,172.65>
  }
  triangle { // #3281
		<-445.3,0,12.8>,
		<-34.4,0,172.45>,
		<-30.6,0,172.55>
  }
  triangle { // #3282
		<-445.3,0,12.8>,
		<-38.15,0,172.35>,
		<-34.4,0,172.45>
  }
  triangle { // #3283
		<-445.3,0,12.8>,
		<-41.95,0,172.2>,
		<-38.15,0,172.35>
  }
  triangle { // #3284
		<-445.3,0,12.8>,
		<-45.7,0,172>,
		<-41.95,0,172.2>
  }
  triangle { // #3285
		<-445.3,0,12.8>,
		<-49.45,0,171.8>,
		<-45.7,0,172>
  }
  triangle { // #3286
		<-445.3,0,12.8>,
		<-53.25,0,171.55>,
		<-49.45,0,171.8>
  }
  triangle { // #3287
		<-445.3,0,12.8>,
		<-57,0,171.3>,
		<-53.25,0,171.55>
  }
  triangle { // #3288
		<-445.3,0,12.8>,
		<-60.8,0,171.05>,
		<-57,0,171.3>
  }
  triangle { // #3289
		<-445.3,0,12.8>,
		<-64.55,0,170.75>,
		<-60.8,0,171.05>
  }
  triangle { // #3290
		<-445.3,0,12.8>,
		<-68.35,0,170.45>,
		<-64.55,0,170.75>
  }
  triangle { // #3291
		<-445.3,0,12.8>,
		<-72.1,0,170.1>,
		<-68.35,0,170.45>
  }
  triangle { // #3292
		<-445.3,0,12.8>,
		<-75.9,0,169.7>,
		<-72.1,0,170.1>
  }
  triangle { // #3293
		<-445.3,0,12.8>,
		<-79.65,0,169.3>,
		<-75.9,0,169.7>
  }
  triangle { // #3294
		<-445.3,0,12.8>,
		<-83.4,0,168.9>,
		<-79.65,0,169.3>
  }
  triangle { // #3295
		<-445.3,0,12.8>,
		<-87.2,0,168.45>,
		<-83.4,0,168.9>
  }
  triangle { // #3296
		<-445.3,0,12.8>,
		<-90.95,0,168>,
		<-87.2,0,168.45>
  }
  triangle { // #3297
		<-445.3,0,12.8>,
		<-95.05,0,167.45>,
		<-90.95,0,168>
  }
  triangle { // #3298
		<-445.3,0,12.8>,
		<-98.5,0,167.05>,
		<-95.05,0,167.45>
  }
  triangle { // #3299
		<-445.3,0,12.8>,
		<-102.3,0,166.55>,
		<-98.5,0,167.05>
  }
  triangle { // #3300
		<-445.3,0,12.8>,
		<-106.05,0,166.05>,
		<-102.3,0,166.55>
  }
  triangle { // #3301
		<-445.3,0,12.8>,
		<-109.8,0,165.6>,
		<-106.05,0,166.05>
  }
  triangle { // #3302
		<-445.3,0,12.8>,
		<-113.6,0,165.1>,
		<-109.8,0,165.6>
  }
  triangle { // #3303
		<-445.3,0,12.8>,
		<-117.35,0,164.6>,
		<-113.6,0,165.1>
  }
  triangle { // #3304
		<-445.3,0,12.8>,
		<-121.15,0,164.15>,
		<-117.35,0,164.6>
  }
  triangle { // #3305
		<-445.3,0,12.8>,
		<-124.9,0,163.65>,
		<-121.15,0,164.15>
  }
  triangle { // #3306
		<-445.3,0,12.8>,
		<-128.7,0,163.15>,
		<-124.9,0,163.65>
  }
  triangle { // #3307
		<-445.3,0,12.8>,
		<-132.45,0,162.7>,
		<-128.7,0,163.15>
  }
  triangle { // #3308
		<-445.3,0,12.8>,
		<-136.25,0,162.2>,
		<-132.45,0,162.7>
  }
  triangle { // #3309
		<-445.3,0,12.8>,
		<-140,0,161.7>,
		<-136.25,0,162.2>
  }
  triangle { // #3310
		<-445.3,0,12.8>,
		<-143.75,0,161.2>,
		<-140,0,161.7>
  }
  triangle { // #3311
		<-445.3,0,12.8>,
		<-147.55,0,160.75>,
		<-143.75,0,161.2>
  }
  triangle { // #3312
		<-445.3,0,12.8>,
		<-151.3,0,160.25>,
		<-147.55,0,160.75>
  }
  triangle { // #3313
		<-445.3,0,12.8>,
		<-155.1,0,159.75>,
		<-151.3,0,160.25>
  }
  triangle { // #3314
		<-445.3,0,12.8>,
		<-158.85,0,159.25>,
		<-155.1,0,159.75>
  }
  triangle { // #3315
		<-445.3,0,12.8>,
		<-162.65,0,158.7>,
		<-158.85,0,159.25>
  }
  triangle { // #3316
		<-445.3,0,12.8>,
		<-166.4,0,158.2>,
		<-162.65,0,158.7>
  }
  triangle { // #3317
		<-445.3,0,12.8>,
		<-170.15,0,157.65>,
		<-166.4,0,158.2>
  }
  triangle { // #3318
		<-445.3,0,12.8>,
		<-173.95,0,157.1>,
		<-170.15,0,157.65>
  }
  triangle { // #3319
		<-445.3,0,12.8>,
		<-177.7,0,156.55>,
		<-173.95,0,157.1>
  }
  triangle { // #3320
		<-445.3,0,12.8>,
		<-181.5,0,155.95>,
		<-177.7,0,156.55>
  }
  triangle { // #3321
		<-445.3,0,12.8>,
		<-185.25,0,155.4>,
		<-181.5,0,155.95>
  }
  triangle { // #3322
		<-445.3,0,12.8>,
		<-189.05,0,154.8>,
		<-185.25,0,155.4>
  }
  triangle { // #3323
		<-445.3,0,12.8>,
		<-192.8,0,154.15>,
		<-189.05,0,154.8>
  }
  triangle { // #3324
		<-445.3,0,12.8>,
		<-196.55,0,153.55>,
		<-192.8,0,154.15>
  }
  triangle { // #3325
		<-445.3,0,12.8>,
		<-200.35,0,152.95>,
		<-196.55,0,153.55>
  }
  triangle { // #3326
		<-445.3,0,12.8>,
		<-204.1,0,152.3>,
		<-200.35,0,152.95>
  }
  triangle { // #3327
		<-445.3,0,12.8>,
		<-205.05,0,152.1>,
		<-204.1,0,152.3>
  }
  triangle { // #3328
		<-445.3,0,12.8>,
		<-207.9,0,151.65>,
		<-205.05,0,152.1>
  }
  triangle { // #3329
		<-445.3,0,12.8>,
		<-211.65,0,150.95>,
		<-207.9,0,151.65>
  }
  triangle { // #3330
		<-445.3,0,12.8>,
		<-215.45,0,150.35>,
		<-211.65,0,150.95>
  }
  triangle { // #3331
		<-445.3,0,12.8>,
		<-219.2,0,149.75>,
		<-215.45,0,150.35>
  }
  triangle { // #3332
		<-445.3,0,12.8>,
		<-222.95,0,149.25>,
		<-219.2,0,149.75>
  }
  triangle { // #3333
		<-445.3,0,12.8>,
		<-226.75,0,148.85>,
		<-222.95,0,149.25>
  }
  triangle { // #3334
		<-445.3,0,12.8>,
		<-230.5,0,148.45>,
		<-226.75,0,148.85>
  }
  triangle { // #3335
		<-445.3,0,12.8>,
		<-234.3,0,148.2>,
		<-230.5,0,148.45>
  }
  triangle { // #3336
		<-445.3,0,12.8>,
		<-238.05,0,147.95>,
		<-234.3,0,148.2>
  }
  triangle { // #3337
		<-445.3,0,12.8>,
		<-241.85,0,147.8>,
		<-238.05,0,147.95>
  }
  triangle { // #3338
		<-445.3,0,12.8>,
		<-245.6,0,147.7>,
		<-241.85,0,147.8>
  }
  triangle { // #3339
		<-445.3,0,12.8>,
		<-249.4,0,147.65>,
		<-245.6,0,147.7>
  }
  triangle { // #3340
		<-445.3,0,12.8>,
		<-253.15,0,147.7>,
		<-249.4,0,147.65>
  }
  triangle { // #3341
		<-445.3,0,12.8>,
		<-256.95,0,147.85>,
		<-253.15,0,147.7>
  }
  triangle { // #3342
		<-445.3,0,12.8>,
		<-260.7,0,148>,
		<-256.95,0,147.85>
  }
  triangle { // #3343
		<-445.3,0,12.8>,
		<-264.5,0,148.25>,
		<-260.7,0,148>
  }
  triangle { // #3344
		<-445.3,0,12.8>,
		<-268.25,0,148.55>,
		<-264.5,0,148.25>
  }
  triangle { // #3345
		<-445.3,0,12.8>,
		<-272.05,0,148.95>,
		<-268.25,0,148.55>
  }
  triangle { // #3346
		<-445.3,0,12.8>,
		<-275.85,0,149.4>,
		<-272.05,0,148.95>
  }
  triangle { // #3347
		<-445.3,0,12.8>,
		<-279.6,0,149.9>,
		<-275.85,0,149.4>
  }
  triangle { // #3348
		<-445.3,0,12.8>,
		<-283.4,0,150.5>,
		<-279.6,0,149.9>
  }
  triangle { // #3349
		<-445.3,0,12.8>,
		<-287.15,0,151.15>,
		<-283.4,0,150.5>
  }
  triangle { // #3350
		<-445.3,0,12.8>,
		<-290.9,0,151.85>,
		<-287.15,0,151.15>
  }
  triangle { // #3351
		<-445.3,0,12.8>,
		<-294.65,0,152.65>,
		<-290.9,0,151.85>
  }
  triangle { // #3352
		<-445.3,0,12.8>,
		<-298.45,0,153.5>,
		<-294.65,0,152.65>
  }
  triangle { // #3353
		<-445.3,0,12.8>,
		<-302.2,0,154.4>,
		<-298.45,0,153.5>
  }
  triangle { // #3354
		<-445.3,0,12.8>,
		<-305.95,0,155.35>,
		<-302.2,0,154.4>
  }
  triangle { // #3355
		<-445.3,0,12.8>,
		<-309.7,0,156.4>,
		<-305.95,0,155.35>
  }
  triangle { // #3356
		<-445.3,0,12.8>,
		<-313.45,0,157.5>,
		<-309.7,0,156.4>
  }
  triangle { // #3357
		<-445.3,0,12.8>,
		<-317.2,0,158.7>,
		<-313.45,0,157.5>
  }
  triangle { // #3358
		<-445.3,0,12.8>,
		<-320.95,0,159.95>,
		<-317.2,0,158.7>
  }
  triangle { // #3359
		<-445.3,0,12.8>,
		<-324.65,0,161.25>,
		<-320.95,0,159.95>
  }
  triangle { // #3360
		<-445.3,0,12.8>,
		<-328.4,0,162.6>,
		<-324.65,0,161.25>
  }
  triangle { // #3361
		<-445.3,0,12.8>,
		<-332.15,0,164.05>,
		<-328.4,0,162.6>
  }
  triangle { // #3362
		<-445.3,0,12.8>,
		<-335.9,0,165.55>,
		<-332.15,0,164.05>
  }
  triangle { // #3363
		<-445.3,0,12.8>,
		<-339.65,0,167.25>,
		<-335.9,0,165.55>
  }
  triangle { // #3364
		<-445.3,0,12.8>,
		<-343.4,0,169>,
		<-339.65,0,167.25>
  }
  triangle { // #3365
		<-445.3,0,12.8>,
		<-347.2,0,170.95>,
		<-343.4,0,169>
  }
  triangle { // #3366
		<-445.3,0,12.8>,
		<-351,0,172.95>,
		<-347.2,0,170.95>
  }
  triangle { // #3367
		<-445.3,-25.15,12.8>,
		<-351,-25.15,172.95>,
		<-354.85,-25.15,175.15>
  }
  triangle { // #3368
		<-445.3,-25.15,12.8>,
		<-442.85,-25.15,263.7>,
		<-445.3,-25.15,268.25>
  }
  triangle { // #3369
		<-445.3,-25.15,12.8>,
		<-440.3,-25.15,259.25>,
		<-442.85,-25.15,263.7>
  }
  triangle { // #3370
		<-445.3,-25.15,12.8>,
		<-437.65,-25.15,254.85>,
		<-440.3,-25.15,259.25>
  }
  triangle { // #3371
		<-445.3,-25.15,12.8>,
		<-434.9,-25.15,250.55>,
		<-437.65,-25.15,254.85>
  }
  triangle { // #3372
		<-445.3,-25.15,12.8>,
		<-432.05,-25.15,246.3>,
		<-434.9,-25.15,250.55>
  }
  triangle { // #3373
		<-445.3,-25.15,12.8>,
		<-429.1,-25.15,242.1>,
		<-432.05,-25.15,246.3>
  }
  triangle { // #3374
		<-445.3,-25.15,12.8>,
		<-426.05,-25.15,238>,
		<-429.1,-25.15,242.1>
  }
  triangle { // #3375
		<-445.3,-25.15,12.8>,
		<-422.9,-25.15,233.9>,
		<-426.05,-25.15,238>
  }
  triangle { // #3376
		<-445.3,-25.15,12.8>,
		<-419.65,-25.15,229.9>,
		<-422.9,-25.15,233.9>
  }
  triangle { // #3377
		<-445.3,-25.15,12.8>,
		<-416.3,-25.15,226>,
		<-419.65,-25.15,229.9>
  }
  triangle { // #3378
		<-445.3,-25.15,12.8>,
		<-412.85,-25.15,222.15>,
		<-416.3,-25.15,226>
  }
  triangle { // #3379
		<-445.3,-25.15,12.8>,
		<-409.25,-25.15,218.35>,
		<-412.85,-25.15,222.15>
  }
  triangle { // #3380
		<-445.3,-25.15,12.8>,
		<-405.6,-25.15,214.6>,
		<-409.25,-25.15,218.35>
  }
  triangle { // #3381
		<-445.3,-25.15,12.8>,
		<-401.85,-25.15,210.95>,
		<-405.6,-25.15,214.6>
  }
  triangle { // #3382
		<-445.3,-25.15,12.8>,
		<-398,-25.15,207.35>,
		<-401.85,-25.15,210.95>
  }
  triangle { // #3383
		<-445.3,-25.15,12.8>,
		<-394.05,-25.15,203.8>,
		<-398,-25.15,207.35>
  }
  triangle { // #3384
		<-445.3,-25.15,12.8>,
		<-390.05,-25.15,200.35>,
		<-394.05,-25.15,203.8>
  }
  triangle { // #3385
		<-445.3,-25.15,12.8>,
		<-386.05,-25.15,197.05>,
		<-390.05,-25.15,200.35>
  }
  triangle { // #3386
		<-445.3,-25.15,12.8>,
		<-382.1,-25.15,193.85>,
		<-386.05,-25.15,197.05>
  }
  triangle { // #3387
		<-445.3,-25.15,12.8>,
		<-378.15,-25.15,190.8>,
		<-382.1,-25.15,193.85>
  }
  triangle { // #3388
		<-445.3,-25.15,12.8>,
		<-374.25,-25.15,187.9>,
		<-378.15,-25.15,190.8>
  }
  triangle { // #3389
		<-445.3,-25.15,12.8>,
		<-370.3,-25.15,185.1>,
		<-374.25,-25.15,187.9>
  }
  triangle { // #3390
		<-445.3,-25.15,12.8>,
		<-366.4,-25.15,182.4>,
		<-370.3,-25.15,185.1>
  }
  triangle { // #3391
		<-445.3,-25.15,12.8>,
		<-362.55,-25.15,179.85>,
		<-366.4,-25.15,182.4>
  }
  triangle { // #3392
		<-445.3,-25.15,12.8>,
		<-358.7,-25.15,177.45>,
		<-362.55,-25.15,179.85>
  }
  triangle { // #3393
		<-445.3,-25.15,12.8>,
		<-354.85,-25.15,175.15>,
		<-358.7,-25.15,177.45>
  }
  triangle { // #3394
		<-4.2,-25.15,172.95>,
		<-0.45,-25.15,12.8>,
		<-0.45,-25.15,172.95>
  }
  triangle { // #3395
		<-4.2,-25.15,172.95>,
		<-445.3,-25.15,12.8>,
		<-0.45,-25.15,12.8>
  }
  triangle { // #3396
		<-8,-25.15,172.9>,
		<-445.3,-25.15,12.8>,
		<-4.2,-25.15,172.95>
  }
  triangle { // #3397
		<-11.75,-25.15,172.9>,
		<-445.3,-25.15,12.8>,
		<-8,-25.15,172.9>
  }
  triangle { // #3398
		<-15.5,-25.15,172.85>,
		<-445.3,-25.15,12.8>,
		<-11.75,-25.15,172.9>
  }
  triangle { // #3399
		<-19.3,-25.15,172.8>,
		<-445.3,-25.15,12.8>,
		<-15.5,-25.15,172.85>
  }
  triangle { // #3400
		<-23.05,-25.15,172.75>,
		<-445.3,-25.15,12.8>,
		<-19.3,-25.15,172.8>
  }
  triangle { // #3401
		<-26.85,-25.15,172.65>,
		<-445.3,-25.15,12.8>,
		<-23.05,-25.15,172.75>
  }
  triangle { // #3402
		<-30.6,-25.15,172.55>,
		<-445.3,-25.15,12.8>,
		<-26.85,-25.15,172.65>
  }
  triangle { // #3403
		<-34.4,-25.15,172.45>,
		<-445.3,-25.15,12.8>,
		<-30.6,-25.15,172.55>
  }
  triangle { // #3404
		<-38.15,-25.15,172.35>,
		<-445.3,-25.15,12.8>,
		<-34.4,-25.15,172.45>
  }
  triangle { // #3405
		<-41.95,-25.15,172.2>,
		<-445.3,-25.15,12.8>,
		<-38.15,-25.15,172.35>
  }
  triangle { // #3406
		<-45.7,-25.15,172>,
		<-445.3,-25.15,12.8>,
		<-41.95,-25.15,172.2>
  }
  triangle { // #3407
		<-49.45,-25.15,171.8>,
		<-445.3,-25.15,12.8>,
		<-45.7,-25.15,172>
  }
  triangle { // #3408
		<-53.25,-25.15,171.55>,
		<-445.3,-25.15,12.8>,
		<-49.45,-25.15,171.8>
  }
  triangle { // #3409
		<-57,-25.15,171.3>,
		<-445.3,-25.15,12.8>,
		<-53.25,-25.15,171.55>
  }
  triangle { // #3410
		<-60.8,-25.15,171.05>,
		<-445.3,-25.15,12.8>,
		<-57,-25.15,171.3>
  }
  triangle { // #3411
		<-64.55,-25.15,170.75>,
		<-445.3,-25.15,12.8>,
		<-60.8,-25.15,171.05>
  }
  triangle { // #3412
		<-68.35,-25.15,170.45>,
		<-445.3,-25.15,12.8>,
		<-64.55,-25.15,170.75>
  }
  triangle { // #3413
		<-72.1,-25.15,170.1>,
		<-445.3,-25.15,12.8>,
		<-68.35,-25.15,170.45>
  }
  triangle { // #3414
		<-75.9,-25.15,169.7>,
		<-445.3,-25.15,12.8>,
		<-72.1,-25.15,170.1>
  }
  triangle { // #3415
		<-79.65,-25.15,169.3>,
		<-445.3,-25.15,12.8>,
		<-75.9,-25.15,169.7>
  }
  triangle { // #3416
		<-83.4,-25.15,168.9>,
		<-445.3,-25.15,12.8>,
		<-79.65,-25.15,169.3>
  }
  triangle { // #3417
		<-87.2,-25.15,168.45>,
		<-445.3,-25.15,12.8>,
		<-83.4,-25.15,168.9>
  }
  triangle { // #3418
		<-90.95,-25.15,168>,
		<-445.3,-25.15,12.8>,
		<-87.2,-25.15,168.45>
  }
  triangle { // #3419
		<-95.05,-25.15,167.45>,
		<-445.3,-25.15,12.8>,
		<-90.95,-25.15,168>
  }
  triangle { // #3420
		<-98.5,-25.15,167.05>,
		<-445.3,-25.15,12.8>,
		<-95.05,-25.15,167.45>
  }
  triangle { // #3421
		<-102.3,-25.15,166.55>,
		<-445.3,-25.15,12.8>,
		<-98.5,-25.15,167.05>
  }
  triangle { // #3422
		<-106.05,-25.15,166.05>,
		<-445.3,-25.15,12.8>,
		<-102.3,-25.15,166.55>
  }
  triangle { // #3423
		<-109.8,-25.15,165.6>,
		<-445.3,-25.15,12.8>,
		<-106.05,-25.15,166.05>
  }
  triangle { // #3424
		<-113.6,-25.15,165.1>,
		<-445.3,-25.15,12.8>,
		<-109.8,-25.15,165.6>
  }
  triangle { // #3425
		<-117.35,-25.15,164.6>,
		<-445.3,-25.15,12.8>,
		<-113.6,-25.15,165.1>
  }
  triangle { // #3426
		<-121.15,-25.15,164.15>,
		<-445.3,-25.15,12.8>,
		<-117.35,-25.15,164.6>
  }
  triangle { // #3427
		<-124.9,-25.15,163.65>,
		<-445.3,-25.15,12.8>,
		<-121.15,-25.15,164.15>
  }
  triangle { // #3428
		<-128.7,-25.15,163.15>,
		<-445.3,-25.15,12.8>,
		<-124.9,-25.15,163.65>
  }
  triangle { // #3429
		<-132.45,-25.15,162.7>,
		<-445.3,-25.15,12.8>,
		<-128.7,-25.15,163.15>
  }
  triangle { // #3430
		<-136.25,-25.15,162.2>,
		<-445.3,-25.15,12.8>,
		<-132.45,-25.15,162.7>
  }
  triangle { // #3431
		<-140,-25.15,161.7>,
		<-445.3,-25.15,12.8>,
		<-136.25,-25.15,162.2>
  }
  triangle { // #3432
		<-143.75,-25.15,161.2>,
		<-445.3,-25.15,12.8>,
		<-140,-25.15,161.7>
  }
  triangle { // #3433
		<-147.55,-25.15,160.75>,
		<-445.3,-25.15,12.8>,
		<-143.75,-25.15,161.2>
  }
  triangle { // #3434
		<-151.3,-25.15,160.25>,
		<-445.3,-25.15,12.8>,
		<-147.55,-25.15,160.75>
  }
  triangle { // #3435
		<-155.1,-25.15,159.75>,
		<-445.3,-25.15,12.8>,
		<-151.3,-25.15,160.25>
  }
  triangle { // #3436
		<-158.85,-25.15,159.25>,
		<-445.3,-25.15,12.8>,
		<-155.1,-25.15,159.75>
  }
  triangle { // #3437
		<-162.65,-25.15,158.7>,
		<-445.3,-25.15,12.8>,
		<-158.85,-25.15,159.25>
  }
  triangle { // #3438
		<-166.4,-25.15,158.2>,
		<-445.3,-25.15,12.8>,
		<-162.65,-25.15,158.7>
  }
  triangle { // #3439
		<-170.15,-25.15,157.65>,
		<-445.3,-25.15,12.8>,
		<-166.4,-25.15,158.2>
  }
  triangle { // #3440
		<-173.95,-25.15,157.1>,
		<-445.3,-25.15,12.8>,
		<-170.15,-25.15,157.65>
  }
  triangle { // #3441
		<-177.7,-25.15,156.55>,
		<-445.3,-25.15,12.8>,
		<-173.95,-25.15,157.1>
  }
  triangle { // #3442
		<-181.5,-25.15,155.95>,
		<-445.3,-25.15,12.8>,
		<-177.7,-25.15,156.55>
  }
  triangle { // #3443
		<-185.25,-25.15,155.4>,
		<-445.3,-25.15,12.8>,
		<-181.5,-25.15,155.95>
  }
  triangle { // #3444
		<-189.05,-25.15,154.8>,
		<-445.3,-25.15,12.8>,
		<-185.25,-25.15,155.4>
  }
  triangle { // #3445
		<-192.8,-25.15,154.2>,
		<-445.3,-25.15,12.8>,
		<-189.05,-25.15,154.8>
  }
  triangle { // #3446
		<-196.55,-25.15,153.55>,
		<-445.3,-25.15,12.8>,
		<-192.8,-25.15,154.2>
  }
  triangle { // #3447
		<-200.35,-25.15,152.95>,
		<-445.3,-25.15,12.8>,
		<-196.55,-25.15,153.55>
  }
  triangle { // #3448
		<-204.1,-25.15,152.3>,
		<-445.3,-25.15,12.8>,
		<-200.35,-25.15,152.95>
  }
  triangle { // #3449
		<-205.05,-25.15,152.1>,
		<-445.3,-25.15,12.8>,
		<-204.1,-25.15,152.3>
  }
  triangle { // #3450
		<-207.9,-25.15,151.65>,
		<-445.3,-25.15,12.8>,
		<-205.05,-25.15,152.1>
  }
  triangle { // #3451
		<-211.65,-25.15,150.95>,
		<-445.3,-25.15,12.8>,
		<-207.9,-25.15,151.65>
  }
  triangle { // #3452
		<-215.45,-25.15,150.35>,
		<-445.3,-25.15,12.8>,
		<-211.65,-25.15,150.95>
  }
  triangle { // #3453
		<-219.2,-25.15,149.75>,
		<-445.3,-25.15,12.8>,
		<-215.45,-25.15,150.35>
  }
  triangle { // #3454
		<-222.95,-25.15,149.25>,
		<-445.3,-25.15,12.8>,
		<-219.2,-25.15,149.75>
  }
  triangle { // #3455
		<-226.75,-25.15,148.85>,
		<-445.3,-25.15,12.8>,
		<-222.95,-25.15,149.25>
  }
  triangle { // #3456
		<-230.5,-25.15,148.45>,
		<-445.3,-25.15,12.8>,
		<-226.75,-25.15,148.85>
  }
  triangle { // #3457
		<-234.3,-25.15,148.2>,
		<-445.3,-25.15,12.8>,
		<-230.5,-25.15,148.45>
  }
  triangle { // #3458
		<-238.05,-25.15,147.95>,
		<-445.3,-25.15,12.8>,
		<-234.3,-25.15,148.2>
  }
  triangle { // #3459
		<-241.85,-25.15,147.8>,
		<-445.3,-25.15,12.8>,
		<-238.05,-25.15,147.95>
  }
  triangle { // #3460
		<-245.6,-25.15,147.7>,
		<-445.3,-25.15,12.8>,
		<-241.85,-25.15,147.8>
  }
  triangle { // #3461
		<-249.4,-25.15,147.65>,
		<-445.3,-25.15,12.8>,
		<-245.6,-25.15,147.7>
  }
  triangle { // #3462
		<-253.15,-25.15,147.7>,
		<-445.3,-25.15,12.8>,
		<-249.4,-25.15,147.65>
  }
  triangle { // #3463
		<-256.95,-25.15,147.85>,
		<-445.3,-25.15,12.8>,
		<-253.15,-25.15,147.7>
  }
  triangle { // #3464
		<-260.7,-25.15,148>,
		<-445.3,-25.15,12.8>,
		<-256.95,-25.15,147.85>
  }
  triangle { // #3465
		<-264.5,-25.15,148.25>,
		<-445.3,-25.15,12.8>,
		<-260.7,-25.15,148>
  }
  triangle { // #3466
		<-268.25,-25.15,148.55>,
		<-445.3,-25.15,12.8>,
		<-264.5,-25.15,148.25>
  }
  triangle { // #3467
		<-272.05,-25.15,148.95>,
		<-445.3,-25.15,12.8>,
		<-268.25,-25.15,148.55>
  }
  triangle { // #3468
		<-275.85,-25.15,149.4>,
		<-445.3,-25.15,12.8>,
		<-272.05,-25.15,148.95>
  }
  triangle { // #3469
		<-279.6,-25.15,149.9>,
		<-445.3,-25.15,12.8>,
		<-275.85,-25.15,149.4>
  }
  triangle { // #3470
		<-283.4,-25.15,150.5>,
		<-445.3,-25.15,12.8>,
		<-279.6,-25.15,149.9>
  }
  triangle { // #3471
		<-287.15,-25.15,151.15>,
		<-445.3,-25.15,12.8>,
		<-283.4,-25.15,150.5>
  }
  triangle { // #3472
		<-290.9,-25.15,151.85>,
		<-445.3,-25.15,12.8>,
		<-287.15,-25.15,151.15>
  }
  triangle { // #3473
		<-294.65,-25.15,152.65>,
		<-445.3,-25.15,12.8>,
		<-290.9,-25.15,151.85>
  }
  triangle { // #3474
		<-298.45,-25.15,153.5>,
		<-445.3,-25.15,12.8>,
		<-294.65,-25.15,152.65>
  }
  triangle { // #3475
		<-302.2,-25.15,154.4>,
		<-445.3,-25.15,12.8>,
		<-298.45,-25.15,153.5>
  }
  triangle { // #3476
		<-305.95,-25.15,155.35>,
		<-445.3,-25.15,12.8>,
		<-302.2,-25.15,154.4>
  }
  triangle { // #3477
		<-309.7,-25.15,156.4>,
		<-445.3,-25.15,12.8>,
		<-305.95,-25.15,155.35>
  }
  triangle { // #3478
		<-313.45,-25.15,157.5>,
		<-445.3,-25.15,12.8>,
		<-309.7,-25.15,156.4>
  }
  triangle { // #3479
		<-317.2,-25.15,158.7>,
		<-445.3,-25.15,12.8>,
		<-313.45,-25.15,157.5>
  }
  triangle { // #3480
		<-320.95,-25.15,159.95>,
		<-445.3,-25.15,12.8>,
		<-317.2,-25.15,158.7>
  }
  triangle { // #3481
		<-324.65,-25.15,161.25>,
		<-445.3,-25.15,12.8>,
		<-320.95,-25.15,159.95>
  }
  triangle { // #3482
		<-328.4,-25.15,162.6>,
		<-445.3,-25.15,12.8>,
		<-324.65,-25.15,161.25>
  }
  triangle { // #3483
		<-332.15,-25.15,164.05>,
		<-445.3,-25.15,12.8>,
		<-328.4,-25.15,162.6>
  }
  triangle { // #3484
		<-335.9,-25.15,165.55>,
		<-445.3,-25.15,12.8>,
		<-332.15,-25.15,164.05>
  }
  triangle { // #3485
		<-339.65,-25.15,167.25>,
		<-445.3,-25.15,12.8>,
		<-335.9,-25.15,165.55>
  }
  triangle { // #3486
		<-343.4,-25.15,169>,
		<-445.3,-25.15,12.8>,
		<-339.65,-25.15,167.25>
  }
  triangle { // #3487
		<-347.2,-25.15,170.95>,
		<-445.3,-25.15,12.8>,
		<-343.4,-25.15,169>
  }
  triangle { // #3488
		<-351,-25.15,172.95>,
		<-445.3,-25.15,12.8>,
		<-347.2,-25.15,170.95>
  }
  triangle { // #3489
		<-445.3,0,12.8>,
		<-445.3,-25.15,268.25>,
		<-445.3,0,268.25>
  }
  triangle { // #3490
		<-445.3,-25.15,268.25>,
		<-445.3,0,12.8>,
		<-445.3,-25.15,12.8>
  }
  smooth_triangle { // #3491
		<-445.3,0,268.25>, <0.945,-0.327,0>,
		<-442.85,-25.15,263.7>, <0.875,-0.484,0>,
		<-442.85,0,263.7>, <0.871,-0.491,0>
  }
  smooth_triangle { // #3492
		<-442.85,-25.15,263.7>, <0.875,-0.484,0>,
		<-445.3,0,268.25>, <0.945,-0.327,0>,
		<-445.3,-25.15,268.25>, <0.879,-0.477,0>
  }
  smooth_triangle { // #3493
		<-442.85,0,263.7>, <0.871,-0.491,0>,
		<-440.3,-25.15,259.25>, <0.864,-0.504,0>,
		<-440.3,0,259.25>, <0.86,-0.511,0>
  }
  smooth_triangle { // #3494
		<-440.3,-25.15,259.25>, <0.864,-0.504,0>,
		<-442.85,0,263.7>, <0.871,-0.491,0>,
		<-442.85,-25.15,263.7>, <0.875,-0.484,0>
  }
  smooth_triangle { // #3495
		<-440.3,0,259.25>, <0.86,-0.511,0>,
		<-437.65,-25.15,254.85>, <0.852,-0.524,0>,
		<-437.65,0,254.85>, <0.848,-0.531,0>
  }
  smooth_triangle { // #3496
		<-437.65,-25.15,254.85>, <0.852,-0.524,0>,
		<-440.3,0,259.25>, <0.86,-0.511,0>,
		<-440.3,-25.15,259.25>, <0.864,-0.504,0>
  }
  smooth_triangle { // #3497
		<-437.65,0,254.85>, <0.848,-0.531,0>,
		<-434.9,-25.15,250.55>, <0.839,-0.544,0>,
		<-434.9,0,250.55>, <0.835,-0.55,0>
  }
  smooth_triangle { // #3498
		<-434.9,-25.15,250.55>, <0.839,-0.544,0>,
		<-437.65,0,254.85>, <0.848,-0.531,0>,
		<-437.65,-25.15,254.85>, <0.852,-0.524,0>
  }
  smooth_triangle { // #3499
		<-434.9,0,250.55>, <0.835,-0.55,0>,
		<-432.05,-25.15,246.3>, <0.826,-0.563,0>,
		<-432.05,0,246.3>, <0.822,-0.57,0>
  }
  smooth_triangle { // #3500
		<-432.05,-25.15,246.3>, <0.826,-0.563,0>,
		<-434.9,0,250.55>, <0.835,-0.55,0>,
		<-434.9,-25.15,250.55>, <0.839,-0.544,0>
  }
  smooth_triangle { // #3501
		<-432.05,0,246.3>, <0.822,-0.57,0>,
		<-429.1,-25.15,242.1>, <0.813,-0.582,0>,
		<-429.1,0,242.1>, <0.808,-0.589,0>
  }
  smooth_triangle { // #3502
		<-429.1,-25.15,242.1>, <0.813,-0.582,0>,
		<-432.05,0,246.3>, <0.822,-0.57,0>,
		<-432.05,-25.15,246.3>, <0.826,-0.563,0>
  }
  smooth_triangle { // #3503
		<-429.1,0,242.1>, <0.808,-0.589,0>,
		<-426.05,-25.15,238>, <0.799,-0.601,0>,
		<-426.05,0,238>, <0.794,-0.607,0>
  }
  smooth_triangle { // #3504
		<-426.05,-25.15,238>, <0.799,-0.601,0>,
		<-429.1,0,242.1>, <0.808,-0.589,0>,
		<-429.1,-25.15,242.1>, <0.813,-0.582,0>
  }
  smooth_triangle { // #3505
		<-426.05,0,238>, <0.794,-0.607,0>,
		<-422.9,-25.15,233.9>, <0.785,-0.62,0>,
		<-422.9,0,233.9>, <0.78,-0.626,0>
  }
  smooth_triangle { // #3506
		<-422.9,-25.15,233.9>, <0.785,-0.62,0>,
		<-426.05,0,238>, <0.794,-0.607,0>,
		<-426.05,-25.15,238>, <0.799,-0.601,0>
  }
  smooth_triangle { // #3507
		<-422.9,0,233.9>, <0.78,-0.626,0>,
		<-419.65,-25.15,229.9>, <0.77,-0.638,0>,
		<-419.65,0,229.9>, <0.765,-0.644,0>
  }
  smooth_triangle { // #3508
		<-419.65,-25.15,229.9>, <0.77,-0.638,0>,
		<-422.9,0,233.9>, <0.78,-0.626,0>,
		<-422.9,-25.15,233.9>, <0.785,-0.62,0>
  }
  smooth_triangle { // #3509
		<-419.65,0,229.9>, <0.765,-0.644,0>,
		<-416.3,-25.15,226>, <0.755,-0.655,0>,
		<-416.3,0,226>, <0.75,-0.661,0>
  }
  smooth_triangle { // #3510
		<-416.3,-25.15,226>, <0.755,-0.655,0>,
		<-419.65,0,229.9>, <0.765,-0.644,0>,
		<-419.65,-25.15,229.9>, <0.77,-0.638,0>
  }
  smooth_triangle { // #3511
		<-416.3,0,226>, <0.75,-0.661,0>,
		<-412.85,-25.15,222.15>, <0.74,-0.672,0>,
		<-412.85,0,222.15>, <0.735,-0.678,0>
  }
  smooth_triangle { // #3512
		<-412.85,-25.15,222.15>, <0.74,-0.672,0>,
		<-416.3,0,226>, <0.75,-0.661,0>,
		<-416.3,-25.15,226>, <0.755,-0.655,0>
  }
  smooth_triangle { // #3513
		<-412.85,0,222.15>, <0.735,-0.678,0>,
		<-409.25,-25.15,218.35>, <0.725,-0.689,0>,
		<-409.25,0,218.35>, <0.72,-0.694,0>
  }
  smooth_triangle { // #3514
		<-409.25,-25.15,218.35>, <0.725,-0.689,0>,
		<-412.85,0,222.15>, <0.735,-0.678,0>,
		<-412.85,-25.15,222.15>, <0.74,-0.672,0>
  }
  smooth_triangle { // #3515
		<-409.25,0,218.35>, <0.72,-0.694,0>,
		<-405.6,-25.15,214.6>, <0.709,-0.705,0>,
		<-405.6,0,214.6>, <0.704,-0.71,0>
  }
  smooth_triangle { // #3516
		<-405.6,-25.15,214.6>, <0.709,-0.705,0>,
		<-409.25,0,218.35>, <0.72,-0.694,0>,
		<-409.25,-25.15,218.35>, <0.725,-0.689,0>
  }
  smooth_triangle { // #3517
		<-405.6,0,214.6>, <0.704,-0.71,0>,
		<-401.85,-25.15,210.95>, <0.693,-0.721,0>,
		<-401.85,0,210.95>, <0.688,-0.726,0>
  }
  smooth_triangle { // #3518
		<-401.85,-25.15,210.95>, <0.693,-0.721,0>,
		<-405.6,0,214.6>, <0.704,-0.71,0>,
		<-405.6,-25.15,214.6>, <0.709,-0.705,0>
  }
  smooth_triangle { // #3519
		<-401.85,0,210.95>, <0.688,-0.726,0>,
		<-398,-25.15,207.35>, <0.677,-0.736,0>,
		<-398,0,207.35>, <0.672,-0.741,0>
  }
  smooth_triangle { // #3520
		<-398,-25.15,207.35>, <0.677,-0.736,0>,
		<-401.85,0,210.95>, <0.688,-0.726,0>,
		<-401.85,-25.15,210.95>, <0.693,-0.721,0>
  }
  triangle { // #3521
		<-398,0,207.35>,
		<-394.05,-25.15,203.8>,
		<-394.05,0,203.8>
  }
  smooth_triangle { // #3522
		<-394.05,-25.15,203.8>, <0.662,-0.75,0>,
		<-398,0,207.35>, <0.672,-0.741,0>,
		<-398,-25.15,207.35>, <0.677,-0.736,0>
  }
  triangle { // #3523
		<-394.05,0,203.8>,
		<-390.05,-25.15,200.35>,
		<-390.05,0,200.35>
  }
  triangle { // #3524
		<-390.05,-25.15,200.35>,
		<-394.05,0,203.8>,
		<-394.05,-25.15,203.8>
  }
  triangle { // #3525
		<-390.05,0,200.35>,
		<-386.05,-25.15,197.05>,
		<-386.05,0,197.05>
  }
  triangle { // #3526
		<-386.05,-25.15,197.05>,
		<-390.05,0,200.35>,
		<-390.05,-25.15,200.35>
  }
  triangle { // #3527
		<-386.05,0,197.05>,
		<-382.1,-25.15,193.85>,
		<-382.1,0,193.85>
  }
  triangle { // #3528
		<-382.1,-25.15,193.85>,
		<-386.05,0,197.05>,
		<-386.05,-25.15,197.05>
  }
  triangle { // #3529
		<-382.1,0,193.85>,
		<-378.15,-25.15,190.8>,
		<-378.15,0,190.8>
  }
  triangle { // #3530
		<-378.15,-25.15,190.8>,
		<-382.1,0,193.85>,
		<-382.1,-25.15,193.85>
  }
  smooth_triangle { // #3531
		<-378.15,0,190.8>, <0.603,-0.798,0>,
		<-374.25,-25.15,187.9>, <0.593,-0.805,0>,
		<-374.25,0,187.9>, <0.588,-0.809,0>
  }
  triangle { // #3532
		<-374.25,-25.15,187.9>,
		<-378.15,0,190.8>,
		<-378.15,-25.15,190.8>
  }
  smooth_triangle { // #3533
		<-374.25,0,187.9>, <0.588,-0.809,0>,
		<-370.3,-25.15,185.1>, <0.577,-0.817,0>,
		<-370.3,0,185.1>, <0.572,-0.82,0>
  }
  smooth_triangle { // #3534
		<-370.3,-25.15,185.1>, <0.577,-0.817,0>,
		<-374.25,0,187.9>, <0.588,-0.809,0>,
		<-374.25,-25.15,187.9>, <0.593,-0.805,0>
  }
  smooth_triangle { // #3535
		<-370.3,0,185.1>, <0.572,-0.82,0>,
		<-366.4,-25.15,182.4>, <0.561,-0.828,0>,
		<-366.4,0,182.4>, <0.555,-0.832,0>
  }
  smooth_triangle { // #3536
		<-366.4,-25.15,182.4>, <0.561,-0.828,0>,
		<-370.3,0,185.1>, <0.572,-0.82,0>,
		<-370.3,-25.15,185.1>, <0.577,-0.817,0>
  }
  smooth_triangle { // #3537
		<-366.4,0,182.4>, <0.555,-0.832,0>,
		<-362.55,-25.15,179.85>, <0.543,-0.84,0>,
		<-362.55,0,179.85>, <0.537,-0.843,0>
  }
  smooth_triangle { // #3538
		<-362.55,-25.15,179.85>, <0.543,-0.84,0>,
		<-366.4,0,182.4>, <0.555,-0.832,0>,
		<-366.4,-25.15,182.4>, <0.561,-0.828,0>
  }
  smooth_triangle { // #3539
		<-362.55,0,179.85>, <0.537,-0.843,0>,
		<-358.7,-25.15,177.45>, <0.525,-0.851,0>,
		<-358.7,0,177.45>, <0.519,-0.855,0>
  }
  smooth_triangle { // #3540
		<-358.7,-25.15,177.45>, <0.525,-0.851,0>,
		<-362.55,0,179.85>, <0.537,-0.843,0>,
		<-362.55,-25.15,179.85>, <0.543,-0.84,0>
  }
  smooth_triangle { // #3541
		<-358.7,0,177.45>, <0.519,-0.855,0>,
		<-354.85,-25.15,175.15>, <0.506,-0.862,0>,
		<-354.85,0,175.15>, <0.5,-0.866,0>
  }
  smooth_triangle { // #3542
		<-354.85,-25.15,175.15>, <0.506,-0.862,0>,
		<-358.7,0,177.45>, <0.519,-0.855,0>,
		<-358.7,-25.15,177.45>, <0.525,-0.851,0>
  }
  smooth_triangle { // #3543
		<-354.85,0,175.15>, <0.5,-0.866,0>,
		<-351,-25.15,172.95>, <0.486,-0.874,0>,
		<-351,0,172.95>, <0.479,-0.878,0>
  }
  smooth_triangle { // #3544
		<-351,-25.15,172.95>, <0.486,-0.874,0>,
		<-354.85,0,175.15>, <0.5,-0.866,0>,
		<-354.85,-25.15,175.15>, <0.506,-0.862,0>
  }
  smooth_triangle { // #3545
		<-351,0,172.95>, <0.479,-0.878,0>,
		<-347.2,-25.15,170.95>, <0.465,-0.885,0>,
		<-347.2,0,170.95>, <0.458,-0.889,0>
  }
  smooth_triangle { // #3546
		<-347.2,-25.15,170.95>, <0.465,-0.885,0>,
		<-351,0,172.95>, <0.479,-0.878,0>,
		<-351,-25.15,172.95>, <0.486,-0.874,0>
  }
  smooth_triangle { // #3547
		<-347.2,0,170.95>, <0.458,-0.889,0>,
		<-343.4,-25.15,169>, <0.443,-0.897,0>,
		<-343.4,0,169>, <0.435,-0.9,0>
  }
  smooth_triangle { // #3548
		<-343.4,-25.15,169>, <0.443,-0.897,0>,
		<-347.2,0,170.95>, <0.458,-0.889,0>,
		<-347.2,-25.15,170.95>, <0.465,-0.885,0>
  }
  smooth_triangle { // #3549
		<-343.4,0,169>, <0.435,-0.9,0>,
		<-339.65,-25.15,167.25>, <0.42,-0.908,0>,
		<-339.65,0,167.25>, <0.412,-0.911,0>
  }
  smooth_triangle { // #3550
		<-339.65,-25.15,167.25>, <0.42,-0.908,0>,
		<-343.4,0,169>, <0.435,-0.9,0>,
		<-343.4,-25.15,169>, <0.443,-0.897,0>
  }
  smooth_triangle { // #3551
		<-339.65,0,167.25>, <0.412,-0.911,0>,
		<-335.9,-25.15,165.55>, <0.396,-0.918,0>,
		<-335.9,0,165.55>, <0.387,-0.922,0>
  }
  smooth_triangle { // #3552
		<-335.9,-25.15,165.55>, <0.396,-0.918,0>,
		<-339.65,0,167.25>, <0.412,-0.911,0>,
		<-339.65,-25.15,167.25>, <0.42,-0.908,0>
  }
  smooth_triangle { // #3553
		<-335.9,0,165.55>, <0.387,-0.922,0>,
		<-332.15,-25.15,164.05>, <0.372,-0.928,0>,
		<-332.15,0,164.05>, <0.366,-0.931,0>
  }
  smooth_triangle { // #3554
		<-332.15,-25.15,164.05>, <0.372,-0.928,0>,
		<-335.9,0,165.55>, <0.387,-0.922,0>,
		<-335.9,-25.15,165.55>, <0.396,-0.918,0>
  }
  triangle { // #3555
		<-332.15,0,164.05>,
		<-328.4,-25.15,162.6>,
		<-328.4,0,162.6>
  }
  smooth_triangle { // #3556
		<-328.4,-25.15,162.6>, <0.354,-0.935,0>,
		<-332.15,0,164.05>, <0.366,-0.931,0>,
		<-332.15,-25.15,164.05>, <0.372,-0.928,0>
  }
  triangle { // #3557
		<-328.4,0,162.6>,
		<-324.65,-25.15,161.25>,
		<-324.65,0,161.25>
  }
  triangle { // #3558
		<-324.65,-25.15,161.25>,
		<-328.4,0,162.6>,
		<-328.4,-25.15,162.6>
  }
  smooth_triangle { // #3559
		<-324.65,0,161.25>, <0.334,-0.942,0>,
		<-320.95,-25.15,159.95>, <0.324,-0.946,0>,
		<-320.95,0,159.95>, <0.319,-0.948,0>
  }
  triangle { // #3560
		<-320.95,-25.15,159.95>,
		<-324.65,0,161.25>,
		<-324.65,-25.15,161.25>
  }
  smooth_triangle { // #3561
		<-320.95,0,159.95>, <0.319,-0.948,0>,
		<-317.2,-25.15,158.7>, <0.309,-0.951,0>,
		<-317.2,0,158.7>, <0.304,-0.953,0>
  }
  smooth_triangle { // #3562
		<-317.2,-25.15,158.7>, <0.309,-0.951,0>,
		<-320.95,0,159.95>, <0.319,-0.948,0>,
		<-320.95,-25.15,159.95>, <0.324,-0.946,0>
  }
  smooth_triangle { // #3563
		<-317.2,0,158.7>, <0.304,-0.953,0>,
		<-313.45,-25.15,157.5>, <0.294,-0.956,0>,
		<-313.45,0,157.5>, <0.288,-0.957,0>
  }
  smooth_triangle { // #3564
		<-313.45,-25.15,157.5>, <0.294,-0.956,0>,
		<-317.2,0,158.7>, <0.304,-0.953,0>,
		<-317.2,-25.15,158.7>, <0.309,-0.951,0>
  }
  smooth_triangle { // #3565
		<-313.45,0,157.5>, <0.288,-0.957,0>,
		<-309.7,-25.15,156.4>, <0.278,-0.961,0>,
		<-309.7,0,156.4>, <0.273,-0.962,0>
  }
  smooth_triangle { // #3566
		<-309.7,-25.15,156.4>, <0.278,-0.961,0>,
		<-313.45,0,157.5>, <0.288,-0.957,0>,
		<-313.45,-25.15,157.5>, <0.294,-0.956,0>
  }
  smooth_triangle { // #3567
		<-309.7,0,156.4>, <0.273,-0.962,0>,
		<-305.95,-25.15,155.35>, <0.262,-0.965,0>,
		<-305.95,0,155.35>, <0.257,-0.966,0>
  }
  smooth_triangle { // #3568
		<-305.95,-25.15,155.35>, <0.262,-0.965,0>,
		<-309.7,0,156.4>, <0.273,-0.962,0>,
		<-309.7,-25.15,156.4>, <0.278,-0.961,0>
  }
  smooth_triangle { // #3569
		<-305.95,0,155.35>, <0.257,-0.966,0>,
		<-302.2,-25.15,154.4>, <0.246,-0.969,0>,
		<-302.2,0,154.4>, <0.241,-0.971,0>
  }
  smooth_triangle { // #3570
		<-302.2,-25.15,154.4>, <0.246,-0.969,0>,
		<-305.95,0,155.35>, <0.257,-0.966,0>,
		<-305.95,-25.15,155.35>, <0.262,-0.965,0>
  }
  smooth_triangle { // #3571
		<-302.2,0,154.4>, <0.241,-0.971,0>,
		<-298.45,-25.15,153.5>, <0.23,-0.973,0>,
		<-298.45,0,153.5>, <0.225,-0.974,0>
  }
  smooth_triangle { // #3572
		<-298.45,-25.15,153.5>, <0.23,-0.973,0>,
		<-302.2,0,154.4>, <0.241,-0.971,0>,
		<-302.2,-25.15,154.4>, <0.246,-0.969,0>
  }
  smooth_triangle { // #3573
		<-298.45,0,153.5>, <0.225,-0.974,0>,
		<-294.65,-25.15,152.65>, <0.214,-0.977,0>,
		<-294.65,0,152.65>, <0.208,-0.978,0>
  }
  smooth_triangle { // #3574
		<-294.65,-25.15,152.65>, <0.214,-0.977,0>,
		<-298.45,0,153.5>, <0.225,-0.974,0>,
		<-298.45,-25.15,153.5>, <0.23,-0.973,0>
  }
  smooth_triangle { // #3575
		<-294.65,0,152.65>, <0.208,-0.978,0>,
		<-290.9,-25.15,151.85>, <0.197,-0.98,0>,
		<-290.9,0,151.85>, <0.191,-0.981,0>
  }
  smooth_triangle { // #3576
		<-290.9,-25.15,151.85>, <0.197,-0.98,0>,
		<-294.65,0,152.65>, <0.208,-0.978,0>,
		<-294.65,-25.15,152.65>, <0.214,-0.977,0>
  }
  smooth_triangle { // #3577
		<-290.9,0,151.85>, <0.191,-0.981,0>,
		<-287.15,-25.15,151.15>, <0.18,-0.984,0>,
		<-287.15,0,151.15>, <0.175,-0.985,0>
  }
  smooth_triangle { // #3578
		<-287.15,-25.15,151.15>, <0.18,-0.984,0>,
		<-290.9,0,151.85>, <0.191,-0.981,0>,
		<-290.9,-25.15,151.85>, <0.197,-0.98,0>
  }
  smooth_triangle { // #3579
		<-287.15,0,151.15>, <0.175,-0.985,0>,
		<-283.4,-25.15,150.5>, <0.164,-0.987,0>,
		<-283.4,0,150.5>, <0.158,-0.987,-0>
  }
  smooth_triangle { // #3580
		<-283.4,-25.15,150.5>, <0.164,-0.987,0>,
		<-287.15,0,151.15>, <0.175,-0.985,0>,
		<-287.15,-25.15,151.15>, <0.18,-0.984,0>
  }
  smooth_triangle { // #3581
		<-283.4,0,150.5>, <0.158,-0.987,-0>,
		<-279.6,-25.15,149.9>, <0.147,-0.989,0>,
		<-279.6,0,149.9>, <0.141,-0.99,0>
  }
  smooth_triangle { // #3582
		<-279.6,-25.15,149.9>, <0.147,-0.989,0>,
		<-283.4,0,150.5>, <0.158,-0.987,-0>,
		<-283.4,-25.15,150.5>, <0.164,-0.987,0>
  }
  smooth_triangle { // #3583
		<-279.6,0,149.9>, <0.141,-0.99,0>,
		<-275.85,-25.15,149.4>, <0.13,-0.992,0>,
		<-275.85,0,149.4>, <0.124,-0.992,0>
  }
  smooth_triangle { // #3584
		<-275.85,-25.15,149.4>, <0.13,-0.992,0>,
		<-279.6,0,149.9>, <0.141,-0.99,0>,
		<-279.6,-25.15,149.9>, <0.147,-0.989,0>
  }
  smooth_triangle { // #3585
		<-275.85,0,149.4>, <0.124,-0.992,0>,
		<-272.05,-25.15,148.95>, <0.112,-0.994,0>,
		<-272.05,0,148.95>, <0.107,-0.994,0>
  }
  smooth_triangle { // #3586
		<-272.05,-25.15,148.95>, <0.112,-0.994,0>,
		<-275.85,0,149.4>, <0.124,-0.992,0>,
		<-275.85,-25.15,149.4>, <0.13,-0.992,0>
  }
  smooth_triangle { // #3587
		<-272.05,0,148.95>, <0.107,-0.994,0>,
		<-268.25,-25.15,148.55>, <0.095,-0.995,0>,
		<-268.25,0,148.55>, <0.089,-0.996,0>
  }
  smooth_triangle { // #3588
		<-268.25,-25.15,148.55>, <0.095,-0.995,0>,
		<-272.05,0,148.95>, <0.107,-0.994,0>,
		<-272.05,-25.15,148.95>, <0.112,-0.994,0>
  }
  smooth_triangle { // #3589
		<-268.25,0,148.55>, <0.089,-0.996,0>,
		<-264.5,-25.15,148.25>, <0.077,-0.997,0>,
		<-264.5,0,148.25>, <0.071,-0.997,0>
  }
  smooth_triangle { // #3590
		<-264.5,-25.15,148.25>, <0.077,-0.997,0>,
		<-268.25,0,148.55>, <0.089,-0.996,0>,
		<-268.25,-25.15,148.55>, <0.095,-0.995,0>
  }
  smooth_triangle { // #3591
		<-264.5,0,148.25>, <0.071,-0.997,0>,
		<-260.7,-25.15,148>, <0.059,-0.998,0>,
		<-260.7,0,148>, <0.053,-0.999,-0>
  }
  smooth_triangle { // #3592
		<-260.7,-25.15,148>, <0.059,-0.998,0>,
		<-264.5,0,148.25>, <0.071,-0.997,0>,
		<-264.5,-25.15,148.25>, <0.077,-0.997,0>
  }
  smooth_triangle { // #3593
		<-260.7,0,148>, <0.053,-0.999,-0>,
		<-256.95,-25.15,147.85>, <0.041,-0.999,0>,
		<-256.95,0,147.85>, <0.035,-0.999,0>
  }
  smooth_triangle { // #3594
		<-256.95,-25.15,147.85>, <0.041,-0.999,0>,
		<-260.7,0,148>, <0.053,-0.999,-0>,
		<-260.7,-25.15,148>, <0.059,-0.998,0>
  }
  smooth_triangle { // #3595
		<-256.95,0,147.85>, <0.035,-0.999,0>,
		<-253.15,-25.15,147.7>, <0.024,-1,0>,
		<-253.15,0,147.7>, <0.018,-1,-0>
  }
  smooth_triangle { // #3596
		<-253.15,-25.15,147.7>, <0.024,-1,0>,
		<-256.95,0,147.85>, <0.035,-0.999,0>,
		<-256.95,-25.15,147.85>, <0.041,-0.999,0>
  }
  smooth_triangle { // #3597
		<-253.15,0,147.7>, <0.018,-1,-0>,
		<-249.4,-25.15,147.65>, <0.006,-1,0>,
		<-249.4,0,147.65>, <-0,-1,0>
  }
  smooth_triangle { // #3598
		<-249.4,-25.15,147.65>, <0.006,-1,0>,
		<-253.15,0,147.7>, <0.018,-1,-0>,
		<-253.15,-25.15,147.7>, <0.024,-1,0>
  }
  smooth_triangle { // #3599
		<-249.4,0,147.65>, <-0,-1,0>,
		<-245.6,-25.15,147.7>, <-0.012,-1,0>,
		<-245.6,0,147.7>, <-0.018,-1,0>
  }
  smooth_triangle { // #3600
		<-245.6,-25.15,147.7>, <-0.012,-1,0>,
		<-249.4,0,147.65>, <-0,-1,0>,
		<-249.4,-25.15,147.65>, <0.006,-1,0>
  }
  smooth_triangle { // #3601
		<-245.6,0,147.7>, <-0.018,-1,0>,
		<-241.85,-25.15,147.8>, <-0.03,-1,0>,
		<-241.85,0,147.8>, <-0.036,-0.999,-0>
  }
  smooth_triangle { // #3602
		<-241.85,-25.15,147.8>, <-0.03,-1,0>,
		<-245.6,0,147.7>, <-0.018,-1,0>,
		<-245.6,-25.15,147.7>, <-0.012,-1,0>
  }
  smooth_triangle { // #3603
		<-241.85,0,147.8>, <-0.036,-0.999,-0>,
		<-238.05,-25.15,147.95>, <-0.048,-0.999,0>,
		<-238.05,0,147.95>, <-0.054,-0.999,0>
  }
  smooth_triangle { // #3604
		<-238.05,-25.15,147.95>, <-0.048,-0.999,0>,
		<-241.85,0,147.8>, <-0.036,-0.999,-0>,
		<-241.85,-25.15,147.8>, <-0.03,-1,0>
  }
  smooth_triangle { // #3605
		<-238.05,0,147.95>, <-0.054,-0.999,0>,
		<-234.3,-25.15,148.2>, <-0.066,-0.998,0>,
		<-234.3,0,148.2>, <-0.072,-0.997,-0>
  }
  smooth_triangle { // #3606
		<-234.3,-25.15,148.2>, <-0.066,-0.998,0>,
		<-238.05,0,147.95>, <-0.054,-0.999,0>,
		<-238.05,-25.15,147.95>, <-0.048,-0.999,0>
  }
  smooth_triangle { // #3607
		<-234.3,0,148.2>, <-0.072,-0.997,-0>,
		<-230.5,-25.15,148.45>, <-0.084,-0.996,0>,
		<-230.5,0,148.45>, <-0.09,-0.996,0>
  }
  smooth_triangle { // #3608
		<-230.5,-25.15,148.45>, <-0.084,-0.996,0>,
		<-234.3,0,148.2>, <-0.072,-0.997,-0>,
		<-234.3,-25.15,148.2>, <-0.066,-0.998,0>
  }
  smooth_triangle { // #3609
		<-230.5,0,148.45>, <-0.09,-0.996,0>,
		<-226.75,-25.15,148.85>, <-0.102,-0.995,0>,
		<-226.75,0,148.85>, <-0.108,-0.994,0>
  }
  smooth_triangle { // #3610
		<-226.75,-25.15,148.85>, <-0.102,-0.995,0>,
		<-230.5,0,148.45>, <-0.09,-0.996,0>,
		<-230.5,-25.15,148.45>, <-0.084,-0.996,0>
  }
  smooth_triangle { // #3611
		<-226.75,0,148.85>, <-0.108,-0.994,0>,
		<-222.95,-25.15,149.25>, <-0.119,-0.993,-0>,
		<-222.95,0,149.25>, <-0.125,-0.992,-0>
  }
  smooth_triangle { // #3612
		<-222.95,-25.15,149.25>, <-0.119,-0.993,-0>,
		<-226.75,0,148.85>, <-0.108,-0.994,0>,
		<-226.75,-25.15,148.85>, <-0.102,-0.995,0>
  }
  smooth_triangle { // #3613
		<-222.95,0,149.25>, <-0.125,-0.992,-0>,
		<-219.2,-25.15,149.75>, <-0.137,-0.991,-0>,
		<-219.2,0,149.75>, <-0.143,-0.99,0>
  }
  smooth_triangle { // #3614
		<-219.2,-25.15,149.75>, <-0.137,-0.991,-0>,
		<-222.95,0,149.25>, <-0.125,-0.992,-0>,
		<-222.95,-25.15,149.25>, <-0.119,-0.993,-0>
  }
  smooth_triangle { // #3615
		<-219.2,0,149.75>, <-0.143,-0.99,0>,
		<-215.45,-25.15,150.35>, <-0.154,-0.988,0>,
		<-215.45,0,150.35>, <-0.16,-0.987,0>
  }
  smooth_triangle { // #3616
		<-215.45,-25.15,150.35>, <-0.154,-0.988,0>,
		<-219.2,0,149.75>, <-0.143,-0.99,0>,
		<-219.2,-25.15,149.75>, <-0.137,-0.991,-0>
  }
  triangle { // #3617
		<-215.45,0,150.35>,
		<-211.65,-25.15,150.95>,
		<-211.65,0,150.95>
  }
  smooth_triangle { // #3618
		<-211.65,-25.15,150.95>, <-0.168,-0.986,0>,
		<-215.45,0,150.35>, <-0.16,-0.987,0>,
		<-215.45,-25.15,150.35>, <-0.154,-0.988,0>
  }
  triangle { // #3619
		<-211.65,0,150.95>,
		<-207.9,-25.15,151.65>,
		<-207.9,0,151.65>
  }
  triangle { // #3620
		<-207.9,-25.15,151.65>,
		<-211.65,0,150.95>,
		<-211.65,-25.15,150.95>
  }
  triangle { // #3621
		<-207.9,0,151.65>,
		<-205.05,-25.15,152.1>,
		<-205.05,0,152.1>
  }
  triangle { // #3622
		<-205.05,-25.15,152.1>,
		<-207.9,0,151.65>,
		<-207.9,-25.15,151.65>
  }
  triangle { // #3623
		<-205.05,0,152.1>,
		<-204.1,-25.15,152.3>,
		<-204.1,0,152.3>
  }
  triangle { // #3624
		<-204.1,-25.15,152.3>,
		<-205.05,0,152.1>,
		<-205.05,-25.15,152.1>
  }
  triangle { // #3625
		<-204.1,0,152.3>,
		<-200.35,-25.15,152.95>,
		<-200.35,0,152.95>
  }
  triangle { // #3626
		<-200.35,-25.15,152.95>,
		<-204.1,0,152.3>,
		<-204.1,-25.15,152.3>
  }
  triangle { // #3627
		<-200.35,0,152.95>,
		<-196.55,-25.15,153.55>,
		<-196.55,0,153.55>
  }
  triangle { // #3628
		<-196.55,-25.15,153.55>,
		<-200.35,0,152.95>,
		<-200.35,-25.15,152.95>
  }
  triangle { // #3629
		<-196.55,0,153.55>,
		<-192.8,-25.15,154.2>,
		<-192.8,0,154.15>
  }
  triangle { // #3630
		<-192.8,-25.15,154.2>,
		<-196.55,0,153.55>,
		<-196.55,-25.15,153.55>
  }
  triangle { // #3631
		<-192.8,0,154.15>,
		<-189.05,-25.15,154.8>,
		<-189.05,0,154.8>
  }
  triangle { // #3632
		<-189.05,-25.15,154.8>,
		<-192.8,0,154.15>,
		<-192.8,-25.15,154.2>
  }
  triangle { // #3633
		<-189.05,0,154.8>,
		<-185.25,-25.15,155.4>,
		<-185.25,0,155.4>
  }
  triangle { // #3634
		<-185.25,-25.15,155.4>,
		<-189.05,0,154.8>,
		<-189.05,-25.15,154.8>
  }
  triangle { // #3635
		<-185.25,0,155.4>,
		<-181.5,-25.15,155.95>,
		<-181.5,0,155.95>
  }
  triangle { // #3636
		<-181.5,-25.15,155.95>,
		<-185.25,0,155.4>,
		<-185.25,-25.15,155.4>
  }
  triangle { // #3637
		<-181.5,0,155.95>,
		<-177.7,-25.15,156.55>,
		<-177.7,0,156.55>
  }
  triangle { // #3638
		<-177.7,-25.15,156.55>,
		<-181.5,0,155.95>,
		<-181.5,-25.15,155.95>
  }
  triangle { // #3639
		<-177.7,0,156.55>,
		<-173.95,-25.15,157.1>,
		<-173.95,0,157.1>
  }
  triangle { // #3640
		<-173.95,-25.15,157.1>,
		<-177.7,0,156.55>,
		<-177.7,-25.15,156.55>
  }
  triangle { // #3641
		<-173.95,0,157.1>,
		<-170.15,-25.15,157.65>,
		<-170.15,0,157.65>
  }
  triangle { // #3642
		<-170.15,-25.15,157.65>,
		<-173.95,0,157.1>,
		<-173.95,-25.15,157.1>
  }
  triangle { // #3643
		<-170.15,0,157.65>,
		<-166.4,-25.15,158.2>,
		<-166.4,0,158.2>
  }
  triangle { // #3644
		<-166.4,-25.15,158.2>,
		<-170.15,0,157.65>,
		<-170.15,-25.15,157.65>
  }
  triangle { // #3645
		<-166.4,0,158.2>,
		<-162.65,-25.15,158.7>,
		<-162.65,0,158.7>
  }
  triangle { // #3646
		<-162.65,-25.15,158.7>,
		<-166.4,0,158.2>,
		<-166.4,-25.15,158.2>
  }
  triangle { // #3647
		<-162.65,0,158.7>,
		<-158.85,-25.15,159.25>,
		<-158.85,0,159.25>
  }
  triangle { // #3648
		<-158.85,-25.15,159.25>,
		<-162.65,0,158.7>,
		<-162.65,-25.15,158.7>
  }
  triangle { // #3649
		<-158.85,0,159.25>,
		<-155.1,-25.15,159.75>,
		<-155.1,0,159.75>
  }
  triangle { // #3650
		<-155.1,-25.15,159.75>,
		<-158.85,0,159.25>,
		<-158.85,-25.15,159.25>
  }
  triangle { // #3651
		<-155.1,0,159.75>,
		<-151.3,-25.15,160.25>,
		<-151.3,0,160.25>
  }
  triangle { // #3652
		<-151.3,-25.15,160.25>,
		<-155.1,0,159.75>,
		<-155.1,-25.15,159.75>
  }
  triangle { // #3653
		<-151.3,0,160.25>,
		<-147.55,-25.15,160.75>,
		<-147.55,0,160.75>
  }
  triangle { // #3654
		<-147.55,-25.15,160.75>,
		<-151.3,0,160.25>,
		<-151.3,-25.15,160.25>
  }
  triangle { // #3655
		<-147.55,0,160.75>,
		<-143.75,-25.15,161.2>,
		<-143.75,0,161.2>
  }
  triangle { // #3656
		<-143.75,-25.15,161.2>,
		<-147.55,0,160.75>,
		<-147.55,-25.15,160.75>
  }
  triangle { // #3657
		<-143.75,0,161.2>,
		<-140,-25.15,161.7>,
		<-140,0,161.7>
  }
  triangle { // #3658
		<-140,-25.15,161.7>,
		<-143.75,0,161.2>,
		<-143.75,-25.15,161.2>
  }
  triangle { // #3659
		<-140,0,161.7>,
		<-136.25,-25.15,162.2>,
		<-136.25,0,162.2>
  }
  triangle { // #3660
		<-136.25,-25.15,162.2>,
		<-140,0,161.7>,
		<-140,-25.15,161.7>
  }
  triangle { // #3661
		<-136.25,0,162.2>,
		<-132.45,-25.15,162.7>,
		<-132.45,0,162.7>
  }
  triangle { // #3662
		<-132.45,-25.15,162.7>,
		<-136.25,0,162.2>,
		<-136.25,-25.15,162.2>
  }
  triangle { // #3663
		<-132.45,0,162.7>,
		<-128.7,-25.15,163.15>,
		<-128.7,0,163.15>
  }
  triangle { // #3664
		<-128.7,-25.15,163.15>,
		<-132.45,0,162.7>,
		<-132.45,-25.15,162.7>
  }
  triangle { // #3665
		<-128.7,0,163.15>,
		<-124.9,-25.15,163.65>,
		<-124.9,0,163.65>
  }
  triangle { // #3666
		<-124.9,-25.15,163.65>,
		<-128.7,0,163.15>,
		<-128.7,-25.15,163.15>
  }
  triangle { // #3667
		<-124.9,0,163.65>,
		<-121.15,-25.15,164.15>,
		<-121.15,0,164.15>
  }
  triangle { // #3668
		<-121.15,-25.15,164.15>,
		<-124.9,0,163.65>,
		<-124.9,-25.15,163.65>
  }
  triangle { // #3669
		<-121.15,0,164.15>,
		<-117.35,-25.15,164.6>,
		<-117.35,0,164.6>
  }
  triangle { // #3670
		<-117.35,-25.15,164.6>,
		<-121.15,0,164.15>,
		<-121.15,-25.15,164.15>
  }
  triangle { // #3671
		<-117.35,0,164.6>,
		<-113.6,-25.15,165.1>,
		<-113.6,0,165.1>
  }
  triangle { // #3672
		<-113.6,-25.15,165.1>,
		<-117.35,0,164.6>,
		<-117.35,-25.15,164.6>
  }
  triangle { // #3673
		<-113.6,0,165.1>,
		<-109.8,-25.15,165.6>,
		<-109.8,0,165.6>
  }
  triangle { // #3674
		<-109.8,-25.15,165.6>,
		<-113.6,0,165.1>,
		<-113.6,-25.15,165.1>
  }
  triangle { // #3675
		<-109.8,0,165.6>,
		<-106.05,-25.15,166.05>,
		<-106.05,0,166.05>
  }
  triangle { // #3676
		<-106.05,-25.15,166.05>,
		<-109.8,0,165.6>,
		<-109.8,-25.15,165.6>
  }
  triangle { // #3677
		<-106.05,0,166.05>,
		<-102.3,-25.15,166.55>,
		<-102.3,0,166.55>
  }
  triangle { // #3678
		<-102.3,-25.15,166.55>,
		<-106.05,0,166.05>,
		<-106.05,-25.15,166.05>
  }
  triangle { // #3679
		<-102.3,0,166.55>,
		<-98.5,-25.15,167.05>,
		<-98.5,0,167.05>
  }
  triangle { // #3680
		<-98.5,-25.15,167.05>,
		<-102.3,0,166.55>,
		<-102.3,-25.15,166.55>
  }
  triangle { // #3681
		<-98.5,0,167.05>,
		<-95.05,-25.15,167.45>,
		<-95.05,0,167.45>
  }
  triangle { // #3682
		<-95.05,-25.15,167.45>,
		<-98.5,0,167.05>,
		<-98.5,-25.15,167.05>
  }
  triangle { // #3683
		<-95.05,0,167.45>,
		<-90.95,-25.15,168>,
		<-90.95,0,168>
  }
  triangle { // #3684
		<-90.95,-25.15,168>,
		<-95.05,0,167.45>,
		<-95.05,-25.15,167.45>
  }
  triangle { // #3685
		<-90.95,0,168>,
		<-87.2,-25.15,168.45>,
		<-87.2,0,168.45>
  }
  triangle { // #3686
		<-87.2,-25.15,168.45>,
		<-90.95,0,168>,
		<-90.95,-25.15,168>
  }
  triangle { // #3687
		<-87.2,0,168.45>,
		<-83.4,-25.15,168.9>,
		<-83.4,0,168.9>
  }
  triangle { // #3688
		<-83.4,-25.15,168.9>,
		<-87.2,0,168.45>,
		<-87.2,-25.15,168.45>
  }
  triangle { // #3689
		<-83.4,0,168.9>,
		<-79.65,-25.15,169.3>,
		<-79.65,0,169.3>
  }
  triangle { // #3690
		<-79.65,-25.15,169.3>,
		<-83.4,0,168.9>,
		<-83.4,-25.15,168.9>
  }
  triangle { // #3691
		<-79.65,0,169.3>,
		<-75.9,-25.15,169.7>,
		<-75.9,0,169.7>
  }
  triangle { // #3692
		<-75.9,-25.15,169.7>,
		<-79.65,0,169.3>,
		<-79.65,-25.15,169.3>
  }
  triangle { // #3693
		<-75.9,0,169.7>,
		<-72.1,-25.15,170.1>,
		<-72.1,0,170.1>
  }
  triangle { // #3694
		<-72.1,-25.15,170.1>,
		<-75.9,0,169.7>,
		<-75.9,-25.15,169.7>
  }
  triangle { // #3695
		<-72.1,0,170.1>,
		<-68.35,-25.15,170.45>,
		<-68.35,0,170.45>
  }
  triangle { // #3696
		<-68.35,-25.15,170.45>,
		<-72.1,0,170.1>,
		<-72.1,-25.15,170.1>
  }
  triangle { // #3697
		<-68.35,0,170.45>,
		<-64.55,-25.15,170.75>,
		<-64.55,0,170.75>
  }
  triangle { // #3698
		<-64.55,-25.15,170.75>,
		<-68.35,0,170.45>,
		<-68.35,-25.15,170.45>
  }
  triangle { // #3699
		<-64.55,0,170.75>,
		<-60.8,-25.15,171.05>,
		<-60.8,0,171.05>
  }
  triangle { // #3700
		<-60.8,-25.15,171.05>,
		<-64.55,0,170.75>,
		<-64.55,-25.15,170.75>
  }
  triangle { // #3701
		<-60.8,0,171.05>,
		<-57,-25.15,171.3>,
		<-57,0,171.3>
  }
  triangle { // #3702
		<-57,-25.15,171.3>,
		<-60.8,0,171.05>,
		<-60.8,-25.15,171.05>
  }
  triangle { // #3703
		<-57,0,171.3>,
		<-53.25,-25.15,171.55>,
		<-53.25,0,171.55>
  }
  triangle { // #3704
		<-53.25,-25.15,171.55>,
		<-57,0,171.3>,
		<-57,-25.15,171.3>
  }
  triangle { // #3705
		<-53.25,0,171.55>,
		<-49.45,-25.15,171.8>,
		<-49.45,0,171.8>
  }
  triangle { // #3706
		<-49.45,-25.15,171.8>,
		<-53.25,0,171.55>,
		<-53.25,-25.15,171.55>
  }
  triangle { // #3707
		<-49.45,0,171.8>,
		<-45.7,-25.15,172>,
		<-45.7,0,172>
  }
  triangle { // #3708
		<-45.7,-25.15,172>,
		<-49.45,0,171.8>,
		<-49.45,-25.15,171.8>
  }
  triangle { // #3709
		<-45.7,0,172>,
		<-41.95,-25.15,172.2>,
		<-41.95,0,172.2>
  }
  triangle { // #3710
		<-41.95,-25.15,172.2>,
		<-45.7,0,172>,
		<-45.7,-25.15,172>
  }
  triangle { // #3711
		<-41.95,0,172.2>,
		<-38.15,-25.15,172.35>,
		<-38.15,0,172.35>
  }
  triangle { // #3712
		<-38.15,-25.15,172.35>,
		<-41.95,0,172.2>,
		<-41.95,-25.15,172.2>
  }
  triangle { // #3713
		<-38.15,0,172.35>,
		<-34.4,-25.15,172.45>,
		<-34.4,0,172.45>
  }
  triangle { // #3714
		<-34.4,-25.15,172.45>,
		<-38.15,0,172.35>,
		<-38.15,-25.15,172.35>
  }
  triangle { // #3715
		<-34.4,0,172.45>,
		<-30.6,-25.15,172.55>,
		<-30.6,0,172.55>
  }
  triangle { // #3716
		<-30.6,-25.15,172.55>,
		<-34.4,0,172.45>,
		<-34.4,-25.15,172.45>
  }
  triangle { // #3717
		<-30.6,0,172.55>,
		<-26.85,-25.15,172.65>,
		<-26.85,0,172.65>
  }
  triangle { // #3718
		<-26.85,-25.15,172.65>,
		<-30.6,0,172.55>,
		<-30.6,-25.15,172.55>
  }
  triangle { // #3719
		<-26.85,0,172.65>,
		<-23.05,-25.15,172.75>,
		<-23.05,0,172.75>
  }
  triangle { // #3720
		<-23.05,-25.15,172.75>,
		<-26.85,0,172.65>,
		<-26.85,-25.15,172.65>
  }
  triangle { // #3721
		<-23.05,0,172.75>,
		<-19.3,-25.15,172.8>,
		<-19.3,0,172.8>
  }
  triangle { // #3722
		<-19.3,-25.15,172.8>,
		<-23.05,0,172.75>,
		<-23.05,-25.15,172.75>
  }
  triangle { // #3723
		<-19.3,0,172.8>,
		<-15.5,-25.15,172.85>,
		<-15.5,0,172.85>
  }
  triangle { // #3724
		<-15.5,-25.15,172.85>,
		<-19.3,0,172.8>,
		<-19.3,-25.15,172.8>
  }
  triangle { // #3725
		<-15.5,0,172.85>,
		<-11.75,-25.15,172.9>,
		<-11.75,0,172.9>
  }
  triangle { // #3726
		<-11.75,-25.15,172.9>,
		<-15.5,0,172.85>,
		<-15.5,-25.15,172.85>
  }
  triangle { // #3727
		<-11.75,0,172.9>,
		<-8,-25.15,172.9>,
		<-8,0,172.9>
  }
  triangle { // #3728
		<-8,-25.15,172.9>,
		<-11.75,0,172.9>,
		<-11.75,-25.15,172.9>
  }
  triangle { // #3729
		<-8,0,172.9>,
		<-4.2,-25.15,172.95>,
		<-4.2,0,172.95>
  }
  triangle { // #3730
		<-4.2,-25.15,172.95>,
		<-8,0,172.9>,
		<-8,-25.15,172.9>
  }
  triangle { // #3731
		<-4.2,0,172.95>,
		<-0.45,-25.15,172.95>,
		<-0.45,0,172.95>
  }
  triangle { // #3732
		<-0.45,-25.15,172.95>,
		<-4.2,0,172.95>,
		<-4.2,-25.15,172.95>
  }
  triangle { // #3733
		<-0.45,0,172.95>,
		<-0.45,-25.15,12.8>,
		<-0.45,0,12.8>
  }
  triangle { // #3734
		<-0.45,-25.15,12.8>,
		<-0.45,0,172.95>,
		<-0.45,-25.15,172.95>
  }
  triangle { // #3735
		<-0.45,0,12.8>,
		<-445.3,-25.15,12.8>,
		<-445.3,0,12.8>
  }
  triangle { // #3736
		<-445.3,-25.15,12.8>,
		<-0.45,0,12.8>,
		<-0.45,-25.15,12.8>
  }
  triangle { // #3737
		<350,0,167.95>,
		<439.55,-0,-1.9>,
		<346.15,0,165.9>
  }
  triangle { // #3738
		<439.55,0,259.4>,
		<439.55,-0,-1.9>,
		<437.95,0,255.55>
  }
  triangle { // #3739
		<437.95,0,255.55>,
		<439.55,-0,-1.9>,
		<436.15,0,251.7>
  }
  triangle { // #3740
		<436.15,0,251.7>,
		<439.55,-0,-1.9>,
		<434.2,0,247.85>
  }
  triangle { // #3741
		<434.2,0,247.85>,
		<439.55,-0,-1.9>,
		<432.1,0,244>
  }
  triangle { // #3742
		<432.1,0,244>,
		<439.55,-0,-1.9>,
		<429.8,0,240.2>
  }
  triangle { // #3743
		<429.8,0,240.2>,
		<439.55,-0,-1.9>,
		<427.4,0,236.4>
  }
  triangle { // #3744
		<427.4,0,236.4>,
		<439.55,-0,-1.9>,
		<424.8,0,232.65>
  }
  triangle { // #3745
		<424.8,0,232.65>,
		<439.55,-0,-1.9>,
		<422,0,228.9>
  }
  triangle { // #3746
		<422,0,228.9>,
		<439.55,-0,-1.9>,
		<419.1,0,225.15>
  }
  triangle { // #3747
		<419.1,0,225.15>,
		<439.55,-0,-1.9>,
		<416,0,221.4>
  }
  triangle { // #3748
		<416,0,221.4>,
		<439.55,-0,-1.9>,
		<412.75,0,217.7>
  }
  triangle { // #3749
		<412.75,0,217.7>,
		<439.55,-0,-1.9>,
		<409.3,0,214>
  }
  triangle { // #3750
		<409.3,0,214>,
		<439.55,-0,-1.9>,
		<406,0,210.6>
  }
  triangle { // #3751
		<406,0,210.6>,
		<439.55,-0,-1.9>,
		<402,0,206.65>
  }
  triangle { // #3752
		<402,0,206.65>,
		<439.55,-0,-1.9>,
		<398.1,0,203>
  }
  triangle { // #3753
		<398.1,0,203>,
		<439.55,-0,-1.9>,
		<394,0,199.35>
  }
  triangle { // #3754
		<394,0,199.35>,
		<439.55,-0,-1.9>,
		<389.85,0,195.8>
  }
  triangle { // #3755
		<389.85,0,195.8>,
		<439.55,-0,-1.9>,
		<385.75,0,192.4>
  }
  triangle { // #3756
		<385.75,0,192.4>,
		<439.55,-0,-1.9>,
		<381.65,0,189.1>
  }
  triangle { // #3757
		<381.65,0,189.1>,
		<439.55,-0,-1.9>,
		<377.6,0,185.95>
  }
  triangle { // #3758
		<377.6,0,185.95>,
		<439.55,-0,-1.9>,
		<373.6,0,182.95>
  }
  triangle { // #3759
		<373.6,0,182.95>,
		<439.55,-0,-1.9>,
		<369.6,0,180.1>
  }
  triangle { // #3760
		<369.6,0,180.1>,
		<439.55,-0,-1.9>,
		<365.6,0,177.4>
  }
  triangle { // #3761
		<365.6,0,177.4>,
		<439.55,-0,-1.9>,
		<361.65,0,174.8>
  }
  triangle { // #3762
		<361.65,0,174.8>,
		<439.55,-0,-1.9>,
		<357.75,0,172.4>
  }
  triangle { // #3763
		<357.75,0,172.4>,
		<439.55,-0,-1.9>,
		<353.85,0,170.1>
  }
  triangle { // #3764
		<353.85,0,170.1>,
		<439.55,-0,-1.9>,
		<350,0,167.95>
  }
  triangle { // #3765
		<-0.45,0,172.95>,
		<3.35,0,172.95>,
		<-0.45,0,-1.9>
  }
  triangle { // #3766
		<-0.45,0,-1.9>,
		<3.35,0,172.95>,
		<439.55,-0,-1.9>
  }
  triangle { // #3767
		<3.35,0,172.95>,
		<7.1,0,172.9>,
		<439.55,-0,-1.9>
  }
  triangle { // #3768
		<7.1,0,172.9>,
		<10.9,0,172.85>,
		<439.55,-0,-1.9>
  }
  triangle { // #3769
		<10.9,0,172.85>,
		<14.65,0,172.85>,
		<439.55,-0,-1.9>
  }
  triangle { // #3770
		<14.65,0,172.85>,
		<18.4,0,172.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3771
		<18.4,0,172.75>,
		<22.2,0,172.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3772
		<22.2,0,172.7>,
		<25.95,0,172.6>,
		<439.55,-0,-1.9>
  }
  triangle { // #3773
		<25.95,0,172.6>,
		<29.75,0,172.55>,
		<439.55,-0,-1.9>
  }
  triangle { // #3774
		<29.75,0,172.55>,
		<33.5,0,172.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3775
		<33.5,0,172.4>,
		<37.3,0,172.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3776
		<37.3,0,172.3>,
		<41.05,0,172.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3777
		<41.05,0,172.15>,
		<44.85,0,171.95>,
		<439.55,-0,-1.9>
  }
  triangle { // #3778
		<44.85,0,171.95>,
		<48.6,0,171.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3779
		<48.6,0,171.75>,
		<52.35,0,171.55>,
		<439.55,-0,-1.9>
  }
  triangle { // #3780
		<52.35,0,171.55>,
		<56.15,0,171.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3781
		<56.15,0,171.3>,
		<59.9,0,171.05>,
		<439.55,-0,-1.9>
  }
  triangle { // #3782
		<59.9,0,171.05>,
		<63.7,0,170.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3783
		<63.7,0,170.75>,
		<67.45,0,170.45>,
		<439.55,-0,-1.9>
  }
  triangle { // #3784
		<67.45,0,170.45>,
		<71.25,0,170.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3785
		<71.25,0,170.15>,
		<75,0,169.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3786
		<75,0,169.8>,
		<78.75,0,169.45>,
		<439.55,-0,-1.9>
  }
  triangle { // #3787
		<78.75,0,169.45>,
		<82.55,0,169.05>,
		<439.55,-0,-1.9>
  }
  triangle { // #3788
		<82.55,0,169.05>,
		<86.3,0,168.65>,
		<439.55,-0,-1.9>
  }
  triangle { // #3789
		<86.3,0,168.65>,
		<90.1,0,168.2>,
		<439.55,-0,-1.9>
  }
  triangle { // #3790
		<90.1,0,168.2>,
		<93.85,0,167.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3791
		<93.85,0,167.75>,
		<97.65,0,167.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3792
		<97.65,0,167.3>,
		<101.4,0,166.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3793
		<101.4,0,166.8>,
		<105.2,0,166.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3794
		<105.2,0,166.3>,
		<108.95,0,165.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3795
		<108.95,0,165.8>,
		<112.7,0,165.25>,
		<439.55,-0,-1.9>
  }
  triangle { // #3796
		<112.7,0,165.25>,
		<116.5,0,164.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3797
		<116.5,0,164.7>,
		<120.25,0,164.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3798
		<120.25,0,164.15>,
		<124.05,0,163.55>,
		<439.55,-0,-1.9>
  }
  triangle { // #3799
		<124.05,0,163.55>,
		<127.8,0,162.95>,
		<439.55,-0,-1.9>
  }
  triangle { // #3800
		<127.8,0,162.95>,
		<131.6,0,162.35>,
		<439.55,-0,-1.9>
  }
  triangle { // #3801
		<131.6,0,162.35>,
		<135.35,0,161.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3802
		<135.35,0,161.7>,
		<139.1,0,161.05>,
		<439.55,-0,-1.9>
  }
  triangle { // #3803
		<139.1,0,161.05>,
		<142.9,0,160.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3804
		<142.9,0,160.4>,
		<146.65,0,159.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3805
		<146.65,0,159.7>,
		<150.45,0,159>,
		<439.55,-0,-1.9>
  }
  triangle { // #3806
		<150.45,0,159>,
		<154.2,0,158.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3807
		<154.2,0,158.3>,
		<158,0,157.6>,
		<439.55,-0,-1.9>
  }
  triangle { // #3808
		<158,0,157.6>,
		<161.75,0,156.9>,
		<439.55,-0,-1.9>
  }
  triangle { // #3809
		<161.75,0,156.9>,
		<165.55,0,156.2>,
		<439.55,-0,-1.9>
  }
  triangle { // #3810
		<165.55,0,156.2>,
		<169.3,0,155.5>,
		<439.55,-0,-1.9>
  }
  triangle { // #3811
		<169.3,0,155.5>,
		<173.05,0,154.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3812
		<173.05,0,154.8>,
		<176.85,0,154.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3813
		<176.85,0,154.15>,
		<180.6,0,153.45>,
		<439.55,-0,-1.9>
  }
  triangle { // #3814
		<180.6,0,153.45>,
		<184.4,0,152.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3815
		<184.4,0,152.75>,
		<188.15,0,152.1>,
		<439.55,-0,-1.9>
  }
  triangle { // #3816
		<188.15,0,152.1>,
		<191.95,0,151.45>,
		<439.55,-0,-1.9>
  }
  triangle { // #3817
		<191.95,0,151.45>,
		<195.7,0,150.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3818
		<195.7,0,150.8>,
		<199.45,0,150.1>,
		<439.55,-0,-1.9>
  }
  triangle { // #3819
		<199.45,0,150.1>,
		<203.25,0,149.45>,
		<439.55,-0,-1.9>
  }
  triangle { // #3820
		<203.25,0,149.45>,
		<207,0,148.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3821
		<207,0,148.8>,
		<210.8,0,148.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3822
		<210.8,0,148.15>,
		<214.55,0,147.55>,
		<439.55,-0,-1.9>
  }
  triangle { // #3823
		<214.55,0,147.55>,
		<218.3,0,147>,
		<439.55,-0,-1.9>
  }
  triangle { // #3824
		<218.3,0,147>,
		<222.1,0,146.5>,
		<439.55,-0,-1.9>
  }
  triangle { // #3825
		<222.1,0,146.5>,
		<225.85,0,146.1>,
		<439.55,-0,-1.9>
  }
  triangle { // #3826
		<225.85,0,146.1>,
		<229.65,0,145.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3827
		<229.65,0,145.7>,
		<233.4,0,145.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3828
		<233.4,0,145.4>,
		<237.2,0,145.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3829
		<237.2,0,145.15>,
		<240.95,0,144.95>,
		<439.55,-0,-1.9>
  }
  triangle { // #3830
		<240.95,0,144.95>,
		<244.75,0,144.85>,
		<439.55,-0,-1.9>
  }
  triangle { // #3831
		<244.75,0,144.85>,
		<248.5,0,144.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3832
		<248.5,0,144.75>,
		<252.3,0,144.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3833
		<252.3,0,144.75>,
		<256.1,0,144.8>,
		<439.55,-0,-1.9>
  }
  triangle { // #3834
		<256.1,0,144.8>,
		<259.85,0,144.9>,
		<439.55,-0,-1.9>
  }
  triangle { // #3835
		<259.85,0,144.9>,
		<263.65,0,145.1>,
		<439.55,-0,-1.9>
  }
  triangle { // #3836
		<263.65,0,145.1>,
		<267.4,0,145.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3837
		<267.4,0,145.3>,
		<271.2,0,145.6>,
		<439.55,-0,-1.9>
  }
  triangle { // #3838
		<271.2,0,145.6>,
		<275,0,145.95>,
		<439.55,-0,-1.9>
  }
  triangle { // #3839
		<275,0,145.95>,
		<278.75,0,146.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3840
		<278.75,0,146.4>,
		<282.55,0,146.85>,
		<439.55,-0,-1.9>
  }
  triangle { // #3841
		<282.55,0,146.85>,
		<286.3,0,147.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3842
		<286.3,0,147.4>,
		<290.05,0,148.05>,
		<439.55,-0,-1.9>
  }
  triangle { // #3843
		<290.05,0,148.05>,
		<293.8,0,148.75>,
		<439.55,-0,-1.9>
  }
  triangle { // #3844
		<293.8,0,148.75>,
		<297.55,0,149.5>,
		<439.55,-0,-1.9>
  }
  triangle { // #3845
		<297.55,0,149.5>,
		<301.3,0,150.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3846
		<301.3,0,150.3>,
		<305.05,0,151.2>,
		<439.55,-0,-1.9>
  }
  triangle { // #3847
		<305.05,0,151.2>,
		<308.8,0,152.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3848
		<308.8,0,152.15>,
		<312.55,0,153.15>,
		<439.55,-0,-1.9>
  }
  triangle { // #3849
		<312.55,0,153.15>,
		<316.25,0,154.25>,
		<439.55,-0,-1.9>
  }
  triangle { // #3850
		<316.25,0,154.25>,
		<320,0,155.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3851
		<320,0,155.4>,
		<323.7,0,156.6>,
		<439.55,-0,-1.9>
  }
  triangle { // #3852
		<323.7,0,156.6>,
		<327.4,0,157.9>,
		<439.55,-0,-1.9>
  }
  triangle { // #3853
		<327.4,0,157.9>,
		<331.1,0,159.25>,
		<439.55,-0,-1.9>
  }
  triangle { // #3854
		<331.1,0,159.25>,
		<334.85,0,160.7>,
		<439.55,-0,-1.9>
  }
  triangle { // #3855
		<334.85,0,160.7>,
		<338.6,0,162.3>,
		<439.55,-0,-1.9>
  }
  triangle { // #3856
		<338.6,0,162.3>,
		<342.35,0,164.05>,
		<439.55,-0,-1.9>
  }
  triangle { // #3857
		<342.35,0,164.05>,
		<346.15,0,165.9>,
		<439.55,-0,-1.9>
  }
  triangle { // #3858
		<350,-25.15,167.95>,
		<346.15,-25.15,165.9>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3859
		<439.55,-25.15,259.4>,
		<437.95,-25.15,255.55>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3860
		<437.95,-25.15,255.55>,
		<436.15,-25.15,251.7>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3861
		<436.15,-25.15,251.7>,
		<434.2,-25.15,247.85>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3862
		<434.2,-25.15,247.85>,
		<432.1,-25.15,244>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3863
		<432.1,-25.15,244>,
		<429.8,-25.15,240.2>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3864
		<429.8,-25.15,240.2>,
		<427.4,-25.15,236.4>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3865
		<427.4,-25.15,236.4>,
		<424.8,-25.15,232.65>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3866
		<424.8,-25.15,232.65>,
		<422,-25.15,228.9>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3867
		<422,-25.15,228.9>,
		<419.1,-25.15,225.15>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3868
		<419.1,-25.15,225.15>,
		<416,-25.15,221.4>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3869
		<416,-25.15,221.4>,
		<412.75,-25.15,217.7>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3870
		<412.75,-25.15,217.7>,
		<409.3,-25.15,214>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3871
		<409.3,-25.15,214>,
		<406,-25.15,210.6>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3872
		<406,-25.15,210.6>,
		<402,-25.15,206.65>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3873
		<402,-25.15,206.65>,
		<398.1,-25.15,203>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3874
		<398.1,-25.15,203>,
		<394,-25.15,199.35>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3875
		<394,-25.15,199.35>,
		<389.85,-25.15,195.8>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3876
		<389.85,-25.15,195.8>,
		<385.75,-25.15,192.4>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3877
		<385.75,-25.15,192.4>,
		<381.65,-25.15,189.1>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3878
		<381.65,-25.15,189.1>,
		<377.6,-25.15,185.95>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3879
		<377.6,-25.15,185.95>,
		<373.6,-25.15,182.95>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3880
		<373.6,-25.15,182.95>,
		<369.6,-25.15,180.1>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3881
		<369.6,-25.15,180.1>,
		<365.6,-25.15,177.4>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3882
		<365.6,-25.15,177.4>,
		<361.65,-25.15,174.8>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3883
		<361.65,-25.15,174.8>,
		<357.75,-25.15,172.4>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3884
		<357.75,-25.15,172.4>,
		<353.85,-25.15,170.1>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3885
		<353.85,-25.15,170.1>,
		<350,-25.15,167.95>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #3886
		<-0.45,-25.15,172.95>,
		<-0.45,-25.15,-1.9>,
		<3.35,-25.15,172.95>
  }
  triangle { // #3887
		<-0.45,-25.15,-1.9>,
		<439.55,-25.15,-1.9>,
		<3.35,-25.15,172.95>
  }
  triangle { // #3888
		<3.35,-25.15,172.95>,
		<439.55,-25.15,-1.9>,
		<7.1,-25.15,172.9>
  }
  triangle { // #3889
		<7.1,-25.15,172.9>,
		<439.55,-25.15,-1.9>,
		<10.9,-25.15,172.85>
  }
  triangle { // #3890
		<10.9,-25.15,172.85>,
		<439.55,-25.15,-1.9>,
		<14.65,-25.15,172.85>
  }
  triangle { // #3891
		<14.65,-25.15,172.85>,
		<439.55,-25.15,-1.9>,
		<18.4,-25.15,172.75>
  }
  triangle { // #3892
		<18.4,-25.15,172.75>,
		<439.55,-25.15,-1.9>,
		<22.2,-25.15,172.7>
  }
  triangle { // #3893
		<22.2,-25.15,172.7>,
		<439.55,-25.15,-1.9>,
		<25.95,-25.15,172.6>
  }
  triangle { // #3894
		<25.95,-25.15,172.6>,
		<439.55,-25.15,-1.9>,
		<29.75,-25.15,172.55>
  }
  triangle { // #3895
		<29.75,-25.15,172.55>,
		<439.55,-25.15,-1.9>,
		<33.5,-25.15,172.4>
  }
  triangle { // #3896
		<33.5,-25.15,172.4>,
		<439.55,-25.15,-1.9>,
		<37.3,-25.15,172.3>
  }
  triangle { // #3897
		<37.3,-25.15,172.3>,
		<439.55,-25.15,-1.9>,
		<41.05,-25.15,172.15>
  }
  triangle { // #3898
		<41.05,-25.15,172.15>,
		<439.55,-25.15,-1.9>,
		<44.85,-25.15,171.95>
  }
  triangle { // #3899
		<44.85,-25.15,171.95>,
		<439.55,-25.15,-1.9>,
		<48.6,-25.15,171.75>
  }
  triangle { // #3900
		<48.6,-25.15,171.75>,
		<439.55,-25.15,-1.9>,
		<52.35,-25.15,171.55>
  }
  triangle { // #3901
		<52.35,-25.15,171.55>,
		<439.55,-25.15,-1.9>,
		<56.15,-25.15,171.3>
  }
  triangle { // #3902
		<56.15,-25.15,171.3>,
		<439.55,-25.15,-1.9>,
		<59.9,-25.15,171.05>
  }
  triangle { // #3903
		<59.9,-25.15,171.05>,
		<439.55,-25.15,-1.9>,
		<63.7,-25.15,170.75>
  }
  triangle { // #3904
		<63.7,-25.15,170.75>,
		<439.55,-25.15,-1.9>,
		<67.45,-25.15,170.45>
  }
  triangle { // #3905
		<67.45,-25.15,170.45>,
		<439.55,-25.15,-1.9>,
		<71.25,-25.15,170.15>
  }
  triangle { // #3906
		<71.25,-25.15,170.15>,
		<439.55,-25.15,-1.9>,
		<75,-25.15,169.8>
  }
  triangle { // #3907
		<75,-25.15,169.8>,
		<439.55,-25.15,-1.9>,
		<78.75,-25.15,169.45>
  }
  triangle { // #3908
		<78.75,-25.15,169.45>,
		<439.55,-25.15,-1.9>,
		<82.55,-25.15,169.05>
  }
  triangle { // #3909
		<82.55,-25.15,169.05>,
		<439.55,-25.15,-1.9>,
		<86.3,-25.15,168.65>
  }
  triangle { // #3910
		<86.3,-25.15,168.65>,
		<439.55,-25.15,-1.9>,
		<90.1,-25.15,168.2>
  }
  triangle { // #3911
		<90.1,-25.15,168.2>,
		<439.55,-25.15,-1.9>,
		<93.85,-25.15,167.75>
  }
  triangle { // #3912
		<93.85,-25.15,167.75>,
		<439.55,-25.15,-1.9>,
		<97.65,-25.15,167.3>
  }
  triangle { // #3913
		<97.65,-25.15,167.3>,
		<439.55,-25.15,-1.9>,
		<101.4,-25.15,166.8>
  }
  triangle { // #3914
		<101.4,-25.15,166.8>,
		<439.55,-25.15,-1.9>,
		<105.2,-25.15,166.3>
  }
  triangle { // #3915
		<105.2,-25.15,166.3>,
		<439.55,-25.15,-1.9>,
		<108.95,-25.15,165.8>
  }
  triangle { // #3916
		<108.95,-25.15,165.8>,
		<439.55,-25.15,-1.9>,
		<112.7,-25.15,165.25>
  }
  triangle { // #3917
		<112.7,-25.15,165.25>,
		<439.55,-25.15,-1.9>,
		<116.5,-25.15,164.7>
  }
  triangle { // #3918
		<116.5,-25.15,164.7>,
		<439.55,-25.15,-1.9>,
		<120.25,-25.15,164.15>
  }
  triangle { // #3919
		<120.25,-25.15,164.15>,
		<439.55,-25.15,-1.9>,
		<124.05,-25.15,163.55>
  }
  triangle { // #3920
		<124.05,-25.15,163.55>,
		<439.55,-25.15,-1.9>,
		<127.8,-25.15,162.95>
  }
  triangle { // #3921
		<127.8,-25.15,162.95>,
		<439.55,-25.15,-1.9>,
		<131.6,-25.15,162.35>
  }
  triangle { // #3922
		<131.6,-25.15,162.35>,
		<439.55,-25.15,-1.9>,
		<135.35,-25.15,161.7>
  }
  triangle { // #3923
		<135.35,-25.15,161.7>,
		<439.55,-25.15,-1.9>,
		<139.1,-25.15,161.05>
  }
  triangle { // #3924
		<139.1,-25.15,161.05>,
		<439.55,-25.15,-1.9>,
		<142.9,-25.15,160.4>
  }
  triangle { // #3925
		<142.9,-25.15,160.4>,
		<439.55,-25.15,-1.9>,
		<146.65,-25.15,159.7>
  }
  triangle { // #3926
		<146.65,-25.15,159.7>,
		<439.55,-25.15,-1.9>,
		<150.45,-25.15,159>
  }
  triangle { // #3927
		<150.45,-25.15,159>,
		<439.55,-25.15,-1.9>,
		<154.2,-25.15,158.3>
  }
  triangle { // #3928
		<154.2,-25.15,158.3>,
		<439.55,-25.15,-1.9>,
		<158,-25.15,157.6>
  }
  triangle { // #3929
		<158,-25.15,157.6>,
		<439.55,-25.15,-1.9>,
		<161.75,-25.15,156.9>
  }
  triangle { // #3930
		<161.75,-25.15,156.9>,
		<439.55,-25.15,-1.9>,
		<165.55,-25.15,156.2>
  }
  triangle { // #3931
		<165.55,-25.15,156.2>,
		<439.55,-25.15,-1.9>,
		<169.3,-25.15,155.5>
  }
  triangle { // #3932
		<169.3,-25.15,155.5>,
		<439.55,-25.15,-1.9>,
		<173.05,-25.15,154.8>
  }
  triangle { // #3933
		<173.05,-25.15,154.8>,
		<439.55,-25.15,-1.9>,
		<176.85,-25.15,154.15>
  }
  triangle { // #3934
		<176.85,-25.15,154.15>,
		<439.55,-25.15,-1.9>,
		<180.6,-25.15,153.45>
  }
  triangle { // #3935
		<180.6,-25.15,153.45>,
		<439.55,-25.15,-1.9>,
		<184.4,-25.15,152.75>
  }
  triangle { // #3936
		<184.4,-25.15,152.75>,
		<439.55,-25.15,-1.9>,
		<188.15,-25.15,152.1>
  }
  triangle { // #3937
		<188.15,-25.15,152.1>,
		<439.55,-25.15,-1.9>,
		<191.95,-25.15,151.45>
  }
  triangle { // #3938
		<191.95,-25.15,151.45>,
		<439.55,-25.15,-1.9>,
		<195.7,-25.15,150.8>
  }
  triangle { // #3939
		<195.7,-25.15,150.8>,
		<439.55,-25.15,-1.9>,
		<199.45,-25.15,150.1>
  }
  triangle { // #3940
		<199.45,-25.15,150.1>,
		<439.55,-25.15,-1.9>,
		<203.25,-25.15,149.45>
  }
  triangle { // #3941
		<203.25,-25.15,149.45>,
		<439.55,-25.15,-1.9>,
		<207,-25.15,148.8>
  }
  triangle { // #3942
		<207,-25.15,148.8>,
		<439.55,-25.15,-1.9>,
		<210.8,-25.15,148.15>
  }
  triangle { // #3943
		<210.8,-25.15,148.15>,
		<439.55,-25.15,-1.9>,
		<214.55,-25.15,147.55>
  }
  triangle { // #3944
		<214.55,-25.15,147.55>,
		<439.55,-25.15,-1.9>,
		<218.3,-25.15,147>
  }
  triangle { // #3945
		<218.3,-25.15,147>,
		<439.55,-25.15,-1.9>,
		<222.1,-25.15,146.5>
  }
  triangle { // #3946
		<222.1,-25.15,146.5>,
		<439.55,-25.15,-1.9>,
		<225.85,-25.15,146.1>
  }
  triangle { // #3947
		<225.85,-25.15,146.1>,
		<439.55,-25.15,-1.9>,
		<229.65,-25.15,145.7>
  }
  triangle { // #3948
		<229.65,-25.15,145.7>,
		<439.55,-25.15,-1.9>,
		<233.4,-25.15,145.4>
  }
  triangle { // #3949
		<233.4,-25.15,145.4>,
		<439.55,-25.15,-1.9>,
		<237.2,-25.15,145.15>
  }
  triangle { // #3950
		<237.2,-25.15,145.15>,
		<439.55,-25.15,-1.9>,
		<240.95,-25.15,144.95>
  }
  triangle { // #3951
		<240.95,-25.15,144.95>,
		<439.55,-25.15,-1.9>,
		<244.75,-25.15,144.85>
  }
  triangle { // #3952
		<244.75,-25.15,144.85>,
		<439.55,-25.15,-1.9>,
		<248.5,-25.15,144.75>
  }
  triangle { // #3953
		<248.5,-25.15,144.75>,
		<439.55,-25.15,-1.9>,
		<252.3,-25.15,144.75>
  }
  triangle { // #3954
		<252.3,-25.15,144.75>,
		<439.55,-25.15,-1.9>,
		<256.1,-25.15,144.8>
  }
  triangle { // #3955
		<256.1,-25.15,144.8>,
		<439.55,-25.15,-1.9>,
		<259.85,-25.15,144.9>
  }
  triangle { // #3956
		<259.85,-25.15,144.9>,
		<439.55,-25.15,-1.9>,
		<263.65,-25.15,145.1>
  }
  triangle { // #3957
		<263.65,-25.15,145.1>,
		<439.55,-25.15,-1.9>,
		<267.4,-25.15,145.3>
  }
  triangle { // #3958
		<267.4,-25.15,145.3>,
		<439.55,-25.15,-1.9>,
		<271.2,-25.15,145.6>
  }
  triangle { // #3959
		<271.2,-25.15,145.6>,
		<439.55,-25.15,-1.9>,
		<275,-25.15,145.95>
  }
  triangle { // #3960
		<275,-25.15,145.95>,
		<439.55,-25.15,-1.9>,
		<278.75,-25.15,146.4>
  }
  triangle { // #3961
		<278.75,-25.15,146.4>,
		<439.55,-25.15,-1.9>,
		<282.55,-25.15,146.85>
  }
  triangle { // #3962
		<282.55,-25.15,146.85>,
		<439.55,-25.15,-1.9>,
		<286.3,-25.15,147.4>
  }
  triangle { // #3963
		<286.3,-25.15,147.4>,
		<439.55,-25.15,-1.9>,
		<290.05,-25.15,148.05>
  }
  triangle { // #3964
		<290.05,-25.15,148.05>,
		<439.55,-25.15,-1.9>,
		<293.8,-25.15,148.75>
  }
  triangle { // #3965
		<293.8,-25.15,148.75>,
		<439.55,-25.15,-1.9>,
		<297.55,-25.15,149.5>
  }
  triangle { // #3966
		<297.55,-25.15,149.5>,
		<439.55,-25.15,-1.9>,
		<301.3,-25.15,150.3>
  }
  triangle { // #3967
		<301.3,-25.15,150.3>,
		<439.55,-25.15,-1.9>,
		<305.05,-25.15,151.2>
  }
  triangle { // #3968
		<305.05,-25.15,151.2>,
		<439.55,-25.15,-1.9>,
		<308.8,-25.15,152.15>
  }
  triangle { // #3969
		<308.8,-25.15,152.15>,
		<439.55,-25.15,-1.9>,
		<312.55,-25.15,153.15>
  }
  triangle { // #3970
		<312.55,-25.15,153.15>,
		<439.55,-25.15,-1.9>,
		<316.25,-25.15,154.25>
  }
  triangle { // #3971
		<316.25,-25.15,154.25>,
		<439.55,-25.15,-1.9>,
		<320,-25.15,155.4>
  }
  triangle { // #3972
		<320,-25.15,155.4>,
		<439.55,-25.15,-1.9>,
		<323.7,-25.15,156.6>
  }
  triangle { // #3973
		<323.7,-25.15,156.6>,
		<439.55,-25.15,-1.9>,
		<327.4,-25.15,157.9>
  }
  triangle { // #3974
		<327.4,-25.15,157.9>,
		<439.55,-25.15,-1.9>,
		<331.1,-25.15,159.25>
  }
  triangle { // #3975
		<331.1,-25.15,159.25>,
		<439.55,-25.15,-1.9>,
		<334.85,-25.15,160.7>
  }
  triangle { // #3976
		<334.85,-25.15,160.7>,
		<439.55,-25.15,-1.9>,
		<338.6,-25.15,162.3>
  }
  triangle { // #3977
		<338.6,-25.15,162.3>,
		<439.55,-25.15,-1.9>,
		<342.35,-25.15,164.05>
  }
  triangle { // #3978
		<342.35,-25.15,164.05>,
		<439.55,-25.15,-1.9>,
		<346.15,-25.15,165.9>
  }
  triangle { // #3979
		<439.55,0,259.4>,
		<439.55,-25.15,259.4>,
		<439.55,-0,-1.9>
  }
  triangle { // #3980
		<439.55,-25.15,-1.9>,
		<439.55,-0,-1.9>,
		<439.55,-25.15,259.4>
  }
  smooth_triangle { // #3981
		<437.95,0,255.55>, <-0.912,-0.409,0>,
		<437.95,-25.15,255.55>, <-0.917,-0.398,0>,
		<439.55,0,259.4>, <-0.98,-0.197,0>
  }
  smooth_triangle { // #3982
		<439.55,-25.15,259.4>, <-0.922,-0.387,0>,
		<439.55,0,259.4>, <-0.98,-0.197,0>,
		<437.95,-25.15,255.55>, <-0.917,-0.398,0>
  }
  smooth_triangle { // #3983
		<436.15,0,251.7>, <-0.897,-0.442,0>,
		<436.15,-25.15,251.7>, <-0.902,-0.431,0>,
		<437.95,0,255.55>, <-0.912,-0.409,0>
  }
  smooth_triangle { // #3984
		<437.95,-25.15,255.55>, <-0.917,-0.398,0>,
		<437.95,0,255.55>, <-0.912,-0.409,0>,
		<436.15,-25.15,251.7>, <-0.902,-0.431,0>
  }
  smooth_triangle { // #3985
		<434.2,0,247.85>, <-0.881,-0.473,0>,
		<434.2,-25.15,247.85>, <-0.886,-0.463,0>,
		<436.15,0,251.7>, <-0.897,-0.442,0>
  }
  smooth_triangle { // #3986
		<436.15,-25.15,251.7>, <-0.902,-0.431,0>,
		<436.15,0,251.7>, <-0.897,-0.442,0>,
		<434.2,-25.15,247.85>, <-0.886,-0.463,0>
  }
  smooth_triangle { // #3987
		<432.1,0,244>, <-0.864,-0.503,0>,
		<432.1,-25.15,244>, <-0.87,-0.494,0>,
		<434.2,0,247.85>, <-0.881,-0.473,0>
  }
  smooth_triangle { // #3988
		<434.2,-25.15,247.85>, <-0.886,-0.463,0>,
		<434.2,0,247.85>, <-0.881,-0.473,0>,
		<432.1,-25.15,244>, <-0.87,-0.494,0>
  }
  smooth_triangle { // #3989
		<429.8,0,240.2>, <-0.847,-0.532,0>,
		<429.8,-25.15,240.2>, <-0.853,-0.522,0>,
		<432.1,0,244>, <-0.864,-0.503,0>
  }
  smooth_triangle { // #3990
		<432.1,-25.15,244>, <-0.87,-0.494,0>,
		<432.1,0,244>, <-0.864,-0.503,0>,
		<429.8,-25.15,240.2>, <-0.853,-0.522,0>
  }
  smooth_triangle { // #3991
		<427.4,0,236.4>, <-0.829,-0.559,0>,
		<427.4,-25.15,236.4>, <-0.835,-0.55,0>,
		<429.8,0,240.2>, <-0.847,-0.532,0>
  }
  smooth_triangle { // #3992
		<429.8,-25.15,240.2>, <-0.853,-0.522,0>,
		<429.8,0,240.2>, <-0.847,-0.532,0>,
		<427.4,-25.15,236.4>, <-0.835,-0.55,0>
  }
  smooth_triangle { // #3993
		<424.8,0,232.65>, <-0.812,-0.584,0>,
		<424.8,-25.15,232.65>, <-0.818,-0.576,0>,
		<427.4,0,236.4>, <-0.829,-0.559,0>
  }
  smooth_triangle { // #3994
		<427.4,-25.15,236.4>, <-0.835,-0.55,0>,
		<427.4,0,236.4>, <-0.829,-0.559,0>,
		<424.8,-25.15,232.65>, <-0.818,-0.576,0>
  }
  smooth_triangle { // #3995
		<422,0,228.9>, <-0.794,-0.608,0>,
		<422,-25.15,228.9>, <-0.8,-0.6,0>,
		<424.8,0,232.65>, <-0.812,-0.584,0>
  }
  smooth_triangle { // #3996
		<424.8,-25.15,232.65>, <-0.818,-0.576,0>,
		<424.8,0,232.65>, <-0.812,-0.584,0>,
		<422,-25.15,228.9>, <-0.8,-0.6,0>
  }
  smooth_triangle { // #3997
		<419.1,0,225.15>, <-0.776,-0.631,0>,
		<419.1,-25.15,225.15>, <-0.782,-0.624,0>,
		<422,0,228.9>, <-0.794,-0.608,0>
  }
  smooth_triangle { // #3998
		<422,-25.15,228.9>, <-0.8,-0.6,0>,
		<422,0,228.9>, <-0.794,-0.608,0>,
		<419.1,-25.15,225.15>, <-0.782,-0.624,0>
  }
  smooth_triangle { // #3999
		<416,0,221.4>, <-0.758,-0.652,0>,
		<416,-25.15,221.4>, <-0.764,-0.645,0>,
		<419.1,0,225.15>, <-0.776,-0.631,0>
  }
  smooth_triangle { // #4000
		<419.1,-25.15,225.15>, <-0.782,-0.624,0>,
		<419.1,0,225.15>, <-0.776,-0.631,0>,
		<416,-25.15,221.4>, <-0.764,-0.645,0>
  }
  smooth_triangle { // #4001
		<412.75,0,217.7>, <-0.74,-0.672,0>,
		<412.75,-25.15,217.7>, <-0.746,-0.666,0>,
		<416,0,221.4>, <-0.758,-0.652,0>
  }
  smooth_triangle { // #4002
		<416,-25.15,221.4>, <-0.764,-0.645,0>,
		<416,0,221.4>, <-0.758,-0.652,0>,
		<412.75,-25.15,217.7>, <-0.746,-0.666,0>
  }
  smooth_triangle { // #4003
		<409.3,0,214>, <-0.723,-0.691,0>,
		<409.3,-25.15,214>, <-0.728,-0.685,0>,
		<412.75,0,217.7>, <-0.74,-0.672,0>
  }
  smooth_triangle { // #4004
		<412.75,-25.15,217.7>, <-0.746,-0.666,0>,
		<412.75,0,217.7>, <-0.74,-0.672,0>,
		<409.3,-25.15,214>, <-0.728,-0.685,0>
  }
  smooth_triangle { // #4005
		<406,0,210.6>, <-0.706,-0.708,0>,
		<406,-25.15,210.6>, <-0.711,-0.703,0>,
		<409.3,0,214>, <-0.723,-0.691,0>
  }
  smooth_triangle { // #4006
		<409.3,-25.15,214>, <-0.728,-0.685,0>,
		<409.3,0,214>, <-0.723,-0.691,0>,
		<406,-25.15,210.6>, <-0.711,-0.703,0>
  }
  smooth_triangle { // #4007
		<402,0,206.65>, <-0.689,-0.725,0>,
		<402,-25.15,206.65>, <-0.695,-0.719,0>,
		<406,0,210.6>, <-0.706,-0.708,0>
  }
  smooth_triangle { // #4008
		<406,-25.15,210.6>, <-0.711,-0.703,0>,
		<406,0,210.6>, <-0.706,-0.708,0>,
		<402,-25.15,206.65>, <-0.695,-0.719,0>
  }
  smooth_triangle { // #4009
		<398.1,0,203>, <-0.672,-0.741,0>,
		<398.1,-25.15,203>, <-0.677,-0.736,0>,
		<402,0,206.65>, <-0.689,-0.725,0>
  }
  smooth_triangle { // #4010
		<402,-25.15,206.65>, <-0.695,-0.719,0>,
		<402,0,206.65>, <-0.689,-0.725,0>,
		<398.1,-25.15,203>, <-0.677,-0.736,0>
  }
  triangle { // #4011
		<394,0,199.35>,
		<394,-25.15,199.35>,
		<398.1,0,203>
  }
  smooth_triangle { // #4012
		<398.1,-25.15,203>, <-0.677,-0.736,0>,
		<398.1,0,203>, <-0.672,-0.741,0>,
		<394,-25.15,199.35>, <-0.661,-0.75,0>
  }
  triangle { // #4013
		<389.85,0,195.8>,
		<389.85,-25.15,195.8>,
		<394,0,199.35>
  }
  triangle { // #4014
		<394,-25.15,199.35>,
		<394,0,199.35>,
		<389.85,-25.15,195.8>
  }
  triangle { // #4015
		<385.75,0,192.4>,
		<385.75,-25.15,192.4>,
		<389.85,0,195.8>
  }
  triangle { // #4016
		<389.85,-25.15,195.8>,
		<389.85,0,195.8>,
		<385.75,-25.15,192.4>
  }
  triangle { // #4017
		<381.65,0,189.1>,
		<381.65,-25.15,189.1>,
		<385.75,0,192.4>
  }
  triangle { // #4018
		<385.75,-25.15,192.4>,
		<385.75,0,192.4>,
		<381.65,-25.15,189.1>
  }
  triangle { // #4019
		<377.6,0,185.95>,
		<377.6,-25.15,185.95>,
		<381.65,0,189.1>
  }
  triangle { // #4020
		<381.65,-25.15,189.1>,
		<381.65,0,189.1>,
		<377.6,-25.15,185.95>
  }
  smooth_triangle { // #4021
		<373.6,0,182.95>, <-0.586,-0.81,0>,
		<373.6,-25.15,182.95>, <-0.592,-0.806,0>,
		<377.6,0,185.95>, <-0.602,-0.799,0>
  }
  triangle { // #4022
		<377.6,-25.15,185.95>,
		<377.6,0,185.95>,
		<373.6,-25.15,182.95>
  }
  smooth_triangle { // #4023
		<369.6,0,180.1>, <-0.57,-0.822,0>,
		<369.6,-25.15,180.1>, <-0.576,-0.818,0>,
		<373.6,0,182.95>, <-0.586,-0.81,0>
  }
  smooth_triangle { // #4024
		<373.6,-25.15,182.95>, <-0.592,-0.806,0>,
		<373.6,0,182.95>, <-0.586,-0.81,0>,
		<369.6,-25.15,180.1>, <-0.576,-0.818,0>
  }
  smooth_triangle { // #4025
		<365.6,0,177.4>, <-0.553,-0.833,0>,
		<365.6,-25.15,177.4>, <-0.559,-0.829,0>,
		<369.6,0,180.1>, <-0.57,-0.822,0>
  }
  smooth_triangle { // #4026
		<369.6,-25.15,180.1>, <-0.576,-0.818,0>,
		<369.6,0,180.1>, <-0.57,-0.822,0>,
		<365.6,-25.15,177.4>, <-0.559,-0.829,0>
  }
  smooth_triangle { // #4027
		<361.65,0,174.8>, <-0.534,-0.845,0>,
		<361.65,-25.15,174.8>, <-0.541,-0.841,0>,
		<365.6,0,177.4>, <-0.553,-0.833,0>
  }
  smooth_triangle { // #4028
		<365.6,-25.15,177.4>, <-0.559,-0.829,0>,
		<365.6,0,177.4>, <-0.553,-0.833,0>,
		<361.65,-25.15,174.8>, <-0.541,-0.841,0>
  }
  smooth_triangle { // #4029
		<357.75,0,172.4>, <-0.515,-0.857,0>,
		<357.75,-25.15,172.4>, <-0.522,-0.853,0>,
		<361.65,0,174.8>, <-0.534,-0.845,0>
  }
  smooth_triangle { // #4030
		<361.65,-25.15,174.8>, <-0.541,-0.841,0>,
		<361.65,0,174.8>, <-0.534,-0.845,0>,
		<357.75,-25.15,172.4>, <-0.522,-0.853,0>
  }
  smooth_triangle { // #4031
		<353.85,0,170.1>, <-0.495,-0.869,0>,
		<353.85,-25.15,170.1>, <-0.502,-0.865,0>,
		<357.75,0,172.4>, <-0.515,-0.857,0>
  }
  smooth_triangle { // #4032
		<357.75,-25.15,172.4>, <-0.522,-0.853,0>,
		<357.75,0,172.4>, <-0.515,-0.857,0>,
		<353.85,-25.15,170.1>, <-0.502,-0.865,0>
  }
  smooth_triangle { // #4033
		<350,0,167.95>, <-0.473,-0.881,0>,
		<350,-25.15,167.95>, <-0.48,-0.877,0>,
		<353.85,0,170.1>, <-0.495,-0.869,0>
  }
  smooth_triangle { // #4034
		<353.85,-25.15,170.1>, <-0.502,-0.865,0>,
		<353.85,0,170.1>, <-0.495,-0.869,0>,
		<350,-25.15,167.95>, <-0.48,-0.877,0>
  }
  smooth_triangle { // #4035
		<346.15,0,165.9>, <-0.45,-0.893,0>,
		<346.15,-25.15,165.9>, <-0.458,-0.889,0>,
		<350,0,167.95>, <-0.473,-0.881,0>
  }
  smooth_triangle { // #4036
		<350,-25.15,167.95>, <-0.48,-0.877,0>,
		<350,0,167.95>, <-0.473,-0.881,0>,
		<346.15,-25.15,165.9>, <-0.458,-0.889,0>
  }
  smooth_triangle { // #4037
		<342.35,0,164.05>, <-0.426,-0.905,0>,
		<342.35,-25.15,164.05>, <-0.434,-0.901,0>,
		<346.15,0,165.9>, <-0.45,-0.893,0>
  }
  smooth_triangle { // #4038
		<346.15,-25.15,165.9>, <-0.458,-0.889,0>,
		<346.15,0,165.9>, <-0.45,-0.893,0>,
		<342.35,-25.15,164.05>, <-0.434,-0.901,0>
  }
  smooth_triangle { // #4039
		<338.6,0,162.3>, <-0.4,-0.916,0>,
		<338.6,-25.15,162.3>, <-0.409,-0.913,0>,
		<342.35,0,164.05>, <-0.426,-0.905,0>
  }
  smooth_triangle { // #4040
		<342.35,-25.15,164.05>, <-0.434,-0.901,0>,
		<342.35,0,164.05>, <-0.426,-0.905,0>,
		<338.6,-25.15,162.3>, <-0.409,-0.913,0>
  }
  smooth_triangle { // #4041
		<334.85,0,160.7>, <-0.373,-0.928,0>,
		<334.85,-25.15,160.7>, <-0.382,-0.924,0>,
		<338.6,0,162.3>, <-0.4,-0.916,0>
  }
  smooth_triangle { // #4042
		<338.6,-25.15,162.3>, <-0.409,-0.913,0>,
		<338.6,0,162.3>, <-0.4,-0.916,0>,
		<334.85,-25.15,160.7>, <-0.382,-0.924,0>
  }
  smooth_triangle { // #4043
		<331.1,0,159.25>, <-0.35,-0.937,0>,
		<331.1,-25.15,159.25>, <-0.357,-0.934,0>,
		<334.85,0,160.7>, <-0.373,-0.928,0>
  }
  smooth_triangle { // #4044
		<334.85,-25.15,160.7>, <-0.382,-0.924,0>,
		<334.85,0,160.7>, <-0.373,-0.928,0>,
		<331.1,-25.15,159.25>, <-0.357,-0.934,0>
  }
  smooth_triangle { // #4045
		<327.4,0,157.9>, <-0.332,-0.943,0>,
		<327.4,-25.15,157.9>, <-0.337,-0.941,0>,
		<331.1,0,159.25>, <-0.35,-0.937,0>
  }
  smooth_triangle { // #4046
		<331.1,-25.15,159.25>, <-0.357,-0.934,0>,
		<331.1,0,159.25>, <-0.35,-0.937,0>,
		<327.4,-25.15,157.9>, <-0.337,-0.941,0>
  }
  smooth_triangle { // #4047
		<323.7,0,156.6>, <-0.317,-0.949,0>,
		<323.7,-25.15,156.6>, <-0.322,-0.947,0>,
		<327.4,0,157.9>, <-0.332,-0.943,0>
  }
  smooth_triangle { // #4048
		<327.4,-25.15,157.9>, <-0.337,-0.941,0>,
		<327.4,0,157.9>, <-0.332,-0.943,0>,
		<323.7,-25.15,156.6>, <-0.322,-0.947,0>
  }
  smooth_triangle { // #4049
		<320,0,155.4>, <-0.301,-0.954,0>,
		<320,-25.15,155.4>, <-0.306,-0.952,0>,
		<323.7,0,156.6>, <-0.317,-0.949,0>
  }
  smooth_triangle { // #4050
		<323.7,-25.15,156.6>, <-0.322,-0.947,0>,
		<323.7,0,156.6>, <-0.317,-0.949,0>,
		<320,-25.15,155.4>, <-0.306,-0.952,0>
  }
  smooth_triangle { // #4051
		<316.25,0,154.25>, <-0.285,-0.959,0>,
		<316.25,-25.15,154.25>, <-0.29,-0.957,0>,
		<320,0,155.4>, <-0.301,-0.954,0>
  }
  smooth_triangle { // #4052
		<320,-25.15,155.4>, <-0.306,-0.952,0>,
		<320,0,155.4>, <-0.301,-0.954,0>,
		<316.25,-25.15,154.25>, <-0.29,-0.957,0>
  }
  smooth_triangle { // #4053
		<312.55,0,153.15>, <-0.269,-0.963,0>,
		<312.55,-25.15,153.15>, <-0.274,-0.962,0>,
		<316.25,0,154.25>, <-0.285,-0.959,0>
  }
  smooth_triangle { // #4054
		<316.25,-25.15,154.25>, <-0.29,-0.957,0>,
		<316.25,0,154.25>, <-0.285,-0.959,0>,
		<312.55,-25.15,153.15>, <-0.274,-0.962,0>
  }
  smooth_triangle { // #4055
		<308.8,0,152.15>, <-0.253,-0.968,0>,
		<308.8,-25.15,152.15>, <-0.258,-0.966,0>,
		<312.55,0,153.15>, <-0.269,-0.963,0>
  }
  smooth_triangle { // #4056
		<312.55,-25.15,153.15>, <-0.274,-0.962,0>,
		<312.55,0,153.15>, <-0.269,-0.963,0>,
		<308.8,-25.15,152.15>, <-0.258,-0.966,0>
  }
  smooth_triangle { // #4057
		<305.05,0,151.2>, <-0.236,-0.972,0>,
		<305.05,-25.15,151.2>, <-0.242,-0.97,0>,
		<308.8,0,152.15>, <-0.253,-0.968,0>
  }
  smooth_triangle { // #4058
		<308.8,-25.15,152.15>, <-0.258,-0.966,0>,
		<308.8,0,152.15>, <-0.253,-0.968,0>,
		<305.05,-25.15,151.2>, <-0.242,-0.97,0>
  }
  smooth_triangle { // #4059
		<301.3,0,150.3>, <-0.219,-0.976,0>,
		<301.3,-25.15,150.3>, <-0.225,-0.974,0>,
		<305.05,0,151.2>, <-0.236,-0.972,0>
  }
  smooth_triangle { // #4060
		<305.05,-25.15,151.2>, <-0.242,-0.97,0>,
		<305.05,0,151.2>, <-0.236,-0.972,0>,
		<301.3,-25.15,150.3>, <-0.225,-0.974,0>
  }
  smooth_triangle { // #4061
		<297.55,0,149.5>, <-0.203,-0.979,0>,
		<297.55,-25.15,149.5>, <-0.208,-0.978,0>,
		<301.3,0,150.3>, <-0.219,-0.976,0>
  }
  smooth_triangle { // #4062
		<301.3,-25.15,150.3>, <-0.225,-0.974,0>,
		<301.3,0,150.3>, <-0.219,-0.976,0>,
		<297.55,-25.15,149.5>, <-0.208,-0.978,0>
  }
  smooth_triangle { // #4063
		<293.8,0,148.75>, <-0.186,-0.983,-0>,
		<293.8,-25.15,148.75>, <-0.191,-0.982,0>,
		<297.55,0,149.5>, <-0.203,-0.979,0>
  }
  smooth_triangle { // #4064
		<297.55,-25.15,149.5>, <-0.208,-0.978,0>,
		<297.55,0,149.5>, <-0.203,-0.979,0>,
		<293.8,-25.15,148.75>, <-0.191,-0.982,0>
  }
  smooth_triangle { // #4065
		<290.05,0,148.05>, <-0.169,-0.986,-0>,
		<290.05,-25.15,148.05>, <-0.174,-0.985,-0>,
		<293.8,0,148.75>, <-0.186,-0.983,-0>
  }
  smooth_triangle { // #4066
		<293.8,-25.15,148.75>, <-0.191,-0.982,0>,
		<293.8,0,148.75>, <-0.186,-0.983,-0>,
		<290.05,-25.15,148.05>, <-0.174,-0.985,-0>
  }
  smooth_triangle { // #4067
		<286.3,0,147.4>, <-0.151,-0.988,0>,
		<286.3,-25.15,147.4>, <-0.157,-0.988,0>,
		<290.05,0,148.05>, <-0.169,-0.986,-0>
  }
  smooth_triangle { // #4068
		<290.05,-25.15,148.05>, <-0.174,-0.985,-0>,
		<290.05,0,148.05>, <-0.169,-0.986,-0>,
		<286.3,-25.15,147.4>, <-0.157,-0.988,0>
  }
  smooth_triangle { // #4069
		<282.55,0,146.85>, <-0.134,-0.991,0>,
		<282.55,-25.15,146.85>, <-0.14,-0.99,0>,
		<286.3,0,147.4>, <-0.151,-0.988,0>
  }
  smooth_triangle { // #4070
		<286.3,-25.15,147.4>, <-0.157,-0.988,0>,
		<286.3,0,147.4>, <-0.151,-0.988,0>,
		<282.55,-25.15,146.85>, <-0.14,-0.99,0>
  }
  smooth_triangle { // #4071
		<278.75,0,146.4>, <-0.117,-0.993,0>,
		<278.75,-25.15,146.4>, <-0.122,-0.992,0>,
		<282.55,0,146.85>, <-0.134,-0.991,0>
  }
  smooth_triangle { // #4072
		<282.55,-25.15,146.85>, <-0.14,-0.99,0>,
		<282.55,0,146.85>, <-0.134,-0.991,0>,
		<278.75,-25.15,146.4>, <-0.122,-0.992,0>
  }
  smooth_triangle { // #4073
		<275,0,145.95>, <-0.099,-0.995,0>,
		<275,-25.15,145.95>, <-0.105,-0.994,0>,
		<278.75,0,146.4>, <-0.117,-0.993,0>
  }
  smooth_triangle { // #4074
		<278.75,-25.15,146.4>, <-0.122,-0.992,0>,
		<278.75,0,146.4>, <-0.117,-0.993,0>,
		<275,-25.15,145.95>, <-0.105,-0.994,0>
  }
  smooth_triangle { // #4075
		<271.2,0,145.6>, <-0.082,-0.997,-0>,
		<271.2,-25.15,145.6>, <-0.088,-0.996,0>,
		<275,0,145.95>, <-0.099,-0.995,0>
  }
  smooth_triangle { // #4076
		<275,-25.15,145.95>, <-0.105,-0.994,0>,
		<275,0,145.95>, <-0.099,-0.995,0>,
		<271.2,-25.15,145.6>, <-0.088,-0.996,0>
  }
  smooth_triangle { // #4077
		<267.4,0,145.3>, <-0.066,-0.998,0>,
		<267.4,-25.15,145.3>, <-0.072,-0.997,0>,
		<271.2,0,145.6>, <-0.082,-0.997,-0>
  }
  smooth_triangle { // #4078
		<271.2,-25.15,145.6>, <-0.088,-0.996,0>,
		<271.2,0,145.6>, <-0.082,-0.997,-0>,
		<267.4,-25.15,145.3>, <-0.072,-0.997,0>
  }
  smooth_triangle { // #4079
		<263.65,0,145.1>, <-0.05,-0.999,0>,
		<263.65,-25.15,145.1>, <-0.056,-0.998,0>,
		<267.4,0,145.3>, <-0.066,-0.998,0>
  }
  smooth_triangle { // #4080
		<267.4,-25.15,145.3>, <-0.072,-0.997,0>,
		<267.4,0,145.3>, <-0.066,-0.998,0>,
		<263.65,-25.15,145.1>, <-0.056,-0.998,0>
  }
  smooth_triangle { // #4081
		<259.85,0,144.9>, <-0.035,-0.999,0>,
		<259.85,-25.15,144.9>, <-0.04,-0.999,0>,
		<263.65,0,145.1>, <-0.05,-0.999,0>
  }
  smooth_triangle { // #4082
		<263.65,-25.15,145.1>, <-0.056,-0.998,0>,
		<263.65,0,145.1>, <-0.05,-0.999,0>,
		<259.85,-25.15,144.9>, <-0.04,-0.999,0>
  }
  smooth_triangle { // #4083
		<256.1,0,144.8>, <-0.019,-1,0>,
		<256.1,-25.15,144.8>, <-0.024,-1,-0>,
		<259.85,0,144.9>, <-0.035,-0.999,0>
  }
  smooth_triangle { // #4084
		<259.85,-25.15,144.9>, <-0.04,-0.999,0>,
		<259.85,0,144.9>, <-0.035,-0.999,0>,
		<256.1,-25.15,144.8>, <-0.024,-1,-0>
  }
  smooth_triangle { // #4085
		<252.3,0,144.75>, <-0.003,-1,0>,
		<252.3,-25.15,144.75>, <-0.008,-1,0>,
		<256.1,0,144.8>, <-0.019,-1,0>
  }
  smooth_triangle { // #4086
		<256.1,-25.15,144.8>, <-0.024,-1,-0>,
		<256.1,0,144.8>, <-0.019,-1,0>,
		<252.3,-25.15,144.75>, <-0.008,-1,0>
  }
  smooth_triangle { // #4087
		<248.5,0,144.75>, <0.013,-1,-0>,
		<248.5,-25.15,144.75>, <0.008,-1,-0>,
		<252.3,0,144.75>, <-0.003,-1,0>
  }
  smooth_triangle { // #4088
		<252.3,-25.15,144.75>, <-0.008,-1,0>,
		<252.3,0,144.75>, <-0.003,-1,0>,
		<248.5,-25.15,144.75>, <0.008,-1,-0>
  }
  smooth_triangle { // #4089
		<244.75,0,144.85>, <0.029,-1,0>,
		<244.75,-25.15,144.85>, <0.024,-1,0>,
		<248.5,0,144.75>, <0.013,-1,-0>
  }
  smooth_triangle { // #4090
		<248.5,-25.15,144.75>, <0.008,-1,-0>,
		<248.5,0,144.75>, <0.013,-1,-0>,
		<244.75,-25.15,144.85>, <0.024,-1,0>
  }
  smooth_triangle { // #4091
		<240.95,0,144.95>, <0.045,-0.999,0>,
		<240.95,-25.15,144.95>, <0.04,-0.999,0>,
		<244.75,0,144.85>, <0.029,-1,0>
  }
  smooth_triangle { // #4092
		<244.75,-25.15,144.85>, <0.024,-1,0>,
		<244.75,0,144.85>, <0.029,-1,0>,
		<240.95,-25.15,144.95>, <0.04,-0.999,0>
  }
  smooth_triangle { // #4093
		<237.2,0,145.15>, <0.061,-0.998,-0>,
		<237.2,-25.15,145.15>, <0.056,-0.998,0>,
		<240.95,0,144.95>, <0.045,-0.999,0>
  }
  smooth_triangle { // #4094
		<240.95,-25.15,144.95>, <0.04,-0.999,0>,
		<240.95,0,144.95>, <0.045,-0.999,0>,
		<237.2,-25.15,145.15>, <0.056,-0.998,0>
  }
  smooth_triangle { // #4095
		<233.4,0,145.4>, <0.077,-0.997,0>,
		<233.4,-25.15,145.4>, <0.072,-0.997,0>,
		<237.2,0,145.15>, <0.061,-0.998,-0>
  }
  smooth_triangle { // #4096
		<237.2,-25.15,145.15>, <0.056,-0.998,0>,
		<237.2,0,145.15>, <0.061,-0.998,-0>,
		<233.4,-25.15,145.4>, <0.072,-0.997,0>
  }
  smooth_triangle { // #4097
		<229.65,0,145.7>, <0.093,-0.996,0>,
		<229.65,-25.15,145.7>, <0.087,-0.996,0>,
		<233.4,0,145.4>, <0.077,-0.997,0>
  }
  smooth_triangle { // #4098
		<233.4,-25.15,145.4>, <0.072,-0.997,0>,
		<233.4,0,145.4>, <0.077,-0.997,0>,
		<229.65,-25.15,145.7>, <0.087,-0.996,0>
  }
  smooth_triangle { // #4099
		<225.85,0,146.1>, <0.108,-0.994,0>,
		<225.85,-25.15,146.1>, <0.103,-0.995,0>,
		<229.65,0,145.7>, <0.093,-0.996,0>
  }
  smooth_triangle { // #4100
		<229.65,-25.15,145.7>, <0.087,-0.996,0>,
		<229.65,0,145.7>, <0.093,-0.996,0>,
		<225.85,-25.15,146.1>, <0.103,-0.995,0>
  }
  smooth_triangle { // #4101
		<222.1,0,146.5>, <0.124,-0.992,0>,
		<222.1,-25.15,146.5>, <0.119,-0.993,0>,
		<225.85,0,146.1>, <0.108,-0.994,0>
  }
  smooth_triangle { // #4102
		<225.85,-25.15,146.1>, <0.103,-0.995,0>,
		<225.85,0,146.1>, <0.108,-0.994,0>,
		<222.1,-25.15,146.5>, <0.119,-0.993,0>
  }
  smooth_triangle { // #4103
		<218.3,0,147>, <0.14,-0.99,0>,
		<218.3,-25.15,147>, <0.134,-0.991,0>,
		<222.1,0,146.5>, <0.124,-0.992,0>
  }
  smooth_triangle { // #4104
		<222.1,-25.15,146.5>, <0.119,-0.993,0>,
		<222.1,0,146.5>, <0.124,-0.992,0>,
		<218.3,-25.15,147>, <0.134,-0.991,0>
  }
  smooth_triangle { // #4105
		<214.55,0,147.55>, <0.155,-0.988,0>,
		<214.55,-25.15,147.55>, <0.15,-0.989,0>,
		<218.3,0,147>, <0.14,-0.99,0>
  }
  smooth_triangle { // #4106
		<218.3,-25.15,147>, <0.134,-0.991,0>,
		<218.3,0,147>, <0.14,-0.99,0>,
		<214.55,-25.15,147.55>, <0.15,-0.989,0>
  }
  triangle { // #4107
		<210.8,0,148.15>,
		<210.8,-25.15,148.15>,
		<214.55,0,147.55>
  }
  smooth_triangle { // #4108
		<214.55,-25.15,147.55>, <0.15,-0.989,0>,
		<214.55,0,147.55>, <0.155,-0.988,0>,
		<210.8,-25.15,148.15>, <0.163,-0.987,0>
  }
  triangle { // #4109
		<207,0,148.8>,
		<207,-25.15,148.8>,
		<210.8,0,148.15>
  }
  triangle { // #4110
		<210.8,-25.15,148.15>,
		<210.8,0,148.15>,
		<207,-25.15,148.8>
  }
  triangle { // #4111
		<203.25,0,149.45>,
		<203.25,-25.15,149.45>,
		<207,0,148.8>
  }
  triangle { // #4112
		<207,-25.15,148.8>,
		<207,0,148.8>,
		<203.25,-25.15,149.45>
  }
  triangle { // #4113
		<199.45,0,150.1>,
		<199.45,-25.15,150.1>,
		<203.25,0,149.45>
  }
  triangle { // #4114
		<203.25,-25.15,149.45>,
		<203.25,0,149.45>,
		<199.45,-25.15,150.1>
  }
  triangle { // #4115
		<195.7,0,150.8>,
		<195.7,-25.15,150.8>,
		<199.45,0,150.1>
  }
  triangle { // #4116
		<199.45,-25.15,150.1>,
		<199.45,0,150.1>,
		<195.7,-25.15,150.8>
  }
  triangle { // #4117
		<191.95,0,151.45>,
		<191.95,-25.15,151.45>,
		<195.7,0,150.8>
  }
  triangle { // #4118
		<195.7,-25.15,150.8>,
		<195.7,0,150.8>,
		<191.95,-25.15,151.45>
  }
  triangle { // #4119
		<188.15,0,152.1>,
		<188.15,-25.15,152.1>,
		<191.95,0,151.45>
  }
  triangle { // #4120
		<191.95,-25.15,151.45>,
		<191.95,0,151.45>,
		<188.15,-25.15,152.1>
  }
  triangle { // #4121
		<184.4,0,152.75>,
		<184.4,-25.15,152.75>,
		<188.15,0,152.1>
  }
  triangle { // #4122
		<188.15,-25.15,152.1>,
		<188.15,0,152.1>,
		<184.4,-25.15,152.75>
  }
  triangle { // #4123
		<180.6,0,153.45>,
		<180.6,-25.15,153.45>,
		<184.4,0,152.75>
  }
  triangle { // #4124
		<184.4,-25.15,152.75>,
		<184.4,0,152.75>,
		<180.6,-25.15,153.45>
  }
  triangle { // #4125
		<176.85,0,154.15>,
		<176.85,-25.15,154.15>,
		<180.6,0,153.45>
  }
  triangle { // #4126
		<180.6,-25.15,153.45>,
		<180.6,0,153.45>,
		<176.85,-25.15,154.15>
  }
  triangle { // #4127
		<173.05,0,154.8>,
		<173.05,-25.15,154.8>,
		<176.85,0,154.15>
  }
  triangle { // #4128
		<176.85,-25.15,154.15>,
		<176.85,0,154.15>,
		<173.05,-25.15,154.8>
  }
  triangle { // #4129
		<169.3,0,155.5>,
		<169.3,-25.15,155.5>,
		<173.05,0,154.8>
  }
  triangle { // #4130
		<173.05,-25.15,154.8>,
		<173.05,0,154.8>,
		<169.3,-25.15,155.5>
  }
  triangle { // #4131
		<165.55,0,156.2>,
		<165.55,-25.15,156.2>,
		<169.3,0,155.5>
  }
  triangle { // #4132
		<169.3,-25.15,155.5>,
		<169.3,0,155.5>,
		<165.55,-25.15,156.2>
  }
  triangle { // #4133
		<161.75,0,156.9>,
		<161.75,-25.15,156.9>,
		<165.55,0,156.2>
  }
  triangle { // #4134
		<165.55,-25.15,156.2>,
		<165.55,0,156.2>,
		<161.75,-25.15,156.9>
  }
  triangle { // #4135
		<158,0,157.6>,
		<158,-25.15,157.6>,
		<161.75,0,156.9>
  }
  triangle { // #4136
		<161.75,-25.15,156.9>,
		<161.75,0,156.9>,
		<158,-25.15,157.6>
  }
  triangle { // #4137
		<154.2,0,158.3>,
		<154.2,-25.15,158.3>,
		<158,0,157.6>
  }
  triangle { // #4138
		<158,-25.15,157.6>,
		<158,0,157.6>,
		<154.2,-25.15,158.3>
  }
  triangle { // #4139
		<150.45,0,159>,
		<150.45,-25.15,159>,
		<154.2,0,158.3>
  }
  triangle { // #4140
		<154.2,-25.15,158.3>,
		<154.2,0,158.3>,
		<150.45,-25.15,159>
  }
  triangle { // #4141
		<146.65,0,159.7>,
		<146.65,-25.15,159.7>,
		<150.45,0,159>
  }
  triangle { // #4142
		<150.45,-25.15,159>,
		<150.45,0,159>,
		<146.65,-25.15,159.7>
  }
  triangle { // #4143
		<142.9,0,160.4>,
		<142.9,-25.15,160.4>,
		<146.65,0,159.7>
  }
  triangle { // #4144
		<146.65,-25.15,159.7>,
		<146.65,0,159.7>,
		<142.9,-25.15,160.4>
  }
  triangle { // #4145
		<139.1,0,161.05>,
		<139.1,-25.15,161.05>,
		<142.9,0,160.4>
  }
  triangle { // #4146
		<142.9,-25.15,160.4>,
		<142.9,0,160.4>,
		<139.1,-25.15,161.05>
  }
  triangle { // #4147
		<135.35,0,161.7>,
		<135.35,-25.15,161.7>,
		<139.1,0,161.05>
  }
  triangle { // #4148
		<139.1,-25.15,161.05>,
		<139.1,0,161.05>,
		<135.35,-25.15,161.7>
  }
  triangle { // #4149
		<131.6,0,162.35>,
		<131.6,-25.15,162.35>,
		<135.35,0,161.7>
  }
  triangle { // #4150
		<135.35,-25.15,161.7>,
		<135.35,0,161.7>,
		<131.6,-25.15,162.35>
  }
  triangle { // #4151
		<127.8,0,162.95>,
		<127.8,-25.15,162.95>,
		<131.6,0,162.35>
  }
  triangle { // #4152
		<131.6,-25.15,162.35>,
		<131.6,0,162.35>,
		<127.8,-25.15,162.95>
  }
  triangle { // #4153
		<124.05,0,163.55>,
		<124.05,-25.15,163.55>,
		<127.8,0,162.95>
  }
  triangle { // #4154
		<127.8,-25.15,162.95>,
		<127.8,0,162.95>,
		<124.05,-25.15,163.55>
  }
  triangle { // #4155
		<120.25,0,164.15>,
		<120.25,-25.15,164.15>,
		<124.05,0,163.55>
  }
  triangle { // #4156
		<124.05,-25.15,163.55>,
		<124.05,0,163.55>,
		<120.25,-25.15,164.15>
  }
  triangle { // #4157
		<116.5,0,164.7>,
		<116.5,-25.15,164.7>,
		<120.25,0,164.15>
  }
  triangle { // #4158
		<120.25,-25.15,164.15>,
		<120.25,0,164.15>,
		<116.5,-25.15,164.7>
  }
  triangle { // #4159
		<112.7,0,165.25>,
		<112.7,-25.15,165.25>,
		<116.5,0,164.7>
  }
  triangle { // #4160
		<116.5,-25.15,164.7>,
		<116.5,0,164.7>,
		<112.7,-25.15,165.25>
  }
  triangle { // #4161
		<108.95,0,165.8>,
		<108.95,-25.15,165.8>,
		<112.7,0,165.25>
  }
  triangle { // #4162
		<112.7,-25.15,165.25>,
		<112.7,0,165.25>,
		<108.95,-25.15,165.8>
  }
  triangle { // #4163
		<105.2,0,166.3>,
		<105.2,-25.15,166.3>,
		<108.95,0,165.8>
  }
  triangle { // #4164
		<108.95,-25.15,165.8>,
		<108.95,0,165.8>,
		<105.2,-25.15,166.3>
  }
  triangle { // #4165
		<101.4,0,166.8>,
		<101.4,-25.15,166.8>,
		<105.2,0,166.3>
  }
  triangle { // #4166
		<105.2,-25.15,166.3>,
		<105.2,0,166.3>,
		<101.4,-25.15,166.8>
  }
  triangle { // #4167
		<97.65,0,167.3>,
		<97.65,-25.15,167.3>,
		<101.4,0,166.8>
  }
  triangle { // #4168
		<101.4,-25.15,166.8>,
		<101.4,0,166.8>,
		<97.65,-25.15,167.3>
  }
  triangle { // #4169
		<93.85,0,167.75>,
		<93.85,-25.15,167.75>,
		<97.65,0,167.3>
  }
  triangle { // #4170
		<97.65,-25.15,167.3>,
		<97.65,0,167.3>,
		<93.85,-25.15,167.75>
  }
  triangle { // #4171
		<90.1,0,168.2>,
		<90.1,-25.15,168.2>,
		<93.85,0,167.75>
  }
  triangle { // #4172
		<93.85,-25.15,167.75>,
		<93.85,0,167.75>,
		<90.1,-25.15,168.2>
  }
  triangle { // #4173
		<86.3,0,168.65>,
		<86.3,-25.15,168.65>,
		<90.1,0,168.2>
  }
  triangle { // #4174
		<90.1,-25.15,168.2>,
		<90.1,0,168.2>,
		<86.3,-25.15,168.65>
  }
  triangle { // #4175
		<82.55,0,169.05>,
		<82.55,-25.15,169.05>,
		<86.3,0,168.65>
  }
  triangle { // #4176
		<86.3,-25.15,168.65>,
		<86.3,0,168.65>,
		<82.55,-25.15,169.05>
  }
  triangle { // #4177
		<78.75,0,169.45>,
		<78.75,-25.15,169.45>,
		<82.55,0,169.05>
  }
  triangle { // #4178
		<82.55,-25.15,169.05>,
		<82.55,0,169.05>,
		<78.75,-25.15,169.45>
  }
  triangle { // #4179
		<75,0,169.8>,
		<75,-25.15,169.8>,
		<78.75,0,169.45>
  }
  triangle { // #4180
		<78.75,-25.15,169.45>,
		<78.75,0,169.45>,
		<75,-25.15,169.8>
  }
  triangle { // #4181
		<71.25,0,170.15>,
		<71.25,-25.15,170.15>,
		<75,0,169.8>
  }
  triangle { // #4182
		<75,-25.15,169.8>,
		<75,0,169.8>,
		<71.25,-25.15,170.15>
  }
  triangle { // #4183
		<67.45,0,170.45>,
		<67.45,-25.15,170.45>,
		<71.25,0,170.15>
  }
  triangle { // #4184
		<71.25,-25.15,170.15>,
		<71.25,0,170.15>,
		<67.45,-25.15,170.45>
  }
  triangle { // #4185
		<63.7,0,170.75>,
		<63.7,-25.15,170.75>,
		<67.45,0,170.45>
  }
  triangle { // #4186
		<67.45,-25.15,170.45>,
		<67.45,0,170.45>,
		<63.7,-25.15,170.75>
  }
  triangle { // #4187
		<59.9,0,171.05>,
		<59.9,-25.15,171.05>,
		<63.7,0,170.75>
  }
  triangle { // #4188
		<63.7,-25.15,170.75>,
		<63.7,0,170.75>,
		<59.9,-25.15,171.05>
  }
  triangle { // #4189
		<56.15,0,171.3>,
		<56.15,-25.15,171.3>,
		<59.9,0,171.05>
  }
  triangle { // #4190
		<59.9,-25.15,171.05>,
		<59.9,0,171.05>,
		<56.15,-25.15,171.3>
  }
  triangle { // #4191
		<52.35,0,171.55>,
		<52.35,-25.15,171.55>,
		<56.15,0,171.3>
  }
  triangle { // #4192
		<56.15,-25.15,171.3>,
		<56.15,0,171.3>,
		<52.35,-25.15,171.55>
  }
  triangle { // #4193
		<48.6,0,171.75>,
		<48.6,-25.15,171.75>,
		<52.35,0,171.55>
  }
  triangle { // #4194
		<52.35,-25.15,171.55>,
		<52.35,0,171.55>,
		<48.6,-25.15,171.75>
  }
  triangle { // #4195
		<44.85,0,171.95>,
		<44.85,-25.15,171.95>,
		<48.6,0,171.75>
  }
  triangle { // #4196
		<48.6,-25.15,171.75>,
		<48.6,0,171.75>,
		<44.85,-25.15,171.95>
  }
  triangle { // #4197
		<41.05,0,172.15>,
		<41.05,-25.15,172.15>,
		<44.85,0,171.95>
  }
  triangle { // #4198
		<44.85,-25.15,171.95>,
		<44.85,0,171.95>,
		<41.05,-25.15,172.15>
  }
  triangle { // #4199
		<37.3,0,172.3>,
		<37.3,-25.15,172.3>,
		<41.05,0,172.15>
  }
  triangle { // #4200
		<41.05,-25.15,172.15>,
		<41.05,0,172.15>,
		<37.3,-25.15,172.3>
  }
  triangle { // #4201
		<33.5,0,172.4>,
		<33.5,-25.15,172.4>,
		<37.3,0,172.3>
  }
  triangle { // #4202
		<37.3,-25.15,172.3>,
		<37.3,0,172.3>,
		<33.5,-25.15,172.4>
  }
  triangle { // #4203
		<29.75,0,172.55>,
		<29.75,-25.15,172.55>,
		<33.5,0,172.4>
  }
  triangle { // #4204
		<33.5,-25.15,172.4>,
		<33.5,0,172.4>,
		<29.75,-25.15,172.55>
  }
  triangle { // #4205
		<25.95,0,172.6>,
		<25.95,-25.15,172.6>,
		<29.75,0,172.55>
  }
  triangle { // #4206
		<29.75,-25.15,172.55>,
		<29.75,0,172.55>,
		<25.95,-25.15,172.6>
  }
  triangle { // #4207
		<22.2,0,172.7>,
		<22.2,-25.15,172.7>,
		<25.95,0,172.6>
  }
  triangle { // #4208
		<25.95,-25.15,172.6>,
		<25.95,0,172.6>,
		<22.2,-25.15,172.7>
  }
  triangle { // #4209
		<18.4,0,172.75>,
		<18.4,-25.15,172.75>,
		<22.2,0,172.7>
  }
  triangle { // #4210
		<22.2,-25.15,172.7>,
		<22.2,0,172.7>,
		<18.4,-25.15,172.75>
  }
  triangle { // #4211
		<14.65,0,172.85>,
		<14.65,-25.15,172.85>,
		<18.4,0,172.75>
  }
  triangle { // #4212
		<18.4,-25.15,172.75>,
		<18.4,0,172.75>,
		<14.65,-25.15,172.85>
  }
  triangle { // #4213
		<10.9,0,172.85>,
		<10.9,-25.15,172.85>,
		<14.65,0,172.85>
  }
  triangle { // #4214
		<14.65,-25.15,172.85>,
		<14.65,0,172.85>,
		<10.9,-25.15,172.85>
  }
  triangle { // #4215
		<7.1,0,172.9>,
		<7.1,-25.15,172.9>,
		<10.9,0,172.85>
  }
  triangle { // #4216
		<10.9,-25.15,172.85>,
		<10.9,0,172.85>,
		<7.1,-25.15,172.9>
  }
  triangle { // #4217
		<3.35,0,172.95>,
		<3.35,-25.15,172.95>,
		<7.1,0,172.9>
  }
  triangle { // #4218
		<7.1,-25.15,172.9>,
		<7.1,0,172.9>,
		<3.35,-25.15,172.95>
  }
  triangle { // #4219
		<-0.45,0,172.95>,
		<-0.45,-25.15,172.95>,
		<3.35,0,172.95>
  }
  triangle { // #4220
		<3.35,-25.15,172.95>,
		<3.35,0,172.95>,
		<-0.45,-25.15,172.95>
  }
  triangle { // #4221
		<-0.45,0,-1.9>,
		<-0.45,-25.15,-1.9>,
		<-0.45,0,172.95>
  }
  triangle { // #4222
		<-0.45,-25.15,172.95>,
		<-0.45,0,172.95>,
		<-0.45,-25.15,-1.9>
  }
  triangle { // #4223
		<439.55,-0,-1.9>,
		<439.55,-25.15,-1.9>,
		<-0.45,0,-1.9>
  }
  triangle { // #4224
		<-0.45,-25.15,-1.9>,
		<-0.45,0,-1.9>,
		<439.55,-25.15,-1.9>
  }
  triangle { // #4225
		<434.2,-5.65,247.75>,
		<436.15,-5.65,251.6>,
		<432.1,-5.65,243.95>
  }
  triangle { // #4226
		<-445.35,-5.65,268.15>,
		<-437.7,-5.65,254.8>,
		<-435.25,-5.65,272.65>
  }
  triangle { // #4227
		<439.55,-5.65,259.3>,
		<431.35,-5.65,262.95>,
		<437.9,-5.65,255.45>
  }
  triangle { // #4228
		<437.9,-5.65,255.45>,
		<431.35,-5.65,262.95>,
		<436.15,-5.65,251.6>
  }
  triangle { // #4229
		<-435.25,-5.65,272.65>,
		<-437.7,-5.65,254.8>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4230
		<-437.7,-5.65,254.8>,
		<-434.95,-5.65,250.45>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4231
		<-434.95,-5.65,250.45>,
		<-432.05,-5.65,246.2>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4232
		<-432.05,-5.65,246.2>,
		<-429.1,-5.65,242.05>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4233
		<-429.1,-5.65,242.05>,
		<-426.05,-5.65,237.9>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4234
		<-426.05,-5.65,237.9>,
		<-422.9,-5.65,233.85>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4235
		<-422.9,-5.65,233.85>,
		<-419.65,-5.65,229.85>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4236
		<-419.65,-5.65,229.85>,
		<-416.3,-5.65,225.9>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4237
		<-416.3,-5.65,225.9>,
		<-412.85,-5.65,222.05>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4238
		<-412.85,-5.65,222.05>,
		<-409.3,-5.65,218.25>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4239
		<-409.3,-5.65,218.25>,
		<-405.65,-5.65,214.55>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4240
		<-405.65,-5.65,214.55>,
		<-401.9,-5.65,210.85>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4241
		<-401.9,-5.65,210.85>,
		<-398,-5.65,207.25>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4242
		<-398,-5.65,207.25>,
		<-394.05,-5.65,203.75>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4243
		<-394.05,-5.65,203.75>,
		<-382.1,-5.65,193.8>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4244
		<-382.1,-5.65,193.8>,
		<-378.15,-5.65,190.75>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4245
		<-378.15,-5.65,190.75>,
		<-374.25,-5.65,187.8>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4246
		<-374.25,-5.65,187.8>,
		<-370.35,-5.65,185>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4247
		<-370.35,-5.65,185>,
		<-366.45,-5.65,182.35>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4248
		<-366.45,-5.65,182.35>,
		<-362.55,-5.65,179.8>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4249
		<-362.55,-5.65,179.8>,
		<-358.7,-5.65,177.35>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4250
		<-358.7,-5.65,177.35>,
		<-352.95,-5.65,174>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4251
		<-352.95,-5.65,174>,
		<-345.35,-5.65,169.9>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4252
		<-345.35,-5.65,169.9>,
		<-337.8,-5.65,166.35>,
		<-327.2,-5.65,309.75>
  }
  triangle { // #4253
		<-327.2,-5.65,309.75>,
		<-337.8,-5.65,166.35>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4254
		<-337.8,-5.65,166.35>,
		<-332.15,-5.65,163.95>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4255
		<-332.15,-5.65,163.95>,
		<-304.55,-5.65,150.35>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4256
		<-304.55,-5.65,150.35>,
		<-272.05,-5.65,148.9>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4257
		<-272.05,-5.65,148.9>,
		<-268.3,-5.65,148.5>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4258
		<-268.3,-5.65,148.5>,
		<-264.5,-5.65,148.2>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4259
		<-264.5,-5.65,148.2>,
		<-258.85,-5.65,147.85>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4260
		<-258.85,-5.65,147.85>,
		<-251.3,-5.65,147.6>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4261
		<-251.3,-5.65,147.6>,
		<-243.75,-5.65,147.65>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4262
		<-243.75,-5.65,147.65>,
		<-236.2,-5.65,148>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4263
		<-236.2,-5.65,148>,
		<-230.55,-5.65,148.4>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4264
		<-230.55,-5.65,148.4>,
		<-226.75,-5.65,148.75>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4265
		<-226.75,-5.65,148.75>,
		<-223,-5.65,149.2>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4266
		<-223,-5.65,149.2>,
		<-219.2,-5.65,149.7>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4267
		<-219.2,-5.65,149.7>,
		<-215.45,-5.65,150.25>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4268
		<-215.45,-5.65,150.25>,
		<-93.35,-5.65,167.6>,
		<-219.1,-5.65,335.9>
  }
  triangle { // #4269
		<-219.1,-5.65,335.9>,
		<-93.35,-5.65,167.6>,
		<-110.9,-5.65,351.1>
  }
  triangle { // #4270
		<-110.9,-5.65,351.1>,
		<-93.35,-5.65,167.6>,
		<-2.6,-5.65,355.35>
  }
  triangle { // #4271
		<-93.35,-5.65,167.6>,
		<29.7,-5.65,172.45>,
		<-2.6,-5.65,355.35>
  }
  triangle { // #4272
		<-2.6,-5.65,355.35>,
		<29.7,-5.65,172.45>,
		<105.75,-5.65,348.65>
  }
  triangle { // #4273
		<29.7,-5.65,172.45>,
		<152.45,-5.65,158.55>,
		<105.75,-5.65,348.65>
  }
  triangle { // #4274
		<105.75,-5.65,348.65>,
		<152.45,-5.65,158.55>,
		<214.2,-5.65,331.05>
  }
  triangle { // #4275
		<152.45,-5.65,158.55>,
		<213.35,-5.65,147.7>,
		<214.2,-5.65,331.05>
  }
  triangle { // #4276
		<214.2,-5.65,331.05>,
		<213.35,-5.65,147.7>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4277
		<213.35,-5.65,147.7>,
		<244.15,-5.65,140.85>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4278
		<244.15,-5.65,140.85>,
		<274.95,-5.65,145.9>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4279
		<274.95,-5.65,145.9>,
		<278.75,-5.65,146.3>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4280
		<278.75,-5.65,146.3>,
		<282.5,-5.65,146.8>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4281
		<282.5,-5.65,146.8>,
		<306.8,-5.65,148.85>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4282
		<306.8,-5.65,148.85>,
		<331.1,-5.65,159.2>,
		<322.75,-5.65,302.45>
  }
  triangle { // #4283
		<322.75,-5.65,302.45>,
		<331.1,-5.65,159.2>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4284
		<331.1,-5.65,159.2>,
		<334.8,-5.65,160.65>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4285
		<334.8,-5.65,160.65>,
		<338.55,-5.65,162.25>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4286
		<338.55,-5.65,162.25>,
		<342.35,-5.65,163.95>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4287
		<342.35,-5.65,163.95>,
		<346.15,-5.65,165.85>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4288
		<346.15,-5.65,165.85>,
		<350,-5.65,167.85>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4289
		<350,-5.65,167.85>,
		<353.85,-5.65,170>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4290
		<353.85,-5.65,170>,
		<357.75,-5.65,172.3>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4291
		<357.75,-5.65,172.3>,
		<361.65,-5.65,174.75>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4292
		<361.65,-5.65,174.75>,
		<365.6,-5.65,177.35>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4293
		<365.6,-5.65,177.35>,
		<369.55,-5.65,180.05>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4294
		<369.55,-5.65,180.05>,
		<373.55,-5.65,182.9>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4295
		<373.55,-5.65,182.9>,
		<377.6,-5.65,185.9>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4296
		<377.6,-5.65,185.9>,
		<381.65,-5.65,189.05>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4297
		<381.65,-5.65,189.05>,
		<394,-5.65,199.3>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4298
		<394,-5.65,199.3>,
		<398.05,-5.65,202.95>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4299
		<398.05,-5.65,202.95>,
		<401.95,-5.65,206.6>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4300
		<401.95,-5.65,206.6>,
		<405.95,-5.65,210.5>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4301
		<405.95,-5.65,210.5>,
		<409.3,-5.65,213.95>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4302
		<409.3,-5.65,213.95>,
		<412.7,-5.65,217.65>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4303
		<412.7,-5.65,217.65>,
		<415.95,-5.65,221.35>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4304
		<415.95,-5.65,221.35>,
		<419.05,-5.65,225.05>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4305
		<419.05,-5.65,225.05>,
		<422,-5.65,228.8>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4306
		<422,-5.65,228.8>,
		<424.75,-5.65,232.55>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4307
		<424.75,-5.65,232.55>,
		<427.35,-5.65,236.35>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4308
		<427.35,-5.65,236.35>,
		<429.8,-5.65,240.15>,
		<431.35,-5.65,262.95>
  }
  triangle { // #4309
		<431.35,-5.65,262.95>,
		<429.8,-5.65,240.15>,
		<436.15,-5.65,251.6>
  }
  triangle { // #4310
		<429.8,-5.65,240.15>,
		<432.1,-5.65,243.95>,
		<436.15,-5.65,251.6>
  }
  triangle { // #4311
		<434.2,0,247.75>,
		<432.1,0,243.95>,
		<436.15,0,251.6>
  }
  triangle { // #4312
		<-445.35,0,268.15>,
		<-435.25,0,272.65>,
		<-437.7,0,254.8>
  }
  triangle { // #4313
		<439.55,0,259.3>,
		<437.9,0,255.45>,
		<431.35,0,262.95>
  }
  triangle { // #4314
		<437.9,0,255.45>,
		<436.15,0,251.6>,
		<431.35,0,262.95>
  }
  triangle { // #4315
		<-435.25,0,272.65>,
		<-327.2,0,309.75>,
		<-437.7,0,254.8>
  }
  triangle { // #4316
		<-437.7,0,254.8>,
		<-327.2,0,309.75>,
		<-434.95,0,250.45>
  }
  triangle { // #4317
		<-434.95,0,250.45>,
		<-327.2,0,309.75>,
		<-432.05,0,246.2>
  }
  triangle { // #4318
		<-432.05,0,246.2>,
		<-327.2,0,309.75>,
		<-429.1,0,242.05>
  }
  triangle { // #4319
		<-429.1,0,242.05>,
		<-327.2,0,309.75>,
		<-426.05,0,237.9>
  }
  triangle { // #4320
		<-426.05,0,237.9>,
		<-327.2,0,309.75>,
		<-422.9,0,233.85>
  }
  triangle { // #4321
		<-422.9,0,233.85>,
		<-327.2,0,309.75>,
		<-419.65,0,229.85>
  }
  triangle { // #4322
		<-419.65,0,229.85>,
		<-327.2,0,309.75>,
		<-416.3,0,225.9>
  }
  triangle { // #4323
		<-416.3,0,225.9>,
		<-327.2,0,309.75>,
		<-412.85,0,222.05>
  }
  triangle { // #4324
		<-412.85,0,222.05>,
		<-327.2,0,309.75>,
		<-409.3,0,218.25>
  }
  triangle { // #4325
		<-409.3,0,218.25>,
		<-327.2,0,309.75>,
		<-405.65,0,214.55>
  }
  triangle { // #4326
		<-405.65,0,214.55>,
		<-327.2,0,309.75>,
		<-401.9,0,210.85>
  }
  triangle { // #4327
		<-401.9,0,210.85>,
		<-327.2,0,309.75>,
		<-398,0,207.25>
  }
  triangle { // #4328
		<-398,0,207.25>,
		<-327.2,0,309.75>,
		<-394.05,0,203.75>
  }
  triangle { // #4329
		<-394.05,0,203.75>,
		<-327.2,0,309.75>,
		<-382.1,0,193.8>
  }
  triangle { // #4330
		<-382.1,0,193.8>,
		<-327.2,0,309.75>,
		<-378.15,0,190.75>
  }
  triangle { // #4331
		<-378.15,0,190.75>,
		<-327.2,0,309.75>,
		<-374.25,0,187.8>
  }
  triangle { // #4332
		<-374.25,0,187.8>,
		<-327.2,0,309.75>,
		<-370.35,0,185>
  }
  triangle { // #4333
		<-370.35,0,185>,
		<-327.2,0,309.75>,
		<-366.45,0,182.35>
  }
  triangle { // #4334
		<-366.45,0,182.35>,
		<-327.2,0,309.75>,
		<-362.55,0,179.8>
  }
  triangle { // #4335
		<-362.55,0,179.8>,
		<-327.2,0,309.75>,
		<-358.7,0,177.35>
  }
  triangle { // #4336
		<-358.7,0,177.35>,
		<-327.2,0,309.75>,
		<-352.95,0,174>
  }
  triangle { // #4337
		<-352.95,0,174>,
		<-327.2,0,309.75>,
		<-345.35,0,169.9>
  }
  triangle { // #4338
		<-345.35,0,169.9>,
		<-327.2,0,309.75>,
		<-337.8,0,166.35>
  }
  triangle { // #4339
		<-327.2,0,309.75>,
		<-219.1,0,335.9>,
		<-337.8,0,166.35>
  }
  triangle { // #4340
		<-337.8,0,166.35>,
		<-219.1,0,335.9>,
		<-332.15,0,163.95>
  }
  triangle { // #4341
		<-332.15,0,163.95>,
		<-219.1,0,335.9>,
		<-304.55,0,150.35>
  }
  triangle { // #4342
		<-219.1,0,335.9>,
		<-272.05,0,148.9>,
		<-304.55,0,150.35>
  }
  triangle { // #4343
		<-272.05,0,148.9>,
		<-219.1,0,335.9>,
		<-268.3,0,148.5>
  }
  triangle { // #4344
		<-268.3,0,148.5>,
		<-219.1,0,335.9>,
		<-264.5,0,148.2>
  }
  triangle { // #4345
		<-264.5,0,148.2>,
		<-219.1,0,335.9>,
		<-258.85,0,147.85>
  }
  triangle { // #4346
		<-258.85,0,147.85>,
		<-219.1,0,335.9>,
		<-251.3,0,147.6>
  }
  triangle { // #4347
		<-251.3,0,147.6>,
		<-219.1,0,335.9>,
		<-243.75,0,147.65>
  }
  triangle { // #4348
		<-243.75,0,147.65>,
		<-219.1,0,335.9>,
		<-236.2,0,148>
  }
  triangle { // #4349
		<-236.2,0,148>,
		<-219.1,0,335.9>,
		<-230.55,0,148.4>
  }
  triangle { // #4350
		<-230.55,0,148.4>,
		<-219.1,0,335.9>,
		<-226.75,0,148.75>
  }
  triangle { // #4351
		<-226.75,0,148.75>,
		<-219.1,0,335.9>,
		<-223,0,149.2>
  }
  triangle { // #4352
		<-223,0,149.2>,
		<-219.1,0,335.9>,
		<-219.2,0,149.7>
  }
  triangle { // #4353
		<-219.2,0,149.7>,
		<-219.1,0,335.9>,
		<-215.45,0,150.25>
  }
  triangle { // #4354
		<-215.45,0,150.25>,
		<-219.1,0,335.9>,
		<-93.35,0,167.6>
  }
  triangle { // #4355
		<-219.1,0,335.9>,
		<-110.9,0,351.1>,
		<-93.35,0,167.6>
  }
  triangle { // #4356
		<-110.9,0,351.1>,
		<-2.6,0,355.35>,
		<-93.35,0,167.6>
  }
  triangle { // #4357
		<-93.35,0,167.6>,
		<-2.6,0,355.35>,
		<29.7,0,172.45>
  }
  triangle { // #4358
		<-2.6,0,355.35>,
		<105.75,0,348.65>,
		<29.7,0,172.45>
  }
  triangle { // #4359
		<29.7,0,172.45>,
		<105.75,0,348.65>,
		<152.45,0,158.55>
  }
  triangle { // #4360
		<105.75,0,348.65>,
		<214.2,0,331.05>,
		<152.45,0,158.55>
  }
  triangle { // #4361
		<152.45,0,158.55>,
		<214.2,0,331.05>,
		<213.35,0,147.7>
  }
  triangle { // #4362
		<214.2,0,331.05>,
		<322.75,0,302.45>,
		<213.35,0,147.7>
  }
  triangle { // #4363
		<213.35,0,147.7>,
		<322.75,0,302.45>,
		<244.15,0,140.85>
  }
  triangle { // #4364
		<322.75,0,302.45>,
		<274.95,0,145.9>,
		<244.15,0,140.85>
  }
  triangle { // #4365
		<274.95,0,145.9>,
		<322.75,0,302.45>,
		<278.75,0,146.3>
  }
  triangle { // #4366
		<278.75,0,146.3>,
		<322.75,0,302.45>,
		<282.5,0,146.8>
  }
  triangle { // #4367
		<282.5,0,146.8>,
		<322.75,0,302.45>,
		<306.8,0,148.85>
  }
  triangle { // #4368
		<322.75,0,302.45>,
		<331.1,0,159.2>,
		<306.8,0,148.85>
  }
  triangle { // #4369
		<322.75,0,302.45>,
		<431.35,0,262.95>,
		<331.1,0,159.2>
  }
  triangle { // #4370
		<331.1,0,159.2>,
		<431.35,0,262.95>,
		<334.8,0,160.65>
  }
  triangle { // #4371
		<334.8,0,160.65>,
		<431.35,0,262.95>,
		<338.55,0,162.25>
  }
  triangle { // #4372
		<338.55,0,162.25>,
		<431.35,0,262.95>,
		<342.35,0,163.95>
  }
  triangle { // #4373
		<342.35,0,163.95>,
		<431.35,0,262.95>,
		<346.15,0,165.85>
  }
  triangle { // #4374
		<346.15,0,165.85>,
		<431.35,0,262.95>,
		<350,0,167.85>
  }
  triangle { // #4375
		<350,0,167.85>,
		<431.35,0,262.95>,
		<353.85,0,170>
  }
  triangle { // #4376
		<353.85,0,170>,
		<431.35,0,262.95>,
		<357.75,0,172.3>
  }
  triangle { // #4377
		<357.75,0,172.3>,
		<431.35,0,262.95>,
		<361.65,0,174.75>
  }
  triangle { // #4378
		<361.65,0,174.75>,
		<431.35,0,262.95>,
		<365.6,0,177.35>
  }
  triangle { // #4379
		<365.6,0,177.35>,
		<431.35,0,262.95>,
		<369.55,0,180.05>
  }
  triangle { // #4380
		<369.55,0,180.05>,
		<431.35,0,262.95>,
		<373.55,0,182.9>
  }
  triangle { // #4381
		<373.55,0,182.9>,
		<431.35,0,262.95>,
		<377.6,0,185.9>
  }
  triangle { // #4382
		<377.6,0,185.9>,
		<431.35,0,262.95>,
		<381.65,0,189.05>
  }
  triangle { // #4383
		<381.65,0,189.05>,
		<431.35,0,262.95>,
		<394,0,199.3>
  }
  triangle { // #4384
		<394,0,199.3>,
		<431.35,0,262.95>,
		<398.05,0,202.95>
  }
  triangle { // #4385
		<398.05,0,202.95>,
		<431.35,0,262.95>,
		<401.95,0,206.6>
  }
  triangle { // #4386
		<401.95,0,206.6>,
		<431.35,0,262.95>,
		<405.95,0,210.5>
  }
  triangle { // #4387
		<405.95,0,210.5>,
		<431.35,0,262.95>,
		<409.3,0,213.95>
  }
  triangle { // #4388
		<409.3,0,213.95>,
		<431.35,0,262.95>,
		<412.7,0,217.65>
  }
  triangle { // #4389
		<412.7,0,217.65>,
		<431.35,0,262.95>,
		<415.95,0,221.35>
  }
  triangle { // #4390
		<415.95,0,221.35>,
		<431.35,0,262.95>,
		<419.05,0,225.05>
  }
  triangle { // #4391
		<419.05,0,225.05>,
		<431.35,0,262.95>,
		<422,0,228.8>
  }
  triangle { // #4392
		<422,0,228.8>,
		<431.35,0,262.95>,
		<424.75,0,232.55>
  }
  triangle { // #4393
		<424.75,0,232.55>,
		<431.35,0,262.95>,
		<427.35,0,236.35>
  }
  triangle { // #4394
		<427.35,0,236.35>,
		<431.35,0,262.95>,
		<429.8,0,240.15>
  }
  triangle { // #4395
		<431.35,0,262.95>,
		<436.15,0,251.6>,
		<429.8,0,240.15>
  }
  triangle { // #4396
		<429.8,0,240.15>,
		<436.15,0,251.6>,
		<432.1,0,243.95>
  }
  smooth_triangle { // #4397
		<-435.25,-5.65,272.65>, <-0.366,-0.931,0>,
		<-435.25,0,272.65>, <-0.366,-0.931,0>,
		<-445.35,-5.65,268.15>, <-0.407,-0.914,0>
  }
  smooth_triangle { // #4398
		<-445.35,0,268.15>, <-0.407,-0.914,0>,
		<-445.35,-5.65,268.15>, <-0.407,-0.914,0>,
		<-435.25,0,272.65>, <-0.366,-0.931,0>
  }
  smooth_triangle { // #4399
		<-435.25,-5.65,272.65>, <-0.325,-0.946,0>,
		<-327.2,-5.65,309.75>, <-0.295,-0.955,0>,
		<-435.25,0,272.65>, <-0.325,-0.946,0>
  }
  smooth_triangle { // #4400
		<431.35,-5.65,262.95>, <0.342,-0.94,0>,
		<431.35,0,262.95>, <0.342,-0.94,0>,
		<322.75,-5.65,302.45>, <0.298,-0.954,0>
  }
  smooth_triangle { // #4401
		<431.35,0,262.95>, <0.342,-0.94,0>,
		<322.75,0,302.45>, <0.298,-0.954,0>,
		<322.75,-5.65,302.45>, <0.298,-0.954,0>
  }
  smooth_triangle { // #4402
		<322.75,0,302.45>, <0.298,-0.954,0>,
		<214.2,0,331.05>, <0.223,-0.975,0>,
		<322.75,-5.65,302.45>, <0.298,-0.954,0>
  }
  smooth_triangle { // #4403
		<322.75,-5.65,302.45>, <0.298,-0.954,0>,
		<214.2,0,331.05>, <0.223,-0.975,0>,
		<214.2,-5.65,331.05>, <0.192,-0.981,0>
  }
  smooth_triangle { // #4404
		<214.2,0,331.05>, <0.223,-0.975,0>,
		<105.75,0,348.65>, <0.128,-0.992,0>,
		<214.2,-5.65,331.05>, <0.192,-0.981,0>
  }
  smooth_triangle { // #4405
		<214.2,-5.65,331.05>, <0.192,-0.981,0>,
		<105.75,0,348.65>, <0.128,-0.992,0>,
		<105.75,-5.65,348.65>, <0.095,-0.996,0>
  }
  smooth_triangle { // #4406
		<105.75,0,348.65>, <0.128,-0.992,0>,
		<-2.6,0,355.35>, <0.028,-1,0>,
		<105.75,-5.65,348.65>, <0.095,-0.996,0>
  }
  smooth_triangle { // #4407
		<105.75,-5.65,348.65>, <0.095,-0.996,0>,
		<-2.6,0,355.35>, <0.028,-1,0>,
		<-2.6,-5.65,355.35>, <-0.006,-1,0>
  }
  smooth_triangle { // #4408
		<-2.6,0,355.35>, <0.028,-1,0>,
		<-110.9,0,351.1>, <-0.073,-0.997,0>,
		<-2.6,-5.65,355.35>, <-0.006,-1,0>
  }
  smooth_triangle { // #4409
		<-2.6,-5.65,355.35>, <-0.006,-1,0>,
		<-110.9,0,351.1>, <-0.073,-0.997,0>,
		<-110.9,-5.65,351.1>, <-0.106,-0.994,0>
  }
  smooth_triangle { // #4410
		<-110.9,0,351.1>, <-0.073,-0.997,0>,
		<-219.1,0,335.9>, <-0.171,-0.985,0>,
		<-110.9,-5.65,351.1>, <-0.106,-0.994,0>
  }
  smooth_triangle { // #4411
		<-110.9,-5.65,351.1>, <-0.106,-0.994,0>,
		<-219.1,0,335.9>, <-0.171,-0.985,0>,
		<-219.1,-5.65,335.9>, <-0.203,-0.979,0>
  }
  smooth_triangle { // #4412
		<-219.1,0,335.9>, <-0.171,-0.985,0>,
		<-327.2,0,309.75>, <-0.265,-0.964,0>,
		<-219.1,-5.65,335.9>, <-0.203,-0.979,0>
  }
  smooth_triangle { // #4413
		<-219.1,-5.65,335.9>, <-0.203,-0.979,0>,
		<-327.2,0,309.75>, <-0.265,-0.964,0>,
		<-327.2,-5.65,309.75>, <-0.295,-0.955,0>
  }
  smooth_triangle { // #4414
		<-327.2,0,309.75>, <-0.265,-0.964,0>,
		<-435.25,0,272.65>, <-0.325,-0.946,0>,
		<-327.2,-5.65,309.75>, <-0.295,-0.955,0>
  }
  smooth_triangle { // #4415
		<439.55,-5.65,259.3>, <0.406,-0.914,0>,
		<439.55,0,259.3>, <0.406,-0.914,0>,
		<431.35,-5.65,262.95>, <0.385,-0.923,0>
  }
  smooth_triangle { // #4416
		<431.35,0,262.95>, <0.363,-0.932,0>,
		<431.35,-5.65,262.95>, <0.385,-0.923,0>,
		<439.55,0,259.3>, <0.406,-0.914,0>
  }
  smooth_triangle { // #4417
		<437.9,-5.65,255.45>, <0.912,0.409,0>,
		<437.9,0,255.45>, <0.917,0.398,0>,
		<439.55,-5.65,259.3>, <0.922,0.387,0>
  }
  smooth_triangle { // #4418
		<439.55,0,259.3>, <0.922,0.387,0>,
		<439.55,-5.65,259.3>, <0.922,0.387,0>,
		<437.9,0,255.45>, <0.917,0.398,0>
  }
  smooth_triangle { // #4419
		<436.15,-5.65,251.6>, <0.897,0.442,0>,
		<436.15,0,251.6>, <0.902,0.431,0>,
		<437.9,-5.65,255.45>, <0.912,0.409,0>
  }
  smooth_triangle { // #4420
		<437.9,0,255.45>, <0.917,0.398,0>,
		<437.9,-5.65,255.45>, <0.912,0.409,0>,
		<436.15,0,251.6>, <0.902,0.431,0>
  }
  smooth_triangle { // #4421
		<434.2,-5.65,247.75>, <0.881,0.473,0>,
		<434.2,0,247.75>, <0.886,0.463,0>,
		<436.15,-5.65,251.6>, <0.897,0.442,0>
  }
  smooth_triangle { // #4422
		<436.15,0,251.6>, <0.902,0.431,0>,
		<436.15,-5.65,251.6>, <0.897,0.442,0>,
		<434.2,0,247.75>, <0.886,0.463,0>
  }
  smooth_triangle { // #4423
		<432.1,-5.65,243.95>, <0.864,0.503,0>,
		<432.1,0,243.95>, <0.87,0.494,0>,
		<434.2,-5.65,247.75>, <0.881,0.473,0>
  }
  smooth_triangle { // #4424
		<434.2,0,247.75>, <0.886,0.463,0>,
		<434.2,-5.65,247.75>, <0.881,0.473,0>,
		<432.1,0,243.95>, <0.87,0.494,0>
  }
  smooth_triangle { // #4425
		<429.8,-5.65,240.15>, <0.847,0.532,0>,
		<429.8,0,240.15>, <0.853,0.522,0>,
		<432.1,-5.65,243.95>, <0.864,0.503,0>
  }
  smooth_triangle { // #4426
		<432.1,0,243.95>, <0.87,0.494,0>,
		<432.1,-5.65,243.95>, <0.864,0.503,0>,
		<429.8,0,240.15>, <0.853,0.522,0>
  }
  smooth_triangle { // #4427
		<427.35,-5.65,236.35>, <0.829,0.559,0>,
		<427.35,0,236.35>, <0.835,0.55,0>,
		<429.8,-5.65,240.15>, <0.847,0.532,0>
  }
  smooth_triangle { // #4428
		<429.8,0,240.15>, <0.853,0.522,0>,
		<429.8,-5.65,240.15>, <0.847,0.532,0>,
		<427.35,0,236.35>, <0.835,0.55,0>
  }
  smooth_triangle { // #4429
		<424.75,-5.65,232.55>, <0.812,0.584,0>,
		<424.75,0,232.55>, <0.818,0.576,0>,
		<427.35,-5.65,236.35>, <0.829,0.559,0>
  }
  smooth_triangle { // #4430
		<427.35,0,236.35>, <0.835,0.55,0>,
		<427.35,-5.65,236.35>, <0.829,0.559,0>,
		<424.75,0,232.55>, <0.818,0.576,0>
  }
  smooth_triangle { // #4431
		<422,-5.65,228.8>, <0.794,0.608,0>,
		<422,0,228.8>, <0.8,0.6,0>,
		<424.75,-5.65,232.55>, <0.812,0.584,0>
  }
  smooth_triangle { // #4432
		<424.75,0,232.55>, <0.818,0.576,0>,
		<424.75,-5.65,232.55>, <0.812,0.584,0>,
		<422,0,228.8>, <0.8,0.6,0>
  }
  smooth_triangle { // #4433
		<419.05,-5.65,225.05>, <0.776,0.631,0>,
		<419.05,0,225.05>, <0.782,0.624,0>,
		<422,-5.65,228.8>, <0.794,0.608,0>
  }
  smooth_triangle { // #4434
		<422,0,228.8>, <0.8,0.6,0>,
		<422,-5.65,228.8>, <0.794,0.608,0>,
		<419.05,0,225.05>, <0.782,0.624,0>
  }
  smooth_triangle { // #4435
		<415.95,-5.65,221.35>, <0.758,0.652,0>,
		<415.95,0,221.35>, <0.764,0.645,0>,
		<419.05,-5.65,225.05>, <0.776,0.631,0>
  }
  smooth_triangle { // #4436
		<419.05,0,225.05>, <0.782,0.624,0>,
		<419.05,-5.65,225.05>, <0.776,0.631,0>,
		<415.95,0,221.35>, <0.764,0.645,0>
  }
  smooth_triangle { // #4437
		<412.7,-5.65,217.65>, <0.74,0.672,0>,
		<412.7,0,217.65>, <0.746,0.666,0>,
		<415.95,-5.65,221.35>, <0.758,0.652,0>
  }
  smooth_triangle { // #4438
		<415.95,0,221.35>, <0.764,0.645,0>,
		<415.95,-5.65,221.35>, <0.758,0.652,0>,
		<412.7,0,217.65>, <0.746,0.666,0>
  }
  smooth_triangle { // #4439
		<409.3,-5.65,213.95>, <0.723,0.691,0>,
		<409.3,0,213.95>, <0.728,0.685,0>,
		<412.7,-5.65,217.65>, <0.74,0.672,0>
  }
  smooth_triangle { // #4440
		<412.7,0,217.65>, <0.746,0.666,0>,
		<412.7,-5.65,217.65>, <0.74,0.672,0>,
		<409.3,0,213.95>, <0.728,0.685,0>
  }
  smooth_triangle { // #4441
		<405.95,-5.65,210.5>, <0.706,0.708,0>,
		<405.95,0,210.5>, <0.711,0.703,0>,
		<409.3,-5.65,213.95>, <0.723,0.691,0>
  }
  smooth_triangle { // #4442
		<409.3,0,213.95>, <0.728,0.685,0>,
		<409.3,-5.65,213.95>, <0.723,0.691,0>,
		<405.95,0,210.5>, <0.711,0.703,0>
  }
  smooth_triangle { // #4443
		<401.95,-5.65,206.6>, <0.689,0.725,0>,
		<401.95,0,206.6>, <0.695,0.719,0>,
		<405.95,-5.65,210.5>, <0.706,0.708,0>
  }
  smooth_triangle { // #4444
		<405.95,0,210.5>, <0.711,0.703,0>,
		<405.95,-5.65,210.5>, <0.706,0.708,0>,
		<401.95,0,206.6>, <0.695,0.719,0>
  }
  smooth_triangle { // #4445
		<398.05,-5.65,202.95>, <0.672,0.741,0>,
		<398.05,0,202.95>, <0.677,0.736,0>,
		<401.95,-5.65,206.6>, <0.689,0.725,0>
  }
  smooth_triangle { // #4446
		<401.95,0,206.6>, <0.695,0.719,0>,
		<401.95,-5.65,206.6>, <0.689,0.725,0>,
		<398.05,0,202.95>, <0.677,0.736,0>
  }
  smooth_triangle { // #4447
		<394,-5.65,199.3>, <0.648,0.761,0>,
		<394,0,199.3>, <0.657,0.754,0>,
		<398.05,-5.65,202.95>, <0.672,0.741,0>
  }
  smooth_triangle { // #4448
		<398.05,0,202.95>, <0.677,0.736,0>,
		<398.05,-5.65,202.95>, <0.672,0.741,0>,
		<394,0,199.3>, <0.657,0.754,0>
  }
  triangle { // #4449
		<381.65,-5.65,189.05>,
		<381.65,0,189.05>,
		<394,-5.65,199.3>
  }
  triangle { // #4450
		<394,0,199.3>,
		<394,-5.65,199.3>,
		<381.65,0,189.05>
  }
  triangle { // #4451
		<377.6,-5.65,185.9>,
		<377.6,0,185.9>,
		<381.65,-5.65,189.05>
  }
  smooth_triangle { // #4452
		<381.65,0,189.05>, <0.63,0.776,0>,
		<381.65,-5.65,189.05>, <0.621,0.784,0>,
		<377.6,0,185.9>, <0.607,0.795,0>
  }
  smooth_triangle { // #4453
		<373.55,-5.65,182.9>, <0.586,0.81,0>,
		<373.55,0,182.9>, <0.592,0.806,0>,
		<377.6,-5.65,185.9>, <0.602,0.799,0>
  }
  triangle { // #4454
		<377.6,0,185.9>,
		<377.6,-5.65,185.9>,
		<373.55,0,182.9>
  }
  smooth_triangle { // #4455
		<369.55,-5.65,180.05>, <0.57,0.822,0>,
		<369.55,0,180.05>, <0.576,0.818,0>,
		<373.55,-5.65,182.9>, <0.586,0.81,0>
  }
  smooth_triangle { // #4456
		<373.55,0,182.9>, <0.592,0.806,0>,
		<373.55,-5.65,182.9>, <0.586,0.81,0>,
		<369.55,0,180.05>, <0.576,0.818,0>
  }
  smooth_triangle { // #4457
		<365.6,-5.65,177.35>, <0.553,0.833,0>,
		<365.6,0,177.35>, <0.559,0.829,0>,
		<369.55,-5.65,180.05>, <0.57,0.822,0>
  }
  smooth_triangle { // #4458
		<369.55,0,180.05>, <0.576,0.818,0>,
		<369.55,-5.65,180.05>, <0.57,0.822,0>,
		<365.6,0,177.35>, <0.559,0.829,0>
  }
  smooth_triangle { // #4459
		<361.65,-5.65,174.75>, <0.534,0.845,0>,
		<361.65,0,174.75>, <0.541,0.841,0>,
		<365.6,-5.65,177.35>, <0.553,0.833,0>
  }
  smooth_triangle { // #4460
		<365.6,0,177.35>, <0.559,0.829,0>,
		<365.6,-5.65,177.35>, <0.553,0.833,0>,
		<361.65,0,174.75>, <0.541,0.841,0>
  }
  smooth_triangle { // #4461
		<357.75,-5.65,172.3>, <0.515,0.857,0>,
		<357.75,0,172.3>, <0.522,0.853,0>,
		<361.65,-5.65,174.75>, <0.534,0.845,0>
  }
  smooth_triangle { // #4462
		<361.65,0,174.75>, <0.541,0.841,0>,
		<361.65,-5.65,174.75>, <0.534,0.845,0>,
		<357.75,0,172.3>, <0.522,0.853,0>
  }
  smooth_triangle { // #4463
		<353.85,-5.65,170>, <0.495,0.869,0>,
		<353.85,0,170>, <0.502,0.865,0>,
		<357.75,-5.65,172.3>, <0.515,0.857,0>
  }
  smooth_triangle { // #4464
		<357.75,0,172.3>, <0.522,0.853,0>,
		<357.75,-5.65,172.3>, <0.515,0.857,0>,
		<353.85,0,170>, <0.502,0.865,0>
  }
  smooth_triangle { // #4465
		<350,-5.65,167.85>, <0.473,0.881,0>,
		<350,0,167.85>, <0.48,0.877,0>,
		<353.85,-5.65,170>, <0.495,0.869,0>
  }
  smooth_triangle { // #4466
		<353.85,0,170>, <0.502,0.865,0>,
		<353.85,-5.65,170>, <0.495,0.869,0>,
		<350,0,167.85>, <0.48,0.877,0>
  }
  smooth_triangle { // #4467
		<346.15,-5.65,165.85>, <0.45,0.893,0>,
		<346.15,0,165.85>, <0.458,0.889,0>,
		<350,-5.65,167.85>, <0.473,0.881,0>
  }
  smooth_triangle { // #4468
		<350,0,167.85>, <0.48,0.877,0>,
		<350,-5.65,167.85>, <0.473,0.881,0>,
		<346.15,0,165.85>, <0.458,0.889,0>
  }
  smooth_triangle { // #4469
		<342.35,-5.65,163.95>, <0.426,0.905,0>,
		<342.35,0,163.95>, <0.434,0.901,0>,
		<346.15,-5.65,165.85>, <0.45,0.893,0>
  }
  smooth_triangle { // #4470
		<346.15,0,165.85>, <0.458,0.889,0>,
		<346.15,-5.65,165.85>, <0.45,0.893,0>,
		<342.35,0,163.95>, <0.434,0.901,0>
  }
  smooth_triangle { // #4471
		<338.55,-5.65,162.25>, <0.4,0.916,0>,
		<338.55,0,162.25>, <0.409,0.913,0>,
		<342.35,-5.65,163.95>, <0.426,0.905,0>
  }
  smooth_triangle { // #4472
		<342.35,0,163.95>, <0.434,0.901,0>,
		<342.35,-5.65,163.95>, <0.426,0.905,0>,
		<338.55,0,162.25>, <0.409,0.913,0>
  }
  smooth_triangle { // #4473
		<334.8,-5.65,160.65>, <0.373,0.928,0>,
		<334.8,0,160.65>, <0.382,0.924,0>,
		<338.55,-5.65,162.25>, <0.4,0.916,0>
  }
  smooth_triangle { // #4474
		<338.55,0,162.25>, <0.409,0.913,0>,
		<338.55,-5.65,162.25>, <0.4,0.916,0>,
		<334.8,0,160.65>, <0.382,0.924,0>
  }
  smooth_triangle { // #4475
		<331.1,-5.65,159.2>, <0.383,0.924,0>,
		<331.1,0,159.2>, <0.378,0.926,0>,
		<334.8,-5.65,160.65>, <0.373,0.928,0>
  }
  smooth_triangle { // #4476
		<334.8,0,160.65>, <0.382,0.924,0>,
		<334.8,-5.65,160.65>, <0.373,0.928,0>,
		<331.1,0,159.2>, <0.378,0.926,0>
  }
  smooth_triangle { // #4477
		<331.1,-5.65,159.2>, <0.392,0.92,0>,
		<306.8,-5.65,148.85>, <0.241,0.971,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>
  }
  smooth_triangle { // #4478
		<282.5,0,146.8>, <0.084,0.996,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>,
		<282.5,-5.65,146.8>, <0.084,0.996,0>
  }
  smooth_triangle { // #4479
		<282.5,-5.65,146.8>, <0.084,0.996,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>,
		<306.8,-5.65,148.85>, <0.241,0.971,0>
  }
  smooth_triangle { // #4480
		<282.5,0,146.8>, <0.084,0.996,0>,
		<306.8,0,148.85>, <0.241,0.971,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>
  }
  smooth_triangle { // #4481
		<331.1,-5.65,159.2>, <0.392,0.92,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>,
		<331.1,0,159.2>, <0.392,0.92,0>
  }
  smooth_triangle { // #4482
		<331.1,0,159.2>, <0.392,0.92,0>,
		<306.8,-2.85,148.85>, <0.241,0.971,0>,
		<306.8,0,148.85>, <0.241,0.971,0>
  }
  smooth_triangle { // #4483
		<278.75,-5.65,146.3>, <0.117,0.993,0>,
		<278.75,0,146.3>, <0.122,0.992,0>,
		<282.5,-5.65,146.8>, <0.106,0.994,0>
  }
  smooth_triangle { // #4484
		<282.5,0,146.8>, <0.099,0.995,0>,
		<282.5,-5.65,146.8>, <0.106,0.994,0>,
		<278.75,0,146.3>, <0.122,0.992,0>
  }
  smooth_triangle { // #4485
		<274.95,-5.65,145.9>, <0.136,0.991,0>,
		<274.95,0,145.9>, <0.141,0.99,0>,
		<278.75,-5.65,146.3>, <0.117,0.993,0>
  }
  smooth_triangle { // #4486
		<278.75,0,146.3>, <0.122,0.992,0>,
		<278.75,-5.65,146.3>, <0.117,0.993,0>,
		<274.95,0,145.9>, <0.141,0.99,0>
  }
  smooth_triangle { // #4487
		<152.45,-5.65,158.55>, <-0.155,0.988,0>,
		<29.7,-5.65,172.45>, <-0.062,0.998,0>,
		<152.45,0,158.55>, <-0.134,0.991,0>
  }
  smooth_triangle { // #4488
		<213.35,-5.65,147.7>, <-0.203,0.979,0>,
		<244.15,-2.85,140.85>, <-0.066,0.998,0>,
		<244.15,-5.65,140.85>, <0.036,0.999,0>
  }
  smooth_triangle { // #4489
		<274.95,-5.65,145.9>, <0.161,0.987,0>,
		<244.15,-5.65,140.85>, <0.036,0.999,0>,
		<274.95,0,145.9>, <0.161,0.987,0>
  }
  smooth_triangle { // #4490
		<244.15,-5.65,140.85>, <0.036,0.999,0>,
		<244.15,-2.85,140.85>, <-0.066,0.998,0>,
		<274.95,0,145.9>, <0.161,0.987,0>
  }
  smooth_triangle { // #4491
		<274.95,0,145.9>, <0.161,0.987,0>,
		<244.15,-2.85,140.85>, <-0.066,0.998,0>,
		<244.15,0,140.85>, <-0.028,1,0>
  }
  smooth_triangle { // #4492
		<213.35,-5.65,147.7>, <-0.203,0.979,0>,
		<213.35,0,147.7>, <-0.196,0.981,0>,
		<244.15,-2.85,140.85>, <-0.066,0.998,0>
  }
  smooth_triangle { // #4493
		<244.15,-2.85,140.85>, <-0.066,0.998,0>,
		<213.35,0,147.7>, <-0.196,0.981,0>,
		<244.15,0,140.85>, <-0.028,1,0>
  }
  smooth_triangle { // #4494
		<213.35,-5.65,147.7>, <-0.203,0.979,0>,
		<152.45,-5.65,158.55>, <-0.155,0.988,0>,
		<213.35,0,147.7>, <-0.196,0.981,0>
  }
  smooth_triangle { // #4495
		<213.35,0,147.7>, <-0.196,0.981,0>,
		<152.45,-5.65,158.55>, <-0.155,0.988,0>,
		<152.45,0,158.55>, <-0.134,0.991,0>
  }
  smooth_triangle { // #4496
		<-215.45,0,150.25>, <0.141,0.99,0>,
		<-93.35,0,167.6>, <0.107,0.994,0>,
		<-215.45,-5.65,150.25>, <0.141,0.99,0>
  }
  smooth_triangle { // #4497
		<-215.45,-5.65,150.25>, <0.141,0.99,0>,
		<-93.35,0,167.6>, <0.107,0.994,0>,
		<-93.35,-5.65,167.6>, <0.073,0.997,0>
  }
  smooth_triangle { // #4498
		<-93.35,0,167.6>, <0.107,0.994,0>,
		<29.7,0,172.45>, <-0.011,1,0>,
		<-93.35,-5.65,167.6>, <0.073,0.997,0>
  }
  smooth_triangle { // #4499
		<-93.35,-5.65,167.6>, <0.073,0.997,0>,
		<29.7,0,172.45>, <-0.011,1,0>,
		<29.7,-5.65,172.45>, <-0.062,0.998,0>
  }
  smooth_triangle { // #4500
		<29.7,0,172.45>, <-0.011,1,0>,
		<152.45,0,158.55>, <-0.134,0.991,0>,
		<29.7,-5.65,172.45>, <-0.062,0.998,0>
  }
  smooth_triangle { // #4501
		<-219.2,-5.65,149.7>, <0.137,0.991,0>,
		<-219.2,0,149.7>, <0.143,0.99,0>,
		<-215.45,-5.65,150.25>, <0.145,0.989,0>
  }
  triangle { // #4502
		<-215.45,0,150.25>,
		<-215.45,-5.65,150.25>,
		<-219.2,0,149.7>
  }
  smooth_triangle { // #4503
		<-223,-5.65,149.2>, <0.119,0.993,0>,
		<-223,0,149.2>, <0.125,0.992,0>,
		<-219.2,-5.65,149.7>, <0.137,0.991,0>
  }
  smooth_triangle { // #4504
		<-219.2,0,149.7>, <0.143,0.99,0>,
		<-219.2,-5.65,149.7>, <0.137,0.991,0>,
		<-223,0,149.2>, <0.125,0.992,0>
  }
  smooth_triangle { // #4505
		<-226.75,-5.65,148.75>, <0.102,0.995,0>,
		<-226.75,0,148.75>, <0.108,0.994,0>,
		<-223,-5.65,149.2>, <0.119,0.993,0>
  }
  smooth_triangle { // #4506
		<-223,0,149.2>, <0.125,0.992,0>,
		<-223,-5.65,149.2>, <0.119,0.993,0>,
		<-226.75,0,148.75>, <0.108,0.994,0>
  }
  smooth_triangle { // #4507
		<-230.55,-5.65,148.4>, <0.08,0.997,0>,
		<-230.55,0,148.4>, <0.088,0.996,0>,
		<-226.75,-5.65,148.75>, <0.102,0.995,0>
  }
  smooth_triangle { // #4508
		<-226.75,0,148.75>, <0.108,0.994,0>,
		<-226.75,-5.65,148.75>, <0.102,0.995,0>,
		<-230.55,0,148.4>, <0.088,0.996,0>
  }
  smooth_triangle { // #4509
		<-236.2,-5.65,148>, <0.052,0.999,0>,
		<-236.2,0,148>, <0.062,0.998,0>,
		<-230.55,-5.65,148.4>, <0.08,0.997,0>
  }
  smooth_triangle { // #4510
		<-230.55,0,148.4>, <0.088,0.996,0>,
		<-230.55,-5.65,148.4>, <0.08,0.997,0>,
		<-236.2,0,148>, <0.062,0.998,0>
  }
  smooth_triangle { // #4511
		<-243.75,-5.65,147.65>, <0.018,1,0>,
		<-243.75,0,147.65>, <0.03,1,0>,
		<-236.2,-5.65,148>, <0.052,0.999,0>
  }
  smooth_triangle { // #4512
		<-236.2,0,148>, <0.062,0.998,0>,
		<-236.2,-5.65,148>, <0.052,0.999,0>,
		<-243.75,0,147.65>, <0.03,1,0>
  }
  smooth_triangle { // #4513
		<-251.3,-5.65,147.6>, <-0.017,1,0>,
		<-251.3,0,147.6>, <-0.006,1,0>,
		<-243.75,-5.65,147.65>, <0.018,1,0>
  }
  smooth_triangle { // #4514
		<-243.75,0,147.65>, <0.03,1,0>,
		<-243.75,-5.65,147.65>, <0.018,1,0>,
		<-251.3,0,147.6>, <-0.006,1,0>
  }
  smooth_triangle { // #4515
		<-258.85,-5.65,147.85>, <-0.049,0.999,0>,
		<-258.85,0,147.85>, <-0.039,0.999,0>,
		<-251.3,-5.65,147.6>, <-0.017,1,0>
  }
  smooth_triangle { // #4516
		<-251.3,0,147.6>, <-0.006,1,0>,
		<-251.3,-5.65,147.6>, <-0.017,1,0>,
		<-258.85,0,147.85>, <-0.039,0.999,0>
  }
  smooth_triangle { // #4517
		<-264.5,-5.65,148.2>, <-0.075,0.997,0>,
		<-264.5,0,148.2>, <-0.067,0.998,0>,
		<-258.85,-5.65,147.85>, <-0.049,0.999,0>
  }
  smooth_triangle { // #4518
		<-258.85,0,147.85>, <-0.039,0.999,0>,
		<-258.85,-5.65,147.85>, <-0.049,0.999,0>,
		<-264.5,0,148.2>, <-0.067,0.998,0>
  }
  smooth_triangle { // #4519
		<-268.3,-5.65,148.5>, <-0.095,0.995,0>,
		<-268.3,0,148.5>, <-0.089,0.996,0>,
		<-264.5,-5.65,148.2>, <-0.075,0.997,0>
  }
  smooth_triangle { // #4520
		<-264.5,0,148.2>, <-0.067,0.998,0>,
		<-264.5,-5.65,148.2>, <-0.075,0.997,0>,
		<-268.3,0,148.5>, <-0.089,0.996,0>
  }
  smooth_triangle { // #4521
		<-272.05,-5.65,148.9>, <-0.063,0.998,0>,
		<-272.05,0,148.9>, <-0.073,0.997,0>,
		<-268.3,-5.65,148.5>, <-0.095,0.995,0>
  }
  smooth_triangle { // #4522
		<-268.3,0,148.5>, <-0.089,0.996,0>,
		<-268.3,-5.65,148.5>, <-0.095,0.995,0>,
		<-272.05,0,148.9>, <-0.073,0.997,0>
  }
  smooth_triangle { // #4523
		<-272.05,-5.65,148.9>, <-0.045,0.999,0>,
		<-304.55,-5.65,150.35>, <-0.249,0.969,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>
  }
  smooth_triangle { // #4524
		<-332.15,0,163.95>, <-0.442,0.897,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>,
		<-332.15,-5.65,163.95>, <-0.442,0.897,0>
  }
  smooth_triangle { // #4525
		<-332.15,-5.65,163.95>, <-0.442,0.897,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>,
		<-304.55,-5.65,150.35>, <-0.249,0.969,0>
  }
  smooth_triangle { // #4526
		<-332.15,0,163.95>, <-0.442,0.897,0>,
		<-304.55,0,150.35>, <-0.249,0.969,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>
  }
  smooth_triangle { // #4527
		<-272.05,-5.65,148.9>, <-0.045,0.999,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>,
		<-272.05,0,148.9>, <-0.045,0.999,0>
  }
  smooth_triangle { // #4528
		<-272.05,0,148.9>, <-0.045,0.999,0>,
		<-304.55,-2.85,150.35>, <-0.249,0.969,0>,
		<-304.55,0,150.35>, <-0.249,0.969,0>
  }
  smooth_triangle { // #4529
		<-337.8,-5.65,166.35>, <-0.414,0.91,0>,
		<-337.8,0,166.35>, <-0.402,0.915,0>,
		<-332.15,-5.65,163.95>, <-0.417,0.909,0>
  }
  smooth_triangle { // #4530
		<-332.15,0,163.95>, <-0.425,0.905,0>,
		<-332.15,-5.65,163.95>, <-0.417,0.909,0>,
		<-337.8,0,166.35>, <-0.402,0.915,0>
  }
  smooth_triangle { // #4531
		<-345.35,-5.65,169.9>, <-0.457,0.889,0>,
		<-345.35,0,169.9>, <-0.442,0.897,0>,
		<-337.8,-5.65,166.35>, <-0.414,0.91,0>
  }
  smooth_triangle { // #4532
		<-337.8,0,166.35>, <-0.402,0.915,0>,
		<-337.8,-5.65,166.35>, <-0.414,0.91,0>,
		<-345.35,0,169.9>, <-0.442,0.897,0>
  }
  smooth_triangle { // #4533
		<-352.95,-5.65,174>, <-0.494,0.869,0>,
		<-352.95,0,174>, <-0.484,0.875,0>,
		<-345.35,-5.65,169.9>, <-0.457,0.889,0>
  }
  smooth_triangle { // #4534
		<-345.35,0,169.9>, <-0.442,0.897,0>,
		<-345.35,-5.65,169.9>, <-0.457,0.889,0>,
		<-352.95,0,174>, <-0.484,0.875,0>
  }
  smooth_triangle { // #4535
		<-358.7,-5.65,177.35>, <-0.523,0.853,0>,
		<-358.7,0,177.35>, <-0.514,0.858,0>,
		<-352.95,-5.65,174>, <-0.494,0.869,0>
  }
  smooth_triangle { // #4536
		<-352.95,0,174>, <-0.484,0.875,0>,
		<-352.95,-5.65,174>, <-0.494,0.869,0>,
		<-358.7,0,177.35>, <-0.514,0.858,0>
  }
  smooth_triangle { // #4537
		<-362.55,-5.65,179.8>, <-0.543,0.84,0>,
		<-362.55,0,179.8>, <-0.537,0.843,0>,
		<-358.7,-5.65,177.35>, <-0.523,0.853,0>
  }
  smooth_triangle { // #4538
		<-358.7,0,177.35>, <-0.514,0.858,0>,
		<-358.7,-5.65,177.35>, <-0.523,0.853,0>,
		<-362.55,0,179.8>, <-0.537,0.843,0>
  }
  smooth_triangle { // #4539
		<-366.45,-5.65,182.35>, <-0.561,0.828,0>,
		<-366.45,0,182.35>, <-0.555,0.832,0>,
		<-362.55,-5.65,179.8>, <-0.543,0.84,0>
  }
  smooth_triangle { // #4540
		<-362.55,0,179.8>, <-0.537,0.843,0>,
		<-362.55,-5.65,179.8>, <-0.543,0.84,0>,
		<-366.45,0,182.35>, <-0.555,0.832,0>
  }
  smooth_triangle { // #4541
		<-370.35,-5.65,185>, <-0.577,0.817,0>,
		<-370.35,0,185>, <-0.572,0.82,0>,
		<-366.45,-5.65,182.35>, <-0.561,0.828,0>
  }
  smooth_triangle { // #4542
		<-366.45,0,182.35>, <-0.555,0.832,0>,
		<-366.45,-5.65,182.35>, <-0.561,0.828,0>,
		<-370.35,0,185>, <-0.572,0.82,0>
  }
  smooth_triangle { // #4543
		<-374.25,-5.65,187.8>, <-0.593,0.805,0>,
		<-374.25,0,187.8>, <-0.588,0.809,0>,
		<-370.35,-5.65,185>, <-0.577,0.817,0>
  }
  smooth_triangle { // #4544
		<-370.35,0,185>, <-0.572,0.82,0>,
		<-370.35,-5.65,185>, <-0.577,0.817,0>,
		<-374.25,0,187.8>, <-0.588,0.809,0>
  }
  triangle { // #4545
		<-378.15,-5.65,190.75>,
		<-378.15,0,190.75>,
		<-374.25,-5.65,187.8>
  }
  smooth_triangle { // #4546
		<-374.25,0,187.8>, <-0.588,0.809,0>,
		<-374.25,-5.65,187.8>, <-0.593,0.805,0>,
		<-378.15,0,190.75>, <-0.603,0.798,0>
  }
  smooth_triangle { // #4547
		<-382.1,-5.65,193.8>, <-0.631,0.776,0>,
		<-382.1,0,193.8>, <-0.622,0.783,0>,
		<-378.15,-5.65,190.75>, <-0.608,0.794,0>
  }
  triangle { // #4548
		<-378.15,0,190.75>,
		<-378.15,-5.65,190.75>,
		<-382.1,0,193.8>
  }
  triangle { // #4549
		<-394.05,-5.65,203.75>,
		<-394.05,0,203.75>,
		<-382.1,-5.65,193.8>
  }
  triangle { // #4550
		<-382.1,0,193.8>,
		<-382.1,-5.65,193.8>,
		<-394.05,0,203.75>
  }
  smooth_triangle { // #4551
		<-398,-5.65,207.25>, <-0.677,0.736,0>,
		<-398,0,207.25>, <-0.672,0.741,0>,
		<-394.05,-5.65,203.75>, <-0.657,0.754,0>
  }
  smooth_triangle { // #4552
		<-394.05,0,203.75>, <-0.648,0.761,0>,
		<-394.05,-5.65,203.75>, <-0.657,0.754,0>,
		<-398,0,207.25>, <-0.672,0.741,0>
  }
  smooth_triangle { // #4553
		<-401.9,-5.65,210.85>, <-0.693,0.721,0>,
		<-401.9,0,210.85>, <-0.688,0.726,0>,
		<-398,-5.65,207.25>, <-0.677,0.736,0>
  }
  smooth_triangle { // #4554
		<-398,0,207.25>, <-0.672,0.741,0>,
		<-398,-5.65,207.25>, <-0.677,0.736,0>,
		<-401.9,0,210.85>, <-0.688,0.726,0>
  }
  smooth_triangle { // #4555
		<-405.65,-5.65,214.55>, <-0.709,0.705,0>,
		<-405.65,0,214.55>, <-0.704,0.71,0>,
		<-401.9,-5.65,210.85>, <-0.693,0.721,0>
  }
  smooth_triangle { // #4556
		<-401.9,0,210.85>, <-0.688,0.726,0>,
		<-401.9,-5.65,210.85>, <-0.693,0.721,0>,
		<-405.65,0,214.55>, <-0.704,0.71,0>
  }
  smooth_triangle { // #4557
		<-409.3,-5.65,218.25>, <-0.725,0.689,0>,
		<-409.3,0,218.25>, <-0.72,0.694,0>,
		<-405.65,-5.65,214.55>, <-0.709,0.705,0>
  }
  smooth_triangle { // #4558
		<-405.65,0,214.55>, <-0.704,0.71,0>,
		<-405.65,-5.65,214.55>, <-0.709,0.705,0>,
		<-409.3,0,218.25>, <-0.72,0.694,0>
  }
  smooth_triangle { // #4559
		<-412.85,-5.65,222.05>, <-0.74,0.672,0>,
		<-412.85,0,222.05>, <-0.735,0.678,0>,
		<-409.3,-5.65,218.25>, <-0.725,0.689,0>
  }
  smooth_triangle { // #4560
		<-409.3,0,218.25>, <-0.72,0.694,0>,
		<-409.3,-5.65,218.25>, <-0.725,0.689,0>,
		<-412.85,0,222.05>, <-0.735,0.678,0>
  }
  smooth_triangle { // #4561
		<-416.3,-5.65,225.9>, <-0.755,0.655,0>,
		<-416.3,0,225.9>, <-0.75,0.661,0>,
		<-412.85,-5.65,222.05>, <-0.74,0.672,0>
  }
  smooth_triangle { // #4562
		<-412.85,0,222.05>, <-0.735,0.678,0>,
		<-412.85,-5.65,222.05>, <-0.74,0.672,0>,
		<-416.3,0,225.9>, <-0.75,0.661,0>
  }
  smooth_triangle { // #4563
		<-419.65,-5.65,229.85>, <-0.77,0.638,0>,
		<-419.65,0,229.85>, <-0.765,0.644,0>,
		<-416.3,-5.65,225.9>, <-0.755,0.655,0>
  }
  smooth_triangle { // #4564
		<-416.3,0,225.9>, <-0.75,0.661,0>,
		<-416.3,-5.65,225.9>, <-0.755,0.655,0>,
		<-419.65,0,229.85>, <-0.765,0.644,0>
  }
  smooth_triangle { // #4565
		<-422.9,-5.65,233.85>, <-0.785,0.62,0>,
		<-422.9,0,233.85>, <-0.78,0.626,0>,
		<-419.65,-5.65,229.85>, <-0.77,0.638,0>
  }
  smooth_triangle { // #4566
		<-419.65,0,229.85>, <-0.765,0.644,0>,
		<-419.65,-5.65,229.85>, <-0.77,0.638,0>,
		<-422.9,0,233.85>, <-0.78,0.626,0>
  }
  smooth_triangle { // #4567
		<-426.05,-5.65,237.9>, <-0.799,0.601,0>,
		<-426.05,0,237.9>, <-0.794,0.607,0>,
		<-422.9,-5.65,233.85>, <-0.785,0.62,0>
  }
  smooth_triangle { // #4568
		<-422.9,0,233.85>, <-0.78,0.626,0>,
		<-422.9,-5.65,233.85>, <-0.785,0.62,0>,
		<-426.05,0,237.9>, <-0.794,0.607,0>
  }
  smooth_triangle { // #4569
		<-429.1,-5.65,242.05>, <-0.813,0.582,0>,
		<-429.1,0,242.05>, <-0.808,0.589,0>,
		<-426.05,-5.65,237.9>, <-0.799,0.601,0>
  }
  smooth_triangle { // #4570
		<-426.05,0,237.9>, <-0.794,0.607,0>,
		<-426.05,-5.65,237.9>, <-0.799,0.601,0>,
		<-429.1,0,242.05>, <-0.808,0.589,0>
  }
  smooth_triangle { // #4571
		<-432.05,-5.65,246.2>, <-0.826,0.563,0>,
		<-432.05,0,246.2>, <-0.822,0.57,0>,
		<-429.1,-5.65,242.05>, <-0.813,0.582,0>
  }
  smooth_triangle { // #4572
		<-429.1,0,242.05>, <-0.808,0.589,0>,
		<-429.1,-5.65,242.05>, <-0.813,0.582,0>,
		<-432.05,0,246.2>, <-0.822,0.57,0>
  }
  smooth_triangle { // #4573
		<-434.95,-5.65,250.45>, <-0.839,0.544,0>,
		<-434.95,0,250.45>, <-0.835,0.55,0>,
		<-432.05,-5.65,246.2>, <-0.826,0.563,0>
  }
  smooth_triangle { // #4574
		<-432.05,0,246.2>, <-0.822,0.57,0>,
		<-432.05,-5.65,246.2>, <-0.826,0.563,0>,
		<-434.95,0,250.45>, <-0.835,0.55,0>
  }
  smooth_triangle { // #4575
		<-437.7,-5.65,254.8>, <-0.86,0.511,0>,
		<-437.7,0,254.8>, <-0.852,0.524,0>,
		<-434.95,-5.65,250.45>, <-0.839,0.544,0>
  }
  smooth_triangle { // #4576
		<-434.95,0,250.45>, <-0.835,0.55,0>,
		<-434.95,-5.65,250.45>, <-0.839,0.544,0>,
		<-437.7,0,254.8>, <-0.852,0.524,0>
  }
  triangle { // #4577
		<-445.35,-5.65,268.15>,
		<-445.35,0,268.15>,
		<-437.7,-5.65,254.8>
  }
  triangle { // #4578
		<-437.7,0,254.8>,
		<-437.7,-5.65,254.8>,
		<-445.35,0,268.15>
  }
  triangle { // #4579
		<-596.75,-99,323.8>,
		<-880.45,-99,465.7>,
		<-880.45,-99,321.95>
  }
  triangle { // #4580
		<-864.05,-99,689.7>,
		<-500.7,-99,403.65>,
		<-506.35,-99,754.45>
  }
  triangle { // #4581
		<-880.45,-99,465.7>,
		<-500.7,-99,403.65>,
		<-864.05,-99,689.7>
  }
  triangle { // #4582
		<-880.45,-99,465.7>,
		<-596.75,-99,323.8>,
		<-500.7,-99,403.65>
  }
  triangle { // #4583
		<-880.45,-79.2,465.7>,
		<-596.75,-79.2,323.8>,
		<-880.45,-79.2,321.95>
  }
  triangle { // #4584
		<-500.7,-79.2,403.65>,
		<-864.05,-79.2,689.7>,
		<-506.35,-79.2,754.45>
  }
  triangle { // #4585
		<-500.7,-79.2,403.65>,
		<-880.45,-79.2,465.7>,
		<-864.05,-79.2,689.7>
  }
  triangle { // #4586
		<-596.75,-79.2,323.8>,
		<-880.45,-79.2,465.7>,
		<-500.7,-79.2,403.65>
  }
  smooth_triangle { // #4587
		<-596.75,-99,323.8>, <0.452,0.892,0>,
		<-500.7,-79.2,403.65>, <0.639,0.769,0>,
		<-500.7,-99,403.65>, <0.639,0.769,0>
  }
  smooth_triangle { // #4588
		<-500.7,-79.2,403.65>, <0.639,0.769,0>,
		<-596.75,-99,323.8>, <0.452,0.892,0>,
		<-596.75,-79.2,323.8>, <0.229,0.973,0>
  }
  triangle { // #4589
		<-500.7,-99,403.65>,
		<-506.35,-79.2,754.45>,
		<-506.35,-99,754.45>
  }
  triangle { // #4590
		<-506.35,-79.2,754.45>,
		<-500.7,-99,403.65>,
		<-500.7,-79.2,403.65>
  }
  triangle { // #4591
		<-506.35,-99,754.45>,
		<-864.05,-79.2,689.7>,
		<-864.05,-99,689.7>
  }
  triangle { // #4592
		<-864.05,-79.2,689.7>,
		<-506.35,-99,754.45>,
		<-506.35,-79.2,754.45>
  }
  smooth_triangle { // #4593
		<-864.05,-99,689.7>, <-0.997,-0.073,0>,
		<-880.45,-79.2,465.7>, <-0.999,-0.049,0>,
		<-880.45,-99,465.7>, <-1,-0.024,0>
  }
  smooth_triangle { // #4594
		<-880.45,-79.2,465.7>, <-0.999,-0.049,0>,
		<-864.05,-99,689.7>, <-0.997,-0.073,0>,
		<-864.05,-79.2,689.7>, <-0.997,-0.073,0>
  }
  smooth_triangle { // #4595
		<-880.45,-99,465.7>, <-1,-0.024,0>,
		<-880.45,-79.2,321.95>, <-1,0,0>,
		<-880.45,-99,321.95>, <-1,0,0>
  }
  smooth_triangle { // #4596
		<-880.45,-79.2,321.95>, <-1,0,0>,
		<-880.45,-99,465.7>, <-1,-0.024,0>,
		<-880.45,-79.2,465.7>, <-0.999,-0.049,0>
  }
  triangle { // #4597
		<-880.45,-99,321.95>,
		<-596.75,-79.2,323.8>,
		<-596.75,-99,323.8>
  }
  triangle { // #4598
		<-596.75,-79.2,323.8>,
		<-880.45,-99,321.95>,
		<-880.45,-79.2,321.95>
  }
  triangle { // #4599
		<477.35,-99,206.25>,
		<357.6,-99,260.25>,
		<756.45,-99,339.55>
  }
  triangle { // #4600
		<-498.35,-99,208.75>,
		<-641.65,-99,865.1>,
		<-374.15,-99,262.15>
  }
  triangle { // #4601
		<-641.65,-99,865.1>,
		<-65.8,-99,1043.6>,
		<-374.15,-99,262.15>
  }
  triangle { // #4602
		<-374.15,-99,262.15>,
		<-65.8,-99,1043.6>,
		<-250.65,-99,300.2>
  }
  triangle { // #4603
		<-250.65,-99,300.2>,
		<-65.8,-99,1043.6>,
		<-127.75,-99,322.9>
  }
  triangle { // #4604
		<-127.75,-99,322.9>,
		<-65.8,-99,1043.6>,
		<-5.45,-99,330.25>
  }
  triangle { // #4605
		<-65.8,-99,1043.6>,
		<492.4,-99,960.65>,
		<-5.45,-99,330.25>
  }
  triangle { // #4606
		<-5.45,-99,330.25>,
		<492.4,-99,960.65>,
		<116.2,-99,322.25>
  }
  triangle { // #4607
		<116.2,-99,322.25>,
		<492.4,-99,960.65>,
		<237.2,-99,298.95>
  }
  triangle { // #4608
		<492.4,-99,960.65>,
		<857.05,-99,636.25>,
		<237.2,-99,298.95>
  }
  triangle { // #4609
		<857.05,-99,636.25>,
		<756.45,-99,339.55>,
		<237.2,-99,298.95>
  }
  triangle { // #4610
		<237.2,-99,298.95>,
		<756.45,-99,339.55>,
		<357.6,-99,260.25>
  }
  triangle { // #4611
		<477.35,-118.8,206.25>,
		<756.45,-118.8,339.55>,
		<357.6,-118.8,260.25>
  }
  triangle { // #4612
		<-498.35,-118.8,208.75>,
		<-374.15,-118.8,262.15>,
		<-641.65,-118.8,865.1>
  }
  triangle { // #4613
		<-641.65,-118.8,865.1>,
		<-374.15,-118.8,262.15>,
		<-65.8,-118.8,1043.6>
  }
  triangle { // #4614
		<-374.15,-118.8,262.15>,
		<-250.65,-118.8,300.2>,
		<-65.8,-118.8,1043.6>
  }
  triangle { // #4615
		<-250.65,-118.8,300.2>,
		<-127.75,-118.8,322.9>,
		<-65.8,-118.8,1043.6>
  }
  triangle { // #4616
		<-127.75,-118.8,322.9>,
		<-5.45,-118.8,330.25>,
		<-65.8,-118.8,1043.6>
  }
  triangle { // #4617
		<-65.8,-118.8,1043.6>,
		<-5.45,-118.8,330.25>,
		<492.4,-118.8,960.65>
  }
  triangle { // #4618
		<-5.45,-118.8,330.25>,
		<116.2,-118.8,322.25>,
		<492.4,-118.8,960.65>
  }
  triangle { // #4619
		<116.2,-118.8,322.25>,
		<237.2,-118.8,298.95>,
		<492.4,-118.8,960.65>
  }
  triangle { // #4620
		<492.4,-118.8,960.65>,
		<237.2,-118.8,298.95>,
		<857.05,-118.8,636.25>
  }
  triangle { // #4621
		<857.05,-118.8,636.25>,
		<237.2,-118.8,298.95>,
		<756.45,-118.8,339.55>
  }
  triangle { // #4622
		<237.2,-118.8,298.95>,
		<357.6,-118.8,260.25>,
		<756.45,-118.8,339.55>
  }
  triangle { // #4623
		<-498.35,-99,208.75>,
		<-498.35,-118.8,208.75>,
		<-641.65,-99,865.1>
  }
  triangle { // #4624
		<-641.65,-118.8,865.1>,
		<-641.65,-99,865.1>,
		<-498.35,-118.8,208.75>
  }
  smooth_triangle { // #4625
		<-498.35,-99,208.75>, <0.395,0.919,0>,
		<-374.15,-99,262.15>, <0.362,0.932,0>,
		<-498.35,-118.8,208.75>, <0.395,0.919,0>
  }
  smooth_triangle { // #4626
		<477.35,-99,206.25>, <-0.411,0.912,0>,
		<477.35,-118.8,206.25>, <-0.411,0.912,0>,
		<357.6,-99,260.25>, <-0.359,0.933,0>
  }
  smooth_triangle { // #4627
		<477.35,-118.8,206.25>, <-0.411,0.912,0>,
		<357.6,-118.8,260.25>, <-0.359,0.933,0>,
		<357.6,-99,260.25>, <-0.359,0.933,0>
  }
  smooth_triangle { // #4628
		<357.6,-118.8,260.25>, <-0.359,0.933,0>,
		<237.2,-118.8,298.95>, <-0.267,0.964,0>,
		<357.6,-99,260.25>, <-0.359,0.933,0>
  }
  smooth_triangle { // #4629
		<357.6,-99,260.25>, <-0.359,0.933,0>,
		<237.2,-118.8,298.95>, <-0.267,0.964,0>,
		<237.2,-99,298.95>, <-0.229,0.974,0>
  }
  smooth_triangle { // #4630
		<237.2,-118.8,298.95>, <-0.267,0.964,0>,
		<116.2,-118.8,322.25>, <-0.148,0.989,0>,
		<237.2,-99,298.95>, <-0.229,0.974,0>
  }
  smooth_triangle { // #4631
		<237.2,-99,298.95>, <-0.229,0.974,0>,
		<116.2,-118.8,322.25>, <-0.148,0.989,0>,
		<116.2,-99,322.25>, <-0.107,0.994,0>
  }
  smooth_triangle { // #4632
		<116.2,-118.8,322.25>, <-0.148,0.989,0>,
		<-5.45,-118.8,330.25>, <-0.024,1,0>,
		<116.2,-99,322.25>, <-0.107,0.994,0>
  }
  smooth_triangle { // #4633
		<116.2,-99,322.25>, <-0.107,0.994,0>,
		<-5.45,-118.8,330.25>, <-0.024,1,0>,
		<-5.45,-99,330.25>, <0.018,1,0>
  }
  smooth_triangle { // #4634
		<-5.45,-118.8,330.25>, <-0.024,1,0>,
		<-127.75,-118.8,322.9>, <0.101,0.995,0>,
		<-5.45,-99,330.25>, <0.018,1,0>
  }
  smooth_triangle { // #4635
		<-5.45,-99,330.25>, <0.018,1,0>,
		<-127.75,-118.8,322.9>, <0.101,0.995,0>,
		<-127.75,-99,322.9>, <0.141,0.99,0>
  }
  smooth_triangle { // #4636
		<-127.75,-118.8,322.9>, <0.101,0.995,0>,
		<-250.65,-118.8,300.2>, <0.22,0.976,0>,
		<-127.75,-99,322.9>, <0.141,0.99,0>
  }
  smooth_triangle { // #4637
		<-127.75,-99,322.9>, <0.141,0.99,0>,
		<-250.65,-118.8,300.2>, <0.22,0.976,0>,
		<-250.65,-99,300.2>, <0.257,0.966,0>
  }
  smooth_triangle { // #4638
		<-250.65,-118.8,300.2>, <0.22,0.976,0>,
		<-374.15,-118.8,262.15>, <0.328,0.945,0>,
		<-250.65,-99,300.2>, <0.257,0.966,0>
  }
  smooth_triangle { // #4639
		<-250.65,-99,300.2>, <0.257,0.966,0>,
		<-374.15,-118.8,262.15>, <0.328,0.945,0>,
		<-374.15,-99,262.15>, <0.362,0.932,0>
  }
  smooth_triangle { // #4640
		<-374.15,-118.8,262.15>, <0.328,0.945,0>,
		<-498.35,-118.8,208.75>, <0.395,0.919,0>,
		<-374.15,-99,262.15>, <0.362,0.932,0>
  }
  triangle { // #4641
		<756.45,-99,339.55>,
		<756.45,-118.8,339.55>,
		<477.35,-99,206.25>
  }
  triangle { // #4642
		<477.35,-118.8,206.25>,
		<477.35,-99,206.25>,
		<756.45,-118.8,339.55>
  }
  triangle { // #4643
		<857.05,-99,636.25>,
		<857.05,-118.8,636.25>,
		<756.45,-99,339.55>
  }
  triangle { // #4644
		<756.45,-118.8,339.55>,
		<756.45,-99,339.55>,
		<857.05,-118.8,636.25>
  }
  smooth_triangle { // #4645
		<492.4,-99,960.65>, <0.332,-0.943,0>,
		<492.4,-118.8,960.65>, <0.511,-0.86,0>,
		<857.05,-99,636.25>, <0.665,-0.747,0>
  }
  smooth_triangle { // #4646
		<857.05,-118.8,636.25>, <0.665,-0.747,0>,
		<857.05,-99,636.25>, <0.665,-0.747,0>,
		<492.4,-118.8,960.65>, <0.511,-0.86,0>
  }
  smooth_triangle { // #4647
		<-65.8,-99,1043.6>, <-0.152,-0.988,0>,
		<-65.8,-118.8,1043.6>, <-0.001,-1,0>,
		<492.4,-99,960.65>, <0.332,-0.943,0>
  }
  smooth_triangle { // #4648
		<492.4,-118.8,960.65>, <0.511,-0.86,0>,
		<492.4,-99,960.65>, <0.332,-0.943,0>,
		<-65.8,-118.8,1043.6>, <-0.001,-1,0>
  }
  smooth_triangle { // #4649
		<-641.65,-99,865.1>, <-0.296,-0.955,0>,
		<-641.65,-118.8,865.1>, <-0.296,-0.955,0>,
		<-65.8,-99,1043.6>, <-0.152,-0.988,0>
  }
  smooth_triangle { // #4650
		<-65.8,-118.8,1043.6>, <-0.001,-1,0>,
		<-65.8,-99,1043.6>, <-0.152,-0.988,0>,
		<-641.65,-118.8,865.1>, <-0.296,-0.955,0>
  }
  triangle { // #4651
		<-852.9,214.7,1154.25>,
		<-639.75,214.7,1446.3>,
		<-852.9,214.7,1375.55>
  }
  triangle { // #4652
		<852,214.7,1139.15>,
		<613.25,214.7,1098.55>,
		<817.7,214.7,1022.4>
  }
  triangle { // #4653
		<-611.1,214.7,1098.55>,
		<-852.9,214.7,1154.25>,
		<-814.75,214.7,1022.4>
  }
  triangle { // #4654
		<852,214.7,1362.9>,
		<613.25,214.7,1098.55>,
		<852,214.7,1139.15>
  }
  triangle { // #4655
		<638.9,214.7,1436.8>,
		<613.25,214.7,1098.55>,
		<852,214.7,1362.9>
  }
  triangle { // #4656
		<638.9,214.7,1436.8>,
		<408.9,214.7,1152.95>,
		<613.25,214.7,1098.55>
  }
  triangle { // #4657
		<425.8,214.7,1490.05>,
		<408.9,214.7,1152.95>,
		<638.9,214.7,1436.8>
  }
  triangle { // #4658
		<425.8,214.7,1490.05>,
		<204.65,214.7,1185.55>,
		<408.9,214.7,1152.95>
  }
  triangle { // #4659
		<212.7,214.7,1522.65>,
		<204.65,214.7,1185.55>,
		<425.8,214.7,1490.05>
  }
  triangle { // #4660
		<212.7,214.7,1522.65>,
		<0.5,214.7,1196.45>,
		<204.65,214.7,1185.55>
  }
  triangle { // #4661
		<-0.45,214.7,1534.55>,
		<0.5,214.7,1196.45>,
		<212.7,214.7,1522.65>
  }
  triangle { // #4662
		<-213.55,214.7,1525.8>,
		<0.5,214.7,1196.45>,
		<-0.45,214.7,1534.55>
  }
  triangle { // #4663
		<-213.55,214.7,1525.8>,
		<-203.45,214.7,1185.55>,
		<0.5,214.7,1196.45>
  }
  triangle { // #4664
		<-426.65,214.7,1496.4>,
		<-203.45,214.7,1185.55>,
		<-213.55,214.7,1525.8>
  }
  triangle { // #4665
		<-426.65,214.7,1496.4>,
		<-407.35,214.7,1152.95>,
		<-203.45,214.7,1185.55>
  }
  triangle { // #4666
		<-639.75,214.7,1446.3>,
		<-407.35,214.7,1152.95>,
		<-426.65,214.7,1496.4>
  }
  triangle { // #4667
		<-639.75,214.7,1446.3>,
		<-611.1,214.7,1098.55>,
		<-407.35,214.7,1152.95>
  }
  triangle { // #4668
		<-639.75,214.7,1446.3>,
		<-852.9,214.7,1154.25>,
		<-611.1,214.7,1098.55>
  }
  triangle { // #4669
		<-639.75,241.7,1446.3>,
		<-852.9,241.7,1154.25>,
		<-852.9,241.7,1375.55>
  }
  triangle { // #4670
		<613.25,241.7,1098.55>,
		<852,241.7,1139.15>,
		<817.7,241.7,1022.4>
  }
  triangle { // #4671
		<-852.9,241.7,1154.25>,
		<-611.1,241.7,1098.55>,
		<-814.75,241.7,1022.4>
  }
  triangle { // #4672
		<613.25,241.7,1098.55>,
		<852,241.7,1362.9>,
		<852,241.7,1139.15>
  }
  triangle { // #4673
		<613.25,241.7,1098.55>,
		<638.9,241.7,1436.8>,
		<852,241.7,1362.9>
  }
  triangle { // #4674
		<408.9,241.7,1152.95>,
		<638.9,241.7,1436.8>,
		<613.25,241.7,1098.55>
  }
  triangle { // #4675
		<408.9,241.7,1152.95>,
		<425.8,241.7,1490.05>,
		<638.9,241.7,1436.8>
  }
  triangle { // #4676
		<204.65,241.7,1185.55>,
		<425.8,241.7,1490.05>,
		<408.9,241.7,1152.95>
  }
  triangle { // #4677
		<204.65,241.7,1185.55>,
		<212.7,241.7,1522.65>,
		<425.8,241.7,1490.05>
  }
  triangle { // #4678
		<0.5,241.7,1196.45>,
		<212.7,241.7,1522.65>,
		<204.65,241.7,1185.55>
  }
  triangle { // #4679
		<0.5,241.7,1196.45>,
		<-0.45,241.7,1534.55>,
		<212.7,241.7,1522.65>
  }
  triangle { // #4680
		<0.5,241.7,1196.45>,
		<-213.55,241.7,1525.8>,
		<-0.45,241.7,1534.55>
  }
  triangle { // #4681
		<-203.45,241.7,1185.55>,
		<-213.55,241.7,1525.8>,
		<0.5,241.7,1196.45>
  }
  triangle { // #4682
		<-203.45,241.7,1185.55>,
		<-426.65,241.7,1496.4>,
		<-213.55,241.7,1525.8>
  }
  triangle { // #4683
		<-407.35,241.7,1152.95>,
		<-426.65,241.7,1496.4>,
		<-203.45,241.7,1185.55>
  }
  triangle { // #4684
		<-407.35,241.7,1152.95>,
		<-639.75,241.7,1446.3>,
		<-426.65,241.7,1496.4>
  }
  triangle { // #4685
		<-611.1,241.7,1098.55>,
		<-639.75,241.7,1446.3>,
		<-407.35,241.7,1152.95>
  }
  triangle { // #4686
		<-852.9,241.7,1154.25>,
		<-639.75,241.7,1446.3>,
		<-611.1,241.7,1098.55>
  }
  smooth_triangle { // #4687
		<852,241.7,1362.9>, <0.328,-0.945,0>,
		<638.9,214.7,1436.8>, <0.3,-0.954,0>,
		<852,214.7,1362.9>, <0.328,-0.945,0>
  }
  smooth_triangle { // #4688
		<-639.75,214.7,1446.3>, <-0.272,-0.962,0>,
		<-852.9,241.7,1375.55>, <-0.315,-0.949,0>,
		<-852.9,214.7,1375.55>, <-0.315,-0.949,0>
  }
  smooth_triangle { // #4689
		<-639.75,214.7,1446.3>, <-0.272,-0.962,0>,
		<-639.75,241.7,1446.3>, <-0.272,-0.962,0>,
		<-852.9,241.7,1375.55>, <-0.315,-0.949,0>
  }
  smooth_triangle { // #4690
		<-639.75,214.7,1446.3>, <-0.272,-0.962,0>,
		<-426.65,241.7,1496.4>, <-0.198,-0.98,0>,
		<-639.75,241.7,1446.3>, <-0.272,-0.962,0>
  }
  smooth_triangle { // #4691
		<-426.65,214.7,1496.4>, <-0.168,-0.986,0>,
		<-426.65,241.7,1496.4>, <-0.198,-0.98,0>,
		<-639.75,214.7,1446.3>, <-0.272,-0.962,0>
  }
  smooth_triangle { // #4692
		<-426.65,214.7,1496.4>, <-0.168,-0.986,0>,
		<-213.55,241.7,1525.8>, <-0.105,-0.994,0>,
		<-426.65,241.7,1496.4>, <-0.198,-0.98,0>
  }
  smooth_triangle { // #4693
		<-213.55,214.7,1525.8>, <-0.073,-0.997,0>,
		<-213.55,241.7,1525.8>, <-0.105,-0.994,0>,
		<-426.65,214.7,1496.4>, <-0.168,-0.986,0>
  }
  smooth_triangle { // #4694
		<-213.55,214.7,1525.8>, <-0.073,-0.997,0>,
		<-0.45,241.7,1534.55>, <-0.009,-1,0>,
		<-213.55,241.7,1525.8>, <-0.105,-0.994,0>
  }
  smooth_triangle { // #4695
		<-0.45,214.7,1534.55>, <0.024,-1,0>,
		<-0.45,241.7,1534.55>, <-0.009,-1,0>,
		<-213.55,214.7,1525.8>, <-0.073,-0.997,0>
  }
  smooth_triangle { // #4696
		<-0.45,214.7,1534.55>, <0.024,-1,0>,
		<212.7,241.7,1522.65>, <0.088,-0.996,0>,
		<-0.45,241.7,1534.55>, <-0.009,-1,0>
  }
  smooth_triangle { // #4697
		<212.7,214.7,1522.65>, <0.12,-0.993,0>,
		<212.7,241.7,1522.65>, <0.088,-0.996,0>,
		<-0.45,214.7,1534.55>, <0.024,-1,0>
  }
  smooth_triangle { // #4698
		<212.7,214.7,1522.65>, <0.12,-0.993,0>,
		<425.8,241.7,1490.05>, <0.182,-0.983,0>,
		<212.7,241.7,1522.65>, <0.088,-0.996,0>
  }
  smooth_triangle { // #4699
		<425.8,214.7,1490.05>, <0.212,-0.977,0>,
		<425.8,241.7,1490.05>, <0.182,-0.983,0>,
		<212.7,214.7,1522.65>, <0.12,-0.993,0>
  }
  smooth_triangle { // #4700
		<425.8,214.7,1490.05>, <0.212,-0.977,0>,
		<638.9,241.7,1436.8>, <0.271,-0.963,0>,
		<425.8,241.7,1490.05>, <0.182,-0.983,0>
  }
  smooth_triangle { // #4701
		<638.9,214.7,1436.8>, <0.3,-0.954,0>,
		<638.9,241.7,1436.8>, <0.271,-0.963,0>,
		<425.8,214.7,1490.05>, <0.212,-0.977,0>
  }
  smooth_triangle { // #4702
		<638.9,214.7,1436.8>, <0.3,-0.954,0>,
		<852,241.7,1362.9>, <0.328,-0.945,0>,
		<638.9,241.7,1436.8>, <0.271,-0.963,0>
  }
  smooth_triangle { // #4703
		<-852.9,214.7,1375.55>, <-1,0,0>,
		<-852.9,241.7,1154.25>, <-0.996,0.093,0>,
		<-852.9,214.7,1154.25>, <-0.982,0.187,0>
  }
  smooth_triangle { // #4704
		<-852.9,241.7,1154.25>, <-0.996,0.093,0>,
		<-852.9,214.7,1375.55>, <-1,0,0>,
		<-852.9,241.7,1375.55>, <-1,0,0>
  }
  smooth_triangle { // #4705
		<-852.9,214.7,1154.25>, <-0.982,0.187,0>,
		<-814.75,241.7,1022.4>, <-0.961,0.278,0>,
		<-814.75,214.7,1022.4>, <-0.961,0.278,0>
  }
  smooth_triangle { // #4706
		<-814.75,241.7,1022.4>, <-0.961,0.278,0>,
		<-852.9,214.7,1154.25>, <-0.982,0.187,0>,
		<-852.9,241.7,1154.25>, <-0.996,0.093,0>
  }
  smooth_triangle { // #4707
		<-814.75,241.7,1022.4>, <0.35,0.937,0>,
		<-611.1,214.7,1098.55>, <0.32,0.947,0>,
		<-814.75,214.7,1022.4>, <0.35,0.937,0>
  }
  smooth_triangle { // #4708
		<613.25,214.7,1098.55>, <-0.303,0.953,0>,
		<817.7,241.7,1022.4>, <-0.349,0.937,0>,
		<817.7,214.7,1022.4>, <-0.349,0.937,0>
  }
  smooth_triangle { // #4709
		<613.25,214.7,1098.55>, <-0.303,0.953,0>,
		<613.25,241.7,1098.55>, <-0.303,0.953,0>,
		<817.7,241.7,1022.4>, <-0.349,0.937,0>
  }
  smooth_triangle { // #4710
		<613.25,214.7,1098.55>, <-0.303,0.953,0>,
		<408.9,241.7,1152.95>, <-0.224,0.975,0>,
		<613.25,241.7,1098.55>, <-0.303,0.953,0>
  }
  smooth_triangle { // #4711
		<408.9,214.7,1152.95>, <-0.191,0.982,0>,
		<408.9,241.7,1152.95>, <-0.224,0.975,0>,
		<613.25,214.7,1098.55>, <-0.303,0.953,0>
  }
  smooth_triangle { // #4712
		<408.9,214.7,1152.95>, <-0.191,0.982,0>,
		<204.65,241.7,1185.55>, <-0.123,0.992,0>,
		<408.9,241.7,1152.95>, <-0.224,0.975,0>
  }
  smooth_triangle { // #4713
		<204.65,214.7,1185.55>, <-0.088,0.996,0>,
		<204.65,241.7,1185.55>, <-0.123,0.992,0>,
		<408.9,214.7,1152.95>, <-0.191,0.982,0>
  }
  smooth_triangle { // #4714
		<204.65,214.7,1185.55>, <-0.088,0.996,0>,
		<0.5,241.7,1196.45>, <-0.018,1,0>,
		<204.65,241.7,1185.55>, <-0.123,0.992,0>
  }
  smooth_triangle { // #4715
		<0.5,214.7,1196.45>, <0.018,1,0>,
		<0.5,241.7,1196.45>, <-0.018,1,0>,
		<204.65,214.7,1185.55>, <-0.088,0.996,0>
  }
  smooth_triangle { // #4716
		<0.5,214.7,1196.45>, <0.018,1,0>,
		<-203.45,241.7,1185.55>, <0.088,0.996,0>,
		<0.5,241.7,1196.45>, <-0.018,1,0>
  }
  smooth_triangle { // #4717
		<-203.45,214.7,1185.55>, <0.123,0.992,0>,
		<-203.45,241.7,1185.55>, <0.088,0.996,0>,
		<0.5,214.7,1196.45>, <0.018,1,0>
  }
  smooth_triangle { // #4718
		<-203.45,214.7,1185.55>, <0.123,0.992,0>,
		<-407.35,241.7,1152.95>, <0.192,0.981,0>,
		<-203.45,241.7,1185.55>, <0.088,0.996,0>
  }
  smooth_triangle { // #4719
		<-407.35,214.7,1152.95>, <0.225,0.974,0>,
		<-407.35,241.7,1152.95>, <0.192,0.981,0>,
		<-203.45,214.7,1185.55>, <0.123,0.992,0>
  }
  smooth_triangle { // #4720
		<-407.35,214.7,1152.95>, <0.225,0.974,0>,
		<-611.1,241.7,1098.55>, <0.289,0.957,0>,
		<-407.35,241.7,1152.95>, <0.192,0.981,0>
  }
  smooth_triangle { // #4721
		<-611.1,214.7,1098.55>, <0.32,0.947,0>,
		<-611.1,241.7,1098.55>, <0.289,0.957,0>,
		<-407.35,214.7,1152.95>, <0.225,0.974,0>
  }
  smooth_triangle { // #4722
		<-611.1,214.7,1098.55>, <0.32,0.947,0>,
		<-814.75,241.7,1022.4>, <0.35,0.937,0>,
		<-611.1,241.7,1098.55>, <0.289,0.957,0>
  }
  smooth_triangle { // #4723
		<817.7,214.7,1022.4>, <0.959,0.282,0>,
		<852,241.7,1139.15>, <0.982,0.19,0>,
		<852,214.7,1139.15>, <0.995,0.095,0>
  }
  smooth_triangle { // #4724
		<852,241.7,1139.15>, <0.982,0.19,0>,
		<817.7,214.7,1022.4>, <0.959,0.282,0>,
		<817.7,241.7,1022.4>, <0.959,0.282,0>
  }
  smooth_triangle { // #4725
		<852,214.7,1139.15>, <0.995,0.095,0>,
		<852,241.7,1362.9>, <1,0,0>,
		<852,214.7,1362.9>, <1,0,0>
  }
  smooth_triangle { // #4726
		<852,241.7,1362.9>, <1,0,0>,
		<852,214.7,1139.15>, <0.995,0.095,0>,
		<852,241.7,1139.15>, <0.982,0.19,0>
  }
  triangle { // #4727
		<842.6,426.25,2077.1>,
		<631.95,426.25,1695.1>,
		<842.6,426.25,1632.05>
  }
  triangle { // #4728
		<-630.25,426.25,1695.1>,
		<-840.35,426.25,2064.55>,
		<-840.35,426.25,1632.05>
  }
  triangle { // #4729
		<-630.25,426.25,1695.1>,
		<842.6,426.25,2077.1>,
		<-840.35,426.25,2064.55>
  }
  triangle { // #4730
		<-420.1,426.25,1740.2>,
		<842.6,426.25,2077.1>,
		<-630.25,426.25,1695.1>
  }
  triangle { // #4731
		<-209.85,426.25,1767.2>,
		<842.6,426.25,2077.1>,
		<-420.1,426.25,1740.2>
  }
  triangle { // #4732
		<0.5,426.25,1776.25>,
		<842.6,426.25,2077.1>,
		<-209.85,426.25,1767.2>
  }
  triangle { // #4733
		<210.9,426.25,1767.2>,
		<842.6,426.25,2077.1>,
		<0.5,426.25,1776.25>
  }
  triangle { // #4734
		<421.4,426.25,1740.2>,
		<842.6,426.25,2077.1>,
		<210.9,426.25,1767.2>
  }
  triangle { // #4735
		<631.95,426.25,1695.1>,
		<842.6,426.25,2077.1>,
		<421.4,426.25,1740.2>
  }
  triangle { // #4736
		<631.95,486.9,1695.1>,
		<842.6,486.9,2077.1>,
		<842.6,486.9,1632.05>
  }
  triangle { // #4737
		<-840.35,486.9,2064.55>,
		<-630.25,486.9,1695.1>,
		<-840.35,486.9,1632.05>
  }
  triangle { // #4738
		<842.6,486.9,2077.1>,
		<-630.25,486.9,1695.1>,
		<-840.35,486.9,2064.55>
  }
  triangle { // #4739
		<842.6,486.9,2077.1>,
		<-420.1,486.9,1740.2>,
		<-630.25,486.9,1695.1>
  }
  triangle { // #4740
		<842.6,486.9,2077.1>,
		<-209.85,486.9,1767.2>,
		<-420.1,486.9,1740.2>
  }
  triangle { // #4741
		<842.6,486.9,2077.1>,
		<0.5,486.9,1776.25>,
		<-209.85,486.9,1767.2>
  }
  triangle { // #4742
		<842.6,486.9,2077.1>,
		<210.9,486.9,1767.2>,
		<0.5,486.9,1776.25>
  }
  triangle { // #4743
		<842.6,486.9,2077.1>,
		<421.4,486.9,1740.2>,
		<210.9,486.9,1767.2>
  }
  triangle { // #4744
		<842.6,486.9,2077.1>,
		<631.95,486.9,1695.1>,
		<421.4,486.9,1740.2>
  }
  triangle { // #4745
		<-840.35,426.25,2064.55>,
		<-840.35,486.9,1632.05>,
		<-840.35,426.25,1632.05>
  }
  triangle { // #4746
		<-840.35,486.9,1632.05>,
		<-840.35,426.25,2064.55>,
		<-840.35,486.9,2064.55>
  }
  smooth_triangle { // #4747
		<-840.35,486.9,1632.05>, <0.288,0.958,0>,
		<-630.25,426.25,1695.1>, <0.262,0.965,0>,
		<-840.35,426.25,1632.05>, <0.288,0.958,0>
  }
  smooth_triangle { // #4748
		<631.95,426.25,1695.1>, <-0.248,0.969,0>,
		<842.6,486.9,1632.05>, <-0.287,0.958,0>,
		<842.6,426.25,1632.05>, <-0.287,0.958,0>
  }
  smooth_triangle { // #4749
		<631.95,426.25,1695.1>, <-0.248,0.969,0>,
		<631.95,486.9,1695.1>, <-0.248,0.969,0>,
		<842.6,486.9,1632.05>, <-0.287,0.958,0>
  }
  smooth_triangle { // #4750
		<631.95,426.25,1695.1>, <-0.248,0.969,0>,
		<421.4,486.9,1740.2>, <-0.182,0.983,0>,
		<631.95,486.9,1695.1>, <-0.248,0.969,0>
  }
  smooth_triangle { // #4751
		<421.4,426.25,1740.2>, <-0.155,0.988,0>,
		<421.4,486.9,1740.2>, <-0.182,0.983,0>,
		<631.95,426.25,1695.1>, <-0.248,0.969,0>
  }
  smooth_triangle { // #4752
		<421.4,426.25,1740.2>, <-0.155,0.988,0>,
		<210.9,486.9,1767.2>, <-0.099,0.995,0>,
		<421.4,486.9,1740.2>, <-0.182,0.983,0>
  }
  smooth_triangle { // #4753
		<210.9,426.25,1767.2>, <-0.071,0.997,0>,
		<210.9,486.9,1767.2>, <-0.099,0.995,0>,
		<421.4,426.25,1740.2>, <-0.155,0.988,0>
  }
  smooth_triangle { // #4754
		<210.9,426.25,1767.2>, <-0.071,0.997,0>,
		<0.5,486.9,1776.25>, <-0.014,1,0>,
		<210.9,486.9,1767.2>, <-0.099,0.995,0>
  }
  smooth_triangle { // #4755
		<0.5,426.25,1776.25>, <0.014,1,0>,
		<0.5,486.9,1776.25>, <-0.014,1,0>,
		<210.9,426.25,1767.2>, <-0.071,0.997,0>
  }
  smooth_triangle { // #4756
		<0.5,426.25,1776.25>, <0.014,1,0>,
		<-209.85,486.9,1767.2>, <0.071,0.997,0>,
		<0.5,486.9,1776.25>, <-0.014,1,0>
  }
  smooth_triangle { // #4757
		<-209.85,426.25,1767.2>, <0.099,0.995,0>,
		<-209.85,486.9,1767.2>, <0.071,0.997,0>,
		<0.5,426.25,1776.25>, <0.014,1,0>
  }
  smooth_triangle { // #4758
		<-209.85,426.25,1767.2>, <0.099,0.995,0>,
		<-420.1,486.9,1740.2>, <0.155,0.988,0>,
		<-209.85,486.9,1767.2>, <0.071,0.997,0>
  }
  smooth_triangle { // #4759
		<-420.1,426.25,1740.2>, <0.182,0.983,0>,
		<-420.1,486.9,1740.2>, <0.155,0.988,0>,
		<-209.85,426.25,1767.2>, <0.099,0.995,0>
  }
  smooth_triangle { // #4760
		<-420.1,426.25,1740.2>, <0.182,0.983,0>,
		<-630.25,486.9,1695.1>, <0.236,0.972,0>,
		<-420.1,486.9,1740.2>, <0.155,0.988,0>
  }
  smooth_triangle { // #4761
		<-630.25,426.25,1695.1>, <0.262,0.965,0>,
		<-630.25,486.9,1695.1>, <0.236,0.972,0>,
		<-420.1,426.25,1740.2>, <0.182,0.983,0>
  }
  smooth_triangle { // #4762
		<-630.25,426.25,1695.1>, <0.262,0.965,0>,
		<-840.35,486.9,1632.05>, <0.288,0.958,0>,
		<-630.25,486.9,1695.1>, <0.236,0.972,0>
  }
  triangle { // #4763
		<842.6,426.25,1632.05>,
		<842.6,486.9,2077.1>,
		<842.6,426.25,2077.1>
  }
  triangle { // #4764
		<842.6,486.9,2077.1>,
		<842.6,426.25,1632.05>,
		<842.6,486.9,1632.05>
  }
  triangle { // #4765
		<842.6,426.25,2077.1>,
		<-840.35,486.9,2064.55>,
		<-840.35,426.25,2064.55>
  }
  triangle { // #4766
		<-840.35,486.9,2064.55>,
		<842.6,426.25,2077.1>,
		<842.6,486.9,2077.1>
  }
  triangle { // #4767
		<-840.35,345.45,1352.9>,
		<-840.35,345.45,1398.7>,
		<-670.9,345.45,1352.9>
  }
  triangle { // #4768
		<843.35,345.45,1353.5>,
		<674,345.45,1353.5>,
		<843.45,345.45,1390.65>
  }
  triangle { // #4769
		<843.45,345.45,1390.65>,
		<674,345.45,1353.5>,
		<611.85,345.45,1462.3>
  }
  triangle { // #4770
		<674,345.45,1353.5>,
		<337,345.45,1428.55>,
		<611.85,345.45,1462.3>
  }
  triangle { // #4771
		<611.85,345.45,1462.3>,
		<337,345.45,1428.55>,
		<389.35,345.45,1517.05>
  }
  triangle { // #4772
		<389.35,345.45,1517.05>,
		<337,345.45,1428.55>,
		<293.75,345.45,1531.1>
  }
  triangle { // #4773
		<337,345.45,1428.55>,
		<0.55,345.45,1453.5>,
		<293.75,345.45,1531.1>
  }
  triangle { // #4774
		<293.75,345.45,1531.1>,
		<0.55,345.45,1453.5>,
		<25.95,345.45,1556.6>
  }
  triangle { // #4775
		<25.95,345.45,1556.6>,
		<0.55,345.45,1453.5>,
		<-210.95,345.45,1543.7>
  }
  triangle { // #4776
		<0.55,345.45,1453.5>,
		<-335.45,345.45,1428.25>,
		<-210.95,345.45,1543.7>
  }
  triangle { // #4777
		<-210.95,345.45,1543.7>,
		<-335.45,345.45,1428.25>,
		<-458.1,345.45,1511.95>
  }
  triangle { // #4778
		<-335.45,345.45,1428.25>,
		<-670.9,345.45,1352.9>,
		<-458.1,345.45,1511.95>
  }
  triangle { // #4779
		<-458.1,345.45,1511.95>,
		<-670.9,345.45,1352.9>,
		<-659.55,345.45,1456.25>
  }
  triangle { // #4780
		<-659.55,345.45,1456.25>,
		<-670.9,345.45,1352.9>,
		<-840.35,345.45,1398.7>
  }
  triangle { // #4781
		<-840.35,310.25,1352.9>,
		<-670.9,310.25,1352.9>,
		<-840.35,310.25,1398.7>
  }
  triangle { // #4782
		<843.35,310.25,1353.5>,
		<843.45,310.25,1390.65>,
		<674,310.25,1353.5>
  }
  triangle { // #4783
		<843.45,310.25,1390.65>,
		<611.85,310.25,1462.3>,
		<674,310.25,1353.5>
  }
  triangle { // #4784
		<674,310.25,1353.5>,
		<611.85,310.25,1462.3>,
		<337,310.25,1428.55>
  }
  triangle { // #4785
		<611.85,310.25,1462.3>,
		<389.35,310.25,1517.05>,
		<337,310.25,1428.55>
  }
  triangle { // #4786
		<389.35,310.25,1517.05>,
		<293.75,310.25,1531.1>,
		<337,310.25,1428.55>
  }
  triangle { // #4787
		<337,310.25,1428.55>,
		<293.75,310.25,1531.1>,
		<0.55,310.25,1453.5>
  }
  triangle { // #4788
		<293.75,310.25,1531.1>,
		<25.95,310.25,1556.6>,
		<0.55,310.25,1453.5>
  }
  triangle { // #4789
		<25.95,310.25,1556.6>,
		<-210.95,310.25,1543.7>,
		<0.55,310.25,1453.5>
  }
  triangle { // #4790
		<0.55,310.25,1453.5>,
		<-210.95,310.25,1543.7>,
		<-335.45,310.25,1428.25>
  }
  triangle { // #4791
		<-210.95,310.25,1543.7>,
		<-458.1,310.25,1511.95>,
		<-335.45,310.25,1428.25>
  }
  triangle { // #4792
		<-335.45,310.25,1428.25>,
		<-458.1,310.25,1511.95>,
		<-670.9,310.25,1352.9>
  }
  triangle { // #4793
		<-458.1,310.25,1511.95>,
		<-659.55,310.25,1456.25>,
		<-670.9,310.25,1352.9>
  }
  triangle { // #4794
		<-659.55,310.25,1456.25>,
		<-840.35,310.25,1398.7>,
		<-670.9,310.25,1352.9>
  }
  triangle { // #4795
		<-840.35,345.45,1352.9>,
		<-840.35,310.25,1352.9>,
		<-840.35,345.45,1398.7>
  }
  triangle { // #4796
		<-840.35,310.25,1398.7>,
		<-840.35,345.45,1398.7>,
		<-840.35,310.25,1352.9>
  }
  smooth_triangle { // #4797
		<-670.9,345.45,1352.9>, <0.11,0.994,0>,
		<-670.9,310.25,1352.9>, <0.11,0.994,0>,
		<-840.35,345.45,1352.9>, <0,1,0>
  }
  smooth_triangle { // #4798
		<-840.35,310.25,1352.9>, <0,1,0>,
		<-840.35,345.45,1352.9>, <0,1,0>,
		<-670.9,310.25,1352.9>, <0.11,0.994,0>
  }
  smooth_triangle { // #4799
		<-670.9,345.45,1352.9>, <0.11,0.994,0>,
		<-335.45,345.45,1428.25>, <0.171,0.985,0>,
		<-670.9,310.25,1352.9>, <0.11,0.994,0>
  }
  smooth_triangle { // #4800
		<674,345.45,1353.5>, <-0.217,0.976,0>,
		<674,310.25,1353.5>, <-0.217,0.976,0>,
		<337,345.45,1428.55>, <-0.146,0.989,0>
  }
  smooth_triangle { // #4801
		<674,310.25,1353.5>, <-0.217,0.976,0>,
		<337,310.25,1428.55>, <-0.146,0.989,0>,
		<337,345.45,1428.55>, <-0.146,0.989,0>
  }
  smooth_triangle { // #4802
		<337,310.25,1428.55>, <-0.146,0.989,0>,
		<0.55,310.25,1453.5>, <-0.024,1,0>,
		<337,345.45,1428.55>, <-0.146,0.989,0>
  }
  smooth_triangle { // #4803
		<337,345.45,1428.55>, <-0.146,0.989,0>,
		<0.55,310.25,1453.5>, <-0.024,1,0>,
		<0.55,345.45,1453.5>, <0.025,1,0>
  }
  smooth_triangle { // #4804
		<0.55,310.25,1453.5>, <-0.024,1,0>,
		<-335.45,310.25,1428.25>, <0.123,0.992,0>,
		<0.55,345.45,1453.5>, <0.025,1,0>
  }
  smooth_triangle { // #4805
		<0.55,345.45,1453.5>, <0.025,1,0>,
		<-335.45,310.25,1428.25>, <0.123,0.992,0>,
		<-335.45,345.45,1428.25>, <0.171,0.985,0>
  }
  smooth_triangle { // #4806
		<-335.45,310.25,1428.25>, <0.123,0.992,0>,
		<-670.9,310.25,1352.9>, <0.11,0.994,0>,
		<-335.45,345.45,1428.25>, <0.171,0.985,0>
  }
  smooth_triangle { // #4807
		<843.35,345.45,1353.5>, <0,1,0>,
		<843.35,310.25,1353.5>, <0,1,0>,
		<674,345.45,1353.5>, <-0.073,0.997,0>
  }
  smooth_triangle { // #4808
		<674,310.25,1353.5>, <-0.146,0.989,0>,
		<674,345.45,1353.5>, <-0.073,0.997,0>,
		<843.35,310.25,1353.5>, <0,1,0>
  }
  triangle { // #4809
		<843.45,345.45,1390.65>,
		<843.45,310.25,1390.65>,
		<843.35,345.45,1353.5>
  }
  triangle { // #4810
		<843.35,310.25,1353.5>,
		<843.35,345.45,1353.5>,
		<843.45,310.25,1390.65>
  }
  smooth_triangle { // #4811
		<611.85,345.45,1462.3>, <0.258,-0.966,0>,
		<611.85,310.25,1462.3>, <0.277,-0.961,0>,
		<843.45,345.45,1390.65>, <0.296,-0.955,0>
  }
  smooth_triangle { // #4812
		<843.45,310.25,1390.65>, <0.296,-0.955,0>,
		<843.45,345.45,1390.65>, <0.296,-0.955,0>,
		<611.85,310.25,1462.3>, <0.277,-0.961,0>
  }
  smooth_triangle { // #4813
		<389.35,345.45,1517.05>, <0.239,-0.971,0>,
		<389.35,310.25,1517.05>, <0.239,-0.971,0>,
		<611.85,345.45,1462.3>, <0.258,-0.966,0>
  }
  smooth_triangle { // #4814
		<611.85,310.25,1462.3>, <0.277,-0.961,0>,
		<611.85,345.45,1462.3>, <0.258,-0.966,0>,
		<389.35,310.25,1517.05>, <0.239,-0.971,0>
  }
  smooth_triangle { // #4815
		<293.75,345.45,1531.1>, <0.112,-0.994,0>,
		<293.75,310.25,1531.1>, <0.129,-0.992,0>,
		<389.35,345.45,1517.05>, <0.177,-0.984,0>
  }
  smooth_triangle { // #4816
		<389.35,310.25,1517.05>, <0.208,-0.978,0>,
		<389.35,345.45,1517.05>, <0.177,-0.984,0>,
		<293.75,310.25,1531.1>, <0.129,-0.992,0>
  }
  smooth_triangle { // #4817
		<25.95,345.45,1556.6>, <-0.005,-1,0>,
		<25.95,310.25,1556.6>, <0.045,-0.999,0>,
		<293.75,345.45,1531.1>, <0.095,-0.996,0>
  }
  smooth_triangle { // #4818
		<293.75,310.25,1531.1>, <0.095,-0.996,0>,
		<293.75,345.45,1531.1>, <0.095,-0.996,0>,
		<25.95,310.25,1556.6>, <0.045,-0.999,0>
  }
  smooth_triangle { // #4819
		<-210.95,345.45,1543.7>, <-0.103,-0.995,0>,
		<-210.95,310.25,1543.7>, <-0.079,-0.997,0>,
		<25.95,345.45,1556.6>, <-0.005,-1,0>
  }
  smooth_triangle { // #4820
		<25.95,310.25,1556.6>, <0.045,-0.999,0>,
		<25.95,345.45,1556.6>, <-0.005,-1,0>,
		<-210.95,310.25,1543.7>, <-0.079,-0.997,0>
  }
  smooth_triangle { // #4821
		<-458.1,345.45,1511.95>, <-0.221,-0.975,0>,
		<-458.1,310.25,1511.95>, <-0.174,-0.985,0>,
		<-210.95,345.45,1543.7>, <-0.103,-0.995,0>
  }
  smooth_triangle { // #4822
		<-210.95,310.25,1543.7>, <-0.079,-0.997,0>,
		<-210.95,345.45,1543.7>, <-0.103,-0.995,0>,
		<-458.1,310.25,1511.95>, <-0.174,-0.985,0>
  }
  smooth_triangle { // #4823
		<-659.55,345.45,1456.25>, <-0.291,-0.957,0>,
		<-659.55,310.25,1456.25>, <-0.279,-0.96,0>,
		<-458.1,345.45,1511.95>, <-0.221,-0.975,0>
  }
  smooth_triangle { // #4824
		<-458.1,310.25,1511.95>, <-0.174,-0.985,0>,
		<-458.1,345.45,1511.95>, <-0.221,-0.975,0>,
		<-659.55,310.25,1456.25>, <-0.279,-0.96,0>
  }
  smooth_triangle { // #4825
		<-840.35,345.45,1398.7>, <-0.303,-0.953,0>,
		<-840.35,310.25,1398.7>, <-0.303,-0.953,0>,
		<-659.55,345.45,1456.25>, <-0.291,-0.957,0>
  }
  smooth_triangle { // #4826
		<-659.55,310.25,1456.25>, <-0.279,-0.96,0>,
		<-659.55,345.45,1456.25>, <-0.291,-0.957,0>,
		<-840.35,310.25,1398.7>, <-0.303,-0.953,0>
  }
  triangle { // #4827
		<452.2,310.25,1428.35>,
		<653.35,310.25,1380.75>,
		<423.75,310.25,1331.2>
  }
  triangle { // #4828
		<-840.35,310.25,1209.6>,
		<-840.35,310.25,1366.75>,
		<-630.25,310.25,1280.55>
  }
  triangle { // #4829
		<-840.35,310.25,1366.75>,
		<-551.15,310.25,1397.3>,
		<-630.25,310.25,1280.55>
  }
  triangle { // #4830
		<-630.25,310.25,1280.55>,
		<-551.15,310.25,1397.3>,
		<-419.95,310.25,1331.2>
  }
  triangle { // #4831
		<-551.15,310.25,1397.3>,
		<-355,310.25,1451>,
		<-419.95,310.25,1331.2>
  }
  triangle { // #4832
		<-419.95,310.25,1331.2>,
		<-355,310.25,1451>,
		<-209.35,310.25,1361.65>
  }
  triangle { // #4833
		<-355,310.25,1451>,
		<-53.25,310.25,1473.6>,
		<-209.35,310.25,1361.65>
  }
  triangle { // #4834
		<-209.35,310.25,1361.65>,
		<-53.25,310.25,1473.6>,
		<1.45,310.25,1371.75>
  }
  triangle { // #4835
		<-53.25,310.25,1473.6>,
		<158,310.25,1473.6>,
		<1.45,310.25,1371.75>
  }
  triangle { // #4836
		<1.45,310.25,1371.75>,
		<158,310.25,1473.6>,
		<212.45,310.25,1361.65>
  }
  triangle { // #4837
		<158,310.25,1473.6>,
		<452.2,310.25,1428.35>,
		<212.45,310.25,1361.65>
  }
  triangle { // #4838
		<212.45,310.25,1361.65>,
		<452.2,310.25,1428.35>,
		<423.75,310.25,1331.2>
  }
  triangle { // #4839
		<862.05,310.25,1208.3>,
		<847,310.25,1209.6>,
		<862.05,310.25,1362.95>
  }
  triangle { // #4840
		<847,310.25,1209.6>,
		<635.25,310.25,1280.55>,
		<862.05,310.25,1362.95>
  }
  triangle { // #4841
		<862.05,310.25,1362.95>,
		<635.25,310.25,1280.55>,
		<718.75,310.25,1362.9>
  }
  triangle { // #4842
		<718.75,310.25,1362.9>,
		<635.25,310.25,1280.55>,
		<653.35,310.25,1380.75>
  }
  triangle { // #4843
		<635.25,310.25,1280.55>,
		<423.75,310.25,1331.2>,
		<653.35,310.25,1380.75>
  }
  triangle { // #4844
		<452.2,275.05,1428.35>,
		<423.75,275.05,1331.2>,
		<653.35,275.05,1380.75>
  }
  triangle { // #4845
		<-840.35,275.05,1209.6>,
		<-630.25,275.05,1280.55>,
		<-840.35,275.05,1366.75>
  }
  triangle { // #4846
		<-840.35,275.05,1366.75>,
		<-630.25,275.05,1280.55>,
		<-551.15,275.05,1397.3>
  }
  triangle { // #4847
		<-630.25,275.05,1280.55>,
		<-419.95,275.05,1331.2>,
		<-551.15,275.05,1397.3>
  }
  triangle { // #4848
		<-551.15,275.05,1397.3>,
		<-419.95,275.05,1331.2>,
		<-355,275.05,1451>
  }
  triangle { // #4849
		<-419.95,275.05,1331.2>,
		<-209.35,275.05,1361.65>,
		<-355,275.05,1451>
  }
  triangle { // #4850
		<-355,275.05,1451>,
		<-209.35,275.05,1361.65>,
		<-53.25,275.05,1473.6>
  }
  triangle { // #4851
		<-209.35,275.05,1361.65>,
		<1.45,275.05,1371.75>,
		<-53.25,275.05,1473.6>
  }
  triangle { // #4852
		<-53.25,275.05,1473.6>,
		<1.45,275.05,1371.75>,
		<158,275.05,1473.6>
  }
  triangle { // #4853
		<1.45,275.05,1371.75>,
		<212.45,275.05,1361.65>,
		<158,275.05,1473.6>
  }
  triangle { // #4854
		<158,275.05,1473.6>,
		<212.45,275.05,1361.65>,
		<452.2,275.05,1428.35>
  }
  triangle { // #4855
		<212.45,275.05,1361.65>,
		<423.75,275.05,1331.2>,
		<452.2,275.05,1428.35>
  }
  triangle { // #4856
		<862.05,275.05,1208.3>,
		<862.05,275.05,1362.95>,
		<847,275.05,1209.6>
  }
  triangle { // #4857
		<847,275.05,1209.6>,
		<862.05,275.05,1362.95>,
		<635.25,275.05,1280.55>
  }
  triangle { // #4858
		<862.05,275.05,1362.95>,
		<718.75,275.05,1362.9>,
		<635.25,275.05,1280.55>
  }
  triangle { // #4859
		<718.75,275.05,1362.9>,
		<653.35,275.05,1380.75>,
		<635.25,275.05,1280.55>
  }
  triangle { // #4860
		<635.25,275.05,1280.55>,
		<653.35,275.05,1380.75>,
		<423.75,275.05,1331.2>
  }
  triangle { // #4861
		<-840.35,310.25,1209.6>,
		<-840.35,275.05,1209.6>,
		<-840.35,310.25,1366.75>
  }
  triangle { // #4862
		<-840.35,275.05,1366.75>,
		<-840.35,310.25,1366.75>,
		<-840.35,275.05,1209.6>
  }
  smooth_triangle { // #4863
		<-840.35,310.25,1209.6>, <0.32,0.947,0>,
		<-630.25,310.25,1280.55>, <0.292,0.957,0>,
		<-840.35,275.05,1209.6>, <0.32,0.947,0>
  }
  smooth_triangle { // #4864
		<847,310.25,1209.6>, <-0.318,0.948,0>,
		<847,275.05,1209.6>, <-0.318,0.948,0>,
		<635.25,310.25,1280.55>, <-0.276,0.961,0>
  }
  smooth_triangle { // #4865
		<847,275.05,1209.6>, <-0.318,0.948,0>,
		<635.25,275.05,1280.55>, <-0.276,0.961,0>,
		<635.25,310.25,1280.55>, <-0.276,0.961,0>
  }
  smooth_triangle { // #4866
		<635.25,275.05,1280.55>, <-0.276,0.961,0>,
		<423.75,275.05,1331.2>, <-0.203,0.979,0>,
		<635.25,310.25,1280.55>, <-0.276,0.961,0>
  }
  smooth_triangle { // #4867
		<635.25,310.25,1280.55>, <-0.276,0.961,0>,
		<423.75,275.05,1331.2>, <-0.203,0.979,0>,
		<423.75,310.25,1331.2>, <-0.173,0.985,0>
  }
  smooth_triangle { // #4868
		<423.75,275.05,1331.2>, <-0.203,0.979,0>,
		<212.45,275.05,1361.65>, <-0.111,0.994,0>,
		<423.75,310.25,1331.2>, <-0.173,0.985,0>
  }
  smooth_triangle { // #4869
		<423.75,310.25,1331.2>, <-0.173,0.985,0>,
		<212.45,275.05,1361.65>, <-0.111,0.994,0>,
		<212.45,310.25,1361.65>, <-0.08,0.997,0>
  }
  smooth_triangle { // #4870
		<212.45,275.05,1361.65>, <-0.111,0.994,0>,
		<1.45,275.05,1371.75>, <-0.016,1,0>,
		<212.45,310.25,1361.65>, <-0.08,0.997,0>
  }
  smooth_triangle { // #4871
		<212.45,310.25,1361.65>, <-0.08,0.997,0>,
		<1.45,275.05,1371.75>, <-0.016,1,0>,
		<1.45,310.25,1371.75>, <0.016,1,0>
  }
  smooth_triangle { // #4872
		<1.45,275.05,1371.75>, <-0.016,1,0>,
		<-209.35,275.05,1361.65>, <0.08,0.997,0>,
		<1.45,310.25,1371.75>, <0.016,1,0>
  }
  smooth_triangle { // #4873
		<1.45,310.25,1371.75>, <0.016,1,0>,
		<-209.35,275.05,1361.65>, <0.08,0.997,0>,
		<-209.35,310.25,1361.65>, <0.111,0.994,0>
  }
  smooth_triangle { // #4874
		<-209.35,275.05,1361.65>, <0.08,0.997,0>,
		<-419.95,275.05,1331.2>, <0.174,0.985,0>,
		<-209.35,310.25,1361.65>, <0.111,0.994,0>
  }
  smooth_triangle { // #4875
		<-209.35,310.25,1361.65>, <0.111,0.994,0>,
		<-419.95,275.05,1331.2>, <0.174,0.985,0>,
		<-419.95,310.25,1331.2>, <0.204,0.979,0>
  }
  smooth_triangle { // #4876
		<-419.95,275.05,1331.2>, <0.174,0.985,0>,
		<-630.25,275.05,1280.55>, <0.263,0.965,0>,
		<-419.95,310.25,1331.2>, <0.204,0.979,0>
  }
  smooth_triangle { // #4877
		<-419.95,310.25,1331.2>, <0.204,0.979,0>,
		<-630.25,275.05,1280.55>, <0.263,0.965,0>,
		<-630.25,310.25,1280.55>, <0.292,0.957,0>
  }
  smooth_triangle { // #4878
		<-630.25,275.05,1280.55>, <0.263,0.965,0>,
		<-840.35,275.05,1209.6>, <0.32,0.947,0>,
		<-630.25,310.25,1280.55>, <0.292,0.957,0>
  }
  smooth_triangle { // #4879
		<862.05,310.25,1208.3>, <-0.083,0.997,0>,
		<862.05,275.05,1208.3>, <-0.083,0.997,0>,
		<847,310.25,1209.6>, <-0.162,0.987,0>
  }
  smooth_triangle { // #4880
		<847,275.05,1209.6>, <-0.241,0.971,0>,
		<847,310.25,1209.6>, <-0.162,0.987,0>,
		<862.05,275.05,1208.3>, <-0.083,0.997,0>
  }
  triangle { // #4881
		<862.05,310.25,1362.95>,
		<862.05,275.05,1362.95>,
		<862.05,310.25,1208.3>
  }
  triangle { // #4882
		<862.05,275.05,1208.3>,
		<862.05,310.25,1208.3>,
		<862.05,275.05,1362.95>
  }
  smooth_triangle { // #4883
		<718.75,310.25,1362.9>, <0.177,-0.984,0>,
		<718.75,275.05,1362.9>, <0.088,-0.996,0>,
		<862.05,310.25,1362.95>, <-0.001,-1,0>
  }
  smooth_triangle { // #4884
		<862.05,275.05,1362.95>, <-0.001,-1,0>,
		<862.05,310.25,1362.95>, <-0.001,-1,0>,
		<718.75,275.05,1362.9>, <0.088,-0.996,0>
  }
  smooth_triangle { // #4885
		<653.35,310.25,1380.75>, <0.241,-0.97,0>,
		<653.35,275.05,1380.75>, <0.252,-0.968,0>,
		<718.75,310.25,1362.9>, <0.177,-0.984,0>
  }
  smooth_triangle { // #4886
		<718.75,275.05,1362.9>, <0.088,-0.996,0>,
		<718.75,310.25,1362.9>, <0.177,-0.984,0>,
		<653.35,275.05,1380.75>, <0.252,-0.968,0>
  }
  smooth_triangle { // #4887
		<452.2,310.25,1428.35>, <0.178,-0.984,0>,
		<452.2,275.05,1428.35>, <0.204,-0.979,0>,
		<653.35,310.25,1380.75>, <0.23,-0.973,0>
  }
  smooth_triangle { // #4888
		<653.35,275.05,1380.75>, <0.23,-0.973,0>,
		<653.35,310.25,1380.75>, <0.23,-0.973,0>,
		<452.2,275.05,1428.35>, <0.204,-0.979,0>
  }
  smooth_triangle { // #4889
		<158,310.25,1473.6>, <0.051,-0.999,0>,
		<158,275.05,1473.6>, <0.102,-0.995,0>,
		<452.2,310.25,1428.35>, <0.178,-0.984,0>
  }
  smooth_triangle { // #4890
		<452.2,275.05,1428.35>, <0.204,-0.979,0>,
		<452.2,310.25,1428.35>, <0.178,-0.984,0>,
		<158,275.05,1473.6>, <0.102,-0.995,0>
  }
  smooth_triangle { // #4891
		<-53.25,310.25,1473.6>, <-0.05,-0.999,0>,
		<-53.25,275.05,1473.6>, <-0.025,-1,0>,
		<158,310.25,1473.6>, <0.051,-0.999,0>
  }
  smooth_triangle { // #4892
		<158,275.05,1473.6>, <0.102,-0.995,0>,
		<158,310.25,1473.6>, <0.051,-0.999,0>,
		<-53.25,275.05,1473.6>, <-0.025,-1,0>
  }
  smooth_triangle { // #4893
		<-355,310.25,1451>, <-0.202,-0.979,0>,
		<-355,275.05,1451>, <-0.138,-0.99,0>,
		<-53.25,310.25,1473.6>, <-0.05,-0.999,0>
  }
  smooth_triangle { // #4894
		<-53.25,275.05,1473.6>, <-0.025,-1,0>,
		<-53.25,310.25,1473.6>, <-0.05,-0.999,0>,
		<-355,275.05,1451>, <-0.138,-0.99,0>
  }
  smooth_triangle { // #4895
		<-551.15,310.25,1397.3>, <-0.159,-0.987,0>,
		<-551.15,275.05,1397.3>, <-0.212,-0.977,0>,
		<-355,310.25,1451>, <-0.202,-0.979,0>
  }
  smooth_triangle { // #4896
		<-355,275.05,1451>, <-0.138,-0.99,0>,
		<-355,310.25,1451>, <-0.202,-0.979,0>,
		<-551.15,275.05,1397.3>, <-0.212,-0.977,0>
  }
  smooth_triangle { // #4897
		<-840.35,310.25,1366.75>, <-0.105,-0.994,0>,
		<-840.35,275.05,1366.75>, <-0.105,-0.994,0>,
		<-551.15,310.25,1397.3>, <-0.159,-0.987,0>
  }
  smooth_triangle { // #4898
		<-551.15,275.05,1397.3>, <-0.212,-0.977,0>,
		<-551.15,310.25,1397.3>, <-0.159,-0.987,0>,
		<-840.35,275.05,1366.75>, <-0.105,-0.994,0>
  }
  triangle { // #4899
		<-845.4,275.05,1129.1>,
		<-857.9,275.05,1217.1>,
		<-829.15,275.05,1124.1>
  }
  triangle { // #4900
		<833.8,275.05,1124.1>,
		<624.9,275.05,1197.8>,
		<870.1,275.05,1186.95>
  }
  triangle { // #4901
		<870.1,275.05,1186.95>,
		<624.9,275.05,1197.8>,
		<863.65,275.05,1232.2>
  }
  triangle { // #4902
		<863.65,275.05,1232.2>,
		<624.9,275.05,1197.8>,
		<535.15,275.05,1320.2>
  }
  triangle { // #4903
		<624.9,275.05,1197.8>,
		<416.3,275.05,1250.45>,
		<535.15,275.05,1320.2>
  }
  triangle { // #4904
		<535.15,275.05,1320.2>,
		<416.3,275.05,1250.45>,
		<331.5,275.05,1357.95>
  }
  triangle { // #4905
		<416.3,275.05,1250.45>,
		<208,275.05,1282.05>,
		<331.5,275.05,1357.95>
  }
  triangle { // #4906
		<331.5,275.05,1357.95>,
		<208,275.05,1282.05>,
		<140.4,275.05,1373.35>
  }
  triangle { // #4907
		<208,275.05,1282.05>,
		<-0,275.05,1292.55>,
		<140.4,275.05,1373.35>
  }
  triangle { // #4908
		<140.4,275.05,1373.35>,
		<-0,275.05,1292.55>,
		<-48.2,275.05,1379.85>
  }
  triangle { // #4909
		<-0,275.05,1292.55>,
		<-207.75,275.05,1282.05>,
		<-48.2,275.05,1379.85>
  }
  triangle { // #4910
		<-48.2,275.05,1379.85>,
		<-207.75,275.05,1282.05>,
		<-229.25,275.05,1379.85>
  }
  triangle { // #4911
		<-207.75,275.05,1282.05>,
		<-415.15,275.05,1250.45>,
		<-229.25,275.05,1379.85>
  }
  triangle { // #4912
		<-229.25,275.05,1379.85>,
		<-415.15,275.05,1250.45>,
		<-337.4,275.05,1350.4>
  }
  triangle { // #4913
		<-337.4,275.05,1350.4>,
		<-415.15,275.05,1250.45>,
		<-573.75,275.05,1305.15>
  }
  triangle { // #4914
		<-415.15,275.05,1250.45>,
		<-622.3,275.05,1197.8>,
		<-573.75,275.05,1305.15>
  }
  triangle { // #4915
		<-573.75,275.05,1305.15>,
		<-622.3,275.05,1197.8>,
		<-779.1,275.05,1245.85>
  }
  triangle { // #4916
		<-622.3,275.05,1197.8>,
		<-829.15,275.05,1124.1>,
		<-779.1,275.05,1245.85>
  }
  triangle { // #4917
		<-779.1,275.05,1245.85>,
		<-829.15,275.05,1124.1>,
		<-857.9,275.05,1217.1>
  }
  triangle { // #4918
		<-845.4,239.85,1129.1>,
		<-829.15,239.85,1124.1>,
		<-857.9,239.85,1217.1>
  }
  triangle { // #4919
		<833.8,239.85,1124.1>,
		<870.1,239.85,1186.95>,
		<624.9,239.85,1197.8>
  }
  triangle { // #4920
		<870.1,239.85,1186.95>,
		<863.65,239.85,1232.2>,
		<624.9,239.85,1197.8>
  }
  triangle { // #4921
		<863.65,239.85,1232.2>,
		<535.15,239.85,1320.2>,
		<624.9,239.85,1197.8>
  }
  triangle { // #4922
		<624.9,239.85,1197.8>,
		<535.15,239.85,1320.2>,
		<416.3,239.85,1250.45>
  }
  triangle { // #4923
		<535.15,239.85,1320.2>,
		<331.5,239.85,1357.95>,
		<416.3,239.85,1250.45>
  }
  triangle { // #4924
		<416.3,239.85,1250.45>,
		<331.5,239.85,1357.95>,
		<208,239.85,1282.05>
  }
  triangle { // #4925
		<331.5,239.85,1357.95>,
		<140.4,239.85,1373.35>,
		<208,239.85,1282.05>
  }
  triangle { // #4926
		<208,239.85,1282.05>,
		<140.4,239.85,1373.35>,
		<-0,239.85,1292.55>
  }
  triangle { // #4927
		<140.4,239.85,1373.35>,
		<-48.2,239.85,1379.85>,
		<-0,239.85,1292.55>
  }
  triangle { // #4928
		<-0,239.85,1292.55>,
		<-48.2,239.85,1379.85>,
		<-207.75,239.85,1282.05>
  }
  triangle { // #4929
		<-48.2,239.85,1379.85>,
		<-229.25,239.85,1379.85>,
		<-207.75,239.85,1282.05>
  }
  triangle { // #4930
		<-207.75,239.85,1282.05>,
		<-229.25,239.85,1379.85>,
		<-415.15,239.85,1250.45>
  }
  triangle { // #4931
		<-229.25,239.85,1379.85>,
		<-337.4,239.85,1350.4>,
		<-415.15,239.85,1250.45>
  }
  triangle { // #4932
		<-337.4,239.85,1350.4>,
		<-573.75,239.85,1305.15>,
		<-415.15,239.85,1250.45>
  }
  triangle { // #4933
		<-415.15,239.85,1250.45>,
		<-573.75,239.85,1305.15>,
		<-622.3,239.85,1197.8>
  }
  triangle { // #4934
		<-573.75,239.85,1305.15>,
		<-779.1,239.85,1245.85>,
		<-622.3,239.85,1197.8>
  }
  triangle { // #4935
		<-622.3,239.85,1197.8>,
		<-779.1,239.85,1245.85>,
		<-829.15,239.85,1124.1>
  }
  triangle { // #4936
		<-779.1,239.85,1245.85>,
		<-857.9,239.85,1217.1>,
		<-829.15,239.85,1124.1>
  }
  smooth_triangle { // #4937
		<-829.15,275.05,1124.1>, <0.021,1,0>,
		<-829.15,239.85,1124.1>, <0.021,1,0>,
		<-845.4,275.05,1129.1>, <-0.296,0.955,0>
  }
  smooth_triangle { // #4938
		<-845.4,239.85,1129.1>, <-0.296,0.955,0>,
		<-845.4,275.05,1129.1>, <-0.296,0.955,0>,
		<-829.15,239.85,1124.1>, <0.021,1,0>
  }
  smooth_triangle { // #4939
		<833.8,239.85,1124.1>, <-0.333,0.943,0>,
		<624.9,239.85,1197.8>, <-0.304,0.953,0>,
		<833.8,275.05,1124.1>, <-0.333,0.943,0>
  }
  smooth_triangle { // #4940
		<-829.15,275.05,1124.1>, <0.336,0.942,0>,
		<-622.3,275.05,1197.8>, <0.306,0.952,0>,
		<-829.15,239.85,1124.1>, <0.336,0.942,0>
  }
  smooth_triangle { // #4941
		<-829.15,239.85,1124.1>, <0.336,0.942,0>,
		<-622.3,275.05,1197.8>, <0.306,0.952,0>,
		<-622.3,239.85,1197.8>, <0.276,0.961,0>
  }
  smooth_triangle { // #4942
		<-622.3,275.05,1197.8>, <0.306,0.952,0>,
		<-415.15,275.05,1250.45>, <0.215,0.977,0>,
		<-622.3,239.85,1197.8>, <0.276,0.961,0>
  }
  smooth_triangle { // #4943
		<-622.3,239.85,1197.8>, <0.276,0.961,0>,
		<-415.15,275.05,1250.45>, <0.215,0.977,0>,
		<-415.15,239.85,1250.45>, <0.183,0.983,0>
  }
  smooth_triangle { // #4944
		<-415.15,275.05,1250.45>, <0.215,0.977,0>,
		<-207.75,275.05,1282.05>, <0.117,0.993,0>,
		<-415.15,239.85,1250.45>, <0.183,0.983,0>
  }
  smooth_triangle { // #4945
		<-415.15,239.85,1250.45>, <0.183,0.983,0>,
		<-207.75,275.05,1282.05>, <0.117,0.993,0>,
		<-207.75,239.85,1282.05>, <0.084,0.996,0>
  }
  smooth_triangle { // #4946
		<-207.75,275.05,1282.05>, <0.117,0.993,0>,
		<-0,275.05,1292.55>, <0.017,1,0>,
		<-207.75,239.85,1282.05>, <0.084,0.996,0>
  }
  smooth_triangle { // #4947
		<-207.75,239.85,1282.05>, <0.084,0.996,0>,
		<-0,275.05,1292.55>, <0.017,1,0>,
		<-0,239.85,1292.55>, <-0.017,1,0>
  }
  smooth_triangle { // #4948
		<-0,275.05,1292.55>, <0.017,1,0>,
		<208,275.05,1282.05>, <-0.084,0.996,0>,
		<-0,239.85,1292.55>, <-0.017,1,0>
  }
  smooth_triangle { // #4949
		<-0,239.85,1292.55>, <-0.017,1,0>,
		<208,275.05,1282.05>, <-0.084,0.996,0>,
		<208,239.85,1282.05>, <-0.117,0.993,0>
  }
  smooth_triangle { // #4950
		<208,275.05,1282.05>, <-0.084,0.996,0>,
		<416.3,275.05,1250.45>, <-0.182,0.983,0>,
		<208,239.85,1282.05>, <-0.117,0.993,0>
  }
  smooth_triangle { // #4951
		<208,239.85,1282.05>, <-0.117,0.993,0>,
		<416.3,275.05,1250.45>, <-0.182,0.983,0>,
		<416.3,239.85,1250.45>, <-0.213,0.977,0>
  }
  smooth_triangle { // #4952
		<416.3,275.05,1250.45>, <-0.182,0.983,0>,
		<624.9,275.05,1197.8>, <-0.274,0.962,0>,
		<416.3,239.85,1250.45>, <-0.213,0.977,0>
  }
  smooth_triangle { // #4953
		<416.3,239.85,1250.45>, <-0.213,0.977,0>,
		<624.9,275.05,1197.8>, <-0.274,0.962,0>,
		<624.9,239.85,1197.8>, <-0.304,0.953,0>
  }
  smooth_triangle { // #4954
		<624.9,275.05,1197.8>, <-0.274,0.962,0>,
		<833.8,275.05,1124.1>, <-0.333,0.943,0>,
		<624.9,239.85,1197.8>, <-0.304,0.953,0>
  }
  smooth_triangle { // #4955
		<870.1,275.05,1186.95>, <0.997,0.077,0>,
		<870.1,239.85,1186.95>, <0.954,0.301,0>,
		<833.8,275.05,1124.1>, <0.866,0.5,0>
  }
  smooth_triangle { // #4956
		<833.8,239.85,1124.1>, <0.866,0.5,0>,
		<833.8,275.05,1124.1>, <0.866,0.5,0>,
		<870.1,239.85,1186.95>, <0.954,0.301,0>
  }
  smooth_triangle { // #4957
		<863.65,275.05,1232.2>, <0.99,-0.141,0>,
		<863.65,239.85,1232.2>, <0.99,-0.141,0>,
		<870.1,275.05,1186.95>, <0.997,0.077,0>
  }
  smooth_triangle { // #4958
		<870.1,239.85,1186.95>, <0.954,0.301,0>,
		<870.1,275.05,1186.95>, <0.997,0.077,0>,
		<863.65,239.85,1232.2>, <0.99,-0.141,0>
  }
  smooth_triangle { // #4959
		<535.15,275.05,1320.2>, <0.208,-0.978,0>,
		<535.15,239.85,1320.2>, <0.233,-0.972,0>,
		<863.65,275.05,1232.2>, <0.259,-0.966,0>
  }
  smooth_triangle { // #4960
		<863.65,239.85,1232.2>, <0.259,-0.966,0>,
		<863.65,275.05,1232.2>, <0.259,-0.966,0>,
		<535.15,239.85,1320.2>, <0.233,-0.972,0>
  }
  smooth_triangle { // #4961
		<331.5,275.05,1357.95>, <0.114,-0.993,0>,
		<331.5,239.85,1357.95>, <0.148,-0.989,0>,
		<535.15,275.05,1320.2>, <0.208,-0.978,0>
  }
  smooth_triangle { // #4962
		<535.15,239.85,1320.2>, <0.233,-0.972,0>,
		<535.15,275.05,1320.2>, <0.208,-0.978,0>,
		<331.5,239.85,1357.95>, <0.148,-0.989,0>
  }
  smooth_triangle { // #4963
		<140.4,275.05,1373.35>, <0.05,-0.999,0>,
		<140.4,239.85,1373.35>, <0.065,-0.998,0>,
		<331.5,275.05,1357.95>, <0.114,-0.993,0>
  }
  smooth_triangle { // #4964
		<331.5,239.85,1357.95>, <0.148,-0.989,0>,
		<331.5,275.05,1357.95>, <0.114,-0.993,0>,
		<140.4,239.85,1373.35>, <0.065,-0.998,0>
  }
  smooth_triangle { // #4965
		<-48.2,275.05,1379.85>, <0.012,-1,0>,
		<-48.2,239.85,1379.85>, <0.023,-1,0>,
		<140.4,275.05,1373.35>, <0.05,-0.999,0>
  }
  smooth_triangle { // #4966
		<140.4,239.85,1373.35>, <0.065,-0.998,0>,
		<140.4,275.05,1373.35>, <0.05,-0.999,0>,
		<-48.2,239.85,1379.85>, <0.023,-1,0>
  }
  smooth_triangle { // #4967
		<-229.25,275.05,1379.85>, <-0.177,-0.984,0>,
		<-229.25,239.85,1379.85>, <-0.088,-0.996,0>,
		<-48.2,275.05,1379.85>, <0.012,-1,0>
  }
  smooth_triangle { // #4968
		<-48.2,239.85,1379.85>, <0.023,-1,0>,
		<-48.2,275.05,1379.85>, <0.012,-1,0>,
		<-229.25,239.85,1379.85>, <-0.088,-0.996,0>
  }
  smooth_triangle { // #4969
		<-337.4,275.05,1350.4>, <-0.213,-0.977,0>,
		<-337.4,239.85,1350.4>, <-0.238,-0.971,0>,
		<-229.25,275.05,1379.85>, <-0.177,-0.984,0>
  }
  smooth_triangle { // #4970
		<-229.25,239.85,1379.85>, <-0.088,-0.996,0>,
		<-229.25,275.05,1379.85>, <-0.177,-0.984,0>,
		<-337.4,239.85,1350.4>, <-0.238,-0.971,0>
  }
  smooth_triangle { // #4971
		<-573.75,275.05,1305.15>, <-0.248,-0.969,0>,
		<-573.75,239.85,1305.15>, <-0.218,-0.976,0>,
		<-337.4,275.05,1350.4>, <-0.188,-0.982,0>
  }
  smooth_triangle { // #4972
		<-337.4,239.85,1350.4>, <-0.188,-0.982,0>,
		<-337.4,275.05,1350.4>, <-0.188,-0.982,0>,
		<-573.75,239.85,1305.15>, <-0.218,-0.976,0>
  }
  smooth_triangle { // #4973
		<-779.1,275.05,1245.85>, <-0.277,-0.961,0>,
		<-779.1,239.85,1245.85>, <-0.277,-0.961,0>,
		<-573.75,275.05,1305.15>, <-0.248,-0.969,0>
  }
  smooth_triangle { // #4974
		<-573.75,239.85,1305.15>, <-0.218,-0.976,0>,
		<-573.75,275.05,1305.15>, <-0.248,-0.969,0>,
		<-779.1,239.85,1245.85>, <-0.277,-0.961,0>
  }
  smooth_triangle { // #4975
		<-857.9,275.05,1217.1>, <-0.342,-0.94,0>,
		<-857.9,239.85,1217.1>, <-0.342,-0.94,0>,
		<-779.1,275.05,1245.85>, <-0.321,-0.947,0>
  }
  smooth_triangle { // #4976
		<-779.1,239.85,1245.85>, <-0.299,-0.954,0>,
		<-779.1,275.05,1245.85>, <-0.321,-0.947,0>,
		<-857.9,239.85,1217.1>, <-0.342,-0.94,0>
  }
  triangle { // #4977
		<-845.4,275.05,1129.1>,
		<-845.4,239.85,1129.1>,
		<-857.9,275.05,1217.1>
  }
  triangle { // #4978
		<-857.9,239.85,1217.1>,
		<-857.9,275.05,1217.1>,
		<-845.4,239.85,1129.1>
  }
  triangle { // #4979
		<-13,380.65,1710>,
		<2.05,380.65,1616.9>,
		<17.15,380.65,1710>
  }
  triangle { // #4980
		<-630.25,380.65,1530.65>,
		<-840.35,380.65,1569.35>,
		<-840.35,380.65,1463.55>
  }
  triangle { // #4981
		<-630.25,380.65,1530.65>,
		<-619.05,380.65,1627>,
		<-840.35,380.65,1569.35>
  }
  triangle { // #4982
		<-419.8,380.65,1578.55>,
		<-619.05,380.65,1627>,
		<-630.25,380.65,1530.65>
  }
  triangle { // #4983
		<-419.8,380.65,1578.55>,
		<-405.3,380.65,1672.25>,
		<-619.05,380.65,1627>
  }
  triangle { // #4984
		<849.5,380.65,1564.15>,
		<637.15,380.65,1530.65>,
		<849.5,380.65,1463.55>
  }
  triangle { // #4985
		<532.65,380.65,1649.65>,
		<637.15,380.65,1530.65>,
		<849.5,380.65,1564.15>
  }
  triangle { // #4986
		<532.65,380.65,1649.65>,
		<425.15,380.65,1578.55>,
		<637.15,380.65,1530.65>
  }
  triangle { // #4987
		<301.3,380.65,1684.85>,
		<425.15,380.65,1578.55>,
		<532.65,380.65,1649.65>
  }
  triangle { // #4988
		<301.3,380.65,1684.85>,
		<213.45,380.65,1607.3>,
		<425.15,380.65,1578.55>
  }
  triangle { // #4989
		<17.15,380.65,1710>,
		<213.45,380.65,1607.3>,
		<301.3,380.65,1684.85>
  }
  triangle { // #4990
		<17.15,380.65,1710>,
		<2.05,380.65,1616.9>,
		<213.45,380.65,1607.3>
  }
  triangle { // #4991
		<-209,380.65,1607.3>,
		<-405.3,380.65,1672.25>,
		<-419.8,380.65,1578.55>
  }
  triangle { // #4992
		<-209,380.65,1607.3>,
		<-236.8,380.65,1694.9>,
		<-405.3,380.65,1672.25>
  }
  triangle { // #4993
		<-209,380.65,1607.3>,
		<-13,380.65,1710>,
		<-236.8,380.65,1694.9>
  }
  triangle { // #4994
		<2.05,380.65,1616.9>,
		<-13,380.65,1710>,
		<-209,380.65,1607.3>
  }
  triangle { // #4995
		<2.05,415.85,1616.9>,
		<-13,415.85,1710>,
		<17.15,415.85,1710>
  }
  triangle { // #4996
		<-840.35,415.85,1569.35>,
		<-630.25,415.85,1530.65>,
		<-840.35,415.85,1463.55>
  }
  triangle { // #4997
		<-619.05,415.85,1627>,
		<-630.25,415.85,1530.65>,
		<-840.35,415.85,1569.35>
  }
  triangle { // #4998
		<-619.05,415.85,1627>,
		<-419.8,415.85,1578.55>,
		<-630.25,415.85,1530.65>
  }
  triangle { // #4999
		<-405.3,415.85,1672.25>,
		<-419.8,415.85,1578.55>,
		<-619.05,415.85,1627>
  }
  triangle { // #5000
		<637.15,415.85,1530.65>,
		<849.5,415.85,1564.15>,
		<849.5,415.85,1463.55>
  }
  triangle { // #5001
		<637.15,415.85,1530.65>,
		<532.65,415.85,1649.65>,
		<849.5,415.85,1564.15>
  }
  triangle { // #5002
		<425.15,415.85,1578.55>,
		<532.65,415.85,1649.65>,
		<637.15,415.85,1530.65>
  }
  triangle { // #5003
		<425.15,415.85,1578.55>,
		<301.3,415.85,1684.85>,
		<532.65,415.85,1649.65>
  }
  triangle { // #5004
		<213.45,415.85,1607.3>,
		<301.3,415.85,1684.85>,
		<425.15,415.85,1578.55>
  }
  triangle { // #5005
		<213.45,415.85,1607.3>,
		<17.15,415.85,1710>,
		<301.3,415.85,1684.85>
  }
  triangle { // #5006
		<2.05,415.85,1616.9>,
		<17.15,415.85,1710>,
		<213.45,415.85,1607.3>
  }
  triangle { // #5007
		<-405.3,415.85,1672.25>,
		<-209,415.85,1607.3>,
		<-419.8,415.85,1578.55>
  }
  triangle { // #5008
		<-236.8,415.85,1694.9>,
		<-209,415.85,1607.3>,
		<-405.3,415.85,1672.25>
  }
  triangle { // #5009
		<-13,415.85,1710>,
		<-209,415.85,1607.3>,
		<-236.8,415.85,1694.9>
  }
  triangle { // #5010
		<-13,415.85,1710>,
		<2.05,415.85,1616.9>,
		<-209,415.85,1607.3>
  }
  triangle { // #5011
		<-840.35,380.65,1569.35>,
		<-840.35,415.85,1463.55>,
		<-840.35,380.65,1463.55>
  }
  triangle { // #5012
		<-840.35,415.85,1463.55>,
		<-840.35,380.65,1569.35>,
		<-840.35,415.85,1569.35>
  }
  smooth_triangle { // #5013
		<-840.35,415.85,1463.55>, <0.304,0.953,0>,
		<-630.25,380.65,1530.65>, <0.277,0.961,0>,
		<-840.35,380.65,1463.55>, <0.304,0.953,0>
  }
  smooth_triangle { // #5014
		<637.15,380.65,1530.65>, <-0.261,0.965,0>,
		<849.5,415.85,1463.55>, <-0.301,0.954,0>,
		<849.5,380.65,1463.55>, <-0.301,0.954,0>
  }
  smooth_triangle { // #5015
		<637.15,380.65,1530.65>, <-0.261,0.965,0>,
		<637.15,415.85,1530.65>, <-0.261,0.965,0>,
		<849.5,415.85,1463.55>, <-0.301,0.954,0>
  }
  smooth_triangle { // #5016
		<637.15,380.65,1530.65>, <-0.261,0.965,0>,
		<425.15,415.85,1578.55>, <-0.192,0.981,0>,
		<637.15,415.85,1530.65>, <-0.261,0.965,0>
  }
  smooth_triangle { // #5017
		<425.15,380.65,1578.55>, <-0.163,0.987,0>,
		<425.15,415.85,1578.55>, <-0.192,0.981,0>,
		<637.15,380.65,1530.65>, <-0.261,0.965,0>
  }
  smooth_triangle { // #5018
		<425.15,380.65,1578.55>, <-0.163,0.987,0>,
		<213.45,415.85,1607.3>, <-0.105,0.994,0>,
		<425.15,415.85,1578.55>, <-0.192,0.981,0>
  }
  smooth_triangle { // #5019
		<213.45,380.65,1607.3>, <-0.075,0.997,0>,
		<213.45,415.85,1607.3>, <-0.105,0.994,0>,
		<425.15,380.65,1578.55>, <-0.163,0.987,0>
  }
  smooth_triangle { // #5020
		<213.45,380.65,1607.3>, <-0.075,0.997,0>,
		<2.05,415.85,1616.9>, <-0.015,1,0>,
		<213.45,415.85,1607.3>, <-0.105,0.994,0>
  }
  smooth_triangle { // #5021
		<2.05,380.65,1616.9>, <0.015,1,0>,
		<2.05,415.85,1616.9>, <-0.015,1,0>,
		<213.45,380.65,1607.3>, <-0.075,0.997,0>
  }
  smooth_triangle { // #5022
		<2.05,380.65,1616.9>, <0.015,1,0>,
		<-209,415.85,1607.3>, <0.075,0.997,0>,
		<2.05,415.85,1616.9>, <-0.015,1,0>
  }
  smooth_triangle { // #5023
		<-209,380.65,1607.3>, <0.105,0.994,0>,
		<-209,415.85,1607.3>, <0.075,0.997,0>,
		<2.05,380.65,1616.9>, <0.015,1,0>
  }
  smooth_triangle { // #5024
		<-209,380.65,1607.3>, <0.105,0.994,0>,
		<-419.8,415.85,1578.55>, <0.164,0.986,0>,
		<-209,415.85,1607.3>, <0.075,0.997,0>
  }
  smooth_triangle { // #5025
		<-419.8,380.65,1578.55>, <0.193,0.981,0>,
		<-419.8,415.85,1578.55>, <0.164,0.986,0>,
		<-209,380.65,1607.3>, <0.105,0.994,0>
  }
  smooth_triangle { // #5026
		<-419.8,380.65,1578.55>, <0.193,0.981,0>,
		<-630.25,415.85,1530.65>, <0.25,0.968,0>,
		<-419.8,415.85,1578.55>, <0.164,0.986,0>
  }
  smooth_triangle { // #5027
		<-630.25,380.65,1530.65>, <0.277,0.961,0>,
		<-630.25,415.85,1530.65>, <0.25,0.968,0>,
		<-419.8,380.65,1578.55>, <0.193,0.981,0>
  }
  smooth_triangle { // #5028
		<-630.25,380.65,1530.65>, <0.277,0.961,0>,
		<-840.35,415.85,1463.55>, <0.304,0.953,0>,
		<-630.25,415.85,1530.65>, <0.25,0.968,0>
  }
  triangle { // #5029
		<849.5,380.65,1463.55>,
		<849.5,415.85,1564.15>,
		<849.5,380.65,1564.15>
  }
  triangle { // #5030
		<849.5,415.85,1564.15>,
		<849.5,380.65,1463.55>,
		<849.5,415.85,1463.55>
  }
  smooth_triangle { // #5031
		<849.5,380.65,1564.15>, <0.261,-0.965,0>,
		<532.65,415.85,1649.65>, <0.224,-0.975,0>,
		<532.65,380.65,1649.65>, <0.187,-0.982,0>
  }
  smooth_triangle { // #5032
		<532.65,415.85,1649.65>, <0.224,-0.975,0>,
		<849.5,380.65,1564.15>, <0.261,-0.965,0>,
		<849.5,415.85,1564.15>, <0.261,-0.965,0>
  }
  smooth_triangle { // #5033
		<532.65,380.65,1649.65>, <0.187,-0.982,0>,
		<301.3,415.85,1684.85>, <0.13,-0.992,0>,
		<301.3,380.65,1684.85>, <0.109,-0.994,0>
  }
  smooth_triangle { // #5034
		<301.3,415.85,1684.85>, <0.13,-0.992,0>,
		<532.65,380.65,1649.65>, <0.187,-0.982,0>,
		<532.65,415.85,1649.65>, <0.224,-0.975,0>
  }
  smooth_triangle { // #5035
		<301.3,380.65,1684.85>, <0.109,-0.994,0>,
		<17.15,415.85,1710>, <0.088,-0.996,0>,
		<17.15,380.65,1710>, <0.088,-0.996,0>
  }
  smooth_triangle { // #5036
		<17.15,415.85,1710>, <0.088,-0.996,0>,
		<301.3,380.65,1684.85>, <0.109,-0.994,0>,
		<301.3,415.85,1684.85>, <0.13,-0.992,0>
  }
  smooth_triangle { // #5037
		<17.15,380.65,1710>, <0.029,-1,0>,
		<-13,415.85,1710>, <-0.022,-1,0>,
		<-13,380.65,1710>, <-0.045,-0.999,0>
  }
  smooth_triangle { // #5038
		<-13,415.85,1710>, <-0.022,-1,0>,
		<17.15,380.65,1710>, <0.029,-1,0>,
		<17.15,415.85,1710>, <0.059,-0.998,0>
  }
  smooth_triangle { // #5039
		<-13,380.65,1710>, <-0.067,-0.998,0>,
		<-236.8,415.85,1694.9>, <-0.089,-0.996,0>,
		<-236.8,380.65,1694.9>, <-0.111,-0.994,0>
  }
  smooth_triangle { // #5040
		<-236.8,415.85,1694.9>, <-0.089,-0.996,0>,
		<-13,380.65,1710>, <-0.067,-0.998,0>,
		<-13,415.85,1710>, <-0.067,-0.998,0>
  }
  smooth_triangle { // #5041
		<-236.8,380.65,1694.9>, <-0.111,-0.994,0>,
		<-405.3,415.85,1672.25>, <-0.158,-0.987,0>,
		<-405.3,380.65,1672.25>, <-0.183,-0.983,0>
  }
  smooth_triangle { // #5042
		<-405.3,415.85,1672.25>, <-0.158,-0.987,0>,
		<-236.8,380.65,1694.9>, <-0.111,-0.994,0>,
		<-236.8,415.85,1694.9>, <-0.089,-0.996,0>
  }
  smooth_triangle { // #5043
		<-405.3,380.65,1672.25>, <-0.183,-0.983,0>,
		<-619.05,415.85,1627>, <-0.222,-0.975,0>,
		<-619.05,380.65,1627>, <-0.237,-0.971,0>
  }
  smooth_triangle { // #5044
		<-619.05,415.85,1627>, <-0.222,-0.975,0>,
		<-405.3,380.65,1672.25>, <-0.183,-0.983,0>,
		<-405.3,415.85,1672.25>, <-0.158,-0.987,0>
  }
  smooth_triangle { // #5045
		<-619.05,380.65,1627>, <-0.237,-0.971,0>,
		<-840.35,415.85,1569.35>, <-0.252,-0.968,0>,
		<-840.35,380.65,1569.35>, <-0.252,-0.968,0>
  }
  smooth_triangle { // #5046
		<-840.35,415.85,1569.35>, <-0.252,-0.968,0>,
		<-619.05,380.65,1627>, <-0.237,-0.971,0>,
		<-619.05,415.85,1627>, <-0.222,-0.975,0>
  }
  triangle { // #5047
		<848.4,345.45,1478.65>,
		<637.5,345.45,1452.7>,
		<848.4,345.45,1385.6>
  }
  triangle { // #5048
		<-625.25,345.45,1452.7>,
		<-835.35,345.45,1478.65>,
		<-835.3,345.45,1385.6>
  }
  triangle { // #5049
		<-625.25,345.45,1452.7>,
		<-732.2,345.45,1513.85>,
		<-835.35,345.45,1478.65>
  }
  triangle { // #5050
		<-625.25,345.45,1452.7>,
		<-523.45,345.45,1574.2>,
		<-732.2,345.45,1513.85>
  }
  triangle { // #5051
		<-415.1,345.45,1500.65>,
		<-523.45,345.45,1574.2>,
		<-625.25,345.45,1452.7>
  }
  triangle { // #5052
		<-415.1,345.45,1500.65>,
		<-317.3,345.45,1612.35>,
		<-523.45,345.45,1574.2>
  }
  triangle { // #5053
		<-204.8,345.45,1529.4>,
		<-317.3,345.45,1612.35>,
		<-415.1,345.45,1500.65>
  }
  triangle { // #5054
		<-204.8,345.45,1529.4>,
		<-73.35,345.45,1632.05>,
		<-317.3,345.45,1612.35>
  }
  triangle { // #5055
		<5.6,345.45,1539>,
		<-73.35,345.45,1632.05>,
		<-204.8,345.45,1529.4>
  }
  triangle { // #5056
		<5.6,345.45,1539>,
		<75,345.45,1632.05>,
		<-73.35,345.45,1632.05>
  }
  triangle { // #5057
		<216.1,345.45,1529.4>,
		<75,345.45,1632.05>,
		<5.6,345.45,1539>
  }
  triangle { // #5058
		<216.1,345.45,1529.4>,
		<311.35,345.45,1609.4>,
		<75,345.45,1632.05>
  }
  triangle { // #5059
		<426.75,345.45,1500.65>,
		<311.35,345.45,1609.4>,
		<216.1,345.45,1529.4>
  }
  triangle { // #5060
		<426.75,345.45,1500.65>,
		<605.6,345.45,1561.6>,
		<311.35,345.45,1609.4>
  }
  triangle { // #5061
		<637.5,345.45,1452.7>,
		<605.6,345.45,1561.6>,
		<426.75,345.45,1500.65>
  }
  triangle { // #5062
		<637.5,345.45,1452.7>,
		<848.4,345.45,1478.65>,
		<605.6,345.45,1561.6>
  }
  triangle { // #5063
		<637.5,380.65,1452.7>,
		<848.4,380.65,1478.65>,
		<848.4,380.65,1385.6>
  }
  triangle { // #5064
		<-835.35,380.65,1478.65>,
		<-625.25,380.65,1452.7>,
		<-835.3,380.65,1385.6>
  }
  triangle { // #5065
		<-732.2,380.65,1513.85>,
		<-625.25,380.65,1452.7>,
		<-835.35,380.65,1478.65>
  }
  triangle { // #5066
		<-523.45,380.65,1574.2>,
		<-625.25,380.65,1452.7>,
		<-732.2,380.65,1513.85>
  }
  triangle { // #5067
		<-523.45,380.65,1574.2>,
		<-415.1,380.65,1500.65>,
		<-625.25,380.65,1452.7>
  }
  triangle { // #5068
		<-317.3,380.65,1612.35>,
		<-415.1,380.65,1500.65>,
		<-523.45,380.65,1574.2>
  }
  triangle { // #5069
		<-317.3,380.65,1612.35>,
		<-204.8,380.65,1529.4>,
		<-415.1,380.65,1500.65>
  }
  triangle { // #5070
		<-73.35,380.65,1632.05>,
		<-204.8,380.65,1529.4>,
		<-317.3,380.65,1612.35>
  }
  triangle { // #5071
		<-73.35,380.65,1632.05>,
		<5.6,380.65,1539>,
		<-204.8,380.65,1529.4>
  }
  triangle { // #5072
		<75,380.65,1632.05>,
		<5.6,380.65,1539>,
		<-73.35,380.65,1632.05>
  }
  triangle { // #5073
		<75,380.65,1632.05>,
		<216.1,380.65,1529.4>,
		<5.6,380.65,1539>
  }
  triangle { // #5074
		<311.35,380.65,1609.4>,
		<216.1,380.65,1529.4>,
		<75,380.65,1632.05>
  }
  triangle { // #5075
		<311.35,380.65,1609.4>,
		<426.75,380.65,1500.65>,
		<216.1,380.65,1529.4>
  }
  triangle { // #5076
		<605.6,380.65,1561.6>,
		<426.75,380.65,1500.65>,
		<311.35,380.65,1609.4>
  }
  triangle { // #5077
		<605.6,380.65,1561.6>,
		<637.5,380.65,1452.7>,
		<426.75,380.65,1500.65>
  }
  triangle { // #5078
		<848.4,380.65,1478.65>,
		<637.5,380.65,1452.7>,
		<605.6,380.65,1561.6>
  }
  triangle { // #5079
		<-835.35,345.45,1478.65>,
		<-835.3,380.65,1385.6>,
		<-835.3,345.45,1385.6>
  }
  triangle { // #5080
		<-835.3,380.65,1385.6>,
		<-835.35,345.45,1478.65>,
		<-835.35,380.65,1478.65>
  }
  smooth_triangle { // #5081
		<-835.3,380.65,1385.6>, <0.304,0.953,0>,
		<-625.25,345.45,1452.7>, <0.277,0.961,0>,
		<-835.3,345.45,1385.6>, <0.304,0.953,0>
  }
  smooth_triangle { // #5082
		<637.5,345.45,1452.7>, <-0.263,0.965,0>,
		<848.4,380.65,1385.6>, <-0.303,0.953,0>,
		<848.4,345.45,1385.6>, <-0.303,0.953,0>
  }
  smooth_triangle { // #5083
		<637.5,345.45,1452.7>, <-0.263,0.965,0>,
		<637.5,380.65,1452.7>, <-0.263,0.965,0>,
		<848.4,380.65,1385.6>, <-0.303,0.953,0>
  }
  smooth_triangle { // #5084
		<637.5,345.45,1452.7>, <-0.263,0.965,0>,
		<426.75,380.65,1500.65>, <-0.193,0.981,0>,
		<637.5,380.65,1452.7>, <-0.263,0.965,0>
  }
  smooth_triangle { // #5085
		<426.75,345.45,1500.65>, <-0.164,0.986,0>,
		<426.75,380.65,1500.65>, <-0.193,0.981,0>,
		<637.5,345.45,1452.7>, <-0.263,0.965,0>
  }
  smooth_triangle { // #5086
		<426.75,345.45,1500.65>, <-0.164,0.986,0>,
		<216.1,380.65,1529.4>, <-0.105,0.994,0>,
		<426.75,380.65,1500.65>, <-0.193,0.981,0>
  }
  smooth_triangle { // #5087
		<216.1,345.45,1529.4>, <-0.075,0.997,0>,
		<216.1,380.65,1529.4>, <-0.105,0.994,0>,
		<426.75,345.45,1500.65>, <-0.164,0.986,0>
  }
  smooth_triangle { // #5088
		<216.1,345.45,1529.4>, <-0.075,0.997,0>,
		<5.6,380.65,1539>, <-0.015,1,0>,
		<216.1,380.65,1529.4>, <-0.105,0.994,0>
  }
  smooth_triangle { // #5089
		<5.6,345.45,1539>, <0.015,1,0>,
		<5.6,380.65,1539>, <-0.015,1,0>,
		<216.1,345.45,1529.4>, <-0.075,0.997,0>
  }
  smooth_triangle { // #5090
		<5.6,345.45,1539>, <0.015,1,0>,
		<-204.8,380.65,1529.4>, <0.076,0.997,0>,
		<5.6,380.65,1539>, <-0.015,1,0>
  }
  smooth_triangle { // #5091
		<-204.8,345.45,1529.4>, <0.106,0.994,0>,
		<-204.8,380.65,1529.4>, <0.076,0.997,0>,
		<5.6,345.45,1539>, <0.015,1,0>
  }
  smooth_triangle { // #5092
		<-204.8,345.45,1529.4>, <0.106,0.994,0>,
		<-415.1,380.65,1500.65>, <0.165,0.986,0>,
		<-204.8,380.65,1529.4>, <0.076,0.997,0>
  }
  smooth_triangle { // #5093
		<-415.1,345.45,1500.65>, <0.194,0.981,0>,
		<-415.1,380.65,1500.65>, <0.165,0.986,0>,
		<-204.8,345.45,1529.4>, <0.106,0.994,0>
  }
  smooth_triangle { // #5094
		<-415.1,345.45,1500.65>, <0.194,0.981,0>,
		<-625.25,380.65,1452.7>, <0.25,0.968,0>,
		<-415.1,380.65,1500.65>, <0.165,0.986,0>
  }
  smooth_triangle { // #5095
		<-625.25,345.45,1452.7>, <0.277,0.961,0>,
		<-625.25,380.65,1452.7>, <0.25,0.968,0>,
		<-415.1,345.45,1500.65>, <0.194,0.981,0>
  }
  smooth_triangle { // #5096
		<-625.25,345.45,1452.7>, <0.277,0.961,0>,
		<-835.3,380.65,1385.6>, <0.304,0.953,0>,
		<-625.25,380.65,1452.7>, <0.25,0.968,0>
  }
  triangle { // #5097
		<848.4,345.45,1385.6>,
		<848.4,380.65,1478.65>,
		<848.4,345.45,1478.65>
  }
  triangle { // #5098
		<848.4,380.65,1478.65>,
		<848.4,345.45,1385.6>,
		<848.4,380.65,1385.6>
  }
  smooth_triangle { // #5099
		<848.4,345.45,1478.65>, <0.323,-0.946,0>,
		<605.6,380.65,1561.6>, <0.27,-0.963,0>,
		<605.6,345.45,1561.6>, <0.215,-0.977,0>
  }
  smooth_triangle { // #5100
		<605.6,380.65,1561.6>, <0.27,-0.963,0>,
		<848.4,345.45,1478.65>, <0.323,-0.946,0>,
		<848.4,380.65,1478.65>, <0.323,-0.946,0>
  }
  smooth_triangle { // #5101
		<605.6,345.45,1561.6>, <0.215,-0.977,0>,
		<311.35,380.65,1609.4>, <0.139,-0.99,0>,
		<311.35,345.45,1609.4>, <0.117,-0.993,0>
  }
  smooth_triangle { // #5102
		<311.35,380.65,1609.4>, <0.139,-0.99,0>,
		<605.6,345.45,1561.6>, <0.215,-0.977,0>,
		<605.6,380.65,1561.6>, <0.27,-0.963,0>
  }
  smooth_triangle { // #5103
		<311.35,345.45,1609.4>, <0.117,-0.993,0>,
		<75,380.65,1632.05>, <0.064,-0.998,0>,
		<75,345.45,1632.05>, <0.032,-0.999,0>
  }
  smooth_triangle { // #5104
		<75,380.65,1632.05>, <0.064,-0.998,0>,
		<311.35,345.45,1609.4>, <0.117,-0.993,0>,
		<311.35,380.65,1609.4>, <0.139,-0.99,0>
  }
  smooth_triangle { // #5105
		<75,345.45,1632.05>, <0.032,-0.999,0>,
		<-73.35,380.65,1632.05>, <-0.027,-1,0>,
		<-73.35,345.45,1632.05>, <-0.054,-0.999,0>
  }
  smooth_triangle { // #5106
		<-73.35,380.65,1632.05>, <-0.027,-1,0>,
		<75,345.45,1632.05>, <0.032,-0.999,0>,
		<75,380.65,1632.05>, <0.064,-0.998,0>
  }
  smooth_triangle { // #5107
		<-73.35,345.45,1632.05>, <-0.054,-0.999,0>,
		<-317.3,380.65,1612.35>, <-0.114,-0.993,0>,
		<-317.3,345.45,1612.35>, <-0.148,-0.989,0>
  }
  smooth_triangle { // #5108
		<-317.3,380.65,1612.35>, <-0.114,-0.993,0>,
		<-73.35,345.45,1632.05>, <-0.054,-0.999,0>,
		<-73.35,380.65,1632.05>, <-0.027,-1,0>
  }
  smooth_triangle { // #5109
		<-317.3,345.45,1612.35>, <-0.148,-0.989,0>,
		<-523.45,380.65,1574.2>, <-0.214,-0.977,0>,
		<-523.45,345.45,1574.2>, <-0.246,-0.969,0>
  }
  smooth_triangle { // #5110
		<-523.45,380.65,1574.2>, <-0.214,-0.977,0>,
		<-317.3,345.45,1612.35>, <-0.148,-0.989,0>,
		<-317.3,380.65,1612.35>, <-0.114,-0.993,0>
  }
  smooth_triangle { // #5111
		<-523.45,345.45,1574.2>, <-0.246,-0.969,0>,
		<-732.2,380.65,1513.85>, <-0.293,-0.956,0>,
		<-732.2,345.45,1513.85>, <-0.308,-0.951,0>
  }
  smooth_triangle { // #5112
		<-732.2,380.65,1513.85>, <-0.293,-0.956,0>,
		<-523.45,345.45,1574.2>, <-0.246,-0.969,0>,
		<-523.45,380.65,1574.2>, <-0.214,-0.977,0>
  }
  smooth_triangle { // #5113
		<-732.2,345.45,1513.85>, <-0.308,-0.951,0>,
		<-835.35,380.65,1478.65>, <-0.323,-0.946,0>,
		<-835.35,345.45,1478.65>, <-0.323,-0.946,0>
  }
  smooth_triangle { // #5114
		<-835.35,380.65,1478.65>, <-0.323,-0.946,0>,
		<-732.2,345.45,1513.85>, <-0.308,-0.951,0>,
		<-732.2,380.65,1513.85>, <-0.293,-0.956,0>
  }
  triangle { // #5115
		<116.5,-0,1962.7>,
		<863.35,-0,1925>,
		<863.35,-0,1962.7>
  }
  triangle { // #5116
		<863.35,-0,1925>,
		<116.5,-0,1962.7>,
		<116.5,-0,1925>
  }
  triangle { // #5117
		<116.5,427.5,1962.7>,
		<863.35,427.5,1925>,
		<116.5,427.5,1925>
  }
  triangle { // #5118
		<863.35,427.5,1925>,
		<116.5,427.5,1962.7>,
		<863.35,427.5,1962.7>
  }
  triangle { // #5119
		<116.5,-0,1962.7>,
		<116.5,427.5,1925>,
		<116.5,-0,1925>
  }
  triangle { // #5120
		<116.5,427.5,1925>,
		<116.5,-0,1962.7>,
		<116.5,427.5,1962.7>
  }
  triangle { // #5121
		<116.5,-0,1925>,
		<863.35,427.5,1925>,
		<863.35,-0,1925>
  }
  triangle { // #5122
		<863.35,427.5,1925>,
		<116.5,-0,1925>,
		<116.5,427.5,1925>
  }
  triangle { // #5123
		<863.35,-0,1925>,
		<863.35,427.5,1962.7>,
		<863.35,-0,1962.7>
  }
  triangle { // #5124
		<863.35,427.5,1962.7>,
		<863.35,-0,1925>,
		<863.35,427.5,1925>
  }
  triangle { // #5125
		<863.35,-0,1962.7>,
		<116.5,427.5,1962.7>,
		<116.5,-0,1962.7>
  }
  triangle { // #5126
		<116.5,427.5,1962.7>,
		<863.35,-0,1962.7>,
		<863.35,427.5,1962.7>
  }
  triangle { // #5127
		<-866.7,-0,1962.7>,
		<-117.35,-0,1925>,
		<-117.35,-0,1962.7>
  }
  triangle { // #5128
		<-117.35,-0,1925>,
		<-866.7,-0,1962.7>,
		<-866.7,-0,1925>
  }
  triangle { // #5129
		<-866.7,427.5,1962.7>,
		<-117.35,427.5,1925>,
		<-866.7,427.5,1925>
  }
  triangle { // #5130
		<-117.35,427.5,1925>,
		<-866.7,427.5,1962.7>,
		<-117.35,427.5,1962.7>
  }
  triangle { // #5131
		<-866.7,-0,1962.7>,
		<-866.7,427.5,1925>,
		<-866.7,-0,1925>
  }
  triangle { // #5132
		<-866.7,427.5,1925>,
		<-866.7,-0,1962.7>,
		<-866.7,427.5,1962.7>
  }
  triangle { // #5133
		<-866.7,-0,1925>,
		<-117.35,427.5,1925>,
		<-117.35,-0,1925>
  }
  triangle { // #5134
		<-117.35,427.5,1925>,
		<-866.7,-0,1925>,
		<-866.7,427.5,1925>
  }
  triangle { // #5135
		<-117.35,-0,1925>,
		<-117.35,427.5,1962.7>,
		<-117.35,-0,1962.7>
  }
  triangle { // #5136
		<-117.35,427.5,1962.7>,
		<-117.35,-0,1925>,
		<-117.35,427.5,1925>
  }
  triangle { // #5137
		<-117.35,-0,1962.7>,
		<-866.7,427.5,1962.7>,
		<-866.7,-0,1962.7>
  }
  triangle { // #5138
		<-866.7,427.5,1962.7>,
		<-117.35,-0,1962.7>,
		<-117.35,427.5,1962.7>
  }
  triangle { // #5139
		<-118.6,-0,1925>,
		<117.75,-0,1962.7>,
		<-118.6,-0,1962.7>
  }
  triangle { // #5140
		<117.75,-0,1962.7>,
		<-118.6,-0,1925>,
		<117.75,-0,1925>
  }
  triangle { // #5141
		<-118.6,145.85,1962.7>,
		<117.75,145.85,1925>,
		<-118.6,145.85,1925>
  }
  triangle { // #5142
		<117.75,145.85,1925>,
		<-118.6,145.85,1962.7>,
		<117.75,145.85,1962.7>
  }
  triangle { // #5143
		<-118.6,-0,1962.7>,
		<-118.6,145.85,1925>,
		<-118.6,-0,1925>
  }
  triangle { // #5144
		<-118.6,145.85,1925>,
		<-118.6,-0,1962.7>,
		<-118.6,145.85,1962.7>
  }
  triangle { // #5145
		<117.75,-0,1925>,
		<117.75,145.85,1962.7>,
		<117.75,-0,1962.7>
  }
  triangle { // #5146
		<117.75,145.85,1962.7>,
		<117.75,-0,1925>,
		<117.75,145.85,1925>
  }
  triangle { // #5147
		<117.75,-0,1962.7>,
		<-118.6,145.85,1962.7>,
		<-118.6,-0,1962.7>
  }
  triangle { // #5148
		<-118.6,145.85,1962.7>,
		<117.75,-0,1962.7>,
		<117.75,145.85,1962.7>
  }
  triangle { // #5149
		<-118.6,379.7,1925>,
		<117.75,379.7,1962.7>,
		<-118.6,379.7,1962.7>
  }
  triangle { // #5150
		<117.75,379.7,1962.7>,
		<-118.6,379.7,1925>,
		<117.75,379.7,1925>
  }
  triangle { // #5151
		<-118.6,430,1962.7>,
		<117.75,430,1925>,
		<-118.6,430,1925>
  }
  triangle { // #5152
		<117.75,430,1925>,
		<-118.6,430,1962.7>,
		<117.75,430,1962.7>
  }
  triangle { // #5153
		<-118.6,379.7,1962.7>,
		<-118.6,430,1925>,
		<-118.6,379.7,1925>
  }
  triangle { // #5154
		<-118.6,430,1925>,
		<-118.6,379.7,1962.7>,
		<-118.6,430,1962.7>
  }
  triangle { // #5155
		<-118.6,379.7,1925>,
		<117.75,430,1925>,
		<117.75,379.7,1925>
  }
  triangle { // #5156
		<117.75,430,1925>,
		<-118.6,379.7,1925>,
		<-118.6,430,1925>
  }
  triangle { // #5157
		<117.75,379.7,1925>,
		<117.75,430,1962.7>,
		<117.75,379.7,1962.7>
  }
  triangle { // #5158
		<117.75,430,1962.7>,
		<117.75,379.7,1925>,
		<117.75,430,1925>
  }
  triangle { // #5159
		<117.75,379.7,1962.7>,
		<-118.6,430,1962.7>,
		<-118.6,379.7,1962.7>
  }
  triangle { // #5160
		<-118.6,430,1962.7>,
		<117.75,379.7,1962.7>,
		<117.75,430,1962.7>
  }
  triangle { // #5161
		<380.5,-15.1,1518>,
		<187.55,-15.1,1512.3>,
		<375.5,-15.1,1486.6>
  }
  triangle { // #5162
		<-376.15,-15.1,1487.05>,
		<-191,-15.1,1542.05>,
		<-381.55,-15.1,1518>
  }
  triangle { // #5163
		<-188.3,-15.1,1512.5>,
		<-191,-15.1,1542.05>,
		<-376.15,-15.1,1487.05>
  }
  triangle { // #5164
		<-188.3,-15.1,1512.5>,
		<-0.5,-15.1,1550.1>,
		<-191,-15.1,1542.05>
  }
  triangle { // #5165
		<-0.4,-15.1,1520.95>,
		<-0.5,-15.1,1550.1>,
		<-188.3,-15.1,1512.5>
  }
  triangle { // #5166
		<-0.4,-15.1,1520.95>,
		<190.05,-15.1,1542.05>,
		<-0.5,-15.1,1550.1>
  }
  triangle { // #5167
		<187.55,-15.1,1512.3>,
		<190.05,-15.1,1542.05>,
		<-0.4,-15.1,1520.95>
  }
  triangle { // #5168
		<187.55,-15.1,1512.3>,
		<380.5,-15.1,1518>,
		<190.05,-15.1,1542.05>
  }
  triangle { // #5169
		<187.55,301.75,1512.3>,
		<380.5,301.75,1518>,
		<375.5,301.75,1486.6>
  }
  triangle { // #5170
		<-191,301.75,1542.05>,
		<-376.15,301.75,1487.05>,
		<-381.55,301.75,1518>
  }
  triangle { // #5171
		<-191,301.75,1542.05>,
		<-188.3,301.75,1512.5>,
		<-376.15,301.75,1487.05>
  }
  triangle { // #5172
		<-0.5,301.75,1550.1>,
		<-188.3,301.75,1512.5>,
		<-191,301.75,1542.05>
  }
  triangle { // #5173
		<-0.5,301.75,1550.1>,
		<-0.4,301.75,1520.95>,
		<-188.3,301.75,1512.5>
  }
  triangle { // #5174
		<190.05,301.75,1542.05>,
		<-0.4,301.75,1520.95>,
		<-0.5,301.75,1550.1>
  }
  triangle { // #5175
		<190.05,301.75,1542.05>,
		<187.55,301.75,1512.3>,
		<-0.4,301.75,1520.95>
  }
  triangle { // #5176
		<380.5,301.75,1518>,
		<187.55,301.75,1512.3>,
		<190.05,301.75,1542.05>
  }
  triangle { // #5177
		<-381.55,-15.1,1518>,
		<-376.15,301.75,1487.05>,
		<-376.15,-15.1,1487.05>
  }
  triangle { // #5178
		<-376.15,301.75,1487.05>,
		<-381.55,-15.1,1518>,
		<-381.55,301.75,1518>
  }
  smooth_triangle { // #5179
		<-376.15,301.75,1487.05>, <0.134,0.991,0>,
		<-188.3,-15.1,1512.5>, <0.105,0.995,0>,
		<-376.15,-15.1,1487.05>, <0.134,0.991,0>
  }
  smooth_triangle { // #5180
		<187.55,-15.1,1512.3>, <-0.091,0.996,0>,
		<375.5,301.75,1486.6>, <-0.135,0.991,0>,
		<375.5,-15.1,1486.6>, <-0.135,0.991,0>
  }
  smooth_triangle { // #5181
		<187.55,-15.1,1512.3>, <-0.091,0.996,0>,
		<187.55,301.75,1512.3>, <-0.091,0.996,0>,
		<375.5,301.75,1486.6>, <-0.135,0.991,0>
  }
  smooth_triangle { // #5182
		<187.55,-15.1,1512.3>, <-0.091,0.996,0>,
		<-0.4,301.75,1520.95>, <-0.016,1,0>,
		<187.55,301.75,1512.3>, <-0.091,0.996,0>
  }
  smooth_triangle { // #5183
		<-0.4,-15.1,1520.95>, <0.015,1,0>,
		<-0.4,301.75,1520.95>, <-0.016,1,0>,
		<187.55,-15.1,1512.3>, <-0.091,0.996,0>
  }
  smooth_triangle { // #5184
		<-0.4,-15.1,1520.95>, <0.015,1,0>,
		<-188.3,301.75,1512.5>, <0.075,0.997,0>,
		<-0.4,301.75,1520.95>, <-0.016,1,0>
  }
  smooth_triangle { // #5185
		<-188.3,-15.1,1512.5>, <0.105,0.995,0>,
		<-188.3,301.75,1512.5>, <0.075,0.997,0>,
		<-0.4,-15.1,1520.95>, <0.015,1,0>
  }
  smooth_triangle { // #5186
		<-188.3,-15.1,1512.5>, <0.105,0.995,0>,
		<-376.15,301.75,1487.05>, <0.134,0.991,0>,
		<-188.3,301.75,1512.5>, <0.075,0.997,0>
  }
  triangle { // #5187
		<375.5,-15.1,1486.6>,
		<380.5,301.75,1518>,
		<380.5,-15.1,1518>
  }
  triangle { // #5188
		<380.5,301.75,1518>,
		<375.5,-15.1,1486.6>,
		<375.5,301.75,1486.6>
  }
  smooth_triangle { // #5189
		<190.05,301.75,1542.05>, <0.07,-0.998,0>,
		<-0.5,-15.1,1550.1>, <0.014,-1,0>,
		<190.05,-15.1,1542.05>, <0.098,-0.995,0>
  }
  smooth_triangle { // #5190
		<380.5,301.75,1518>, <0.125,-0.992,0>,
		<190.05,-15.1,1542.05>, <0.098,-0.995,0>,
		<380.5,-15.1,1518>, <0.125,-0.992,0>
  }
  smooth_triangle { // #5191
		<190.05,301.75,1542.05>, <0.07,-0.998,0>,
		<190.05,-15.1,1542.05>, <0.098,-0.995,0>,
		<380.5,301.75,1518>, <0.125,-0.992,0>
  }
  smooth_triangle { // #5192
		<-381.55,-15.1,1518>, <-0.125,-0.992,0>,
		<-191,301.75,1542.05>, <-0.098,-0.995,0>,
		<-381.55,301.75,1518>, <-0.125,-0.992,0>
  }
  smooth_triangle { // #5193
		<-191,-15.1,1542.05>, <-0.07,-0.998,0>,
		<-191,301.75,1542.05>, <-0.098,-0.995,0>,
		<-381.55,-15.1,1518>, <-0.125,-0.992,0>
  }
  smooth_triangle { // #5194
		<-191,-15.1,1542.05>, <-0.07,-0.998,0>,
		<-0.5,301.75,1550.1>, <-0.014,-1,0>,
		<-191,301.75,1542.05>, <-0.098,-0.995,0>
  }
  smooth_triangle { // #5195
		<-0.5,-15.1,1550.1>, <0.014,-1,0>,
		<-0.5,301.75,1550.1>, <-0.014,-1,0>,
		<-191,-15.1,1542.05>, <-0.07,-0.998,0>
  }
  smooth_triangle { // #5196
		<-0.5,-15.1,1550.1>, <0.014,-1,0>,
		<190.05,301.75,1542.05>, <0.07,-0.998,0>,
		<-0.5,301.75,1550.1>, <-0.014,-1,0>
  }
  triangle { // #5197
		<514.9,427.5,1881.3>,
		<514.9,442.15,1964.25>,
		<514.9,427.5,1964.25>
  }
  triangle { // #5198
		<514.9,263.6,1415.8>,
		<514.9,427.5,1881.3>,
		<514.9,249.75,1415.8>
  }
  triangle { // #5199
		<514.9,442.15,1878.5>,
		<514.9,427.5,1881.3>,
		<514.9,263.6,1415.8>
  }
  triangle { // #5200
		<514.9,442.15,1964.25>,
		<514.9,427.5,1881.3>,
		<514.9,442.15,1878.5>
  }
  triangle { // #5201
		<-511.05,442.15,1964.25>,
		<-511.05,427.5,1881.3>,
		<-511.05,427.5,1964.25>
  }
  triangle { // #5202
		<-511.05,427.5,1881.3>,
		<-511.05,263.6,1415.8>,
		<-511.05,249.75,1415.8>
  }
  triangle { // #5203
		<-511.05,427.5,1881.3>,
		<-511.05,442.15,1878.5>,
		<-511.05,263.6,1415.8>
  }
  triangle { // #5204
		<-511.05,427.5,1881.3>,
		<-511.05,442.15,1964.25>,
		<-511.05,442.15,1878.5>
  }
  smooth_triangle { // #5205
		<514.9,427.5,1964.25>, <0,0,-1>,
		<-511.05,427.5,1881.3>, <0,-0.121,-0.993>,
		<514.9,427.5,1881.3>, <0,-0.241,-0.97>
  }
  smooth_triangle { // #5206
		<-511.05,427.5,1881.3>, <0,-0.121,-0.993>,
		<514.9,427.5,1964.25>, <0,0,-1>,
		<-511.05,427.5,1964.25>, <0,0,-1>
  }
  smooth_triangle { // #5207
		<514.9,427.5,1881.3>, <0,-0.241,-0.97>,
		<-511.05,249.75,1415.8>, <0,-0.357,-0.934>,
		<514.9,249.75,1415.8>, <0,-0.357,-0.934>
  }
  smooth_triangle { // #5208
		<-511.05,249.75,1415.8>, <0,-0.357,-0.934>,
		<514.9,427.5,1881.3>, <0,-0.241,-0.97>,
		<-511.05,427.5,1881.3>, <0,-0.121,-0.993>
  }
  triangle { // #5209
		<514.9,249.75,1415.8>,
		<-511.05,263.6,1415.8>,
		<514.9,263.6,1415.8>
  }
  triangle { // #5210
		<-511.05,263.6,1415.8>,
		<514.9,249.75,1415.8>,
		<-511.05,249.75,1415.8>
  }
  smooth_triangle { // #5211
		<514.9,263.6,1415.8>, <0,0.36,0.933>,
		<-511.05,442.15,1878.5>, <0,0.244,0.97>,
		<514.9,442.15,1878.5>, <0,0.122,0.993>
  }
  smooth_triangle { // #5212
		<-511.05,442.15,1878.5>, <0,0.244,0.97>,
		<514.9,263.6,1415.8>, <0,0.36,0.933>,
		<-511.05,263.6,1415.8>, <0,0.36,0.933>
  }
  smooth_triangle { // #5213
		<514.9,442.15,1878.5>, <0,0.122,0.993>,
		<-511.05,442.15,1964.25>, <0,0,1>,
		<514.9,442.15,1964.25>, <0,0,1>
  }
  smooth_triangle { // #5214
		<-511.05,442.15,1964.25>, <0,0,1>,
		<514.9,442.15,1878.5>, <0,0.122,0.993>,
		<-511.05,442.15,1878.5>, <0,0.244,0.97>
  }
  triangle { // #5215
		<514.9,442.15,1964.25>,
		<-511.05,427.5,1964.25>,
		<514.9,427.5,1964.25>
  }
  triangle { // #5216
		<-511.05,427.5,1964.25>,
		<514.9,442.15,1964.25>,
		<-511.05,442.15,1964.25>
  }
  triangle { // #5217
		<518.65,275.55,1468.95>,
		<518.65,0.2,1944.2>,
		<518.65,0.2,1468.95>
  }
  triangle { // #5218
		<518.65,0.2,1944.2>,
		<518.65,433.95,1875.05>,
		<518.65,433.95,1944.2>
  }
  triangle { // #5219
		<518.65,0.2,1944.2>,
		<518.65,275.55,1468.95>,
		<518.65,433.95,1875.05>
  }
  triangle { // #5220
		<503.6,0.2,1944.2>,
		<503.6,275.55,1468.95>,
		<503.6,0.2,1468.95>
  }
  triangle { // #5221
		<503.6,433.95,1875.05>,
		<503.6,0.2,1944.2>,
		<503.6,433.95,1944.2>
  }
  triangle { // #5222
		<503.6,275.55,1468.95>,
		<503.6,0.2,1944.2>,
		<503.6,433.95,1875.05>
  }
  triangle { // #5223
		<518.65,433.95,1944.2>,
		<503.6,0.2,1944.2>,
		<518.65,0.2,1944.2>
  }
  triangle { // #5224
		<503.6,0.2,1944.2>,
		<518.65,433.95,1944.2>,
		<503.6,433.95,1944.2>
  }
  triangle { // #5225
		<518.65,0.2,1944.2>,
		<503.6,0.2,1468.95>,
		<518.65,0.2,1468.95>
  }
  triangle { // #5226
		<503.6,0.2,1468.95>,
		<518.65,0.2,1944.2>,
		<503.6,0.2,1944.2>
  }
  triangle { // #5227
		<518.65,0.2,1468.95>,
		<503.6,275.55,1468.95>,
		<518.65,275.55,1468.95>
  }
  triangle { // #5228
		<503.6,275.55,1468.95>,
		<518.65,0.2,1468.95>,
		<503.6,0.2,1468.95>
  }
  triangle { // #5229
		<518.65,275.55,1468.95>,
		<503.6,433.95,1875.05>,
		<518.65,433.95,1875.05>
  }
  triangle { // #5230
		<503.6,433.95,1875.05>,
		<518.65,275.55,1468.95>,
		<503.6,275.55,1468.95>
  }
  smooth_triangle { // #5231
		<518.65,433.95,1875.05>, <0,0.123,0.992>,
		<503.6,433.95,1944.2>, <0,0,1>,
		<518.65,433.95,1944.2>, <0,0,1>
  }
  smooth_triangle { // #5232
		<503.6,433.95,1944.2>, <0,0,1>,
		<518.65,433.95,1875.05>, <0,0.123,0.992>,
		<503.6,433.95,1875.05>, <0,0.246,0.969>
  }
  triangle { // #5233
		<-503.5,275.55,1468.95>,
		<-503.5,0.2,1944.2>,
		<-503.5,0.2,1468.95>
  }
  triangle { // #5234
		<-503.5,0.2,1944.2>,
		<-503.5,433.95,1875.05>,
		<-503.5,433.95,1944.2>
  }
  triangle { // #5235
		<-503.5,0.2,1944.2>,
		<-503.5,275.55,1468.95>,
		<-503.5,433.95,1875.05>
  }
  triangle { // #5236
		<-518.6,0.2,1944.2>,
		<-518.6,275.55,1468.95>,
		<-518.6,0.2,1468.95>
  }
  triangle { // #5237
		<-518.6,433.95,1875.05>,
		<-518.6,0.2,1944.2>,
		<-518.6,433.95,1944.2>
  }
  triangle { // #5238
		<-518.6,275.55,1468.95>,
		<-518.6,0.2,1944.2>,
		<-518.6,433.95,1875.05>
  }
  triangle { // #5239
		<-503.5,433.95,1944.2>,
		<-518.6,0.2,1944.2>,
		<-503.5,0.2,1944.2>
  }
  triangle { // #5240
		<-518.6,0.2,1944.2>,
		<-503.5,433.95,1944.2>,
		<-518.6,433.95,1944.2>
  }
  triangle { // #5241
		<-503.5,0.2,1944.2>,
		<-518.6,0.2,1468.95>,
		<-503.5,0.2,1468.95>
  }
  triangle { // #5242
		<-518.6,0.2,1468.95>,
		<-503.5,0.2,1944.2>,
		<-518.6,0.2,1944.2>
  }
  triangle { // #5243
		<-503.5,0.2,1468.95>,
		<-518.6,275.55,1468.95>,
		<-503.5,275.55,1468.95>
  }
  triangle { // #5244
		<-518.6,275.55,1468.95>,
		<-503.5,0.2,1468.95>,
		<-518.6,0.2,1468.95>
  }
  triangle { // #5245
		<-503.5,275.55,1468.95>,
		<-518.6,433.95,1875.05>,
		<-503.5,433.95,1875.05>
  }
  triangle { // #5246
		<-518.6,433.95,1875.05>,
		<-503.5,275.55,1468.95>,
		<-518.6,275.55,1468.95>
  }
  smooth_triangle { // #5247
		<-503.5,433.95,1875.05>, <0,0.123,0.992>,
		<-518.6,433.95,1944.2>, <0,0,1>,
		<-503.5,433.95,1944.2>, <0,0,1>
  }
  smooth_triangle { // #5248
		<-518.6,433.95,1944.2>, <0,0,1>,
		<-503.5,433.95,1875.05>, <0,0.123,0.992>,
		<-518.6,433.95,1875.05>, <0,0.246,0.969>
  }
  triangle { // #5249
		<-0.45,-118,338.95>,
		<846.85,-128.95,340>,
		<0.15,-153.35,342.35>
  }
  triangle { // #5250
		<-0.45,-118,338.95>,
		<-843,-131.45,340.25>,
		<-843,-98.9,337.1>
  }
  triangle { // #5251
		<-0.45,-118,338.95>,
		<0.15,-153.35,342.35>,
		<-843,-131.45,340.25>
  }
  triangle { // #5252
		<846.85,-128.95,340>,
		<-0.45,-118,338.95>,
		<846.85,-98.9,337.1>
  }
  triangle { // #5253
		<846.85,-18.2,1490.15>,
		<-0.45,-7.25,1489.1>,
		<0.15,-42.6,1492.5>
  }
  triangle { // #5254
		<-843,-20.7,1490.4>,
		<-0.45,-7.25,1489.1>,
		<-843,11.85,1487.25>
  }
  triangle { // #5255
		<0.15,-42.6,1492.5>,
		<-0.45,-7.25,1489.1>,
		<-843,-20.7,1490.4>
  }
  triangle { // #5256
		<-0.45,-7.25,1489.1>,
		<846.85,-18.2,1490.15>,
		<846.85,11.85,1487.25>
  }
  triangle { // #5257
		<-843,-131.45,340.25>,
		<-843,11.85,1487.25>,
		<-843,-98.9,337.1>
  }
  triangle { // #5258
		<-843,11.85,1487.25>,
		<-843,-131.45,340.25>,
		<-843,-20.7,1490.4>
  }
  smooth_triangle { // #5259
		<-843,11.85,1487.25>, <0.023,0.096,0.995>,
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-843,-98.9,337.1>, <0.023,0.096,0.995>
  }
  smooth_triangle { // #5260
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<846.85,11.85,1487.25>, <-0.023,0.096,0.995>,
		<846.85,-98.9,337.1>, <-0.023,0.096,0.995>
  }
  smooth_triangle { // #5261
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-0.45,-7.25,1489.1>, <0,0.096,0.995>,
		<846.85,11.85,1487.25>, <-0.023,0.096,0.995>
  }
  smooth_triangle { // #5262
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-843,11.85,1487.25>, <0.023,0.096,0.995>,
		<-0.45,-7.25,1489.1>, <0,0.096,0.995>
  }
  triangle { // #5263
		<846.85,-98.9,337.1>,
		<846.85,-18.2,1490.15>,
		<846.85,-128.95,340>
  }
  triangle { // #5264
		<846.85,-18.2,1490.15>,
		<846.85,-98.9,337.1>,
		<846.85,11.85,1487.25>
  }
  smooth_triangle { // #5265
		<846.85,-18.2,1490.15>, <0.029,-0.096,-0.995>,
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<846.85,-128.95,340>, <0.029,-0.096,-0.995>
  }
  smooth_triangle { // #5266
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<-843,-20.7,1490.4>, <-0.026,-0.096,-0.995>,
		<-843,-131.45,340.25>, <-0.026,-0.096,-0.995>
  }
  smooth_triangle { // #5267
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<0.15,-42.6,1492.5>, <0.001,-0.096,-0.995>,
		<-843,-20.7,1490.4>, <-0.026,-0.096,-0.995>
  }
  smooth_triangle { // #5268
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<846.85,-18.2,1490.15>, <0.029,-0.096,-0.995>,
		<0.15,-42.6,1492.5>, <0.001,-0.096,-0.995>
  }
  triangle { // #5269
		<-509.65,-0,1828.55>,
		<-509.65,-10.05,1930.2>,
		<-509.65,-0,1930.2>
  }
  triangle { // #5270
		<-509.65,-10.05,1930.2>,
		<-509.65,-0,1828.55>,
		<-509.65,-10.05,1828.55>
  }
  triangle { // #5271
		<515.05,-0,1930.2>,
		<515.05,-10.05,1828.55>,
		<515.05,-0,1828.55>
  }
  triangle { // #5272
		<515.05,-10.05,1828.55>,
		<515.05,-0,1930.2>,
		<515.05,-10.05,1930.2>
  }
  triangle { // #5273
		<205.95,214.7,1196.6>,
		<1,214.7,1187.4>,
		<205,214.7,1176.45>
  }
  triangle { // #5274
		<-609.95,214.7,1088.65>,
		<-816,214.7,1031.35>,
		<-813.25,214.7,1011.85>
  }
  triangle { // #5275
		<-609.95,214.7,1088.65>,
		<-611.9,214.7,1108.3>,
		<-816,214.7,1031.35>
  }
  triangle { // #5276
		<820.9,214.7,1032.3>,
		<613.55,214.7,1088.65>,
		<818.05,214.7,1011.85>
  }
  triangle { // #5277
		<615.75,214.7,1109>,
		<613.55,214.7,1088.65>,
		<820.9,214.7,1032.3>
  }
  triangle { // #5278
		<-406.5,214.7,1143.55>,
		<-611.9,214.7,1108.3>,
		<-609.95,214.7,1088.65>
  }
  triangle { // #5279
		<-406.5,214.7,1143.55>,
		<-407.7,214.7,1163.3>,
		<-611.9,214.7,1108.3>
  }
  triangle { // #5280
		<615.75,214.7,1109>,
		<409.15,214.7,1143.55>,
		<613.55,214.7,1088.65>
  }
  triangle { // #5281
		<410.75,214.7,1163.8>,
		<409.15,214.7,1143.55>,
		<615.75,214.7,1109>
  }
  triangle { // #5282
		<-202.85,214.7,1176.45>,
		<-407.7,214.7,1163.3>,
		<-406.5,214.7,1143.55>
  }
  triangle { // #5283
		<-202.85,214.7,1176.45>,
		<-203.3,214.7,1196.35>,
		<-407.7,214.7,1163.3>
  }
  triangle { // #5284
		<410.75,214.7,1163.8>,
		<205,214.7,1176.45>,
		<409.15,214.7,1143.55>
  }
  triangle { // #5285
		<205.95,214.7,1196.6>,
		<205,214.7,1176.45>,
		<410.75,214.7,1163.8>
  }
  triangle { // #5286
		<1,214.7,1187.4>,
		<-203.3,214.7,1196.35>,
		<-202.85,214.7,1176.45>
  }
  triangle { // #5287
		<1,214.7,1187.4>,
		<1.25,214.7,1207.45>,
		<-203.3,214.7,1196.35>
  }
  triangle { // #5288
		<1,214.7,1187.4>,
		<205.95,214.7,1196.6>,
		<1.25,214.7,1207.45>
  }
  triangle { // #5289
		<1,277.85,1187.4>,
		<205.95,277.85,1196.6>,
		<205,277.85,1176.45>
  }
  triangle { // #5290
		<-816,277.85,1031.35>,
		<-609.95,277.85,1088.65>,
		<-813.25,277.85,1011.85>
  }
  triangle { // #5291
		<-611.9,277.85,1108.3>,
		<-609.95,277.85,1088.65>,
		<-816,277.85,1031.35>
  }
  triangle { // #5292
		<613.55,277.85,1088.65>,
		<820.9,277.85,1032.3>,
		<818.05,277.85,1011.85>
  }
  triangle { // #5293
		<613.55,277.85,1088.65>,
		<615.75,277.85,1109>,
		<820.9,277.85,1032.3>
  }
  triangle { // #5294
		<-611.9,277.85,1108.3>,
		<-406.5,277.85,1143.55>,
		<-609.95,277.85,1088.65>
  }
  triangle { // #5295
		<-407.7,277.85,1163.3>,
		<-406.5,277.85,1143.55>,
		<-611.9,277.85,1108.3>
  }
  triangle { // #5296
		<409.15,277.85,1143.55>,
		<615.75,277.85,1109>,
		<613.55,277.85,1088.65>
  }
  triangle { // #5297
		<409.15,277.85,1143.55>,
		<410.75,277.85,1163.8>,
		<615.75,277.85,1109>
  }
  triangle { // #5298
		<-407.7,277.85,1163.3>,
		<-202.85,277.85,1176.45>,
		<-406.5,277.85,1143.55>
  }
  triangle { // #5299
		<-203.3,277.85,1196.35>,
		<-202.85,277.85,1176.45>,
		<-407.7,277.85,1163.3>
  }
  triangle { // #5300
		<205,277.85,1176.45>,
		<410.75,277.85,1163.8>,
		<409.15,277.85,1143.55>
  }
  triangle { // #5301
		<205,277.85,1176.45>,
		<205.95,277.85,1196.6>,
		<410.75,277.85,1163.8>
  }
  triangle { // #5302
		<-203.3,277.85,1196.35>,
		<1,277.85,1187.4>,
		<-202.85,277.85,1176.45>
  }
  triangle { // #5303
		<1.25,277.85,1207.45>,
		<1,277.85,1187.4>,
		<-203.3,277.85,1196.35>
  }
  triangle { // #5304
		<205.95,277.85,1196.6>,
		<1,277.85,1187.4>,
		<1.25,277.85,1207.45>
  }
  triangle { // #5305
		<-816,214.7,1031.35>,
		<-813.25,277.85,1011.85>,
		<-813.25,214.7,1011.85>
  }
  triangle { // #5306
		<-813.25,277.85,1011.85>,
		<-816,214.7,1031.35>,
		<-816,277.85,1031.35>
  }
  smooth_triangle { // #5307
		<-813.25,277.85,1011.85>, <0.353,0.935,0>,
		<-609.95,214.7,1088.65>, <0.323,0.946,0>,
		<-813.25,214.7,1011.85>, <0.353,0.935,0>
  }
  smooth_triangle { // #5308
		<613.55,214.7,1088.65>, <-0.306,0.952,0>,
		<818.05,277.85,1011.85>, <-0.352,0.936,0>,
		<818.05,214.7,1011.85>, <-0.352,0.936,0>
  }
  smooth_triangle { // #5309
		<613.55,214.7,1088.65>, <-0.306,0.952,0>,
		<613.55,277.85,1088.65>, <-0.306,0.952,0>,
		<818.05,277.85,1011.85>, <-0.352,0.936,0>
  }
  smooth_triangle { // #5310
		<613.55,214.7,1088.65>, <-0.306,0.952,0>,
		<409.15,277.85,1143.55>, <-0.226,0.974,0>,
		<613.55,277.85,1088.65>, <-0.306,0.952,0>
  }
  smooth_triangle { // #5311
		<409.15,214.7,1143.55>, <-0.193,0.981,0>,
		<409.15,277.85,1143.55>, <-0.226,0.974,0>,
		<613.55,214.7,1088.65>, <-0.306,0.952,0>
  }
  smooth_triangle { // #5312
		<409.15,214.7,1143.55>, <-0.193,0.981,0>,
		<205,277.85,1176.45>, <-0.124,0.992,0>,
		<409.15,277.85,1143.55>, <-0.226,0.974,0>
  }
  smooth_triangle { // #5313
		<205,214.7,1176.45>, <-0.089,0.996,0>,
		<205,277.85,1176.45>, <-0.124,0.992,0>,
		<409.15,214.7,1143.55>, <-0.193,0.981,0>
  }
  smooth_triangle { // #5314
		<205,214.7,1176.45>, <-0.089,0.996,0>,
		<1,277.85,1187.4>, <-0.018,1,0>,
		<205,277.85,1176.45>, <-0.124,0.992,0>
  }
  smooth_triangle { // #5315
		<1,214.7,1187.4>, <0.018,1,0>,
		<1,277.85,1187.4>, <-0.018,1,0>,
		<205,214.7,1176.45>, <-0.089,0.996,0>
  }
  smooth_triangle { // #5316
		<1,214.7,1187.4>, <0.018,1,0>,
		<-202.85,277.85,1176.45>, <0.089,0.996,0>,
		<1,277.85,1187.4>, <-0.018,1,0>
  }
  smooth_triangle { // #5317
		<-202.85,214.7,1176.45>, <0.124,0.992,0>,
		<-202.85,277.85,1176.45>, <0.089,0.996,0>,
		<1,214.7,1187.4>, <0.018,1,0>
  }
  smooth_triangle { // #5318
		<-202.85,214.7,1176.45>, <0.124,0.992,0>,
		<-406.5,277.85,1143.55>, <0.193,0.981,0>,
		<-202.85,277.85,1176.45>, <0.089,0.996,0>
  }
  smooth_triangle { // #5319
		<-406.5,214.7,1143.55>, <0.227,0.974,0>,
		<-406.5,277.85,1143.55>, <0.193,0.981,0>,
		<-202.85,214.7,1176.45>, <0.124,0.992,0>
  }
  smooth_triangle { // #5320
		<-406.5,214.7,1143.55>, <0.227,0.974,0>,
		<-609.95,277.85,1088.65>, <0.292,0.957,0>,
		<-406.5,277.85,1143.55>, <0.193,0.981,0>
  }
  smooth_triangle { // #5321
		<-609.95,214.7,1088.65>, <0.323,0.946,0>,
		<-609.95,277.85,1088.65>, <0.292,0.957,0>,
		<-406.5,214.7,1143.55>, <0.227,0.974,0>
  }
  smooth_triangle { // #5322
		<-609.95,214.7,1088.65>, <0.323,0.946,0>,
		<-813.25,277.85,1011.85>, <0.353,0.935,0>,
		<-609.95,277.85,1088.65>, <0.292,0.957,0>
  }
  triangle { // #5323
		<818.05,214.7,1011.85>,
		<820.9,277.85,1032.3>,
		<820.9,214.7,1032.3>
  }
  triangle { // #5324
		<820.9,277.85,1032.3>,
		<818.05,214.7,1011.85>,
		<818.05,277.85,1011.85>
  }
  smooth_triangle { // #5325
		<820.9,277.85,1032.3>, <0.35,-0.937,0>,
		<615.75,214.7,1109>, <0.32,-0.947,0>,
		<820.9,214.7,1032.3>, <0.35,-0.937,0>
  }
  smooth_triangle { // #5326
		<-611.9,214.7,1108.3>, <-0.307,-0.952,0>,
		<-816,277.85,1031.35>, <-0.353,-0.936,0>,
		<-816,214.7,1031.35>, <-0.353,-0.936,0>
  }
  smooth_triangle { // #5327
		<-611.9,214.7,1108.3>, <-0.307,-0.952,0>,
		<-611.9,277.85,1108.3>, <-0.307,-0.952,0>,
		<-816,277.85,1031.35>, <-0.353,-0.936,0>
  }
  smooth_triangle { // #5328
		<-611.9,214.7,1108.3>, <-0.307,-0.952,0>,
		<-407.7,277.85,1163.3>, <-0.227,-0.974,0>,
		<-611.9,277.85,1108.3>, <-0.307,-0.952,0>
  }
  smooth_triangle { // #5329
		<-407.7,214.7,1163.3>, <-0.193,-0.981,0>,
		<-407.7,277.85,1163.3>, <-0.227,-0.974,0>,
		<-611.9,214.7,1108.3>, <-0.307,-0.952,0>
  }
  smooth_triangle { // #5330
		<-407.7,214.7,1163.3>, <-0.193,-0.981,0>,
		<-203.3,277.85,1196.35>, <-0.125,-0.992,0>,
		<-407.7,277.85,1163.3>, <-0.227,-0.974,0>
  }
  smooth_triangle { // #5331
		<-203.3,214.7,1196.35>, <-0.089,-0.996,0>,
		<-203.3,277.85,1196.35>, <-0.125,-0.992,0>,
		<-407.7,214.7,1163.3>, <-0.193,-0.981,0>
  }
  smooth_triangle { // #5332
		<-203.3,214.7,1196.35>, <-0.089,-0.996,0>,
		<1.25,277.85,1207.45>, <-0.018,-1,0>,
		<-203.3,277.85,1196.35>, <-0.125,-0.992,0>
  }
  smooth_triangle { // #5333
		<1.25,214.7,1207.45>, <0.017,-1,0>,
		<1.25,277.85,1207.45>, <-0.018,-1,0>,
		<-203.3,214.7,1196.35>, <-0.089,-0.996,0>
  }
  smooth_triangle { // #5334
		<1.25,214.7,1207.45>, <0.017,-1,0>,
		<205.95,277.85,1196.6>, <0.088,-0.996,0>,
		<1.25,277.85,1207.45>, <-0.018,-1,0>
  }
  smooth_triangle { // #5335
		<205.95,214.7,1196.6>, <0.123,-0.992,0>,
		<205.95,277.85,1196.6>, <0.088,-0.996,0>,
		<1.25,214.7,1207.45>, <0.017,-1,0>
  }
  smooth_triangle { // #5336
		<205.95,214.7,1196.6>, <0.123,-0.992,0>,
		<410.75,277.85,1163.8>, <0.192,-0.981,0>,
		<205.95,277.85,1196.6>, <0.088,-0.996,0>
  }
  smooth_triangle { // #5337
		<410.75,214.7,1163.8>, <0.225,-0.974,0>,
		<410.75,277.85,1163.8>, <0.192,-0.981,0>,
		<205.95,214.7,1196.6>, <0.123,-0.992,0>
  }
  smooth_triangle { // #5338
		<410.75,214.7,1163.8>, <0.225,-0.974,0>,
		<615.75,277.85,1109>, <0.289,-0.957,0>,
		<410.75,277.85,1163.8>, <0.192,-0.981,0>
  }
  smooth_triangle { // #5339
		<615.75,214.7,1109>, <0.32,-0.947,0>,
		<615.75,277.85,1109>, <0.289,-0.957,0>,
		<410.75,214.7,1163.8>, <0.225,-0.974,0>
  }
  smooth_triangle { // #5340
		<615.75,214.7,1109>, <0.32,-0.947,0>,
		<820.9,277.85,1032.3>, <0.35,-0.937,0>,
		<615.75,277.85,1109>, <0.289,-0.957,0>
  }
  triangle { // #5341
		<-0.45,-11.75,1489.05>,
		<846.85,-22.7,1490.1>,
		<0.15,-47.1,1492.45>
  }
  triangle { // #5342
		<-0.45,-11.75,1489.05>,
		<-843,-25.2,1490.35>,
		<-843,7.35,1487.2>
  }
  triangle { // #5343
		<-0.45,-11.75,1489.05>,
		<0.15,-47.1,1492.45>,
		<-843,-25.2,1490.35>
  }
  triangle { // #5344
		<846.85,-22.7,1490.1>,
		<-0.45,-11.75,1489.05>,
		<846.85,7.35,1487.2>
  }
  triangle { // #5345
		<-843,-25.2,1490.35>,
		<-843,50.75,1937.75>,
		<-843,7.35,1487.2>
  }
  triangle { // #5346
		<-843,50.75,1937.75>,
		<-843,-25.2,1490.35>,
		<-843,18.2,1940.9>
  }
  triangle { // #5347
		<846.85,7.35,1487.2>,
		<846.85,20.7,1940.65>,
		<846.85,-22.7,1490.1>
  }
  triangle { // #5348
		<846.85,20.7,1940.65>,
		<846.85,7.35,1487.2>,
		<846.85,50.75,1937.75>
  }
  triangle { // #5349
		<-843,18.2,1940.9>,
		<-510.65,-0,1900.55>,
		<-510.65,4,1942.25>
  }
  triangle { // #5350
		<-843,-25.2,1490.35>,
		<-510.65,-0,1900.55>,
		<-843,18.2,1940.9>
  }
  smooth_triangle { // #5351
		<0.15,-47.1,1492.45>, <-0.003,-0.09,-0.996>,
		<-510.65,-0,1900.55>, <-0.031,-0.088,-0.996>,
		<-843,-25.2,1490.35>, <-0.034,-0.089,-0.995>
  }
  smooth_triangle { // #5352
		<511.3,-0,1885.05>, <0.032,-0.096,-0.995>,
		<846.85,20.7,1940.65>, <0.045,-0.096,-0.994>,
		<511.3,5.5,1942.1>, <0.045,-0.096,-0.994>
  }
  smooth_triangle { // #5353
		<511.3,-0,1885.05>, <0.032,-0.096,-0.995>,
		<846.85,-22.7,1490.1>, <0.037,-0.089,-0.995>,
		<846.85,20.7,1940.65>, <0.045,-0.096,-0.994>
  }
  smooth_triangle { // #5354
		<511.3,-0,1885.05>, <0.027,-0.096,-0.995>,
		<0.15,-47.1,1492.45>, <-0.003,-0.09,-0.996>,
		<846.85,-22.7,1490.1>, <0.037,-0.089,-0.995>
  }
  smooth_triangle { // #5355
		<0.15,-47.1,1492.45>, <-0.003,-0.09,-0.996>,
		<-361.4,-0,1942.65>, <-0.008,-0.097,-0.995>,
		<-510.65,-0,1900.55>, <-0.034,-0.09,-0.995>
  }
  smooth_triangle { // #5356
		<511.3,-0,1885.05>, <0.027,-0.096,-0.995>,
		<-361.4,-0,1942.65>, <-0.008,-0.097,-0.995>,
		<0.15,-47.1,1492.45>, <-0.003,-0.09,-0.996>
  }
  smooth_triangle { // #5357
		<-510.65,-0,1537.75>, <0.022,0.054,0.998>,
		<-843,50.75,1937.75>, <0.037,0.096,0.995>,
		<-510.65,38.65,1938.95>, <0.037,0.096,0.995>
  }
  smooth_triangle { // #5358
		<846.85,7.35,1487.2>, <-0.032,0.065,0.997>,
		<511.3,38.6,1938.95>, <-0.036,0.096,0.995>,
		<846.85,50.75,1937.75>, <-0.036,0.096,0.995>
  }
  smooth_triangle { // #5359
		<846.85,7.35,1487.2>, <-0.032,0.065,0.997>,
		<511.3,-0,1537.85>, <-0.019,0.043,0.999>,
		<511.3,38.6,1938.95>, <-0.036,0.096,0.995>
  }
  smooth_triangle { // #5360
		<-0.45,-11.75,1489.05>, <0,0.039,0.999>,
		<511.3,-0,1537.85>, <-0.025,0.058,0.998>,
		<846.85,7.35,1487.2>, <-0.032,0.065,0.997>
  }
  smooth_triangle { // #5361
		<-0.45,-11.75,1489.05>, <-0,0.058,0.998>,
		<269.3,-0,1590.65>, <-0.005,0.034,0.999>,
		<511.3,-0,1537.85>, <-0.019,0.043,0.999>
  }
  smooth_triangle { // #5362
		<-0.45,-11.75,1489.05>, <-0,0.058,0.998>,
		<18.5,-0,1610.85>, <-0,0.048,0.999>,
		<269.3,-0,1590.65>, <-0.005,0.034,0.999>
  }
  smooth_triangle { // #5363
		<-0.45,-11.75,1489.05>, <-0,0.058,0.998>,
		<-246.5,-0,1593.95>, <0.004,0.029,1>,
		<18.5,-0,1610.85>, <-0,0.048,0.999>
  }
  smooth_triangle { // #5364
		<-0.45,-11.75,1489.05>, <-0,0.058,0.998>,
		<-510.65,-0,1537.75>, <0.022,0.054,0.998>,
		<-246.5,-0,1593.95>, <0.004,0.029,1>
  }
  smooth_triangle { // #5365
		<-843,7.35,1487.2>, <0.03,0.05,0.998>,
		<-510.65,-0,1537.75>, <0.028,0.067,0.997>,
		<-0.45,-11.75,1489.05>, <0,0.039,0.999>
  }
  smooth_triangle { // #5366
		<-843,50.75,1937.75>, <0.037,0.096,0.995>,
		<-510.65,-0,1537.75>, <0.022,0.054,0.998>,
		<-843,7.35,1487.2>, <0.03,0.05,0.998>
  }
  triangle { // #5367
		<316.6,-0,1942.65>,
		<-361.4,-0,1942.65>,
		<0.15,-3.7,1943>
  }
  triangle { // #5368
		<511.3,38.6,1938.95>,
		<846.85,20.7,1940.65>,
		<846.85,50.75,1937.75>
  }
  triangle { // #5369
		<846.85,20.7,1940.65>,
		<511.3,38.6,1938.95>,
		<511.3,5.5,1942.1>
  }
  triangle { // #5370
		<-510.65,38.65,1938.95>,
		<-843,18.2,1940.9>,
		<-510.65,4,1942.25>
  }
  triangle { // #5371
		<-843,18.2,1940.9>,
		<-510.65,38.65,1938.95>,
		<-843,50.75,1937.75>
  }
  smooth_triangle { // #5372
		<269.3,-0,1590.65>, <-0.005,0.034,0.999>,
		<316.6,-0,1942.65>, <0,0,1>,
		<511.3,-0,1885.05>, <0,0,1>
  }
  smooth_triangle { // #5373
		<269.3,-0,1590.65>, <-0.005,0.034,0.999>,
		<511.3,-0,1885.05>, <0,0,1>,
		<511.3,-0,1537.85>, <-0.019,0.043,0.999>
  }
  smooth_triangle { // #5374
		<-510.65,-0,1900.55>, <0,0,1>,
		<-246.5,-0,1593.95>, <0.004,0.029,1>,
		<-510.65,-0,1537.75>, <0.022,0.054,0.998>
  }
  smooth_triangle { // #5375
		<-361.4,-0,1942.65>, <0,0,1>,
		<-246.5,-0,1593.95>, <0.004,0.029,1>,
		<-510.65,-0,1900.55>, <0,0,1>
  }
  smooth_triangle { // #5376
		<316.6,-0,1942.65>, <0,0,1>,
		<-246.5,-0,1593.95>, <0.003,0.015,1>,
		<-361.4,-0,1942.65>, <0,0,1>
  }
  smooth_triangle { // #5377
		<316.6,-0,1942.65>, <0,0,1>,
		<18.5,-0,1610.85>, <0,0,1>,
		<-246.5,-0,1593.95>, <0.003,0.015,1>
  }
  smooth_triangle { // #5378
		<316.6,-0,1942.65>, <0,0,1>,
		<269.3,-0,1590.65>, <-0.005,0.034,0.999>,
		<18.5,-0,1610.85>, <-0,0.048,0.999>
  }
  triangle { // #5379
		<511.3,38.6,1938.95>,
		<511.3,-0,1885.05>,
		<511.3,5.5,1942.1>
  }
  triangle { // #5380
		<511.3,-0,1885.05>,
		<511.3,38.6,1938.95>,
		<511.3,-0,1537.85>
  }
  triangle { // #5381
		<-510.65,38.65,1938.95>,
		<-510.65,-0,1900.55>,
		<-510.65,-0,1537.75>
  }
  triangle { // #5382
		<-510.65,-0,1900.55>,
		<-510.65,38.65,1938.95>,
		<-510.65,4,1942.25>
  }
  triangle { // #5383
		<-510.65,-0,1849.95>,
		<-510.65,-15.1,1950.55>,
		<-510.65,-0,1950.55>
  }
  triangle { // #5384
		<-510.65,-15.1,1950.55>,
		<-510.65,-0,1849.95>,
		<-510.65,-15.1,1849.95>
  }
  triangle { // #5385
		<-510.65,-0,1950.55>,
		<510.05,-15.1,1950.55>,
		<510.05,-0,1950.55>
  }
  triangle { // #5386
		<510.05,-15.1,1950.55>,
		<-510.65,-0,1950.55>,
		<-510.65,-15.1,1950.55>
  }
  triangle { // #5387
		<510.05,-0,1950.55>,
		<510.05,-15.1,1849.95>,
		<510.05,-0,1849.95>
  }
  triangle { // #5388
		<510.05,-15.1,1849.95>,
		<510.05,-0,1950.55>,
		<510.05,-15.1,1950.55>
  }
  triangle { // #5389
		<1.5,277.85,1180.5>,
		<-203.5,277.85,1201.1>,
		<-202.3,277.85,1169.55>
  }
  triangle { // #5390
		<822.15,277.85,1038.25>,
		<614.5,277.85,1082.1>,
		<819.3,277.85,1005.6>
  }
  triangle { // #5391
		<616.7,277.85,1114.25>,
		<614.5,277.85,1082.1>,
		<822.15,277.85,1038.25>
  }
  triangle { // #5392
		<-609.25,277.85,1082.1>,
		<-817,277.85,1038.25>,
		<-812.35,277.85,1005.6>
  }
  triangle { // #5393
		<-609.25,277.85,1082.1>,
		<-612.65,277.85,1114.25>,
		<-817,277.85,1038.25>
  }
  triangle { // #5394
		<616.7,277.85,1114.25>,
		<409.95,277.85,1136.75>,
		<614.5,277.85,1082.1>
  }
  triangle { // #5395
		<411.4,277.85,1168.5>,
		<409.95,277.85,1136.75>,
		<616.7,277.85,1114.25>
  }
  triangle { // #5396
		<-405.9,277.85,1136.75>,
		<-612.65,277.85,1114.25>,
		<-609.25,277.85,1082.1>
  }
  triangle { // #5397
		<-405.9,277.85,1136.75>,
		<-408.15,277.85,1168.5>,
		<-612.65,277.85,1114.25>
  }
  triangle { // #5398
		<411.4,277.85,1168.5>,
		<205.6,277.85,1169.55>,
		<409.95,277.85,1136.75>
  }
  triangle { // #5399
		<206.3,277.85,1201.1>,
		<205.6,277.85,1169.55>,
		<411.4,277.85,1168.5>
  }
  triangle { // #5400
		<-202.3,277.85,1169.55>,
		<-408.15,277.85,1168.5>,
		<-405.9,277.85,1136.75>
  }
  triangle { // #5401
		<-202.3,277.85,1169.55>,
		<-203.5,277.85,1201.1>,
		<-408.15,277.85,1168.5>
  }
  triangle { // #5402
		<206.3,277.85,1201.1>,
		<1.5,277.85,1180.5>,
		<205.6,277.85,1169.55>
  }
  triangle { // #5403
		<1.3,277.85,1211.95>,
		<1.5,277.85,1180.5>,
		<206.3,277.85,1201.1>
  }
  triangle { // #5404
		<-203.5,277.85,1201.1>,
		<1.5,277.85,1180.5>,
		<1.3,277.85,1211.95>
  }
  triangle { // #5405
		<-203.5,280.4,1201.1>,
		<1.5,280.4,1180.5>,
		<-202.3,280.4,1169.55>
  }
  triangle { // #5406
		<614.5,280.4,1082.1>,
		<822.15,280.4,1038.25>,
		<819.3,280.4,1005.6>
  }
  triangle { // #5407
		<614.5,280.4,1082.1>,
		<616.7,280.4,1114.25>,
		<822.15,280.4,1038.25>
  }
  triangle { // #5408
		<-817,280.4,1038.25>,
		<-609.25,280.4,1082.1>,
		<-812.35,280.4,1005.6>
  }
  triangle { // #5409
		<-612.65,280.4,1114.25>,
		<-609.25,280.4,1082.1>,
		<-817,280.4,1038.25>
  }
  triangle { // #5410
		<409.95,280.4,1136.75>,
		<616.7,280.4,1114.25>,
		<614.5,280.4,1082.1>
  }
  triangle { // #5411
		<409.95,280.4,1136.75>,
		<411.4,280.4,1168.5>,
		<616.7,280.4,1114.25>
  }
  triangle { // #5412
		<-612.65,280.4,1114.25>,
		<-405.9,280.4,1136.75>,
		<-609.25,280.4,1082.1>
  }
  triangle { // #5413
		<-408.15,280.4,1168.5>,
		<-405.9,280.4,1136.75>,
		<-612.65,280.4,1114.25>
  }
  triangle { // #5414
		<205.6,280.4,1169.55>,
		<411.4,280.4,1168.5>,
		<409.95,280.4,1136.75>
  }
  triangle { // #5415
		<205.6,280.4,1169.55>,
		<206.3,280.4,1201.1>,
		<411.4,280.4,1168.5>
  }
  triangle { // #5416
		<-408.15,280.4,1168.5>,
		<-202.3,280.4,1169.55>,
		<-405.9,280.4,1136.75>
  }
  triangle { // #5417
		<-203.5,280.4,1201.1>,
		<-202.3,280.4,1169.55>,
		<-408.15,280.4,1168.5>
  }
  triangle { // #5418
		<1.5,280.4,1180.5>,
		<206.3,280.4,1201.1>,
		<205.6,280.4,1169.55>
  }
  triangle { // #5419
		<1.5,280.4,1180.5>,
		<1.3,280.4,1211.95>,
		<206.3,280.4,1201.1>
  }
  triangle { // #5420
		<1.5,280.4,1180.5>,
		<-203.5,280.4,1201.1>,
		<1.3,280.4,1211.95>
  }
  triangle { // #5421
		<-817,277.85,1038.25>,
		<-812.35,280.4,1005.6>,
		<-812.35,277.85,1005.6>
  }
  triangle { // #5422
		<-812.35,280.4,1005.6>,
		<-817,277.85,1038.25>,
		<-817,280.4,1038.25>
  }
  smooth_triangle { // #5423
		<-812.35,280.4,1005.6>, <0.353,0.936,0>,
		<-609.25,277.85,1082.1>, <0.322,0.947,0>,
		<-812.35,277.85,1005.6>, <0.353,0.936,0>
  }
  smooth_triangle { // #5424
		<614.5,277.85,1082.1>, <-0.304,0.953,0>,
		<819.3,280.4,1005.6>, <-0.35,0.937,0>,
		<819.3,277.85,1005.6>, <-0.35,0.937,0>
  }
  smooth_triangle { // #5425
		<614.5,277.85,1082.1>, <-0.304,0.953,0>,
		<614.5,280.4,1082.1>, <-0.304,0.953,0>,
		<819.3,280.4,1005.6>, <-0.35,0.937,0>
  }
  smooth_triangle { // #5426
		<614.5,277.85,1082.1>, <-0.304,0.953,0>,
		<409.95,280.4,1136.75>, <-0.225,0.974,0>,
		<614.5,280.4,1082.1>, <-0.304,0.953,0>
  }
  smooth_triangle { // #5427
		<409.95,277.85,1136.75>, <-0.192,0.981,0>,
		<409.95,280.4,1136.75>, <-0.225,0.974,0>,
		<614.5,277.85,1082.1>, <-0.304,0.953,0>
  }
  smooth_triangle { // #5428
		<409.95,277.85,1136.75>, <-0.192,0.981,0>,
		<205.6,280.4,1169.55>, <-0.124,0.992,0>,
		<409.95,280.4,1136.75>, <-0.225,0.974,0>
  }
  smooth_triangle { // #5429
		<205.6,277.85,1169.55>, <-0.089,0.996,0>,
		<205.6,280.4,1169.55>, <-0.124,0.992,0>,
		<409.95,277.85,1136.75>, <-0.192,0.981,0>
  }
  smooth_triangle { // #5430
		<205.6,277.85,1169.55>, <-0.089,0.996,0>,
		<1.5,280.4,1180.5>, <-0.018,1,0>,
		<205.6,280.4,1169.55>, <-0.124,0.992,0>
  }
  smooth_triangle { // #5431
		<1.5,277.85,1180.5>, <0.018,1,0>,
		<1.5,280.4,1180.5>, <-0.018,1,0>,
		<205.6,277.85,1169.55>, <-0.089,0.996,0>
  }
  smooth_triangle { // #5432
		<1.5,277.85,1180.5>, <0.018,1,0>,
		<-202.3,280.4,1169.55>, <0.089,0.996,0>,
		<1.5,280.4,1180.5>, <-0.018,1,0>
  }
  smooth_triangle { // #5433
		<-202.3,277.85,1169.55>, <0.124,0.992,0>,
		<-202.3,280.4,1169.55>, <0.089,0.996,0>,
		<1.5,277.85,1180.5>, <0.018,1,0>
  }
  smooth_triangle { // #5434
		<-202.3,277.85,1169.55>, <0.124,0.992,0>,
		<-405.9,280.4,1136.75>, <0.193,0.981,0>,
		<-202.3,280.4,1169.55>, <0.089,0.996,0>
  }
  smooth_triangle { // #5435
		<-405.9,277.85,1136.75>, <0.226,0.974,0>,
		<-405.9,280.4,1136.75>, <0.193,0.981,0>,
		<-202.3,277.85,1169.55>, <0.124,0.992,0>
  }
  smooth_triangle { // #5436
		<-405.9,277.85,1136.75>, <0.226,0.974,0>,
		<-609.25,280.4,1082.1>, <0.291,0.957,0>,
		<-405.9,280.4,1136.75>, <0.193,0.981,0>
  }
  smooth_triangle { // #5437
		<-609.25,277.85,1082.1>, <0.322,0.947,0>,
		<-609.25,280.4,1082.1>, <0.291,0.957,0>,
		<-405.9,277.85,1136.75>, <0.226,0.974,0>
  }
  smooth_triangle { // #5438
		<-609.25,277.85,1082.1>, <0.322,0.947,0>,
		<-812.35,280.4,1005.6>, <0.353,0.936,0>,
		<-609.25,280.4,1082.1>, <0.291,0.957,0>
  }
  triangle { // #5439
		<819.3,277.85,1005.6>,
		<822.15,280.4,1038.25>,
		<822.15,277.85,1038.25>
  }
  triangle { // #5440
		<822.15,280.4,1038.25>,
		<819.3,277.85,1005.6>,
		<819.3,280.4,1005.6>
  }
  smooth_triangle { // #5441
		<822.15,280.4,1038.25>, <0.347,-0.938,0>,
		<616.7,277.85,1114.25>, <0.317,-0.949,0>,
		<822.15,277.85,1038.25>, <0.347,-0.938,0>
  }
  smooth_triangle { // #5442
		<-612.65,277.85,1114.25>, <-0.303,-0.953,0>,
		<-817,280.4,1038.25>, <-0.349,-0.937,0>,
		<-817,277.85,1038.25>, <-0.349,-0.937,0>
  }
  smooth_triangle { // #5443
		<-612.65,277.85,1114.25>, <-0.303,-0.953,0>,
		<-612.65,280.4,1114.25>, <-0.303,-0.953,0>,
		<-817,280.4,1038.25>, <-0.349,-0.937,0>
  }
  smooth_triangle { // #5444
		<-612.65,277.85,1114.25>, <-0.303,-0.953,0>,
		<-408.15,280.4,1168.5>, <-0.224,-0.975,0>,
		<-612.65,280.4,1114.25>, <-0.303,-0.953,0>
  }
  smooth_triangle { // #5445
		<-408.15,277.85,1168.5>, <-0.19,-0.982,0>,
		<-408.15,280.4,1168.5>, <-0.224,-0.975,0>,
		<-612.65,277.85,1114.25>, <-0.303,-0.953,0>
  }
  smooth_triangle { // #5446
		<-408.15,277.85,1168.5>, <-0.19,-0.982,0>,
		<-203.5,280.4,1201.1>, <-0.123,-0.992,0>,
		<-408.15,280.4,1168.5>, <-0.224,-0.975,0>
  }
  smooth_triangle { // #5447
		<-203.5,277.85,1201.1>, <-0.088,-0.996,0>,
		<-203.5,280.4,1201.1>, <-0.123,-0.992,0>,
		<-408.15,277.85,1168.5>, <-0.19,-0.982,0>
  }
  smooth_triangle { // #5448
		<-203.5,277.85,1201.1>, <-0.088,-0.996,0>,
		<1.3,280.4,1211.95>, <-0,-1,0>,
		<-203.5,280.4,1201.1>, <-0.123,-0.992,0>
  }
  smooth_triangle { // #5449
		<1.3,277.85,1211.95>, <-0,-1,0>,
		<1.3,280.4,1211.95>, <-0,-1,0>,
		<-203.5,277.85,1201.1>, <-0.088,-0.996,0>
  }
  smooth_triangle { // #5450
		<206.3,277.85,1201.1>, <0.105,-0.994,0>,
		<1.3,280.4,1211.95>, <-0,-1,0>,
		<1.3,277.85,1211.95>, <-0,-1,0>
  }
  smooth_triangle { // #5451
		<206.3,277.85,1201.1>, <0.105,-0.994,0>,
		<206.3,280.4,1201.1>, <0.105,-0.994,0>,
		<1.3,280.4,1211.95>, <-0,-1,0>
  }
  smooth_triangle { // #5452
		<206.3,277.85,1201.1>, <0.105,-0.994,0>,
		<411.4,280.4,1168.5>, <0.19,-0.982,0>,
		<206.3,280.4,1201.1>, <0.105,-0.994,0>
  }
  smooth_triangle { // #5453
		<411.4,277.85,1168.5>, <0.223,-0.975,0>,
		<411.4,280.4,1168.5>, <0.19,-0.982,0>,
		<206.3,277.85,1201.1>, <0.105,-0.994,0>
  }
  smooth_triangle { // #5454
		<411.4,277.85,1168.5>, <0.223,-0.975,0>,
		<616.7,280.4,1114.25>, <0.286,-0.958,0>,
		<411.4,280.4,1168.5>, <0.19,-0.982,0>
  }
  smooth_triangle { // #5455
		<616.7,277.85,1114.25>, <0.317,-0.949,0>,
		<616.7,280.4,1114.25>, <0.286,-0.958,0>,
		<411.4,277.85,1168.5>, <0.223,-0.975,0>
  }
  smooth_triangle { // #5456
		<616.7,277.85,1114.25>, <0.317,-0.949,0>,
		<822.15,280.4,1038.25>, <0.347,-0.938,0>,
		<616.7,280.4,1114.25>, <0.286,-0.958,0>
  }
  triangle { // #5457
		<1.4,214.7,1173.9>,
		<-202.75,214.7,1182.85>,
		<-202.05,214.7,1163>
  }
  triangle { // #5458
		<818.05,214.7,1014.7>,
		<612.7,214.7,1075.7>,
		<816.8,214.7,999.3>
  }
  triangle { // #5459
		<613.65,214.7,1093.2>,
		<612.7,214.7,1075.7>,
		<818.05,214.7,1014.7>
  }
  triangle { // #5460
		<-608.5,214.7,1075.7>,
		<-813.6,214.7,1014.4>,
		<-811.45,214.7,999.3>
  }
  triangle { // #5461
		<-608.5,214.7,1075.7>,
		<-610.1,214.7,1093>,
		<-813.6,214.7,1014.4>
  }
  triangle { // #5462
		<613.65,214.7,1093.2>,
		<408.8,214.7,1130.25>,
		<612.7,214.7,1075.7>
  }
  triangle { // #5463
		<409.35,214.7,1149.3>,
		<408.8,214.7,1130.25>,
		<613.65,214.7,1093.2>
  }
  triangle { // #5464
		<-405.35,214.7,1130.25>,
		<-610.1,214.7,1093>,
		<-608.5,214.7,1075.7>
  }
  triangle { // #5465
		<-405.35,214.7,1130.25>,
		<-406.5,214.7,1149.15>,
		<-610.1,214.7,1093>
  }
  triangle { // #5466
		<409.35,214.7,1149.3>,
		<205,214.7,1163>,
		<408.8,214.7,1130.25>
  }
  triangle { // #5467
		<205.2,214.7,1182.9>,
		<205,214.7,1163>,
		<409.35,214.7,1149.3>
  }
  triangle { // #5468
		<-202.05,214.7,1163>,
		<-406.5,214.7,1149.15>,
		<-405.35,214.7,1130.25>
  }
  triangle { // #5469
		<-202.05,214.7,1163>,
		<-202.75,214.7,1182.85>,
		<-406.5,214.7,1149.15>
  }
  triangle { // #5470
		<205.2,214.7,1182.9>,
		<1.4,214.7,1173.9>,
		<205,214.7,1163>
  }
  triangle { // #5471
		<1.15,214.7,1194.1>,
		<1.4,214.7,1173.9>,
		<205.2,214.7,1182.9>
  }
  triangle { // #5472
		<-202.75,214.7,1182.85>,
		<1.4,214.7,1173.9>,
		<1.15,214.7,1194.1>
  }
  triangle { // #5473
		<-202.75,234.5,1182.85>,
		<1.4,234.5,1173.9>,
		<-202.05,234.5,1163>
  }
  triangle { // #5474
		<612.7,234.5,1075.7>,
		<818.05,234.5,1014.7>,
		<816.8,234.5,999.3>
  }
  triangle { // #5475
		<612.7,234.5,1075.7>,
		<613.65,234.5,1093.2>,
		<818.05,234.5,1014.7>
  }
  triangle { // #5476
		<-813.6,234.5,1014.4>,
		<-608.5,234.5,1075.7>,
		<-811.45,234.5,999.3>
  }
  triangle { // #5477
		<-610.1,234.5,1093>,
		<-608.5,234.5,1075.7>,
		<-813.6,234.5,1014.4>
  }
  triangle { // #5478
		<408.8,234.5,1130.25>,
		<613.65,234.5,1093.2>,
		<612.7,234.5,1075.7>
  }
  triangle { // #5479
		<408.8,234.5,1130.25>,
		<409.35,234.5,1149.3>,
		<613.65,234.5,1093.2>
  }
  triangle { // #5480
		<-610.1,234.5,1093>,
		<-405.35,234.5,1130.25>,
		<-608.5,234.5,1075.7>
  }
  triangle { // #5481
		<-406.5,234.5,1149.15>,
		<-405.35,234.5,1130.25>,
		<-610.1,234.5,1093>
  }
  triangle { // #5482
		<205,234.5,1163>,
		<409.35,234.5,1149.3>,
		<408.8,234.5,1130.25>
  }
  triangle { // #5483
		<205,234.5,1163>,
		<205.2,234.5,1182.9>,
		<409.35,234.5,1149.3>
  }
  triangle { // #5484
		<-406.5,234.5,1149.15>,
		<-202.05,234.5,1163>,
		<-405.35,234.5,1130.25>
  }
  triangle { // #5485
		<-202.75,234.5,1182.85>,
		<-202.05,234.5,1163>,
		<-406.5,234.5,1149.15>
  }
  triangle { // #5486
		<1.4,234.5,1173.9>,
		<205.2,234.5,1182.9>,
		<205,234.5,1163>
  }
  triangle { // #5487
		<1.4,234.5,1173.9>,
		<1.15,234.5,1194.1>,
		<205.2,234.5,1182.9>
  }
  triangle { // #5488
		<1.4,234.5,1173.9>,
		<-202.75,234.5,1182.85>,
		<1.15,234.5,1194.1>
  }
  triangle { // #5489
		<-813.6,214.7,1014.4>,
		<-811.45,234.5,999.3>,
		<-811.45,214.7,999.3>
  }
  triangle { // #5490
		<-811.45,234.5,999.3>,
		<-813.6,214.7,1014.4>,
		<-813.6,234.5,1014.4>
  }
  smooth_triangle { // #5491
		<-811.45,234.5,999.3>, <0.352,0.936,0>,
		<-608.5,214.7,1075.7>, <0.322,0.947,0>,
		<-811.45,214.7,999.3>, <0.352,0.936,0>
  }
  smooth_triangle { // #5492
		<612.7,214.7,1075.7>, <-0.305,0.952,0>,
		<816.8,234.5,999.3>, <-0.351,0.937,0>,
		<816.8,214.7,999.3>, <-0.351,0.937,0>
  }
  smooth_triangle { // #5493
		<612.7,214.7,1075.7>, <-0.305,0.952,0>,
		<612.7,234.5,1075.7>, <-0.305,0.952,0>,
		<816.8,234.5,999.3>, <-0.351,0.937,0>
  }
  smooth_triangle { // #5494
		<612.7,214.7,1075.7>, <-0.305,0.952,0>,
		<408.8,234.5,1130.25>, <-0.225,0.974,0>,
		<612.7,234.5,1075.7>, <-0.305,0.952,0>
  }
  smooth_triangle { // #5495
		<408.8,214.7,1130.25>, <-0.192,0.981,0>,
		<408.8,234.5,1130.25>, <-0.225,0.974,0>,
		<612.7,214.7,1075.7>, <-0.305,0.952,0>
  }
  smooth_triangle { // #5496
		<408.8,214.7,1130.25>, <-0.192,0.981,0>,
		<205,234.5,1163>, <-0.124,0.992,0>,
		<408.8,234.5,1130.25>, <-0.225,0.974,0>
  }
  smooth_triangle { // #5497
		<205,214.7,1163>, <-0.089,0.996,0>,
		<205,234.5,1163>, <-0.124,0.992,0>,
		<408.8,214.7,1130.25>, <-0.192,0.981,0>
  }
  smooth_triangle { // #5498
		<205,214.7,1163>, <-0.089,0.996,0>,
		<1.4,234.5,1173.9>, <-0.018,1,0>,
		<205,234.5,1163>, <-0.124,0.992,0>
  }
  smooth_triangle { // #5499
		<1.4,214.7,1173.9>, <0.018,1,0>,
		<1.4,234.5,1173.9>, <-0.018,1,0>,
		<205,214.7,1163>, <-0.089,0.996,0>
  }
  smooth_triangle { // #5500
		<1.4,214.7,1173.9>, <0.018,1,0>,
		<-202.05,234.5,1163>, <0.089,0.996,0>,
		<1.4,234.5,1173.9>, <-0.018,1,0>
  }
  smooth_triangle { // #5501
		<-202.05,214.7,1163>, <0.124,0.992,0>,
		<-202.05,234.5,1163>, <0.089,0.996,0>,
		<1.4,214.7,1173.9>, <0.018,1,0>
  }
  smooth_triangle { // #5502
		<-202.05,214.7,1163>, <0.124,0.992,0>,
		<-405.35,234.5,1130.25>, <0.193,0.981,0>,
		<-202.05,234.5,1163>, <0.089,0.996,0>
  }
  smooth_triangle { // #5503
		<-405.35,214.7,1130.25>, <0.226,0.974,0>,
		<-405.35,234.5,1130.25>, <0.193,0.981,0>,
		<-202.05,214.7,1163>, <0.124,0.992,0>
  }
  smooth_triangle { // #5504
		<-405.35,214.7,1130.25>, <0.226,0.974,0>,
		<-608.5,234.5,1075.7>, <0.291,0.957,0>,
		<-405.35,234.5,1130.25>, <0.193,0.981,0>
  }
  smooth_triangle { // #5505
		<-608.5,214.7,1075.7>, <0.322,0.947,0>,
		<-608.5,234.5,1075.7>, <0.291,0.957,0>,
		<-405.35,214.7,1130.25>, <0.226,0.974,0>
  }
  smooth_triangle { // #5506
		<-608.5,214.7,1075.7>, <0.322,0.947,0>,
		<-811.45,234.5,999.3>, <0.352,0.936,0>,
		<-608.5,234.5,1075.7>, <0.291,0.957,0>
  }
  triangle { // #5507
		<816.8,214.7,999.3>,
		<818.05,234.5,1014.7>,
		<818.05,214.7,1014.7>
  }
  triangle { // #5508
		<818.05,234.5,1014.7>,
		<816.8,214.7,999.3>,
		<816.8,234.5,999.3>
  }
  smooth_triangle { // #5509
		<818.05,234.5,1014.7>, <0.359,-0.934,0>,
		<613.65,214.7,1093.2>, <0.328,-0.945,0>,
		<818.05,214.7,1014.7>, <0.359,-0.934,0>
  }
  smooth_triangle { // #5510
		<-610.1,214.7,1093>, <-0.313,-0.95,0>,
		<-813.6,234.5,1014.4>, <-0.36,-0.933,0>,
		<-813.6,214.7,1014.4>, <-0.36,-0.933,0>
  }
  smooth_triangle { // #5511
		<-610.1,214.7,1093>, <-0.313,-0.95,0>,
		<-610.1,234.5,1093>, <-0.313,-0.95,0>,
		<-813.6,234.5,1014.4>, <-0.36,-0.933,0>
  }
  smooth_triangle { // #5512
		<-610.1,214.7,1093>, <-0.313,-0.95,0>,
		<-406.5,234.5,1149.15>, <-0.232,-0.973,0>,
		<-610.1,234.5,1093>, <-0.313,-0.95,0>
  }
  smooth_triangle { // #5513
		<-406.5,214.7,1149.15>, <-0.198,-0.98,0>,
		<-406.5,234.5,1149.15>, <-0.232,-0.973,0>,
		<-610.1,214.7,1093>, <-0.313,-0.95,0>
  }
  smooth_triangle { // #5514
		<-406.5,214.7,1149.15>, <-0.198,-0.98,0>,
		<-202.75,234.5,1182.85>, <-0.127,-0.992,0>,
		<-406.5,234.5,1149.15>, <-0.232,-0.973,0>
  }
  smooth_triangle { // #5515
		<-202.75,214.7,1182.85>, <-0.091,-0.996,0>,
		<-202.75,234.5,1182.85>, <-0.127,-0.992,0>,
		<-406.5,214.7,1149.15>, <-0.198,-0.98,0>
  }
  smooth_triangle { // #5516
		<-202.75,214.7,1182.85>, <-0.091,-0.996,0>,
		<1.15,234.5,1194.1>, <-0.019,-1,0>,
		<-202.75,234.5,1182.85>, <-0.127,-0.992,0>
  }
  smooth_triangle { // #5517
		<1.15,214.7,1194.1>, <0.018,-1,0>,
		<1.15,234.5,1194.1>, <-0.019,-1,0>,
		<-202.75,214.7,1182.85>, <-0.091,-0.996,0>
  }
  smooth_triangle { // #5518
		<1.15,214.7,1194.1>, <0.018,-1,0>,
		<205.2,234.5,1182.9>, <0.091,-0.996,0>,
		<1.15,234.5,1194.1>, <-0.019,-1,0>
  }
  smooth_triangle { // #5519
		<205.2,214.7,1182.9>, <0.127,-0.992,0>,
		<205.2,234.5,1182.9>, <0.091,-0.996,0>,
		<1.15,214.7,1194.1>, <0.018,-1,0>
  }
  smooth_triangle { // #5520
		<205.2,214.7,1182.9>, <0.127,-0.992,0>,
		<409.35,234.5,1149.3>, <0.197,-0.98,0>,
		<205.2,234.5,1182.9>, <0.091,-0.996,0>
  }
  smooth_triangle { // #5521
		<409.35,214.7,1149.3>, <0.231,-0.973,0>,
		<409.35,234.5,1149.3>, <0.197,-0.98,0>,
		<205.2,214.7,1182.9>, <0.127,-0.992,0>
  }
  smooth_triangle { // #5522
		<409.35,214.7,1149.3>, <0.231,-0.973,0>,
		<613.65,234.5,1093.2>, <0.296,-0.955,0>,
		<409.35,234.5,1149.3>, <0.197,-0.98,0>
  }
  smooth_triangle { // #5523
		<613.65,214.7,1093.2>, <0.328,-0.945,0>,
		<613.65,234.5,1093.2>, <0.296,-0.955,0>,
		<409.35,214.7,1149.3>, <0.231,-0.973,0>
  }
  smooth_triangle { // #5524
		<613.65,214.7,1093.2>, <0.328,-0.945,0>,
		<818.05,234.5,1014.7>, <0.359,-0.934,0>,
		<613.65,234.5,1093.2>, <0.296,-0.955,0>
  }
  triangle { // #5525
		<628,486.9,1895.05>,
		<697.7,486.9,1762.15>,
		<703.95,486.9,1876.9>
  }
  triangle { // #5526
		<843.2,486.9,1834.45>,
		<697.7,486.9,1762.15>,
		<843.2,486.9,1717.55>
  }
  triangle { // #5527
		<775.7,486.9,1856.7>,
		<697.7,486.9,1762.15>,
		<843.2,486.9,1834.45>
  }
  triangle { // #5528
		<703.95,486.9,1876.9>,
		<697.7,486.9,1762.15>,
		<775.7,486.9,1856.7>
  }
  triangle { // #5529
		<547.75,486.9,1798>,
		<628,486.9,1895.05>,
		<547.75,486.9,1911.15>
  }
  triangle { // #5530
		<697.7,486.9,1762.15>,
		<628,486.9,1895.05>,
		<547.75,486.9,1798>
  }
  triangle { // #5531
		<697.7,522.1,1762.15>,
		<628,522.1,1895.05>,
		<703.95,522.1,1876.9>
  }
  triangle { // #5532
		<697.7,522.1,1762.15>,
		<843.2,522.1,1834.45>,
		<843.2,522.1,1717.55>
  }
  triangle { // #5533
		<697.7,522.1,1762.15>,
		<775.7,522.1,1856.7>,
		<843.2,522.1,1834.45>
  }
  triangle { // #5534
		<697.7,522.1,1762.15>,
		<703.95,522.1,1876.9>,
		<775.7,522.1,1856.7>
  }
  triangle { // #5535
		<628,522.1,1895.05>,
		<547.75,522.1,1798>,
		<547.75,522.1,1911.15>
  }
  triangle { // #5536
		<628,522.1,1895.05>,
		<697.7,522.1,1762.15>,
		<547.75,522.1,1798>
  }
  smooth_triangle { // #5537
		<843.2,486.9,1717.55>, <-0.293,0.956,0>,
		<697.7,522.1,1762.15>, <-0.273,0.962,0>,
		<843.2,522.1,1717.55>, <-0.293,0.956,0>
  }
  smooth_triangle { // #5538
		<547.75,522.1,1798>, <-0.232,0.973,0>,
		<697.7,486.9,1762.15>, <-0.253,0.968,0>,
		<547.75,486.9,1798>, <-0.232,0.973,0>
  }
  smooth_triangle { // #5539
		<697.7,522.1,1762.15>, <-0.273,0.962,0>,
		<697.7,486.9,1762.15>, <-0.253,0.968,0>,
		<547.75,522.1,1798>, <-0.232,0.973,0>
  }
  smooth_triangle { // #5540
		<697.7,522.1,1762.15>, <-0.273,0.962,0>,
		<843.2,486.9,1717.55>, <-0.293,0.956,0>,
		<697.7,486.9,1762.15>, <-0.253,0.968,0>
  }
  triangle { // #5541
		<843.2,486.9,1717.55>,
		<843.2,522.1,1834.45>,
		<843.2,486.9,1834.45>
  }
  triangle { // #5542
		<843.2,522.1,1834.45>,
		<843.2,486.9,1717.55>,
		<843.2,522.1,1717.55>
  }
  smooth_triangle { // #5543
		<843.2,522.1,1834.45>, <0.313,-0.95,0>,
		<775.7,486.9,1856.7>, <0.299,-0.954,0>,
		<843.2,486.9,1834.45>, <0.313,-0.95,0>
  }
  smooth_triangle { // #5544
		<628,486.9,1895.05>, <0.215,-0.977,0>,
		<547.75,522.1,1911.15>, <0.197,-0.98,0>,
		<547.75,486.9,1911.15>, <0.197,-0.98,0>
  }
  smooth_triangle { // #5545
		<628,486.9,1895.05>, <0.215,-0.977,0>,
		<628,522.1,1895.05>, <0.215,-0.977,0>,
		<547.75,522.1,1911.15>, <0.197,-0.98,0>
  }
  smooth_triangle { // #5546
		<628,486.9,1895.05>, <0.215,-0.977,0>,
		<703.95,522.1,1876.9>, <0.245,-0.969,0>,
		<628,522.1,1895.05>, <0.215,-0.977,0>
  }
  smooth_triangle { // #5547
		<703.95,486.9,1876.9>, <0.258,-0.966,0>,
		<703.95,522.1,1876.9>, <0.245,-0.969,0>,
		<628,486.9,1895.05>, <0.215,-0.977,0>
  }
  smooth_triangle { // #5548
		<703.95,486.9,1876.9>, <0.258,-0.966,0>,
		<775.7,522.1,1856.7>, <0.285,-0.959,0>,
		<703.95,522.1,1876.9>, <0.245,-0.969,0>
  }
  smooth_triangle { // #5549
		<775.7,486.9,1856.7>, <0.299,-0.954,0>,
		<775.7,522.1,1856.7>, <0.285,-0.959,0>,
		<703.95,486.9,1876.9>, <0.258,-0.966,0>
  }
  smooth_triangle { // #5550
		<775.7,486.9,1856.7>, <0.299,-0.954,0>,
		<843.2,522.1,1834.45>, <0.313,-0.95,0>,
		<775.7,522.1,1856.7>, <0.285,-0.959,0>
  }
  triangle { // #5551
		<547.75,486.9,1911.15>,
		<547.75,522.1,1798>,
		<547.75,486.9,1798>
  }
  triangle { // #5552
		<547.75,522.1,1798>,
		<547.75,486.9,1911.15>,
		<547.75,522.1,1911.15>
  }
  triangle { // #5553
		<547.75,486.9,1911.15>,
		<517.55,486.9,1805.55>,
		<547.75,486.9,1798>
  }
  triangle { // #5554
		<517.55,486.9,1805.55>,
		<547.75,486.9,1911.15>,
		<517.55,486.9,1918.7>
  }
  triangle { // #5555
		<547.75,504.5,1911.15>,
		<517.55,504.5,1805.55>,
		<517.55,504.5,1918.7>
  }
  triangle { // #5556
		<517.55,504.5,1805.55>,
		<547.75,504.5,1911.15>,
		<547.75,504.5,1798>
  }
  triangle { // #5557
		<547.75,486.9,1798>,
		<547.75,504.5,1911.15>,
		<547.75,486.9,1911.15>
  }
  triangle { // #5558
		<547.75,504.5,1911.15>,
		<547.75,486.9,1798>,
		<547.75,504.5,1798>
  }
  smooth_triangle { // #5559
		<547.75,486.9,1911.15>, <0.227,-0.974,0>,
		<517.55,504.5,1918.7>, <0.243,-0.97,0>,
		<517.55,486.9,1918.7>, <0.243,-0.97,0>
  }
  smooth_triangle { // #5560
		<517.55,504.5,1918.7>, <0.243,-0.97,0>,
		<547.75,486.9,1911.15>, <0.227,-0.974,0>,
		<547.75,504.5,1911.15>, <0.243,-0.97,0>
  }
  triangle { // #5561
		<517.55,486.9,1918.7>,
		<517.55,504.5,1805.55>,
		<517.55,486.9,1805.55>
  }
  triangle { // #5562
		<517.55,504.5,1805.55>,
		<517.55,486.9,1918.7>,
		<517.55,504.5,1918.7>
  }
  triangle { // #5563
		<517.55,486.9,1805.55>,
		<547.75,504.5,1798>,
		<547.75,486.9,1798>
  }
  triangle { // #5564
		<547.75,504.5,1798>,
		<517.55,486.9,1805.55>,
		<517.55,504.5,1805.55>
  }
  triangle { // #5565
		<-701.05,486.9,1876.9>,
		<-694.8,486.9,1762.15>,
		<-625.1,486.9,1895.05>
  }
  triangle { // #5566
		<-840.3,486.9,1717.55>,
		<-694.8,486.9,1762.15>,
		<-840.3,486.9,1834.45>
  }
  triangle { // #5567
		<-840.3,486.9,1834.45>,
		<-694.8,486.9,1762.15>,
		<-772.8,486.9,1856.7>
  }
  triangle { // #5568
		<-772.8,486.9,1856.7>,
		<-694.8,486.9,1762.15>,
		<-701.05,486.9,1876.9>
  }
  triangle { // #5569
		<-544.85,486.9,1911.15>,
		<-625.1,486.9,1895.05>,
		<-544.85,486.9,1798>
  }
  triangle { // #5570
		<-544.85,486.9,1798>,
		<-625.1,486.9,1895.05>,
		<-694.8,486.9,1762.15>
  }
  triangle { // #5571
		<-701.05,522.1,1876.9>,
		<-625.1,522.1,1895.05>,
		<-694.8,522.1,1762.15>
  }
  triangle { // #5572
		<-840.3,522.1,1717.55>,
		<-840.3,522.1,1834.45>,
		<-694.8,522.1,1762.15>
  }
  triangle { // #5573
		<-840.3,522.1,1834.45>,
		<-772.8,522.1,1856.7>,
		<-694.8,522.1,1762.15>
  }
  triangle { // #5574
		<-772.8,522.1,1856.7>,
		<-701.05,522.1,1876.9>,
		<-694.8,522.1,1762.15>
  }
  triangle { // #5575
		<-544.85,522.1,1911.15>,
		<-544.85,522.1,1798>,
		<-625.1,522.1,1895.05>
  }
  triangle { // #5576
		<-544.85,522.1,1798>,
		<-694.8,522.1,1762.15>,
		<-625.1,522.1,1895.05>
  }
  smooth_triangle { // #5577
		<-840.3,522.1,1717.55>, <0.293,0.956,0>,
		<-694.8,522.1,1762.15>, <0.273,0.962,0>,
		<-840.3,486.9,1717.55>, <0.293,0.956,0>
  }
  smooth_triangle { // #5578
		<-544.85,486.9,1798>, <0.232,0.973,0>,
		<-694.8,486.9,1762.15>, <0.253,0.968,0>,
		<-544.85,522.1,1798>, <0.232,0.973,0>
  }
  smooth_triangle { // #5579
		<-544.85,522.1,1798>, <0.232,0.973,0>,
		<-694.8,486.9,1762.15>, <0.253,0.968,0>,
		<-694.8,522.1,1762.15>, <0.273,0.962,0>
  }
  smooth_triangle { // #5580
		<-694.8,486.9,1762.15>, <0.253,0.968,0>,
		<-840.3,486.9,1717.55>, <0.293,0.956,0>,
		<-694.8,522.1,1762.15>, <0.273,0.962,0>
  }
  triangle { // #5581
		<-840.3,486.9,1834.45>,
		<-840.3,522.1,1834.45>,
		<-840.3,486.9,1717.55>
  }
  triangle { // #5582
		<-840.3,522.1,1717.55>,
		<-840.3,486.9,1717.55>,
		<-840.3,522.1,1834.45>
  }
  smooth_triangle { // #5583
		<-544.85,522.1,1911.15>, <-0.197,-0.98,0>,
		<-625.1,522.1,1895.05>, <-0.209,-0.978,0>,
		<-544.85,486.9,1911.15>, <-0.197,-0.98,0>
  }
  smooth_triangle { // #5584
		<-840.3,486.9,1834.45>, <-0.313,-0.95,0>,
		<-772.8,486.9,1856.7>, <-0.299,-0.954,0>,
		<-840.3,522.1,1834.45>, <-0.313,-0.95,0>
  }
  smooth_triangle { // #5585
		<-840.3,522.1,1834.45>, <-0.313,-0.95,0>,
		<-772.8,486.9,1856.7>, <-0.299,-0.954,0>,
		<-772.8,522.1,1856.7>, <-0.285,-0.959,0>
  }
  smooth_triangle { // #5586
		<-772.8,486.9,1856.7>, <-0.299,-0.954,0>,
		<-701.05,486.9,1876.9>, <-0.258,-0.966,0>,
		<-772.8,522.1,1856.7>, <-0.285,-0.959,0>
  }
  smooth_triangle { // #5587
		<-772.8,522.1,1856.7>, <-0.285,-0.959,0>,
		<-701.05,486.9,1876.9>, <-0.258,-0.966,0>,
		<-701.05,522.1,1876.9>, <-0.245,-0.969,0>
  }
  smooth_triangle { // #5588
		<-701.05,486.9,1876.9>, <-0.258,-0.966,0>,
		<-625.1,486.9,1895.05>, <-0.221,-0.975,0>,
		<-701.05,522.1,1876.9>, <-0.245,-0.969,0>
  }
  smooth_triangle { // #5589
		<-701.05,522.1,1876.9>, <-0.245,-0.969,0>,
		<-625.1,486.9,1895.05>, <-0.221,-0.975,0>,
		<-625.1,522.1,1895.05>, <-0.209,-0.978,0>
  }
  smooth_triangle { // #5590
		<-625.1,486.9,1895.05>, <-0.221,-0.975,0>,
		<-544.85,486.9,1911.15>, <-0.197,-0.98,0>,
		<-625.1,522.1,1895.05>, <-0.209,-0.978,0>
  }
  triangle { // #5591
		<-544.85,486.9,1798>,
		<-544.85,522.1,1798>,
		<-544.85,486.9,1911.15>
  }
  triangle { // #5592
		<-544.85,522.1,1911.15>,
		<-544.85,486.9,1911.15>,
		<-544.85,522.1,1798>
  }
  triangle { // #5593
		<-544.85,486.9,1798>,
		<-514.65,486.9,1805.55>,
		<-544.85,486.9,1911.15>
  }
  triangle { // #5594
		<-514.65,486.9,1918.7>,
		<-544.85,486.9,1911.15>,
		<-514.65,486.9,1805.55>
  }
  triangle { // #5595
		<-514.65,504.5,1918.7>,
		<-514.65,504.5,1805.55>,
		<-544.85,504.5,1911.15>
  }
  triangle { // #5596
		<-544.85,504.5,1798>,
		<-544.85,504.5,1911.15>,
		<-514.65,504.5,1805.55>
  }
  triangle { // #5597
		<-544.85,486.9,1911.15>,
		<-544.85,504.5,1911.15>,
		<-544.85,486.9,1798>
  }
  triangle { // #5598
		<-544.85,504.5,1798>,
		<-544.85,486.9,1798>,
		<-544.85,504.5,1911.15>
  }
  smooth_triangle { // #5599
		<-514.65,486.9,1918.7>, <-0.243,-0.97,0>,
		<-514.65,504.5,1918.7>, <-0.243,-0.97,0>,
		<-544.85,486.9,1911.15>, <-0.22,-0.976,0>
  }
  smooth_triangle { // #5600
		<-544.85,504.5,1911.15>, <-0.243,-0.97,0>,
		<-544.85,486.9,1911.15>, <-0.22,-0.976,0>,
		<-514.65,504.5,1918.7>, <-0.243,-0.97,0>
  }
  triangle { // #5601
		<-514.65,486.9,1805.55>,
		<-514.65,504.5,1805.55>,
		<-514.65,486.9,1918.7>
  }
  triangle { // #5602
		<-514.65,504.5,1918.7>,
		<-514.65,486.9,1918.7>,
		<-514.65,504.5,1805.55>
  }
  triangle { // #5603
		<-544.85,486.9,1798>,
		<-544.85,504.5,1798>,
		<-514.65,486.9,1805.55>
  }
  triangle { // #5604
		<-514.65,504.5,1805.55>,
		<-514.65,486.9,1805.55>,
		<-544.85,504.5,1798>
  }
  triangle { // #5605
		<398.45,451.05,1746.8>,
		<383.2,451.05,1745.5>,
		<413.65,451.05,1746.9>
  }
  triangle { // #5606
		<503.9,451.05,1692.7>,
		<503.9,451.05,1722.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5607
		<503.9,451.05,1722.85>,
		<489,451.05,1729.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5608
		<489,451.05,1729.85>,
		<474,451.05,1735.6>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5609
		<474,451.05,1735.6>,
		<459,451.05,1740.2>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5610
		<459,451.05,1740.2>,
		<443.95,451.05,1743.6>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5611
		<443.95,451.05,1743.6>,
		<428.85,451.05,1745.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5612
		<428.85,451.05,1745.85>,
		<413.65,451.05,1746.9>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5613
		<383.2,451.05,1715.35>,
		<413.65,451.05,1746.9>,
		<383.2,451.05,1745.5>
  }
  triangle { // #5614
		<398.45,468.65,1746.8>,
		<413.65,468.65,1746.9>,
		<383.2,468.65,1745.5>
  }
  triangle { // #5615
		<503.9,468.65,1692.7>,
		<383.2,468.65,1715.35>,
		<503.9,468.65,1722.85>
  }
  triangle { // #5616
		<503.9,468.65,1722.85>,
		<383.2,468.65,1715.35>,
		<489,468.65,1729.85>
  }
  triangle { // #5617
		<489,468.65,1729.85>,
		<383.2,468.65,1715.35>,
		<474,468.65,1735.6>
  }
  triangle { // #5618
		<474,468.65,1735.6>,
		<383.2,468.65,1715.35>,
		<459,468.65,1740.2>
  }
  triangle { // #5619
		<459,468.65,1740.2>,
		<383.2,468.65,1715.35>,
		<443.95,468.65,1743.6>
  }
  triangle { // #5620
		<443.95,468.65,1743.6>,
		<383.2,468.65,1715.35>,
		<428.85,468.65,1745.85>
  }
  triangle { // #5621
		<428.85,468.65,1745.85>,
		<383.2,468.65,1715.35>,
		<413.65,468.65,1746.9>
  }
  triangle { // #5622
		<383.2,468.65,1715.35>,
		<383.2,468.65,1745.5>,
		<413.65,468.65,1746.9>
  }
  smooth_triangle { // #5623
		<383.2,451.05,1745.5>, <-0.085,-0.996,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>,
		<383.2,468.65,1745.5>, <-0.085,-0.996,0>
  }
  smooth_triangle { // #5624
		<503.9,451.05,1722.85>, <0.423,-0.906,0>,
		<503.9,468.65,1722.85>, <0.423,-0.906,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5625
		<503.9,468.65,1722.85>, <0.423,-0.906,0>,
		<489,468.65,1729.85>, <0.392,-0.92,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5626
		<489,468.65,1729.85>, <0.392,-0.92,0>,
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5627
		<489,451.05,1729.85>, <0.392,-0.92,0>,
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<474,451.05,1735.6>, <0.315,-0.949,0>
  }
  smooth_triangle { // #5628
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<474,451.05,1735.6>, <0.315,-0.949,0>
  }
  smooth_triangle { // #5629
		<474,451.05,1735.6>, <0.315,-0.949,0>,
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<459,451.05,1740.2>, <0.245,-0.969,0>
  }
  smooth_triangle { // #5630
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<459,451.05,1740.2>, <0.245,-0.969,0>
  }
  smooth_triangle { // #5631
		<459,451.05,1740.2>, <0.245,-0.969,0>,
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<443.95,451.05,1743.6>, <0.172,-0.985,0>
  }
  smooth_triangle { // #5632
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<443.95,451.05,1743.6>, <0.172,-0.985,0>
  }
  smooth_triangle { // #5633
		<443.95,451.05,1743.6>, <0.172,-0.985,0>,
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<428.85,451.05,1745.85>, <0.095,-0.995,0>
  }
  smooth_triangle { // #5634
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<428.85,451.05,1745.85>, <0.095,-0.995,0>
  }
  smooth_triangle { // #5635
		<428.85,451.05,1745.85>, <0.095,-0.995,0>,
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<413.65,451.05,1746.9>, <0.018,-1,0>
  }
  smooth_triangle { // #5636
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<413.65,451.05,1746.9>, <0.018,-1,0>
  }
  smooth_triangle { // #5637
		<413.65,451.05,1746.9>, <0.018,-1,0>,
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>
  }
  smooth_triangle { // #5638
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<383.2,468.65,1745.5>, <-0.085,-0.996,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>
  }
  triangle { // #5639
		<503.9,451.05,1692.7>,
		<503.9,468.65,1692.7>,
		<503.9,451.05,1722.85>
  }
  triangle { // #5640
		<503.9,468.65,1722.85>,
		<503.9,451.05,1722.85>,
		<503.9,468.65,1692.7>
  }
  triangle { // #5641
		<383.2,451.05,1715.35>,
		<383.2,468.65,1715.35>,
		<503.9,451.05,1692.7>
  }
  triangle { // #5642
		<503.9,468.65,1692.7>,
		<503.9,451.05,1692.7>,
		<383.2,468.65,1715.35>
  }
  triangle { // #5643
		<383.2,451.05,1745.5>,
		<383.2,468.65,1745.5>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5644
		<383.2,468.65,1715.35>,
		<383.2,451.05,1715.35>,
		<383.2,468.65,1745.5>
  }
  triangle { // #5645
		<398.45,451.05,1746.8>,
		<383.2,451.05,1745.5>,
		<413.65,451.05,1746.9>
  }
  triangle { // #5646
		<503.9,451.05,1692.7>,
		<503.9,451.05,1722.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5647
		<503.9,451.05,1722.85>,
		<489,451.05,1729.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5648
		<489,451.05,1729.85>,
		<474,451.05,1735.6>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5649
		<474,451.05,1735.6>,
		<459,451.05,1740.2>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5650
		<459,451.05,1740.2>,
		<443.95,451.05,1743.6>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5651
		<443.95,451.05,1743.6>,
		<428.85,451.05,1745.85>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5652
		<428.85,451.05,1745.85>,
		<413.65,451.05,1746.9>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5653
		<383.2,451.05,1715.35>,
		<413.65,451.05,1746.9>,
		<383.2,451.05,1745.5>
  }
  triangle { // #5654
		<398.45,468.65,1746.8>,
		<413.65,468.65,1746.9>,
		<383.2,468.65,1745.5>
  }
  triangle { // #5655
		<503.9,468.65,1692.7>,
		<383.2,468.65,1715.35>,
		<503.9,468.65,1722.85>
  }
  triangle { // #5656
		<503.9,468.65,1722.85>,
		<383.2,468.65,1715.35>,
		<489,468.65,1729.85>
  }
  triangle { // #5657
		<489,468.65,1729.85>,
		<383.2,468.65,1715.35>,
		<474,468.65,1735.6>
  }
  triangle { // #5658
		<474,468.65,1735.6>,
		<383.2,468.65,1715.35>,
		<459,468.65,1740.2>
  }
  triangle { // #5659
		<459,468.65,1740.2>,
		<383.2,468.65,1715.35>,
		<443.95,468.65,1743.6>
  }
  triangle { // #5660
		<443.95,468.65,1743.6>,
		<383.2,468.65,1715.35>,
		<428.85,468.65,1745.85>
  }
  triangle { // #5661
		<428.85,468.65,1745.85>,
		<383.2,468.65,1715.35>,
		<413.65,468.65,1746.9>
  }
  triangle { // #5662
		<383.2,468.65,1715.35>,
		<383.2,468.65,1745.5>,
		<413.65,468.65,1746.9>
  }
  smooth_triangle { // #5663
		<383.2,451.05,1745.5>, <-0.085,-0.996,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>,
		<383.2,468.65,1745.5>, <-0.085,-0.996,0>
  }
  smooth_triangle { // #5664
		<503.9,451.05,1722.85>, <0.423,-0.906,0>,
		<503.9,468.65,1722.85>, <0.423,-0.906,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5665
		<503.9,468.65,1722.85>, <0.423,-0.906,0>,
		<489,468.65,1729.85>, <0.392,-0.92,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5666
		<489,468.65,1729.85>, <0.392,-0.92,0>,
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<489,451.05,1729.85>, <0.392,-0.92,0>
  }
  smooth_triangle { // #5667
		<489,451.05,1729.85>, <0.392,-0.92,0>,
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<474,451.05,1735.6>, <0.315,-0.949,0>
  }
  smooth_triangle { // #5668
		<474,468.65,1735.6>, <0.338,-0.941,0>,
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<474,451.05,1735.6>, <0.315,-0.949,0>
  }
  smooth_triangle { // #5669
		<474,451.05,1735.6>, <0.315,-0.949,0>,
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<459,451.05,1740.2>, <0.245,-0.969,0>
  }
  smooth_triangle { // #5670
		<459,468.65,1740.2>, <0.269,-0.963,0>,
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<459,451.05,1740.2>, <0.245,-0.969,0>
  }
  smooth_triangle { // #5671
		<459,451.05,1740.2>, <0.245,-0.969,0>,
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<443.95,451.05,1743.6>, <0.172,-0.985,0>
  }
  smooth_triangle { // #5672
		<443.95,468.65,1743.6>, <0.197,-0.98,0>,
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<443.95,451.05,1743.6>, <0.172,-0.985,0>
  }
  smooth_triangle { // #5673
		<443.95,451.05,1743.6>, <0.172,-0.985,0>,
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<428.85,451.05,1745.85>, <0.095,-0.995,0>
  }
  smooth_triangle { // #5674
		<428.85,468.65,1745.85>, <0.121,-0.993,0>,
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<428.85,451.05,1745.85>, <0.095,-0.995,0>
  }
  smooth_triangle { // #5675
		<428.85,451.05,1745.85>, <0.095,-0.995,0>,
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<413.65,451.05,1746.9>, <0.018,-1,0>
  }
  smooth_triangle { // #5676
		<413.65,468.65,1746.9>, <0.044,-0.999,0>,
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<413.65,451.05,1746.9>, <0.018,-1,0>
  }
  smooth_triangle { // #5677
		<413.65,451.05,1746.9>, <0.018,-1,0>,
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>
  }
  smooth_triangle { // #5678
		<398.45,468.65,1746.8>, <-0.033,-0.999,0>,
		<383.2,468.65,1745.5>, <-0.085,-0.996,0>,
		<398.45,451.05,1746.8>, <-0.059,-0.998,0>
  }
  triangle { // #5679
		<503.9,451.05,1692.7>,
		<503.9,468.65,1692.7>,
		<503.9,451.05,1722.85>
  }
  triangle { // #5680
		<503.9,468.65,1722.85>,
		<503.9,451.05,1722.85>,
		<503.9,468.65,1692.7>
  }
  triangle { // #5681
		<383.2,451.05,1715.35>,
		<383.2,468.65,1715.35>,
		<503.9,451.05,1692.7>
  }
  triangle { // #5682
		<503.9,468.65,1692.7>,
		<503.9,451.05,1692.7>,
		<383.2,468.65,1715.35>
  }
  triangle { // #5683
		<383.2,451.05,1745.5>,
		<383.2,468.65,1745.5>,
		<383.2,451.05,1715.35>
  }
  triangle { // #5684
		<383.2,468.65,1715.35>,
		<383.2,451.05,1715.35>,
		<383.2,468.65,1745.5>
  }
  triangle { // #5685
		<383.2,415.85,1668.95>,
		<383.2,415.85,1635.8>,
		<414.15,415.85,1665.3>
  }
  triangle { // #5686
		<503.9,415.85,1612.85>,
		<503.9,415.85,1643.05>,
		<383.2,415.85,1635.8>
  }
  triangle { // #5687
		<503.9,415.85,1643.05>,
		<474.5,415.85,1652.3>,
		<383.2,415.85,1635.8>
  }
  triangle { // #5688
		<474.5,415.85,1652.3>,
		<444.55,415.85,1659.75>,
		<383.2,415.85,1635.8>
  }
  triangle { // #5689
		<444.55,415.85,1659.75>,
		<414.15,415.85,1665.3>,
		<383.2,415.85,1635.8>
  }
  triangle { // #5690
		<383.2,433.45,1668.95>,
		<414.15,433.45,1665.3>,
		<383.2,433.45,1635.8>
  }
  triangle { // #5691
		<503.9,433.45,1612.85>,
		<383.2,433.45,1635.8>,
		<503.9,433.45,1643.05>
  }
  triangle { // #5692
		<503.9,433.45,1643.05>,
		<383.2,433.45,1635.8>,
		<474.5,433.45,1652.3>
  }
  triangle { // #5693
		<474.5,433.45,1652.3>,
		<383.2,433.45,1635.8>,
		<444.55,433.45,1659.75>
  }
  triangle { // #5694
		<444.55,433.45,1659.75>,
		<383.2,433.45,1635.8>,
		<414.15,433.45,1665.3>
  }
  smooth_triangle { // #5695
		<383.2,415.85,1668.95>, <0.118,-0.993,0>,
		<414.15,415.85,1665.3>, <0.139,-0.99,0>,
		<383.2,433.45,1668.95>, <0.118,-0.993,0>
  }
  smooth_triangle { // #5696
		<503.9,415.85,1643.05>, <0.301,-0.954,0>,
		<503.9,433.45,1643.05>, <0.301,-0.954,0>,
		<474.5,415.85,1652.3>, <0.271,-0.963,0>
  }
  smooth_triangle { // #5697
		<503.9,433.45,1643.05>, <0.301,-0.954,0>,
		<474.5,433.45,1652.3>, <0.271,-0.963,0>,
		<474.5,415.85,1652.3>, <0.271,-0.963,0>
  }
  smooth_triangle { // #5698
		<474.5,433.45,1652.3>, <0.271,-0.963,0>,
		<444.55,433.45,1659.75>, <0.22,-0.975,0>,
		<474.5,415.85,1652.3>, <0.271,-0.963,0>
  }
  smooth_triangle { // #5699
		<474.5,415.85,1652.3>, <0.271,-0.963,0>,
		<444.55,433.45,1659.75>, <0.22,-0.975,0>,
		<444.55,415.85,1659.75>, <0.2,-0.98,0>
  }
  smooth_triangle { // #5700
		<444.55,433.45,1659.75>, <0.22,-0.975,0>,
		<414.15,433.45,1665.3>, <0.159,-0.987,0>,
		<444.55,415.85,1659.75>, <0.2,-0.98,0>
  }
  smooth_triangle { // #5701
		<444.55,415.85,1659.75>, <0.2,-0.98,0>,
		<414.15,433.45,1665.3>, <0.159,-0.987,0>,
		<414.15,415.85,1665.3>, <0.139,-0.99,0>
  }
  smooth_triangle { // #5702
		<414.15,433.45,1665.3>, <0.159,-0.987,0>,
		<383.2,433.45,1668.95>, <0.118,-0.993,0>,
		<414.15,415.85,1665.3>, <0.139,-0.99,0>
  }
  triangle { // #5703
		<503.9,415.85,1612.85>,
		<503.9,433.45,1612.85>,
		<503.9,415.85,1643.05>
  }
  triangle { // #5704
		<503.9,433.45,1643.05>,
		<503.9,415.85,1643.05>,
		<503.9,433.45,1612.85>
  }
  triangle { // #5705
		<383.2,415.85,1635.8>,
		<383.2,433.45,1635.8>,
		<503.9,415.85,1612.85>
  }
  triangle { // #5706
		<503.9,433.45,1612.85>,
		<503.9,415.85,1612.85>,
		<383.2,433.45,1635.8>
  }
  triangle { // #5707
		<383.2,415.85,1668.95>,
		<383.2,433.45,1668.95>,
		<383.2,415.85,1635.8>
  }
  triangle { // #5708
		<383.2,433.45,1635.8>,
		<383.2,415.85,1635.8>,
		<383.2,433.45,1668.95>
  }
  triangle { // #5709
		<383.2,380.65,1585.5>,
		<383.2,380.65,1554.05>,
		<414.25,380.65,1582.45>
  }
  triangle { // #5710
		<503.9,380.65,1530.8>,
		<503.9,380.65,1561>,
		<383.2,380.65,1554.05>
  }
  triangle { // #5711
		<503.9,380.65,1561>,
		<474.6,380.65,1570.2>,
		<383.2,380.65,1554.05>
  }
  triangle { // #5712
		<474.6,380.65,1570.2>,
		<444.75,380.65,1577.35>,
		<383.2,380.65,1554.05>
  }
  triangle { // #5713
		<444.75,380.65,1577.35>,
		<414.25,380.65,1582.45>,
		<383.2,380.65,1554.05>
  }
  triangle { // #5714
		<383.2,398.25,1585.5>,
		<414.25,398.25,1582.45>,
		<383.2,398.25,1554.05>
  }
  triangle { // #5715
		<503.9,398.25,1530.8>,
		<383.2,398.25,1554.05>,
		<503.9,398.25,1561>
  }
  triangle { // #5716
		<503.9,398.25,1561>,
		<383.2,398.25,1554.05>,
		<474.6,398.25,1570.2>
  }
  triangle { // #5717
		<474.6,398.25,1570.2>,
		<383.2,398.25,1554.05>,
		<444.75,398.25,1577.35>
  }
  triangle { // #5718
		<444.75,398.25,1577.35>,
		<383.2,398.25,1554.05>,
		<414.25,398.25,1582.45>
  }
  smooth_triangle { // #5719
		<383.2,380.65,1585.5>, <0.098,-0.995,0>,
		<414.25,380.65,1582.45>, <0.121,-0.993,0>,
		<383.2,398.25,1585.5>, <0.098,-0.995,0>
  }
  smooth_triangle { // #5720
		<503.9,380.65,1561>, <0.299,-0.954,0>,
		<503.9,398.25,1561>, <0.299,-0.954,0>,
		<474.6,380.65,1570.2>, <0.266,-0.964,0>
  }
  smooth_triangle { // #5721
		<503.9,398.25,1561>, <0.299,-0.954,0>,
		<474.6,398.25,1570.2>, <0.266,-0.964,0>,
		<474.6,380.65,1570.2>, <0.266,-0.964,0>
  }
  smooth_triangle { // #5722
		<474.6,398.25,1570.2>, <0.266,-0.964,0>,
		<444.75,398.25,1577.35>, <0.21,-0.978,0>,
		<474.6,380.65,1570.2>, <0.266,-0.964,0>
  }
  smooth_triangle { // #5723
		<474.6,380.65,1570.2>, <0.266,-0.964,0>,
		<444.75,398.25,1577.35>, <0.21,-0.978,0>,
		<444.75,380.65,1577.35>, <0.188,-0.982,0>
  }
  smooth_triangle { // #5724
		<444.75,398.25,1577.35>, <0.21,-0.978,0>,
		<414.25,398.25,1582.45>, <0.143,-0.99,0>,
		<444.75,380.65,1577.35>, <0.188,-0.982,0>
  }
  smooth_triangle { // #5725
		<444.75,380.65,1577.35>, <0.188,-0.982,0>,
		<414.25,398.25,1582.45>, <0.143,-0.99,0>,
		<414.25,380.65,1582.45>, <0.121,-0.993,0>
  }
  smooth_triangle { // #5726
		<414.25,398.25,1582.45>, <0.143,-0.99,0>,
		<383.2,398.25,1585.5>, <0.098,-0.995,0>,
		<414.25,380.65,1582.45>, <0.121,-0.993,0>
  }
  triangle { // #5727
		<503.9,380.65,1530.8>,
		<503.9,398.25,1530.8>,
		<503.9,380.65,1561>
  }
  triangle { // #5728
		<503.9,398.25,1561>,
		<503.9,380.65,1561>,
		<503.9,398.25,1530.8>
  }
  triangle { // #5729
		<383.2,380.65,1554.05>,
		<383.2,398.25,1554.05>,
		<503.9,380.65,1530.8>
  }
  triangle { // #5730
		<503.9,398.25,1530.8>,
		<503.9,380.65,1530.8>,
		<383.2,398.25,1554.05>
  }
  triangle { // #5731
		<383.2,380.65,1585.5>,
		<383.2,398.25,1585.5>,
		<383.2,380.65,1554.05>
  }
  triangle { // #5732
		<383.2,398.25,1554.05>,
		<383.2,380.65,1554.05>,
		<383.2,398.25,1585.5>
  }
  triangle { // #5733
		<383.2,345.45,1515.1>,
		<383.2,345.45,1475.8>,
		<413.6,345.45,1510.15>
  }
  triangle { // #5734
		<501.35,345.45,1446.9>,
		<501.35,345.45,1483.15>,
		<383.2,345.45,1475.8>
  }
  triangle { // #5735
		<501.35,345.45,1483.15>,
		<472.65,345.45,1494.15>,
		<383.2,345.45,1475.8>
  }
  triangle { // #5736
		<472.65,345.45,1494.15>,
		<443.4,345.45,1503.15>,
		<383.2,345.45,1475.8>
  }
  triangle { // #5737
		<443.4,345.45,1503.15>,
		<413.6,345.45,1510.15>,
		<383.2,345.45,1475.8>
  }
  triangle { // #5738
		<383.2,363.05,1515.1>,
		<413.6,363.05,1510.15>,
		<383.2,363.05,1475.8>
  }
  triangle { // #5739
		<501.35,363.05,1446.9>,
		<383.2,363.05,1475.8>,
		<501.35,363.05,1483.15>
  }
  triangle { // #5740
		<501.35,363.05,1483.15>,
		<383.2,363.05,1475.8>,
		<472.65,363.05,1494.15>
  }
  triangle { // #5741
		<472.65,363.05,1494.15>,
		<383.2,363.05,1475.8>,
		<443.4,363.05,1503.15>
  }
  triangle { // #5742
		<443.4,363.05,1503.15>,
		<383.2,363.05,1475.8>,
		<413.6,363.05,1510.15>
  }
  smooth_triangle { // #5743
		<383.2,345.45,1515.1>, <0.161,-0.987,0>,
		<413.6,345.45,1510.15>, <0.184,-0.983,0>,
		<383.2,363.05,1515.1>, <0.161,-0.987,0>
  }
  smooth_triangle { // #5744
		<501.35,345.45,1483.15>, <0.358,-0.934,0>,
		<501.35,363.05,1483.15>, <0.358,-0.934,0>,
		<472.65,345.45,1494.15>, <0.326,-0.945,0>
  }
  smooth_triangle { // #5745
		<501.35,363.05,1483.15>, <0.358,-0.934,0>,
		<472.65,363.05,1494.15>, <0.326,-0.945,0>,
		<472.65,345.45,1494.15>, <0.326,-0.945,0>
  }
  smooth_triangle { // #5746
		<472.65,363.05,1494.15>, <0.326,-0.945,0>,
		<443.4,363.05,1503.15>, <0.272,-0.962,0>,
		<472.65,345.45,1494.15>, <0.326,-0.945,0>
  }
  smooth_triangle { // #5747
		<472.65,345.45,1494.15>, <0.326,-0.945,0>,
		<443.4,363.05,1503.15>, <0.272,-0.962,0>,
		<443.4,345.45,1503.15>, <0.25,-0.968,0>
  }
  smooth_triangle { // #5748
		<443.4,363.05,1503.15>, <0.272,-0.962,0>,
		<413.6,363.05,1510.15>, <0.206,-0.979,0>,
		<443.4,345.45,1503.15>, <0.25,-0.968,0>
  }
  smooth_triangle { // #5749
		<443.4,345.45,1503.15>, <0.25,-0.968,0>,
		<413.6,363.05,1510.15>, <0.206,-0.979,0>,
		<413.6,345.45,1510.15>, <0.184,-0.983,0>
  }
  smooth_triangle { // #5750
		<413.6,363.05,1510.15>, <0.206,-0.979,0>,
		<383.2,363.05,1515.1>, <0.161,-0.987,0>,
		<413.6,345.45,1510.15>, <0.184,-0.983,0>
  }
  triangle { // #5751
		<501.35,345.45,1446.9>,
		<501.35,363.05,1446.9>,
		<501.35,345.45,1483.15>
  }
  triangle { // #5752
		<501.35,363.05,1483.15>,
		<501.35,345.45,1483.15>,
		<501.35,363.05,1446.9>
  }
  triangle { // #5753
		<383.2,345.45,1475.8>,
		<383.2,363.05,1475.8>,
		<501.35,345.45,1446.9>
  }
  triangle { // #5754
		<501.35,363.05,1446.9>,
		<501.35,345.45,1446.9>,
		<383.2,363.05,1475.8>
  }
  triangle { // #5755
		<383.2,345.45,1515.1>,
		<383.2,363.05,1515.1>,
		<383.2,345.45,1475.8>
  }
  triangle { // #5756
		<383.2,363.05,1475.8>,
		<383.2,345.45,1475.8>,
		<383.2,363.05,1515.1>
  }
  triangle { // #5757
		<383.2,310.25,1424.25>,
		<383.2,310.25,1389.7>,
		<443.4,310.25,1419.85>
  }
  triangle { // #5758
		<503.9,310.25,1367.7>,
		<503.9,310.25,1397.85>,
		<383.2,310.25,1389.7>
  }
  triangle { // #5759
		<503.9,310.25,1397.85>,
		<443.4,310.25,1419.85>,
		<383.2,310.25,1389.7>
  }
  triangle { // #5760
		<383.2,327.85,1424.25>,
		<443.4,327.85,1419.85>,
		<383.2,327.85,1389.7>
  }
  triangle { // #5761
		<503.9,327.85,1367.7>,
		<383.2,327.85,1389.7>,
		<503.9,327.85,1397.85>
  }
  triangle { // #5762
		<503.9,327.85,1397.85>,
		<383.2,327.85,1389.7>,
		<443.4,327.85,1419.85>
  }
  smooth_triangle { // #5763
		<503.9,310.25,1397.85>, <0.342,-0.94,0>,
		<503.9,327.85,1397.85>, <0.342,-0.94,0>,
		<443.4,310.25,1419.85>, <0.254,-0.967,0>
  }
  smooth_triangle { // #5764
		<443.4,327.85,1419.85>, <0.164,-0.986,0>,
		<443.4,310.25,1419.85>, <0.254,-0.967,0>,
		<503.9,327.85,1397.85>, <0.342,-0.94,0>
  }
  triangle { // #5765
		<503.9,310.25,1367.7>,
		<503.9,327.85,1367.7>,
		<503.9,310.25,1397.85>
  }
  triangle { // #5766
		<503.9,327.85,1397.85>,
		<503.9,310.25,1397.85>,
		<503.9,327.85,1367.7>
  }
  triangle { // #5767
		<383.2,310.25,1389.7>,
		<383.2,327.85,1389.7>,
		<503.9,310.25,1367.7>
  }
  triangle { // #5768
		<503.9,327.85,1367.7>,
		<503.9,310.25,1367.7>,
		<383.2,327.85,1389.7>
  }
  triangle { // #5769
		<383.2,310.25,1424.25>,
		<383.2,327.85,1424.25>,
		<383.2,310.25,1389.7>
  }
  triangle { // #5770
		<383.2,327.85,1389.7>,
		<383.2,310.25,1389.7>,
		<383.2,327.85,1424.25>
  }
  smooth_triangle { // #5771
		<443.4,310.25,1419.85>, <0.254,-0.967,0>,
		<443.4,327.85,1419.85>, <0.164,-0.986,0>,
		<383.2,310.25,1424.25>, <0.073,-0.997,0>
  }
  smooth_triangle { // #5772
		<383.2,327.85,1424.25>, <0.073,-0.997,0>,
		<383.2,310.25,1424.25>, <0.073,-0.997,0>,
		<443.4,327.85,1419.85>, <0.164,-0.986,0>
  }
  triangle { // #5773
		<503.9,275.05,1312.05>,
		<476.85,275.05,1320.7>,
		<503.9,275.05,1281.85>
  }
  triangle { // #5774
		<383.2,275.05,1342.85>,
		<383.2,275.05,1306.7>,
		<416.5,275.05,1336.1>
  }
  triangle { // #5775
		<383.2,275.05,1306.7>,
		<503.9,275.05,1281.85>,
		<416.5,275.05,1336.1>
  }
  triangle { // #5776
		<416.5,275.05,1336.1>,
		<503.9,275.05,1281.85>,
		<447.7,275.05,1328.7>
  }
  triangle { // #5777
		<447.7,275.05,1328.7>,
		<503.9,275.05,1281.85>,
		<476.85,275.05,1320.7>
  }
  triangle { // #5778
		<503.9,292.65,1312.05>,
		<503.9,292.65,1281.85>,
		<476.85,292.65,1320.7>
  }
  triangle { // #5779
		<383.2,292.65,1342.85>,
		<416.5,292.65,1336.1>,
		<383.2,292.65,1306.7>
  }
  triangle { // #5780
		<383.2,292.65,1306.7>,
		<416.5,292.65,1336.1>,
		<503.9,292.65,1281.85>
  }
  triangle { // #5781
		<416.5,292.65,1336.1>,
		<447.7,292.65,1328.7>,
		<503.9,292.65,1281.85>
  }
  triangle { // #5782
		<447.7,292.65,1328.7>,
		<476.85,292.65,1320.7>,
		<503.9,292.65,1281.85>
  }
  smooth_triangle { // #5783
		<383.2,275.05,1342.85>, <0.199,-0.98,0>,
		<416.5,275.05,1336.1>, <0.209,-0.978,0>,
		<383.2,292.65,1342.85>, <0.199,-0.98,0>
  }
  smooth_triangle { // #5784
		<503.9,275.05,1312.05>, <0.304,-0.953,0>,
		<503.9,292.65,1312.05>, <0.304,-0.953,0>,
		<476.85,275.05,1320.7>, <0.285,-0.959,0>
  }
  smooth_triangle { // #5785
		<503.9,292.65,1312.05>, <0.304,-0.953,0>,
		<476.85,292.65,1320.7>, <0.285,-0.959,0>,
		<476.85,275.05,1320.7>, <0.285,-0.959,0>
  }
  smooth_triangle { // #5786
		<476.85,292.65,1320.7>, <0.285,-0.959,0>,
		<447.7,292.65,1328.7>, <0.254,-0.967,0>,
		<476.85,275.05,1320.7>, <0.285,-0.959,0>
  }
  smooth_triangle { // #5787
		<476.85,275.05,1320.7>, <0.285,-0.959,0>,
		<447.7,292.65,1328.7>, <0.254,-0.967,0>,
		<447.7,275.05,1328.7>, <0.242,-0.97,0>
  }
  smooth_triangle { // #5788
		<447.7,292.65,1328.7>, <0.254,-0.967,0>,
		<416.5,292.65,1336.1>, <0.22,-0.976,0>,
		<447.7,275.05,1328.7>, <0.242,-0.97,0>
  }
  smooth_triangle { // #5789
		<447.7,275.05,1328.7>, <0.242,-0.97,0>,
		<416.5,292.65,1336.1>, <0.22,-0.976,0>,
		<416.5,275.05,1336.1>, <0.209,-0.978,0>
  }
  smooth_triangle { // #5790
		<416.5,292.65,1336.1>, <0.22,-0.976,0>,
		<383.2,292.65,1342.85>, <0.199,-0.98,0>,
		<416.5,275.05,1336.1>, <0.209,-0.978,0>
  }
  triangle { // #5791
		<503.9,275.05,1281.85>,
		<503.9,292.65,1281.85>,
		<503.9,275.05,1312.05>
  }
  triangle { // #5792
		<503.9,292.65,1312.05>,
		<503.9,275.05,1312.05>,
		<503.9,292.65,1281.85>
  }
  triangle { // #5793
		<383.2,275.05,1306.7>,
		<383.2,292.65,1306.7>,
		<503.9,275.05,1281.85>
  }
  triangle { // #5794
		<503.9,292.65,1281.85>,
		<503.9,275.05,1281.85>,
		<383.2,292.65,1306.7>
  }
  triangle { // #5795
		<383.2,275.05,1342.85>,
		<383.2,292.65,1342.85>,
		<383.2,275.05,1306.7>
  }
  triangle { // #5796
		<383.2,292.65,1306.7>,
		<383.2,275.05,1306.7>,
		<383.2,292.65,1342.85>
  }
  triangle { // #5797
		<383.2,239.85,1260.2>,
		<383.2,239.85,1225.6>,
		<421.2,239.85,1255.5>
  }
  triangle { // #5798
		<503.9,239.85,1198.25>,
		<503.9,239.85,1228.45>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5799
		<503.9,239.85,1228.45>,
		<493.4,239.85,1234.3>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5800
		<493.4,239.85,1234.3>,
		<481.55,239.85,1239.6>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5801
		<481.55,239.85,1239.6>,
		<454,239.85,1248.65>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5802
		<454,239.85,1248.65>,
		<421.2,239.85,1255.5>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5803
		<383.2,257.45,1260.2>,
		<421.2,257.45,1255.5>,
		<383.2,257.45,1225.6>
  }
  triangle { // #5804
		<503.9,257.45,1198.25>,
		<383.2,257.45,1225.6>,
		<503.9,257.45,1228.45>
  }
  triangle { // #5805
		<503.9,257.45,1228.45>,
		<383.2,257.45,1225.6>,
		<493.4,257.45,1234.3>
  }
  triangle { // #5806
		<493.4,257.45,1234.3>,
		<383.2,257.45,1225.6>,
		<481.55,257.45,1239.6>
  }
  triangle { // #5807
		<481.55,257.45,1239.6>,
		<383.2,257.45,1225.6>,
		<454,257.45,1248.65>
  }
  triangle { // #5808
		<454,257.45,1248.65>,
		<383.2,257.45,1225.6>,
		<421.2,257.45,1255.5>
  }
  smooth_triangle { // #5809
		<383.2,239.85,1260.2>, <0.123,-0.992,0>,
		<421.2,239.85,1255.5>, <0.15,-0.989,0>,
		<383.2,257.45,1260.2>, <0.123,-0.992,0>
  }
  smooth_triangle { // #5810
		<503.9,239.85,1228.45>, <0.487,-0.874,0>,
		<503.9,257.45,1228.45>, <0.487,-0.874,0>,
		<493.4,239.85,1234.3>, <0.449,-0.894,0>
  }
  smooth_triangle { // #5811
		<503.9,257.45,1228.45>, <0.487,-0.874,0>,
		<493.4,257.45,1234.3>, <0.449,-0.894,0>,
		<493.4,239.85,1234.3>, <0.449,-0.894,0>
  }
  smooth_triangle { // #5812
		<493.4,257.45,1234.3>, <0.449,-0.894,0>,
		<481.55,257.45,1239.6>, <0.378,-0.926,0>,
		<493.4,239.85,1234.3>, <0.449,-0.894,0>
  }
  smooth_triangle { // #5813
		<493.4,239.85,1234.3>, <0.449,-0.894,0>,
		<481.55,257.45,1239.6>, <0.378,-0.926,0>,
		<481.55,239.85,1239.6>, <0.345,-0.939,0>
  }
  smooth_triangle { // #5814
		<481.55,257.45,1239.6>, <0.378,-0.926,0>,
		<454,257.45,1248.65>, <0.276,-0.961,0>,
		<481.55,239.85,1239.6>, <0.345,-0.939,0>
  }
  smooth_triangle { // #5815
		<481.55,239.85,1239.6>, <0.345,-0.939,0>,
		<454,257.45,1248.65>, <0.276,-0.961,0>,
		<454,239.85,1248.65>, <0.24,-0.971,0>
  }
  smooth_triangle { // #5816
		<454,257.45,1248.65>, <0.276,-0.961,0>,
		<421.2,257.45,1255.5>, <0.177,-0.984,0>,
		<454,239.85,1248.65>, <0.24,-0.971,0>
  }
  smooth_triangle { // #5817
		<454,239.85,1248.65>, <0.24,-0.971,0>,
		<421.2,257.45,1255.5>, <0.177,-0.984,0>,
		<421.2,239.85,1255.5>, <0.15,-0.989,0>
  }
  smooth_triangle { // #5818
		<421.2,257.45,1255.5>, <0.177,-0.984,0>,
		<383.2,257.45,1260.2>, <0.123,-0.992,0>,
		<421.2,239.85,1255.5>, <0.15,-0.989,0>
  }
  triangle { // #5819
		<503.9,239.85,1198.25>,
		<503.9,257.45,1198.25>,
		<503.9,239.85,1228.45>
  }
  triangle { // #5820
		<503.9,257.45,1228.45>,
		<503.9,239.85,1228.45>,
		<503.9,257.45,1198.25>
  }
  triangle { // #5821
		<383.2,239.85,1225.6>,
		<383.2,257.45,1225.6>,
		<503.9,239.85,1198.25>
  }
  triangle { // #5822
		<503.9,257.45,1198.25>,
		<503.9,239.85,1198.25>,
		<383.2,257.45,1225.6>
  }
  triangle { // #5823
		<383.2,239.85,1260.2>,
		<383.2,257.45,1260.2>,
		<383.2,239.85,1225.6>
  }
  triangle { // #5824
		<383.2,257.45,1225.6>,
		<383.2,239.85,1225.6>,
		<383.2,257.45,1260.2>
  }
  triangle { // #5825
		<-413.6,451.05,1746.9>,
		<-383.15,451.05,1745.5>,
		<-398.4,451.05,1746.8>
  }
  triangle { // #5826
		<-383.15,451.05,1715.35>,
		<-503.85,451.05,1722.85>,
		<-503.85,451.05,1692.7>
  }
  triangle { // #5827
		<-383.15,451.05,1715.35>,
		<-488.9,451.05,1729.85>,
		<-503.85,451.05,1722.85>
  }
  triangle { // #5828
		<-383.15,451.05,1715.35>,
		<-473.95,451.05,1735.6>,
		<-488.9,451.05,1729.85>
  }
  triangle { // #5829
		<-383.15,451.05,1715.35>,
		<-458.95,451.05,1740.2>,
		<-473.95,451.05,1735.6>
  }
  triangle { // #5830
		<-383.15,451.05,1715.35>,
		<-443.85,451.05,1743.6>,
		<-458.95,451.05,1740.2>
  }
  triangle { // #5831
		<-383.15,451.05,1715.35>,
		<-428.75,451.05,1745.85>,
		<-443.85,451.05,1743.6>
  }
  triangle { // #5832
		<-383.15,451.05,1715.35>,
		<-413.6,451.05,1746.9>,
		<-428.75,451.05,1745.85>
  }
  triangle { // #5833
		<-383.15,451.05,1745.5>,
		<-413.6,451.05,1746.9>,
		<-383.15,451.05,1715.35>
  }
  triangle { // #5834
		<-383.15,468.65,1745.5>,
		<-413.6,468.65,1746.9>,
		<-398.4,468.65,1746.8>
  }
  triangle { // #5835
		<-503.85,468.65,1722.85>,
		<-383.15,468.65,1715.35>,
		<-503.85,468.65,1692.7>
  }
  triangle { // #5836
		<-488.9,468.65,1729.85>,
		<-383.15,468.65,1715.35>,
		<-503.85,468.65,1722.85>
  }
  triangle { // #5837
		<-473.95,468.65,1735.6>,
		<-383.15,468.65,1715.35>,
		<-488.9,468.65,1729.85>
  }
  triangle { // #5838
		<-458.95,468.65,1740.2>,
		<-383.15,468.65,1715.35>,
		<-473.95,468.65,1735.6>
  }
  triangle { // #5839
		<-443.85,468.65,1743.6>,
		<-383.15,468.65,1715.35>,
		<-458.95,468.65,1740.2>
  }
  triangle { // #5840
		<-428.75,468.65,1745.85>,
		<-383.15,468.65,1715.35>,
		<-443.85,468.65,1743.6>
  }
  triangle { // #5841
		<-413.6,468.65,1746.9>,
		<-383.15,468.65,1715.35>,
		<-428.75,468.65,1745.85>
  }
  triangle { // #5842
		<-413.6,468.65,1746.9>,
		<-383.15,468.65,1745.5>,
		<-383.15,468.65,1715.35>
  }
  smooth_triangle { // #5843
		<-503.85,451.05,1722.85>, <-0.423,-0.906,0>,
		<-488.9,468.65,1729.85>, <-0.402,-0.916,0>,
		<-503.85,468.65,1722.85>, <-0.423,-0.906,0>
  }
  smooth_triangle { // #5844
		<-383.15,468.65,1745.5>, <0.085,-0.996,0>,
		<-398.4,451.05,1746.8>, <0.059,-0.998,0>,
		<-383.15,451.05,1745.5>, <0.085,-0.996,0>
  }
  smooth_triangle { // #5845
		<-398.4,468.65,1746.8>, <0.033,-0.999,0>,
		<-398.4,451.05,1746.8>, <0.059,-0.998,0>,
		<-383.15,468.65,1745.5>, <0.085,-0.996,0>
  }
  smooth_triangle { // #5846
		<-398.4,468.65,1746.8>, <0.033,-0.999,0>,
		<-413.6,451.05,1746.9>, <-0.018,-1,0>,
		<-398.4,451.05,1746.8>, <0.059,-0.998,0>
  }
  smooth_triangle { // #5847
		<-413.6,468.65,1746.9>, <-0.044,-0.999,0>,
		<-413.6,451.05,1746.9>, <-0.018,-1,0>,
		<-398.4,468.65,1746.8>, <0.033,-0.999,0>
  }
  smooth_triangle { // #5848
		<-413.6,468.65,1746.9>, <-0.044,-0.999,0>,
		<-428.75,451.05,1745.85>, <-0.095,-0.995,0>,
		<-413.6,451.05,1746.9>, <-0.018,-1,0>
  }
  smooth_triangle { // #5849
		<-428.75,468.65,1745.85>, <-0.121,-0.993,0>,
		<-428.75,451.05,1745.85>, <-0.095,-0.995,0>,
		<-413.6,468.65,1746.9>, <-0.044,-0.999,0>
  }
  smooth_triangle { // #5850
		<-428.75,468.65,1745.85>, <-0.121,-0.993,0>,
		<-443.85,451.05,1743.6>, <-0.172,-0.985,0>,
		<-428.75,451.05,1745.85>, <-0.095,-0.995,0>
  }
  smooth_triangle { // #5851
		<-443.85,468.65,1743.6>, <-0.197,-0.98,0>,
		<-443.85,451.05,1743.6>, <-0.172,-0.985,0>,
		<-428.75,468.65,1745.85>, <-0.121,-0.993,0>
  }
  smooth_triangle { // #5852
		<-443.85,468.65,1743.6>, <-0.197,-0.98,0>,
		<-458.95,451.05,1740.2>, <-0.245,-0.969,0>,
		<-443.85,451.05,1743.6>, <-0.172,-0.985,0>
  }
  smooth_triangle { // #5853
		<-458.95,468.65,1740.2>, <-0.269,-0.963,0>,
		<-458.95,451.05,1740.2>, <-0.245,-0.969,0>,
		<-443.85,468.65,1743.6>, <-0.197,-0.98,0>
  }
  smooth_triangle { // #5854
		<-458.95,468.65,1740.2>, <-0.269,-0.963,0>,
		<-473.95,451.05,1735.6>, <-0.315,-0.949,0>,
		<-458.95,451.05,1740.2>, <-0.245,-0.969,0>
  }
  smooth_triangle { // #5855
		<-473.95,468.65,1735.6>, <-0.338,-0.941,0>,
		<-473.95,451.05,1735.6>, <-0.315,-0.949,0>,
		<-458.95,468.65,1740.2>, <-0.269,-0.963,0>
  }
  smooth_triangle { // #5856
		<-473.95,468.65,1735.6>, <-0.338,-0.941,0>,
		<-488.9,451.05,1729.85>, <-0.381,-0.925,0>,
		<-473.95,451.05,1735.6>, <-0.315,-0.949,0>
  }
  smooth_triangle { // #5857
		<-488.9,468.65,1729.85>, <-0.402,-0.916,0>,
		<-488.9,451.05,1729.85>, <-0.381,-0.925,0>,
		<-473.95,468.65,1735.6>, <-0.338,-0.941,0>
  }
  smooth_triangle { // #5858
		<-488.9,468.65,1729.85>, <-0.402,-0.916,0>,
		<-503.85,451.05,1722.85>, <-0.423,-0.906,0>,
		<-488.9,451.05,1729.85>, <-0.381,-0.925,0>
  }
  triangle { // #5859
		<-503.85,451.05,1722.85>,
		<-503.85,468.65,1692.7>,
		<-503.85,451.05,1692.7>
  }
  triangle { // #5860
		<-503.85,468.65,1692.7>,
		<-503.85,451.05,1722.85>,
		<-503.85,468.65,1722.85>
  }
  triangle { // #5861
		<-503.85,451.05,1692.7>,
		<-383.15,468.65,1715.35>,
		<-383.15,451.05,1715.35>
  }
  triangle { // #5862
		<-383.15,468.65,1715.35>,
		<-503.85,451.05,1692.7>,
		<-503.85,468.65,1692.7>
  }
  triangle { // #5863
		<-383.15,451.05,1715.35>,
		<-383.15,468.65,1745.5>,
		<-383.15,451.05,1745.5>
  }
  triangle { // #5864
		<-383.15,468.65,1745.5>,
		<-383.15,451.05,1715.35>,
		<-383.15,468.65,1715.35>
  }
  triangle { // #5865
		<-415.2,415.85,1669.15>,
		<-384.4,415.85,1632.65>,
		<-384.4,415.85,1673.7>
  }
  triangle { // #5866
		<-384.4,415.85,1632.65>,
		<-504.6,415.85,1641.6>,
		<-504.6,415.85,1604.25>
  }
  triangle { // #5867
		<-384.4,415.85,1632.65>,
		<-475.3,415.85,1653.1>,
		<-504.6,415.85,1641.6>
  }
  triangle { // #5868
		<-384.4,415.85,1632.65>,
		<-445.5,415.85,1662.25>,
		<-475.3,415.85,1653.1>
  }
  triangle { // #5869
		<-384.4,415.85,1632.65>,
		<-415.2,415.85,1669.15>,
		<-445.5,415.85,1662.25>
  }
  triangle { // #5870
		<-384.4,433.45,1632.65>,
		<-415.2,433.45,1669.15>,
		<-384.4,433.45,1673.7>
  }
  triangle { // #5871
		<-504.6,433.45,1641.6>,
		<-384.4,433.45,1632.65>,
		<-504.6,433.45,1604.25>
  }
  triangle { // #5872
		<-475.3,433.45,1653.1>,
		<-384.4,433.45,1632.65>,
		<-504.6,433.45,1641.6>
  }
  triangle { // #5873
		<-445.5,433.45,1662.25>,
		<-384.4,433.45,1632.65>,
		<-475.3,433.45,1653.1>
  }
  triangle { // #5874
		<-415.2,433.45,1669.15>,
		<-384.4,433.45,1632.65>,
		<-445.5,433.45,1662.25>
  }
  smooth_triangle { // #5875
		<-504.6,415.85,1641.6>, <-0.365,-0.931,0>,
		<-475.3,433.45,1653.1>, <-0.342,-0.94,0>,
		<-504.6,433.45,1641.6>, <-0.365,-0.931,0>
  }
  smooth_triangle { // #5876
		<-384.4,433.45,1673.7>, <-0.146,-0.989,0>,
		<-415.2,415.85,1669.15>, <-0.171,-0.985,0>,
		<-384.4,415.85,1673.7>, <-0.146,-0.989,0>
  }
  smooth_triangle { // #5877
		<-415.2,433.45,1669.15>, <-0.196,-0.981,0>,
		<-415.2,415.85,1669.15>, <-0.171,-0.985,0>,
		<-384.4,433.45,1673.7>, <-0.146,-0.989,0>
  }
  smooth_triangle { // #5878
		<-415.2,433.45,1669.15>, <-0.196,-0.981,0>,
		<-445.5,415.85,1662.25>, <-0.246,-0.969,0>,
		<-415.2,415.85,1669.15>, <-0.171,-0.985,0>
  }
  smooth_triangle { // #5879
		<-445.5,433.45,1662.25>, <-0.27,-0.963,0>,
		<-445.5,415.85,1662.25>, <-0.246,-0.969,0>,
		<-415.2,433.45,1669.15>, <-0.196,-0.981,0>
  }
  smooth_triangle { // #5880
		<-445.5,433.45,1662.25>, <-0.27,-0.963,0>,
		<-475.3,415.85,1653.1>, <-0.318,-0.948,0>,
		<-445.5,415.85,1662.25>, <-0.246,-0.969,0>
  }
  smooth_triangle { // #5881
		<-475.3,433.45,1653.1>, <-0.342,-0.94,0>,
		<-475.3,415.85,1653.1>, <-0.318,-0.948,0>,
		<-445.5,433.45,1662.25>, <-0.27,-0.963,0>
  }
  smooth_triangle { // #5882
		<-475.3,433.45,1653.1>, <-0.342,-0.94,0>,
		<-504.6,415.85,1641.6>, <-0.365,-0.931,0>,
		<-475.3,415.85,1653.1>, <-0.318,-0.948,0>
  }
  triangle { // #5883
		<-504.6,415.85,1641.6>,
		<-504.6,433.45,1604.25>,
		<-504.6,415.85,1604.25>
  }
  triangle { // #5884
		<-504.6,433.45,1604.25>,
		<-504.6,415.85,1641.6>,
		<-504.6,433.45,1641.6>
  }
  triangle { // #5885
		<-504.6,415.85,1604.25>,
		<-384.4,433.45,1632.65>,
		<-384.4,415.85,1632.65>
  }
  triangle { // #5886
		<-384.4,433.45,1632.65>,
		<-504.6,415.85,1604.25>,
		<-504.6,433.45,1604.25>
  }
  triangle { // #5887
		<-384.4,415.85,1632.65>,
		<-384.4,433.45,1673.7>,
		<-384.4,415.85,1673.7>
  }
  triangle { // #5888
		<-384.4,433.45,1673.7>,
		<-384.4,415.85,1632.65>,
		<-384.4,433.45,1632.65>
  }
  triangle { // #5889
		<-414.2,380.65,1582.45>,
		<-383.15,380.65,1554.05>,
		<-383.15,380.65,1585.5>
  }
  triangle { // #5890
		<-383.15,380.65,1554.05>,
		<-503.85,380.65,1561>,
		<-503.85,380.65,1530.8>
  }
  triangle { // #5891
		<-383.15,380.65,1554.05>,
		<-474.55,380.65,1570.2>,
		<-503.85,380.65,1561>
  }
  triangle { // #5892
		<-383.15,380.65,1554.05>,
		<-444.65,380.65,1577.35>,
		<-474.55,380.65,1570.2>
  }
  triangle { // #5893
		<-383.15,380.65,1554.05>,
		<-414.2,380.65,1582.45>,
		<-444.65,380.65,1577.35>
  }
  triangle { // #5894
		<-383.15,398.25,1554.05>,
		<-414.2,398.25,1582.45>,
		<-383.15,398.25,1585.5>
  }
  triangle { // #5895
		<-503.85,398.25,1561>,
		<-383.15,398.25,1554.05>,
		<-503.85,398.25,1530.8>
  }
  triangle { // #5896
		<-474.55,398.25,1570.2>,
		<-383.15,398.25,1554.05>,
		<-503.85,398.25,1561>
  }
  triangle { // #5897
		<-444.65,398.25,1577.35>,
		<-383.15,398.25,1554.05>,
		<-474.55,398.25,1570.2>
  }
  triangle { // #5898
		<-414.2,398.25,1582.45>,
		<-383.15,398.25,1554.05>,
		<-444.65,398.25,1577.35>
  }
  smooth_triangle { // #5899
		<-503.85,380.65,1561>, <-0.299,-0.954,0>,
		<-474.55,398.25,1570.2>, <-0.277,-0.961,0>,
		<-503.85,398.25,1561>, <-0.299,-0.954,0>
  }
  smooth_triangle { // #5900
		<-383.15,398.25,1585.5>, <-0.098,-0.995,0>,
		<-414.2,380.65,1582.45>, <-0.121,-0.993,0>,
		<-383.15,380.65,1585.5>, <-0.098,-0.995,0>
  }
  smooth_triangle { // #5901
		<-414.2,398.25,1582.45>, <-0.143,-0.99,0>,
		<-414.2,380.65,1582.45>, <-0.121,-0.993,0>,
		<-383.15,398.25,1585.5>, <-0.098,-0.995,0>
  }
  smooth_triangle { // #5902
		<-414.2,398.25,1582.45>, <-0.143,-0.99,0>,
		<-444.65,380.65,1577.35>, <-0.188,-0.982,0>,
		<-414.2,380.65,1582.45>, <-0.121,-0.993,0>
  }
  smooth_triangle { // #5903
		<-444.65,398.25,1577.35>, <-0.21,-0.978,0>,
		<-444.65,380.65,1577.35>, <-0.188,-0.982,0>,
		<-414.2,398.25,1582.45>, <-0.143,-0.99,0>
  }
  smooth_triangle { // #5904
		<-444.65,398.25,1577.35>, <-0.21,-0.978,0>,
		<-474.55,380.65,1570.2>, <-0.255,-0.967,0>,
		<-444.65,380.65,1577.35>, <-0.188,-0.982,0>
  }
  smooth_triangle { // #5905
		<-474.55,398.25,1570.2>, <-0.277,-0.961,0>,
		<-474.55,380.65,1570.2>, <-0.255,-0.967,0>,
		<-444.65,398.25,1577.35>, <-0.21,-0.978,0>
  }
  smooth_triangle { // #5906
		<-474.55,398.25,1570.2>, <-0.277,-0.961,0>,
		<-503.85,380.65,1561>, <-0.299,-0.954,0>,
		<-474.55,380.65,1570.2>, <-0.255,-0.967,0>
  }
  triangle { // #5907
		<-503.85,380.65,1561>,
		<-503.85,398.25,1530.8>,
		<-503.85,380.65,1530.8>
  }
  triangle { // #5908
		<-503.85,398.25,1530.8>,
		<-503.85,380.65,1561>,
		<-503.85,398.25,1561>
  }
  triangle { // #5909
		<-503.85,380.65,1530.8>,
		<-383.15,398.25,1554.05>,
		<-383.15,380.65,1554.05>
  }
  triangle { // #5910
		<-383.15,398.25,1554.05>,
		<-503.85,380.65,1530.8>,
		<-503.85,398.25,1530.8>
  }
  triangle { // #5911
		<-383.15,380.65,1554.05>,
		<-383.15,398.25,1585.5>,
		<-383.15,380.65,1585.5>
  }
  triangle { // #5912
		<-383.15,398.25,1585.5>,
		<-383.15,380.65,1554.05>,
		<-383.15,398.25,1554.05>
  }
  triangle { // #5913
		<-414.05,345.45,1511.25>,
		<-383.15,345.45,1476.3>,
		<-383.15,345.45,1516.3>
  }
  triangle { // #5914
		<-383.15,345.45,1476.3>,
		<-503.35,345.45,1483.8>,
		<-503.35,345.45,1446.9>
  }
  triangle { // #5915
		<-383.15,345.45,1476.3>,
		<-474.2,345.45,1495>,
		<-503.35,345.45,1483.8>
  }
  triangle { // #5916
		<-383.15,345.45,1476.3>,
		<-444.4,345.45,1504.15>,
		<-474.2,345.45,1495>
  }
  triangle { // #5917
		<-383.15,345.45,1476.3>,
		<-414.05,345.45,1511.25>,
		<-444.4,345.45,1504.15>
  }
  triangle { // #5918
		<-383.15,363.05,1476.3>,
		<-414.05,363.05,1511.25>,
		<-383.15,363.05,1516.3>
  }
  triangle { // #5919
		<-503.35,363.05,1483.8>,
		<-383.15,363.05,1476.3>,
		<-503.35,363.05,1446.9>
  }
  triangle { // #5920
		<-474.2,363.05,1495>,
		<-383.15,363.05,1476.3>,
		<-503.35,363.05,1483.8>
  }
  triangle { // #5921
		<-444.4,363.05,1504.15>,
		<-383.15,363.05,1476.3>,
		<-474.2,363.05,1495>
  }
  triangle { // #5922
		<-414.05,363.05,1511.25>,
		<-383.15,363.05,1476.3>,
		<-444.4,363.05,1504.15>
  }
  smooth_triangle { // #5923
		<-503.35,345.45,1483.8>, <-0.358,-0.934,0>,
		<-474.2,363.05,1495>, <-0.337,-0.942,0>,
		<-503.35,363.05,1483.8>, <-0.358,-0.934,0>
  }
  smooth_triangle { // #5924
		<-383.15,363.05,1516.3>, <-0.161,-0.987,0>,
		<-414.05,345.45,1511.25>, <-0.184,-0.983,0>,
		<-383.15,345.45,1516.3>, <-0.161,-0.987,0>
  }
  smooth_triangle { // #5925
		<-414.05,363.05,1511.25>, <-0.206,-0.979,0>,
		<-414.05,345.45,1511.25>, <-0.184,-0.983,0>,
		<-383.15,363.05,1516.3>, <-0.161,-0.987,0>
  }
  smooth_triangle { // #5926
		<-414.05,363.05,1511.25>, <-0.206,-0.979,0>,
		<-444.4,345.45,1504.15>, <-0.25,-0.968,0>,
		<-414.05,345.45,1511.25>, <-0.184,-0.983,0>
  }
  smooth_triangle { // #5927
		<-444.4,363.05,1504.15>, <-0.272,-0.962,0>,
		<-444.4,345.45,1504.15>, <-0.25,-0.968,0>,
		<-414.05,363.05,1511.25>, <-0.206,-0.979,0>
  }
  smooth_triangle { // #5928
		<-444.4,363.05,1504.15>, <-0.272,-0.962,0>,
		<-474.2,345.45,1495>, <-0.315,-0.949,0>,
		<-444.4,345.45,1504.15>, <-0.25,-0.968,0>
  }
  smooth_triangle { // #5929
		<-474.2,363.05,1495>, <-0.337,-0.942,0>,
		<-474.2,345.45,1495>, <-0.315,-0.949,0>,
		<-444.4,363.05,1504.15>, <-0.272,-0.962,0>
  }
  smooth_triangle { // #5930
		<-474.2,363.05,1495>, <-0.337,-0.942,0>,
		<-503.35,345.45,1483.8>, <-0.358,-0.934,0>,
		<-474.2,345.45,1495>, <-0.315,-0.949,0>
  }
  triangle { // #5931
		<-503.35,345.45,1483.8>,
		<-503.35,363.05,1446.9>,
		<-503.35,345.45,1446.9>
  }
  triangle { // #5932
		<-503.35,363.05,1446.9>,
		<-503.35,345.45,1483.8>,
		<-503.35,363.05,1483.8>
  }
  triangle { // #5933
		<-503.35,345.45,1446.9>,
		<-383.15,363.05,1476.3>,
		<-383.15,345.45,1476.3>
  }
  triangle { // #5934
		<-383.15,363.05,1476.3>,
		<-503.35,345.45,1446.9>,
		<-503.35,363.05,1446.9>
  }
  triangle { // #5935
		<-383.15,345.45,1476.3>,
		<-383.15,363.05,1516.3>,
		<-383.15,345.45,1516.3>
  }
  triangle { // #5936
		<-383.15,363.05,1516.3>,
		<-383.15,345.45,1476.3>,
		<-383.15,363.05,1476.3>
  }
  triangle { // #5937
		<-443.3,310.25,1419.85>,
		<-383.15,310.25,1389.7>,
		<-383.15,310.25,1424.25>
  }
  triangle { // #5938
		<-383.15,310.25,1389.7>,
		<-503.85,310.25,1397.85>,
		<-503.85,310.25,1367.7>
  }
  triangle { // #5939
		<-383.15,310.25,1389.7>,
		<-443.3,310.25,1419.85>,
		<-503.85,310.25,1397.85>
  }
  triangle { // #5940
		<-383.15,327.85,1389.7>,
		<-443.3,327.85,1419.85>,
		<-383.15,327.85,1424.25>
  }
  triangle { // #5941
		<-503.85,327.85,1397.85>,
		<-383.15,327.85,1389.7>,
		<-503.85,327.85,1367.7>
  }
  triangle { // #5942
		<-443.3,327.85,1419.85>,
		<-383.15,327.85,1389.7>,
		<-503.85,327.85,1397.85>
  }
  smooth_triangle { // #5943
		<-443.3,310.25,1419.85>, <-0.254,-0.967,0>,
		<-503.85,327.85,1397.85>, <-0.342,-0.94,0>,
		<-503.85,310.25,1397.85>, <-0.342,-0.94,0>
  }
  smooth_triangle { // #5944
		<-503.85,327.85,1397.85>, <-0.342,-0.94,0>,
		<-443.3,310.25,1419.85>, <-0.254,-0.967,0>,
		<-443.3,327.85,1419.85>, <-0.164,-0.986,0>
  }
  triangle { // #5945
		<-503.85,310.25,1397.85>,
		<-503.85,327.85,1367.7>,
		<-503.85,310.25,1367.7>
  }
  triangle { // #5946
		<-503.85,327.85,1367.7>,
		<-503.85,310.25,1397.85>,
		<-503.85,327.85,1397.85>
  }
  triangle { // #5947
		<-503.85,310.25,1367.7>,
		<-383.15,327.85,1389.7>,
		<-383.15,310.25,1389.7>
  }
  triangle { // #5948
		<-383.15,327.85,1389.7>,
		<-503.85,310.25,1367.7>,
		<-503.85,327.85,1367.7>
  }
  triangle { // #5949
		<-383.15,310.25,1389.7>,
		<-383.15,327.85,1424.25>,
		<-383.15,310.25,1424.25>
  }
  triangle { // #5950
		<-383.15,327.85,1424.25>,
		<-383.15,310.25,1389.7>,
		<-383.15,327.85,1389.7>
  }
  smooth_triangle { // #5951
		<-383.15,310.25,1424.25>, <-0.073,-0.997,0>,
		<-443.3,327.85,1419.85>, <-0.164,-0.986,0>,
		<-443.3,310.25,1419.85>, <-0.254,-0.967,0>
  }
  smooth_triangle { // #5952
		<-443.3,327.85,1419.85>, <-0.164,-0.986,0>,
		<-383.15,310.25,1424.25>, <-0.073,-0.997,0>,
		<-383.15,327.85,1424.25>, <-0.073,-0.997,0>
  }
  triangle { // #5953
		<-503.85,275.05,1281.85>,
		<-476.8,275.05,1320.7>,
		<-503.85,275.05,1312.05>
  }
  triangle { // #5954
		<-416.45,275.05,1336.1>,
		<-383.15,275.05,1306.7>,
		<-383.15,275.05,1342.85>
  }
  triangle { // #5955
		<-416.45,275.05,1336.1>,
		<-503.85,275.05,1281.85>,
		<-383.15,275.05,1306.7>
  }
  triangle { // #5956
		<-447.65,275.05,1328.7>,
		<-503.85,275.05,1281.85>,
		<-416.45,275.05,1336.1>
  }
  triangle { // #5957
		<-476.8,275.05,1320.7>,
		<-503.85,275.05,1281.85>,
		<-447.65,275.05,1328.7>
  }
  triangle { // #5958
		<-476.8,292.65,1320.7>,
		<-503.85,292.65,1281.85>,
		<-503.85,292.65,1312.05>
  }
  triangle { // #5959
		<-383.15,292.65,1306.7>,
		<-416.45,292.65,1336.1>,
		<-383.15,292.65,1342.85>
  }
  triangle { // #5960
		<-503.85,292.65,1281.85>,
		<-416.45,292.65,1336.1>,
		<-383.15,292.65,1306.7>
  }
  triangle { // #5961
		<-503.85,292.65,1281.85>,
		<-447.65,292.65,1328.7>,
		<-416.45,292.65,1336.1>
  }
  triangle { // #5962
		<-503.85,292.65,1281.85>,
		<-476.8,292.65,1320.7>,
		<-447.65,292.65,1328.7>
  }
  smooth_triangle { // #5963
		<-503.85,275.05,1312.05>, <-0.304,-0.953,0>,
		<-476.8,292.65,1320.7>, <-0.291,-0.957,0>,
		<-503.85,292.65,1312.05>, <-0.304,-0.953,0>
  }
  smooth_triangle { // #5964
		<-383.15,292.65,1342.85>, <-0.199,-0.98,0>,
		<-416.45,275.05,1336.1>, <-0.209,-0.978,0>,
		<-383.15,275.05,1342.85>, <-0.199,-0.98,0>
  }
  smooth_triangle { // #5965
		<-416.45,292.65,1336.1>, <-0.22,-0.976,0>,
		<-416.45,275.05,1336.1>, <-0.209,-0.978,0>,
		<-383.15,292.65,1342.85>, <-0.199,-0.98,0>
  }
  smooth_triangle { // #5966
		<-416.45,292.65,1336.1>, <-0.22,-0.976,0>,
		<-447.65,275.05,1328.7>, <-0.242,-0.97,0>,
		<-416.45,275.05,1336.1>, <-0.209,-0.978,0>
  }
  smooth_triangle { // #5967
		<-447.65,292.65,1328.7>, <-0.254,-0.967,0>,
		<-447.65,275.05,1328.7>, <-0.242,-0.97,0>,
		<-416.45,292.65,1336.1>, <-0.22,-0.976,0>
  }
  smooth_triangle { // #5968
		<-447.65,292.65,1328.7>, <-0.254,-0.967,0>,
		<-476.8,275.05,1320.7>, <-0.278,-0.96,0>,
		<-447.65,275.05,1328.7>, <-0.242,-0.97,0>
  }
  smooth_triangle { // #5969
		<-476.8,292.65,1320.7>, <-0.291,-0.957,0>,
		<-476.8,275.05,1320.7>, <-0.278,-0.96,0>,
		<-447.65,292.65,1328.7>, <-0.254,-0.967,0>
  }
  smooth_triangle { // #5970
		<-476.8,292.65,1320.7>, <-0.291,-0.957,0>,
		<-503.85,275.05,1312.05>, <-0.304,-0.953,0>,
		<-476.8,275.05,1320.7>, <-0.278,-0.96,0>
  }
  triangle { // #5971
		<-503.85,275.05,1312.05>,
		<-503.85,292.65,1281.85>,
		<-503.85,275.05,1281.85>
  }
  triangle { // #5972
		<-503.85,292.65,1281.85>,
		<-503.85,275.05,1312.05>,
		<-503.85,292.65,1312.05>
  }
  triangle { // #5973
		<-503.85,275.05,1281.85>,
		<-383.15,292.65,1306.7>,
		<-383.15,275.05,1306.7>
  }
  triangle { // #5974
		<-383.15,292.65,1306.7>,
		<-503.85,275.05,1281.85>,
		<-503.85,292.65,1281.85>
  }
  triangle { // #5975
		<-383.15,275.05,1306.7>,
		<-383.15,292.65,1342.85>,
		<-383.15,275.05,1342.85>
  }
  triangle { // #5976
		<-383.15,292.65,1342.85>,
		<-383.15,275.05,1306.7>,
		<-383.15,292.65,1306.7>
  }
  triangle { // #5977
		<-421.15,239.85,1255.5>,
		<-383.15,239.85,1225.6>,
		<-383.15,239.85,1260.2>
  }
  triangle { // #5978
		<-383.15,239.85,1225.6>,
		<-503.85,239.85,1228.45>,
		<-503.85,239.85,1198.25>
  }
  triangle { // #5979
		<-383.15,239.85,1225.6>,
		<-493.3,239.85,1234.3>,
		<-503.85,239.85,1228.45>
  }
  triangle { // #5980
		<-383.15,239.85,1225.6>,
		<-481.5,239.85,1239.6>,
		<-493.3,239.85,1234.3>
  }
  triangle { // #5981
		<-383.15,239.85,1225.6>,
		<-453.95,239.85,1248.65>,
		<-481.5,239.85,1239.6>
  }
  triangle { // #5982
		<-383.15,239.85,1225.6>,
		<-421.15,239.85,1255.5>,
		<-453.95,239.85,1248.65>
  }
  triangle { // #5983
		<-383.15,257.45,1225.6>,
		<-421.15,257.45,1255.5>,
		<-383.15,257.45,1260.2>
  }
  triangle { // #5984
		<-503.85,257.45,1228.45>,
		<-383.15,257.45,1225.6>,
		<-503.85,257.45,1198.25>
  }
  triangle { // #5985
		<-493.3,257.45,1234.3>,
		<-383.15,257.45,1225.6>,
		<-503.85,257.45,1228.45>
  }
  triangle { // #5986
		<-481.5,257.45,1239.6>,
		<-383.15,257.45,1225.6>,
		<-493.3,257.45,1234.3>
  }
  triangle { // #5987
		<-453.95,257.45,1248.65>,
		<-383.15,257.45,1225.6>,
		<-481.5,257.45,1239.6>
  }
  triangle { // #5988
		<-421.15,257.45,1255.5>,
		<-383.15,257.45,1225.6>,
		<-453.95,257.45,1248.65>
  }
  smooth_triangle { // #5989
		<-383.15,257.45,1260.2>, <-0.123,-0.992,0>,
		<-421.15,239.85,1255.5>, <-0.15,-0.989,0>,
		<-383.15,239.85,1260.2>, <-0.123,-0.992,0>
  }
  smooth_triangle { // #5990
		<-503.85,239.85,1228.45>, <-0.487,-0.874,0>,
		<-493.3,257.45,1234.3>, <-0.462,-0.887,0>,
		<-503.85,257.45,1228.45>, <-0.487,-0.874,0>
  }
  smooth_triangle { // #5991
		<-493.3,239.85,1234.3>, <-0.436,-0.9,0>,
		<-493.3,257.45,1234.3>, <-0.462,-0.887,0>,
		<-503.85,239.85,1228.45>, <-0.487,-0.874,0>
  }
  smooth_triangle { // #5992
		<-493.3,239.85,1234.3>, <-0.436,-0.9,0>,
		<-481.5,257.45,1239.6>, <-0.378,-0.926,0>,
		<-493.3,257.45,1234.3>, <-0.462,-0.887,0>
  }
  smooth_triangle { // #5993
		<-481.5,239.85,1239.6>, <-0.345,-0.939,0>,
		<-481.5,257.45,1239.6>, <-0.378,-0.926,0>,
		<-493.3,239.85,1234.3>, <-0.436,-0.9,0>
  }
  smooth_triangle { // #5994
		<-481.5,239.85,1239.6>, <-0.345,-0.939,0>,
		<-453.95,257.45,1248.65>, <-0.276,-0.961,0>,
		<-481.5,257.45,1239.6>, <-0.378,-0.926,0>
  }
  smooth_triangle { // #5995
		<-453.95,239.85,1248.65>, <-0.24,-0.971,0>,
		<-453.95,257.45,1248.65>, <-0.276,-0.961,0>,
		<-481.5,239.85,1239.6>, <-0.345,-0.939,0>
  }
  smooth_triangle { // #5996
		<-453.95,239.85,1248.65>, <-0.24,-0.971,0>,
		<-421.15,257.45,1255.5>, <-0.177,-0.984,0>,
		<-453.95,257.45,1248.65>, <-0.276,-0.961,0>
  }
  smooth_triangle { // #5997
		<-421.15,239.85,1255.5>, <-0.15,-0.989,0>,
		<-421.15,257.45,1255.5>, <-0.177,-0.984,0>,
		<-453.95,239.85,1248.65>, <-0.24,-0.971,0>
  }
  smooth_triangle { // #5998
		<-421.15,239.85,1255.5>, <-0.15,-0.989,0>,
		<-383.15,257.45,1260.2>, <-0.123,-0.992,0>,
		<-421.15,257.45,1255.5>, <-0.177,-0.984,0>
  }
  triangle { // #5999
		<-503.85,239.85,1228.45>,
		<-503.85,257.45,1198.25>,
		<-503.85,239.85,1198.25>
  }
  triangle { // #6000
		<-503.85,257.45,1198.25>,
		<-503.85,239.85,1228.45>,
		<-503.85,257.45,1228.45>
  }
  triangle { // #6001
		<-503.85,239.85,1198.25>,
		<-383.15,257.45,1225.6>,
		<-383.15,239.85,1225.6>
  }
  triangle { // #6002
		<-383.15,257.45,1225.6>,
		<-503.85,239.85,1198.25>,
		<-503.85,257.45,1198.25>
  }
  triangle { // #6003
		<-383.15,239.85,1225.6>,
		<-383.15,257.45,1260.2>,
		<-383.15,239.85,1260.2>
  }
  triangle { // #6004
		<-383.15,257.45,1260.2>,
		<-383.15,239.85,1225.6>,
		<-383.15,257.45,1225.6>
  }
  triangle { // #6005
		<-0.45,-118,338.95>,
		<846.85,-128.95,340>,
		<0.15,-153.35,342.35>
  }
  triangle { // #6006
		<-0.45,-118,338.95>,
		<-843,-131.45,340.25>,
		<-843,-98.9,337.1>
  }
  triangle { // #6007
		<-0.45,-118,338.95>,
		<0.15,-153.35,342.35>,
		<-843,-131.45,340.25>
  }
  triangle { // #6008
		<846.85,-128.95,340>,
		<-0.45,-118,338.95>,
		<846.85,-98.9,337.1>
  }
  triangle { // #6009
		<846.85,-18.2,1490.15>,
		<-0.45,-7.25,1489.1>,
		<0.15,-42.6,1492.5>
  }
  triangle { // #6010
		<-843,-20.7,1490.4>,
		<-0.45,-7.25,1489.1>,
		<-843,11.85,1487.25>
  }
  triangle { // #6011
		<0.15,-42.6,1492.5>,
		<-0.45,-7.25,1489.1>,
		<-843,-20.7,1490.4>
  }
  triangle { // #6012
		<-0.45,-7.25,1489.1>,
		<846.85,-18.2,1490.15>,
		<846.85,11.85,1487.25>
  }
  triangle { // #6013
		<-843,-131.45,340.25>,
		<-843,11.85,1487.25>,
		<-843,-98.9,337.1>
  }
  triangle { // #6014
		<-843,11.85,1487.25>,
		<-843,-131.45,340.25>,
		<-843,-20.7,1490.4>
  }
  smooth_triangle { // #6015
		<-843,11.85,1487.25>, <0.023,0.096,0.995>,
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-843,-98.9,337.1>, <0.023,0.096,0.995>
  }
  smooth_triangle { // #6016
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<846.85,11.85,1487.25>, <-0.023,0.096,0.995>,
		<846.85,-98.9,337.1>, <-0.023,0.096,0.995>
  }
  smooth_triangle { // #6017
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-0.45,-7.25,1489.1>, <0,0.096,0.995>,
		<846.85,11.85,1487.25>, <-0.023,0.096,0.995>
  }
  smooth_triangle { // #6018
		<-0.45,-118,338.95>, <0,0.096,0.995>,
		<-843,11.85,1487.25>, <0.023,0.096,0.995>,
		<-0.45,-7.25,1489.1>, <0,0.096,0.995>
  }
  triangle { // #6019
		<846.85,-98.9,337.1>,
		<846.85,-18.2,1490.15>,
		<846.85,-128.95,340>
  }
  triangle { // #6020
		<846.85,-18.2,1490.15>,
		<846.85,-98.9,337.1>,
		<846.85,11.85,1487.25>
  }
  smooth_triangle { // #6021
		<846.85,-18.2,1490.15>, <0.029,-0.096,-0.995>,
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<846.85,-128.95,340>, <0.029,-0.096,-0.995>
  }
  smooth_triangle { // #6022
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<-843,-20.7,1490.4>, <-0.026,-0.096,-0.995>,
		<-843,-131.45,340.25>, <-0.026,-0.096,-0.995>
  }
  smooth_triangle { // #6023
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<0.15,-42.6,1492.5>, <0.001,-0.096,-0.995>,
		<-843,-20.7,1490.4>, <-0.026,-0.096,-0.995>
  }
  smooth_triangle { // #6024
		<0.15,-153.35,342.35>, <0.001,-0.096,-0.995>,
		<846.85,-18.2,1490.15>, <0.029,-0.096,-0.995>,
		<0.15,-42.6,1492.5>, <0.001,-0.096,-0.995>
  }
  triangle { // #6025
		<-114.05,-30.2,302.8>,
		<-3.55,-30.2,337.95>,
		<-1.6,-30.2,307.8>
  }
  triangle { // #6026
		<334.95,-30.2,249.85>,
		<444.7,-30.2,240.2>,
		<446.85,-30.2,206.25>
  }
  triangle { // #6027
		<334.95,-30.2,249.85>,
		<333.2,-30.2,282.4>,
		<444.7,-30.2,240.2>
  }
  triangle { // #6028
		<222.9,-30.2,281.3>,
		<333.2,-30.2,282.4>,
		<334.95,-30.2,249.85>
  }
  triangle { // #6029
		<222.9,-30.2,281.3>,
		<221.35,-30.2,312.75>,
		<333.2,-30.2,282.4>
  }
  triangle { // #6030
		<110.75,-30.2,300.6>,
		<221.35,-30.2,312.75>,
		<222.9,-30.2,281.3>
  }
  triangle { // #6031
		<110.75,-30.2,300.6>,
		<109.1,-30.2,331.25>,
		<221.35,-30.2,312.75>
  }
  triangle { // #6032
		<-458.1,-30.2,246.5>,
		<-339.4,-30.2,256.45>,
		<-452.25,-30.2,215.05>
  }
  triangle { // #6033
		<-343.9,-30.2,287.1>,
		<-339.4,-30.2,256.45>,
		<-458.1,-30.2,246.5>
  }
  triangle { // #6034
		<-1.6,-30.2,307.8>,
		<109.1,-30.2,331.25>,
		<110.75,-30.2,300.6>
  }
  triangle { // #6035
		<-1.6,-30.2,307.8>,
		<-3.55,-30.2,337.95>,
		<109.1,-30.2,331.25>
  }
  triangle { // #6036
		<-343.9,-30.2,287.1>,
		<-226.65,-30.2,285.7>,
		<-339.4,-30.2,256.45>
  }
  triangle { // #6037
		<-230.05,-30.2,315.9>,
		<-226.65,-30.2,285.7>,
		<-343.9,-30.2,287.1>
  }
  triangle { // #6038
		<-230.05,-30.2,315.9>,
		<-114.05,-30.2,302.8>,
		<-226.65,-30.2,285.7>
  }
  triangle { // #6039
		<-116.6,-30.2,332.85>,
		<-114.05,-30.2,302.8>,
		<-230.05,-30.2,315.9>
  }
  triangle { // #6040
		<-3.55,-30.2,337.95>,
		<-114.05,-30.2,302.8>,
		<-116.6,-30.2,332.85>
  }
  triangle { // #6041
		<-3.55,-191.1,337.95>,
		<-114.05,-191.1,302.8>,
		<-1.6,-191.1,307.8>
  }
  triangle { // #6042
		<444.7,-191.1,240.2>,
		<334.95,-191.1,249.85>,
		<446.85,-191.1,206.25>
  }
  triangle { // #6043
		<333.2,-191.1,282.4>,
		<334.95,-191.1,249.85>,
		<444.7,-191.1,240.2>
  }
  triangle { // #6044
		<333.2,-191.1,282.4>,
		<222.9,-191.1,281.3>,
		<334.95,-191.1,249.85>
  }
  triangle { // #6045
		<221.35,-191.1,312.75>,
		<222.9,-191.1,281.3>,
		<333.2,-191.1,282.4>
  }
  triangle { // #6046
		<221.35,-191.1,312.75>,
		<110.75,-191.1,300.6>,
		<222.9,-191.1,281.3>
  }
  triangle { // #6047
		<109.1,-191.1,331.25>,
		<110.75,-191.1,300.6>,
		<221.35,-191.1,312.75>
  }
  triangle { // #6048
		<-339.4,-191.1,256.45>,
		<-458.1,-191.1,246.5>,
		<-452.25,-191.1,215.05>
  }
  triangle { // #6049
		<-339.4,-191.1,256.45>,
		<-343.9,-191.1,287.1>,
		<-458.1,-191.1,246.5>
  }
  triangle { // #6050
		<109.1,-191.1,331.25>,
		<-1.6,-191.1,307.8>,
		<110.75,-191.1,300.6>
  }
  triangle { // #6051
		<-3.55,-191.1,337.95>,
		<-1.6,-191.1,307.8>,
		<109.1,-191.1,331.25>
  }
  triangle { // #6052
		<-226.65,-191.1,285.7>,
		<-343.9,-191.1,287.1>,
		<-339.4,-191.1,256.45>
  }
  triangle { // #6053
		<-226.65,-191.1,285.7>,
		<-230.05,-191.1,315.9>,
		<-343.9,-191.1,287.1>
  }
  triangle { // #6054
		<-114.05,-191.1,302.8>,
		<-230.05,-191.1,315.9>,
		<-226.65,-191.1,285.7>
  }
  triangle { // #6055
		<-114.05,-191.1,302.8>,
		<-116.6,-191.1,332.85>,
		<-230.05,-191.1,315.9>
  }
  triangle { // #6056
		<-114.05,-191.1,302.8>,
		<-3.55,-191.1,337.95>,
		<-116.6,-191.1,332.85>
  }
  triangle { // #6057
		<-452.25,-30.2,215.05>,
		<-458.1,-191.1,246.5>,
		<-458.1,-30.2,246.5>
  }
  triangle { // #6058
		<-458.1,-191.1,246.5>,
		<-452.25,-30.2,215.05>,
		<-452.25,-191.1,215.05>
  }
  smooth_triangle { // #6059
		<-458.1,-191.1,246.5>, <-0.335,-0.942,0>,
		<-343.9,-30.2,287.1>, <-0.305,-0.952,0>,
		<-458.1,-30.2,246.5>, <-0.335,-0.942,0>
  }
  smooth_triangle { // #6060
		<333.2,-30.2,282.4>, <0.308,-0.951,0>,
		<444.7,-191.1,240.2>, <0.354,-0.935,0>,
		<444.7,-30.2,240.2>, <0.354,-0.935,0>
  }
  smooth_triangle { // #6061
		<333.2,-30.2,282.4>, <0.308,-0.951,0>,
		<333.2,-191.1,282.4>, <0.308,-0.951,0>,
		<444.7,-191.1,240.2>, <0.354,-0.935,0>
  }
  smooth_triangle { // #6062
		<333.2,-30.2,282.4>, <0.308,-0.951,0>,
		<221.35,-191.1,312.75>, <0.229,-0.973,0>,
		<333.2,-191.1,282.4>, <0.308,-0.951,0>
  }
  smooth_triangle { // #6063
		<221.35,-30.2,312.75>, <0.196,-0.981,0>,
		<221.35,-191.1,312.75>, <0.229,-0.973,0>,
		<333.2,-30.2,282.4>, <0.308,-0.951,0>
  }
  smooth_triangle { // #6064
		<221.35,-30.2,312.75>, <0.196,-0.981,0>,
		<109.1,-191.1,331.25>, <0.128,-0.992,0>,
		<221.35,-191.1,312.75>, <0.229,-0.973,0>
  }
  smooth_triangle { // #6065
		<109.1,-30.2,331.25>, <0.094,-0.996,0>,
		<109.1,-191.1,331.25>, <0.128,-0.992,0>,
		<221.35,-30.2,312.75>, <0.196,-0.981,0>
  }
  smooth_triangle { // #6066
		<109.1,-30.2,331.25>, <0.094,-0.996,0>,
		<-3.55,-191.1,337.95>, <0.025,-1,0>,
		<109.1,-191.1,331.25>, <0.128,-0.992,0>
  }
  smooth_triangle { // #6067
		<-3.55,-30.2,337.95>, <-0.01,-1,0>,
		<-3.55,-191.1,337.95>, <0.025,-1,0>,
		<109.1,-30.2,331.25>, <0.094,-0.996,0>
  }
  smooth_triangle { // #6068
		<-3.55,-30.2,337.95>, <-0.01,-1,0>,
		<-116.6,-191.1,332.85>, <-0.08,-0.997,0>,
		<-3.55,-191.1,337.95>, <0.025,-1,0>
  }
  smooth_triangle { // #6069
		<-116.6,-30.2,332.85>, <-0.114,-0.994,0>,
		<-116.6,-191.1,332.85>, <-0.08,-0.997,0>,
		<-3.55,-30.2,337.95>, <-0.01,-1,0>
  }
  smooth_triangle { // #6070
		<-116.6,-30.2,332.85>, <-0.114,-0.994,0>,
		<-230.05,-191.1,315.9>, <-0.18,-0.984,0>,
		<-116.6,-191.1,332.85>, <-0.08,-0.997,0>
  }
  smooth_triangle { // #6071
		<-230.05,-30.2,315.9>, <-0.213,-0.977,0>,
		<-230.05,-191.1,315.9>, <-0.18,-0.984,0>,
		<-116.6,-30.2,332.85>, <-0.114,-0.994,0>
  }
  smooth_triangle { // #6072
		<-230.05,-30.2,315.9>, <-0.213,-0.977,0>,
		<-343.9,-191.1,287.1>, <-0.275,-0.961,0>,
		<-230.05,-191.1,315.9>, <-0.18,-0.984,0>
  }
  smooth_triangle { // #6073
		<-343.9,-30.2,287.1>, <-0.305,-0.952,0>,
		<-343.9,-191.1,287.1>, <-0.275,-0.961,0>,
		<-230.05,-30.2,315.9>, <-0.213,-0.977,0>
  }
  smooth_triangle { // #6074
		<-343.9,-30.2,287.1>, <-0.305,-0.952,0>,
		<-458.1,-191.1,246.5>, <-0.335,-0.942,0>,
		<-343.9,-191.1,287.1>, <-0.275,-0.961,0>
  }
  triangle { // #6075
		<444.7,-30.2,240.2>,
		<446.85,-191.1,206.25>,
		<446.85,-30.2,206.25>
  }
  triangle { // #6076
		<446.85,-191.1,206.25>,
		<444.7,-30.2,240.2>,
		<444.7,-191.1,240.2>
  }
  smooth_triangle { // #6077
		<334.95,-191.1,249.85>, <-0.302,0.953,0>,
		<222.9,-30.2,281.3>, <-0.237,0.972,0>,
		<334.95,-30.2,249.85>, <-0.332,0.943,0>
  }
  smooth_triangle { // #6078
		<446.85,-191.1,206.25>, <-0.363,0.932,0>,
		<334.95,-30.2,249.85>, <-0.332,0.943,0>,
		<446.85,-30.2,206.25>, <-0.363,0.932,0>
  }
  smooth_triangle { // #6079
		<334.95,-191.1,249.85>, <-0.302,0.953,0>,
		<334.95,-30.2,249.85>, <-0.332,0.943,0>,
		<446.85,-191.1,206.25>, <-0.363,0.932,0>
  }
  smooth_triangle { // #6080
		<-339.4,-30.2,256.45>, <0.298,0.955,0>,
		<-452.25,-191.1,215.05>, <0.344,0.939,0>,
		<-452.25,-30.2,215.05>, <0.344,0.939,0>
  }
  smooth_triangle { // #6081
		<-339.4,-30.2,256.45>, <0.298,0.955,0>,
		<-339.4,-191.1,256.45>, <0.298,0.955,0>,
		<-452.25,-191.1,215.05>, <0.344,0.939,0>
  }
  smooth_triangle { // #6082
		<-339.4,-30.2,256.45>, <0.298,0.955,0>,
		<-226.65,-191.1,285.7>, <0.218,0.976,0>,
		<-339.4,-191.1,256.45>, <0.298,0.955,0>
  }
  smooth_triangle { // #6083
		<-226.65,-30.2,285.7>, <0.184,0.983,0>,
		<-226.65,-191.1,285.7>, <0.218,0.976,0>,
		<-339.4,-30.2,256.45>, <0.298,0.955,0>
  }
  smooth_triangle { // #6084
		<-226.65,-30.2,285.7>, <0.184,0.983,0>,
		<-114.05,-191.1,302.8>, <0.115,0.993,0>,
		<-226.65,-191.1,285.7>, <0.218,0.976,0>
  }
  smooth_triangle { // #6085
		<-114.05,-30.2,302.8>, <0.08,0.997,0>,
		<-114.05,-191.1,302.8>, <0.115,0.993,0>,
		<-226.65,-30.2,285.7>, <0.184,0.983,0>
  }
  smooth_triangle { // #6086
		<-114.05,-30.2,302.8>, <0.08,0.997,0>,
		<-1.6,-191.1,307.8>, <0.008,1,0>,
		<-114.05,-191.1,302.8>, <0.115,0.993,0>
  }
  smooth_triangle { // #6087
		<-1.6,-30.2,307.8>, <-0.028,1,0>,
		<-1.6,-191.1,307.8>, <0.008,1,0>,
		<-114.05,-30.2,302.8>, <0.08,0.997,0>
  }
  smooth_triangle { // #6088
		<-1.6,-30.2,307.8>, <-0.028,1,0>,
		<110.75,-191.1,300.6>, <-0.099,0.995,0>,
		<-1.6,-191.1,307.8>, <0.008,1,0>
  }
  smooth_triangle { // #6089
		<110.75,-30.2,300.6>, <-0.135,0.991,0>,
		<110.75,-191.1,300.6>, <-0.099,0.995,0>,
		<-1.6,-30.2,307.8>, <-0.028,1,0>
  }
  smooth_triangle { // #6090
		<110.75,-30.2,300.6>, <-0.135,0.991,0>,
		<222.9,-191.1,281.3>, <-0.203,0.979,0>,
		<110.75,-191.1,300.6>, <-0.099,0.995,0>
  }
  smooth_triangle { // #6091
		<222.9,-30.2,281.3>, <-0.237,0.972,0>,
		<222.9,-191.1,281.3>, <-0.203,0.979,0>,
		<110.75,-30.2,300.6>, <-0.135,0.991,0>
  }
  smooth_triangle { // #6092
		<222.9,-30.2,281.3>, <-0.237,0.972,0>,
		<334.95,-191.1,249.85>, <-0.302,0.953,0>,
		<222.9,-191.1,281.3>, <-0.203,0.979,0>
  }
  triangle { // #6093
		<-119.15,-190.8,325.45>,
		<-2.95,-190.8,217.55>,
		<-116.6,-190.8,211.3>
  }
  triangle { // #6094
		<336.05,-190.8,161>,
		<454.6,-190.8,233.9>,
		<448.4,-190.8,117>
  }
  triangle { // #6095
		<336.05,-190.8,161>,
		<340.65,-190.8,275.8>,
		<454.6,-190.8,233.9>
  }
  triangle { // #6096
		<-468.15,-190.8,238.95>,
		<-344.8,-190.8,161>,
		<-459.35,-190.8,117>
  }
  triangle { // #6097
		<-351.4,-190.8,279.55>,
		<-344.8,-190.8,161>,
		<-468.15,-190.8,238.95>
  }
  triangle { // #6098
		<223.35,-190.8,192.4>,
		<340.65,-190.8,275.8>,
		<336.05,-190.8,161>
  }
  triangle { // #6099
		<223.35,-190.8,192.4>,
		<226.3,-190.8,305.9>,
		<340.65,-190.8,275.8>
  }
  triangle { // #6100
		<-351.4,-190.8,279.55>,
		<-230.5,-190.8,192.4>,
		<-344.8,-190.8,161>
  }
  triangle { // #6101
		<-235.1,-190.8,308.4>,
		<-230.5,-190.8,192.4>,
		<-351.4,-190.8,279.55>
  }
  triangle { // #6102
		<110.35,-190.8,211.3>,
		<226.3,-190.8,305.9>,
		<223.35,-190.8,192.4>
  }
  triangle { // #6103
		<110.35,-190.8,211.3>,
		<111.55,-190.8,324.2>,
		<226.3,-190.8,305.9>
  }
  triangle { // #6104
		<-235.1,-190.8,308.4>,
		<-116.6,-190.8,211.3>,
		<-230.5,-190.8,192.4>
  }
  triangle { // #6105
		<-119.15,-190.8,325.45>,
		<-116.6,-190.8,211.3>,
		<-235.1,-190.8,308.4>
  }
  triangle { // #6106
		<-2.95,-190.8,217.55>,
		<111.55,-190.8,324.2>,
		<110.35,-190.8,211.3>
  }
  triangle { // #6107
		<-2.95,-190.8,217.55>,
		<-3.6,-190.8,330.75>,
		<111.55,-190.8,324.2>
  }
  triangle { // #6108
		<-2.95,-190.8,217.55>,
		<-119.15,-190.8,325.45>,
		<-3.6,-190.8,330.75>
  }
  triangle { // #6109
		<-2.95,-215.95,217.55>,
		<-119.15,-215.95,325.45>,
		<-116.6,-215.95,211.3>
  }
  triangle { // #6110
		<454.6,-215.95,233.9>,
		<336.05,-215.95,161>,
		<448.4,-215.95,117>
  }
  triangle { // #6111
		<340.65,-215.95,275.8>,
		<336.05,-215.95,161>,
		<454.6,-215.95,233.9>
  }
  triangle { // #6112
		<-344.8,-215.95,161>,
		<-468.15,-215.95,238.95>,
		<-459.35,-215.95,117>
  }
  triangle { // #6113
		<-344.8,-215.95,161>,
		<-351.4,-215.95,279.55>,
		<-468.15,-215.95,238.95>
  }
  triangle { // #6114
		<340.65,-215.95,275.8>,
		<223.35,-215.95,192.4>,
		<336.05,-215.95,161>
  }
  triangle { // #6115
		<226.3,-215.95,305.9>,
		<223.35,-215.95,192.4>,
		<340.65,-215.95,275.8>
  }
  triangle { // #6116
		<-230.5,-215.95,192.4>,
		<-351.4,-215.95,279.55>,
		<-344.8,-215.95,161>
  }
  triangle { // #6117
		<-230.5,-215.95,192.4>,
		<-235.1,-215.95,308.4>,
		<-351.4,-215.95,279.55>
  }
  triangle { // #6118
		<226.3,-215.95,305.9>,
		<110.35,-215.95,211.3>,
		<223.35,-215.95,192.4>
  }
  triangle { // #6119
		<111.55,-215.95,324.2>,
		<110.35,-215.95,211.3>,
		<226.3,-215.95,305.9>
  }
  triangle { // #6120
		<-116.6,-215.95,211.3>,
		<-235.1,-215.95,308.4>,
		<-230.5,-215.95,192.4>
  }
  triangle { // #6121
		<-116.6,-215.95,211.3>,
		<-119.15,-215.95,325.45>,
		<-235.1,-215.95,308.4>
  }
  triangle { // #6122
		<111.55,-215.95,324.2>,
		<-2.95,-215.95,217.55>,
		<110.35,-215.95,211.3>
  }
  triangle { // #6123
		<-3.6,-215.95,330.75>,
		<-2.95,-215.95,217.55>,
		<111.55,-215.95,324.2>
  }
  triangle { // #6124
		<-119.15,-215.95,325.45>,
		<-2.95,-215.95,217.55>,
		<-3.6,-215.95,330.75>
  }
  triangle { // #6125
		<-459.35,-190.8,117>,
		<-468.15,-215.95,238.95>,
		<-468.15,-190.8,238.95>
  }
  triangle { // #6126
		<-468.15,-215.95,238.95>,
		<-459.35,-190.8,117>,
		<-459.35,-215.95,117>
  }
  smooth_triangle { // #6127
		<-468.15,-215.95,238.95>, <-0.329,-0.944,0>,
		<-351.4,-190.8,279.55>, <-0.3,-0.954,0>,
		<-468.15,-190.8,238.95>, <-0.329,-0.944,0>
  }
  smooth_triangle { // #6128
		<340.65,-190.8,275.8>, <0.3,-0.954,0>,
		<454.6,-215.95,233.9>, <0.345,-0.939,0>,
		<454.6,-190.8,233.9>, <0.345,-0.939,0>
  }
  smooth_triangle { // #6129
		<340.65,-190.8,275.8>, <0.3,-0.954,0>,
		<340.65,-215.95,275.8>, <0.3,-0.954,0>,
		<454.6,-215.95,233.9>, <0.345,-0.939,0>
  }
  smooth_triangle { // #6130
		<340.65,-190.8,275.8>, <0.3,-0.954,0>,
		<226.3,-215.95,305.9>, <0.222,-0.975,0>,
		<340.65,-215.95,275.8>, <0.3,-0.954,0>
  }
  smooth_triangle { // #6131
		<226.3,-190.8,305.9>, <0.19,-0.982,0>,
		<226.3,-215.95,305.9>, <0.222,-0.975,0>,
		<340.65,-190.8,275.8>, <0.3,-0.954,0>
  }
  smooth_triangle { // #6132
		<226.3,-190.8,305.9>, <0.19,-0.982,0>,
		<111.55,-215.95,324.2>, <0.124,-0.992,0>,
		<226.3,-215.95,305.9>, <0.222,-0.975,0>
  }
  smooth_triangle { // #6133
		<111.55,-190.8,324.2>, <0.09,-0.996,0>,
		<111.55,-215.95,324.2>, <0.124,-0.992,0>,
		<226.3,-190.8,305.9>, <0.19,-0.982,0>
  }
  smooth_triangle { // #6134
		<111.55,-190.8,324.2>, <0.09,-0.996,0>,
		<-3.6,-215.95,330.75>, <0.023,-1,0>,
		<111.55,-215.95,324.2>, <0.124,-0.992,0>
  }
  smooth_triangle { // #6135
		<-3.6,-190.8,330.75>, <-0.012,-1,0>,
		<-3.6,-215.95,330.75>, <0.023,-1,0>,
		<111.55,-190.8,324.2>, <0.09,-0.996,0>
  }
  smooth_triangle { // #6136
		<-3.6,-190.8,330.75>, <-0.012,-1,0>,
		<-119.15,-215.95,325.45>, <-0.079,-0.997,0>,
		<-3.6,-215.95,330.75>, <0.023,-1,0>
  }
  smooth_triangle { // #6137
		<-119.15,-190.8,325.45>, <-0.112,-0.994,0>,
		<-119.15,-215.95,325.45>, <-0.079,-0.997,0>,
		<-3.6,-190.8,330.75>, <-0.012,-1,0>
  }
  smooth_triangle { // #6138
		<-119.15,-190.8,325.45>, <-0.112,-0.994,0>,
		<-235.1,-215.95,308.4>, <-0.177,-0.984,0>,
		<-119.15,-215.95,325.45>, <-0.079,-0.997,0>
  }
  smooth_triangle { // #6139
		<-235.1,-190.8,308.4>, <-0.209,-0.978,0>,
		<-235.1,-215.95,308.4>, <-0.177,-0.984,0>,
		<-119.15,-190.8,325.45>, <-0.112,-0.994,0>
  }
  smooth_triangle { // #6140
		<-235.1,-190.8,308.4>, <-0.209,-0.978,0>,
		<-351.4,-215.95,279.55>, <-0.27,-0.963,0>,
		<-235.1,-215.95,308.4>, <-0.177,-0.984,0>
  }
  smooth_triangle { // #6141
		<-351.4,-190.8,279.55>, <-0.3,-0.954,0>,
		<-351.4,-215.95,279.55>, <-0.27,-0.963,0>,
		<-235.1,-190.8,308.4>, <-0.209,-0.978,0>
  }
  smooth_triangle { // #6142
		<-351.4,-190.8,279.55>, <-0.3,-0.954,0>,
		<-468.15,-215.95,238.95>, <-0.329,-0.944,0>,
		<-351.4,-215.95,279.55>, <-0.27,-0.963,0>
  }
  triangle { // #6143
		<454.6,-190.8,233.9>,
		<448.4,-215.95,117>,
		<448.4,-190.8,117>
  }
  triangle { // #6144
		<448.4,-215.95,117>,
		<454.6,-190.8,233.9>,
		<454.6,-215.95,233.9>
  }
  smooth_triangle { // #6145
		<-459.35,-190.8,117>, <0.359,0.934,0>,
		<-344.8,-215.95,161>, <0.328,0.945,0>,
		<-459.35,-215.95,117>, <0.359,0.934,0>
  }
  smooth_triangle { // #6146
		<448.4,-215.95,117>, <-0.365,0.931,0>,
		<336.05,-190.8,161>, <-0.333,0.943,0>,
		<448.4,-190.8,117>, <-0.365,0.931,0>
  }
  smooth_triangle { // #6147
		<336.05,-215.95,161>, <-0.301,0.954,0>,
		<336.05,-190.8,161>, <-0.333,0.943,0>,
		<448.4,-215.95,117>, <-0.365,0.931,0>
  }
  smooth_triangle { // #6148
		<336.05,-215.95,161>, <-0.301,0.954,0>,
		<223.35,-190.8,192.4>, <-0.234,0.972,0>,
		<336.05,-190.8,161>, <-0.333,0.943,0>
  }
  smooth_triangle { // #6149
		<223.35,-215.95,192.4>, <-0.2,0.98,0>,
		<223.35,-190.8,192.4>, <-0.234,0.972,0>,
		<336.05,-215.95,161>, <-0.301,0.954,0>
  }
  smooth_triangle { // #6150
		<223.35,-215.95,192.4>, <-0.2,0.98,0>,
		<110.35,-190.8,211.3>, <-0.128,0.992,0>,
		<223.35,-190.8,192.4>, <-0.234,0.972,0>
  }
  smooth_triangle { // #6151
		<110.35,-215.95,211.3>, <-0.092,0.996,0>,
		<110.35,-190.8,211.3>, <-0.128,0.992,0>,
		<223.35,-215.95,192.4>, <-0.2,0.98,0>
  }
  smooth_triangle { // #6152
		<110.35,-215.95,211.3>, <-0.092,0.996,0>,
		<-2.95,-190.8,217.55>, <-0.019,1,0>,
		<110.35,-190.8,211.3>, <-0.128,0.992,0>
  }
  smooth_triangle { // #6153
		<-2.95,-215.95,217.55>, <0.018,1,0>,
		<-2.95,-190.8,217.55>, <-0.019,1,0>,
		<110.35,-215.95,211.3>, <-0.092,0.996,0>
  }
  smooth_triangle { // #6154
		<-2.95,-215.95,217.55>, <0.018,1,0>,
		<-116.6,-190.8,211.3>, <0.091,0.996,0>,
		<-2.95,-190.8,217.55>, <-0.019,1,0>
  }
  smooth_triangle { // #6155
		<-116.6,-215.95,211.3>, <0.127,0.992,0>,
		<-116.6,-190.8,211.3>, <0.091,0.996,0>,
		<-2.95,-215.95,217.55>, <0.018,1,0>
  }
  smooth_triangle { // #6156
		<-116.6,-215.95,211.3>, <0.127,0.992,0>,
		<-230.5,-190.8,192.4>, <0.198,0.98,0>,
		<-116.6,-190.8,211.3>, <0.091,0.996,0>
  }
  smooth_triangle { // #6157
		<-230.5,-215.95,192.4>, <0.232,0.973,0>,
		<-230.5,-190.8,192.4>, <0.198,0.98,0>,
		<-116.6,-215.95,211.3>, <0.127,0.992,0>
  }
  smooth_triangle { // #6158
		<-230.5,-215.95,192.4>, <0.232,0.973,0>,
		<-344.8,-190.8,161>, <0.297,0.955,0>,
		<-230.5,-190.8,192.4>, <0.198,0.98,0>
  }
  smooth_triangle { // #6159
		<-344.8,-215.95,161>, <0.328,0.945,0>,
		<-344.8,-190.8,161>, <0.297,0.955,0>,
		<-230.5,-215.95,192.4>, <0.232,0.973,0>
  }
  smooth_triangle { // #6160
		<-344.8,-215.95,161>, <0.328,0.945,0>,
		<-459.35,-190.8,117>, <0.359,0.934,0>,
		<-344.8,-190.8,161>, <0.297,0.955,0>
  }
  triangle { // #6161
		<63.8,-213.45,99.25>,
		<44.2,-213.45,113.85>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6162
		<450.95,-213.45,20.15>,
		<90.7,-213.45,20.15>,
		<442.15,-213.45,144.65>
  }
  triangle { // #6163
		<442.15,-213.45,144.65>,
		<90.7,-213.45,20.15>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6164
		<90.7,-213.45,20.15>,
		<90.1,-213.45,35.25>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6165
		<90.1,-213.45,35.25>,
		<86.75,-213.45,60>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6166
		<86.75,-213.45,60>,
		<78,-213.45,81.3>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6167
		<78,-213.45,81.3>,
		<63.8,-213.45,99.25>,
		<198.2,-213.45,225.1>
  }
  triangle { // #6168
		<-451.8,-213.45,16.4>,
		<-452.25,-213.45,152.2>,
		<-91.9,-213.45,24.25>
  }
  triangle { // #6169
		<-452.25,-213.45,152.2>,
		<-194.05,-213.45,221.35>,
		<-91.9,-213.45,24.25>
  }
  triangle { // #6170
		<-91.9,-213.45,24.25>,
		<-194.05,-213.45,221.35>,
		<-90.95,-213.45,35.25>
  }
  triangle { // #6171
		<-90.95,-213.45,35.25>,
		<-194.05,-213.45,221.35>,
		<-88.15,-213.45,57.9>
  }
  triangle { // #6172
		<-88.15,-213.45,57.9>,
		<-194.05,-213.45,221.35>,
		<-80.45,-213.45,78.05>
  }
  triangle { // #6173
		<-80.45,-213.45,78.05>,
		<-194.05,-213.45,221.35>,
		<-67.75,-213.45,95.75>
  }
  triangle { // #6174
		<-67.75,-213.45,95.75>,
		<-194.05,-213.45,221.35>,
		<-50.1,-213.45,110.95>
  }
  triangle { // #6175
		<-194.05,-213.45,221.35>,
		<198.2,-213.45,225.1>,
		<-50.1,-213.45,110.95>
  }
  triangle { // #6176
		<-50.1,-213.45,110.95>,
		<198.2,-213.45,225.1>,
		<-25.6,-213.45,121.9>
  }
  triangle { // #6177
		<-25.6,-213.45,121.9>,
		<198.2,-213.45,225.1>,
		<-1.7,-213.45,126>
  }
  triangle { // #6178
		<-1.7,-213.45,126>,
		<198.2,-213.45,225.1>,
		<21.55,-213.45,123.35>
  }
  triangle { // #6179
		<21.55,-213.45,123.35>,
		<198.2,-213.45,225.1>,
		<44.2,-213.45,113.85>
  }
  triangle { // #6180
		<63.8,-238.55,99.25>,
		<198.2,-238.55,225.1>,
		<44.2,-238.55,113.85>
  }
  triangle { // #6181
		<450.95,-238.55,20.15>,
		<442.15,-238.55,144.65>,
		<90.7,-238.55,20.15>
  }
  triangle { // #6182
		<442.15,-238.55,144.65>,
		<198.2,-238.55,225.1>,
		<90.7,-238.55,20.15>
  }
  triangle { // #6183
		<90.7,-238.55,20.15>,
		<198.2,-238.55,225.1>,
		<90.1,-238.55,35.25>
  }
  triangle { // #6184
		<90.1,-238.55,35.25>,
		<198.2,-238.55,225.1>,
		<86.75,-238.55,60>
  }
  triangle { // #6185
		<86.75,-238.55,60>,
		<198.2,-238.55,225.1>,
		<78,-238.55,81.3>
  }
  triangle { // #6186
		<78,-238.55,81.3>,
		<198.2,-238.55,225.1>,
		<63.8,-238.55,99.25>
  }
  triangle { // #6187
		<-451.8,-238.55,16.4>,
		<-91.9,-238.55,24.25>,
		<-452.25,-238.55,152.2>
  }
  triangle { // #6188
		<-452.25,-238.55,152.2>,
		<-91.9,-238.55,24.25>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6189
		<-91.9,-238.55,24.25>,
		<-90.95,-238.55,35.25>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6190
		<-90.95,-238.55,35.25>,
		<-88.15,-238.55,57.9>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6191
		<-88.15,-238.55,57.9>,
		<-80.45,-238.55,78.05>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6192
		<-80.45,-238.55,78.05>,
		<-67.75,-238.55,95.75>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6193
		<-67.75,-238.55,95.75>,
		<-50.1,-238.55,110.95>,
		<-194.05,-238.55,221.35>
  }
  triangle { // #6194
		<-194.05,-238.55,221.35>,
		<-50.1,-238.55,110.95>,
		<198.2,-238.55,225.1>
  }
  triangle { // #6195
		<-50.1,-238.55,110.95>,
		<-25.6,-238.55,121.9>,
		<198.2,-238.55,225.1>
  }
  triangle { // #6196
		<-25.6,-238.55,121.9>,
		<-1.7,-238.55,126>,
		<198.2,-238.55,225.1>
  }
  triangle { // #6197
		<-1.7,-238.55,126>,
		<21.55,-238.55,123.35>,
		<198.2,-238.55,225.1>
  }
  triangle { // #6198
		<21.55,-238.55,123.35>,
		<44.2,-238.55,113.85>,
		<198.2,-238.55,225.1>
  }
  triangle { // #6199
		<-91.9,-213.45,24.25>,
		<-91.9,-238.55,24.25>,
		<-451.8,-213.45,16.4>
  }
  triangle { // #6200
		<-451.8,-238.55,16.4>,
		<-451.8,-213.45,16.4>,
		<-91.9,-238.55,24.25>
  }
  smooth_triangle { // #6201
		<-90.95,-213.45,35.25>, <0.995,0.104,0>,
		<-90.95,-238.55,35.25>, <0.995,0.104,0>,
		<-91.9,-213.45,24.25>, <0.996,0.085,0>
  }
  smooth_triangle { // #6202
		<-91.9,-238.55,24.25>, <0.996,0.085,0>,
		<-91.9,-213.45,24.25>, <0.996,0.085,0>,
		<-90.95,-238.55,35.25>, <0.995,0.104,0>
  }
  smooth_triangle { // #6203
		<-90.95,-213.45,35.25>, <0.995,0.104,0>,
		<-88.15,-213.45,57.9>, <0.979,0.202,0>,
		<-90.95,-238.55,35.25>, <0.995,0.104,0>
  }
  smooth_triangle { // #6204
		<-50.1,-213.45,110.95>, <0.536,0.844,0>,
		<-50.1,-238.55,110.95>, <0.536,0.844,0>,
		<-67.75,-213.45,95.75>, <0.738,0.675,0>
  }
  smooth_triangle { // #6205
		<-50.1,-238.55,110.95>, <0.536,0.844,0>,
		<-67.75,-238.55,95.75>, <0.738,0.675,0>,
		<-67.75,-213.45,95.75>, <0.738,0.675,0>
  }
  smooth_triangle { // #6206
		<-67.75,-238.55,95.75>, <0.738,0.675,0>,
		<-80.45,-238.55,78.05>, <0.859,0.512,0>,
		<-67.75,-213.45,95.75>, <0.738,0.675,0>
  }
  smooth_triangle { // #6207
		<-67.75,-213.45,95.75>, <0.738,0.675,0>,
		<-80.45,-238.55,78.05>, <0.859,0.512,0>,
		<-80.45,-213.45,78.05>, <0.9,0.436,0>
  }
  smooth_triangle { // #6208
		<-80.45,-238.55,78.05>, <0.859,0.512,0>,
		<-88.15,-238.55,57.9>, <0.96,0.282,0>,
		<-80.45,-213.45,78.05>, <0.9,0.436,0>
  }
  smooth_triangle { // #6209
		<-80.45,-213.45,78.05>, <0.9,0.436,0>,
		<-88.15,-238.55,57.9>, <0.96,0.282,0>,
		<-88.15,-213.45,57.9>, <0.979,0.202,0>
  }
  smooth_triangle { // #6210
		<-88.15,-238.55,57.9>, <0.96,0.282,0>,
		<-90.95,-238.55,35.25>, <0.995,0.104,0>,
		<-88.15,-213.45,57.9>, <0.979,0.202,0>
  }
  smooth_triangle { // #6211
		<-50.1,-213.45,110.95>, <0.536,0.844,0>,
		<-25.6,-213.45,121.9>, <0.33,0.944,0>,
		<-50.1,-238.55,110.95>, <0.536,0.844,0>
  }
  smooth_triangle { // #6212
		<90.1,-213.45,35.25>, <-0.997,0.072,0>,
		<90.1,-238.55,35.25>, <-0.995,0.103,0>,
		<86.75,-213.45,60>, <-0.966,0.259,0>
  }
  smooth_triangle { // #6213
		<90.1,-238.55,35.25>, <-0.995,0.103,0>,
		<86.75,-238.55,60>, <-0.966,0.259,0>,
		<86.75,-213.45,60>, <-0.966,0.259,0>
  }
  smooth_triangle { // #6214
		<86.75,-238.55,60>, <-0.966,0.259,0>,
		<78,-238.55,81.3>, <-0.886,0.464,0>,
		<86.75,-213.45,60>, <-0.966,0.259,0>
  }
  smooth_triangle { // #6215
		<86.75,-213.45,60>, <-0.966,0.259,0>,
		<78,-238.55,81.3>, <-0.886,0.464,0>,
		<78,-213.45,81.3>, <-0.839,0.545,0>
  }
  smooth_triangle { // #6216
		<78,-238.55,81.3>, <-0.886,0.464,0>,
		<63.8,-238.55,99.25>, <-0.728,0.686,0>,
		<78,-213.45,81.3>, <-0.839,0.545,0>
  }
  smooth_triangle { // #6217
		<78,-213.45,81.3>, <-0.839,0.545,0>,
		<63.8,-238.55,99.25>, <-0.728,0.686,0>,
		<63.8,-213.45,99.25>, <-0.664,0.747,0>
  }
  smooth_triangle { // #6218
		<63.8,-238.55,99.25>, <-0.728,0.686,0>,
		<44.2,-238.55,113.85>, <-0.53,0.848,0>,
		<63.8,-213.45,99.25>, <-0.664,0.747,0>
  }
  smooth_triangle { // #6219
		<63.8,-213.45,99.25>, <-0.664,0.747,0>,
		<44.2,-238.55,113.85>, <-0.53,0.848,0>,
		<44.2,-213.45,113.85>, <-0.46,0.888,0>
  }
  smooth_triangle { // #6220
		<44.2,-238.55,113.85>, <-0.53,0.848,0>,
		<21.55,-238.55,123.35>, <-0.298,0.954,0>,
		<44.2,-213.45,113.85>, <-0.46,0.888,0>
  }
  smooth_triangle { // #6221
		<44.2,-213.45,113.85>, <-0.46,0.888,0>,
		<21.55,-238.55,123.35>, <-0.298,0.954,0>,
		<21.55,-213.45,123.35>, <-0.207,0.978,0>
  }
  smooth_triangle { // #6222
		<21.55,-238.55,123.35>, <-0.298,0.954,0>,
		<-1.7,-238.55,126>, <-0.02,1,0>,
		<21.55,-213.45,123.35>, <-0.207,0.978,0>
  }
  smooth_triangle { // #6223
		<21.55,-213.45,123.35>, <-0.207,0.978,0>,
		<-1.7,-238.55,126>, <-0.02,1,0>,
		<-1.7,-213.45,126>, <0.076,0.997,0>
  }
  smooth_triangle { // #6224
		<-1.7,-238.55,126>, <-0.02,1,0>,
		<-25.6,-238.55,121.9>, <0.251,0.968,0>,
		<-1.7,-213.45,126>, <0.076,0.997,0>
  }
  smooth_triangle { // #6225
		<-1.7,-213.45,126>, <0.076,0.997,0>,
		<-25.6,-238.55,121.9>, <0.251,0.968,0>,
		<-25.6,-213.45,121.9>, <0.33,0.944,0>
  }
  smooth_triangle { // #6226
		<-25.6,-238.55,121.9>, <0.251,0.968,0>,
		<-50.1,-238.55,110.95>, <0.536,0.844,0>,
		<-25.6,-213.45,121.9>, <0.33,0.944,0>
  }
  smooth_triangle { // #6227
		<90.7,-213.45,20.15>, <-0.999,0.042,0>,
		<90.7,-238.55,20.15>, <-0.999,0.042,0>,
		<90.1,-213.45,35.25>, <-0.997,0.072,0>
  }
  smooth_triangle { // #6228
		<90.1,-238.55,35.25>, <-0.995,0.103,0>,
		<90.1,-213.45,35.25>, <-0.997,0.072,0>,
		<90.7,-238.55,20.15>, <-0.999,0.042,0>
  }
  triangle { // #6229
		<450.95,-213.45,20.15>,
		<450.95,-238.55,20.15>,
		<90.7,-213.45,20.15>
  }
  triangle { // #6230
		<90.7,-238.55,20.15>,
		<90.7,-213.45,20.15>,
		<450.95,-238.55,20.15>
  }
  triangle { // #6231
		<442.15,-213.45,144.65>,
		<442.15,-238.55,144.65>,
		<450.95,-213.45,20.15>
  }
  triangle { // #6232
		<450.95,-238.55,20.15>,
		<450.95,-213.45,20.15>,
		<442.15,-238.55,144.65>
  }
  smooth_triangle { // #6233
		<198.2,-213.45,225.1>, <0.099,-0.995,0>,
		<198.2,-238.55,225.1>, <0.208,-0.978,0>,
		<442.15,-213.45,144.65>, <0.313,-0.95,0>
  }
  smooth_triangle { // #6234
		<442.15,-238.55,144.65>, <0.313,-0.95,0>,
		<442.15,-213.45,144.65>, <0.313,-0.95,0>,
		<198.2,-238.55,225.1>, <0.208,-0.978,0>
  }
  smooth_triangle { // #6235
		<-194.05,-213.45,221.35>, <-0.177,-0.984,0>,
		<-194.05,-238.55,221.35>, <-0.093,-0.996,0>,
		<198.2,-213.45,225.1>, <0.099,-0.995,0>
  }
  smooth_triangle { // #6236
		<198.2,-238.55,225.1>, <0.208,-0.978,0>,
		<198.2,-213.45,225.1>, <0.099,-0.995,0>,
		<-194.05,-238.55,221.35>, <-0.093,-0.996,0>
  }
  smooth_triangle { // #6237
		<-452.25,-213.45,152.2>, <-0.259,-0.966,0>,
		<-452.25,-238.55,152.2>, <-0.259,-0.966,0>,
		<-194.05,-213.45,221.35>, <-0.177,-0.984,0>
  }
  smooth_triangle { // #6238
		<-194.05,-238.55,221.35>, <-0.093,-0.996,0>,
		<-194.05,-213.45,221.35>, <-0.177,-0.984,0>,
		<-452.25,-238.55,152.2>, <-0.259,-0.966,0>
  }
  triangle { // #6239
		<-451.8,-213.45,16.4>,
		<-451.8,-238.55,16.4>,
		<-452.25,-213.45,152.2>
  }
  triangle { // #6240
		<-452.25,-238.55,152.2>,
		<-452.25,-213.45,152.2>,
		<-451.8,-238.55,16.4>
  }
  triangle { // #6241
		<91.25,-236.05,141.25>,
		<91.25,-236.05,35.25>,
		<-92.35,-236.05,141.25>
  }
  triangle { // #6242
		<-92.35,-236.05,35.25>,
		<-92.35,-236.05,141.25>,
		<91.25,-236.05,35.25>
  }
  triangle { // #6243
		<-92.35,-261.2,35.25>,
		<91.25,-261.2,35.25>,
		<-92.35,-261.2,141.25>
  }
  triangle { // #6244
		<91.25,-261.2,141.25>,
		<-92.35,-261.2,141.25>,
		<91.25,-261.2,35.25>
  }
  triangle { // #6245
		<-92.35,-236.05,35.25>,
		<-92.35,-261.2,35.25>,
		<-92.35,-236.05,141.25>
  }
  triangle { // #6246
		<-92.35,-261.2,141.25>,
		<-92.35,-236.05,141.25>,
		<-92.35,-261.2,35.25>
  }
  triangle { // #6247
		<91.25,-236.05,35.25>,
		<91.25,-261.2,35.25>,
		<-92.35,-236.05,35.25>
  }
  triangle { // #6248
		<-92.35,-261.2,35.25>,
		<-92.35,-236.05,35.25>,
		<91.25,-261.2,35.25>
  }
  triangle { // #6249
		<91.25,-236.05,141.25>,
		<91.25,-261.2,141.25>,
		<91.25,-236.05,35.25>
  }
  triangle { // #6250
		<91.25,-261.2,35.25>,
		<91.25,-236.05,35.25>,
		<91.25,-261.2,141.25>
  }
  triangle { // #6251
		<-92.35,-236.05,141.25>,
		<-92.35,-261.2,141.25>,
		<91.25,-236.05,141.25>
  }
  triangle { // #6252
		<91.25,-261.2,141.25>,
		<91.25,-236.05,141.25>,
		<-92.35,-261.2,141.25>
  }
  triangle { // #6253
		<-90.95,-25.15,35.25>,
		<-90.95,-25.15,5.1>,
		<-424.15,-25.15,35.25>
  }
  triangle { // #6254
		<-446.8,-25.15,222.6>,
		<-424.15,-25.15,35.25>,
		<-446.8,-25.15,5.1>
  }
  triangle { // #6255
		<-446.8,-25.15,5.1>,
		<-424.15,-25.15,35.25>,
		<-90.95,-25.15,5.1>
  }
  triangle { // #6256
		<-90.95,-283.85,35.25>,
		<-424.15,-283.85,35.25>,
		<-90.95,-283.85,5.1>
  }
  triangle { // #6257
		<-446.8,-283.85,222.6>,
		<-446.8,-283.85,5.1>,
		<-424.15,-283.85,35.25>
  }
  triangle { // #6258
		<-446.8,-283.85,5.1>,
		<-90.95,-283.85,5.1>,
		<-424.15,-283.85,35.25>
  }
  triangle { // #6259
		<-90.95,-25.15,35.25>,
		<-90.95,-283.85,35.25>,
		<-90.95,-25.15,5.1>
  }
  triangle { // #6260
		<-90.95,-283.85,5.1>,
		<-90.95,-25.15,5.1>,
		<-90.95,-283.85,35.25>
  }
  triangle { // #6261
		<-424.15,-25.15,35.25>,
		<-424.15,-283.85,35.25>,
		<-90.95,-25.15,35.25>
  }
  triangle { // #6262
		<-90.95,-283.85,35.25>,
		<-90.95,-25.15,35.25>,
		<-424.15,-283.85,35.25>
  }
  triangle { // #6263
		<-446.8,-25.15,222.6>,
		<-446.8,-283.85,222.6>,
		<-424.15,-25.15,35.25>
  }
  triangle { // #6264
		<-424.15,-283.85,35.25>,
		<-424.15,-25.15,35.25>,
		<-446.8,-283.85,222.6>
  }
  triangle { // #6265
		<-446.8,-25.15,5.1>,
		<-446.8,-283.85,5.1>,
		<-446.8,-25.15,222.6>
  }
  triangle { // #6266
		<-446.8,-283.85,222.6>,
		<-446.8,-25.15,222.6>,
		<-446.8,-283.85,5.1>
  }
  triangle { // #6267
		<-90.95,-25.15,5.1>,
		<-90.95,-283.85,5.1>,
		<-446.8,-25.15,5.1>
  }
  triangle { // #6268
		<-446.8,-283.85,5.1>,
		<-446.8,-25.15,5.1>,
		<-90.95,-283.85,5.1>
  }
  triangle { // #6269
		<423.25,-25.15,35.25>,
		<90.1,-25.15,5.1>,
		<90.1,-25.15,35.25>
  }
  triangle { // #6270
		<439.7,-25.15,5.1>,
		<423.25,-25.15,35.25>,
		<439.7,-25.15,209.4>
  }
  triangle { // #6271
		<90.1,-25.15,5.1>,
		<423.25,-25.15,35.25>,
		<439.7,-25.15,5.1>
  }
  triangle { // #6272
		<90.1,-283.85,5.1>,
		<423.25,-283.85,35.25>,
		<90.1,-283.85,35.25>
  }
  triangle { // #6273
		<423.25,-283.85,35.25>,
		<439.7,-283.85,5.1>,
		<439.7,-283.85,209.4>
  }
  triangle { // #6274
		<423.25,-283.85,35.25>,
		<90.1,-283.85,5.1>,
		<439.7,-283.85,5.1>
  }
  triangle { // #6275
		<90.1,-25.15,5.1>,
		<90.1,-283.85,35.25>,
		<90.1,-25.15,35.25>
  }
  triangle { // #6276
		<90.1,-283.85,35.25>,
		<90.1,-25.15,5.1>,
		<90.1,-283.85,5.1>
  }
  triangle { // #6277
		<90.1,-25.15,35.25>,
		<423.25,-283.85,35.25>,
		<423.25,-25.15,35.25>
  }
  triangle { // #6278
		<423.25,-283.85,35.25>,
		<90.1,-25.15,35.25>,
		<90.1,-283.85,35.25>
  }
  triangle { // #6279
		<423.25,-25.15,35.25>,
		<439.7,-283.85,209.4>,
		<439.7,-25.15,209.4>
  }
  triangle { // #6280
		<439.7,-283.85,209.4>,
		<423.25,-25.15,35.25>,
		<423.25,-283.85,35.25>
  }
  triangle { // #6281
		<439.7,-25.15,209.4>,
		<439.7,-283.85,5.1>,
		<439.7,-25.15,5.1>
  }
  triangle { // #6282
		<439.7,-283.85,5.1>,
		<439.7,-25.15,209.4>,
		<439.7,-283.85,209.4>
  }
  triangle { // #6283
		<439.7,-25.15,5.1>,
		<90.1,-283.85,5.1>,
		<90.1,-25.15,5.1>
  }
  triangle { // #6284
		<90.1,-283.85,5.1>,
		<439.7,-25.15,5.1>,
		<439.7,-283.85,5.1>
  }
  triangle { // #6285
		<-250,-258.7,46.9>,
		<173.05,-258.7,46.9>,
		<-250,-258.7,-181>
  }
  triangle { // #6286
		<173.05,-258.7,-181>,
		<-250,-258.7,-181>,
		<173.05,-258.7,46.9>
  }
  triangle { // #6287
		<-250,-283.85,-181>,
		<173.05,-283.85,-181>,
		<-250,-283.85,46.9>
  }
  triangle { // #6288
		<173.05,-283.85,46.9>,
		<-250,-283.85,46.9>,
		<173.05,-283.85,-181>
  }
  triangle { // #6289
		<-250,-258.7,-181>,
		<-250,-283.85,-181>,
		<-250,-258.7,46.9>
  }
  triangle { // #6290
		<-250,-283.85,46.9>,
		<-250,-258.7,46.9>,
		<-250,-283.85,-181>
  }
  triangle { // #6291
		<173.05,-258.7,-181>,
		<173.05,-283.85,-181>,
		<-250,-258.7,-181>
  }
  triangle { // #6292
		<-250,-283.85,-181>,
		<-250,-258.7,-181>,
		<173.05,-283.85,-181>
  }
  triangle { // #6293
		<173.05,-258.7,46.9>,
		<173.05,-283.85,46.9>,
		<173.05,-258.7,-181>
  }
  triangle { // #6294
		<173.05,-283.85,-181>,
		<173.05,-258.7,-181>,
		<173.05,-283.85,46.9>
  }
  triangle { // #6295
		<-250,-258.7,46.9>,
		<-250,-283.85,46.9>,
		<173.05,-258.7,46.9>
  }
  triangle { // #6296
		<173.05,-283.85,46.9>,
		<173.05,-258.7,46.9>,
		<-250,-283.85,46.9>
  }
  triangle { // #6297
		<56.15,-25.15,35.25>,
		<56.15,-25.15,5.1>,
		<-57,-25.15,35.25>
  }
  triangle { // #6298
		<-57,-25.15,5.1>,
		<-57,-25.15,35.25>,
		<56.15,-25.15,5.1>
  }
  triangle { // #6299
		<-57,-51.25,5.1>,
		<56.15,-51.25,5.1>,
		<-57,-51.25,35.25>
  }
  triangle { // #6300
		<56.15,-51.25,35.25>,
		<-57,-51.25,35.25>,
		<56.15,-51.25,5.1>
  }
  triangle { // #6301
		<-57,-25.15,5.1>,
		<-57,-51.25,5.1>,
		<-57,-25.15,35.25>
  }
  triangle { // #6302
		<-57,-51.25,35.25>,
		<-57,-25.15,35.25>,
		<-57,-51.25,5.1>
  }
  triangle { // #6303
		<56.15,-25.15,5.1>,
		<56.15,-51.25,5.1>,
		<-57,-25.15,5.1>
  }
  triangle { // #6304
		<-57,-51.25,5.1>,
		<-57,-25.15,5.1>,
		<56.15,-51.25,5.1>
  }
  triangle { // #6305
		<56.15,-25.15,35.25>,
		<56.15,-51.25,35.25>,
		<56.15,-25.15,5.1>
  }
  triangle { // #6306
		<56.15,-51.25,5.1>,
		<56.15,-25.15,5.1>,
		<56.15,-51.25,35.25>
  }
  triangle { // #6307
		<-57,-25.15,35.25>,
		<-57,-51.25,35.25>,
		<56.15,-25.15,35.25>
  }
  triangle { // #6308
		<56.15,-51.25,35.25>,
		<56.15,-25.15,35.25>,
		<-57,-51.25,35.25>
  }
  triangle { // #6309
		<-90.95,-25.15,35.25>,
		<-57,-25.15,35.25>,
		<-90.95,-25.15,5.1>
  }
  triangle { // #6310
		<-57,-25.15,5.1>,
		<-90.95,-25.15,5.1>,
		<-57,-25.15,35.25>
  }
  triangle { // #6311
		<-90.95,-283.85,5.1>,
		<-57,-283.85,5.1>,
		<-90.95,-283.85,35.25>
  }
  triangle { // #6312
		<-57,-283.85,35.25>,
		<-90.95,-283.85,35.25>,
		<-57,-283.85,5.1>
  }
  triangle { // #6313
		<-90.95,-25.15,5.1>,
		<-90.95,-283.85,5.1>,
		<-90.95,-25.15,35.25>
  }
  triangle { // #6314
		<-90.95,-283.85,35.25>,
		<-90.95,-25.15,35.25>,
		<-90.95,-283.85,5.1>
  }
  triangle { // #6315
		<-57,-25.15,5.1>,
		<-57,-283.85,5.1>,
		<-90.95,-25.15,5.1>
  }
  triangle { // #6316
		<-90.95,-283.85,5.1>,
		<-90.95,-25.15,5.1>,
		<-57,-283.85,5.1>
  }
  triangle { // #6317
		<-57,-25.15,35.25>,
		<-57,-283.85,35.25>,
		<-57,-25.15,5.1>
  }
  triangle { // #6318
		<-57,-283.85,5.1>,
		<-57,-25.15,5.1>,
		<-57,-283.85,35.25>
  }
  triangle { // #6319
		<-90.95,-25.15,35.25>,
		<-90.95,-283.85,35.25>,
		<-57,-25.15,35.25>
  }
  triangle { // #6320
		<-57,-283.85,35.25>,
		<-57,-25.15,35.25>,
		<-90.95,-283.85,35.25>
  }
  triangle { // #6321
		<56.15,-25.15,35.25>,
		<90.1,-25.15,35.25>,
		<56.15,-25.15,5.1>
  }
  triangle { // #6322
		<90.1,-25.15,5.1>,
		<56.15,-25.15,5.1>,
		<90.1,-25.15,35.25>
  }
  triangle { // #6323
		<56.15,-283.85,5.1>,
		<90.1,-283.85,5.1>,
		<56.15,-283.85,35.25>
  }
  triangle { // #6324
		<90.1,-283.85,35.25>,
		<56.15,-283.85,35.25>,
		<90.1,-283.85,5.1>
  }
  triangle { // #6325
		<56.15,-25.15,5.1>,
		<56.15,-283.85,5.1>,
		<56.15,-25.15,35.25>
  }
  triangle { // #6326
		<56.15,-283.85,35.25>,
		<56.15,-25.15,35.25>,
		<56.15,-283.85,5.1>
  }
  triangle { // #6327
		<90.1,-25.15,5.1>,
		<90.1,-283.85,5.1>,
		<56.15,-25.15,5.1>
  }
  triangle { // #6328
		<56.15,-283.85,5.1>,
		<56.15,-25.15,5.1>,
		<90.1,-283.85,5.1>
  }
  triangle { // #6329
		<90.1,-25.15,35.25>,
		<90.1,-283.85,35.25>,
		<90.1,-25.15,5.1>
  }
  triangle { // #6330
		<90.1,-283.85,5.1>,
		<90.1,-25.15,5.1>,
		<90.1,-283.85,35.25>
  }
  triangle { // #6331
		<56.15,-25.15,35.25>,
		<56.15,-283.85,35.25>,
		<90.1,-25.15,35.25>
  }
  triangle { // #6332
		<90.1,-283.85,35.25>,
		<90.1,-25.15,35.25>,
		<56.15,-283.85,35.25>
  }
  triangle { // #6333
		<842.6,-99,1740.15>,
		<884.05,-99,1963.35>,
		<842.6,-99,1963.35>
  }
  triangle { // #6334
		<884.05,-99,1963.35>,
		<842.6,-99,1740.15>,
		<884.05,-99,1740.15>
  }
  triangle { // #6335
		<842.6,806.25,1963.35>,
		<884.05,806.25,1740.15>,
		<842.6,806.25,1740.15>
  }
  triangle { // #6336
		<884.05,806.25,1740.15>,
		<842.6,806.25,1963.35>,
		<884.05,806.25,1963.35>
  }
  triangle { // #6337
		<842.6,-99,1963.35>,
		<842.6,806.25,1740.15>,
		<842.6,-99,1740.15>
  }
  triangle { // #6338
		<842.6,806.25,1740.15>,
		<842.6,-99,1963.35>,
		<842.6,806.25,1963.35>
  }
  triangle { // #6339
		<842.6,-99,1740.15>,
		<884.05,806.25,1740.15>,
		<884.05,-99,1740.15>
  }
  triangle { // #6340
		<884.05,806.25,1740.15>,
		<842.6,-99,1740.15>,
		<842.6,806.25,1740.15>
  }
  triangle { // #6341
		<884.05,-99,1740.15>,
		<884.05,806.25,1963.35>,
		<884.05,-99,1963.35>
  }
  triangle { // #6342
		<884.05,806.25,1963.35>,
		<884.05,-99,1740.15>,
		<884.05,806.25,1740.15>
  }
  triangle { // #6343
		<884.05,-99,1963.35>,
		<842.6,806.25,1963.35>,
		<842.6,-99,1963.35>
  }
  triangle { // #6344
		<842.6,806.25,1963.35>,
		<884.05,-99,1963.35>,
		<884.05,806.25,1963.35>
  }
  triangle { // #6345
		<-880.65,-99,1716.5>,
		<-840.35,-99,1962.7>,
		<-880.65,-99,1962.7>
  }
  triangle { // #6346
		<-840.35,-99,1962.7>,
		<-880.65,-99,1716.5>,
		<-840.35,-99,1716.5>
  }
  triangle { // #6347
		<-880.65,806.25,1962.7>,
		<-840.35,806.25,1716.5>,
		<-880.65,806.25,1716.5>
  }
  triangle { // #6348
		<-840.35,806.25,1716.5>,
		<-880.65,806.25,1962.7>,
		<-840.35,806.25,1962.7>
  }
  triangle { // #6349
		<-880.65,-99,1962.7>,
		<-880.65,806.25,1716.5>,
		<-880.65,-99,1716.5>
  }
  triangle { // #6350
		<-880.65,806.25,1716.5>,
		<-880.65,-99,1962.7>,
		<-880.65,806.25,1962.7>
  }
  triangle { // #6351
		<-880.65,-99,1716.5>,
		<-840.35,806.25,1716.5>,
		<-840.35,-99,1716.5>
  }
  triangle { // #6352
		<-840.35,806.25,1716.5>,
		<-880.65,-99,1716.5>,
		<-880.65,806.25,1716.5>
  }
  triangle { // #6353
		<-840.35,-99,1716.5>,
		<-840.35,806.25,1962.7>,
		<-840.35,-99,1962.7>
  }
  triangle { // #6354
		<-840.35,806.25,1962.7>,
		<-840.35,-99,1716.5>,
		<-840.35,806.25,1716.5>
  }
  triangle { // #6355
		<-840.35,-99,1962.7>,
		<-880.65,806.25,1962.7>,
		<-880.65,-99,1962.7>
  }
  triangle { // #6356
		<-880.65,806.25,1962.7>,
		<-840.35,-99,1962.7>,
		<-840.35,806.25,1962.7>
  }
  triangle { // #6357
		<210.4,755.5,907.3>,
		<2.2,663.15,472.85>,
		<174.85,660.4,460>
  }
  triangle { // #6358
		<843.6,706.85,678.5>,
		<519.95,638.5,357.05>,
		<692.45,619.35,267>
  }
  triangle { // #6359
		<632.55,729.4,784.7>,
		<519.95,638.5,357.05>,
		<843.6,706.85,678.5>
  }
  triangle { // #6360
		<-515.85,638.5,357.05>,
		<-845.6,709.25,689.75>,
		<-688.65,619.35,267>
  }
  triangle { // #6361
		<-515.85,638.5,357.05>,
		<-634.3,731.2,793.15>,
		<-845.6,709.25,689.75>
  }
  triangle { // #6362
		<632.55,729.4,784.7>,
		<347.4,652.2,421.4>,
		<519.95,638.5,357.05>
  }
  triangle { // #6363
		<421.5,745.65,861>,
		<347.4,652.2,421.4>,
		<632.55,729.4,784.7>
  }
  triangle { // #6364
		<-343.15,652.2,421.4>,
		<-634.3,731.2,793.15>,
		<-515.85,638.5,357.05>
  }
  triangle { // #6365
		<-343.15,652.2,421.4>,
		<-423.1,746.85,866.65>,
		<-634.3,731.2,793.15>
  }
  triangle { // #6366
		<421.5,745.65,861>,
		<174.85,660.4,460>,
		<347.4,652.2,421.4>
  }
  triangle { // #6367
		<210.4,755.5,907.3>,
		<174.85,660.4,460>,
		<421.5,745.65,861>
  }
  triangle { // #6368
		<-170.45,660.4,460>,
		<-423.1,746.85,866.65>,
		<-343.15,652.2,421.4>
  }
  triangle { // #6369
		<-170.45,660.4,460>,
		<-211.9,756.1,910.15>,
		<-423.1,746.85,866.65>
  }
  triangle { // #6370
		<-170.45,660.4,460>,
		<-0.7,758.95,923.7>,
		<-211.9,756.1,910.15>
  }
  triangle { // #6371
		<2.2,663.15,472.85>,
		<-0.7,758.95,923.7>,
		<-170.45,660.4,460>
  }
  triangle { // #6372
		<2.2,663.15,472.85>,
		<210.4,755.5,907.3>,
		<-0.7,758.95,923.7>
  }
  triangle { // #6373
		<2.2,677.9,469.7>,
		<210.4,770.25,904.2>,
		<174.85,675.15,456.85>
  }
  triangle { // #6374
		<519.95,653.25,353.9>,
		<843.6,721.6,675.35>,
		<692.45,634.15,263.85>
  }
  triangle { // #6375
		<519.95,653.25,353.9>,
		<632.55,744.2,781.6>,
		<843.6,721.6,675.35>
  }
  triangle { // #6376
		<-845.6,724,686.65>,
		<-515.85,653.25,353.9>,
		<-688.65,634.15,263.85>
  }
  triangle { // #6377
		<-634.3,745.95,790.05>,
		<-515.85,653.25,353.9>,
		<-845.6,724,686.65>
  }
  triangle { // #6378
		<347.4,666.95,418.25>,
		<632.55,744.2,781.6>,
		<519.95,653.25,353.9>
  }
  triangle { // #6379
		<347.4,666.95,418.25>,
		<421.5,760.4,857.85>,
		<632.55,744.2,781.6>
  }
  triangle { // #6380
		<-634.3,745.95,790.05>,
		<-343.15,666.95,418.25>,
		<-515.85,653.25,353.9>
  }
  triangle { // #6381
		<-423.1,761.6,863.5>,
		<-343.15,666.95,418.25>,
		<-634.3,745.95,790.05>
  }
  triangle { // #6382
		<174.85,675.15,456.85>,
		<421.5,760.4,857.85>,
		<347.4,666.95,418.25>
  }
  triangle { // #6383
		<174.85,675.15,456.85>,
		<210.4,770.25,904.2>,
		<421.5,760.4,857.85>
  }
  triangle { // #6384
		<-423.1,761.6,863.5>,
		<-170.45,675.15,456.85>,
		<-343.15,666.95,418.25>
  }
  triangle { // #6385
		<-211.9,770.85,907>,
		<-170.45,675.15,456.85>,
		<-423.1,761.6,863.5>
  }
  triangle { // #6386
		<-0.7,773.7,920.55>,
		<-170.45,675.15,456.85>,
		<-211.9,770.85,907>
  }
  triangle { // #6387
		<-0.7,773.7,920.55>,
		<2.2,677.9,469.7>,
		<-170.45,675.15,456.85>
  }
  triangle { // #6388
		<210.4,770.25,904.2>,
		<2.2,677.9,469.7>,
		<-0.7,773.7,920.55>
  }
  triangle { // #6389
		<-845.6,709.25,689.75>,
		<-688.65,634.15,263.85>,
		<-688.65,619.35,267>
  }
  triangle { // #6390
		<-688.65,634.15,263.85>,
		<-845.6,709.25,689.75>,
		<-845.6,724,686.65>
  }
  smooth_triangle { // #6391
		<-688.65,634.15,263.85>, <0.47,0.863,-0.183>,
		<-515.85,638.5,357.05>, <0.433,0.882,-0.187>,
		<-688.65,619.35,267>, <0.47,0.863,-0.183>
  }
  smooth_triangle { // #6392
		<519.95,638.5,357.05>, <-0.414,0.89,-0.189>,
		<692.45,634.15,263.85>, <-0.471,0.863,-0.183>,
		<692.45,619.35,267>, <-0.471,0.863,-0.183>
  }
  smooth_triangle { // #6393
		<519.95,638.5,357.05>, <-0.414,0.89,-0.189>,
		<519.95,653.25,353.9>, <-0.414,0.89,-0.189>,
		<692.45,634.15,263.85>, <-0.471,0.863,-0.183>
  }
  smooth_triangle { // #6394
		<519.95,638.5,357.05>, <-0.414,0.89,-0.189>,
		<347.4,666.95,418.25>, <-0.312,0.929,-0.198>,
		<519.95,653.25,353.9>, <-0.414,0.89,-0.189>
  }
  smooth_triangle { // #6395
		<347.4,652.2,421.4>, <-0.268,0.942,-0.2>,
		<347.4,666.95,418.25>, <-0.312,0.929,-0.198>,
		<519.95,638.5,357.05>, <-0.414,0.89,-0.189>
  }
  smooth_triangle { // #6396
		<347.4,652.2,421.4>, <-0.268,0.942,-0.2>,
		<174.85,675.15,456.85>, <-0.174,0.963,-0.205>,
		<347.4,666.95,418.25>, <-0.312,0.929,-0.198>
  }
  smooth_triangle { // #6397
		<174.85,660.4,460>, <-0.125,0.97,-0.206>,
		<174.85,675.15,456.85>, <-0.174,0.963,-0.205>,
		<347.4,652.2,421.4>, <-0.268,0.942,-0.2>
  }
  smooth_triangle { // #6398
		<174.85,660.4,460>, <-0.125,0.97,-0.206>,
		<2.2,677.9,469.7>, <-0.025,0.978,-0.208>,
		<174.85,675.15,456.85>, <-0.174,0.963,-0.205>
  }
  smooth_triangle { // #6399
		<2.2,663.15,472.85>, <0.025,0.978,-0.208>,
		<2.2,677.9,469.7>, <-0.025,0.978,-0.208>,
		<174.85,660.4,460>, <-0.125,0.97,-0.206>
  }
  smooth_triangle { // #6400
		<2.2,663.15,472.85>, <0.025,0.978,-0.208>,
		<-170.45,675.15,456.85>, <0.125,0.97,-0.206>,
		<2.2,677.9,469.7>, <-0.025,0.978,-0.208>
  }
  smooth_triangle { // #6401
		<-170.45,660.4,460>, <0.174,0.963,-0.205>,
		<-170.45,675.15,456.85>, <0.125,0.97,-0.206>,
		<2.2,663.15,472.85>, <0.025,0.978,-0.208>
  }
  smooth_triangle { // #6402
		<-170.45,660.4,460>, <0.174,0.963,-0.205>,
		<-343.15,666.95,418.25>, <0.268,0.942,-0.2>,
		<-170.45,675.15,456.85>, <0.125,0.97,-0.206>
  }
  smooth_triangle { // #6403
		<-343.15,652.2,421.4>, <0.312,0.929,-0.198>,
		<-343.15,666.95,418.25>, <0.268,0.942,-0.2>,
		<-170.45,660.4,460>, <0.174,0.963,-0.205>
  }
  smooth_triangle { // #6404
		<-343.15,652.2,421.4>, <0.312,0.929,-0.198>,
		<-515.85,653.25,353.9>, <0.395,0.899,-0.191>,
		<-343.15,666.95,418.25>, <0.268,0.942,-0.2>
  }
  smooth_triangle { // #6405
		<-515.85,638.5,357.05>, <0.433,0.882,-0.187>,
		<-515.85,653.25,353.9>, <0.395,0.899,-0.191>,
		<-343.15,652.2,421.4>, <0.312,0.929,-0.198>
  }
  smooth_triangle { // #6406
		<-515.85,638.5,357.05>, <0.433,0.882,-0.187>,
		<-688.65,634.15,263.85>, <0.47,0.863,-0.183>,
		<-515.85,653.25,353.9>, <0.395,0.899,-0.191>
  }
  triangle { // #6407
		<692.45,619.35,267>,
		<843.6,721.6,675.35>,
		<843.6,706.85,678.5>
  }
  triangle { // #6408
		<843.6,721.6,675.35>,
		<692.45,619.35,267>,
		<692.45,634.15,263.85>
  }
  smooth_triangle { // #6409
		<843.6,721.6,675.35>, <0.458,-0.87,0.185>,
		<632.55,729.4,784.7>, <0.421,-0.887,0.189>,
		<843.6,706.85,678.5>, <0.458,-0.87,0.185>
  }
  smooth_triangle { // #6410
		<-634.3,731.2,793.15>, <-0.392,-0.9,0.191>,
		<-845.6,724,686.65>, <-0.447,-0.875,0.186>,
		<-845.6,709.25,689.75>, <-0.447,-0.875,0.186>
  }
  smooth_triangle { // #6411
		<-634.3,731.2,793.15>, <-0.392,-0.9,0.191>,
		<-634.3,745.95,790.05>, <-0.392,-0.9,0.191>,
		<-845.6,724,686.65>, <-0.447,-0.875,0.186>
  }
  smooth_triangle { // #6412
		<-634.3,731.2,793.15>, <-0.392,-0.9,0.191>,
		<-423.1,761.6,863.5>, <-0.293,-0.935,0.199>,
		<-634.3,745.95,790.05>, <-0.392,-0.9,0.191>
  }
  smooth_triangle { // #6413
		<-423.1,746.85,866.65>, <-0.25,-0.947,0.201>,
		<-423.1,761.6,863.5>, <-0.293,-0.935,0.199>,
		<-634.3,731.2,793.15>, <-0.392,-0.9,0.191>
  }
  smooth_triangle { // #6414
		<-423.1,746.85,866.65>, <-0.25,-0.947,0.201>,
		<-211.9,770.85,907>, <-0.16,-0.966,0.205>,
		<-423.1,761.6,863.5>, <-0.293,-0.935,0.199>
  }
  smooth_triangle { // #6415
		<-211.9,756.1,910.15>, <-0.113,-0.972,0.207>,
		<-211.9,770.85,907>, <-0.16,-0.966,0.205>,
		<-423.1,746.85,866.65>, <-0.25,-0.947,0.201>
  }
  smooth_triangle { // #6416
		<-211.9,756.1,910.15>, <-0.113,-0.972,0.207>,
		<-0.7,773.7,920.55>, <-0.017,-0.978,0.208>,
		<-211.9,770.85,907>, <-0.16,-0.966,0.205>
  }
  smooth_triangle { // #6417
		<-0.7,758.95,923.7>, <0.031,-0.978,0.208>,
		<-0.7,773.7,920.55>, <-0.017,-0.978,0.208>,
		<-211.9,756.1,910.15>, <-0.113,-0.972,0.207>
  }
  smooth_triangle { // #6418
		<-0.7,758.95,923.7>, <0.031,-0.978,0.208>,
		<210.4,770.25,904.2>, <0.126,-0.97,0.206>,
		<-0.7,773.7,920.55>, <-0.017,-0.978,0.208>
  }
  smooth_triangle { // #6419
		<210.4,755.5,907.3>, <0.173,-0.963,0.205>,
		<210.4,770.25,904.2>, <0.126,-0.97,0.206>,
		<-0.7,758.95,923.7>, <0.031,-0.978,0.208>
  }
  smooth_triangle { // #6420
		<210.4,755.5,907.3>, <0.173,-0.963,0.205>,
		<421.5,760.4,857.85>, <0.262,-0.944,0.201>,
		<210.4,770.25,904.2>, <0.126,-0.97,0.206>
  }
  smooth_triangle { // #6421
		<421.5,745.65,861>, <0.305,-0.932,0.198>,
		<421.5,760.4,857.85>, <0.262,-0.944,0.201>,
		<210.4,755.5,907.3>, <0.173,-0.963,0.205>
  }
  smooth_triangle { // #6422
		<421.5,745.65,861>, <0.305,-0.932,0.198>,
		<632.55,744.2,781.6>, <0.384,-0.903,0.192>,
		<421.5,760.4,857.85>, <0.262,-0.944,0.201>
  }
  smooth_triangle { // #6423
		<632.55,729.4,784.7>, <0.421,-0.887,0.189>,
		<632.55,744.2,781.6>, <0.384,-0.903,0.192>,
		<421.5,745.65,861>, <0.305,-0.932,0.198>
  }
  smooth_triangle { // #6424
		<632.55,729.4,784.7>, <0.421,-0.887,0.189>,
		<843.6,721.6,675.35>, <0.458,-0.87,0.185>,
		<632.55,744.2,781.6>, <0.384,-0.903,0.192>
  }
  triangle { // #6425
		<862.05,644.8,734.9>,
		<568.05,663,813.65>,
		<757.3,644.8,734.85>
  }
  triangle { // #6426
		<-744.7,644.75,734.7>,
		<-855.4,801.5,1413.55>,
		<-855.65,644.8,734.75>
  }
  triangle { // #6427
		<-558.45,662.95,813.55>,
		<-855.4,801.5,1413.55>,
		<-744.7,644.75,734.7>
  }
  triangle { // #6428
		<-558.45,662.95,813.55>,
		<862.35,801.5,1413.55>,
		<-855.4,801.5,1413.55>
  }
  triangle { // #6429
		<-371.75,676,869.85>,
		<862.35,801.5,1413.55>,
		<-558.45,662.95,813.55>
  }
  triangle { // #6430
		<-184.6,683.8,903.65>,
		<862.35,801.5,1413.55>,
		<-371.75,676,869.85>
  }
  triangle { // #6431
		<2.9,686.4,914.9>,
		<862.35,801.5,1413.55>,
		<-184.6,683.8,903.65>
  }
  triangle { // #6432
		<190.9,683.8,903.7>,
		<862.35,801.5,1413.55>,
		<2.9,686.4,914.9>
  }
  triangle { // #6433
		<379.25,676,869.9>,
		<862.35,801.5,1413.55>,
		<190.9,683.8,903.7>
  }
  triangle { // #6434
		<379.25,676,869.9>,
		<862.05,644.8,734.9>,
		<862.35,801.5,1413.55>
  }
  triangle { // #6435
		<568.05,663,813.65>,
		<862.05,644.8,734.9>,
		<379.25,676,869.9>
  }
  triangle { // #6436
		<568.05,677.7,810.25>,
		<862.05,659.5,731.5>,
		<757.3,659.5,731.45>
  }
  triangle { // #6437
		<-855.4,816.2,1410.2>,
		<-744.7,659.5,731.3>,
		<-855.65,659.5,731.35>
  }
  triangle { // #6438
		<-855.4,816.2,1410.2>,
		<-558.45,677.65,810.15>,
		<-744.7,659.5,731.3>
  }
  triangle { // #6439
		<862.35,816.2,1410.2>,
		<-558.45,677.65,810.15>,
		<-855.4,816.2,1410.2>
  }
  triangle { // #6440
		<862.35,816.2,1410.2>,
		<-371.75,690.7,866.45>,
		<-558.45,677.65,810.15>
  }
  triangle { // #6441
		<862.35,816.2,1410.2>,
		<-184.6,698.5,900.25>,
		<-371.75,690.7,866.45>
  }
  triangle { // #6442
		<862.35,816.2,1410.2>,
		<2.9,701.1,911.5>,
		<-184.6,698.5,900.25>
  }
  triangle { // #6443
		<862.35,816.2,1410.2>,
		<190.9,698.5,900.3>,
		<2.9,701.1,911.5>
  }
  triangle { // #6444
		<862.35,816.2,1410.2>,
		<379.25,690.7,866.55>,
		<190.9,698.5,900.3>
  }
  triangle { // #6445
		<862.05,659.5,731.5>,
		<379.25,690.7,866.55>,
		<862.35,816.2,1410.2>
  }
  triangle { // #6446
		<862.05,659.5,731.5>,
		<568.05,677.7,810.25>,
		<379.25,690.7,866.55>
  }
  smooth_triangle { // #6447
		<-855.65,644.8,734.75>, <-0,0.974,-0.225>,
		<-744.7,659.5,731.3>, <0.203,0.954,-0.22>,
		<-744.7,644.75,734.7>, <0.203,0.954,-0.22>
  }
  smooth_triangle { // #6448
		<-744.7,659.5,731.3>, <0.203,0.954,-0.22>,
		<-855.65,644.8,734.75>, <-0,0.974,-0.225>,
		<-855.65,659.5,731.35>, <-0,0.974,-0.225>
  }
  smooth_triangle { // #6449
		<-744.7,659.5,731.3>, <0.203,0.954,-0.22>,
		<-558.45,662.95,813.55>, <0.365,0.907,-0.209>,
		<-744.7,644.75,734.7>, <0.203,0.954,-0.22>
  }
  smooth_triangle { // #6450
		<568.05,663,813.65>, <-0.343,0.915,-0.211>,
		<757.3,659.5,731.45>, <-0.267,0.939,-0.217>,
		<757.3,644.8,734.85>, <-0.133,0.966,-0.223>
  }
  smooth_triangle { // #6451
		<568.05,663,813.65>, <-0.343,0.915,-0.211>,
		<568.05,677.7,810.25>, <-0.343,0.915,-0.211>,
		<757.3,659.5,731.45>, <-0.267,0.939,-0.217>
  }
  smooth_triangle { // #6452
		<568.05,663,813.65>, <-0.343,0.915,-0.211>,
		<379.25,690.7,866.55>, <-0.256,0.942,-0.217>,
		<568.05,677.7,810.25>, <-0.343,0.915,-0.211>
  }
  smooth_triangle { // #6453
		<379.25,676,869.9>, <-0.218,0.951,-0.22>,
		<379.25,690.7,866.55>, <-0.256,0.942,-0.217>,
		<568.05,663,813.65>, <-0.343,0.915,-0.211>
  }
  smooth_triangle { // #6454
		<379.25,676,869.9>, <-0.218,0.951,-0.22>,
		<190.9,698.5,900.3>, <-0.141,0.965,-0.223>,
		<379.25,690.7,866.55>, <-0.256,0.942,-0.217>
  }
  smooth_triangle { // #6455
		<190.9,683.8,903.7>, <-0.101,0.969,-0.224>,
		<190.9,698.5,900.3>, <-0.141,0.965,-0.223>,
		<379.25,676,869.9>, <-0.218,0.951,-0.22>
  }
  smooth_triangle { // #6456
		<190.9,683.8,903.7>, <-0.101,0.969,-0.224>,
		<2.9,701.1,911.5>, <-0.02,0.974,-0.225>,
		<190.9,698.5,900.3>, <-0.141,0.965,-0.223>
  }
  smooth_triangle { // #6457
		<2.9,686.4,914.9>, <0.021,0.974,-0.225>,
		<2.9,701.1,911.5>, <-0.02,0.974,-0.225>,
		<190.9,683.8,903.7>, <-0.101,0.969,-0.224>
  }
  smooth_triangle { // #6458
		<2.9,686.4,914.9>, <0.021,0.974,-0.225>,
		<-184.6,698.5,900.25>, <0.102,0.969,-0.224>,
		<2.9,701.1,911.5>, <-0.02,0.974,-0.225>
  }
  smooth_triangle { // #6459
		<-184.6,683.8,903.65>, <0.142,0.964,-0.223>,
		<-184.6,698.5,900.25>, <0.102,0.969,-0.224>,
		<2.9,686.4,914.9>, <0.021,0.974,-0.225>
  }
  smooth_triangle { // #6460
		<-184.6,683.8,903.65>, <0.142,0.964,-0.223>,
		<-371.75,690.7,866.45>, <0.22,0.95,-0.219>,
		<-184.6,698.5,900.25>, <0.102,0.969,-0.224>
  }
  smooth_triangle { // #6461
		<-371.75,676,869.85>, <0.258,0.941,-0.217>,
		<-371.75,690.7,866.45>, <0.22,0.95,-0.219>,
		<-184.6,683.8,903.65>, <0.142,0.964,-0.223>
  }
  smooth_triangle { // #6462
		<-371.75,676,869.85>, <0.258,0.941,-0.217>,
		<-558.45,677.65,810.15>, <0.33,0.92,-0.212>,
		<-371.75,690.7,866.45>, <0.22,0.95,-0.219>
  }
  smooth_triangle { // #6463
		<-558.45,662.95,813.55>, <0.365,0.907,-0.209>,
		<-558.45,677.65,810.15>, <0.33,0.92,-0.212>,
		<-371.75,676,869.85>, <0.258,0.941,-0.217>
  }
  smooth_triangle { // #6464
		<-558.45,662.95,813.55>, <0.365,0.907,-0.209>,
		<-744.7,659.5,731.3>, <0.203,0.954,-0.22>,
		<-558.45,677.65,810.15>, <0.33,0.92,-0.212>
  }
  smooth_triangle { // #6465
		<757.3,644.8,734.85>, <-0.133,0.966,-0.223>,
		<862.05,659.5,731.5>, <0,0.974,-0.225>,
		<862.05,644.8,734.9>, <0,0.974,-0.225>
  }
  smooth_triangle { // #6466
		<862.05,659.5,731.5>, <0,0.974,-0.225>,
		<757.3,644.8,734.85>, <-0.133,0.966,-0.223>,
		<757.3,659.5,731.45>, <-0.267,0.939,-0.217>
  }
  triangle { // #6467
		<862.05,644.8,734.9>,
		<862.35,816.2,1410.2>,
		<862.35,801.5,1413.55>
  }
  triangle { // #6468
		<862.35,816.2,1410.2>,
		<862.05,644.8,734.9>,
		<862.05,659.5,731.5>
  }
  triangle { // #6469
		<862.35,801.5,1413.55>,
		<-855.4,816.2,1410.2>,
		<-855.4,801.5,1413.55>
  }
  triangle { // #6470
		<-855.4,816.2,1410.2>,
		<862.35,801.5,1413.55>,
		<862.35,816.2,1410.2>
  }
  triangle { // #6471
		<-855.4,801.5,1413.55>,
		<-855.65,659.5,731.35>,
		<-855.65,644.8,734.75>
  }
  triangle { // #6472
		<-855.65,659.5,731.35>,
		<-855.4,801.5,1413.55>,
		<-855.4,816.2,1410.2>
  }
  triangle { // #6473
		<844.8,797.05,1341.15>,
		<844.8,805.2,1388.9>,
		<844.8,786.05,1342.25>
  }
  triangle { // #6474
		<844.8,749.6,1964.75>,
		<844.8,790.65,1426.4>,
		<844.8,760.05,1964.75>
  }
  triangle { // #6475
		<844.8,760.05,1964.75>,
		<844.8,790.65,1426.4>,
		<844.8,804.6,1427.7>
  }
  triangle { // #6476
		<844.8,804.6,1427.7>,
		<844.8,790.65,1426.4>,
		<844.8,805.2,1388.9>
  }
  triangle { // #6477
		<844.8,790.65,1426.4>,
		<844.8,786.05,1342.25>,
		<844.8,805.2,1388.9>
  }
  triangle { // #6478
		<-845.05,797.05,1341.15>,
		<-845.05,786.05,1342.25>,
		<-845.05,805.2,1388.9>
  }
  triangle { // #6479
		<-845.05,749.6,1964.75>,
		<-845.05,760.05,1964.75>,
		<-845.05,790.65,1426.4>
  }
  triangle { // #6480
		<-845.05,760.05,1964.75>,
		<-845.05,804.6,1427.7>,
		<-845.05,790.65,1426.4>
  }
  triangle { // #6481
		<-845.05,804.6,1427.7>,
		<-845.05,805.2,1388.9>,
		<-845.05,790.65,1426.4>
  }
  triangle { // #6482
		<-845.05,790.65,1426.4>,
		<-845.05,805.2,1388.9>,
		<-845.05,786.05,1342.25>
  }
  triangle { // #6483
		<844.8,786.05,1342.25>,
		<-845.05,786.05,1342.25>,
		<844.8,797.05,1341.15>
  }
  triangle { // #6484
		<-845.05,797.05,1341.15>,
		<844.8,797.05,1341.15>,
		<-845.05,786.05,1342.25>
  }
  smooth_triangle { // #6485
		<844.8,790.65,1426.4>, <0,0.033,-0.999>,
		<-845.05,790.65,1426.4>, <0,-0.011,-1>,
		<844.8,786.05,1342.25>, <0,-0.055,-0.999>
  }
  smooth_triangle { // #6486
		<-845.05,786.05,1342.25>, <0,-0.055,-0.999>,
		<844.8,786.05,1342.25>, <0,-0.055,-0.999>,
		<-845.05,790.65,1426.4>, <0,-0.011,-1>
  }
  smooth_triangle { // #6487
		<844.8,749.6,1964.75>, <0,0.076,-0.997>,
		<-845.05,749.6,1964.75>, <0,0.076,-0.997>,
		<844.8,790.65,1426.4>, <0,0.033,-0.999>
  }
  smooth_triangle { // #6488
		<-845.05,790.65,1426.4>, <0,-0.011,-1>,
		<844.8,790.65,1426.4>, <0,0.033,-0.999>,
		<-845.05,749.6,1964.75>, <0,0.076,-0.997>
  }
  triangle { // #6489
		<844.8,760.05,1964.75>,
		<-845.05,760.05,1964.75>,
		<844.8,749.6,1964.75>
  }
  triangle { // #6490
		<-845.05,749.6,1964.75>,
		<844.8,749.6,1964.75>,
		<-845.05,760.05,1964.75>
  }
  smooth_triangle { // #6491
		<844.8,804.6,1427.7>, <0,-0.049,0.999>,
		<-845.05,804.6,1427.7>, <0,-0.049,0.999>,
		<844.8,760.05,1964.75>, <0,-0.083,0.997>
  }
  smooth_triangle { // #6492
		<-845.05,760.05,1964.75>, <0,-0.083,0.997>,
		<844.8,760.05,1964.75>, <0,-0.083,0.997>,
		<-845.05,804.6,1427.7>, <0,-0.049,0.999>
  }
  smooth_triangle { // #6493
		<844.8,797.05,1341.15>, <0,0.169,0.986>,
		<-845.05,797.05,1341.15>, <0,0.169,0.986>,
		<844.8,805.2,1388.9>, <0,0.077,0.997>
  }
  smooth_triangle { // #6494
		<844.8,804.6,1427.7>, <0,-0.049,0.999>,
		<844.8,805.2,1388.9>, <0,0.077,0.997>,
		<-845.05,804.6,1427.7>, <0,-0.049,0.999>
  }
  smooth_triangle { // #6495
		<-845.05,804.6,1427.7>, <0,-0.049,0.999>,
		<844.8,805.2,1388.9>, <0,0.077,0.997>,
		<-845.05,805.2,1388.9>, <0,0.077,0.997>
  }
  smooth_triangle { // #6496
		<-845.05,805.2,1388.9>, <0,0.077,0.997>,
		<844.8,805.2,1388.9>, <0,0.077,0.997>,
		<-845.05,797.05,1341.15>, <0,0.169,0.986>
  }
  triangle { // #6497
		<510.05,485.95,1931.25>,
		<510.05,485.95,1918.8>,
		<677.9,485.95,1895.3>
  }
  triangle { // #6498
		<843.2,485.95,1834.55>,
		<843.2,485.95,1846.4>,
		<677.9,485.95,1881.45>
  }
  triangle { // #6499
		<843.2,485.95,1846.4>,
		<677.9,485.95,1895.3>,
		<677.9,485.95,1881.45>
  }
  triangle { // #6500
		<677.9,485.95,1881.45>,
		<677.9,485.95,1895.3>,
		<510.05,485.95,1918.8>
  }
  triangle { // #6501
		<510.05,772.6,1931.25>,
		<677.9,772.6,1895.3>,
		<510.05,772.6,1918.8>
  }
  triangle { // #6502
		<843.2,772.6,1834.55>,
		<677.9,772.6,1881.45>,
		<843.2,772.6,1846.4>
  }
  triangle { // #6503
		<843.2,772.6,1846.4>,
		<677.9,772.6,1881.45>,
		<677.9,772.6,1895.3>
  }
  triangle { // #6504
		<677.9,772.6,1881.45>,
		<510.05,772.6,1918.8>,
		<677.9,772.6,1895.3>
  }
  triangle { // #6505
		<843.2,485.95,1834.55>,
		<843.2,772.6,1834.55>,
		<843.2,485.95,1846.4>
  }
  triangle { // #6506
		<843.2,772.6,1846.4>,
		<843.2,485.95,1846.4>,
		<843.2,772.6,1834.55>
  }
  smooth_triangle { // #6507
		<843.2,485.95,1834.55>, <-0.273,0.962,0>,
		<677.9,485.95,1881.45>, <-0.245,0.969,0>,
		<843.2,772.6,1834.55>, <-0.273,0.962,0>
  }
  smooth_triangle { // #6508
		<510.05,485.95,1918.8>, <-0.217,0.976,0>,
		<510.05,772.6,1918.8>, <-0.217,0.976,0>,
		<677.9,485.95,1881.45>, <-0.245,0.969,0>
  }
  smooth_triangle { // #6509
		<510.05,772.6,1918.8>, <-0.217,0.976,0>,
		<677.9,772.6,1881.45>, <-0.245,0.969,0>,
		<677.9,485.95,1881.45>, <-0.245,0.969,0>
  }
  smooth_triangle { // #6510
		<677.9,772.6,1881.45>, <-0.245,0.969,0>,
		<843.2,772.6,1834.55>, <-0.273,0.962,0>,
		<677.9,485.95,1881.45>, <-0.245,0.969,0>
  }
  triangle { // #6511
		<510.05,485.95,1931.25>,
		<510.05,772.6,1931.25>,
		<510.05,485.95,1918.8>
  }
  triangle { // #6512
		<510.05,772.6,1918.8>,
		<510.05,485.95,1918.8>,
		<510.05,772.6,1931.25>
  }
  smooth_triangle { // #6513
		<510.05,485.95,1931.25>, <0.21,-0.978,0>,
		<677.9,485.95,1895.3>, <0.247,-0.969,0>,
		<510.05,772.6,1931.25>, <0.21,-0.978,0>
  }
  smooth_triangle { // #6514
		<843.2,485.95,1846.4>, <0.283,-0.959,0>,
		<843.2,772.6,1846.4>, <0.283,-0.959,0>,
		<677.9,485.95,1895.3>, <0.247,-0.969,0>
  }
  smooth_triangle { // #6515
		<843.2,772.6,1846.4>, <0.283,-0.959,0>,
		<677.9,772.6,1895.3>, <0.247,-0.969,0>,
		<677.9,485.95,1895.3>, <0.247,-0.969,0>
  }
  smooth_triangle { // #6516
		<677.9,772.6,1895.3>, <0.247,-0.969,0>,
		<510.05,772.6,1931.25>, <0.21,-0.978,0>,
		<677.9,485.95,1895.3>, <0.247,-0.969,0>
  }
  triangle { // #6517
		<-675,485.95,1895.3>,
		<-507.15,485.95,1918.8>,
		<-507.15,485.95,1931.25>
  }
  triangle { // #6518
		<-675,485.95,1881.45>,
		<-840.3,485.95,1846.4>,
		<-840.3,485.95,1834.55>
  }
  triangle { // #6519
		<-675,485.95,1881.45>,
		<-675,485.95,1895.3>,
		<-840.3,485.95,1846.4>
  }
  triangle { // #6520
		<-507.15,485.95,1918.8>,
		<-675,485.95,1895.3>,
		<-675,485.95,1881.45>
  }
  triangle { // #6521
		<-507.15,772.6,1918.8>,
		<-675,772.6,1895.3>,
		<-507.15,772.6,1931.25>
  }
  triangle { // #6522
		<-840.3,772.6,1846.4>,
		<-675,772.6,1881.45>,
		<-840.3,772.6,1834.55>
  }
  triangle { // #6523
		<-675,772.6,1895.3>,
		<-675,772.6,1881.45>,
		<-840.3,772.6,1846.4>
  }
  triangle { // #6524
		<-675,772.6,1895.3>,
		<-507.15,772.6,1918.8>,
		<-675,772.6,1881.45>
  }
  triangle { // #6525
		<-840.3,485.95,1846.4>,
		<-840.3,772.6,1834.55>,
		<-840.3,485.95,1834.55>
  }
  triangle { // #6526
		<-840.3,772.6,1834.55>,
		<-840.3,485.95,1846.4>,
		<-840.3,772.6,1846.4>
  }
  smooth_triangle { // #6527
		<-840.3,772.6,1834.55>, <0.273,0.962,0>,
		<-675,485.95,1881.45>, <0.245,0.969,0>,
		<-840.3,485.95,1834.55>, <0.273,0.962,0>
  }
  smooth_triangle { // #6528
		<-675,485.95,1881.45>, <0.245,0.969,0>,
		<-507.15,772.6,1918.8>, <0.217,0.976,0>,
		<-507.15,485.95,1918.8>, <0.217,0.976,0>
  }
  smooth_triangle { // #6529
		<-675,485.95,1881.45>, <0.245,0.969,0>,
		<-675,772.6,1881.45>, <0.245,0.969,0>,
		<-507.15,772.6,1918.8>, <0.217,0.976,0>
  }
  smooth_triangle { // #6530
		<-675,485.95,1881.45>, <0.245,0.969,0>,
		<-840.3,772.6,1834.55>, <0.273,0.962,0>,
		<-675,772.6,1881.45>, <0.245,0.969,0>
  }
  triangle { // #6531
		<-507.15,485.95,1918.8>,
		<-507.15,772.6,1931.25>,
		<-507.15,485.95,1931.25>
  }
  triangle { // #6532
		<-507.15,772.6,1931.25>,
		<-507.15,485.95,1918.8>,
		<-507.15,772.6,1918.8>
  }
  smooth_triangle { // #6533
		<-507.15,772.6,1931.25>, <-0.21,-0.978,0>,
		<-675,485.95,1895.3>, <-0.247,-0.969,0>,
		<-507.15,485.95,1931.25>, <-0.21,-0.978,0>
  }
  smooth_triangle { // #6534
		<-675,485.95,1895.3>, <-0.247,-0.969,0>,
		<-840.3,772.6,1846.4>, <-0.283,-0.959,0>,
		<-840.3,485.95,1846.4>, <-0.283,-0.959,0>
  }
  smooth_triangle { // #6535
		<-675,485.95,1895.3>, <-0.247,-0.969,0>,
		<-675,772.6,1895.3>, <-0.247,-0.969,0>,
		<-840.3,772.6,1846.4>, <-0.283,-0.959,0>
  }
  smooth_triangle { // #6536
		<-675,485.95,1895.3>, <-0.247,-0.969,0>,
		<-507.15,772.6,1931.25>, <-0.21,-0.978,0>,
		<-675,772.6,1895.3>, <-0.247,-0.969,0>
  }
  triangle { // #6537
		<-401.5,485.95,1913.75>,
		<-390.2,485.95,1925.1>,
		<-397.75,485.95,1925.1>
  }
  triangle { // #6538
		<-379.5,485.95,1868.7>,
		<-304.25,485.95,1865.6>,
		<-305.35,485.95,1878.45>
  }
  triangle { // #6539
		<-379.5,485.95,1868.7>,
		<-391.45,485.95,1854.25>,
		<-304.25,485.95,1865.6>
  }
  triangle { // #6540
		<-379.5,485.95,1868.7>,
		<-401.5,485.95,1913.75>,
		<-391.45,485.95,1854.25>
  }
  triangle { // #6541
		<-390.2,485.95,1925.1>,
		<-401.5,485.95,1913.75>,
		<-379.5,485.95,1868.7>
  }
  triangle { // #6542
		<-390.2,802.8,1925.1>,
		<-401.5,802.8,1913.75>,
		<-397.75,802.8,1925.1>
  }
  triangle { // #6543
		<-304.25,802.8,1865.6>,
		<-379.5,802.8,1868.7>,
		<-305.35,802.8,1878.45>
  }
  triangle { // #6544
		<-391.45,802.8,1854.25>,
		<-379.5,802.8,1868.7>,
		<-304.25,802.8,1865.6>
  }
  triangle { // #6545
		<-401.5,802.8,1913.75>,
		<-379.5,802.8,1868.7>,
		<-391.45,802.8,1854.25>
  }
  triangle { // #6546
		<-401.5,802.8,1913.75>,
		<-390.2,802.8,1925.1>,
		<-379.5,802.8,1868.7>
  }
  smooth_triangle { // #6547
		<-305.35,485.95,1878.45>, <-0.115,-0.993,0>,
		<-379.5,802.8,1868.7>, <-0.13,-0.992,0>,
		<-379.5,485.95,1868.7>, <-0.13,-0.992,0>
  }
  smooth_triangle { // #6548
		<-379.5,802.8,1868.7>, <-0.13,-0.992,0>,
		<-305.35,485.95,1878.45>, <-0.115,-0.993,0>,
		<-305.35,802.8,1878.45>, <-0.13,-0.992,0>
  }
  triangle { // #6549
		<-379.5,485.95,1868.7>,
		<-390.2,802.8,1925.1>,
		<-390.2,485.95,1925.1>
  }
  triangle { // #6550
		<-390.2,802.8,1925.1>,
		<-379.5,485.95,1868.7>,
		<-379.5,802.8,1868.7>
  }
  triangle { // #6551
		<-390.2,485.95,1925.1>,
		<-397.75,802.8,1925.1>,
		<-397.75,485.95,1925.1>
  }
  triangle { // #6552
		<-397.75,802.8,1925.1>,
		<-390.2,485.95,1925.1>,
		<-390.2,802.8,1925.1>
  }
  smooth_triangle { // #6553
		<-397.75,485.95,1925.1>, <-0.999,-0.04,0>,
		<-401.5,802.8,1913.75>, <-0.995,-0.095,0>,
		<-401.5,485.95,1913.75>, <-1,0.004,0>
  }
  smooth_triangle { // #6554
		<-401.5,802.8,1913.75>, <-0.995,-0.095,0>,
		<-397.75,485.95,1925.1>, <-0.999,-0.04,0>,
		<-397.75,802.8,1925.1>, <-0.989,0.148,0>
  }
  smooth_triangle { // #6555
		<-401.5,485.95,1913.75>, <-1,0.004,0>,
		<-391.45,802.8,1854.25>, <-0.986,0.167,0>,
		<-391.45,485.95,1854.25>, <-0.986,0.167,0>
  }
  smooth_triangle { // #6556
		<-391.45,802.8,1854.25>, <-0.986,0.167,0>,
		<-401.5,485.95,1913.75>, <-1,0.004,0>,
		<-401.5,802.8,1913.75>, <-0.995,-0.095,0>
  }
  smooth_triangle { // #6557
		<-391.45,485.95,1854.25>, <0.129,0.992,0>,
		<-304.25,802.8,1865.6>, <0.129,0.992,0>,
		<-304.25,485.95,1865.6>, <0.111,0.994,0>
  }
  triangle { // #6558
		<-304.25,802.8,1865.6>,
		<-391.45,485.95,1854.25>,
		<-391.45,802.8,1854.25>
  }
  triangle { // #6559
		<-304.25,485.95,1865.6>,
		<-305.35,802.8,1878.45>,
		<-305.35,485.95,1878.45>
  }
  triangle { // #6560
		<-305.35,802.8,1878.45>,
		<-304.25,485.95,1865.6>,
		<-304.25,802.8,1865.6>
  }
  triangle { // #6561
		<-185.1,485.95,1890.55>,
		<-305.35,485.95,1878.45>,
		<-183.95,485.95,1876.9>
  }
  triangle { // #6562
		<-304.25,485.95,1865.6>,
		<-183.95,485.95,1876.9>,
		<-305.35,485.95,1878.45>
  }
  triangle { // #6563
		<-304.25,661.35,1865.6>,
		<-305.35,661.35,1878.45>,
		<-183.95,661.35,1876.9>
  }
  triangle { // #6564
		<-185.1,661.35,1890.55>,
		<-183.95,661.35,1876.9>,
		<-305.35,661.35,1878.45>
  }
  smooth_triangle { // #6565
		<-304.25,485.95,1865.6>, <0.111,0.994,0>,
		<-304.25,661.35,1865.6>, <0.094,0.996,0>,
		<-183.95,485.95,1876.9>, <0.073,0.997,0>
  }
  smooth_triangle { // #6566
		<-183.95,661.35,1876.9>, <0.094,0.996,0>,
		<-183.95,485.95,1876.9>, <0.073,0.997,0>,
		<-304.25,661.35,1865.6>, <0.094,0.996,0>
  }
  triangle { // #6567
		<-305.35,485.95,1878.45>,
		<-305.35,661.35,1878.45>,
		<-304.25,485.95,1865.6>
  }
  triangle { // #6568
		<-304.25,661.35,1865.6>,
		<-304.25,485.95,1865.6>,
		<-305.35,661.35,1878.45>
  }
  smooth_triangle { // #6569
		<-185.1,485.95,1890.55>, <-0.078,-0.997,0>,
		<-185.1,661.35,1890.55>, <-0.1,-0.995,0>,
		<-305.35,485.95,1878.45>, <-0.115,-0.993,0>
  }
  smooth_triangle { // #6570
		<-305.35,661.35,1878.45>, <-0.1,-0.995,0>,
		<-305.35,485.95,1878.45>, <-0.115,-0.993,0>,
		<-185.1,661.35,1890.55>, <-0.1,-0.995,0>
  }
  triangle { // #6571
		<-183.95,485.95,1876.9>,
		<-183.95,661.35,1876.9>,
		<-185.1,485.95,1890.55>
  }
  triangle { // #6572
		<-185.1,661.35,1890.55>,
		<-185.1,485.95,1890.55>,
		<-183.95,661.35,1876.9>
  }
  triangle { // #6573
		<-185.1,485.95,1890.55>,
		<-128.7,485.95,1879.8>,
		<-128.7,485.95,1893.7>
  }
  triangle { // #6574
		<-128.7,485.95,1879.8>,
		<-185.1,485.95,1890.55>,
		<-183.95,485.95,1876.9>
  }
  triangle { // #6575
		<-185.1,802.8,1890.55>,
		<-128.7,802.8,1879.8>,
		<-183.95,802.8,1876.9>
  }
  triangle { // #6576
		<-128.7,802.8,1879.8>,
		<-185.1,802.8,1890.55>,
		<-128.7,802.8,1893.7>
  }
  triangle { // #6577
		<-185.1,485.95,1890.55>,
		<-183.95,802.8,1876.9>,
		<-183.95,485.95,1876.9>
  }
  triangle { // #6578
		<-183.95,802.8,1876.9>,
		<-185.1,485.95,1890.55>,
		<-185.1,802.8,1890.55>
  }
  smooth_triangle { // #6579
		<-183.95,485.95,1876.9>, <0.073,0.997,0>,
		<-128.7,802.8,1879.8>, <0.053,0.999,0>,
		<-128.7,485.95,1879.8>, <0.04,0.999,0>
  }
  smooth_triangle { // #6580
		<-128.7,802.8,1879.8>, <0.053,0.999,0>,
		<-183.95,485.95,1876.9>, <0.073,0.997,0>,
		<-183.95,802.8,1876.9>, <0.053,0.999,0>
  }
  triangle { // #6581
		<-128.7,485.95,1879.8>,
		<-128.7,802.8,1893.7>,
		<-128.7,485.95,1893.7>
  }
  triangle { // #6582
		<-128.7,802.8,1893.7>,
		<-128.7,485.95,1879.8>,
		<-128.7,802.8,1879.8>
  }
  smooth_triangle { // #6583
		<-128.7,485.95,1893.7>, <-0.046,-0.999,0>,
		<-185.1,802.8,1890.55>, <-0.056,-0.998,0>,
		<-185.1,485.95,1890.55>, <-0.078,-0.997,0>
  }
  triangle { // #6584
		<-185.1,802.8,1890.55>,
		<-128.7,485.95,1893.7>,
		<-128.7,802.8,1893.7>
  }
  triangle { // #6585
		<127.85,485.95,1879.9>,
		<127.85,485.95,1893.85>,
		<-0.45,485.95,1883.25>
  }
  triangle { // #6586
		<-128.7,485.95,1879.8>,
		<-0.45,485.95,1883.25>,
		<-128.7,485.95,1893.7>
  }
  triangle { // #6587
		<-128.7,485.95,1893.7>,
		<-0.45,485.95,1883.25>,
		<-0.45,485.95,1897.3>
  }
  triangle { // #6588
		<-0.45,485.95,1897.3>,
		<-0.45,485.95,1883.25>,
		<127.85,485.95,1893.85>
  }
  triangle { // #6589
		<127.85,661.35,1879.9>,
		<-0.45,661.35,1883.25>,
		<127.85,661.35,1893.85>
  }
  triangle { // #6590
		<-128.7,661.35,1879.8>,
		<-128.7,661.35,1893.7>,
		<-0.45,661.35,1883.25>
  }
  triangle { // #6591
		<-128.7,661.35,1893.7>,
		<-0.45,661.35,1897.3>,
		<-0.45,661.35,1883.25>
  }
  triangle { // #6592
		<-0.45,661.35,1897.3>,
		<127.85,661.35,1893.85>,
		<-0.45,661.35,1883.25>
  }
  triangle { // #6593
		<-128.7,485.95,1893.7>,
		<-128.7,661.35,1893.7>,
		<-128.7,485.95,1879.8>
  }
  triangle { // #6594
		<-128.7,661.35,1879.8>,
		<-128.7,485.95,1879.8>,
		<-128.7,661.35,1893.7>
  }
  smooth_triangle { // #6595
		<-128.7,485.95,1893.7>, <-0.046,-0.999,0>,
		<-0.45,485.95,1897.3>, <-0,-1,0>,
		<-128.7,661.35,1893.7>, <-0.028,-1,0>
  }
  smooth_triangle { // #6596
		<127.85,485.95,1893.85>, <0.047,-0.999,0>,
		<127.85,661.35,1893.85>, <0.027,-1,0>,
		<-0.45,485.95,1897.3>, <-0,-1,0>
  }
  smooth_triangle { // #6597
		<127.85,661.35,1893.85>, <0.027,-1,0>,
		<-0.45,661.35,1897.3>, <-0,-1,0>,
		<-0.45,485.95,1897.3>, <-0,-1,0>
  }
  smooth_triangle { // #6598
		<-0.45,661.35,1897.3>, <-0,-1,0>,
		<-128.7,661.35,1893.7>, <-0.028,-1,0>,
		<-0.45,485.95,1897.3>, <-0,-1,0>
  }
  triangle { // #6599
		<127.85,485.95,1879.9>,
		<127.85,661.35,1879.9>,
		<127.85,485.95,1893.85>
  }
  triangle { // #6600
		<127.85,661.35,1893.85>,
		<127.85,485.95,1893.85>,
		<127.85,661.35,1879.9>
  }
  smooth_triangle { // #6601
		<127.85,485.95,1879.9>, <-0.04,0.999,0>,
		<-0.45,485.95,1883.25>, <0,1,0>,
		<127.85,661.35,1879.9>, <-0.026,1,0>
  }
  smooth_triangle { // #6602
		<-128.7,485.95,1879.8>, <0.04,0.999,0>,
		<-128.7,661.35,1879.8>, <0.027,1,0>,
		<-0.45,485.95,1883.25>, <0,1,0>
  }
  smooth_triangle { // #6603
		<-128.7,661.35,1879.8>, <0.027,1,0>,
		<-0.45,661.35,1883.25>, <0,1,0>,
		<-0.45,485.95,1883.25>, <0,1,0>
  }
  smooth_triangle { // #6604
		<-0.45,661.35,1883.25>, <0,1,0>,
		<127.85,661.35,1879.9>, <-0.026,1,0>,
		<-0.45,485.95,1883.25>, <0,1,0>
  }
  triangle { // #6605
		<183.3,485.95,1876.9>,
		<184.5,485.95,1890.55>,
		<127.85,485.95,1879.9>
  }
  triangle { // #6606
		<127.85,485.95,1893.85>,
		<127.85,485.95,1879.9>,
		<184.5,485.95,1890.55>
  }
  triangle { // #6607
		<127.85,802.8,1893.85>,
		<184.5,802.8,1890.55>,
		<127.85,802.8,1879.9>
  }
  triangle { // #6608
		<183.3,802.8,1876.9>,
		<127.85,802.8,1879.9>,
		<184.5,802.8,1890.55>
  }
  smooth_triangle { // #6609
		<127.85,485.95,1879.9>, <-0.04,0.999,0>,
		<127.85,802.8,1879.9>, <-0.054,0.999,0>,
		<183.3,485.95,1876.9>, <-0.073,0.997,0>
  }
  smooth_triangle { // #6610
		<183.3,802.8,1876.9>, <-0.054,0.999,0>,
		<183.3,485.95,1876.9>, <-0.073,0.997,0>,
		<127.85,802.8,1879.9>, <-0.054,0.999,0>
  }
  triangle { // #6611
		<127.85,485.95,1893.85>,
		<127.85,802.8,1893.85>,
		<127.85,485.95,1879.9>
  }
  triangle { // #6612
		<127.85,802.8,1879.9>,
		<127.85,485.95,1879.9>,
		<127.85,802.8,1893.85>
  }
  smooth_triangle { // #6613
		<184.5,485.95,1890.55>, <0.077,-0.997,0>,
		<184.5,802.8,1890.55>, <0.057,-0.998,0>,
		<127.85,485.95,1893.85>, <0.047,-0.999,0>
  }
  smooth_triangle { // #6614
		<127.85,802.8,1893.85>, <0.057,-0.998,0>,
		<127.85,485.95,1893.85>, <0.047,-0.999,0>,
		<184.5,802.8,1890.55>, <0.057,-0.998,0>
  }
  triangle { // #6615
		<183.3,485.95,1876.9>,
		<183.3,802.8,1876.9>,
		<184.5,485.95,1890.55>
  }
  triangle { // #6616
		<184.5,802.8,1890.55>,
		<184.5,485.95,1890.55>,
		<183.3,802.8,1876.9>
  }
  triangle { // #6617
		<183.3,485.95,1876.9>,
		<304.55,485.95,1878.9>,
		<184.5,485.95,1890.55>
  }
  triangle { // #6618
		<304.55,485.95,1878.9>,
		<183.3,485.95,1876.9>,
		<303.45,485.95,1865.95>
  }
  triangle { // #6619
		<183.3,661.35,1876.9>,
		<304.55,661.35,1878.9>,
		<303.45,661.35,1865.95>
  }
  triangle { // #6620
		<304.55,661.35,1878.9>,
		<183.3,661.35,1876.9>,
		<184.5,661.35,1890.55>
  }
  smooth_triangle { // #6621
		<183.3,485.95,1876.9>, <-0.073,0.997,0>,
		<303.45,661.35,1865.95>, <-0.091,0.996,0>,
		<303.45,485.95,1865.95>, <-0.109,0.994,0>
  }
  smooth_triangle { // #6622
		<303.45,661.35,1865.95>, <-0.091,0.996,0>,
		<183.3,485.95,1876.9>, <-0.073,0.997,0>,
		<183.3,661.35,1876.9>, <-0.091,0.996,0>
  }
  triangle { // #6623
		<303.45,485.95,1865.95>,
		<304.55,661.35,1878.9>,
		<304.55,485.95,1878.9>
  }
  triangle { // #6624
		<304.55,661.35,1878.9>,
		<303.45,485.95,1865.95>,
		<303.45,661.35,1865.95>
  }
  smooth_triangle { // #6625
		<304.55,485.95,1878.9>, <0.114,-0.994,0>,
		<184.5,661.35,1890.55>, <0.097,-0.995,0>,
		<184.5,485.95,1890.55>, <0.077,-0.997,0>
  }
  smooth_triangle { // #6626
		<184.5,661.35,1890.55>, <0.097,-0.995,0>,
		<304.55,485.95,1878.9>, <0.114,-0.994,0>,
		<304.55,661.35,1878.9>, <0.097,-0.995,0>
  }
  triangle { // #6627
		<184.5,485.95,1890.55>,
		<183.3,661.35,1876.9>,
		<183.3,485.95,1876.9>
  }
  triangle { // #6628
		<183.3,661.35,1876.9>,
		<184.5,485.95,1890.55>,
		<184.5,661.35,1890.55>
  }
  triangle { // #6629
		<400.65,485.95,1925.1>,
		<394.35,485.95,1925.1>,
		<404.4,485.95,1913.75>
  }
  triangle { // #6630
		<304.55,485.95,1878.9>,
		<303.45,485.95,1865.95>,
		<384.3,485.95,1868.4>
  }
  triangle { // #6631
		<303.45,485.95,1865.95>,
		<394.35,485.95,1854.25>,
		<384.3,485.95,1868.4>
  }
  triangle { // #6632
		<394.35,485.95,1854.25>,
		<404.4,485.95,1913.75>,
		<384.3,485.95,1868.4>
  }
  triangle { // #6633
		<384.3,485.95,1868.4>,
		<404.4,485.95,1913.75>,
		<394.35,485.95,1925.1>
  }
  triangle { // #6634
		<400.65,802.8,1925.1>,
		<404.4,802.8,1913.75>,
		<394.35,802.8,1925.1>
  }
  triangle { // #6635
		<304.55,802.8,1878.9>,
		<384.3,802.8,1868.4>,
		<303.45,802.8,1865.95>
  }
  triangle { // #6636
		<303.45,802.8,1865.95>,
		<384.3,802.8,1868.4>,
		<394.35,802.8,1854.25>
  }
  triangle { // #6637
		<394.35,802.8,1854.25>,
		<384.3,802.8,1868.4>,
		<404.4,802.8,1913.75>
  }
  triangle { // #6638
		<384.3,802.8,1868.4>,
		<394.35,802.8,1925.1>,
		<404.4,802.8,1913.75>
  }
  smooth_triangle { // #6639
		<303.45,485.95,1865.95>, <-0.109,0.994,0>,
		<303.45,802.8,1865.95>, <-0.128,0.992,0>,
		<394.35,485.95,1854.25>, <-0.128,0.992,0>
  }
  triangle { // #6640
		<394.35,802.8,1854.25>,
		<394.35,485.95,1854.25>,
		<303.45,802.8,1865.95>
  }
  triangle { // #6641
		<304.55,485.95,1878.9>,
		<304.55,802.8,1878.9>,
		<303.45,485.95,1865.95>
  }
  triangle { // #6642
		<303.45,802.8,1865.95>,
		<303.45,485.95,1865.95>,
		<304.55,802.8,1878.9>
  }
  smooth_triangle { // #6643
		<384.3,485.95,1868.4>, <0.131,-0.991,0>,
		<384.3,802.8,1868.4>, <0.131,-0.991,0>,
		<304.55,485.95,1878.9>, <0.114,-0.994,0>
  }
  smooth_triangle { // #6644
		<304.55,802.8,1878.9>, <0.131,-0.991,0>,
		<304.55,485.95,1878.9>, <0.114,-0.994,0>,
		<384.3,802.8,1868.4>, <0.131,-0.991,0>
  }
  triangle { // #6645
		<394.35,485.95,1925.1>,
		<394.35,802.8,1925.1>,
		<384.3,485.95,1868.4>
  }
  triangle { // #6646
		<384.3,802.8,1868.4>,
		<384.3,485.95,1868.4>,
		<394.35,802.8,1925.1>
  }
  triangle { // #6647
		<400.65,485.95,1925.1>,
		<400.65,802.8,1925.1>,
		<394.35,485.95,1925.1>
  }
  triangle { // #6648
		<394.35,802.8,1925.1>,
		<394.35,485.95,1925.1>,
		<400.65,802.8,1925.1>
  }
  smooth_triangle { // #6649
		<404.4,485.95,1913.75>, <1,0.003,0>,
		<404.4,802.8,1913.75>, <0.993,-0.119,0>,
		<400.65,485.95,1925.1>, <0.998,-0.066,0>
  }
  smooth_triangle { // #6650
		<400.65,802.8,1925.1>, <0.997,0.08,0>,
		<400.65,485.95,1925.1>, <0.998,-0.066,0>,
		<404.4,802.8,1913.75>, <0.993,-0.119,0>
  }
  smooth_triangle { // #6651
		<394.35,485.95,1854.25>, <0.986,0.167,0>,
		<394.35,802.8,1854.25>, <0.986,0.167,0>,
		<404.4,485.95,1913.75>, <1,0.003,0>
  }
  smooth_triangle { // #6652
		<404.4,802.8,1913.75>, <0.993,-0.119,0>,
		<404.4,485.95,1913.75>, <1,0.003,0>,
		<394.35,802.8,1854.25>, <0.986,0.167,0>
  }
  triangle { // #6653
		<-185.1,721.7,1890.55>,
		<-305.35,721.7,1878.45>,
		<-183.95,721.7,1876.9>
  }
  triangle { // #6654
		<-304.25,721.7,1865.6>,
		<-183.95,721.7,1876.9>,
		<-305.35,721.7,1878.45>
  }
  triangle { // #6655
		<-304.25,802.8,1865.6>,
		<-305.35,802.8,1878.45>,
		<-183.95,802.8,1876.9>
  }
  triangle { // #6656
		<-185.1,802.8,1890.55>,
		<-183.95,802.8,1876.9>,
		<-305.35,802.8,1878.45>
  }
  smooth_triangle { // #6657
		<-304.25,721.7,1865.6>, <0.094,0.996,0>,
		<-304.25,802.8,1865.6>, <0.111,0.994,0>,
		<-183.95,721.7,1876.9>, <0.094,0.996,0>
  }
  smooth_triangle { // #6658
		<-183.95,802.8,1876.9>, <0.073,0.997,0>,
		<-183.95,721.7,1876.9>, <0.094,0.996,0>,
		<-304.25,802.8,1865.6>, <0.111,0.994,0>
  }
  triangle { // #6659
		<-305.35,721.7,1878.45>,
		<-305.35,802.8,1878.45>,
		<-304.25,721.7,1865.6>
  }
  triangle { // #6660
		<-304.25,802.8,1865.6>,
		<-304.25,721.7,1865.6>,
		<-305.35,802.8,1878.45>
  }
  smooth_triangle { // #6661
		<-185.1,721.7,1890.55>, <-0.1,-0.995,0>,
		<-185.1,802.8,1890.55>, <-0.078,-0.997,0>,
		<-305.35,721.7,1878.45>, <-0.1,-0.995,0>
  }
  smooth_triangle { // #6662
		<-305.35,802.8,1878.45>, <-0.115,-0.993,0>,
		<-305.35,721.7,1878.45>, <-0.1,-0.995,0>,
		<-185.1,802.8,1890.55>, <-0.078,-0.997,0>
  }
  triangle { // #6663
		<-183.95,721.7,1876.9>,
		<-183.95,802.8,1876.9>,
		<-185.1,721.7,1890.55>
  }
  triangle { // #6664
		<-185.1,802.8,1890.55>,
		<-185.1,721.7,1890.55>,
		<-183.95,802.8,1876.9>
  }
  triangle { // #6665
		<127.85,736.8,1879.9>,
		<127.85,736.8,1893.85>,
		<-0.45,736.8,1883.25>
  }
  triangle { // #6666
		<-128.7,736.8,1879.8>,
		<-0.45,736.8,1883.25>,
		<-128.7,736.8,1893.7>
  }
  triangle { // #6667
		<-128.7,736.8,1893.7>,
		<-0.45,736.8,1883.25>,
		<-0.45,736.8,1897.3>
  }
  triangle { // #6668
		<-0.45,736.8,1897.3>,
		<-0.45,736.8,1883.25>,
		<127.85,736.8,1893.85>
  }
  triangle { // #6669
		<127.85,802.8,1879.9>,
		<-0.45,802.8,1883.25>,
		<127.85,802.8,1893.85>
  }
  triangle { // #6670
		<-128.7,802.8,1879.8>,
		<-128.7,802.8,1893.7>,
		<-0.45,802.8,1883.25>
  }
  triangle { // #6671
		<-128.7,802.8,1893.7>,
		<-0.45,802.8,1897.3>,
		<-0.45,802.8,1883.25>
  }
  triangle { // #6672
		<-0.45,802.8,1897.3>,
		<127.85,802.8,1893.85>,
		<-0.45,802.8,1883.25>
  }
  triangle { // #6673
		<-128.7,736.8,1893.7>,
		<-128.7,802.8,1893.7>,
		<-128.7,736.8,1879.8>
  }
  triangle { // #6674
		<-128.7,802.8,1879.8>,
		<-128.7,736.8,1879.8>,
		<-128.7,802.8,1893.7>
  }
  smooth_triangle { // #6675
		<-128.7,736.8,1893.7>, <-0.028,-1,0>,
		<-0.45,736.8,1897.3>, <-0,-1,0>,
		<-128.7,802.8,1893.7>, <-0.037,-0.999,0>
  }
  smooth_triangle { // #6676
		<127.85,736.8,1893.85>, <0.027,-1,0>,
		<127.85,802.8,1893.85>, <0.037,-0.999,0>,
		<-0.45,736.8,1897.3>, <-0,-1,0>
  }
  smooth_triangle { // #6677
		<127.85,802.8,1893.85>, <0.037,-0.999,0>,
		<-0.45,802.8,1897.3>, <-0,-1,0>,
		<-0.45,736.8,1897.3>, <-0,-1,0>
  }
  smooth_triangle { // #6678
		<-0.45,802.8,1897.3>, <-0,-1,0>,
		<-128.7,802.8,1893.7>, <-0.037,-0.999,0>,
		<-0.45,736.8,1897.3>, <-0,-1,0>
  }
  triangle { // #6679
		<127.85,736.8,1879.9>,
		<127.85,802.8,1879.9>,
		<127.85,736.8,1893.85>
  }
  triangle { // #6680
		<127.85,802.8,1893.85>,
		<127.85,736.8,1893.85>,
		<127.85,802.8,1879.9>
  }
  smooth_triangle { // #6681
		<127.85,736.8,1879.9>, <-0.026,1,0>,
		<-0.45,736.8,1883.25>, <0,1,0>,
		<127.85,802.8,1879.9>, <-0.04,0.999,0>
  }
  smooth_triangle { // #6682
		<-128.7,736.8,1879.8>, <0.027,1,0>,
		<-128.7,802.8,1879.8>, <0.04,0.999,0>,
		<-0.45,736.8,1883.25>, <0,1,0>
  }
  smooth_triangle { // #6683
		<-128.7,802.8,1879.8>, <0.04,0.999,0>,
		<-0.45,802.8,1883.25>, <0,1,0>,
		<-0.45,736.8,1883.25>, <0,1,0>
  }
  smooth_triangle { // #6684
		<-0.45,802.8,1883.25>, <0,1,0>,
		<127.85,802.8,1879.9>, <-0.04,0.999,0>,
		<-0.45,736.8,1883.25>, <0,1,0>
  }
  triangle { // #6685
		<183.3,721.7,1876.9>,
		<304.55,721.7,1878.9>,
		<184.5,721.7,1890.55>
  }
  triangle { // #6686
		<304.55,721.7,1878.9>,
		<183.3,721.7,1876.9>,
		<303.45,721.7,1865.95>
  }
  triangle { // #6687
		<183.3,802.8,1876.9>,
		<304.55,802.8,1878.9>,
		<303.45,802.8,1865.95>
  }
  triangle { // #6688
		<304.55,802.8,1878.9>,
		<183.3,802.8,1876.9>,
		<184.5,802.8,1890.55>
  }
  smooth_triangle { // #6689
		<183.3,721.7,1876.9>, <-0.091,0.996,0>,
		<303.45,802.8,1865.95>, <-0.109,0.994,0>,
		<303.45,721.7,1865.95>, <-0.091,0.996,0>
  }
  smooth_triangle { // #6690
		<303.45,802.8,1865.95>, <-0.109,0.994,0>,
		<183.3,721.7,1876.9>, <-0.091,0.996,0>,
		<183.3,802.8,1876.9>, <-0.073,0.997,0>
  }
  triangle { // #6691
		<303.45,721.7,1865.95>,
		<304.55,802.8,1878.9>,
		<304.55,721.7,1878.9>
  }
  triangle { // #6692
		<304.55,802.8,1878.9>,
		<303.45,721.7,1865.95>,
		<303.45,802.8,1865.95>
  }
  smooth_triangle { // #6693
		<304.55,721.7,1878.9>, <0.097,-0.995,0>,
		<184.5,802.8,1890.55>, <0.077,-0.997,0>,
		<184.5,721.7,1890.55>, <0.097,-0.995,0>
  }
  smooth_triangle { // #6694
		<184.5,802.8,1890.55>, <0.077,-0.997,0>,
		<304.55,721.7,1878.9>, <0.097,-0.995,0>,
		<304.55,802.8,1878.9>, <0.114,-0.994,0>
  }
  triangle { // #6695
		<184.5,721.7,1890.55>,
		<183.3,802.8,1876.9>,
		<183.3,721.7,1876.9>
  }
  triangle { // #6696
		<183.3,802.8,1876.9>,
		<184.5,721.7,1890.55>,
		<184.5,802.8,1890.55>
  }
  triangle { // #6697
		<500.9,485.95,1919.4>,
		<502.5,485.95,1919.4>,
		<500.9,485.95,1926.35>
  }
  triangle { // #6698
		<510.05,485.95,1913.75>,
		<510.05,485.95,1918.8>,
		<502.5,485.95,1914.7>
  }
  triangle { // #6699
		<502.5,485.95,1914.7>,
		<510.05,485.95,1918.8>,
		<502.5,485.95,1919.4>
  }
  triangle { // #6700
		<510.05,485.95,1932.3>,
		<502.5,485.95,1931.35>,
		<510.05,485.95,1918.8>
  }
  triangle { // #6701
		<502.5,485.95,1931.35>,
		<502.5,485.95,1926.35>,
		<510.05,485.95,1918.8>
  }
  triangle { // #6702
		<510.05,485.95,1918.8>,
		<502.5,485.95,1926.35>,
		<502.5,485.95,1919.4>
  }
  triangle { // #6703
		<502.5,485.95,1926.35>,
		<500.9,485.95,1926.35>,
		<502.5,485.95,1919.4>
  }
  triangle { // #6704
		<500.9,702.2,1926.35>,
		<502.5,702.2,1926.35>,
		<500.9,702.2,1919.4>
  }
  triangle { // #6705
		<510.05,702.2,1913.75>,
		<502.5,702.2,1914.7>,
		<510.05,702.2,1918.8>
  }
  triangle { // #6706
		<502.5,702.2,1914.7>,
		<502.5,702.2,1919.4>,
		<510.05,702.2,1918.8>
  }
  triangle { // #6707
		<510.05,702.2,1932.3>,
		<510.05,702.2,1918.8>,
		<502.5,702.2,1931.35>
  }
  triangle { // #6708
		<502.5,702.2,1931.35>,
		<510.05,702.2,1918.8>,
		<502.5,702.2,1926.35>
  }
  triangle { // #6709
		<510.05,702.2,1918.8>,
		<502.5,702.2,1919.4>,
		<502.5,702.2,1926.35>
  }
  triangle { // #6710
		<502.5,702.2,1919.4>,
		<500.9,702.2,1919.4>,
		<502.5,702.2,1926.35>
  }
  triangle { // #6711
		<510.05,485.95,1918.8>,
		<510.05,702.2,1918.8>,
		<510.05,485.95,1932.3>
  }
  triangle { // #6712
		<510.05,702.2,1932.3>,
		<510.05,485.95,1932.3>,
		<510.05,702.2,1918.8>
  }
  triangle { // #6713
		<510.05,485.95,1913.75>,
		<510.05,702.2,1913.75>,
		<510.05,485.95,1918.8>
  }
  triangle { // #6714
		<510.05,702.2,1918.8>,
		<510.05,485.95,1918.8>,
		<510.05,702.2,1913.75>
  }
  triangle { // #6715
		<502.5,485.95,1914.7>,
		<502.5,702.2,1914.7>,
		<510.05,485.95,1913.75>
  }
  triangle { // #6716
		<510.05,702.2,1913.75>,
		<510.05,485.95,1913.75>,
		<502.5,702.2,1914.7>
  }
  triangle { // #6717
		<502.5,485.95,1919.4>,
		<502.5,702.2,1919.4>,
		<502.5,485.95,1914.7>
  }
  triangle { // #6718
		<502.5,702.2,1914.7>,
		<502.5,485.95,1914.7>,
		<502.5,702.2,1919.4>
  }
  triangle { // #6719
		<500.9,485.95,1919.4>,
		<500.9,702.2,1919.4>,
		<502.5,485.95,1919.4>
  }
  triangle { // #6720
		<502.5,702.2,1919.4>,
		<502.5,485.95,1919.4>,
		<500.9,702.2,1919.4>
  }
  triangle { // #6721
		<500.9,485.95,1926.35>,
		<500.9,702.2,1926.35>,
		<500.9,485.95,1919.4>
  }
  triangle { // #6722
		<500.9,702.2,1919.4>,
		<500.9,485.95,1919.4>,
		<500.9,702.2,1926.35>
  }
  triangle { // #6723
		<502.5,485.95,1926.35>,
		<502.5,702.2,1926.35>,
		<500.9,485.95,1926.35>
  }
  triangle { // #6724
		<500.9,702.2,1926.35>,
		<500.9,485.95,1926.35>,
		<502.5,702.2,1926.35>
  }
  triangle { // #6725
		<502.5,485.95,1931.35>,
		<502.5,702.2,1931.35>,
		<502.5,485.95,1926.35>
  }
  triangle { // #6726
		<502.5,702.2,1926.35>,
		<502.5,485.95,1926.35>,
		<502.5,702.2,1931.35>
  }
  smooth_triangle { // #6727
		<510.05,485.95,1932.3>, <-0.124,-0.992,0>,
		<510.05,702.2,1932.3>, <-0.124,-0.992,0>,
		<502.5,485.95,1931.35>, <-0.062,-0.998,0>
  }
  smooth_triangle { // #6728
		<502.5,702.2,1931.35>, <-0.124,-0.992,0>,
		<502.5,485.95,1931.35>, <-0.062,-0.998,0>,
		<510.05,702.2,1932.3>, <-0.124,-0.992,0>
  }
  triangle { // #6729
		<413.55,485.95,1926.35>,
		<411.95,485.95,1919.4>,
		<413.55,485.95,1919.4>
  }
  triangle { // #6730
		<411.95,485.95,1914.7>,
		<404.4,485.95,1918.8>,
		<404.4,485.95,1913.75>
  }
  triangle { // #6731
		<411.95,485.95,1919.4>,
		<404.4,485.95,1918.8>,
		<411.95,485.95,1914.7>
  }
  triangle { // #6732
		<404.4,485.95,1918.8>,
		<411.95,485.95,1931.35>,
		<404.4,485.95,1932.3>
  }
  triangle { // #6733
		<404.4,485.95,1918.8>,
		<411.95,485.95,1926.35>,
		<411.95,485.95,1931.35>
  }
  triangle { // #6734
		<411.95,485.95,1919.4>,
		<411.95,485.95,1926.35>,
		<404.4,485.95,1918.8>
  }
  triangle { // #6735
		<411.95,485.95,1919.4>,
		<413.55,485.95,1926.35>,
		<411.95,485.95,1926.35>
  }
  triangle { // #6736
		<413.55,702.2,1919.4>,
		<411.95,702.2,1926.35>,
		<413.55,702.2,1926.35>
  }
  triangle { // #6737
		<404.4,702.2,1918.8>,
		<411.95,702.2,1914.7>,
		<404.4,702.2,1913.75>
  }
  triangle { // #6738
		<404.4,702.2,1918.8>,
		<411.95,702.2,1919.4>,
		<411.95,702.2,1914.7>
  }
  triangle { // #6739
		<411.95,702.2,1931.35>,
		<404.4,702.2,1918.8>,
		<404.4,702.2,1932.3>
  }
  triangle { // #6740
		<411.95,702.2,1926.35>,
		<404.4,702.2,1918.8>,
		<411.95,702.2,1931.35>
  }
  triangle { // #6741
		<411.95,702.2,1926.35>,
		<411.95,702.2,1919.4>,
		<404.4,702.2,1918.8>
  }
  triangle { // #6742
		<411.95,702.2,1926.35>,
		<413.55,702.2,1919.4>,
		<411.95,702.2,1919.4>
  }
  triangle { // #6743
		<404.4,485.95,1932.3>,
		<404.4,702.2,1918.8>,
		<404.4,485.95,1918.8>
  }
  triangle { // #6744
		<404.4,702.2,1918.8>,
		<404.4,485.95,1932.3>,
		<404.4,702.2,1932.3>
  }
  triangle { // #6745
		<404.4,485.95,1918.8>,
		<404.4,702.2,1913.75>,
		<404.4,485.95,1913.75>
  }
  triangle { // #6746
		<404.4,702.2,1913.75>,
		<404.4,485.95,1918.8>,
		<404.4,702.2,1918.8>
  }
  smooth_triangle { // #6747
		<404.4,485.95,1913.75>, <0.083,0.997,0>,
		<411.95,702.2,1914.7>, <0.124,0.992,0>,
		<411.95,485.95,1914.7>, <0.124,0.992,0>
  }
  smooth_triangle { // #6748
		<411.95,702.2,1914.7>, <0.124,0.992,0>,
		<404.4,485.95,1913.75>, <0.083,0.997,0>,
		<404.4,702.2,1913.75>, <0.124,0.992,0>
  }
  triangle { // #6749
		<411.95,485.95,1914.7>,
		<411.95,702.2,1919.4>,
		<411.95,485.95,1919.4>
  }
  triangle { // #6750
		<411.95,702.2,1919.4>,
		<411.95,485.95,1914.7>,
		<411.95,702.2,1914.7>
  }
  triangle { // #6751
		<411.95,485.95,1919.4>,
		<413.55,702.2,1919.4>,
		<413.55,485.95,1919.4>
  }
  triangle { // #6752
		<413.55,702.2,1919.4>,
		<411.95,485.95,1919.4>,
		<411.95,702.2,1919.4>
  }
  triangle { // #6753
		<413.55,485.95,1919.4>,
		<413.55,702.2,1926.35>,
		<413.55,485.95,1926.35>
  }
  triangle { // #6754
		<413.55,702.2,1926.35>,
		<413.55,485.95,1919.4>,
		<413.55,702.2,1919.4>
  }
  triangle { // #6755
		<413.55,485.95,1926.35>,
		<411.95,702.2,1926.35>,
		<411.95,485.95,1926.35>
  }
  triangle { // #6756
		<411.95,702.2,1926.35>,
		<413.55,485.95,1926.35>,
		<413.55,702.2,1926.35>
  }
  triangle { // #6757
		<411.95,485.95,1926.35>,
		<411.95,702.2,1931.35>,
		<411.95,485.95,1931.35>
  }
  triangle { // #6758
		<411.95,702.2,1931.35>,
		<411.95,485.95,1926.35>,
		<411.95,702.2,1926.35>
  }
  smooth_triangle { // #6759
		<411.95,485.95,1931.35>, <0.083,-0.997,0>,
		<404.4,702.2,1932.3>, <0.124,-0.992,0>,
		<404.4,485.95,1932.3>, <0.041,-0.999,0>
  }
  smooth_triangle { // #6760
		<404.4,702.2,1932.3>, <0.124,-0.992,0>,
		<411.95,485.95,1931.35>, <0.083,-0.997,0>,
		<411.95,702.2,1931.35>, <0.124,-0.992,0>
  }
  triangle { // #6761
		<400.65,485.95,1913.75>,
		<404.4,485.95,1932.3>,
		<400.65,485.95,1932.3>
  }
  triangle { // #6762
		<404.4,485.95,1932.3>,
		<400.65,485.95,1913.75>,
		<404.4,485.95,1913.75>
  }
  triangle { // #6763
		<400.65,802.8,1932.3>,
		<404.4,802.8,1913.75>,
		<400.65,802.8,1913.75>
  }
  triangle { // #6764
		<404.4,802.8,1913.75>,
		<400.65,802.8,1932.3>,
		<404.4,802.8,1932.3>
  }
  triangle { // #6765
		<400.65,485.95,1932.3>,
		<400.65,802.8,1913.75>,
		<400.65,485.95,1913.75>
  }
  triangle { // #6766
		<400.65,802.8,1913.75>,
		<400.65,485.95,1932.3>,
		<400.65,802.8,1932.3>
  }
  smooth_triangle { // #6767
		<400.65,485.95,1913.75>, <0,1,0>,
		<404.4,802.8,1913.75>, <0,1,0>,
		<404.4,485.95,1913.75>, <0.083,0.997,0>
  }
  triangle { // #6768
		<404.4,802.8,1913.75>,
		<400.65,485.95,1913.75>,
		<400.65,802.8,1913.75>
  }
  triangle { // #6769
		<404.4,485.95,1913.75>,
		<404.4,802.8,1932.3>,
		<404.4,485.95,1932.3>
  }
  smooth_triangle { // #6770
		<404.4,802.8,1932.3>, <1,0,0>,
		<404.4,485.95,1913.75>, <1,0.003,0>,
		<404.4,802.8,1913.75>, <0.993,-0.119,0>
  }
  smooth_triangle { // #6771
		<404.4,485.95,1932.3>, <0.041,-0.999,0>,
		<400.65,802.8,1932.3>, <0,-1,0>,
		<400.65,485.95,1932.3>, <0,-1,0>
  }
  smooth_triangle { // #6772
		<400.65,802.8,1932.3>, <0,-1,0>,
		<404.4,485.95,1932.3>, <0.041,-0.999,0>,
		<404.4,802.8,1932.3>, <0,-1,0>
  }
  triangle { // #6773
		<-409.05,485.95,1926.35>,
		<-401.5,485.95,1932>,
		<-409.05,485.95,1931.05>
  }
  triangle { // #6774
		<-401.5,485.95,1932>,
		<-409.05,485.95,1914.7>,
		<-401.5,485.95,1913.75>
  }
  triangle { // #6775
		<-401.5,485.95,1932>,
		<-409.05,485.95,1919.4>,
		<-409.05,485.95,1914.7>
  }
  triangle { // #6776
		<-410.65,485.95,1919.4>,
		<-409.05,485.95,1926.35>,
		<-410.65,485.95,1926.35>
  }
  triangle { // #6777
		<-409.05,485.95,1919.4>,
		<-409.05,485.95,1926.35>,
		<-410.65,485.95,1919.4>
  }
  triangle { // #6778
		<-401.5,485.95,1932>,
		<-409.05,485.95,1926.35>,
		<-409.05,485.95,1919.4>
  }
  triangle { // #6779
		<-401.5,702.2,1932>,
		<-409.05,702.2,1926.35>,
		<-409.05,702.2,1931.05>
  }
  triangle { // #6780
		<-409.05,702.2,1914.7>,
		<-401.5,702.2,1932>,
		<-401.5,702.2,1913.75>
  }
  triangle { // #6781
		<-409.05,702.2,1919.4>,
		<-401.5,702.2,1932>,
		<-409.05,702.2,1914.7>
  }
  triangle { // #6782
		<-410.65,702.2,1926.35>,
		<-409.05,702.2,1919.4>,
		<-410.65,702.2,1919.4>
  }
  triangle { // #6783
		<-409.05,702.2,1926.35>,
		<-409.05,702.2,1919.4>,
		<-410.65,702.2,1926.35>
  }
  triangle { // #6784
		<-409.05,702.2,1926.35>,
		<-401.5,702.2,1932>,
		<-409.05,702.2,1919.4>
  }
  smooth_triangle { // #6785
		<-409.05,485.95,1914.7>, <-0.124,0.992,0>,
		<-401.5,702.2,1913.75>, <-0.124,0.992,0>,
		<-401.5,485.95,1913.75>, <-0.041,0.999,0>
  }
  triangle { // #6786
		<-401.5,702.2,1913.75>,
		<-409.05,485.95,1914.7>,
		<-409.05,702.2,1914.7>
  }
  triangle { // #6787
		<-401.5,485.95,1913.75>,
		<-401.5,702.2,1932>,
		<-401.5,485.95,1932>
  }
  triangle { // #6788
		<-401.5,702.2,1932>,
		<-401.5,485.95,1913.75>,
		<-401.5,702.2,1913.75>
  }
  smooth_triangle { // #6789
		<-401.5,485.95,1932>, <-0.083,-0.997,0>,
		<-409.05,702.2,1931.05>, <-0.124,-0.992,0>,
		<-409.05,485.95,1931.05>, <-0.041,-0.999,0>
  }
  smooth_triangle { // #6790
		<-409.05,702.2,1931.05>, <-0.124,-0.992,0>,
		<-401.5,485.95,1932>, <-0.083,-0.997,0>,
		<-401.5,702.2,1932>, <-0.124,-0.992,0>
  }
  triangle { // #6791
		<-409.05,485.95,1931.05>,
		<-409.05,702.2,1926.35>,
		<-409.05,485.95,1926.35>
  }
  triangle { // #6792
		<-409.05,702.2,1926.35>,
		<-409.05,485.95,1931.05>,
		<-409.05,702.2,1931.05>
  }
  triangle { // #6793
		<-409.05,485.95,1926.35>,
		<-410.65,702.2,1926.35>,
		<-410.65,485.95,1926.35>
  }
  triangle { // #6794
		<-410.65,702.2,1926.35>,
		<-409.05,485.95,1926.35>,
		<-409.05,702.2,1926.35>
  }
  triangle { // #6795
		<-410.65,485.95,1926.35>,
		<-410.65,702.2,1919.4>,
		<-410.65,485.95,1919.4>
  }
  triangle { // #6796
		<-410.65,702.2,1919.4>,
		<-410.65,485.95,1926.35>,
		<-410.65,702.2,1926.35>
  }
  triangle { // #6797
		<-410.65,485.95,1919.4>,
		<-409.05,702.2,1919.4>,
		<-409.05,485.95,1919.4>
  }
  triangle { // #6798
		<-409.05,702.2,1919.4>,
		<-410.65,485.95,1919.4>,
		<-410.65,702.2,1919.4>
  }
  triangle { // #6799
		<-409.05,485.95,1919.4>,
		<-409.05,702.2,1914.7>,
		<-409.05,485.95,1914.7>
  }
  triangle { // #6800
		<-409.05,702.2,1914.7>,
		<-409.05,485.95,1919.4>,
		<-409.05,702.2,1919.4>
  }
  triangle { // #6801
		<-401.5,485.95,1913.75>,
		<-397.75,485.95,1932>,
		<-401.5,485.95,1932>
  }
  triangle { // #6802
		<-397.75,485.95,1932>,
		<-401.5,485.95,1913.75>,
		<-397.75,485.95,1913.75>
  }
  triangle { // #6803
		<-401.5,802.8,1913.75>,
		<-397.75,802.8,1932>,
		<-397.75,802.8,1913.75>
  }
  triangle { // #6804
		<-397.75,802.8,1932>,
		<-401.5,802.8,1913.75>,
		<-401.5,802.8,1932>
  }
  smooth_triangle { // #6805
		<-401.5,485.95,1932>, <-1,0,0>,
		<-401.5,802.8,1913.75>, <-0.995,-0.095,0>,
		<-401.5,485.95,1913.75>, <-1,0.004,0>
  }
  smooth_triangle { // #6806
		<-401.5,802.8,1913.75>, <-0.995,-0.095,0>,
		<-401.5,485.95,1932>, <-1,0,0>,
		<-401.5,802.8,1932>, <-1,0,0>
  }
  smooth_triangle { // #6807
		<-401.5,485.95,1913.75>, <-0.041,0.999,0>,
		<-397.75,802.8,1913.75>, <0,1,0>,
		<-397.75,485.95,1913.75>, <0,1,0>
  }
  smooth_triangle { // #6808
		<-397.75,802.8,1913.75>, <0,1,0>,
		<-401.5,485.95,1913.75>, <-0.041,0.999,0>,
		<-401.5,802.8,1913.75>, <0,1,0>
  }
  triangle { // #6809
		<-397.75,485.95,1913.75>,
		<-397.75,802.8,1932>,
		<-397.75,485.95,1932>
  }
  triangle { // #6810
		<-397.75,802.8,1932>,
		<-397.75,485.95,1913.75>,
		<-397.75,802.8,1913.75>
  }
  smooth_triangle { // #6811
		<-397.75,485.95,1932>, <0,-1,0>,
		<-401.5,802.8,1932>, <0,-1,0>,
		<-401.5,485.95,1932>, <-0.083,-0.997,0>
  }
  triangle { // #6812
		<-401.5,802.8,1932>,
		<-397.75,485.95,1932>,
		<-397.75,802.8,1932>
  }
  triangle { // #6813
		<-499.6,485.95,1931.05>,
		<-507.15,485.95,1932>,
		<-499.6,485.95,1926.35>
  }
  triangle { // #6814
		<-507.15,485.95,1913.75>,
		<-499.6,485.95,1914.7>,
		<-507.15,485.95,1932>
  }
  triangle { // #6815
		<-499.6,485.95,1914.7>,
		<-499.6,485.95,1919.4>,
		<-507.15,485.95,1932>
  }
  triangle { // #6816
		<-498,485.95,1926.35>,
		<-499.6,485.95,1926.35>,
		<-498,485.95,1919.4>
  }
  triangle { // #6817
		<-498,485.95,1919.4>,
		<-499.6,485.95,1926.35>,
		<-499.6,485.95,1919.4>
  }
  triangle { // #6818
		<-499.6,485.95,1919.4>,
		<-499.6,485.95,1926.35>,
		<-507.15,485.95,1932>
  }
  triangle { // #6819
		<-499.6,702.2,1931.05>,
		<-499.6,702.2,1926.35>,
		<-507.15,702.2,1932>
  }
  triangle { // #6820
		<-507.15,702.2,1913.75>,
		<-507.15,702.2,1932>,
		<-499.6,702.2,1914.7>
  }
  triangle { // #6821
		<-499.6,702.2,1914.7>,
		<-507.15,702.2,1932>,
		<-499.6,702.2,1919.4>
  }
  triangle { // #6822
		<-498,702.2,1919.4>,
		<-499.6,702.2,1919.4>,
		<-498,702.2,1926.35>
  }
  triangle { // #6823
		<-498,702.2,1926.35>,
		<-499.6,702.2,1919.4>,
		<-499.6,702.2,1926.35>
  }
  triangle { // #6824
		<-499.6,702.2,1919.4>,
		<-507.15,702.2,1932>,
		<-499.6,702.2,1926.35>
  }
  triangle { // #6825
		<-507.15,485.95,1913.75>,
		<-507.15,702.2,1913.75>,
		<-499.6,485.95,1914.7>
  }
  triangle { // #6826
		<-499.6,702.2,1914.7>,
		<-499.6,485.95,1914.7>,
		<-507.15,702.2,1913.75>
  }
  triangle { // #6827
		<-507.15,485.95,1932>,
		<-507.15,702.2,1932>,
		<-507.15,485.95,1913.75>
  }
  triangle { // #6828
		<-507.15,702.2,1913.75>,
		<-507.15,485.95,1913.75>,
		<-507.15,702.2,1932>
  }
  smooth_triangle { // #6829
		<-499.6,485.95,1931.05>, <0.062,-0.998,0>,
		<-499.6,702.2,1931.05>, <0.124,-0.992,0>,
		<-507.15,485.95,1932>, <0.124,-0.992,0>
  }
  triangle { // #6830
		<-507.15,702.2,1932>,
		<-507.15,485.95,1932>,
		<-499.6,702.2,1931.05>
  }
  triangle { // #6831
		<-499.6,485.95,1926.35>,
		<-499.6,702.2,1926.35>,
		<-499.6,485.95,1931.05>
  }
  triangle { // #6832
		<-499.6,702.2,1931.05>,
		<-499.6,485.95,1931.05>,
		<-499.6,702.2,1926.35>
  }
  triangle { // #6833
		<-498,485.95,1926.35>,
		<-498,702.2,1926.35>,
		<-499.6,485.95,1926.35>
  }
  triangle { // #6834
		<-499.6,702.2,1926.35>,
		<-499.6,485.95,1926.35>,
		<-498,702.2,1926.35>
  }
  triangle { // #6835
		<-498,485.95,1919.4>,
		<-498,702.2,1919.4>,
		<-498,485.95,1926.35>
  }
  triangle { // #6836
		<-498,702.2,1926.35>,
		<-498,485.95,1926.35>,
		<-498,702.2,1919.4>
  }
  triangle { // #6837
		<-499.6,485.95,1919.4>,
		<-499.6,702.2,1919.4>,
		<-498,485.95,1919.4>
  }
  triangle { // #6838
		<-498,702.2,1919.4>,
		<-498,485.95,1919.4>,
		<-499.6,702.2,1919.4>
  }
  triangle { // #6839
		<-499.6,485.95,1914.7>,
		<-499.6,702.2,1914.7>,
		<-499.6,485.95,1919.4>
  }
  triangle { // #6840
		<-499.6,702.2,1919.4>,
		<-499.6,485.95,1919.4>,
		<-499.6,702.2,1914.7>
  }
  triangle { // #6841
		<314.4,485.95,2119.35>,
		<318.2,485.95,2125.35>,
		<313.3,485.95,2120.5>
  }
  triangle { // #6842
		<309.95,485.95,2117.15>,
		<307.5,485.95,2125.35>,
		<303.95,485.95,2121.8>
  }
  triangle { // #6843
		<313.3,485.95,2120.5>,
		<307.5,485.95,2125.35>,
		<309.95,485.95,2117.15>
  }
  triangle { // #6844
		<307.5,485.95,2125.35>,
		<321.75,485.95,2128.95>,
		<317.05,485.95,2134.95>
  }
  triangle { // #6845
		<307.5,485.95,2125.35>,
		<318.2,485.95,2125.35>,
		<321.75,485.95,2128.95>
  }
  triangle { // #6846
		<313.3,485.95,2120.5>,
		<318.2,485.95,2125.35>,
		<307.5,485.95,2125.35>
  }
  triangle { // #6847
		<318.2,485.95,2125.35>,
		<314.4,485.95,2119.35>,
		<319.3,485.95,2124.25>
  }
  triangle { // #6848
		<314.4,702.2,2119.35>,
		<318.2,702.2,2125.35>,
		<319.3,702.2,2124.25>
  }
  triangle { // #6849
		<307.5,702.2,2125.35>,
		<309.95,702.2,2117.15>,
		<303.95,702.2,2121.8>
  }
  triangle { // #6850
		<307.5,702.2,2125.35>,
		<313.3,702.2,2120.5>,
		<309.95,702.2,2117.15>
  }
  triangle { // #6851
		<321.75,702.2,2128.95>,
		<307.5,702.2,2125.35>,
		<317.05,702.2,2134.95>
  }
  triangle { // #6852
		<318.2,702.2,2125.35>,
		<307.5,702.2,2125.35>,
		<321.75,702.2,2128.95>
  }
  triangle { // #6853
		<318.2,702.2,2125.35>,
		<313.3,702.2,2120.5>,
		<307.5,702.2,2125.35>
  }
  triangle { // #6854
		<318.2,702.2,2125.35>,
		<314.4,702.2,2119.35>,
		<313.3,702.2,2120.5>
  }
  triangle { // #6855
		<317.05,485.95,2134.95>,
		<307.5,702.2,2125.35>,
		<307.5,485.95,2125.35>
  }
  triangle { // #6856
		<307.5,702.2,2125.35>,
		<317.05,485.95,2134.95>,
		<317.05,702.2,2134.95>
  }
  triangle { // #6857
		<307.5,485.95,2125.35>,
		<303.95,702.2,2121.8>,
		<303.95,485.95,2121.8>
  }
  triangle { // #6858
		<303.95,702.2,2121.8>,
		<307.5,485.95,2125.35>,
		<307.5,702.2,2125.35>
  }
  triangle { // #6859
		<303.95,485.95,2121.8>,
		<309.95,702.2,2117.15>,
		<309.95,485.95,2117.15>
  }
  triangle { // #6860
		<309.95,702.2,2117.15>,
		<303.95,485.95,2121.8>,
		<303.95,702.2,2121.8>
  }
  triangle { // #6861
		<309.95,485.95,2117.15>,
		<313.3,702.2,2120.5>,
		<313.3,485.95,2120.5>
  }
  triangle { // #6862
		<313.3,702.2,2120.5>,
		<309.95,485.95,2117.15>,
		<309.95,702.2,2117.15>
  }
  triangle { // #6863
		<314.4,485.95,2119.35>,
		<313.3,702.2,2120.5>,
		<314.4,702.2,2119.35>
  }
  triangle { // #6864
		<313.3,702.2,2120.5>,
		<314.4,485.95,2119.35>,
		<313.3,485.95,2120.5>
  }
  triangle { // #6865
		<314.4,485.95,2119.35>,
		<319.3,702.2,2124.25>,
		<319.3,485.95,2124.25>
  }
  triangle { // #6866
		<319.3,702.2,2124.25>,
		<314.4,485.95,2119.35>,
		<314.4,702.2,2119.35>
  }
  triangle { // #6867
		<319.3,485.95,2124.25>,
		<318.2,702.2,2125.35>,
		<318.2,485.95,2125.35>
  }
  triangle { // #6868
		<318.2,702.2,2125.35>,
		<319.3,485.95,2124.25>,
		<319.3,702.2,2124.25>
  }
  triangle { // #6869
		<318.2,485.95,2125.35>,
		<321.75,702.2,2128.95>,
		<321.75,485.95,2128.95>
  }
  triangle { // #6870
		<321.75,702.2,2128.95>,
		<318.2,485.95,2125.35>,
		<318.2,702.2,2125.35>
  }
  smooth_triangle { // #6871
		<321.75,485.95,2128.95>, <0.75,-0.662,0>,
		<317.05,702.2,2134.95>, <0.789,-0.614,0>,
		<317.05,485.95,2134.95>, <0.789,-0.614,0>
  }
  smooth_triangle { // #6872
		<317.05,702.2,2134.95>, <0.789,-0.614,0>,
		<321.75,485.95,2128.95>, <0.75,-0.662,0>,
		<321.75,702.2,2128.95>, <0.789,-0.614,0>
  }
  triangle { // #6873
		<390.9,485.95,2046.95>,
		<386.4,485.95,2065.65>,
		<379.3,485.95,2058.55>
  }
  triangle { // #6874
		<400.65,485.95,1925.1>,
		<390.9,485.95,2046.95>,
		<390.9,485.95,1895.45>
  }
  triangle { // #6875
		<400.65,485.95,2051.45>,
		<390.9,485.95,2046.95>,
		<400.65,485.95,1925.1>
  }
  triangle { // #6876
		<386.4,485.95,2065.65>,
		<390.9,485.95,2046.95>,
		<400.65,485.95,2051.45>
  }
  triangle { // #6877
		<386.4,802.8,2065.65>,
		<390.9,802.8,2046.95>,
		<379.3,802.8,2058.55>
  }
  triangle { // #6878
		<390.9,802.8,2046.95>,
		<400.65,802.8,1925.1>,
		<390.9,802.8,1895.45>
  }
  triangle { // #6879
		<390.9,802.8,2046.95>,
		<400.65,802.8,2051.45>,
		<400.65,802.8,1925.1>
  }
  triangle { // #6880
		<390.9,802.8,2046.95>,
		<386.4,802.8,2065.65>,
		<400.65,802.8,2051.45>
  }
  triangle { // #6881
		<400.65,485.95,2051.45>,
		<386.4,802.8,2065.65>,
		<386.4,485.95,2065.65>
  }
  triangle { // #6882
		<386.4,802.8,2065.65>,
		<400.65,485.95,2051.45>,
		<400.65,802.8,2051.45>
  }
  triangle { // #6883
		<386.4,485.95,2065.65>,
		<379.3,802.8,2058.55>,
		<379.3,485.95,2058.55>
  }
  triangle { // #6884
		<379.3,802.8,2058.55>,
		<386.4,485.95,2065.65>,
		<386.4,802.8,2065.65>
  }
  smooth_triangle { // #6885
		<379.3,485.95,2058.55>, <-0.708,0.706,0>,
		<390.9,802.8,2046.95>, <-0.863,0.505,0>,
		<390.9,485.95,2046.95>, <-0.968,0.252,0>
  }
  smooth_triangle { // #6886
		<390.9,802.8,2046.95>, <-0.863,0.505,0>,
		<379.3,485.95,2058.55>, <-0.708,0.706,0>,
		<379.3,802.8,2058.55>, <-0.708,0.706,0>
  }
  smooth_triangle { // #6887
		<390.9,485.95,2046.95>, <-0.968,0.252,0>,
		<390.9,802.8,1895.45>, <-1,0,0>,
		<390.9,485.95,1895.45>, <-1,0,0>
  }
  smooth_triangle { // #6888
		<390.9,802.8,1895.45>, <-1,0,0>,
		<390.9,485.95,2046.95>, <-0.968,0.252,0>,
		<390.9,802.8,2046.95>, <-0.863,0.505,0>
  }
  smooth_triangle { // #6889
		<390.9,485.95,1895.45>, <0.95,0.312,0>,
		<400.65,802.8,1925.1>, <0.997,0.08,0>,
		<400.65,485.95,1925.1>, <0.998,-0.066,0>
  }
  smooth_triangle { // #6890
		<400.65,802.8,1925.1>, <0.997,0.08,0>,
		<390.9,485.95,1895.45>, <0.95,0.312,0>,
		<390.9,802.8,1895.45>, <0.95,0.312,0>
  }
  smooth_triangle { // #6891
		<400.65,485.95,1925.1>, <0.998,-0.066,0>,
		<400.65,802.8,2051.45>, <1,0,0>,
		<400.65,485.95,2051.45>, <1,0,0>
  }
  smooth_triangle { // #6892
		<400.65,802.8,2051.45>, <1,0,0>,
		<400.65,485.95,1925.1>, <0.998,-0.066,0>,
		<400.65,802.8,1925.1>, <0.997,0.08,0>
  }
  triangle { // #6893
		<386.4,702.2,2065.65>,
		<310.1,702.2,2128.05>,
		<379.3,702.2,2058.55>
  }
  triangle { // #6894
		<310.1,702.2,2128.05>,
		<386.4,702.2,2065.65>,
		<317.05,702.2,2135>
  }
  triangle { // #6895
		<386.4,802.8,2065.65>,
		<310.1,802.8,2128.05>,
		<317.05,802.8,2135>
  }
  triangle { // #6896
		<310.1,802.8,2128.05>,
		<386.4,802.8,2065.65>,
		<379.3,802.8,2058.55>
  }
  triangle { // #6897
		<379.3,702.2,2058.55>,
		<386.4,802.8,2065.65>,
		<386.4,702.2,2065.65>
  }
  triangle { // #6898
		<386.4,802.8,2065.65>,
		<379.3,702.2,2058.55>,
		<379.3,802.8,2058.55>
  }
  triangle { // #6899
		<386.4,702.2,2065.65>,
		<317.05,802.8,2135>,
		<317.05,702.2,2135>
  }
  triangle { // #6900
		<317.05,802.8,2135>,
		<386.4,702.2,2065.65>,
		<386.4,802.8,2065.65>
  }
  triangle { // #6901
		<317.05,702.2,2135>,
		<310.1,802.8,2128.05>,
		<310.1,702.2,2128.05>
  }
  triangle { // #6902
		<310.1,802.8,2128.05>,
		<317.05,702.2,2135>,
		<317.05,802.8,2135>
  }
  triangle { // #6903
		<310.1,702.2,2128.05>,
		<379.3,802.8,2058.55>,
		<379.3,702.2,2058.55>
  }
  triangle { // #6904
		<379.3,802.8,2058.55>,
		<310.1,702.2,2128.05>,
		<310.1,802.8,2128.05>
  }
  triangle { // #6905
		<-376.35,485.95,2058.5>,
		<-383.5,485.95,2065.65>,
		<-387.7,485.95,2047.25>
  }
  triangle { // #6906
		<-387.7,485.95,1904.55>,
		<-387.7,485.95,2047.25>,
		<-397.75,485.95,1925.1>
  }
  triangle { // #6907
		<-397.75,485.95,1925.1>,
		<-387.7,485.95,2047.25>,
		<-397.75,485.95,2051.45>
  }
  triangle { // #6908
		<-397.75,485.95,2051.45>,
		<-387.7,485.95,2047.25>,
		<-383.5,485.95,2065.65>
  }
  triangle { // #6909
		<-376.35,802.8,2058.5>,
		<-387.7,802.8,2047.25>,
		<-383.5,802.8,2065.65>
  }
  triangle { // #6910
		<-387.7,802.8,1904.55>,
		<-397.75,802.8,1925.1>,
		<-387.7,802.8,2047.25>
  }
  triangle { // #6911
		<-397.75,802.8,1925.1>,
		<-397.75,802.8,2051.45>,
		<-387.7,802.8,2047.25>
  }
  triangle { // #6912
		<-397.75,802.8,2051.45>,
		<-383.5,802.8,2065.65>,
		<-387.7,802.8,2047.25>
  }
  triangle { // #6913
		<-383.5,485.95,2065.65>,
		<-383.5,802.8,2065.65>,
		<-397.75,485.95,2051.45>
  }
  triangle { // #6914
		<-397.75,802.8,2051.45>,
		<-397.75,485.95,2051.45>,
		<-383.5,802.8,2065.65>
  }
  triangle { // #6915
		<-376.35,485.95,2058.5>,
		<-376.35,802.8,2058.5>,
		<-383.5,485.95,2065.65>
  }
  triangle { // #6916
		<-383.5,802.8,2065.65>,
		<-383.5,485.95,2065.65>,
		<-376.35,802.8,2058.5>
  }
  triangle { // #6917
		<-387.7,485.95,2047.25>,
		<-387.7,802.8,2047.25>,
		<-376.35,485.95,2058.5>
  }
  triangle { // #6918
		<-376.35,802.8,2058.5>,
		<-376.35,485.95,2058.5>,
		<-387.7,802.8,2047.25>
  }
  triangle { // #6919
		<-387.7,485.95,1904.55>,
		<-387.7,802.8,1904.55>,
		<-387.7,485.95,2047.25>
  }
  triangle { // #6920
		<-387.7,802.8,2047.25>,
		<-387.7,485.95,2047.25>,
		<-387.7,802.8,1904.55>
  }
  smooth_triangle { // #6921
		<-397.75,485.95,1925.1>, <-0.999,-0.04,0>,
		<-397.75,802.8,1925.1>, <-0.989,0.148,0>,
		<-387.7,485.95,1904.55>, <-0.898,0.439,0>
  }
  smooth_triangle { // #6922
		<-387.7,802.8,1904.55>, <-0.898,0.439,0>,
		<-387.7,485.95,1904.55>, <-0.898,0.439,0>,
		<-397.75,802.8,1925.1>, <-0.989,0.148,0>
  }
  smooth_triangle { // #6923
		<-397.75,485.95,2051.45>, <-1,0,0>,
		<-397.75,802.8,2051.45>, <-1,0,0>,
		<-397.75,485.95,1925.1>, <-0.999,-0.04,0>
  }
  smooth_triangle { // #6924
		<-397.75,802.8,1925.1>, <-0.989,0.148,0>,
		<-397.75,485.95,1925.1>, <-0.999,-0.04,0>,
		<-397.75,802.8,2051.45>, <-1,0,0>
  }
  triangle { // #6925
		<-376.35,702.2,2058.5>,
		<-307.5,702.2,2128.35>,
		<-383.5,702.2,2065.65>
  }
  triangle { // #6926
		<-314.15,702.2,2135>,
		<-383.5,702.2,2065.65>,
		<-307.5,702.2,2128.35>
  }
  triangle { // #6927
		<-314.15,802.8,2135>,
		<-307.5,802.8,2128.35>,
		<-383.5,802.8,2065.65>
  }
  triangle { // #6928
		<-376.35,802.8,2058.5>,
		<-383.5,802.8,2065.65>,
		<-307.5,802.8,2128.35>
  }
  triangle { // #6929
		<-383.5,702.2,2065.65>,
		<-383.5,802.8,2065.65>,
		<-376.35,702.2,2058.5>
  }
  triangle { // #6930
		<-376.35,802.8,2058.5>,
		<-376.35,702.2,2058.5>,
		<-383.5,802.8,2065.65>
  }
  triangle { // #6931
		<-314.15,702.2,2135>,
		<-314.15,802.8,2135>,
		<-383.5,702.2,2065.65>
  }
  triangle { // #6932
		<-383.5,802.8,2065.65>,
		<-383.5,702.2,2065.65>,
		<-314.15,802.8,2135>
  }
  triangle { // #6933
		<-307.5,702.2,2128.35>,
		<-307.5,802.8,2128.35>,
		<-314.15,702.2,2135>
  }
  triangle { // #6934
		<-314.15,802.8,2135>,
		<-314.15,702.2,2135>,
		<-307.5,802.8,2128.35>
  }
  triangle { // #6935
		<-376.35,702.2,2058.5>,
		<-376.35,802.8,2058.5>,
		<-307.5,702.2,2128.35>
  }
  triangle { // #6936
		<-307.5,802.8,2128.35>,
		<-307.5,702.2,2128.35>,
		<-376.35,802.8,2058.5>
  }
  triangle { // #6937
		<310.1,485.95,2128.05>,
		<317.05,485.95,2135>,
		<298.9,485.95,2138.95>
  }
  triangle { // #6938
		<-314.15,485.95,2135>,
		<-307.5,485.95,2128.35>,
		<-299.95,485.95,2149.25>
  }
  triangle { // #6939
		<-307.5,485.95,2128.35>,
		<-296.6,485.95,2139.2>,
		<-299.95,485.95,2149.25>
  }
  triangle { // #6940
		<-299.95,485.95,2149.25>,
		<-296.6,485.95,2139.2>,
		<302.85,485.95,2149.25>
  }
  triangle { // #6941
		<-296.6,485.95,2139.2>,
		<298.9,485.95,2138.95>,
		<302.85,485.95,2149.25>
  }
  triangle { // #6942
		<302.85,485.95,2149.25>,
		<298.9,485.95,2138.95>,
		<317.05,485.95,2135>
  }
  triangle { // #6943
		<310.1,802.8,2128.05>,
		<298.9,802.8,2138.95>,
		<317.05,802.8,2135>
  }
  triangle { // #6944
		<-314.15,802.8,2135>,
		<-299.95,802.8,2149.25>,
		<-307.5,802.8,2128.35>
  }
  triangle { // #6945
		<-307.5,802.8,2128.35>,
		<-299.95,802.8,2149.25>,
		<-296.6,802.8,2139.2>
  }
  triangle { // #6946
		<-299.95,802.8,2149.25>,
		<302.85,802.8,2149.25>,
		<-296.6,802.8,2139.2>
  }
  triangle { // #6947
		<-296.6,802.8,2139.2>,
		<302.85,802.8,2149.25>,
		<298.9,802.8,2138.95>
  }
  triangle { // #6948
		<302.85,802.8,2149.25>,
		<317.05,802.8,2135>,
		<298.9,802.8,2138.95>
  }
  triangle { // #6949
		<-314.15,485.95,2135>,
		<-314.15,802.8,2135>,
		<-307.5,485.95,2128.35>
  }
  triangle { // #6950
		<-307.5,802.8,2128.35>,
		<-307.5,485.95,2128.35>,
		<-314.15,802.8,2135>
  }
  triangle { // #6951
		<-299.95,485.95,2149.25>,
		<-299.95,802.8,2149.25>,
		<-314.15,485.95,2135>
  }
  triangle { // #6952
		<-314.15,802.8,2135>,
		<-314.15,485.95,2135>,
		<-299.95,802.8,2149.25>
  }
  triangle { // #6953
		<302.85,485.95,2149.25>,
		<302.85,802.8,2149.25>,
		<-299.95,485.95,2149.25>
  }
  triangle { // #6954
		<-299.95,802.8,2149.25>,
		<-299.95,485.95,2149.25>,
		<302.85,802.8,2149.25>
  }
  triangle { // #6955
		<317.05,485.95,2135>,
		<317.05,802.8,2135>,
		<302.85,485.95,2149.25>
  }
  smooth_triangle { // #6956
		<302.85,802.8,2149.25>, <0.253,-0.968,-0>,
		<302.85,485.95,2149.25>, <0.505,-0.863,0>,
		<317.05,802.8,2135>, <0.707,-0.707,0>
  }
  triangle { // #6957
		<310.1,485.95,2128.05>,
		<310.1,802.8,2128.05>,
		<317.05,485.95,2135>
  }
  triangle { // #6958
		<317.05,802.8,2135>,
		<317.05,485.95,2135>,
		<310.1,802.8,2128.05>
  }
  smooth_triangle { // #6959
		<298.9,485.95,2138.95>, <-0.249,0.968,0>,
		<298.9,802.8,2138.95>, <-0.498,0.867,0>,
		<310.1,485.95,2128.05>, <-0.698,0.716,0>
  }
  smooth_triangle { // #6960
		<310.1,802.8,2128.05>, <-0.698,0.716,0>,
		<310.1,485.95,2128.05>, <-0.698,0.716,0>,
		<298.9,802.8,2138.95>, <-0.498,0.867,0>
  }
  triangle { // #6961
		<-296.6,485.95,2139.2>,
		<-296.6,802.8,2139.2>,
		<298.9,485.95,2138.95>
  }
  triangle { // #6962
		<298.9,802.8,2138.95>,
		<298.9,485.95,2138.95>,
		<-296.6,802.8,2139.2>
  }
  smooth_triangle { // #6963
		<-307.5,485.95,2128.35>, <0.705,0.71,0>,
		<-307.5,802.8,2128.35>, <0.705,0.71,0>,
		<-296.6,485.95,2139.2>, <0.503,0.864,0>
  }
  smooth_triangle { // #6964
		<-296.6,802.8,2139.2>, <0.251,0.968,0>,
		<-296.6,485.95,2139.2>, <0.503,0.864,0>,
		<-307.5,802.8,2128.35>, <0.705,0.71,0>
  }
  triangle { // #6965
		<370.8,485.95,2062.95>,
		<371.95,485.95,2061.85>,
		<375.7,485.95,2067.85>
  }
  triangle { // #6966
		<373.25,485.95,2052.5>,
		<376.8,485.95,2056.05>,
		<368.6,485.95,2058.5>
  }
  triangle { // #6967
		<368.6,485.95,2058.5>,
		<376.8,485.95,2056.05>,
		<371.95,485.95,2061.85>
  }
  triangle { // #6968
		<386.4,485.95,2065.6>,
		<380.35,485.95,2070.3>,
		<376.8,485.95,2056.05>
  }
  triangle { // #6969
		<380.35,485.95,2070.3>,
		<376.8,485.95,2066.75>,
		<376.8,485.95,2056.05>
  }
  triangle { // #6970
		<376.8,485.95,2056.05>,
		<376.8,485.95,2066.75>,
		<371.95,485.95,2061.85>
  }
  triangle { // #6971
		<376.8,485.95,2066.75>,
		<375.7,485.95,2067.85>,
		<371.95,485.95,2061.85>
  }
  triangle { // #6972
		<375.7,702.2,2067.85>,
		<376.8,702.2,2066.75>,
		<370.8,702.2,2062.95>
  }
  triangle { // #6973
		<373.25,702.2,2052.5>,
		<368.6,702.2,2058.5>,
		<376.8,702.2,2056.05>
  }
  triangle { // #6974
		<368.6,702.2,2058.5>,
		<371.95,702.2,2061.85>,
		<376.8,702.2,2056.05>
  }
  triangle { // #6975
		<386.4,702.2,2065.6>,
		<376.8,702.2,2056.05>,
		<380.35,702.2,2070.3>
  }
  triangle { // #6976
		<380.35,702.2,2070.3>,
		<376.8,702.2,2056.05>,
		<376.8,702.2,2066.75>
  }
  triangle { // #6977
		<376.8,702.2,2056.05>,
		<371.95,702.2,2061.85>,
		<376.8,702.2,2066.75>
  }
  triangle { // #6978
		<371.95,702.2,2061.85>,
		<370.8,702.2,2062.95>,
		<376.8,702.2,2066.75>
  }
  triangle { // #6979
		<376.8,485.95,2056.05>,
		<376.8,702.2,2056.05>,
		<386.4,485.95,2065.6>
  }
  triangle { // #6980
		<386.4,702.2,2065.6>,
		<386.4,485.95,2065.6>,
		<376.8,702.2,2056.05>
  }
  triangle { // #6981
		<373.25,485.95,2052.5>,
		<373.25,702.2,2052.5>,
		<376.8,485.95,2056.05>
  }
  triangle { // #6982
		<376.8,702.2,2056.05>,
		<376.8,485.95,2056.05>,
		<373.25,702.2,2052.5>
  }
  triangle { // #6983
		<368.6,485.95,2058.5>,
		<368.6,702.2,2058.5>,
		<373.25,485.95,2052.5>
  }
  triangle { // #6984
		<373.25,702.2,2052.5>,
		<373.25,485.95,2052.5>,
		<368.6,702.2,2058.5>
  }
  triangle { // #6985
		<371.95,485.95,2061.85>,
		<371.95,702.2,2061.85>,
		<368.6,485.95,2058.5>
  }
  triangle { // #6986
		<368.6,702.2,2058.5>,
		<368.6,485.95,2058.5>,
		<371.95,702.2,2061.85>
  }
  triangle { // #6987
		<370.8,485.95,2062.95>,
		<370.8,702.2,2062.95>,
		<371.95,485.95,2061.85>
  }
  triangle { // #6988
		<371.95,702.2,2061.85>,
		<371.95,485.95,2061.85>,
		<370.8,702.2,2062.95>
  }
  triangle { // #6989
		<375.7,485.95,2067.85>,
		<375.7,702.2,2067.85>,
		<370.8,485.95,2062.95>
  }
  triangle { // #6990
		<370.8,702.2,2062.95>,
		<370.8,485.95,2062.95>,
		<375.7,702.2,2067.85>
  }
  triangle { // #6991
		<376.8,485.95,2066.75>,
		<376.8,702.2,2066.75>,
		<375.7,485.95,2067.85>
  }
  triangle { // #6992
		<375.7,702.2,2067.85>,
		<375.7,485.95,2067.85>,
		<376.8,702.2,2066.75>
  }
  triangle { // #6993
		<380.35,485.95,2070.3>,
		<380.35,702.2,2070.3>,
		<376.8,485.95,2066.75>
  }
  triangle { // #6994
		<376.8,702.2,2066.75>,
		<376.8,485.95,2066.75>,
		<380.35,702.2,2070.3>
  }
  smooth_triangle { // #6995
		<386.4,485.95,2065.6>, <0.614,-0.789,0>,
		<386.4,702.2,2065.6>, <0.614,-0.789,0>,
		<380.35,485.95,2070.3>, <0.646,-0.763,0>
  }
  smooth_triangle { // #6996
		<380.35,702.2,2070.3>, <0.614,-0.789,0>,
		<380.35,485.95,2070.3>, <0.646,-0.763,0>,
		<386.4,702.2,2065.6>, <0.614,-0.789,0>
  }
  triangle { // #6997
		<-377.35,485.95,2070.35>,
		<-383.35,485.95,2065.65>,
		<-374.05,485.95,2067>
  }
  triangle { // #6998
		<-370.5,485.95,2052.75>,
		<-365.8,485.95,2058.8>,
		<-383.35,485.95,2065.65>
  }
  triangle { // #6999
		<-365.8,485.95,2058.8>,
		<-369.15,485.95,2062.1>,
		<-383.35,485.95,2065.65>
  }
  triangle { // #7000
		<-368.05,485.95,2063.2>,
		<-372.9,485.95,2068.1>,
		<-369.15,485.95,2062.1>
  }
  triangle { // #7001
		<-372.9,485.95,2068.1>,
		<-374.05,485.95,2067>,
		<-369.15,485.95,2062.1>
  }
  triangle { // #7002
		<-369.15,485.95,2062.1>,
		<-374.05,485.95,2067>,
		<-383.35,485.95,2065.65>
  }
  triangle { // #7003
		<-377.35,702.2,2070.35>,
		<-374.05,702.2,2067>,
		<-383.35,702.2,2065.65>
  }
  triangle { // #7004
		<-370.5,702.2,2052.75>,
		<-383.35,702.2,2065.65>,
		<-365.8,702.2,2058.8>
  }
  triangle { // #7005
		<-365.8,702.2,2058.8>,
		<-383.35,702.2,2065.65>,
		<-369.15,702.2,2062.1>
  }
  triangle { // #7006
		<-368.05,702.2,2063.2>,
		<-369.15,702.2,2062.1>,
		<-372.9,702.2,2068.1>
  }
  triangle { // #7007
		<-372.9,702.2,2068.1>,
		<-369.15,702.2,2062.1>,
		<-374.05,702.2,2067>
  }
  triangle { // #7008
		<-369.15,702.2,2062.1>,
		<-383.35,702.2,2065.65>,
		<-374.05,702.2,2067>
  }
  triangle { // #7009
		<-370.5,485.95,2052.75>,
		<-370.5,702.2,2052.75>,
		<-365.8,485.95,2058.8>
  }
  triangle { // #7010
		<-365.8,702.2,2058.8>,
		<-365.8,485.95,2058.8>,
		<-370.5,702.2,2052.75>
  }
  triangle { // #7011
		<-383.35,485.95,2065.65>,
		<-383.35,702.2,2065.65>,
		<-370.5,485.95,2052.75>
  }
  triangle { // #7012
		<-370.5,702.2,2052.75>,
		<-370.5,485.95,2052.75>,
		<-383.35,702.2,2065.65>
  }
  smooth_triangle { // #7013
		<-377.35,485.95,2070.35>, <-0.662,-0.75,0>,
		<-377.35,702.2,2070.35>, <-0.614,-0.789,0>,
		<-383.35,485.95,2065.65>, <-0.614,-0.789,0>
  }
  triangle { // #7014
		<-383.35,702.2,2065.65>,
		<-383.35,485.95,2065.65>,
		<-377.35,702.2,2070.35>
  }
  triangle { // #7015
		<-374.05,485.95,2067>,
		<-374.05,702.2,2067>,
		<-377.35,485.95,2070.35>
  }
  triangle { // #7016
		<-377.35,702.2,2070.35>,
		<-377.35,485.95,2070.35>,
		<-374.05,702.2,2067>
  }
  triangle { // #7017
		<-372.9,485.95,2068.1>,
		<-372.9,702.2,2068.1>,
		<-374.05,485.95,2067>
  }
  triangle { // #7018
		<-374.05,702.2,2067>,
		<-374.05,485.95,2067>,
		<-372.9,702.2,2068.1>
  }
  triangle { // #7019
		<-368.05,485.95,2063.2>,
		<-368.05,702.2,2063.2>,
		<-372.9,485.95,2068.1>
  }
  triangle { // #7020
		<-372.9,702.2,2068.1>,
		<-372.9,485.95,2068.1>,
		<-368.05,702.2,2063.2>
  }
  triangle { // #7021
		<-369.15,485.95,2062.1>,
		<-369.15,702.2,2062.1>,
		<-368.05,485.95,2063.2>
  }
  triangle { // #7022
		<-368.05,702.2,2063.2>,
		<-368.05,485.95,2063.2>,
		<-369.15,702.2,2062.1>
  }
  triangle { // #7023
		<-365.8,485.95,2058.8>,
		<-365.8,702.2,2058.8>,
		<-369.15,485.95,2062.1>
  }
  triangle { // #7024
		<-369.15,702.2,2062.1>,
		<-369.15,485.95,2062.1>,
		<-365.8,702.2,2058.8>
  }
  triangle { // #7025
		<-315.4,485.95,2125.65>,
		<-314.05,485.95,2135>,
		<-318.7,485.95,2129>
  }
  triangle { // #7026
		<-314.05,485.95,2135>,
		<-307.15,485.95,2117.4>,
		<-301.15,485.95,2122.1>
  }
  triangle { // #7027
		<-314.05,485.95,2135>,
		<-310.5,485.95,2120.75>,
		<-307.15,485.95,2117.4>
  }
  triangle { // #7028
		<-311.6,485.95,2119.65>,
		<-315.4,485.95,2125.65>,
		<-316.5,485.95,2124.55>
  }
  triangle { // #7029
		<-310.5,485.95,2120.75>,
		<-315.4,485.95,2125.65>,
		<-311.6,485.95,2119.65>
  }
  triangle { // #7030
		<-314.05,485.95,2135>,
		<-315.4,485.95,2125.65>,
		<-310.5,485.95,2120.75>
  }
  triangle { // #7031
		<-314.05,702.2,2135>,
		<-315.4,702.2,2125.65>,
		<-318.7,702.2,2129>
  }
  triangle { // #7032
		<-307.15,702.2,2117.4>,
		<-314.05,702.2,2135>,
		<-301.15,702.2,2122.1>
  }
  triangle { // #7033
		<-310.5,702.2,2120.75>,
		<-314.05,702.2,2135>,
		<-307.15,702.2,2117.4>
  }
  triangle { // #7034
		<-316.5,702.2,2124.55>,
		<-310.5,702.2,2120.75>,
		<-311.6,702.2,2119.65>
  }
  triangle { // #7035
		<-315.4,702.2,2125.65>,
		<-310.5,702.2,2120.75>,
		<-316.5,702.2,2124.55>
  }
  triangle { // #7036
		<-315.4,702.2,2125.65>,
		<-314.05,702.2,2135>,
		<-310.5,702.2,2120.75>
  }
  triangle { // #7037
		<-307.15,485.95,2117.4>,
		<-301.15,702.2,2122.1>,
		<-301.15,485.95,2122.1>
  }
  triangle { // #7038
		<-301.15,702.2,2122.1>,
		<-307.15,485.95,2117.4>,
		<-307.15,702.2,2117.4>
  }
  triangle { // #7039
		<-301.15,485.95,2122.1>,
		<-314.05,702.2,2135>,
		<-314.05,485.95,2135>
  }
  triangle { // #7040
		<-314.05,702.2,2135>,
		<-301.15,485.95,2122.1>,
		<-301.15,702.2,2122.1>
  }
  smooth_triangle { // #7041
		<-314.05,485.95,2135>, <-0.789,-0.614,0>,
		<-318.7,702.2,2129>, <-0.789,-0.614,0>,
		<-318.7,485.95,2129>, <-0.736,-0.677,0>
  }
  triangle { // #7042
		<-318.7,702.2,2129>,
		<-314.05,485.95,2135>,
		<-314.05,702.2,2135>
  }
  triangle { // #7043
		<-318.7,485.95,2129>,
		<-315.4,702.2,2125.65>,
		<-315.4,485.95,2125.65>
  }
  triangle { // #7044
		<-315.4,702.2,2125.65>,
		<-318.7,485.95,2129>,
		<-318.7,702.2,2129>
  }
  triangle { // #7045
		<-315.4,485.95,2125.65>,
		<-316.5,702.2,2124.55>,
		<-316.5,485.95,2124.55>
  }
  triangle { // #7046
		<-316.5,702.2,2124.55>,
		<-315.4,485.95,2125.65>,
		<-315.4,702.2,2125.65>
  }
  triangle { // #7047
		<-316.5,485.95,2124.55>,
		<-311.6,702.2,2119.65>,
		<-311.6,485.95,2119.65>
  }
  triangle { // #7048
		<-311.6,702.2,2119.65>,
		<-316.5,485.95,2124.55>,
		<-316.5,702.2,2124.55>
  }
  triangle { // #7049
		<-311.6,485.95,2119.65>,
		<-310.5,702.2,2120.75>,
		<-310.5,485.95,2120.75>
  }
  triangle { // #7050
		<-310.5,702.2,2120.75>,
		<-311.6,485.95,2119.65>,
		<-311.6,702.2,2119.65>
  }
  triangle { // #7051
		<-310.5,485.95,2120.75>,
		<-307.15,702.2,2117.4>,
		<-307.15,485.95,2117.4>
  }
  triangle { // #7052
		<-307.15,702.2,2117.4>,
		<-310.5,485.95,2120.75>,
		<-310.5,702.2,2120.75>
  }
  triangle { // #7053
		<404.4,693.1,1926.35>,
		<404.4,694.65,1919.4>,
		<404.4,693.1,1919.4>
  }
  triangle { // #7054
		<404.4,694.65,1914.7>,
		<404.4,702.2,1918.8>,
		<404.4,702.2,1913.75>
  }
  triangle { // #7055
		<404.4,694.65,1919.4>,
		<404.4,702.2,1918.8>,
		<404.4,694.65,1914.7>
  }
  triangle { // #7056
		<404.4,702.2,1918.8>,
		<404.4,694.65,1931.35>,
		<404.4,702.2,1932.3>
  }
  triangle { // #7057
		<404.4,702.2,1918.8>,
		<404.4,694.65,1926.35>,
		<404.4,694.65,1931.35>
  }
  triangle { // #7058
		<404.4,694.65,1919.4>,
		<404.4,694.65,1926.35>,
		<404.4,702.2,1918.8>
  }
  triangle { // #7059
		<404.4,694.65,1919.4>,
		<404.4,693.1,1926.35>,
		<404.4,694.65,1926.35>
  }
  triangle { // #7060
		<510.05,693.1,1919.4>,
		<510.05,694.65,1926.35>,
		<510.05,693.1,1926.35>
  }
  triangle { // #7061
		<510.05,702.2,1918.8>,
		<510.05,694.65,1914.7>,
		<510.05,702.2,1913.75>
  }
  triangle { // #7062
		<510.05,702.2,1918.8>,
		<510.05,694.65,1919.4>,
		<510.05,694.65,1914.7>
  }
  triangle { // #7063
		<510.05,694.65,1931.35>,
		<510.05,702.2,1918.8>,
		<510.05,702.2,1932.3>
  }
  triangle { // #7064
		<510.05,694.65,1926.35>,
		<510.05,702.2,1918.8>,
		<510.05,694.65,1931.35>
  }
  triangle { // #7065
		<510.05,694.65,1926.35>,
		<510.05,694.65,1919.4>,
		<510.05,702.2,1918.8>
  }
  triangle { // #7066
		<510.05,694.65,1926.35>,
		<510.05,693.1,1919.4>,
		<510.05,694.65,1919.4>
  }
  triangle { // #7067
		<404.4,702.2,1932.3>,
		<510.05,702.2,1918.8>,
		<404.4,702.2,1918.8>
  }
  triangle { // #7068
		<510.05,702.2,1918.8>,
		<404.4,702.2,1932.3>,
		<510.05,702.2,1932.3>
  }
  triangle { // #7069
		<404.4,702.2,1918.8>,
		<510.05,702.2,1913.75>,
		<404.4,702.2,1913.75>
  }
  triangle { // #7070
		<510.05,702.2,1913.75>,
		<404.4,702.2,1918.8>,
		<510.05,702.2,1918.8>
  }
  smooth_triangle { // #7071
		<404.4,702.2,1913.75>, <0.041,0.996,-0.083>,
		<510.05,694.65,1914.7>, <0,0.992,-0.124>,
		<404.4,694.65,1914.7>, <0,0.992,-0.124>
  }
  smooth_triangle { // #7072
		<510.05,694.65,1914.7>, <0,0.992,-0.124>,
		<404.4,702.2,1913.75>, <0.041,0.996,-0.083>,
		<510.05,702.2,1913.75>, <-0.062,0.996,-0.062>
  }
  triangle { // #7073
		<404.4,694.65,1914.7>,
		<510.05,694.65,1919.4>,
		<404.4,694.65,1919.4>
  }
  triangle { // #7074
		<510.05,694.65,1919.4>,
		<404.4,694.65,1914.7>,
		<510.05,694.65,1914.7>
  }
  triangle { // #7075
		<404.4,694.65,1919.4>,
		<510.05,693.1,1919.4>,
		<404.4,693.1,1919.4>
  }
  triangle { // #7076
		<510.05,693.1,1919.4>,
		<404.4,694.65,1919.4>,
		<510.05,694.65,1919.4>
  }
  triangle { // #7077
		<404.4,693.1,1919.4>,
		<510.05,693.1,1926.35>,
		<404.4,693.1,1926.35>
  }
  triangle { // #7078
		<510.05,693.1,1926.35>,
		<404.4,693.1,1919.4>,
		<510.05,693.1,1919.4>
  }
  triangle { // #7079
		<404.4,693.1,1926.35>,
		<510.05,694.65,1926.35>,
		<404.4,694.65,1926.35>
  }
  triangle { // #7080
		<510.05,694.65,1926.35>,
		<404.4,693.1,1926.35>,
		<510.05,693.1,1926.35>
  }
  triangle { // #7081
		<404.4,694.65,1926.35>,
		<510.05,694.65,1931.35>,
		<404.4,694.65,1931.35>
  }
  triangle { // #7082
		<510.05,694.65,1931.35>,
		<404.4,694.65,1926.35>,
		<510.05,694.65,1926.35>
  }
  smooth_triangle { // #7083
		<404.4,694.65,1931.35>, <0,-0.992,-0.124>,
		<510.05,702.2,1932.3>, <-0.062,-0.996,-0.062>,
		<404.4,702.2,1932.3>, <0.083,-0.996,-0.041>
  }
  smooth_triangle { // #7084
		<510.05,702.2,1932.3>, <-0.062,-0.996,-0.062>,
		<404.4,694.65,1931.35>, <0,-0.992,-0.124>,
		<510.05,694.65,1931.35>, <0,-0.992,-0.124>
  }
  triangle { // #7085
		<-507.15,694.65,1931.05>,
		<-507.15,702.2,1932>,
		<-507.15,694.65,1926.35>
  }
  triangle { // #7086
		<-507.15,702.2,1913.75>,
		<-507.15,694.65,1914.7>,
		<-507.15,702.2,1932>
  }
  triangle { // #7087
		<-507.15,694.65,1914.7>,
		<-507.15,694.65,1919.4>,
		<-507.15,702.2,1932>
  }
  triangle { // #7088
		<-507.15,693.1,1926.35>,
		<-507.15,694.65,1926.35>,
		<-507.15,693.1,1919.4>
  }
  triangle { // #7089
		<-507.15,693.1,1919.4>,
		<-507.15,694.65,1926.35>,
		<-507.15,694.65,1919.4>
  }
  triangle { // #7090
		<-507.15,694.65,1919.4>,
		<-507.15,694.65,1926.35>,
		<-507.15,702.2,1932>
  }
  triangle { // #7091
		<-401.5,694.65,1931.05>,
		<-401.5,694.65,1926.35>,
		<-401.5,702.2,1932>
  }
  triangle { // #7092
		<-401.5,702.2,1913.75>,
		<-401.5,702.2,1932>,
		<-401.5,694.65,1914.7>
  }
  triangle { // #7093
		<-401.5,694.65,1914.7>,
		<-401.5,702.2,1932>,
		<-401.5,694.65,1919.4>
  }
  triangle { // #7094
		<-401.5,693.1,1919.4>,
		<-401.5,694.65,1919.4>,
		<-401.5,693.1,1926.35>
  }
  triangle { // #7095
		<-401.5,693.1,1926.35>,
		<-401.5,694.65,1919.4>,
		<-401.5,694.65,1926.35>
  }
  triangle { // #7096
		<-401.5,694.65,1919.4>,
		<-401.5,702.2,1932>,
		<-401.5,694.65,1926.35>
  }
  smooth_triangle { // #7097
		<-507.15,702.2,1913.75>, <0.083,0.996,-0.041>,
		<-401.5,702.2,1913.75>, <-0.062,0.996,-0.062>,
		<-507.15,694.65,1914.7>, <0,0.992,-0.124>
  }
  smooth_triangle { // #7098
		<-401.5,694.65,1914.7>, <0,0.992,-0.124>,
		<-507.15,694.65,1914.7>, <0,0.992,-0.124>,
		<-401.5,702.2,1913.75>, <-0.062,0.996,-0.062>
  }
  triangle { // #7099
		<-507.15,702.2,1932>,
		<-401.5,702.2,1932>,
		<-507.15,702.2,1913.75>
  }
  triangle { // #7100
		<-401.5,702.2,1913.75>,
		<-507.15,702.2,1913.75>,
		<-401.5,702.2,1932>
  }
  smooth_triangle { // #7101
		<-507.15,694.65,1931.05>, <0,-0.992,-0.124>,
		<-401.5,694.65,1931.05>, <0,-0.992,-0.124>,
		<-507.15,702.2,1932>, <0.041,-0.996,-0.083>
  }
  smooth_triangle { // #7102
		<-401.5,702.2,1932>, <-0.062,-0.996,-0.062>,
		<-507.15,702.2,1932>, <0.041,-0.996,-0.083>,
		<-401.5,694.65,1931.05>, <0,-0.992,-0.124>
  }
  triangle { // #7103
		<-507.15,694.65,1926.35>,
		<-401.5,694.65,1926.35>,
		<-507.15,694.65,1931.05>
  }
  triangle { // #7104
		<-401.5,694.65,1931.05>,
		<-507.15,694.65,1931.05>,
		<-401.5,694.65,1926.35>
  }
  triangle { // #7105
		<-507.15,693.1,1926.35>,
		<-401.5,693.1,1926.35>,
		<-507.15,694.65,1926.35>
  }
  triangle { // #7106
		<-401.5,694.65,1926.35>,
		<-507.15,694.65,1926.35>,
		<-401.5,693.1,1926.35>
  }
  triangle { // #7107
		<-507.15,693.1,1919.4>,
		<-401.5,693.1,1919.4>,
		<-507.15,693.1,1926.35>
  }
  triangle { // #7108
		<-401.5,693.1,1926.35>,
		<-507.15,693.1,1926.35>,
		<-401.5,693.1,1919.4>
  }
  triangle { // #7109
		<-507.15,694.65,1919.4>,
		<-401.5,694.65,1919.4>,
		<-507.15,693.1,1919.4>
  }
  triangle { // #7110
		<-401.5,693.1,1919.4>,
		<-507.15,693.1,1919.4>,
		<-401.5,694.65,1919.4>
  }
  triangle { // #7111
		<-507.15,694.65,1914.7>,
		<-401.5,694.65,1914.7>,
		<-507.15,694.65,1919.4>
  }
  triangle { // #7112
		<-401.5,694.65,1919.4>,
		<-507.15,694.65,1919.4>,
		<-401.5,694.65,1914.7>
  }
  triangle { // #7113
		<404.5,702.2,1918.8>,
		<510.1,702.2,1931.25>,
		<404.5,702.2,1931.25>
  }
  triangle { // #7114
		<510.1,702.2,1931.25>,
		<404.5,702.2,1918.8>,
		<510.1,702.2,1918.8>
  }
  triangle { // #7115
		<404.5,802.8,1931.25>,
		<510.1,802.8,1918.8>,
		<404.5,802.8,1918.8>
  }
  triangle { // #7116
		<510.1,802.8,1918.8>,
		<404.5,802.8,1931.25>,
		<510.1,802.8,1931.25>
  }
  triangle { // #7117
		<404.5,702.2,1931.25>,
		<404.5,802.8,1918.8>,
		<404.5,702.2,1918.8>
  }
  triangle { // #7118
		<404.5,802.8,1918.8>,
		<404.5,702.2,1931.25>,
		<404.5,802.8,1931.25>
  }
  triangle { // #7119
		<404.5,702.2,1918.8>,
		<510.1,802.8,1918.8>,
		<510.1,702.2,1918.8>
  }
  triangle { // #7120
		<510.1,802.8,1918.8>,
		<404.5,702.2,1918.8>,
		<404.5,802.8,1918.8>
  }
  triangle { // #7121
		<510.1,702.2,1918.8>,
		<510.1,802.8,1931.25>,
		<510.1,702.2,1931.25>
  }
  triangle { // #7122
		<510.1,802.8,1931.25>,
		<510.1,702.2,1918.8>,
		<510.1,802.8,1918.8>
  }
  triangle { // #7123
		<510.1,702.2,1931.25>,
		<404.5,802.8,1931.25>,
		<404.5,702.2,1931.25>
  }
  triangle { // #7124
		<404.5,802.8,1931.25>,
		<510.1,702.2,1931.25>,
		<510.1,802.8,1931.25>
  }
  triangle { // #7125
		<-507.15,702.2,1918.8>,
		<-401.5,702.2,1931.25>,
		<-507.15,702.2,1931.25>
  }
  triangle { // #7126
		<-401.5,702.2,1931.25>,
		<-507.15,702.2,1918.8>,
		<-401.5,702.2,1918.8>
  }
  triangle { // #7127
		<-507.15,802.8,1931.25>,
		<-401.5,802.8,1918.8>,
		<-507.15,802.8,1918.8>
  }
  triangle { // #7128
		<-401.5,802.8,1918.8>,
		<-507.15,802.8,1931.25>,
		<-401.5,802.8,1931.25>
  }
  triangle { // #7129
		<-507.15,702.2,1931.25>,
		<-507.15,802.8,1918.8>,
		<-507.15,702.2,1918.8>
  }
  triangle { // #7130
		<-507.15,802.8,1918.8>,
		<-507.15,702.2,1931.25>,
		<-507.15,802.8,1931.25>
  }
  triangle { // #7131
		<-507.15,702.2,1918.8>,
		<-401.5,802.8,1918.8>,
		<-401.5,702.2,1918.8>
  }
  triangle { // #7132
		<-401.5,802.8,1918.8>,
		<-507.15,702.2,1918.8>,
		<-507.15,802.8,1918.8>
  }
  triangle { // #7133
		<-401.5,702.2,1918.8>,
		<-401.5,802.8,1931.25>,
		<-401.5,702.2,1931.25>
  }
  triangle { // #7134
		<-401.5,802.8,1931.25>,
		<-401.5,702.2,1918.8>,
		<-401.5,802.8,1918.8>
  }
  triangle { // #7135
		<-401.5,702.2,1931.25>,
		<-507.15,802.8,1931.25>,
		<-507.15,702.2,1931.25>
  }
  triangle { // #7136
		<-507.15,802.8,1931.25>,
		<-401.5,702.2,1931.25>,
		<-401.5,802.8,1931.25>
  }
  triangle { // #7137
		<312.8,693.1,2130.7>,
		<307.95,694.65,2125.85>,
		<307.95,693.1,2125.85>
  }
  triangle { // #7138
		<304.6,694.65,2122.5>,
		<307.5,702.2,2125.35>,
		<303.95,702.2,2121.8>
  }
  triangle { // #7139
		<307.95,694.65,2125.85>,
		<307.5,702.2,2125.35>,
		<304.6,694.65,2122.5>
  }
  triangle { // #7140
		<307.5,702.2,2125.35>,
		<316.4,694.65,2134.3>,
		<317.05,702.2,2134.95>
  }
  triangle { // #7141
		<307.5,702.2,2125.35>,
		<312.8,694.65,2130.7>,
		<316.4,694.65,2134.3>
  }
  triangle { // #7142
		<307.95,694.65,2125.85>,
		<312.8,694.65,2130.7>,
		<307.5,702.2,2125.35>
  }
  triangle { // #7143
		<307.95,694.65,2125.85>,
		<312.8,693.1,2130.7>,
		<312.8,694.65,2130.7>
  }
  triangle { // #7144
		<377.3,693.1,2056.5>,
		<382.15,694.65,2061.4>,
		<382.15,693.1,2061.4>
  }
  triangle { // #7145
		<376.8,702.2,2056.05>,
		<373.95,694.65,2053.15>,
		<373.25,702.2,2052.5>
  }
  triangle { // #7146
		<376.8,702.2,2056.05>,
		<377.3,694.65,2056.5>,
		<373.95,694.65,2053.15>
  }
  triangle { // #7147
		<385.75,694.65,2064.95>,
		<376.8,702.2,2056.05>,
		<386.4,702.2,2065.6>
  }
  triangle { // #7148
		<382.15,694.65,2061.4>,
		<376.8,702.2,2056.05>,
		<385.75,694.65,2064.95>
  }
  triangle { // #7149
		<382.15,694.65,2061.4>,
		<377.3,694.65,2056.5>,
		<376.8,702.2,2056.05>
  }
  triangle { // #7150
		<382.15,694.65,2061.4>,
		<377.3,693.1,2056.5>,
		<377.3,694.65,2056.5>
  }
  triangle { // #7151
		<307.5,702.2,2125.35>,
		<386.4,702.2,2065.6>,
		<376.8,702.2,2056.05>
  }
  triangle { // #7152
		<386.4,702.2,2065.6>,
		<307.5,702.2,2125.35>,
		<317.05,702.2,2134.95>
  }
  triangle { // #7153
		<303.95,702.2,2121.8>,
		<376.8,702.2,2056.05>,
		<373.25,702.2,2052.5>
  }
  triangle { // #7154
		<376.8,702.2,2056.05>,
		<303.95,702.2,2121.8>,
		<307.5,702.2,2125.35>
  }
  smooth_triangle { // #7155
		<303.95,702.2,2121.8>, <-0.675,0.733,-0.083>,
		<373.95,694.65,2053.15>, <-0.702,0.702,-0.124>,
		<304.6,694.65,2122.5>, <-0.702,0.702,-0.124>
  }
  smooth_triangle { // #7156
		<373.95,694.65,2053.15>, <-0.702,0.702,-0.124>,
		<303.95,702.2,2121.8>, <-0.675,0.733,-0.083>,
		<373.25,702.2,2052.5>, <-0.748,0.66,-0.062>
  }
  triangle { // #7157
		<304.6,694.65,2122.5>,
		<377.3,694.65,2056.5>,
		<307.95,694.65,2125.85>
  }
  triangle { // #7158
		<377.3,694.65,2056.5>,
		<304.6,694.65,2122.5>,
		<373.95,694.65,2053.15>
  }
  triangle { // #7159
		<307.95,694.65,2125.85>,
		<377.3,693.1,2056.5>,
		<307.95,693.1,2125.85>
  }
  triangle { // #7160
		<377.3,693.1,2056.5>,
		<307.95,694.65,2125.85>,
		<377.3,694.65,2056.5>
  }
  triangle { // #7161
		<307.95,693.1,2125.85>,
		<382.15,693.1,2061.4>,
		<312.8,693.1,2130.7>
  }
  triangle { // #7162
		<382.15,693.1,2061.4>,
		<307.95,693.1,2125.85>,
		<377.3,693.1,2056.5>
  }
  triangle { // #7163
		<312.8,693.1,2130.7>,
		<382.15,694.65,2061.4>,
		<312.8,694.65,2130.7>
  }
  triangle { // #7164
		<382.15,694.65,2061.4>,
		<312.8,693.1,2130.7>,
		<382.15,693.1,2061.4>
  }
  triangle { // #7165
		<312.8,694.65,2130.7>,
		<385.75,694.65,2064.95>,
		<316.4,694.65,2134.3>
  }
  triangle { // #7166
		<385.75,694.65,2064.95>,
		<312.8,694.65,2130.7>,
		<382.15,694.65,2061.4>
  }
  smooth_triangle { // #7167
		<316.4,694.65,2134.3>, <0.702,-0.702,-0.124>,
		<386.4,702.2,2065.6>, <0.66,-0.748,-0.062>,
		<317.05,702.2,2134.95>, <0.763,-0.645,-0.041>
  }
  smooth_triangle { // #7168
		<386.4,702.2,2065.6>, <0.66,-0.748,-0.062>,
		<316.4,694.65,2134.3>, <0.702,-0.702,-0.124>,
		<385.75,694.65,2064.95>, <0.702,-0.702,-0.124>
  }
  triangle { // #7169
		<-382.85,694.65,2064.85>,
		<-383.55,702.2,2065.5>,
		<-379.55,694.65,2061.5>
  }
  triangle { // #7170
		<-370.65,702.2,2052.6>,
		<-371.3,694.65,2053.25>,
		<-383.55,702.2,2065.5>
  }
  triangle { // #7171
		<-371.3,694.65,2053.25>,
		<-374.65,694.65,2056.6>,
		<-383.55,702.2,2065.5>
  }
  triangle { // #7172
		<-379.55,693.1,2061.5>,
		<-379.55,694.65,2061.5>,
		<-374.65,693.1,2056.6>
  }
  triangle { // #7173
		<-374.65,693.1,2056.6>,
		<-379.55,694.65,2061.5>,
		<-374.65,694.65,2056.6>
  }
  triangle { // #7174
		<-374.65,694.65,2056.6>,
		<-379.55,694.65,2061.5>,
		<-383.55,702.2,2065.5>
  }
  triangle { // #7175
		<-313.35,694.65,2134.35>,
		<-310,694.65,2131>,
		<-314,702.2,2135>
  }
  triangle { // #7176
		<-301.1,702.2,2122.15>,
		<-314,702.2,2135>,
		<-301.8,694.65,2122.8>
  }
  triangle { // #7177
		<-301.8,694.65,2122.8>,
		<-314,702.2,2135>,
		<-305.1,694.65,2126.15>
  }
  triangle { // #7178
		<-305.1,693.1,2126.15>,
		<-305.1,694.65,2126.15>,
		<-310,693.1,2131>
  }
  triangle { // #7179
		<-310,693.1,2131>,
		<-305.1,694.65,2126.15>,
		<-310,694.65,2131>
  }
  triangle { // #7180
		<-305.1,694.65,2126.15>,
		<-314,702.2,2135>,
		<-310,694.65,2131>
  }
  triangle { // #7181
		<-301.1,702.2,2122.15>,
		<-301.8,694.65,2122.8>,
		<-370.65,702.2,2052.6>
  }
  triangle { // #7182
		<-371.3,694.65,2053.25>,
		<-370.65,702.2,2052.6>,
		<-301.8,694.65,2122.8>
  }
  triangle { // #7183
		<-383.55,702.2,2065.5>,
		<-314,702.2,2135>,
		<-370.65,702.2,2052.6>
  }
  triangle { // #7184
		<-301.1,702.2,2122.15>,
		<-370.65,702.2,2052.6>,
		<-314,702.2,2135>
  }
  triangle { // #7185
		<-382.85,694.65,2064.85>,
		<-313.35,694.65,2134.35>,
		<-383.55,702.2,2065.5>
  }
  triangle { // #7186
		<-314,702.2,2135>,
		<-383.55,702.2,2065.5>,
		<-313.35,694.65,2134.35>
  }
  triangle { // #7187
		<-379.55,694.65,2061.5>,
		<-310,694.65,2131>,
		<-382.85,694.65,2064.85>
  }
  triangle { // #7188
		<-313.35,694.65,2134.35>,
		<-382.85,694.65,2064.85>,
		<-310,694.65,2131>
  }
  triangle { // #7189
		<-379.55,693.1,2061.5>,
		<-310,693.1,2131>,
		<-379.55,694.65,2061.5>
  }
  triangle { // #7190
		<-310,694.65,2131>,
		<-379.55,694.65,2061.5>,
		<-310,693.1,2131>
  }
  triangle { // #7191
		<-374.65,693.1,2056.6>,
		<-305.1,693.1,2126.15>,
		<-379.55,693.1,2061.5>
  }
  triangle { // #7192
		<-310,693.1,2131>,
		<-379.55,693.1,2061.5>,
		<-305.1,693.1,2126.15>
  }
  triangle { // #7193
		<-374.65,694.65,2056.6>,
		<-305.1,694.65,2126.15>,
		<-374.65,693.1,2056.6>
  }
  triangle { // #7194
		<-305.1,693.1,2126.15>,
		<-374.65,693.1,2056.6>,
		<-305.1,694.65,2126.15>
  }
  triangle { // #7195
		<-371.3,694.65,2053.25>,
		<-301.8,694.65,2122.8>,
		<-374.65,694.65,2056.6>
  }
  triangle { // #7196
		<-305.1,694.65,2126.15>,
		<-374.65,694.65,2056.6>,
		<-301.8,694.65,2122.8>
  }
  triangle { // #7197
		<-868.9,309.9,1225.95>,
		<-863.25,309.9,1218.4>,
		<-864.2,309.9,1225.95>
  }
  triangle { // #7198
		<-863.25,309.9,1218.4>,
		<-880.55,309.9,1225.95>,
		<-881.5,309.9,1218.4>
  }
  triangle { // #7199
		<-863.25,309.9,1218.4>,
		<-875.85,309.9,1225.95>,
		<-880.55,309.9,1225.95>
  }
  triangle { // #7200
		<-875.85,309.9,1227.5>,
		<-868.9,309.9,1225.95>,
		<-868.9,309.9,1227.5>
  }
  triangle { // #7201
		<-875.85,309.9,1225.95>,
		<-868.9,309.9,1225.95>,
		<-875.85,309.9,1227.5>
  }
  triangle { // #7202
		<-863.25,309.9,1218.4>,
		<-868.9,309.9,1225.95>,
		<-875.85,309.9,1225.95>
  }
  triangle { // #7203
		<-863.25,528.4,1218.4>,
		<-868.9,528.4,1225.95>,
		<-864.2,528.4,1225.95>
  }
  triangle { // #7204
		<-880.55,528.4,1225.95>,
		<-863.25,528.4,1218.4>,
		<-881.5,528.4,1218.4>
  }
  triangle { // #7205
		<-875.85,528.4,1225.95>,
		<-863.25,528.4,1218.4>,
		<-880.55,528.4,1225.95>
  }
  triangle { // #7206
		<-868.9,528.4,1227.5>,
		<-875.85,528.4,1225.95>,
		<-875.85,528.4,1227.5>
  }
  triangle { // #7207
		<-868.9,528.4,1225.95>,
		<-875.85,528.4,1225.95>,
		<-868.9,528.4,1227.5>
  }
  triangle { // #7208
		<-868.9,528.4,1225.95>,
		<-863.25,528.4,1218.4>,
		<-875.85,528.4,1225.95>
  }
  smooth_triangle { // #7209
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-881.5,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<-881.5,309.9,1218.4>, <-0.992,-0.124,0>
  }
  smooth_triangle { // #7210
		<-881.5,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-880.55,528.4,1225.95>, <-0.992,-0.124,0>
  }
  triangle { // #7211
		<-881.5,309.9,1218.4>,
		<-863.25,528.4,1218.4>,
		<-863.25,309.9,1218.4>
  }
  triangle { // #7212
		<-863.25,528.4,1218.4>,
		<-881.5,309.9,1218.4>,
		<-881.5,528.4,1218.4>
  }
  triangle { // #7213
		<-863.25,309.9,1218.4>,
		<-864.2,528.4,1225.95>,
		<-864.2,309.9,1225.95>
  }
  smooth_triangle { // #7214
		<-864.2,528.4,1225.95>, <0.992,-0.124,0>,
		<-863.25,309.9,1218.4>, <0.992,-0.124,0>,
		<-863.25,528.4,1218.4>, <0.996,-0.062,-0.062>
  }
  triangle { // #7215
		<-864.2,309.9,1225.95>,
		<-868.9,528.4,1225.95>,
		<-868.9,309.9,1225.95>
  }
  triangle { // #7216
		<-868.9,528.4,1225.95>,
		<-864.2,309.9,1225.95>,
		<-864.2,528.4,1225.95>
  }
  triangle { // #7217
		<-868.9,309.9,1225.95>,
		<-868.9,528.4,1227.5>,
		<-868.9,309.9,1227.5>
  }
  triangle { // #7218
		<-868.9,528.4,1227.5>,
		<-868.9,309.9,1225.95>,
		<-868.9,528.4,1225.95>
  }
  triangle { // #7219
		<-868.9,309.9,1227.5>,
		<-875.85,528.4,1227.5>,
		<-875.85,309.9,1227.5>
  }
  triangle { // #7220
		<-875.85,528.4,1227.5>,
		<-868.9,309.9,1227.5>,
		<-868.9,528.4,1227.5>
  }
  triangle { // #7221
		<-875.85,309.9,1227.5>,
		<-875.85,528.4,1225.95>,
		<-875.85,309.9,1225.95>
  }
  triangle { // #7222
		<-875.85,528.4,1225.95>,
		<-875.85,309.9,1227.5>,
		<-875.85,528.4,1227.5>
  }
  triangle { // #7223
		<-875.85,309.9,1225.95>,
		<-880.55,528.4,1225.95>,
		<-880.55,309.9,1225.95>
  }
  triangle { // #7224
		<-880.55,528.4,1225.95>,
		<-875.85,309.9,1225.95>,
		<-875.85,528.4,1225.95>
  }
  triangle { // #7225
		<-864.2,309.9,1340.35>,
		<-863.25,309.9,1347.9>,
		<-868.9,309.9,1340.35>
  }
  triangle { // #7226
		<-881.5,309.9,1347.9>,
		<-880.55,309.9,1340.35>,
		<-863.25,309.9,1347.9>
  }
  triangle { // #7227
		<-880.55,309.9,1340.35>,
		<-875.85,309.9,1340.35>,
		<-863.25,309.9,1347.9>
  }
  triangle { // #7228
		<-868.9,309.9,1338.8>,
		<-868.9,309.9,1340.35>,
		<-875.85,309.9,1338.8>
  }
  triangle { // #7229
		<-875.85,309.9,1338.8>,
		<-868.9,309.9,1340.35>,
		<-875.85,309.9,1340.35>
  }
  triangle { // #7230
		<-875.85,309.9,1340.35>,
		<-868.9,309.9,1340.35>,
		<-863.25,309.9,1347.9>
  }
  triangle { // #7231
		<-864.2,528.4,1340.35>,
		<-868.9,528.4,1340.35>,
		<-863.25,528.4,1347.9>
  }
  triangle { // #7232
		<-881.5,528.4,1347.9>,
		<-863.25,528.4,1347.9>,
		<-880.55,528.4,1340.35>
  }
  triangle { // #7233
		<-880.55,528.4,1340.35>,
		<-863.25,528.4,1347.9>,
		<-875.85,528.4,1340.35>
  }
  triangle { // #7234
		<-875.85,528.4,1338.8>,
		<-875.85,528.4,1340.35>,
		<-868.9,528.4,1338.8>
  }
  triangle { // #7235
		<-868.9,528.4,1338.8>,
		<-875.85,528.4,1340.35>,
		<-868.9,528.4,1340.35>
  }
  triangle { // #7236
		<-875.85,528.4,1340.35>,
		<-863.25,528.4,1347.9>,
		<-868.9,528.4,1340.35>
  }
  smooth_triangle { // #7237
		<-881.5,309.9,1347.9>, <-0.992,0.124,0>,
		<-881.5,528.4,1347.9>, <-0.996,0.083,-0.041>,
		<-880.55,309.9,1340.35>, <-0.999,0.05,0>
  }
  smooth_triangle { // #7238
		<-880.55,528.4,1340.35>, <-0.992,0.124,0>,
		<-880.55,309.9,1340.35>, <-0.999,0.05,0>,
		<-881.5,528.4,1347.9>, <-0.996,0.083,-0.041>
  }
  triangle { // #7239
		<-863.25,309.9,1347.9>,
		<-863.25,528.4,1347.9>,
		<-881.5,309.9,1347.9>
  }
  triangle { // #7240
		<-881.5,528.4,1347.9>,
		<-881.5,309.9,1347.9>,
		<-863.25,528.4,1347.9>
  }
  triangle { // #7241
		<-864.2,309.9,1340.35>,
		<-864.2,528.4,1340.35>,
		<-863.25,309.9,1347.9>
  }
  smooth_triangle { // #7242
		<-863.25,528.4,1347.9>, <0.996,0.041,-0.083>,
		<-863.25,309.9,1347.9>, <0.992,0.124,0>,
		<-864.2,528.4,1340.35>, <0.992,0.124,0>
  }
  triangle { // #7243
		<-868.9,309.9,1340.35>,
		<-868.9,528.4,1340.35>,
		<-864.2,309.9,1340.35>
  }
  triangle { // #7244
		<-864.2,528.4,1340.35>,
		<-864.2,309.9,1340.35>,
		<-868.9,528.4,1340.35>
  }
  triangle { // #7245
		<-868.9,309.9,1338.8>,
		<-868.9,528.4,1338.8>,
		<-868.9,309.9,1340.35>
  }
  triangle { // #7246
		<-868.9,528.4,1340.35>,
		<-868.9,309.9,1340.35>,
		<-868.9,528.4,1338.8>
  }
  triangle { // #7247
		<-875.85,309.9,1338.8>,
		<-875.85,528.4,1338.8>,
		<-868.9,309.9,1338.8>
  }
  triangle { // #7248
		<-868.9,528.4,1338.8>,
		<-868.9,309.9,1338.8>,
		<-875.85,528.4,1338.8>
  }
  triangle { // #7249
		<-875.85,309.9,1340.35>,
		<-875.85,528.4,1340.35>,
		<-875.85,309.9,1338.8>
  }
  triangle { // #7250
		<-875.85,528.4,1338.8>,
		<-875.85,309.9,1338.8>,
		<-875.85,528.4,1340.35>
  }
  triangle { // #7251
		<-880.55,309.9,1340.35>,
		<-880.55,528.4,1340.35>,
		<-875.85,309.9,1340.35>
  }
  triangle { // #7252
		<-875.85,528.4,1340.35>,
		<-875.85,309.9,1340.35>,
		<-880.55,528.4,1340.35>
  }
  triangle { // #7253
		<-864.2,520.85,1347.9>,
		<-863.25,528.4,1347.9>,
		<-868.9,520.85,1347.9>
  }
  triangle { // #7254
		<-881.5,528.4,1347.9>,
		<-880.55,520.85,1347.9>,
		<-863.25,528.4,1347.9>
  }
  triangle { // #7255
		<-880.55,520.85,1347.9>,
		<-875.85,520.85,1347.9>,
		<-863.25,528.4,1347.9>
  }
  triangle { // #7256
		<-868.9,519.25,1347.9>,
		<-868.9,520.85,1347.9>,
		<-875.85,519.25,1347.9>
  }
  triangle { // #7257
		<-875.85,519.25,1347.9>,
		<-868.9,520.85,1347.9>,
		<-875.85,520.85,1347.9>
  }
  triangle { // #7258
		<-875.85,520.85,1347.9>,
		<-868.9,520.85,1347.9>,
		<-863.25,528.4,1347.9>
  }
  triangle { // #7259
		<-864.2,520.85,1218.4>,
		<-868.9,520.85,1218.4>,
		<-863.25,528.4,1218.4>
  }
  triangle { // #7260
		<-881.5,528.4,1218.4>,
		<-863.25,528.4,1218.4>,
		<-880.55,520.85,1218.4>
  }
  triangle { // #7261
		<-880.55,520.85,1218.4>,
		<-863.25,528.4,1218.4>,
		<-875.85,520.85,1218.4>
  }
  triangle { // #7262
		<-875.85,519.25,1218.4>,
		<-875.85,520.85,1218.4>,
		<-868.9,519.25,1218.4>
  }
  triangle { // #7263
		<-868.9,519.25,1218.4>,
		<-875.85,520.85,1218.4>,
		<-868.9,520.85,1218.4>
  }
  triangle { // #7264
		<-875.85,520.85,1218.4>,
		<-863.25,528.4,1218.4>,
		<-868.9,520.85,1218.4>
  }
  smooth_triangle { // #7265
		<-881.5,528.4,1347.9>, <-0.996,0.083,-0.041>,
		<-881.5,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<-880.55,520.85,1347.9>, <-0.992,0,-0.124>
  }
  smooth_triangle { // #7266
		<-880.55,520.85,1218.4>, <-0.992,0,-0.124>,
		<-880.55,520.85,1347.9>, <-0.992,0,-0.124>,
		<-881.5,528.4,1218.4>, <-0.996,-0.062,-0.062>
  }
  triangle { // #7267
		<-863.25,528.4,1347.9>,
		<-863.25,528.4,1218.4>,
		<-881.5,528.4,1347.9>
  }
  triangle { // #7268
		<-881.5,528.4,1218.4>,
		<-881.5,528.4,1347.9>,
		<-863.25,528.4,1218.4>
  }
  smooth_triangle { // #7269
		<-864.2,520.85,1347.9>, <0.992,0,-0.124>,
		<-864.2,520.85,1218.4>, <0.992,0,-0.124>,
		<-863.25,528.4,1347.9>, <0.996,0.041,-0.083>
  }
  smooth_triangle { // #7270
		<-863.25,528.4,1218.4>, <0.996,-0.062,-0.062>,
		<-863.25,528.4,1347.9>, <0.996,0.041,-0.083>,
		<-864.2,520.85,1218.4>, <0.992,0,-0.124>
  }
  triangle { // #7271
		<-868.9,520.85,1347.9>,
		<-868.9,520.85,1218.4>,
		<-864.2,520.85,1347.9>
  }
  triangle { // #7272
		<-864.2,520.85,1218.4>,
		<-864.2,520.85,1347.9>,
		<-868.9,520.85,1218.4>
  }
  triangle { // #7273
		<-868.9,519.25,1347.9>,
		<-868.9,519.25,1218.4>,
		<-868.9,520.85,1347.9>
  }
  triangle { // #7274
		<-868.9,520.85,1218.4>,
		<-868.9,520.85,1347.9>,
		<-868.9,519.25,1218.4>
  }
  triangle { // #7275
		<-875.85,519.25,1347.9>,
		<-875.85,519.25,1218.4>,
		<-868.9,519.25,1347.9>
  }
  triangle { // #7276
		<-868.9,519.25,1218.4>,
		<-868.9,519.25,1347.9>,
		<-875.85,519.25,1218.4>
  }
  triangle { // #7277
		<-875.85,520.85,1347.9>,
		<-875.85,520.85,1218.4>,
		<-875.85,519.25,1347.9>
  }
  triangle { // #7278
		<-875.85,519.25,1218.4>,
		<-875.85,519.25,1347.9>,
		<-875.85,520.85,1218.4>
  }
  triangle { // #7279
		<-880.55,520.85,1347.9>,
		<-880.55,520.85,1218.4>,
		<-875.85,520.85,1347.9>
  }
  triangle { // #7280
		<-875.85,520.85,1218.4>,
		<-875.85,520.85,1347.9>,
		<-880.55,520.85,1218.4>
  }
  triangle { // #7281
		<879.35,309.9,1225.95>,
		<885,309.9,1218.4>,
		<884.05,309.9,1225.95>
  }
  triangle { // #7282
		<885,309.9,1218.4>,
		<867.75,309.9,1225.95>,
		<866.8,309.9,1218.4>
  }
  triangle { // #7283
		<885,309.9,1218.4>,
		<872.45,309.9,1225.95>,
		<867.75,309.9,1225.95>
  }
  triangle { // #7284
		<872.45,309.9,1227.5>,
		<879.35,309.9,1225.95>,
		<879.35,309.9,1227.5>
  }
  triangle { // #7285
		<872.45,309.9,1225.95>,
		<879.35,309.9,1225.95>,
		<872.45,309.9,1227.5>
  }
  triangle { // #7286
		<885,309.9,1218.4>,
		<879.35,309.9,1225.95>,
		<872.45,309.9,1225.95>
  }
  triangle { // #7287
		<885,528.4,1218.4>,
		<879.35,528.4,1225.95>,
		<884.05,528.4,1225.95>
  }
  triangle { // #7288
		<867.75,528.4,1225.95>,
		<885,528.4,1218.4>,
		<866.8,528.4,1218.4>
  }
  triangle { // #7289
		<872.45,528.4,1225.95>,
		<885,528.4,1218.4>,
		<867.75,528.4,1225.95>
  }
  triangle { // #7290
		<879.35,528.4,1227.5>,
		<872.45,528.4,1225.95>,
		<872.45,528.4,1227.5>
  }
  triangle { // #7291
		<879.35,528.4,1225.95>,
		<872.45,528.4,1225.95>,
		<879.35,528.4,1227.5>
  }
  triangle { // #7292
		<879.35,528.4,1225.95>,
		<885,528.4,1218.4>,
		<872.45,528.4,1225.95>
  }
  smooth_triangle { // #7293
		<867.75,309.9,1225.95>, <-0.992,-0.124,0>,
		<866.8,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<866.8,309.9,1218.4>, <-0.992,-0.124,0>
  }
  smooth_triangle { // #7294
		<866.8,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<867.75,309.9,1225.95>, <-0.992,-0.124,0>,
		<867.75,528.4,1225.95>, <-0.992,-0.124,0>
  }
  triangle { // #7295
		<866.8,309.9,1218.4>,
		<885,528.4,1218.4>,
		<885,309.9,1218.4>
  }
  triangle { // #7296
		<885,528.4,1218.4>,
		<866.8,309.9,1218.4>,
		<866.8,528.4,1218.4>
  }
  smooth_triangle { // #7297
		<885,309.9,1218.4>, <0.992,-0.124,0>,
		<884.05,528.4,1225.95>, <0.992,-0.124,0>,
		<884.05,309.9,1225.95>, <1,-0.025,0>
  }
  smooth_triangle { // #7298
		<884.05,528.4,1225.95>, <0.992,-0.124,0>,
		<885,309.9,1218.4>, <0.992,-0.124,0>,
		<885,528.4,1218.4>, <0.996,-0.062,-0.062>
  }
  triangle { // #7299
		<884.05,309.9,1225.95>,
		<879.35,528.4,1225.95>,
		<879.35,309.9,1225.95>
  }
  triangle { // #7300
		<879.35,528.4,1225.95>,
		<884.05,309.9,1225.95>,
		<884.05,528.4,1225.95>
  }
  triangle { // #7301
		<879.35,309.9,1225.95>,
		<879.35,528.4,1227.5>,
		<879.35,309.9,1227.5>
  }
  triangle { // #7302
		<879.35,528.4,1227.5>,
		<879.35,309.9,1225.95>,
		<879.35,528.4,1225.95>
  }
  triangle { // #7303
		<879.35,309.9,1227.5>,
		<872.45,528.4,1227.5>,
		<872.45,309.9,1227.5>
  }
  triangle { // #7304
		<872.45,528.4,1227.5>,
		<879.35,309.9,1227.5>,
		<879.35,528.4,1227.5>
  }
  triangle { // #7305
		<872.45,309.9,1227.5>,
		<872.45,528.4,1225.95>,
		<872.45,309.9,1225.95>
  }
  triangle { // #7306
		<872.45,528.4,1225.95>,
		<872.45,309.9,1227.5>,
		<872.45,528.4,1227.5>
  }
  triangle { // #7307
		<872.45,309.9,1225.95>,
		<867.75,528.4,1225.95>,
		<867.75,309.9,1225.95>
  }
  triangle { // #7308
		<867.75,528.4,1225.95>,
		<872.45,309.9,1225.95>,
		<872.45,528.4,1225.95>
  }
  triangle { // #7309
		<884.05,309.9,1340.35>,
		<885,309.9,1347.9>,
		<879.35,309.9,1340.35>
  }
  triangle { // #7310
		<866.8,309.9,1347.9>,
		<867.75,309.9,1340.35>,
		<885,309.9,1347.9>
  }
  triangle { // #7311
		<867.75,309.9,1340.35>,
		<872.45,309.9,1340.35>,
		<885,309.9,1347.9>
  }
  triangle { // #7312
		<879.35,309.9,1338.8>,
		<879.35,309.9,1340.35>,
		<872.45,309.9,1338.8>
  }
  triangle { // #7313
		<872.45,309.9,1338.8>,
		<879.35,309.9,1340.35>,
		<872.45,309.9,1340.35>
  }
  triangle { // #7314
		<872.45,309.9,1340.35>,
		<879.35,309.9,1340.35>,
		<885,309.9,1347.9>
  }
  triangle { // #7315
		<884.05,528.4,1340.35>,
		<879.35,528.4,1340.35>,
		<885,528.4,1347.9>
  }
  triangle { // #7316
		<866.8,528.4,1347.9>,
		<885,528.4,1347.9>,
		<867.75,528.4,1340.35>
  }
  triangle { // #7317
		<867.75,528.4,1340.35>,
		<885,528.4,1347.9>,
		<872.45,528.4,1340.35>
  }
  triangle { // #7318
		<872.45,528.4,1338.8>,
		<872.45,528.4,1340.35>,
		<879.35,528.4,1338.8>
  }
  triangle { // #7319
		<879.35,528.4,1338.8>,
		<872.45,528.4,1340.35>,
		<879.35,528.4,1340.35>
  }
  triangle { // #7320
		<872.45,528.4,1340.35>,
		<885,528.4,1347.9>,
		<879.35,528.4,1340.35>
  }
  smooth_triangle { // #7321
		<866.8,309.9,1347.9>, <-0.992,0.124,0>,
		<866.8,528.4,1347.9>, <-0.996,0.083,-0.041>,
		<867.75,309.9,1340.35>, <-0.992,0.124,0>
  }
  smooth_triangle { // #7322
		<867.75,528.4,1340.35>, <-0.992,0.124,0>,
		<867.75,309.9,1340.35>, <-0.992,0.124,0>,
		<866.8,528.4,1347.9>, <-0.996,0.083,-0.041>
  }
  triangle { // #7323
		<885,309.9,1347.9>,
		<885,528.4,1347.9>,
		<866.8,309.9,1347.9>
  }
  triangle { // #7324
		<866.8,528.4,1347.9>,
		<866.8,309.9,1347.9>,
		<885,528.4,1347.9>
  }
  smooth_triangle { // #7325
		<884.05,309.9,1340.35>, <1,0.031,0>,
		<884.05,528.4,1340.35>, <0.992,0.124,0>,
		<885,309.9,1347.9>, <0.992,0.124,0>
  }
  smooth_triangle { // #7326
		<885,528.4,1347.9>, <0.996,0.041,-0.083>,
		<885,309.9,1347.9>, <0.992,0.124,0>,
		<884.05,528.4,1340.35>, <0.992,0.124,0>
  }
  triangle { // #7327
		<879.35,309.9,1340.35>,
		<879.35,528.4,1340.35>,
		<884.05,309.9,1340.35>
  }
  triangle { // #7328
		<884.05,528.4,1340.35>,
		<884.05,309.9,1340.35>,
		<879.35,528.4,1340.35>
  }
  triangle { // #7329
		<879.35,309.9,1338.8>,
		<879.35,528.4,1338.8>,
		<879.35,309.9,1340.35>
  }
  triangle { // #7330
		<879.35,528.4,1340.35>,
		<879.35,309.9,1340.35>,
		<879.35,528.4,1338.8>
  }
  triangle { // #7331
		<872.45,309.9,1338.8>,
		<872.45,528.4,1338.8>,
		<879.35,309.9,1338.8>
  }
  triangle { // #7332
		<879.35,528.4,1338.8>,
		<879.35,309.9,1338.8>,
		<872.45,528.4,1338.8>
  }
  triangle { // #7333
		<872.45,309.9,1340.35>,
		<872.45,528.4,1340.35>,
		<872.45,309.9,1338.8>
  }
  triangle { // #7334
		<872.45,528.4,1338.8>,
		<872.45,309.9,1338.8>,
		<872.45,528.4,1340.35>
  }
  triangle { // #7335
		<867.75,309.9,1340.35>,
		<867.75,528.4,1340.35>,
		<872.45,309.9,1340.35>
  }
  triangle { // #7336
		<872.45,528.4,1340.35>,
		<872.45,309.9,1340.35>,
		<867.75,528.4,1340.35>
  }
  triangle { // #7337
		<884.05,520.85,1347.9>,
		<885,528.4,1347.9>,
		<879.35,520.85,1347.9>
  }
  triangle { // #7338
		<866.8,528.4,1347.9>,
		<867.75,520.85,1347.9>,
		<885,528.4,1347.9>
  }
  triangle { // #7339
		<867.75,520.85,1347.9>,
		<872.45,520.85,1347.9>,
		<885,528.4,1347.9>
  }
  triangle { // #7340
		<879.35,519.25,1347.9>,
		<879.35,520.85,1347.9>,
		<872.45,519.25,1347.9>
  }
  triangle { // #7341
		<872.45,519.25,1347.9>,
		<879.35,520.85,1347.9>,
		<872.45,520.85,1347.9>
  }
  triangle { // #7342
		<872.45,520.85,1347.9>,
		<879.35,520.85,1347.9>,
		<885,528.4,1347.9>
  }
  triangle { // #7343
		<884.05,520.85,1218.4>,
		<879.35,520.85,1218.4>,
		<885,528.4,1218.4>
  }
  triangle { // #7344
		<866.8,528.4,1218.4>,
		<885,528.4,1218.4>,
		<867.75,520.85,1218.4>
  }
  triangle { // #7345
		<867.75,520.85,1218.4>,
		<885,528.4,1218.4>,
		<872.45,520.85,1218.4>
  }
  triangle { // #7346
		<872.45,519.25,1218.4>,
		<872.45,520.85,1218.4>,
		<879.35,519.25,1218.4>
  }
  triangle { // #7347
		<879.35,519.25,1218.4>,
		<872.45,520.85,1218.4>,
		<879.35,520.85,1218.4>
  }
  triangle { // #7348
		<872.45,520.85,1218.4>,
		<885,528.4,1218.4>,
		<879.35,520.85,1218.4>
  }
  smooth_triangle { // #7349
		<866.8,528.4,1347.9>, <-0.996,0.083,-0.041>,
		<866.8,528.4,1218.4>, <-0.996,-0.062,-0.062>,
		<867.75,520.85,1347.9>, <-0.992,0,-0.124>
  }
  smooth_triangle { // #7350
		<867.75,520.85,1218.4>, <-0.992,0,-0.124>,
		<867.75,520.85,1347.9>, <-0.992,0,-0.124>,
		<866.8,528.4,1218.4>, <-0.996,-0.062,-0.062>
  }
  triangle { // #7351
		<885,528.4,1347.9>,
		<885,528.4,1218.4>,
		<866.8,528.4,1347.9>
  }
  triangle { // #7352
		<866.8,528.4,1218.4>,
		<866.8,528.4,1347.9>,
		<885,528.4,1218.4>
  }
  smooth_triangle { // #7353
		<884.05,520.85,1347.9>, <0.992,0,-0.124>,
		<884.05,520.85,1218.4>, <0.992,0,-0.124>,
		<885,528.4,1347.9>, <0.996,0.041,-0.083>
  }
  smooth_triangle { // #7354
		<885,528.4,1218.4>, <0.996,-0.062,-0.062>,
		<885,528.4,1347.9>, <0.996,0.041,-0.083>,
		<884.05,520.85,1218.4>, <0.992,0,-0.124>
  }
  triangle { // #7355
		<879.35,520.85,1347.9>,
		<879.35,520.85,1218.4>,
		<884.05,520.85,1347.9>
  }
  triangle { // #7356
		<884.05,520.85,1218.4>,
		<884.05,520.85,1347.9>,
		<879.35,520.85,1218.4>
  }
  triangle { // #7357
		<879.35,519.25,1347.9>,
		<879.35,519.25,1218.4>,
		<879.35,520.85,1347.9>
  }
  triangle { // #7358
		<879.35,520.85,1218.4>,
		<879.35,520.85,1347.9>,
		<879.35,519.25,1218.4>
  }
  triangle { // #7359
		<872.45,519.25,1347.9>,
		<872.45,519.25,1218.4>,
		<879.35,519.25,1347.9>
  }
  triangle { // #7360
		<879.35,519.25,1218.4>,
		<879.35,519.25,1347.9>,
		<872.45,519.25,1218.4>
  }
  triangle { // #7361
		<872.45,520.85,1347.9>,
		<872.45,520.85,1218.4>,
		<872.45,519.25,1347.9>
  }
  triangle { // #7362
		<872.45,519.25,1218.4>,
		<872.45,519.25,1347.9>,
		<872.45,520.85,1218.4>
  }
  triangle { // #7363
		<867.75,520.85,1347.9>,
		<867.75,520.85,1218.4>,
		<872.45,520.85,1347.9>
  }
  triangle { // #7364
		<872.45,520.85,1218.4>,
		<872.45,520.85,1347.9>,
		<867.75,520.85,1218.4>
  }
  triangle { // #7365
		<411.95,485.95,1926.65>,
		<502.5,485.95,1931.35>,
		<411.95,485.95,1931.35>
  }
  triangle { // #7366
		<502.5,485.95,1931.35>,
		<411.95,485.95,1926.65>,
		<502.5,485.95,1926.65>
  }
  triangle { // #7367
		<411.95,694.65,1931.35>,
		<502.5,694.65,1926.65>,
		<411.95,694.65,1926.65>
  }
  triangle { // #7368
		<502.5,694.65,1926.65>,
		<411.95,694.65,1931.35>,
		<502.5,694.65,1931.35>
  }
  triangle { // #7369
		<411.95,485.95,1931.35>,
		<411.95,694.65,1926.65>,
		<411.95,485.95,1926.65>
  }
  triangle { // #7370
		<411.95,694.65,1926.65>,
		<411.95,485.95,1931.35>,
		<411.95,694.65,1931.35>
  }
  triangle { // #7371
		<411.95,485.95,1926.65>,
		<502.5,694.65,1926.65>,
		<502.5,485.95,1926.65>
  }
  triangle { // #7372
		<502.5,694.65,1926.65>,
		<411.95,485.95,1926.65>,
		<411.95,694.65,1926.65>
  }
  triangle { // #7373
		<502.5,485.95,1926.65>,
		<502.5,694.65,1931.35>,
		<502.5,485.95,1931.35>
  }
  triangle { // #7374
		<502.5,694.65,1931.35>,
		<502.5,485.95,1926.65>,
		<502.5,694.65,1926.65>
  }
  smooth_triangle { // #7375
		<502.5,485.95,1931.35>, <-0.062,-0.998,0>,
		<411.95,694.65,1931.35>, <0,-1,0>,
		<411.95,485.95,1931.35>, <0.083,-0.997,0>
  }
  smooth_triangle { // #7376
		<411.95,694.65,1931.35>, <0,-1,0>,
		<502.5,485.95,1931.35>, <-0.062,-0.998,0>,
		<502.5,694.65,1931.35>, <0,-1,0>
  }
  triangle { // #7377
		<-499.6,485.95,1926.35>,
		<-409.05,485.95,1931.05>,
		<-499.6,485.95,1931.05>
  }
  triangle { // #7378
		<-409.05,485.95,1931.05>,
		<-499.6,485.95,1926.35>,
		<-409.05,485.95,1926.35>
  }
  triangle { // #7379
		<-499.6,694.65,1931.05>,
		<-409.05,694.65,1926.35>,
		<-499.6,694.65,1926.35>
  }
  triangle { // #7380
		<-409.05,694.65,1926.35>,
		<-499.6,694.65,1931.05>,
		<-409.05,694.65,1931.05>
  }
  triangle { // #7381
		<-499.6,485.95,1931.05>,
		<-499.6,694.65,1926.35>,
		<-499.6,485.95,1926.35>
  }
  triangle { // #7382
		<-499.6,694.65,1926.35>,
		<-499.6,485.95,1931.05>,
		<-499.6,694.65,1931.05>
  }
  triangle { // #7383
		<-499.6,485.95,1926.35>,
		<-409.05,694.65,1926.35>,
		<-409.05,485.95,1926.35>
  }
  triangle { // #7384
		<-409.05,694.65,1926.35>,
		<-499.6,485.95,1926.35>,
		<-499.6,694.65,1926.35>
  }
  triangle { // #7385
		<-409.05,485.95,1926.35>,
		<-409.05,694.65,1931.05>,
		<-409.05,485.95,1931.05>
  }
  triangle { // #7386
		<-409.05,694.65,1931.05>,
		<-409.05,485.95,1926.35>,
		<-409.05,694.65,1926.35>
  }
  smooth_triangle { // #7387
		<-409.05,485.95,1931.05>, <-0.041,-0.999,0>,
		<-499.6,694.65,1931.05>, <0,-1,0>,
		<-499.6,485.95,1931.05>, <0.062,-0.998,0>
  }
  smooth_triangle { // #7388
		<-499.6,694.65,1931.05>, <0,-1,0>,
		<-409.05,485.95,1931.05>, <-0.041,-0.999,0>,
		<-409.05,694.65,1931.05>, <0,-1,0>
  }
  triangle { // #7389
		<-374.05,485.95,2067>,
		<-318.7,485.95,2129>,
		<-377.35,485.95,2070.35>
  }
  triangle { // #7390
		<-318.7,485.95,2129>,
		<-374.05,485.95,2067>,
		<-315.4,485.95,2125.65>
  }
  triangle { // #7391
		<-374.05,694.65,2067>,
		<-318.7,694.65,2129>,
		<-315.35,694.65,2125.7>
  }
  triangle { // #7392
		<-318.7,694.65,2129>,
		<-374.05,694.65,2067>,
		<-377.35,694.65,2070.35>
  }
  triangle { // #7393
		<-377.35,485.95,2070.35>,
		<-374.05,694.65,2067>,
		<-374.05,485.95,2067>
  }
  triangle { // #7394
		<-374.05,694.65,2067>,
		<-377.35,485.95,2070.35>,
		<-377.35,694.65,2070.35>
  }
  triangle { // #7395
		<-374.05,485.95,2067>,
		<-315.35,694.65,2125.7>,
		<-315.4,485.95,2125.65>
  }
  triangle { // #7396
		<-315.35,694.65,2125.7>,
		<-374.05,485.95,2067>,
		<-374.05,694.65,2067>
  }
  triangle { // #7397
		<-315.4,485.95,2125.65>,
		<-318.7,694.65,2129>,
		<-318.7,485.95,2129>
  }
  triangle { // #7398
		<-318.7,694.65,2129>,
		<-315.4,485.95,2125.65>,
		<-315.35,694.65,2125.7>
  }
  smooth_triangle { // #7399
		<-318.7,485.95,2129>, <-0.736,-0.677,0>,
		<-377.35,694.65,2070.35>, <-0.707,-0.707,0>,
		<-377.35,485.95,2070.35>, <-0.662,-0.75,0>
  }
  smooth_triangle { // #7400
		<-377.35,694.65,2070.35>, <-0.707,-0.707,0>,
		<-318.7,485.95,2129>, <-0.736,-0.677,0>,
		<-318.7,694.65,2129>, <-0.707,-0.707,0>
  }
  triangle { // #7401
		<318.2,485.95,2125.35>,
		<377.05,485.95,2066.9>,
		<321.75,485.95,2128.95>
  }
  triangle { // #7402
		<380.35,485.95,2070.3>,
		<321.75,485.95,2128.95>,
		<377.05,485.95,2066.9>
  }
  triangle { // #7403
		<380.4,694.65,2070.25>,
		<377.05,694.65,2066.9>,
		<321.75,694.65,2128.95>
  }
  triangle { // #7404
		<318.2,694.65,2125.35>,
		<321.75,694.65,2128.95>,
		<377.05,694.65,2066.9>
  }
  triangle { // #7405
		<321.75,485.95,2128.95>,
		<321.75,694.65,2128.95>,
		<318.2,485.95,2125.35>
  }
  triangle { // #7406
		<318.2,694.65,2125.35>,
		<318.2,485.95,2125.35>,
		<321.75,694.65,2128.95>
  }
  smooth_triangle { // #7407
		<380.35,485.95,2070.3>, <0.646,-0.763,0>,
		<380.4,694.65,2070.25>, <0.707,-0.707,0>,
		<321.75,485.95,2128.95>, <0.75,-0.662,0>
  }
  smooth_triangle { // #7408
		<321.75,694.65,2128.95>, <0.707,-0.707,0>,
		<321.75,485.95,2128.95>, <0.75,-0.662,0>,
		<380.4,694.65,2070.25>, <0.707,-0.707,0>
  }
  triangle { // #7409
		<377.05,485.95,2066.9>,
		<377.05,694.65,2066.9>,
		<380.35,485.95,2070.3>
  }
  triangle { // #7410
		<380.4,694.65,2070.25>,
		<380.35,485.95,2070.3>,
		<377.05,694.65,2066.9>
  }
  triangle { // #7411
		<318.2,485.95,2125.35>,
		<318.2,694.65,2125.35>,
		<377.05,485.95,2066.9>
  }
  triangle { // #7412
		<377.05,694.65,2066.9>,
		<377.05,485.95,2066.9>,
		<318.2,694.65,2125.35>
  }
  triangle { // #7413
		<-880.55,309.9,1225.95>,
		<-875.85,309.9,1340.35>,
		<-880.55,309.9,1340.35>
  }
  triangle { // #7414
		<-875.85,309.9,1340.35>,
		<-880.55,309.9,1225.95>,
		<-875.85,309.9,1225.95>
  }
  triangle { // #7415
		<-875.85,309.9,1225.95>,
		<-880.55,520.85,1225.95>,
		<-875.85,520.85,1225.95>
  }
  triangle { // #7416
		<-880.55,520.85,1225.95>,
		<-875.85,309.9,1225.95>,
		<-880.55,309.9,1225.95>
  }
  triangle { // #7417
		<-875.85,463.65,1295.75>,
		<-875.85,309.9,1225.95>,
		<-875.85,463.65,1270.6>
  }
  triangle { // #7418
		<-875.85,520.85,1340.35>,
		<-875.85,488.75,1270.6>,
		<-875.85,520.85,1225.95>
  }
  triangle { // #7419
		<-875.85,520.85,1340.35>,
		<-875.85,488.75,1295.75>,
		<-875.85,488.75,1270.6>
  }
  triangle { // #7420
		<-875.85,488.75,1270.6>,
		<-875.85,309.9,1225.95>,
		<-875.85,520.85,1225.95>
  }
  triangle { // #7421
		<-875.85,463.65,1270.6>,
		<-875.85,309.9,1225.95>,
		<-875.85,488.75,1270.6>
  }
  triangle { // #7422
		<-875.85,309.9,1340.35>,
		<-875.85,488.75,1295.75>,
		<-875.85,520.85,1340.35>
  }
  triangle { // #7423
		<-875.85,309.9,1340.35>,
		<-875.85,463.65,1295.75>,
		<-875.85,488.75,1295.75>
  }
  triangle { // #7424
		<-875.85,309.9,1225.95>,
		<-875.85,463.65,1295.75>,
		<-875.85,309.9,1340.35>
  }
  triangle { // #7425
		<-880.55,309.9,1340.35>,
		<-875.85,520.85,1340.35>,
		<-880.55,520.85,1340.35>
  }
  triangle { // #7426
		<-875.85,520.85,1340.35>,
		<-880.55,309.9,1340.35>,
		<-875.85,309.9,1340.35>
  }
  smooth_triangle { // #7427
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-880.55,463.65,1295.75>, <-1,0,0>,
		<-880.55,463.65,1270.6>, <-1,0,0>
  }
  triangle { // #7428
		<-880.55,488.75,1270.6>,
		<-880.55,520.85,1340.35>,
		<-880.55,520.85,1225.95>
  }
  triangle { // #7429
		<-880.55,488.75,1295.75>,
		<-880.55,520.85,1340.35>,
		<-880.55,488.75,1270.6>
  }
  smooth_triangle { // #7430
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-880.55,488.75,1270.6>, <-1,0,0>,
		<-880.55,520.85,1225.95>, <-1,0,0>
  }
  smooth_triangle { // #7431
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-880.55,463.65,1270.6>, <-1,0,0>,
		<-880.55,488.75,1270.6>, <-1,0,0>
  }
  smooth_triangle { // #7432
		<-880.55,488.75,1295.75>, <-1,0,0>,
		<-880.55,309.9,1340.35>, <-0.999,0.05,0>,
		<-880.55,520.85,1340.35>, <-1,-0,0>
  }
  smooth_triangle { // #7433
		<-880.55,463.65,1295.75>, <-1,0,0>,
		<-880.55,309.9,1340.35>, <-0.999,0.05,0>,
		<-880.55,488.75,1295.75>, <-1,0,0>
  }
  smooth_triangle { // #7434
		<-880.55,463.65,1295.75>, <-1,0,0>,
		<-880.55,309.9,1225.95>, <-0.999,-0.041,0>,
		<-880.55,309.9,1340.35>, <-0.999,0.05,0>
  }
  triangle { // #7435
		<-880.55,520.85,1225.95>,
		<-875.85,520.85,1340.35>,
		<-875.85,520.85,1225.95>
  }
  triangle { // #7436
		<-875.85,520.85,1340.35>,
		<-880.55,520.85,1225.95>,
		<-880.55,520.85,1340.35>
  }
  triangle { // #7437
		<-880.55,463.65,1295.75>,
		<-875.85,463.65,1270.6>,
		<-880.55,463.65,1270.6>
  }
  triangle { // #7438
		<-875.85,463.65,1270.6>,
		<-880.55,463.65,1295.75>,
		<-875.85,463.65,1295.75>
  }
  triangle { // #7439
		<-880.55,463.65,1270.6>,
		<-875.85,488.75,1270.6>,
		<-880.55,488.75,1270.6>
  }
  triangle { // #7440
		<-875.85,488.75,1270.6>,
		<-880.55,463.65,1270.6>,
		<-875.85,463.65,1270.6>
  }
  triangle { // #7441
		<-880.55,488.75,1270.6>,
		<-875.85,488.75,1295.75>,
		<-880.55,488.75,1295.75>
  }
  triangle { // #7442
		<-875.85,488.75,1295.75>,
		<-880.55,488.75,1270.6>,
		<-875.85,488.75,1270.6>
  }
  triangle { // #7443
		<-880.55,488.75,1295.75>,
		<-875.85,463.65,1295.75>,
		<-880.55,463.65,1295.75>
  }
  triangle { // #7444
		<-875.85,463.65,1295.75>,
		<-880.55,488.75,1295.75>,
		<-875.85,488.75,1295.75>
  }
  triangle { // #7445
		<879.35,309.9,1225.95>,
		<884.05,309.9,1340.35>,
		<879.35,309.9,1340.35>
  }
  triangle { // #7446
		<884.05,309.9,1340.35>,
		<879.35,309.9,1225.95>,
		<884.05,309.9,1225.95>
  }
  triangle { // #7447
		<884.05,309.9,1225.95>,
		<879.35,520.85,1225.95>,
		<884.05,520.85,1225.95>
  }
  triangle { // #7448
		<879.35,520.85,1225.95>,
		<884.05,309.9,1225.95>,
		<879.35,309.9,1225.95>
  }
  smooth_triangle { // #7449
		<884.05,463.65,1295.75>, <1,0,0>,
		<884.05,309.9,1225.95>, <1,-0.025,0>,
		<884.05,463.65,1270.6>, <1,0,0>
  }
  triangle { // #7450
		<884.05,520.85,1340.35>,
		<884.05,488.75,1270.6>,
		<884.05,520.85,1225.95>
  }
  triangle { // #7451
		<884.05,520.85,1340.35>,
		<884.05,488.75,1295.75>,
		<884.05,488.75,1270.6>
  }
  smooth_triangle { // #7452
		<884.05,488.75,1270.6>, <1,0,0>,
		<884.05,309.9,1225.95>, <1,-0.025,0>,
		<884.05,520.85,1225.95>, <1,-0,0>
  }
  smooth_triangle { // #7453
		<884.05,463.65,1270.6>, <1,0,0>,
		<884.05,309.9,1225.95>, <1,-0.025,0>,
		<884.05,488.75,1270.6>, <1,0,0>
  }
  smooth_triangle { // #7454
		<884.05,309.9,1340.35>, <1,0.031,0>,
		<884.05,488.75,1295.75>, <1,0,0>,
		<884.05,520.85,1340.35>, <1,0,0>
  }
  smooth_triangle { // #7455
		<884.05,309.9,1340.35>, <1,0.031,0>,
		<884.05,463.65,1295.75>, <1,0,0>,
		<884.05,488.75,1295.75>, <1,0,0>
  }
  smooth_triangle { // #7456
		<884.05,309.9,1225.95>, <1,-0.025,0>,
		<884.05,463.65,1295.75>, <1,0,0>,
		<884.05,309.9,1340.35>, <1,0.031,0>
  }
  triangle { // #7457
		<879.35,309.9,1340.35>,
		<884.05,520.85,1340.35>,
		<879.35,520.85,1340.35>
  }
  triangle { // #7458
		<884.05,520.85,1340.35>,
		<879.35,309.9,1340.35>,
		<884.05,309.9,1340.35>
  }
  triangle { // #7459
		<879.35,309.9,1225.95>,
		<879.35,463.65,1295.75>,
		<879.35,463.65,1270.6>
  }
  triangle { // #7460
		<879.35,488.75,1270.6>,
		<879.35,520.85,1340.35>,
		<879.35,520.85,1225.95>
  }
  triangle { // #7461
		<879.35,488.75,1295.75>,
		<879.35,520.85,1340.35>,
		<879.35,488.75,1270.6>
  }
  triangle { // #7462
		<879.35,309.9,1225.95>,
		<879.35,488.75,1270.6>,
		<879.35,520.85,1225.95>
  }
  triangle { // #7463
		<879.35,309.9,1225.95>,
		<879.35,463.65,1270.6>,
		<879.35,488.75,1270.6>
  }
  triangle { // #7464
		<879.35,488.75,1295.75>,
		<879.35,309.9,1340.35>,
		<879.35,520.85,1340.35>
  }
  triangle { // #7465
		<879.35,463.65,1295.75>,
		<879.35,309.9,1340.35>,
		<879.35,488.75,1295.75>
  }
  triangle { // #7466
		<879.35,463.65,1295.75>,
		<879.35,309.9,1225.95>,
		<879.35,309.9,1340.35>
  }
  triangle { // #7467
		<879.35,520.85,1225.95>,
		<884.05,520.85,1340.35>,
		<884.05,520.85,1225.95>
  }
  triangle { // #7468
		<884.05,520.85,1340.35>,
		<879.35,520.85,1225.95>,
		<879.35,520.85,1340.35>
  }
  triangle { // #7469
		<879.35,463.65,1295.75>,
		<884.05,463.65,1270.6>,
		<879.35,463.65,1270.6>
  }
  triangle { // #7470
		<884.05,463.65,1270.6>,
		<879.35,463.65,1295.75>,
		<884.05,463.65,1295.75>
  }
  triangle { // #7471
		<879.35,463.65,1270.6>,
		<884.05,488.75,1270.6>,
		<879.35,488.75,1270.6>
  }
  triangle { // #7472
		<884.05,488.75,1270.6>,
		<879.35,463.65,1270.6>,
		<884.05,463.65,1270.6>
  }
  triangle { // #7473
		<879.35,488.75,1270.6>,
		<884.05,488.75,1295.75>,
		<879.35,488.75,1295.75>
  }
  triangle { // #7474
		<884.05,488.75,1295.75>,
		<879.35,488.75,1270.6>,
		<884.05,488.75,1270.6>
  }
  triangle { // #7475
		<879.35,488.75,1295.75>,
		<884.05,463.65,1295.75>,
		<879.35,463.65,1295.75>
  }
  triangle { // #7476
		<884.05,463.65,1295.75>,
		<879.35,488.75,1295.75>,
		<884.05,488.75,1295.75>
  }
  triangle { // #7477
		<472.7,-0,1486.75>,
		<474.25,-0,1486.45>,
		<474.15,-0,1493.55>
  }
  triangle { // #7478
		<480.45,-0,1479.35>,
		<481.5,-0,1484.25>,
		<473.3,-0,1481.85>
  }
  triangle { // #7479
		<473.3,-0,1481.85>,
		<481.5,-0,1484.25>,
		<474.25,-0,1486.45>
  }
  triangle { // #7480
		<484.3,-0,1497.5>,
		<476.75,-0,1498.15>,
		<481.5,-0,1484.25>
  }
  triangle { // #7481
		<476.75,-0,1498.15>,
		<475.7,-0,1493.2>,
		<481.5,-0,1484.25>
  }
  triangle { // #7482
		<481.5,-0,1484.25>,
		<475.7,-0,1493.2>,
		<474.25,-0,1486.45>
  }
  triangle { // #7483
		<475.7,-0,1493.2>,
		<474.15,-0,1493.55>,
		<474.25,-0,1486.45>
  }
  triangle { // #7484
		<474.15,207.45,1493.55>,
		<475.7,207.45,1493.2>,
		<472.7,207.45,1486.75>
  }
  triangle { // #7485
		<480.45,207.45,1479.35>,
		<473.3,207.45,1481.85>,
		<481.5,207.45,1484.25>
  }
  triangle { // #7486
		<473.3,207.45,1481.85>,
		<474.25,207.45,1486.45>,
		<481.5,207.45,1484.25>
  }
  triangle { // #7487
		<484.3,207.45,1497.5>,
		<481.5,207.45,1484.25>,
		<476.75,207.45,1498.15>
  }
  triangle { // #7488
		<476.75,207.45,1498.15>,
		<481.5,207.45,1484.25>,
		<475.7,207.45,1493.2>
  }
  triangle { // #7489
		<481.5,207.45,1484.25>,
		<474.25,207.45,1486.45>,
		<475.7,207.45,1493.2>
  }
  triangle { // #7490
		<474.25,207.45,1486.45>,
		<472.7,207.45,1486.75>,
		<475.7,207.45,1493.2>
  }
  triangle { // #7491
		<481.5,-0,1484.25>,
		<481.5,207.45,1484.25>,
		<484.3,-0,1497.5>
  }
  triangle { // #7492
		<484.3,207.45,1497.5>,
		<484.3,-0,1497.5>,
		<481.5,207.45,1484.25>
  }
  triangle { // #7493
		<480.45,-0,1479.35>,
		<480.45,207.45,1479.35>,
		<481.5,-0,1484.25>
  }
  triangle { // #7494
		<481.5,207.45,1484.25>,
		<481.5,-0,1484.25>,
		<480.45,207.45,1479.35>
  }
  triangle { // #7495
		<473.3,-0,1481.85>,
		<473.3,207.45,1481.85>,
		<480.45,-0,1479.35>
  }
  smooth_triangle { // #7496
		<480.45,207.45,1479.35>, <-0.248,0.965,-0.083>,
		<480.45,-0,1479.35>, <-0.328,0.945,-0>,
		<473.3,207.45,1481.85>, <-0.328,0.945,-0>
  }
  triangle { // #7497
		<474.25,-0,1486.45>,
		<474.25,207.45,1486.45>,
		<473.3,-0,1481.85>
  }
  triangle { // #7498
		<473.3,207.45,1481.85>,
		<473.3,-0,1481.85>,
		<474.25,207.45,1486.45>
  }
  triangle { // #7499
		<472.7,-0,1486.75>,
		<472.7,207.45,1486.75>,
		<474.25,-0,1486.45>
  }
  triangle { // #7500
		<474.25,207.45,1486.45>,
		<474.25,-0,1486.45>,
		<472.7,207.45,1486.75>
  }
  triangle { // #7501
		<474.15,-0,1493.55>,
		<474.15,207.45,1493.55>,
		<472.7,-0,1486.75>
  }
  triangle { // #7502
		<472.7,207.45,1486.75>,
		<472.7,-0,1486.75>,
		<474.15,207.45,1493.55>
  }
  triangle { // #7503
		<475.7,-0,1493.2>,
		<475.7,207.45,1493.2>,
		<474.15,-0,1493.55>
  }
  triangle { // #7504
		<474.15,207.45,1493.55>,
		<474.15,-0,1493.55>,
		<475.7,207.45,1493.2>
  }
  triangle { // #7505
		<476.75,-0,1498.15>,
		<476.75,207.45,1498.15>,
		<475.7,-0,1493.2>
  }
  triangle { // #7506
		<475.7,207.45,1493.2>,
		<475.7,-0,1493.2>,
		<476.75,207.45,1498.15>
  }
  smooth_triangle { // #7507
		<484.3,-0,1497.5>, <0.085,-0.996,0>,
		<484.3,207.45,1497.5>, <0.146,-0.987,-0.062>,
		<476.75,-0,1498.15>, <0.085,-0.996,0>
  }
  smooth_triangle { // #7508
		<476.75,207.45,1498.15>, <0.085,-0.996,0>,
		<476.75,-0,1498.15>, <0.085,-0.996,0>,
		<484.3,207.45,1497.5>, <0.146,-0.987,-0.062>
  }
  triangle { // #7509
		<387.25,-0,1504.95>,
		<387.15,-0,1512.05>,
		<385.7,-0,1505.25>
  }
  triangle { // #7510
		<384.75,-0,1500.65>,
		<378.2,-0,1506.2>,
		<377.15,-0,1501.3>
  }
  triangle { // #7511
		<385.7,-0,1505.25>,
		<378.2,-0,1506.2>,
		<384.75,-0,1500.65>
  }
  triangle { // #7512
		<378.2,-0,1506.2>,
		<388.2,-0,1516.95>,
		<381,-0,1519.45>
  }
  triangle { // #7513
		<378.2,-0,1506.2>,
		<387.15,-0,1512.05>,
		<388.2,-0,1516.95>
  }
  triangle { // #7514
		<385.7,-0,1505.25>,
		<387.15,-0,1512.05>,
		<378.2,-0,1506.2>
  }
  triangle { // #7515
		<387.15,-0,1512.05>,
		<387.25,-0,1504.95>,
		<388.7,-0,1511.7>
  }
  triangle { // #7516
		<387.25,207.45,1504.95>,
		<387.15,207.45,1512.05>,
		<388.7,207.45,1511.7>
  }
  triangle { // #7517
		<378.2,207.45,1506.2>,
		<384.75,207.45,1500.65>,
		<377.15,207.45,1501.3>
  }
  triangle { // #7518
		<378.2,207.45,1506.2>,
		<385.7,207.45,1505.25>,
		<384.75,207.45,1500.65>
  }
  triangle { // #7519
		<388.2,207.45,1516.95>,
		<378.2,207.45,1506.2>,
		<381,207.45,1519.45>
  }
  triangle { // #7520
		<387.15,207.45,1512.05>,
		<378.2,207.45,1506.2>,
		<388.2,207.45,1516.95>
  }
  triangle { // #7521
		<387.15,207.45,1512.05>,
		<385.7,207.45,1505.25>,
		<378.2,207.45,1506.2>
  }
  triangle { // #7522
		<387.15,207.45,1512.05>,
		<387.25,207.45,1504.95>,
		<385.7,207.45,1505.25>
  }
  triangle { // #7523
		<381,-0,1519.45>,
		<378.2,207.45,1506.2>,
		<378.2,-0,1506.2>
  }
  triangle { // #7524
		<378.2,207.45,1506.2>,
		<381,-0,1519.45>,
		<381,207.45,1519.45>
  }
  triangle { // #7525
		<377.15,-0,1501.3>,
		<378.2,207.45,1506.2>,
		<377.15,207.45,1501.3>
  }
  triangle { // #7526
		<378.2,207.45,1506.2>,
		<377.15,-0,1501.3>,
		<378.2,-0,1506.2>
  }
  triangle { // #7527
		<377.15,-0,1501.3>,
		<384.75,207.45,1500.65>,
		<384.75,-0,1500.65>
  }
  smooth_triangle { // #7528
		<384.75,207.45,1500.65>, <-0.085,0.996,0>,
		<377.15,-0,1501.3>, <-0.085,0.996,0>,
		<377.15,207.45,1501.3>, <-0.146,0.987,-0.062>
  }
  triangle { // #7529
		<384.75,-0,1500.65>,
		<385.7,207.45,1505.25>,
		<385.7,-0,1505.25>
  }
  triangle { // #7530
		<385.7,207.45,1505.25>,
		<384.75,-0,1500.65>,
		<384.75,207.45,1500.65>
  }
  triangle { // #7531
		<385.7,-0,1505.25>,
		<387.25,207.45,1504.95>,
		<387.25,-0,1504.95>
  }
  triangle { // #7532
		<387.25,207.45,1504.95>,
		<385.7,-0,1505.25>,
		<385.7,207.45,1505.25>
  }
  triangle { // #7533
		<387.25,-0,1504.95>,
		<388.7,207.45,1511.7>,
		<388.7,-0,1511.7>
  }
  triangle { // #7534
		<388.7,207.45,1511.7>,
		<387.25,-0,1504.95>,
		<387.25,207.45,1504.95>
  }
  triangle { // #7535
		<388.7,-0,1511.7>,
		<387.15,207.45,1512.05>,
		<387.15,-0,1512.05>
  }
  triangle { // #7536
		<387.15,207.45,1512.05>,
		<388.7,-0,1511.7>,
		<388.7,207.45,1511.7>
  }
  triangle { // #7537
		<387.15,-0,1512.05>,
		<388.2,207.45,1516.95>,
		<388.2,-0,1516.95>
  }
  triangle { // #7538
		<388.2,207.45,1516.95>,
		<387.15,-0,1512.05>,
		<387.15,207.45,1512.05>
  }
  smooth_triangle { // #7539
		<388.2,-0,1516.95>, <0.328,-0.945,0>,
		<381,207.45,1519.45>, <0.288,-0.957,-0.041>,
		<381,-0,1519.45>, <0.328,-0.945,0>
  }
  smooth_triangle { // #7540
		<381,207.45,1519.45>, <0.288,-0.957,-0.041>,
		<388.2,-0,1516.95>, <0.328,-0.945,0>,
		<388.2,207.45,1516.95>, <0.328,-0.945,0>
  }
  triangle { // #7541
		<379.75,198.35,1513.6>,
		<378.35,199.9,1506.85>,
		<378.35,198.35,1506.85>
  }
  triangle { // #7542
		<377.35,199.9,1502.2>,
		<378.2,207.45,1506.2>,
		<377.15,207.45,1501.3>
  }
  triangle { // #7543
		<378.35,199.9,1506.85>,
		<378.2,207.45,1506.2>,
		<377.35,199.9,1502.2>
  }
  triangle { // #7544
		<378.2,207.45,1506.2>,
		<380.8,199.9,1518.5>,
		<381,207.45,1519.45>
  }
  triangle { // #7545
		<378.2,207.45,1506.2>,
		<379.75,199.9,1513.6>,
		<380.8,199.9,1518.5>
  }
  triangle { // #7546
		<378.35,199.9,1506.85>,
		<379.75,199.9,1513.6>,
		<378.2,207.45,1506.2>
  }
  triangle { // #7547
		<378.35,199.9,1506.85>,
		<379.75,198.35,1513.6>,
		<379.75,199.9,1513.6>
  }
  triangle { // #7548
		<481.65,198.35,1484.9>,
		<483.1,199.9,1491.65>,
		<483.1,198.35,1491.65>
  }
  triangle { // #7549
		<481.5,207.45,1484.25>,
		<480.65,199.9,1480.25>,
		<480.45,207.45,1479.35>
  }
  triangle { // #7550
		<481.5,207.45,1484.25>,
		<481.65,199.9,1484.9>,
		<480.65,199.9,1480.25>
  }
  triangle { // #7551
		<484.1,199.9,1496.55>,
		<481.5,207.45,1484.25>,
		<484.3,207.45,1497.5>
  }
  triangle { // #7552
		<483.1,199.9,1491.65>,
		<481.5,207.45,1484.25>,
		<484.1,199.9,1496.55>
  }
  triangle { // #7553
		<483.1,199.9,1491.65>,
		<481.65,199.9,1484.9>,
		<481.5,207.45,1484.25>
  }
  triangle { // #7554
		<483.1,199.9,1491.65>,
		<481.65,198.35,1484.9>,
		<481.65,199.9,1484.9>
  }
  triangle { // #7555
		<378.2,207.45,1506.2>,
		<484.3,207.45,1497.5>,
		<481.5,207.45,1484.25>
  }
  triangle { // #7556
		<484.3,207.45,1497.5>,
		<378.2,207.45,1506.2>,
		<381,207.45,1519.45>
  }
  triangle { // #7557
		<377.15,207.45,1501.3>,
		<481.5,207.45,1484.25>,
		<480.45,207.45,1479.35>
  }
  triangle { // #7558
		<481.5,207.45,1484.25>,
		<377.15,207.45,1501.3>,
		<378.2,207.45,1506.2>
  }
  smooth_triangle { // #7559
		<377.35,199.9,1502.2>, <-0.206,0.971,-0.124>,
		<480.45,207.45,1479.35>, <-0.248,0.965,-0.083>,
		<480.65,199.9,1480.25>, <-0.206,0.971,-0.124>
  }
  smooth_triangle { // #7560
		<480.45,207.45,1479.35>, <-0.248,0.965,-0.083>,
		<377.35,199.9,1502.2>, <-0.206,0.971,-0.124>,
		<377.15,207.45,1501.3>, <-0.146,0.987,-0.062>
  }
  triangle { // #7561
		<377.35,199.9,1502.2>,
		<481.65,199.9,1484.9>,
		<378.35,199.9,1506.85>
  }
  triangle { // #7562
		<481.65,199.9,1484.9>,
		<377.35,199.9,1502.2>,
		<480.65,199.9,1480.25>
  }
  triangle { // #7563
		<378.35,199.9,1506.85>,
		<481.65,198.35,1484.9>,
		<378.35,198.35,1506.85>
  }
  triangle { // #7564
		<481.65,198.35,1484.9>,
		<378.35,199.9,1506.85>,
		<481.65,199.9,1484.9>
  }
  triangle { // #7565
		<378.35,198.35,1506.85>,
		<483.1,198.35,1491.65>,
		<379.75,198.35,1513.6>
  }
  triangle { // #7566
		<483.1,198.35,1491.65>,
		<378.35,198.35,1506.85>,
		<481.65,198.35,1484.9>
  }
  triangle { // #7567
		<379.75,198.35,1513.6>,
		<483.1,199.9,1491.65>,
		<379.75,199.9,1513.6>
  }
  triangle { // #7568
		<483.1,199.9,1491.65>,
		<379.75,198.35,1513.6>,
		<483.1,198.35,1491.65>
  }
  triangle { // #7569
		<380.8,199.9,1518.5>,
		<483.1,199.9,1491.65>,
		<484.1,199.9,1496.55>
  }
  triangle { // #7570
		<483.1,199.9,1491.65>,
		<380.8,199.9,1518.5>,
		<379.75,199.9,1513.6>
  }
  smooth_triangle { // #7571
		<380.8,199.9,1518.5>, <0.206,-0.971,-0.124>,
		<484.3,207.45,1497.5>, <0.146,-0.987,-0.062>,
		<381,207.45,1519.45>, <0.288,-0.957,-0.041>
  }
  smooth_triangle { // #7572
		<484.3,207.45,1497.5>, <0.146,-0.987,-0.062>,
		<380.8,199.9,1518.5>, <0.206,-0.971,-0.124>,
		<484.1,199.9,1496.55>, <0.206,-0.971,-0.124>
  }
  triangle { // #7573
		<483.1,-0,1588.55>,
		<476.75,-0,1498.15>,
		<487.75,-0,1588>
  }
  triangle { // #7574
		<476.75,-0,1498.15>,
		<483.1,-0,1588.55>,
		<472.05,-0,1498.7>
  }
  triangle { // #7575
		<472.05,-0,1498.7>,
		<478.95,144.6,1554.85>,
		<476.2,144.6,1532.4>
  }
  triangle { // #7576
		<476.2,167.2,1532.4>,
		<483.1,199.9,1588.55>,
		<472.05,199.9,1498.7>
  }
  triangle { // #7577
		<478.95,167.2,1554.85>,
		<483.1,199.9,1588.55>,
		<476.2,167.2,1532.4>
  }
  triangle { // #7578
		<478.95,167.2,1554.85>,
		<483.1,-0,1588.55>,
		<483.1,199.9,1588.55>
  }
  triangle { // #7579
		<478.95,144.6,1554.85>,
		<483.1,-0,1588.55>,
		<478.95,167.2,1554.85>
  }
  triangle { // #7580
		<472.05,-0,1498.7>,
		<476.2,167.2,1532.4>,
		<472.05,199.9,1498.7>
  }
  triangle { // #7581
		<472.05,-0,1498.7>,
		<476.2,144.6,1532.4>,
		<476.2,167.2,1532.4>
  }
  triangle { // #7582
		<478.95,144.6,1554.85>,
		<472.05,-0,1498.7>,
		<483.1,-0,1588.55>
  }
  triangle { // #7583
		<476.75,-0,1498.15>,
		<472.05,199.9,1498.7>,
		<476.75,199.9,1498.15>
  }
  triangle { // #7584
		<472.05,199.9,1498.7>,
		<476.75,-0,1498.15>,
		<472.05,-0,1498.7>
  }
  triangle { // #7585
		<483.65,144.6,1554.3>,
		<476.75,-0,1498.15>,
		<480.9,144.6,1531.8>
  }
  triangle { // #7586
		<487.75,199.9,1588>,
		<480.9,167.2,1531.8>,
		<476.75,199.9,1498.15>
  }
  triangle { // #7587
		<487.75,199.9,1588>,
		<483.65,167.2,1554.3>,
		<480.9,167.2,1531.8>
  }
  triangle { // #7588
		<487.75,-0,1588>,
		<483.65,167.2,1554.3>,
		<487.75,199.9,1588>
  }
  triangle { // #7589
		<487.75,-0,1588>,
		<483.65,144.6,1554.3>,
		<483.65,167.2,1554.3>
  }
  triangle { // #7590
		<480.9,167.2,1531.8>,
		<476.75,-0,1498.15>,
		<476.75,199.9,1498.15>
  }
  triangle { // #7591
		<480.9,144.6,1531.8>,
		<476.75,-0,1498.15>,
		<480.9,167.2,1531.8>
  }
  triangle { // #7592
		<476.75,-0,1498.15>,
		<483.65,144.6,1554.3>,
		<487.75,-0,1588>
  }
  triangle { // #7593
		<483.1,-0,1588.55>,
		<487.75,199.9,1588>,
		<483.1,199.9,1588.55>
  }
  triangle { // #7594
		<487.75,199.9,1588>,
		<483.1,-0,1588.55>,
		<487.75,-0,1588>
  }
  triangle { // #7595
		<483.1,199.9,1588.55>,
		<476.75,199.9,1498.15>,
		<472.05,199.9,1498.7>
  }
  triangle { // #7596
		<476.75,199.9,1498.15>,
		<483.1,199.9,1588.55>,
		<487.75,199.9,1588>
  }
  triangle { // #7597
		<480.9,144.6,1531.8>,
		<478.95,144.6,1554.85>,
		<483.65,144.6,1554.3>
  }
  triangle { // #7598
		<478.95,144.6,1554.85>,
		<480.9,144.6,1531.8>,
		<476.2,144.6,1532.4>
  }
  triangle { // #7599
		<478.95,144.6,1554.85>,
		<483.65,167.2,1554.3>,
		<483.65,144.6,1554.3>
  }
  triangle { // #7600
		<483.65,167.2,1554.3>,
		<478.95,144.6,1554.85>,
		<478.95,167.2,1554.85>
  }
  triangle { // #7601
		<478.95,167.2,1554.85>,
		<480.9,167.2,1531.8>,
		<483.65,167.2,1554.3>
  }
  triangle { // #7602
		<480.9,167.2,1531.8>,
		<478.95,167.2,1554.85>,
		<476.2,167.2,1532.4>
  }
  triangle { // #7603
		<476.2,167.2,1532.4>,
		<480.9,144.6,1531.8>,
		<480.9,167.2,1531.8>
  }
  triangle { // #7604
		<480.9,144.6,1531.8>,
		<476.2,167.2,1532.4>,
		<476.2,144.6,1532.4>
  }
  triangle { // #7605
		<-388.6,-0,1505.35>,
		<-387.05,-0,1505.65>,
		<-389.95,-0,1512.15>
  }
  triangle { // #7606
		<-378.6,-0,1501.55>,
		<-379.55,-0,1506.5>,
		<-386.15,-0,1501.05>
  }
  triangle { // #7607
		<-386.15,-0,1501.05>,
		<-379.55,-0,1506.5>,
		<-387.05,-0,1505.65>
  }
  triangle { // #7608
		<-382.15,-0,1519.75>,
		<-389.35,-0,1517.4>,
		<-379.55,-0,1506.5>
  }
  triangle { // #7609
		<-389.35,-0,1517.4>,
		<-388.4,-0,1512.45>,
		<-379.55,-0,1506.5>
  }
  triangle { // #7610
		<-379.55,-0,1506.5>,
		<-388.4,-0,1512.45>,
		<-387.05,-0,1505.65>
  }
  triangle { // #7611
		<-388.4,-0,1512.45>,
		<-389.95,-0,1512.15>,
		<-387.05,-0,1505.65>
  }
  triangle { // #7612
		<-389.95,207.45,1512.15>,
		<-388.4,207.45,1512.45>,
		<-388.6,207.45,1505.35>
  }
  triangle { // #7613
		<-378.6,207.45,1501.55>,
		<-386.15,207.45,1501.05>,
		<-379.55,207.45,1506.5>
  }
  triangle { // #7614
		<-386.15,207.45,1501.05>,
		<-387.05,207.45,1505.65>,
		<-379.55,207.45,1506.5>
  }
  triangle { // #7615
		<-382.15,207.45,1519.75>,
		<-379.55,207.45,1506.5>,
		<-389.35,207.45,1517.4>
  }
  triangle { // #7616
		<-389.35,207.45,1517.4>,
		<-379.55,207.45,1506.5>,
		<-388.4,207.45,1512.45>
  }
  triangle { // #7617
		<-379.55,207.45,1506.5>,
		<-387.05,207.45,1505.65>,
		<-388.4,207.45,1512.45>
  }
  triangle { // #7618
		<-387.05,207.45,1505.65>,
		<-388.6,207.45,1505.35>,
		<-388.4,207.45,1512.45>
  }
  triangle { // #7619
		<-379.55,-0,1506.5>,
		<-379.55,207.45,1506.5>,
		<-382.15,-0,1519.75>
  }
  triangle { // #7620
		<-382.15,207.45,1519.75>,
		<-382.15,-0,1519.75>,
		<-379.55,207.45,1506.5>
  }
  triangle { // #7621
		<-378.6,-0,1501.55>,
		<-378.6,207.45,1501.55>,
		<-379.55,-0,1506.5>
  }
  triangle { // #7622
		<-379.55,207.45,1506.5>,
		<-379.55,-0,1506.5>,
		<-378.6,207.45,1501.55>
  }
  triangle { // #7623
		<-386.15,-0,1501.05>,
		<-386.15,207.45,1501.05>,
		<-378.6,-0,1501.55>
  }
  smooth_triangle { // #7624
		<-378.6,207.45,1501.55>, <0.129,0.99,-0.062>,
		<-378.6,-0,1501.55>, <0.068,0.998,0>,
		<-386.15,207.45,1501.05>, <0.068,0.998,0>
  }
  triangle { // #7625
		<-387.05,-0,1505.65>,
		<-387.05,207.45,1505.65>,
		<-386.15,-0,1501.05>
  }
  triangle { // #7626
		<-386.15,207.45,1501.05>,
		<-386.15,-0,1501.05>,
		<-387.05,207.45,1505.65>
  }
  triangle { // #7627
		<-388.6,-0,1505.35>,
		<-388.6,207.45,1505.35>,
		<-387.05,-0,1505.65>
  }
  triangle { // #7628
		<-387.05,207.45,1505.65>,
		<-387.05,-0,1505.65>,
		<-388.6,207.45,1505.35>
  }
  triangle { // #7629
		<-389.95,-0,1512.15>,
		<-389.95,207.45,1512.15>,
		<-388.6,-0,1505.35>
  }
  triangle { // #7630
		<-388.6,207.45,1505.35>,
		<-388.6,-0,1505.35>,
		<-389.95,207.45,1512.15>
  }
  triangle { // #7631
		<-388.4,-0,1512.45>,
		<-388.4,207.45,1512.45>,
		<-389.95,-0,1512.15>
  }
  triangle { // #7632
		<-389.95,207.45,1512.15>,
		<-389.95,-0,1512.15>,
		<-388.4,207.45,1512.45>
  }
  triangle { // #7633
		<-389.35,-0,1517.4>,
		<-389.35,207.45,1517.4>,
		<-388.4,-0,1512.45>
  }
  triangle { // #7634
		<-388.4,207.45,1512.45>,
		<-388.4,-0,1512.45>,
		<-389.35,207.45,1517.4>
  }
  smooth_triangle { // #7635
		<-382.15,-0,1519.75>, <-0.311,-0.95,0>,
		<-382.15,207.45,1519.75>, <-0.251,-0.966,-0.062>,
		<-389.35,-0,1517.4>, <-0.311,-0.95,0>
  }
  smooth_triangle { // #7636
		<-389.35,207.45,1517.4>, <-0.311,-0.95,0>,
		<-389.35,-0,1517.4>, <-0.311,-0.95,0>,
		<-382.15,207.45,1519.75>, <-0.251,-0.966,-0.062>
  }
  triangle { // #7637
		<-477.25,-0,1495.2>,
		<-474.4,-0,1488.7>,
		<-475.7,-0,1495.5>
  }
  triangle { // #7638
		<-475.05,-0,1483.75>,
		<-483.2,-0,1486.35>,
		<-482.25,-0,1481.4>
  }
  triangle { // #7639
		<-475.95,-0,1488.4>,
		<-483.2,-0,1486.35>,
		<-475.05,-0,1483.75>
  }
  triangle { // #7640
		<-483.2,-0,1486.35>,
		<-478.2,-0,1500.15>,
		<-485.8,-0,1499.6>
  }
  triangle { // #7641
		<-483.2,-0,1486.35>,
		<-477.25,-0,1495.2>,
		<-478.2,-0,1500.15>
  }
  triangle { // #7642
		<-475.95,-0,1488.4>,
		<-477.25,-0,1495.2>,
		<-483.2,-0,1486.35>
  }
  triangle { // #7643
		<-474.4,-0,1488.7>,
		<-477.25,-0,1495.2>,
		<-475.95,-0,1488.4>
  }
  triangle { // #7644
		<-474.4,207.45,1488.7>,
		<-477.25,207.45,1495.2>,
		<-475.7,207.45,1495.5>
  }
  triangle { // #7645
		<-483.2,207.45,1486.35>,
		<-475.05,207.45,1483.75>,
		<-482.25,207.45,1481.4>
  }
  triangle { // #7646
		<-483.2,207.45,1486.35>,
		<-475.95,207.45,1488.4>,
		<-475.05,207.45,1483.75>
  }
  triangle { // #7647
		<-478.2,207.45,1500.15>,
		<-483.2,207.45,1486.35>,
		<-485.8,207.45,1499.6>
  }
  triangle { // #7648
		<-477.25,207.45,1495.2>,
		<-483.2,207.45,1486.35>,
		<-478.2,207.45,1500.15>
  }
  triangle { // #7649
		<-477.25,207.45,1495.2>,
		<-475.95,207.45,1488.4>,
		<-483.2,207.45,1486.35>
  }
  triangle { // #7650
		<-477.25,207.45,1495.2>,
		<-474.4,207.45,1488.7>,
		<-475.95,207.45,1488.4>
  }
  triangle { // #7651
		<-485.8,-0,1499.6>,
		<-483.2,207.45,1486.35>,
		<-483.2,-0,1486.35>
  }
  triangle { // #7652
		<-483.2,207.45,1486.35>,
		<-485.8,-0,1499.6>,
		<-485.8,207.45,1499.6>
  }
  triangle { // #7653
		<-483.2,-0,1486.35>,
		<-482.25,207.45,1481.4>,
		<-482.25,-0,1481.4>
  }
  triangle { // #7654
		<-482.25,207.45,1481.4>,
		<-483.2,-0,1486.35>,
		<-483.2,207.45,1486.35>
  }
  triangle { // #7655
		<-482.25,-0,1481.4>,
		<-475.05,207.45,1483.75>,
		<-475.05,-0,1483.75>
  }
  smooth_triangle { // #7656
		<-475.05,207.45,1483.75>, <0.311,0.95,-0>,
		<-482.25,-0,1481.4>, <0.311,0.95,-0>,
		<-482.25,207.45,1481.4>, <0.231,0.969,-0.083>
  }
  triangle { // #7657
		<-475.05,-0,1483.75>,
		<-475.95,207.45,1488.4>,
		<-475.95,-0,1488.4>
  }
  triangle { // #7658
		<-475.95,207.45,1488.4>,
		<-475.05,-0,1483.75>,
		<-475.05,207.45,1483.75>
  }
  triangle { // #7659
		<-474.4,-0,1488.7>,
		<-475.95,207.45,1488.4>,
		<-474.4,207.45,1488.7>
  }
  triangle { // #7660
		<-475.95,207.45,1488.4>,
		<-474.4,-0,1488.7>,
		<-475.95,-0,1488.4>
  }
  triangle { // #7661
		<-474.4,-0,1488.7>,
		<-475.7,207.45,1495.5>,
		<-475.7,-0,1495.5>
  }
  triangle { // #7662
		<-475.7,207.45,1495.5>,
		<-474.4,-0,1488.7>,
		<-474.4,207.45,1488.7>
  }
  triangle { // #7663
		<-477.25,-0,1495.2>,
		<-475.7,207.45,1495.5>,
		<-477.25,207.45,1495.2>
  }
  triangle { // #7664
		<-475.7,207.45,1495.5>,
		<-477.25,-0,1495.2>,
		<-475.7,-0,1495.5>
  }
  triangle { // #7665
		<-477.25,-0,1495.2>,
		<-478.2,207.45,1500.15>,
		<-478.2,-0,1500.15>
  }
  triangle { // #7666
		<-478.2,207.45,1500.15>,
		<-477.25,-0,1495.2>,
		<-477.25,207.45,1495.2>
  }
  smooth_triangle { // #7667
		<-478.2,-0,1500.15>, <-0.068,-0.998,0>,
		<-485.8,207.45,1499.6>, <-0.109,-0.993,-0.042>,
		<-485.8,-0,1499.6>, <-0.068,-0.998,0>
  }
  smooth_triangle { // #7668
		<-485.8,207.45,1499.6>, <-0.109,-0.993,-0.042>,
		<-478.2,-0,1500.15>, <-0.068,-0.998,0>,
		<-478.2,207.45,1500.15>, <-0.068,-0.998,0>
  }
  triangle { // #7669
		<-484.65,198.35,1493.75>,
		<-483.35,199.9,1486.95>,
		<-483.35,198.35,1486.95>
  }
  triangle { // #7670
		<-482.45,199.9,1482.35>,
		<-483.2,207.45,1486.35>,
		<-482.25,207.45,1481.4>
  }
  triangle { // #7671
		<-483.35,199.9,1486.95>,
		<-483.2,207.45,1486.35>,
		<-482.45,199.9,1482.35>
  }
  triangle { // #7672
		<-483.2,207.45,1486.35>,
		<-485.6,199.9,1498.7>,
		<-485.8,207.45,1499.6>
  }
  triangle { // #7673
		<-483.2,207.45,1486.35>,
		<-484.65,199.9,1493.75>,
		<-485.6,199.9,1498.7>
  }
  triangle { // #7674
		<-483.35,199.9,1486.95>,
		<-484.65,199.9,1493.75>,
		<-483.2,207.45,1486.35>
  }
  triangle { // #7675
		<-483.35,199.9,1486.95>,
		<-484.65,198.35,1493.75>,
		<-484.65,199.9,1493.75>
  }
  triangle { // #7676
		<-379.65,198.35,1507.1>,
		<-381,199.9,1513.9>,
		<-381,198.35,1513.9>
  }
  triangle { // #7677
		<-379.55,207.45,1506.5>,
		<-378.75,199.9,1502.5>,
		<-378.6,207.45,1501.55>
  }
  triangle { // #7678
		<-379.55,207.45,1506.5>,
		<-379.65,199.9,1507.1>,
		<-378.75,199.9,1502.5>
  }
  triangle { // #7679
		<-381.95,199.9,1518.85>,
		<-379.55,207.45,1506.5>,
		<-382.15,207.45,1519.75>
  }
  triangle { // #7680
		<-381,199.9,1513.9>,
		<-379.55,207.45,1506.5>,
		<-381.95,199.9,1518.85>
  }
  triangle { // #7681
		<-381,199.9,1513.9>,
		<-379.65,199.9,1507.1>,
		<-379.55,207.45,1506.5>
  }
  triangle { // #7682
		<-381,199.9,1513.9>,
		<-379.65,198.35,1507.1>,
		<-379.65,199.9,1507.1>
  }
  triangle { // #7683
		<-483.2,207.45,1486.35>,
		<-382.15,207.45,1519.75>,
		<-379.55,207.45,1506.5>
  }
  triangle { // #7684
		<-382.15,207.45,1519.75>,
		<-483.2,207.45,1486.35>,
		<-485.8,207.45,1499.6>
  }
  triangle { // #7685
		<-482.25,207.45,1481.4>,
		<-379.55,207.45,1506.5>,
		<-378.6,207.45,1501.55>
  }
  triangle { // #7686
		<-379.55,207.45,1506.5>,
		<-482.25,207.45,1481.4>,
		<-483.2,207.45,1486.35>
  }
  smooth_triangle { // #7687
		<-482.25,207.45,1481.4>, <0.231,0.969,-0.083>,
		<-378.75,199.9,1502.5>, <0.189,0.974,-0.124>,
		<-482.45,199.9,1482.35>, <0.189,0.974,-0.124>
  }
  smooth_triangle { // #7688
		<-378.75,199.9,1502.5>, <0.189,0.974,-0.124>,
		<-482.25,207.45,1481.4>, <0.231,0.969,-0.083>,
		<-378.6,207.45,1501.55>, <0.129,0.99,-0.062>
  }
  triangle { // #7689
		<-483.35,199.9,1486.95>,
		<-378.75,199.9,1502.5>,
		<-379.65,199.9,1507.1>
  }
  triangle { // #7690
		<-378.75,199.9,1502.5>,
		<-483.35,199.9,1486.95>,
		<-482.45,199.9,1482.35>
  }
  triangle { // #7691
		<-483.35,199.9,1486.95>,
		<-379.65,198.35,1507.1>,
		<-483.35,198.35,1486.95>
  }
  triangle { // #7692
		<-379.65,198.35,1507.1>,
		<-483.35,199.9,1486.95>,
		<-379.65,199.9,1507.1>
  }
  triangle { // #7693
		<-483.35,198.35,1486.95>,
		<-381,198.35,1513.9>,
		<-484.65,198.35,1493.75>
  }
  triangle { // #7694
		<-381,198.35,1513.9>,
		<-483.35,198.35,1486.95>,
		<-379.65,198.35,1507.1>
  }
  triangle { // #7695
		<-484.65,198.35,1493.75>,
		<-381,199.9,1513.9>,
		<-484.65,199.9,1493.75>
  }
  triangle { // #7696
		<-381,199.9,1513.9>,
		<-484.65,198.35,1493.75>,
		<-381,198.35,1513.9>
  }
  triangle { // #7697
		<-485.6,199.9,1498.7>,
		<-381,199.9,1513.9>,
		<-381.95,199.9,1518.85>
  }
  triangle { // #7698
		<-381,199.9,1513.9>,
		<-485.6,199.9,1498.7>,
		<-484.65,199.9,1493.75>
  }
  smooth_triangle { // #7699
		<-485.6,199.9,1498.7>, <-0.189,-0.974,-0.124>,
		<-382.15,207.45,1519.75>, <-0.251,-0.966,-0.062>,
		<-485.8,207.45,1499.6>, <-0.109,-0.993,-0.042>
  }
  smooth_triangle { // #7700
		<-382.15,207.45,1519.75>, <-0.251,-0.966,-0.062>,
		<-485.6,199.9,1498.7>, <-0.189,-0.974,-0.124>,
		<-381.95,199.9,1518.85>, <-0.189,-0.974,-0.124>
  }
  triangle { // #7701
		<-473.55,-0,1500.6>,
		<-487.7,-0,1590.15>,
		<-478.2,-0,1500.15>
  }
  triangle { // #7702
		<-487.7,-0,1590.15>,
		<-473.55,-0,1500.6>,
		<-483,-0,1590.65>
  }
  triangle { // #7703
		<-479.45,144.6,1556.9>,
		<-473.55,-0,1500.6>,
		<-477.05,144.6,1534.4>
  }
  triangle { // #7704
		<-483,199.9,1590.65>,
		<-477.05,167.2,1534.4>,
		<-473.55,199.9,1500.6>
  }
  triangle { // #7705
		<-483,199.9,1590.65>,
		<-479.45,167.2,1556.9>,
		<-477.05,167.2,1534.4>
  }
  triangle { // #7706
		<-477.05,167.2,1534.4>,
		<-473.55,-0,1500.6>,
		<-473.55,199.9,1500.6>
  }
  triangle { // #7707
		<-477.05,144.6,1534.4>,
		<-473.55,-0,1500.6>,
		<-477.05,167.2,1534.4>
  }
  triangle { // #7708
		<-483,-0,1590.65>,
		<-479.45,167.2,1556.9>,
		<-483,199.9,1590.65>
  }
  triangle { // #7709
		<-483,-0,1590.65>,
		<-479.45,144.6,1556.9>,
		<-479.45,167.2,1556.9>
  }
  triangle { // #7710
		<-473.55,-0,1500.6>,
		<-479.45,144.6,1556.9>,
		<-483,-0,1590.65>
  }
  triangle { // #7711
		<-487.7,-0,1590.15>,
		<-483,199.9,1590.65>,
		<-487.7,199.9,1590.15>
  }
  triangle { // #7712
		<-483,199.9,1590.65>,
		<-487.7,-0,1590.15>,
		<-483,-0,1590.65>
  }
  triangle { // #7713
		<-481.75,144.6,1533.9>,
		<-487.7,-0,1590.15>,
		<-484.15,144.6,1556.4>
  }
  triangle { // #7714
		<-478.2,199.9,1500.15>,
		<-484.15,167.2,1556.4>,
		<-487.7,199.9,1590.15>
  }
  triangle { // #7715
		<-478.2,199.9,1500.15>,
		<-481.75,167.2,1533.9>,
		<-484.15,167.2,1556.4>
  }
  triangle { // #7716
		<-484.15,167.2,1556.4>,
		<-487.7,-0,1590.15>,
		<-487.7,199.9,1590.15>
  }
  triangle { // #7717
		<-484.15,144.6,1556.4>,
		<-487.7,-0,1590.15>,
		<-484.15,167.2,1556.4>
  }
  triangle { // #7718
		<-478.2,-0,1500.15>,
		<-481.75,167.2,1533.9>,
		<-478.2,199.9,1500.15>
  }
  triangle { // #7719
		<-478.2,-0,1500.15>,
		<-481.75,144.6,1533.9>,
		<-481.75,167.2,1533.9>
  }
  triangle { // #7720
		<-487.7,-0,1590.15>,
		<-481.75,144.6,1533.9>,
		<-478.2,-0,1500.15>
  }
  triangle { // #7721
		<-473.55,-0,1500.6>,
		<-478.2,199.9,1500.15>,
		<-473.55,199.9,1500.6>
  }
  triangle { // #7722
		<-478.2,199.9,1500.15>,
		<-473.55,-0,1500.6>,
		<-478.2,-0,1500.15>
  }
  triangle { // #7723
		<-473.55,199.9,1500.6>,
		<-487.7,199.9,1590.15>,
		<-483,199.9,1590.65>
  }
  triangle { // #7724
		<-487.7,199.9,1590.15>,
		<-473.55,199.9,1500.6>,
		<-478.2,199.9,1500.15>
  }
  triangle { // #7725
		<-479.45,144.6,1556.9>,
		<-481.75,144.6,1533.9>,
		<-484.15,144.6,1556.4>
  }
  triangle { // #7726
		<-481.75,144.6,1533.9>,
		<-479.45,144.6,1556.9>,
		<-477.05,144.6,1534.4>
  }
  triangle { // #7727
		<-477.05,144.6,1534.4>,
		<-481.75,167.2,1533.9>,
		<-481.75,144.6,1533.9>
  }
  triangle { // #7728
		<-481.75,167.2,1533.9>,
		<-477.05,144.6,1534.4>,
		<-477.05,167.2,1534.4>
  }
  triangle { // #7729
		<-481.75,167.2,1533.9>,
		<-479.45,167.2,1556.9>,
		<-484.15,167.2,1556.4>
  }
  triangle { // #7730
		<-479.45,167.2,1556.9>,
		<-481.75,167.2,1533.9>,
		<-477.05,167.2,1534.4>
  }
  triangle { // #7731
		<-479.45,167.2,1556.9>,
		<-484.15,144.6,1556.4>,
		<-484.15,167.2,1556.4>
  }
  triangle { // #7732
		<-484.15,144.6,1556.4>,
		<-479.45,167.2,1556.9>,
		<-479.45,144.6,1556.9>
  }
  triangle { // #7733
		<477.35,-15.1,1466.05>,
		<576.75,-15.1,1477.05>,
		<484.1,-15.1,1496.55>
  }
  triangle { // #7734
		<844.45,-15.1,1397.3>,
		<758.8,-15.1,1392.05>,
		<844.45,-15.1,1362.1>
  }
  triangle { // #7735
		<756.9,-15.1,1427.4>,
		<758.8,-15.1,1392.05>,
		<844.45,-15.1,1397.3>
  }
  triangle { // #7736
		<756.9,-15.1,1427.4>,
		<669.1,-15.1,1419.35>,
		<758.8,-15.1,1392.05>
  }
  triangle { // #7737
		<667.65,-15.1,1454>,
		<669.1,-15.1,1419.35>,
		<756.9,-15.1,1427.4>
  }
  triangle { // #7738
		<667.65,-15.1,1454>,
		<477.35,-15.1,1466.05>,
		<669.1,-15.1,1419.35>
  }
  triangle { // #7739
		<576.75,-15.1,1477.05>,
		<477.35,-15.1,1466.05>,
		<667.65,-15.1,1454>
  }
  triangle { // #7740
		<576.75,301.75,1477.05>,
		<477.35,301.75,1466.05>,
		<484.1,301.75,1496.55>
  }
  triangle { // #7741
		<758.8,301.75,1392.05>,
		<844.45,301.75,1397.3>,
		<844.45,301.75,1362.1>
  }
  triangle { // #7742
		<758.8,301.75,1392.05>,
		<756.9,301.75,1427.4>,
		<844.45,301.75,1397.3>
  }
  triangle { // #7743
		<669.1,301.75,1419.35>,
		<756.9,301.75,1427.4>,
		<758.8,301.75,1392.05>
  }
  triangle { // #7744
		<669.1,301.75,1419.35>,
		<667.65,301.75,1454>,
		<756.9,301.75,1427.4>
  }
  triangle { // #7745
		<477.35,301.75,1466.05>,
		<667.65,301.75,1454>,
		<669.1,301.75,1419.35>
  }
  triangle { // #7746
		<477.35,301.75,1466.05>,
		<576.75,301.75,1477.05>,
		<667.65,301.75,1454>
  }
  smooth_triangle { // #7747
		<844.45,301.75,1397.3>, <0.325,-0.946,0>,
		<756.9,-15.1,1427.4>, <0.312,-0.95,0>,
		<844.45,-15.1,1397.3>, <0.325,-0.946,0>
  }
  smooth_triangle { // #7748
		<576.75,-15.1,1477.05>, <0.226,-0.974,0>,
		<484.1,301.75,1496.55>, <0.206,-0.978,0>,
		<484.1,-15.1,1496.55>, <0.206,-0.978,0>
  }
  smooth_triangle { // #7749
		<576.75,-15.1,1477.05>, <0.226,-0.974,0>,
		<576.75,301.75,1477.05>, <0.226,-0.974,0>,
		<484.1,301.75,1496.55>, <0.206,-0.978,0>
  }
  smooth_triangle { // #7750
		<576.75,-15.1,1477.05>, <0.226,-0.974,0>,
		<667.65,301.75,1454>, <0.259,-0.966,0>,
		<576.75,301.75,1477.05>, <0.226,-0.974,0>
  }
  smooth_triangle { // #7751
		<667.65,-15.1,1454>, <0.272,-0.962,0>,
		<667.65,301.75,1454>, <0.259,-0.966,0>,
		<576.75,-15.1,1477.05>, <0.226,-0.974,0>
  }
  smooth_triangle { // #7752
		<667.65,-15.1,1454>, <0.272,-0.962,0>,
		<756.9,301.75,1427.4>, <0.299,-0.954,0>,
		<667.65,301.75,1454>, <0.259,-0.966,0>
  }
  smooth_triangle { // #7753
		<756.9,-15.1,1427.4>, <0.312,-0.95,0>,
		<756.9,301.75,1427.4>, <0.299,-0.954,0>,
		<667.65,-15.1,1454>, <0.272,-0.962,0>
  }
  smooth_triangle { // #7754
		<756.9,-15.1,1427.4>, <0.312,-0.95,0>,
		<844.45,301.75,1397.3>, <0.325,-0.946,0>,
		<756.9,301.75,1427.4>, <0.299,-0.954,0>
  }
  triangle { // #7755
		<484.1,-15.1,1496.55>,
		<477.35,301.75,1466.05>,
		<477.35,-15.1,1466.05>
  }
  triangle { // #7756
		<477.35,301.75,1466.05>,
		<484.1,-15.1,1496.55>,
		<484.1,301.75,1496.55>
  }
  smooth_triangle { // #7757
		<477.35,301.75,1466.05>, <-0.237,0.972,0>,
		<669.1,-15.1,1419.35>, <-0.255,0.967,0>,
		<477.35,-15.1,1466.05>, <-0.237,0.972,0>
  }
  smooth_triangle { // #7758
		<758.8,-15.1,1392.05>, <-0.311,0.951,0>,
		<844.45,301.75,1362.1>, <-0.33,0.944,0>,
		<844.45,-15.1,1362.1>, <-0.33,0.944,0>
  }
  smooth_triangle { // #7759
		<758.8,-15.1,1392.05>, <-0.311,0.951,0>,
		<758.8,301.75,1392.05>, <-0.311,0.951,0>,
		<844.45,301.75,1362.1>, <-0.33,0.944,0>
  }
  smooth_triangle { // #7760
		<758.8,-15.1,1392.05>, <-0.311,0.951,0>,
		<669.1,301.75,1419.35>, <-0.273,0.962,0>,
		<758.8,301.75,1392.05>, <-0.311,0.951,0>
  }
  smooth_triangle { // #7761
		<669.1,-15.1,1419.35>, <-0.255,0.967,0>,
		<669.1,301.75,1419.35>, <-0.273,0.962,0>,
		<758.8,-15.1,1392.05>, <-0.311,0.951,0>
  }
  smooth_triangle { // #7762
		<669.1,-15.1,1419.35>, <-0.255,0.967,0>,
		<477.35,301.75,1466.05>, <-0.237,0.972,0>,
		<669.1,301.75,1419.35>, <-0.273,0.962,0>
  }
  triangle { // #7763
		<844.45,-15.1,1362.1>,
		<844.45,301.75,1397.3>,
		<844.45,-15.1,1397.3>
  }
  triangle { // #7764
		<844.45,301.75,1397.3>,
		<844.45,-15.1,1362.1>,
		<844.45,301.75,1362.1>
  }
  triangle { // #7765
		<-669.2,-15.1,1454.2>,
		<-479.4,-15.1,1467.75>,
		<-485.5,-15.1,1498.45>
  }
  triangle { // #7766
		<-663.05,-15.1,1421.6>,
		<-840.35,-15.1,1398.7>,
		<-840.35,-15.1,1363.25>
  }
  triangle { // #7767
		<-663.05,-15.1,1421.6>,
		<-669.2,-15.1,1454.2>,
		<-840.35,-15.1,1398.7>
  }
  triangle { // #7768
		<-479.4,-15.1,1467.75>,
		<-669.2,-15.1,1454.2>,
		<-663.05,-15.1,1421.6>
  }
  triangle { // #7769
		<-479.4,301.75,1467.75>,
		<-669.2,301.75,1454.2>,
		<-485.5,301.75,1498.45>
  }
  triangle { // #7770
		<-840.35,301.75,1398.7>,
		<-663.05,301.75,1421.6>,
		<-840.35,301.75,1363.25>
  }
  triangle { // #7771
		<-669.2,301.75,1454.2>,
		<-663.05,301.75,1421.6>,
		<-840.35,301.75,1398.7>
  }
  triangle { // #7772
		<-669.2,301.75,1454.2>,
		<-479.4,301.75,1467.75>,
		<-663.05,301.75,1421.6>
  }
  triangle { // #7773
		<-479.4,-15.1,1467.75>,
		<-485.5,301.75,1498.45>,
		<-485.5,-15.1,1498.45>
  }
  triangle { // #7774
		<-485.5,301.75,1498.45>,
		<-479.4,-15.1,1467.75>,
		<-479.4,301.75,1467.75>
  }
  smooth_triangle { // #7775
		<-485.5,301.75,1498.45>, <-0.234,-0.972,0>,
		<-669.2,-15.1,1454.2>, <-0.271,-0.962,0>,
		<-485.5,-15.1,1498.45>, <-0.234,-0.972,0>
  }
  smooth_triangle { // #7776
		<-669.2,-15.1,1454.2>, <-0.271,-0.962,0>,
		<-840.35,301.75,1398.7>, <-0.308,-0.951,0>,
		<-840.35,-15.1,1398.7>, <-0.308,-0.951,0>
  }
  smooth_triangle { // #7777
		<-669.2,-15.1,1454.2>, <-0.271,-0.962,0>,
		<-669.2,301.75,1454.2>, <-0.271,-0.962,0>,
		<-840.35,301.75,1398.7>, <-0.308,-0.951,0>
  }
  smooth_triangle { // #7778
		<-669.2,-15.1,1454.2>, <-0.271,-0.962,0>,
		<-485.5,301.75,1498.45>, <-0.234,-0.972,0>,
		<-669.2,301.75,1454.2>, <-0.271,-0.962,0>
  }
  triangle { // #7779
		<-840.35,-15.1,1398.7>,
		<-840.35,301.75,1363.25>,
		<-840.35,-15.1,1363.25>
  }
  triangle { // #7780
		<-840.35,301.75,1363.25>,
		<-840.35,-15.1,1398.7>,
		<-840.35,301.75,1398.7>
  }
  smooth_triangle { // #7781
		<-840.35,301.75,1363.25>, <0.313,0.95,0>,
		<-663.05,-15.1,1421.6>, <0.278,0.96,0>,
		<-840.35,-15.1,1363.25>, <0.313,0.95,0>
  }
  smooth_triangle { // #7782
		<-663.05,-15.1,1421.6>, <0.278,0.96,0>,
		<-479.4,301.75,1467.75>, <0.244,0.97,0>,
		<-479.4,-15.1,1467.75>, <0.244,0.97,0>
  }
  smooth_triangle { // #7783
		<-663.05,-15.1,1421.6>, <0.278,0.96,0>,
		<-663.05,301.75,1421.6>, <0.278,0.96,0>,
		<-479.4,301.75,1467.75>, <0.244,0.97,0>
  }
  smooth_triangle { // #7784
		<-663.05,-15.1,1421.6>, <0.278,0.96,0>,
		<-840.35,301.75,1363.25>, <0.313,0.95,0>,
		<-663.05,301.75,1421.6>, <0.278,0.96,0>
  }
  triangle { // #7785
		<-376.15,207.45,1487.05>,
		<-381.55,207.45,1518>,
		<-429.65,207.45,1478>
  }
  triangle { // #7786
		<-479.4,207.45,1467.75>,
		<-429.65,207.45,1478>,
		<-485.5,207.45,1498.45>
  }
  triangle { // #7787
		<-485.5,207.45,1498.45>,
		<-429.65,207.45,1478>,
		<-381.55,207.45,1518>
  }
  triangle { // #7788
		<-376.15,313.05,1487.05>,
		<-429.65,313.05,1478>,
		<-381.55,313.05,1518>
  }
  triangle { // #7789
		<-479.4,313.05,1467.75>,
		<-485.5,313.05,1498.45>,
		<-429.65,313.05,1478>
  }
  triangle { // #7790
		<-485.5,313.05,1498.45>,
		<-381.55,313.05,1518>,
		<-429.65,313.05,1478>
  }
  triangle { // #7791
		<-485.5,207.45,1498.45>,
		<-485.5,313.05,1498.45>,
		<-479.4,207.45,1467.75>
  }
  triangle { // #7792
		<-479.4,313.05,1467.75>,
		<-479.4,207.45,1467.75>,
		<-485.5,313.05,1498.45>
  }
  triangle { // #7793
		<-381.55,207.45,1518>,
		<-381.55,313.05,1518>,
		<-485.5,207.45,1498.45>
  }
  triangle { // #7794
		<-485.5,313.05,1498.45>,
		<-485.5,207.45,1498.45>,
		<-381.55,313.05,1518>
  }
  triangle { // #7795
		<-376.15,207.45,1487.05>,
		<-376.15,313.05,1487.05>,
		<-381.55,207.45,1518>
  }
  triangle { // #7796
		<-381.55,313.05,1518>,
		<-381.55,207.45,1518>,
		<-376.15,313.05,1487.05>
  }
  smooth_triangle { // #7797
		<-479.4,313.05,1467.75>, <0.202,0.979,0>,
		<-429.65,313.05,1478>, <0.19,0.982,0>,
		<-479.4,207.45,1467.75>, <0.202,0.979,0>
  }
  smooth_triangle { // #7798
		<-376.15,207.45,1487.05>, <0.167,0.986,0>,
		<-429.65,207.45,1478>, <0.179,0.984,0>,
		<-376.15,313.05,1487.05>, <0.167,0.986,0>
  }
  smooth_triangle { // #7799
		<-376.15,313.05,1487.05>, <0.167,0.986,0>,
		<-429.65,207.45,1478>, <0.179,0.984,0>,
		<-429.65,313.05,1478>, <0.19,0.982,0>
  }
  smooth_triangle { // #7800
		<-429.65,207.45,1478>, <0.179,0.984,0>,
		<-479.4,207.45,1467.75>, <0.202,0.979,0>,
		<-429.65,313.05,1478>, <0.19,0.982,0>
  }
  triangle { // #7801
		<484.1,207.45,1496.55>,
		<428.3,207.45,1476.6>,
		<477.35,207.45,1466.05>
  }
  triangle { // #7802
		<375.5,207.45,1486.6>,
		<484.1,207.45,1496.55>,
		<380.5,207.45,1518>
  }
  triangle { // #7803
		<428.3,207.45,1476.6>,
		<484.1,207.45,1496.55>,
		<375.5,207.45,1486.6>
  }
  triangle { // #7804
		<428.3,313.05,1476.6>,
		<484.1,313.05,1496.55>,
		<477.35,313.05,1466.05>
  }
  triangle { // #7805
		<484.1,313.05,1496.55>,
		<375.5,313.05,1486.6>,
		<380.5,313.05,1518>
  }
  triangle { // #7806
		<484.1,313.05,1496.55>,
		<428.3,313.05,1476.6>,
		<375.5,313.05,1486.6>
  }
  triangle { // #7807
		<484.1,207.45,1496.55>,
		<380.5,313.05,1518>,
		<380.5,207.45,1518>
  }
  triangle { // #7808
		<380.5,313.05,1518>,
		<484.1,207.45,1496.55>,
		<484.1,313.05,1496.55>
  }
  triangle { // #7809
		<380.5,207.45,1518>,
		<375.5,313.05,1486.6>,
		<375.5,207.45,1486.6>
  }
  triangle { // #7810
		<375.5,313.05,1486.6>,
		<380.5,207.45,1518>,
		<380.5,313.05,1518>
  }
  smooth_triangle { // #7811
		<375.5,313.05,1486.6>, <-0.185,0.983,0>,
		<428.3,207.45,1476.6>, <-0.198,0.98,0>,
		<375.5,207.45,1486.6>, <-0.185,0.983,0>
  }
  smooth_triangle { // #7812
		<428.3,207.45,1476.6>, <-0.198,0.98,0>,
		<477.35,313.05,1466.05>, <-0.21,0.978,0>,
		<477.35,207.45,1466.05>, <-0.21,0.978,0>
  }
  smooth_triangle { // #7813
		<428.3,207.45,1476.6>, <-0.198,0.98,0>,
		<428.3,313.05,1476.6>, <-0.198,0.98,0>,
		<477.35,313.05,1466.05>, <-0.21,0.978,0>
  }
  smooth_triangle { // #7814
		<428.3,207.45,1476.6>, <-0.198,0.98,0>,
		<375.5,313.05,1486.6>, <-0.185,0.983,0>,
		<428.3,313.05,1476.6>, <-0.198,0.98,0>
  }
  triangle { // #7815
		<477.35,207.45,1466.05>,
		<484.1,313.05,1496.55>,
		<484.1,207.45,1496.55>
  }
  triangle { // #7816
		<484.1,313.05,1496.55>,
		<477.35,207.45,1466.05>,
		<477.35,313.05,1466.05>
  }
  triangle { // #7817
		<-876.4,136.85,339.3>,
		<-877.4,143,339.3>,
		<-874.65,136.4,339.3>
  }
  triangle { // #7818
		<-865.85,133.1,339.3>,
		<-865.85,134.7,339.3>,
		<-846.35,133.1,339.3>
  }
  triangle { // #7819
		<-846.35,133.1,339.3>,
		<-865.85,134.7,339.3>,
		<-846.35,134.7,339.3>
  }
  triangle { // #7820
		<-839.45,147.9,339.3>,
		<-839.45,145.4,339.3>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7821
		<-839.45,145.4,339.3>,
		<-841.2,134.9,339.3>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7822
		<-841.2,134.9,339.3>,
		<-846.35,134.7,339.3>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7823
		<-846.35,134.7,339.3>,
		<-865.85,134.7,339.3>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7824
		<-865.85,134.7,339.3>,
		<-868.65,134.7,339.3>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7825
		<-880.6,143.35,339.3>,
		<-880.6,147.9,339.3>,
		<-877.4,143,339.3>
  }
  triangle { // #7826
		<-880.6,147.9,339.3>,
		<-868.65,134.7,339.3>,
		<-877.4,143,339.3>
  }
  triangle { // #7827
		<-874.15,134.95,339.3>,
		<-874.65,136.4,339.3>,
		<-868.65,134.7,339.3>
  }
  triangle { // #7828
		<-868.65,134.7,339.3>,
		<-874.65,136.4,339.3>,
		<-877.4,143,339.3>
  }
  triangle { // #7829
		<-876.4,136.85,467.55>,
		<-874.65,136.4,467.55>,
		<-877.4,143,467.55>
  }
  triangle { // #7830
		<-846.35,133.1,467.55>,
		<-846.35,134.7,467.55>,
		<-865.85,133.1,467.55>
  }
  triangle { // #7831
		<-865.85,133.1,467.55>,
		<-846.35,134.7,467.55>,
		<-865.85,134.7,467.55>
  }
  triangle { // #7832
		<-839.45,147.9,467.55>,
		<-880.6,147.9,467.55>,
		<-839.45,145.4,467.55>
  }
  triangle { // #7833
		<-839.45,145.4,467.55>,
		<-880.6,147.9,467.55>,
		<-841.2,134.9,467.55>
  }
  triangle { // #7834
		<-841.2,134.9,467.55>,
		<-880.6,147.9,467.55>,
		<-846.35,134.7,467.55>
  }
  triangle { // #7835
		<-846.35,134.7,467.55>,
		<-880.6,147.9,467.55>,
		<-865.85,134.7,467.55>
  }
  triangle { // #7836
		<-865.85,134.7,467.55>,
		<-880.6,147.9,467.55>,
		<-868.65,134.7,467.55>
  }
  triangle { // #7837
		<-880.6,143.35,467.55>,
		<-877.4,143,467.55>,
		<-880.6,147.9,467.55>
  }
  triangle { // #7838
		<-880.6,147.9,467.55>,
		<-877.4,143,467.55>,
		<-868.65,134.7,467.55>
  }
  triangle { // #7839
		<-874.15,134.95,467.55>,
		<-868.65,134.7,467.55>,
		<-874.65,136.4,467.55>
  }
  triangle { // #7840
		<-868.65,134.7,467.55>,
		<-877.4,143,467.55>,
		<-874.65,136.4,467.55>
  }
  triangle { // #7841
		<-880.6,143.35,339.3>,
		<-880.6,143.35,467.55>,
		<-880.6,147.9,339.3>
  }
  triangle { // #7842
		<-880.6,147.9,467.55>,
		<-880.6,147.9,339.3>,
		<-880.6,143.35,467.55>
  }
  triangle { // #7843
		<-877.4,143,339.3>,
		<-877.4,143,467.55>,
		<-880.6,143.35,339.3>
  }
  triangle { // #7844
		<-880.6,143.35,467.55>,
		<-880.6,143.35,339.3>,
		<-877.4,143,467.55>
  }
  triangle { // #7845
		<-876.4,136.85,339.3>,
		<-876.4,136.85,467.55>,
		<-877.4,143,339.3>
  }
  triangle { // #7846
		<-877.4,143,467.55>,
		<-877.4,143,339.3>,
		<-876.4,136.85,467.55>
  }
  triangle { // #7847
		<-874.65,136.4,339.3>,
		<-874.65,136.4,467.55>,
		<-876.4,136.85,339.3>
  }
  triangle { // #7848
		<-876.4,136.85,467.55>,
		<-876.4,136.85,339.3>,
		<-874.65,136.4,467.55>
  }
  triangle { // #7849
		<-874.15,134.95,339.3>,
		<-874.15,134.95,467.55>,
		<-874.65,136.4,339.3>
  }
  triangle { // #7850
		<-874.65,136.4,467.55>,
		<-874.65,136.4,339.3>,
		<-874.15,134.95,467.55>
  }
  smooth_triangle { // #7851
		<-868.65,134.7,339.3>, <-0.015,0,-1>,
		<-868.65,134.7,467.55>, <-0.03,0,-1>,
		<-874.15,134.95,339.3>, <-0.045,0,-0.999>
  }
  smooth_triangle { // #7852
		<-874.15,134.95,467.55>, <-0.045,0,-0.999>,
		<-874.15,134.95,339.3>, <-0.045,0,-0.999>,
		<-868.65,134.7,467.55>, <-0.03,0,-1>
  }
  smooth_triangle { // #7853
		<-865.85,134.7,339.3>, <0,0,-1>,
		<-865.85,134.7,467.55>, <0,0,-1>,
		<-868.65,134.7,339.3>, <-0.015,0,-1>
  }
  smooth_triangle { // #7854
		<-868.65,134.7,467.55>, <-0.03,0,-1>,
		<-868.65,134.7,339.3>, <-0.015,0,-1>,
		<-865.85,134.7,467.55>, <0,0,-1>
  }
  triangle { // #7855
		<-865.85,133.1,339.3>,
		<-865.85,133.1,467.55>,
		<-865.85,134.7,339.3>
  }
  triangle { // #7856
		<-865.85,134.7,467.55>,
		<-865.85,134.7,339.3>,
		<-865.85,133.1,467.55>
  }
  triangle { // #7857
		<-846.35,133.1,339.3>,
		<-846.35,133.1,467.55>,
		<-865.85,133.1,339.3>
  }
  triangle { // #7858
		<-865.85,133.1,467.55>,
		<-865.85,133.1,339.3>,
		<-846.35,133.1,467.55>
  }
  triangle { // #7859
		<-846.35,134.7,339.3>,
		<-846.35,134.7,467.55>,
		<-846.35,133.1,339.3>
  }
  triangle { // #7860
		<-846.35,133.1,467.55>,
		<-846.35,133.1,339.3>,
		<-846.35,134.7,467.55>
  }
  triangle { // #7861
		<-841.2,134.9,339.3>,
		<-841.2,134.9,467.55>,
		<-846.35,134.7,339.3>
  }
  triangle { // #7862
		<-846.35,134.7,467.55>,
		<-846.35,134.7,339.3>,
		<-841.2,134.9,467.55>
  }
  smooth_triangle { // #7863
		<-839.45,145.4,339.3>, <0.998,0,-0.056>,
		<-839.45,145.4,467.55>, <0.994,0,-0.113>,
		<-841.2,134.9,339.3>, <0.986,0,-0.169>
  }
  smooth_triangle { // #7864
		<-841.2,134.9,467.55>, <0.986,0,-0.169>,
		<-841.2,134.9,339.3>, <0.986,0,-0.169>,
		<-839.45,145.4,467.55>, <0.994,0,-0.113>
  }
  smooth_triangle { // #7865
		<-839.45,147.9,339.3>, <1,0,0>,
		<-839.45,147.9,467.55>, <1,0,0>,
		<-839.45,145.4,339.3>, <0.998,0,-0.056>
  }
  smooth_triangle { // #7866
		<-839.45,145.4,467.55>, <0.994,0,-0.113>,
		<-839.45,145.4,339.3>, <0.998,0,-0.056>,
		<-839.45,147.9,467.55>, <1,0,0>
  }
  triangle { // #7867
		<-880.6,147.9,339.3>,
		<-880.6,147.9,467.55>,
		<-839.45,147.9,339.3>
  }
  triangle { // #7868
		<-839.45,147.9,467.55>,
		<-839.45,147.9,339.3>,
		<-880.6,147.9,467.55>
  }
  triangle { // #7869
		<843.2,135.65,347.65>,
		<843.2,139.25,347.65>,
		<843.85,134.55,347.65>
  }
  triangle { // #7870
		<841.95,147.6,347.65>,
		<843.85,147.6,347.65>,
		<841.95,144.55,347.65>
  }
  triangle { // #7871
		<884.05,143,347.65>,
		<879.9,143,347.65>,
		<884.05,147.6,347.65>
  }
  triangle { // #7872
		<884.05,147.6,347.65>,
		<879.9,143,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7873
		<879.9,143,347.65>,
		<878.9,136.55,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7874
		<878.9,136.55,347.65>,
		<877.95,136.05,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7875
		<877.95,136.05,347.65>,
		<875.9,134.35,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7876
		<875.9,134.35,347.65>,
		<868.35,134.35,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7877
		<848.85,132.8,347.65>,
		<848.85,134.35,347.65>,
		<868.35,132.8,347.65>
  }
  triangle { // #7878
		<868.35,132.8,347.65>,
		<848.85,134.35,347.65>,
		<868.35,134.35,347.65>
  }
  triangle { // #7879
		<868.35,134.35,347.65>,
		<848.85,134.35,347.65>,
		<843.85,147.6,347.65>
  }
  triangle { // #7880
		<843.85,147.6,347.65>,
		<848.85,134.35,347.65>,
		<841.95,144.55,347.65>
  }
  triangle { // #7881
		<841.95,144.55,347.65>,
		<848.85,134.35,347.65>,
		<843.2,139.25,347.65>
  }
  triangle { // #7882
		<848.85,134.35,347.65>,
		<843.85,134.55,347.65>,
		<843.2,139.25,347.65>
  }
  triangle { // #7883
		<843.2,135.65,470.85>,
		<843.85,134.55,470.85>,
		<843.2,139.25,470.85>
  }
  triangle { // #7884
		<841.95,147.6,470.85>,
		<841.95,144.55,470.85>,
		<843.85,147.6,470.85>
  }
  triangle { // #7885
		<884.05,143,470.85>,
		<884.05,147.6,470.85>,
		<879.9,143,470.85>
  }
  triangle { // #7886
		<884.05,147.6,470.85>,
		<843.85,147.6,470.85>,
		<879.9,143,470.85>
  }
  triangle { // #7887
		<879.9,143,470.85>,
		<843.85,147.6,470.85>,
		<878.9,136.55,470.85>
  }
  triangle { // #7888
		<878.9,136.55,470.85>,
		<843.85,147.6,470.85>,
		<877.95,136.05,470.85>
  }
  triangle { // #7889
		<877.95,136.05,470.85>,
		<843.85,147.6,470.85>,
		<875.9,134.35,470.85>
  }
  triangle { // #7890
		<875.9,134.35,470.85>,
		<843.85,147.6,470.85>,
		<868.35,134.35,470.85>
  }
  triangle { // #7891
		<868.35,132.8,470.85>,
		<868.35,134.35,470.85>,
		<848.85,132.8,470.85>
  }
  triangle { // #7892
		<848.85,132.8,470.85>,
		<868.35,134.35,470.85>,
		<848.85,134.35,470.85>
  }
  triangle { // #7893
		<868.35,134.35,470.85>,
		<843.85,147.6,470.85>,
		<848.85,134.35,470.85>
  }
  triangle { // #7894
		<843.85,147.6,470.85>,
		<841.95,144.55,470.85>,
		<848.85,134.35,470.85>
  }
  triangle { // #7895
		<841.95,144.55,470.85>,
		<843.2,139.25,470.85>,
		<848.85,134.35,470.85>
  }
  triangle { // #7896
		<848.85,134.35,470.85>,
		<843.2,139.25,470.85>,
		<843.85,134.55,470.85>
  }
  triangle { // #7897
		<843.85,147.6,347.65>,
		<843.85,147.6,470.85>,
		<884.05,147.6,347.65>
  }
  triangle { // #7898
		<884.05,147.6,470.85>,
		<884.05,147.6,347.65>,
		<843.85,147.6,470.85>
  }
  triangle { // #7899
		<841.95,147.6,347.65>,
		<841.95,147.6,470.85>,
		<843.85,147.6,347.65>
  }
  triangle { // #7900
		<843.85,147.6,470.85>,
		<843.85,147.6,347.65>,
		<841.95,147.6,470.85>
  }
  smooth_triangle { // #7901
		<841.95,144.55,347.65>, <-0.988,0,-0.155>,
		<841.95,144.55,470.85>, <-0.997,0,-0.078>,
		<841.95,147.6,347.65>, <-1,0,0>
  }
  smooth_triangle { // #7902
		<841.95,147.6,470.85>, <-1,0,0>,
		<841.95,147.6,347.65>, <-1,0,0>,
		<841.95,144.55,470.85>, <-0.997,0,-0.078>
  }
  smooth_triangle { // #7903
		<843.2,139.25,347.65>, <-0.997,0,-0.078>,
		<843.2,139.25,470.85>, <-0.988,0,-0.155>,
		<841.95,144.55,347.65>, <-0.988,0,-0.155>
  }
  smooth_triangle { // #7904
		<841.95,144.55,470.85>, <-0.997,0,-0.078>,
		<841.95,144.55,347.65>, <-0.988,0,-0.155>,
		<843.2,139.25,470.85>, <-0.988,0,-0.155>
  }
  smooth_triangle { // #7905
		<843.2,135.65,347.65>, <-0.939,0,-0.344>,
		<843.2,135.65,470.85>, <-0.985,0,-0.172>,
		<843.2,139.25,347.65>, <-0.997,0,-0.078>
  }
  smooth_triangle { // #7906
		<843.2,139.25,470.85>, <-0.988,0,-0.155>,
		<843.2,139.25,347.65>, <-0.997,0,-0.078>,
		<843.2,135.65,470.85>, <-0.985,0,-0.172>
  }
  smooth_triangle { // #7907
		<843.85,134.55,347.65>, <-0.866,0,-0.5>,
		<843.85,134.55,470.85>, <-0.866,0,-0.5>,
		<843.2,135.65,347.65>, <-0.939,0,-0.344>
  }
  smooth_triangle { // #7908
		<843.2,135.65,470.85>, <-0.985,0,-0.172>,
		<843.2,135.65,347.65>, <-0.939,0,-0.344>,
		<843.85,134.55,470.85>, <-0.866,0,-0.5>
  }
  triangle { // #7909
		<848.85,134.35,347.65>,
		<848.85,134.35,470.85>,
		<843.85,134.55,347.65>
  }
  triangle { // #7910
		<843.85,134.55,470.85>,
		<843.85,134.55,347.65>,
		<848.85,134.35,470.85>
  }
  triangle { // #7911
		<848.85,132.8,347.65>,
		<848.85,132.8,470.85>,
		<848.85,134.35,347.65>
  }
  triangle { // #7912
		<848.85,134.35,470.85>,
		<848.85,134.35,347.65>,
		<848.85,132.8,470.85>
  }
  triangle { // #7913
		<868.35,132.8,347.65>,
		<868.35,132.8,470.85>,
		<848.85,132.8,347.65>
  }
  triangle { // #7914
		<848.85,132.8,470.85>,
		<848.85,132.8,347.65>,
		<868.35,132.8,470.85>
  }
  triangle { // #7915
		<868.35,134.35,347.65>,
		<868.35,134.35,470.85>,
		<868.35,132.8,347.65>
  }
  triangle { // #7916
		<868.35,132.8,470.85>,
		<868.35,132.8,347.65>,
		<868.35,134.35,470.85>
  }
  smooth_triangle { // #7917
		<875.9,134.35,347.65>, <0.45,0,-0.893>,
		<875.9,134.35,470.85>, <0.225,0,-0.974>,
		<868.35,134.35,347.65>, <0,0,-1>
  }
  smooth_triangle { // #7918
		<868.35,134.35,470.85>, <0,0,-1>,
		<868.35,134.35,347.65>, <0,0,-1>,
		<875.9,134.35,470.85>, <0.225,0,-0.974>
  }
  smooth_triangle { // #7919
		<877.95,136.05,347.65>, <0.508,0,-0.861>,
		<877.95,136.05,470.85>, <0.576,0,-0.817>,
		<875.9,134.35,347.65>, <0.45,0,-0.893>
  }
  smooth_triangle { // #7920
		<875.9,134.35,470.85>, <0.225,0,-0.974>,
		<875.9,134.35,347.65>, <0.45,0,-0.893>,
		<877.95,136.05,470.85>, <0.576,0,-0.817>
  }
  smooth_triangle { // #7921
		<878.9,136.55,347.65>, <0.438,0,-0.899>,
		<878.9,136.55,470.85>, <0.438,0,-0.899>,
		<877.95,136.05,347.65>, <0.508,0,-0.861>
  }
  smooth_triangle { // #7922
		<877.95,136.05,470.85>, <0.576,0,-0.817>,
		<877.95,136.05,347.65>, <0.508,0,-0.861>,
		<878.9,136.55,470.85>, <0.438,0,-0.899>
  }
  triangle { // #7923
		<879.9,143,347.65>,
		<879.9,143,470.85>,
		<878.9,136.55,347.65>
  }
  triangle { // #7924
		<878.9,136.55,470.85>,
		<878.9,136.55,347.65>,
		<879.9,143,470.85>
  }
  triangle { // #7925
		<884.05,143,347.65>,
		<884.05,143,470.85>,
		<879.9,143,347.65>
  }
  triangle { // #7926
		<879.9,143,470.85>,
		<879.9,143,347.65>,
		<884.05,143,470.85>
  }
  triangle { // #7927
		<884.05,147.6,347.65>,
		<884.05,147.6,470.85>,
		<884.05,143,347.65>
  }
  triangle { // #7928
		<884.05,143,470.85>,
		<884.05,143,347.65>,
		<884.05,147.6,470.85>
  }
  triangle { // #7929
		<868.3,-79.2,357.25>,
		<875.8,-79.2,461.9>,
		<868.3,-79.2,461.9>
  }
  triangle { // #7930
		<875.8,-79.2,461.9>,
		<868.3,-79.2,357.25>,
		<875.8,-79.2,357.25>
  }
  triangle { // #7931
		<868.3,134.55,461.9>,
		<875.8,134.55,357.25>,
		<868.3,134.55,357.25>
  }
  triangle { // #7932
		<875.8,134.55,357.25>,
		<868.3,134.55,461.9>,
		<875.8,134.55,461.9>
  }
  triangle { // #7933
		<868.3,-79.2,461.9>,
		<868.3,134.55,357.25>,
		<868.3,-79.2,357.25>
  }
  triangle { // #7934
		<868.3,134.55,357.25>,
		<868.3,-79.2,461.9>,
		<868.3,134.55,461.9>
  }
  triangle { // #7935
		<868.3,-79.2,357.25>,
		<875.8,134.55,357.25>,
		<875.8,-79.2,357.25>
  }
  triangle { // #7936
		<875.8,134.55,357.25>,
		<868.3,-79.2,357.25>,
		<868.3,134.55,357.25>
  }
  triangle { // #7937
		<875.8,-79.2,357.25>,
		<875.8,134.55,461.9>,
		<875.8,-79.2,461.9>
  }
  triangle { // #7938
		<875.8,134.55,461.9>,
		<875.8,-79.2,357.25>,
		<875.8,134.55,357.25>
  }
  triangle { // #7939
		<875.8,-79.2,461.9>,
		<868.3,134.55,461.9>,
		<868.3,-79.2,461.9>
  }
  triangle { // #7940
		<868.3,134.55,461.9>,
		<875.8,-79.2,461.9>,
		<875.8,134.55,461.9>
  }
  triangle { // #7941
		<-871.5,-79.2,456.9>,
		<-865.85,-79.2,352.7>,
		<-865.85,-79.2,456.9>
  }
  triangle { // #7942
		<-865.85,-79.2,352.7>,
		<-871.5,-79.2,456.9>,
		<-871.5,-79.2,352.7>
  }
  triangle { // #7943
		<-871.5,134.55,456.9>,
		<-865.85,134.55,352.7>,
		<-871.5,134.55,352.7>
  }
  triangle { // #7944
		<-865.85,134.55,352.7>,
		<-871.5,134.55,456.9>,
		<-865.85,134.55,456.9>
  }
  triangle { // #7945
		<-871.5,-79.2,456.9>,
		<-871.5,134.55,352.7>,
		<-871.5,-79.2,352.7>
  }
  triangle { // #7946
		<-871.5,134.55,352.7>,
		<-871.5,-79.2,456.9>,
		<-871.5,134.55,456.9>
  }
  triangle { // #7947
		<-871.5,-79.2,352.7>,
		<-865.85,134.55,352.7>,
		<-865.85,-79.2,352.7>
  }
  triangle { // #7948
		<-865.85,134.55,352.7>,
		<-871.5,-79.2,352.7>,
		<-871.5,134.55,352.7>
  }
  triangle { // #7949
		<-865.85,-79.2,352.7>,
		<-865.85,134.55,456.9>,
		<-865.85,-79.2,456.9>
  }
  triangle { // #7950
		<-865.85,134.55,456.9>,
		<-865.85,-79.2,352.7>,
		<-865.85,134.55,352.7>
  }
  triangle { // #7951
		<-865.85,-79.2,456.9>,
		<-871.5,134.55,456.9>,
		<-871.5,-79.2,456.9>
  }
  triangle { // #7952
		<-871.5,134.55,456.9>,
		<-865.85,-79.2,456.9>,
		<-865.85,134.55,456.9>
  }
  triangle { // #7953
		<940.65,139.4,232.45>,
		<1045.3,139.4,262.45>,
		<940.65,139.4,262.45>
  }
  triangle { // #7954
		<1045.3,139.4,262.45>,
		<940.65,139.4,232.45>,
		<1045.3,139.4,232.45>
  }
  triangle { // #7955
		<940.65,574.6,232.45>,
		<1045.3,574.6,262.45>,
		<1045.3,574.6,232.45>
  }
  triangle { // #7956
		<1045.3,574.6,262.45>,
		<940.65,574.6,232.45>,
		<940.65,574.6,262.45>
  }
  triangle { // #7957
		<940.65,139.4,262.45>,
		<940.65,574.6,232.45>,
		<940.65,139.4,232.45>
  }
  triangle { // #7958
		<940.65,574.6,232.45>,
		<940.65,139.4,262.45>,
		<940.65,574.6,262.45>
  }
  triangle { // #7959
		<940.65,139.4,232.45>,
		<1045.3,574.6,232.45>,
		<1045.3,139.4,232.45>
  }
  triangle { // #7960
		<1045.3,574.6,232.45>,
		<940.65,139.4,232.45>,
		<940.65,574.6,232.45>
  }
  triangle { // #7961
		<1045.3,139.4,232.45>,
		<1045.3,574.6,262.45>,
		<1045.3,139.4,262.45>
  }
  triangle { // #7962
		<1045.3,574.6,262.45>,
		<1045.3,139.4,232.45>,
		<1045.3,574.6,232.45>
  }
  triangle { // #7963
		<1045.3,139.4,262.45>,
		<940.65,574.6,262.45>,
		<940.65,139.4,262.45>
  }
  triangle { // #7964
		<940.65,574.6,262.45>,
		<1045.3,139.4,262.45>,
		<1045.3,574.6,262.45>
  }
  triangle { // #7965
		<955.95,-82.35,245.55>,
		<1031.4,-82.35,251.2>,
		<955.95,-82.35,251.2>
  }
  triangle { // #7966
		<1031.4,-82.35,251.2>,
		<955.95,-82.35,245.55>,
		<1031.4,-82.35,245.55>
  }
  triangle { // #7967
		<955.95,131.4,251.2>,
		<1031.4,131.4,245.55>,
		<955.95,131.4,245.55>
  }
  triangle { // #7968
		<1031.4,131.4,245.55>,
		<955.95,131.4,251.2>,
		<1031.4,131.4,251.2>
  }
  triangle { // #7969
		<955.95,-82.35,251.2>,
		<955.95,131.4,245.55>,
		<955.95,-82.35,245.55>
  }
  triangle { // #7970
		<955.95,131.4,245.55>,
		<955.95,-82.35,251.2>,
		<955.95,131.4,251.2>
  }
  triangle { // #7971
		<955.95,-82.35,245.55>,
		<1031.4,131.4,245.55>,
		<1031.4,-82.35,245.55>
  }
  triangle { // #7972
		<1031.4,131.4,245.55>,
		<955.95,-82.35,245.55>,
		<955.95,131.4,245.55>
  }
  triangle { // #7973
		<1031.4,-82.35,245.55>,
		<1031.4,131.4,251.2>,
		<1031.4,-82.35,251.2>
  }
  triangle { // #7974
		<1031.4,131.4,251.2>,
		<1031.4,-82.35,245.55>,
		<1031.4,131.4,245.55>
  }
  triangle { // #7975
		<1031.4,-82.35,251.2>,
		<955.95,131.4,251.2>,
		<955.95,-82.35,251.2>
  }
  triangle { // #7976
		<955.95,131.4,251.2>,
		<1031.4,-82.35,251.2>,
		<1031.4,131.4,251.2>
  }
  triangle { // #7977
		<-989.95,0,30.1>,
		<-986.15,0,34.8>,
		<-989.95,0,34.8>
  }
  triangle { // #7978
		<-986.15,0,34.8>,
		<-982.4,0,21.9>,
		<-982.4,0,35.75>
  }
  triangle { // #7979
		<-986.15,0,34.8>,
		<-989.95,0,21.9>,
		<-982.4,0,21.9>
  }
  triangle { // #7980
		<-986.15,0,34.8>,
		<-989.95,0,26.6>,
		<-989.95,0,21.9>
  }
  triangle { // #7981
		<-991.5,0,26.6>,
		<-989.95,0,30.1>,
		<-991.5,0,30.1>
  }
  triangle { // #7982
		<-989.95,0,26.6>,
		<-989.95,0,30.1>,
		<-991.5,0,26.6>
  }
  triangle { // #7983
		<-986.15,0,34.8>,
		<-989.95,0,30.1>,
		<-989.95,0,26.6>
  }
  triangle { // #7984
		<-986.15,213.75,34.8>,
		<-989.95,213.75,30.1>,
		<-989.95,213.75,34.8>
  }
  triangle { // #7985
		<-982.4,213.75,21.9>,
		<-986.15,213.75,34.8>,
		<-982.4,213.75,35.75>
  }
  triangle { // #7986
		<-989.95,213.75,21.9>,
		<-986.15,213.75,34.8>,
		<-982.4,213.75,21.9>
  }
  triangle { // #7987
		<-989.95,213.75,26.6>,
		<-986.15,213.75,34.8>,
		<-989.95,213.75,21.9>
  }
  triangle { // #7988
		<-991.5,213.75,30.1>,
		<-989.95,213.75,26.6>,
		<-991.5,213.75,26.6>
  }
  triangle { // #7989
		<-989.95,213.75,30.1>,
		<-989.95,213.75,26.6>,
		<-991.5,213.75,30.1>
  }
  triangle { // #7990
		<-989.95,213.75,30.1>,
		<-986.15,213.75,34.8>,
		<-989.95,213.75,26.6>
  }
  triangle { // #7991
		<-982.4,0,21.9>,
		<-982.4,213.75,35.75>,
		<-982.4,0,35.75>
  }
  triangle { // #7992
		<-982.4,213.75,35.75>,
		<-982.4,0,21.9>,
		<-982.4,213.75,21.9>
  }
  smooth_triangle { // #7993
		<-982.4,0,35.75>, <-0.243,-0.97,0>,
		<-986.15,213.75,34.8>, <-0.163,-0.987,0>,
		<-986.15,0,34.8>, <-0.081,-0.997,0>
  }
  smooth_triangle { // #7994
		<-986.15,213.75,34.8>, <-0.163,-0.987,0>,
		<-982.4,0,35.75>, <-0.243,-0.97,0>,
		<-982.4,213.75,35.75>, <-0.243,-0.97,0>
  }
  smooth_triangle { // #7995
		<-986.15,0,34.8>, <-0.081,-0.997,0>,
		<-989.95,213.75,34.8>, <0,-1,0>,
		<-989.95,0,34.8>, <0,-1,0>
  }
  smooth_triangle { // #7996
		<-989.95,213.75,34.8>, <0,-1,0>,
		<-986.15,0,34.8>, <-0.081,-0.997,0>,
		<-986.15,213.75,34.8>, <-0.163,-0.987,0>
  }
  triangle { // #7997
		<-989.95,0,34.8>,
		<-989.95,213.75,30.1>,
		<-989.95,0,30.1>
  }
  triangle { // #7998
		<-989.95,213.75,30.1>,
		<-989.95,0,34.8>,
		<-989.95,213.75,34.8>
  }
  triangle { // #7999
		<-989.95,0,30.1>,
		<-991.5,213.75,30.1>,
		<-991.5,0,30.1>
  }
  triangle { // #8000
		<-991.5,213.75,30.1>,
		<-989.95,0,30.1>,
		<-989.95,213.75,30.1>
  }
  triangle { // #8001
		<-991.5,0,30.1>,
		<-991.5,213.75,26.6>,
		<-991.5,0,26.6>
  }
  triangle { // #8002
		<-991.5,213.75,26.6>,
		<-991.5,0,30.1>,
		<-991.5,213.75,30.1>
  }
  triangle { // #8003
		<-991.5,0,26.6>,
		<-989.95,213.75,26.6>,
		<-989.95,0,26.6>
  }
  triangle { // #8004
		<-989.95,213.75,26.6>,
		<-991.5,0,26.6>,
		<-991.5,213.75,26.6>
  }
  triangle { // #8005
		<-989.95,0,26.6>,
		<-989.95,213.75,21.9>,
		<-989.95,0,21.9>
  }
  triangle { // #8006
		<-989.95,213.75,21.9>,
		<-989.95,0,26.6>,
		<-989.95,213.75,26.6>
  }
  triangle { // #8007
		<-989.95,0,21.9>,
		<-982.4,213.75,21.9>,
		<-982.4,0,21.9>
  }
  triangle { // #8008
		<-982.4,213.75,21.9>,
		<-989.95,0,21.9>,
		<-989.95,213.75,21.9>
  }
  triangle { // #8009
		<-1080.45,213.75,30.1>,
		<-1084.25,213.75,34.8>,
		<-1080.45,213.75,34.8>
  }
  triangle { // #8010
		<-1084.25,213.75,34.8>,
		<-1088,213.75,21.9>,
		<-1088,213.75,35.75>
  }
  triangle { // #8011
		<-1084.25,213.75,34.8>,
		<-1080.45,213.75,21.9>,
		<-1088,213.75,21.9>
  }
  triangle { // #8012
		<-1084.25,213.75,34.8>,
		<-1080.45,213.75,26.6>,
		<-1080.45,213.75,21.9>
  }
  triangle { // #8013
		<-1078.9,213.75,26.6>,
		<-1080.45,213.75,30.1>,
		<-1078.9,213.75,30.1>
  }
  triangle { // #8014
		<-1080.45,213.75,26.6>,
		<-1080.45,213.75,30.1>,
		<-1078.9,213.75,26.6>
  }
  triangle { // #8015
		<-1084.25,213.75,34.8>,
		<-1080.45,213.75,30.1>,
		<-1080.45,213.75,26.6>
  }
  triangle { // #8016
		<-1084.25,0,34.8>,
		<-1080.45,0,30.1>,
		<-1080.45,0,34.8>
  }
  triangle { // #8017
		<-1088,0,21.9>,
		<-1084.25,0,34.8>,
		<-1088,0,35.75>
  }
  triangle { // #8018
		<-1080.45,0,21.9>,
		<-1084.25,0,34.8>,
		<-1088,0,21.9>
  }
  triangle { // #8019
		<-1080.45,0,26.6>,
		<-1084.25,0,34.8>,
		<-1080.45,0,21.9>
  }
  triangle { // #8020
		<-1078.9,0,30.1>,
		<-1080.45,0,26.6>,
		<-1078.9,0,26.6>
  }
  triangle { // #8021
		<-1080.45,0,30.1>,
		<-1080.45,0,26.6>,
		<-1078.9,0,30.1>
  }
  triangle { // #8022
		<-1080.45,0,30.1>,
		<-1084.25,0,34.8>,
		<-1080.45,0,26.6>
  }
  triangle { // #8023
		<-1088,213.75,21.9>,
		<-1088,0,35.75>,
		<-1088,213.75,35.75>
  }
  triangle { // #8024
		<-1088,0,35.75>,
		<-1088,213.75,21.9>,
		<-1088,0,21.9>
  }
  smooth_triangle { // #8025
		<-1088,213.75,35.75>, <0.243,-0.97,0>,
		<-1084.25,0,34.8>, <0.163,-0.987,0>,
		<-1084.25,213.75,34.8>, <0.081,-0.997,0>
  }
  smooth_triangle { // #8026
		<-1084.25,0,34.8>, <0.163,-0.987,0>,
		<-1088,213.75,35.75>, <0.243,-0.97,0>,
		<-1088,0,35.75>, <0.243,-0.97,0>
  }
  smooth_triangle { // #8027
		<-1084.25,213.75,34.8>, <0.081,-0.997,0>,
		<-1080.45,0,34.8>, <0,-1,0>,
		<-1080.45,213.75,34.8>, <0,-1,0>
  }
  smooth_triangle { // #8028
		<-1080.45,0,34.8>, <0,-1,0>,
		<-1084.25,213.75,34.8>, <0.081,-0.997,0>,
		<-1084.25,0,34.8>, <0.163,-0.987,0>
  }
  triangle { // #8029
		<-1080.45,213.75,34.8>,
		<-1080.45,0,30.1>,
		<-1080.45,213.75,30.1>
  }
  triangle { // #8030
		<-1080.45,0,30.1>,
		<-1080.45,213.75,34.8>,
		<-1080.45,0,34.8>
  }
  triangle { // #8031
		<-1080.45,213.75,30.1>,
		<-1078.9,0,30.1>,
		<-1078.9,213.75,30.1>
  }
  triangle { // #8032
		<-1078.9,0,30.1>,
		<-1080.45,213.75,30.1>,
		<-1080.45,0,30.1>
  }
  triangle { // #8033
		<-1078.9,213.75,30.1>,
		<-1078.9,0,26.6>,
		<-1078.9,213.75,26.6>
  }
  triangle { // #8034
		<-1078.9,0,26.6>,
		<-1078.9,213.75,30.1>,
		<-1078.9,0,30.1>
  }
  triangle { // #8035
		<-1078.9,213.75,26.6>,
		<-1080.45,0,26.6>,
		<-1080.45,213.75,26.6>
  }
  triangle { // #8036
		<-1080.45,0,26.6>,
		<-1078.9,213.75,26.6>,
		<-1078.9,0,26.6>
  }
  triangle { // #8037
		<-1080.45,213.75,26.6>,
		<-1080.45,0,21.9>,
		<-1080.45,213.75,21.9>
  }
  triangle { // #8038
		<-1080.45,0,21.9>,
		<-1080.45,213.75,26.6>,
		<-1080.45,0,26.6>
  }
  triangle { // #8039
		<-1080.45,213.75,21.9>,
		<-1088,0,21.9>,
		<-1088,213.75,21.9>
  }
  triangle { // #8040
		<-1088,0,21.9>,
		<-1080.45,213.75,21.9>,
		<-1080.45,0,21.9>
  }
  triangle { // #8041
		<-982.4,206.2,30.1>,
		<-982.4,209.95,34.8>,
		<-982.4,206.2,34.8>
  }
  triangle { // #8042
		<-982.4,209.95,34.8>,
		<-982.4,213.75,21.9>,
		<-982.4,213.75,35.75>
  }
  triangle { // #8043
		<-982.4,209.95,34.8>,
		<-982.4,206.2,21.9>,
		<-982.4,213.75,21.9>
  }
  triangle { // #8044
		<-982.4,209.95,34.8>,
		<-982.4,206.2,26.6>,
		<-982.4,206.2,21.9>
  }
  triangle { // #8045
		<-982.4,204.65,26.6>,
		<-982.4,206.2,30.1>,
		<-982.4,204.65,30.1>
  }
  triangle { // #8046
		<-982.4,206.2,26.6>,
		<-982.4,206.2,30.1>,
		<-982.4,204.65,26.6>
  }
  triangle { // #8047
		<-982.4,209.95,34.8>,
		<-982.4,206.2,30.1>,
		<-982.4,206.2,26.6>
  }
  triangle { // #8048
		<-1088,209.95,34.8>,
		<-1088,206.2,30.1>,
		<-1088,206.2,34.8>
  }
  triangle { // #8049
		<-1088,213.75,21.9>,
		<-1088,209.95,34.8>,
		<-1088,213.75,35.75>
  }
  triangle { // #8050
		<-1088,206.2,21.9>,
		<-1088,209.95,34.8>,
		<-1088,213.75,21.9>
  }
  triangle { // #8051
		<-1088,206.2,26.6>,
		<-1088,209.95,34.8>,
		<-1088,206.2,21.9>
  }
  triangle { // #8052
		<-1088,204.65,30.1>,
		<-1088,206.2,26.6>,
		<-1088,204.65,26.6>
  }
  triangle { // #8053
		<-1088,206.2,30.1>,
		<-1088,206.2,26.6>,
		<-1088,204.65,30.1>
  }
  triangle { // #8054
		<-1088,206.2,30.1>,
		<-1088,209.95,34.8>,
		<-1088,206.2,26.6>
  }
  triangle { // #8055
		<-982.4,213.75,21.9>,
		<-1088,213.75,35.75>,
		<-982.4,213.75,35.75>
  }
  triangle { // #8056
		<-1088,213.75,35.75>,
		<-982.4,213.75,21.9>,
		<-1088,213.75,21.9>
  }
  smooth_triangle { // #8057
		<-982.4,213.75,35.75>, <-0.082,-0.983,-0.164>,
		<-1088,209.95,34.8>, <0,-0.987,-0.163>,
		<-982.4,209.95,34.8>, <0,-0.997,-0.081>
  }
  smooth_triangle { // #8058
		<-1088,209.95,34.8>, <0,-0.987,-0.163>,
		<-982.4,213.75,35.75>, <-0.082,-0.983,-0.164>,
		<-1088,213.75,35.75>, <0.164,-0.983,-0.082>
  }
  smooth_triangle { // #8059
		<-982.4,209.95,34.8>, <0,-0.997,-0.081>,
		<-1088,206.2,34.8>, <0,-1,0>,
		<-982.4,206.2,34.8>, <0,-1,0>
  }
  smooth_triangle { // #8060
		<-1088,206.2,34.8>, <0,-1,0>,
		<-982.4,209.95,34.8>, <0,-0.997,-0.081>,
		<-1088,209.95,34.8>, <0,-0.987,-0.163>
  }
  triangle { // #8061
		<-982.4,206.2,34.8>,
		<-1088,206.2,30.1>,
		<-982.4,206.2,30.1>
  }
  triangle { // #8062
		<-1088,206.2,30.1>,
		<-982.4,206.2,34.8>,
		<-1088,206.2,34.8>
  }
  triangle { // #8063
		<-982.4,206.2,30.1>,
		<-1088,204.65,30.1>,
		<-982.4,204.65,30.1>
  }
  triangle { // #8064
		<-1088,204.65,30.1>,
		<-982.4,206.2,30.1>,
		<-1088,206.2,30.1>
  }
  triangle { // #8065
		<-982.4,204.65,30.1>,
		<-1088,204.65,26.6>,
		<-982.4,204.65,26.6>
  }
  triangle { // #8066
		<-1088,204.65,26.6>,
		<-982.4,204.65,30.1>,
		<-1088,204.65,30.1>
  }
  triangle { // #8067
		<-982.4,204.65,26.6>,
		<-1088,206.2,26.6>,
		<-982.4,206.2,26.6>
  }
  triangle { // #8068
		<-1088,206.2,26.6>,
		<-982.4,204.65,26.6>,
		<-1088,204.65,26.6>
  }
  triangle { // #8069
		<-982.4,206.2,26.6>,
		<-1088,206.2,21.9>,
		<-982.4,206.2,21.9>
  }
  triangle { // #8070
		<-1088,206.2,21.9>,
		<-982.4,206.2,26.6>,
		<-1088,206.2,26.6>
  }
  triangle { // #8071
		<-982.4,206.2,21.9>,
		<-1088,213.75,21.9>,
		<-982.4,213.75,21.9>
  }
  triangle { // #8072
		<-1088,213.75,21.9>,
		<-982.4,206.2,21.9>,
		<-1088,206.2,21.9>
  }
  triangle { // #8073
		<-1075.75,0,35.3>,
		<-1089.9,0,124.8>,
		<-1080.45,0,34.8>
  }
  triangle { // #8074
		<-1089.9,0,124.8>,
		<-1075.75,0,35.3>,
		<-1085.25,0,125.3>
  }
  triangle { // #8075
		<-1080.45,206.2,34.8>,
		<-1085.25,206.2,125.3>,
		<-1075.75,206.2,35.3>
  }
  triangle { // #8076
		<-1085.25,206.2,125.3>,
		<-1080.45,206.2,34.8>,
		<-1089.9,206.2,124.8>
  }
  triangle { // #8077
		<-1080.45,0,34.8>,
		<-1075.75,206.2,35.3>,
		<-1075.75,0,35.3>
  }
  triangle { // #8078
		<-1075.75,206.2,35.3>,
		<-1080.45,0,34.8>,
		<-1080.45,206.2,34.8>
  }
  triangle { // #8079
		<-1075.75,0,35.3>,
		<-1085.25,206.2,125.3>,
		<-1085.25,0,125.3>
  }
  triangle { // #8080
		<-1085.25,206.2,125.3>,
		<-1075.75,0,35.3>,
		<-1075.75,206.2,35.3>
  }
  triangle { // #8081
		<-1085.25,0,125.3>,
		<-1089.9,206.2,124.8>,
		<-1089.9,0,124.8>
  }
  triangle { // #8082
		<-1089.9,206.2,124.8>,
		<-1085.25,0,125.3>,
		<-1085.25,206.2,125.3>
  }
  triangle { // #8083
		<-1089.9,0,124.8>,
		<-1080.45,206.2,34.8>,
		<-1080.45,0,34.8>
  }
  triangle { // #8084
		<-1080.45,206.2,34.8>,
		<-1089.9,0,124.8>,
		<-1089.9,206.2,124.8>
  }
  triangle { // #8085
		<-1088,213.75,-2>,
		<-982.4,213.75,28.2>,
		<-1088,213.75,28.2>
  }
  triangle { // #8086
		<-982.4,213.75,28.2>,
		<-1088,213.75,-2>,
		<-982.4,213.75,-2>
  }
  triangle { // #8087
		<-1088,574.25,28.2>,
		<-982.4,574.25,-2>,
		<-1088,574.25,-2>
  }
  triangle { // #8088
		<-982.4,574.25,-2>,
		<-1088,574.25,28.2>,
		<-982.4,574.25,28.2>
  }
  triangle { // #8089
		<-1088,213.75,28.2>,
		<-1088,574.25,-2>,
		<-1088,213.75,-2>
  }
  triangle { // #8090
		<-1088,574.25,-2>,
		<-1088,213.75,28.2>,
		<-1088,574.25,28.2>
  }
  triangle { // #8091
		<-1088,213.75,-2>,
		<-982.4,574.25,-2>,
		<-982.4,213.75,-2>
  }
  triangle { // #8092
		<-982.4,574.25,-2>,
		<-1088,213.75,-2>,
		<-1088,574.25,-2>
  }
  triangle { // #8093
		<-982.4,213.75,-2>,
		<-982.4,574.25,28.2>,
		<-982.4,213.75,28.2>
  }
  triangle { // #8094
		<-982.4,574.25,28.2>,
		<-982.4,213.75,-2>,
		<-982.4,574.25,-2>
  }
  triangle { // #8095
		<-982.4,213.75,28.2>,
		<-1088,574.25,28.2>,
		<-1088,213.75,28.2>
  }
  triangle { // #8096
		<-1088,574.25,28.2>,
		<-982.4,213.75,28.2>,
		<-982.4,574.25,28.2>
  }
  triangle { // #8097
		<-762.65,205.25,-826.6>,
		<-762.65,201.15,-821.9>,
		<-762.65,208.7,-824.75>
  }
  triangle { // #8098
		<-762.65,208.7,-827.9>,
		<-762.65,205.25,-826.6>,
		<-762.65,208.7,-824.75>
  }
  triangle { // #8099
		<-762.65,199.6,-818.45>,
		<-762.65,201.15,-818.45>,
		<-762.65,199.6,-821.9>
  }
  triangle { // #8100
		<-762.65,199.6,-821.9>,
		<-762.65,201.15,-818.45>,
		<-762.65,201.15,-821.9>
  }
  triangle { // #8101
		<-762.65,201.15,-826.6>,
		<-762.65,201.15,-821.9>,
		<-762.65,205.25,-826.6>
  }
  triangle { // #8102
		<-762.65,201.15,-813.75>,
		<-762.65,208.7,-813.75>,
		<-762.65,201.15,-818.45>
  }
  triangle { // #8103
		<-762.65,208.7,-813.75>,
		<-762.65,208.7,-824.75>,
		<-762.65,201.15,-818.45>
  }
  triangle { // #8104
		<-762.65,201.15,-818.45>,
		<-762.65,208.7,-824.75>,
		<-762.65,201.15,-821.9>
  }
  triangle { // #8105
		<-657.4,205.25,-826.6>,
		<-657.4,208.7,-824.75>,
		<-657.4,201.15,-821.9>
  }
  triangle { // #8106
		<-657.4,208.7,-827.9>,
		<-657.4,208.7,-824.75>,
		<-657.4,205.25,-826.6>
  }
  triangle { // #8107
		<-657.4,199.6,-821.9>,
		<-657.4,201.15,-821.9>,
		<-657.4,199.6,-818.45>
  }
  triangle { // #8108
		<-657.4,199.6,-818.45>,
		<-657.4,201.15,-821.9>,
		<-657.4,201.15,-818.45>
  }
  triangle { // #8109
		<-657.4,201.15,-826.6>,
		<-657.4,205.25,-826.6>,
		<-657.4,201.15,-821.9>
  }
  triangle { // #8110
		<-657.4,201.15,-813.75>,
		<-657.4,201.15,-818.45>,
		<-657.4,208.7,-813.75>
  }
  triangle { // #8111
		<-657.4,208.7,-813.75>,
		<-657.4,201.15,-818.45>,
		<-657.4,208.7,-824.75>
  }
  triangle { // #8112
		<-657.4,201.15,-818.45>,
		<-657.4,201.15,-821.9>,
		<-657.4,208.7,-824.75>
  }
  triangle { // #8113
		<-762.65,201.15,-813.75>,
		<-657.4,201.15,-813.75>,
		<-762.65,208.7,-813.75>
  }
  triangle { // #8114
		<-657.4,208.7,-813.75>,
		<-762.65,208.7,-813.75>,
		<-657.4,201.15,-813.75>
  }
  triangle { // #8115
		<-762.65,201.15,-818.45>,
		<-657.4,201.15,-818.45>,
		<-762.65,201.15,-813.75>
  }
  triangle { // #8116
		<-657.4,201.15,-813.75>,
		<-762.65,201.15,-813.75>,
		<-657.4,201.15,-818.45>
  }
  triangle { // #8117
		<-762.65,199.6,-818.45>,
		<-657.4,199.6,-818.45>,
		<-762.65,201.15,-818.45>
  }
  triangle { // #8118
		<-657.4,201.15,-818.45>,
		<-762.65,201.15,-818.45>,
		<-657.4,199.6,-818.45>
  }
  triangle { // #8119
		<-762.65,199.6,-821.9>,
		<-657.4,199.6,-821.9>,
		<-762.65,199.6,-818.45>
  }
  triangle { // #8120
		<-657.4,199.6,-818.45>,
		<-762.65,199.6,-818.45>,
		<-657.4,199.6,-821.9>
  }
  triangle { // #8121
		<-762.65,201.15,-821.9>,
		<-657.4,201.15,-821.9>,
		<-762.65,199.6,-821.9>
  }
  triangle { // #8122
		<-657.4,199.6,-821.9>,
		<-762.65,199.6,-821.9>,
		<-657.4,201.15,-821.9>
  }
  triangle { // #8123
		<-762.65,201.15,-826.6>,
		<-657.4,201.15,-826.6>,
		<-762.65,201.15,-821.9>
  }
  triangle { // #8124
		<-657.4,201.15,-821.9>,
		<-762.65,201.15,-821.9>,
		<-657.4,201.15,-826.6>
  }
  smooth_triangle { // #8125
		<-762.65,205.25,-826.6>, <0,0.973,-0.231>,
		<-657.4,205.25,-826.6>, <0,0.993,-0.115>,
		<-762.65,201.15,-826.6>, <0,1,0>
  }
  smooth_triangle { // #8126
		<-657.4,201.15,-826.6>, <0,1,0>,
		<-762.65,201.15,-826.6>, <0,1,0>,
		<-657.4,205.25,-826.6>, <0,0.993,-0.115>
  }
  smooth_triangle { // #8127
		<-762.65,208.7,-827.9>, <0.176,0.968,-0.176>,
		<-657.4,208.7,-827.9>, <-0.176,0.968,-0.176>,
		<-762.65,205.25,-826.6>, <0,0.973,-0.231>
  }
  smooth_triangle { // #8128
		<-657.4,205.25,-826.6>, <0,0.993,-0.115>,
		<-762.65,205.25,-826.6>, <0,0.973,-0.231>,
		<-657.4,208.7,-827.9>, <-0.176,0.968,-0.176>
  }
  triangle { // #8129
		<-762.65,208.7,-824.75>,
		<-657.4,208.7,-824.75>,
		<-762.65,208.7,-827.9>
  }
  triangle { // #8130
		<-657.4,208.7,-827.9>,
		<-762.65,208.7,-827.9>,
		<-657.4,208.7,-824.75>
  }
  triangle { // #8131
		<-762.65,208.7,-813.75>,
		<-657.4,208.7,-813.75>,
		<-762.65,208.7,-824.75>
  }
  triangle { // #8132
		<-657.4,208.7,-824.75>,
		<-762.65,208.7,-824.75>,
		<-657.4,208.7,-813.75>
  }
  triangle { // #8133
		<1013.9,208.7,-605.8>,
		<1010.1,208.7,-606.75>,
		<1012.3,208.7,-605.8>
  }
  triangle { // #8134
		<1004.75,208.7,-611.8>,
		<1006.35,208.7,-615.85>,
		<1004.75,208.7,-615.85>
  }
  triangle { // #8135
		<1006.35,208.7,-611.8>,
		<1006.35,208.7,-615.85>,
		<1004.75,208.7,-611.8>
  }
  triangle { // #8136
		<1010.1,208.7,-606.75>,
		<1006.35,208.7,-611.8>,
		<1006.35,208.7,-606.75>
  }
  triangle { // #8137
		<1006.35,208.7,-615.85>,
		<1013.9,208.7,-620.6>,
		<1006.35,208.7,-620.6>
  }
  triangle { // #8138
		<1006.35,208.7,-615.85>,
		<1013.9,208.7,-605.8>,
		<1013.9,208.7,-620.6>
  }
  triangle { // #8139
		<1006.35,208.7,-611.8>,
		<1013.9,208.7,-605.8>,
		<1006.35,208.7,-615.85>
  }
  triangle { // #8140
		<1010.1,208.7,-606.75>,
		<1013.9,208.7,-605.8>,
		<1006.35,208.7,-611.8>
  }
  triangle { // #8141
		<1010.1,0,-606.75>,
		<1013.9,0,-605.8>,
		<1012.3,0,-605.8>
  }
  triangle { // #8142
		<1004.75,0,-615.85>,
		<1006.35,0,-611.8>,
		<1004.75,0,-611.8>
  }
  triangle { // #8143
		<1006.35,0,-615.85>,
		<1006.35,0,-611.8>,
		<1004.75,0,-615.85>
  }
  triangle { // #8144
		<1006.35,0,-611.8>,
		<1010.1,0,-606.75>,
		<1006.35,0,-606.75>
  }
  triangle { // #8145
		<1013.9,0,-620.6>,
		<1006.35,0,-615.85>,
		<1006.35,0,-620.6>
  }
  triangle { // #8146
		<1013.9,0,-605.8>,
		<1006.35,0,-615.85>,
		<1013.9,0,-620.6>
  }
  triangle { // #8147
		<1013.9,0,-605.8>,
		<1006.35,0,-611.8>,
		<1006.35,0,-615.85>
  }
  triangle { // #8148
		<1013.9,0,-605.8>,
		<1010.1,0,-606.75>,
		<1006.35,0,-611.8>
  }
  triangle { // #8149
		<1013.9,208.7,-620.6>,
		<1006.35,0,-620.6>,
		<1006.35,208.7,-620.6>
  }
  triangle { // #8150
		<1006.35,0,-620.6>,
		<1013.9,208.7,-620.6>,
		<1013.9,0,-620.6>
  }
  triangle { // #8151
		<1006.35,208.7,-620.6>,
		<1006.35,0,-615.85>,
		<1006.35,208.7,-615.85>
  }
  triangle { // #8152
		<1006.35,0,-615.85>,
		<1006.35,208.7,-620.6>,
		<1006.35,0,-620.6>
  }
  triangle { // #8153
		<1006.35,208.7,-615.85>,
		<1004.75,0,-615.85>,
		<1004.75,208.7,-615.85>
  }
  triangle { // #8154
		<1004.75,0,-615.85>,
		<1006.35,208.7,-615.85>,
		<1006.35,0,-615.85>
  }
  triangle { // #8155
		<1004.75,208.7,-615.85>,
		<1004.75,0,-611.8>,
		<1004.75,208.7,-611.8>
  }
  triangle { // #8156
		<1004.75,0,-611.8>,
		<1004.75,208.7,-615.85>,
		<1004.75,0,-615.85>
  }
  triangle { // #8157
		<1004.75,208.7,-611.8>,
		<1006.35,0,-611.8>,
		<1006.35,208.7,-611.8>
  }
  triangle { // #8158
		<1006.35,0,-611.8>,
		<1004.75,208.7,-611.8>,
		<1004.75,0,-611.8>
  }
  triangle { // #8159
		<1006.35,208.7,-611.8>,
		<1006.35,0,-606.75>,
		<1006.35,208.7,-606.75>
  }
  triangle { // #8160
		<1006.35,0,-606.75>,
		<1006.35,208.7,-611.8>,
		<1006.35,0,-611.8>
  }
  smooth_triangle { // #8161
		<1006.35,208.7,-606.75>, <0,-1,0>,
		<1010.1,0,-606.75>, <-0.134,-0.991,0>,
		<1010.1,208.7,-606.75>, <-0.267,-0.964,0>
  }
  smooth_triangle { // #8162
		<1010.1,0,-606.75>, <-0.134,-0.991,0>,
		<1006.35,208.7,-606.75>, <0,-1,0>,
		<1006.35,0,-606.75>, <0,-1,0>
  }
  smooth_triangle { // #8163
		<1010.1,208.7,-606.75>, <-0.267,-0.964,0>,
		<1012.3,0,-605.8>, <-0.267,-0.964,0>,
		<1012.3,208.7,-605.8>, <-0.134,-0.991,0>
  }
  smooth_triangle { // #8164
		<1012.3,0,-605.8>, <-0.267,-0.964,0>,
		<1010.1,208.7,-606.75>, <-0.267,-0.964,0>,
		<1010.1,0,-606.75>, <-0.134,-0.991,0>
  }
  smooth_triangle { // #8165
		<1012.3,208.7,-605.8>, <-0.134,-0.991,0>,
		<1013.9,0,-605.8>, <0,-1,0>,
		<1013.9,208.7,-605.8>, <0,-1,0>
  }
  smooth_triangle { // #8166
		<1013.9,0,-605.8>, <0,-1,0>,
		<1012.3,208.7,-605.8>, <-0.134,-0.991,0>,
		<1012.3,0,-605.8>, <-0.267,-0.964,0>
  }
  triangle { // #8167
		<1013.9,208.7,-605.8>,
		<1013.9,0,-620.6>,
		<1013.9,208.7,-620.6>
  }
  triangle { // #8168
		<1013.9,0,-620.6>,
		<1013.9,208.7,-605.8>,
		<1013.9,0,-605.8>
  }
  triangle { // #8169
		<907.65,0,-605.8>,
		<911.4,0,-606.75>,
		<909.2,0,-605.8>
  }
  triangle { // #8170
		<916.75,0,-611.8>,
		<915.2,0,-615.85>,
		<916.75,0,-615.85>
  }
  triangle { // #8171
		<915.2,0,-611.8>,
		<915.2,0,-615.85>,
		<916.75,0,-611.8>
  }
  triangle { // #8172
		<911.4,0,-606.75>,
		<915.2,0,-611.8>,
		<915.2,0,-606.75>
  }
  triangle { // #8173
		<915.2,0,-615.85>,
		<907.65,0,-620.6>,
		<915.2,0,-620.6>
  }
  triangle { // #8174
		<915.2,0,-615.85>,
		<907.65,0,-605.8>,
		<907.65,0,-620.6>
  }
  triangle { // #8175
		<915.2,0,-611.8>,
		<907.65,0,-605.8>,
		<915.2,0,-615.85>
  }
  triangle { // #8176
		<911.4,0,-606.75>,
		<907.65,0,-605.8>,
		<915.2,0,-611.8>
  }
  triangle { // #8177
		<911.4,208.7,-606.75>,
		<907.65,208.7,-605.8>,
		<909.2,208.7,-605.8>
  }
  triangle { // #8178
		<916.75,208.7,-615.85>,
		<915.2,208.7,-611.8>,
		<916.75,208.7,-611.8>
  }
  triangle { // #8179
		<915.2,208.7,-615.85>,
		<915.2,208.7,-611.8>,
		<916.75,208.7,-615.85>
  }
  triangle { // #8180
		<915.2,208.7,-611.8>,
		<911.4,208.7,-606.75>,
		<915.2,208.7,-606.75>
  }
  triangle { // #8181
		<907.65,208.7,-620.6>,
		<915.2,208.7,-615.85>,
		<915.2,208.7,-620.6>
  }
  triangle { // #8182
		<907.65,208.7,-605.8>,
		<915.2,208.7,-615.85>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8183
		<907.65,208.7,-605.8>,
		<915.2,208.7,-611.8>,
		<915.2,208.7,-615.85>
  }
  triangle { // #8184
		<907.65,208.7,-605.8>,
		<911.4,208.7,-606.75>,
		<915.2,208.7,-611.8>
  }
  triangle { // #8185
		<907.65,0,-620.6>,
		<915.2,208.7,-620.6>,
		<915.2,0,-620.6>
  }
  triangle { // #8186
		<915.2,208.7,-620.6>,
		<907.65,0,-620.6>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8187
		<915.2,0,-620.6>,
		<915.2,208.7,-615.85>,
		<915.2,0,-615.85>
  }
  triangle { // #8188
		<915.2,208.7,-615.85>,
		<915.2,0,-620.6>,
		<915.2,208.7,-620.6>
  }
  triangle { // #8189
		<915.2,0,-615.85>,
		<916.75,208.7,-615.85>,
		<916.75,0,-615.85>
  }
  triangle { // #8190
		<916.75,208.7,-615.85>,
		<915.2,0,-615.85>,
		<915.2,208.7,-615.85>
  }
  triangle { // #8191
		<916.75,0,-615.85>,
		<916.75,208.7,-611.8>,
		<916.75,0,-611.8>
  }
  triangle { // #8192
		<916.75,208.7,-611.8>,
		<916.75,0,-615.85>,
		<916.75,208.7,-615.85>
  }
  triangle { // #8193
		<916.75,0,-611.8>,
		<915.2,208.7,-611.8>,
		<915.2,0,-611.8>
  }
  triangle { // #8194
		<915.2,208.7,-611.8>,
		<916.75,0,-611.8>,
		<916.75,208.7,-611.8>
  }
  triangle { // #8195
		<915.2,0,-611.8>,
		<915.2,208.7,-606.75>,
		<915.2,0,-606.75>
  }
  triangle { // #8196
		<915.2,208.7,-606.75>,
		<915.2,0,-611.8>,
		<915.2,208.7,-611.8>
  }
  smooth_triangle { // #8197
		<915.2,0,-606.75>, <0,-1,0>,
		<911.4,208.7,-606.75>, <0.134,-0.991,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>
  }
  smooth_triangle { // #8198
		<911.4,208.7,-606.75>, <0.134,-0.991,0>,
		<915.2,0,-606.75>, <0,-1,0>,
		<915.2,208.7,-606.75>, <0,-1,0>
  }
  smooth_triangle { // #8199
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<909.2,208.7,-605.8>, <0.267,-0.964,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>
  }
  smooth_triangle { // #8200
		<909.2,208.7,-605.8>, <0.267,-0.964,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<911.4,208.7,-606.75>, <0.134,-0.991,0>
  }
  smooth_triangle { // #8201
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<907.65,208.7,-605.8>, <0,-1,0>,
		<907.65,0,-605.8>, <0,-1,0>
  }
  smooth_triangle { // #8202
		<907.65,208.7,-605.8>, <0,-1,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<909.2,208.7,-605.8>, <0.267,-0.964,0>
  }
  triangle { // #8203
		<907.65,0,-605.8>,
		<907.65,208.7,-620.6>,
		<907.65,0,-620.6>
  }
  triangle { // #8204
		<907.65,208.7,-620.6>,
		<907.65,0,-605.8>,
		<907.65,208.7,-605.8>
  }
  triangle { // #8205
		<907.65,208.7,-605.8>,
		<907.65,204.95,-606.75>,
		<907.65,207.15,-605.8>
  }
  triangle { // #8206
		<907.65,199.6,-611.8>,
		<907.65,201.15,-615.85>,
		<907.65,199.6,-615.85>
  }
  triangle { // #8207
		<907.65,201.15,-611.8>,
		<907.65,201.15,-615.85>,
		<907.65,199.6,-611.8>
  }
  triangle { // #8208
		<907.65,204.95,-606.75>,
		<907.65,201.15,-611.8>,
		<907.65,201.15,-606.75>
  }
  triangle { // #8209
		<907.65,201.15,-615.85>,
		<907.65,208.7,-620.6>,
		<907.65,201.15,-620.6>
  }
  triangle { // #8210
		<907.65,201.15,-615.85>,
		<907.65,208.7,-605.8>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8211
		<907.65,201.15,-611.8>,
		<907.65,208.7,-605.8>,
		<907.65,201.15,-615.85>
  }
  triangle { // #8212
		<907.65,204.95,-606.75>,
		<907.65,208.7,-605.8>,
		<907.65,201.15,-611.8>
  }
  triangle { // #8213
		<1013.9,204.95,-606.75>,
		<1013.9,208.7,-605.8>,
		<1013.9,207.15,-605.8>
  }
  triangle { // #8214
		<1013.9,199.6,-615.85>,
		<1013.9,201.15,-611.8>,
		<1013.9,199.6,-611.8>
  }
  triangle { // #8215
		<1013.9,201.15,-615.85>,
		<1013.9,201.15,-611.8>,
		<1013.9,199.6,-615.85>
  }
  triangle { // #8216
		<1013.9,201.15,-611.8>,
		<1013.9,204.95,-606.75>,
		<1013.9,201.15,-606.75>
  }
  triangle { // #8217
		<1013.9,208.7,-620.6>,
		<1013.9,201.15,-615.85>,
		<1013.9,201.15,-620.6>
  }
  triangle { // #8218
		<1013.9,208.7,-605.8>,
		<1013.9,201.15,-615.85>,
		<1013.9,208.7,-620.6>
  }
  triangle { // #8219
		<1013.9,208.7,-605.8>,
		<1013.9,201.15,-611.8>,
		<1013.9,201.15,-615.85>
  }
  triangle { // #8220
		<1013.9,208.7,-605.8>,
		<1013.9,204.95,-606.75>,
		<1013.9,201.15,-611.8>
  }
  triangle { // #8221
		<907.65,208.7,-620.6>,
		<1013.9,201.15,-620.6>,
		<907.65,201.15,-620.6>
  }
  triangle { // #8222
		<1013.9,201.15,-620.6>,
		<907.65,208.7,-620.6>,
		<1013.9,208.7,-620.6>
  }
  triangle { // #8223
		<907.65,201.15,-620.6>,
		<1013.9,201.15,-615.85>,
		<907.65,201.15,-615.85>
  }
  triangle { // #8224
		<1013.9,201.15,-615.85>,
		<907.65,201.15,-620.6>,
		<1013.9,201.15,-620.6>
  }
  triangle { // #8225
		<907.65,201.15,-615.85>,
		<1013.9,199.6,-615.85>,
		<907.65,199.6,-615.85>
  }
  triangle { // #8226
		<1013.9,199.6,-615.85>,
		<907.65,201.15,-615.85>,
		<1013.9,201.15,-615.85>
  }
  triangle { // #8227
		<907.65,199.6,-615.85>,
		<1013.9,199.6,-611.8>,
		<907.65,199.6,-611.8>
  }
  triangle { // #8228
		<1013.9,199.6,-611.8>,
		<907.65,199.6,-615.85>,
		<1013.9,199.6,-615.85>
  }
  triangle { // #8229
		<907.65,199.6,-611.8>,
		<1013.9,201.15,-611.8>,
		<907.65,201.15,-611.8>
  }
  triangle { // #8230
		<1013.9,201.15,-611.8>,
		<907.65,199.6,-611.8>,
		<1013.9,199.6,-611.8>
  }
  triangle { // #8231
		<907.65,201.15,-611.8>,
		<1013.9,201.15,-606.75>,
		<907.65,201.15,-606.75>
  }
  triangle { // #8232
		<1013.9,201.15,-606.75>,
		<907.65,201.15,-611.8>,
		<1013.9,201.15,-611.8>
  }
  smooth_triangle { // #8233
		<907.65,201.15,-606.75>, <0,-1,0>,
		<1013.9,204.95,-606.75>, <0,-0.991,-0.134>,
		<907.65,204.95,-606.75>, <0,-0.964,-0.267>
  }
  smooth_triangle { // #8234
		<1013.9,204.95,-606.75>, <0,-0.991,-0.134>,
		<907.65,201.15,-606.75>, <0,-1,0>,
		<1013.9,201.15,-606.75>, <0,-1,0>
  }
  smooth_triangle { // #8235
		<907.65,204.95,-606.75>, <0,-0.964,-0.267>,
		<1013.9,207.15,-605.8>, <0,-0.964,-0.267>,
		<907.65,207.15,-605.8>, <0,-0.991,-0.134>
  }
  smooth_triangle { // #8236
		<1013.9,207.15,-605.8>, <0,-0.964,-0.267>,
		<907.65,204.95,-606.75>, <0,-0.964,-0.267>,
		<1013.9,204.95,-606.75>, <0,-0.991,-0.134>
  }
  smooth_triangle { // #8237
		<907.65,207.15,-605.8>, <0,-0.991,-0.134>,
		<1013.9,208.7,-605.8>, <0,-1,0>,
		<907.65,208.7,-605.8>, <0,-1,0>
  }
  smooth_triangle { // #8238
		<1013.9,208.7,-605.8>, <0,-1,0>,
		<907.65,207.15,-605.8>, <0,-0.991,-0.134>,
		<1013.9,207.15,-605.8>, <0,-0.964,-0.267>
  }
  triangle { // #8239
		<907.65,208.7,-605.8>,
		<1013.9,208.7,-620.6>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8240
		<1013.9,208.7,-620.6>,
		<907.65,208.7,-605.8>,
		<1013.9,208.7,-605.8>
  }
  triangle { // #8241
		<1388.9,0,-652.95>,
		<1385.1,0,-652>,
		<1387.3,0,-652.95>
  }
  triangle { // #8242
		<1379.75,0,-647>,
		<1381.35,0,-642.9>,
		<1379.75,0,-642.9>
  }
  triangle { // #8243
		<1381.35,0,-647>,
		<1381.35,0,-642.9>,
		<1379.75,0,-647>
  }
  triangle { // #8244
		<1385.1,0,-652>,
		<1381.35,0,-647>,
		<1381.35,0,-652>
  }
  triangle { // #8245
		<1381.35,0,-642.9>,
		<1388.9,0,-638.2>,
		<1381.35,0,-638.2>
  }
  triangle { // #8246
		<1381.35,0,-642.9>,
		<1388.9,0,-652.95>,
		<1388.9,0,-638.2>
  }
  triangle { // #8247
		<1381.35,0,-647>,
		<1388.9,0,-652.95>,
		<1381.35,0,-642.9>
  }
  triangle { // #8248
		<1385.1,0,-652>,
		<1388.9,0,-652.95>,
		<1381.35,0,-647>
  }
  triangle { // #8249
		<1385.1,208.7,-652>,
		<1388.9,208.7,-652.95>,
		<1387.3,208.7,-652.95>
  }
  triangle { // #8250
		<1379.75,208.7,-642.9>,
		<1381.35,208.7,-647>,
		<1379.75,208.7,-647>
  }
  triangle { // #8251
		<1381.35,208.7,-642.9>,
		<1381.35,208.7,-647>,
		<1379.75,208.7,-642.9>
  }
  triangle { // #8252
		<1381.35,208.7,-647>,
		<1385.1,208.7,-652>,
		<1381.35,208.7,-652>
  }
  triangle { // #8253
		<1388.9,208.7,-638.2>,
		<1381.35,208.7,-642.9>,
		<1381.35,208.7,-638.2>
  }
  triangle { // #8254
		<1388.9,208.7,-652.95>,
		<1381.35,208.7,-642.9>,
		<1388.9,208.7,-638.2>
  }
  triangle { // #8255
		<1388.9,208.7,-652.95>,
		<1381.35,208.7,-647>,
		<1381.35,208.7,-642.9>
  }
  triangle { // #8256
		<1388.9,208.7,-652.95>,
		<1385.1,208.7,-652>,
		<1381.35,208.7,-647>
  }
  triangle { // #8257
		<1388.9,0,-638.2>,
		<1381.35,208.7,-638.2>,
		<1381.35,0,-638.2>
  }
  triangle { // #8258
		<1381.35,208.7,-638.2>,
		<1388.9,0,-638.2>,
		<1388.9,208.7,-638.2>
  }
  triangle { // #8259
		<1381.35,0,-638.2>,
		<1381.35,208.7,-642.9>,
		<1381.35,0,-642.9>
  }
  triangle { // #8260
		<1381.35,208.7,-642.9>,
		<1381.35,0,-638.2>,
		<1381.35,208.7,-638.2>
  }
  triangle { // #8261
		<1381.35,0,-642.9>,
		<1379.75,208.7,-642.9>,
		<1379.75,0,-642.9>
  }
  triangle { // #8262
		<1379.75,208.7,-642.9>,
		<1381.35,0,-642.9>,
		<1381.35,208.7,-642.9>
  }
  triangle { // #8263
		<1379.75,0,-642.9>,
		<1379.75,208.7,-647>,
		<1379.75,0,-647>
  }
  triangle { // #8264
		<1379.75,208.7,-647>,
		<1379.75,0,-642.9>,
		<1379.75,208.7,-642.9>
  }
  triangle { // #8265
		<1379.75,0,-647>,
		<1381.35,208.7,-647>,
		<1381.35,0,-647>
  }
  triangle { // #8266
		<1381.35,208.7,-647>,
		<1379.75,0,-647>,
		<1379.75,208.7,-647>
  }
  triangle { // #8267
		<1381.35,0,-647>,
		<1381.35,208.7,-652>,
		<1381.35,0,-652>
  }
  triangle { // #8268
		<1381.35,208.7,-652>,
		<1381.35,0,-647>,
		<1381.35,208.7,-647>
  }
  smooth_triangle { // #8269
		<1381.35,0,-652>, <0,1,0>,
		<1385.1,208.7,-652>, <-0.134,0.991,0>,
		<1385.1,0,-652>, <-0.267,0.964,0>
  }
  smooth_triangle { // #8270
		<1385.1,208.7,-652>, <-0.134,0.991,0>,
		<1381.35,0,-652>, <0,1,0>,
		<1381.35,208.7,-652>, <0,1,0>
  }
  smooth_triangle { // #8271
		<1385.1,0,-652>, <-0.267,0.964,0>,
		<1387.3,208.7,-652.95>, <-0.267,0.964,0>,
		<1387.3,0,-652.95>, <-0.134,0.991,0>
  }
  smooth_triangle { // #8272
		<1387.3,208.7,-652.95>, <-0.267,0.964,0>,
		<1385.1,0,-652>, <-0.267,0.964,0>,
		<1385.1,208.7,-652>, <-0.134,0.991,0>
  }
  smooth_triangle { // #8273
		<1387.3,0,-652.95>, <-0.134,0.991,0>,
		<1388.9,208.7,-652.95>, <0,1,0>,
		<1388.9,0,-652.95>, <0,1,0>
  }
  smooth_triangle { // #8274
		<1388.9,208.7,-652.95>, <0,1,0>,
		<1387.3,0,-652.95>, <-0.134,0.991,0>,
		<1387.3,208.7,-652.95>, <-0.267,0.964,0>
  }
  triangle { // #8275
		<1388.9,0,-652.95>,
		<1388.9,208.7,-638.2>,
		<1388.9,0,-638.2>
  }
  triangle { // #8276
		<1388.9,208.7,-638.2>,
		<1388.9,0,-652.95>,
		<1388.9,208.7,-652.95>
  }
  triangle { // #8277
		<1191.5,208.7,-652.95>,
		<1195.25,208.7,-652>,
		<1193.05,208.7,-652.95>
  }
  triangle { // #8278
		<1200.6,208.7,-647>,
		<1199.05,208.7,-642.9>,
		<1200.6,208.7,-642.9>
  }
  triangle { // #8279
		<1199.05,208.7,-647>,
		<1199.05,208.7,-642.9>,
		<1200.6,208.7,-647>
  }
  triangle { // #8280
		<1195.25,208.7,-652>,
		<1199.05,208.7,-647>,
		<1199.05,208.7,-652>
  }
  triangle { // #8281
		<1199.05,208.7,-642.9>,
		<1191.5,208.7,-638.2>,
		<1199.05,208.7,-638.2>
  }
  triangle { // #8282
		<1199.05,208.7,-642.9>,
		<1191.5,208.7,-652.95>,
		<1191.5,208.7,-638.2>
  }
  triangle { // #8283
		<1199.05,208.7,-647>,
		<1191.5,208.7,-652.95>,
		<1199.05,208.7,-642.9>
  }
  triangle { // #8284
		<1195.25,208.7,-652>,
		<1191.5,208.7,-652.95>,
		<1199.05,208.7,-647>
  }
  triangle { // #8285
		<1195.25,0,-652>,
		<1191.5,0,-652.95>,
		<1193.05,0,-652.95>
  }
  triangle { // #8286
		<1200.6,0,-642.9>,
		<1199.05,0,-647>,
		<1200.6,0,-647>
  }
  triangle { // #8287
		<1199.05,0,-642.9>,
		<1199.05,0,-647>,
		<1200.6,0,-642.9>
  }
  triangle { // #8288
		<1199.05,0,-647>,
		<1195.25,0,-652>,
		<1199.05,0,-652>
  }
  triangle { // #8289
		<1191.5,0,-638.2>,
		<1199.05,0,-642.9>,
		<1199.05,0,-638.2>
  }
  triangle { // #8290
		<1191.5,0,-652.95>,
		<1199.05,0,-642.9>,
		<1191.5,0,-638.2>
  }
  triangle { // #8291
		<1191.5,0,-652.95>,
		<1199.05,0,-647>,
		<1199.05,0,-642.9>
  }
  triangle { // #8292
		<1191.5,0,-652.95>,
		<1195.25,0,-652>,
		<1199.05,0,-647>
  }
  triangle { // #8293
		<1191.5,208.7,-638.2>,
		<1199.05,0,-638.2>,
		<1199.05,208.7,-638.2>
  }
  triangle { // #8294
		<1199.05,0,-638.2>,
		<1191.5,208.7,-638.2>,
		<1191.5,0,-638.2>
  }
  triangle { // #8295
		<1199.05,208.7,-638.2>,
		<1199.05,0,-642.9>,
		<1199.05,208.7,-642.9>
  }
  triangle { // #8296
		<1199.05,0,-642.9>,
		<1199.05,208.7,-638.2>,
		<1199.05,0,-638.2>
  }
  triangle { // #8297
		<1199.05,208.7,-642.9>,
		<1200.6,0,-642.9>,
		<1200.6,208.7,-642.9>
  }
  triangle { // #8298
		<1200.6,0,-642.9>,
		<1199.05,208.7,-642.9>,
		<1199.05,0,-642.9>
  }
  triangle { // #8299
		<1200.6,208.7,-642.9>,
		<1200.6,0,-647>,
		<1200.6,208.7,-647>
  }
  triangle { // #8300
		<1200.6,0,-647>,
		<1200.6,208.7,-642.9>,
		<1200.6,0,-642.9>
  }
  triangle { // #8301
		<1200.6,208.7,-647>,
		<1199.05,0,-647>,
		<1199.05,208.7,-647>
  }
  triangle { // #8302
		<1199.05,0,-647>,
		<1200.6,208.7,-647>,
		<1200.6,0,-647>
  }
  triangle { // #8303
		<1199.05,208.7,-647>,
		<1199.05,0,-652>,
		<1199.05,208.7,-652>
  }
  triangle { // #8304
		<1199.05,0,-652>,
		<1199.05,208.7,-647>,
		<1199.05,0,-647>
  }
  smooth_triangle { // #8305
		<1199.05,208.7,-652>, <0,1,0>,
		<1195.25,0,-652>, <0.134,0.991,0>,
		<1195.25,208.7,-652>, <0.267,0.964,0>
  }
  smooth_triangle { // #8306
		<1195.25,0,-652>, <0.134,0.991,0>,
		<1199.05,208.7,-652>, <0,1,0>,
		<1199.05,0,-652>, <0,1,0>
  }
  smooth_triangle { // #8307
		<1195.25,208.7,-652>, <0.267,0.964,0>,
		<1193.05,0,-652.95>, <0.267,0.964,0>,
		<1193.05,208.7,-652.95>, <0.134,0.991,0>
  }
  smooth_triangle { // #8308
		<1193.05,0,-652.95>, <0.267,0.964,0>,
		<1195.25,208.7,-652>, <0.267,0.964,0>,
		<1195.25,0,-652>, <0.134,0.991,0>
  }
  smooth_triangle { // #8309
		<1193.05,208.7,-652.95>, <0.134,0.991,0>,
		<1191.5,0,-652.95>, <0,1,0>,
		<1191.5,208.7,-652.95>, <0,1,0>
  }
  smooth_triangle { // #8310
		<1191.5,0,-652.95>, <0,1,0>,
		<1193.05,208.7,-652.95>, <0.134,0.991,0>,
		<1193.05,0,-652.95>, <0.267,0.964,0>
  }
  triangle { // #8311
		<1191.5,208.7,-652.95>,
		<1191.5,0,-638.2>,
		<1191.5,208.7,-638.2>
  }
  triangle { // #8312
		<1191.5,0,-638.2>,
		<1191.5,208.7,-652.95>,
		<1191.5,0,-652.95>
  }
  triangle { // #8313
		<1388.7,208.85,-652.95>,
		<1388.7,205.1,-652>,
		<1388.7,207.3,-652.95>
  }
  triangle { // #8314
		<1388.7,199.75,-647>,
		<1388.7,201.3,-642.9>,
		<1388.7,199.75,-642.9>
  }
  triangle { // #8315
		<1388.7,201.3,-647>,
		<1388.7,201.3,-642.9>,
		<1388.7,199.75,-647>
  }
  triangle { // #8316
		<1388.7,205.1,-652>,
		<1388.7,201.3,-647>,
		<1388.7,201.3,-652>
  }
  triangle { // #8317
		<1388.7,201.3,-642.9>,
		<1388.7,208.85,-638.2>,
		<1388.7,201.3,-638.2>
  }
  triangle { // #8318
		<1388.7,201.3,-642.9>,
		<1388.7,208.85,-652.95>,
		<1388.7,208.85,-638.2>
  }
  triangle { // #8319
		<1388.7,201.3,-647>,
		<1388.7,208.85,-652.95>,
		<1388.7,201.3,-642.9>
  }
  triangle { // #8320
		<1388.7,205.1,-652>,
		<1388.7,208.85,-652.95>,
		<1388.7,201.3,-647>
  }
  triangle { // #8321
		<1191.35,205.1,-652>,
		<1191.35,208.85,-652.95>,
		<1191.35,207.3,-652.95>
  }
  triangle { // #8322
		<1191.35,199.75,-642.9>,
		<1191.35,201.3,-647>,
		<1191.35,199.75,-647>
  }
  triangle { // #8323
		<1191.35,201.3,-642.9>,
		<1191.35,201.3,-647>,
		<1191.35,199.75,-642.9>
  }
  triangle { // #8324
		<1191.35,201.3,-647>,
		<1191.35,205.1,-652>,
		<1191.35,201.3,-652>
  }
  triangle { // #8325
		<1191.35,208.85,-638.2>,
		<1191.35,201.3,-642.9>,
		<1191.35,201.3,-638.2>
  }
  triangle { // #8326
		<1191.35,208.85,-652.95>,
		<1191.35,201.3,-642.9>,
		<1191.35,208.85,-638.2>
  }
  triangle { // #8327
		<1191.35,208.85,-652.95>,
		<1191.35,201.3,-647>,
		<1191.35,201.3,-642.9>
  }
  triangle { // #8328
		<1191.35,208.85,-652.95>,
		<1191.35,205.1,-652>,
		<1191.35,201.3,-647>
  }
  triangle { // #8329
		<1388.7,208.85,-638.2>,
		<1191.35,201.3,-638.2>,
		<1388.7,201.3,-638.2>
  }
  triangle { // #8330
		<1191.35,201.3,-638.2>,
		<1388.7,208.85,-638.2>,
		<1191.35,208.85,-638.2>
  }
  triangle { // #8331
		<1388.7,201.3,-638.2>,
		<1191.35,201.3,-642.9>,
		<1388.7,201.3,-642.9>
  }
  triangle { // #8332
		<1191.35,201.3,-642.9>,
		<1388.7,201.3,-638.2>,
		<1191.35,201.3,-638.2>
  }
  triangle { // #8333
		<1388.7,201.3,-642.9>,
		<1191.35,199.75,-642.9>,
		<1388.7,199.75,-642.9>
  }
  triangle { // #8334
		<1191.35,199.75,-642.9>,
		<1388.7,201.3,-642.9>,
		<1191.35,201.3,-642.9>
  }
  triangle { // #8335
		<1388.7,199.75,-642.9>,
		<1191.35,199.75,-647>,
		<1388.7,199.75,-647>
  }
  triangle { // #8336
		<1191.35,199.75,-647>,
		<1388.7,199.75,-642.9>,
		<1191.35,199.75,-642.9>
  }
  triangle { // #8337
		<1388.7,199.75,-647>,
		<1191.35,201.3,-647>,
		<1388.7,201.3,-647>
  }
  triangle { // #8338
		<1191.35,201.3,-647>,
		<1388.7,199.75,-647>,
		<1191.35,199.75,-647>
  }
  triangle { // #8339
		<1388.7,201.3,-647>,
		<1191.35,201.3,-652>,
		<1388.7,201.3,-652>
  }
  triangle { // #8340
		<1191.35,201.3,-652>,
		<1388.7,201.3,-647>,
		<1191.35,201.3,-647>
  }
  smooth_triangle { // #8341
		<1388.7,201.3,-652>, <0,1,0>,
		<1191.35,205.1,-652>, <0,0.991,-0.134>,
		<1388.7,205.1,-652>, <0,0.964,-0.267>
  }
  smooth_triangle { // #8342
		<1191.35,205.1,-652>, <0,0.991,-0.134>,
		<1388.7,201.3,-652>, <0,1,0>,
		<1191.35,201.3,-652>, <0,1,0>
  }
  smooth_triangle { // #8343
		<1388.7,205.1,-652>, <0,0.964,-0.267>,
		<1191.35,207.3,-652.95>, <0,0.964,-0.267>,
		<1388.7,207.3,-652.95>, <0,0.991,-0.134>
  }
  smooth_triangle { // #8344
		<1191.35,207.3,-652.95>, <0,0.964,-0.267>,
		<1388.7,205.1,-652>, <0,0.964,-0.267>,
		<1191.35,205.1,-652>, <0,0.991,-0.134>
  }
  smooth_triangle { // #8345
		<1388.7,207.3,-652.95>, <0,0.991,-0.134>,
		<1191.35,208.85,-652.95>, <0,1,0>,
		<1388.7,208.85,-652.95>, <0,1,0>
  }
  smooth_triangle { // #8346
		<1191.35,208.85,-652.95>, <0,1,0>,
		<1388.7,207.3,-652.95>, <0,0.991,-0.134>,
		<1191.35,207.3,-652.95>, <0,0.964,-0.267>
  }
  triangle { // #8347
		<1388.7,208.85,-652.95>,
		<1191.35,208.85,-638.2>,
		<1388.7,208.85,-638.2>
  }
  triangle { // #8348
		<1191.35,208.85,-638.2>,
		<1388.7,208.85,-652.95>,
		<1191.35,208.85,-652.95>
  }
  triangle { // #8349
		<-755.15,0,-821.9>,
		<-762.65,0,-824.75>,
		<-759.2,0,-826.6>
  }
  triangle { // #8350
		<-759.2,0,-826.6>,
		<-762.65,0,-824.75>,
		<-762.65,0,-827.9>
  }
  triangle { // #8351
		<-753.55,0,-818.45>,
		<-755.15,0,-821.9>,
		<-753.55,0,-821.9>
  }
  triangle { // #8352
		<-755.15,0,-818.45>,
		<-755.15,0,-821.9>,
		<-753.55,0,-818.45>
  }
  triangle { // #8353
		<-755.15,0,-821.9>,
		<-759.2,0,-826.6>,
		<-755.15,0,-826.6>
  }
  triangle { // #8354
		<-762.35,0,-813.75>,
		<-755.15,0,-818.45>,
		<-755.15,0,-813.75>
  }
  triangle { // #8355
		<-762.65,0,-824.75>,
		<-755.15,0,-818.45>,
		<-762.35,0,-813.75>
  }
  triangle { // #8356
		<-762.65,0,-824.75>,
		<-755.15,0,-821.9>,
		<-755.15,0,-818.45>
  }
  triangle { // #8357
		<-762.65,208.7,-824.75>,
		<-755.15,208.7,-821.9>,
		<-759.2,208.7,-826.6>
  }
  triangle { // #8358
		<-762.65,208.7,-824.75>,
		<-759.2,208.7,-826.6>,
		<-762.65,208.7,-827.9>
  }
  triangle { // #8359
		<-753.55,208.7,-821.9>,
		<-755.15,208.7,-818.45>,
		<-753.55,208.7,-818.45>
  }
  triangle { // #8360
		<-755.15,208.7,-821.9>,
		<-755.15,208.7,-818.45>,
		<-753.55,208.7,-821.9>
  }
  triangle { // #8361
		<-759.2,208.7,-826.6>,
		<-755.15,208.7,-821.9>,
		<-755.15,208.7,-826.6>
  }
  triangle { // #8362
		<-755.15,208.7,-818.45>,
		<-762.35,208.7,-813.75>,
		<-755.15,208.7,-813.75>
  }
  triangle { // #8363
		<-755.15,208.7,-818.45>,
		<-762.65,208.7,-824.75>,
		<-762.35,208.7,-813.75>
  }
  triangle { // #8364
		<-755.15,208.7,-821.9>,
		<-762.65,208.7,-824.75>,
		<-755.15,208.7,-818.45>
  }
  triangle { // #8365
		<-755.15,0,-818.45>,
		<-755.15,208.7,-813.75>,
		<-755.15,0,-813.75>
  }
  triangle { // #8366
		<-755.15,208.7,-813.75>,
		<-755.15,0,-818.45>,
		<-755.15,208.7,-818.45>
  }
  triangle { // #8367
		<-755.15,0,-813.75>,
		<-762.35,208.7,-813.75>,
		<-762.35,0,-813.75>
  }
  triangle { // #8368
		<-762.35,208.7,-813.75>,
		<-755.15,0,-813.75>,
		<-755.15,208.7,-813.75>
  }
  smooth_triangle { // #8369
		<-762.35,0,-813.75>, <-1,-0.029,0>,
		<-762.65,208.7,-824.75>, <-1,-0.019,0>,
		<-762.65,0,-824.75>, <-1,-0.01,0>
  }
  triangle { // #8370
		<-762.65,208.7,-824.75>,
		<-762.35,0,-813.75>,
		<-762.35,208.7,-813.75>
  }
  triangle { // #8371
		<-762.65,0,-824.75>,
		<-762.65,208.7,-827.9>,
		<-762.65,0,-827.9>
  }
  smooth_triangle { // #8372
		<-762.65,208.7,-827.9>, <-1,0,0>,
		<-762.65,0,-824.75>, <-1,-0.01,0>,
		<-762.65,208.7,-824.75>, <-1,-0.019,0>
  }
  smooth_triangle { // #8373
		<-762.65,0,-827.9>, <0.342,0.94,0>,
		<-759.2,208.7,-826.6>, <0.231,0.973,0>,
		<-759.2,0,-826.6>, <0.115,0.993,0>
  }
  smooth_triangle { // #8374
		<-759.2,208.7,-826.6>, <0.231,0.973,0>,
		<-762.65,0,-827.9>, <0.342,0.94,0>,
		<-762.65,208.7,-827.9>, <0.176,0.968,-0.176>
  }
  smooth_triangle { // #8375
		<-759.2,0,-826.6>, <0.115,0.993,0>,
		<-755.15,208.7,-826.6>, <0,1,0>,
		<-755.15,0,-826.6>, <0,1,0>
  }
  smooth_triangle { // #8376
		<-755.15,208.7,-826.6>, <0,1,0>,
		<-759.2,0,-826.6>, <0.115,0.993,0>,
		<-759.2,208.7,-826.6>, <0.231,0.973,0>
  }
  triangle { // #8377
		<-755.15,0,-826.6>,
		<-755.15,208.7,-821.9>,
		<-755.15,0,-821.9>
  }
  triangle { // #8378
		<-755.15,208.7,-821.9>,
		<-755.15,0,-826.6>,
		<-755.15,208.7,-826.6>
  }
  triangle { // #8379
		<-755.15,0,-821.9>,
		<-753.55,208.7,-821.9>,
		<-753.55,0,-821.9>
  }
  triangle { // #8380
		<-753.55,208.7,-821.9>,
		<-755.15,0,-821.9>,
		<-755.15,208.7,-821.9>
  }
  triangle { // #8381
		<-753.55,0,-821.9>,
		<-753.55,208.7,-818.45>,
		<-753.55,0,-818.45>
  }
  triangle { // #8382
		<-753.55,208.7,-818.45>,
		<-753.55,0,-821.9>,
		<-753.55,208.7,-821.9>
  }
  triangle { // #8383
		<-753.55,0,-818.45>,
		<-755.15,208.7,-818.45>,
		<-755.15,0,-818.45>
  }
  triangle { // #8384
		<-755.15,208.7,-818.45>,
		<-753.55,0,-818.45>,
		<-753.55,208.7,-818.45>
  }
  triangle { // #8385
		<-657.4,0,-824.75>,
		<-664.9,0,-821.9>,
		<-660.85,0,-826.6>
  }
  triangle { // #8386
		<-657.4,0,-824.75>,
		<-660.85,0,-826.6>,
		<-657.4,0,-827.9>
  }
  triangle { // #8387
		<-666.5,0,-821.9>,
		<-664.9,0,-818.45>,
		<-666.5,0,-818.45>
  }
  triangle { // #8388
		<-664.9,0,-821.9>,
		<-664.9,0,-818.45>,
		<-666.5,0,-821.9>
  }
  triangle { // #8389
		<-660.85,0,-826.6>,
		<-664.9,0,-821.9>,
		<-664.9,0,-826.6>
  }
  triangle { // #8390
		<-664.9,0,-818.45>,
		<-658,0,-813.75>,
		<-664.9,0,-813.75>
  }
  triangle { // #8391
		<-664.9,0,-818.45>,
		<-657.4,0,-824.75>,
		<-658,0,-813.75>
  }
  triangle { // #8392
		<-664.9,0,-821.9>,
		<-657.4,0,-824.75>,
		<-664.9,0,-818.45>
  }
  triangle { // #8393
		<-664.9,208.7,-821.9>,
		<-657.4,208.7,-824.75>,
		<-660.85,208.7,-826.6>
  }
  triangle { // #8394
		<-660.85,208.7,-826.6>,
		<-657.4,208.7,-824.75>,
		<-657.4,208.7,-827.9>
  }
  triangle { // #8395
		<-666.5,208.7,-818.45>,
		<-664.9,208.7,-821.9>,
		<-666.5,208.7,-821.9>
  }
  triangle { // #8396
		<-664.9,208.7,-818.45>,
		<-664.9,208.7,-821.9>,
		<-666.5,208.7,-818.45>
  }
  triangle { // #8397
		<-664.9,208.7,-821.9>,
		<-660.85,208.7,-826.6>,
		<-664.9,208.7,-826.6>
  }
  triangle { // #8398
		<-658,208.7,-813.75>,
		<-664.9,208.7,-818.45>,
		<-664.9,208.7,-813.75>
  }
  triangle { // #8399
		<-657.4,208.7,-824.75>,
		<-664.9,208.7,-818.45>,
		<-658,208.7,-813.75>
  }
  triangle { // #8400
		<-657.4,208.7,-824.75>,
		<-664.9,208.7,-821.9>,
		<-664.9,208.7,-818.45>
  }
  triangle { // #8401
		<-664.9,0,-821.9>,
		<-664.9,208.7,-826.6>,
		<-664.9,0,-826.6>
  }
  triangle { // #8402
		<-664.9,208.7,-826.6>,
		<-664.9,0,-821.9>,
		<-664.9,208.7,-821.9>
  }
  smooth_triangle { // #8403
		<-664.9,0,-826.6>, <0,1,0>,
		<-660.85,208.7,-826.6>, <-0.115,0.993,0>,
		<-660.85,0,-826.6>, <-0.231,0.973,0>
  }
  smooth_triangle { // #8404
		<-660.85,208.7,-826.6>, <-0.115,0.993,0>,
		<-664.9,0,-826.6>, <0,1,0>,
		<-664.9,208.7,-826.6>, <0,1,0>
  }
  smooth_triangle { // #8405
		<-660.85,0,-826.6>, <-0.231,0.973,0>,
		<-657.4,208.7,-827.9>, <-0.176,0.968,-0.176>,
		<-657.4,0,-827.9>, <-0.342,0.94,0>
  }
  smooth_triangle { // #8406
		<-657.4,208.7,-827.9>, <-0.176,0.968,-0.176>,
		<-660.85,0,-826.6>, <-0.231,0.973,0>,
		<-660.85,208.7,-826.6>, <-0.115,0.993,0>
  }
  smooth_triangle { // #8407
		<-657.4,0,-827.9>, <1,0,0>,
		<-657.4,208.7,-824.75>, <1,-0.019,0>,
		<-657.4,0,-824.75>, <0.999,-0.038,0>
  }
  smooth_triangle { // #8408
		<-657.4,208.7,-824.75>, <1,-0.019,0>,
		<-657.4,0,-827.9>, <1,0,0>,
		<-657.4,208.7,-827.9>, <1,0,0>
  }
  smooth_triangle { // #8409
		<-657.4,0,-824.75>, <0.999,-0.038,0>,
		<-658,208.7,-813.75>, <0.998,-0.057,0>,
		<-658,0,-813.75>, <0.998,-0.057,0>
  }
  smooth_triangle { // #8410
		<-658,208.7,-813.75>, <0.998,-0.057,0>,
		<-657.4,0,-824.75>, <0.999,-0.038,0>,
		<-657.4,208.7,-824.75>, <1,-0.019,0>
  }
  triangle { // #8411
		<-658,0,-813.75>,
		<-664.9,208.7,-813.75>,
		<-664.9,0,-813.75>
  }
  triangle { // #8412
		<-664.9,208.7,-813.75>,
		<-658,0,-813.75>,
		<-658,208.7,-813.75>
  }
  triangle { // #8413
		<-664.9,0,-813.75>,
		<-664.9,208.7,-818.45>,
		<-664.9,0,-818.45>
  }
  triangle { // #8414
		<-664.9,208.7,-818.45>,
		<-664.9,0,-813.75>,
		<-664.9,208.7,-813.75>
  }
  triangle { // #8415
		<-664.9,0,-818.45>,
		<-666.5,208.7,-818.45>,
		<-666.5,0,-818.45>
  }
  triangle { // #8416
		<-666.5,208.7,-818.45>,
		<-664.9,0,-818.45>,
		<-664.9,208.7,-818.45>
  }
  triangle { // #8417
		<-666.5,0,-818.45>,
		<-666.5,208.7,-821.9>,
		<-666.5,0,-821.9>
  }
  triangle { // #8418
		<-666.5,208.7,-821.9>,
		<-666.5,0,-818.45>,
		<-666.5,208.7,-818.45>
  }
  triangle { // #8419
		<-666.5,0,-821.9>,
		<-664.9,208.7,-821.9>,
		<-664.9,0,-821.9>
  }
  triangle { // #8420
		<-664.9,208.7,-821.9>,
		<-666.5,0,-821.9>,
		<-666.5,208.7,-821.9>
  }
  triangle { // #8421
		<663.9,0,-821.85>,
		<656.35,0,-824.75>,
		<659.8,0,-826.55>
  }
  triangle { // #8422
		<659.8,0,-826.55>,
		<656.35,0,-824.75>,
		<656.35,0,-827.8>
  }
  triangle { // #8423
		<665.45,0,-818.4>,
		<663.9,0,-821.85>,
		<665.45,0,-821.85>
  }
  triangle { // #8424
		<663.9,0,-818.4>,
		<663.9,0,-821.85>,
		<665.45,0,-818.4>
  }
  triangle { // #8425
		<663.9,0,-821.85>,
		<659.8,0,-826.55>,
		<663.9,0,-826.55>
  }
  triangle { // #8426
		<657.15,0,-813.65>,
		<663.9,0,-818.4>,
		<663.9,0,-813.65>
  }
  triangle { // #8427
		<656.35,0,-824.75>,
		<663.9,0,-818.4>,
		<657.15,0,-813.65>
  }
  triangle { // #8428
		<656.35,0,-824.75>,
		<663.9,0,-821.85>,
		<663.9,0,-818.4>
  }
  triangle { // #8429
		<656.35,208.7,-824.75>,
		<663.9,208.7,-821.85>,
		<659.8,208.7,-826.55>
  }
  triangle { // #8430
		<656.35,208.7,-824.75>,
		<659.8,208.7,-826.55>,
		<656.35,208.7,-827.8>
  }
  triangle { // #8431
		<665.45,208.7,-821.85>,
		<663.9,208.7,-818.4>,
		<665.45,208.7,-818.4>
  }
  triangle { // #8432
		<663.9,208.7,-821.85>,
		<663.9,208.7,-818.4>,
		<665.45,208.7,-821.85>
  }
  triangle { // #8433
		<659.8,208.7,-826.55>,
		<663.9,208.7,-821.85>,
		<663.9,208.7,-826.55>
  }
  triangle { // #8434
		<663.9,208.7,-818.4>,
		<657.15,208.7,-813.65>,
		<663.9,208.7,-813.65>
  }
  triangle { // #8435
		<663.9,208.7,-818.4>,
		<656.35,208.7,-824.75>,
		<657.15,208.7,-813.65>
  }
  triangle { // #8436
		<663.9,208.7,-821.85>,
		<656.35,208.7,-824.75>,
		<663.9,208.7,-818.4>
  }
  smooth_triangle { // #8437
		<657.15,0,-813.65>, <-0.997,-0.071,0>,
		<656.35,208.7,-824.75>, <-0.999,-0.047,0>,
		<656.35,0,-824.75>, <-1,-0.024,0>
  }
  smooth_triangle { // #8438
		<656.35,208.7,-824.75>, <-0.999,-0.047,0>,
		<657.15,0,-813.65>, <-0.997,-0.071,0>,
		<657.15,208.7,-813.65>, <-0.997,-0.071,0>
  }
  smooth_triangle { // #8439
		<656.35,0,-824.75>, <-1,-0.024,0>,
		<656.35,208.7,-827.8>, <-1,-0,0>,
		<656.35,0,-827.8>, <-1,0,0>
  }
  smooth_triangle { // #8440
		<656.35,208.7,-827.8>, <-1,-0,0>,
		<656.35,0,-824.75>, <-1,-0.024,0>,
		<656.35,208.7,-824.75>, <-0.999,-0.047,0>
  }
  smooth_triangle { // #8441
		<656.35,0,-827.8>, <0.342,0.94,0>,
		<659.8,208.7,-826.55>, <0.231,0.973,0>,
		<659.8,0,-826.55>, <0.115,0.993,0>
  }
  smooth_triangle { // #8442
		<659.8,208.7,-826.55>, <0.231,0.973,0>,
		<656.35,0,-827.8>, <0.342,0.94,0>,
		<656.35,208.7,-827.8>, <0.117,0.965,-0.234>
  }
  smooth_triangle { // #8443
		<659.8,0,-826.55>, <0.115,0.993,0>,
		<663.9,208.7,-826.55>, <0,1,0>,
		<663.9,0,-826.55>, <0,1,0>
  }
  smooth_triangle { // #8444
		<663.9,208.7,-826.55>, <0,1,0>,
		<659.8,0,-826.55>, <0.115,0.993,0>,
		<659.8,208.7,-826.55>, <0.231,0.973,0>
  }
  triangle { // #8445
		<663.9,0,-826.55>,
		<663.9,208.7,-821.85>,
		<663.9,0,-821.85>
  }
  triangle { // #8446
		<663.9,208.7,-821.85>,
		<663.9,0,-826.55>,
		<663.9,208.7,-826.55>
  }
  triangle { // #8447
		<663.9,0,-821.85>,
		<665.45,208.7,-821.85>,
		<665.45,0,-821.85>
  }
  triangle { // #8448
		<665.45,208.7,-821.85>,
		<663.9,0,-821.85>,
		<663.9,208.7,-821.85>
  }
  triangle { // #8449
		<665.45,0,-821.85>,
		<665.45,208.7,-818.4>,
		<665.45,0,-818.4>
  }
  triangle { // #8450
		<665.45,208.7,-818.4>,
		<665.45,0,-821.85>,
		<665.45,208.7,-821.85>
  }
  triangle { // #8451
		<665.45,0,-818.4>,
		<663.9,208.7,-818.4>,
		<663.9,0,-818.4>
  }
  triangle { // #8452
		<663.9,208.7,-818.4>,
		<665.45,0,-818.4>,
		<665.45,208.7,-818.4>
  }
  triangle { // #8453
		<663.9,0,-818.4>,
		<663.9,208.7,-813.65>,
		<663.9,0,-813.65>
  }
  triangle { // #8454
		<663.9,208.7,-813.65>,
		<663.9,0,-818.4>,
		<663.9,208.7,-818.4>
  }
  triangle { // #8455
		<663.9,0,-813.65>,
		<657.15,208.7,-813.65>,
		<657.15,0,-813.65>
  }
  triangle { // #8456
		<657.15,208.7,-813.65>,
		<663.9,0,-813.65>,
		<663.9,208.7,-813.65>
  }
  triangle { // #8457
		<656.35,201.15,-821.85>,
		<656.35,205.25,-826.55>,
		<656.35,201.15,-826.55>
  }
  triangle { // #8458
		<656.35,205.25,-826.55>,
		<656.35,208.7,-813.65>,
		<656.35,208.7,-827.8>
  }
  triangle { // #8459
		<656.35,205.25,-826.55>,
		<656.35,201.15,-813.65>,
		<656.35,208.7,-813.65>
  }
  triangle { // #8460
		<656.35,205.25,-826.55>,
		<656.35,201.15,-818.4>,
		<656.35,201.15,-813.65>
  }
  triangle { // #8461
		<656.35,199.6,-818.4>,
		<656.35,201.15,-821.85>,
		<656.35,199.6,-821.85>
  }
  triangle { // #8462
		<656.35,201.15,-818.4>,
		<656.35,201.15,-821.85>,
		<656.35,199.6,-818.4>
  }
  triangle { // #8463
		<656.35,205.25,-826.55>,
		<656.35,201.15,-821.85>,
		<656.35,201.15,-818.4>
  }
  triangle { // #8464
		<761.65,205.25,-826.55>,
		<761.65,201.15,-821.85>,
		<761.65,201.15,-826.55>
  }
  triangle { // #8465
		<761.65,208.7,-813.65>,
		<761.65,205.25,-826.55>,
		<761.65,208.7,-827.8>
  }
  triangle { // #8466
		<761.65,201.15,-813.65>,
		<761.65,205.25,-826.55>,
		<761.65,208.7,-813.65>
  }
  triangle { // #8467
		<761.65,201.15,-818.4>,
		<761.65,205.25,-826.55>,
		<761.65,201.15,-813.65>
  }
  triangle { // #8468
		<761.65,199.6,-821.85>,
		<761.65,201.15,-818.4>,
		<761.65,199.6,-818.4>
  }
  triangle { // #8469
		<761.65,201.15,-821.85>,
		<761.65,201.15,-818.4>,
		<761.65,199.6,-821.85>
  }
  triangle { // #8470
		<761.65,201.15,-821.85>,
		<761.65,205.25,-826.55>,
		<761.65,201.15,-818.4>
  }
  triangle { // #8471
		<656.35,208.7,-813.65>,
		<761.65,208.7,-827.8>,
		<656.35,208.7,-827.8>
  }
  triangle { // #8472
		<761.65,208.7,-827.8>,
		<656.35,208.7,-813.65>,
		<761.65,208.7,-813.65>
  }
  smooth_triangle { // #8473
		<656.35,208.7,-827.8>, <0.117,0.965,-0.234>,
		<761.65,205.25,-826.55>, <0,0.973,-0.231>,
		<656.35,205.25,-826.55>, <0,0.993,-0.115>
  }
  smooth_triangle { // #8474
		<761.65,205.25,-826.55>, <0,0.973,-0.231>,
		<656.35,208.7,-827.8>, <0.117,0.965,-0.234>,
		<761.65,208.7,-827.8>, <-0.234,0.965,-0.117>
  }
  smooth_triangle { // #8475
		<656.35,205.25,-826.55>, <0,0.993,-0.115>,
		<761.65,201.15,-826.55>, <0,1,0>,
		<656.35,201.15,-826.55>, <0,1,0>
  }
  smooth_triangle { // #8476
		<761.65,201.15,-826.55>, <0,1,0>,
		<656.35,205.25,-826.55>, <0,0.993,-0.115>,
		<761.65,205.25,-826.55>, <0,0.973,-0.231>
  }
  triangle { // #8477
		<656.35,201.15,-826.55>,
		<761.65,201.15,-821.85>,
		<656.35,201.15,-821.85>
  }
  triangle { // #8478
		<761.65,201.15,-821.85>,
		<656.35,201.15,-826.55>,
		<761.65,201.15,-826.55>
  }
  triangle { // #8479
		<656.35,201.15,-821.85>,
		<761.65,199.6,-821.85>,
		<656.35,199.6,-821.85>
  }
  triangle { // #8480
		<761.65,199.6,-821.85>,
		<656.35,201.15,-821.85>,
		<761.65,201.15,-821.85>
  }
  triangle { // #8481
		<656.35,199.6,-821.85>,
		<761.65,199.6,-818.4>,
		<656.35,199.6,-818.4>
  }
  triangle { // #8482
		<761.65,199.6,-818.4>,
		<656.35,199.6,-821.85>,
		<761.65,199.6,-821.85>
  }
  triangle { // #8483
		<656.35,199.6,-818.4>,
		<761.65,201.15,-818.4>,
		<656.35,201.15,-818.4>
  }
  triangle { // #8484
		<761.65,201.15,-818.4>,
		<656.35,199.6,-818.4>,
		<761.65,199.6,-818.4>
  }
  triangle { // #8485
		<656.35,201.15,-818.4>,
		<761.65,201.15,-813.65>,
		<656.35,201.15,-813.65>
  }
  triangle { // #8486
		<761.65,201.15,-813.65>,
		<656.35,201.15,-818.4>,
		<761.65,201.15,-818.4>
  }
  triangle { // #8487
		<656.35,201.15,-813.65>,
		<761.65,208.7,-813.65>,
		<656.35,208.7,-813.65>
  }
  triangle { // #8488
		<761.65,208.7,-813.65>,
		<656.35,201.15,-813.65>,
		<761.65,201.15,-813.65>
  }
  triangle { // #8489
		<754.1,208.7,-821.85>,
		<761.65,208.7,-824.75>,
		<758.2,208.7,-826.55>
  }
  triangle { // #8490
		<758.2,208.7,-826.55>,
		<761.65,208.7,-824.75>,
		<761.65,208.7,-827.8>
  }
  triangle { // #8491
		<752.55,208.7,-818.4>,
		<754.1,208.7,-821.85>,
		<752.55,208.7,-821.85>
  }
  triangle { // #8492
		<754.1,208.7,-818.4>,
		<754.1,208.7,-821.85>,
		<752.55,208.7,-818.4>
  }
  triangle { // #8493
		<754.1,208.7,-821.85>,
		<758.2,208.7,-826.55>,
		<754.1,208.7,-826.55>
  }
  triangle { // #8494
		<760.85,208.7,-813.65>,
		<754.1,208.7,-818.4>,
		<754.1,208.7,-813.65>
  }
  triangle { // #8495
		<761.65,208.7,-824.75>,
		<754.1,208.7,-818.4>,
		<760.85,208.7,-813.65>
  }
  triangle { // #8496
		<761.65,208.7,-824.75>,
		<754.1,208.7,-821.85>,
		<754.1,208.7,-818.4>
  }
  triangle { // #8497
		<761.65,0,-824.75>,
		<754.1,0,-821.85>,
		<758.2,0,-826.55>
  }
  triangle { // #8498
		<761.65,0,-824.75>,
		<758.2,0,-826.55>,
		<761.65,0,-827.8>
  }
  triangle { // #8499
		<752.55,0,-821.85>,
		<754.1,0,-818.4>,
		<752.55,0,-818.4>
  }
  triangle { // #8500
		<754.1,0,-821.85>,
		<754.1,0,-818.4>,
		<752.55,0,-821.85>
  }
  triangle { // #8501
		<758.2,0,-826.55>,
		<754.1,0,-821.85>,
		<754.1,0,-826.55>
  }
  triangle { // #8502
		<754.1,0,-818.4>,
		<760.85,0,-813.65>,
		<754.1,0,-813.65>
  }
  triangle { // #8503
		<754.1,0,-818.4>,
		<761.65,0,-824.75>,
		<760.85,0,-813.65>
  }
  triangle { // #8504
		<754.1,0,-821.85>,
		<761.65,0,-824.75>,
		<754.1,0,-818.4>
  }
  smooth_triangle { // #8505
		<760.85,208.7,-813.65>, <0.997,-0.071,0>,
		<761.65,0,-824.75>, <1,-0.028,0>,
		<761.65,208.7,-824.75>, <1,-0.024,0>
  }
  smooth_triangle { // #8506
		<761.65,0,-824.75>, <1,-0.028,0>,
		<760.85,208.7,-813.65>, <0.997,-0.071,0>,
		<760.85,0,-813.65>, <0.997,-0.071,0>
  }
  smooth_triangle { // #8507
		<761.65,208.7,-824.75>, <1,-0.024,0>,
		<761.65,0,-827.8>, <1,0,0>,
		<761.65,208.7,-827.8>, <1,0,0>
  }
  smooth_triangle { // #8508
		<761.65,0,-827.8>, <1,0,0>,
		<761.65,208.7,-824.75>, <1,-0.024,0>,
		<761.65,0,-824.75>, <1,-0.028,0>
  }
  smooth_triangle { // #8509
		<761.65,208.7,-827.8>, <-0.234,0.965,-0.117>,
		<758.2,0,-826.55>, <-0.174,0.985,0>,
		<758.2,208.7,-826.55>, <-0.115,0.993,0>
  }
  smooth_triangle { // #8510
		<758.2,0,-826.55>, <-0.174,0.985,0>,
		<761.65,208.7,-827.8>, <-0.234,0.965,-0.117>,
		<761.65,0,-827.8>, <-0.342,0.94,0>
  }
  smooth_triangle { // #8511
		<758.2,208.7,-826.55>, <-0.115,0.993,0>,
		<754.1,0,-826.55>, <0,1,0>,
		<754.1,208.7,-826.55>, <0,1,0>
  }
  smooth_triangle { // #8512
		<754.1,0,-826.55>, <0,1,0>,
		<758.2,208.7,-826.55>, <-0.115,0.993,0>,
		<758.2,0,-826.55>, <-0.174,0.985,0>
  }
  triangle { // #8513
		<754.1,208.7,-826.55>,
		<754.1,0,-821.85>,
		<754.1,208.7,-821.85>
  }
  triangle { // #8514
		<754.1,0,-821.85>,
		<754.1,208.7,-826.55>,
		<754.1,0,-826.55>
  }
  triangle { // #8515
		<754.1,208.7,-821.85>,
		<752.55,0,-821.85>,
		<752.55,208.7,-821.85>
  }
  triangle { // #8516
		<752.55,0,-821.85>,
		<754.1,208.7,-821.85>,
		<754.1,0,-821.85>
  }
  triangle { // #8517
		<752.55,208.7,-821.85>,
		<752.55,0,-818.4>,
		<752.55,208.7,-818.4>
  }
  triangle { // #8518
		<752.55,0,-818.4>,
		<752.55,208.7,-821.85>,
		<752.55,0,-821.85>
  }
  triangle { // #8519
		<752.55,208.7,-818.4>,
		<754.1,0,-818.4>,
		<754.1,208.7,-818.4>
  }
  triangle { // #8520
		<754.1,0,-818.4>,
		<752.55,208.7,-818.4>,
		<752.55,0,-818.4>
  }
  triangle { // #8521
		<754.1,208.7,-818.4>,
		<754.1,0,-813.65>,
		<754.1,208.7,-813.65>
  }
  triangle { // #8522
		<754.1,0,-813.65>,
		<754.1,208.7,-818.4>,
		<754.1,0,-818.4>
  }
  triangle { // #8523
		<754.1,208.7,-813.65>,
		<760.85,0,-813.65>,
		<760.85,208.7,-813.65>
  }
  triangle { // #8524
		<760.85,0,-813.65>,
		<754.1,208.7,-813.65>,
		<754.1,0,-813.65>
  }
  triangle { // #8525
		<657.15,0,-784.5>,
		<657.15,1306,-813.65>,
		<657.15,1306,-784.5>
  }
  triangle { // #8526
		<657.15,1306,-813.65>,
		<657.15,0,-784.5>,
		<657.15,0,-813.65>
  }
  triangle { // #8527
		<-658,0,-784.5>,
		<657.15,1306,-784.5>,
		<-658,1306,-784.5>
  }
  triangle { // #8528
		<657.15,1306,-784.5>,
		<-658,0,-784.5>,
		<657.15,0,-784.5>
  }
  triangle { // #8529
		<-658,0,-813.75>,
		<-658,1306,-784.5>,
		<-658,1306,-813.75>
  }
  triangle { // #8530
		<-658,1306,-784.5>,
		<-658,0,-813.75>,
		<-658,0,-784.5>
  }
  triangle { // #8531
		<-658,0,-813.75>,
		<-657.4,1306,-813.75>,
		<-657.4,-0,-813.75>
  }
  triangle { // #8532
		<-657.4,1306,-813.75>,
		<-658,0,-813.75>,
		<-658,1306,-813.75>
  }
  triangle { // #8533
		<-657.4,1306,-813.75>,
		<-657.4,0,-824.75>,
		<-657.4,-0,-813.75>
  }
  triangle { // #8534
		<-657.4,0,-824.75>,
		<-657.4,1306,-813.75>,
		<-657.4,1306,-824.75>
  }
  triangle { // #8535
		<656.35,0,-824.75>,
		<656.35,1306,-813.65>,
		<656.35,0,-813.65>
  }
  triangle { // #8536
		<656.35,1306,-813.65>,
		<656.35,0,-824.75>,
		<656.35,1306,-824.75>
  }
  triangle { // #8537
		<657.15,1306,-813.65>,
		<656.35,0,-813.65>,
		<656.35,1306,-813.65>
  }
  triangle { // #8538
		<656.35,0,-813.65>,
		<657.15,1306,-813.65>,
		<657.15,0,-813.65>
  }
  triangle { // #8539
		<656.35,0,-824.75>,
		<-657.4,-0,-813.75>,
		<-657.4,0,-824.75>
  }
  triangle { // #8540
		<-657.4,-0,-813.75>,
		<-658,0,-784.5>,
		<-658,0,-813.75>
  }
  triangle { // #8541
		<-657.4,-0,-813.75>,
		<657.15,0,-784.5>,
		<-658,0,-784.5>
  }
  triangle { // #8542
		<657.15,0,-784.5>,
		<656.35,0,-813.65>,
		<657.15,0,-813.65>
  }
  triangle { // #8543
		<-657.4,-0,-813.75>,
		<656.35,0,-813.65>,
		<657.15,0,-784.5>
  }
  triangle { // #8544
		<-657.4,-0,-813.75>,
		<656.35,0,-824.75>,
		<656.35,0,-813.65>
  }
  triangle { // #8545
		<-657.4,0,-824.75>,
		<656.35,1306,-824.75>,
		<656.35,0,-824.75>
  }
  triangle { // #8546
		<656.35,1306,-824.75>,
		<-657.4,0,-824.75>,
		<-657.4,1306,-824.75>
  }
  triangle { // #8547
		<-657.4,1306,-813.75>,
		<656.35,1306,-824.75>,
		<-657.4,1306,-824.75>
  }
  triangle { // #8548
		<657.15,1306,-813.65>,
		<-658,1306,-784.5>,
		<657.15,1306,-784.5>
  }
  triangle { // #8549
		<656.35,1306,-813.65>,
		<-658,1306,-784.5>,
		<657.15,1306,-813.65>
  }
  triangle { // #8550
		<656.35,1306,-813.65>,
		<-658,1306,-813.75>,
		<-658,1306,-784.5>
  }
  triangle { // #8551
		<656.35,1306,-813.65>,
		<-657.4,1306,-813.75>,
		<-658,1306,-813.75>
  }
  triangle { // #8552
		<656.35,1306,-824.75>,
		<-657.4,1306,-813.75>,
		<656.35,1306,-813.65>
  }
  triangle { // #8553
		<911.4,0,-606.75>,
		<915.2,0,-611.8>,
		<915.2,0,-606.75>
  }
  triangle { // #8554
		<915.2,0,-615.85>,
		<907.65,0,-620.6>,
		<915.2,0,-620.6>
  }
  triangle { // #8555
		<915.2,0,-615.85>,
		<907.65,0,-609.6>,
		<907.65,0,-620.6>
  }
  triangle { // #8556
		<907.65,0,-609.6>,
		<909.2,0,-605.8>,
		<907.65,0,-605.8>
  }
  triangle { // #8557
		<907.65,0,-609.6>,
		<911.4,0,-606.75>,
		<909.2,0,-605.8>
  }
  triangle { // #8558
		<915.2,0,-615.85>,
		<911.4,0,-606.75>,
		<907.65,0,-609.6>
  }
  triangle { // #8559
		<915.2,0,-611.8>,
		<916.75,0,-615.85>,
		<916.75,0,-611.8>
  }
  triangle { // #8560
		<915.2,0,-611.8>,
		<915.2,0,-615.85>,
		<916.75,0,-615.85>
  }
  triangle { // #8561
		<915.2,0,-611.8>,
		<911.4,0,-606.75>,
		<915.2,0,-615.85>
  }
  triangle { // #8562
		<915.2,208.7,-611.8>,
		<911.4,208.7,-606.75>,
		<915.2,208.7,-606.75>
  }
  triangle { // #8563
		<907.65,208.7,-620.6>,
		<915.2,208.7,-615.85>,
		<915.2,208.7,-620.6>
  }
  triangle { // #8564
		<907.65,208.7,-609.6>,
		<915.2,208.7,-615.85>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8565
		<909.2,208.7,-605.8>,
		<907.65,208.7,-609.6>,
		<907.65,208.7,-605.8>
  }
  triangle { // #8566
		<911.4,208.7,-606.75>,
		<907.65,208.7,-609.6>,
		<909.2,208.7,-605.8>
  }
  triangle { // #8567
		<911.4,208.7,-606.75>,
		<915.2,208.7,-615.85>,
		<907.65,208.7,-609.6>
  }
  triangle { // #8568
		<916.75,208.7,-615.85>,
		<915.2,208.7,-611.8>,
		<916.75,208.7,-611.8>
  }
  triangle { // #8569
		<915.2,208.7,-615.85>,
		<915.2,208.7,-611.8>,
		<916.75,208.7,-615.85>
  }
  triangle { // #8570
		<911.4,208.7,-606.75>,
		<915.2,208.7,-611.8>,
		<915.2,208.7,-615.85>
  }
  triangle { // #8571
		<907.65,0,-620.6>,
		<915.2,208.7,-620.6>,
		<915.2,0,-620.6>
  }
  triangle { // #8572
		<915.2,208.7,-620.6>,
		<907.65,0,-620.6>,
		<907.65,208.7,-620.6>
  }
  triangle { // #8573
		<915.2,0,-620.6>,
		<915.2,208.7,-615.85>,
		<915.2,0,-615.85>
  }
  triangle { // #8574
		<915.2,208.7,-615.85>,
		<915.2,0,-620.6>,
		<915.2,208.7,-620.6>
  }
  triangle { // #8575
		<915.2,0,-615.85>,
		<916.75,208.7,-615.85>,
		<916.75,0,-615.85>
  }
  triangle { // #8576
		<916.75,208.7,-615.85>,
		<915.2,0,-615.85>,
		<915.2,208.7,-615.85>
  }
  triangle { // #8577
		<916.75,0,-615.85>,
		<916.75,208.7,-611.8>,
		<916.75,0,-611.8>
  }
  triangle { // #8578
		<916.75,208.7,-611.8>,
		<916.75,0,-615.85>,
		<916.75,208.7,-615.85>
  }
  triangle { // #8579
		<916.75,0,-611.8>,
		<915.2,208.7,-611.8>,
		<915.2,0,-611.8>
  }
  triangle { // #8580
		<915.2,208.7,-611.8>,
		<916.75,0,-611.8>,
		<916.75,208.7,-611.8>
  }
  triangle { // #8581
		<915.2,0,-611.8>,
		<915.2,208.7,-606.75>,
		<915.2,0,-606.75>
  }
  triangle { // #8582
		<915.2,208.7,-606.75>,
		<915.2,0,-611.8>,
		<915.2,208.7,-611.8>
  }
  smooth_triangle { // #8583
		<915.2,0,-606.75>, <0,-1,0>,
		<911.4,208.7,-606.75>, <0.134,-0.991,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>
  }
  smooth_triangle { // #8584
		<911.4,208.7,-606.75>, <0.134,-0.991,0>,
		<915.2,0,-606.75>, <0,-1,0>,
		<915.2,208.7,-606.75>, <0,-1,0>
  }
  smooth_triangle { // #8585
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<909.2,208.7,-605.8>, <0.267,-0.964,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>
  }
  smooth_triangle { // #8586
		<909.2,208.7,-605.8>, <0.267,-0.964,0>,
		<911.4,0,-606.75>, <0.223,-0.975,0>,
		<911.4,208.7,-606.75>, <0.134,-0.991,0>
  }
  smooth_triangle { // #8587
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<907.65,208.7,-605.8>, <0,-1,0>,
		<907.65,0,-605.8>, <0,-1,0>
  }
  smooth_triangle { // #8588
		<907.65,208.7,-605.8>, <0,-1,0>,
		<909.2,0,-605.8>, <0.179,-0.984,0>,
		<909.2,208.7,-605.8>, <0.267,-0.964,0>
  }
  triangle { // #8589
		<907.65,0,-605.8>,
		<907.65,208.7,-609.6>,
		<907.65,0,-609.6>
  }
  triangle { // #8590
		<907.65,208.7,-609.6>,
		<907.65,0,-605.8>,
		<907.65,208.7,-605.8>
  }
  triangle { // #8591
		<907.65,0,-609.6>,
		<907.65,208.7,-620.6>,
		<907.65,0,-620.6>
  }
  triangle { // #8592
		<907.65,208.7,-620.6>,
		<907.65,0,-609.6>,
		<907.65,208.7,-609.6>
  }
  triangle { // #8593
		<1162.55,0,-818.75>,
		<1171.35,0,-649.8>,
		<1162.55,0,-649.8>
  }
  triangle { // #8594
		<930.6,0,-824.75>,
		<884.7,0,-818.75>,
		<884.7,0,-824.75>
  }
  triangle { // #8595
		<930.6,0,-824.75>,
		<1162.55,0,-818.75>,
		<884.7,0,-818.75>
  }
  triangle { // #8596
		<1171.35,0,-824.75>,
		<1162.55,0,-818.75>,
		<930.6,0,-824.75>
  }
  triangle { // #8597
		<1171.35,0,-649.8>,
		<1162.55,0,-818.75>,
		<1171.35,0,-824.75>
  }
  triangle { // #8598
		<1171.35,574.25,-649.8>,
		<1162.55,574.25,-818.75>,
		<1162.55,574.25,-649.8>
  }
  triangle { // #8599
		<884.7,574.25,-818.75>,
		<930.6,574.25,-824.75>,
		<884.7,574.25,-824.75>
  }
  triangle { // #8600
		<1162.55,574.25,-818.75>,
		<930.6,574.25,-824.75>,
		<884.7,574.25,-818.75>
  }
  triangle { // #8601
		<1162.55,574.25,-818.75>,
		<1171.35,574.25,-824.75>,
		<930.6,574.25,-824.75>
  }
  triangle { // #8602
		<1162.55,574.25,-818.75>,
		<1171.35,574.25,-649.8>,
		<1171.35,574.25,-824.75>
  }
  triangle { // #8603
		<884.7,0,-824.75>,
		<930.6,574.25,-824.75>,
		<930.6,0,-824.75>
  }
  triangle { // #8604
		<930.6,574.25,-824.75>,
		<884.7,0,-824.75>,
		<884.7,574.25,-824.75>
  }
  triangle { // #8605
		<930.6,0,-824.75>,
		<1171.35,574.25,-824.75>,
		<1171.35,0,-824.75>
  }
  triangle { // #8606
		<1171.35,574.25,-824.75>,
		<930.6,0,-824.75>,
		<930.6,574.25,-824.75>
  }
  triangle { // #8607
		<1171.35,0,-824.75>,
		<1171.35,574.25,-649.8>,
		<1171.35,0,-649.8>
  }
  triangle { // #8608
		<1171.35,574.25,-649.8>,
		<1171.35,0,-824.75>,
		<1171.35,574.25,-824.75>
  }
  triangle { // #8609
		<1171.35,0,-649.8>,
		<1162.55,574.25,-649.8>,
		<1162.55,0,-649.8>
  }
  triangle { // #8610
		<1162.55,574.25,-649.8>,
		<1171.35,0,-649.8>,
		<1171.35,574.25,-649.8>
  }
  triangle { // #8611
		<1162.55,0,-649.8>,
		<1162.55,574.25,-818.75>,
		<1162.55,0,-818.75>
  }
  triangle { // #8612
		<1162.55,574.25,-818.75>,
		<1162.55,0,-649.8>,
		<1162.55,574.25,-649.8>
  }
  triangle { // #8613
		<1162.55,0,-818.75>,
		<884.7,574.25,-818.75>,
		<884.7,0,-818.75>
  }
  triangle { // #8614
		<884.7,574.25,-818.75>,
		<1162.55,0,-818.75>,
		<1162.55,574.25,-818.75>
  }
  triangle { // #8615
		<884.7,0,-818.75>,
		<884.7,574.25,-824.75>,
		<884.7,0,-824.75>
  }
  triangle { // #8616
		<884.7,574.25,-824.75>,
		<884.7,0,-818.75>,
		<884.7,574.25,-818.75>
  }
  triangle { // #8617
		<884.7,0,-649.8>,
		<908.9,0,-609.6>,
		<884.7,0,-609.6>
  }
  triangle { // #8618
		<908.9,0,-609.6>,
		<884.7,0,-649.8>,
		<908.9,0,-649.8>
  }
  triangle { // #8619
		<884.7,574.25,-609.6>,
		<908.9,574.25,-649.8>,
		<884.7,574.25,-649.8>
  }
  triangle { // #8620
		<908.9,574.25,-649.8>,
		<884.7,574.25,-609.6>,
		<908.9,574.25,-609.6>
  }
  triangle { // #8621
		<884.7,0,-609.6>,
		<884.7,574.25,-649.8>,
		<884.7,0,-649.8>
  }
  triangle { // #8622
		<884.7,574.25,-649.8>,
		<884.7,0,-609.6>,
		<884.7,574.25,-609.6>
  }
  triangle { // #8623
		<884.7,0,-649.8>,
		<908.9,574.25,-649.8>,
		<908.9,0,-649.8>
  }
  triangle { // #8624
		<908.9,574.25,-649.8>,
		<884.7,0,-649.8>,
		<884.7,574.25,-649.8>
  }
  triangle { // #8625
		<908.9,0,-649.8>,
		<908.9,574.25,-609.6>,
		<908.9,0,-609.6>
  }
  triangle { // #8626
		<908.9,574.25,-609.6>,
		<908.9,0,-649.8>,
		<908.9,574.25,-649.8>
  }
  triangle { // #8627
		<908.9,0,-609.6>,
		<884.7,574.25,-609.6>,
		<884.7,0,-609.6>
  }
  triangle { // #8628
		<884.7,574.25,-609.6>,
		<908.9,0,-609.6>,
		<908.9,574.25,-609.6>
  }
  triangle { // #8629
		<844.45,0,-543.1>,
		<884.7,1306,-543.1>,
		<844.45,1306,-543.1>
  }
  triangle { // #8630
		<884.7,1306,-543.1>,
		<844.45,0,-543.1>,
		<884.7,0,-543.1>
  }
  triangle { // #8631
		<844.45,0,-744.25>,
		<844.45,1306,-543.1>,
		<844.45,1306,-744.25>
  }
  triangle { // #8632
		<844.45,1306,-543.1>,
		<844.45,0,-744.25>,
		<844.45,0,-543.1>
  }
  triangle { // #8633
		<824.35,0,-744.25>,
		<844.45,1306,-744.25>,
		<824.35,1306,-744.25>
  }
  triangle { // #8634
		<844.45,1306,-744.25>,
		<824.35,0,-744.25>,
		<844.45,0,-744.25>
  }
  triangle { // #8635
		<824.35,0,-784.5>,
		<824.35,1306,-744.25>,
		<824.35,1306,-784.5>
  }
  triangle { // #8636
		<824.35,1306,-744.25>,
		<824.35,0,-784.5>,
		<824.35,0,-744.25>
  }
  triangle { // #8637
		<761.5,0,-784.5>,
		<824.35,1306,-784.5>,
		<761.5,1306,-784.5>
  }
  triangle { // #8638
		<824.35,1306,-784.5>,
		<761.5,0,-784.5>,
		<824.35,0,-784.5>
  }
  triangle { // #8639
		<761.5,0,-813.65>,
		<761.5,1306,-784.5>,
		<761.5,1306,-813.65>
  }
  triangle { // #8640
		<761.5,1306,-784.5>,
		<761.5,0,-813.65>,
		<761.5,0,-784.5>
  }
  triangle { // #8641
		<761.5,1306,-813.65>,
		<761.65,0,-813.65>,
		<761.5,0,-813.65>
  }
  triangle { // #8642
		<761.65,0,-813.65>,
		<761.5,1306,-813.65>,
		<761.65,1306,-813.65>
  }
  triangle { // #8643
		<761.65,1306,-813.65>,
		<761.65,0,-824.75>,
		<761.65,0,-813.65>
  }
  triangle { // #8644
		<761.65,0,-824.75>,
		<761.65,1306,-813.65>,
		<761.65,1306,-824.75>
  }
  triangle { // #8645
		<761.65,1306,-824.75>,
		<884.7,0,-824.75>,
		<761.65,0,-824.75>
  }
  triangle { // #8646
		<884.7,0,-824.75>,
		<761.65,1306,-824.75>,
		<884.7,1306,-824.75>
  }
  triangle { // #8647
		<844.45,1306,-744.25>,
		<884.7,1306,-824.75>,
		<824.35,1306,-784.5>
  }
  triangle { // #8648
		<761.65,1306,-813.65>,
		<884.7,1306,-824.75>,
		<761.65,1306,-824.75>
  }
  triangle { // #8649
		<761.5,1306,-784.5>,
		<761.65,1306,-813.65>,
		<761.5,1306,-813.65>
  }
  triangle { // #8650
		<824.35,1306,-784.5>,
		<761.65,1306,-813.65>,
		<761.5,1306,-784.5>
  }
  triangle { // #8651
		<824.35,1306,-784.5>,
		<884.7,1306,-824.75>,
		<761.65,1306,-813.65>
  }
  triangle { // #8652
		<844.45,1306,-744.25>,
		<824.35,1306,-784.5>,
		<824.35,1306,-744.25>
  }
  triangle { // #8653
		<884.7,1306,-543.1>,
		<844.45,1306,-744.25>,
		<844.45,1306,-543.1>
  }
  triangle { // #8654
		<884.7,1306,-824.75>,
		<844.45,1306,-744.25>,
		<884.7,1306,-543.1>
  }
  triangle { // #8655
		<884.7,0,-824.75>,
		<844.45,0,-744.25>,
		<824.35,0,-784.5>
  }
  triangle { // #8656
		<884.7,0,-824.75>,
		<761.65,0,-813.65>,
		<761.65,0,-824.75>
  }
  triangle { // #8657
		<761.65,0,-813.65>,
		<761.5,0,-784.5>,
		<761.5,0,-813.65>
  }
  triangle { // #8658
		<761.65,0,-813.65>,
		<824.35,0,-784.5>,
		<761.5,0,-784.5>
  }
  triangle { // #8659
		<884.7,0,-824.75>,
		<824.35,0,-784.5>,
		<761.65,0,-813.65>
  }
  triangle { // #8660
		<824.35,0,-784.5>,
		<844.45,0,-744.25>,
		<824.35,0,-744.25>
  }
  triangle { // #8661
		<844.45,0,-744.25>,
		<884.7,0,-543.1>,
		<844.45,0,-543.1>
  }
  triangle { // #8662
		<844.45,0,-744.25>,
		<884.7,0,-824.75>,
		<884.7,0,-543.1>
  }
  triangle { // #8663
		<884.7,0,-543.1>,
		<884.7,1306,-824.75>,
		<884.7,1306,-543.1>
  }
  triangle { // #8664
		<884.7,1306,-824.75>,
		<884.7,0,-543.1>,
		<884.7,0,-824.75>
  }
  triangle { // #8665
		<-1187.35,0,-652.5>,
		<-1207.45,0,-652.5>,
		<-1187.35,0,-804.6>
  }
  triangle { // #8666
		<-885.6,0,-804.6>,
		<-1187.35,0,-804.6>,
		<-892.5,0,-824.75>
  }
  triangle { // #8667
		<-892.5,0,-824.75>,
		<-1187.35,0,-804.6>,
		<-1207.45,0,-824.55>
  }
  triangle { // #8668
		<-1207.45,0,-824.55>,
		<-1187.35,0,-804.6>,
		<-1207.45,0,-652.5>
  }
  triangle { // #8669
		<-1187.35,331.95,-652.5>,
		<-1187.35,331.95,-804.6>,
		<-1207.45,331.95,-652.5>
  }
  triangle { // #8670
		<-885.6,331.95,-804.6>,
		<-892.5,331.95,-824.75>,
		<-1187.35,331.95,-804.6>
  }
  triangle { // #8671
		<-892.5,331.95,-824.75>,
		<-1207.45,331.95,-824.55>,
		<-1187.35,331.95,-804.6>
  }
  triangle { // #8672
		<-1207.45,331.95,-824.55>,
		<-1207.45,331.95,-652.5>,
		<-1187.35,331.95,-804.6>
  }
  triangle { // #8673
		<-892.5,0,-824.75>,
		<-892.5,331.95,-824.75>,
		<-885.6,0,-804.6>
  }
  triangle { // #8674
		<-885.6,331.95,-804.6>,
		<-885.6,0,-804.6>,
		<-892.5,331.95,-824.75>
  }
  triangle { // #8675
		<-1207.45,0,-824.55>,
		<-1207.45,331.95,-824.55>,
		<-892.5,0,-824.75>
  }
  triangle { // #8676
		<-892.5,331.95,-824.75>,
		<-892.5,0,-824.75>,
		<-1207.45,331.95,-824.55>
  }
  triangle { // #8677
		<-1207.45,0,-652.5>,
		<-1207.45,331.95,-652.5>,
		<-1207.45,0,-824.55>
  }
  triangle { // #8678
		<-1207.45,331.95,-824.55>,
		<-1207.45,0,-824.55>,
		<-1207.45,331.95,-652.5>
  }
  triangle { // #8679
		<-1187.35,0,-652.5>,
		<-1187.35,331.95,-652.5>,
		<-1207.45,0,-652.5>
  }
  triangle { // #8680
		<-1207.45,331.95,-652.5>,
		<-1207.45,0,-652.5>,
		<-1187.35,331.95,-652.5>
  }
  triangle { // #8681
		<-1187.35,0,-804.6>,
		<-1187.35,331.95,-804.6>,
		<-1187.35,0,-652.5>
  }
  triangle { // #8682
		<-1187.35,331.95,-652.5>,
		<-1187.35,0,-652.5>,
		<-1187.35,331.95,-804.6>
  }
  triangle { // #8683
		<-885.6,0,-804.6>,
		<-885.6,331.95,-804.6>,
		<-1187.35,0,-804.6>
  }
  triangle { // #8684
		<-1187.35,331.95,-804.6>,
		<-1187.35,0,-804.6>,
		<-885.6,331.95,-804.6>
  }
  triangle { // #8685
		<-885.6,0,-551.9>,
		<-915.75,0,-542.45>,
		<-915.75,0,-551.9>
  }
  triangle { // #8686
		<-915.75,0,-542.45>,
		<-885.6,0,-551.9>,
		<-885.6,0,-542.45>
  }
  triangle { // #8687
		<-885.6,251.45,-551.9>,
		<-915.75,251.45,-542.45>,
		<-885.6,251.45,-542.45>
  }
  triangle { // #8688
		<-915.75,251.45,-542.45>,
		<-885.6,251.45,-551.9>,
		<-915.75,251.45,-551.9>
  }
  triangle { // #8689
		<-885.6,0,-551.9>,
		<-885.6,251.45,-542.45>,
		<-885.6,0,-542.45>
  }
  triangle { // #8690
		<-885.6,251.45,-542.45>,
		<-885.6,0,-551.9>,
		<-885.6,251.45,-551.9>
  }
  triangle { // #8691
		<-885.6,0,-542.45>,
		<-915.75,251.45,-542.45>,
		<-915.75,0,-542.45>
  }
  triangle { // #8692
		<-915.75,251.45,-542.45>,
		<-885.6,0,-542.45>,
		<-885.6,251.45,-542.45>
  }
  triangle { // #8693
		<-915.75,0,-542.45>,
		<-915.75,251.45,-551.9>,
		<-915.75,0,-551.9>
  }
  triangle { // #8694
		<-915.75,251.45,-551.9>,
		<-915.75,0,-542.45>,
		<-915.75,251.45,-542.45>
  }
  triangle { // #8695
		<-915.75,0,-551.9>,
		<-885.6,251.45,-551.9>,
		<-885.6,0,-551.9>
  }
  triangle { // #8696
		<-885.6,251.45,-551.9>,
		<-915.75,0,-551.9>,
		<-915.75,251.45,-551.9>
  }
  triangle { // #8697
		<-1187.35,0,-551.75>,
		<-1193,0,-622.3>,
		<-1187.35,0,-622.3>
  }
  triangle { // #8698
		<-1002.5,0,-542.45>,
		<-1187.35,0,-551.75>,
		<-1002.5,0,-551.9>
  }
  triangle { // #8699
		<-1193,0,-542.45>,
		<-1187.35,0,-551.75>,
		<-1002.5,0,-542.45>
  }
  triangle { // #8700
		<-1193,0,-622.3>,
		<-1187.35,0,-551.75>,
		<-1193,0,-542.45>
  }
  triangle { // #8701
		<-1193,251.45,-622.3>,
		<-1187.35,251.45,-551.75>,
		<-1187.35,251.45,-622.3>
  }
  triangle { // #8702
		<-1187.35,251.45,-551.75>,
		<-1002.5,251.45,-542.45>,
		<-1002.5,251.45,-551.9>
  }
  triangle { // #8703
		<-1187.35,251.45,-551.75>,
		<-1193,251.45,-542.45>,
		<-1002.5,251.45,-542.45>
  }
  triangle { // #8704
		<-1187.35,251.45,-551.75>,
		<-1193,251.45,-622.3>,
		<-1193,251.45,-542.45>
  }
  triangle { // #8705
		<-1193,0,-622.3>,
		<-1187.35,251.45,-622.3>,
		<-1187.35,0,-622.3>
  }
  triangle { // #8706
		<-1187.35,251.45,-622.3>,
		<-1193,0,-622.3>,
		<-1193,251.45,-622.3>
  }
  triangle { // #8707
		<-1187.35,0,-622.3>,
		<-1187.35,251.45,-551.75>,
		<-1187.35,0,-551.75>
  }
  triangle { // #8708
		<-1187.35,251.45,-551.75>,
		<-1187.35,0,-622.3>,
		<-1187.35,251.45,-622.3>
  }
  triangle { // #8709
		<-1187.35,0,-551.75>,
		<-1002.5,251.45,-551.9>,
		<-1002.5,0,-551.9>
  }
  triangle { // #8710
		<-1002.5,251.45,-551.9>,
		<-1187.35,0,-551.75>,
		<-1187.35,251.45,-551.75>
  }
  triangle { // #8711
		<-1002.5,0,-551.9>,
		<-1002.5,251.45,-542.45>,
		<-1002.5,0,-542.45>
  }
  triangle { // #8712
		<-1002.5,251.45,-542.45>,
		<-1002.5,0,-551.9>,
		<-1002.5,251.45,-551.9>
  }
  triangle { // #8713
		<-1002.5,0,-542.45>,
		<-1193,251.45,-542.45>,
		<-1193,0,-542.45>
  }
  triangle { // #8714
		<-1193,251.45,-542.45>,
		<-1002.5,0,-542.45>,
		<-1002.5,251.45,-542.45>
  }
  triangle { // #8715
		<-1193,0,-542.45>,
		<-1193,251.45,-622.3>,
		<-1193,0,-622.3>
  }
  triangle { // #8716
		<-1193,251.45,-622.3>,
		<-1193,0,-542.45>,
		<-1193,251.45,-542.45>
  }
  triangle { // #8717
		<-1193,0,-542.45>,
		<-1455.15,0,-551.75>,
		<-1193,0,-551.55>
  }
  triangle { // #8718
		<-1455.15,0,-622.3>,
		<-1464.55,0,-542.45>,
		<-1464.55,0,-622.3>
  }
  triangle { // #8719
		<-1455.15,0,-551.75>,
		<-1464.55,0,-542.45>,
		<-1455.15,0,-622.3>
  }
  triangle { // #8720
		<-1455.15,0,-551.75>,
		<-1193,0,-542.45>,
		<-1464.55,0,-542.45>
  }
  triangle { // #8721
		<-1455.15,251.45,-551.75>,
		<-1193,251.45,-542.45>,
		<-1193,251.45,-551.55>
  }
  triangle { // #8722
		<-1464.55,251.45,-542.45>,
		<-1455.15,251.45,-622.3>,
		<-1464.55,251.45,-622.3>
  }
  triangle { // #8723
		<-1464.55,251.45,-542.45>,
		<-1455.15,251.45,-551.75>,
		<-1455.15,251.45,-622.3>
  }
  triangle { // #8724
		<-1193,251.45,-542.45>,
		<-1455.15,251.45,-551.75>,
		<-1464.55,251.45,-542.45>
  }
  triangle { // #8725
		<-1193,0,-551.55>,
		<-1193,251.45,-542.45>,
		<-1193,0,-542.45>
  }
  triangle { // #8726
		<-1193,251.45,-542.45>,
		<-1193,0,-551.55>,
		<-1193,251.45,-551.55>
  }
  triangle { // #8727
		<-1193,0,-542.45>,
		<-1464.55,251.45,-542.45>,
		<-1464.55,0,-542.45>
  }
  triangle { // #8728
		<-1464.55,251.45,-542.45>,
		<-1193,0,-542.45>,
		<-1193,251.45,-542.45>
  }
  triangle { // #8729
		<-1464.55,0,-542.45>,
		<-1464.55,251.45,-622.3>,
		<-1464.55,0,-622.3>
  }
  triangle { // #8730
		<-1464.55,251.45,-622.3>,
		<-1464.55,0,-542.45>,
		<-1464.55,251.45,-542.45>
  }
  triangle { // #8731
		<-1464.55,0,-622.3>,
		<-1455.15,251.45,-622.3>,
		<-1455.15,0,-622.3>
  }
  triangle { // #8732
		<-1455.15,251.45,-622.3>,
		<-1464.55,0,-622.3>,
		<-1464.55,251.45,-622.3>
  }
  triangle { // #8733
		<-1455.15,0,-622.3>,
		<-1455.15,251.45,-551.75>,
		<-1455.15,0,-551.75>
  }
  triangle { // #8734
		<-1455.15,251.45,-551.75>,
		<-1455.15,0,-622.3>,
		<-1455.15,251.45,-622.3>
  }
  triangle { // #8735
		<-1455.15,0,-551.75>,
		<-1193,251.45,-551.55>,
		<-1193,0,-551.55>
  }
  triangle { // #8736
		<-1193,251.45,-551.55>,
		<-1455.15,0,-551.75>,
		<-1455.15,251.45,-551.75>
  }
  triangle { // #8737
		<-1464.55,251.45,-622.3>,
		<-885.6,251.45,-542.45>,
		<-1464.55,251.45,-542.45>
  }
  triangle { // #8738
		<-885.6,251.45,-542.45>,
		<-1464.55,251.45,-622.3>,
		<-885.6,251.45,-622.3>
  }
  triangle { // #8739
		<-1464.55,252.7,-542.45>,
		<-885.6,252.7,-622.3>,
		<-1464.55,252.7,-622.3>
  }
  triangle { // #8740
		<-885.6,252.7,-622.3>,
		<-1464.55,252.7,-542.45>,
		<-885.6,252.7,-542.45>
  }
  triangle { // #8741
		<-1464.55,251.45,-542.45>,
		<-1464.55,252.7,-622.3>,
		<-1464.55,251.45,-622.3>
  }
  triangle { // #8742
		<-1464.55,252.7,-622.3>,
		<-1464.55,251.45,-542.45>,
		<-1464.55,252.7,-542.45>
  }
  triangle { // #8743
		<-1464.55,251.45,-622.3>,
		<-885.6,252.7,-622.3>,
		<-885.6,251.45,-622.3>
  }
  triangle { // #8744
		<-885.6,252.7,-622.3>,
		<-1464.55,251.45,-622.3>,
		<-1464.55,252.7,-622.3>
  }
  triangle { // #8745
		<-885.6,251.45,-622.3>,
		<-885.6,252.7,-542.45>,
		<-885.6,251.45,-542.45>
  }
  triangle { // #8746
		<-885.6,252.7,-542.45>,
		<-885.6,251.45,-622.3>,
		<-885.6,252.7,-622.3>
  }
  triangle { // #8747
		<-885.6,251.45,-542.45>,
		<-1464.55,252.7,-542.45>,
		<-1464.55,251.45,-542.45>
  }
  triangle { // #8748
		<-1464.55,252.7,-542.45>,
		<-885.6,251.45,-542.45>,
		<-885.6,252.7,-542.45>
  }
  triangle { // #8749
		<-1002.5,203.7,-551.9>,
		<-915.75,203.7,-542.45>,
		<-1002.5,203.7,-542.45>
  }
  triangle { // #8750
		<-915.75,203.7,-542.45>,
		<-1002.5,203.7,-551.9>,
		<-915.75,203.7,-551.9>
  }
  triangle { // #8751
		<-1002.5,251.45,-542.45>,
		<-915.75,251.45,-551.9>,
		<-1002.5,251.45,-551.9>
  }
  triangle { // #8752
		<-915.75,251.45,-551.9>,
		<-1002.5,251.45,-542.45>,
		<-915.75,251.45,-542.45>
  }
  smooth_triangle { // #8753
		<-1002.5,203.7,-542.45>, <-0.996,0.087,0>,
		<-1002.5,251.45,-551.9>, <-1,0,0>,
		<-1002.5,203.7,-551.9>, <-1,0,0>
  }
  smooth_triangle { // #8754
		<-1002.5,251.45,-551.9>, <-1,0,0>,
		<-1002.5,203.7,-542.45>, <-0.996,0.087,0>,
		<-1002.5,251.45,-542.45>, <-1,0,0>
  }
  triangle { // #8755
		<-1002.5,203.7,-551.9>,
		<-915.75,251.45,-551.9>,
		<-915.75,203.7,-551.9>
  }
  triangle { // #8756
		<-915.75,251.45,-551.9>,
		<-1002.5,203.7,-551.9>,
		<-1002.5,251.45,-551.9>
  }
  triangle { // #8757
		<-915.75,203.7,-551.9>,
		<-915.75,251.45,-542.45>,
		<-915.75,203.7,-542.45>
  }
  triangle { // #8758
		<-915.75,251.45,-542.45>,
		<-915.75,203.7,-551.9>,
		<-915.75,251.45,-551.9>
  }
  triangle { // #8759
		<-915.75,203.7,-542.45>,
		<-1002.5,251.45,-542.45>,
		<-1002.5,203.7,-542.45>
  }
  triangle { // #8760
		<-1002.5,251.45,-542.45>,
		<-915.75,203.7,-542.45>,
		<-915.75,251.45,-542.45>
  }
  triangle { // #8761
		<-885.6,0,-622.3>,
		<-885.6,0,-824.55>,
		<-1207.45,0,-622.3>
  }
  triangle { // #8762
		<-1207.45,0,-824.55>,
		<-1207.45,0,-622.3>,
		<-885.6,0,-824.55>
  }
  triangle { // #8763
		<-1207.45,-30.2,-824.55>,
		<-885.6,-30.2,-824.55>,
		<-1207.45,-30.2,-622.3>
  }
  triangle { // #8764
		<-885.6,-30.2,-622.3>,
		<-1207.45,-30.2,-622.3>,
		<-885.6,-30.2,-824.55>
  }
  triangle { // #8765
		<-1207.45,0,-824.55>,
		<-1207.45,-30.2,-824.55>,
		<-1207.45,0,-622.3>
  }
  triangle { // #8766
		<-1207.45,-30.2,-622.3>,
		<-1207.45,0,-622.3>,
		<-1207.45,-30.2,-824.55>
  }
  triangle { // #8767
		<-885.6,0,-824.55>,
		<-885.6,-30.2,-824.55>,
		<-1207.45,0,-824.55>
  }
  triangle { // #8768
		<-1207.45,-30.2,-824.55>,
		<-1207.45,0,-824.55>,
		<-885.6,-30.2,-824.55>
  }
  triangle { // #8769
		<-885.6,0,-622.3>,
		<-885.6,-30.2,-622.3>,
		<-885.6,0,-824.55>
  }
  triangle { // #8770
		<-885.6,-30.2,-824.55>,
		<-885.6,0,-824.55>,
		<-885.6,-30.2,-622.3>
  }
  triangle { // #8771
		<-1207.45,0,-622.3>,
		<-1207.45,-30.2,-622.3>,
		<-885.6,0,-622.3>
  }
  triangle { // #8772
		<-885.6,-30.2,-622.3>,
		<-885.6,0,-622.3>,
		<-1207.45,-30.2,-622.3>
  }
  triangle { // #8773
		<884.7,0,-649.8>,
		<1171.35,0,-649.8>,
		<884.7,0,-824.75>
  }
  triangle { // #8774
		<1171.35,0,-824.75>,
		<884.7,0,-824.75>,
		<1171.35,0,-649.8>
  }
  triangle { // #8775
		<884.7,-30.2,-824.75>,
		<1171.35,-30.2,-824.75>,
		<884.7,-30.2,-649.8>
  }
  triangle { // #8776
		<1171.35,-30.2,-649.8>,
		<884.7,-30.2,-649.8>,
		<1171.35,-30.2,-824.75>
  }
  triangle { // #8777
		<884.7,0,-824.75>,
		<884.7,-30.2,-824.75>,
		<884.7,0,-649.8>
  }
  triangle { // #8778
		<884.7,-30.2,-649.8>,
		<884.7,0,-649.8>,
		<884.7,-30.2,-824.75>
  }
  triangle { // #8779
		<1171.35,0,-824.75>,
		<1171.35,-30.2,-824.75>,
		<884.7,0,-824.75>
  }
  triangle { // #8780
		<884.7,-30.2,-824.75>,
		<884.7,0,-824.75>,
		<1171.35,-30.2,-824.75>
  }
  triangle { // #8781
		<1171.35,0,-649.8>,
		<1171.35,-30.2,-649.8>,
		<1171.35,0,-824.75>
  }
  triangle { // #8782
		<1171.35,-30.2,-824.75>,
		<1171.35,0,-824.75>,
		<1171.35,-30.2,-649.8>
  }
  triangle { // #8783
		<884.7,0,-649.8>,
		<884.7,-30.2,-649.8>,
		<1171.35,0,-649.8>
  }
  triangle { // #8784
		<1171.35,-30.2,-649.8>,
		<1171.35,0,-649.8>,
		<884.7,-30.2,-649.8>
  }
  triangle { // #8785
		<1032.65,-82.5,254.35>,
		<1031.4,-82.5,253.05>,
		<1036.4,-82.5,254.35>
  }
  triangle { // #8786
		<1039.55,-82.5,257.45>,
		<1036.4,-82.5,254.35>,
		<1043.95,-82.5,232.45>
  }
  triangle { // #8787
		<1043.95,-82.5,228.7>,
		<1043.95,-82.5,232.45>,
		<1041.45,-82.5,228.7>
  }
  triangle { // #8788
		<1030.15,-82.5,236.2>,
		<1031.4,-82.5,236.2>,
		<1030.15,-82.5,245.55>
  }
  triangle { // #8789
		<1030.15,-82.5,245.55>,
		<1031.4,-82.5,236.2>,
		<1031.4,-82.5,245.55>
  }
  triangle { // #8790
		<1041.45,-82.5,228.7>,
		<1043.95,-82.5,232.45>,
		<1037.65,-82.5,230.55>
  }
  triangle { // #8791
		<1043.95,-82.5,232.45>,
		<1036.4,-82.5,254.35>,
		<1037.65,-82.5,230.55>
  }
  triangle { // #8792
		<1037.65,-82.5,230.55>,
		<1036.4,-82.5,254.35>,
		<1032.65,-82.5,230.55>
  }
  triangle { // #8793
		<1032.65,-82.5,230.55>,
		<1036.4,-82.5,254.35>,
		<1031.4,-82.5,231.8>
  }
  triangle { // #8794
		<1031.4,-82.5,231.8>,
		<1036.4,-82.5,254.35>,
		<1031.4,-82.5,236.2>
  }
  triangle { // #8795
		<1031.4,-82.5,236.2>,
		<1036.4,-82.5,254.35>,
		<1031.4,-82.5,245.55>
  }
  triangle { // #8796
		<1031.4,-82.5,245.55>,
		<1036.4,-82.5,254.35>,
		<1031.4,-82.5,253.05>
  }
  triangle { // #8797
		<1032.65,143.8,254.35>,
		<1036.4,143.8,254.35>,
		<1031.4,143.8,253.05>
  }
  smooth_triangle { // #8798
		<1039.55,143.8,257.45>, <0,0,1>,
		<1043.95,143.8,232.45>, <0,-0.035,0.999>,
		<1036.4,143.8,254.35>, <0,0,1>
  }
  smooth_triangle { // #8799
		<1043.95,143.8,228.7>, <0,0,1>,
		<1041.45,143.8,228.7>, <0,0,1>,
		<1043.95,143.8,232.45>, <0,-0.025,1>
  }
  triangle { // #8800
		<1030.15,143.8,245.55>,
		<1031.4,143.8,245.55>,
		<1030.15,143.8,236.2>
  }
  triangle { // #8801
		<1030.15,143.8,236.2>,
		<1031.4,143.8,245.55>,
		<1031.4,143.8,236.2>
  }
  smooth_triangle { // #8802
		<1041.45,143.8,228.7>, <0,0,1>,
		<1037.65,143.8,230.55>, <0,0,1>,
		<1043.95,143.8,232.45>, <0,-0.025,1>
  }
  smooth_triangle { // #8803
		<1043.95,143.8,232.45>, <0,-0.035,0.999>,
		<1037.65,143.8,230.55>, <0,0,1>,
		<1036.4,143.8,254.35>, <0,0,1>
  }
  triangle { // #8804
		<1037.65,143.8,230.55>,
		<1032.65,143.8,230.55>,
		<1036.4,143.8,254.35>
  }
  triangle { // #8805
		<1032.65,143.8,230.55>,
		<1031.4,143.8,231.8>,
		<1036.4,143.8,254.35>
  }
  triangle { // #8806
		<1031.4,143.8,231.8>,
		<1031.4,143.8,236.2>,
		<1036.4,143.8,254.35>
  }
  triangle { // #8807
		<1031.4,143.8,236.2>,
		<1031.4,143.8,245.55>,
		<1036.4,143.8,254.35>
  }
  triangle { // #8808
		<1031.4,143.8,245.55>,
		<1031.4,143.8,253.05>,
		<1036.4,143.8,254.35>
  }
  smooth_triangle { // #8809
		<1043.95,-82.5,232.45>, <0.998,-0.058,0>,
		<1043.95,143.8,232.45>, <0.993,-0.116,0>,
		<1039.55,-82.5,257.45>, <0.985,-0.173,0>
  }
  smooth_triangle { // #8810
		<1039.55,143.8,257.45>, <0.985,-0.173,0>,
		<1039.55,-82.5,257.45>, <0.985,-0.173,0>,
		<1043.95,143.8,232.45>, <0.993,-0.116,0>
  }
  smooth_triangle { // #8811
		<1043.95,-82.5,228.7>, <1,0,0>,
		<1043.95,143.8,228.7>, <1,0,0>,
		<1043.95,-82.5,232.45>, <0.998,-0.058,0>
  }
  smooth_triangle { // #8812
		<1043.95,143.8,232.45>, <0.993,-0.116,0>,
		<1043.95,-82.5,232.45>, <0.998,-0.058,0>,
		<1043.95,143.8,228.7>, <1,0,0>
  }
  smooth_triangle { // #8813
		<1041.45,-82.5,228.7>, <-0.305,0.952,0>,
		<1041.45,143.8,228.7>, <-0.153,0.988,0>,
		<1043.95,-82.5,228.7>, <0,1,0>
  }
  smooth_triangle { // #8814
		<1043.95,143.8,228.7>, <0,1,0>,
		<1043.95,-82.5,228.7>, <0,1,0>,
		<1041.45,143.8,228.7>, <-0.153,0.988,0>
  }
  smooth_triangle { // #8815
		<1037.65,-82.5,230.55>, <-0.153,0.988,0>,
		<1037.65,143.8,230.55>, <-0.305,0.952,0>,
		<1041.45,-82.5,228.7>, <-0.305,0.952,0>
  }
  smooth_triangle { // #8816
		<1041.45,143.8,228.7>, <-0.153,0.988,0>,
		<1041.45,-82.5,228.7>, <-0.305,0.952,0>,
		<1037.65,143.8,230.55>, <-0.305,0.952,0>
  }
  smooth_triangle { // #8817
		<1032.65,-82.5,230.55>, <-0.505,0.863,0>,
		<1032.65,143.8,230.55>, <-0.253,0.968,0>,
		<1037.65,-82.5,230.55>, <-0.153,0.988,0>
  }
  smooth_triangle { // #8818
		<1037.65,143.8,230.55>, <-0.305,0.952,0>,
		<1037.65,-82.5,230.55>, <-0.153,0.988,0>,
		<1032.65,143.8,230.55>, <-0.253,0.968,0>
  }
  smooth_triangle { // #8819
		<1031.4,-82.5,231.8>, <-0.707,0.707,0>,
		<1031.4,143.8,231.8>, <-0.707,0.707,0>,
		<1032.65,-82.5,230.55>, <-0.505,0.863,0>
  }
  smooth_triangle { // #8820
		<1032.65,143.8,230.55>, <-0.253,0.968,0>,
		<1032.65,-82.5,230.55>, <-0.505,0.863,0>,
		<1031.4,143.8,231.8>, <-0.707,0.707,0>
  }
  triangle { // #8821
		<1031.4,-82.5,236.2>,
		<1031.4,143.8,236.2>,
		<1031.4,-82.5,231.8>
  }
  triangle { // #8822
		<1031.4,143.8,231.8>,
		<1031.4,-82.5,231.8>,
		<1031.4,143.8,236.2>
  }
  triangle { // #8823
		<1030.15,-82.5,236.2>,
		<1030.15,143.8,236.2>,
		<1031.4,-82.5,236.2>
  }
  triangle { // #8824
		<1031.4,143.8,236.2>,
		<1031.4,-82.5,236.2>,
		<1030.15,143.8,236.2>
  }
  triangle { // #8825
		<1030.15,-82.5,245.55>,
		<1030.15,143.8,245.55>,
		<1030.15,-82.5,236.2>
  }
  triangle { // #8826
		<1030.15,143.8,236.2>,
		<1030.15,-82.5,236.2>,
		<1030.15,143.8,245.55>
  }
  triangle { // #8827
		<1031.4,-82.5,245.55>,
		<1031.4,143.8,245.55>,
		<1030.15,-82.5,245.55>
  }
  triangle { // #8828
		<1030.15,143.8,245.55>,
		<1030.15,-82.5,245.55>,
		<1031.4,143.8,245.55>
  }
  triangle { // #8829
		<1031.4,-82.5,253.05>,
		<1031.4,143.8,253.05>,
		<1031.4,-82.5,245.55>
  }
  triangle { // #8830
		<1031.4,143.8,245.55>,
		<1031.4,-82.5,245.55>,
		<1031.4,143.8,253.05>
  }
  smooth_triangle { // #8831
		<1032.65,-82.5,254.35>, <-0.253,-0.968,0>,
		<1032.65,143.8,254.35>, <-0.505,-0.863,0>,
		<1031.4,-82.5,253.05>, <-0.707,-0.707,0>
  }
  smooth_triangle { // #8832
		<1031.4,143.8,253.05>, <-0.707,-0.707,0>,
		<1031.4,-82.5,253.05>, <-0.707,-0.707,0>,
		<1032.65,143.8,254.35>, <-0.505,-0.863,0>
  }
  smooth_triangle { // #8833
		<1036.4,-82.5,254.35>, <0,-1,0>,
		<1036.4,143.8,254.35>, <0,-1,0>,
		<1032.65,-82.5,254.35>, <-0.253,-0.968,0>
  }
  smooth_triangle { // #8834
		<1032.65,143.8,254.35>, <-0.505,-0.863,0>,
		<1032.65,-82.5,254.35>, <-0.253,-0.968,0>,
		<1036.4,143.8,254.35>, <0,-1,0>
  }
  triangle { // #8835
		<1039.55,-82.5,257.45>,
		<1039.55,143.8,257.45>,
		<1036.4,-82.5,254.35>
  }
  triangle { // #8836
		<1036.4,143.8,254.35>,
		<1036.4,-82.5,254.35>,
		<1039.55,143.8,257.45>
  }
  triangle { // #8837
		<954.7,143.8,254.35>,
		<955.95,143.8,253.05>,
		<950.9,143.8,254.35>
  }
  smooth_triangle { // #8838
		<947.75,143.8,257.45>, <0,0,1>,
		<950.9,143.8,254.35>, <0,0,1>,
		<943.35,143.8,232.45>, <-0,-0.07,0.998>
  }
  smooth_triangle { // #8839
		<943.35,143.8,228.7>, <0,0,1>,
		<943.35,143.8,232.45>, <-0,-0.05,0.999>,
		<945.9,143.8,228.7>, <0,0,1>
  }
  triangle { // #8840
		<957.2,143.8,236.2>,
		<955.95,143.8,236.2>,
		<957.2,143.8,245.55>
  }
  triangle { // #8841
		<957.2,143.8,245.55>,
		<955.95,143.8,236.2>,
		<955.95,143.8,245.55>
  }
  smooth_triangle { // #8842
		<945.9,143.8,228.7>, <0,0,1>,
		<943.35,143.8,232.45>, <-0,-0.05,0.999>,
		<949.65,143.8,230.55>, <-0,0,1>
  }
  smooth_triangle { // #8843
		<943.35,143.8,232.45>, <-0,-0.07,0.998>,
		<950.9,143.8,254.35>, <0,0,1>,
		<949.65,143.8,230.55>, <-0,0,1>
  }
  triangle { // #8844
		<949.65,143.8,230.55>,
		<950.9,143.8,254.35>,
		<954.7,143.8,230.55>
  }
  triangle { // #8845
		<954.7,143.8,230.55>,
		<950.9,143.8,254.35>,
		<955.95,143.8,231.8>
  }
  triangle { // #8846
		<955.95,143.8,231.8>,
		<950.9,143.8,254.35>,
		<955.95,143.8,236.2>
  }
  triangle { // #8847
		<955.95,143.8,236.2>,
		<950.9,143.8,254.35>,
		<955.95,143.8,245.55>
  }
  triangle { // #8848
		<955.95,143.8,245.55>,
		<950.9,143.8,254.35>,
		<955.95,143.8,253.05>
  }
  triangle { // #8849
		<954.7,-82.5,254.35>,
		<950.9,-82.5,254.35>,
		<955.95,-82.5,253.05>
  }
  triangle { // #8850
		<947.75,-82.5,257.45>,
		<943.35,-82.5,232.45>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8851
		<943.35,-82.5,228.7>,
		<945.9,-82.5,228.7>,
		<943.35,-82.5,232.45>
  }
  triangle { // #8852
		<957.2,-82.5,245.55>,
		<955.95,-82.5,245.55>,
		<957.2,-82.5,236.2>
  }
  triangle { // #8853
		<957.2,-82.5,236.2>,
		<955.95,-82.5,245.55>,
		<955.95,-82.5,236.2>
  }
  triangle { // #8854
		<945.9,-82.5,228.7>,
		<949.65,-82.5,230.55>,
		<943.35,-82.5,232.45>
  }
  triangle { // #8855
		<943.35,-82.5,232.45>,
		<949.65,-82.5,230.55>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8856
		<949.65,-82.5,230.55>,
		<954.7,-82.5,230.55>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8857
		<954.7,-82.5,230.55>,
		<955.95,-82.5,231.8>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8858
		<955.95,-82.5,231.8>,
		<955.95,-82.5,236.2>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8859
		<955.95,-82.5,236.2>,
		<955.95,-82.5,245.55>,
		<950.9,-82.5,254.35>
  }
  triangle { // #8860
		<955.95,-82.5,245.55>,
		<955.95,-82.5,253.05>,
		<950.9,-82.5,254.35>
  }
  smooth_triangle { // #8861
		<943.35,143.8,232.45>, <-0.998,-0.058,0>,
		<943.35,-82.5,232.45>, <-0.993,-0.116,0>,
		<947.75,143.8,257.45>, <-0.985,-0.173,0>
  }
  smooth_triangle { // #8862
		<947.75,-82.5,257.45>, <-0.985,-0.173,0>,
		<947.75,143.8,257.45>, <-0.985,-0.173,0>,
		<943.35,-82.5,232.45>, <-0.993,-0.116,0>
  }
  smooth_triangle { // #8863
		<943.35,143.8,228.7>, <-1,0,0>,
		<943.35,-82.5,228.7>, <-1,0,0>,
		<943.35,143.8,232.45>, <-0.998,-0.058,0>
  }
  smooth_triangle { // #8864
		<943.35,-82.5,232.45>, <-0.993,-0.116,0>,
		<943.35,143.8,232.45>, <-0.998,-0.058,0>,
		<943.35,-82.5,228.7>, <-1,0,0>
  }
  smooth_triangle { // #8865
		<945.9,143.8,228.7>, <0.305,0.952,0>,
		<945.9,-82.5,228.7>, <0.153,0.988,0>,
		<943.35,143.8,228.7>, <0,1,0>
  }
  smooth_triangle { // #8866
		<943.35,-82.5,228.7>, <0,1,0>,
		<943.35,143.8,228.7>, <0,1,0>,
		<945.9,-82.5,228.7>, <0.153,0.988,0>
  }
  smooth_triangle { // #8867
		<949.65,143.8,230.55>, <0.153,0.988,0>,
		<949.65,-82.5,230.55>, <0.305,0.952,0>,
		<945.9,143.8,228.7>, <0.305,0.952,0>
  }
  smooth_triangle { // #8868
		<945.9,-82.5,228.7>, <0.153,0.988,0>,
		<945.9,143.8,228.7>, <0.305,0.952,0>,
		<949.65,-82.5,230.55>, <0.305,0.952,0>
  }
  smooth_triangle { // #8869
		<954.7,143.8,230.55>, <0.383,0.924,0>,
		<954.7,-82.5,230.55>, <0,1,0>,
		<949.65,143.8,230.55>, <0.153,0.988,0>
  }
  smooth_triangle { // #8870
		<949.65,-82.5,230.55>, <0.305,0.952,0>,
		<949.65,143.8,230.55>, <0.153,0.988,0>,
		<954.7,-82.5,230.55>, <0,1,0>
  }
  smooth_triangle { // #8871
		<955.95,143.8,231.8>, <0.707,0.707,0>,
		<955.95,-82.5,231.8>, <0.707,0.707,0>,
		<954.7,143.8,230.55>, <0.505,0.863,0>
  }
  smooth_triangle { // #8872
		<954.7,-82.5,230.55>, <0.707,0.707,0>,
		<954.7,143.8,230.55>, <0.707,0.707,0>,
		<955.95,-82.5,231.8>, <0.863,0.505,0>
  }
  triangle { // #8873
		<955.95,143.8,236.2>,
		<955.95,-82.5,236.2>,
		<955.95,143.8,231.8>
  }
  smooth_triangle { // #8874
		<955.95,-82.5,231.8>, <0.924,0.383,0>,
		<955.95,143.8,231.8>, <1,0,0>,
		<955.95,-82.5,236.2>, <1,0,0>
  }
  triangle { // #8875
		<957.2,143.8,236.2>,
		<957.2,-82.5,236.2>,
		<955.95,143.8,236.2>
  }
  triangle { // #8876
		<955.95,-82.5,236.2>,
		<955.95,143.8,236.2>,
		<957.2,-82.5,236.2>
  }
  triangle { // #8877
		<957.2,143.8,245.55>,
		<957.2,-82.5,245.55>,
		<957.2,143.8,236.2>
  }
  triangle { // #8878
		<957.2,-82.5,236.2>,
		<957.2,143.8,236.2>,
		<957.2,-82.5,245.55>
  }
  triangle { // #8879
		<955.95,143.8,245.55>,
		<955.95,-82.5,245.55>,
		<957.2,143.8,245.55>
  }
  triangle { // #8880
		<957.2,-82.5,245.55>,
		<957.2,143.8,245.55>,
		<955.95,-82.5,245.55>
  }
  smooth_triangle { // #8881
		<955.95,143.8,253.05>, <0.924,-0.383,0>,
		<955.95,-82.5,253.05>, <1,0,0>,
		<955.95,143.8,245.55>, <1,0,0>
  }
  triangle { // #8882
		<955.95,-82.5,245.55>,
		<955.95,143.8,245.55>,
		<955.95,-82.5,253.05>
  }
  smooth_triangle { // #8883
		<954.7,143.8,254.35>, <0.707,-0.707,0>,
		<954.7,-82.5,254.35>, <0.707,-0.707,0>,
		<955.95,143.8,253.05>, <0.863,-0.505,0>
  }
  smooth_triangle { // #8884
		<955.95,-82.5,253.05>, <0.707,-0.707,0>,
		<955.95,143.8,253.05>, <0.707,-0.707,0>,
		<954.7,-82.5,254.35>, <0.505,-0.863,0>
  }
  triangle { // #8885
		<950.9,143.8,254.35>,
		<950.9,-82.5,254.35>,
		<954.7,143.8,254.35>
  }
  smooth_triangle { // #8886
		<954.7,-82.5,254.35>, <0.383,-0.924,0>,
		<954.7,143.8,254.35>, <0,-1,0>,
		<950.9,-82.5,254.35>, <0,-1,0>
  }
  triangle { // #8887
		<947.75,143.8,257.45>,
		<947.75,-82.5,257.45>,
		<950.9,143.8,254.35>
  }
  triangle { // #8888
		<950.9,-82.5,254.35>,
		<950.9,143.8,254.35>,
		<947.75,-82.5,257.45>
  }
  triangle { // #8889
		<1134.95,-99,262.45>,
		<1134.95,574.25,28.3>,
		<1134.95,574.25,262.45>
  }
  triangle { // #8890
		<1134.95,574.25,28.3>,
		<1134.95,-99,262.45>,
		<1134.95,-99,28.3>
  }
  triangle { // #8891
		<1039.55,-99,262.45>,
		<1134.95,574.25,262.45>,
		<1039.55,574.25,262.45>
  }
  triangle { // #8892
		<1134.95,574.25,262.45>,
		<1039.55,-99,262.45>,
		<1134.95,-99,262.45>
  }
  smooth_triangle { // #8893
		<1039.55,-99,257.45>, <-0.998,0.058,0>,
		<1039.55,574.25,262.45>, <-1,-0,0>,
		<1039.55,574.25,257.45>, <-0.993,0.116,0>
  }
  smooth_triangle { // #8894
		<1039.55,574.25,262.45>, <-1,-0,0>,
		<1039.55,-99,257.45>, <-0.998,0.058,0>,
		<1039.55,-99,262.45>, <-1,0,0>
  }
  triangle { // #8895
		<1043.95,-99,232.45>,
		<1104.8,574.25,232.45>,
		<1104.8,-99,232.45>
  }
  triangle { // #8896
		<1104.8,574.25,232.45>,
		<1043.95,-99,232.45>,
		<1043.95,574.25,232.45>
  }
  triangle { // #8897
		<1104.8,-99,28.3>,
		<1104.8,574.25,232.45>,
		<1104.8,574.25,28.3>
  }
  triangle { // #8898
		<1104.8,574.25,232.45>,
		<1104.8,-99,28.3>,
		<1104.8,-99,232.45>
  }
  triangle { // #8899
		<1009.8,-99,28.3>,
		<1104.8,574.25,28.3>,
		<1009.8,574.25,28.3>
  }
  triangle { // #8900
		<1104.8,574.25,28.3>,
		<1009.8,-99,28.3>,
		<1104.8,-99,28.3>
  }
  triangle { // #8901
		<1009.8,-99,9.4>,
		<1009.8,574.25,28.3>,
		<1009.8,574.25,9.4>
  }
  triangle { // #8902
		<1009.8,574.25,28.3>,
		<1009.8,-99,9.4>,
		<1009.8,-99,28.3>
  }
  triangle { // #8903
		<1002.55,-99,9.4>,
		<1009.8,574.25,9.4>,
		<1002.55,574.25,9.4>
  }
  triangle { // #8904
		<1009.8,574.25,9.4>,
		<1002.55,-99,9.4>,
		<1009.8,-99,9.4>
  }
  triangle { // #8905
		<1002.55,-99,4.35>,
		<1002.55,574.25,9.4>,
		<1002.55,574.25,4.35>
  }
  triangle { // #8906
		<1002.55,574.25,9.4>,
		<1002.55,-99,4.35>,
		<1002.55,-99,9.4>
  }
  triangle { // #8907
		<1001,-99,4.35>,
		<1002.55,574.25,4.35>,
		<1001,574.25,4.35>
  }
  triangle { // #8908
		<1002.55,574.25,4.35>,
		<1001,-99,4.35>,
		<1002.55,-99,4.35>
  }
  triangle { // #8909
		<1001,-99,0.8>,
		<1001,574.25,4.35>,
		<1001,574.25,0.8>
  }
  triangle { // #8910
		<1001,574.25,4.35>,
		<1001,-99,0.8>,
		<1001,-99,4.35>
  }
  triangle { // #8911
		<1002.55,-99,0.8>,
		<1001,574.25,0.8>,
		<1002.55,574.25,0.8>
  }
  triangle { // #8912
		<1001,574.25,0.8>,
		<1002.55,-99,0.8>,
		<1001,-99,0.8>
  }
  triangle { // #8913
		<1009.8,-98.4,-2.6>,
		<1831.75,-99,-2.6>,
		<1009.8,-99,-2.6>
  }
  triangle { // #8914
		<1831.75,-99,-2.6>,
		<1002.55,574.25,-2.6>,
		<1831.75,574.25,-2.6>
  }
  triangle { // #8915
		<1002.55,574.25,-2.6>,
		<1009.8,-98.4,-2.6>,
		<1002.55,-98.4,-2.6>
  }
  triangle { // #8916
		<1831.75,-99,-2.6>,
		<1009.8,-98.4,-2.6>,
		<1002.55,574.25,-2.6>
  }
  triangle { // #8917
		<1831.75,-99,-64.85>,
		<1831.75,574.25,-2.6>,
		<1831.75,574.25,-64.85>
  }
  triangle { // #8918
		<1831.75,574.25,-2.6>,
		<1831.75,-99,-64.85>,
		<1831.75,-99,-2.6>
  }
  triangle { // #8919
		<1840.1,-99,-64.85>,
		<1831.75,574.25,-64.85>,
		<1840.1,574.25,-64.85>
  }
  triangle { // #8920
		<1831.75,574.25,-64.85>,
		<1840.1,-99,-64.85>,
		<1831.75,-99,-64.85>
  }
  triangle { // #8921
		<1840.1,-99,-72.4>,
		<1840.1,574.25,-64.85>,
		<1840.1,574.25,-72.4>
  }
  triangle { // #8922
		<1840.1,574.25,-64.85>,
		<1840.1,-99,-72.4>,
		<1840.1,-99,-64.85>
  }
  triangle { // #8923
		<1843.85,-99,-72.4>,
		<1840.1,574.25,-72.4>,
		<1843.85,574.25,-72.4>
  }
  triangle { // #8924
		<1840.1,574.25,-72.4>,
		<1843.85,-99,-72.4>,
		<1840.1,-99,-72.4>
  }
  triangle { // #8925
		<1843.85,-99,-64.85>,
		<1843.85,574.25,-72.4>,
		<1843.85,574.25,-64.85>
  }
  triangle { // #8926
		<1843.85,574.25,-72.4>,
		<1843.85,-99,-64.85>,
		<1843.85,-99,-72.4>
  }
  smooth_triangle { // #8927
		<1850.75,-99,-64.85>, <0.199,0.98,0>,
		<1843.85,574.25,-64.85>, <0,1,0>,
		<1850.75,574.25,-64.85>, <0.399,0.917,0>
  }
  smooth_triangle { // #8928
		<1843.85,574.25,-64.85>, <0,1,0>,
		<1850.75,-99,-64.85>, <0.199,0.98,0>,
		<1843.85,-99,-64.85>, <0,1,0>
  }
  smooth_triangle { // #8929
		<1857.05,-99,-60.45>, <0.399,0.917,0>,
		<1850.75,574.25,-64.85>, <0.399,0.917,0>,
		<1857.05,574.25,-60.45>, <0.199,0.98,0>
  }
  smooth_triangle { // #8930
		<1850.75,574.25,-64.85>, <0.399,0.917,0>,
		<1857.05,-99,-60.45>, <0.399,0.917,0>,
		<1850.75,-99,-64.85>, <0.199,0.98,0>
  }
  smooth_triangle { // #8931
		<1861.95,-99,-60.45>, <0,1,0>,
		<1857.05,574.25,-60.45>, <0.199,0.98,0>,
		<1861.95,574.25,-60.45>, <0,1,0>
  }
  smooth_triangle { // #8932
		<1857.05,574.25,-60.45>, <0.199,0.98,0>,
		<1861.95,-99,-60.45>, <0,1,0>,
		<1857.05,-99,-60.45>, <0.399,0.917,0>
  }
  triangle { // #8933
		<1861.95,574.25,28.3>,
		<1861.95,-99,-60.45>,
		<1861.95,574.25,-60.45>
  }
  triangle { // #8934
		<1861.95,-99,-60.45>,
		<1861.95,574.25,28.3>,
		<1861.95,-99,28.3>
  }
  triangle { // #8935
		<1134.95,-99,28.3>,
		<1861.95,574.25,28.3>,
		<1134.95,574.25,28.3>
  }
  triangle { // #8936
		<1861.95,574.25,28.3>,
		<1134.95,-99,28.3>,
		<1861.95,-99,28.3>
  }
  triangle { // #8937
		<1009.8,-98.4,-5.05>,
		<1009.8,-99,-2.6>,
		<1009.8,-99,-5.05>
  }
  triangle { // #8938
		<1009.8,-99,-2.6>,
		<1009.8,-98.4,-5.05>,
		<1009.8,-98.4,-2.6>
  }
  smooth_triangle { // #8939
		<1006.8,-98.4,-5.05>, <-0.129,0.992,0>,
		<1009.8,-99,-5.05>, <0,1,0>,
		<1006.8,-99,-5.05>, <-0.258,0.966,0>
  }
  smooth_triangle { // #8940
		<1009.8,-99,-5.05>, <0,1,0>,
		<1006.8,-98.4,-5.05>, <-0.129,0.992,0>,
		<1009.8,-98.4,-5.05>, <0,1,0>
  }
  smooth_triangle { // #8941
		<1003.25,-98.4,-3.6>, <-0.38,0.925,0>,
		<1006.8,-99,-5.05>, <-0.258,0.966,0>,
		<1003.25,-99,-3.6>, <-0.38,0.925,0>
  }
  smooth_triangle { // #8942
		<1006.8,-99,-5.05>, <-0.258,0.966,0>,
		<1003.25,-98.4,-3.6>, <-0.38,0.925,0>,
		<1006.8,-98.4,-5.05>, <-0.129,0.992,0>
  }
  smooth_triangle { // #8943
		<1002.55,-98.4,-3.6>, <0,1,0>,
		<1003.25,-99,-3.6>, <-0.129,0.992,0>,
		<1002.55,-99,-3.6>, <0,1,0>
  }
  smooth_triangle { // #8944
		<1003.25,-99,-3.6>, <-0.129,0.992,0>,
		<1002.55,-98.4,-3.6>, <0,1,0>,
		<1003.25,-98.4,-3.6>, <-0.258,0.966,0>
  }
  triangle { // #8945
		<1002.55,-99,-3.6>,
		<1002.55,-98.4,-2.6>,
		<1002.55,-98.4,-3.6>
  }
  triangle { // #8946
		<1002.55,574.25,-2.6>,
		<1002.55,-99,0.8>,
		<1002.55,574.25,0.8>
  }
  triangle { // #8947
		<1002.55,-98.4,-2.6>,
		<1002.55,-99,0.8>,
		<1002.55,574.25,-2.6>
  }
  triangle { // #8948
		<1002.55,-98.4,-2.6>,
		<1002.55,-99,-3.6>,
		<1002.55,-99,0.8>
  }
  triangle { // #8949
		<1006.8,-98.4,-5.05>,
		<1009.8,-98.4,-2.6>,
		<1009.8,-98.4,-5.05>
  }
  triangle { // #8950
		<1002.55,-98.4,-2.6>,
		<1003.25,-98.4,-3.6>,
		<1002.55,-98.4,-3.6>
  }
  triangle { // #8951
		<1009.8,-98.4,-2.6>,
		<1003.25,-98.4,-3.6>,
		<1002.55,-98.4,-2.6>
  }
  triangle { // #8952
		<1009.8,-98.4,-2.6>,
		<1006.8,-98.4,-5.05>,
		<1003.25,-98.4,-3.6>
  }
  triangle { // #8953
		<1843.85,574.25,-64.85>,
		<1857.05,574.25,-60.45>,
		<1850.75,574.25,-64.85>
  }
  triangle { // #8954
		<1001,574.25,4.35>,
		<1002.55,574.25,0.8>,
		<1001,574.25,0.8>
  }
  triangle { // #8955
		<1002.55,574.25,4.35>,
		<1002.55,574.25,0.8>,
		<1001,574.25,4.35>
  }
  triangle { // #8956
		<1840.1,574.25,-72.4>,
		<1843.85,574.25,-64.85>,
		<1843.85,574.25,-72.4>
  }
  triangle { // #8957
		<1840.1,574.25,-64.85>,
		<1843.85,574.25,-64.85>,
		<1840.1,574.25,-72.4>
  }
  triangle { // #8958
		<1009.8,574.25,9.4>,
		<1002.55,574.25,4.35>,
		<1002.55,574.25,9.4>
  }
  triangle { // #8959
		<1831.75,574.25,-2.6>,
		<1840.1,574.25,-64.85>,
		<1831.75,574.25,-64.85>
  }
  triangle { // #8960
		<1857.05,574.25,-60.45>,
		<1861.95,574.25,28.3>,
		<1861.95,574.25,-60.45>
  }
  triangle { // #8961
		<1134.95,574.25,262.45>,
		<1039.55,574.25,257.45>,
		<1039.55,574.25,262.45>
  }
  triangle { // #8962
		<1134.95,574.25,262.45>,
		<1043.95,574.25,232.45>,
		<1039.55,574.25,257.45>
  }
  triangle { // #8963
		<1134.95,574.25,262.45>,
		<1104.8,574.25,232.45>,
		<1043.95,574.25,232.45>
  }
  triangle { // #8964
		<1134.95,574.25,28.3>,
		<1104.8,574.25,232.45>,
		<1134.95,574.25,262.45>
  }
  triangle { // #8965
		<1134.95,574.25,28.3>,
		<1104.8,574.25,28.3>,
		<1104.8,574.25,232.45>
  }
  triangle { // #8966
		<1104.8,574.25,28.3>,
		<1009.8,574.25,9.4>,
		<1009.8,574.25,28.3>
  }
  triangle { // #8967
		<1002.55,574.25,0.8>,
		<1831.75,574.25,-2.6>,
		<1002.55,574.25,-2.6>
  }
  triangle { // #8968
		<1002.55,574.25,4.35>,
		<1831.75,574.25,-2.6>,
		<1002.55,574.25,0.8>
  }
  triangle { // #8969
		<1009.8,574.25,9.4>,
		<1831.75,574.25,-2.6>,
		<1002.55,574.25,4.35>
  }
  triangle { // #8970
		<1104.8,574.25,28.3>,
		<1831.75,574.25,-2.6>,
		<1009.8,574.25,9.4>
  }
  triangle { // #8971
		<1134.95,574.25,28.3>,
		<1831.75,574.25,-2.6>,
		<1104.8,574.25,28.3>
  }
  triangle { // #8972
		<1861.95,574.25,28.3>,
		<1831.75,574.25,-2.6>,
		<1134.95,574.25,28.3>
  }
  triangle { // #8973
		<1857.05,574.25,-60.45>,
		<1831.75,574.25,-2.6>,
		<1861.95,574.25,28.3>
  }
  triangle { // #8974
		<1857.05,574.25,-60.45>,
		<1840.1,574.25,-64.85>,
		<1831.75,574.25,-2.6>
  }
  triangle { // #8975
		<1857.05,574.25,-60.45>,
		<1843.85,574.25,-64.85>,
		<1840.1,574.25,-64.85>
  }
  triangle { // #8976
		<1009.8,-99,-2.6>,
		<1003.25,-99,-3.6>,
		<1006.8,-99,-5.05>
  }
  triangle { // #8977
		<1009.8,-99,-2.6>,
		<1006.8,-99,-5.05>,
		<1009.8,-99,-5.05>
  }
  triangle { // #8978
		<1001,-99,0.8>,
		<1002.55,-99,4.35>,
		<1001,-99,4.35>
  }
  triangle { // #8979
		<1002.55,-99,0.8>,
		<1002.55,-99,4.35>,
		<1001,-99,0.8>
  }
  triangle { // #8980
		<1003.25,-99,-3.6>,
		<1002.55,-99,0.8>,
		<1002.55,-99,-3.6>
  }
  triangle { // #8981
		<1843.85,-99,-72.4>,
		<1840.1,-99,-64.85>,
		<1840.1,-99,-72.4>
  }
  triangle { // #8982
		<1843.85,-99,-64.85>,
		<1840.1,-99,-64.85>,
		<1843.85,-99,-72.4>
  }
  triangle { // #8983
		<1002.55,-99,4.35>,
		<1009.8,-99,9.4>,
		<1002.55,-99,9.4>
  }
  triangle { // #8984
		<1840.1,-99,-64.85>,
		<1831.75,-99,-2.6>,
		<1831.75,-99,-64.85>
  }
  triangle { // #8985
		<1861.95,-99,28.3>,
		<1857.05,-99,-60.45>,
		<1861.95,-99,-60.45>
  }
  triangle { // #8986
		<1039.55,-99,257.45>,
		<1134.95,-99,262.45>,
		<1039.55,-99,262.45>
  }
  triangle { // #8987
		<1043.95,-99,232.45>,
		<1134.95,-99,262.45>,
		<1039.55,-99,257.45>
  }
  triangle { // #8988
		<1104.8,-99,232.45>,
		<1134.95,-99,262.45>,
		<1043.95,-99,232.45>
  }
  triangle { // #8989
		<1104.8,-99,232.45>,
		<1134.95,-99,28.3>,
		<1134.95,-99,262.45>
  }
  triangle { // #8990
		<1104.8,-99,28.3>,
		<1134.95,-99,28.3>,
		<1104.8,-99,232.45>
  }
  triangle { // #8991
		<1009.8,-99,9.4>,
		<1104.8,-99,28.3>,
		<1009.8,-99,28.3>
  }
  triangle { // #8992
		<1843.85,-99,-64.85>,
		<1831.75,-99,-2.6>,
		<1840.1,-99,-64.85>
  }
  triangle { // #8993
		<1850.75,-99,-64.85>,
		<1831.75,-99,-2.6>,
		<1843.85,-99,-64.85>
  }
  triangle { // #8994
		<1857.05,-99,-60.45>,
		<1831.75,-99,-2.6>,
		<1850.75,-99,-64.85>
  }
  triangle { // #8995
		<1861.95,-99,28.3>,
		<1831.75,-99,-2.6>,
		<1857.05,-99,-60.45>
  }
  triangle { // #8996
		<1134.95,-99,28.3>,
		<1831.75,-99,-2.6>,
		<1861.95,-99,28.3>
  }
  triangle { // #8997
		<1134.95,-99,28.3>,
		<1009.8,-99,-2.6>,
		<1831.75,-99,-2.6>
  }
  triangle { // #8998
		<1104.8,-99,28.3>,
		<1009.8,-99,-2.6>,
		<1134.95,-99,28.3>
  }
  triangle { // #8999
		<1009.8,-99,9.4>,
		<1009.8,-99,-2.6>,
		<1104.8,-99,28.3>
  }
  triangle { // #9000
		<1002.55,-99,4.35>,
		<1009.8,-99,-2.6>,
		<1009.8,-99,9.4>
  }
  triangle { // #9001
		<1002.55,-99,0.8>,
		<1009.8,-99,-2.6>,
		<1002.55,-99,4.35>
  }
  triangle { // #9002
		<1003.25,-99,-3.6>,
		<1009.8,-99,-2.6>,
		<1002.55,-99,0.8>
  }
  smooth_triangle { // #9003
		<1043.95,-99,232.45>, <-0.985,0.173,0>,
		<1039.55,574.25,257.45>, <-0.993,0.116,0>,
		<1043.95,574.25,232.45>, <-0.985,0.173,0>
  }
  smooth_triangle { // #9004
		<1039.55,574.25,257.45>, <-0.993,0.116,0>,
		<1043.95,-99,232.45>, <-0.985,0.173,0>,
		<1039.55,-99,257.45>, <-0.998,0.058,0>
  }
  triangle { // #9005
		<1043.95,132.5,254.35>,
		<1043.95,131.25,253.05>,
		<1043.95,136.25,254.35>
  }
  smooth_triangle { // #9006
		<1043.95,139.4,257.45>, <1,-0,0>,
		<1043.95,136.25,254.35>, <1,-0,0>,
		<1043.95,143.8,232.45>, <0.998,-0.07,0>
  }
  smooth_triangle { // #9007
		<1043.95,143.8,228.7>, <1,0,0>,
		<1043.95,143.8,232.45>, <0.999,-0.05,0>,
		<1043.95,141.3,228.7>, <1,0,0>
  }
  triangle { // #9008
		<1043.95,129.95,236.2>,
		<1043.95,131.25,236.2>,
		<1043.95,129.95,245.55>
  }
  triangle { // #9009
		<1043.95,129.95,245.55>,
		<1043.95,131.25,236.2>,
		<1043.95,131.25,245.55>
  }
  smooth_triangle { // #9010
		<1043.95,141.3,228.7>, <1,0,0>,
		<1043.95,143.8,232.45>, <0.999,-0.05,0>,
		<1043.95,137.5,230.55>, <1,0,0>
  }
  smooth_triangle { // #9011
		<1043.95,143.8,232.45>, <0.998,-0.07,0>,
		<1043.95,136.25,254.35>, <1,-0,0>,
		<1043.95,137.5,230.55>, <1,0,0>
  }
  triangle { // #9012
		<1043.95,137.5,230.55>,
		<1043.95,136.25,254.35>,
		<1043.95,132.5,230.55>
  }
  triangle { // #9013
		<1043.95,132.5,230.55>,
		<1043.95,136.25,254.35>,
		<1043.95,131.25,231.8>
  }
  triangle { // #9014
		<1043.95,131.25,231.8>,
		<1043.95,136.25,254.35>,
		<1043.95,131.25,236.2>
  }
  triangle { // #9015
		<1043.95,131.25,236.2>,
		<1043.95,136.25,254.35>,
		<1043.95,131.25,245.55>
  }
  triangle { // #9016
		<1043.95,131.25,245.55>,
		<1043.95,136.25,254.35>,
		<1043.95,131.25,253.05>
  }
  triangle { // #9017
		<943.35,132.5,254.35>,
		<943.35,136.25,254.35>,
		<943.35,131.25,253.05>
  }
  smooth_triangle { // #9018
		<943.35,139.4,257.45>, <-1,0,0>,
		<943.35,143.8,232.45>, <-0.999,-0.035,0>,
		<943.35,136.25,254.35>, <-1,-0,0>
  }
  smooth_triangle { // #9019
		<943.35,143.8,228.7>, <-1,0,0>,
		<943.35,141.3,228.7>, <-1,0,0>,
		<943.35,143.8,232.45>, <-1,-0.025,0>
  }
  triangle { // #9020
		<943.35,129.95,245.55>,
		<943.35,131.25,245.55>,
		<943.35,129.95,236.2>
  }
  triangle { // #9021
		<943.35,129.95,236.2>,
		<943.35,131.25,245.55>,
		<943.35,131.25,236.2>
  }
  smooth_triangle { // #9022
		<943.35,141.3,228.7>, <-1,0,0>,
		<943.35,137.5,230.55>, <-1,0,0>,
		<943.35,143.8,232.45>, <-1,-0.025,0>
  }
  smooth_triangle { // #9023
		<943.35,143.8,232.45>, <-0.999,-0.035,0>,
		<943.35,137.5,230.55>, <-1,0,0>,
		<943.35,136.25,254.35>, <-1,-0,0>
  }
  triangle { // #9024
		<943.35,137.5,230.55>,
		<943.35,132.5,230.55>,
		<943.35,136.25,254.35>
  }
  triangle { // #9025
		<943.35,132.5,230.55>,
		<943.35,131.25,231.8>,
		<943.35,136.25,254.35>
  }
  triangle { // #9026
		<943.35,131.25,231.8>,
		<943.35,131.25,236.2>,
		<943.35,136.25,254.35>
  }
  triangle { // #9027
		<943.35,131.25,236.2>,
		<943.35,131.25,245.55>,
		<943.35,136.25,254.35>
  }
  triangle { // #9028
		<943.35,131.25,245.55>,
		<943.35,131.25,253.05>,
		<943.35,136.25,254.35>
  }
  smooth_triangle { // #9029
		<1043.95,143.8,232.45>, <0,-0.058,0.998>,
		<943.35,143.8,232.45>, <0,-0.116,0.993>,
		<1043.95,139.4,257.45>, <0,-0.173,0.985>
  }
  smooth_triangle { // #9030
		<943.35,139.4,257.45>, <0,-0.173,0.985>,
		<1043.95,139.4,257.45>, <0,-0.173,0.985>,
		<943.35,143.8,232.45>, <0,-0.116,0.993>
  }
  smooth_triangle { // #9031
		<1043.95,143.8,228.7>, <0,0,1>,
		<943.35,143.8,228.7>, <0,0,1>,
		<1043.95,143.8,232.45>, <0,-0.058,0.998>
  }
  smooth_triangle { // #9032
		<943.35,143.8,232.45>, <0,-0.116,0.993>,
		<1043.95,143.8,232.45>, <0,-0.058,0.998>,
		<943.35,143.8,228.7>, <0,0,1>
  }
  smooth_triangle { // #9033
		<1043.95,141.3,228.7>, <0,0.952,-0.305>,
		<943.35,141.3,228.7>, <0,0.988,-0.153>,
		<1043.95,143.8,228.7>, <0,1,0>
  }
  smooth_triangle { // #9034
		<943.35,143.8,228.7>, <0,1,0>,
		<1043.95,143.8,228.7>, <0,1,0>,
		<943.35,141.3,228.7>, <0,0.988,-0.153>
  }
  smooth_triangle { // #9035
		<1043.95,137.5,230.55>, <0,0.988,-0.153>,
		<943.35,137.5,230.55>, <0,0.952,-0.305>,
		<1043.95,141.3,228.7>, <0,0.952,-0.305>
  }
  smooth_triangle { // #9036
		<943.35,141.3,228.7>, <0,0.988,-0.153>,
		<1043.95,141.3,228.7>, <0,0.952,-0.305>,
		<943.35,137.5,230.55>, <0,0.952,-0.305>
  }
  smooth_triangle { // #9037
		<1043.95,132.5,230.55>, <0,1,0>,
		<943.35,132.5,230.55>, <0,1,0>,
		<1043.95,137.5,230.55>, <0,0.988,-0.153>
  }
  smooth_triangle { // #9038
		<943.35,137.5,230.55>, <0,0.952,-0.305>,
		<1043.95,137.5,230.55>, <0,0.988,-0.153>,
		<943.35,132.5,230.55>, <0,1,0>
  }
  smooth_triangle { // #9039
		<1043.95,131.25,231.8>, <0,0.253,-0.968>,
		<943.35,131.25,231.8>, <0,0.505,-0.863>,
		<1043.95,132.5,230.55>, <0,0.707,-0.707>
  }
  smooth_triangle { // #9040
		<943.35,132.5,230.55>, <0,0.707,-0.707>,
		<1043.95,132.5,230.55>, <0,0.707,-0.707>,
		<943.35,131.25,231.8>, <0,0.505,-0.863>
  }
  smooth_triangle { // #9041
		<1043.95,131.25,236.2>, <0,0,-1>,
		<943.35,131.25,236.2>, <0,0,-1>,
		<1043.95,131.25,231.8>, <0,0.253,-0.968>
  }
  smooth_triangle { // #9042
		<943.35,131.25,231.8>, <0,0.505,-0.863>,
		<1043.95,131.25,231.8>, <0,0.253,-0.968>,
		<943.35,131.25,236.2>, <0,0,-1>
  }
  triangle { // #9043
		<1043.95,129.95,236.2>,
		<943.35,129.95,236.2>,
		<1043.95,131.25,236.2>
  }
  triangle { // #9044
		<943.35,131.25,236.2>,
		<1043.95,131.25,236.2>,
		<943.35,129.95,236.2>
  }
  triangle { // #9045
		<1043.95,129.95,245.55>,
		<943.35,129.95,245.55>,
		<1043.95,129.95,236.2>
  }
  triangle { // #9046
		<943.35,129.95,236.2>,
		<1043.95,129.95,236.2>,
		<943.35,129.95,245.55>
  }
  triangle { // #9047
		<1043.95,131.25,245.55>,
		<943.35,131.25,245.55>,
		<1043.95,129.95,245.55>
  }
  triangle { // #9048
		<943.35,129.95,245.55>,
		<1043.95,129.95,245.55>,
		<943.35,131.25,245.55>
  }
  smooth_triangle { // #9049
		<1043.95,131.25,253.05>, <0,-0.383,-0.924>,
		<943.35,131.25,253.05>, <0,0,-1>,
		<1043.95,131.25,245.55>, <0,0,-1>
  }
  triangle { // #9050
		<943.35,131.25,245.55>,
		<1043.95,131.25,245.55>,
		<943.35,131.25,253.05>
  }
  smooth_triangle { // #9051
		<1043.95,132.5,254.35>, <0,-0.707,-0.707>,
		<943.35,132.5,254.35>, <0,-0.707,-0.707>,
		<1043.95,131.25,253.05>, <0,-0.505,-0.863>
  }
  smooth_triangle { // #9052
		<943.35,131.25,253.05>, <0,-0.707,-0.707>,
		<1043.95,131.25,253.05>, <0,-0.707,-0.707>,
		<943.35,132.5,254.35>, <0,-0.863,-0.505>
  }
  triangle { // #9053
		<1043.95,136.25,254.35>,
		<943.35,136.25,254.35>,
		<1043.95,132.5,254.35>
  }
  smooth_triangle { // #9054
		<943.35,132.5,254.35>, <0,-0.924,-0.383>,
		<1043.95,132.5,254.35>, <0,-1,0>,
		<943.35,136.25,254.35>, <0,-1,0>
  }
  triangle { // #9055
		<1043.95,139.4,257.45>,
		<943.35,139.4,257.45>,
		<1043.95,136.25,254.35>
  }
  triangle { // #9056
		<943.35,136.25,254.35>,
		<1043.95,136.25,254.35>,
		<943.35,139.4,257.45>
  }
  triangle { // #9057
		<-1756.55,0,-630.65>,
		<-1504.8,0,-622.3>,
		<-1756.55,0,-622.3>
  }
  triangle { // #9058
		<-1504.8,0,-622.3>,
		<-1756.55,0,-630.65>,
		<-1504.8,0,-630.65>
  }
  triangle { // #9059
		<-1756.55,308.65,-622.3>,
		<-1504.8,308.65,-630.65>,
		<-1756.55,308.65,-630.65>
  }
  triangle { // #9060
		<-1504.8,308.65,-630.65>,
		<-1756.55,308.65,-622.3>,
		<-1504.8,308.65,-622.3>
  }
  triangle { // #9061
		<-1756.55,0,-622.3>,
		<-1756.55,308.65,-630.65>,
		<-1756.55,0,-630.65>
  }
  triangle { // #9062
		<-1756.55,308.65,-630.65>,
		<-1756.55,0,-622.3>,
		<-1756.55,308.65,-622.3>
  }
  triangle { // #9063
		<-1756.55,0,-630.65>,
		<-1504.8,308.65,-630.65>,
		<-1504.8,0,-630.65>
  }
  triangle { // #9064
		<-1504.8,308.65,-630.65>,
		<-1756.55,0,-630.65>,
		<-1756.55,308.65,-630.65>
  }
  triangle { // #9065
		<-1504.8,0,-630.65>,
		<-1504.8,308.65,-622.3>,
		<-1504.8,0,-622.3>
  }
  triangle { // #9066
		<-1504.8,308.65,-622.3>,
		<-1504.8,0,-630.65>,
		<-1504.8,308.65,-630.65>
  }
  triangle { // #9067
		<-1504.8,0,-622.3>,
		<-1756.55,308.65,-622.3>,
		<-1756.55,0,-622.3>
  }
  triangle { // #9068
		<-1756.55,308.65,-622.3>,
		<-1504.8,0,-622.3>,
		<-1504.8,308.65,-622.3>
  }
  triangle { // #9069
		<1831.75,0,-316.7>,
		<1840.1,0,-64.85>,
		<1831.75,0,-64.85>
  }
  triangle { // #9070
		<1840.1,0,-64.85>,
		<1831.75,0,-316.7>,
		<1840.1,0,-316.7>
  }
  triangle { // #9071
		<1831.75,308.65,-64.85>,
		<1840.1,308.65,-316.7>,
		<1831.75,308.65,-316.7>
  }
  triangle { // #9072
		<1840.1,308.65,-316.7>,
		<1831.75,308.65,-64.85>,
		<1840.1,308.65,-64.85>
  }
  triangle { // #9073
		<1831.75,0,-64.85>,
		<1831.75,308.65,-316.7>,
		<1831.75,0,-316.7>
  }
  triangle { // #9074
		<1831.75,308.65,-316.7>,
		<1831.75,0,-64.85>,
		<1831.75,308.65,-64.85>
  }
  triangle { // #9075
		<1831.75,0,-316.7>,
		<1840.1,308.65,-316.7>,
		<1840.1,0,-316.7>
  }
  triangle { // #9076
		<1840.1,308.65,-316.7>,
		<1831.75,0,-316.7>,
		<1831.75,308.65,-316.7>
  }
  triangle { // #9077
		<1840.1,0,-316.7>,
		<1840.1,308.65,-64.85>,
		<1840.1,0,-64.85>
  }
  triangle { // #9078
		<1840.1,308.65,-64.85>,
		<1840.1,0,-316.7>,
		<1840.1,308.65,-316.7>
  }
  triangle { // #9079
		<1840.1,0,-64.85>,
		<1831.75,308.65,-64.85>,
		<1831.75,0,-64.85>
  }
  triangle { // #9080
		<1831.75,308.65,-64.85>,
		<1840.1,0,-64.85>,
		<1840.1,308.65,-64.85>
  }
  triangle { // #9081
		<-876.4,-79.5,350.5>,
		<-877.4,-79.5,344.35>,
		<-874.65,-79.5,351>
  }
  triangle { // #9082
		<-865.85,-79.5,354.25>,
		<-865.85,-79.5,352.7>,
		<-846.35,-79.5,354.25>
  }
  triangle { // #9083
		<-846.35,-79.5,354.25>,
		<-865.85,-79.5,352.7>,
		<-846.35,-79.5,352.7>
  }
  triangle { // #9084
		<-839.45,-79.5,339.5>,
		<-839.45,-79.5,342>,
		<-880.6,-79.5,339.5>
  }
  triangle { // #9085
		<-839.45,-79.5,342>,
		<-841.2,-79.5,352.45>,
		<-880.6,-79.5,339.5>
  }
  triangle { // #9086
		<-841.2,-79.5,352.45>,
		<-846.35,-79.5,352.7>,
		<-880.6,-79.5,339.5>
  }
  triangle { // #9087
		<-846.35,-79.5,352.7>,
		<-865.85,-79.5,352.7>,
		<-880.6,-79.5,339.5>
  }
  triangle { // #9088
		<-865.85,-79.5,352.7>,
		<-868.65,-79.5,352.7>,
		<-880.6,-79.5,339.5>
  }
  triangle { // #9089
		<-880.6,-79.5,344.05>,
		<-880.6,-79.5,339.5>,
		<-877.4,-79.5,344.35>
  }
  triangle { // #9090
		<-880.6,-79.5,339.5>,
		<-868.65,-79.5,352.7>,
		<-877.4,-79.5,344.35>
  }
  triangle { // #9091
		<-874.15,-79.5,352.45>,
		<-874.65,-79.5,351>,
		<-868.65,-79.5,352.7>
  }
  triangle { // #9092
		<-868.65,-79.5,352.7>,
		<-874.65,-79.5,351>,
		<-877.4,-79.5,344.35>
  }
  triangle { // #9093
		<-876.4,148.05,350.5>,
		<-874.65,148.05,351>,
		<-877.4,148.05,344.35>
  }
  triangle { // #9094
		<-846.35,148.05,354.25>,
		<-846.35,148.05,352.7>,
		<-865.85,148.05,354.25>
  }
  triangle { // #9095
		<-865.85,148.05,354.25>,
		<-846.35,148.05,352.7>,
		<-865.85,148.05,352.7>
  }
  triangle { // #9096
		<-839.45,148.05,339.5>,
		<-880.6,148.05,339.5>,
		<-839.45,148.05,342>
  }
  triang