//      Mod Switch Macros by [GDS|Entropy]
#version unofficial megapov 1.21;

#include "modSwitch.inc"

global_settings {
 assumed_gamma 1.0
 max_trace_level 100
}

#declare camMult = 40;

camera {
 location <-5, 6,-18>*camMult
 up y*image_height right x*image_width
 look_at < 0, 1.5, 0>*camMult
 angle 45	
} 

light_source {
 0*x
 color rgb <0.2734, 0.5078, 0.7031>  
 area_light
 <100, 0, 0> <0, 0, 100> 
 4, 4                
 adaptive 0          
 jitter              
 translate <0,1000,-2000>   
}

#declare IOR = 1.45;
#declare Fade_Distance = 2;
#declare Fade_Power = 3;

#declare InteriorX =
 interior {
  fade_distance Fade_Distance
  fade_power Fade_Power
  ior IOR
  caustics 1.0
 }

#declare FinishX =
 finish {
  diffuse 0.000001
  reflection 0.5
  specular 1
  brilliance 5
  metallic on
  ambient 0.5
  roughness 0.001  
 }

#declare FinishY =
 finish {
  diffuse 0.000001
  reflection 0.5
  specular 1
  brilliance 5
  metallic on  
 }
   
#macro testSphere(ctr,vect,diameter)
 sphere {
  vect,diameter
  texture {
   pigment {
    color rgb vect/(ctr+0.0001) // divide by zero fix
    filter 1
   }
   finish {
    FinishY
   }
  }
  interior {
   InteriorX
  }     
 }
#end

#macro testCylinder(ctr,vect0,vect1,diameter)
 cylinder {
  vect0,vect1,diameter
  texture {
   pigment {
    color rgb vect0/(ctr+0.0001) // divide by zero fix
    filter 1
   }
   finish {
    FinishX
   }
  }
  interior {
   InteriorX
  }
 }
#end 

#local RsA = seed(574647);

//      RRand Macro by Chris Huff
#macro RRand(RS, Min, Max) (rand(RS)*(Max-Min) + Min) #end 

#macro demoMod(ctr)
#declare demoModObject =                             
#local i = 0;
#while (i < ctr)
 #local diaRand = RRand(RsA, 5.125, 5.75);
  
 mod9Switch(i,
  testSphere(i,  <RRand(RsA, -i+1, i+1),i,RRand(RsA, -i+1, i+1)>,diaRand),
  testCylinder(i,<RRand(RsA, -i+1, i+1),-i,RRand(RsA, -i+1, i+1)>,<RRand(RsA, -i+1, i+1),i+0.1,RRand(RsA, -i+1, i+1)>,diaRand),
  testSphere(i,  <2,i,RRand(RsA, -i+1, i+1)>,diaRand),
  testCylinder(i,<2,-i,RRand(RsA, -i+1, i+1)>,<2,i+0.1,RRand(RsA, -i+1, i+1)>,diaRand),
  testSphere(i,  <-2,i,RRand(RsA, -i+1, i+1)>,diaRand),
  testCylinder(i,<RRand(RsA, -i+1, i+1),-i,2>,<RRand(RsA, -i+1, i+1),i+0.1,2>,diaRand),
  testSphere(i,  <RRand(RsA, -i+1, i+1),i,2>,diaRand),
  testCylinder(i,<2+RRand(RsA, -i+1, i+1),-i,2+RRand(RsA, -i+1, i+1)>,<2+RRand(RsA, -i+1, i+1),i+0.1,2+RRand(RsA, -i+1, i+1)>,diaRand),
  testSphere(i,  <RRand(RsA, -i+1, i+1),i,-2>,diaRand),
  testCylinder(i,<-2+RRand(RsA, -i+1, i+1),-i,-2+RRand(RsA, -i+1, i+1)>,<-2+RRand(RsA, -i+1, i+1),i+0.1,-2+RRand(RsA, -i+1, i+1)>,diaRand)
  )
 
#set i = i + 1;
#end     


object {
 demoModObject
}
#end

demoMod(200)