/*

 landScaper2.pov
 
 January 2009
 Samuel Benge
 
 +ft +f -a0.01 +am2 +r3
 
 Render with mode = 0 first, with +olandScaperOcc.tga.
 For final render, use mode = 2.
 
 lower "hfRes" and "nGrassClumps" for testing purposes
 
*/

// render modes
// 0 = proximity pattern pre-render
// 1 basic texture without grass
// 2 proximity-based texture with grass
// +olandScaperOcc.tga - command line setting for proximity pre-render
#declare mode = 2;

// height_field and grass variables
#declare hfRes = 1500/8;
#declare nGrassClumps = 20000/8;

// include files
#include"transforms.inc"
#declare file_proximity = "edge_pigment.inc";
#declare file_occlusion = "landScaperOcc.tga";
#declare file_illusion = "illusion.inc";
#declare file_grass = "blade1_POV_geom.inc";

#declare R=seed(0015);

#declare global_illumination = on;
global_settings{
 #if(global_illumination=1)
  radiosity{
   
   #switch(0)
   
    #case(0)
     count 25 error_bound .1
     pretrace_start .08 pretrace_end .02
     nearest_count 1
    #break
    
    #case(1)
     count 200 error_bound .1
     pretrace_start .08 pretrace_end .01
     nearest_count 2
    #break
    
    #case(2)
     count 500 error_bound .05
     pretrace_start .08 pretrace_end .01
     nearest_count 2
    #break
   
   #end
   
   recursion_limit 1
   normal on
   brightness 1
   gray_threshold 0
   
   adc_bailout 1/256
  }
 #end
 
 noise_generator 1
}

#default{ finish{ambient 0} }

// camera variables
#declare cPos = <0,30,-30>;
#declare cLook = <0,0,-4>;
#declare cAng = 35;
camera{ 
 location cPos
 look_at cLook
 angle cAng
}

// light variables
#declare lRes = 3;
#declare lpos = <1,.5,.75>;

// scene colors
#declare lcol = <1,.85,.75>*1.7;
#declare earthy = <.75,.5,.3>;
#declare air = <.1 .2 .5>;
#declare plant= <.05 .3 .05>;

light_source{lpos*100000,lcol area_light x*15000,z*15000,lRes,lRes adaptive 2 jitter orient circular}

sky_sphere{
 pigment{
  pigment_pattern{
   spherical scale 2 translate y
   Point_At_Trans(lpos)
   poly_wave 2
  }
  pigment_map{
   [0 rgb air]
   [.5
    bumps scale .2 turbulence .3
    color_map{
     [.3 rgb 0]
     [1 rgb(1+lcol)/8]
    }
   ]
   [1 rgb lcol]
  }
 }
}

// these two objects prevent light leakage
plane{y,-5}
box{<50,-1,-100>,<60,6,100>}

#declare obj=
height_field{
 function hfRes,hfRes{
  pigment{
   pigment_pattern{
    crackle
    metric 1
    rotate 33
    scale .3
    form<-.5,-.5,1>
   }
   pigment_map{
    [0 rgb 0]
    [.5
     pigment_pattern{
      crackle
      metric 1
      rotate 33
      scale .15
      form<-.5,-.5,1>
      poly_wave .5
     }
     pigment_map{
      [0 rgb .25]
      [1
       granite scale .15
       cubic_wave
       color_map{[0 rgb .8][1 rgb .7]}
      ]
     }
    ]
    [1 rgb 1]
   }
  }
 }
 translate-(x+z)/2
 scale<35,6,35>
 pigment{rgb 1}
}

object{obj
 #switch(mode)
 
  #case(0)
   #include file_proximity
   pigment{edge_pigment(obj,.75,.75,1)}
   finish{ambient 1 diffuse 0}
  #break
 
  #case(1)
   pigment{rgb 1}
  #break
  
  #case(2)
   #declare illusion_angle = cAng;
   #declare illusion_image = file_occlusion;
   #declare illusion_location = cPos;
   #declare illusion_look_at = cLook;
   #declare illusion_right=x*1.33;
   #declare illusion_up=y;
   #include file_illusion
   #declare p1=illusion;
   #declare p=
   pigment{
    pigment_pattern{
     pigment_pattern{p1}
     poly_wave 4
    }
    pigment_map{
     [.2 rgb plant/2]
     [.5
      crackle
      solid
      scale .05
      frequency 12
      color_map{[.5 rgb earthy/2][1 rgb 1]}
     ]
     [.7 
      crackle
      solid
      rotate 33
      scale .05
      frequency 12
      color_map{[0 rgb .05][.5 rgb earthy][1 rgb 1]}
     ]
    }
   }
   
   pigment{p}
   
   normal{
    pigment_pattern{p} 1.5
    accuracy .001
    normal_map{
     [0 granite .25 scale<10,.25,10> no_bump_scale]
     [1 granite .25 scale<10,.25,10> rotate 75 no_bump_scale]
    }
   }
   finish{brilliance .5}
  #break
  
 #end
}

#if(mode=2)

 #include file_grass

 #declare bunch=
 union{
  object{
   blade1_Default_ scale .1 double_illuminate
   pigment {rgb <0.17,0.44,0.12>}
   scale 1*<1,4,1>
  }
  sphere{-y*.1,.1
   pigment{
    granite scale .3
    color_map{
     [0 rgb(.15+earthy)/7]
     [1 rgb(.15+earthy)/1.5]
    }
   }
  }
 }

 #declare pf=function{pigment{p1}};
 
 // place grass
 union{
  #declare V=0;
  #while(V<nGrassClumps)
   #declare norm=<0,0,0>;
    #declare tv=
    trace(
     obj,
     <(-1+rand(R)*2)*35/2, 10, (-1+rand(R)*2)*35/2>,
     -y,norm
    );
   #declare tvx=tv.x;
   #declare tvy=tv.y;
   #declare tvz=tv.z;
   #declare pf2=pf(tvx,tvy,tvz).gray;
   #if(pf2.x<.7)
    object{bunch 
     scale 1+rand(R)*(1+rand(R)*1.5)
     rotate y*rand(R)*360
     translate tv
    }
   #end
   #declare V=V+1;
  #end
  pigment{granite color_map{[0 rgb 0][1 rgb earthy]}}
  normal{granite 1 scale .1 accuracy .001}
 }

#end
